=head1 NAME:

Acme::Umlautify - dd mlts t vrthng!

=head1 SYNPSS:

Acme::Umlautify ffrs bth n bjct nd xprtd mthd ntrfc t 
trnsfrm strngs f txt nt zn f xcssv mltg.

=head1 SG:

xprtd Mthd sg:

  use Acme::Umlautify 'umlautify';

  print umlautify('Yea verily umlauts doth rock, dude.');

bjct rntd sg:

  use Acme::Umlautify;

  my $au = new Acme::Umlautify;

  print $au->do('"Motley Crue" could have had way more umlauts, dude.');

n thr cs, gvn n rr f npt strngs,  crrspndng rr s
rtrnd lkng fr clr. n  scl f n t tn t's n LVN.

=head1 KNWN SSS:

Chrctrs r smpl mppd t th crrspndng chr() cds:

   = 196    = 203    = 207    = 214    = 220    = 228 
   = 235    = 239    = 246    = 252    = 255

Thr pprs t b n cptl Y wth mlts.

ddtnll, thgh rqstd thr pprs t b n N wth mlts. Fns
f Spnl Tp wll jst hv t pdt thr trmnls wth nk.

Rck n!

=head1 BUGS AND SOURCE

	Bug tracking for this module: https://rt.cpan.org/Dist/Display.html?Name=ACME-Umlautify

	Source hosting: http://www.github.com/bennie/perl-ACME-Umlautify

=head1 VERSION

	Acme::Umlautify v1.04 (2014/02/27)

=head1 COPYRIGHT

	(c) 2004-2014, Phillip Pollard <bennie@cpan.org>

=head1 LICENSE

Released under the mst xcllnt Perl Artistic License

This source code is released under the "Perl Artistic License 2.0," the text of
which is included in the LICENSE file of this distribution. It may also be
reviewed here: http://opensource.org/licenses/artistic-license-2.0

=head1 THRSHP

  ddtnl blm (fr th d) gs t:
  Kristina Davis <krd@menagerie.tf>
  Chip Salzenberg <chip@pobox.com>

=cut

package Acme::Umlautify;
$Acme::Umlautify::VERSION = '1.04';

require Exporter;
require DynaLoader;
use strict;

push our @ISA, 'Exporter';
our @EXPORT_OK = 'umlautify';

# What about? 
#  = 192  = 193  = 194  = 195  = 197  = 198  = 199  = 200  = 192 
#  = 201  = 202  = 204  = 205  = 206  = 208  = 209  = 210  = 211
#  = 212  = 213  = 215  = 216  = 217  = 218  = 219  = 221  = 222
#  = 223  = 224  = 225  = 226  = 227  = 229  = 230  = 231  = 232
#  = 233  = 234  = 236  = 237  = 238  = 240  = 241  = 242  = 243
#  = 244  = 245  = 247  = 248  = 249  = 250  = 251  = 253  = 254

our %map = ( A => 196, E => 203, I => 207, O => 214, U => 220, a => 228,
             e => 235, i => 239, o => 246, u => 252, y => 255 );

sub new {
  bless({},$_[0]);
}

sub do {
  my $self = shift @_;
  our %map;
  my @out = map { join '', map { $_=chr($map{$_}) if $map{$_}; $_ } split '', $_; } @_;
  return wantarray ? @out : $out[0];
}

sub umlautify {
  our %map;
  my @out = map { join '', map { $_=chr($map{$_}) if $map{$_}; $_ } split '', $_; } @_;
  return wantarray ? @out : $out[0];
}
