package Acme::Excuse;

use strict;
use warnings;

our $VERSION = '1.001001'; # VERSION

BEGIN {
    use Mojo::UserAgent;

    # need this to coax Mojo::Reactor::EV to behave during compile time deaths
    use Mojo::Util qw/encode/;
    encode 'UTF-8', '42';

    $SIG{__DIE__} = sub {
        print Mojo::UserAgent->new
                ->get("http://www.programmerexcuses.com/")
                ->res->dom->at(".wrapper a")->text
            . "\n";

        exit
    };
}

q|
    Hardware (noun.): the part of a computer that you can kick.
|;

__END__

=encoding utf8

=for stopwords Znet Zoffix

=head1 NAME

Acme::Excuse - give excuses when your code fails

=head1 SYNOPSIS

=for html  <div style="display: table; height: 91px; background: url(http://zoffix.com/CPAN/Dist-Zilla-Plugin-Pod-Spiffy/icons/section-code.png) no-repeat left; padding-left: 120px;" ><div style="display: table-cell; vertical-align: middle;">

    $ perl -MAcme::Excuse -e 'oops a compile error!'
    Somebody must have changed my code
    $

=for html  </div></div>

=for html  <div style="display: table; height: 91px; background: url(http://zoffix.com/CPAN/Dist-Zilla-Plugin-Pod-Spiffy/icons/section-code.png) no-repeat left; padding-left: 120px;" ><div style="display: table-cell; vertical-align: middle;">

    use Acme::Excuse;

    open my $fh, '<', 'non-existent' or die $!;
    # dies with an excuse, e.g.
    # "We didn't have enough time to peer review the final changes"

=for html  </div></div>

=head1 DESCRIPTION

When your code fails, consult L<http://www.programmerexcuses.com/> and
give the correct excuse.

=head1 METHODS

None.

=head1 SEE ALSO

L<http://www.programmerexcuses.com/>

=for html <div style="background: url(http://zoffix.com/CPAN/Dist-Zilla-Plugin-Pod-Spiffy/icons/hr.png);height: 18px;"></div>

=head1 REPOSITORY

=for html  <div style="display: table; height: 91px; background: url(http://zoffix.com/CPAN/Dist-Zilla-Plugin-Pod-Spiffy/icons/section-github.png) no-repeat left; padding-left: 120px;" ><div style="display: table-cell; vertical-align: middle;">

Fork this module on GitHub:
L<https://github.com/zoffixznet/Acme-Excuse>

=for html  </div></div>

=head1 BUGS

=for html  <div style="display: table; height: 91px; background: url(http://zoffix.com/CPAN/Dist-Zilla-Plugin-Pod-Spiffy/icons/section-bugs.png) no-repeat left; padding-left: 120px;" ><div style="display: table-cell; vertical-align: middle;">

To report bugs or request features, please use
L<https://github.com/zoffixznet/Acme-Excuse/issues>

If you can't access GitHub, you can email your request
to C<bug-Acme-Excuse at rt.cpan.org>

=for html  </div></div>

=head1 AUTHOR

=for html  <div style="display: table; height: 91px; background: url(http://zoffix.com/CPAN/Dist-Zilla-Plugin-Pod-Spiffy/icons/section-author.png) no-repeat left; padding-left: 120px;" ><div style="display: table-cell; vertical-align: middle;">

=for html   <span style="display: inline-block; text-align: center;"> <a href="http://metacpan.org/author/ZOFFIX"> <img src="http://www.gravatar.com/avatar/328e658ab6b08dfb5c106266a4a5d065?d=http%3A%2F%2Fwww.gravatar.com%2Favatar%2F627d83ef9879f31bdabf448e666a32d5" alt="ZOFFIX" style="display: block; margin: 0 3px 5px 0!important; border: 1px solid #666; border-radius: 3px; "> <span style="color: #333; font-weight: bold;">ZOFFIX</span> </a> </span>

=for html  </div></div>

=head1 LICENSE

You can use and distribute this module under the same terms as Perl itself.
See the C<LICENSE> file included in this distribution for complete
details.

=cut