package NKTI::general::connection::sqlite;

use strict;
use warnings;
use JSON;
use DBI;

# Define Version :
# ----------------------------------------------------------------
our $VERSION = '0.05';

# Create Module for connection SQLite :
# ------------------------------------------------------------------------
=head1 MODULE connect()

    Parameter Subroutine :
    ----------------------------------------
    $fieloc_db      =>  [ Berisi Lokasi file Database ]

=cut
sub connect {
    
    # Define parameter module :
    # ----------------------------------------------------------------
    my ($self, $fileloc_db) = @_;
    
    # Define parameter for SQL list
    # ----------------------------------------------------------------
    my $driver = "SQLite";
    my $dsn = "DBI:$driver:dbname=$fileloc_db";
    my $userid = "";
    my $password = "";
    my $dbh = DBI->connect($dsn, $userid, $password, { RaiseError => 1 })
        or die $DBI::errstr;
        
    # Return Result :
    # ----------------------------------------------------------------
    return $dbh;
}
# End of Create Module for connection SQLite
# ===========================================================================================================

1;
__END__
=head1 AUTHOR
    Achmad Yusri Afandi, (linuxer08@gmail.com)

=head1 COPYRIGHT AND LICENSE
    Copyright (c) 2016, Achmad Yusri Afandi, All Rights reserved.

    Pustaka yang berfungsi untuk melakukan koneksi database SQLite.
=cut