package main;

use 5.006002;

use strict;
use warnings;

use DateTime;
use DateTime::Fiction::JRRTolkien::Shire;
use Test::More 0.47;	# The best we can do with 5.6.2.
use Time::Local;

plan tests => 70128;

print <<'EOT';
# Created Wed Feb  8 05:16:06 2017 UT
# using Date::Tolkien::Shire 0.02_01
EOT

my ( $dts, $epoch );

$epoch = timegm( 0, 0, 0, 1, 1 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 1,
	day	=> 1,
    ),
);
cmp_ok( $dts->day(), '==', 9, 'day() on 1999-01-01 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Monday', 'day_name() on 1999-01-01 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Monendei', 'day_name_trad() on 1999-01-01 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 9, 'day_of_month() on 1999-01-01 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 3, 'day_of_week() on 1999-01-01 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 10, 'day_of_year() on 1999-01-01 Gregorian' );
cmp_ok( $dts->dow(), '==', 3, 'dow() on 1999-01-01 Gregorian' );
cmp_ok( $dts->doy(), '==', 10, 'doy() on 1999-01-01 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-01-01 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-01-01 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-01-01 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-01-01 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-01-01 Gregorian' );
cmp_ok( $dts->mday(), '==', 9, 'mday() on 1999-01-01 Gregorian' );
cmp_ok( $dts->month(), '==', 1, 'month() on 1999-01-01 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afteryule', 'month_name() on 1999-01-01 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-01-01 Gregorian' );
Monday 9 Afteryule 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63050832000, 'utc_rd_as_seconds() on 1999-01-01 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729755,
  0,
  0
]
, 'utc_rd_values() on 1999-01-01 Gregorian' );
cmp_ok( $dts->wday(), '==', 3, 'wday() on 1999-01-01 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  2
]
, 'week() on 1999-01-01 Gregorian' );
cmp_ok( $dts->week_number(), '==', 2, 'week_number() on 1999-01-01 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-01-01 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-01-01 Gregorian' );

$epoch = timegm( 0, 0, 0, 2, 1 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 1,
	day	=> 2,
    ),
);
cmp_ok( $dts->day(), '==', 10, 'day() on 1999-01-02 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Trewsday', 'day_name() on 1999-01-02 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Trewesdei', 'day_name_trad() on 1999-01-02 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 10, 'day_of_month() on 1999-01-02 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 4, 'day_of_week() on 1999-01-02 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 11, 'day_of_year() on 1999-01-02 Gregorian' );
cmp_ok( $dts->dow(), '==', 4, 'dow() on 1999-01-02 Gregorian' );
cmp_ok( $dts->doy(), '==', 11, 'doy() on 1999-01-02 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-01-02 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-01-02 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-01-02 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-01-02 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-01-02 Gregorian' );
cmp_ok( $dts->mday(), '==', 10, 'mday() on 1999-01-02 Gregorian' );
cmp_ok( $dts->month(), '==', 1, 'month() on 1999-01-02 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afteryule', 'month_name() on 1999-01-02 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-01-02 Gregorian' );
Trewsday 10 Afteryule 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63050918400, 'utc_rd_as_seconds() on 1999-01-02 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729756,
  0,
  0
]
, 'utc_rd_values() on 1999-01-02 Gregorian' );
cmp_ok( $dts->wday(), '==', 4, 'wday() on 1999-01-02 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  2
]
, 'week() on 1999-01-02 Gregorian' );
cmp_ok( $dts->week_number(), '==', 2, 'week_number() on 1999-01-02 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-01-02 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-01-02 Gregorian' );

$epoch = timegm( 0, 0, 0, 3, 1 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 1,
	day	=> 3,
    ),
);
cmp_ok( $dts->day(), '==', 11, 'day() on 1999-01-03 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Hevensday', 'day_name() on 1999-01-03 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Hevenesdei', 'day_name_trad() on 1999-01-03 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 11, 'day_of_month() on 1999-01-03 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 5, 'day_of_week() on 1999-01-03 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 12, 'day_of_year() on 1999-01-03 Gregorian' );
cmp_ok( $dts->dow(), '==', 5, 'dow() on 1999-01-03 Gregorian' );
cmp_ok( $dts->doy(), '==', 12, 'doy() on 1999-01-03 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-01-03 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-01-03 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-01-03 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-01-03 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-01-03 Gregorian' );
cmp_ok( $dts->mday(), '==', 11, 'mday() on 1999-01-03 Gregorian' );
cmp_ok( $dts->month(), '==', 1, 'month() on 1999-01-03 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afteryule', 'month_name() on 1999-01-03 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-01-03 Gregorian' );
Hevensday 11 Afteryule 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63051004800, 'utc_rd_as_seconds() on 1999-01-03 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729757,
  0,
  0
]
, 'utc_rd_values() on 1999-01-03 Gregorian' );
cmp_ok( $dts->wday(), '==', 5, 'wday() on 1999-01-03 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  2
]
, 'week() on 1999-01-03 Gregorian' );
cmp_ok( $dts->week_number(), '==', 2, 'week_number() on 1999-01-03 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-01-03 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-01-03 Gregorian' );

$epoch = timegm( 0, 0, 0, 4, 1 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 1,
	day	=> 4,
    ),
);
cmp_ok( $dts->day(), '==', 12, 'day() on 1999-01-04 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Mersday', 'day_name() on 1999-01-04 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Meresdei', 'day_name_trad() on 1999-01-04 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 12, 'day_of_month() on 1999-01-04 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 6, 'day_of_week() on 1999-01-04 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 13, 'day_of_year() on 1999-01-04 Gregorian' );
cmp_ok( $dts->dow(), '==', 6, 'dow() on 1999-01-04 Gregorian' );
cmp_ok( $dts->doy(), '==', 13, 'doy() on 1999-01-04 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-01-04 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-01-04 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-01-04 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-01-04 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-01-04 Gregorian' );
cmp_ok( $dts->mday(), '==', 12, 'mday() on 1999-01-04 Gregorian' );
cmp_ok( $dts->month(), '==', 1, 'month() on 1999-01-04 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afteryule', 'month_name() on 1999-01-04 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-01-04 Gregorian' );
Mersday 12 Afteryule 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63051091200, 'utc_rd_as_seconds() on 1999-01-04 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729758,
  0,
  0
]
, 'utc_rd_values() on 1999-01-04 Gregorian' );
cmp_ok( $dts->wday(), '==', 6, 'wday() on 1999-01-04 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  2
]
, 'week() on 1999-01-04 Gregorian' );
cmp_ok( $dts->week_number(), '==', 2, 'week_number() on 1999-01-04 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-01-04 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-01-04 Gregorian' );

$epoch = timegm( 0, 0, 0, 5, 1 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 1,
	day	=> 5,
    ),
);
cmp_ok( $dts->day(), '==', 13, 'day() on 1999-01-05 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Highday', 'day_name() on 1999-01-05 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Highdei', 'day_name_trad() on 1999-01-05 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 13, 'day_of_month() on 1999-01-05 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 7, 'day_of_week() on 1999-01-05 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 14, 'day_of_year() on 1999-01-05 Gregorian' );
cmp_ok( $dts->dow(), '==', 7, 'dow() on 1999-01-05 Gregorian' );
cmp_ok( $dts->doy(), '==', 14, 'doy() on 1999-01-05 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-01-05 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-01-05 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-01-05 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-01-05 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-01-05 Gregorian' );
cmp_ok( $dts->mday(), '==', 13, 'mday() on 1999-01-05 Gregorian' );
cmp_ok( $dts->month(), '==', 1, 'month() on 1999-01-05 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afteryule', 'month_name() on 1999-01-05 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-01-05 Gregorian' );
Highday 13 Afteryule 7463

The Company of the Ring reaches the West-gate of Moria at nightfall, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63051177600, 'utc_rd_as_seconds() on 1999-01-05 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729759,
  0,
  0
]
, 'utc_rd_values() on 1999-01-05 Gregorian' );
cmp_ok( $dts->wday(), '==', 7, 'wday() on 1999-01-05 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  2
]
, 'week() on 1999-01-05 Gregorian' );
cmp_ok( $dts->week_number(), '==', 2, 'week_number() on 1999-01-05 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-01-05 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-01-05 Gregorian' );

$epoch = timegm( 0, 0, 0, 6, 1 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 1,
	day	=> 6,
    ),
);
cmp_ok( $dts->day(), '==', 14, 'day() on 1999-01-06 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sterday', 'day_name() on 1999-01-06 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sterrendei', 'day_name_trad() on 1999-01-06 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 14, 'day_of_month() on 1999-01-06 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 1, 'day_of_week() on 1999-01-06 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 15, 'day_of_year() on 1999-01-06 Gregorian' );
cmp_ok( $dts->dow(), '==', 1, 'dow() on 1999-01-06 Gregorian' );
cmp_ok( $dts->doy(), '==', 15, 'doy() on 1999-01-06 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-01-06 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-01-06 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-01-06 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-01-06 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-01-06 Gregorian' );
cmp_ok( $dts->mday(), '==', 14, 'mday() on 1999-01-06 Gregorian' );
cmp_ok( $dts->month(), '==', 1, 'month() on 1999-01-06 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afteryule', 'month_name() on 1999-01-06 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-01-06 Gregorian' );
Sterday 14 Afteryule 7463

The Company of the Ring spends the night in Moria hall 21, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63051264000, 'utc_rd_as_seconds() on 1999-01-06 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729760,
  0,
  0
]
, 'utc_rd_values() on 1999-01-06 Gregorian' );
cmp_ok( $dts->wday(), '==', 1, 'wday() on 1999-01-06 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  3
]
, 'week() on 1999-01-06 Gregorian' );
cmp_ok( $dts->week_number(), '==', 3, 'week_number() on 1999-01-06 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-01-06 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-01-06 Gregorian' );

$epoch = timegm( 0, 0, 0, 7, 1 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 1,
	day	=> 7,
    ),
);
cmp_ok( $dts->day(), '==', 15, 'day() on 1999-01-07 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sunday', 'day_name() on 1999-01-07 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sunnendei', 'day_name_trad() on 1999-01-07 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 15, 'day_of_month() on 1999-01-07 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 2, 'day_of_week() on 1999-01-07 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 16, 'day_of_year() on 1999-01-07 Gregorian' );
cmp_ok( $dts->dow(), '==', 2, 'dow() on 1999-01-07 Gregorian' );
cmp_ok( $dts->doy(), '==', 16, 'doy() on 1999-01-07 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-01-07 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-01-07 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-01-07 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-01-07 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-01-07 Gregorian' );
cmp_ok( $dts->mday(), '==', 15, 'mday() on 1999-01-07 Gregorian' );
cmp_ok( $dts->month(), '==', 1, 'month() on 1999-01-07 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afteryule', 'month_name() on 1999-01-07 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-01-07 Gregorian' );
Sunday 15 Afteryule 7463

The Bridge of Khazad-dum, and the fall of Gandalf, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63051350400, 'utc_rd_as_seconds() on 1999-01-07 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729761,
  0,
  0
]
, 'utc_rd_values() on 1999-01-07 Gregorian' );
cmp_ok( $dts->wday(), '==', 2, 'wday() on 1999-01-07 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  3
]
, 'week() on 1999-01-07 Gregorian' );
cmp_ok( $dts->week_number(), '==', 3, 'week_number() on 1999-01-07 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-01-07 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-01-07 Gregorian' );

$epoch = timegm( 0, 0, 0, 8, 1 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 1,
	day	=> 8,
    ),
);
cmp_ok( $dts->day(), '==', 16, 'day() on 1999-01-08 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Monday', 'day_name() on 1999-01-08 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Monendei', 'day_name_trad() on 1999-01-08 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 16, 'day_of_month() on 1999-01-08 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 3, 'day_of_week() on 1999-01-08 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 17, 'day_of_year() on 1999-01-08 Gregorian' );
cmp_ok( $dts->dow(), '==', 3, 'dow() on 1999-01-08 Gregorian' );
cmp_ok( $dts->doy(), '==', 17, 'doy() on 1999-01-08 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-01-08 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-01-08 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-01-08 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-01-08 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-01-08 Gregorian' );
cmp_ok( $dts->mday(), '==', 16, 'mday() on 1999-01-08 Gregorian' );
cmp_ok( $dts->month(), '==', 1, 'month() on 1999-01-08 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afteryule', 'month_name() on 1999-01-08 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-01-08 Gregorian' );
Monday 16 Afteryule 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63051436800, 'utc_rd_as_seconds() on 1999-01-08 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729762,
  0,
  0
]
, 'utc_rd_values() on 1999-01-08 Gregorian' );
cmp_ok( $dts->wday(), '==', 3, 'wday() on 1999-01-08 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  3
]
, 'week() on 1999-01-08 Gregorian' );
cmp_ok( $dts->week_number(), '==', 3, 'week_number() on 1999-01-08 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-01-08 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-01-08 Gregorian' );

$epoch = timegm( 0, 0, 0, 9, 1 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 1,
	day	=> 9,
    ),
);
cmp_ok( $dts->day(), '==', 17, 'day() on 1999-01-09 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Trewsday', 'day_name() on 1999-01-09 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Trewesdei', 'day_name_trad() on 1999-01-09 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 17, 'day_of_month() on 1999-01-09 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 4, 'day_of_week() on 1999-01-09 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 18, 'day_of_year() on 1999-01-09 Gregorian' );
cmp_ok( $dts->dow(), '==', 4, 'dow() on 1999-01-09 Gregorian' );
cmp_ok( $dts->doy(), '==', 18, 'doy() on 1999-01-09 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-01-09 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-01-09 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-01-09 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-01-09 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-01-09 Gregorian' );
cmp_ok( $dts->mday(), '==', 17, 'mday() on 1999-01-09 Gregorian' );
cmp_ok( $dts->month(), '==', 1, 'month() on 1999-01-09 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afteryule', 'month_name() on 1999-01-09 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-01-09 Gregorian' );
Trewsday 17 Afteryule 7463

The Company of the Ring comes to Caras Galadhon at evening, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63051523200, 'utc_rd_as_seconds() on 1999-01-09 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729763,
  0,
  0
]
, 'utc_rd_values() on 1999-01-09 Gregorian' );
cmp_ok( $dts->wday(), '==', 4, 'wday() on 1999-01-09 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  3
]
, 'week() on 1999-01-09 Gregorian' );
cmp_ok( $dts->week_number(), '==', 3, 'week_number() on 1999-01-09 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-01-09 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-01-09 Gregorian' );

$epoch = timegm( 0, 0, 0, 10, 1 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 1,
	day	=> 10,
    ),
);
cmp_ok( $dts->day(), '==', 18, 'day() on 1999-01-10 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Hevensday', 'day_name() on 1999-01-10 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Hevenesdei', 'day_name_trad() on 1999-01-10 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 18, 'day_of_month() on 1999-01-10 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 5, 'day_of_week() on 1999-01-10 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 19, 'day_of_year() on 1999-01-10 Gregorian' );
cmp_ok( $dts->dow(), '==', 5, 'dow() on 1999-01-10 Gregorian' );
cmp_ok( $dts->doy(), '==', 19, 'doy() on 1999-01-10 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-01-10 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-01-10 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-01-10 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-01-10 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-01-10 Gregorian' );
cmp_ok( $dts->mday(), '==', 18, 'mday() on 1999-01-10 Gregorian' );
cmp_ok( $dts->month(), '==', 1, 'month() on 1999-01-10 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afteryule', 'month_name() on 1999-01-10 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-01-10 Gregorian' );
Hevensday 18 Afteryule 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63051609600, 'utc_rd_as_seconds() on 1999-01-10 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729764,
  0,
  0
]
, 'utc_rd_values() on 1999-01-10 Gregorian' );
cmp_ok( $dts->wday(), '==', 5, 'wday() on 1999-01-10 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  3
]
, 'week() on 1999-01-10 Gregorian' );
cmp_ok( $dts->week_number(), '==', 3, 'week_number() on 1999-01-10 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-01-10 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-01-10 Gregorian' );

$epoch = timegm( 0, 0, 0, 11, 1 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 1,
	day	=> 11,
    ),
);
cmp_ok( $dts->day(), '==', 19, 'day() on 1999-01-11 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Mersday', 'day_name() on 1999-01-11 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Meresdei', 'day_name_trad() on 1999-01-11 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 19, 'day_of_month() on 1999-01-11 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 6, 'day_of_week() on 1999-01-11 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 20, 'day_of_year() on 1999-01-11 Gregorian' );
cmp_ok( $dts->dow(), '==', 6, 'dow() on 1999-01-11 Gregorian' );
cmp_ok( $dts->doy(), '==', 20, 'doy() on 1999-01-11 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-01-11 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-01-11 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-01-11 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-01-11 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-01-11 Gregorian' );
cmp_ok( $dts->mday(), '==', 19, 'mday() on 1999-01-11 Gregorian' );
cmp_ok( $dts->month(), '==', 1, 'month() on 1999-01-11 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afteryule', 'month_name() on 1999-01-11 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-01-11 Gregorian' );
Mersday 19 Afteryule 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63051696000, 'utc_rd_as_seconds() on 1999-01-11 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729765,
  0,
  0
]
, 'utc_rd_values() on 1999-01-11 Gregorian' );
cmp_ok( $dts->wday(), '==', 6, 'wday() on 1999-01-11 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  3
]
, 'week() on 1999-01-11 Gregorian' );
cmp_ok( $dts->week_number(), '==', 3, 'week_number() on 1999-01-11 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-01-11 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-01-11 Gregorian' );

$epoch = timegm( 0, 0, 0, 12, 1 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 1,
	day	=> 12,
    ),
);
cmp_ok( $dts->day(), '==', 20, 'day() on 1999-01-12 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Highday', 'day_name() on 1999-01-12 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Highdei', 'day_name_trad() on 1999-01-12 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 20, 'day_of_month() on 1999-01-12 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 7, 'day_of_week() on 1999-01-12 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 21, 'day_of_year() on 1999-01-12 Gregorian' );
cmp_ok( $dts->dow(), '==', 7, 'dow() on 1999-01-12 Gregorian' );
cmp_ok( $dts->doy(), '==', 21, 'doy() on 1999-01-12 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-01-12 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-01-12 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-01-12 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-01-12 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-01-12 Gregorian' );
cmp_ok( $dts->mday(), '==', 20, 'mday() on 1999-01-12 Gregorian' );
cmp_ok( $dts->month(), '==', 1, 'month() on 1999-01-12 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afteryule', 'month_name() on 1999-01-12 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-01-12 Gregorian' );
Highday 20 Afteryule 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63051782400, 'utc_rd_as_seconds() on 1999-01-12 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729766,
  0,
  0
]
, 'utc_rd_values() on 1999-01-12 Gregorian' );
cmp_ok( $dts->wday(), '==', 7, 'wday() on 1999-01-12 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  3
]
, 'week() on 1999-01-12 Gregorian' );
cmp_ok( $dts->week_number(), '==', 3, 'week_number() on 1999-01-12 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-01-12 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-01-12 Gregorian' );

$epoch = timegm( 0, 0, 0, 13, 1 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 1,
	day	=> 13,
    ),
);
cmp_ok( $dts->day(), '==', 21, 'day() on 1999-01-13 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sterday', 'day_name() on 1999-01-13 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sterrendei', 'day_name_trad() on 1999-01-13 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 21, 'day_of_month() on 1999-01-13 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 1, 'day_of_week() on 1999-01-13 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 22, 'day_of_year() on 1999-01-13 Gregorian' );
cmp_ok( $dts->dow(), '==', 1, 'dow() on 1999-01-13 Gregorian' );
cmp_ok( $dts->doy(), '==', 22, 'doy() on 1999-01-13 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-01-13 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-01-13 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-01-13 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-01-13 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-01-13 Gregorian' );
cmp_ok( $dts->mday(), '==', 21, 'mday() on 1999-01-13 Gregorian' );
cmp_ok( $dts->month(), '==', 1, 'month() on 1999-01-13 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afteryule', 'month_name() on 1999-01-13 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-01-13 Gregorian' );
Sterday 21 Afteryule 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63051868800, 'utc_rd_as_seconds() on 1999-01-13 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729767,
  0,
  0
]
, 'utc_rd_values() on 1999-01-13 Gregorian' );
cmp_ok( $dts->wday(), '==', 1, 'wday() on 1999-01-13 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  4
]
, 'week() on 1999-01-13 Gregorian' );
cmp_ok( $dts->week_number(), '==', 4, 'week_number() on 1999-01-13 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-01-13 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-01-13 Gregorian' );

$epoch = timegm( 0, 0, 0, 14, 1 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 1,
	day	=> 14,
    ),
);
cmp_ok( $dts->day(), '==', 22, 'day() on 1999-01-14 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sunday', 'day_name() on 1999-01-14 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sunnendei', 'day_name_trad() on 1999-01-14 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 22, 'day_of_month() on 1999-01-14 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 2, 'day_of_week() on 1999-01-14 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 23, 'day_of_year() on 1999-01-14 Gregorian' );
cmp_ok( $dts->dow(), '==', 2, 'dow() on 1999-01-14 Gregorian' );
cmp_ok( $dts->doy(), '==', 23, 'doy() on 1999-01-14 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-01-14 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-01-14 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-01-14 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-01-14 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-01-14 Gregorian' );
cmp_ok( $dts->mday(), '==', 22, 'mday() on 1999-01-14 Gregorian' );
cmp_ok( $dts->month(), '==', 1, 'month() on 1999-01-14 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afteryule', 'month_name() on 1999-01-14 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-01-14 Gregorian' );
Sunday 22 Afteryule 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63051955200, 'utc_rd_as_seconds() on 1999-01-14 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729768,
  0,
  0
]
, 'utc_rd_values() on 1999-01-14 Gregorian' );
cmp_ok( $dts->wday(), '==', 2, 'wday() on 1999-01-14 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  4
]
, 'week() on 1999-01-14 Gregorian' );
cmp_ok( $dts->week_number(), '==', 4, 'week_number() on 1999-01-14 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-01-14 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-01-14 Gregorian' );

$epoch = timegm( 0, 0, 0, 15, 1 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 1,
	day	=> 15,
    ),
);
cmp_ok( $dts->day(), '==', 23, 'day() on 1999-01-15 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Monday', 'day_name() on 1999-01-15 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Monendei', 'day_name_trad() on 1999-01-15 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 23, 'day_of_month() on 1999-01-15 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 3, 'day_of_week() on 1999-01-15 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 24, 'day_of_year() on 1999-01-15 Gregorian' );
cmp_ok( $dts->dow(), '==', 3, 'dow() on 1999-01-15 Gregorian' );
cmp_ok( $dts->doy(), '==', 24, 'doy() on 1999-01-15 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-01-15 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-01-15 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-01-15 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-01-15 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-01-15 Gregorian' );
cmp_ok( $dts->mday(), '==', 23, 'mday() on 1999-01-15 Gregorian' );
cmp_ok( $dts->month(), '==', 1, 'month() on 1999-01-15 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afteryule', 'month_name() on 1999-01-15 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-01-15 Gregorian' );
Monday 23 Afteryule 7463

Gandalf pursues the Balrog to the peak of Zirakzigil, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63052041600, 'utc_rd_as_seconds() on 1999-01-15 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729769,
  0,
  0
]
, 'utc_rd_values() on 1999-01-15 Gregorian' );
cmp_ok( $dts->wday(), '==', 3, 'wday() on 1999-01-15 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  4
]
, 'week() on 1999-01-15 Gregorian' );
cmp_ok( $dts->week_number(), '==', 4, 'week_number() on 1999-01-15 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-01-15 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-01-15 Gregorian' );

$epoch = timegm( 0, 0, 0, 16, 1 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 1,
	day	=> 16,
    ),
);
cmp_ok( $dts->day(), '==', 24, 'day() on 1999-01-16 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Trewsday', 'day_name() on 1999-01-16 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Trewesdei', 'day_name_trad() on 1999-01-16 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 24, 'day_of_month() on 1999-01-16 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 4, 'day_of_week() on 1999-01-16 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 25, 'day_of_year() on 1999-01-16 Gregorian' );
cmp_ok( $dts->dow(), '==', 4, 'dow() on 1999-01-16 Gregorian' );
cmp_ok( $dts->doy(), '==', 25, 'doy() on 1999-01-16 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-01-16 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-01-16 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-01-16 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-01-16 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-01-16 Gregorian' );
cmp_ok( $dts->mday(), '==', 24, 'mday() on 1999-01-16 Gregorian' );
cmp_ok( $dts->month(), '==', 1, 'month() on 1999-01-16 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afteryule', 'month_name() on 1999-01-16 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-01-16 Gregorian' );
Trewsday 24 Afteryule 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63052128000, 'utc_rd_as_seconds() on 1999-01-16 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729770,
  0,
  0
]
, 'utc_rd_values() on 1999-01-16 Gregorian' );
cmp_ok( $dts->wday(), '==', 4, 'wday() on 1999-01-16 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  4
]
, 'week() on 1999-01-16 Gregorian' );
cmp_ok( $dts->week_number(), '==', 4, 'week_number() on 1999-01-16 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-01-16 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-01-16 Gregorian' );

$epoch = timegm( 0, 0, 0, 17, 1 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 1,
	day	=> 17,
    ),
);
cmp_ok( $dts->day(), '==', 25, 'day() on 1999-01-17 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Hevensday', 'day_name() on 1999-01-17 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Hevenesdei', 'day_name_trad() on 1999-01-17 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 25, 'day_of_month() on 1999-01-17 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 5, 'day_of_week() on 1999-01-17 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 26, 'day_of_year() on 1999-01-17 Gregorian' );
cmp_ok( $dts->dow(), '==', 5, 'dow() on 1999-01-17 Gregorian' );
cmp_ok( $dts->doy(), '==', 26, 'doy() on 1999-01-17 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-01-17 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-01-17 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-01-17 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-01-17 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-01-17 Gregorian' );
cmp_ok( $dts->mday(), '==', 25, 'mday() on 1999-01-17 Gregorian' );
cmp_ok( $dts->month(), '==', 1, 'month() on 1999-01-17 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afteryule', 'month_name() on 1999-01-17 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-01-17 Gregorian' );
Hevensday 25 Afteryule 7463

Gandalf casts down the Balrog, and passes away.
His body lies on the peak of Zirakzigil, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63052214400, 'utc_rd_as_seconds() on 1999-01-17 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729771,
  0,
  0
]
, 'utc_rd_values() on 1999-01-17 Gregorian' );
cmp_ok( $dts->wday(), '==', 5, 'wday() on 1999-01-17 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  4
]
, 'week() on 1999-01-17 Gregorian' );
cmp_ok( $dts->week_number(), '==', 4, 'week_number() on 1999-01-17 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-01-17 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-01-17 Gregorian' );

$epoch = timegm( 0, 0, 0, 18, 1 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 1,
	day	=> 18,
    ),
);
cmp_ok( $dts->day(), '==', 26, 'day() on 1999-01-18 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Mersday', 'day_name() on 1999-01-18 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Meresdei', 'day_name_trad() on 1999-01-18 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 26, 'day_of_month() on 1999-01-18 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 6, 'day_of_week() on 1999-01-18 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 27, 'day_of_year() on 1999-01-18 Gregorian' );
cmp_ok( $dts->dow(), '==', 6, 'dow() on 1999-01-18 Gregorian' );
cmp_ok( $dts->doy(), '==', 27, 'doy() on 1999-01-18 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-01-18 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-01-18 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-01-18 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-01-18 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-01-18 Gregorian' );
cmp_ok( $dts->mday(), '==', 26, 'mday() on 1999-01-18 Gregorian' );
cmp_ok( $dts->month(), '==', 1, 'month() on 1999-01-18 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afteryule', 'month_name() on 1999-01-18 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-01-18 Gregorian' );
Mersday 26 Afteryule 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63052300800, 'utc_rd_as_seconds() on 1999-01-18 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729772,
  0,
  0
]
, 'utc_rd_values() on 1999-01-18 Gregorian' );
cmp_ok( $dts->wday(), '==', 6, 'wday() on 1999-01-18 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  4
]
, 'week() on 1999-01-18 Gregorian' );
cmp_ok( $dts->week_number(), '==', 4, 'week_number() on 1999-01-18 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-01-18 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-01-18 Gregorian' );

$epoch = timegm( 0, 0, 0, 19, 1 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 1,
	day	=> 19,
    ),
);
cmp_ok( $dts->day(), '==', 27, 'day() on 1999-01-19 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Highday', 'day_name() on 1999-01-19 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Highdei', 'day_name_trad() on 1999-01-19 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 27, 'day_of_month() on 1999-01-19 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 7, 'day_of_week() on 1999-01-19 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 28, 'day_of_year() on 1999-01-19 Gregorian' );
cmp_ok( $dts->dow(), '==', 7, 'dow() on 1999-01-19 Gregorian' );
cmp_ok( $dts->doy(), '==', 28, 'doy() on 1999-01-19 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-01-19 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-01-19 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-01-19 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-01-19 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-01-19 Gregorian' );
cmp_ok( $dts->mday(), '==', 27, 'mday() on 1999-01-19 Gregorian' );
cmp_ok( $dts->month(), '==', 1, 'month() on 1999-01-19 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afteryule', 'month_name() on 1999-01-19 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-01-19 Gregorian' );
Highday 27 Afteryule 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63052387200, 'utc_rd_as_seconds() on 1999-01-19 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729773,
  0,
  0
]
, 'utc_rd_values() on 1999-01-19 Gregorian' );
cmp_ok( $dts->wday(), '==', 7, 'wday() on 1999-01-19 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  4
]
, 'week() on 1999-01-19 Gregorian' );
cmp_ok( $dts->week_number(), '==', 4, 'week_number() on 1999-01-19 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-01-19 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-01-19 Gregorian' );

$epoch = timegm( 0, 0, 0, 20, 1 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 1,
	day	=> 20,
    ),
);
cmp_ok( $dts->day(), '==', 28, 'day() on 1999-01-20 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sterday', 'day_name() on 1999-01-20 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sterrendei', 'day_name_trad() on 1999-01-20 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 28, 'day_of_month() on 1999-01-20 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 1, 'day_of_week() on 1999-01-20 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 29, 'day_of_year() on 1999-01-20 Gregorian' );
cmp_ok( $dts->dow(), '==', 1, 'dow() on 1999-01-20 Gregorian' );
cmp_ok( $dts->doy(), '==', 29, 'doy() on 1999-01-20 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-01-20 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-01-20 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-01-20 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-01-20 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-01-20 Gregorian' );
cmp_ok( $dts->mday(), '==', 28, 'mday() on 1999-01-20 Gregorian' );
cmp_ok( $dts->month(), '==', 1, 'month() on 1999-01-20 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afteryule', 'month_name() on 1999-01-20 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-01-20 Gregorian' );
Sterday 28 Afteryule 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63052473600, 'utc_rd_as_seconds() on 1999-01-20 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729774,
  0,
  0
]
, 'utc_rd_values() on 1999-01-20 Gregorian' );
cmp_ok( $dts->wday(), '==', 1, 'wday() on 1999-01-20 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  5
]
, 'week() on 1999-01-20 Gregorian' );
cmp_ok( $dts->week_number(), '==', 5, 'week_number() on 1999-01-20 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-01-20 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-01-20 Gregorian' );

$epoch = timegm( 0, 0, 0, 21, 1 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 1,
	day	=> 21,
    ),
);
cmp_ok( $dts->day(), '==', 29, 'day() on 1999-01-21 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sunday', 'day_name() on 1999-01-21 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sunnendei', 'day_name_trad() on 1999-01-21 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 29, 'day_of_month() on 1999-01-21 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 2, 'day_of_week() on 1999-01-21 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 30, 'day_of_year() on 1999-01-21 Gregorian' );
cmp_ok( $dts->dow(), '==', 2, 'dow() on 1999-01-21 Gregorian' );
cmp_ok( $dts->doy(), '==', 30, 'doy() on 1999-01-21 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-01-21 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-01-21 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-01-21 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-01-21 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-01-21 Gregorian' );
cmp_ok( $dts->mday(), '==', 29, 'mday() on 1999-01-21 Gregorian' );
cmp_ok( $dts->month(), '==', 1, 'month() on 1999-01-21 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afteryule', 'month_name() on 1999-01-21 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-01-21 Gregorian' );
Sunday 29 Afteryule 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63052560000, 'utc_rd_as_seconds() on 1999-01-21 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729775,
  0,
  0
]
, 'utc_rd_values() on 1999-01-21 Gregorian' );
cmp_ok( $dts->wday(), '==', 2, 'wday() on 1999-01-21 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  5
]
, 'week() on 1999-01-21 Gregorian' );
cmp_ok( $dts->week_number(), '==', 5, 'week_number() on 1999-01-21 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-01-21 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-01-21 Gregorian' );

$epoch = timegm( 0, 0, 0, 22, 1 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 1,
	day	=> 22,
    ),
);
cmp_ok( $dts->day(), '==', 30, 'day() on 1999-01-22 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Monday', 'day_name() on 1999-01-22 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Monendei', 'day_name_trad() on 1999-01-22 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 30, 'day_of_month() on 1999-01-22 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 3, 'day_of_week() on 1999-01-22 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 31, 'day_of_year() on 1999-01-22 Gregorian' );
cmp_ok( $dts->dow(), '==', 3, 'dow() on 1999-01-22 Gregorian' );
cmp_ok( $dts->doy(), '==', 31, 'doy() on 1999-01-22 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-01-22 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-01-22 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-01-22 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-01-22 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-01-22 Gregorian' );
cmp_ok( $dts->mday(), '==', 30, 'mday() on 1999-01-22 Gregorian' );
cmp_ok( $dts->month(), '==', 1, 'month() on 1999-01-22 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afteryule', 'month_name() on 1999-01-22 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-01-22 Gregorian' );
Monday 30 Afteryule 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63052646400, 'utc_rd_as_seconds() on 1999-01-22 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729776,
  0,
  0
]
, 'utc_rd_values() on 1999-01-22 Gregorian' );
cmp_ok( $dts->wday(), '==', 3, 'wday() on 1999-01-22 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  5
]
, 'week() on 1999-01-22 Gregorian' );
cmp_ok( $dts->week_number(), '==', 5, 'week_number() on 1999-01-22 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-01-22 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-01-22 Gregorian' );

$epoch = timegm( 0, 0, 0, 23, 1 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 1,
	day	=> 23,
    ),
);
cmp_ok( $dts->day(), '==', 1, 'day() on 1999-01-23 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Trewsday', 'day_name() on 1999-01-23 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Trewesdei', 'day_name_trad() on 1999-01-23 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 1, 'day_of_month() on 1999-01-23 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 4, 'day_of_week() on 1999-01-23 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 32, 'day_of_year() on 1999-01-23 Gregorian' );
cmp_ok( $dts->dow(), '==', 4, 'dow() on 1999-01-23 Gregorian' );
cmp_ok( $dts->doy(), '==', 32, 'doy() on 1999-01-23 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-01-23 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-01-23 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-01-23 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-01-23 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-01-23 Gregorian' );
cmp_ok( $dts->mday(), '==', 1, 'mday() on 1999-01-23 Gregorian' );
cmp_ok( $dts->month(), '==', 2, 'month() on 1999-01-23 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Solmath', 'month_name() on 1999-01-23 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-01-23 Gregorian' );
Trewsday 1 Solmath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63052732800, 'utc_rd_as_seconds() on 1999-01-23 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729777,
  0,
  0
]
, 'utc_rd_values() on 1999-01-23 Gregorian' );
cmp_ok( $dts->wday(), '==', 4, 'wday() on 1999-01-23 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  5
]
, 'week() on 1999-01-23 Gregorian' );
cmp_ok( $dts->week_number(), '==', 5, 'week_number() on 1999-01-23 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-01-23 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-01-23 Gregorian' );

$epoch = timegm( 0, 0, 0, 24, 1 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 1,
	day	=> 24,
    ),
);
cmp_ok( $dts->day(), '==', 2, 'day() on 1999-01-24 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Hevensday', 'day_name() on 1999-01-24 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Hevenesdei', 'day_name_trad() on 1999-01-24 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 2, 'day_of_month() on 1999-01-24 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 5, 'day_of_week() on 1999-01-24 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 33, 'day_of_year() on 1999-01-24 Gregorian' );
cmp_ok( $dts->dow(), '==', 5, 'dow() on 1999-01-24 Gregorian' );
cmp_ok( $dts->doy(), '==', 33, 'doy() on 1999-01-24 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-01-24 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-01-24 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-01-24 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-01-24 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-01-24 Gregorian' );
cmp_ok( $dts->mday(), '==', 2, 'mday() on 1999-01-24 Gregorian' );
cmp_ok( $dts->month(), '==', 2, 'month() on 1999-01-24 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Solmath', 'month_name() on 1999-01-24 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-01-24 Gregorian' );
Hevensday 2 Solmath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63052819200, 'utc_rd_as_seconds() on 1999-01-24 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729778,
  0,
  0
]
, 'utc_rd_values() on 1999-01-24 Gregorian' );
cmp_ok( $dts->wday(), '==', 5, 'wday() on 1999-01-24 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  5
]
, 'week() on 1999-01-24 Gregorian' );
cmp_ok( $dts->week_number(), '==', 5, 'week_number() on 1999-01-24 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-01-24 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-01-24 Gregorian' );

$epoch = timegm( 0, 0, 0, 25, 1 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 1,
	day	=> 25,
    ),
);
cmp_ok( $dts->day(), '==', 3, 'day() on 1999-01-25 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Mersday', 'day_name() on 1999-01-25 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Meresdei', 'day_name_trad() on 1999-01-25 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 3, 'day_of_month() on 1999-01-25 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 6, 'day_of_week() on 1999-01-25 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 34, 'day_of_year() on 1999-01-25 Gregorian' );
cmp_ok( $dts->dow(), '==', 6, 'dow() on 1999-01-25 Gregorian' );
cmp_ok( $dts->doy(), '==', 34, 'doy() on 1999-01-25 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-01-25 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-01-25 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-01-25 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-01-25 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-01-25 Gregorian' );
cmp_ok( $dts->mday(), '==', 3, 'mday() on 1999-01-25 Gregorian' );
cmp_ok( $dts->month(), '==', 2, 'month() on 1999-01-25 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Solmath', 'month_name() on 1999-01-25 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-01-25 Gregorian' );
Mersday 3 Solmath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63052905600, 'utc_rd_as_seconds() on 1999-01-25 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729779,
  0,
  0
]
, 'utc_rd_values() on 1999-01-25 Gregorian' );
cmp_ok( $dts->wday(), '==', 6, 'wday() on 1999-01-25 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  5
]
, 'week() on 1999-01-25 Gregorian' );
cmp_ok( $dts->week_number(), '==', 5, 'week_number() on 1999-01-25 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-01-25 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-01-25 Gregorian' );

$epoch = timegm( 0, 0, 0, 26, 1 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 1,
	day	=> 26,
    ),
);
cmp_ok( $dts->day(), '==', 4, 'day() on 1999-01-26 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Highday', 'day_name() on 1999-01-26 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Highdei', 'day_name_trad() on 1999-01-26 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 4, 'day_of_month() on 1999-01-26 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 7, 'day_of_week() on 1999-01-26 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 35, 'day_of_year() on 1999-01-26 Gregorian' );
cmp_ok( $dts->dow(), '==', 7, 'dow() on 1999-01-26 Gregorian' );
cmp_ok( $dts->doy(), '==', 35, 'doy() on 1999-01-26 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-01-26 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-01-26 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-01-26 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-01-26 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-01-26 Gregorian' );
cmp_ok( $dts->mday(), '==', 4, 'mday() on 1999-01-26 Gregorian' );
cmp_ok( $dts->month(), '==', 2, 'month() on 1999-01-26 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Solmath', 'month_name() on 1999-01-26 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-01-26 Gregorian' );
Highday 4 Solmath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63052992000, 'utc_rd_as_seconds() on 1999-01-26 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729780,
  0,
  0
]
, 'utc_rd_values() on 1999-01-26 Gregorian' );
cmp_ok( $dts->wday(), '==', 7, 'wday() on 1999-01-26 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  5
]
, 'week() on 1999-01-26 Gregorian' );
cmp_ok( $dts->week_number(), '==', 5, 'week_number() on 1999-01-26 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-01-26 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-01-26 Gregorian' );

$epoch = timegm( 0, 0, 0, 27, 1 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 1,
	day	=> 27,
    ),
);
cmp_ok( $dts->day(), '==', 5, 'day() on 1999-01-27 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sterday', 'day_name() on 1999-01-27 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sterrendei', 'day_name_trad() on 1999-01-27 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 5, 'day_of_month() on 1999-01-27 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 1, 'day_of_week() on 1999-01-27 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 36, 'day_of_year() on 1999-01-27 Gregorian' );
cmp_ok( $dts->dow(), '==', 1, 'dow() on 1999-01-27 Gregorian' );
cmp_ok( $dts->doy(), '==', 36, 'doy() on 1999-01-27 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-01-27 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-01-27 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-01-27 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-01-27 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-01-27 Gregorian' );
cmp_ok( $dts->mday(), '==', 5, 'mday() on 1999-01-27 Gregorian' );
cmp_ok( $dts->month(), '==', 2, 'month() on 1999-01-27 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Solmath', 'month_name() on 1999-01-27 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-01-27 Gregorian' );
Sterday 5 Solmath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63053078400, 'utc_rd_as_seconds() on 1999-01-27 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729781,
  0,
  0
]
, 'utc_rd_values() on 1999-01-27 Gregorian' );
cmp_ok( $dts->wday(), '==', 1, 'wday() on 1999-01-27 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  6
]
, 'week() on 1999-01-27 Gregorian' );
cmp_ok( $dts->week_number(), '==', 6, 'week_number() on 1999-01-27 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-01-27 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-01-27 Gregorian' );

$epoch = timegm( 0, 0, 0, 28, 1 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 1,
	day	=> 28,
    ),
);
cmp_ok( $dts->day(), '==', 6, 'day() on 1999-01-28 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sunday', 'day_name() on 1999-01-28 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sunnendei', 'day_name_trad() on 1999-01-28 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 6, 'day_of_month() on 1999-01-28 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 2, 'day_of_week() on 1999-01-28 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 37, 'day_of_year() on 1999-01-28 Gregorian' );
cmp_ok( $dts->dow(), '==', 2, 'dow() on 1999-01-28 Gregorian' );
cmp_ok( $dts->doy(), '==', 37, 'doy() on 1999-01-28 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-01-28 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-01-28 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-01-28 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-01-28 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-01-28 Gregorian' );
cmp_ok( $dts->mday(), '==', 6, 'mday() on 1999-01-28 Gregorian' );
cmp_ok( $dts->month(), '==', 2, 'month() on 1999-01-28 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Solmath', 'month_name() on 1999-01-28 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-01-28 Gregorian' );
Sunday 6 Solmath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63053164800, 'utc_rd_as_seconds() on 1999-01-28 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729782,
  0,
  0
]
, 'utc_rd_values() on 1999-01-28 Gregorian' );
cmp_ok( $dts->wday(), '==', 2, 'wday() on 1999-01-28 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  6
]
, 'week() on 1999-01-28 Gregorian' );
cmp_ok( $dts->week_number(), '==', 6, 'week_number() on 1999-01-28 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-01-28 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-01-28 Gregorian' );

$epoch = timegm( 0, 0, 0, 29, 1 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 1,
	day	=> 29,
    ),
);
cmp_ok( $dts->day(), '==', 7, 'day() on 1999-01-29 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Monday', 'day_name() on 1999-01-29 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Monendei', 'day_name_trad() on 1999-01-29 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 7, 'day_of_month() on 1999-01-29 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 3, 'day_of_week() on 1999-01-29 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 38, 'day_of_year() on 1999-01-29 Gregorian' );
cmp_ok( $dts->dow(), '==', 3, 'dow() on 1999-01-29 Gregorian' );
cmp_ok( $dts->doy(), '==', 38, 'doy() on 1999-01-29 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-01-29 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-01-29 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-01-29 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-01-29 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-01-29 Gregorian' );
cmp_ok( $dts->mday(), '==', 7, 'mday() on 1999-01-29 Gregorian' );
cmp_ok( $dts->month(), '==', 2, 'month() on 1999-01-29 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Solmath', 'month_name() on 1999-01-29 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-01-29 Gregorian' );
Monday 7 Solmath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63053251200, 'utc_rd_as_seconds() on 1999-01-29 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729783,
  0,
  0
]
, 'utc_rd_values() on 1999-01-29 Gregorian' );
cmp_ok( $dts->wday(), '==', 3, 'wday() on 1999-01-29 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  6
]
, 'week() on 1999-01-29 Gregorian' );
cmp_ok( $dts->week_number(), '==', 6, 'week_number() on 1999-01-29 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-01-29 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-01-29 Gregorian' );

$epoch = timegm( 0, 0, 0, 30, 1 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 1,
	day	=> 30,
    ),
);
cmp_ok( $dts->day(), '==', 8, 'day() on 1999-01-30 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Trewsday', 'day_name() on 1999-01-30 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Trewesdei', 'day_name_trad() on 1999-01-30 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 8, 'day_of_month() on 1999-01-30 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 4, 'day_of_week() on 1999-01-30 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 39, 'day_of_year() on 1999-01-30 Gregorian' );
cmp_ok( $dts->dow(), '==', 4, 'dow() on 1999-01-30 Gregorian' );
cmp_ok( $dts->doy(), '==', 39, 'doy() on 1999-01-30 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-01-30 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-01-30 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-01-30 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-01-30 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-01-30 Gregorian' );
cmp_ok( $dts->mday(), '==', 8, 'mday() on 1999-01-30 Gregorian' );
cmp_ok( $dts->month(), '==', 2, 'month() on 1999-01-30 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Solmath', 'month_name() on 1999-01-30 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-01-30 Gregorian' );
Trewsday 8 Solmath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63053337600, 'utc_rd_as_seconds() on 1999-01-30 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729784,
  0,
  0
]
, 'utc_rd_values() on 1999-01-30 Gregorian' );
cmp_ok( $dts->wday(), '==', 4, 'wday() on 1999-01-30 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  6
]
, 'week() on 1999-01-30 Gregorian' );
cmp_ok( $dts->week_number(), '==', 6, 'week_number() on 1999-01-30 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-01-30 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-01-30 Gregorian' );

$epoch = timegm( 0, 0, 0, 31, 1 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 1,
	day	=> 31,
    ),
);
cmp_ok( $dts->day(), '==', 9, 'day() on 1999-01-31 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Hevensday', 'day_name() on 1999-01-31 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Hevenesdei', 'day_name_trad() on 1999-01-31 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 9, 'day_of_month() on 1999-01-31 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 5, 'day_of_week() on 1999-01-31 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 40, 'day_of_year() on 1999-01-31 Gregorian' );
cmp_ok( $dts->dow(), '==', 5, 'dow() on 1999-01-31 Gregorian' );
cmp_ok( $dts->doy(), '==', 40, 'doy() on 1999-01-31 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-01-31 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-01-31 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-01-31 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-01-31 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-01-31 Gregorian' );
cmp_ok( $dts->mday(), '==', 9, 'mday() on 1999-01-31 Gregorian' );
cmp_ok( $dts->month(), '==', 2, 'month() on 1999-01-31 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Solmath', 'month_name() on 1999-01-31 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-01-31 Gregorian' );
Hevensday 9 Solmath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63053424000, 'utc_rd_as_seconds() on 1999-01-31 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729785,
  0,
  0
]
, 'utc_rd_values() on 1999-01-31 Gregorian' );
cmp_ok( $dts->wday(), '==', 5, 'wday() on 1999-01-31 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  6
]
, 'week() on 1999-01-31 Gregorian' );
cmp_ok( $dts->week_number(), '==', 6, 'week_number() on 1999-01-31 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-01-31 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-01-31 Gregorian' );

$epoch = timegm( 0, 0, 0, 1, 2 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 2,
	day	=> 1,
    ),
);
cmp_ok( $dts->day(), '==', 10, 'day() on 1999-02-01 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Mersday', 'day_name() on 1999-02-01 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Meresdei', 'day_name_trad() on 1999-02-01 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 10, 'day_of_month() on 1999-02-01 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 6, 'day_of_week() on 1999-02-01 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 41, 'day_of_year() on 1999-02-01 Gregorian' );
cmp_ok( $dts->dow(), '==', 6, 'dow() on 1999-02-01 Gregorian' );
cmp_ok( $dts->doy(), '==', 41, 'doy() on 1999-02-01 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-02-01 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-02-01 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-02-01 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-02-01 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-02-01 Gregorian' );
cmp_ok( $dts->mday(), '==', 10, 'mday() on 1999-02-01 Gregorian' );
cmp_ok( $dts->month(), '==', 2, 'month() on 1999-02-01 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Solmath', 'month_name() on 1999-02-01 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-02-01 Gregorian' );
Mersday 10 Solmath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63053510400, 'utc_rd_as_seconds() on 1999-02-01 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729786,
  0,
  0
]
, 'utc_rd_values() on 1999-02-01 Gregorian' );
cmp_ok( $dts->wday(), '==', 6, 'wday() on 1999-02-01 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  6
]
, 'week() on 1999-02-01 Gregorian' );
cmp_ok( $dts->week_number(), '==', 6, 'week_number() on 1999-02-01 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-02-01 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-02-01 Gregorian' );

$epoch = timegm( 0, 0, 0, 2, 2 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 2,
	day	=> 2,
    ),
);
cmp_ok( $dts->day(), '==', 11, 'day() on 1999-02-02 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Highday', 'day_name() on 1999-02-02 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Highdei', 'day_name_trad() on 1999-02-02 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 11, 'day_of_month() on 1999-02-02 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 7, 'day_of_week() on 1999-02-02 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 42, 'day_of_year() on 1999-02-02 Gregorian' );
cmp_ok( $dts->dow(), '==', 7, 'dow() on 1999-02-02 Gregorian' );
cmp_ok( $dts->doy(), '==', 42, 'doy() on 1999-02-02 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-02-02 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-02-02 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-02-02 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-02-02 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-02-02 Gregorian' );
cmp_ok( $dts->mday(), '==', 11, 'mday() on 1999-02-02 Gregorian' );
cmp_ok( $dts->month(), '==', 2, 'month() on 1999-02-02 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Solmath', 'month_name() on 1999-02-02 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-02-02 Gregorian' );
Highday 11 Solmath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63053596800, 'utc_rd_as_seconds() on 1999-02-02 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729787,
  0,
  0
]
, 'utc_rd_values() on 1999-02-02 Gregorian' );
cmp_ok( $dts->wday(), '==', 7, 'wday() on 1999-02-02 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  6
]
, 'week() on 1999-02-02 Gregorian' );
cmp_ok( $dts->week_number(), '==', 6, 'week_number() on 1999-02-02 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-02-02 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-02-02 Gregorian' );

$epoch = timegm( 0, 0, 0, 3, 2 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 2,
	day	=> 3,
    ),
);
cmp_ok( $dts->day(), '==', 12, 'day() on 1999-02-03 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sterday', 'day_name() on 1999-02-03 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sterrendei', 'day_name_trad() on 1999-02-03 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 12, 'day_of_month() on 1999-02-03 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 1, 'day_of_week() on 1999-02-03 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 43, 'day_of_year() on 1999-02-03 Gregorian' );
cmp_ok( $dts->dow(), '==', 1, 'dow() on 1999-02-03 Gregorian' );
cmp_ok( $dts->doy(), '==', 43, 'doy() on 1999-02-03 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-02-03 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-02-03 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-02-03 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-02-03 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-02-03 Gregorian' );
cmp_ok( $dts->mday(), '==', 12, 'mday() on 1999-02-03 Gregorian' );
cmp_ok( $dts->month(), '==', 2, 'month() on 1999-02-03 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Solmath', 'month_name() on 1999-02-03 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-02-03 Gregorian' );
Sterday 12 Solmath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63053683200, 'utc_rd_as_seconds() on 1999-02-03 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729788,
  0,
  0
]
, 'utc_rd_values() on 1999-02-03 Gregorian' );
cmp_ok( $dts->wday(), '==', 1, 'wday() on 1999-02-03 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  7
]
, 'week() on 1999-02-03 Gregorian' );
cmp_ok( $dts->week_number(), '==', 7, 'week_number() on 1999-02-03 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-02-03 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-02-03 Gregorian' );

$epoch = timegm( 0, 0, 0, 4, 2 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 2,
	day	=> 4,
    ),
);
cmp_ok( $dts->day(), '==', 13, 'day() on 1999-02-04 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sunday', 'day_name() on 1999-02-04 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sunnendei', 'day_name_trad() on 1999-02-04 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 13, 'day_of_month() on 1999-02-04 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 2, 'day_of_week() on 1999-02-04 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 44, 'day_of_year() on 1999-02-04 Gregorian' );
cmp_ok( $dts->dow(), '==', 2, 'dow() on 1999-02-04 Gregorian' );
cmp_ok( $dts->doy(), '==', 44, 'doy() on 1999-02-04 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-02-04 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-02-04 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-02-04 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-02-04 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-02-04 Gregorian' );
cmp_ok( $dts->mday(), '==', 13, 'mday() on 1999-02-04 Gregorian' );
cmp_ok( $dts->month(), '==', 2, 'month() on 1999-02-04 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Solmath', 'month_name() on 1999-02-04 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-02-04 Gregorian' );
Sunday 13 Solmath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63053769600, 'utc_rd_as_seconds() on 1999-02-04 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729789,
  0,
  0
]
, 'utc_rd_values() on 1999-02-04 Gregorian' );
cmp_ok( $dts->wday(), '==', 2, 'wday() on 1999-02-04 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  7
]
, 'week() on 1999-02-04 Gregorian' );
cmp_ok( $dts->week_number(), '==', 7, 'week_number() on 1999-02-04 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-02-04 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-02-04 Gregorian' );

$epoch = timegm( 0, 0, 0, 5, 2 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 2,
	day	=> 5,
    ),
);
cmp_ok( $dts->day(), '==', 14, 'day() on 1999-02-05 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Monday', 'day_name() on 1999-02-05 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Monendei', 'day_name_trad() on 1999-02-05 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 14, 'day_of_month() on 1999-02-05 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 3, 'day_of_week() on 1999-02-05 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 45, 'day_of_year() on 1999-02-05 Gregorian' );
cmp_ok( $dts->dow(), '==', 3, 'dow() on 1999-02-05 Gregorian' );
cmp_ok( $dts->doy(), '==', 45, 'doy() on 1999-02-05 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-02-05 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-02-05 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-02-05 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-02-05 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-02-05 Gregorian' );
cmp_ok( $dts->mday(), '==', 14, 'mday() on 1999-02-05 Gregorian' );
cmp_ok( $dts->month(), '==', 2, 'month() on 1999-02-05 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Solmath', 'month_name() on 1999-02-05 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-02-05 Gregorian' );
Monday 14 Solmath 7463

Frodo and Sam look in the Mirror of Galadriel, 1419.
Gandalf returns to life, and lies in a trance, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63053856000, 'utc_rd_as_seconds() on 1999-02-05 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729790,
  0,
  0
]
, 'utc_rd_values() on 1999-02-05 Gregorian' );
cmp_ok( $dts->wday(), '==', 3, 'wday() on 1999-02-05 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  7
]
, 'week() on 1999-02-05 Gregorian' );
cmp_ok( $dts->week_number(), '==', 7, 'week_number() on 1999-02-05 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-02-05 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-02-05 Gregorian' );

$epoch = timegm( 0, 0, 0, 6, 2 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 2,
	day	=> 6,
    ),
);
cmp_ok( $dts->day(), '==', 15, 'day() on 1999-02-06 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Trewsday', 'day_name() on 1999-02-06 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Trewesdei', 'day_name_trad() on 1999-02-06 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 15, 'day_of_month() on 1999-02-06 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 4, 'day_of_week() on 1999-02-06 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 46, 'day_of_year() on 1999-02-06 Gregorian' );
cmp_ok( $dts->dow(), '==', 4, 'dow() on 1999-02-06 Gregorian' );
cmp_ok( $dts->doy(), '==', 46, 'doy() on 1999-02-06 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-02-06 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-02-06 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-02-06 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-02-06 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-02-06 Gregorian' );
cmp_ok( $dts->mday(), '==', 15, 'mday() on 1999-02-06 Gregorian' );
cmp_ok( $dts->month(), '==', 2, 'month() on 1999-02-06 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Solmath', 'month_name() on 1999-02-06 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-02-06 Gregorian' );
Trewsday 15 Solmath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63053942400, 'utc_rd_as_seconds() on 1999-02-06 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729791,
  0,
  0
]
, 'utc_rd_values() on 1999-02-06 Gregorian' );
cmp_ok( $dts->wday(), '==', 4, 'wday() on 1999-02-06 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  7
]
, 'week() on 1999-02-06 Gregorian' );
cmp_ok( $dts->week_number(), '==', 7, 'week_number() on 1999-02-06 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-02-06 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-02-06 Gregorian' );

$epoch = timegm( 0, 0, 0, 7, 2 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 2,
	day	=> 7,
    ),
);
cmp_ok( $dts->day(), '==', 16, 'day() on 1999-02-07 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Hevensday', 'day_name() on 1999-02-07 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Hevenesdei', 'day_name_trad() on 1999-02-07 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 16, 'day_of_month() on 1999-02-07 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 5, 'day_of_week() on 1999-02-07 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 47, 'day_of_year() on 1999-02-07 Gregorian' );
cmp_ok( $dts->dow(), '==', 5, 'dow() on 1999-02-07 Gregorian' );
cmp_ok( $dts->doy(), '==', 47, 'doy() on 1999-02-07 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-02-07 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-02-07 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-02-07 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-02-07 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-02-07 Gregorian' );
cmp_ok( $dts->mday(), '==', 16, 'mday() on 1999-02-07 Gregorian' );
cmp_ok( $dts->month(), '==', 2, 'month() on 1999-02-07 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Solmath', 'month_name() on 1999-02-07 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-02-07 Gregorian' );
Hevensday 16 Solmath 7463

Company of the Ring says farewell to Lorien --
Gollum observes departure, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63054028800, 'utc_rd_as_seconds() on 1999-02-07 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729792,
  0,
  0
]
, 'utc_rd_values() on 1999-02-07 Gregorian' );
cmp_ok( $dts->wday(), '==', 5, 'wday() on 1999-02-07 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  7
]
, 'week() on 1999-02-07 Gregorian' );
cmp_ok( $dts->week_number(), '==', 7, 'week_number() on 1999-02-07 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-02-07 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-02-07 Gregorian' );

$epoch = timegm( 0, 0, 0, 8, 2 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 2,
	day	=> 8,
    ),
);
cmp_ok( $dts->day(), '==', 17, 'day() on 1999-02-08 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Mersday', 'day_name() on 1999-02-08 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Meresdei', 'day_name_trad() on 1999-02-08 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 17, 'day_of_month() on 1999-02-08 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 6, 'day_of_week() on 1999-02-08 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 48, 'day_of_year() on 1999-02-08 Gregorian' );
cmp_ok( $dts->dow(), '==', 6, 'dow() on 1999-02-08 Gregorian' );
cmp_ok( $dts->doy(), '==', 48, 'doy() on 1999-02-08 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-02-08 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-02-08 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-02-08 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-02-08 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-02-08 Gregorian' );
cmp_ok( $dts->mday(), '==', 17, 'mday() on 1999-02-08 Gregorian' );
cmp_ok( $dts->month(), '==', 2, 'month() on 1999-02-08 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Solmath', 'month_name() on 1999-02-08 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-02-08 Gregorian' );
Mersday 17 Solmath 7463

Gwaihir the eagle bears Gandalf to Lorien, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63054115200, 'utc_rd_as_seconds() on 1999-02-08 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729793,
  0,
  0
]
, 'utc_rd_values() on 1999-02-08 Gregorian' );
cmp_ok( $dts->wday(), '==', 6, 'wday() on 1999-02-08 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  7
]
, 'week() on 1999-02-08 Gregorian' );
cmp_ok( $dts->week_number(), '==', 7, 'week_number() on 1999-02-08 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-02-08 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-02-08 Gregorian' );

$epoch = timegm( 0, 0, 0, 9, 2 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 2,
	day	=> 9,
    ),
);
cmp_ok( $dts->day(), '==', 18, 'day() on 1999-02-09 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Highday', 'day_name() on 1999-02-09 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Highdei', 'day_name_trad() on 1999-02-09 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 18, 'day_of_month() on 1999-02-09 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 7, 'day_of_week() on 1999-02-09 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 49, 'day_of_year() on 1999-02-09 Gregorian' );
cmp_ok( $dts->dow(), '==', 7, 'dow() on 1999-02-09 Gregorian' );
cmp_ok( $dts->doy(), '==', 49, 'doy() on 1999-02-09 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-02-09 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-02-09 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-02-09 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-02-09 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-02-09 Gregorian' );
cmp_ok( $dts->mday(), '==', 18, 'mday() on 1999-02-09 Gregorian' );
cmp_ok( $dts->month(), '==', 2, 'month() on 1999-02-09 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Solmath', 'month_name() on 1999-02-09 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-02-09 Gregorian' );
Highday 18 Solmath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63054201600, 'utc_rd_as_seconds() on 1999-02-09 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729794,
  0,
  0
]
, 'utc_rd_values() on 1999-02-09 Gregorian' );
cmp_ok( $dts->wday(), '==', 7, 'wday() on 1999-02-09 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  7
]
, 'week() on 1999-02-09 Gregorian' );
cmp_ok( $dts->week_number(), '==', 7, 'week_number() on 1999-02-09 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-02-09 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-02-09 Gregorian' );

$epoch = timegm( 0, 0, 0, 10, 2 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 2,
	day	=> 10,
    ),
);
cmp_ok( $dts->day(), '==', 19, 'day() on 1999-02-10 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sterday', 'day_name() on 1999-02-10 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sterrendei', 'day_name_trad() on 1999-02-10 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 19, 'day_of_month() on 1999-02-10 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 1, 'day_of_week() on 1999-02-10 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 50, 'day_of_year() on 1999-02-10 Gregorian' );
cmp_ok( $dts->dow(), '==', 1, 'dow() on 1999-02-10 Gregorian' );
cmp_ok( $dts->doy(), '==', 50, 'doy() on 1999-02-10 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-02-10 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-02-10 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-02-10 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-02-10 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-02-10 Gregorian' );
cmp_ok( $dts->mday(), '==', 19, 'mday() on 1999-02-10 Gregorian' );
cmp_ok( $dts->month(), '==', 2, 'month() on 1999-02-10 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Solmath', 'month_name() on 1999-02-10 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-02-10 Gregorian' );
Sterday 19 Solmath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63054288000, 'utc_rd_as_seconds() on 1999-02-10 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729795,
  0,
  0
]
, 'utc_rd_values() on 1999-02-10 Gregorian' );
cmp_ok( $dts->wday(), '==', 1, 'wday() on 1999-02-10 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  8
]
, 'week() on 1999-02-10 Gregorian' );
cmp_ok( $dts->week_number(), '==', 8, 'week_number() on 1999-02-10 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-02-10 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-02-10 Gregorian' );

$epoch = timegm( 0, 0, 0, 11, 2 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 2,
	day	=> 11,
    ),
);
cmp_ok( $dts->day(), '==', 20, 'day() on 1999-02-11 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sunday', 'day_name() on 1999-02-11 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sunnendei', 'day_name_trad() on 1999-02-11 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 20, 'day_of_month() on 1999-02-11 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 2, 'day_of_week() on 1999-02-11 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 51, 'day_of_year() on 1999-02-11 Gregorian' );
cmp_ok( $dts->dow(), '==', 2, 'dow() on 1999-02-11 Gregorian' );
cmp_ok( $dts->doy(), '==', 51, 'doy() on 1999-02-11 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-02-11 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-02-11 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-02-11 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-02-11 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-02-11 Gregorian' );
cmp_ok( $dts->mday(), '==', 20, 'mday() on 1999-02-11 Gregorian' );
cmp_ok( $dts->month(), '==', 2, 'month() on 1999-02-11 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Solmath', 'month_name() on 1999-02-11 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-02-11 Gregorian' );
Sunday 20 Solmath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63054374400, 'utc_rd_as_seconds() on 1999-02-11 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729796,
  0,
  0
]
, 'utc_rd_values() on 1999-02-11 Gregorian' );
cmp_ok( $dts->wday(), '==', 2, 'wday() on 1999-02-11 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  8
]
, 'week() on 1999-02-11 Gregorian' );
cmp_ok( $dts->week_number(), '==', 8, 'week_number() on 1999-02-11 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-02-11 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-02-11 Gregorian' );

$epoch = timegm( 0, 0, 0, 12, 2 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 2,
	day	=> 12,
    ),
);
cmp_ok( $dts->day(), '==', 21, 'day() on 1999-02-12 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Monday', 'day_name() on 1999-02-12 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Monendei', 'day_name_trad() on 1999-02-12 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 21, 'day_of_month() on 1999-02-12 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 3, 'day_of_week() on 1999-02-12 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 52, 'day_of_year() on 1999-02-12 Gregorian' );
cmp_ok( $dts->dow(), '==', 3, 'dow() on 1999-02-12 Gregorian' );
cmp_ok( $dts->doy(), '==', 52, 'doy() on 1999-02-12 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-02-12 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-02-12 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-02-12 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-02-12 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-02-12 Gregorian' );
cmp_ok( $dts->mday(), '==', 21, 'mday() on 1999-02-12 Gregorian' );
cmp_ok( $dts->month(), '==', 2, 'month() on 1999-02-12 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Solmath', 'month_name() on 1999-02-12 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-02-12 Gregorian' );
Monday 21 Solmath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63054460800, 'utc_rd_as_seconds() on 1999-02-12 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729797,
  0,
  0
]
, 'utc_rd_values() on 1999-02-12 Gregorian' );
cmp_ok( $dts->wday(), '==', 3, 'wday() on 1999-02-12 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  8
]
, 'week() on 1999-02-12 Gregorian' );
cmp_ok( $dts->week_number(), '==', 8, 'week_number() on 1999-02-12 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-02-12 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-02-12 Gregorian' );

$epoch = timegm( 0, 0, 0, 13, 2 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 2,
	day	=> 13,
    ),
);
cmp_ok( $dts->day(), '==', 22, 'day() on 1999-02-13 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Trewsday', 'day_name() on 1999-02-13 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Trewesdei', 'day_name_trad() on 1999-02-13 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 22, 'day_of_month() on 1999-02-13 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 4, 'day_of_week() on 1999-02-13 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 53, 'day_of_year() on 1999-02-13 Gregorian' );
cmp_ok( $dts->dow(), '==', 4, 'dow() on 1999-02-13 Gregorian' );
cmp_ok( $dts->doy(), '==', 53, 'doy() on 1999-02-13 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-02-13 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-02-13 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-02-13 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-02-13 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-02-13 Gregorian' );
cmp_ok( $dts->mday(), '==', 22, 'mday() on 1999-02-13 Gregorian' );
cmp_ok( $dts->month(), '==', 2, 'month() on 1999-02-13 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Solmath', 'month_name() on 1999-02-13 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-02-13 Gregorian' );
Trewsday 22 Solmath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63054547200, 'utc_rd_as_seconds() on 1999-02-13 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729798,
  0,
  0
]
, 'utc_rd_values() on 1999-02-13 Gregorian' );
cmp_ok( $dts->wday(), '==', 4, 'wday() on 1999-02-13 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  8
]
, 'week() on 1999-02-13 Gregorian' );
cmp_ok( $dts->week_number(), '==', 8, 'week_number() on 1999-02-13 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-02-13 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-02-13 Gregorian' );

$epoch = timegm( 0, 0, 0, 14, 2 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 2,
	day	=> 14,
    ),
);
cmp_ok( $dts->day(), '==', 23, 'day() on 1999-02-14 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Hevensday', 'day_name() on 1999-02-14 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Hevenesdei', 'day_name_trad() on 1999-02-14 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 23, 'day_of_month() on 1999-02-14 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 5, 'day_of_week() on 1999-02-14 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 54, 'day_of_year() on 1999-02-14 Gregorian' );
cmp_ok( $dts->dow(), '==', 5, 'dow() on 1999-02-14 Gregorian' );
cmp_ok( $dts->doy(), '==', 54, 'doy() on 1999-02-14 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-02-14 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-02-14 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-02-14 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-02-14 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-02-14 Gregorian' );
cmp_ok( $dts->mday(), '==', 23, 'mday() on 1999-02-14 Gregorian' );
cmp_ok( $dts->month(), '==', 2, 'month() on 1999-02-14 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Solmath', 'month_name() on 1999-02-14 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-02-14 Gregorian' );
Hevensday 23 Solmath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63054633600, 'utc_rd_as_seconds() on 1999-02-14 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729799,
  0,
  0
]
, 'utc_rd_values() on 1999-02-14 Gregorian' );
cmp_ok( $dts->wday(), '==', 5, 'wday() on 1999-02-14 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  8
]
, 'week() on 1999-02-14 Gregorian' );
cmp_ok( $dts->week_number(), '==', 8, 'week_number() on 1999-02-14 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-02-14 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-02-14 Gregorian' );

$epoch = timegm( 0, 0, 0, 15, 2 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 2,
	day	=> 15,
    ),
);
cmp_ok( $dts->day(), '==', 24, 'day() on 1999-02-15 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Mersday', 'day_name() on 1999-02-15 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Meresdei', 'day_name_trad() on 1999-02-15 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 24, 'day_of_month() on 1999-02-15 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 6, 'day_of_week() on 1999-02-15 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 55, 'day_of_year() on 1999-02-15 Gregorian' );
cmp_ok( $dts->dow(), '==', 6, 'dow() on 1999-02-15 Gregorian' );
cmp_ok( $dts->doy(), '==', 55, 'doy() on 1999-02-15 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-02-15 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-02-15 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-02-15 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-02-15 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-02-15 Gregorian' );
cmp_ok( $dts->mday(), '==', 24, 'mday() on 1999-02-15 Gregorian' );
cmp_ok( $dts->month(), '==', 2, 'month() on 1999-02-15 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Solmath', 'month_name() on 1999-02-15 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-02-15 Gregorian' );
Mersday 24 Solmath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63054720000, 'utc_rd_as_seconds() on 1999-02-15 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729800,
  0,
  0
]
, 'utc_rd_values() on 1999-02-15 Gregorian' );
cmp_ok( $dts->wday(), '==', 6, 'wday() on 1999-02-15 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  8
]
, 'week() on 1999-02-15 Gregorian' );
cmp_ok( $dts->week_number(), '==', 8, 'week_number() on 1999-02-15 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-02-15 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-02-15 Gregorian' );

$epoch = timegm( 0, 0, 0, 16, 2 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 2,
	day	=> 16,
    ),
);
cmp_ok( $dts->day(), '==', 25, 'day() on 1999-02-16 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Highday', 'day_name() on 1999-02-16 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Highdei', 'day_name_trad() on 1999-02-16 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 25, 'day_of_month() on 1999-02-16 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 7, 'day_of_week() on 1999-02-16 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 56, 'day_of_year() on 1999-02-16 Gregorian' );
cmp_ok( $dts->dow(), '==', 7, 'dow() on 1999-02-16 Gregorian' );
cmp_ok( $dts->doy(), '==', 56, 'doy() on 1999-02-16 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-02-16 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-02-16 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-02-16 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-02-16 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-02-16 Gregorian' );
cmp_ok( $dts->mday(), '==', 25, 'mday() on 1999-02-16 Gregorian' );
cmp_ok( $dts->month(), '==', 2, 'month() on 1999-02-16 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Solmath', 'month_name() on 1999-02-16 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-02-16 Gregorian' );
Highday 25 Solmath 7463

The Company of the Ring pass the Argonath and camp at Parth Galen, 1419.
First battle of the Fords of Isen -- Theodred son of Theoden slain, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63054806400, 'utc_rd_as_seconds() on 1999-02-16 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729801,
  0,
  0
]
, 'utc_rd_values() on 1999-02-16 Gregorian' );
cmp_ok( $dts->wday(), '==', 7, 'wday() on 1999-02-16 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  8
]
, 'week() on 1999-02-16 Gregorian' );
cmp_ok( $dts->week_number(), '==', 8, 'week_number() on 1999-02-16 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-02-16 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-02-16 Gregorian' );

$epoch = timegm( 0, 0, 0, 17, 2 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 2,
	day	=> 17,
    ),
);
cmp_ok( $dts->day(), '==', 26, 'day() on 1999-02-17 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sterday', 'day_name() on 1999-02-17 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sterrendei', 'day_name_trad() on 1999-02-17 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 26, 'day_of_month() on 1999-02-17 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 1, 'day_of_week() on 1999-02-17 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 57, 'day_of_year() on 1999-02-17 Gregorian' );
cmp_ok( $dts->dow(), '==', 1, 'dow() on 1999-02-17 Gregorian' );
cmp_ok( $dts->doy(), '==', 57, 'doy() on 1999-02-17 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-02-17 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-02-17 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-02-17 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-02-17 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-02-17 Gregorian' );
cmp_ok( $dts->mday(), '==', 26, 'mday() on 1999-02-17 Gregorian' );
cmp_ok( $dts->month(), '==', 2, 'month() on 1999-02-17 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Solmath', 'month_name() on 1999-02-17 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-02-17 Gregorian' );
Sterday 26 Solmath 7463

Breaking of the Fellowship, 1419.
Death of Boromir; his horn is heard in Minas Tirith, 1419.
Meriadoc and Peregrin captured by Orcs -- Aragorn pursues, 1419.
Eomer hears of the descent of the Orc-band from Emyn Muil, 1419.
Frodo and Samwise enter the eastern Emyn Muil, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63054892800, 'utc_rd_as_seconds() on 1999-02-17 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729802,
  0,
  0
]
, 'utc_rd_values() on 1999-02-17 Gregorian' );
cmp_ok( $dts->wday(), '==', 1, 'wday() on 1999-02-17 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  9
]
, 'week() on 1999-02-17 Gregorian' );
cmp_ok( $dts->week_number(), '==', 9, 'week_number() on 1999-02-17 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-02-17 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-02-17 Gregorian' );

$epoch = timegm( 0, 0, 0, 18, 2 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 2,
	day	=> 18,
    ),
);
cmp_ok( $dts->day(), '==', 27, 'day() on 1999-02-18 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sunday', 'day_name() on 1999-02-18 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sunnendei', 'day_name_trad() on 1999-02-18 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 27, 'day_of_month() on 1999-02-18 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 2, 'day_of_week() on 1999-02-18 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 58, 'day_of_year() on 1999-02-18 Gregorian' );
cmp_ok( $dts->dow(), '==', 2, 'dow() on 1999-02-18 Gregorian' );
cmp_ok( $dts->doy(), '==', 58, 'doy() on 1999-02-18 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-02-18 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-02-18 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-02-18 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-02-18 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-02-18 Gregorian' );
cmp_ok( $dts->mday(), '==', 27, 'mday() on 1999-02-18 Gregorian' );
cmp_ok( $dts->month(), '==', 2, 'month() on 1999-02-18 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Solmath', 'month_name() on 1999-02-18 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-02-18 Gregorian' );
Sunday 27 Solmath 7463

Aragorn reaches the west-cliff at sunrise, 1419.
Eomer sets out from Eastfold against Theoden's orders to pursue the Orcs, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63054979200, 'utc_rd_as_seconds() on 1999-02-18 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729803,
  0,
  0
]
, 'utc_rd_values() on 1999-02-18 Gregorian' );
cmp_ok( $dts->wday(), '==', 2, 'wday() on 1999-02-18 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  9
]
, 'week() on 1999-02-18 Gregorian' );
cmp_ok( $dts->week_number(), '==', 9, 'week_number() on 1999-02-18 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-02-18 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-02-18 Gregorian' );

$epoch = timegm( 0, 0, 0, 19, 2 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 2,
	day	=> 19,
    ),
);
cmp_ok( $dts->day(), '==', 28, 'day() on 1999-02-19 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Monday', 'day_name() on 1999-02-19 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Monendei', 'day_name_trad() on 1999-02-19 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 28, 'day_of_month() on 1999-02-19 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 3, 'day_of_week() on 1999-02-19 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 59, 'day_of_year() on 1999-02-19 Gregorian' );
cmp_ok( $dts->dow(), '==', 3, 'dow() on 1999-02-19 Gregorian' );
cmp_ok( $dts->doy(), '==', 59, 'doy() on 1999-02-19 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-02-19 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-02-19 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-02-19 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-02-19 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-02-19 Gregorian' );
cmp_ok( $dts->mday(), '==', 28, 'mday() on 1999-02-19 Gregorian' );
cmp_ok( $dts->month(), '==', 2, 'month() on 1999-02-19 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Solmath', 'month_name() on 1999-02-19 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-02-19 Gregorian' );
Monday 28 Solmath 7463

Eomer overtakes the Orcs just outside of Fangorn Forest, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63055065600, 'utc_rd_as_seconds() on 1999-02-19 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729804,
  0,
  0
]
, 'utc_rd_values() on 1999-02-19 Gregorian' );
cmp_ok( $dts->wday(), '==', 3, 'wday() on 1999-02-19 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  9
]
, 'week() on 1999-02-19 Gregorian' );
cmp_ok( $dts->week_number(), '==', 9, 'week_number() on 1999-02-19 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-02-19 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-02-19 Gregorian' );

$epoch = timegm( 0, 0, 0, 20, 2 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 2,
	day	=> 20,
    ),
);
cmp_ok( $dts->day(), '==', 29, 'day() on 1999-02-20 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Trewsday', 'day_name() on 1999-02-20 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Trewesdei', 'day_name_trad() on 1999-02-20 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 29, 'day_of_month() on 1999-02-20 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 4, 'day_of_week() on 1999-02-20 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 60, 'day_of_year() on 1999-02-20 Gregorian' );
cmp_ok( $dts->dow(), '==', 4, 'dow() on 1999-02-20 Gregorian' );
cmp_ok( $dts->doy(), '==', 60, 'doy() on 1999-02-20 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-02-20 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-02-20 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-02-20 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-02-20 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-02-20 Gregorian' );
cmp_ok( $dts->mday(), '==', 29, 'mday() on 1999-02-20 Gregorian' );
cmp_ok( $dts->month(), '==', 2, 'month() on 1999-02-20 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Solmath', 'month_name() on 1999-02-20 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-02-20 Gregorian' );
Trewsday 29 Solmath 7463

Meriodoc and Pippin escape and meet Treebeard, 1419.
The Rohirrim attack at sunrise and destroy the Orcs, 1419.
Frodo descends from the Emyn Muil and meets Gollum, 1419.
Faramir sees the funeral boat of Boromir, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63055152000, 'utc_rd_as_seconds() on 1999-02-20 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729805,
  0,
  0
]
, 'utc_rd_values() on 1999-02-20 Gregorian' );
cmp_ok( $dts->wday(), '==', 4, 'wday() on 1999-02-20 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  9
]
, 'week() on 1999-02-20 Gregorian' );
cmp_ok( $dts->week_number(), '==', 9, 'week_number() on 1999-02-20 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-02-20 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-02-20 Gregorian' );

$epoch = timegm( 0, 0, 0, 21, 2 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 2,
	day	=> 21,
    ),
);
cmp_ok( $dts->day(), '==', 30, 'day() on 1999-02-21 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Hevensday', 'day_name() on 1999-02-21 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Hevenesdei', 'day_name_trad() on 1999-02-21 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 30, 'day_of_month() on 1999-02-21 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 5, 'day_of_week() on 1999-02-21 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 61, 'day_of_year() on 1999-02-21 Gregorian' );
cmp_ok( $dts->dow(), '==', 5, 'dow() on 1999-02-21 Gregorian' );
cmp_ok( $dts->doy(), '==', 61, 'doy() on 1999-02-21 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-02-21 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-02-21 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-02-21 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-02-21 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-02-21 Gregorian' );
cmp_ok( $dts->mday(), '==', 30, 'mday() on 1999-02-21 Gregorian' );
cmp_ok( $dts->month(), '==', 2, 'month() on 1999-02-21 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Solmath', 'month_name() on 1999-02-21 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-02-21 Gregorian' );
Hevensday 30 Solmath 7463

Entmoot begins, 1419.
Eomer, returning to Edoras, meets Aragorn, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63055238400, 'utc_rd_as_seconds() on 1999-02-21 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729806,
  0,
  0
]
, 'utc_rd_values() on 1999-02-21 Gregorian' );
cmp_ok( $dts->wday(), '==', 5, 'wday() on 1999-02-21 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  9
]
, 'week() on 1999-02-21 Gregorian' );
cmp_ok( $dts->week_number(), '==', 9, 'week_number() on 1999-02-21 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-02-21 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-02-21 Gregorian' );

$epoch = timegm( 0, 0, 0, 22, 2 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 2,
	day	=> 22,
    ),
);
cmp_ok( $dts->day(), '==', 1, 'day() on 1999-02-22 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Mersday', 'day_name() on 1999-02-22 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Meresdei', 'day_name_trad() on 1999-02-22 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 1, 'day_of_month() on 1999-02-22 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 6, 'day_of_week() on 1999-02-22 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 62, 'day_of_year() on 1999-02-22 Gregorian' );
cmp_ok( $dts->dow(), '==', 6, 'dow() on 1999-02-22 Gregorian' );
cmp_ok( $dts->doy(), '==', 62, 'doy() on 1999-02-22 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-02-22 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-02-22 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-02-22 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-02-22 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-02-22 Gregorian' );
cmp_ok( $dts->mday(), '==', 1, 'mday() on 1999-02-22 Gregorian' );
cmp_ok( $dts->month(), '==', 3, 'month() on 1999-02-22 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Rethe', 'month_name() on 1999-02-22 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-02-22 Gregorian' );
Mersday 1 Rethe 7463

Aragorn meets Gandalf the White, and they set out for Edoras, 1419.
Faramir leaves Minas Tirith on an errand to Ithilien, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63055324800, 'utc_rd_as_seconds() on 1999-02-22 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729807,
  0,
  0
]
, 'utc_rd_values() on 1999-02-22 Gregorian' );
cmp_ok( $dts->wday(), '==', 6, 'wday() on 1999-02-22 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  9
]
, 'week() on 1999-02-22 Gregorian' );
cmp_ok( $dts->week_number(), '==', 9, 'week_number() on 1999-02-22 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-02-22 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-02-22 Gregorian' );

$epoch = timegm( 0, 0, 0, 23, 2 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 2,
	day	=> 23,
    ),
);
cmp_ok( $dts->day(), '==', 2, 'day() on 1999-02-23 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Highday', 'day_name() on 1999-02-23 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Highdei', 'day_name_trad() on 1999-02-23 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 2, 'day_of_month() on 1999-02-23 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 7, 'day_of_week() on 1999-02-23 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 63, 'day_of_year() on 1999-02-23 Gregorian' );
cmp_ok( $dts->dow(), '==', 7, 'dow() on 1999-02-23 Gregorian' );
cmp_ok( $dts->doy(), '==', 63, 'doy() on 1999-02-23 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-02-23 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-02-23 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-02-23 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-02-23 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-02-23 Gregorian' );
cmp_ok( $dts->mday(), '==', 2, 'mday() on 1999-02-23 Gregorian' );
cmp_ok( $dts->month(), '==', 3, 'month() on 1999-02-23 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Rethe', 'month_name() on 1999-02-23 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-02-23 Gregorian' );
Highday 2 Rethe 7463

The Rohirrim ride west against Saruman, 1419.
Second battle at the Fords of Isen; Erkenbrand defeated, 1419.
Entmoot ends.  Ents march on Isengard and reach it at night, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63055411200, 'utc_rd_as_seconds() on 1999-02-23 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729808,
  0,
  0
]
, 'utc_rd_values() on 1999-02-23 Gregorian' );
cmp_ok( $dts->wday(), '==', 7, 'wday() on 1999-02-23 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  9
]
, 'week() on 1999-02-23 Gregorian' );
cmp_ok( $dts->week_number(), '==', 9, 'week_number() on 1999-02-23 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-02-23 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-02-23 Gregorian' );

$epoch = timegm( 0, 0, 0, 24, 2 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 2,
	day	=> 24,
    ),
);
cmp_ok( $dts->day(), '==', 3, 'day() on 1999-02-24 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sterday', 'day_name() on 1999-02-24 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sterrendei', 'day_name_trad() on 1999-02-24 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 3, 'day_of_month() on 1999-02-24 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 1, 'day_of_week() on 1999-02-24 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 64, 'day_of_year() on 1999-02-24 Gregorian' );
cmp_ok( $dts->dow(), '==', 1, 'dow() on 1999-02-24 Gregorian' );
cmp_ok( $dts->doy(), '==', 64, 'doy() on 1999-02-24 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-02-24 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-02-24 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-02-24 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-02-24 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-02-24 Gregorian' );
cmp_ok( $dts->mday(), '==', 3, 'mday() on 1999-02-24 Gregorian' );
cmp_ok( $dts->month(), '==', 3, 'month() on 1999-02-24 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Rethe', 'month_name() on 1999-02-24 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-02-24 Gregorian' );
Sterday 3 Rethe 7463

Theoden retreats to Helm's Deep; battle of the Hornburg begins, 1419.
Ents complete the destruction of Isengard.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63055497600, 'utc_rd_as_seconds() on 1999-02-24 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729809,
  0,
  0
]
, 'utc_rd_values() on 1999-02-24 Gregorian' );
cmp_ok( $dts->wday(), '==', 1, 'wday() on 1999-02-24 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  10
]
, 'week() on 1999-02-24 Gregorian' );
cmp_ok( $dts->week_number(), '==', 10, 'week_number() on 1999-02-24 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-02-24 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-02-24 Gregorian' );

$epoch = timegm( 0, 0, 0, 25, 2 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 2,
	day	=> 25,
    ),
);
cmp_ok( $dts->day(), '==', 4, 'day() on 1999-02-25 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sunday', 'day_name() on 1999-02-25 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sunnendei', 'day_name_trad() on 1999-02-25 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 4, 'day_of_month() on 1999-02-25 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 2, 'day_of_week() on 1999-02-25 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 65, 'day_of_year() on 1999-02-25 Gregorian' );
cmp_ok( $dts->dow(), '==', 2, 'dow() on 1999-02-25 Gregorian' );
cmp_ok( $dts->doy(), '==', 65, 'doy() on 1999-02-25 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-02-25 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-02-25 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-02-25 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-02-25 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-02-25 Gregorian' );
cmp_ok( $dts->mday(), '==', 4, 'mday() on 1999-02-25 Gregorian' );
cmp_ok( $dts->month(), '==', 3, 'month() on 1999-02-25 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Rethe', 'month_name() on 1999-02-25 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-02-25 Gregorian' );
Sunday 4 Rethe 7463

Theoden and Gandalf set out from Helm's Deep for Isengard, 1419.
Frodo reaches the slag mound on the edge of the of the Morannon, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63055584000, 'utc_rd_as_seconds() on 1999-02-25 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729810,
  0,
  0
]
, 'utc_rd_values() on 1999-02-25 Gregorian' );
cmp_ok( $dts->wday(), '==', 2, 'wday() on 1999-02-25 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  10
]
, 'week() on 1999-02-25 Gregorian' );
cmp_ok( $dts->week_number(), '==', 10, 'week_number() on 1999-02-25 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-02-25 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-02-25 Gregorian' );

$epoch = timegm( 0, 0, 0, 26, 2 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 2,
	day	=> 26,
    ),
);
cmp_ok( $dts->day(), '==', 5, 'day() on 1999-02-26 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Monday', 'day_name() on 1999-02-26 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Monendei', 'day_name_trad() on 1999-02-26 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 5, 'day_of_month() on 1999-02-26 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 3, 'day_of_week() on 1999-02-26 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 66, 'day_of_year() on 1999-02-26 Gregorian' );
cmp_ok( $dts->dow(), '==', 3, 'dow() on 1999-02-26 Gregorian' );
cmp_ok( $dts->doy(), '==', 66, 'doy() on 1999-02-26 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-02-26 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-02-26 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-02-26 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-02-26 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-02-26 Gregorian' );
cmp_ok( $dts->mday(), '==', 5, 'mday() on 1999-02-26 Gregorian' );
cmp_ok( $dts->month(), '==', 3, 'month() on 1999-02-26 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Rethe', 'month_name() on 1999-02-26 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-02-26 Gregorian' );
Monday 5 Rethe 7463

Theoden reaches Isengard at noon; parley with Saruman in Orthanc, 1419.
Gandalf sets out with Peregrin for Minas Tirith, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63055670400, 'utc_rd_as_seconds() on 1999-02-26 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729811,
  0,
  0
]
, 'utc_rd_values() on 1999-02-26 Gregorian' );
cmp_ok( $dts->wday(), '==', 3, 'wday() on 1999-02-26 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  10
]
, 'week() on 1999-02-26 Gregorian' );
cmp_ok( $dts->week_number(), '==', 10, 'week_number() on 1999-02-26 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-02-26 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-02-26 Gregorian' );

$epoch = timegm( 0, 0, 0, 27, 2 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 2,
	day	=> 27,
    ),
);
cmp_ok( $dts->day(), '==', 6, 'day() on 1999-02-27 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Trewsday', 'day_name() on 1999-02-27 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Trewesdei', 'day_name_trad() on 1999-02-27 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 6, 'day_of_month() on 1999-02-27 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 4, 'day_of_week() on 1999-02-27 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 67, 'day_of_year() on 1999-02-27 Gregorian' );
cmp_ok( $dts->dow(), '==', 4, 'dow() on 1999-02-27 Gregorian' );
cmp_ok( $dts->doy(), '==', 67, 'doy() on 1999-02-27 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-02-27 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-02-27 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-02-27 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-02-27 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-02-27 Gregorian' );
cmp_ok( $dts->mday(), '==', 6, 'mday() on 1999-02-27 Gregorian' );
cmp_ok( $dts->month(), '==', 3, 'month() on 1999-02-27 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Rethe', 'month_name() on 1999-02-27 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-02-27 Gregorian' );
Trewsday 6 Rethe 7463

Aragorn overtaken by the Dunedain in the early hours, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63055756800, 'utc_rd_as_seconds() on 1999-02-27 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729812,
  0,
  0
]
, 'utc_rd_values() on 1999-02-27 Gregorian' );
cmp_ok( $dts->wday(), '==', 4, 'wday() on 1999-02-27 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  10
]
, 'week() on 1999-02-27 Gregorian' );
cmp_ok( $dts->week_number(), '==', 10, 'week_number() on 1999-02-27 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-02-27 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-02-27 Gregorian' );

$epoch = timegm( 0, 0, 0, 28, 2 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 2,
	day	=> 28,
    ),
);
cmp_ok( $dts->day(), '==', 7, 'day() on 1999-02-28 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Hevensday', 'day_name() on 1999-02-28 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Hevenesdei', 'day_name_trad() on 1999-02-28 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 7, 'day_of_month() on 1999-02-28 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 5, 'day_of_week() on 1999-02-28 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 68, 'day_of_year() on 1999-02-28 Gregorian' );
cmp_ok( $dts->dow(), '==', 5, 'dow() on 1999-02-28 Gregorian' );
cmp_ok( $dts->doy(), '==', 68, 'doy() on 1999-02-28 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-02-28 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-02-28 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-02-28 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-02-28 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-02-28 Gregorian' );
cmp_ok( $dts->mday(), '==', 7, 'mday() on 1999-02-28 Gregorian' );
cmp_ok( $dts->month(), '==', 3, 'month() on 1999-02-28 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Rethe', 'month_name() on 1999-02-28 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-02-28 Gregorian' );
Hevensday 7 Rethe 7463

Frodo taken by Faramir to Henneth Annun, 1419.
Aragorn comes to Dunharrow at nightfall, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63055843200, 'utc_rd_as_seconds() on 1999-02-28 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729813,
  0,
  0
]
, 'utc_rd_values() on 1999-02-28 Gregorian' );
cmp_ok( $dts->wday(), '==', 5, 'wday() on 1999-02-28 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  10
]
, 'week() on 1999-02-28 Gregorian' );
cmp_ok( $dts->week_number(), '==', 10, 'week_number() on 1999-02-28 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-02-28 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-02-28 Gregorian' );

$epoch = timegm( 0, 0, 0, 1, 3 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 3,
	day	=> 1,
    ),
);
cmp_ok( $dts->day(), '==', 8, 'day() on 1999-03-01 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Mersday', 'day_name() on 1999-03-01 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Meresdei', 'day_name_trad() on 1999-03-01 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 8, 'day_of_month() on 1999-03-01 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 6, 'day_of_week() on 1999-03-01 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 69, 'day_of_year() on 1999-03-01 Gregorian' );
cmp_ok( $dts->dow(), '==', 6, 'dow() on 1999-03-01 Gregorian' );
cmp_ok( $dts->doy(), '==', 69, 'doy() on 1999-03-01 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-03-01 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-03-01 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-03-01 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-03-01 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-03-01 Gregorian' );
cmp_ok( $dts->mday(), '==', 8, 'mday() on 1999-03-01 Gregorian' );
cmp_ok( $dts->month(), '==', 3, 'month() on 1999-03-01 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Rethe', 'month_name() on 1999-03-01 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-03-01 Gregorian' );
Mersday 8 Rethe 7463

Aragorn takes the "Paths of the Dead", and reaches Erech at midnight, 1419.
Frodo leaves Henneth Annun, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63055929600, 'utc_rd_as_seconds() on 1999-03-01 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729814,
  0,
  0
]
, 'utc_rd_values() on 1999-03-01 Gregorian' );
cmp_ok( $dts->wday(), '==', 6, 'wday() on 1999-03-01 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  10
]
, 'week() on 1999-03-01 Gregorian' );
cmp_ok( $dts->week_number(), '==', 10, 'week_number() on 1999-03-01 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-03-01 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-03-01 Gregorian' );

$epoch = timegm( 0, 0, 0, 2, 3 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 3,
	day	=> 2,
    ),
);
cmp_ok( $dts->day(), '==', 9, 'day() on 1999-03-02 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Highday', 'day_name() on 1999-03-02 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Highdei', 'day_name_trad() on 1999-03-02 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 9, 'day_of_month() on 1999-03-02 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 7, 'day_of_week() on 1999-03-02 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 70, 'day_of_year() on 1999-03-02 Gregorian' );
cmp_ok( $dts->dow(), '==', 7, 'dow() on 1999-03-02 Gregorian' );
cmp_ok( $dts->doy(), '==', 70, 'doy() on 1999-03-02 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-03-02 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-03-02 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-03-02 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-03-02 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-03-02 Gregorian' );
cmp_ok( $dts->mday(), '==', 9, 'mday() on 1999-03-02 Gregorian' );
cmp_ok( $dts->month(), '==', 3, 'month() on 1999-03-02 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Rethe', 'month_name() on 1999-03-02 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-03-02 Gregorian' );
Highday 9 Rethe 7463

Gandalf reaches Minas Tirith, 1419.
Darkness begins to flow out of Mordor, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63056016000, 'utc_rd_as_seconds() on 1999-03-02 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729815,
  0,
  0
]
, 'utc_rd_values() on 1999-03-02 Gregorian' );
cmp_ok( $dts->wday(), '==', 7, 'wday() on 1999-03-02 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  10
]
, 'week() on 1999-03-02 Gregorian' );
cmp_ok( $dts->week_number(), '==', 10, 'week_number() on 1999-03-02 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-03-02 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-03-02 Gregorian' );

$epoch = timegm( 0, 0, 0, 3, 3 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 3,
	day	=> 3,
    ),
);
cmp_ok( $dts->day(), '==', 10, 'day() on 1999-03-03 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sterday', 'day_name() on 1999-03-03 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sterrendei', 'day_name_trad() on 1999-03-03 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 10, 'day_of_month() on 1999-03-03 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 1, 'day_of_week() on 1999-03-03 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 71, 'day_of_year() on 1999-03-03 Gregorian' );
cmp_ok( $dts->dow(), '==', 1, 'dow() on 1999-03-03 Gregorian' );
cmp_ok( $dts->doy(), '==', 71, 'doy() on 1999-03-03 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-03-03 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-03-03 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-03-03 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-03-03 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-03-03 Gregorian' );
cmp_ok( $dts->mday(), '==', 10, 'mday() on 1999-03-03 Gregorian' );
cmp_ok( $dts->month(), '==', 3, 'month() on 1999-03-03 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Rethe', 'month_name() on 1999-03-03 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-03-03 Gregorian' );
Sterday 10 Rethe 7463

The Dawnless Day, 1419.
The Rohirrim are mustered and ride from Harrowdale, 1419.
Faramir rescued by Gandalf at the gates of Minas Tirith, 1419.
An army from the Morannon takes Cair Andros and passes into Anorien, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63056102400, 'utc_rd_as_seconds() on 1999-03-03 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729816,
  0,
  0
]
, 'utc_rd_values() on 1999-03-03 Gregorian' );
cmp_ok( $dts->wday(), '==', 1, 'wday() on 1999-03-03 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  11
]
, 'week() on 1999-03-03 Gregorian' );
cmp_ok( $dts->week_number(), '==', 11, 'week_number() on 1999-03-03 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-03-03 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-03-03 Gregorian' );

$epoch = timegm( 0, 0, 0, 4, 3 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 3,
	day	=> 4,
    ),
);
cmp_ok( $dts->day(), '==', 11, 'day() on 1999-03-04 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sunday', 'day_name() on 1999-03-04 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sunnendei', 'day_name_trad() on 1999-03-04 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 11, 'day_of_month() on 1999-03-04 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 2, 'day_of_week() on 1999-03-04 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 72, 'day_of_year() on 1999-03-04 Gregorian' );
cmp_ok( $dts->dow(), '==', 2, 'dow() on 1999-03-04 Gregorian' );
cmp_ok( $dts->doy(), '==', 72, 'doy() on 1999-03-04 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-03-04 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-03-04 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-03-04 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-03-04 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-03-04 Gregorian' );
cmp_ok( $dts->mday(), '==', 11, 'mday() on 1999-03-04 Gregorian' );
cmp_ok( $dts->month(), '==', 3, 'month() on 1999-03-04 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Rethe', 'month_name() on 1999-03-04 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-03-04 Gregorian' );
Sunday 11 Rethe 7463

Gollum visits Shelob, 1419.
Denethor sends Faramir to Osgiliath, 1419.
Eastern Rohan is invaded and Lorien assaulted, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63056188800, 'utc_rd_as_seconds() on 1999-03-04 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729817,
  0,
  0
]
, 'utc_rd_values() on 1999-03-04 Gregorian' );
cmp_ok( $dts->wday(), '==', 2, 'wday() on 1999-03-04 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  11
]
, 'week() on 1999-03-04 Gregorian' );
cmp_ok( $dts->week_number(), '==', 11, 'week_number() on 1999-03-04 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-03-04 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-03-04 Gregorian' );

$epoch = timegm( 0, 0, 0, 5, 3 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 3,
	day	=> 5,
    ),
);
cmp_ok( $dts->day(), '==', 12, 'day() on 1999-03-05 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Monday', 'day_name() on 1999-03-05 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Monendei', 'day_name_trad() on 1999-03-05 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 12, 'day_of_month() on 1999-03-05 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 3, 'day_of_week() on 1999-03-05 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 73, 'day_of_year() on 1999-03-05 Gregorian' );
cmp_ok( $dts->dow(), '==', 3, 'dow() on 1999-03-05 Gregorian' );
cmp_ok( $dts->doy(), '==', 73, 'doy() on 1999-03-05 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-03-05 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-03-05 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-03-05 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-03-05 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-03-05 Gregorian' );
cmp_ok( $dts->mday(), '==', 12, 'mday() on 1999-03-05 Gregorian' );
cmp_ok( $dts->month(), '==', 3, 'month() on 1999-03-05 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Rethe', 'month_name() on 1999-03-05 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-03-05 Gregorian' );
Monday 12 Rethe 7463

Gollum leads Frodo into Shelob's lair, 1419.
Ents defeat the invaders of Rohan, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63056275200, 'utc_rd_as_seconds() on 1999-03-05 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729818,
  0,
  0
]
, 'utc_rd_values() on 1999-03-05 Gregorian' );
cmp_ok( $dts->wday(), '==', 3, 'wday() on 1999-03-05 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  11
]
, 'week() on 1999-03-05 Gregorian' );
cmp_ok( $dts->week_number(), '==', 11, 'week_number() on 1999-03-05 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-03-05 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-03-05 Gregorian' );

$epoch = timegm( 0, 0, 0, 6, 3 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 3,
	day	=> 6,
    ),
);
cmp_ok( $dts->day(), '==', 13, 'day() on 1999-03-06 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Trewsday', 'day_name() on 1999-03-06 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Trewesdei', 'day_name_trad() on 1999-03-06 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 13, 'day_of_month() on 1999-03-06 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 4, 'day_of_week() on 1999-03-06 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 74, 'day_of_year() on 1999-03-06 Gregorian' );
cmp_ok( $dts->dow(), '==', 4, 'dow() on 1999-03-06 Gregorian' );
cmp_ok( $dts->doy(), '==', 74, 'doy() on 1999-03-06 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-03-06 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-03-06 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-03-06 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-03-06 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-03-06 Gregorian' );
cmp_ok( $dts->mday(), '==', 13, 'mday() on 1999-03-06 Gregorian' );
cmp_ok( $dts->month(), '==', 3, 'month() on 1999-03-06 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Rethe', 'month_name() on 1999-03-06 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-03-06 Gregorian' );
Trewsday 13 Rethe 7463

Frodo captured by the Orcs of Cirith Ungol, 1419.
The Pelennor is overrun and Faramir is wounded, 1419.
Aragorn reaches Pelargir and captures the fleet of Umbar, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63056361600, 'utc_rd_as_seconds() on 1999-03-06 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729819,
  0,
  0
]
, 'utc_rd_values() on 1999-03-06 Gregorian' );
cmp_ok( $dts->wday(), '==', 4, 'wday() on 1999-03-06 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  11
]
, 'week() on 1999-03-06 Gregorian' );
cmp_ok( $dts->week_number(), '==', 11, 'week_number() on 1999-03-06 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-03-06 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-03-06 Gregorian' );

$epoch = timegm( 0, 0, 0, 7, 3 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 3,
	day	=> 7,
    ),
);
cmp_ok( $dts->day(), '==', 14, 'day() on 1999-03-07 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Hevensday', 'day_name() on 1999-03-07 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Hevenesdei', 'day_name_trad() on 1999-03-07 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 14, 'day_of_month() on 1999-03-07 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 5, 'day_of_week() on 1999-03-07 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 75, 'day_of_year() on 1999-03-07 Gregorian' );
cmp_ok( $dts->dow(), '==', 5, 'dow() on 1999-03-07 Gregorian' );
cmp_ok( $dts->doy(), '==', 75, 'doy() on 1999-03-07 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-03-07 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-03-07 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-03-07 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-03-07 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-03-07 Gregorian' );
cmp_ok( $dts->mday(), '==', 14, 'mday() on 1999-03-07 Gregorian' );
cmp_ok( $dts->month(), '==', 3, 'month() on 1999-03-07 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Rethe', 'month_name() on 1999-03-07 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-03-07 Gregorian' );
Hevensday 14 Rethe 7463

Samwise finds Frodo in the tower of Cirith Ungol, 1419.
Minas Tirith besieged, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63056448000, 'utc_rd_as_seconds() on 1999-03-07 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729820,
  0,
  0
]
, 'utc_rd_values() on 1999-03-07 Gregorian' );
cmp_ok( $dts->wday(), '==', 5, 'wday() on 1999-03-07 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  11
]
, 'week() on 1999-03-07 Gregorian' );
cmp_ok( $dts->week_number(), '==', 11, 'week_number() on 1999-03-07 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-03-07 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-03-07 Gregorian' );

$epoch = timegm( 0, 0, 0, 8, 3 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 3,
	day	=> 8,
    ),
);
cmp_ok( $dts->day(), '==', 15, 'day() on 1999-03-08 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Mersday', 'day_name() on 1999-03-08 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Meresdei', 'day_name_trad() on 1999-03-08 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 15, 'day_of_month() on 1999-03-08 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 6, 'day_of_week() on 1999-03-08 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 76, 'day_of_year() on 1999-03-08 Gregorian' );
cmp_ok( $dts->dow(), '==', 6, 'dow() on 1999-03-08 Gregorian' );
cmp_ok( $dts->doy(), '==', 76, 'doy() on 1999-03-08 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-03-08 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-03-08 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-03-08 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-03-08 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-03-08 Gregorian' );
cmp_ok( $dts->mday(), '==', 15, 'mday() on 1999-03-08 Gregorian' );
cmp_ok( $dts->month(), '==', 3, 'month() on 1999-03-08 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Rethe', 'month_name() on 1999-03-08 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-03-08 Gregorian' );
Mersday 15 Rethe 7463

Witch King breaks the gates of Minas Tirith, 1419.
Denethor, Steward of Gondor, burns himself on a pyre, 1419.
The battle of the Pelennor occurs as Theoden and Aragorn arrive, 1419.
Thranduil repels the forces of Dol Guldur in Mirkwood, 1419.
Lorien assaulted for second time, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63056534400, 'utc_rd_as_seconds() on 1999-03-08 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729821,
  0,
  0
]
, 'utc_rd_values() on 1999-03-08 Gregorian' );
cmp_ok( $dts->wday(), '==', 6, 'wday() on 1999-03-08 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  11
]
, 'week() on 1999-03-08 Gregorian' );
cmp_ok( $dts->week_number(), '==', 11, 'week_number() on 1999-03-08 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-03-08 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-03-08 Gregorian' );

$epoch = timegm( 0, 0, 0, 9, 3 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 3,
	day	=> 9,
    ),
);
cmp_ok( $dts->day(), '==', 16, 'day() on 1999-03-09 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Highday', 'day_name() on 1999-03-09 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Highdei', 'day_name_trad() on 1999-03-09 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 16, 'day_of_month() on 1999-03-09 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 7, 'day_of_week() on 1999-03-09 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 77, 'day_of_year() on 1999-03-09 Gregorian' );
cmp_ok( $dts->dow(), '==', 7, 'dow() on 1999-03-09 Gregorian' );
cmp_ok( $dts->doy(), '==', 77, 'doy() on 1999-03-09 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-03-09 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-03-09 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-03-09 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-03-09 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-03-09 Gregorian' );
cmp_ok( $dts->mday(), '==', 16, 'mday() on 1999-03-09 Gregorian' );
cmp_ok( $dts->month(), '==', 3, 'month() on 1999-03-09 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Rethe', 'month_name() on 1999-03-09 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-03-09 Gregorian' );
Highday 16 Rethe 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63056620800, 'utc_rd_as_seconds() on 1999-03-09 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729822,
  0,
  0
]
, 'utc_rd_values() on 1999-03-09 Gregorian' );
cmp_ok( $dts->wday(), '==', 7, 'wday() on 1999-03-09 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  11
]
, 'week() on 1999-03-09 Gregorian' );
cmp_ok( $dts->week_number(), '==', 11, 'week_number() on 1999-03-09 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-03-09 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-03-09 Gregorian' );

$epoch = timegm( 0, 0, 0, 10, 3 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 3,
	day	=> 10,
    ),
);
cmp_ok( $dts->day(), '==', 17, 'day() on 1999-03-10 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sterday', 'day_name() on 1999-03-10 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sterrendei', 'day_name_trad() on 1999-03-10 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 17, 'day_of_month() on 1999-03-10 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 1, 'day_of_week() on 1999-03-10 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 78, 'day_of_year() on 1999-03-10 Gregorian' );
cmp_ok( $dts->dow(), '==', 1, 'dow() on 1999-03-10 Gregorian' );
cmp_ok( $dts->doy(), '==', 78, 'doy() on 1999-03-10 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-03-10 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-03-10 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-03-10 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-03-10 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-03-10 Gregorian' );
cmp_ok( $dts->mday(), '==', 17, 'mday() on 1999-03-10 Gregorian' );
cmp_ok( $dts->month(), '==', 3, 'month() on 1999-03-10 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Rethe', 'month_name() on 1999-03-10 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-03-10 Gregorian' );
Sterday 17 Rethe 7463

Battle of Dale, where King Brand and King Dain Ironfoot fall, 1419.
Shagrat brings Frodo's cloak, mail-shirt, and sword to Barad-dur, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63056707200, 'utc_rd_as_seconds() on 1999-03-10 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729823,
  0,
  0
]
, 'utc_rd_values() on 1999-03-10 Gregorian' );
cmp_ok( $dts->wday(), '==', 1, 'wday() on 1999-03-10 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  12
]
, 'week() on 1999-03-10 Gregorian' );
cmp_ok( $dts->week_number(), '==', 12, 'week_number() on 1999-03-10 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-03-10 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-03-10 Gregorian' );

$epoch = timegm( 0, 0, 0, 11, 3 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 3,
	day	=> 11,
    ),
);
cmp_ok( $dts->day(), '==', 18, 'day() on 1999-03-11 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sunday', 'day_name() on 1999-03-11 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sunnendei', 'day_name_trad() on 1999-03-11 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 18, 'day_of_month() on 1999-03-11 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 2, 'day_of_week() on 1999-03-11 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 79, 'day_of_year() on 1999-03-11 Gregorian' );
cmp_ok( $dts->dow(), '==', 2, 'dow() on 1999-03-11 Gregorian' );
cmp_ok( $dts->doy(), '==', 79, 'doy() on 1999-03-11 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-03-11 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-03-11 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-03-11 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-03-11 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-03-11 Gregorian' );
cmp_ok( $dts->mday(), '==', 18, 'mday() on 1999-03-11 Gregorian' );
cmp_ok( $dts->month(), '==', 3, 'month() on 1999-03-11 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Rethe', 'month_name() on 1999-03-11 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-03-11 Gregorian' );
Sunday 18 Rethe 7463

Host of the west leaves Minas Tirith, 1419.
Frodo and Sam overtaken by Orcs on the road from Durthang to Udun, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63056793600, 'utc_rd_as_seconds() on 1999-03-11 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729824,
  0,
  0
]
, 'utc_rd_values() on 1999-03-11 Gregorian' );
cmp_ok( $dts->wday(), '==', 2, 'wday() on 1999-03-11 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  12
]
, 'week() on 1999-03-11 Gregorian' );
cmp_ok( $dts->week_number(), '==', 12, 'week_number() on 1999-03-11 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-03-11 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-03-11 Gregorian' );

$epoch = timegm( 0, 0, 0, 12, 3 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 3,
	day	=> 12,
    ),
);
cmp_ok( $dts->day(), '==', 19, 'day() on 1999-03-12 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Monday', 'day_name() on 1999-03-12 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Monendei', 'day_name_trad() on 1999-03-12 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 19, 'day_of_month() on 1999-03-12 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 3, 'day_of_week() on 1999-03-12 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 80, 'day_of_year() on 1999-03-12 Gregorian' );
cmp_ok( $dts->dow(), '==', 3, 'dow() on 1999-03-12 Gregorian' );
cmp_ok( $dts->doy(), '==', 80, 'doy() on 1999-03-12 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-03-12 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-03-12 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-03-12 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-03-12 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-03-12 Gregorian' );
cmp_ok( $dts->mday(), '==', 19, 'mday() on 1999-03-12 Gregorian' );
cmp_ok( $dts->month(), '==', 3, 'month() on 1999-03-12 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Rethe', 'month_name() on 1999-03-12 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-03-12 Gregorian' );
Monday 19 Rethe 7463

Frodo and Sam escape the Orcs and start on the road toward Mount Doom, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63056880000, 'utc_rd_as_seconds() on 1999-03-12 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729825,
  0,
  0
]
, 'utc_rd_values() on 1999-03-12 Gregorian' );
cmp_ok( $dts->wday(), '==', 3, 'wday() on 1999-03-12 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  12
]
, 'week() on 1999-03-12 Gregorian' );
cmp_ok( $dts->week_number(), '==', 12, 'week_number() on 1999-03-12 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-03-12 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-03-12 Gregorian' );

$epoch = timegm( 0, 0, 0, 13, 3 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 3,
	day	=> 13,
    ),
);
cmp_ok( $dts->day(), '==', 20, 'day() on 1999-03-13 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Trewsday', 'day_name() on 1999-03-13 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Trewesdei', 'day_name_trad() on 1999-03-13 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 20, 'day_of_month() on 1999-03-13 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 4, 'day_of_week() on 1999-03-13 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 81, 'day_of_year() on 1999-03-13 Gregorian' );
cmp_ok( $dts->dow(), '==', 4, 'dow() on 1999-03-13 Gregorian' );
cmp_ok( $dts->doy(), '==', 81, 'doy() on 1999-03-13 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-03-13 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-03-13 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-03-13 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-03-13 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-03-13 Gregorian' );
cmp_ok( $dts->mday(), '==', 20, 'mday() on 1999-03-13 Gregorian' );
cmp_ok( $dts->month(), '==', 3, 'month() on 1999-03-13 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Rethe', 'month_name() on 1999-03-13 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-03-13 Gregorian' );
Trewsday 20 Rethe 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63056966400, 'utc_rd_as_seconds() on 1999-03-13 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729826,
  0,
  0
]
, 'utc_rd_values() on 1999-03-13 Gregorian' );
cmp_ok( $dts->wday(), '==', 4, 'wday() on 1999-03-13 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  12
]
, 'week() on 1999-03-13 Gregorian' );
cmp_ok( $dts->week_number(), '==', 12, 'week_number() on 1999-03-13 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-03-13 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-03-13 Gregorian' );

$epoch = timegm( 0, 0, 0, 14, 3 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 3,
	day	=> 14,
    ),
);
cmp_ok( $dts->day(), '==', 21, 'day() on 1999-03-14 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Hevensday', 'day_name() on 1999-03-14 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Hevenesdei', 'day_name_trad() on 1999-03-14 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 21, 'day_of_month() on 1999-03-14 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 5, 'day_of_week() on 1999-03-14 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 82, 'day_of_year() on 1999-03-14 Gregorian' );
cmp_ok( $dts->dow(), '==', 5, 'dow() on 1999-03-14 Gregorian' );
cmp_ok( $dts->doy(), '==', 82, 'doy() on 1999-03-14 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-03-14 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-03-14 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-03-14 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-03-14 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-03-14 Gregorian' );
cmp_ok( $dts->mday(), '==', 21, 'mday() on 1999-03-14 Gregorian' );
cmp_ok( $dts->month(), '==', 3, 'month() on 1999-03-14 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Rethe', 'month_name() on 1999-03-14 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-03-14 Gregorian' );
Hevensday 21 Rethe 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63057052800, 'utc_rd_as_seconds() on 1999-03-14 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729827,
  0,
  0
]
, 'utc_rd_values() on 1999-03-14 Gregorian' );
cmp_ok( $dts->wday(), '==', 5, 'wday() on 1999-03-14 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  12
]
, 'week() on 1999-03-14 Gregorian' );
cmp_ok( $dts->week_number(), '==', 12, 'week_number() on 1999-03-14 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-03-14 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-03-14 Gregorian' );

$epoch = timegm( 0, 0, 0, 15, 3 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 3,
	day	=> 15,
    ),
);
cmp_ok( $dts->day(), '==', 22, 'day() on 1999-03-15 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Mersday', 'day_name() on 1999-03-15 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Meresdei', 'day_name_trad() on 1999-03-15 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 22, 'day_of_month() on 1999-03-15 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 6, 'day_of_week() on 1999-03-15 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 83, 'day_of_year() on 1999-03-15 Gregorian' );
cmp_ok( $dts->dow(), '==', 6, 'dow() on 1999-03-15 Gregorian' );
cmp_ok( $dts->doy(), '==', 83, 'doy() on 1999-03-15 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-03-15 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-03-15 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-03-15 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-03-15 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-03-15 Gregorian' );
cmp_ok( $dts->mday(), '==', 22, 'mday() on 1999-03-15 Gregorian' );
cmp_ok( $dts->month(), '==', 3, 'month() on 1999-03-15 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Rethe', 'month_name() on 1999-03-15 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-03-15 Gregorian' );
Mersday 22 Rethe 7463

Lorien assaulted for the third time, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63057139200, 'utc_rd_as_seconds() on 1999-03-15 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729828,
  0,
  0
]
, 'utc_rd_values() on 1999-03-15 Gregorian' );
cmp_ok( $dts->wday(), '==', 6, 'wday() on 1999-03-15 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  12
]
, 'week() on 1999-03-15 Gregorian' );
cmp_ok( $dts->week_number(), '==', 12, 'week_number() on 1999-03-15 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-03-15 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-03-15 Gregorian' );

$epoch = timegm( 0, 0, 0, 16, 3 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 3,
	day	=> 16,
    ),
);
cmp_ok( $dts->day(), '==', 23, 'day() on 1999-03-16 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Highday', 'day_name() on 1999-03-16 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Highdei', 'day_name_trad() on 1999-03-16 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 23, 'day_of_month() on 1999-03-16 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 7, 'day_of_week() on 1999-03-16 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 84, 'day_of_year() on 1999-03-16 Gregorian' );
cmp_ok( $dts->dow(), '==', 7, 'dow() on 1999-03-16 Gregorian' );
cmp_ok( $dts->doy(), '==', 84, 'doy() on 1999-03-16 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-03-16 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-03-16 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-03-16 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-03-16 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-03-16 Gregorian' );
cmp_ok( $dts->mday(), '==', 23, 'mday() on 1999-03-16 Gregorian' );
cmp_ok( $dts->month(), '==', 3, 'month() on 1999-03-16 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Rethe', 'month_name() on 1999-03-16 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-03-16 Gregorian' );
Highday 23 Rethe 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63057225600, 'utc_rd_as_seconds() on 1999-03-16 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729829,
  0,
  0
]
, 'utc_rd_values() on 1999-03-16 Gregorian' );
cmp_ok( $dts->wday(), '==', 7, 'wday() on 1999-03-16 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  12
]
, 'week() on 1999-03-16 Gregorian' );
cmp_ok( $dts->week_number(), '==', 12, 'week_number() on 1999-03-16 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-03-16 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-03-16 Gregorian' );

$epoch = timegm( 0, 0, 0, 17, 3 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 3,
	day	=> 17,
    ),
);
cmp_ok( $dts->day(), '==', 24, 'day() on 1999-03-17 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sterday', 'day_name() on 1999-03-17 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sterrendei', 'day_name_trad() on 1999-03-17 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 24, 'day_of_month() on 1999-03-17 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 1, 'day_of_week() on 1999-03-17 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 85, 'day_of_year() on 1999-03-17 Gregorian' );
cmp_ok( $dts->dow(), '==', 1, 'dow() on 1999-03-17 Gregorian' );
cmp_ok( $dts->doy(), '==', 85, 'doy() on 1999-03-17 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-03-17 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-03-17 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-03-17 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-03-17 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-03-17 Gregorian' );
cmp_ok( $dts->mday(), '==', 24, 'mday() on 1999-03-17 Gregorian' );
cmp_ok( $dts->month(), '==', 3, 'month() on 1999-03-17 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Rethe', 'month_name() on 1999-03-17 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-03-17 Gregorian' );
Sterday 24 Rethe 7463

Frodo and Sam reach the base of Mount Doom, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63057312000, 'utc_rd_as_seconds() on 1999-03-17 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729830,
  0,
  0
]
, 'utc_rd_values() on 1999-03-17 Gregorian' );
cmp_ok( $dts->wday(), '==', 1, 'wday() on 1999-03-17 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  13
]
, 'week() on 1999-03-17 Gregorian' );
cmp_ok( $dts->week_number(), '==', 13, 'week_number() on 1999-03-17 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-03-17 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-03-17 Gregorian' );

$epoch = timegm( 0, 0, 0, 18, 3 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 3,
	day	=> 18,
    ),
);
cmp_ok( $dts->day(), '==', 25, 'day() on 1999-03-18 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sunday', 'day_name() on 1999-03-18 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sunnendei', 'day_name_trad() on 1999-03-18 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 25, 'day_of_month() on 1999-03-18 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 2, 'day_of_week() on 1999-03-18 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 86, 'day_of_year() on 1999-03-18 Gregorian' );
cmp_ok( $dts->dow(), '==', 2, 'dow() on 1999-03-18 Gregorian' );
cmp_ok( $dts->doy(), '==', 86, 'doy() on 1999-03-18 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-03-18 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-03-18 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-03-18 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-03-18 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-03-18 Gregorian' );
cmp_ok( $dts->mday(), '==', 25, 'mday() on 1999-03-18 Gregorian' );
cmp_ok( $dts->month(), '==', 3, 'month() on 1999-03-18 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Rethe', 'month_name() on 1999-03-18 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-03-18 Gregorian' );
Sunday 25 Rethe 7463

Battle of the Host of the West on the slag hill of the Morannon, 1419.
Gollum siezes the Ring of Power and falls into the Cracks of Doom, 1419.
Downfall of Barad-dur and the passing of Sauron!, 1419.
Birth of Elanor the Fair, daughter of Samwise, 1421.
Fourth age begins in the reckoning of Gondor, 1421.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63057398400, 'utc_rd_as_seconds() on 1999-03-18 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729831,
  0,
  0
]
, 'utc_rd_values() on 1999-03-18 Gregorian' );
cmp_ok( $dts->wday(), '==', 2, 'wday() on 1999-03-18 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  13
]
, 'week() on 1999-03-18 Gregorian' );
cmp_ok( $dts->week_number(), '==', 13, 'week_number() on 1999-03-18 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-03-18 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-03-18 Gregorian' );

$epoch = timegm( 0, 0, 0, 19, 3 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 3,
	day	=> 19,
    ),
);
cmp_ok( $dts->day(), '==', 26, 'day() on 1999-03-19 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Monday', 'day_name() on 1999-03-19 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Monendei', 'day_name_trad() on 1999-03-19 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 26, 'day_of_month() on 1999-03-19 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 3, 'day_of_week() on 1999-03-19 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 87, 'day_of_year() on 1999-03-19 Gregorian' );
cmp_ok( $dts->dow(), '==', 3, 'dow() on 1999-03-19 Gregorian' );
cmp_ok( $dts->doy(), '==', 87, 'doy() on 1999-03-19 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-03-19 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-03-19 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-03-19 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-03-19 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-03-19 Gregorian' );
cmp_ok( $dts->mday(), '==', 26, 'mday() on 1999-03-19 Gregorian' );
cmp_ok( $dts->month(), '==', 3, 'month() on 1999-03-19 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Rethe', 'month_name() on 1999-03-19 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-03-19 Gregorian' );
Monday 26 Rethe 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63057484800, 'utc_rd_as_seconds() on 1999-03-19 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729832,
  0,
  0
]
, 'utc_rd_values() on 1999-03-19 Gregorian' );
cmp_ok( $dts->wday(), '==', 3, 'wday() on 1999-03-19 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  13
]
, 'week() on 1999-03-19 Gregorian' );
cmp_ok( $dts->week_number(), '==', 13, 'week_number() on 1999-03-19 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-03-19 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-03-19 Gregorian' );

$epoch = timegm( 0, 0, 0, 20, 3 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 3,
	day	=> 20,
    ),
);
cmp_ok( $dts->day(), '==', 27, 'day() on 1999-03-20 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Trewsday', 'day_name() on 1999-03-20 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Trewesdei', 'day_name_trad() on 1999-03-20 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 27, 'day_of_month() on 1999-03-20 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 4, 'day_of_week() on 1999-03-20 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 88, 'day_of_year() on 1999-03-20 Gregorian' );
cmp_ok( $dts->dow(), '==', 4, 'dow() on 1999-03-20 Gregorian' );
cmp_ok( $dts->doy(), '==', 88, 'doy() on 1999-03-20 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-03-20 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-03-20 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-03-20 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-03-20 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-03-20 Gregorian' );
cmp_ok( $dts->mday(), '==', 27, 'mday() on 1999-03-20 Gregorian' );
cmp_ok( $dts->month(), '==', 3, 'month() on 1999-03-20 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Rethe', 'month_name() on 1999-03-20 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-03-20 Gregorian' );
Trewsday 27 Rethe 7463

Bard II and Thorin III Stonehelm drive the enemy from Dale, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63057571200, 'utc_rd_as_seconds() on 1999-03-20 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729833,
  0,
  0
]
, 'utc_rd_values() on 1999-03-20 Gregorian' );
cmp_ok( $dts->wday(), '==', 4, 'wday() on 1999-03-20 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  13
]
, 'week() on 1999-03-20 Gregorian' );
cmp_ok( $dts->week_number(), '==', 13, 'week_number() on 1999-03-20 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-03-20 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-03-20 Gregorian' );

$epoch = timegm( 0, 0, 0, 21, 3 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 3,
	day	=> 21,
    ),
);
cmp_ok( $dts->day(), '==', 28, 'day() on 1999-03-21 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Hevensday', 'day_name() on 1999-03-21 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Hevenesdei', 'day_name_trad() on 1999-03-21 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 28, 'day_of_month() on 1999-03-21 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 5, 'day_of_week() on 1999-03-21 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 89, 'day_of_year() on 1999-03-21 Gregorian' );
cmp_ok( $dts->dow(), '==', 5, 'dow() on 1999-03-21 Gregorian' );
cmp_ok( $dts->doy(), '==', 89, 'doy() on 1999-03-21 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-03-21 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-03-21 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-03-21 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-03-21 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-03-21 Gregorian' );
cmp_ok( $dts->mday(), '==', 28, 'mday() on 1999-03-21 Gregorian' );
cmp_ok( $dts->month(), '==', 3, 'month() on 1999-03-21 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Rethe', 'month_name() on 1999-03-21 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-03-21 Gregorian' );
Hevensday 28 Rethe 7463

Celeborn crosses the Anduin and begins destruction of Dol Guldur, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63057657600, 'utc_rd_as_seconds() on 1999-03-21 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729834,
  0,
  0
]
, 'utc_rd_values() on 1999-03-21 Gregorian' );
cmp_ok( $dts->wday(), '==', 5, 'wday() on 1999-03-21 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  13
]
, 'week() on 1999-03-21 Gregorian' );
cmp_ok( $dts->week_number(), '==', 13, 'week_number() on 1999-03-21 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-03-21 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-03-21 Gregorian' );

$epoch = timegm( 0, 0, 0, 22, 3 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 3,
	day	=> 22,
    ),
);
cmp_ok( $dts->day(), '==', 29, 'day() on 1999-03-22 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Mersday', 'day_name() on 1999-03-22 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Meresdei', 'day_name_trad() on 1999-03-22 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 29, 'day_of_month() on 1999-03-22 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 6, 'day_of_week() on 1999-03-22 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 90, 'day_of_year() on 1999-03-22 Gregorian' );
cmp_ok( $dts->dow(), '==', 6, 'dow() on 1999-03-22 Gregorian' );
cmp_ok( $dts->doy(), '==', 90, 'doy() on 1999-03-22 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-03-22 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-03-22 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-03-22 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-03-22 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-03-22 Gregorian' );
cmp_ok( $dts->mday(), '==', 29, 'mday() on 1999-03-22 Gregorian' );
cmp_ok( $dts->month(), '==', 3, 'month() on 1999-03-22 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Rethe', 'month_name() on 1999-03-22 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-03-22 Gregorian' );
Mersday 29 Rethe 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63057744000, 'utc_rd_as_seconds() on 1999-03-22 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729835,
  0,
  0
]
, 'utc_rd_values() on 1999-03-22 Gregorian' );
cmp_ok( $dts->wday(), '==', 6, 'wday() on 1999-03-22 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  13
]
, 'week() on 1999-03-22 Gregorian' );
cmp_ok( $dts->week_number(), '==', 13, 'week_number() on 1999-03-22 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-03-22 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-03-22 Gregorian' );

$epoch = timegm( 0, 0, 0, 23, 3 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 3,
	day	=> 23,
    ),
);
cmp_ok( $dts->day(), '==', 30, 'day() on 1999-03-23 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Highday', 'day_name() on 1999-03-23 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Highdei', 'day_name_trad() on 1999-03-23 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 30, 'day_of_month() on 1999-03-23 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 7, 'day_of_week() on 1999-03-23 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 91, 'day_of_year() on 1999-03-23 Gregorian' );
cmp_ok( $dts->dow(), '==', 7, 'dow() on 1999-03-23 Gregorian' );
cmp_ok( $dts->doy(), '==', 91, 'doy() on 1999-03-23 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-03-23 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-03-23 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-03-23 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-03-23 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-03-23 Gregorian' );
cmp_ok( $dts->mday(), '==', 30, 'mday() on 1999-03-23 Gregorian' );
cmp_ok( $dts->month(), '==', 3, 'month() on 1999-03-23 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Rethe', 'month_name() on 1999-03-23 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-03-23 Gregorian' );
Highday 30 Rethe 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63057830400, 'utc_rd_as_seconds() on 1999-03-23 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729836,
  0,
  0
]
, 'utc_rd_values() on 1999-03-23 Gregorian' );
cmp_ok( $dts->wday(), '==', 7, 'wday() on 1999-03-23 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  13
]
, 'week() on 1999-03-23 Gregorian' );
cmp_ok( $dts->week_number(), '==', 13, 'week_number() on 1999-03-23 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-03-23 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-03-23 Gregorian' );

$epoch = timegm( 0, 0, 0, 24, 3 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 3,
	day	=> 24,
    ),
);
cmp_ok( $dts->day(), '==', 1, 'day() on 1999-03-24 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sterday', 'day_name() on 1999-03-24 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sterrendei', 'day_name_trad() on 1999-03-24 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 1, 'day_of_month() on 1999-03-24 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 1, 'day_of_week() on 1999-03-24 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 92, 'day_of_year() on 1999-03-24 Gregorian' );
cmp_ok( $dts->dow(), '==', 1, 'dow() on 1999-03-24 Gregorian' );
cmp_ok( $dts->doy(), '==', 92, 'doy() on 1999-03-24 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-03-24 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-03-24 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-03-24 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-03-24 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-03-24 Gregorian' );
cmp_ok( $dts->mday(), '==', 1, 'mday() on 1999-03-24 Gregorian' );
cmp_ok( $dts->month(), '==', 4, 'month() on 1999-03-24 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Astron', 'month_name() on 1999-03-24 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-03-24 Gregorian' );
Sterday 1 Astron 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63057916800, 'utc_rd_as_seconds() on 1999-03-24 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729837,
  0,
  0
]
, 'utc_rd_values() on 1999-03-24 Gregorian' );
cmp_ok( $dts->wday(), '==', 1, 'wday() on 1999-03-24 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  14
]
, 'week() on 1999-03-24 Gregorian' );
cmp_ok( $dts->week_number(), '==', 14, 'week_number() on 1999-03-24 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-03-24 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-03-24 Gregorian' );

$epoch = timegm( 0, 0, 0, 25, 3 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 3,
	day	=> 25,
    ),
);
cmp_ok( $dts->day(), '==', 2, 'day() on 1999-03-25 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sunday', 'day_name() on 1999-03-25 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sunnendei', 'day_name_trad() on 1999-03-25 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 2, 'day_of_month() on 1999-03-25 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 2, 'day_of_week() on 1999-03-25 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 93, 'day_of_year() on 1999-03-25 Gregorian' );
cmp_ok( $dts->dow(), '==', 2, 'dow() on 1999-03-25 Gregorian' );
cmp_ok( $dts->doy(), '==', 93, 'doy() on 1999-03-25 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-03-25 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-03-25 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-03-25 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-03-25 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-03-25 Gregorian' );
cmp_ok( $dts->mday(), '==', 2, 'mday() on 1999-03-25 Gregorian' );
cmp_ok( $dts->month(), '==', 4, 'month() on 1999-03-25 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Astron', 'month_name() on 1999-03-25 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-03-25 Gregorian' );
Sunday 2 Astron 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63058003200, 'utc_rd_as_seconds() on 1999-03-25 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729838,
  0,
  0
]
, 'utc_rd_values() on 1999-03-25 Gregorian' );
cmp_ok( $dts->wday(), '==', 2, 'wday() on 1999-03-25 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  14
]
, 'week() on 1999-03-25 Gregorian' );
cmp_ok( $dts->week_number(), '==', 14, 'week_number() on 1999-03-25 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-03-25 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-03-25 Gregorian' );

$epoch = timegm( 0, 0, 0, 26, 3 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 3,
	day	=> 26,
    ),
);
cmp_ok( $dts->day(), '==', 3, 'day() on 1999-03-26 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Monday', 'day_name() on 1999-03-26 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Monendei', 'day_name_trad() on 1999-03-26 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 3, 'day_of_month() on 1999-03-26 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 3, 'day_of_week() on 1999-03-26 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 94, 'day_of_year() on 1999-03-26 Gregorian' );
cmp_ok( $dts->dow(), '==', 3, 'dow() on 1999-03-26 Gregorian' );
cmp_ok( $dts->doy(), '==', 94, 'doy() on 1999-03-26 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-03-26 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-03-26 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-03-26 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-03-26 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-03-26 Gregorian' );
cmp_ok( $dts->mday(), '==', 3, 'mday() on 1999-03-26 Gregorian' );
cmp_ok( $dts->month(), '==', 4, 'month() on 1999-03-26 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Astron', 'month_name() on 1999-03-26 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-03-26 Gregorian' );
Monday 3 Astron 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63058089600, 'utc_rd_as_seconds() on 1999-03-26 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729839,
  0,
  0
]
, 'utc_rd_values() on 1999-03-26 Gregorian' );
cmp_ok( $dts->wday(), '==', 3, 'wday() on 1999-03-26 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  14
]
, 'week() on 1999-03-26 Gregorian' );
cmp_ok( $dts->week_number(), '==', 14, 'week_number() on 1999-03-26 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-03-26 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-03-26 Gregorian' );

$epoch = timegm( 0, 0, 0, 27, 3 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 3,
	day	=> 27,
    ),
);
cmp_ok( $dts->day(), '==', 4, 'day() on 1999-03-27 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Trewsday', 'day_name() on 1999-03-27 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Trewesdei', 'day_name_trad() on 1999-03-27 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 4, 'day_of_month() on 1999-03-27 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 4, 'day_of_week() on 1999-03-27 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 95, 'day_of_year() on 1999-03-27 Gregorian' );
cmp_ok( $dts->dow(), '==', 4, 'dow() on 1999-03-27 Gregorian' );
cmp_ok( $dts->doy(), '==', 95, 'doy() on 1999-03-27 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-03-27 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-03-27 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-03-27 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-03-27 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-03-27 Gregorian' );
cmp_ok( $dts->mday(), '==', 4, 'mday() on 1999-03-27 Gregorian' );
cmp_ok( $dts->month(), '==', 4, 'month() on 1999-03-27 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Astron', 'month_name() on 1999-03-27 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-03-27 Gregorian' );
Trewsday 4 Astron 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63058176000, 'utc_rd_as_seconds() on 1999-03-27 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729840,
  0,
  0
]
, 'utc_rd_values() on 1999-03-27 Gregorian' );
cmp_ok( $dts->wday(), '==', 4, 'wday() on 1999-03-27 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  14
]
, 'week() on 1999-03-27 Gregorian' );
cmp_ok( $dts->week_number(), '==', 14, 'week_number() on 1999-03-27 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-03-27 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-03-27 Gregorian' );

$epoch = timegm( 0, 0, 0, 28, 3 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 3,
	day	=> 28,
    ),
);
cmp_ok( $dts->day(), '==', 5, 'day() on 1999-03-28 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Hevensday', 'day_name() on 1999-03-28 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Hevenesdei', 'day_name_trad() on 1999-03-28 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 5, 'day_of_month() on 1999-03-28 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 5, 'day_of_week() on 1999-03-28 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 96, 'day_of_year() on 1999-03-28 Gregorian' );
cmp_ok( $dts->dow(), '==', 5, 'dow() on 1999-03-28 Gregorian' );
cmp_ok( $dts->doy(), '==', 96, 'doy() on 1999-03-28 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-03-28 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-03-28 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-03-28 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-03-28 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-03-28 Gregorian' );
cmp_ok( $dts->mday(), '==', 5, 'mday() on 1999-03-28 Gregorian' );
cmp_ok( $dts->month(), '==', 4, 'month() on 1999-03-28 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Astron', 'month_name() on 1999-03-28 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-03-28 Gregorian' );
Hevensday 5 Astron 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63058262400, 'utc_rd_as_seconds() on 1999-03-28 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729841,
  0,
  0
]
, 'utc_rd_values() on 1999-03-28 Gregorian' );
cmp_ok( $dts->wday(), '==', 5, 'wday() on 1999-03-28 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  14
]
, 'week() on 1999-03-28 Gregorian' );
cmp_ok( $dts->week_number(), '==', 14, 'week_number() on 1999-03-28 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-03-28 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-03-28 Gregorian' );

$epoch = timegm( 0, 0, 0, 29, 3 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 3,
	day	=> 29,
    ),
);
cmp_ok( $dts->day(), '==', 6, 'day() on 1999-03-29 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Mersday', 'day_name() on 1999-03-29 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Meresdei', 'day_name_trad() on 1999-03-29 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 6, 'day_of_month() on 1999-03-29 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 6, 'day_of_week() on 1999-03-29 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 97, 'day_of_year() on 1999-03-29 Gregorian' );
cmp_ok( $dts->dow(), '==', 6, 'dow() on 1999-03-29 Gregorian' );
cmp_ok( $dts->doy(), '==', 97, 'doy() on 1999-03-29 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-03-29 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-03-29 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-03-29 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-03-29 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-03-29 Gregorian' );
cmp_ok( $dts->mday(), '==', 6, 'mday() on 1999-03-29 Gregorian' );
cmp_ok( $dts->month(), '==', 4, 'month() on 1999-03-29 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Astron', 'month_name() on 1999-03-29 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-03-29 Gregorian' );
Mersday 6 Astron 7463

The mallorn tree flowers in the party field, 1420.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63058348800, 'utc_rd_as_seconds() on 1999-03-29 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729842,
  0,
  0
]
, 'utc_rd_values() on 1999-03-29 Gregorian' );
cmp_ok( $dts->wday(), '==', 6, 'wday() on 1999-03-29 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  14
]
, 'week() on 1999-03-29 Gregorian' );
cmp_ok( $dts->week_number(), '==', 14, 'week_number() on 1999-03-29 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-03-29 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-03-29 Gregorian' );

$epoch = timegm( 0, 0, 0, 30, 3 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 3,
	day	=> 30,
    ),
);
cmp_ok( $dts->day(), '==', 7, 'day() on 1999-03-30 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Highday', 'day_name() on 1999-03-30 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Highdei', 'day_name_trad() on 1999-03-30 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 7, 'day_of_month() on 1999-03-30 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 7, 'day_of_week() on 1999-03-30 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 98, 'day_of_year() on 1999-03-30 Gregorian' );
cmp_ok( $dts->dow(), '==', 7, 'dow() on 1999-03-30 Gregorian' );
cmp_ok( $dts->doy(), '==', 98, 'doy() on 1999-03-30 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-03-30 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-03-30 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-03-30 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-03-30 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-03-30 Gregorian' );
cmp_ok( $dts->mday(), '==', 7, 'mday() on 1999-03-30 Gregorian' );
cmp_ok( $dts->month(), '==', 4, 'month() on 1999-03-30 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Astron', 'month_name() on 1999-03-30 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-03-30 Gregorian' );
Highday 7 Astron 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63058435200, 'utc_rd_as_seconds() on 1999-03-30 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729843,
  0,
  0
]
, 'utc_rd_values() on 1999-03-30 Gregorian' );
cmp_ok( $dts->wday(), '==', 7, 'wday() on 1999-03-30 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  14
]
, 'week() on 1999-03-30 Gregorian' );
cmp_ok( $dts->week_number(), '==', 14, 'week_number() on 1999-03-30 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-03-30 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-03-30 Gregorian' );

$epoch = timegm( 0, 0, 0, 31, 3 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 3,
	day	=> 31,
    ),
);
cmp_ok( $dts->day(), '==', 8, 'day() on 1999-03-31 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sterday', 'day_name() on 1999-03-31 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sterrendei', 'day_name_trad() on 1999-03-31 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 8, 'day_of_month() on 1999-03-31 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 1, 'day_of_week() on 1999-03-31 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 99, 'day_of_year() on 1999-03-31 Gregorian' );
cmp_ok( $dts->dow(), '==', 1, 'dow() on 1999-03-31 Gregorian' );
cmp_ok( $dts->doy(), '==', 99, 'doy() on 1999-03-31 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-03-31 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-03-31 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-03-31 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-03-31 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-03-31 Gregorian' );
cmp_ok( $dts->mday(), '==', 8, 'mday() on 1999-03-31 Gregorian' );
cmp_ok( $dts->month(), '==', 4, 'month() on 1999-03-31 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Astron', 'month_name() on 1999-03-31 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-03-31 Gregorian' );
Sterday 8 Astron 7463

Ring bearers are honored on the fields of Cormallen, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63058521600, 'utc_rd_as_seconds() on 1999-03-31 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729844,
  0,
  0
]
, 'utc_rd_values() on 1999-03-31 Gregorian' );
cmp_ok( $dts->wday(), '==', 1, 'wday() on 1999-03-31 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  15
]
, 'week() on 1999-03-31 Gregorian' );
cmp_ok( $dts->week_number(), '==', 15, 'week_number() on 1999-03-31 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-03-31 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-03-31 Gregorian' );

$epoch = timegm( 0, 0, 0, 1, 4 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 4,
	day	=> 1,
    ),
);
cmp_ok( $dts->day(), '==', 9, 'day() on 1999-04-01 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sunday', 'day_name() on 1999-04-01 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sunnendei', 'day_name_trad() on 1999-04-01 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 9, 'day_of_month() on 1999-04-01 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 2, 'day_of_week() on 1999-04-01 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 100, 'day_of_year() on 1999-04-01 Gregorian' );
cmp_ok( $dts->dow(), '==', 2, 'dow() on 1999-04-01 Gregorian' );
cmp_ok( $dts->doy(), '==', 100, 'doy() on 1999-04-01 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-04-01 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-04-01 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-04-01 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-04-01 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-04-01 Gregorian' );
cmp_ok( $dts->mday(), '==', 9, 'mday() on 1999-04-01 Gregorian' );
cmp_ok( $dts->month(), '==', 4, 'month() on 1999-04-01 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Astron', 'month_name() on 1999-04-01 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-04-01 Gregorian' );
Sunday 9 Astron 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63058608000, 'utc_rd_as_seconds() on 1999-04-01 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729845,
  0,
  0
]
, 'utc_rd_values() on 1999-04-01 Gregorian' );
cmp_ok( $dts->wday(), '==', 2, 'wday() on 1999-04-01 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  15
]
, 'week() on 1999-04-01 Gregorian' );
cmp_ok( $dts->week_number(), '==', 15, 'week_number() on 1999-04-01 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-04-01 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-04-01 Gregorian' );

$epoch = timegm( 0, 0, 0, 2, 4 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 4,
	day	=> 2,
    ),
);
cmp_ok( $dts->day(), '==', 10, 'day() on 1999-04-02 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Monday', 'day_name() on 1999-04-02 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Monendei', 'day_name_trad() on 1999-04-02 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 10, 'day_of_month() on 1999-04-02 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 3, 'day_of_week() on 1999-04-02 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 101, 'day_of_year() on 1999-04-02 Gregorian' );
cmp_ok( $dts->dow(), '==', 3, 'dow() on 1999-04-02 Gregorian' );
cmp_ok( $dts->doy(), '==', 101, 'doy() on 1999-04-02 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-04-02 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-04-02 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-04-02 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-04-02 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-04-02 Gregorian' );
cmp_ok( $dts->mday(), '==', 10, 'mday() on 1999-04-02 Gregorian' );
cmp_ok( $dts->month(), '==', 4, 'month() on 1999-04-02 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Astron', 'month_name() on 1999-04-02 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-04-02 Gregorian' );
Monday 10 Astron 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63058694400, 'utc_rd_as_seconds() on 1999-04-02 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729846,
  0,
  0
]
, 'utc_rd_values() on 1999-04-02 Gregorian' );
cmp_ok( $dts->wday(), '==', 3, 'wday() on 1999-04-02 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  15
]
, 'week() on 1999-04-02 Gregorian' );
cmp_ok( $dts->week_number(), '==', 15, 'week_number() on 1999-04-02 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-04-02 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-04-02 Gregorian' );

$epoch = timegm( 0, 0, 0, 3, 4 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 4,
	day	=> 3,
    ),
);
cmp_ok( $dts->day(), '==', 11, 'day() on 1999-04-03 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Trewsday', 'day_name() on 1999-04-03 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Trewesdei', 'day_name_trad() on 1999-04-03 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 11, 'day_of_month() on 1999-04-03 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 4, 'day_of_week() on 1999-04-03 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 102, 'day_of_year() on 1999-04-03 Gregorian' );
cmp_ok( $dts->dow(), '==', 4, 'dow() on 1999-04-03 Gregorian' );
cmp_ok( $dts->doy(), '==', 102, 'doy() on 1999-04-03 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-04-03 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-04-03 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-04-03 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-04-03 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-04-03 Gregorian' );
cmp_ok( $dts->mday(), '==', 11, 'mday() on 1999-04-03 Gregorian' );
cmp_ok( $dts->month(), '==', 4, 'month() on 1999-04-03 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Astron', 'month_name() on 1999-04-03 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-04-03 Gregorian' );
Trewsday 11 Astron 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63058780800, 'utc_rd_as_seconds() on 1999-04-03 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729847,
  0,
  0
]
, 'utc_rd_values() on 1999-04-03 Gregorian' );
cmp_ok( $dts->wday(), '==', 4, 'wday() on 1999-04-03 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  15
]
, 'week() on 1999-04-03 Gregorian' );
cmp_ok( $dts->week_number(), '==', 15, 'week_number() on 1999-04-03 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-04-03 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-04-03 Gregorian' );

$epoch = timegm( 0, 0, 0, 4, 4 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 4,
	day	=> 4,
    ),
);
cmp_ok( $dts->day(), '==', 12, 'day() on 1999-04-04 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Hevensday', 'day_name() on 1999-04-04 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Hevenesdei', 'day_name_trad() on 1999-04-04 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 12, 'day_of_month() on 1999-04-04 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 5, 'day_of_week() on 1999-04-04 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 103, 'day_of_year() on 1999-04-04 Gregorian' );
cmp_ok( $dts->dow(), '==', 5, 'dow() on 1999-04-04 Gregorian' );
cmp_ok( $dts->doy(), '==', 103, 'doy() on 1999-04-04 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-04-04 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-04-04 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-04-04 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-04-04 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-04-04 Gregorian' );
cmp_ok( $dts->mday(), '==', 12, 'mday() on 1999-04-04 Gregorian' );
cmp_ok( $dts->month(), '==', 4, 'month() on 1999-04-04 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Astron', 'month_name() on 1999-04-04 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-04-04 Gregorian' );
Hevensday 12 Astron 7463

Gandalf arrives in Hobbiton, 1418
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63058867200, 'utc_rd_as_seconds() on 1999-04-04 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729848,
  0,
  0
]
, 'utc_rd_values() on 1999-04-04 Gregorian' );
cmp_ok( $dts->wday(), '==', 5, 'wday() on 1999-04-04 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  15
]
, 'week() on 1999-04-04 Gregorian' );
cmp_ok( $dts->week_number(), '==', 15, 'week_number() on 1999-04-04 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-04-04 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-04-04 Gregorian' );

$epoch = timegm( 0, 0, 0, 5, 4 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 4,
	day	=> 5,
    ),
);
cmp_ok( $dts->day(), '==', 13, 'day() on 1999-04-05 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Mersday', 'day_name() on 1999-04-05 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Meresdei', 'day_name_trad() on 1999-04-05 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 13, 'day_of_month() on 1999-04-05 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 6, 'day_of_week() on 1999-04-05 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 104, 'day_of_year() on 1999-04-05 Gregorian' );
cmp_ok( $dts->dow(), '==', 6, 'dow() on 1999-04-05 Gregorian' );
cmp_ok( $dts->doy(), '==', 104, 'doy() on 1999-04-05 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-04-05 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-04-05 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-04-05 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-04-05 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-04-05 Gregorian' );
cmp_ok( $dts->mday(), '==', 13, 'mday() on 1999-04-05 Gregorian' );
cmp_ok( $dts->month(), '==', 4, 'month() on 1999-04-05 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Astron', 'month_name() on 1999-04-05 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-04-05 Gregorian' );
Mersday 13 Astron 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63058953600, 'utc_rd_as_seconds() on 1999-04-05 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729849,
  0,
  0
]
, 'utc_rd_values() on 1999-04-05 Gregorian' );
cmp_ok( $dts->wday(), '==', 6, 'wday() on 1999-04-05 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  15
]
, 'week() on 1999-04-05 Gregorian' );
cmp_ok( $dts->week_number(), '==', 15, 'week_number() on 1999-04-05 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-04-05 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-04-05 Gregorian' );

$epoch = timegm( 0, 0, 0, 6, 4 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 4,
	day	=> 6,
    ),
);
cmp_ok( $dts->day(), '==', 14, 'day() on 1999-04-06 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Highday', 'day_name() on 1999-04-06 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Highdei', 'day_name_trad() on 1999-04-06 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 14, 'day_of_month() on 1999-04-06 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 7, 'day_of_week() on 1999-04-06 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 105, 'day_of_year() on 1999-04-06 Gregorian' );
cmp_ok( $dts->dow(), '==', 7, 'dow() on 1999-04-06 Gregorian' );
cmp_ok( $dts->doy(), '==', 105, 'doy() on 1999-04-06 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-04-06 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-04-06 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-04-06 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-04-06 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-04-06 Gregorian' );
cmp_ok( $dts->mday(), '==', 14, 'mday() on 1999-04-06 Gregorian' );
cmp_ok( $dts->month(), '==', 4, 'month() on 1999-04-06 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Astron', 'month_name() on 1999-04-06 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-04-06 Gregorian' );
Highday 14 Astron 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63059040000, 'utc_rd_as_seconds() on 1999-04-06 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729850,
  0,
  0
]
, 'utc_rd_values() on 1999-04-06 Gregorian' );
cmp_ok( $dts->wday(), '==', 7, 'wday() on 1999-04-06 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  15
]
, 'week() on 1999-04-06 Gregorian' );
cmp_ok( $dts->week_number(), '==', 15, 'week_number() on 1999-04-06 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-04-06 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-04-06 Gregorian' );

$epoch = timegm( 0, 0, 0, 7, 4 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 4,
	day	=> 7,
    ),
);
cmp_ok( $dts->day(), '==', 15, 'day() on 1999-04-07 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sterday', 'day_name() on 1999-04-07 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sterrendei', 'day_name_trad() on 1999-04-07 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 15, 'day_of_month() on 1999-04-07 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 1, 'day_of_week() on 1999-04-07 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 106, 'day_of_year() on 1999-04-07 Gregorian' );
cmp_ok( $dts->dow(), '==', 1, 'dow() on 1999-04-07 Gregorian' );
cmp_ok( $dts->doy(), '==', 106, 'doy() on 1999-04-07 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-04-07 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-04-07 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-04-07 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-04-07 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-04-07 Gregorian' );
cmp_ok( $dts->mday(), '==', 15, 'mday() on 1999-04-07 Gregorian' );
cmp_ok( $dts->month(), '==', 4, 'month() on 1999-04-07 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Astron', 'month_name() on 1999-04-07 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-04-07 Gregorian' );
Sterday 15 Astron 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63059126400, 'utc_rd_as_seconds() on 1999-04-07 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729851,
  0,
  0
]
, 'utc_rd_values() on 1999-04-07 Gregorian' );
cmp_ok( $dts->wday(), '==', 1, 'wday() on 1999-04-07 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  16
]
, 'week() on 1999-04-07 Gregorian' );
cmp_ok( $dts->week_number(), '==', 16, 'week_number() on 1999-04-07 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-04-07 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-04-07 Gregorian' );

$epoch = timegm( 0, 0, 0, 8, 4 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 4,
	day	=> 8,
    ),
);
cmp_ok( $dts->day(), '==', 16, 'day() on 1999-04-08 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sunday', 'day_name() on 1999-04-08 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sunnendei', 'day_name_trad() on 1999-04-08 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 16, 'day_of_month() on 1999-04-08 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 2, 'day_of_week() on 1999-04-08 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 107, 'day_of_year() on 1999-04-08 Gregorian' );
cmp_ok( $dts->dow(), '==', 2, 'dow() on 1999-04-08 Gregorian' );
cmp_ok( $dts->doy(), '==', 107, 'doy() on 1999-04-08 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-04-08 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-04-08 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-04-08 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-04-08 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-04-08 Gregorian' );
cmp_ok( $dts->mday(), '==', 16, 'mday() on 1999-04-08 Gregorian' );
cmp_ok( $dts->month(), '==', 4, 'month() on 1999-04-08 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Astron', 'month_name() on 1999-04-08 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-04-08 Gregorian' );
Sunday 16 Astron 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63059212800, 'utc_rd_as_seconds() on 1999-04-08 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729852,
  0,
  0
]
, 'utc_rd_values() on 1999-04-08 Gregorian' );
cmp_ok( $dts->wday(), '==', 2, 'wday() on 1999-04-08 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  16
]
, 'week() on 1999-04-08 Gregorian' );
cmp_ok( $dts->week_number(), '==', 16, 'week_number() on 1999-04-08 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-04-08 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-04-08 Gregorian' );

$epoch = timegm( 0, 0, 0, 9, 4 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 4,
	day	=> 9,
    ),
);
cmp_ok( $dts->day(), '==', 17, 'day() on 1999-04-09 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Monday', 'day_name() on 1999-04-09 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Monendei', 'day_name_trad() on 1999-04-09 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 17, 'day_of_month() on 1999-04-09 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 3, 'day_of_week() on 1999-04-09 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 108, 'day_of_year() on 1999-04-09 Gregorian' );
cmp_ok( $dts->dow(), '==', 3, 'dow() on 1999-04-09 Gregorian' );
cmp_ok( $dts->doy(), '==', 108, 'doy() on 1999-04-09 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-04-09 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-04-09 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-04-09 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-04-09 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-04-09 Gregorian' );
cmp_ok( $dts->mday(), '==', 17, 'mday() on 1999-04-09 Gregorian' );
cmp_ok( $dts->month(), '==', 4, 'month() on 1999-04-09 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Astron', 'month_name() on 1999-04-09 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-04-09 Gregorian' );
Monday 17 Astron 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63059299200, 'utc_rd_as_seconds() on 1999-04-09 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729853,
  0,
  0
]
, 'utc_rd_values() on 1999-04-09 Gregorian' );
cmp_ok( $dts->wday(), '==', 3, 'wday() on 1999-04-09 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  16
]
, 'week() on 1999-04-09 Gregorian' );
cmp_ok( $dts->week_number(), '==', 16, 'week_number() on 1999-04-09 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-04-09 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-04-09 Gregorian' );

$epoch = timegm( 0, 0, 0, 10, 4 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 4,
	day	=> 10,
    ),
);
cmp_ok( $dts->day(), '==', 18, 'day() on 1999-04-10 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Trewsday', 'day_name() on 1999-04-10 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Trewesdei', 'day_name_trad() on 1999-04-10 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 18, 'day_of_month() on 1999-04-10 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 4, 'day_of_week() on 1999-04-10 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 109, 'day_of_year() on 1999-04-10 Gregorian' );
cmp_ok( $dts->dow(), '==', 4, 'dow() on 1999-04-10 Gregorian' );
cmp_ok( $dts->doy(), '==', 109, 'doy() on 1999-04-10 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-04-10 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-04-10 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-04-10 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-04-10 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-04-10 Gregorian' );
cmp_ok( $dts->mday(), '==', 18, 'mday() on 1999-04-10 Gregorian' );
cmp_ok( $dts->month(), '==', 4, 'month() on 1999-04-10 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Astron', 'month_name() on 1999-04-10 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-04-10 Gregorian' );
Trewsday 18 Astron 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63059385600, 'utc_rd_as_seconds() on 1999-04-10 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729854,
  0,
  0
]
, 'utc_rd_values() on 1999-04-10 Gregorian' );
cmp_ok( $dts->wday(), '==', 4, 'wday() on 1999-04-10 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  16
]
, 'week() on 1999-04-10 Gregorian' );
cmp_ok( $dts->week_number(), '==', 16, 'week_number() on 1999-04-10 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-04-10 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-04-10 Gregorian' );

$epoch = timegm( 0, 0, 0, 11, 4 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 4,
	day	=> 11,
    ),
);
cmp_ok( $dts->day(), '==', 19, 'day() on 1999-04-11 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Hevensday', 'day_name() on 1999-04-11 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Hevenesdei', 'day_name_trad() on 1999-04-11 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 19, 'day_of_month() on 1999-04-11 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 5, 'day_of_week() on 1999-04-11 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 110, 'day_of_year() on 1999-04-11 Gregorian' );
cmp_ok( $dts->dow(), '==', 5, 'dow() on 1999-04-11 Gregorian' );
cmp_ok( $dts->doy(), '==', 110, 'doy() on 1999-04-11 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-04-11 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-04-11 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-04-11 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-04-11 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-04-11 Gregorian' );
cmp_ok( $dts->mday(), '==', 19, 'mday() on 1999-04-11 Gregorian' );
cmp_ok( $dts->month(), '==', 4, 'month() on 1999-04-11 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Astron', 'month_name() on 1999-04-11 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-04-11 Gregorian' );
Hevensday 19 Astron 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63059472000, 'utc_rd_as_seconds() on 1999-04-11 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729855,
  0,
  0
]
, 'utc_rd_values() on 1999-04-11 Gregorian' );
cmp_ok( $dts->wday(), '==', 5, 'wday() on 1999-04-11 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  16
]
, 'week() on 1999-04-11 Gregorian' );
cmp_ok( $dts->week_number(), '==', 16, 'week_number() on 1999-04-11 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-04-11 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-04-11 Gregorian' );

$epoch = timegm( 0, 0, 0, 12, 4 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 4,
	day	=> 12,
    ),
);
cmp_ok( $dts->day(), '==', 20, 'day() on 1999-04-12 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Mersday', 'day_name() on 1999-04-12 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Meresdei', 'day_name_trad() on 1999-04-12 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 20, 'day_of_month() on 1999-04-12 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 6, 'day_of_week() on 1999-04-12 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 111, 'day_of_year() on 1999-04-12 Gregorian' );
cmp_ok( $dts->dow(), '==', 6, 'dow() on 1999-04-12 Gregorian' );
cmp_ok( $dts->doy(), '==', 111, 'doy() on 1999-04-12 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-04-12 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-04-12 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-04-12 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-04-12 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-04-12 Gregorian' );
cmp_ok( $dts->mday(), '==', 20, 'mday() on 1999-04-12 Gregorian' );
cmp_ok( $dts->month(), '==', 4, 'month() on 1999-04-12 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Astron', 'month_name() on 1999-04-12 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-04-12 Gregorian' );
Mersday 20 Astron 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63059558400, 'utc_rd_as_seconds() on 1999-04-12 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729856,
  0,
  0
]
, 'utc_rd_values() on 1999-04-12 Gregorian' );
cmp_ok( $dts->wday(), '==', 6, 'wday() on 1999-04-12 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  16
]
, 'week() on 1999-04-12 Gregorian' );
cmp_ok( $dts->week_number(), '==', 16, 'week_number() on 1999-04-12 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-04-12 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-04-12 Gregorian' );

$epoch = timegm( 0, 0, 0, 13, 4 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 4,
	day	=> 13,
    ),
);
cmp_ok( $dts->day(), '==', 21, 'day() on 1999-04-13 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Highday', 'day_name() on 1999-04-13 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Highdei', 'day_name_trad() on 1999-04-13 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 21, 'day_of_month() on 1999-04-13 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 7, 'day_of_week() on 1999-04-13 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 112, 'day_of_year() on 1999-04-13 Gregorian' );
cmp_ok( $dts->dow(), '==', 7, 'dow() on 1999-04-13 Gregorian' );
cmp_ok( $dts->doy(), '==', 112, 'doy() on 1999-04-13 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-04-13 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-04-13 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-04-13 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-04-13 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-04-13 Gregorian' );
cmp_ok( $dts->mday(), '==', 21, 'mday() on 1999-04-13 Gregorian' );
cmp_ok( $dts->month(), '==', 4, 'month() on 1999-04-13 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Astron', 'month_name() on 1999-04-13 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-04-13 Gregorian' );
Highday 21 Astron 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63059644800, 'utc_rd_as_seconds() on 1999-04-13 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729857,
  0,
  0
]
, 'utc_rd_values() on 1999-04-13 Gregorian' );
cmp_ok( $dts->wday(), '==', 7, 'wday() on 1999-04-13 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  16
]
, 'week() on 1999-04-13 Gregorian' );
cmp_ok( $dts->week_number(), '==', 16, 'week_number() on 1999-04-13 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-04-13 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-04-13 Gregorian' );

$epoch = timegm( 0, 0, 0, 14, 4 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 4,
	day	=> 14,
    ),
);
cmp_ok( $dts->day(), '==', 22, 'day() on 1999-04-14 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sterday', 'day_name() on 1999-04-14 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sterrendei', 'day_name_trad() on 1999-04-14 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 22, 'day_of_month() on 1999-04-14 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 1, 'day_of_week() on 1999-04-14 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 113, 'day_of_year() on 1999-04-14 Gregorian' );
cmp_ok( $dts->dow(), '==', 1, 'dow() on 1999-04-14 Gregorian' );
cmp_ok( $dts->doy(), '==', 113, 'doy() on 1999-04-14 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-04-14 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-04-14 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-04-14 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-04-14 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-04-14 Gregorian' );
cmp_ok( $dts->mday(), '==', 22, 'mday() on 1999-04-14 Gregorian' );
cmp_ok( $dts->month(), '==', 4, 'month() on 1999-04-14 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Astron', 'month_name() on 1999-04-14 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-04-14 Gregorian' );
Sterday 22 Astron 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63059731200, 'utc_rd_as_seconds() on 1999-04-14 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729858,
  0,
  0
]
, 'utc_rd_values() on 1999-04-14 Gregorian' );
cmp_ok( $dts->wday(), '==', 1, 'wday() on 1999-04-14 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  17
]
, 'week() on 1999-04-14 Gregorian' );
cmp_ok( $dts->week_number(), '==', 17, 'week_number() on 1999-04-14 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-04-14 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-04-14 Gregorian' );

$epoch = timegm( 0, 0, 0, 15, 4 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 4,
	day	=> 15,
    ),
);
cmp_ok( $dts->day(), '==', 23, 'day() on 1999-04-15 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sunday', 'day_name() on 1999-04-15 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sunnendei', 'day_name_trad() on 1999-04-15 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 23, 'day_of_month() on 1999-04-15 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 2, 'day_of_week() on 1999-04-15 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 114, 'day_of_year() on 1999-04-15 Gregorian' );
cmp_ok( $dts->dow(), '==', 2, 'dow() on 1999-04-15 Gregorian' );
cmp_ok( $dts->doy(), '==', 114, 'doy() on 1999-04-15 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-04-15 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-04-15 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-04-15 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-04-15 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-04-15 Gregorian' );
cmp_ok( $dts->mday(), '==', 23, 'mday() on 1999-04-15 Gregorian' );
cmp_ok( $dts->month(), '==', 4, 'month() on 1999-04-15 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Astron', 'month_name() on 1999-04-15 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-04-15 Gregorian' );
Sunday 23 Astron 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63059817600, 'utc_rd_as_seconds() on 1999-04-15 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729859,
  0,
  0
]
, 'utc_rd_values() on 1999-04-15 Gregorian' );
cmp_ok( $dts->wday(), '==', 2, 'wday() on 1999-04-15 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  17
]
, 'week() on 1999-04-15 Gregorian' );
cmp_ok( $dts->week_number(), '==', 17, 'week_number() on 1999-04-15 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-04-15 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-04-15 Gregorian' );

$epoch = timegm( 0, 0, 0, 16, 4 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 4,
	day	=> 16,
    ),
);
cmp_ok( $dts->day(), '==', 24, 'day() on 1999-04-16 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Monday', 'day_name() on 1999-04-16 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Monendei', 'day_name_trad() on 1999-04-16 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 24, 'day_of_month() on 1999-04-16 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 3, 'day_of_week() on 1999-04-16 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 115, 'day_of_year() on 1999-04-16 Gregorian' );
cmp_ok( $dts->dow(), '==', 3, 'dow() on 1999-04-16 Gregorian' );
cmp_ok( $dts->doy(), '==', 115, 'doy() on 1999-04-16 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-04-16 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-04-16 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-04-16 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-04-16 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-04-16 Gregorian' );
cmp_ok( $dts->mday(), '==', 24, 'mday() on 1999-04-16 Gregorian' );
cmp_ok( $dts->month(), '==', 4, 'month() on 1999-04-16 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Astron', 'month_name() on 1999-04-16 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-04-16 Gregorian' );
Monday 24 Astron 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63059904000, 'utc_rd_as_seconds() on 1999-04-16 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729860,
  0,
  0
]
, 'utc_rd_values() on 1999-04-16 Gregorian' );
cmp_ok( $dts->wday(), '==', 3, 'wday() on 1999-04-16 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  17
]
, 'week() on 1999-04-16 Gregorian' );
cmp_ok( $dts->week_number(), '==', 17, 'week_number() on 1999-04-16 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-04-16 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-04-16 Gregorian' );

$epoch = timegm( 0, 0, 0, 17, 4 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 4,
	day	=> 17,
    ),
);
cmp_ok( $dts->day(), '==', 25, 'day() on 1999-04-17 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Trewsday', 'day_name() on 1999-04-17 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Trewesdei', 'day_name_trad() on 1999-04-17 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 25, 'day_of_month() on 1999-04-17 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 4, 'day_of_week() on 1999-04-17 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 116, 'day_of_year() on 1999-04-17 Gregorian' );
cmp_ok( $dts->dow(), '==', 4, 'dow() on 1999-04-17 Gregorian' );
cmp_ok( $dts->doy(), '==', 116, 'doy() on 1999-04-17 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-04-17 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-04-17 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-04-17 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-04-17 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-04-17 Gregorian' );
cmp_ok( $dts->mday(), '==', 25, 'mday() on 1999-04-17 Gregorian' );
cmp_ok( $dts->month(), '==', 4, 'month() on 1999-04-17 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Astron', 'month_name() on 1999-04-17 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-04-17 Gregorian' );
Trewsday 25 Astron 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63059990400, 'utc_rd_as_seconds() on 1999-04-17 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729861,
  0,
  0
]
, 'utc_rd_values() on 1999-04-17 Gregorian' );
cmp_ok( $dts->wday(), '==', 4, 'wday() on 1999-04-17 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  17
]
, 'week() on 1999-04-17 Gregorian' );
cmp_ok( $dts->week_number(), '==', 17, 'week_number() on 1999-04-17 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-04-17 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-04-17 Gregorian' );

$epoch = timegm( 0, 0, 0, 18, 4 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 4,
	day	=> 18,
    ),
);
cmp_ok( $dts->day(), '==', 26, 'day() on 1999-04-18 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Hevensday', 'day_name() on 1999-04-18 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Hevenesdei', 'day_name_trad() on 1999-04-18 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 26, 'day_of_month() on 1999-04-18 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 5, 'day_of_week() on 1999-04-18 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 117, 'day_of_year() on 1999-04-18 Gregorian' );
cmp_ok( $dts->dow(), '==', 5, 'dow() on 1999-04-18 Gregorian' );
cmp_ok( $dts->doy(), '==', 117, 'doy() on 1999-04-18 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-04-18 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-04-18 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-04-18 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-04-18 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-04-18 Gregorian' );
cmp_ok( $dts->mday(), '==', 26, 'mday() on 1999-04-18 Gregorian' );
cmp_ok( $dts->month(), '==', 4, 'month() on 1999-04-18 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Astron', 'month_name() on 1999-04-18 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-04-18 Gregorian' );
Hevensday 26 Astron 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63060076800, 'utc_rd_as_seconds() on 1999-04-18 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729862,
  0,
  0
]
, 'utc_rd_values() on 1999-04-18 Gregorian' );
cmp_ok( $dts->wday(), '==', 5, 'wday() on 1999-04-18 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  17
]
, 'week() on 1999-04-18 Gregorian' );
cmp_ok( $dts->week_number(), '==', 17, 'week_number() on 1999-04-18 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-04-18 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-04-18 Gregorian' );

$epoch = timegm( 0, 0, 0, 19, 4 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 4,
	day	=> 19,
    ),
);
cmp_ok( $dts->day(), '==', 27, 'day() on 1999-04-19 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Mersday', 'day_name() on 1999-04-19 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Meresdei', 'day_name_trad() on 1999-04-19 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 27, 'day_of_month() on 1999-04-19 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 6, 'day_of_week() on 1999-04-19 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 118, 'day_of_year() on 1999-04-19 Gregorian' );
cmp_ok( $dts->dow(), '==', 6, 'dow() on 1999-04-19 Gregorian' );
cmp_ok( $dts->doy(), '==', 118, 'doy() on 1999-04-19 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-04-19 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-04-19 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-04-19 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-04-19 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-04-19 Gregorian' );
cmp_ok( $dts->mday(), '==', 27, 'mday() on 1999-04-19 Gregorian' );
cmp_ok( $dts->month(), '==', 4, 'month() on 1999-04-19 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Astron', 'month_name() on 1999-04-19 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-04-19 Gregorian' );
Mersday 27 Astron 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63060163200, 'utc_rd_as_seconds() on 1999-04-19 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729863,
  0,
  0
]
, 'utc_rd_values() on 1999-04-19 Gregorian' );
cmp_ok( $dts->wday(), '==', 6, 'wday() on 1999-04-19 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  17
]
, 'week() on 1999-04-19 Gregorian' );
cmp_ok( $dts->week_number(), '==', 17, 'week_number() on 1999-04-19 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-04-19 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-04-19 Gregorian' );

$epoch = timegm( 0, 0, 0, 20, 4 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 4,
	day	=> 20,
    ),
);
cmp_ok( $dts->day(), '==', 28, 'day() on 1999-04-20 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Highday', 'day_name() on 1999-04-20 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Highdei', 'day_name_trad() on 1999-04-20 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 28, 'day_of_month() on 1999-04-20 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 7, 'day_of_week() on 1999-04-20 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 119, 'day_of_year() on 1999-04-20 Gregorian' );
cmp_ok( $dts->dow(), '==', 7, 'dow() on 1999-04-20 Gregorian' );
cmp_ok( $dts->doy(), '==', 119, 'doy() on 1999-04-20 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-04-20 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-04-20 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-04-20 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-04-20 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-04-20 Gregorian' );
cmp_ok( $dts->mday(), '==', 28, 'mday() on 1999-04-20 Gregorian' );
cmp_ok( $dts->month(), '==', 4, 'month() on 1999-04-20 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Astron', 'month_name() on 1999-04-20 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-04-20 Gregorian' );
Highday 28 Astron 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63060249600, 'utc_rd_as_seconds() on 1999-04-20 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729864,
  0,
  0
]
, 'utc_rd_values() on 1999-04-20 Gregorian' );
cmp_ok( $dts->wday(), '==', 7, 'wday() on 1999-04-20 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  17
]
, 'week() on 1999-04-20 Gregorian' );
cmp_ok( $dts->week_number(), '==', 17, 'week_number() on 1999-04-20 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-04-20 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-04-20 Gregorian' );

$epoch = timegm( 0, 0, 0, 21, 4 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 4,
	day	=> 21,
    ),
);
cmp_ok( $dts->day(), '==', 29, 'day() on 1999-04-21 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sterday', 'day_name() on 1999-04-21 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sterrendei', 'day_name_trad() on 1999-04-21 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 29, 'day_of_month() on 1999-04-21 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 1, 'day_of_week() on 1999-04-21 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 120, 'day_of_year() on 1999-04-21 Gregorian' );
cmp_ok( $dts->dow(), '==', 1, 'dow() on 1999-04-21 Gregorian' );
cmp_ok( $dts->doy(), '==', 120, 'doy() on 1999-04-21 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-04-21 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-04-21 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-04-21 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-04-21 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-04-21 Gregorian' );
cmp_ok( $dts->mday(), '==', 29, 'mday() on 1999-04-21 Gregorian' );
cmp_ok( $dts->month(), '==', 4, 'month() on 1999-04-21 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Astron', 'month_name() on 1999-04-21 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-04-21 Gregorian' );
Sterday 29 Astron 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63060336000, 'utc_rd_as_seconds() on 1999-04-21 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729865,
  0,
  0
]
, 'utc_rd_values() on 1999-04-21 Gregorian' );
cmp_ok( $dts->wday(), '==', 1, 'wday() on 1999-04-21 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  18
]
, 'week() on 1999-04-21 Gregorian' );
cmp_ok( $dts->week_number(), '==', 18, 'week_number() on 1999-04-21 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-04-21 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-04-21 Gregorian' );

$epoch = timegm( 0, 0, 0, 22, 4 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 4,
	day	=> 22,
    ),
);
cmp_ok( $dts->day(), '==', 30, 'day() on 1999-04-22 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sunday', 'day_name() on 1999-04-22 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sunnendei', 'day_name_trad() on 1999-04-22 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 30, 'day_of_month() on 1999-04-22 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 2, 'day_of_week() on 1999-04-22 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 121, 'day_of_year() on 1999-04-22 Gregorian' );
cmp_ok( $dts->dow(), '==', 2, 'dow() on 1999-04-22 Gregorian' );
cmp_ok( $dts->doy(), '==', 121, 'doy() on 1999-04-22 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-04-22 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-04-22 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-04-22 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-04-22 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-04-22 Gregorian' );
cmp_ok( $dts->mday(), '==', 30, 'mday() on 1999-04-22 Gregorian' );
cmp_ok( $dts->month(), '==', 4, 'month() on 1999-04-22 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Astron', 'month_name() on 1999-04-22 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-04-22 Gregorian' );
Sunday 30 Astron 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63060422400, 'utc_rd_as_seconds() on 1999-04-22 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729866,
  0,
  0
]
, 'utc_rd_values() on 1999-04-22 Gregorian' );
cmp_ok( $dts->wday(), '==', 2, 'wday() on 1999-04-22 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  18
]
, 'week() on 1999-04-22 Gregorian' );
cmp_ok( $dts->week_number(), '==', 18, 'week_number() on 1999-04-22 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-04-22 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-04-22 Gregorian' );

$epoch = timegm( 0, 0, 0, 23, 4 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 4,
	day	=> 23,
    ),
);
cmp_ok( $dts->day(), '==', 1, 'day() on 1999-04-23 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Monday', 'day_name() on 1999-04-23 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Monendei', 'day_name_trad() on 1999-04-23 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 1, 'day_of_month() on 1999-04-23 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 3, 'day_of_week() on 1999-04-23 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 122, 'day_of_year() on 1999-04-23 Gregorian' );
cmp_ok( $dts->dow(), '==', 3, 'dow() on 1999-04-23 Gregorian' );
cmp_ok( $dts->doy(), '==', 122, 'doy() on 1999-04-23 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-04-23 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-04-23 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-04-23 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-04-23 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-04-23 Gregorian' );
cmp_ok( $dts->mday(), '==', 1, 'mday() on 1999-04-23 Gregorian' );
cmp_ok( $dts->month(), '==', 5, 'month() on 1999-04-23 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Thrimidge', 'month_name() on 1999-04-23 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-04-23 Gregorian' );
Monday 1 Thrimidge 7463

Crowning of King Elessar, 1419.
Samwise marries Rose, 1420.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63060508800, 'utc_rd_as_seconds() on 1999-04-23 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729867,
  0,
  0
]
, 'utc_rd_values() on 1999-04-23 Gregorian' );
cmp_ok( $dts->wday(), '==', 3, 'wday() on 1999-04-23 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  18
]
, 'week() on 1999-04-23 Gregorian' );
cmp_ok( $dts->week_number(), '==', 18, 'week_number() on 1999-04-23 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-04-23 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-04-23 Gregorian' );

$epoch = timegm( 0, 0, 0, 24, 4 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 4,
	day	=> 24,
    ),
);
cmp_ok( $dts->day(), '==', 2, 'day() on 1999-04-24 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Trewsday', 'day_name() on 1999-04-24 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Trewesdei', 'day_name_trad() on 1999-04-24 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 2, 'day_of_month() on 1999-04-24 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 4, 'day_of_week() on 1999-04-24 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 123, 'day_of_year() on 1999-04-24 Gregorian' );
cmp_ok( $dts->dow(), '==', 4, 'dow() on 1999-04-24 Gregorian' );
cmp_ok( $dts->doy(), '==', 123, 'doy() on 1999-04-24 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-04-24 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-04-24 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-04-24 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-04-24 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-04-24 Gregorian' );
cmp_ok( $dts->mday(), '==', 2, 'mday() on 1999-04-24 Gregorian' );
cmp_ok( $dts->month(), '==', 5, 'month() on 1999-04-24 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Thrimidge', 'month_name() on 1999-04-24 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-04-24 Gregorian' );
Trewsday 2 Thrimidge 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63060595200, 'utc_rd_as_seconds() on 1999-04-24 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729868,
  0,
  0
]
, 'utc_rd_values() on 1999-04-24 Gregorian' );
cmp_ok( $dts->wday(), '==', 4, 'wday() on 1999-04-24 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  18
]
, 'week() on 1999-04-24 Gregorian' );
cmp_ok( $dts->week_number(), '==', 18, 'week_number() on 1999-04-24 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-04-24 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-04-24 Gregorian' );

$epoch = timegm( 0, 0, 0, 25, 4 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 4,
	day	=> 25,
    ),
);
cmp_ok( $dts->day(), '==', 3, 'day() on 1999-04-25 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Hevensday', 'day_name() on 1999-04-25 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Hevenesdei', 'day_name_trad() on 1999-04-25 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 3, 'day_of_month() on 1999-04-25 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 5, 'day_of_week() on 1999-04-25 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 124, 'day_of_year() on 1999-04-25 Gregorian' );
cmp_ok( $dts->dow(), '==', 5, 'dow() on 1999-04-25 Gregorian' );
cmp_ok( $dts->doy(), '==', 124, 'doy() on 1999-04-25 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-04-25 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-04-25 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-04-25 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-04-25 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-04-25 Gregorian' );
cmp_ok( $dts->mday(), '==', 3, 'mday() on 1999-04-25 Gregorian' );
cmp_ok( $dts->month(), '==', 5, 'month() on 1999-04-25 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Thrimidge', 'month_name() on 1999-04-25 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-04-25 Gregorian' );
Hevensday 3 Thrimidge 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63060681600, 'utc_rd_as_seconds() on 1999-04-25 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729869,
  0,
  0
]
, 'utc_rd_values() on 1999-04-25 Gregorian' );
cmp_ok( $dts->wday(), '==', 5, 'wday() on 1999-04-25 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  18
]
, 'week() on 1999-04-25 Gregorian' );
cmp_ok( $dts->week_number(), '==', 18, 'week_number() on 1999-04-25 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-04-25 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-04-25 Gregorian' );

$epoch = timegm( 0, 0, 0, 26, 4 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 4,
	day	=> 26,
    ),
);
cmp_ok( $dts->day(), '==', 4, 'day() on 1999-04-26 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Mersday', 'day_name() on 1999-04-26 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Meresdei', 'day_name_trad() on 1999-04-26 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 4, 'day_of_month() on 1999-04-26 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 6, 'day_of_week() on 1999-04-26 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 125, 'day_of_year() on 1999-04-26 Gregorian' );
cmp_ok( $dts->dow(), '==', 6, 'dow() on 1999-04-26 Gregorian' );
cmp_ok( $dts->doy(), '==', 125, 'doy() on 1999-04-26 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-04-26 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-04-26 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-04-26 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-04-26 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-04-26 Gregorian' );
cmp_ok( $dts->mday(), '==', 4, 'mday() on 1999-04-26 Gregorian' );
cmp_ok( $dts->month(), '==', 5, 'month() on 1999-04-26 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Thrimidge', 'month_name() on 1999-04-26 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-04-26 Gregorian' );
Mersday 4 Thrimidge 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63060768000, 'utc_rd_as_seconds() on 1999-04-26 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729870,
  0,
  0
]
, 'utc_rd_values() on 1999-04-26 Gregorian' );
cmp_ok( $dts->wday(), '==', 6, 'wday() on 1999-04-26 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  18
]
, 'week() on 1999-04-26 Gregorian' );
cmp_ok( $dts->week_number(), '==', 18, 'week_number() on 1999-04-26 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-04-26 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-04-26 Gregorian' );

$epoch = timegm( 0, 0, 0, 27, 4 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 4,
	day	=> 27,
    ),
);
cmp_ok( $dts->day(), '==', 5, 'day() on 1999-04-27 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Highday', 'day_name() on 1999-04-27 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Highdei', 'day_name_trad() on 1999-04-27 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 5, 'day_of_month() on 1999-04-27 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 7, 'day_of_week() on 1999-04-27 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 126, 'day_of_year() on 1999-04-27 Gregorian' );
cmp_ok( $dts->dow(), '==', 7, 'dow() on 1999-04-27 Gregorian' );
cmp_ok( $dts->doy(), '==', 126, 'doy() on 1999-04-27 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-04-27 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-04-27 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-04-27 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-04-27 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-04-27 Gregorian' );
cmp_ok( $dts->mday(), '==', 5, 'mday() on 1999-04-27 Gregorian' );
cmp_ok( $dts->month(), '==', 5, 'month() on 1999-04-27 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Thrimidge', 'month_name() on 1999-04-27 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-04-27 Gregorian' );
Highday 5 Thrimidge 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63060854400, 'utc_rd_as_seconds() on 1999-04-27 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729871,
  0,
  0
]
, 'utc_rd_values() on 1999-04-27 Gregorian' );
cmp_ok( $dts->wday(), '==', 7, 'wday() on 1999-04-27 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  18
]
, 'week() on 1999-04-27 Gregorian' );
cmp_ok( $dts->week_number(), '==', 18, 'week_number() on 1999-04-27 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-04-27 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-04-27 Gregorian' );

$epoch = timegm( 0, 0, 0, 28, 4 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 4,
	day	=> 28,
    ),
);
cmp_ok( $dts->day(), '==', 6, 'day() on 1999-04-28 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sterday', 'day_name() on 1999-04-28 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sterrendei', 'day_name_trad() on 1999-04-28 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 6, 'day_of_month() on 1999-04-28 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 1, 'day_of_week() on 1999-04-28 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 127, 'day_of_year() on 1999-04-28 Gregorian' );
cmp_ok( $dts->dow(), '==', 1, 'dow() on 1999-04-28 Gregorian' );
cmp_ok( $dts->doy(), '==', 127, 'doy() on 1999-04-28 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-04-28 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-04-28 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-04-28 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-04-28 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-04-28 Gregorian' );
cmp_ok( $dts->mday(), '==', 6, 'mday() on 1999-04-28 Gregorian' );
cmp_ok( $dts->month(), '==', 5, 'month() on 1999-04-28 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Thrimidge', 'month_name() on 1999-04-28 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-04-28 Gregorian' );
Sterday 6 Thrimidge 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63060940800, 'utc_rd_as_seconds() on 1999-04-28 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729872,
  0,
  0
]
, 'utc_rd_values() on 1999-04-28 Gregorian' );
cmp_ok( $dts->wday(), '==', 1, 'wday() on 1999-04-28 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  19
]
, 'week() on 1999-04-28 Gregorian' );
cmp_ok( $dts->week_number(), '==', 19, 'week_number() on 1999-04-28 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-04-28 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-04-28 Gregorian' );

$epoch = timegm( 0, 0, 0, 29, 4 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 4,
	day	=> 29,
    ),
);
cmp_ok( $dts->day(), '==', 7, 'day() on 1999-04-29 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sunday', 'day_name() on 1999-04-29 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sunnendei', 'day_name_trad() on 1999-04-29 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 7, 'day_of_month() on 1999-04-29 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 2, 'day_of_week() on 1999-04-29 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 128, 'day_of_year() on 1999-04-29 Gregorian' );
cmp_ok( $dts->dow(), '==', 2, 'dow() on 1999-04-29 Gregorian' );
cmp_ok( $dts->doy(), '==', 128, 'doy() on 1999-04-29 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-04-29 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-04-29 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-04-29 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-04-29 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-04-29 Gregorian' );
cmp_ok( $dts->mday(), '==', 7, 'mday() on 1999-04-29 Gregorian' );
cmp_ok( $dts->month(), '==', 5, 'month() on 1999-04-29 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Thrimidge', 'month_name() on 1999-04-29 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-04-29 Gregorian' );
Sunday 7 Thrimidge 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63061027200, 'utc_rd_as_seconds() on 1999-04-29 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729873,
  0,
  0
]
, 'utc_rd_values() on 1999-04-29 Gregorian' );
cmp_ok( $dts->wday(), '==', 2, 'wday() on 1999-04-29 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  19
]
, 'week() on 1999-04-29 Gregorian' );
cmp_ok( $dts->week_number(), '==', 19, 'week_number() on 1999-04-29 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-04-29 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-04-29 Gregorian' );

$epoch = timegm( 0, 0, 0, 30, 4 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 4,
	day	=> 30,
    ),
);
cmp_ok( $dts->day(), '==', 8, 'day() on 1999-04-30 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Monday', 'day_name() on 1999-04-30 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Monendei', 'day_name_trad() on 1999-04-30 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 8, 'day_of_month() on 1999-04-30 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 3, 'day_of_week() on 1999-04-30 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 129, 'day_of_year() on 1999-04-30 Gregorian' );
cmp_ok( $dts->dow(), '==', 3, 'dow() on 1999-04-30 Gregorian' );
cmp_ok( $dts->doy(), '==', 129, 'doy() on 1999-04-30 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-04-30 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-04-30 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-04-30 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-04-30 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-04-30 Gregorian' );
cmp_ok( $dts->mday(), '==', 8, 'mday() on 1999-04-30 Gregorian' );
cmp_ok( $dts->month(), '==', 5, 'month() on 1999-04-30 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Thrimidge', 'month_name() on 1999-04-30 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-04-30 Gregorian' );
Monday 8 Thrimidge 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63061113600, 'utc_rd_as_seconds() on 1999-04-30 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729874,
  0,
  0
]
, 'utc_rd_values() on 1999-04-30 Gregorian' );
cmp_ok( $dts->wday(), '==', 3, 'wday() on 1999-04-30 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  19
]
, 'week() on 1999-04-30 Gregorian' );
cmp_ok( $dts->week_number(), '==', 19, 'week_number() on 1999-04-30 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-04-30 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-04-30 Gregorian' );

$epoch = timegm( 0, 0, 0, 1, 5 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 5,
	day	=> 1,
    ),
);
cmp_ok( $dts->day(), '==', 9, 'day() on 1999-05-01 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Trewsday', 'day_name() on 1999-05-01 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Trewesdei', 'day_name_trad() on 1999-05-01 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 9, 'day_of_month() on 1999-05-01 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 4, 'day_of_week() on 1999-05-01 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 130, 'day_of_year() on 1999-05-01 Gregorian' );
cmp_ok( $dts->dow(), '==', 4, 'dow() on 1999-05-01 Gregorian' );
cmp_ok( $dts->doy(), '==', 130, 'doy() on 1999-05-01 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-05-01 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-05-01 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-05-01 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-05-01 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-05-01 Gregorian' );
cmp_ok( $dts->mday(), '==', 9, 'mday() on 1999-05-01 Gregorian' );
cmp_ok( $dts->month(), '==', 5, 'month() on 1999-05-01 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Thrimidge', 'month_name() on 1999-05-01 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-05-01 Gregorian' );
Trewsday 9 Thrimidge 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63061200000, 'utc_rd_as_seconds() on 1999-05-01 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729875,
  0,
  0
]
, 'utc_rd_values() on 1999-05-01 Gregorian' );
cmp_ok( $dts->wday(), '==', 4, 'wday() on 1999-05-01 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  19
]
, 'week() on 1999-05-01 Gregorian' );
cmp_ok( $dts->week_number(), '==', 19, 'week_number() on 1999-05-01 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-05-01 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-05-01 Gregorian' );

$epoch = timegm( 0, 0, 0, 2, 5 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 5,
	day	=> 2,
    ),
);
cmp_ok( $dts->day(), '==', 10, 'day() on 1999-05-02 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Hevensday', 'day_name() on 1999-05-02 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Hevenesdei', 'day_name_trad() on 1999-05-02 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 10, 'day_of_month() on 1999-05-02 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 5, 'day_of_week() on 1999-05-02 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 131, 'day_of_year() on 1999-05-02 Gregorian' );
cmp_ok( $dts->dow(), '==', 5, 'dow() on 1999-05-02 Gregorian' );
cmp_ok( $dts->doy(), '==', 131, 'doy() on 1999-05-02 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-05-02 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-05-02 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-05-02 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-05-02 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-05-02 Gregorian' );
cmp_ok( $dts->mday(), '==', 10, 'mday() on 1999-05-02 Gregorian' );
cmp_ok( $dts->month(), '==', 5, 'month() on 1999-05-02 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Thrimidge', 'month_name() on 1999-05-02 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-05-02 Gregorian' );
Hevensday 10 Thrimidge 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63061286400, 'utc_rd_as_seconds() on 1999-05-02 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729876,
  0,
  0
]
, 'utc_rd_values() on 1999-05-02 Gregorian' );
cmp_ok( $dts->wday(), '==', 5, 'wday() on 1999-05-02 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  19
]
, 'week() on 1999-05-02 Gregorian' );
cmp_ok( $dts->week_number(), '==', 19, 'week_number() on 1999-05-02 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-05-02 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-05-02 Gregorian' );

$epoch = timegm( 0, 0, 0, 3, 5 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 5,
	day	=> 3,
    ),
);
cmp_ok( $dts->day(), '==', 11, 'day() on 1999-05-03 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Mersday', 'day_name() on 1999-05-03 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Meresdei', 'day_name_trad() on 1999-05-03 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 11, 'day_of_month() on 1999-05-03 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 6, 'day_of_week() on 1999-05-03 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 132, 'day_of_year() on 1999-05-03 Gregorian' );
cmp_ok( $dts->dow(), '==', 6, 'dow() on 1999-05-03 Gregorian' );
cmp_ok( $dts->doy(), '==', 132, 'doy() on 1999-05-03 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-05-03 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-05-03 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-05-03 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-05-03 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-05-03 Gregorian' );
cmp_ok( $dts->mday(), '==', 11, 'mday() on 1999-05-03 Gregorian' );
cmp_ok( $dts->month(), '==', 5, 'month() on 1999-05-03 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Thrimidge', 'month_name() on 1999-05-03 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-05-03 Gregorian' );
Mersday 11 Thrimidge 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63061372800, 'utc_rd_as_seconds() on 1999-05-03 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729877,
  0,
  0
]
, 'utc_rd_values() on 1999-05-03 Gregorian' );
cmp_ok( $dts->wday(), '==', 6, 'wday() on 1999-05-03 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  19
]
, 'week() on 1999-05-03 Gregorian' );
cmp_ok( $dts->week_number(), '==', 19, 'week_number() on 1999-05-03 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-05-03 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-05-03 Gregorian' );

$epoch = timegm( 0, 0, 0, 4, 5 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 5,
	day	=> 4,
    ),
);
cmp_ok( $dts->day(), '==', 12, 'day() on 1999-05-04 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Highday', 'day_name() on 1999-05-04 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Highdei', 'day_name_trad() on 1999-05-04 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 12, 'day_of_month() on 1999-05-04 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 7, 'day_of_week() on 1999-05-04 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 133, 'day_of_year() on 1999-05-04 Gregorian' );
cmp_ok( $dts->dow(), '==', 7, 'dow() on 1999-05-04 Gregorian' );
cmp_ok( $dts->doy(), '==', 133, 'doy() on 1999-05-04 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-05-04 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-05-04 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-05-04 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-05-04 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-05-04 Gregorian' );
cmp_ok( $dts->mday(), '==', 12, 'mday() on 1999-05-04 Gregorian' );
cmp_ok( $dts->month(), '==', 5, 'month() on 1999-05-04 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Thrimidge', 'month_name() on 1999-05-04 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-05-04 Gregorian' );
Highday 12 Thrimidge 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63061459200, 'utc_rd_as_seconds() on 1999-05-04 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729878,
  0,
  0
]
, 'utc_rd_values() on 1999-05-04 Gregorian' );
cmp_ok( $dts->wday(), '==', 7, 'wday() on 1999-05-04 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  19
]
, 'week() on 1999-05-04 Gregorian' );
cmp_ok( $dts->week_number(), '==', 19, 'week_number() on 1999-05-04 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-05-04 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-05-04 Gregorian' );

$epoch = timegm( 0, 0, 0, 5, 5 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 5,
	day	=> 5,
    ),
);
cmp_ok( $dts->day(), '==', 13, 'day() on 1999-05-05 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sterday', 'day_name() on 1999-05-05 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sterrendei', 'day_name_trad() on 1999-05-05 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 13, 'day_of_month() on 1999-05-05 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 1, 'day_of_week() on 1999-05-05 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 134, 'day_of_year() on 1999-05-05 Gregorian' );
cmp_ok( $dts->dow(), '==', 1, 'dow() on 1999-05-05 Gregorian' );
cmp_ok( $dts->doy(), '==', 134, 'doy() on 1999-05-05 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-05-05 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-05-05 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-05-05 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-05-05 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-05-05 Gregorian' );
cmp_ok( $dts->mday(), '==', 13, 'mday() on 1999-05-05 Gregorian' );
cmp_ok( $dts->month(), '==', 5, 'month() on 1999-05-05 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Thrimidge', 'month_name() on 1999-05-05 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-05-05 Gregorian' );
Sterday 13 Thrimidge 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63061545600, 'utc_rd_as_seconds() on 1999-05-05 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729879,
  0,
  0
]
, 'utc_rd_values() on 1999-05-05 Gregorian' );
cmp_ok( $dts->wday(), '==', 1, 'wday() on 1999-05-05 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  20
]
, 'week() on 1999-05-05 Gregorian' );
cmp_ok( $dts->week_number(), '==', 20, 'week_number() on 1999-05-05 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-05-05 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-05-05 Gregorian' );

$epoch = timegm( 0, 0, 0, 6, 5 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 5,
	day	=> 6,
    ),
);
cmp_ok( $dts->day(), '==', 14, 'day() on 1999-05-06 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sunday', 'day_name() on 1999-05-06 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sunnendei', 'day_name_trad() on 1999-05-06 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 14, 'day_of_month() on 1999-05-06 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 2, 'day_of_week() on 1999-05-06 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 135, 'day_of_year() on 1999-05-06 Gregorian' );
cmp_ok( $dts->dow(), '==', 2, 'dow() on 1999-05-06 Gregorian' );
cmp_ok( $dts->doy(), '==', 135, 'doy() on 1999-05-06 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-05-06 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-05-06 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-05-06 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-05-06 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-05-06 Gregorian' );
cmp_ok( $dts->mday(), '==', 14, 'mday() on 1999-05-06 Gregorian' );
cmp_ok( $dts->month(), '==', 5, 'month() on 1999-05-06 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Thrimidge', 'month_name() on 1999-05-06 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-05-06 Gregorian' );
Sunday 14 Thrimidge 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63061632000, 'utc_rd_as_seconds() on 1999-05-06 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729880,
  0,
  0
]
, 'utc_rd_values() on 1999-05-06 Gregorian' );
cmp_ok( $dts->wday(), '==', 2, 'wday() on 1999-05-06 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  20
]
, 'week() on 1999-05-06 Gregorian' );
cmp_ok( $dts->week_number(), '==', 20, 'week_number() on 1999-05-06 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-05-06 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-05-06 Gregorian' );

$epoch = timegm( 0, 0, 0, 7, 5 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 5,
	day	=> 7,
    ),
);
cmp_ok( $dts->day(), '==', 15, 'day() on 1999-05-07 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Monday', 'day_name() on 1999-05-07 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Monendei', 'day_name_trad() on 1999-05-07 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 15, 'day_of_month() on 1999-05-07 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 3, 'day_of_week() on 1999-05-07 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 136, 'day_of_year() on 1999-05-07 Gregorian' );
cmp_ok( $dts->dow(), '==', 3, 'dow() on 1999-05-07 Gregorian' );
cmp_ok( $dts->doy(), '==', 136, 'doy() on 1999-05-07 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-05-07 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-05-07 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-05-07 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-05-07 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-05-07 Gregorian' );
cmp_ok( $dts->mday(), '==', 15, 'mday() on 1999-05-07 Gregorian' );
cmp_ok( $dts->month(), '==', 5, 'month() on 1999-05-07 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Thrimidge', 'month_name() on 1999-05-07 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-05-07 Gregorian' );
Monday 15 Thrimidge 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63061718400, 'utc_rd_as_seconds() on 1999-05-07 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729881,
  0,
  0
]
, 'utc_rd_values() on 1999-05-07 Gregorian' );
cmp_ok( $dts->wday(), '==', 3, 'wday() on 1999-05-07 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  20
]
, 'week() on 1999-05-07 Gregorian' );
cmp_ok( $dts->week_number(), '==', 20, 'week_number() on 1999-05-07 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-05-07 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-05-07 Gregorian' );

$epoch = timegm( 0, 0, 0, 8, 5 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 5,
	day	=> 8,
    ),
);
cmp_ok( $dts->day(), '==', 16, 'day() on 1999-05-08 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Trewsday', 'day_name() on 1999-05-08 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Trewesdei', 'day_name_trad() on 1999-05-08 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 16, 'day_of_month() on 1999-05-08 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 4, 'day_of_week() on 1999-05-08 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 137, 'day_of_year() on 1999-05-08 Gregorian' );
cmp_ok( $dts->dow(), '==', 4, 'dow() on 1999-05-08 Gregorian' );
cmp_ok( $dts->doy(), '==', 137, 'doy() on 1999-05-08 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-05-08 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-05-08 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-05-08 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-05-08 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-05-08 Gregorian' );
cmp_ok( $dts->mday(), '==', 16, 'mday() on 1999-05-08 Gregorian' );
cmp_ok( $dts->month(), '==', 5, 'month() on 1999-05-08 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Thrimidge', 'month_name() on 1999-05-08 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-05-08 Gregorian' );
Trewsday 16 Thrimidge 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63061804800, 'utc_rd_as_seconds() on 1999-05-08 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729882,
  0,
  0
]
, 'utc_rd_values() on 1999-05-08 Gregorian' );
cmp_ok( $dts->wday(), '==', 4, 'wday() on 1999-05-08 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  20
]
, 'week() on 1999-05-08 Gregorian' );
cmp_ok( $dts->week_number(), '==', 20, 'week_number() on 1999-05-08 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-05-08 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-05-08 Gregorian' );

$epoch = timegm( 0, 0, 0, 9, 5 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 5,
	day	=> 9,
    ),
);
cmp_ok( $dts->day(), '==', 17, 'day() on 1999-05-09 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Hevensday', 'day_name() on 1999-05-09 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Hevenesdei', 'day_name_trad() on 1999-05-09 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 17, 'day_of_month() on 1999-05-09 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 5, 'day_of_week() on 1999-05-09 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 138, 'day_of_year() on 1999-05-09 Gregorian' );
cmp_ok( $dts->dow(), '==', 5, 'dow() on 1999-05-09 Gregorian' );
cmp_ok( $dts->doy(), '==', 138, 'doy() on 1999-05-09 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-05-09 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-05-09 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-05-09 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-05-09 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-05-09 Gregorian' );
cmp_ok( $dts->mday(), '==', 17, 'mday() on 1999-05-09 Gregorian' );
cmp_ok( $dts->month(), '==', 5, 'month() on 1999-05-09 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Thrimidge', 'month_name() on 1999-05-09 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-05-09 Gregorian' );
Hevensday 17 Thrimidge 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63061891200, 'utc_rd_as_seconds() on 1999-05-09 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729883,
  0,
  0
]
, 'utc_rd_values() on 1999-05-09 Gregorian' );
cmp_ok( $dts->wday(), '==', 5, 'wday() on 1999-05-09 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  20
]
, 'week() on 1999-05-09 Gregorian' );
cmp_ok( $dts->week_number(), '==', 20, 'week_number() on 1999-05-09 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-05-09 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-05-09 Gregorian' );

$epoch = timegm( 0, 0, 0, 10, 5 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 5,
	day	=> 10,
    ),
);
cmp_ok( $dts->day(), '==', 18, 'day() on 1999-05-10 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Mersday', 'day_name() on 1999-05-10 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Meresdei', 'day_name_trad() on 1999-05-10 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 18, 'day_of_month() on 1999-05-10 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 6, 'day_of_week() on 1999-05-10 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 139, 'day_of_year() on 1999-05-10 Gregorian' );
cmp_ok( $dts->dow(), '==', 6, 'dow() on 1999-05-10 Gregorian' );
cmp_ok( $dts->doy(), '==', 139, 'doy() on 1999-05-10 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-05-10 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-05-10 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-05-10 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-05-10 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-05-10 Gregorian' );
cmp_ok( $dts->mday(), '==', 18, 'mday() on 1999-05-10 Gregorian' );
cmp_ok( $dts->month(), '==', 5, 'month() on 1999-05-10 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Thrimidge', 'month_name() on 1999-05-10 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-05-10 Gregorian' );
Mersday 18 Thrimidge 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63061977600, 'utc_rd_as_seconds() on 1999-05-10 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729884,
  0,
  0
]
, 'utc_rd_values() on 1999-05-10 Gregorian' );
cmp_ok( $dts->wday(), '==', 6, 'wday() on 1999-05-10 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  20
]
, 'week() on 1999-05-10 Gregorian' );
cmp_ok( $dts->week_number(), '==', 20, 'week_number() on 1999-05-10 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-05-10 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-05-10 Gregorian' );

$epoch = timegm( 0, 0, 0, 11, 5 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 5,
	day	=> 11,
    ),
);
cmp_ok( $dts->day(), '==', 19, 'day() on 1999-05-11 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Highday', 'day_name() on 1999-05-11 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Highdei', 'day_name_trad() on 1999-05-11 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 19, 'day_of_month() on 1999-05-11 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 7, 'day_of_week() on 1999-05-11 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 140, 'day_of_year() on 1999-05-11 Gregorian' );
cmp_ok( $dts->dow(), '==', 7, 'dow() on 1999-05-11 Gregorian' );
cmp_ok( $dts->doy(), '==', 140, 'doy() on 1999-05-11 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-05-11 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-05-11 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-05-11 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-05-11 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-05-11 Gregorian' );
cmp_ok( $dts->mday(), '==', 19, 'mday() on 1999-05-11 Gregorian' );
cmp_ok( $dts->month(), '==', 5, 'month() on 1999-05-11 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Thrimidge', 'month_name() on 1999-05-11 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-05-11 Gregorian' );
Highday 19 Thrimidge 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63062064000, 'utc_rd_as_seconds() on 1999-05-11 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729885,
  0,
  0
]
, 'utc_rd_values() on 1999-05-11 Gregorian' );
cmp_ok( $dts->wday(), '==', 7, 'wday() on 1999-05-11 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  20
]
, 'week() on 1999-05-11 Gregorian' );
cmp_ok( $dts->week_number(), '==', 20, 'week_number() on 1999-05-11 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-05-11 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-05-11 Gregorian' );

$epoch = timegm( 0, 0, 0, 12, 5 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 5,
	day	=> 12,
    ),
);
cmp_ok( $dts->day(), '==', 20, 'day() on 1999-05-12 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sterday', 'day_name() on 1999-05-12 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sterrendei', 'day_name_trad() on 1999-05-12 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 20, 'day_of_month() on 1999-05-12 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 1, 'day_of_week() on 1999-05-12 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 141, 'day_of_year() on 1999-05-12 Gregorian' );
cmp_ok( $dts->dow(), '==', 1, 'dow() on 1999-05-12 Gregorian' );
cmp_ok( $dts->doy(), '==', 141, 'doy() on 1999-05-12 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-05-12 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-05-12 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-05-12 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-05-12 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-05-12 Gregorian' );
cmp_ok( $dts->mday(), '==', 20, 'mday() on 1999-05-12 Gregorian' );
cmp_ok( $dts->month(), '==', 5, 'month() on 1999-05-12 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Thrimidge', 'month_name() on 1999-05-12 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-05-12 Gregorian' );
Sterday 20 Thrimidge 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63062150400, 'utc_rd_as_seconds() on 1999-05-12 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729886,
  0,
  0
]
, 'utc_rd_values() on 1999-05-12 Gregorian' );
cmp_ok( $dts->wday(), '==', 1, 'wday() on 1999-05-12 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  21
]
, 'week() on 1999-05-12 Gregorian' );
cmp_ok( $dts->week_number(), '==', 21, 'week_number() on 1999-05-12 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-05-12 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-05-12 Gregorian' );

$epoch = timegm( 0, 0, 0, 13, 5 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 5,
	day	=> 13,
    ),
);
cmp_ok( $dts->day(), '==', 21, 'day() on 1999-05-13 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sunday', 'day_name() on 1999-05-13 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sunnendei', 'day_name_trad() on 1999-05-13 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 21, 'day_of_month() on 1999-05-13 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 2, 'day_of_week() on 1999-05-13 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 142, 'day_of_year() on 1999-05-13 Gregorian' );
cmp_ok( $dts->dow(), '==', 2, 'dow() on 1999-05-13 Gregorian' );
cmp_ok( $dts->doy(), '==', 142, 'doy() on 1999-05-13 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-05-13 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-05-13 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-05-13 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-05-13 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-05-13 Gregorian' );
cmp_ok( $dts->mday(), '==', 21, 'mday() on 1999-05-13 Gregorian' );
cmp_ok( $dts->month(), '==', 5, 'month() on 1999-05-13 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Thrimidge', 'month_name() on 1999-05-13 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-05-13 Gregorian' );
Sunday 21 Thrimidge 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63062236800, 'utc_rd_as_seconds() on 1999-05-13 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729887,
  0,
  0
]
, 'utc_rd_values() on 1999-05-13 Gregorian' );
cmp_ok( $dts->wday(), '==', 2, 'wday() on 1999-05-13 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  21
]
, 'week() on 1999-05-13 Gregorian' );
cmp_ok( $dts->week_number(), '==', 21, 'week_number() on 1999-05-13 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-05-13 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-05-13 Gregorian' );

$epoch = timegm( 0, 0, 0, 14, 5 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 5,
	day	=> 14,
    ),
);
cmp_ok( $dts->day(), '==', 22, 'day() on 1999-05-14 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Monday', 'day_name() on 1999-05-14 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Monendei', 'day_name_trad() on 1999-05-14 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 22, 'day_of_month() on 1999-05-14 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 3, 'day_of_week() on 1999-05-14 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 143, 'day_of_year() on 1999-05-14 Gregorian' );
cmp_ok( $dts->dow(), '==', 3, 'dow() on 1999-05-14 Gregorian' );
cmp_ok( $dts->doy(), '==', 143, 'doy() on 1999-05-14 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-05-14 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-05-14 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-05-14 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-05-14 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-05-14 Gregorian' );
cmp_ok( $dts->mday(), '==', 22, 'mday() on 1999-05-14 Gregorian' );
cmp_ok( $dts->month(), '==', 5, 'month() on 1999-05-14 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Thrimidge', 'month_name() on 1999-05-14 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-05-14 Gregorian' );
Monday 22 Thrimidge 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63062323200, 'utc_rd_as_seconds() on 1999-05-14 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729888,
  0,
  0
]
, 'utc_rd_values() on 1999-05-14 Gregorian' );
cmp_ok( $dts->wday(), '==', 3, 'wday() on 1999-05-14 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  21
]
, 'week() on 1999-05-14 Gregorian' );
cmp_ok( $dts->week_number(), '==', 21, 'week_number() on 1999-05-14 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-05-14 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-05-14 Gregorian' );

$epoch = timegm( 0, 0, 0, 15, 5 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 5,
	day	=> 15,
    ),
);
cmp_ok( $dts->day(), '==', 23, 'day() on 1999-05-15 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Trewsday', 'day_name() on 1999-05-15 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Trewesdei', 'day_name_trad() on 1999-05-15 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 23, 'day_of_month() on 1999-05-15 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 4, 'day_of_week() on 1999-05-15 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 144, 'day_of_year() on 1999-05-15 Gregorian' );
cmp_ok( $dts->dow(), '==', 4, 'dow() on 1999-05-15 Gregorian' );
cmp_ok( $dts->doy(), '==', 144, 'doy() on 1999-05-15 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-05-15 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-05-15 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-05-15 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-05-15 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-05-15 Gregorian' );
cmp_ok( $dts->mday(), '==', 23, 'mday() on 1999-05-15 Gregorian' );
cmp_ok( $dts->month(), '==', 5, 'month() on 1999-05-15 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Thrimidge', 'month_name() on 1999-05-15 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-05-15 Gregorian' );
Trewsday 23 Thrimidge 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63062409600, 'utc_rd_as_seconds() on 1999-05-15 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729889,
  0,
  0
]
, 'utc_rd_values() on 1999-05-15 Gregorian' );
cmp_ok( $dts->wday(), '==', 4, 'wday() on 1999-05-15 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  21
]
, 'week() on 1999-05-15 Gregorian' );
cmp_ok( $dts->week_number(), '==', 21, 'week_number() on 1999-05-15 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-05-15 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-05-15 Gregorian' );

$epoch = timegm( 0, 0, 0, 16, 5 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 5,
	day	=> 16,
    ),
);
cmp_ok( $dts->day(), '==', 24, 'day() on 1999-05-16 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Hevensday', 'day_name() on 1999-05-16 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Hevenesdei', 'day_name_trad() on 1999-05-16 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 24, 'day_of_month() on 1999-05-16 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 5, 'day_of_week() on 1999-05-16 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 145, 'day_of_year() on 1999-05-16 Gregorian' );
cmp_ok( $dts->dow(), '==', 5, 'dow() on 1999-05-16 Gregorian' );
cmp_ok( $dts->doy(), '==', 145, 'doy() on 1999-05-16 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-05-16 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-05-16 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-05-16 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-05-16 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-05-16 Gregorian' );
cmp_ok( $dts->mday(), '==', 24, 'mday() on 1999-05-16 Gregorian' );
cmp_ok( $dts->month(), '==', 5, 'month() on 1999-05-16 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Thrimidge', 'month_name() on 1999-05-16 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-05-16 Gregorian' );
Hevensday 24 Thrimidge 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63062496000, 'utc_rd_as_seconds() on 1999-05-16 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729890,
  0,
  0
]
, 'utc_rd_values() on 1999-05-16 Gregorian' );
cmp_ok( $dts->wday(), '==', 5, 'wday() on 1999-05-16 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  21
]
, 'week() on 1999-05-16 Gregorian' );
cmp_ok( $dts->week_number(), '==', 21, 'week_number() on 1999-05-16 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-05-16 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-05-16 Gregorian' );

$epoch = timegm( 0, 0, 0, 17, 5 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 5,
	day	=> 17,
    ),
);
cmp_ok( $dts->day(), '==', 25, 'day() on 1999-05-17 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Mersday', 'day_name() on 1999-05-17 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Meresdei', 'day_name_trad() on 1999-05-17 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 25, 'day_of_month() on 1999-05-17 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 6, 'day_of_week() on 1999-05-17 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 146, 'day_of_year() on 1999-05-17 Gregorian' );
cmp_ok( $dts->dow(), '==', 6, 'dow() on 1999-05-17 Gregorian' );
cmp_ok( $dts->doy(), '==', 146, 'doy() on 1999-05-17 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-05-17 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-05-17 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-05-17 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-05-17 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-05-17 Gregorian' );
cmp_ok( $dts->mday(), '==', 25, 'mday() on 1999-05-17 Gregorian' );
cmp_ok( $dts->month(), '==', 5, 'month() on 1999-05-17 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Thrimidge', 'month_name() on 1999-05-17 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-05-17 Gregorian' );
Mersday 25 Thrimidge 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63062582400, 'utc_rd_as_seconds() on 1999-05-17 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729891,
  0,
  0
]
, 'utc_rd_values() on 1999-05-17 Gregorian' );
cmp_ok( $dts->wday(), '==', 6, 'wday() on 1999-05-17 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  21
]
, 'week() on 1999-05-17 Gregorian' );
cmp_ok( $dts->week_number(), '==', 21, 'week_number() on 1999-05-17 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-05-17 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-05-17 Gregorian' );

$epoch = timegm( 0, 0, 0, 18, 5 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 5,
	day	=> 18,
    ),
);
cmp_ok( $dts->day(), '==', 26, 'day() on 1999-05-18 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Highday', 'day_name() on 1999-05-18 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Highdei', 'day_name_trad() on 1999-05-18 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 26, 'day_of_month() on 1999-05-18 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 7, 'day_of_week() on 1999-05-18 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 147, 'day_of_year() on 1999-05-18 Gregorian' );
cmp_ok( $dts->dow(), '==', 7, 'dow() on 1999-05-18 Gregorian' );
cmp_ok( $dts->doy(), '==', 147, 'doy() on 1999-05-18 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-05-18 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-05-18 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-05-18 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-05-18 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-05-18 Gregorian' );
cmp_ok( $dts->mday(), '==', 26, 'mday() on 1999-05-18 Gregorian' );
cmp_ok( $dts->month(), '==', 5, 'month() on 1999-05-18 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Thrimidge', 'month_name() on 1999-05-18 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-05-18 Gregorian' );
Highday 26 Thrimidge 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63062668800, 'utc_rd_as_seconds() on 1999-05-18 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729892,
  0,
  0
]
, 'utc_rd_values() on 1999-05-18 Gregorian' );
cmp_ok( $dts->wday(), '==', 7, 'wday() on 1999-05-18 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  21
]
, 'week() on 1999-05-18 Gregorian' );
cmp_ok( $dts->week_number(), '==', 21, 'week_number() on 1999-05-18 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-05-18 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-05-18 Gregorian' );

$epoch = timegm( 0, 0, 0, 19, 5 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 5,
	day	=> 19,
    ),
);
cmp_ok( $dts->day(), '==', 27, 'day() on 1999-05-19 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sterday', 'day_name() on 1999-05-19 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sterrendei', 'day_name_trad() on 1999-05-19 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 27, 'day_of_month() on 1999-05-19 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 1, 'day_of_week() on 1999-05-19 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 148, 'day_of_year() on 1999-05-19 Gregorian' );
cmp_ok( $dts->dow(), '==', 1, 'dow() on 1999-05-19 Gregorian' );
cmp_ok( $dts->doy(), '==', 148, 'doy() on 1999-05-19 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-05-19 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-05-19 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-05-19 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-05-19 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-05-19 Gregorian' );
cmp_ok( $dts->mday(), '==', 27, 'mday() on 1999-05-19 Gregorian' );
cmp_ok( $dts->month(), '==', 5, 'month() on 1999-05-19 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Thrimidge', 'month_name() on 1999-05-19 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-05-19 Gregorian' );
Sterday 27 Thrimidge 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63062755200, 'utc_rd_as_seconds() on 1999-05-19 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729893,
  0,
  0
]
, 'utc_rd_values() on 1999-05-19 Gregorian' );
cmp_ok( $dts->wday(), '==', 1, 'wday() on 1999-05-19 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  22
]
, 'week() on 1999-05-19 Gregorian' );
cmp_ok( $dts->week_number(), '==', 22, 'week_number() on 1999-05-19 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-05-19 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-05-19 Gregorian' );

$epoch = timegm( 0, 0, 0, 20, 5 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 5,
	day	=> 20,
    ),
);
cmp_ok( $dts->day(), '==', 28, 'day() on 1999-05-20 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sunday', 'day_name() on 1999-05-20 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sunnendei', 'day_name_trad() on 1999-05-20 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 28, 'day_of_month() on 1999-05-20 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 2, 'day_of_week() on 1999-05-20 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 149, 'day_of_year() on 1999-05-20 Gregorian' );
cmp_ok( $dts->dow(), '==', 2, 'dow() on 1999-05-20 Gregorian' );
cmp_ok( $dts->doy(), '==', 149, 'doy() on 1999-05-20 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-05-20 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-05-20 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-05-20 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-05-20 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-05-20 Gregorian' );
cmp_ok( $dts->mday(), '==', 28, 'mday() on 1999-05-20 Gregorian' );
cmp_ok( $dts->month(), '==', 5, 'month() on 1999-05-20 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Thrimidge', 'month_name() on 1999-05-20 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-05-20 Gregorian' );
Sunday 28 Thrimidge 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63062841600, 'utc_rd_as_seconds() on 1999-05-20 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729894,
  0,
  0
]
, 'utc_rd_values() on 1999-05-20 Gregorian' );
cmp_ok( $dts->wday(), '==', 2, 'wday() on 1999-05-20 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  22
]
, 'week() on 1999-05-20 Gregorian' );
cmp_ok( $dts->week_number(), '==', 22, 'week_number() on 1999-05-20 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-05-20 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-05-20 Gregorian' );

$epoch = timegm( 0, 0, 0, 21, 5 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 5,
	day	=> 21,
    ),
);
cmp_ok( $dts->day(), '==', 29, 'day() on 1999-05-21 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Monday', 'day_name() on 1999-05-21 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Monendei', 'day_name_trad() on 1999-05-21 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 29, 'day_of_month() on 1999-05-21 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 3, 'day_of_week() on 1999-05-21 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 150, 'day_of_year() on 1999-05-21 Gregorian' );
cmp_ok( $dts->dow(), '==', 3, 'dow() on 1999-05-21 Gregorian' );
cmp_ok( $dts->doy(), '==', 150, 'doy() on 1999-05-21 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-05-21 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-05-21 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-05-21 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-05-21 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-05-21 Gregorian' );
cmp_ok( $dts->mday(), '==', 29, 'mday() on 1999-05-21 Gregorian' );
cmp_ok( $dts->month(), '==', 5, 'month() on 1999-05-21 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Thrimidge', 'month_name() on 1999-05-21 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-05-21 Gregorian' );
Monday 29 Thrimidge 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63062928000, 'utc_rd_as_seconds() on 1999-05-21 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729895,
  0,
  0
]
, 'utc_rd_values() on 1999-05-21 Gregorian' );
cmp_ok( $dts->wday(), '==', 3, 'wday() on 1999-05-21 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  22
]
, 'week() on 1999-05-21 Gregorian' );
cmp_ok( $dts->week_number(), '==', 22, 'week_number() on 1999-05-21 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-05-21 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-05-21 Gregorian' );

$epoch = timegm( 0, 0, 0, 22, 5 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 5,
	day	=> 22,
    ),
);
cmp_ok( $dts->day(), '==', 30, 'day() on 1999-05-22 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Trewsday', 'day_name() on 1999-05-22 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Trewesdei', 'day_name_trad() on 1999-05-22 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 30, 'day_of_month() on 1999-05-22 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 4, 'day_of_week() on 1999-05-22 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 151, 'day_of_year() on 1999-05-22 Gregorian' );
cmp_ok( $dts->dow(), '==', 4, 'dow() on 1999-05-22 Gregorian' );
cmp_ok( $dts->doy(), '==', 151, 'doy() on 1999-05-22 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-05-22 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-05-22 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-05-22 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-05-22 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-05-22 Gregorian' );
cmp_ok( $dts->mday(), '==', 30, 'mday() on 1999-05-22 Gregorian' );
cmp_ok( $dts->month(), '==', 5, 'month() on 1999-05-22 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Thrimidge', 'month_name() on 1999-05-22 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-05-22 Gregorian' );
Trewsday 30 Thrimidge 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63063014400, 'utc_rd_as_seconds() on 1999-05-22 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729896,
  0,
  0
]
, 'utc_rd_values() on 1999-05-22 Gregorian' );
cmp_ok( $dts->wday(), '==', 4, 'wday() on 1999-05-22 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  22
]
, 'week() on 1999-05-22 Gregorian' );
cmp_ok( $dts->week_number(), '==', 22, 'week_number() on 1999-05-22 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-05-22 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-05-22 Gregorian' );

$epoch = timegm( 0, 0, 0, 23, 5 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 5,
	day	=> 23,
    ),
);
cmp_ok( $dts->day(), '==', 1, 'day() on 1999-05-23 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Hevensday', 'day_name() on 1999-05-23 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Hevenesdei', 'day_name_trad() on 1999-05-23 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 1, 'day_of_month() on 1999-05-23 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 5, 'day_of_week() on 1999-05-23 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 152, 'day_of_year() on 1999-05-23 Gregorian' );
cmp_ok( $dts->dow(), '==', 5, 'dow() on 1999-05-23 Gregorian' );
cmp_ok( $dts->doy(), '==', 152, 'doy() on 1999-05-23 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-05-23 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-05-23 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-05-23 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-05-23 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-05-23 Gregorian' );
cmp_ok( $dts->mday(), '==', 1, 'mday() on 1999-05-23 Gregorian' );
cmp_ok( $dts->month(), '==', 6, 'month() on 1999-05-23 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Forelithe', 'month_name() on 1999-05-23 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-05-23 Gregorian' );
Hevensday 1 Forelithe 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63063100800, 'utc_rd_as_seconds() on 1999-05-23 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729897,
  0,
  0
]
, 'utc_rd_values() on 1999-05-23 Gregorian' );
cmp_ok( $dts->wday(), '==', 5, 'wday() on 1999-05-23 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  22
]
, 'week() on 1999-05-23 Gregorian' );
cmp_ok( $dts->week_number(), '==', 22, 'week_number() on 1999-05-23 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-05-23 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-05-23 Gregorian' );

$epoch = timegm( 0, 0, 0, 24, 5 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 5,
	day	=> 24,
    ),
);
cmp_ok( $dts->day(), '==', 2, 'day() on 1999-05-24 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Mersday', 'day_name() on 1999-05-24 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Meresdei', 'day_name_trad() on 1999-05-24 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 2, 'day_of_month() on 1999-05-24 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 6, 'day_of_week() on 1999-05-24 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 153, 'day_of_year() on 1999-05-24 Gregorian' );
cmp_ok( $dts->dow(), '==', 6, 'dow() on 1999-05-24 Gregorian' );
cmp_ok( $dts->doy(), '==', 153, 'doy() on 1999-05-24 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-05-24 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-05-24 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-05-24 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-05-24 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-05-24 Gregorian' );
cmp_ok( $dts->mday(), '==', 2, 'mday() on 1999-05-24 Gregorian' );
cmp_ok( $dts->month(), '==', 6, 'month() on 1999-05-24 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Forelithe', 'month_name() on 1999-05-24 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-05-24 Gregorian' );
Mersday 2 Forelithe 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63063187200, 'utc_rd_as_seconds() on 1999-05-24 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729898,
  0,
  0
]
, 'utc_rd_values() on 1999-05-24 Gregorian' );
cmp_ok( $dts->wday(), '==', 6, 'wday() on 1999-05-24 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  22
]
, 'week() on 1999-05-24 Gregorian' );
cmp_ok( $dts->week_number(), '==', 22, 'week_number() on 1999-05-24 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-05-24 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-05-24 Gregorian' );

$epoch = timegm( 0, 0, 0, 25, 5 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 5,
	day	=> 25,
    ),
);
cmp_ok( $dts->day(), '==', 3, 'day() on 1999-05-25 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Highday', 'day_name() on 1999-05-25 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Highdei', 'day_name_trad() on 1999-05-25 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 3, 'day_of_month() on 1999-05-25 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 7, 'day_of_week() on 1999-05-25 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 154, 'day_of_year() on 1999-05-25 Gregorian' );
cmp_ok( $dts->dow(), '==', 7, 'dow() on 1999-05-25 Gregorian' );
cmp_ok( $dts->doy(), '==', 154, 'doy() on 1999-05-25 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-05-25 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-05-25 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-05-25 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-05-25 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-05-25 Gregorian' );
cmp_ok( $dts->mday(), '==', 3, 'mday() on 1999-05-25 Gregorian' );
cmp_ok( $dts->month(), '==', 6, 'month() on 1999-05-25 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Forelithe', 'month_name() on 1999-05-25 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-05-25 Gregorian' );
Highday 3 Forelithe 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63063273600, 'utc_rd_as_seconds() on 1999-05-25 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729899,
  0,
  0
]
, 'utc_rd_values() on 1999-05-25 Gregorian' );
cmp_ok( $dts->wday(), '==', 7, 'wday() on 1999-05-25 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  22
]
, 'week() on 1999-05-25 Gregorian' );
cmp_ok( $dts->week_number(), '==', 22, 'week_number() on 1999-05-25 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-05-25 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-05-25 Gregorian' );

$epoch = timegm( 0, 0, 0, 26, 5 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 5,
	day	=> 26,
    ),
);
cmp_ok( $dts->day(), '==', 4, 'day() on 1999-05-26 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sterday', 'day_name() on 1999-05-26 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sterrendei', 'day_name_trad() on 1999-05-26 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 4, 'day_of_month() on 1999-05-26 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 1, 'day_of_week() on 1999-05-26 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 155, 'day_of_year() on 1999-05-26 Gregorian' );
cmp_ok( $dts->dow(), '==', 1, 'dow() on 1999-05-26 Gregorian' );
cmp_ok( $dts->doy(), '==', 155, 'doy() on 1999-05-26 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-05-26 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-05-26 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-05-26 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-05-26 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-05-26 Gregorian' );
cmp_ok( $dts->mday(), '==', 4, 'mday() on 1999-05-26 Gregorian' );
cmp_ok( $dts->month(), '==', 6, 'month() on 1999-05-26 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Forelithe', 'month_name() on 1999-05-26 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-05-26 Gregorian' );
Sterday 4 Forelithe 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63063360000, 'utc_rd_as_seconds() on 1999-05-26 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729900,
  0,
  0
]
, 'utc_rd_values() on 1999-05-26 Gregorian' );
cmp_ok( $dts->wday(), '==', 1, 'wday() on 1999-05-26 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  23
]
, 'week() on 1999-05-26 Gregorian' );
cmp_ok( $dts->week_number(), '==', 23, 'week_number() on 1999-05-26 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-05-26 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-05-26 Gregorian' );

$epoch = timegm( 0, 0, 0, 27, 5 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 5,
	day	=> 27,
    ),
);
cmp_ok( $dts->day(), '==', 5, 'day() on 1999-05-27 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sunday', 'day_name() on 1999-05-27 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sunnendei', 'day_name_trad() on 1999-05-27 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 5, 'day_of_month() on 1999-05-27 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 2, 'day_of_week() on 1999-05-27 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 156, 'day_of_year() on 1999-05-27 Gregorian' );
cmp_ok( $dts->dow(), '==', 2, 'dow() on 1999-05-27 Gregorian' );
cmp_ok( $dts->doy(), '==', 156, 'doy() on 1999-05-27 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-05-27 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-05-27 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-05-27 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-05-27 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-05-27 Gregorian' );
cmp_ok( $dts->mday(), '==', 5, 'mday() on 1999-05-27 Gregorian' );
cmp_ok( $dts->month(), '==', 6, 'month() on 1999-05-27 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Forelithe', 'month_name() on 1999-05-27 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-05-27 Gregorian' );
Sunday 5 Forelithe 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63063446400, 'utc_rd_as_seconds() on 1999-05-27 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729901,
  0,
  0
]
, 'utc_rd_values() on 1999-05-27 Gregorian' );
cmp_ok( $dts->wday(), '==', 2, 'wday() on 1999-05-27 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  23
]
, 'week() on 1999-05-27 Gregorian' );
cmp_ok( $dts->week_number(), '==', 23, 'week_number() on 1999-05-27 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-05-27 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-05-27 Gregorian' );

$epoch = timegm( 0, 0, 0, 28, 5 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 5,
	day	=> 28,
    ),
);
cmp_ok( $dts->day(), '==', 6, 'day() on 1999-05-28 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Monday', 'day_name() on 1999-05-28 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Monendei', 'day_name_trad() on 1999-05-28 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 6, 'day_of_month() on 1999-05-28 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 3, 'day_of_week() on 1999-05-28 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 157, 'day_of_year() on 1999-05-28 Gregorian' );
cmp_ok( $dts->dow(), '==', 3, 'dow() on 1999-05-28 Gregorian' );
cmp_ok( $dts->doy(), '==', 157, 'doy() on 1999-05-28 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-05-28 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-05-28 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-05-28 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-05-28 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-05-28 Gregorian' );
cmp_ok( $dts->mday(), '==', 6, 'mday() on 1999-05-28 Gregorian' );
cmp_ok( $dts->month(), '==', 6, 'month() on 1999-05-28 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Forelithe', 'month_name() on 1999-05-28 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-05-28 Gregorian' );
Monday 6 Forelithe 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63063532800, 'utc_rd_as_seconds() on 1999-05-28 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729902,
  0,
  0
]
, 'utc_rd_values() on 1999-05-28 Gregorian' );
cmp_ok( $dts->wday(), '==', 3, 'wday() on 1999-05-28 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  23
]
, 'week() on 1999-05-28 Gregorian' );
cmp_ok( $dts->week_number(), '==', 23, 'week_number() on 1999-05-28 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-05-28 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-05-28 Gregorian' );

$epoch = timegm( 0, 0, 0, 29, 5 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 5,
	day	=> 29,
    ),
);
cmp_ok( $dts->day(), '==', 7, 'day() on 1999-05-29 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Trewsday', 'day_name() on 1999-05-29 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Trewesdei', 'day_name_trad() on 1999-05-29 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 7, 'day_of_month() on 1999-05-29 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 4, 'day_of_week() on 1999-05-29 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 158, 'day_of_year() on 1999-05-29 Gregorian' );
cmp_ok( $dts->dow(), '==', 4, 'dow() on 1999-05-29 Gregorian' );
cmp_ok( $dts->doy(), '==', 158, 'doy() on 1999-05-29 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-05-29 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-05-29 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-05-29 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-05-29 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-05-29 Gregorian' );
cmp_ok( $dts->mday(), '==', 7, 'mday() on 1999-05-29 Gregorian' );
cmp_ok( $dts->month(), '==', 6, 'month() on 1999-05-29 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Forelithe', 'month_name() on 1999-05-29 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-05-29 Gregorian' );
Trewsday 7 Forelithe 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63063619200, 'utc_rd_as_seconds() on 1999-05-29 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729903,
  0,
  0
]
, 'utc_rd_values() on 1999-05-29 Gregorian' );
cmp_ok( $dts->wday(), '==', 4, 'wday() on 1999-05-29 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  23
]
, 'week() on 1999-05-29 Gregorian' );
cmp_ok( $dts->week_number(), '==', 23, 'week_number() on 1999-05-29 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-05-29 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-05-29 Gregorian' );

$epoch = timegm( 0, 0, 0, 30, 5 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 5,
	day	=> 30,
    ),
);
cmp_ok( $dts->day(), '==', 8, 'day() on 1999-05-30 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Hevensday', 'day_name() on 1999-05-30 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Hevenesdei', 'day_name_trad() on 1999-05-30 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 8, 'day_of_month() on 1999-05-30 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 5, 'day_of_week() on 1999-05-30 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 159, 'day_of_year() on 1999-05-30 Gregorian' );
cmp_ok( $dts->dow(), '==', 5, 'dow() on 1999-05-30 Gregorian' );
cmp_ok( $dts->doy(), '==', 159, 'doy() on 1999-05-30 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-05-30 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-05-30 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-05-30 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-05-30 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-05-30 Gregorian' );
cmp_ok( $dts->mday(), '==', 8, 'mday() on 1999-05-30 Gregorian' );
cmp_ok( $dts->month(), '==', 6, 'month() on 1999-05-30 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Forelithe', 'month_name() on 1999-05-30 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-05-30 Gregorian' );
Hevensday 8 Forelithe 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63063705600, 'utc_rd_as_seconds() on 1999-05-30 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729904,
  0,
  0
]
, 'utc_rd_values() on 1999-05-30 Gregorian' );
cmp_ok( $dts->wday(), '==', 5, 'wday() on 1999-05-30 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  23
]
, 'week() on 1999-05-30 Gregorian' );
cmp_ok( $dts->week_number(), '==', 23, 'week_number() on 1999-05-30 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-05-30 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-05-30 Gregorian' );

$epoch = timegm( 0, 0, 0, 31, 5 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 5,
	day	=> 31,
    ),
);
cmp_ok( $dts->day(), '==', 9, 'day() on 1999-05-31 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Mersday', 'day_name() on 1999-05-31 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Meresdei', 'day_name_trad() on 1999-05-31 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 9, 'day_of_month() on 1999-05-31 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 6, 'day_of_week() on 1999-05-31 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 160, 'day_of_year() on 1999-05-31 Gregorian' );
cmp_ok( $dts->dow(), '==', 6, 'dow() on 1999-05-31 Gregorian' );
cmp_ok( $dts->doy(), '==', 160, 'doy() on 1999-05-31 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-05-31 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-05-31 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-05-31 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-05-31 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-05-31 Gregorian' );
cmp_ok( $dts->mday(), '==', 9, 'mday() on 1999-05-31 Gregorian' );
cmp_ok( $dts->month(), '==', 6, 'month() on 1999-05-31 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Forelithe', 'month_name() on 1999-05-31 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-05-31 Gregorian' );
Mersday 9 Forelithe 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63063792000, 'utc_rd_as_seconds() on 1999-05-31 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729905,
  0,
  0
]
, 'utc_rd_values() on 1999-05-31 Gregorian' );
cmp_ok( $dts->wday(), '==', 6, 'wday() on 1999-05-31 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  23
]
, 'week() on 1999-05-31 Gregorian' );
cmp_ok( $dts->week_number(), '==', 23, 'week_number() on 1999-05-31 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-05-31 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-05-31 Gregorian' );

$epoch = timegm( 0, 0, 0, 1, 6 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 6,
	day	=> 1,
    ),
);
cmp_ok( $dts->day(), '==', 10, 'day() on 1999-06-01 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Highday', 'day_name() on 1999-06-01 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Highdei', 'day_name_trad() on 1999-06-01 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 10, 'day_of_month() on 1999-06-01 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 7, 'day_of_week() on 1999-06-01 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 161, 'day_of_year() on 1999-06-01 Gregorian' );
cmp_ok( $dts->dow(), '==', 7, 'dow() on 1999-06-01 Gregorian' );
cmp_ok( $dts->doy(), '==', 161, 'doy() on 1999-06-01 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-06-01 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-06-01 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-06-01 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-06-01 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-06-01 Gregorian' );
cmp_ok( $dts->mday(), '==', 10, 'mday() on 1999-06-01 Gregorian' );
cmp_ok( $dts->month(), '==', 6, 'month() on 1999-06-01 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Forelithe', 'month_name() on 1999-06-01 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-06-01 Gregorian' );
Highday 10 Forelithe 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63063878400, 'utc_rd_as_seconds() on 1999-06-01 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729906,
  0,
  0
]
, 'utc_rd_values() on 1999-06-01 Gregorian' );
cmp_ok( $dts->wday(), '==', 7, 'wday() on 1999-06-01 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  23
]
, 'week() on 1999-06-01 Gregorian' );
cmp_ok( $dts->week_number(), '==', 23, 'week_number() on 1999-06-01 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-06-01 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-06-01 Gregorian' );

$epoch = timegm( 0, 0, 0, 2, 6 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 6,
	day	=> 2,
    ),
);
cmp_ok( $dts->day(), '==', 11, 'day() on 1999-06-02 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sterday', 'day_name() on 1999-06-02 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sterrendei', 'day_name_trad() on 1999-06-02 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 11, 'day_of_month() on 1999-06-02 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 1, 'day_of_week() on 1999-06-02 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 162, 'day_of_year() on 1999-06-02 Gregorian' );
cmp_ok( $dts->dow(), '==', 1, 'dow() on 1999-06-02 Gregorian' );
cmp_ok( $dts->doy(), '==', 162, 'doy() on 1999-06-02 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-06-02 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-06-02 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-06-02 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-06-02 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-06-02 Gregorian' );
cmp_ok( $dts->mday(), '==', 11, 'mday() on 1999-06-02 Gregorian' );
cmp_ok( $dts->month(), '==', 6, 'month() on 1999-06-02 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Forelithe', 'month_name() on 1999-06-02 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-06-02 Gregorian' );
Sterday 11 Forelithe 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63063964800, 'utc_rd_as_seconds() on 1999-06-02 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729907,
  0,
  0
]
, 'utc_rd_values() on 1999-06-02 Gregorian' );
cmp_ok( $dts->wday(), '==', 1, 'wday() on 1999-06-02 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  24
]
, 'week() on 1999-06-02 Gregorian' );
cmp_ok( $dts->week_number(), '==', 24, 'week_number() on 1999-06-02 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-06-02 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-06-02 Gregorian' );

$epoch = timegm( 0, 0, 0, 3, 6 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 6,
	day	=> 3,
    ),
);
cmp_ok( $dts->day(), '==', 12, 'day() on 1999-06-03 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sunday', 'day_name() on 1999-06-03 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sunnendei', 'day_name_trad() on 1999-06-03 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 12, 'day_of_month() on 1999-06-03 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 2, 'day_of_week() on 1999-06-03 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 163, 'day_of_year() on 1999-06-03 Gregorian' );
cmp_ok( $dts->dow(), '==', 2, 'dow() on 1999-06-03 Gregorian' );
cmp_ok( $dts->doy(), '==', 163, 'doy() on 1999-06-03 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-06-03 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-06-03 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-06-03 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-06-03 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-06-03 Gregorian' );
cmp_ok( $dts->mday(), '==', 12, 'mday() on 1999-06-03 Gregorian' );
cmp_ok( $dts->month(), '==', 6, 'month() on 1999-06-03 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Forelithe', 'month_name() on 1999-06-03 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-06-03 Gregorian' );
Sunday 12 Forelithe 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63064051200, 'utc_rd_as_seconds() on 1999-06-03 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729908,
  0,
  0
]
, 'utc_rd_values() on 1999-06-03 Gregorian' );
cmp_ok( $dts->wday(), '==', 2, 'wday() on 1999-06-03 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  24
]
, 'week() on 1999-06-03 Gregorian' );
cmp_ok( $dts->week_number(), '==', 24, 'week_number() on 1999-06-03 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-06-03 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-06-03 Gregorian' );

$epoch = timegm( 0, 0, 0, 4, 6 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 6,
	day	=> 4,
    ),
);
cmp_ok( $dts->day(), '==', 13, 'day() on 1999-06-04 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Monday', 'day_name() on 1999-06-04 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Monendei', 'day_name_trad() on 1999-06-04 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 13, 'day_of_month() on 1999-06-04 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 3, 'day_of_week() on 1999-06-04 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 164, 'day_of_year() on 1999-06-04 Gregorian' );
cmp_ok( $dts->dow(), '==', 3, 'dow() on 1999-06-04 Gregorian' );
cmp_ok( $dts->doy(), '==', 164, 'doy() on 1999-06-04 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-06-04 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-06-04 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-06-04 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-06-04 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-06-04 Gregorian' );
cmp_ok( $dts->mday(), '==', 13, 'mday() on 1999-06-04 Gregorian' );
cmp_ok( $dts->month(), '==', 6, 'month() on 1999-06-04 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Forelithe', 'month_name() on 1999-06-04 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-06-04 Gregorian' );
Monday 13 Forelithe 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63064137600, 'utc_rd_as_seconds() on 1999-06-04 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729909,
  0,
  0
]
, 'utc_rd_values() on 1999-06-04 Gregorian' );
cmp_ok( $dts->wday(), '==', 3, 'wday() on 1999-06-04 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  24
]
, 'week() on 1999-06-04 Gregorian' );
cmp_ok( $dts->week_number(), '==', 24, 'week_number() on 1999-06-04 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-06-04 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-06-04 Gregorian' );

$epoch = timegm( 0, 0, 0, 5, 6 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 6,
	day	=> 5,
    ),
);
cmp_ok( $dts->day(), '==', 14, 'day() on 1999-06-05 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Trewsday', 'day_name() on 1999-06-05 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Trewesdei', 'day_name_trad() on 1999-06-05 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 14, 'day_of_month() on 1999-06-05 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 4, 'day_of_week() on 1999-06-05 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 165, 'day_of_year() on 1999-06-05 Gregorian' );
cmp_ok( $dts->dow(), '==', 4, 'dow() on 1999-06-05 Gregorian' );
cmp_ok( $dts->doy(), '==', 165, 'doy() on 1999-06-05 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-06-05 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-06-05 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-06-05 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-06-05 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-06-05 Gregorian' );
cmp_ok( $dts->mday(), '==', 14, 'mday() on 1999-06-05 Gregorian' );
cmp_ok( $dts->month(), '==', 6, 'month() on 1999-06-05 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Forelithe', 'month_name() on 1999-06-05 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-06-05 Gregorian' );
Trewsday 14 Forelithe 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63064224000, 'utc_rd_as_seconds() on 1999-06-05 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729910,
  0,
  0
]
, 'utc_rd_values() on 1999-06-05 Gregorian' );
cmp_ok( $dts->wday(), '==', 4, 'wday() on 1999-06-05 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  24
]
, 'week() on 1999-06-05 Gregorian' );
cmp_ok( $dts->week_number(), '==', 24, 'week_number() on 1999-06-05 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-06-05 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-06-05 Gregorian' );

$epoch = timegm( 0, 0, 0, 6, 6 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 6,
	day	=> 6,
    ),
);
cmp_ok( $dts->day(), '==', 15, 'day() on 1999-06-06 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Hevensday', 'day_name() on 1999-06-06 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Hevenesdei', 'day_name_trad() on 1999-06-06 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 15, 'day_of_month() on 1999-06-06 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 5, 'day_of_week() on 1999-06-06 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 166, 'day_of_year() on 1999-06-06 Gregorian' );
cmp_ok( $dts->dow(), '==', 5, 'dow() on 1999-06-06 Gregorian' );
cmp_ok( $dts->doy(), '==', 166, 'doy() on 1999-06-06 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-06-06 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-06-06 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-06-06 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-06-06 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-06-06 Gregorian' );
cmp_ok( $dts->mday(), '==', 15, 'mday() on 1999-06-06 Gregorian' );
cmp_ok( $dts->month(), '==', 6, 'month() on 1999-06-06 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Forelithe', 'month_name() on 1999-06-06 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-06-06 Gregorian' );
Hevensday 15 Forelithe 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63064310400, 'utc_rd_as_seconds() on 1999-06-06 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729911,
  0,
  0
]
, 'utc_rd_values() on 1999-06-06 Gregorian' );
cmp_ok( $dts->wday(), '==', 5, 'wday() on 1999-06-06 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  24
]
, 'week() on 1999-06-06 Gregorian' );
cmp_ok( $dts->week_number(), '==', 24, 'week_number() on 1999-06-06 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-06-06 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-06-06 Gregorian' );

$epoch = timegm( 0, 0, 0, 7, 6 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 6,
	day	=> 7,
    ),
);
cmp_ok( $dts->day(), '==', 16, 'day() on 1999-06-07 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Mersday', 'day_name() on 1999-06-07 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Meresdei', 'day_name_trad() on 1999-06-07 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 16, 'day_of_month() on 1999-06-07 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 6, 'day_of_week() on 1999-06-07 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 167, 'day_of_year() on 1999-06-07 Gregorian' );
cmp_ok( $dts->dow(), '==', 6, 'dow() on 1999-06-07 Gregorian' );
cmp_ok( $dts->doy(), '==', 167, 'doy() on 1999-06-07 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-06-07 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-06-07 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-06-07 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-06-07 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-06-07 Gregorian' );
cmp_ok( $dts->mday(), '==', 16, 'mday() on 1999-06-07 Gregorian' );
cmp_ok( $dts->month(), '==', 6, 'month() on 1999-06-07 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Forelithe', 'month_name() on 1999-06-07 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-06-07 Gregorian' );
Mersday 16 Forelithe 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63064396800, 'utc_rd_as_seconds() on 1999-06-07 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729912,
  0,
  0
]
, 'utc_rd_values() on 1999-06-07 Gregorian' );
cmp_ok( $dts->wday(), '==', 6, 'wday() on 1999-06-07 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  24
]
, 'week() on 1999-06-07 Gregorian' );
cmp_ok( $dts->week_number(), '==', 24, 'week_number() on 1999-06-07 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-06-07 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-06-07 Gregorian' );

$epoch = timegm( 0, 0, 0, 8, 6 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 6,
	day	=> 8,
    ),
);
cmp_ok( $dts->day(), '==', 17, 'day() on 1999-06-08 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Highday', 'day_name() on 1999-06-08 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Highdei', 'day_name_trad() on 1999-06-08 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 17, 'day_of_month() on 1999-06-08 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 7, 'day_of_week() on 1999-06-08 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 168, 'day_of_year() on 1999-06-08 Gregorian' );
cmp_ok( $dts->dow(), '==', 7, 'dow() on 1999-06-08 Gregorian' );
cmp_ok( $dts->doy(), '==', 168, 'doy() on 1999-06-08 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-06-08 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-06-08 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-06-08 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-06-08 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-06-08 Gregorian' );
cmp_ok( $dts->mday(), '==', 17, 'mday() on 1999-06-08 Gregorian' );
cmp_ok( $dts->month(), '==', 6, 'month() on 1999-06-08 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Forelithe', 'month_name() on 1999-06-08 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-06-08 Gregorian' );
Highday 17 Forelithe 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63064483200, 'utc_rd_as_seconds() on 1999-06-08 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729913,
  0,
  0
]
, 'utc_rd_values() on 1999-06-08 Gregorian' );
cmp_ok( $dts->wday(), '==', 7, 'wday() on 1999-06-08 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  24
]
, 'week() on 1999-06-08 Gregorian' );
cmp_ok( $dts->week_number(), '==', 24, 'week_number() on 1999-06-08 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-06-08 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-06-08 Gregorian' );

$epoch = timegm( 0, 0, 0, 9, 6 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 6,
	day	=> 9,
    ),
);
cmp_ok( $dts->day(), '==', 18, 'day() on 1999-06-09 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sterday', 'day_name() on 1999-06-09 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sterrendei', 'day_name_trad() on 1999-06-09 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 18, 'day_of_month() on 1999-06-09 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 1, 'day_of_week() on 1999-06-09 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 169, 'day_of_year() on 1999-06-09 Gregorian' );
cmp_ok( $dts->dow(), '==', 1, 'dow() on 1999-06-09 Gregorian' );
cmp_ok( $dts->doy(), '==', 169, 'doy() on 1999-06-09 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-06-09 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-06-09 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-06-09 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-06-09 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-06-09 Gregorian' );
cmp_ok( $dts->mday(), '==', 18, 'mday() on 1999-06-09 Gregorian' );
cmp_ok( $dts->month(), '==', 6, 'month() on 1999-06-09 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Forelithe', 'month_name() on 1999-06-09 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-06-09 Gregorian' );
Sterday 18 Forelithe 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63064569600, 'utc_rd_as_seconds() on 1999-06-09 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729914,
  0,
  0
]
, 'utc_rd_values() on 1999-06-09 Gregorian' );
cmp_ok( $dts->wday(), '==', 1, 'wday() on 1999-06-09 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  25
]
, 'week() on 1999-06-09 Gregorian' );
cmp_ok( $dts->week_number(), '==', 25, 'week_number() on 1999-06-09 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-06-09 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-06-09 Gregorian' );

$epoch = timegm( 0, 0, 0, 10, 6 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 6,
	day	=> 10,
    ),
);
cmp_ok( $dts->day(), '==', 19, 'day() on 1999-06-10 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sunday', 'day_name() on 1999-06-10 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sunnendei', 'day_name_trad() on 1999-06-10 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 19, 'day_of_month() on 1999-06-10 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 2, 'day_of_week() on 1999-06-10 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 170, 'day_of_year() on 1999-06-10 Gregorian' );
cmp_ok( $dts->dow(), '==', 2, 'dow() on 1999-06-10 Gregorian' );
cmp_ok( $dts->doy(), '==', 170, 'doy() on 1999-06-10 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-06-10 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-06-10 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-06-10 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-06-10 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-06-10 Gregorian' );
cmp_ok( $dts->mday(), '==', 19, 'mday() on 1999-06-10 Gregorian' );
cmp_ok( $dts->month(), '==', 6, 'month() on 1999-06-10 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Forelithe', 'month_name() on 1999-06-10 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-06-10 Gregorian' );
Sunday 19 Forelithe 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63064656000, 'utc_rd_as_seconds() on 1999-06-10 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729915,
  0,
  0
]
, 'utc_rd_values() on 1999-06-10 Gregorian' );
cmp_ok( $dts->wday(), '==', 2, 'wday() on 1999-06-10 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  25
]
, 'week() on 1999-06-10 Gregorian' );
cmp_ok( $dts->week_number(), '==', 25, 'week_number() on 1999-06-10 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-06-10 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-06-10 Gregorian' );

$epoch = timegm( 0, 0, 0, 11, 6 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 6,
	day	=> 11,
    ),
);
cmp_ok( $dts->day(), '==', 20, 'day() on 1999-06-11 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Monday', 'day_name() on 1999-06-11 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Monendei', 'day_name_trad() on 1999-06-11 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 20, 'day_of_month() on 1999-06-11 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 3, 'day_of_week() on 1999-06-11 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 171, 'day_of_year() on 1999-06-11 Gregorian' );
cmp_ok( $dts->dow(), '==', 3, 'dow() on 1999-06-11 Gregorian' );
cmp_ok( $dts->doy(), '==', 171, 'doy() on 1999-06-11 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-06-11 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-06-11 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-06-11 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-06-11 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-06-11 Gregorian' );
cmp_ok( $dts->mday(), '==', 20, 'mday() on 1999-06-11 Gregorian' );
cmp_ok( $dts->month(), '==', 6, 'month() on 1999-06-11 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Forelithe', 'month_name() on 1999-06-11 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-06-11 Gregorian' );
Monday 20 Forelithe 7463

Sauron attacks Osgiliath, 1418.
Thranduil is attacked, and Gollum escapes, 1418.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63064742400, 'utc_rd_as_seconds() on 1999-06-11 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729916,
  0,
  0
]
, 'utc_rd_values() on 1999-06-11 Gregorian' );
cmp_ok( $dts->wday(), '==', 3, 'wday() on 1999-06-11 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  25
]
, 'week() on 1999-06-11 Gregorian' );
cmp_ok( $dts->week_number(), '==', 25, 'week_number() on 1999-06-11 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-06-11 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-06-11 Gregorian' );

$epoch = timegm( 0, 0, 0, 12, 6 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 6,
	day	=> 12,
    ),
);
cmp_ok( $dts->day(), '==', 21, 'day() on 1999-06-12 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Trewsday', 'day_name() on 1999-06-12 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Trewesdei', 'day_name_trad() on 1999-06-12 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 21, 'day_of_month() on 1999-06-12 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 4, 'day_of_week() on 1999-06-12 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 172, 'day_of_year() on 1999-06-12 Gregorian' );
cmp_ok( $dts->dow(), '==', 4, 'dow() on 1999-06-12 Gregorian' );
cmp_ok( $dts->doy(), '==', 172, 'doy() on 1999-06-12 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-06-12 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-06-12 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-06-12 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-06-12 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-06-12 Gregorian' );
cmp_ok( $dts->mday(), '==', 21, 'mday() on 1999-06-12 Gregorian' );
cmp_ok( $dts->month(), '==', 6, 'month() on 1999-06-12 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Forelithe', 'month_name() on 1999-06-12 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-06-12 Gregorian' );
Trewsday 21 Forelithe 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63064828800, 'utc_rd_as_seconds() on 1999-06-12 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729917,
  0,
  0
]
, 'utc_rd_values() on 1999-06-12 Gregorian' );
cmp_ok( $dts->wday(), '==', 4, 'wday() on 1999-06-12 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  25
]
, 'week() on 1999-06-12 Gregorian' );
cmp_ok( $dts->week_number(), '==', 25, 'week_number() on 1999-06-12 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-06-12 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-06-12 Gregorian' );

$epoch = timegm( 0, 0, 0, 13, 6 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 6,
	day	=> 13,
    ),
);
cmp_ok( $dts->day(), '==', 22, 'day() on 1999-06-13 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Hevensday', 'day_name() on 1999-06-13 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Hevenesdei', 'day_name_trad() on 1999-06-13 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 22, 'day_of_month() on 1999-06-13 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 5, 'day_of_week() on 1999-06-13 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 173, 'day_of_year() on 1999-06-13 Gregorian' );
cmp_ok( $dts->dow(), '==', 5, 'dow() on 1999-06-13 Gregorian' );
cmp_ok( $dts->doy(), '==', 173, 'doy() on 1999-06-13 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-06-13 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-06-13 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-06-13 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-06-13 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-06-13 Gregorian' );
cmp_ok( $dts->mday(), '==', 22, 'mday() on 1999-06-13 Gregorian' );
cmp_ok( $dts->month(), '==', 6, 'month() on 1999-06-13 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Forelithe', 'month_name() on 1999-06-13 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-06-13 Gregorian' );
Hevensday 22 Forelithe 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63064915200, 'utc_rd_as_seconds() on 1999-06-13 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729918,
  0,
  0
]
, 'utc_rd_values() on 1999-06-13 Gregorian' );
cmp_ok( $dts->wday(), '==', 5, 'wday() on 1999-06-13 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  25
]
, 'week() on 1999-06-13 Gregorian' );
cmp_ok( $dts->week_number(), '==', 25, 'week_number() on 1999-06-13 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-06-13 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-06-13 Gregorian' );

$epoch = timegm( 0, 0, 0, 14, 6 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 6,
	day	=> 14,
    ),
);
cmp_ok( $dts->day(), '==', 23, 'day() on 1999-06-14 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Mersday', 'day_name() on 1999-06-14 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Meresdei', 'day_name_trad() on 1999-06-14 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 23, 'day_of_month() on 1999-06-14 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 6, 'day_of_week() on 1999-06-14 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 174, 'day_of_year() on 1999-06-14 Gregorian' );
cmp_ok( $dts->dow(), '==', 6, 'dow() on 1999-06-14 Gregorian' );
cmp_ok( $dts->doy(), '==', 174, 'doy() on 1999-06-14 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-06-14 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-06-14 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-06-14 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-06-14 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-06-14 Gregorian' );
cmp_ok( $dts->mday(), '==', 23, 'mday() on 1999-06-14 Gregorian' );
cmp_ok( $dts->month(), '==', 6, 'month() on 1999-06-14 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Forelithe', 'month_name() on 1999-06-14 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-06-14 Gregorian' );
Mersday 23 Forelithe 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63065001600, 'utc_rd_as_seconds() on 1999-06-14 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729919,
  0,
  0
]
, 'utc_rd_values() on 1999-06-14 Gregorian' );
cmp_ok( $dts->wday(), '==', 6, 'wday() on 1999-06-14 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  25
]
, 'week() on 1999-06-14 Gregorian' );
cmp_ok( $dts->week_number(), '==', 25, 'week_number() on 1999-06-14 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-06-14 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-06-14 Gregorian' );

$epoch = timegm( 0, 0, 0, 15, 6 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 6,
	day	=> 15,
    ),
);
cmp_ok( $dts->day(), '==', 24, 'day() on 1999-06-15 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Highday', 'day_name() on 1999-06-15 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Highdei', 'day_name_trad() on 1999-06-15 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 24, 'day_of_month() on 1999-06-15 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 7, 'day_of_week() on 1999-06-15 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 175, 'day_of_year() on 1999-06-15 Gregorian' );
cmp_ok( $dts->dow(), '==', 7, 'dow() on 1999-06-15 Gregorian' );
cmp_ok( $dts->doy(), '==', 175, 'doy() on 1999-06-15 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-06-15 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-06-15 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-06-15 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-06-15 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-06-15 Gregorian' );
cmp_ok( $dts->mday(), '==', 24, 'mday() on 1999-06-15 Gregorian' );
cmp_ok( $dts->month(), '==', 6, 'month() on 1999-06-15 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Forelithe', 'month_name() on 1999-06-15 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-06-15 Gregorian' );
Highday 24 Forelithe 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63065088000, 'utc_rd_as_seconds() on 1999-06-15 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729920,
  0,
  0
]
, 'utc_rd_values() on 1999-06-15 Gregorian' );
cmp_ok( $dts->wday(), '==', 7, 'wday() on 1999-06-15 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  25
]
, 'week() on 1999-06-15 Gregorian' );
cmp_ok( $dts->week_number(), '==', 25, 'week_number() on 1999-06-15 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-06-15 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-06-15 Gregorian' );

$epoch = timegm( 0, 0, 0, 16, 6 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 6,
	day	=> 16,
    ),
);
cmp_ok( $dts->day(), '==', 25, 'day() on 1999-06-16 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sterday', 'day_name() on 1999-06-16 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sterrendei', 'day_name_trad() on 1999-06-16 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 25, 'day_of_month() on 1999-06-16 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 1, 'day_of_week() on 1999-06-16 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 176, 'day_of_year() on 1999-06-16 Gregorian' );
cmp_ok( $dts->dow(), '==', 1, 'dow() on 1999-06-16 Gregorian' );
cmp_ok( $dts->doy(), '==', 176, 'doy() on 1999-06-16 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-06-16 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-06-16 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-06-16 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-06-16 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-06-16 Gregorian' );
cmp_ok( $dts->mday(), '==', 25, 'mday() on 1999-06-16 Gregorian' );
cmp_ok( $dts->month(), '==', 6, 'month() on 1999-06-16 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Forelithe', 'month_name() on 1999-06-16 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-06-16 Gregorian' );
Sterday 25 Forelithe 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63065174400, 'utc_rd_as_seconds() on 1999-06-16 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729921,
  0,
  0
]
, 'utc_rd_values() on 1999-06-16 Gregorian' );
cmp_ok( $dts->wday(), '==', 1, 'wday() on 1999-06-16 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  26
]
, 'week() on 1999-06-16 Gregorian' );
cmp_ok( $dts->week_number(), '==', 26, 'week_number() on 1999-06-16 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-06-16 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-06-16 Gregorian' );

$epoch = timegm( 0, 0, 0, 17, 6 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 6,
	day	=> 17,
    ),
);
cmp_ok( $dts->day(), '==', 26, 'day() on 1999-06-17 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sunday', 'day_name() on 1999-06-17 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sunnendei', 'day_name_trad() on 1999-06-17 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 26, 'day_of_month() on 1999-06-17 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 2, 'day_of_week() on 1999-06-17 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 177, 'day_of_year() on 1999-06-17 Gregorian' );
cmp_ok( $dts->dow(), '==', 2, 'dow() on 1999-06-17 Gregorian' );
cmp_ok( $dts->doy(), '==', 177, 'doy() on 1999-06-17 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-06-17 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-06-17 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-06-17 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-06-17 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-06-17 Gregorian' );
cmp_ok( $dts->mday(), '==', 26, 'mday() on 1999-06-17 Gregorian' );
cmp_ok( $dts->month(), '==', 6, 'month() on 1999-06-17 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Forelithe', 'month_name() on 1999-06-17 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-06-17 Gregorian' );
Sunday 26 Forelithe 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63065260800, 'utc_rd_as_seconds() on 1999-06-17 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729922,
  0,
  0
]
, 'utc_rd_values() on 1999-06-17 Gregorian' );
cmp_ok( $dts->wday(), '==', 2, 'wday() on 1999-06-17 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  26
]
, 'week() on 1999-06-17 Gregorian' );
cmp_ok( $dts->week_number(), '==', 26, 'week_number() on 1999-06-17 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-06-17 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-06-17 Gregorian' );

$epoch = timegm( 0, 0, 0, 18, 6 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 6,
	day	=> 18,
    ),
);
cmp_ok( $dts->day(), '==', 27, 'day() on 1999-06-18 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Monday', 'day_name() on 1999-06-18 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Monendei', 'day_name_trad() on 1999-06-18 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 27, 'day_of_month() on 1999-06-18 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 3, 'day_of_week() on 1999-06-18 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 178, 'day_of_year() on 1999-06-18 Gregorian' );
cmp_ok( $dts->dow(), '==', 3, 'dow() on 1999-06-18 Gregorian' );
cmp_ok( $dts->doy(), '==', 178, 'doy() on 1999-06-18 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-06-18 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-06-18 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-06-18 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-06-18 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-06-18 Gregorian' );
cmp_ok( $dts->mday(), '==', 27, 'mday() on 1999-06-18 Gregorian' );
cmp_ok( $dts->month(), '==', 6, 'month() on 1999-06-18 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Forelithe', 'month_name() on 1999-06-18 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-06-18 Gregorian' );
Monday 27 Forelithe 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63065347200, 'utc_rd_as_seconds() on 1999-06-18 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729923,
  0,
  0
]
, 'utc_rd_values() on 1999-06-18 Gregorian' );
cmp_ok( $dts->wday(), '==', 3, 'wday() on 1999-06-18 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  26
]
, 'week() on 1999-06-18 Gregorian' );
cmp_ok( $dts->week_number(), '==', 26, 'week_number() on 1999-06-18 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-06-18 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-06-18 Gregorian' );

$epoch = timegm( 0, 0, 0, 19, 6 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 6,
	day	=> 19,
    ),
);
cmp_ok( $dts->day(), '==', 28, 'day() on 1999-06-19 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Trewsday', 'day_name() on 1999-06-19 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Trewesdei', 'day_name_trad() on 1999-06-19 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 28, 'day_of_month() on 1999-06-19 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 4, 'day_of_week() on 1999-06-19 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 179, 'day_of_year() on 1999-06-19 Gregorian' );
cmp_ok( $dts->dow(), '==', 4, 'dow() on 1999-06-19 Gregorian' );
cmp_ok( $dts->doy(), '==', 179, 'doy() on 1999-06-19 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-06-19 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-06-19 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-06-19 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-06-19 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-06-19 Gregorian' );
cmp_ok( $dts->mday(), '==', 28, 'mday() on 1999-06-19 Gregorian' );
cmp_ok( $dts->month(), '==', 6, 'month() on 1999-06-19 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Forelithe', 'month_name() on 1999-06-19 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-06-19 Gregorian' );
Trewsday 28 Forelithe 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63065433600, 'utc_rd_as_seconds() on 1999-06-19 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729924,
  0,
  0
]
, 'utc_rd_values() on 1999-06-19 Gregorian' );
cmp_ok( $dts->wday(), '==', 4, 'wday() on 1999-06-19 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  26
]
, 'week() on 1999-06-19 Gregorian' );
cmp_ok( $dts->week_number(), '==', 26, 'week_number() on 1999-06-19 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-06-19 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-06-19 Gregorian' );

$epoch = timegm( 0, 0, 0, 20, 6 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 6,
	day	=> 20,
    ),
);
cmp_ok( $dts->day(), '==', 29, 'day() on 1999-06-20 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Hevensday', 'day_name() on 1999-06-20 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Hevenesdei', 'day_name_trad() on 1999-06-20 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 29, 'day_of_month() on 1999-06-20 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 5, 'day_of_week() on 1999-06-20 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 180, 'day_of_year() on 1999-06-20 Gregorian' );
cmp_ok( $dts->dow(), '==', 5, 'dow() on 1999-06-20 Gregorian' );
cmp_ok( $dts->doy(), '==', 180, 'doy() on 1999-06-20 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-06-20 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-06-20 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-06-20 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-06-20 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-06-20 Gregorian' );
cmp_ok( $dts->mday(), '==', 29, 'mday() on 1999-06-20 Gregorian' );
cmp_ok( $dts->month(), '==', 6, 'month() on 1999-06-20 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Forelithe', 'month_name() on 1999-06-20 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-06-20 Gregorian' );
Hevensday 29 Forelithe 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63065520000, 'utc_rd_as_seconds() on 1999-06-20 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729925,
  0,
  0
]
, 'utc_rd_values() on 1999-06-20 Gregorian' );
cmp_ok( $dts->wday(), '==', 5, 'wday() on 1999-06-20 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  26
]
, 'week() on 1999-06-20 Gregorian' );
cmp_ok( $dts->week_number(), '==', 26, 'week_number() on 1999-06-20 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-06-20 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-06-20 Gregorian' );

$epoch = timegm( 0, 0, 0, 21, 6 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 6,
	day	=> 21,
    ),
);
cmp_ok( $dts->day(), '==', 30, 'day() on 1999-06-21 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Mersday', 'day_name() on 1999-06-21 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Meresdei', 'day_name_trad() on 1999-06-21 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 30, 'day_of_month() on 1999-06-21 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 6, 'day_of_week() on 1999-06-21 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 181, 'day_of_year() on 1999-06-21 Gregorian' );
cmp_ok( $dts->dow(), '==', 6, 'dow() on 1999-06-21 Gregorian' );
cmp_ok( $dts->doy(), '==', 181, 'doy() on 1999-06-21 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-06-21 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-06-21 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-06-21 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-06-21 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-06-21 Gregorian' );
cmp_ok( $dts->mday(), '==', 30, 'mday() on 1999-06-21 Gregorian' );
cmp_ok( $dts->month(), '==', 6, 'month() on 1999-06-21 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Forelithe', 'month_name() on 1999-06-21 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-06-21 Gregorian' );
Mersday 30 Forelithe 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63065606400, 'utc_rd_as_seconds() on 1999-06-21 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729926,
  0,
  0
]
, 'utc_rd_values() on 1999-06-21 Gregorian' );
cmp_ok( $dts->wday(), '==', 6, 'wday() on 1999-06-21 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  26
]
, 'week() on 1999-06-21 Gregorian' );
cmp_ok( $dts->week_number(), '==', 26, 'week_number() on 1999-06-21 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-06-21 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-06-21 Gregorian' );

$epoch = timegm( 0, 0, 0, 22, 6 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 6,
	day	=> 22,
    ),
);
cmp_ok( $dts->day(), '==', 0, 'day() on 1999-06-22 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Highday', 'day_name() on 1999-06-22 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Highdei', 'day_name_trad() on 1999-06-22 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 0, 'day_of_month() on 1999-06-22 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 7, 'day_of_week() on 1999-06-22 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 182, 'day_of_year() on 1999-06-22 Gregorian' );
cmp_ok( $dts->dow(), '==', 7, 'dow() on 1999-06-22 Gregorian' );
cmp_ok( $dts->doy(), '==', 182, 'doy() on 1999-06-22 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-06-22 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-06-22 Gregorian' );
cmp_ok( $dts->holiday(), '==', 2, 'holiday() on 1999-06-22 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '1 Lithe', 'holiday_name() on 1999-06-22 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-06-22 Gregorian' );
cmp_ok( $dts->mday(), '==', 0, 'mday() on 1999-06-22 Gregorian' );
cmp_ok( $dts->month(), '==', 0, 'month() on 1999-06-22 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', '', 'month_name() on 1999-06-22 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-06-22 Gregorian' );
Highday 1 Lithe 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63065692800, 'utc_rd_as_seconds() on 1999-06-22 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729927,
  0,
  0
]
, 'utc_rd_values() on 1999-06-22 Gregorian' );
cmp_ok( $dts->wday(), '==', 7, 'wday() on 1999-06-22 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  26
]
, 'week() on 1999-06-22 Gregorian' );
cmp_ok( $dts->week_number(), '==', 26, 'week_number() on 1999-06-22 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-06-22 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-06-22 Gregorian' );

$epoch = timegm( 0, 0, 0, 23, 6 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 6,
	day	=> 23,
    ),
);
cmp_ok( $dts->day(), '==', 0, 'day() on 1999-06-23 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', '', 'day_name() on 1999-06-23 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', '', 'day_name_trad() on 1999-06-23 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 0, 'day_of_month() on 1999-06-23 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 0, 'day_of_week() on 1999-06-23 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 183, 'day_of_year() on 1999-06-23 Gregorian' );
cmp_ok( $dts->dow(), '==', 0, 'dow() on 1999-06-23 Gregorian' );
cmp_ok( $dts->doy(), '==', 183, 'doy() on 1999-06-23 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-06-23 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-06-23 Gregorian' );
cmp_ok( $dts->holiday(), '==', 3, 'holiday() on 1999-06-23 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', 'Midyear\'s day', 'holiday_name() on 1999-06-23 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-06-23 Gregorian' );
cmp_ok( $dts->mday(), '==', 0, 'mday() on 1999-06-23 Gregorian' );
cmp_ok( $dts->month(), '==', 0, 'month() on 1999-06-23 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', '', 'month_name() on 1999-06-23 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-06-23 Gregorian' );
Midyear's day 7463

Wedding of King Elessar and Arwen, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63065779200, 'utc_rd_as_seconds() on 1999-06-23 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729928,
  0,
  0
]
, 'utc_rd_values() on 1999-06-23 Gregorian' );
cmp_ok( $dts->wday(), '==', 0, 'wday() on 1999-06-23 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  0
]
, 'week() on 1999-06-23 Gregorian' );
cmp_ok( $dts->week_number(), '==', 0, 'week_number() on 1999-06-23 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-06-23 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-06-23 Gregorian' );

$epoch = timegm( 0, 0, 0, 24, 6 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 6,
	day	=> 24,
    ),
);
cmp_ok( $dts->day(), '==', 0, 'day() on 1999-06-24 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sterday', 'day_name() on 1999-06-24 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sterrendei', 'day_name_trad() on 1999-06-24 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 0, 'day_of_month() on 1999-06-24 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 1, 'day_of_week() on 1999-06-24 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 184, 'day_of_year() on 1999-06-24 Gregorian' );
cmp_ok( $dts->dow(), '==', 1, 'dow() on 1999-06-24 Gregorian' );
cmp_ok( $dts->doy(), '==', 184, 'doy() on 1999-06-24 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-06-24 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-06-24 Gregorian' );
cmp_ok( $dts->holiday(), '==', 5, 'holiday() on 1999-06-24 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '2 Lithe', 'holiday_name() on 1999-06-24 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-06-24 Gregorian' );
cmp_ok( $dts->mday(), '==', 0, 'mday() on 1999-06-24 Gregorian' );
cmp_ok( $dts->month(), '==', 0, 'month() on 1999-06-24 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', '', 'month_name() on 1999-06-24 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-06-24 Gregorian' );
Sterday 2 Lithe 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63065865600, 'utc_rd_as_seconds() on 1999-06-24 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729929,
  0,
  0
]
, 'utc_rd_values() on 1999-06-24 Gregorian' );
cmp_ok( $dts->wday(), '==', 1, 'wday() on 1999-06-24 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  27
]
, 'week() on 1999-06-24 Gregorian' );
cmp_ok( $dts->week_number(), '==', 27, 'week_number() on 1999-06-24 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-06-24 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-06-24 Gregorian' );

$epoch = timegm( 0, 0, 0, 25, 6 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 6,
	day	=> 25,
    ),
);
cmp_ok( $dts->day(), '==', 1, 'day() on 1999-06-25 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sunday', 'day_name() on 1999-06-25 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sunnendei', 'day_name_trad() on 1999-06-25 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 1, 'day_of_month() on 1999-06-25 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 2, 'day_of_week() on 1999-06-25 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 185, 'day_of_year() on 1999-06-25 Gregorian' );
cmp_ok( $dts->dow(), '==', 2, 'dow() on 1999-06-25 Gregorian' );
cmp_ok( $dts->doy(), '==', 185, 'doy() on 1999-06-25 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-06-25 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-06-25 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-06-25 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-06-25 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-06-25 Gregorian' );
cmp_ok( $dts->mday(), '==', 1, 'mday() on 1999-06-25 Gregorian' );
cmp_ok( $dts->month(), '==', 7, 'month() on 1999-06-25 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afterlithe', 'month_name() on 1999-06-25 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-06-25 Gregorian' );
Sunday 1 Afterlithe 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63065952000, 'utc_rd_as_seconds() on 1999-06-25 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729930,
  0,
  0
]
, 'utc_rd_values() on 1999-06-25 Gregorian' );
cmp_ok( $dts->wday(), '==', 2, 'wday() on 1999-06-25 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  27
]
, 'week() on 1999-06-25 Gregorian' );
cmp_ok( $dts->week_number(), '==', 27, 'week_number() on 1999-06-25 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-06-25 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-06-25 Gregorian' );

$epoch = timegm( 0, 0, 0, 26, 6 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 6,
	day	=> 26,
    ),
);
cmp_ok( $dts->day(), '==', 2, 'day() on 1999-06-26 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Monday', 'day_name() on 1999-06-26 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Monendei', 'day_name_trad() on 1999-06-26 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 2, 'day_of_month() on 1999-06-26 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 3, 'day_of_week() on 1999-06-26 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 186, 'day_of_year() on 1999-06-26 Gregorian' );
cmp_ok( $dts->dow(), '==', 3, 'dow() on 1999-06-26 Gregorian' );
cmp_ok( $dts->doy(), '==', 186, 'doy() on 1999-06-26 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-06-26 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-06-26 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-06-26 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-06-26 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-06-26 Gregorian' );
cmp_ok( $dts->mday(), '==', 2, 'mday() on 1999-06-26 Gregorian' );
cmp_ok( $dts->month(), '==', 7, 'month() on 1999-06-26 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afterlithe', 'month_name() on 1999-06-26 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-06-26 Gregorian' );
Monday 2 Afterlithe 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63066038400, 'utc_rd_as_seconds() on 1999-06-26 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729931,
  0,
  0
]
, 'utc_rd_values() on 1999-06-26 Gregorian' );
cmp_ok( $dts->wday(), '==', 3, 'wday() on 1999-06-26 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  27
]
, 'week() on 1999-06-26 Gregorian' );
cmp_ok( $dts->week_number(), '==', 27, 'week_number() on 1999-06-26 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-06-26 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-06-26 Gregorian' );

$epoch = timegm( 0, 0, 0, 27, 6 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 6,
	day	=> 27,
    ),
);
cmp_ok( $dts->day(), '==', 3, 'day() on 1999-06-27 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Trewsday', 'day_name() on 1999-06-27 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Trewesdei', 'day_name_trad() on 1999-06-27 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 3, 'day_of_month() on 1999-06-27 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 4, 'day_of_week() on 1999-06-27 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 187, 'day_of_year() on 1999-06-27 Gregorian' );
cmp_ok( $dts->dow(), '==', 4, 'dow() on 1999-06-27 Gregorian' );
cmp_ok( $dts->doy(), '==', 187, 'doy() on 1999-06-27 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-06-27 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-06-27 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-06-27 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-06-27 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-06-27 Gregorian' );
cmp_ok( $dts->mday(), '==', 3, 'mday() on 1999-06-27 Gregorian' );
cmp_ok( $dts->month(), '==', 7, 'month() on 1999-06-27 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afterlithe', 'month_name() on 1999-06-27 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-06-27 Gregorian' );
Trewsday 3 Afterlithe 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63066124800, 'utc_rd_as_seconds() on 1999-06-27 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729932,
  0,
  0
]
, 'utc_rd_values() on 1999-06-27 Gregorian' );
cmp_ok( $dts->wday(), '==', 4, 'wday() on 1999-06-27 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  27
]
, 'week() on 1999-06-27 Gregorian' );
cmp_ok( $dts->week_number(), '==', 27, 'week_number() on 1999-06-27 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-06-27 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-06-27 Gregorian' );

$epoch = timegm( 0, 0, 0, 28, 6 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 6,
	day	=> 28,
    ),
);
cmp_ok( $dts->day(), '==', 4, 'day() on 1999-06-28 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Hevensday', 'day_name() on 1999-06-28 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Hevenesdei', 'day_name_trad() on 1999-06-28 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 4, 'day_of_month() on 1999-06-28 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 5, 'day_of_week() on 1999-06-28 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 188, 'day_of_year() on 1999-06-28 Gregorian' );
cmp_ok( $dts->dow(), '==', 5, 'dow() on 1999-06-28 Gregorian' );
cmp_ok( $dts->doy(), '==', 188, 'doy() on 1999-06-28 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-06-28 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-06-28 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-06-28 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-06-28 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-06-28 Gregorian' );
cmp_ok( $dts->mday(), '==', 4, 'mday() on 1999-06-28 Gregorian' );
cmp_ok( $dts->month(), '==', 7, 'month() on 1999-06-28 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afterlithe', 'month_name() on 1999-06-28 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-06-28 Gregorian' );
Hevensday 4 Afterlithe 7463

Boromir sets out from Minas Tirith, 1418
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63066211200, 'utc_rd_as_seconds() on 1999-06-28 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729933,
  0,
  0
]
, 'utc_rd_values() on 1999-06-28 Gregorian' );
cmp_ok( $dts->wday(), '==', 5, 'wday() on 1999-06-28 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  27
]
, 'week() on 1999-06-28 Gregorian' );
cmp_ok( $dts->week_number(), '==', 27, 'week_number() on 1999-06-28 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-06-28 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-06-28 Gregorian' );

$epoch = timegm( 0, 0, 0, 29, 6 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 6,
	day	=> 29,
    ),
);
cmp_ok( $dts->day(), '==', 5, 'day() on 1999-06-29 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Mersday', 'day_name() on 1999-06-29 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Meresdei', 'day_name_trad() on 1999-06-29 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 5, 'day_of_month() on 1999-06-29 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 6, 'day_of_week() on 1999-06-29 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 189, 'day_of_year() on 1999-06-29 Gregorian' );
cmp_ok( $dts->dow(), '==', 6, 'dow() on 1999-06-29 Gregorian' );
cmp_ok( $dts->doy(), '==', 189, 'doy() on 1999-06-29 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-06-29 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-06-29 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-06-29 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-06-29 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-06-29 Gregorian' );
cmp_ok( $dts->mday(), '==', 5, 'mday() on 1999-06-29 Gregorian' );
cmp_ok( $dts->month(), '==', 7, 'month() on 1999-06-29 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afterlithe', 'month_name() on 1999-06-29 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-06-29 Gregorian' );
Mersday 5 Afterlithe 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63066297600, 'utc_rd_as_seconds() on 1999-06-29 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729934,
  0,
  0
]
, 'utc_rd_values() on 1999-06-29 Gregorian' );
cmp_ok( $dts->wday(), '==', 6, 'wday() on 1999-06-29 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  27
]
, 'week() on 1999-06-29 Gregorian' );
cmp_ok( $dts->week_number(), '==', 27, 'week_number() on 1999-06-29 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-06-29 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-06-29 Gregorian' );

$epoch = timegm( 0, 0, 0, 30, 6 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 6,
	day	=> 30,
    ),
);
cmp_ok( $dts->day(), '==', 6, 'day() on 1999-06-30 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Highday', 'day_name() on 1999-06-30 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Highdei', 'day_name_trad() on 1999-06-30 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 6, 'day_of_month() on 1999-06-30 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 7, 'day_of_week() on 1999-06-30 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 190, 'day_of_year() on 1999-06-30 Gregorian' );
cmp_ok( $dts->dow(), '==', 7, 'dow() on 1999-06-30 Gregorian' );
cmp_ok( $dts->doy(), '==', 190, 'doy() on 1999-06-30 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-06-30 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-06-30 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-06-30 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-06-30 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-06-30 Gregorian' );
cmp_ok( $dts->mday(), '==', 6, 'mday() on 1999-06-30 Gregorian' );
cmp_ok( $dts->month(), '==', 7, 'month() on 1999-06-30 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afterlithe', 'month_name() on 1999-06-30 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-06-30 Gregorian' );
Highday 6 Afterlithe 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63066384000, 'utc_rd_as_seconds() on 1999-06-30 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729935,
  0,
  0
]
, 'utc_rd_values() on 1999-06-30 Gregorian' );
cmp_ok( $dts->wday(), '==', 7, 'wday() on 1999-06-30 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  27
]
, 'week() on 1999-06-30 Gregorian' );
cmp_ok( $dts->week_number(), '==', 27, 'week_number() on 1999-06-30 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-06-30 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-06-30 Gregorian' );

$epoch = timegm( 0, 0, 0, 1, 7 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 7,
	day	=> 1,
    ),
);
cmp_ok( $dts->day(), '==', 7, 'day() on 1999-07-01 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sterday', 'day_name() on 1999-07-01 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sterrendei', 'day_name_trad() on 1999-07-01 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 7, 'day_of_month() on 1999-07-01 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 1, 'day_of_week() on 1999-07-01 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 191, 'day_of_year() on 1999-07-01 Gregorian' );
cmp_ok( $dts->dow(), '==', 1, 'dow() on 1999-07-01 Gregorian' );
cmp_ok( $dts->doy(), '==', 191, 'doy() on 1999-07-01 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-07-01 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-07-01 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-07-01 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-07-01 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-07-01 Gregorian' );
cmp_ok( $dts->mday(), '==', 7, 'mday() on 1999-07-01 Gregorian' );
cmp_ok( $dts->month(), '==', 7, 'month() on 1999-07-01 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afterlithe', 'month_name() on 1999-07-01 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-07-01 Gregorian' );
Sterday 7 Afterlithe 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63066470400, 'utc_rd_as_seconds() on 1999-07-01 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729936,
  0,
  0
]
, 'utc_rd_values() on 1999-07-01 Gregorian' );
cmp_ok( $dts->wday(), '==', 1, 'wday() on 1999-07-01 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  28
]
, 'week() on 1999-07-01 Gregorian' );
cmp_ok( $dts->week_number(), '==', 28, 'week_number() on 1999-07-01 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-07-01 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-07-01 Gregorian' );

$epoch = timegm( 0, 0, 0, 2, 7 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 7,
	day	=> 2,
    ),
);
cmp_ok( $dts->day(), '==', 8, 'day() on 1999-07-02 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sunday', 'day_name() on 1999-07-02 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sunnendei', 'day_name_trad() on 1999-07-02 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 8, 'day_of_month() on 1999-07-02 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 2, 'day_of_week() on 1999-07-02 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 192, 'day_of_year() on 1999-07-02 Gregorian' );
cmp_ok( $dts->dow(), '==', 2, 'dow() on 1999-07-02 Gregorian' );
cmp_ok( $dts->doy(), '==', 192, 'doy() on 1999-07-02 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-07-02 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-07-02 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-07-02 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-07-02 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-07-02 Gregorian' );
cmp_ok( $dts->mday(), '==', 8, 'mday() on 1999-07-02 Gregorian' );
cmp_ok( $dts->month(), '==', 7, 'month() on 1999-07-02 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afterlithe', 'month_name() on 1999-07-02 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-07-02 Gregorian' );
Sunday 8 Afterlithe 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63066556800, 'utc_rd_as_seconds() on 1999-07-02 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729937,
  0,
  0
]
, 'utc_rd_values() on 1999-07-02 Gregorian' );
cmp_ok( $dts->wday(), '==', 2, 'wday() on 1999-07-02 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  28
]
, 'week() on 1999-07-02 Gregorian' );
cmp_ok( $dts->week_number(), '==', 28, 'week_number() on 1999-07-02 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-07-02 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-07-02 Gregorian' );

$epoch = timegm( 0, 0, 0, 3, 7 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 7,
	day	=> 3,
    ),
);
cmp_ok( $dts->day(), '==', 9, 'day() on 1999-07-03 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Monday', 'day_name() on 1999-07-03 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Monendei', 'day_name_trad() on 1999-07-03 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 9, 'day_of_month() on 1999-07-03 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 3, 'day_of_week() on 1999-07-03 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 193, 'day_of_year() on 1999-07-03 Gregorian' );
cmp_ok( $dts->dow(), '==', 3, 'dow() on 1999-07-03 Gregorian' );
cmp_ok( $dts->doy(), '==', 193, 'doy() on 1999-07-03 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-07-03 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-07-03 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-07-03 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-07-03 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-07-03 Gregorian' );
cmp_ok( $dts->mday(), '==', 9, 'mday() on 1999-07-03 Gregorian' );
cmp_ok( $dts->month(), '==', 7, 'month() on 1999-07-03 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afterlithe', 'month_name() on 1999-07-03 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-07-03 Gregorian' );
Monday 9 Afterlithe 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63066643200, 'utc_rd_as_seconds() on 1999-07-03 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729938,
  0,
  0
]
, 'utc_rd_values() on 1999-07-03 Gregorian' );
cmp_ok( $dts->wday(), '==', 3, 'wday() on 1999-07-03 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  28
]
, 'week() on 1999-07-03 Gregorian' );
cmp_ok( $dts->week_number(), '==', 28, 'week_number() on 1999-07-03 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-07-03 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-07-03 Gregorian' );

$epoch = timegm( 0, 0, 0, 4, 7 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 7,
	day	=> 4,
    ),
);
cmp_ok( $dts->day(), '==', 10, 'day() on 1999-07-04 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Trewsday', 'day_name() on 1999-07-04 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Trewesdei', 'day_name_trad() on 1999-07-04 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 10, 'day_of_month() on 1999-07-04 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 4, 'day_of_week() on 1999-07-04 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 194, 'day_of_year() on 1999-07-04 Gregorian' );
cmp_ok( $dts->dow(), '==', 4, 'dow() on 1999-07-04 Gregorian' );
cmp_ok( $dts->doy(), '==', 194, 'doy() on 1999-07-04 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-07-04 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-07-04 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-07-04 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-07-04 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-07-04 Gregorian' );
cmp_ok( $dts->mday(), '==', 10, 'mday() on 1999-07-04 Gregorian' );
cmp_ok( $dts->month(), '==', 7, 'month() on 1999-07-04 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afterlithe', 'month_name() on 1999-07-04 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-07-04 Gregorian' );
Trewsday 10 Afterlithe 7463

Gandalf imprisoned in Orthanc, 1418
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63066729600, 'utc_rd_as_seconds() on 1999-07-04 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729939,
  0,
  0
]
, 'utc_rd_values() on 1999-07-04 Gregorian' );
cmp_ok( $dts->wday(), '==', 4, 'wday() on 1999-07-04 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  28
]
, 'week() on 1999-07-04 Gregorian' );
cmp_ok( $dts->week_number(), '==', 28, 'week_number() on 1999-07-04 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-07-04 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-07-04 Gregorian' );

$epoch = timegm( 0, 0, 0, 5, 7 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 7,
	day	=> 5,
    ),
);
cmp_ok( $dts->day(), '==', 11, 'day() on 1999-07-05 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Hevensday', 'day_name() on 1999-07-05 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Hevenesdei', 'day_name_trad() on 1999-07-05 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 11, 'day_of_month() on 1999-07-05 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 5, 'day_of_week() on 1999-07-05 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 195, 'day_of_year() on 1999-07-05 Gregorian' );
cmp_ok( $dts->dow(), '==', 5, 'dow() on 1999-07-05 Gregorian' );
cmp_ok( $dts->doy(), '==', 195, 'doy() on 1999-07-05 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-07-05 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-07-05 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-07-05 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-07-05 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-07-05 Gregorian' );
cmp_ok( $dts->mday(), '==', 11, 'mday() on 1999-07-05 Gregorian' );
cmp_ok( $dts->month(), '==', 7, 'month() on 1999-07-05 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afterlithe', 'month_name() on 1999-07-05 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-07-05 Gregorian' );
Hevensday 11 Afterlithe 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63066816000, 'utc_rd_as_seconds() on 1999-07-05 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729940,
  0,
  0
]
, 'utc_rd_values() on 1999-07-05 Gregorian' );
cmp_ok( $dts->wday(), '==', 5, 'wday() on 1999-07-05 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  28
]
, 'week() on 1999-07-05 Gregorian' );
cmp_ok( $dts->week_number(), '==', 28, 'week_number() on 1999-07-05 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-07-05 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-07-05 Gregorian' );

$epoch = timegm( 0, 0, 0, 6, 7 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 7,
	day	=> 6,
    ),
);
cmp_ok( $dts->day(), '==', 12, 'day() on 1999-07-06 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Mersday', 'day_name() on 1999-07-06 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Meresdei', 'day_name_trad() on 1999-07-06 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 12, 'day_of_month() on 1999-07-06 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 6, 'day_of_week() on 1999-07-06 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 196, 'day_of_year() on 1999-07-06 Gregorian' );
cmp_ok( $dts->dow(), '==', 6, 'dow() on 1999-07-06 Gregorian' );
cmp_ok( $dts->doy(), '==', 196, 'doy() on 1999-07-06 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-07-06 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-07-06 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-07-06 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-07-06 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-07-06 Gregorian' );
cmp_ok( $dts->mday(), '==', 12, 'mday() on 1999-07-06 Gregorian' );
cmp_ok( $dts->month(), '==', 7, 'month() on 1999-07-06 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afterlithe', 'month_name() on 1999-07-06 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-07-06 Gregorian' );
Mersday 12 Afterlithe 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63066902400, 'utc_rd_as_seconds() on 1999-07-06 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729941,
  0,
  0
]
, 'utc_rd_values() on 1999-07-06 Gregorian' );
cmp_ok( $dts->wday(), '==', 6, 'wday() on 1999-07-06 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  28
]
, 'week() on 1999-07-06 Gregorian' );
cmp_ok( $dts->week_number(), '==', 28, 'week_number() on 1999-07-06 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-07-06 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-07-06 Gregorian' );

$epoch = timegm( 0, 0, 0, 7, 7 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 7,
	day	=> 7,
    ),
);
cmp_ok( $dts->day(), '==', 13, 'day() on 1999-07-07 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Highday', 'day_name() on 1999-07-07 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Highdei', 'day_name_trad() on 1999-07-07 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 13, 'day_of_month() on 1999-07-07 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 7, 'day_of_week() on 1999-07-07 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 197, 'day_of_year() on 1999-07-07 Gregorian' );
cmp_ok( $dts->dow(), '==', 7, 'dow() on 1999-07-07 Gregorian' );
cmp_ok( $dts->doy(), '==', 197, 'doy() on 1999-07-07 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-07-07 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-07-07 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-07-07 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-07-07 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-07-07 Gregorian' );
cmp_ok( $dts->mday(), '==', 13, 'mday() on 1999-07-07 Gregorian' );
cmp_ok( $dts->month(), '==', 7, 'month() on 1999-07-07 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afterlithe', 'month_name() on 1999-07-07 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-07-07 Gregorian' );
Highday 13 Afterlithe 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63066988800, 'utc_rd_as_seconds() on 1999-07-07 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729942,
  0,
  0
]
, 'utc_rd_values() on 1999-07-07 Gregorian' );
cmp_ok( $dts->wday(), '==', 7, 'wday() on 1999-07-07 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  28
]
, 'week() on 1999-07-07 Gregorian' );
cmp_ok( $dts->week_number(), '==', 28, 'week_number() on 1999-07-07 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-07-07 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-07-07 Gregorian' );

$epoch = timegm( 0, 0, 0, 8, 7 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 7,
	day	=> 8,
    ),
);
cmp_ok( $dts->day(), '==', 14, 'day() on 1999-07-08 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sterday', 'day_name() on 1999-07-08 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sterrendei', 'day_name_trad() on 1999-07-08 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 14, 'day_of_month() on 1999-07-08 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 1, 'day_of_week() on 1999-07-08 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 198, 'day_of_year() on 1999-07-08 Gregorian' );
cmp_ok( $dts->dow(), '==', 1, 'dow() on 1999-07-08 Gregorian' );
cmp_ok( $dts->doy(), '==', 198, 'doy() on 1999-07-08 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-07-08 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-07-08 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-07-08 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-07-08 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-07-08 Gregorian' );
cmp_ok( $dts->mday(), '==', 14, 'mday() on 1999-07-08 Gregorian' );
cmp_ok( $dts->month(), '==', 7, 'month() on 1999-07-08 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afterlithe', 'month_name() on 1999-07-08 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-07-08 Gregorian' );
Sterday 14 Afterlithe 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63067075200, 'utc_rd_as_seconds() on 1999-07-08 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729943,
  0,
  0
]
, 'utc_rd_values() on 1999-07-08 Gregorian' );
cmp_ok( $dts->wday(), '==', 1, 'wday() on 1999-07-08 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  29
]
, 'week() on 1999-07-08 Gregorian' );
cmp_ok( $dts->week_number(), '==', 29, 'week_number() on 1999-07-08 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-07-08 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-07-08 Gregorian' );

$epoch = timegm( 0, 0, 0, 9, 7 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 7,
	day	=> 9,
    ),
);
cmp_ok( $dts->day(), '==', 15, 'day() on 1999-07-09 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sunday', 'day_name() on 1999-07-09 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sunnendei', 'day_name_trad() on 1999-07-09 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 15, 'day_of_month() on 1999-07-09 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 2, 'day_of_week() on 1999-07-09 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 199, 'day_of_year() on 1999-07-09 Gregorian' );
cmp_ok( $dts->dow(), '==', 2, 'dow() on 1999-07-09 Gregorian' );
cmp_ok( $dts->doy(), '==', 199, 'doy() on 1999-07-09 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-07-09 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-07-09 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-07-09 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-07-09 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-07-09 Gregorian' );
cmp_ok( $dts->mday(), '==', 15, 'mday() on 1999-07-09 Gregorian' );
cmp_ok( $dts->month(), '==', 7, 'month() on 1999-07-09 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afterlithe', 'month_name() on 1999-07-09 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-07-09 Gregorian' );
Sunday 15 Afterlithe 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63067161600, 'utc_rd_as_seconds() on 1999-07-09 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729944,
  0,
  0
]
, 'utc_rd_values() on 1999-07-09 Gregorian' );
cmp_ok( $dts->wday(), '==', 2, 'wday() on 1999-07-09 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  29
]
, 'week() on 1999-07-09 Gregorian' );
cmp_ok( $dts->week_number(), '==', 29, 'week_number() on 1999-07-09 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-07-09 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-07-09 Gregorian' );

$epoch = timegm( 0, 0, 0, 10, 7 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 7,
	day	=> 10,
    ),
);
cmp_ok( $dts->day(), '==', 16, 'day() on 1999-07-10 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Monday', 'day_name() on 1999-07-10 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Monendei', 'day_name_trad() on 1999-07-10 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 16, 'day_of_month() on 1999-07-10 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 3, 'day_of_week() on 1999-07-10 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 200, 'day_of_year() on 1999-07-10 Gregorian' );
cmp_ok( $dts->dow(), '==', 3, 'dow() on 1999-07-10 Gregorian' );
cmp_ok( $dts->doy(), '==', 200, 'doy() on 1999-07-10 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-07-10 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-07-10 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-07-10 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-07-10 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-07-10 Gregorian' );
cmp_ok( $dts->mday(), '==', 16, 'mday() on 1999-07-10 Gregorian' );
cmp_ok( $dts->month(), '==', 7, 'month() on 1999-07-10 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afterlithe', 'month_name() on 1999-07-10 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-07-10 Gregorian' );
Monday 16 Afterlithe 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63067248000, 'utc_rd_as_seconds() on 1999-07-10 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729945,
  0,
  0
]
, 'utc_rd_values() on 1999-07-10 Gregorian' );
cmp_ok( $dts->wday(), '==', 3, 'wday() on 1999-07-10 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  29
]
, 'week() on 1999-07-10 Gregorian' );
cmp_ok( $dts->week_number(), '==', 29, 'week_number() on 1999-07-10 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-07-10 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-07-10 Gregorian' );

$epoch = timegm( 0, 0, 0, 11, 7 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 7,
	day	=> 11,
    ),
);
cmp_ok( $dts->day(), '==', 17, 'day() on 1999-07-11 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Trewsday', 'day_name() on 1999-07-11 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Trewesdei', 'day_name_trad() on 1999-07-11 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 17, 'day_of_month() on 1999-07-11 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 4, 'day_of_week() on 1999-07-11 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 201, 'day_of_year() on 1999-07-11 Gregorian' );
cmp_ok( $dts->dow(), '==', 4, 'dow() on 1999-07-11 Gregorian' );
cmp_ok( $dts->doy(), '==', 201, 'doy() on 1999-07-11 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-07-11 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-07-11 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-07-11 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-07-11 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-07-11 Gregorian' );
cmp_ok( $dts->mday(), '==', 17, 'mday() on 1999-07-11 Gregorian' );
cmp_ok( $dts->month(), '==', 7, 'month() on 1999-07-11 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afterlithe', 'month_name() on 1999-07-11 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-07-11 Gregorian' );
Trewsday 17 Afterlithe 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63067334400, 'utc_rd_as_seconds() on 1999-07-11 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729946,
  0,
  0
]
, 'utc_rd_values() on 1999-07-11 Gregorian' );
cmp_ok( $dts->wday(), '==', 4, 'wday() on 1999-07-11 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  29
]
, 'week() on 1999-07-11 Gregorian' );
cmp_ok( $dts->week_number(), '==', 29, 'week_number() on 1999-07-11 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-07-11 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-07-11 Gregorian' );

$epoch = timegm( 0, 0, 0, 12, 7 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 7,
	day	=> 12,
    ),
);
cmp_ok( $dts->day(), '==', 18, 'day() on 1999-07-12 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Hevensday', 'day_name() on 1999-07-12 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Hevenesdei', 'day_name_trad() on 1999-07-12 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 18, 'day_of_month() on 1999-07-12 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 5, 'day_of_week() on 1999-07-12 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 202, 'day_of_year() on 1999-07-12 Gregorian' );
cmp_ok( $dts->dow(), '==', 5, 'dow() on 1999-07-12 Gregorian' );
cmp_ok( $dts->doy(), '==', 202, 'doy() on 1999-07-12 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-07-12 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-07-12 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-07-12 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-07-12 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-07-12 Gregorian' );
cmp_ok( $dts->mday(), '==', 18, 'mday() on 1999-07-12 Gregorian' );
cmp_ok( $dts->month(), '==', 7, 'month() on 1999-07-12 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afterlithe', 'month_name() on 1999-07-12 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-07-12 Gregorian' );
Hevensday 18 Afterlithe 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63067420800, 'utc_rd_as_seconds() on 1999-07-12 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729947,
  0,
  0
]
, 'utc_rd_values() on 1999-07-12 Gregorian' );
cmp_ok( $dts->wday(), '==', 5, 'wday() on 1999-07-12 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  29
]
, 'week() on 1999-07-12 Gregorian' );
cmp_ok( $dts->week_number(), '==', 29, 'week_number() on 1999-07-12 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-07-12 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-07-12 Gregorian' );

$epoch = timegm( 0, 0, 0, 13, 7 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 7,
	day	=> 13,
    ),
);
cmp_ok( $dts->day(), '==', 19, 'day() on 1999-07-13 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Mersday', 'day_name() on 1999-07-13 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Meresdei', 'day_name_trad() on 1999-07-13 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 19, 'day_of_month() on 1999-07-13 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 6, 'day_of_week() on 1999-07-13 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 203, 'day_of_year() on 1999-07-13 Gregorian' );
cmp_ok( $dts->dow(), '==', 6, 'dow() on 1999-07-13 Gregorian' );
cmp_ok( $dts->doy(), '==', 203, 'doy() on 1999-07-13 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-07-13 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-07-13 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-07-13 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-07-13 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-07-13 Gregorian' );
cmp_ok( $dts->mday(), '==', 19, 'mday() on 1999-07-13 Gregorian' );
cmp_ok( $dts->month(), '==', 7, 'month() on 1999-07-13 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afterlithe', 'month_name() on 1999-07-13 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-07-13 Gregorian' );
Mersday 19 Afterlithe 7463

Funeral Escort of King Theoden leaves Minas Tirith, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63067507200, 'utc_rd_as_seconds() on 1999-07-13 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729948,
  0,
  0
]
, 'utc_rd_values() on 1999-07-13 Gregorian' );
cmp_ok( $dts->wday(), '==', 6, 'wday() on 1999-07-13 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  29
]
, 'week() on 1999-07-13 Gregorian' );
cmp_ok( $dts->week_number(), '==', 29, 'week_number() on 1999-07-13 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-07-13 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-07-13 Gregorian' );

$epoch = timegm( 0, 0, 0, 14, 7 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 7,
	day	=> 14,
    ),
);
cmp_ok( $dts->day(), '==', 20, 'day() on 1999-07-14 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Highday', 'day_name() on 1999-07-14 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Highdei', 'day_name_trad() on 1999-07-14 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 20, 'day_of_month() on 1999-07-14 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 7, 'day_of_week() on 1999-07-14 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 204, 'day_of_year() on 1999-07-14 Gregorian' );
cmp_ok( $dts->dow(), '==', 7, 'dow() on 1999-07-14 Gregorian' );
cmp_ok( $dts->doy(), '==', 204, 'doy() on 1999-07-14 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-07-14 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-07-14 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-07-14 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-07-14 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-07-14 Gregorian' );
cmp_ok( $dts->mday(), '==', 20, 'mday() on 1999-07-14 Gregorian' );
cmp_ok( $dts->month(), '==', 7, 'month() on 1999-07-14 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afterlithe', 'month_name() on 1999-07-14 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-07-14 Gregorian' );
Highday 20 Afterlithe 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63067593600, 'utc_rd_as_seconds() on 1999-07-14 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729949,
  0,
  0
]
, 'utc_rd_values() on 1999-07-14 Gregorian' );
cmp_ok( $dts->wday(), '==', 7, 'wday() on 1999-07-14 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  29
]
, 'week() on 1999-07-14 Gregorian' );
cmp_ok( $dts->week_number(), '==', 29, 'week_number() on 1999-07-14 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-07-14 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-07-14 Gregorian' );

$epoch = timegm( 0, 0, 0, 15, 7 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 7,
	day	=> 15,
    ),
);
cmp_ok( $dts->day(), '==', 21, 'day() on 1999-07-15 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sterday', 'day_name() on 1999-07-15 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sterrendei', 'day_name_trad() on 1999-07-15 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 21, 'day_of_month() on 1999-07-15 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 1, 'day_of_week() on 1999-07-15 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 205, 'day_of_year() on 1999-07-15 Gregorian' );
cmp_ok( $dts->dow(), '==', 1, 'dow() on 1999-07-15 Gregorian' );
cmp_ok( $dts->doy(), '==', 205, 'doy() on 1999-07-15 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-07-15 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-07-15 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-07-15 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-07-15 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-07-15 Gregorian' );
cmp_ok( $dts->mday(), '==', 21, 'mday() on 1999-07-15 Gregorian' );
cmp_ok( $dts->month(), '==', 7, 'month() on 1999-07-15 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afterlithe', 'month_name() on 1999-07-15 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-07-15 Gregorian' );
Sterday 21 Afterlithe 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63067680000, 'utc_rd_as_seconds() on 1999-07-15 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729950,
  0,
  0
]
, 'utc_rd_values() on 1999-07-15 Gregorian' );
cmp_ok( $dts->wday(), '==', 1, 'wday() on 1999-07-15 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  30
]
, 'week() on 1999-07-15 Gregorian' );
cmp_ok( $dts->week_number(), '==', 30, 'week_number() on 1999-07-15 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-07-15 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-07-15 Gregorian' );

$epoch = timegm( 0, 0, 0, 16, 7 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 7,
	day	=> 16,
    ),
);
cmp_ok( $dts->day(), '==', 22, 'day() on 1999-07-16 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sunday', 'day_name() on 1999-07-16 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sunnendei', 'day_name_trad() on 1999-07-16 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 22, 'day_of_month() on 1999-07-16 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 2, 'day_of_week() on 1999-07-16 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 206, 'day_of_year() on 1999-07-16 Gregorian' );
cmp_ok( $dts->dow(), '==', 2, 'dow() on 1999-07-16 Gregorian' );
cmp_ok( $dts->doy(), '==', 206, 'doy() on 1999-07-16 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-07-16 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-07-16 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-07-16 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-07-16 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-07-16 Gregorian' );
cmp_ok( $dts->mday(), '==', 22, 'mday() on 1999-07-16 Gregorian' );
cmp_ok( $dts->month(), '==', 7, 'month() on 1999-07-16 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afterlithe', 'month_name() on 1999-07-16 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-07-16 Gregorian' );
Sunday 22 Afterlithe 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63067766400, 'utc_rd_as_seconds() on 1999-07-16 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729951,
  0,
  0
]
, 'utc_rd_values() on 1999-07-16 Gregorian' );
cmp_ok( $dts->wday(), '==', 2, 'wday() on 1999-07-16 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  30
]
, 'week() on 1999-07-16 Gregorian' );
cmp_ok( $dts->week_number(), '==', 30, 'week_number() on 1999-07-16 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-07-16 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-07-16 Gregorian' );

$epoch = timegm( 0, 0, 0, 17, 7 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 7,
	day	=> 17,
    ),
);
cmp_ok( $dts->day(), '==', 23, 'day() on 1999-07-17 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Monday', 'day_name() on 1999-07-17 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Monendei', 'day_name_trad() on 1999-07-17 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 23, 'day_of_month() on 1999-07-17 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 3, 'day_of_week() on 1999-07-17 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 207, 'day_of_year() on 1999-07-17 Gregorian' );
cmp_ok( $dts->dow(), '==', 3, 'dow() on 1999-07-17 Gregorian' );
cmp_ok( $dts->doy(), '==', 207, 'doy() on 1999-07-17 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-07-17 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-07-17 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-07-17 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-07-17 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-07-17 Gregorian' );
cmp_ok( $dts->mday(), '==', 23, 'mday() on 1999-07-17 Gregorian' );
cmp_ok( $dts->month(), '==', 7, 'month() on 1999-07-17 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afterlithe', 'month_name() on 1999-07-17 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-07-17 Gregorian' );
Monday 23 Afterlithe 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63067852800, 'utc_rd_as_seconds() on 1999-07-17 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729952,
  0,
  0
]
, 'utc_rd_values() on 1999-07-17 Gregorian' );
cmp_ok( $dts->wday(), '==', 3, 'wday() on 1999-07-17 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  30
]
, 'week() on 1999-07-17 Gregorian' );
cmp_ok( $dts->week_number(), '==', 30, 'week_number() on 1999-07-17 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-07-17 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-07-17 Gregorian' );

$epoch = timegm( 0, 0, 0, 18, 7 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 7,
	day	=> 18,
    ),
);
cmp_ok( $dts->day(), '==', 24, 'day() on 1999-07-18 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Trewsday', 'day_name() on 1999-07-18 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Trewesdei', 'day_name_trad() on 1999-07-18 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 24, 'day_of_month() on 1999-07-18 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 4, 'day_of_week() on 1999-07-18 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 208, 'day_of_year() on 1999-07-18 Gregorian' );
cmp_ok( $dts->dow(), '==', 4, 'dow() on 1999-07-18 Gregorian' );
cmp_ok( $dts->doy(), '==', 208, 'doy() on 1999-07-18 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-07-18 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-07-18 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-07-18 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-07-18 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-07-18 Gregorian' );
cmp_ok( $dts->mday(), '==', 24, 'mday() on 1999-07-18 Gregorian' );
cmp_ok( $dts->month(), '==', 7, 'month() on 1999-07-18 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afterlithe', 'month_name() on 1999-07-18 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-07-18 Gregorian' );
Trewsday 24 Afterlithe 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63067939200, 'utc_rd_as_seconds() on 1999-07-18 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729953,
  0,
  0
]
, 'utc_rd_values() on 1999-07-18 Gregorian' );
cmp_ok( $dts->wday(), '==', 4, 'wday() on 1999-07-18 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  30
]
, 'week() on 1999-07-18 Gregorian' );
cmp_ok( $dts->week_number(), '==', 30, 'week_number() on 1999-07-18 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-07-18 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-07-18 Gregorian' );

$epoch = timegm( 0, 0, 0, 19, 7 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 7,
	day	=> 19,
    ),
);
cmp_ok( $dts->day(), '==', 25, 'day() on 1999-07-19 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Hevensday', 'day_name() on 1999-07-19 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Hevenesdei', 'day_name_trad() on 1999-07-19 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 25, 'day_of_month() on 1999-07-19 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 5, 'day_of_week() on 1999-07-19 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 209, 'day_of_year() on 1999-07-19 Gregorian' );
cmp_ok( $dts->dow(), '==', 5, 'dow() on 1999-07-19 Gregorian' );
cmp_ok( $dts->doy(), '==', 209, 'doy() on 1999-07-19 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-07-19 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-07-19 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-07-19 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-07-19 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-07-19 Gregorian' );
cmp_ok( $dts->mday(), '==', 25, 'mday() on 1999-07-19 Gregorian' );
cmp_ok( $dts->month(), '==', 7, 'month() on 1999-07-19 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afterlithe', 'month_name() on 1999-07-19 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-07-19 Gregorian' );
Hevensday 25 Afterlithe 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63068025600, 'utc_rd_as_seconds() on 1999-07-19 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729954,
  0,
  0
]
, 'utc_rd_values() on 1999-07-19 Gregorian' );
cmp_ok( $dts->wday(), '==', 5, 'wday() on 1999-07-19 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  30
]
, 'week() on 1999-07-19 Gregorian' );
cmp_ok( $dts->week_number(), '==', 30, 'week_number() on 1999-07-19 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-07-19 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-07-19 Gregorian' );

$epoch = timegm( 0, 0, 0, 20, 7 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 7,
	day	=> 20,
    ),
);
cmp_ok( $dts->day(), '==', 26, 'day() on 1999-07-20 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Mersday', 'day_name() on 1999-07-20 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Meresdei', 'day_name_trad() on 1999-07-20 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 26, 'day_of_month() on 1999-07-20 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 6, 'day_of_week() on 1999-07-20 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 210, 'day_of_year() on 1999-07-20 Gregorian' );
cmp_ok( $dts->dow(), '==', 6, 'dow() on 1999-07-20 Gregorian' );
cmp_ok( $dts->doy(), '==', 210, 'doy() on 1999-07-20 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-07-20 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-07-20 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-07-20 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-07-20 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-07-20 Gregorian' );
cmp_ok( $dts->mday(), '==', 26, 'mday() on 1999-07-20 Gregorian' );
cmp_ok( $dts->month(), '==', 7, 'month() on 1999-07-20 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afterlithe', 'month_name() on 1999-07-20 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-07-20 Gregorian' );
Mersday 26 Afterlithe 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63068112000, 'utc_rd_as_seconds() on 1999-07-20 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729955,
  0,
  0
]
, 'utc_rd_values() on 1999-07-20 Gregorian' );
cmp_ok( $dts->wday(), '==', 6, 'wday() on 1999-07-20 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  30
]
, 'week() on 1999-07-20 Gregorian' );
cmp_ok( $dts->week_number(), '==', 30, 'week_number() on 1999-07-20 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-07-20 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-07-20 Gregorian' );

$epoch = timegm( 0, 0, 0, 21, 7 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 7,
	day	=> 21,
    ),
);
cmp_ok( $dts->day(), '==', 27, 'day() on 1999-07-21 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Highday', 'day_name() on 1999-07-21 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Highdei', 'day_name_trad() on 1999-07-21 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 27, 'day_of_month() on 1999-07-21 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 7, 'day_of_week() on 1999-07-21 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 211, 'day_of_year() on 1999-07-21 Gregorian' );
cmp_ok( $dts->dow(), '==', 7, 'dow() on 1999-07-21 Gregorian' );
cmp_ok( $dts->doy(), '==', 211, 'doy() on 1999-07-21 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-07-21 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-07-21 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-07-21 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-07-21 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-07-21 Gregorian' );
cmp_ok( $dts->mday(), '==', 27, 'mday() on 1999-07-21 Gregorian' );
cmp_ok( $dts->month(), '==', 7, 'month() on 1999-07-21 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afterlithe', 'month_name() on 1999-07-21 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-07-21 Gregorian' );
Highday 27 Afterlithe 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63068198400, 'utc_rd_as_seconds() on 1999-07-21 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729956,
  0,
  0
]
, 'utc_rd_values() on 1999-07-21 Gregorian' );
cmp_ok( $dts->wday(), '==', 7, 'wday() on 1999-07-21 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  30
]
, 'week() on 1999-07-21 Gregorian' );
cmp_ok( $dts->week_number(), '==', 30, 'week_number() on 1999-07-21 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-07-21 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-07-21 Gregorian' );

$epoch = timegm( 0, 0, 0, 22, 7 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 7,
	day	=> 22,
    ),
);
cmp_ok( $dts->day(), '==', 28, 'day() on 1999-07-22 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sterday', 'day_name() on 1999-07-22 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sterrendei', 'day_name_trad() on 1999-07-22 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 28, 'day_of_month() on 1999-07-22 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 1, 'day_of_week() on 1999-07-22 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 212, 'day_of_year() on 1999-07-22 Gregorian' );
cmp_ok( $dts->dow(), '==', 1, 'dow() on 1999-07-22 Gregorian' );
cmp_ok( $dts->doy(), '==', 212, 'doy() on 1999-07-22 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-07-22 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-07-22 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-07-22 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-07-22 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-07-22 Gregorian' );
cmp_ok( $dts->mday(), '==', 28, 'mday() on 1999-07-22 Gregorian' );
cmp_ok( $dts->month(), '==', 7, 'month() on 1999-07-22 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afterlithe', 'month_name() on 1999-07-22 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-07-22 Gregorian' );
Sterday 28 Afterlithe 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63068284800, 'utc_rd_as_seconds() on 1999-07-22 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729957,
  0,
  0
]
, 'utc_rd_values() on 1999-07-22 Gregorian' );
cmp_ok( $dts->wday(), '==', 1, 'wday() on 1999-07-22 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  31
]
, 'week() on 1999-07-22 Gregorian' );
cmp_ok( $dts->week_number(), '==', 31, 'week_number() on 1999-07-22 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-07-22 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-07-22 Gregorian' );

$epoch = timegm( 0, 0, 0, 23, 7 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 7,
	day	=> 23,
    ),
);
cmp_ok( $dts->day(), '==', 29, 'day() on 1999-07-23 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sunday', 'day_name() on 1999-07-23 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sunnendei', 'day_name_trad() on 1999-07-23 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 29, 'day_of_month() on 1999-07-23 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 2, 'day_of_week() on 1999-07-23 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 213, 'day_of_year() on 1999-07-23 Gregorian' );
cmp_ok( $dts->dow(), '==', 2, 'dow() on 1999-07-23 Gregorian' );
cmp_ok( $dts->doy(), '==', 213, 'doy() on 1999-07-23 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-07-23 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-07-23 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-07-23 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-07-23 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-07-23 Gregorian' );
cmp_ok( $dts->mday(), '==', 29, 'mday() on 1999-07-23 Gregorian' );
cmp_ok( $dts->month(), '==', 7, 'month() on 1999-07-23 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afterlithe', 'month_name() on 1999-07-23 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-07-23 Gregorian' );
Sunday 29 Afterlithe 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63068371200, 'utc_rd_as_seconds() on 1999-07-23 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729958,
  0,
  0
]
, 'utc_rd_values() on 1999-07-23 Gregorian' );
cmp_ok( $dts->wday(), '==', 2, 'wday() on 1999-07-23 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  31
]
, 'week() on 1999-07-23 Gregorian' );
cmp_ok( $dts->week_number(), '==', 31, 'week_number() on 1999-07-23 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-07-23 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-07-23 Gregorian' );

$epoch = timegm( 0, 0, 0, 24, 7 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 7,
	day	=> 24,
    ),
);
cmp_ok( $dts->day(), '==', 30, 'day() on 1999-07-24 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Monday', 'day_name() on 1999-07-24 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Monendei', 'day_name_trad() on 1999-07-24 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 30, 'day_of_month() on 1999-07-24 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 3, 'day_of_week() on 1999-07-24 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 214, 'day_of_year() on 1999-07-24 Gregorian' );
cmp_ok( $dts->dow(), '==', 3, 'dow() on 1999-07-24 Gregorian' );
cmp_ok( $dts->doy(), '==', 214, 'doy() on 1999-07-24 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-07-24 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-07-24 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-07-24 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-07-24 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-07-24 Gregorian' );
cmp_ok( $dts->mday(), '==', 30, 'mday() on 1999-07-24 Gregorian' );
cmp_ok( $dts->month(), '==', 7, 'month() on 1999-07-24 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afterlithe', 'month_name() on 1999-07-24 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-07-24 Gregorian' );
Monday 30 Afterlithe 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63068457600, 'utc_rd_as_seconds() on 1999-07-24 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729959,
  0,
  0
]
, 'utc_rd_values() on 1999-07-24 Gregorian' );
cmp_ok( $dts->wday(), '==', 3, 'wday() on 1999-07-24 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  31
]
, 'week() on 1999-07-24 Gregorian' );
cmp_ok( $dts->week_number(), '==', 31, 'week_number() on 1999-07-24 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-07-24 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-07-24 Gregorian' );

$epoch = timegm( 0, 0, 0, 25, 7 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 7,
	day	=> 25,
    ),
);
cmp_ok( $dts->day(), '==', 1, 'day() on 1999-07-25 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Trewsday', 'day_name() on 1999-07-25 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Trewesdei', 'day_name_trad() on 1999-07-25 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 1, 'day_of_month() on 1999-07-25 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 4, 'day_of_week() on 1999-07-25 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 215, 'day_of_year() on 1999-07-25 Gregorian' );
cmp_ok( $dts->dow(), '==', 4, 'dow() on 1999-07-25 Gregorian' );
cmp_ok( $dts->doy(), '==', 215, 'doy() on 1999-07-25 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-07-25 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-07-25 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-07-25 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-07-25 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-07-25 Gregorian' );
cmp_ok( $dts->mday(), '==', 1, 'mday() on 1999-07-25 Gregorian' );
cmp_ok( $dts->month(), '==', 8, 'month() on 1999-07-25 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Wedmath', 'month_name() on 1999-07-25 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-07-25 Gregorian' );
Trewsday 1 Wedmath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63068544000, 'utc_rd_as_seconds() on 1999-07-25 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729960,
  0,
  0
]
, 'utc_rd_values() on 1999-07-25 Gregorian' );
cmp_ok( $dts->wday(), '==', 4, 'wday() on 1999-07-25 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  31
]
, 'week() on 1999-07-25 Gregorian' );
cmp_ok( $dts->week_number(), '==', 31, 'week_number() on 1999-07-25 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-07-25 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-07-25 Gregorian' );

$epoch = timegm( 0, 0, 0, 26, 7 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 7,
	day	=> 26,
    ),
);
cmp_ok( $dts->day(), '==', 2, 'day() on 1999-07-26 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Hevensday', 'day_name() on 1999-07-26 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Hevenesdei', 'day_name_trad() on 1999-07-26 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 2, 'day_of_month() on 1999-07-26 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 5, 'day_of_week() on 1999-07-26 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 216, 'day_of_year() on 1999-07-26 Gregorian' );
cmp_ok( $dts->dow(), '==', 5, 'dow() on 1999-07-26 Gregorian' );
cmp_ok( $dts->doy(), '==', 216, 'doy() on 1999-07-26 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-07-26 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-07-26 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-07-26 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-07-26 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-07-26 Gregorian' );
cmp_ok( $dts->mday(), '==', 2, 'mday() on 1999-07-26 Gregorian' );
cmp_ok( $dts->month(), '==', 8, 'month() on 1999-07-26 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Wedmath', 'month_name() on 1999-07-26 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-07-26 Gregorian' );
Hevensday 2 Wedmath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63068630400, 'utc_rd_as_seconds() on 1999-07-26 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729961,
  0,
  0
]
, 'utc_rd_values() on 1999-07-26 Gregorian' );
cmp_ok( $dts->wday(), '==', 5, 'wday() on 1999-07-26 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  31
]
, 'week() on 1999-07-26 Gregorian' );
cmp_ok( $dts->week_number(), '==', 31, 'week_number() on 1999-07-26 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-07-26 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-07-26 Gregorian' );

$epoch = timegm( 0, 0, 0, 27, 7 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 7,
	day	=> 27,
    ),
);
cmp_ok( $dts->day(), '==', 3, 'day() on 1999-07-27 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Mersday', 'day_name() on 1999-07-27 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Meresdei', 'day_name_trad() on 1999-07-27 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 3, 'day_of_month() on 1999-07-27 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 6, 'day_of_week() on 1999-07-27 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 217, 'day_of_year() on 1999-07-27 Gregorian' );
cmp_ok( $dts->dow(), '==', 6, 'dow() on 1999-07-27 Gregorian' );
cmp_ok( $dts->doy(), '==', 217, 'doy() on 1999-07-27 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-07-27 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-07-27 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-07-27 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-07-27 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-07-27 Gregorian' );
cmp_ok( $dts->mday(), '==', 3, 'mday() on 1999-07-27 Gregorian' );
cmp_ok( $dts->month(), '==', 8, 'month() on 1999-07-27 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Wedmath', 'month_name() on 1999-07-27 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-07-27 Gregorian' );
Mersday 3 Wedmath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63068716800, 'utc_rd_as_seconds() on 1999-07-27 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729962,
  0,
  0
]
, 'utc_rd_values() on 1999-07-27 Gregorian' );
cmp_ok( $dts->wday(), '==', 6, 'wday() on 1999-07-27 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  31
]
, 'week() on 1999-07-27 Gregorian' );
cmp_ok( $dts->week_number(), '==', 31, 'week_number() on 1999-07-27 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-07-27 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-07-27 Gregorian' );

$epoch = timegm( 0, 0, 0, 28, 7 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 7,
	day	=> 28,
    ),
);
cmp_ok( $dts->day(), '==', 4, 'day() on 1999-07-28 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Highday', 'day_name() on 1999-07-28 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Highdei', 'day_name_trad() on 1999-07-28 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 4, 'day_of_month() on 1999-07-28 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 7, 'day_of_week() on 1999-07-28 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 218, 'day_of_year() on 1999-07-28 Gregorian' );
cmp_ok( $dts->dow(), '==', 7, 'dow() on 1999-07-28 Gregorian' );
cmp_ok( $dts->doy(), '==', 218, 'doy() on 1999-07-28 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-07-28 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-07-28 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-07-28 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-07-28 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-07-28 Gregorian' );
cmp_ok( $dts->mday(), '==', 4, 'mday() on 1999-07-28 Gregorian' );
cmp_ok( $dts->month(), '==', 8, 'month() on 1999-07-28 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Wedmath', 'month_name() on 1999-07-28 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-07-28 Gregorian' );
Highday 4 Wedmath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63068803200, 'utc_rd_as_seconds() on 1999-07-28 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729963,
  0,
  0
]
, 'utc_rd_values() on 1999-07-28 Gregorian' );
cmp_ok( $dts->wday(), '==', 7, 'wday() on 1999-07-28 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  31
]
, 'week() on 1999-07-28 Gregorian' );
cmp_ok( $dts->week_number(), '==', 31, 'week_number() on 1999-07-28 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-07-28 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-07-28 Gregorian' );

$epoch = timegm( 0, 0, 0, 29, 7 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 7,
	day	=> 29,
    ),
);
cmp_ok( $dts->day(), '==', 5, 'day() on 1999-07-29 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sterday', 'day_name() on 1999-07-29 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sterrendei', 'day_name_trad() on 1999-07-29 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 5, 'day_of_month() on 1999-07-29 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 1, 'day_of_week() on 1999-07-29 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 219, 'day_of_year() on 1999-07-29 Gregorian' );
cmp_ok( $dts->dow(), '==', 1, 'dow() on 1999-07-29 Gregorian' );
cmp_ok( $dts->doy(), '==', 219, 'doy() on 1999-07-29 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-07-29 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-07-29 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-07-29 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-07-29 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-07-29 Gregorian' );
cmp_ok( $dts->mday(), '==', 5, 'mday() on 1999-07-29 Gregorian' );
cmp_ok( $dts->month(), '==', 8, 'month() on 1999-07-29 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Wedmath', 'month_name() on 1999-07-29 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-07-29 Gregorian' );
Sterday 5 Wedmath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63068889600, 'utc_rd_as_seconds() on 1999-07-29 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729964,
  0,
  0
]
, 'utc_rd_values() on 1999-07-29 Gregorian' );
cmp_ok( $dts->wday(), '==', 1, 'wday() on 1999-07-29 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  32
]
, 'week() on 1999-07-29 Gregorian' );
cmp_ok( $dts->week_number(), '==', 32, 'week_number() on 1999-07-29 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-07-29 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-07-29 Gregorian' );

$epoch = timegm( 0, 0, 0, 30, 7 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 7,
	day	=> 30,
    ),
);
cmp_ok( $dts->day(), '==', 6, 'day() on 1999-07-30 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sunday', 'day_name() on 1999-07-30 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sunnendei', 'day_name_trad() on 1999-07-30 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 6, 'day_of_month() on 1999-07-30 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 2, 'day_of_week() on 1999-07-30 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 220, 'day_of_year() on 1999-07-30 Gregorian' );
cmp_ok( $dts->dow(), '==', 2, 'dow() on 1999-07-30 Gregorian' );
cmp_ok( $dts->doy(), '==', 220, 'doy() on 1999-07-30 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-07-30 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-07-30 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-07-30 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-07-30 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-07-30 Gregorian' );
cmp_ok( $dts->mday(), '==', 6, 'mday() on 1999-07-30 Gregorian' );
cmp_ok( $dts->month(), '==', 8, 'month() on 1999-07-30 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Wedmath', 'month_name() on 1999-07-30 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-07-30 Gregorian' );
Sunday 6 Wedmath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63068976000, 'utc_rd_as_seconds() on 1999-07-30 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729965,
  0,
  0
]
, 'utc_rd_values() on 1999-07-30 Gregorian' );
cmp_ok( $dts->wday(), '==', 2, 'wday() on 1999-07-30 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  32
]
, 'week() on 1999-07-30 Gregorian' );
cmp_ok( $dts->week_number(), '==', 32, 'week_number() on 1999-07-30 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-07-30 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-07-30 Gregorian' );

$epoch = timegm( 0, 0, 0, 31, 7 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 7,
	day	=> 31,
    ),
);
cmp_ok( $dts->day(), '==', 7, 'day() on 1999-07-31 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Monday', 'day_name() on 1999-07-31 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Monendei', 'day_name_trad() on 1999-07-31 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 7, 'day_of_month() on 1999-07-31 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 3, 'day_of_week() on 1999-07-31 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 221, 'day_of_year() on 1999-07-31 Gregorian' );
cmp_ok( $dts->dow(), '==', 3, 'dow() on 1999-07-31 Gregorian' );
cmp_ok( $dts->doy(), '==', 221, 'doy() on 1999-07-31 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-07-31 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-07-31 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-07-31 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-07-31 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-07-31 Gregorian' );
cmp_ok( $dts->mday(), '==', 7, 'mday() on 1999-07-31 Gregorian' );
cmp_ok( $dts->month(), '==', 8, 'month() on 1999-07-31 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Wedmath', 'month_name() on 1999-07-31 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-07-31 Gregorian' );
Monday 7 Wedmath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63069062400, 'utc_rd_as_seconds() on 1999-07-31 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729966,
  0,
  0
]
, 'utc_rd_values() on 1999-07-31 Gregorian' );
cmp_ok( $dts->wday(), '==', 3, 'wday() on 1999-07-31 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  32
]
, 'week() on 1999-07-31 Gregorian' );
cmp_ok( $dts->week_number(), '==', 32, 'week_number() on 1999-07-31 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-07-31 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-07-31 Gregorian' );

$epoch = timegm( 0, 0, 0, 1, 8 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 8,
	day	=> 1,
    ),
);
cmp_ok( $dts->day(), '==', 8, 'day() on 1999-08-01 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Trewsday', 'day_name() on 1999-08-01 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Trewesdei', 'day_name_trad() on 1999-08-01 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 8, 'day_of_month() on 1999-08-01 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 4, 'day_of_week() on 1999-08-01 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 222, 'day_of_year() on 1999-08-01 Gregorian' );
cmp_ok( $dts->dow(), '==', 4, 'dow() on 1999-08-01 Gregorian' );
cmp_ok( $dts->doy(), '==', 222, 'doy() on 1999-08-01 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-08-01 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-08-01 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-08-01 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-08-01 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-08-01 Gregorian' );
cmp_ok( $dts->mday(), '==', 8, 'mday() on 1999-08-01 Gregorian' );
cmp_ok( $dts->month(), '==', 8, 'month() on 1999-08-01 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Wedmath', 'month_name() on 1999-08-01 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-08-01 Gregorian' );
Trewsday 8 Wedmath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63069148800, 'utc_rd_as_seconds() on 1999-08-01 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729967,
  0,
  0
]
, 'utc_rd_values() on 1999-08-01 Gregorian' );
cmp_ok( $dts->wday(), '==', 4, 'wday() on 1999-08-01 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  32
]
, 'week() on 1999-08-01 Gregorian' );
cmp_ok( $dts->week_number(), '==', 32, 'week_number() on 1999-08-01 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-08-01 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-08-01 Gregorian' );

$epoch = timegm( 0, 0, 0, 2, 8 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 8,
	day	=> 2,
    ),
);
cmp_ok( $dts->day(), '==', 9, 'day() on 1999-08-02 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Hevensday', 'day_name() on 1999-08-02 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Hevenesdei', 'day_name_trad() on 1999-08-02 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 9, 'day_of_month() on 1999-08-02 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 5, 'day_of_week() on 1999-08-02 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 223, 'day_of_year() on 1999-08-02 Gregorian' );
cmp_ok( $dts->dow(), '==', 5, 'dow() on 1999-08-02 Gregorian' );
cmp_ok( $dts->doy(), '==', 223, 'doy() on 1999-08-02 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-08-02 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-08-02 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-08-02 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-08-02 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-08-02 Gregorian' );
cmp_ok( $dts->mday(), '==', 9, 'mday() on 1999-08-02 Gregorian' );
cmp_ok( $dts->month(), '==', 8, 'month() on 1999-08-02 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Wedmath', 'month_name() on 1999-08-02 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-08-02 Gregorian' );
Hevensday 9 Wedmath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63069235200, 'utc_rd_as_seconds() on 1999-08-02 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729968,
  0,
  0
]
, 'utc_rd_values() on 1999-08-02 Gregorian' );
cmp_ok( $dts->wday(), '==', 5, 'wday() on 1999-08-02 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  32
]
, 'week() on 1999-08-02 Gregorian' );
cmp_ok( $dts->week_number(), '==', 32, 'week_number() on 1999-08-02 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-08-02 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-08-02 Gregorian' );

$epoch = timegm( 0, 0, 0, 3, 8 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 8,
	day	=> 3,
    ),
);
cmp_ok( $dts->day(), '==', 10, 'day() on 1999-08-03 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Mersday', 'day_name() on 1999-08-03 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Meresdei', 'day_name_trad() on 1999-08-03 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 10, 'day_of_month() on 1999-08-03 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 6, 'day_of_week() on 1999-08-03 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 224, 'day_of_year() on 1999-08-03 Gregorian' );
cmp_ok( $dts->dow(), '==', 6, 'dow() on 1999-08-03 Gregorian' );
cmp_ok( $dts->doy(), '==', 224, 'doy() on 1999-08-03 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-08-03 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-08-03 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-08-03 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-08-03 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-08-03 Gregorian' );
cmp_ok( $dts->mday(), '==', 10, 'mday() on 1999-08-03 Gregorian' );
cmp_ok( $dts->month(), '==', 8, 'month() on 1999-08-03 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Wedmath', 'month_name() on 1999-08-03 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-08-03 Gregorian' );
Mersday 10 Wedmath 7463

Funeral of King Theoden, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63069321600, 'utc_rd_as_seconds() on 1999-08-03 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729969,
  0,
  0
]
, 'utc_rd_values() on 1999-08-03 Gregorian' );
cmp_ok( $dts->wday(), '==', 6, 'wday() on 1999-08-03 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  32
]
, 'week() on 1999-08-03 Gregorian' );
cmp_ok( $dts->week_number(), '==', 32, 'week_number() on 1999-08-03 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-08-03 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-08-03 Gregorian' );

$epoch = timegm( 0, 0, 0, 4, 8 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 8,
	day	=> 4,
    ),
);
cmp_ok( $dts->day(), '==', 11, 'day() on 1999-08-04 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Highday', 'day_name() on 1999-08-04 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Highdei', 'day_name_trad() on 1999-08-04 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 11, 'day_of_month() on 1999-08-04 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 7, 'day_of_week() on 1999-08-04 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 225, 'day_of_year() on 1999-08-04 Gregorian' );
cmp_ok( $dts->dow(), '==', 7, 'dow() on 1999-08-04 Gregorian' );
cmp_ok( $dts->doy(), '==', 225, 'doy() on 1999-08-04 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-08-04 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-08-04 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-08-04 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-08-04 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-08-04 Gregorian' );
cmp_ok( $dts->mday(), '==', 11, 'mday() on 1999-08-04 Gregorian' );
cmp_ok( $dts->month(), '==', 8, 'month() on 1999-08-04 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Wedmath', 'month_name() on 1999-08-04 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-08-04 Gregorian' );
Highday 11 Wedmath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63069408000, 'utc_rd_as_seconds() on 1999-08-04 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729970,
  0,
  0
]
, 'utc_rd_values() on 1999-08-04 Gregorian' );
cmp_ok( $dts->wday(), '==', 7, 'wday() on 1999-08-04 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  32
]
, 'week() on 1999-08-04 Gregorian' );
cmp_ok( $dts->week_number(), '==', 32, 'week_number() on 1999-08-04 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-08-04 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-08-04 Gregorian' );

$epoch = timegm( 0, 0, 0, 5, 8 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 8,
	day	=> 5,
    ),
);
cmp_ok( $dts->day(), '==', 12, 'day() on 1999-08-05 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sterday', 'day_name() on 1999-08-05 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sterrendei', 'day_name_trad() on 1999-08-05 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 12, 'day_of_month() on 1999-08-05 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 1, 'day_of_week() on 1999-08-05 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 226, 'day_of_year() on 1999-08-05 Gregorian' );
cmp_ok( $dts->dow(), '==', 1, 'dow() on 1999-08-05 Gregorian' );
cmp_ok( $dts->doy(), '==', 226, 'doy() on 1999-08-05 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-08-05 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-08-05 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-08-05 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-08-05 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-08-05 Gregorian' );
cmp_ok( $dts->mday(), '==', 12, 'mday() on 1999-08-05 Gregorian' );
cmp_ok( $dts->month(), '==', 8, 'month() on 1999-08-05 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Wedmath', 'month_name() on 1999-08-05 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-08-05 Gregorian' );
Sterday 12 Wedmath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63069494400, 'utc_rd_as_seconds() on 1999-08-05 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729971,
  0,
  0
]
, 'utc_rd_values() on 1999-08-05 Gregorian' );
cmp_ok( $dts->wday(), '==', 1, 'wday() on 1999-08-05 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  33
]
, 'week() on 1999-08-05 Gregorian' );
cmp_ok( $dts->week_number(), '==', 33, 'week_number() on 1999-08-05 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-08-05 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-08-05 Gregorian' );

$epoch = timegm( 0, 0, 0, 6, 8 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 8,
	day	=> 6,
    ),
);
cmp_ok( $dts->day(), '==', 13, 'day() on 1999-08-06 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sunday', 'day_name() on 1999-08-06 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sunnendei', 'day_name_trad() on 1999-08-06 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 13, 'day_of_month() on 1999-08-06 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 2, 'day_of_week() on 1999-08-06 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 227, 'day_of_year() on 1999-08-06 Gregorian' );
cmp_ok( $dts->dow(), '==', 2, 'dow() on 1999-08-06 Gregorian' );
cmp_ok( $dts->doy(), '==', 227, 'doy() on 1999-08-06 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-08-06 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-08-06 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-08-06 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-08-06 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-08-06 Gregorian' );
cmp_ok( $dts->mday(), '==', 13, 'mday() on 1999-08-06 Gregorian' );
cmp_ok( $dts->month(), '==', 8, 'month() on 1999-08-06 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Wedmath', 'month_name() on 1999-08-06 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-08-06 Gregorian' );
Sunday 13 Wedmath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63069580800, 'utc_rd_as_seconds() on 1999-08-06 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729972,
  0,
  0
]
, 'utc_rd_values() on 1999-08-06 Gregorian' );
cmp_ok( $dts->wday(), '==', 2, 'wday() on 1999-08-06 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  33
]
, 'week() on 1999-08-06 Gregorian' );
cmp_ok( $dts->week_number(), '==', 33, 'week_number() on 1999-08-06 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-08-06 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-08-06 Gregorian' );

$epoch = timegm( 0, 0, 0, 7, 8 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 8,
	day	=> 7,
    ),
);
cmp_ok( $dts->day(), '==', 14, 'day() on 1999-08-07 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Monday', 'day_name() on 1999-08-07 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Monendei', 'day_name_trad() on 1999-08-07 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 14, 'day_of_month() on 1999-08-07 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 3, 'day_of_week() on 1999-08-07 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 228, 'day_of_year() on 1999-08-07 Gregorian' );
cmp_ok( $dts->dow(), '==', 3, 'dow() on 1999-08-07 Gregorian' );
cmp_ok( $dts->doy(), '==', 228, 'doy() on 1999-08-07 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-08-07 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-08-07 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-08-07 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-08-07 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-08-07 Gregorian' );
cmp_ok( $dts->mday(), '==', 14, 'mday() on 1999-08-07 Gregorian' );
cmp_ok( $dts->month(), '==', 8, 'month() on 1999-08-07 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Wedmath', 'month_name() on 1999-08-07 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-08-07 Gregorian' );
Monday 14 Wedmath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63069667200, 'utc_rd_as_seconds() on 1999-08-07 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729973,
  0,
  0
]
, 'utc_rd_values() on 1999-08-07 Gregorian' );
cmp_ok( $dts->wday(), '==', 3, 'wday() on 1999-08-07 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  33
]
, 'week() on 1999-08-07 Gregorian' );
cmp_ok( $dts->week_number(), '==', 33, 'week_number() on 1999-08-07 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-08-07 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-08-07 Gregorian' );

$epoch = timegm( 0, 0, 0, 8, 8 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 8,
	day	=> 8,
    ),
);
cmp_ok( $dts->day(), '==', 15, 'day() on 1999-08-08 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Trewsday', 'day_name() on 1999-08-08 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Trewesdei', 'day_name_trad() on 1999-08-08 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 15, 'day_of_month() on 1999-08-08 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 4, 'day_of_week() on 1999-08-08 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 229, 'day_of_year() on 1999-08-08 Gregorian' );
cmp_ok( $dts->dow(), '==', 4, 'dow() on 1999-08-08 Gregorian' );
cmp_ok( $dts->doy(), '==', 229, 'doy() on 1999-08-08 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-08-08 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-08-08 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-08-08 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-08-08 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-08-08 Gregorian' );
cmp_ok( $dts->mday(), '==', 15, 'mday() on 1999-08-08 Gregorian' );
cmp_ok( $dts->month(), '==', 8, 'month() on 1999-08-08 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Wedmath', 'month_name() on 1999-08-08 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-08-08 Gregorian' );
Trewsday 15 Wedmath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63069753600, 'utc_rd_as_seconds() on 1999-08-08 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729974,
  0,
  0
]
, 'utc_rd_values() on 1999-08-08 Gregorian' );
cmp_ok( $dts->wday(), '==', 4, 'wday() on 1999-08-08 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  33
]
, 'week() on 1999-08-08 Gregorian' );
cmp_ok( $dts->week_number(), '==', 33, 'week_number() on 1999-08-08 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-08-08 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-08-08 Gregorian' );

$epoch = timegm( 0, 0, 0, 9, 8 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 8,
	day	=> 9,
    ),
);
cmp_ok( $dts->day(), '==', 16, 'day() on 1999-08-09 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Hevensday', 'day_name() on 1999-08-09 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Hevenesdei', 'day_name_trad() on 1999-08-09 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 16, 'day_of_month() on 1999-08-09 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 5, 'day_of_week() on 1999-08-09 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 230, 'day_of_year() on 1999-08-09 Gregorian' );
cmp_ok( $dts->dow(), '==', 5, 'dow() on 1999-08-09 Gregorian' );
cmp_ok( $dts->doy(), '==', 230, 'doy() on 1999-08-09 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-08-09 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-08-09 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-08-09 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-08-09 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-08-09 Gregorian' );
cmp_ok( $dts->mday(), '==', 16, 'mday() on 1999-08-09 Gregorian' );
cmp_ok( $dts->month(), '==', 8, 'month() on 1999-08-09 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Wedmath', 'month_name() on 1999-08-09 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-08-09 Gregorian' );
Hevensday 16 Wedmath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63069840000, 'utc_rd_as_seconds() on 1999-08-09 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729975,
  0,
  0
]
, 'utc_rd_values() on 1999-08-09 Gregorian' );
cmp_ok( $dts->wday(), '==', 5, 'wday() on 1999-08-09 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  33
]
, 'week() on 1999-08-09 Gregorian' );
cmp_ok( $dts->week_number(), '==', 33, 'week_number() on 1999-08-09 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-08-09 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-08-09 Gregorian' );

$epoch = timegm( 0, 0, 0, 10, 8 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 8,
	day	=> 10,
    ),
);
cmp_ok( $dts->day(), '==', 17, 'day() on 1999-08-10 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Mersday', 'day_name() on 1999-08-10 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Meresdei', 'day_name_trad() on 1999-08-10 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 17, 'day_of_month() on 1999-08-10 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 6, 'day_of_week() on 1999-08-10 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 231, 'day_of_year() on 1999-08-10 Gregorian' );
cmp_ok( $dts->dow(), '==', 6, 'dow() on 1999-08-10 Gregorian' );
cmp_ok( $dts->doy(), '==', 231, 'doy() on 1999-08-10 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-08-10 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-08-10 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-08-10 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-08-10 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-08-10 Gregorian' );
cmp_ok( $dts->mday(), '==', 17, 'mday() on 1999-08-10 Gregorian' );
cmp_ok( $dts->month(), '==', 8, 'month() on 1999-08-10 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Wedmath', 'month_name() on 1999-08-10 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-08-10 Gregorian' );
Mersday 17 Wedmath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63069926400, 'utc_rd_as_seconds() on 1999-08-10 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729976,
  0,
  0
]
, 'utc_rd_values() on 1999-08-10 Gregorian' );
cmp_ok( $dts->wday(), '==', 6, 'wday() on 1999-08-10 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  33
]
, 'week() on 1999-08-10 Gregorian' );
cmp_ok( $dts->week_number(), '==', 33, 'week_number() on 1999-08-10 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-08-10 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-08-10 Gregorian' );

$epoch = timegm( 0, 0, 0, 11, 8 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 8,
	day	=> 11,
    ),
);
cmp_ok( $dts->day(), '==', 18, 'day() on 1999-08-11 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Highday', 'day_name() on 1999-08-11 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Highdei', 'day_name_trad() on 1999-08-11 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 18, 'day_of_month() on 1999-08-11 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 7, 'day_of_week() on 1999-08-11 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 232, 'day_of_year() on 1999-08-11 Gregorian' );
cmp_ok( $dts->dow(), '==', 7, 'dow() on 1999-08-11 Gregorian' );
cmp_ok( $dts->doy(), '==', 232, 'doy() on 1999-08-11 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-08-11 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-08-11 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-08-11 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-08-11 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-08-11 Gregorian' );
cmp_ok( $dts->mday(), '==', 18, 'mday() on 1999-08-11 Gregorian' );
cmp_ok( $dts->month(), '==', 8, 'month() on 1999-08-11 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Wedmath', 'month_name() on 1999-08-11 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-08-11 Gregorian' );
Highday 18 Wedmath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63070012800, 'utc_rd_as_seconds() on 1999-08-11 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729977,
  0,
  0
]
, 'utc_rd_values() on 1999-08-11 Gregorian' );
cmp_ok( $dts->wday(), '==', 7, 'wday() on 1999-08-11 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  33
]
, 'week() on 1999-08-11 Gregorian' );
cmp_ok( $dts->week_number(), '==', 33, 'week_number() on 1999-08-11 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-08-11 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-08-11 Gregorian' );

$epoch = timegm( 0, 0, 0, 12, 8 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 8,
	day	=> 12,
    ),
);
cmp_ok( $dts->day(), '==', 19, 'day() on 1999-08-12 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sterday', 'day_name() on 1999-08-12 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sterrendei', 'day_name_trad() on 1999-08-12 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 19, 'day_of_month() on 1999-08-12 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 1, 'day_of_week() on 1999-08-12 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 233, 'day_of_year() on 1999-08-12 Gregorian' );
cmp_ok( $dts->dow(), '==', 1, 'dow() on 1999-08-12 Gregorian' );
cmp_ok( $dts->doy(), '==', 233, 'doy() on 1999-08-12 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-08-12 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-08-12 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-08-12 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-08-12 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-08-12 Gregorian' );
cmp_ok( $dts->mday(), '==', 19, 'mday() on 1999-08-12 Gregorian' );
cmp_ok( $dts->month(), '==', 8, 'month() on 1999-08-12 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Wedmath', 'month_name() on 1999-08-12 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-08-12 Gregorian' );
Sterday 19 Wedmath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63070099200, 'utc_rd_as_seconds() on 1999-08-12 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729978,
  0,
  0
]
, 'utc_rd_values() on 1999-08-12 Gregorian' );
cmp_ok( $dts->wday(), '==', 1, 'wday() on 1999-08-12 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  34
]
, 'week() on 1999-08-12 Gregorian' );
cmp_ok( $dts->week_number(), '==', 34, 'week_number() on 1999-08-12 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-08-12 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-08-12 Gregorian' );

$epoch = timegm( 0, 0, 0, 13, 8 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 8,
	day	=> 13,
    ),
);
cmp_ok( $dts->day(), '==', 20, 'day() on 1999-08-13 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sunday', 'day_name() on 1999-08-13 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sunnendei', 'day_name_trad() on 1999-08-13 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 20, 'day_of_month() on 1999-08-13 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 2, 'day_of_week() on 1999-08-13 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 234, 'day_of_year() on 1999-08-13 Gregorian' );
cmp_ok( $dts->dow(), '==', 2, 'dow() on 1999-08-13 Gregorian' );
cmp_ok( $dts->doy(), '==', 234, 'doy() on 1999-08-13 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-08-13 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-08-13 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-08-13 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-08-13 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-08-13 Gregorian' );
cmp_ok( $dts->mday(), '==', 20, 'mday() on 1999-08-13 Gregorian' );
cmp_ok( $dts->month(), '==', 8, 'month() on 1999-08-13 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Wedmath', 'month_name() on 1999-08-13 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-08-13 Gregorian' );
Sunday 20 Wedmath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63070185600, 'utc_rd_as_seconds() on 1999-08-13 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729979,
  0,
  0
]
, 'utc_rd_values() on 1999-08-13 Gregorian' );
cmp_ok( $dts->wday(), '==', 2, 'wday() on 1999-08-13 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  34
]
, 'week() on 1999-08-13 Gregorian' );
cmp_ok( $dts->week_number(), '==', 34, 'week_number() on 1999-08-13 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-08-13 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-08-13 Gregorian' );

$epoch = timegm( 0, 0, 0, 14, 8 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 8,
	day	=> 14,
    ),
);
cmp_ok( $dts->day(), '==', 21, 'day() on 1999-08-14 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Monday', 'day_name() on 1999-08-14 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Monendei', 'day_name_trad() on 1999-08-14 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 21, 'day_of_month() on 1999-08-14 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 3, 'day_of_week() on 1999-08-14 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 235, 'day_of_year() on 1999-08-14 Gregorian' );
cmp_ok( $dts->dow(), '==', 3, 'dow() on 1999-08-14 Gregorian' );
cmp_ok( $dts->doy(), '==', 235, 'doy() on 1999-08-14 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-08-14 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-08-14 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-08-14 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-08-14 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-08-14 Gregorian' );
cmp_ok( $dts->mday(), '==', 21, 'mday() on 1999-08-14 Gregorian' );
cmp_ok( $dts->month(), '==', 8, 'month() on 1999-08-14 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Wedmath', 'month_name() on 1999-08-14 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-08-14 Gregorian' );
Monday 21 Wedmath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63070272000, 'utc_rd_as_seconds() on 1999-08-14 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729980,
  0,
  0
]
, 'utc_rd_values() on 1999-08-14 Gregorian' );
cmp_ok( $dts->wday(), '==', 3, 'wday() on 1999-08-14 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  34
]
, 'week() on 1999-08-14 Gregorian' );
cmp_ok( $dts->week_number(), '==', 34, 'week_number() on 1999-08-14 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-08-14 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-08-14 Gregorian' );

$epoch = timegm( 0, 0, 0, 15, 8 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 8,
	day	=> 15,
    ),
);
cmp_ok( $dts->day(), '==', 22, 'day() on 1999-08-15 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Trewsday', 'day_name() on 1999-08-15 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Trewesdei', 'day_name_trad() on 1999-08-15 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 22, 'day_of_month() on 1999-08-15 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 4, 'day_of_week() on 1999-08-15 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 236, 'day_of_year() on 1999-08-15 Gregorian' );
cmp_ok( $dts->dow(), '==', 4, 'dow() on 1999-08-15 Gregorian' );
cmp_ok( $dts->doy(), '==', 236, 'doy() on 1999-08-15 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-08-15 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-08-15 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-08-15 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-08-15 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-08-15 Gregorian' );
cmp_ok( $dts->mday(), '==', 22, 'mday() on 1999-08-15 Gregorian' );
cmp_ok( $dts->month(), '==', 8, 'month() on 1999-08-15 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Wedmath', 'month_name() on 1999-08-15 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-08-15 Gregorian' );
Trewsday 22 Wedmath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63070358400, 'utc_rd_as_seconds() on 1999-08-15 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729981,
  0,
  0
]
, 'utc_rd_values() on 1999-08-15 Gregorian' );
cmp_ok( $dts->wday(), '==', 4, 'wday() on 1999-08-15 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  34
]
, 'week() on 1999-08-15 Gregorian' );
cmp_ok( $dts->week_number(), '==', 34, 'week_number() on 1999-08-15 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-08-15 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-08-15 Gregorian' );

$epoch = timegm( 0, 0, 0, 16, 8 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 8,
	day	=> 16,
    ),
);
cmp_ok( $dts->day(), '==', 23, 'day() on 1999-08-16 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Hevensday', 'day_name() on 1999-08-16 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Hevenesdei', 'day_name_trad() on 1999-08-16 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 23, 'day_of_month() on 1999-08-16 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 5, 'day_of_week() on 1999-08-16 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 237, 'day_of_year() on 1999-08-16 Gregorian' );
cmp_ok( $dts->dow(), '==', 5, 'dow() on 1999-08-16 Gregorian' );
cmp_ok( $dts->doy(), '==', 237, 'doy() on 1999-08-16 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-08-16 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-08-16 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-08-16 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-08-16 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-08-16 Gregorian' );
cmp_ok( $dts->mday(), '==', 23, 'mday() on 1999-08-16 Gregorian' );
cmp_ok( $dts->month(), '==', 8, 'month() on 1999-08-16 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Wedmath', 'month_name() on 1999-08-16 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-08-16 Gregorian' );
Hevensday 23 Wedmath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63070444800, 'utc_rd_as_seconds() on 1999-08-16 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729982,
  0,
  0
]
, 'utc_rd_values() on 1999-08-16 Gregorian' );
cmp_ok( $dts->wday(), '==', 5, 'wday() on 1999-08-16 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  34
]
, 'week() on 1999-08-16 Gregorian' );
cmp_ok( $dts->week_number(), '==', 34, 'week_number() on 1999-08-16 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-08-16 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-08-16 Gregorian' );

$epoch = timegm( 0, 0, 0, 17, 8 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 8,
	day	=> 17,
    ),
);
cmp_ok( $dts->day(), '==', 24, 'day() on 1999-08-17 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Mersday', 'day_name() on 1999-08-17 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Meresdei', 'day_name_trad() on 1999-08-17 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 24, 'day_of_month() on 1999-08-17 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 6, 'day_of_week() on 1999-08-17 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 238, 'day_of_year() on 1999-08-17 Gregorian' );
cmp_ok( $dts->dow(), '==', 6, 'dow() on 1999-08-17 Gregorian' );
cmp_ok( $dts->doy(), '==', 238, 'doy() on 1999-08-17 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-08-17 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-08-17 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-08-17 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-08-17 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-08-17 Gregorian' );
cmp_ok( $dts->mday(), '==', 24, 'mday() on 1999-08-17 Gregorian' );
cmp_ok( $dts->month(), '==', 8, 'month() on 1999-08-17 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Wedmath', 'month_name() on 1999-08-17 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-08-17 Gregorian' );
Mersday 24 Wedmath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63070531200, 'utc_rd_as_seconds() on 1999-08-17 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729983,
  0,
  0
]
, 'utc_rd_values() on 1999-08-17 Gregorian' );
cmp_ok( $dts->wday(), '==', 6, 'wday() on 1999-08-17 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  34
]
, 'week() on 1999-08-17 Gregorian' );
cmp_ok( $dts->week_number(), '==', 34, 'week_number() on 1999-08-17 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-08-17 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-08-17 Gregorian' );

$epoch = timegm( 0, 0, 0, 18, 8 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 8,
	day	=> 18,
    ),
);
cmp_ok( $dts->day(), '==', 25, 'day() on 1999-08-18 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Highday', 'day_name() on 1999-08-18 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Highdei', 'day_name_trad() on 1999-08-18 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 25, 'day_of_month() on 1999-08-18 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 7, 'day_of_week() on 1999-08-18 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 239, 'day_of_year() on 1999-08-18 Gregorian' );
cmp_ok( $dts->dow(), '==', 7, 'dow() on 1999-08-18 Gregorian' );
cmp_ok( $dts->doy(), '==', 239, 'doy() on 1999-08-18 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-08-18 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-08-18 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-08-18 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-08-18 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-08-18 Gregorian' );
cmp_ok( $dts->mday(), '==', 25, 'mday() on 1999-08-18 Gregorian' );
cmp_ok( $dts->month(), '==', 8, 'month() on 1999-08-18 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Wedmath', 'month_name() on 1999-08-18 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-08-18 Gregorian' );
Highday 25 Wedmath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63070617600, 'utc_rd_as_seconds() on 1999-08-18 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729984,
  0,
  0
]
, 'utc_rd_values() on 1999-08-18 Gregorian' );
cmp_ok( $dts->wday(), '==', 7, 'wday() on 1999-08-18 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  34
]
, 'week() on 1999-08-18 Gregorian' );
cmp_ok( $dts->week_number(), '==', 34, 'week_number() on 1999-08-18 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-08-18 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-08-18 Gregorian' );

$epoch = timegm( 0, 0, 0, 19, 8 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 8,
	day	=> 19,
    ),
);
cmp_ok( $dts->day(), '==', 26, 'day() on 1999-08-19 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sterday', 'day_name() on 1999-08-19 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sterrendei', 'day_name_trad() on 1999-08-19 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 26, 'day_of_month() on 1999-08-19 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 1, 'day_of_week() on 1999-08-19 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 240, 'day_of_year() on 1999-08-19 Gregorian' );
cmp_ok( $dts->dow(), '==', 1, 'dow() on 1999-08-19 Gregorian' );
cmp_ok( $dts->doy(), '==', 240, 'doy() on 1999-08-19 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-08-19 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-08-19 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-08-19 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-08-19 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-08-19 Gregorian' );
cmp_ok( $dts->mday(), '==', 26, 'mday() on 1999-08-19 Gregorian' );
cmp_ok( $dts->month(), '==', 8, 'month() on 1999-08-19 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Wedmath', 'month_name() on 1999-08-19 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-08-19 Gregorian' );
Sterday 26 Wedmath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63070704000, 'utc_rd_as_seconds() on 1999-08-19 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729985,
  0,
  0
]
, 'utc_rd_values() on 1999-08-19 Gregorian' );
cmp_ok( $dts->wday(), '==', 1, 'wday() on 1999-08-19 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  35
]
, 'week() on 1999-08-19 Gregorian' );
cmp_ok( $dts->week_number(), '==', 35, 'week_number() on 1999-08-19 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-08-19 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-08-19 Gregorian' );

$epoch = timegm( 0, 0, 0, 20, 8 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 8,
	day	=> 20,
    ),
);
cmp_ok( $dts->day(), '==', 27, 'day() on 1999-08-20 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sunday', 'day_name() on 1999-08-20 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sunnendei', 'day_name_trad() on 1999-08-20 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 27, 'day_of_month() on 1999-08-20 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 2, 'day_of_week() on 1999-08-20 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 241, 'day_of_year() on 1999-08-20 Gregorian' );
cmp_ok( $dts->dow(), '==', 2, 'dow() on 1999-08-20 Gregorian' );
cmp_ok( $dts->doy(), '==', 241, 'doy() on 1999-08-20 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-08-20 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-08-20 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-08-20 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-08-20 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-08-20 Gregorian' );
cmp_ok( $dts->mday(), '==', 27, 'mday() on 1999-08-20 Gregorian' );
cmp_ok( $dts->month(), '==', 8, 'month() on 1999-08-20 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Wedmath', 'month_name() on 1999-08-20 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-08-20 Gregorian' );
Sunday 27 Wedmath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63070790400, 'utc_rd_as_seconds() on 1999-08-20 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729986,
  0,
  0
]
, 'utc_rd_values() on 1999-08-20 Gregorian' );
cmp_ok( $dts->wday(), '==', 2, 'wday() on 1999-08-20 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  35
]
, 'week() on 1999-08-20 Gregorian' );
cmp_ok( $dts->week_number(), '==', 35, 'week_number() on 1999-08-20 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-08-20 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-08-20 Gregorian' );

$epoch = timegm( 0, 0, 0, 21, 8 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 8,
	day	=> 21,
    ),
);
cmp_ok( $dts->day(), '==', 28, 'day() on 1999-08-21 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Monday', 'day_name() on 1999-08-21 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Monendei', 'day_name_trad() on 1999-08-21 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 28, 'day_of_month() on 1999-08-21 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 3, 'day_of_week() on 1999-08-21 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 242, 'day_of_year() on 1999-08-21 Gregorian' );
cmp_ok( $dts->dow(), '==', 3, 'dow() on 1999-08-21 Gregorian' );
cmp_ok( $dts->doy(), '==', 242, 'doy() on 1999-08-21 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-08-21 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-08-21 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-08-21 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-08-21 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-08-21 Gregorian' );
cmp_ok( $dts->mday(), '==', 28, 'mday() on 1999-08-21 Gregorian' );
cmp_ok( $dts->month(), '==', 8, 'month() on 1999-08-21 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Wedmath', 'month_name() on 1999-08-21 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-08-21 Gregorian' );
Monday 28 Wedmath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63070876800, 'utc_rd_as_seconds() on 1999-08-21 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729987,
  0,
  0
]
, 'utc_rd_values() on 1999-08-21 Gregorian' );
cmp_ok( $dts->wday(), '==', 3, 'wday() on 1999-08-21 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  35
]
, 'week() on 1999-08-21 Gregorian' );
cmp_ok( $dts->week_number(), '==', 35, 'week_number() on 1999-08-21 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-08-21 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-08-21 Gregorian' );

$epoch = timegm( 0, 0, 0, 22, 8 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 8,
	day	=> 22,
    ),
);
cmp_ok( $dts->day(), '==', 29, 'day() on 1999-08-22 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Trewsday', 'day_name() on 1999-08-22 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Trewesdei', 'day_name_trad() on 1999-08-22 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 29, 'day_of_month() on 1999-08-22 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 4, 'day_of_week() on 1999-08-22 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 243, 'day_of_year() on 1999-08-22 Gregorian' );
cmp_ok( $dts->dow(), '==', 4, 'dow() on 1999-08-22 Gregorian' );
cmp_ok( $dts->doy(), '==', 243, 'doy() on 1999-08-22 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-08-22 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-08-22 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-08-22 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-08-22 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-08-22 Gregorian' );
cmp_ok( $dts->mday(), '==', 29, 'mday() on 1999-08-22 Gregorian' );
cmp_ok( $dts->month(), '==', 8, 'month() on 1999-08-22 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Wedmath', 'month_name() on 1999-08-22 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-08-22 Gregorian' );
Trewsday 29 Wedmath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63070963200, 'utc_rd_as_seconds() on 1999-08-22 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729988,
  0,
  0
]
, 'utc_rd_values() on 1999-08-22 Gregorian' );
cmp_ok( $dts->wday(), '==', 4, 'wday() on 1999-08-22 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  35
]
, 'week() on 1999-08-22 Gregorian' );
cmp_ok( $dts->week_number(), '==', 35, 'week_number() on 1999-08-22 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-08-22 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-08-22 Gregorian' );

$epoch = timegm( 0, 0, 0, 23, 8 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 8,
	day	=> 23,
    ),
);
cmp_ok( $dts->day(), '==', 30, 'day() on 1999-08-23 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Hevensday', 'day_name() on 1999-08-23 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Hevenesdei', 'day_name_trad() on 1999-08-23 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 30, 'day_of_month() on 1999-08-23 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 5, 'day_of_week() on 1999-08-23 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 244, 'day_of_year() on 1999-08-23 Gregorian' );
cmp_ok( $dts->dow(), '==', 5, 'dow() on 1999-08-23 Gregorian' );
cmp_ok( $dts->doy(), '==', 244, 'doy() on 1999-08-23 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-08-23 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-08-23 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-08-23 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-08-23 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-08-23 Gregorian' );
cmp_ok( $dts->mday(), '==', 30, 'mday() on 1999-08-23 Gregorian' );
cmp_ok( $dts->month(), '==', 8, 'month() on 1999-08-23 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Wedmath', 'month_name() on 1999-08-23 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-08-23 Gregorian' );
Hevensday 30 Wedmath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63071049600, 'utc_rd_as_seconds() on 1999-08-23 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729989,
  0,
  0
]
, 'utc_rd_values() on 1999-08-23 Gregorian' );
cmp_ok( $dts->wday(), '==', 5, 'wday() on 1999-08-23 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  35
]
, 'week() on 1999-08-23 Gregorian' );
cmp_ok( $dts->week_number(), '==', 35, 'week_number() on 1999-08-23 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-08-23 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-08-23 Gregorian' );

$epoch = timegm( 0, 0, 0, 24, 8 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 8,
	day	=> 24,
    ),
);
cmp_ok( $dts->day(), '==', 1, 'day() on 1999-08-24 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Mersday', 'day_name() on 1999-08-24 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Meresdei', 'day_name_trad() on 1999-08-24 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 1, 'day_of_month() on 1999-08-24 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 6, 'day_of_week() on 1999-08-24 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 245, 'day_of_year() on 1999-08-24 Gregorian' );
cmp_ok( $dts->dow(), '==', 6, 'dow() on 1999-08-24 Gregorian' );
cmp_ok( $dts->doy(), '==', 245, 'doy() on 1999-08-24 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-08-24 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-08-24 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-08-24 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-08-24 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-08-24 Gregorian' );
cmp_ok( $dts->mday(), '==', 1, 'mday() on 1999-08-24 Gregorian' );
cmp_ok( $dts->month(), '==', 9, 'month() on 1999-08-24 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Halimath', 'month_name() on 1999-08-24 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-08-24 Gregorian' );
Mersday 1 Halimath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63071136000, 'utc_rd_as_seconds() on 1999-08-24 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729990,
  0,
  0
]
, 'utc_rd_values() on 1999-08-24 Gregorian' );
cmp_ok( $dts->wday(), '==', 6, 'wday() on 1999-08-24 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  35
]
, 'week() on 1999-08-24 Gregorian' );
cmp_ok( $dts->week_number(), '==', 35, 'week_number() on 1999-08-24 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-08-24 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-08-24 Gregorian' );

$epoch = timegm( 0, 0, 0, 25, 8 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 8,
	day	=> 25,
    ),
);
cmp_ok( $dts->day(), '==', 2, 'day() on 1999-08-25 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Highday', 'day_name() on 1999-08-25 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Highdei', 'day_name_trad() on 1999-08-25 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 2, 'day_of_month() on 1999-08-25 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 7, 'day_of_week() on 1999-08-25 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 246, 'day_of_year() on 1999-08-25 Gregorian' );
cmp_ok( $dts->dow(), '==', 7, 'dow() on 1999-08-25 Gregorian' );
cmp_ok( $dts->doy(), '==', 246, 'doy() on 1999-08-25 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-08-25 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-08-25 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-08-25 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-08-25 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-08-25 Gregorian' );
cmp_ok( $dts->mday(), '==', 2, 'mday() on 1999-08-25 Gregorian' );
cmp_ok( $dts->month(), '==', 9, 'month() on 1999-08-25 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Halimath', 'month_name() on 1999-08-25 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-08-25 Gregorian' );
Highday 2 Halimath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63071222400, 'utc_rd_as_seconds() on 1999-08-25 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729991,
  0,
  0
]
, 'utc_rd_values() on 1999-08-25 Gregorian' );
cmp_ok( $dts->wday(), '==', 7, 'wday() on 1999-08-25 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  35
]
, 'week() on 1999-08-25 Gregorian' );
cmp_ok( $dts->week_number(), '==', 35, 'week_number() on 1999-08-25 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-08-25 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-08-25 Gregorian' );

$epoch = timegm( 0, 0, 0, 26, 8 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 8,
	day	=> 26,
    ),
);
cmp_ok( $dts->day(), '==', 3, 'day() on 1999-08-26 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sterday', 'day_name() on 1999-08-26 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sterrendei', 'day_name_trad() on 1999-08-26 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 3, 'day_of_month() on 1999-08-26 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 1, 'day_of_week() on 1999-08-26 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 247, 'day_of_year() on 1999-08-26 Gregorian' );
cmp_ok( $dts->dow(), '==', 1, 'dow() on 1999-08-26 Gregorian' );
cmp_ok( $dts->doy(), '==', 247, 'doy() on 1999-08-26 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-08-26 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-08-26 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-08-26 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-08-26 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-08-26 Gregorian' );
cmp_ok( $dts->mday(), '==', 3, 'mday() on 1999-08-26 Gregorian' );
cmp_ok( $dts->month(), '==', 9, 'month() on 1999-08-26 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Halimath', 'month_name() on 1999-08-26 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-08-26 Gregorian' );
Sterday 3 Halimath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63071308800, 'utc_rd_as_seconds() on 1999-08-26 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729992,
  0,
  0
]
, 'utc_rd_values() on 1999-08-26 Gregorian' );
cmp_ok( $dts->wday(), '==', 1, 'wday() on 1999-08-26 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  36
]
, 'week() on 1999-08-26 Gregorian' );
cmp_ok( $dts->week_number(), '==', 36, 'week_number() on 1999-08-26 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-08-26 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-08-26 Gregorian' );

$epoch = timegm( 0, 0, 0, 27, 8 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 8,
	day	=> 27,
    ),
);
cmp_ok( $dts->day(), '==', 4, 'day() on 1999-08-27 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sunday', 'day_name() on 1999-08-27 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sunnendei', 'day_name_trad() on 1999-08-27 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 4, 'day_of_month() on 1999-08-27 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 2, 'day_of_week() on 1999-08-27 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 248, 'day_of_year() on 1999-08-27 Gregorian' );
cmp_ok( $dts->dow(), '==', 2, 'dow() on 1999-08-27 Gregorian' );
cmp_ok( $dts->doy(), '==', 248, 'doy() on 1999-08-27 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-08-27 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-08-27 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-08-27 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-08-27 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-08-27 Gregorian' );
cmp_ok( $dts->mday(), '==', 4, 'mday() on 1999-08-27 Gregorian' );
cmp_ok( $dts->month(), '==', 9, 'month() on 1999-08-27 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Halimath', 'month_name() on 1999-08-27 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-08-27 Gregorian' );
Sunday 4 Halimath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63071395200, 'utc_rd_as_seconds() on 1999-08-27 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729993,
  0,
  0
]
, 'utc_rd_values() on 1999-08-27 Gregorian' );
cmp_ok( $dts->wday(), '==', 2, 'wday() on 1999-08-27 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  36
]
, 'week() on 1999-08-27 Gregorian' );
cmp_ok( $dts->week_number(), '==', 36, 'week_number() on 1999-08-27 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-08-27 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-08-27 Gregorian' );

$epoch = timegm( 0, 0, 0, 28, 8 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 8,
	day	=> 28,
    ),
);
cmp_ok( $dts->day(), '==', 5, 'day() on 1999-08-28 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Monday', 'day_name() on 1999-08-28 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Monendei', 'day_name_trad() on 1999-08-28 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 5, 'day_of_month() on 1999-08-28 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 3, 'day_of_week() on 1999-08-28 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 249, 'day_of_year() on 1999-08-28 Gregorian' );
cmp_ok( $dts->dow(), '==', 3, 'dow() on 1999-08-28 Gregorian' );
cmp_ok( $dts->doy(), '==', 249, 'doy() on 1999-08-28 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-08-28 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-08-28 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-08-28 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-08-28 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-08-28 Gregorian' );
cmp_ok( $dts->mday(), '==', 5, 'mday() on 1999-08-28 Gregorian' );
cmp_ok( $dts->month(), '==', 9, 'month() on 1999-08-28 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Halimath', 'month_name() on 1999-08-28 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-08-28 Gregorian' );
Monday 5 Halimath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63071481600, 'utc_rd_as_seconds() on 1999-08-28 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729994,
  0,
  0
]
, 'utc_rd_values() on 1999-08-28 Gregorian' );
cmp_ok( $dts->wday(), '==', 3, 'wday() on 1999-08-28 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  36
]
, 'week() on 1999-08-28 Gregorian' );
cmp_ok( $dts->week_number(), '==', 36, 'week_number() on 1999-08-28 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-08-28 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-08-28 Gregorian' );

$epoch = timegm( 0, 0, 0, 29, 8 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 8,
	day	=> 29,
    ),
);
cmp_ok( $dts->day(), '==', 6, 'day() on 1999-08-29 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Trewsday', 'day_name() on 1999-08-29 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Trewesdei', 'day_name_trad() on 1999-08-29 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 6, 'day_of_month() on 1999-08-29 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 4, 'day_of_week() on 1999-08-29 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 250, 'day_of_year() on 1999-08-29 Gregorian' );
cmp_ok( $dts->dow(), '==', 4, 'dow() on 1999-08-29 Gregorian' );
cmp_ok( $dts->doy(), '==', 250, 'doy() on 1999-08-29 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-08-29 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-08-29 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-08-29 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-08-29 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-08-29 Gregorian' );
cmp_ok( $dts->mday(), '==', 6, 'mday() on 1999-08-29 Gregorian' );
cmp_ok( $dts->month(), '==', 9, 'month() on 1999-08-29 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Halimath', 'month_name() on 1999-08-29 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-08-29 Gregorian' );
Trewsday 6 Halimath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63071568000, 'utc_rd_as_seconds() on 1999-08-29 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729995,
  0,
  0
]
, 'utc_rd_values() on 1999-08-29 Gregorian' );
cmp_ok( $dts->wday(), '==', 4, 'wday() on 1999-08-29 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  36
]
, 'week() on 1999-08-29 Gregorian' );
cmp_ok( $dts->week_number(), '==', 36, 'week_number() on 1999-08-29 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-08-29 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-08-29 Gregorian' );

$epoch = timegm( 0, 0, 0, 30, 8 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 8,
	day	=> 30,
    ),
);
cmp_ok( $dts->day(), '==', 7, 'day() on 1999-08-30 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Hevensday', 'day_name() on 1999-08-30 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Hevenesdei', 'day_name_trad() on 1999-08-30 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 7, 'day_of_month() on 1999-08-30 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 5, 'day_of_week() on 1999-08-30 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 251, 'day_of_year() on 1999-08-30 Gregorian' );
cmp_ok( $dts->dow(), '==', 5, 'dow() on 1999-08-30 Gregorian' );
cmp_ok( $dts->doy(), '==', 251, 'doy() on 1999-08-30 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-08-30 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-08-30 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-08-30 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-08-30 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-08-30 Gregorian' );
cmp_ok( $dts->mday(), '==', 7, 'mday() on 1999-08-30 Gregorian' );
cmp_ok( $dts->month(), '==', 9, 'month() on 1999-08-30 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Halimath', 'month_name() on 1999-08-30 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-08-30 Gregorian' );
Hevensday 7 Halimath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63071654400, 'utc_rd_as_seconds() on 1999-08-30 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729996,
  0,
  0
]
, 'utc_rd_values() on 1999-08-30 Gregorian' );
cmp_ok( $dts->wday(), '==', 5, 'wday() on 1999-08-30 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  36
]
, 'week() on 1999-08-30 Gregorian' );
cmp_ok( $dts->week_number(), '==', 36, 'week_number() on 1999-08-30 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-08-30 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-08-30 Gregorian' );

$epoch = timegm( 0, 0, 0, 31, 8 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 8,
	day	=> 31,
    ),
);
cmp_ok( $dts->day(), '==', 8, 'day() on 1999-08-31 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Mersday', 'day_name() on 1999-08-31 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Meresdei', 'day_name_trad() on 1999-08-31 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 8, 'day_of_month() on 1999-08-31 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 6, 'day_of_week() on 1999-08-31 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 252, 'day_of_year() on 1999-08-31 Gregorian' );
cmp_ok( $dts->dow(), '==', 6, 'dow() on 1999-08-31 Gregorian' );
cmp_ok( $dts->doy(), '==', 252, 'doy() on 1999-08-31 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-08-31 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-08-31 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-08-31 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-08-31 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-08-31 Gregorian' );
cmp_ok( $dts->mday(), '==', 8, 'mday() on 1999-08-31 Gregorian' );
cmp_ok( $dts->month(), '==', 9, 'month() on 1999-08-31 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Halimath', 'month_name() on 1999-08-31 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-08-31 Gregorian' );
Mersday 8 Halimath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63071740800, 'utc_rd_as_seconds() on 1999-08-31 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729997,
  0,
  0
]
, 'utc_rd_values() on 1999-08-31 Gregorian' );
cmp_ok( $dts->wday(), '==', 6, 'wday() on 1999-08-31 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  36
]
, 'week() on 1999-08-31 Gregorian' );
cmp_ok( $dts->week_number(), '==', 36, 'week_number() on 1999-08-31 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-08-31 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-08-31 Gregorian' );

$epoch = timegm( 0, 0, 0, 1, 9 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 9,
	day	=> 1,
    ),
);
cmp_ok( $dts->day(), '==', 9, 'day() on 1999-09-01 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Highday', 'day_name() on 1999-09-01 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Highdei', 'day_name_trad() on 1999-09-01 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 9, 'day_of_month() on 1999-09-01 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 7, 'day_of_week() on 1999-09-01 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 253, 'day_of_year() on 1999-09-01 Gregorian' );
cmp_ok( $dts->dow(), '==', 7, 'dow() on 1999-09-01 Gregorian' );
cmp_ok( $dts->doy(), '==', 253, 'doy() on 1999-09-01 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-09-01 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-09-01 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-09-01 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-09-01 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-09-01 Gregorian' );
cmp_ok( $dts->mday(), '==', 9, 'mday() on 1999-09-01 Gregorian' );
cmp_ok( $dts->month(), '==', 9, 'month() on 1999-09-01 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Halimath', 'month_name() on 1999-09-01 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-09-01 Gregorian' );
Highday 9 Halimath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63071827200, 'utc_rd_as_seconds() on 1999-09-01 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729998,
  0,
  0
]
, 'utc_rd_values() on 1999-09-01 Gregorian' );
cmp_ok( $dts->wday(), '==', 7, 'wday() on 1999-09-01 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  36
]
, 'week() on 1999-09-01 Gregorian' );
cmp_ok( $dts->week_number(), '==', 36, 'week_number() on 1999-09-01 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-09-01 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-09-01 Gregorian' );

$epoch = timegm( 0, 0, 0, 2, 9 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 9,
	day	=> 2,
    ),
);
cmp_ok( $dts->day(), '==', 10, 'day() on 1999-09-02 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sterday', 'day_name() on 1999-09-02 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sterrendei', 'day_name_trad() on 1999-09-02 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 10, 'day_of_month() on 1999-09-02 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 1, 'day_of_week() on 1999-09-02 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 254, 'day_of_year() on 1999-09-02 Gregorian' );
cmp_ok( $dts->dow(), '==', 1, 'dow() on 1999-09-02 Gregorian' );
cmp_ok( $dts->doy(), '==', 254, 'doy() on 1999-09-02 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-09-02 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-09-02 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-09-02 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-09-02 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-09-02 Gregorian' );
cmp_ok( $dts->mday(), '==', 10, 'mday() on 1999-09-02 Gregorian' );
cmp_ok( $dts->month(), '==', 9, 'month() on 1999-09-02 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Halimath', 'month_name() on 1999-09-02 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-09-02 Gregorian' );
Sterday 10 Halimath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63071913600, 'utc_rd_as_seconds() on 1999-09-02 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  729999,
  0,
  0
]
, 'utc_rd_values() on 1999-09-02 Gregorian' );
cmp_ok( $dts->wday(), '==', 1, 'wday() on 1999-09-02 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  37
]
, 'week() on 1999-09-02 Gregorian' );
cmp_ok( $dts->week_number(), '==', 37, 'week_number() on 1999-09-02 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-09-02 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-09-02 Gregorian' );

$epoch = timegm( 0, 0, 0, 3, 9 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 9,
	day	=> 3,
    ),
);
cmp_ok( $dts->day(), '==', 11, 'day() on 1999-09-03 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sunday', 'day_name() on 1999-09-03 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sunnendei', 'day_name_trad() on 1999-09-03 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 11, 'day_of_month() on 1999-09-03 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 2, 'day_of_week() on 1999-09-03 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 255, 'day_of_year() on 1999-09-03 Gregorian' );
cmp_ok( $dts->dow(), '==', 2, 'dow() on 1999-09-03 Gregorian' );
cmp_ok( $dts->doy(), '==', 255, 'doy() on 1999-09-03 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-09-03 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-09-03 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-09-03 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-09-03 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-09-03 Gregorian' );
cmp_ok( $dts->mday(), '==', 11, 'mday() on 1999-09-03 Gregorian' );
cmp_ok( $dts->month(), '==', 9, 'month() on 1999-09-03 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Halimath', 'month_name() on 1999-09-03 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-09-03 Gregorian' );
Sunday 11 Halimath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63072000000, 'utc_rd_as_seconds() on 1999-09-03 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730000,
  0,
  0
]
, 'utc_rd_values() on 1999-09-03 Gregorian' );
cmp_ok( $dts->wday(), '==', 2, 'wday() on 1999-09-03 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  37
]
, 'week() on 1999-09-03 Gregorian' );
cmp_ok( $dts->week_number(), '==', 37, 'week_number() on 1999-09-03 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-09-03 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-09-03 Gregorian' );

$epoch = timegm( 0, 0, 0, 4, 9 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 9,
	day	=> 4,
    ),
);
cmp_ok( $dts->day(), '==', 12, 'day() on 1999-09-04 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Monday', 'day_name() on 1999-09-04 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Monendei', 'day_name_trad() on 1999-09-04 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 12, 'day_of_month() on 1999-09-04 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 3, 'day_of_week() on 1999-09-04 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 256, 'day_of_year() on 1999-09-04 Gregorian' );
cmp_ok( $dts->dow(), '==', 3, 'dow() on 1999-09-04 Gregorian' );
cmp_ok( $dts->doy(), '==', 256, 'doy() on 1999-09-04 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-09-04 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-09-04 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-09-04 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-09-04 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-09-04 Gregorian' );
cmp_ok( $dts->mday(), '==', 12, 'mday() on 1999-09-04 Gregorian' );
cmp_ok( $dts->month(), '==', 9, 'month() on 1999-09-04 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Halimath', 'month_name() on 1999-09-04 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-09-04 Gregorian' );
Monday 12 Halimath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63072086400, 'utc_rd_as_seconds() on 1999-09-04 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730001,
  0,
  0
]
, 'utc_rd_values() on 1999-09-04 Gregorian' );
cmp_ok( $dts->wday(), '==', 3, 'wday() on 1999-09-04 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  37
]
, 'week() on 1999-09-04 Gregorian' );
cmp_ok( $dts->week_number(), '==', 37, 'week_number() on 1999-09-04 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-09-04 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-09-04 Gregorian' );

$epoch = timegm( 0, 0, 0, 5, 9 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 9,
	day	=> 5,
    ),
);
cmp_ok( $dts->day(), '==', 13, 'day() on 1999-09-05 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Trewsday', 'day_name() on 1999-09-05 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Trewesdei', 'day_name_trad() on 1999-09-05 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 13, 'day_of_month() on 1999-09-05 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 4, 'day_of_week() on 1999-09-05 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 257, 'day_of_year() on 1999-09-05 Gregorian' );
cmp_ok( $dts->dow(), '==', 4, 'dow() on 1999-09-05 Gregorian' );
cmp_ok( $dts->doy(), '==', 257, 'doy() on 1999-09-05 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-09-05 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-09-05 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-09-05 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-09-05 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-09-05 Gregorian' );
cmp_ok( $dts->mday(), '==', 13, 'mday() on 1999-09-05 Gregorian' );
cmp_ok( $dts->month(), '==', 9, 'month() on 1999-09-05 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Halimath', 'month_name() on 1999-09-05 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-09-05 Gregorian' );
Trewsday 13 Halimath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63072172800, 'utc_rd_as_seconds() on 1999-09-05 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730002,
  0,
  0
]
, 'utc_rd_values() on 1999-09-05 Gregorian' );
cmp_ok( $dts->wday(), '==', 4, 'wday() on 1999-09-05 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  37
]
, 'week() on 1999-09-05 Gregorian' );
cmp_ok( $dts->week_number(), '==', 37, 'week_number() on 1999-09-05 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-09-05 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-09-05 Gregorian' );

$epoch = timegm( 0, 0, 0, 6, 9 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 9,
	day	=> 6,
    ),
);
cmp_ok( $dts->day(), '==', 14, 'day() on 1999-09-06 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Hevensday', 'day_name() on 1999-09-06 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Hevenesdei', 'day_name_trad() on 1999-09-06 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 14, 'day_of_month() on 1999-09-06 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 5, 'day_of_week() on 1999-09-06 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 258, 'day_of_year() on 1999-09-06 Gregorian' );
cmp_ok( $dts->dow(), '==', 5, 'dow() on 1999-09-06 Gregorian' );
cmp_ok( $dts->doy(), '==', 258, 'doy() on 1999-09-06 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-09-06 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-09-06 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-09-06 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-09-06 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-09-06 Gregorian' );
cmp_ok( $dts->mday(), '==', 14, 'mday() on 1999-09-06 Gregorian' );
cmp_ok( $dts->month(), '==', 9, 'month() on 1999-09-06 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Halimath', 'month_name() on 1999-09-06 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-09-06 Gregorian' );
Hevensday 14 Halimath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63072259200, 'utc_rd_as_seconds() on 1999-09-06 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730003,
  0,
  0
]
, 'utc_rd_values() on 1999-09-06 Gregorian' );
cmp_ok( $dts->wday(), '==', 5, 'wday() on 1999-09-06 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  37
]
, 'week() on 1999-09-06 Gregorian' );
cmp_ok( $dts->week_number(), '==', 37, 'week_number() on 1999-09-06 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-09-06 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-09-06 Gregorian' );

$epoch = timegm( 0, 0, 0, 7, 9 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 9,
	day	=> 7,
    ),
);
cmp_ok( $dts->day(), '==', 15, 'day() on 1999-09-07 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Mersday', 'day_name() on 1999-09-07 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Meresdei', 'day_name_trad() on 1999-09-07 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 15, 'day_of_month() on 1999-09-07 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 6, 'day_of_week() on 1999-09-07 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 259, 'day_of_year() on 1999-09-07 Gregorian' );
cmp_ok( $dts->dow(), '==', 6, 'dow() on 1999-09-07 Gregorian' );
cmp_ok( $dts->doy(), '==', 259, 'doy() on 1999-09-07 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-09-07 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-09-07 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-09-07 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-09-07 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-09-07 Gregorian' );
cmp_ok( $dts->mday(), '==', 15, 'mday() on 1999-09-07 Gregorian' );
cmp_ok( $dts->month(), '==', 9, 'month() on 1999-09-07 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Halimath', 'month_name() on 1999-09-07 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-09-07 Gregorian' );
Mersday 15 Halimath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63072345600, 'utc_rd_as_seconds() on 1999-09-07 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730004,
  0,
  0
]
, 'utc_rd_values() on 1999-09-07 Gregorian' );
cmp_ok( $dts->wday(), '==', 6, 'wday() on 1999-09-07 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  37
]
, 'week() on 1999-09-07 Gregorian' );
cmp_ok( $dts->week_number(), '==', 37, 'week_number() on 1999-09-07 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-09-07 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-09-07 Gregorian' );

$epoch = timegm( 0, 0, 0, 8, 9 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 9,
	day	=> 8,
    ),
);
cmp_ok( $dts->day(), '==', 16, 'day() on 1999-09-08 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Highday', 'day_name() on 1999-09-08 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Highdei', 'day_name_trad() on 1999-09-08 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 16, 'day_of_month() on 1999-09-08 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 7, 'day_of_week() on 1999-09-08 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 260, 'day_of_year() on 1999-09-08 Gregorian' );
cmp_ok( $dts->dow(), '==', 7, 'dow() on 1999-09-08 Gregorian' );
cmp_ok( $dts->doy(), '==', 260, 'doy() on 1999-09-08 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-09-08 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-09-08 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-09-08 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-09-08 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-09-08 Gregorian' );
cmp_ok( $dts->mday(), '==', 16, 'mday() on 1999-09-08 Gregorian' );
cmp_ok( $dts->month(), '==', 9, 'month() on 1999-09-08 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Halimath', 'month_name() on 1999-09-08 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-09-08 Gregorian' );
Highday 16 Halimath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63072432000, 'utc_rd_as_seconds() on 1999-09-08 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730005,
  0,
  0
]
, 'utc_rd_values() on 1999-09-08 Gregorian' );
cmp_ok( $dts->wday(), '==', 7, 'wday() on 1999-09-08 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  37
]
, 'week() on 1999-09-08 Gregorian' );
cmp_ok( $dts->week_number(), '==', 37, 'week_number() on 1999-09-08 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-09-08 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-09-08 Gregorian' );

$epoch = timegm( 0, 0, 0, 9, 9 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 9,
	day	=> 9,
    ),
);
cmp_ok( $dts->day(), '==', 17, 'day() on 1999-09-09 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sterday', 'day_name() on 1999-09-09 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sterrendei', 'day_name_trad() on 1999-09-09 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 17, 'day_of_month() on 1999-09-09 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 1, 'day_of_week() on 1999-09-09 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 261, 'day_of_year() on 1999-09-09 Gregorian' );
cmp_ok( $dts->dow(), '==', 1, 'dow() on 1999-09-09 Gregorian' );
cmp_ok( $dts->doy(), '==', 261, 'doy() on 1999-09-09 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-09-09 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-09-09 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-09-09 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-09-09 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-09-09 Gregorian' );
cmp_ok( $dts->mday(), '==', 17, 'mday() on 1999-09-09 Gregorian' );
cmp_ok( $dts->month(), '==', 9, 'month() on 1999-09-09 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Halimath', 'month_name() on 1999-09-09 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-09-09 Gregorian' );
Sterday 17 Halimath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63072518400, 'utc_rd_as_seconds() on 1999-09-09 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730006,
  0,
  0
]
, 'utc_rd_values() on 1999-09-09 Gregorian' );
cmp_ok( $dts->wday(), '==', 1, 'wday() on 1999-09-09 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  38
]
, 'week() on 1999-09-09 Gregorian' );
cmp_ok( $dts->week_number(), '==', 38, 'week_number() on 1999-09-09 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-09-09 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-09-09 Gregorian' );

$epoch = timegm( 0, 0, 0, 10, 9 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 9,
	day	=> 10,
    ),
);
cmp_ok( $dts->day(), '==', 18, 'day() on 1999-09-10 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sunday', 'day_name() on 1999-09-10 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sunnendei', 'day_name_trad() on 1999-09-10 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 18, 'day_of_month() on 1999-09-10 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 2, 'day_of_week() on 1999-09-10 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 262, 'day_of_year() on 1999-09-10 Gregorian' );
cmp_ok( $dts->dow(), '==', 2, 'dow() on 1999-09-10 Gregorian' );
cmp_ok( $dts->doy(), '==', 262, 'doy() on 1999-09-10 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-09-10 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-09-10 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-09-10 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-09-10 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-09-10 Gregorian' );
cmp_ok( $dts->mday(), '==', 18, 'mday() on 1999-09-10 Gregorian' );
cmp_ok( $dts->month(), '==', 9, 'month() on 1999-09-10 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Halimath', 'month_name() on 1999-09-10 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-09-10 Gregorian' );
Sunday 18 Halimath 7463

Gandalf escapes from Orthanc in the early hours, 1418.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63072604800, 'utc_rd_as_seconds() on 1999-09-10 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730007,
  0,
  0
]
, 'utc_rd_values() on 1999-09-10 Gregorian' );
cmp_ok( $dts->wday(), '==', 2, 'wday() on 1999-09-10 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  38
]
, 'week() on 1999-09-10 Gregorian' );
cmp_ok( $dts->week_number(), '==', 38, 'week_number() on 1999-09-10 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-09-10 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-09-10 Gregorian' );

$epoch = timegm( 0, 0, 0, 11, 9 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 9,
	day	=> 11,
    ),
);
cmp_ok( $dts->day(), '==', 19, 'day() on 1999-09-11 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Monday', 'day_name() on 1999-09-11 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Monendei', 'day_name_trad() on 1999-09-11 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 19, 'day_of_month() on 1999-09-11 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 3, 'day_of_week() on 1999-09-11 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 263, 'day_of_year() on 1999-09-11 Gregorian' );
cmp_ok( $dts->dow(), '==', 3, 'dow() on 1999-09-11 Gregorian' );
cmp_ok( $dts->doy(), '==', 263, 'doy() on 1999-09-11 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-09-11 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-09-11 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-09-11 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-09-11 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-09-11 Gregorian' );
cmp_ok( $dts->mday(), '==', 19, 'mday() on 1999-09-11 Gregorian' );
cmp_ok( $dts->month(), '==', 9, 'month() on 1999-09-11 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Halimath', 'month_name() on 1999-09-11 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-09-11 Gregorian' );
Monday 19 Halimath 7463

Gandalf comes to Edoras as a beggar, and is refused admittance, 1418
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63072691200, 'utc_rd_as_seconds() on 1999-09-11 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730008,
  0,
  0
]
, 'utc_rd_values() on 1999-09-11 Gregorian' );
cmp_ok( $dts->wday(), '==', 3, 'wday() on 1999-09-11 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  38
]
, 'week() on 1999-09-11 Gregorian' );
cmp_ok( $dts->week_number(), '==', 38, 'week_number() on 1999-09-11 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-09-11 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-09-11 Gregorian' );

$epoch = timegm( 0, 0, 0, 12, 9 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 9,
	day	=> 12,
    ),
);
cmp_ok( $dts->day(), '==', 20, 'day() on 1999-09-12 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Trewsday', 'day_name() on 1999-09-12 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Trewesdei', 'day_name_trad() on 1999-09-12 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 20, 'day_of_month() on 1999-09-12 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 4, 'day_of_week() on 1999-09-12 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 264, 'day_of_year() on 1999-09-12 Gregorian' );
cmp_ok( $dts->dow(), '==', 4, 'dow() on 1999-09-12 Gregorian' );
cmp_ok( $dts->doy(), '==', 264, 'doy() on 1999-09-12 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-09-12 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-09-12 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-09-12 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-09-12 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-09-12 Gregorian' );
cmp_ok( $dts->mday(), '==', 20, 'mday() on 1999-09-12 Gregorian' );
cmp_ok( $dts->month(), '==', 9, 'month() on 1999-09-12 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Halimath', 'month_name() on 1999-09-12 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-09-12 Gregorian' );
Trewsday 20 Halimath 7463

Gandalf gains entrance to Edoras.  Theoden commands him to go:
"Take any horse, only be gone ere tomorrow is old", 1418.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63072777600, 'utc_rd_as_seconds() on 1999-09-12 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730009,
  0,
  0
]
, 'utc_rd_values() on 1999-09-12 Gregorian' );
cmp_ok( $dts->wday(), '==', 4, 'wday() on 1999-09-12 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  38
]
, 'week() on 1999-09-12 Gregorian' );
cmp_ok( $dts->week_number(), '==', 38, 'week_number() on 1999-09-12 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-09-12 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-09-12 Gregorian' );

$epoch = timegm( 0, 0, 0, 13, 9 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 9,
	day	=> 13,
    ),
);
cmp_ok( $dts->day(), '==', 21, 'day() on 1999-09-13 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Hevensday', 'day_name() on 1999-09-13 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Hevenesdei', 'day_name_trad() on 1999-09-13 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 21, 'day_of_month() on 1999-09-13 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 5, 'day_of_week() on 1999-09-13 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 265, 'day_of_year() on 1999-09-13 Gregorian' );
cmp_ok( $dts->dow(), '==', 5, 'dow() on 1999-09-13 Gregorian' );
cmp_ok( $dts->doy(), '==', 265, 'doy() on 1999-09-13 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-09-13 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-09-13 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-09-13 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-09-13 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-09-13 Gregorian' );
cmp_ok( $dts->mday(), '==', 21, 'mday() on 1999-09-13 Gregorian' );
cmp_ok( $dts->month(), '==', 9, 'month() on 1999-09-13 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Halimath', 'month_name() on 1999-09-13 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-09-13 Gregorian' );
Hevensday 21 Halimath 7463

The hobbits return to Rivendell, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63072864000, 'utc_rd_as_seconds() on 1999-09-13 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730010,
  0,
  0
]
, 'utc_rd_values() on 1999-09-13 Gregorian' );
cmp_ok( $dts->wday(), '==', 5, 'wday() on 1999-09-13 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  38
]
, 'week() on 1999-09-13 Gregorian' );
cmp_ok( $dts->week_number(), '==', 38, 'week_number() on 1999-09-13 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-09-13 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-09-13 Gregorian' );

$epoch = timegm( 0, 0, 0, 14, 9 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 9,
	day	=> 14,
    ),
);
cmp_ok( $dts->day(), '==', 22, 'day() on 1999-09-14 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Mersday', 'day_name() on 1999-09-14 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Meresdei', 'day_name_trad() on 1999-09-14 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 22, 'day_of_month() on 1999-09-14 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 6, 'day_of_week() on 1999-09-14 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 266, 'day_of_year() on 1999-09-14 Gregorian' );
cmp_ok( $dts->dow(), '==', 6, 'dow() on 1999-09-14 Gregorian' );
cmp_ok( $dts->doy(), '==', 266, 'doy() on 1999-09-14 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-09-14 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-09-14 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-09-14 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-09-14 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-09-14 Gregorian' );
cmp_ok( $dts->mday(), '==', 22, 'mday() on 1999-09-14 Gregorian' );
cmp_ok( $dts->month(), '==', 9, 'month() on 1999-09-14 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Halimath', 'month_name() on 1999-09-14 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-09-14 Gregorian' );
Mersday 22 Halimath 7463

Birthday of Bilbo and Frodo.
The Black Riders reach Sarn Ford at evening;
  they drive off the guard of Rangers, 1418.
Saruman comes to the Shire, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63072950400, 'utc_rd_as_seconds() on 1999-09-14 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730011,
  0,
  0
]
, 'utc_rd_values() on 1999-09-14 Gregorian' );
cmp_ok( $dts->wday(), '==', 6, 'wday() on 1999-09-14 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  38
]
, 'week() on 1999-09-14 Gregorian' );
cmp_ok( $dts->week_number(), '==', 38, 'week_number() on 1999-09-14 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-09-14 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-09-14 Gregorian' );

$epoch = timegm( 0, 0, 0, 15, 9 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 9,
	day	=> 15,
    ),
);
cmp_ok( $dts->day(), '==', 23, 'day() on 1999-09-15 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Highday', 'day_name() on 1999-09-15 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Highdei', 'day_name_trad() on 1999-09-15 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 23, 'day_of_month() on 1999-09-15 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 7, 'day_of_week() on 1999-09-15 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 267, 'day_of_year() on 1999-09-15 Gregorian' );
cmp_ok( $dts->dow(), '==', 7, 'dow() on 1999-09-15 Gregorian' );
cmp_ok( $dts->doy(), '==', 267, 'doy() on 1999-09-15 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-09-15 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-09-15 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-09-15 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-09-15 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-09-15 Gregorian' );
cmp_ok( $dts->mday(), '==', 23, 'mday() on 1999-09-15 Gregorian' );
cmp_ok( $dts->month(), '==', 9, 'month() on 1999-09-15 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Halimath', 'month_name() on 1999-09-15 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-09-15 Gregorian' );
Highday 23 Halimath 7463

Four Black Riders enter the shire before dawn.  The others pursue 
the Rangers eastward and then return to watch the Greenway, 1418.
A Black Rider comes to Hobbiton at nightfall, 1418.
Frodo leaves Bag End, 1418.
Gandalf having tamed Shadowfax rides from Rohan, 1418.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63073036800, 'utc_rd_as_seconds() on 1999-09-15 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730012,
  0,
  0
]
, 'utc_rd_values() on 1999-09-15 Gregorian' );
cmp_ok( $dts->wday(), '==', 7, 'wday() on 1999-09-15 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  38
]
, 'week() on 1999-09-15 Gregorian' );
cmp_ok( $dts->week_number(), '==', 38, 'week_number() on 1999-09-15 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-09-15 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-09-15 Gregorian' );

$epoch = timegm( 0, 0, 0, 16, 9 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 9,
	day	=> 16,
    ),
);
cmp_ok( $dts->day(), '==', 24, 'day() on 1999-09-16 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sterday', 'day_name() on 1999-09-16 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sterrendei', 'day_name_trad() on 1999-09-16 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 24, 'day_of_month() on 1999-09-16 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 1, 'day_of_week() on 1999-09-16 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 268, 'day_of_year() on 1999-09-16 Gregorian' );
cmp_ok( $dts->dow(), '==', 1, 'dow() on 1999-09-16 Gregorian' );
cmp_ok( $dts->doy(), '==', 268, 'doy() on 1999-09-16 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-09-16 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-09-16 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-09-16 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-09-16 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-09-16 Gregorian' );
cmp_ok( $dts->mday(), '==', 24, 'mday() on 1999-09-16 Gregorian' );
cmp_ok( $dts->month(), '==', 9, 'month() on 1999-09-16 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Halimath', 'month_name() on 1999-09-16 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-09-16 Gregorian' );
Sterday 24 Halimath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63073123200, 'utc_rd_as_seconds() on 1999-09-16 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730013,
  0,
  0
]
, 'utc_rd_values() on 1999-09-16 Gregorian' );
cmp_ok( $dts->wday(), '==', 1, 'wday() on 1999-09-16 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  39
]
, 'week() on 1999-09-16 Gregorian' );
cmp_ok( $dts->week_number(), '==', 39, 'week_number() on 1999-09-16 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-09-16 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-09-16 Gregorian' );

$epoch = timegm( 0, 0, 0, 17, 9 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 9,
	day	=> 17,
    ),
);
cmp_ok( $dts->day(), '==', 25, 'day() on 1999-09-17 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sunday', 'day_name() on 1999-09-17 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sunnendei', 'day_name_trad() on 1999-09-17 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 25, 'day_of_month() on 1999-09-17 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 2, 'day_of_week() on 1999-09-17 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 269, 'day_of_year() on 1999-09-17 Gregorian' );
cmp_ok( $dts->dow(), '==', 2, 'dow() on 1999-09-17 Gregorian' );
cmp_ok( $dts->doy(), '==', 269, 'doy() on 1999-09-17 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-09-17 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-09-17 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-09-17 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-09-17 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-09-17 Gregorian' );
cmp_ok( $dts->mday(), '==', 25, 'mday() on 1999-09-17 Gregorian' );
cmp_ok( $dts->month(), '==', 9, 'month() on 1999-09-17 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Halimath', 'month_name() on 1999-09-17 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-09-17 Gregorian' );
Sunday 25 Halimath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63073209600, 'utc_rd_as_seconds() on 1999-09-17 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730014,
  0,
  0
]
, 'utc_rd_values() on 1999-09-17 Gregorian' );
cmp_ok( $dts->wday(), '==', 2, 'wday() on 1999-09-17 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  39
]
, 'week() on 1999-09-17 Gregorian' );
cmp_ok( $dts->week_number(), '==', 39, 'week_number() on 1999-09-17 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-09-17 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-09-17 Gregorian' );

$epoch = timegm( 0, 0, 0, 18, 9 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 9,
	day	=> 18,
    ),
);
cmp_ok( $dts->day(), '==', 26, 'day() on 1999-09-18 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Monday', 'day_name() on 1999-09-18 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Monendei', 'day_name_trad() on 1999-09-18 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 26, 'day_of_month() on 1999-09-18 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 3, 'day_of_week() on 1999-09-18 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 270, 'day_of_year() on 1999-09-18 Gregorian' );
cmp_ok( $dts->dow(), '==', 3, 'dow() on 1999-09-18 Gregorian' );
cmp_ok( $dts->doy(), '==', 270, 'doy() on 1999-09-18 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-09-18 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-09-18 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-09-18 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-09-18 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-09-18 Gregorian' );
cmp_ok( $dts->mday(), '==', 26, 'mday() on 1999-09-18 Gregorian' );
cmp_ok( $dts->month(), '==', 9, 'month() on 1999-09-18 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Halimath', 'month_name() on 1999-09-18 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-09-18 Gregorian' );
Monday 26 Halimath 7463

Frodo comes to Bombadil, 1418
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63073296000, 'utc_rd_as_seconds() on 1999-09-18 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730015,
  0,
  0
]
, 'utc_rd_values() on 1999-09-18 Gregorian' );
cmp_ok( $dts->wday(), '==', 3, 'wday() on 1999-09-18 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  39
]
, 'week() on 1999-09-18 Gregorian' );
cmp_ok( $dts->week_number(), '==', 39, 'week_number() on 1999-09-18 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-09-18 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-09-18 Gregorian' );

$epoch = timegm( 0, 0, 0, 19, 9 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 9,
	day	=> 19,
    ),
);
cmp_ok( $dts->day(), '==', 27, 'day() on 1999-09-19 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Trewsday', 'day_name() on 1999-09-19 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Trewesdei', 'day_name_trad() on 1999-09-19 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 27, 'day_of_month() on 1999-09-19 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 4, 'day_of_week() on 1999-09-19 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 271, 'day_of_year() on 1999-09-19 Gregorian' );
cmp_ok( $dts->dow(), '==', 4, 'dow() on 1999-09-19 Gregorian' );
cmp_ok( $dts->doy(), '==', 271, 'doy() on 1999-09-19 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-09-19 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-09-19 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-09-19 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-09-19 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-09-19 Gregorian' );
cmp_ok( $dts->mday(), '==', 27, 'mday() on 1999-09-19 Gregorian' );
cmp_ok( $dts->month(), '==', 9, 'month() on 1999-09-19 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Halimath', 'month_name() on 1999-09-19 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-09-19 Gregorian' );
Trewsday 27 Halimath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63073382400, 'utc_rd_as_seconds() on 1999-09-19 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730016,
  0,
  0
]
, 'utc_rd_values() on 1999-09-19 Gregorian' );
cmp_ok( $dts->wday(), '==', 4, 'wday() on 1999-09-19 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  39
]
, 'week() on 1999-09-19 Gregorian' );
cmp_ok( $dts->week_number(), '==', 39, 'week_number() on 1999-09-19 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-09-19 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-09-19 Gregorian' );

$epoch = timegm( 0, 0, 0, 20, 9 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 9,
	day	=> 20,
    ),
);
cmp_ok( $dts->day(), '==', 28, 'day() on 1999-09-20 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Hevensday', 'day_name() on 1999-09-20 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Hevenesdei', 'day_name_trad() on 1999-09-20 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 28, 'day_of_month() on 1999-09-20 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 5, 'day_of_week() on 1999-09-20 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 272, 'day_of_year() on 1999-09-20 Gregorian' );
cmp_ok( $dts->dow(), '==', 5, 'dow() on 1999-09-20 Gregorian' );
cmp_ok( $dts->doy(), '==', 272, 'doy() on 1999-09-20 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-09-20 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-09-20 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-09-20 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-09-20 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-09-20 Gregorian' );
cmp_ok( $dts->mday(), '==', 28, 'mday() on 1999-09-20 Gregorian' );
cmp_ok( $dts->month(), '==', 9, 'month() on 1999-09-20 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Halimath', 'month_name() on 1999-09-20 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-09-20 Gregorian' );
Hevensday 28 Halimath 7463

The Hobbits are captured by a barrow-wight, 1418.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63073468800, 'utc_rd_as_seconds() on 1999-09-20 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730017,
  0,
  0
]
, 'utc_rd_values() on 1999-09-20 Gregorian' );
cmp_ok( $dts->wday(), '==', 5, 'wday() on 1999-09-20 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  39
]
, 'week() on 1999-09-20 Gregorian' );
cmp_ok( $dts->week_number(), '==', 39, 'week_number() on 1999-09-20 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-09-20 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-09-20 Gregorian' );

$epoch = timegm( 0, 0, 0, 21, 9 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 9,
	day	=> 21,
    ),
);
cmp_ok( $dts->day(), '==', 29, 'day() on 1999-09-21 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Mersday', 'day_name() on 1999-09-21 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Meresdei', 'day_name_trad() on 1999-09-21 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 29, 'day_of_month() on 1999-09-21 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 6, 'day_of_week() on 1999-09-21 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 273, 'day_of_year() on 1999-09-21 Gregorian' );
cmp_ok( $dts->dow(), '==', 6, 'dow() on 1999-09-21 Gregorian' );
cmp_ok( $dts->doy(), '==', 273, 'doy() on 1999-09-21 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-09-21 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-09-21 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-09-21 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-09-21 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-09-21 Gregorian' );
cmp_ok( $dts->mday(), '==', 29, 'mday() on 1999-09-21 Gregorian' );
cmp_ok( $dts->month(), '==', 9, 'month() on 1999-09-21 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Halimath', 'month_name() on 1999-09-21 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-09-21 Gregorian' );
Mersday 29 Halimath 7463

Frodo reaches Bree at night, 1418.
Frodo and Bilbo depart over the sea with the three Keepers, 1421.
End of the Third Age, 1421.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63073555200, 'utc_rd_as_seconds() on 1999-09-21 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730018,
  0,
  0
]
, 'utc_rd_values() on 1999-09-21 Gregorian' );
cmp_ok( $dts->wday(), '==', 6, 'wday() on 1999-09-21 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  39
]
, 'week() on 1999-09-21 Gregorian' );
cmp_ok( $dts->week_number(), '==', 39, 'week_number() on 1999-09-21 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-09-21 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-09-21 Gregorian' );

$epoch = timegm( 0, 0, 0, 22, 9 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 9,
	day	=> 22,
    ),
);
cmp_ok( $dts->day(), '==', 30, 'day() on 1999-09-22 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Highday', 'day_name() on 1999-09-22 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Highdei', 'day_name_trad() on 1999-09-22 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 30, 'day_of_month() on 1999-09-22 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 7, 'day_of_week() on 1999-09-22 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 274, 'day_of_year() on 1999-09-22 Gregorian' );
cmp_ok( $dts->dow(), '==', 7, 'dow() on 1999-09-22 Gregorian' );
cmp_ok( $dts->doy(), '==', 274, 'doy() on 1999-09-22 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-09-22 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-09-22 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-09-22 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-09-22 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-09-22 Gregorian' );
cmp_ok( $dts->mday(), '==', 30, 'mday() on 1999-09-22 Gregorian' );
cmp_ok( $dts->month(), '==', 9, 'month() on 1999-09-22 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Halimath', 'month_name() on 1999-09-22 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-09-22 Gregorian' );
Highday 30 Halimath 7463

Crickhollow and the inn at Bree are raided in the early hours, 1418.
Frodo leaves Bree, 1418.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63073641600, 'utc_rd_as_seconds() on 1999-09-22 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730019,
  0,
  0
]
, 'utc_rd_values() on 1999-09-22 Gregorian' );
cmp_ok( $dts->wday(), '==', 7, 'wday() on 1999-09-22 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  39
]
, 'week() on 1999-09-22 Gregorian' );
cmp_ok( $dts->week_number(), '==', 39, 'week_number() on 1999-09-22 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-09-22 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-09-22 Gregorian' );

$epoch = timegm( 0, 0, 0, 23, 9 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 9,
	day	=> 23,
    ),
);
cmp_ok( $dts->day(), '==', 1, 'day() on 1999-09-23 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sterday', 'day_name() on 1999-09-23 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sterrendei', 'day_name_trad() on 1999-09-23 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 1, 'day_of_month() on 1999-09-23 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 1, 'day_of_week() on 1999-09-23 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 275, 'day_of_year() on 1999-09-23 Gregorian' );
cmp_ok( $dts->dow(), '==', 1, 'dow() on 1999-09-23 Gregorian' );
cmp_ok( $dts->doy(), '==', 275, 'doy() on 1999-09-23 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-09-23 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-09-23 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-09-23 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-09-23 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-09-23 Gregorian' );
cmp_ok( $dts->mday(), '==', 1, 'mday() on 1999-09-23 Gregorian' );
cmp_ok( $dts->month(), '==', 10, 'month() on 1999-09-23 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Winterfilth', 'month_name() on 1999-09-23 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-09-23 Gregorian' );
Sterday 1 Winterfilth 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63073728000, 'utc_rd_as_seconds() on 1999-09-23 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730020,
  0,
  0
]
, 'utc_rd_values() on 1999-09-23 Gregorian' );
cmp_ok( $dts->wday(), '==', 1, 'wday() on 1999-09-23 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  40
]
, 'week() on 1999-09-23 Gregorian' );
cmp_ok( $dts->week_number(), '==', 40, 'week_number() on 1999-09-23 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-09-23 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-09-23 Gregorian' );

$epoch = timegm( 0, 0, 0, 24, 9 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 9,
	day	=> 24,
    ),
);
cmp_ok( $dts->day(), '==', 2, 'day() on 1999-09-24 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sunday', 'day_name() on 1999-09-24 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sunnendei', 'day_name_trad() on 1999-09-24 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 2, 'day_of_month() on 1999-09-24 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 2, 'day_of_week() on 1999-09-24 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 276, 'day_of_year() on 1999-09-24 Gregorian' );
cmp_ok( $dts->dow(), '==', 2, 'dow() on 1999-09-24 Gregorian' );
cmp_ok( $dts->doy(), '==', 276, 'doy() on 1999-09-24 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-09-24 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-09-24 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-09-24 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-09-24 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-09-24 Gregorian' );
cmp_ok( $dts->mday(), '==', 2, 'mday() on 1999-09-24 Gregorian' );
cmp_ok( $dts->month(), '==', 10, 'month() on 1999-09-24 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Winterfilth', 'month_name() on 1999-09-24 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-09-24 Gregorian' );
Sunday 2 Winterfilth 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63073814400, 'utc_rd_as_seconds() on 1999-09-24 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730021,
  0,
  0
]
, 'utc_rd_values() on 1999-09-24 Gregorian' );
cmp_ok( $dts->wday(), '==', 2, 'wday() on 1999-09-24 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  40
]
, 'week() on 1999-09-24 Gregorian' );
cmp_ok( $dts->week_number(), '==', 40, 'week_number() on 1999-09-24 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-09-24 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-09-24 Gregorian' );

$epoch = timegm( 0, 0, 0, 25, 9 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 9,
	day	=> 25,
    ),
);
cmp_ok( $dts->day(), '==', 3, 'day() on 1999-09-25 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Monday', 'day_name() on 1999-09-25 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Monendei', 'day_name_trad() on 1999-09-25 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 3, 'day_of_month() on 1999-09-25 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 3, 'day_of_week() on 1999-09-25 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 277, 'day_of_year() on 1999-09-25 Gregorian' );
cmp_ok( $dts->dow(), '==', 3, 'dow() on 1999-09-25 Gregorian' );
cmp_ok( $dts->doy(), '==', 277, 'doy() on 1999-09-25 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-09-25 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-09-25 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-09-25 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-09-25 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-09-25 Gregorian' );
cmp_ok( $dts->mday(), '==', 3, 'mday() on 1999-09-25 Gregorian' );
cmp_ok( $dts->month(), '==', 10, 'month() on 1999-09-25 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Winterfilth', 'month_name() on 1999-09-25 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-09-25 Gregorian' );
Monday 3 Winterfilth 7463

Gandalf attacked at night on Weathertop, 1418.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63073900800, 'utc_rd_as_seconds() on 1999-09-25 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730022,
  0,
  0
]
, 'utc_rd_values() on 1999-09-25 Gregorian' );
cmp_ok( $dts->wday(), '==', 3, 'wday() on 1999-09-25 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  40
]
, 'week() on 1999-09-25 Gregorian' );
cmp_ok( $dts->week_number(), '==', 40, 'week_number() on 1999-09-25 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-09-25 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-09-25 Gregorian' );

$epoch = timegm( 0, 0, 0, 26, 9 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 9,
	day	=> 26,
    ),
);
cmp_ok( $dts->day(), '==', 4, 'day() on 1999-09-26 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Trewsday', 'day_name() on 1999-09-26 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Trewesdei', 'day_name_trad() on 1999-09-26 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 4, 'day_of_month() on 1999-09-26 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 4, 'day_of_week() on 1999-09-26 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 278, 'day_of_year() on 1999-09-26 Gregorian' );
cmp_ok( $dts->dow(), '==', 4, 'dow() on 1999-09-26 Gregorian' );
cmp_ok( $dts->doy(), '==', 278, 'doy() on 1999-09-26 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-09-26 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-09-26 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-09-26 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-09-26 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-09-26 Gregorian' );
cmp_ok( $dts->mday(), '==', 4, 'mday() on 1999-09-26 Gregorian' );
cmp_ok( $dts->month(), '==', 10, 'month() on 1999-09-26 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Winterfilth', 'month_name() on 1999-09-26 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-09-26 Gregorian' );
Trewsday 4 Winterfilth 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63073987200, 'utc_rd_as_seconds() on 1999-09-26 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730023,
  0,
  0
]
, 'utc_rd_values() on 1999-09-26 Gregorian' );
cmp_ok( $dts->wday(), '==', 4, 'wday() on 1999-09-26 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  40
]
, 'week() on 1999-09-26 Gregorian' );
cmp_ok( $dts->week_number(), '==', 40, 'week_number() on 1999-09-26 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-09-26 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-09-26 Gregorian' );

$epoch = timegm( 0, 0, 0, 27, 9 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 9,
	day	=> 27,
    ),
);
cmp_ok( $dts->day(), '==', 5, 'day() on 1999-09-27 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Hevensday', 'day_name() on 1999-09-27 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Hevenesdei', 'day_name_trad() on 1999-09-27 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 5, 'day_of_month() on 1999-09-27 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 5, 'day_of_week() on 1999-09-27 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 279, 'day_of_year() on 1999-09-27 Gregorian' );
cmp_ok( $dts->dow(), '==', 5, 'dow() on 1999-09-27 Gregorian' );
cmp_ok( $dts->doy(), '==', 279, 'doy() on 1999-09-27 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-09-27 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-09-27 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-09-27 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-09-27 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-09-27 Gregorian' );
cmp_ok( $dts->mday(), '==', 5, 'mday() on 1999-09-27 Gregorian' );
cmp_ok( $dts->month(), '==', 10, 'month() on 1999-09-27 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Winterfilth', 'month_name() on 1999-09-27 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-09-27 Gregorian' );
Hevensday 5 Winterfilth 7463

Gandalf and the Hobbits leave Rivendell, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63074073600, 'utc_rd_as_seconds() on 1999-09-27 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730024,
  0,
  0
]
, 'utc_rd_values() on 1999-09-27 Gregorian' );
cmp_ok( $dts->wday(), '==', 5, 'wday() on 1999-09-27 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  40
]
, 'week() on 1999-09-27 Gregorian' );
cmp_ok( $dts->week_number(), '==', 40, 'week_number() on 1999-09-27 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-09-27 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-09-27 Gregorian' );

$epoch = timegm( 0, 0, 0, 28, 9 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 9,
	day	=> 28,
    ),
);
cmp_ok( $dts->day(), '==', 6, 'day() on 1999-09-28 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Mersday', 'day_name() on 1999-09-28 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Meresdei', 'day_name_trad() on 1999-09-28 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 6, 'day_of_month() on 1999-09-28 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 6, 'day_of_week() on 1999-09-28 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 280, 'day_of_year() on 1999-09-28 Gregorian' );
cmp_ok( $dts->dow(), '==', 6, 'dow() on 1999-09-28 Gregorian' );
cmp_ok( $dts->doy(), '==', 280, 'doy() on 1999-09-28 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-09-28 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-09-28 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-09-28 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-09-28 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-09-28 Gregorian' );
cmp_ok( $dts->mday(), '==', 6, 'mday() on 1999-09-28 Gregorian' );
cmp_ok( $dts->month(), '==', 10, 'month() on 1999-09-28 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Winterfilth', 'month_name() on 1999-09-28 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-09-28 Gregorian' );
Mersday 6 Winterfilth 7463

The camp under Weathertop is attacked at night and Frodo is wounded, 1418.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63074160000, 'utc_rd_as_seconds() on 1999-09-28 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730025,
  0,
  0
]
, 'utc_rd_values() on 1999-09-28 Gregorian' );
cmp_ok( $dts->wday(), '==', 6, 'wday() on 1999-09-28 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  40
]
, 'week() on 1999-09-28 Gregorian' );
cmp_ok( $dts->week_number(), '==', 40, 'week_number() on 1999-09-28 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-09-28 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-09-28 Gregorian' );

$epoch = timegm( 0, 0, 0, 29, 9 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 9,
	day	=> 29,
    ),
);
cmp_ok( $dts->day(), '==', 7, 'day() on 1999-09-29 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Highday', 'day_name() on 1999-09-29 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Highdei', 'day_name_trad() on 1999-09-29 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 7, 'day_of_month() on 1999-09-29 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 7, 'day_of_week() on 1999-09-29 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 281, 'day_of_year() on 1999-09-29 Gregorian' );
cmp_ok( $dts->dow(), '==', 7, 'dow() on 1999-09-29 Gregorian' );
cmp_ok( $dts->doy(), '==', 281, 'doy() on 1999-09-29 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-09-29 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-09-29 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-09-29 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-09-29 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-09-29 Gregorian' );
cmp_ok( $dts->mday(), '==', 7, 'mday() on 1999-09-29 Gregorian' );
cmp_ok( $dts->month(), '==', 10, 'month() on 1999-09-29 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Winterfilth', 'month_name() on 1999-09-29 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-09-29 Gregorian' );
Highday 7 Winterfilth 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63074246400, 'utc_rd_as_seconds() on 1999-09-29 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730026,
  0,
  0
]
, 'utc_rd_values() on 1999-09-29 Gregorian' );
cmp_ok( $dts->wday(), '==', 7, 'wday() on 1999-09-29 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  40
]
, 'week() on 1999-09-29 Gregorian' );
cmp_ok( $dts->week_number(), '==', 40, 'week_number() on 1999-09-29 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-09-29 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-09-29 Gregorian' );

$epoch = timegm( 0, 0, 0, 30, 9 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 9,
	day	=> 30,
    ),
);
cmp_ok( $dts->day(), '==', 8, 'day() on 1999-09-30 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sterday', 'day_name() on 1999-09-30 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sterrendei', 'day_name_trad() on 1999-09-30 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 8, 'day_of_month() on 1999-09-30 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 1, 'day_of_week() on 1999-09-30 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 282, 'day_of_year() on 1999-09-30 Gregorian' );
cmp_ok( $dts->dow(), '==', 1, 'dow() on 1999-09-30 Gregorian' );
cmp_ok( $dts->doy(), '==', 282, 'doy() on 1999-09-30 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-09-30 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-09-30 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-09-30 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-09-30 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-09-30 Gregorian' );
cmp_ok( $dts->mday(), '==', 8, 'mday() on 1999-09-30 Gregorian' );
cmp_ok( $dts->month(), '==', 10, 'month() on 1999-09-30 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Winterfilth', 'month_name() on 1999-09-30 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-09-30 Gregorian' );
Sterday 8 Winterfilth 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63074332800, 'utc_rd_as_seconds() on 1999-09-30 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730027,
  0,
  0
]
, 'utc_rd_values() on 1999-09-30 Gregorian' );
cmp_ok( $dts->wday(), '==', 1, 'wday() on 1999-09-30 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  41
]
, 'week() on 1999-09-30 Gregorian' );
cmp_ok( $dts->week_number(), '==', 41, 'week_number() on 1999-09-30 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-09-30 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-09-30 Gregorian' );

$epoch = timegm( 0, 0, 0, 1, 10 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 10,
	day	=> 1,
    ),
);
cmp_ok( $dts->day(), '==', 9, 'day() on 1999-10-01 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sunday', 'day_name() on 1999-10-01 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sunnendei', 'day_name_trad() on 1999-10-01 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 9, 'day_of_month() on 1999-10-01 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 2, 'day_of_week() on 1999-10-01 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 283, 'day_of_year() on 1999-10-01 Gregorian' );
cmp_ok( $dts->dow(), '==', 2, 'dow() on 1999-10-01 Gregorian' );
cmp_ok( $dts->doy(), '==', 283, 'doy() on 1999-10-01 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-10-01 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-10-01 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-10-01 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-10-01 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-10-01 Gregorian' );
cmp_ok( $dts->mday(), '==', 9, 'mday() on 1999-10-01 Gregorian' );
cmp_ok( $dts->month(), '==', 10, 'month() on 1999-10-01 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Winterfilth', 'month_name() on 1999-10-01 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-10-01 Gregorian' );
Sunday 9 Winterfilth 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63074419200, 'utc_rd_as_seconds() on 1999-10-01 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730028,
  0,
  0
]
, 'utc_rd_values() on 1999-10-01 Gregorian' );
cmp_ok( $dts->wday(), '==', 2, 'wday() on 1999-10-01 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  41
]
, 'week() on 1999-10-01 Gregorian' );
cmp_ok( $dts->week_number(), '==', 41, 'week_number() on 1999-10-01 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-10-01 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-10-01 Gregorian' );

$epoch = timegm( 0, 0, 0, 2, 10 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 10,
	day	=> 2,
    ),
);
cmp_ok( $dts->day(), '==', 10, 'day() on 1999-10-02 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Monday', 'day_name() on 1999-10-02 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Monendei', 'day_name_trad() on 1999-10-02 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 10, 'day_of_month() on 1999-10-02 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 3, 'day_of_week() on 1999-10-02 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 284, 'day_of_year() on 1999-10-02 Gregorian' );
cmp_ok( $dts->dow(), '==', 3, 'dow() on 1999-10-02 Gregorian' );
cmp_ok( $dts->doy(), '==', 284, 'doy() on 1999-10-02 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-10-02 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-10-02 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-10-02 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-10-02 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-10-02 Gregorian' );
cmp_ok( $dts->mday(), '==', 10, 'mday() on 1999-10-02 Gregorian' );
cmp_ok( $dts->month(), '==', 10, 'month() on 1999-10-02 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Winterfilth', 'month_name() on 1999-10-02 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-10-02 Gregorian' );
Monday 10 Winterfilth 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63074505600, 'utc_rd_as_seconds() on 1999-10-02 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730029,
  0,
  0
]
, 'utc_rd_values() on 1999-10-02 Gregorian' );
cmp_ok( $dts->wday(), '==', 3, 'wday() on 1999-10-02 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  41
]
, 'week() on 1999-10-02 Gregorian' );
cmp_ok( $dts->week_number(), '==', 41, 'week_number() on 1999-10-02 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-10-02 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-10-02 Gregorian' );

$epoch = timegm( 0, 0, 0, 3, 10 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 10,
	day	=> 3,
    ),
);
cmp_ok( $dts->day(), '==', 11, 'day() on 1999-10-03 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Trewsday', 'day_name() on 1999-10-03 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Trewesdei', 'day_name_trad() on 1999-10-03 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 11, 'day_of_month() on 1999-10-03 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 4, 'day_of_week() on 1999-10-03 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 285, 'day_of_year() on 1999-10-03 Gregorian' );
cmp_ok( $dts->dow(), '==', 4, 'dow() on 1999-10-03 Gregorian' );
cmp_ok( $dts->doy(), '==', 285, 'doy() on 1999-10-03 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-10-03 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-10-03 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-10-03 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-10-03 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-10-03 Gregorian' );
cmp_ok( $dts->mday(), '==', 11, 'mday() on 1999-10-03 Gregorian' );
cmp_ok( $dts->month(), '==', 10, 'month() on 1999-10-03 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Winterfilth', 'month_name() on 1999-10-03 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-10-03 Gregorian' );
Trewsday 11 Winterfilth 7463

Glorfindel drives the Black Riders off the Bridge of Mitheithel, 1418.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63074592000, 'utc_rd_as_seconds() on 1999-10-03 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730030,
  0,
  0
]
, 'utc_rd_values() on 1999-10-03 Gregorian' );
cmp_ok( $dts->wday(), '==', 4, 'wday() on 1999-10-03 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  41
]
, 'week() on 1999-10-03 Gregorian' );
cmp_ok( $dts->week_number(), '==', 41, 'week_number() on 1999-10-03 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-10-03 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-10-03 Gregorian' );

$epoch = timegm( 0, 0, 0, 4, 10 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 10,
	day	=> 4,
    ),
);
cmp_ok( $dts->day(), '==', 12, 'day() on 1999-10-04 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Hevensday', 'day_name() on 1999-10-04 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Hevenesdei', 'day_name_trad() on 1999-10-04 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 12, 'day_of_month() on 1999-10-04 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 5, 'day_of_week() on 1999-10-04 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 286, 'day_of_year() on 1999-10-04 Gregorian' );
cmp_ok( $dts->dow(), '==', 5, 'dow() on 1999-10-04 Gregorian' );
cmp_ok( $dts->doy(), '==', 286, 'doy() on 1999-10-04 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-10-04 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-10-04 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-10-04 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-10-04 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-10-04 Gregorian' );
cmp_ok( $dts->mday(), '==', 12, 'mday() on 1999-10-04 Gregorian' );
cmp_ok( $dts->month(), '==', 10, 'month() on 1999-10-04 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Winterfilth', 'month_name() on 1999-10-04 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-10-04 Gregorian' );
Hevensday 12 Winterfilth 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63074678400, 'utc_rd_as_seconds() on 1999-10-04 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730031,
  0,
  0
]
, 'utc_rd_values() on 1999-10-04 Gregorian' );
cmp_ok( $dts->wday(), '==', 5, 'wday() on 1999-10-04 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  41
]
, 'week() on 1999-10-04 Gregorian' );
cmp_ok( $dts->week_number(), '==', 41, 'week_number() on 1999-10-04 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-10-04 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-10-04 Gregorian' );

$epoch = timegm( 0, 0, 0, 5, 10 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 10,
	day	=> 5,
    ),
);
cmp_ok( $dts->day(), '==', 13, 'day() on 1999-10-05 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Mersday', 'day_name() on 1999-10-05 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Meresdei', 'day_name_trad() on 1999-10-05 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 13, 'day_of_month() on 1999-10-05 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 6, 'day_of_week() on 1999-10-05 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 287, 'day_of_year() on 1999-10-05 Gregorian' );
cmp_ok( $dts->dow(), '==', 6, 'dow() on 1999-10-05 Gregorian' );
cmp_ok( $dts->doy(), '==', 287, 'doy() on 1999-10-05 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-10-05 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-10-05 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-10-05 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-10-05 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-10-05 Gregorian' );
cmp_ok( $dts->mday(), '==', 13, 'mday() on 1999-10-05 Gregorian' );
cmp_ok( $dts->month(), '==', 10, 'month() on 1999-10-05 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Winterfilth', 'month_name() on 1999-10-05 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-10-05 Gregorian' );
Mersday 13 Winterfilth 7463

Frodo crosses the Bridge of Mitheithel, 1418.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63074764800, 'utc_rd_as_seconds() on 1999-10-05 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730032,
  0,
  0
]
, 'utc_rd_values() on 1999-10-05 Gregorian' );
cmp_ok( $dts->wday(), '==', 6, 'wday() on 1999-10-05 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  41
]
, 'week() on 1999-10-05 Gregorian' );
cmp_ok( $dts->week_number(), '==', 41, 'week_number() on 1999-10-05 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-10-05 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-10-05 Gregorian' );

$epoch = timegm( 0, 0, 0, 6, 10 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 10,
	day	=> 6,
    ),
);
cmp_ok( $dts->day(), '==', 14, 'day() on 1999-10-06 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Highday', 'day_name() on 1999-10-06 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Highdei', 'day_name_trad() on 1999-10-06 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 14, 'day_of_month() on 1999-10-06 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 7, 'day_of_week() on 1999-10-06 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 288, 'day_of_year() on 1999-10-06 Gregorian' );
cmp_ok( $dts->dow(), '==', 7, 'dow() on 1999-10-06 Gregorian' );
cmp_ok( $dts->doy(), '==', 288, 'doy() on 1999-10-06 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-10-06 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-10-06 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-10-06 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-10-06 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-10-06 Gregorian' );
cmp_ok( $dts->mday(), '==', 14, 'mday() on 1999-10-06 Gregorian' );
cmp_ok( $dts->month(), '==', 10, 'month() on 1999-10-06 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Winterfilth', 'month_name() on 1999-10-06 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-10-06 Gregorian' );
Highday 14 Winterfilth 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63074851200, 'utc_rd_as_seconds() on 1999-10-06 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730033,
  0,
  0
]
, 'utc_rd_values() on 1999-10-06 Gregorian' );
cmp_ok( $dts->wday(), '==', 7, 'wday() on 1999-10-06 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  41
]
, 'week() on 1999-10-06 Gregorian' );
cmp_ok( $dts->week_number(), '==', 41, 'week_number() on 1999-10-06 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-10-06 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-10-06 Gregorian' );

$epoch = timegm( 0, 0, 0, 7, 10 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 10,
	day	=> 7,
    ),
);
cmp_ok( $dts->day(), '==', 15, 'day() on 1999-10-07 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sterday', 'day_name() on 1999-10-07 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sterrendei', 'day_name_trad() on 1999-10-07 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 15, 'day_of_month() on 1999-10-07 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 1, 'day_of_week() on 1999-10-07 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 289, 'day_of_year() on 1999-10-07 Gregorian' );
cmp_ok( $dts->dow(), '==', 1, 'dow() on 1999-10-07 Gregorian' );
cmp_ok( $dts->doy(), '==', 289, 'doy() on 1999-10-07 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-10-07 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-10-07 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-10-07 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-10-07 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-10-07 Gregorian' );
cmp_ok( $dts->mday(), '==', 15, 'mday() on 1999-10-07 Gregorian' );
cmp_ok( $dts->month(), '==', 10, 'month() on 1999-10-07 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Winterfilth', 'month_name() on 1999-10-07 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-10-07 Gregorian' );
Sterday 15 Winterfilth 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63074937600, 'utc_rd_as_seconds() on 1999-10-07 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730034,
  0,
  0
]
, 'utc_rd_values() on 1999-10-07 Gregorian' );
cmp_ok( $dts->wday(), '==', 1, 'wday() on 1999-10-07 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  42
]
, 'week() on 1999-10-07 Gregorian' );
cmp_ok( $dts->week_number(), '==', 42, 'week_number() on 1999-10-07 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-10-07 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-10-07 Gregorian' );

$epoch = timegm( 0, 0, 0, 8, 10 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 10,
	day	=> 8,
    ),
);
cmp_ok( $dts->day(), '==', 16, 'day() on 1999-10-08 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sunday', 'day_name() on 1999-10-08 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sunnendei', 'day_name_trad() on 1999-10-08 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 16, 'day_of_month() on 1999-10-08 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 2, 'day_of_week() on 1999-10-08 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 290, 'day_of_year() on 1999-10-08 Gregorian' );
cmp_ok( $dts->dow(), '==', 2, 'dow() on 1999-10-08 Gregorian' );
cmp_ok( $dts->doy(), '==', 290, 'doy() on 1999-10-08 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-10-08 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-10-08 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-10-08 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-10-08 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-10-08 Gregorian' );
cmp_ok( $dts->mday(), '==', 16, 'mday() on 1999-10-08 Gregorian' );
cmp_ok( $dts->month(), '==', 10, 'month() on 1999-10-08 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Winterfilth', 'month_name() on 1999-10-08 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-10-08 Gregorian' );
Sunday 16 Winterfilth 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63075024000, 'utc_rd_as_seconds() on 1999-10-08 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730035,
  0,
  0
]
, 'utc_rd_values() on 1999-10-08 Gregorian' );
cmp_ok( $dts->wday(), '==', 2, 'wday() on 1999-10-08 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  42
]
, 'week() on 1999-10-08 Gregorian' );
cmp_ok( $dts->week_number(), '==', 42, 'week_number() on 1999-10-08 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-10-08 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-10-08 Gregorian' );

$epoch = timegm( 0, 0, 0, 9, 10 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 10,
	day	=> 9,
    ),
);
cmp_ok( $dts->day(), '==', 17, 'day() on 1999-10-09 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Monday', 'day_name() on 1999-10-09 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Monendei', 'day_name_trad() on 1999-10-09 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 17, 'day_of_month() on 1999-10-09 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 3, 'day_of_week() on 1999-10-09 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 291, 'day_of_year() on 1999-10-09 Gregorian' );
cmp_ok( $dts->dow(), '==', 3, 'dow() on 1999-10-09 Gregorian' );
cmp_ok( $dts->doy(), '==', 291, 'doy() on 1999-10-09 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-10-09 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-10-09 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-10-09 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-10-09 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-10-09 Gregorian' );
cmp_ok( $dts->mday(), '==', 17, 'mday() on 1999-10-09 Gregorian' );
cmp_ok( $dts->month(), '==', 10, 'month() on 1999-10-09 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Winterfilth', 'month_name() on 1999-10-09 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-10-09 Gregorian' );
Monday 17 Winterfilth 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63075110400, 'utc_rd_as_seconds() on 1999-10-09 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730036,
  0,
  0
]
, 'utc_rd_values() on 1999-10-09 Gregorian' );
cmp_ok( $dts->wday(), '==', 3, 'wday() on 1999-10-09 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  42
]
, 'week() on 1999-10-09 Gregorian' );
cmp_ok( $dts->week_number(), '==', 42, 'week_number() on 1999-10-09 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-10-09 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-10-09 Gregorian' );

$epoch = timegm( 0, 0, 0, 10, 10 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 10,
	day	=> 10,
    ),
);
cmp_ok( $dts->day(), '==', 18, 'day() on 1999-10-10 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Trewsday', 'day_name() on 1999-10-10 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Trewesdei', 'day_name_trad() on 1999-10-10 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 18, 'day_of_month() on 1999-10-10 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 4, 'day_of_week() on 1999-10-10 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 292, 'day_of_year() on 1999-10-10 Gregorian' );
cmp_ok( $dts->dow(), '==', 4, 'dow() on 1999-10-10 Gregorian' );
cmp_ok( $dts->doy(), '==', 292, 'doy() on 1999-10-10 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-10-10 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-10-10 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-10-10 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-10-10 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-10-10 Gregorian' );
cmp_ok( $dts->mday(), '==', 18, 'mday() on 1999-10-10 Gregorian' );
cmp_ok( $dts->month(), '==', 10, 'month() on 1999-10-10 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Winterfilth', 'month_name() on 1999-10-10 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-10-10 Gregorian' );
Trewsday 18 Winterfilth 7463

Glorfindel finds Frodo at dusk, 1418.
Gandalf reaches Rivendell, 1418.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63075196800, 'utc_rd_as_seconds() on 1999-10-10 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730037,
  0,
  0
]
, 'utc_rd_values() on 1999-10-10 Gregorian' );
cmp_ok( $dts->wday(), '==', 4, 'wday() on 1999-10-10 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  42
]
, 'week() on 1999-10-10 Gregorian' );
cmp_ok( $dts->week_number(), '==', 42, 'week_number() on 1999-10-10 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-10-10 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-10-10 Gregorian' );

$epoch = timegm( 0, 0, 0, 11, 10 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 10,
	day	=> 11,
    ),
);
cmp_ok( $dts->day(), '==', 19, 'day() on 1999-10-11 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Hevensday', 'day_name() on 1999-10-11 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Hevenesdei', 'day_name_trad() on 1999-10-11 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 19, 'day_of_month() on 1999-10-11 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 5, 'day_of_week() on 1999-10-11 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 293, 'day_of_year() on 1999-10-11 Gregorian' );
cmp_ok( $dts->dow(), '==', 5, 'dow() on 1999-10-11 Gregorian' );
cmp_ok( $dts->doy(), '==', 293, 'doy() on 1999-10-11 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-10-11 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-10-11 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-10-11 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-10-11 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-10-11 Gregorian' );
cmp_ok( $dts->mday(), '==', 19, 'mday() on 1999-10-11 Gregorian' );
cmp_ok( $dts->month(), '==', 10, 'month() on 1999-10-11 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Winterfilth', 'month_name() on 1999-10-11 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-10-11 Gregorian' );
Hevensday 19 Winterfilth 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63075283200, 'utc_rd_as_seconds() on 1999-10-11 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730038,
  0,
  0
]
, 'utc_rd_values() on 1999-10-11 Gregorian' );
cmp_ok( $dts->wday(), '==', 5, 'wday() on 1999-10-11 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  42
]
, 'week() on 1999-10-11 Gregorian' );
cmp_ok( $dts->week_number(), '==', 42, 'week_number() on 1999-10-11 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-10-11 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-10-11 Gregorian' );

$epoch = timegm( 0, 0, 0, 12, 10 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 10,
	day	=> 12,
    ),
);
cmp_ok( $dts->day(), '==', 20, 'day() on 1999-10-12 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Mersday', 'day_name() on 1999-10-12 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Meresdei', 'day_name_trad() on 1999-10-12 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 20, 'day_of_month() on 1999-10-12 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 6, 'day_of_week() on 1999-10-12 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 294, 'day_of_year() on 1999-10-12 Gregorian' );
cmp_ok( $dts->dow(), '==', 6, 'dow() on 1999-10-12 Gregorian' );
cmp_ok( $dts->doy(), '==', 294, 'doy() on 1999-10-12 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-10-12 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-10-12 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-10-12 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-10-12 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-10-12 Gregorian' );
cmp_ok( $dts->mday(), '==', 20, 'mday() on 1999-10-12 Gregorian' );
cmp_ok( $dts->month(), '==', 10, 'month() on 1999-10-12 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Winterfilth', 'month_name() on 1999-10-12 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-10-12 Gregorian' );
Mersday 20 Winterfilth 7463

Escape across the Ford of Bruinen, 1418.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63075369600, 'utc_rd_as_seconds() on 1999-10-12 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730039,
  0,
  0
]
, 'utc_rd_values() on 1999-10-12 Gregorian' );
cmp_ok( $dts->wday(), '==', 6, 'wday() on 1999-10-12 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  42
]
, 'week() on 1999-10-12 Gregorian' );
cmp_ok( $dts->week_number(), '==', 42, 'week_number() on 1999-10-12 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-10-12 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-10-12 Gregorian' );

$epoch = timegm( 0, 0, 0, 13, 10 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 10,
	day	=> 13,
    ),
);
cmp_ok( $dts->day(), '==', 21, 'day() on 1999-10-13 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Highday', 'day_name() on 1999-10-13 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Highdei', 'day_name_trad() on 1999-10-13 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 21, 'day_of_month() on 1999-10-13 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 7, 'day_of_week() on 1999-10-13 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 295, 'day_of_year() on 1999-10-13 Gregorian' );
cmp_ok( $dts->dow(), '==', 7, 'dow() on 1999-10-13 Gregorian' );
cmp_ok( $dts->doy(), '==', 295, 'doy() on 1999-10-13 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-10-13 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-10-13 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-10-13 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-10-13 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-10-13 Gregorian' );
cmp_ok( $dts->mday(), '==', 21, 'mday() on 1999-10-13 Gregorian' );
cmp_ok( $dts->month(), '==', 10, 'month() on 1999-10-13 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Winterfilth', 'month_name() on 1999-10-13 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-10-13 Gregorian' );
Highday 21 Winterfilth 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63075456000, 'utc_rd_as_seconds() on 1999-10-13 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730040,
  0,
  0
]
, 'utc_rd_values() on 1999-10-13 Gregorian' );
cmp_ok( $dts->wday(), '==', 7, 'wday() on 1999-10-13 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  42
]
, 'week() on 1999-10-13 Gregorian' );
cmp_ok( $dts->week_number(), '==', 42, 'week_number() on 1999-10-13 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-10-13 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-10-13 Gregorian' );

$epoch = timegm( 0, 0, 0, 14, 10 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 10,
	day	=> 14,
    ),
);
cmp_ok( $dts->day(), '==', 22, 'day() on 1999-10-14 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sterday', 'day_name() on 1999-10-14 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sterrendei', 'day_name_trad() on 1999-10-14 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 22, 'day_of_month() on 1999-10-14 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 1, 'day_of_week() on 1999-10-14 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 296, 'day_of_year() on 1999-10-14 Gregorian' );
cmp_ok( $dts->dow(), '==', 1, 'dow() on 1999-10-14 Gregorian' );
cmp_ok( $dts->doy(), '==', 296, 'doy() on 1999-10-14 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-10-14 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-10-14 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-10-14 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-10-14 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-10-14 Gregorian' );
cmp_ok( $dts->mday(), '==', 22, 'mday() on 1999-10-14 Gregorian' );
cmp_ok( $dts->month(), '==', 10, 'month() on 1999-10-14 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Winterfilth', 'month_name() on 1999-10-14 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-10-14 Gregorian' );
Sterday 22 Winterfilth 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63075542400, 'utc_rd_as_seconds() on 1999-10-14 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730041,
  0,
  0
]
, 'utc_rd_values() on 1999-10-14 Gregorian' );
cmp_ok( $dts->wday(), '==', 1, 'wday() on 1999-10-14 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  43
]
, 'week() on 1999-10-14 Gregorian' );
cmp_ok( $dts->week_number(), '==', 43, 'week_number() on 1999-10-14 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-10-14 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-10-14 Gregorian' );

$epoch = timegm( 0, 0, 0, 15, 10 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 10,
	day	=> 15,
    ),
);
cmp_ok( $dts->day(), '==', 23, 'day() on 1999-10-15 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sunday', 'day_name() on 1999-10-15 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sunnendei', 'day_name_trad() on 1999-10-15 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 23, 'day_of_month() on 1999-10-15 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 2, 'day_of_week() on 1999-10-15 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 297, 'day_of_year() on 1999-10-15 Gregorian' );
cmp_ok( $dts->dow(), '==', 2, 'dow() on 1999-10-15 Gregorian' );
cmp_ok( $dts->doy(), '==', 297, 'doy() on 1999-10-15 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-10-15 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-10-15 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-10-15 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-10-15 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-10-15 Gregorian' );
cmp_ok( $dts->mday(), '==', 23, 'mday() on 1999-10-15 Gregorian' );
cmp_ok( $dts->month(), '==', 10, 'month() on 1999-10-15 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Winterfilth', 'month_name() on 1999-10-15 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-10-15 Gregorian' );
Sunday 23 Winterfilth 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63075628800, 'utc_rd_as_seconds() on 1999-10-15 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730042,
  0,
  0
]
, 'utc_rd_values() on 1999-10-15 Gregorian' );
cmp_ok( $dts->wday(), '==', 2, 'wday() on 1999-10-15 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  43
]
, 'week() on 1999-10-15 Gregorian' );
cmp_ok( $dts->week_number(), '==', 43, 'week_number() on 1999-10-15 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-10-15 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-10-15 Gregorian' );

$epoch = timegm( 0, 0, 0, 16, 10 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 10,
	day	=> 16,
    ),
);
cmp_ok( $dts->day(), '==', 24, 'day() on 1999-10-16 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Monday', 'day_name() on 1999-10-16 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Monendei', 'day_name_trad() on 1999-10-16 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 24, 'day_of_month() on 1999-10-16 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 3, 'day_of_week() on 1999-10-16 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 298, 'day_of_year() on 1999-10-16 Gregorian' );
cmp_ok( $dts->dow(), '==', 3, 'dow() on 1999-10-16 Gregorian' );
cmp_ok( $dts->doy(), '==', 298, 'doy() on 1999-10-16 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-10-16 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-10-16 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-10-16 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-10-16 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-10-16 Gregorian' );
cmp_ok( $dts->mday(), '==', 24, 'mday() on 1999-10-16 Gregorian' );
cmp_ok( $dts->month(), '==', 10, 'month() on 1999-10-16 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Winterfilth', 'month_name() on 1999-10-16 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-10-16 Gregorian' );
Monday 24 Winterfilth 7463

Frodo recovers and wakes, 1418.
Boromir arrives at Rivendell at night, 1418.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63075715200, 'utc_rd_as_seconds() on 1999-10-16 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730043,
  0,
  0
]
, 'utc_rd_values() on 1999-10-16 Gregorian' );
cmp_ok( $dts->wday(), '==', 3, 'wday() on 1999-10-16 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  43
]
, 'week() on 1999-10-16 Gregorian' );
cmp_ok( $dts->week_number(), '==', 43, 'week_number() on 1999-10-16 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-10-16 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-10-16 Gregorian' );

$epoch = timegm( 0, 0, 0, 17, 10 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 10,
	day	=> 17,
    ),
);
cmp_ok( $dts->day(), '==', 25, 'day() on 1999-10-17 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Trewsday', 'day_name() on 1999-10-17 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Trewesdei', 'day_name_trad() on 1999-10-17 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 25, 'day_of_month() on 1999-10-17 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 4, 'day_of_week() on 1999-10-17 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 299, 'day_of_year() on 1999-10-17 Gregorian' );
cmp_ok( $dts->dow(), '==', 4, 'dow() on 1999-10-17 Gregorian' );
cmp_ok( $dts->doy(), '==', 299, 'doy() on 1999-10-17 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-10-17 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-10-17 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-10-17 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-10-17 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-10-17 Gregorian' );
cmp_ok( $dts->mday(), '==', 25, 'mday() on 1999-10-17 Gregorian' );
cmp_ok( $dts->month(), '==', 10, 'month() on 1999-10-17 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Winterfilth', 'month_name() on 1999-10-17 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-10-17 Gregorian' );
Trewsday 25 Winterfilth 7463

Council of Elrond, 1418.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63075801600, 'utc_rd_as_seconds() on 1999-10-17 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730044,
  0,
  0
]
, 'utc_rd_values() on 1999-10-17 Gregorian' );
cmp_ok( $dts->wday(), '==', 4, 'wday() on 1999-10-17 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  43
]
, 'week() on 1999-10-17 Gregorian' );
cmp_ok( $dts->week_number(), '==', 43, 'week_number() on 1999-10-17 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-10-17 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-10-17 Gregorian' );

$epoch = timegm( 0, 0, 0, 18, 10 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 10,
	day	=> 18,
    ),
);
cmp_ok( $dts->day(), '==', 26, 'day() on 1999-10-18 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Hevensday', 'day_name() on 1999-10-18 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Hevenesdei', 'day_name_trad() on 1999-10-18 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 26, 'day_of_month() on 1999-10-18 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 5, 'day_of_week() on 1999-10-18 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 300, 'day_of_year() on 1999-10-18 Gregorian' );
cmp_ok( $dts->dow(), '==', 5, 'dow() on 1999-10-18 Gregorian' );
cmp_ok( $dts->doy(), '==', 300, 'doy() on 1999-10-18 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-10-18 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-10-18 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-10-18 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-10-18 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-10-18 Gregorian' );
cmp_ok( $dts->mday(), '==', 26, 'mday() on 1999-10-18 Gregorian' );
cmp_ok( $dts->month(), '==', 10, 'month() on 1999-10-18 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Winterfilth', 'month_name() on 1999-10-18 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-10-18 Gregorian' );
Hevensday 26 Winterfilth 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63075888000, 'utc_rd_as_seconds() on 1999-10-18 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730045,
  0,
  0
]
, 'utc_rd_values() on 1999-10-18 Gregorian' );
cmp_ok( $dts->wday(), '==', 5, 'wday() on 1999-10-18 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  43
]
, 'week() on 1999-10-18 Gregorian' );
cmp_ok( $dts->week_number(), '==', 43, 'week_number() on 1999-10-18 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-10-18 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-10-18 Gregorian' );

$epoch = timegm( 0, 0, 0, 19, 10 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 10,
	day	=> 19,
    ),
);
cmp_ok( $dts->day(), '==', 27, 'day() on 1999-10-19 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Mersday', 'day_name() on 1999-10-19 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Meresdei', 'day_name_trad() on 1999-10-19 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 27, 'day_of_month() on 1999-10-19 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 6, 'day_of_week() on 1999-10-19 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 301, 'day_of_year() on 1999-10-19 Gregorian' );
cmp_ok( $dts->dow(), '==', 6, 'dow() on 1999-10-19 Gregorian' );
cmp_ok( $dts->doy(), '==', 301, 'doy() on 1999-10-19 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-10-19 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-10-19 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-10-19 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-10-19 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-10-19 Gregorian' );
cmp_ok( $dts->mday(), '==', 27, 'mday() on 1999-10-19 Gregorian' );
cmp_ok( $dts->month(), '==', 10, 'month() on 1999-10-19 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Winterfilth', 'month_name() on 1999-10-19 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-10-19 Gregorian' );
Mersday 27 Winterfilth 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63075974400, 'utc_rd_as_seconds() on 1999-10-19 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730046,
  0,
  0
]
, 'utc_rd_values() on 1999-10-19 Gregorian' );
cmp_ok( $dts->wday(), '==', 6, 'wday() on 1999-10-19 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  43
]
, 'week() on 1999-10-19 Gregorian' );
cmp_ok( $dts->week_number(), '==', 43, 'week_number() on 1999-10-19 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-10-19 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-10-19 Gregorian' );

$epoch = timegm( 0, 0, 0, 20, 10 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 10,
	day	=> 20,
    ),
);
cmp_ok( $dts->day(), '==', 28, 'day() on 1999-10-20 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Highday', 'day_name() on 1999-10-20 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Highdei', 'day_name_trad() on 1999-10-20 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 28, 'day_of_month() on 1999-10-20 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 7, 'day_of_week() on 1999-10-20 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 302, 'day_of_year() on 1999-10-20 Gregorian' );
cmp_ok( $dts->dow(), '==', 7, 'dow() on 1999-10-20 Gregorian' );
cmp_ok( $dts->doy(), '==', 302, 'doy() on 1999-10-20 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-10-20 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-10-20 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-10-20 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-10-20 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-10-20 Gregorian' );
cmp_ok( $dts->mday(), '==', 28, 'mday() on 1999-10-20 Gregorian' );
cmp_ok( $dts->month(), '==', 10, 'month() on 1999-10-20 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Winterfilth', 'month_name() on 1999-10-20 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-10-20 Gregorian' );
Highday 28 Winterfilth 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63076060800, 'utc_rd_as_seconds() on 1999-10-20 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730047,
  0,
  0
]
, 'utc_rd_values() on 1999-10-20 Gregorian' );
cmp_ok( $dts->wday(), '==', 7, 'wday() on 1999-10-20 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  43
]
, 'week() on 1999-10-20 Gregorian' );
cmp_ok( $dts->week_number(), '==', 43, 'week_number() on 1999-10-20 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-10-20 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-10-20 Gregorian' );

$epoch = timegm( 0, 0, 0, 21, 10 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 10,
	day	=> 21,
    ),
);
cmp_ok( $dts->day(), '==', 29, 'day() on 1999-10-21 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sterday', 'day_name() on 1999-10-21 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sterrendei', 'day_name_trad() on 1999-10-21 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 29, 'day_of_month() on 1999-10-21 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 1, 'day_of_week() on 1999-10-21 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 303, 'day_of_year() on 1999-10-21 Gregorian' );
cmp_ok( $dts->dow(), '==', 1, 'dow() on 1999-10-21 Gregorian' );
cmp_ok( $dts->doy(), '==', 303, 'doy() on 1999-10-21 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-10-21 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-10-21 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-10-21 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-10-21 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-10-21 Gregorian' );
cmp_ok( $dts->mday(), '==', 29, 'mday() on 1999-10-21 Gregorian' );
cmp_ok( $dts->month(), '==', 10, 'month() on 1999-10-21 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Winterfilth', 'month_name() on 1999-10-21 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-10-21 Gregorian' );
Sterday 29 Winterfilth 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63076147200, 'utc_rd_as_seconds() on 1999-10-21 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730048,
  0,
  0
]
, 'utc_rd_values() on 1999-10-21 Gregorian' );
cmp_ok( $dts->wday(), '==', 1, 'wday() on 1999-10-21 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  44
]
, 'week() on 1999-10-21 Gregorian' );
cmp_ok( $dts->week_number(), '==', 44, 'week_number() on 1999-10-21 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-10-21 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-10-21 Gregorian' );

$epoch = timegm( 0, 0, 0, 22, 10 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 10,
	day	=> 22,
    ),
);
cmp_ok( $dts->day(), '==', 30, 'day() on 1999-10-22 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sunday', 'day_name() on 1999-10-22 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sunnendei', 'day_name_trad() on 1999-10-22 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 30, 'day_of_month() on 1999-10-22 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 2, 'day_of_week() on 1999-10-22 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 304, 'day_of_year() on 1999-10-22 Gregorian' );
cmp_ok( $dts->dow(), '==', 2, 'dow() on 1999-10-22 Gregorian' );
cmp_ok( $dts->doy(), '==', 304, 'doy() on 1999-10-22 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-10-22 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-10-22 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-10-22 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-10-22 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-10-22 Gregorian' );
cmp_ok( $dts->mday(), '==', 30, 'mday() on 1999-10-22 Gregorian' );
cmp_ok( $dts->month(), '==', 10, 'month() on 1999-10-22 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Winterfilth', 'month_name() on 1999-10-22 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-10-22 Gregorian' );
Sunday 30 Winterfilth 7463

The four Hobbits arrive at the Brandywine Bridge in the dark, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63076233600, 'utc_rd_as_seconds() on 1999-10-22 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730049,
  0,
  0
]
, 'utc_rd_values() on 1999-10-22 Gregorian' );
cmp_ok( $dts->wday(), '==', 2, 'wday() on 1999-10-22 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  44
]
, 'week() on 1999-10-22 Gregorian' );
cmp_ok( $dts->week_number(), '==', 44, 'week_number() on 1999-10-22 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-10-22 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-10-22 Gregorian' );

$epoch = timegm( 0, 0, 0, 23, 10 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 10,
	day	=> 23,
    ),
);
cmp_ok( $dts->day(), '==', 1, 'day() on 1999-10-23 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Monday', 'day_name() on 1999-10-23 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Monendei', 'day_name_trad() on 1999-10-23 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 1, 'day_of_month() on 1999-10-23 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 3, 'day_of_week() on 1999-10-23 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 305, 'day_of_year() on 1999-10-23 Gregorian' );
cmp_ok( $dts->dow(), '==', 3, 'dow() on 1999-10-23 Gregorian' );
cmp_ok( $dts->doy(), '==', 305, 'doy() on 1999-10-23 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-10-23 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-10-23 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-10-23 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-10-23 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-10-23 Gregorian' );
cmp_ok( $dts->mday(), '==', 1, 'mday() on 1999-10-23 Gregorian' );
cmp_ok( $dts->month(), '==', 11, 'month() on 1999-10-23 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Blotmath', 'month_name() on 1999-10-23 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-10-23 Gregorian' );
Monday 1 Blotmath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63076320000, 'utc_rd_as_seconds() on 1999-10-23 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730050,
  0,
  0
]
, 'utc_rd_values() on 1999-10-23 Gregorian' );
cmp_ok( $dts->wday(), '==', 3, 'wday() on 1999-10-23 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  44
]
, 'week() on 1999-10-23 Gregorian' );
cmp_ok( $dts->week_number(), '==', 44, 'week_number() on 1999-10-23 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-10-23 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-10-23 Gregorian' );

$epoch = timegm( 0, 0, 0, 24, 10 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 10,
	day	=> 24,
    ),
);
cmp_ok( $dts->day(), '==', 2, 'day() on 1999-10-24 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Trewsday', 'day_name() on 1999-10-24 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Trewesdei', 'day_name_trad() on 1999-10-24 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 2, 'day_of_month() on 1999-10-24 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 4, 'day_of_week() on 1999-10-24 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 306, 'day_of_year() on 1999-10-24 Gregorian' );
cmp_ok( $dts->dow(), '==', 4, 'dow() on 1999-10-24 Gregorian' );
cmp_ok( $dts->doy(), '==', 306, 'doy() on 1999-10-24 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-10-24 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-10-24 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-10-24 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-10-24 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-10-24 Gregorian' );
cmp_ok( $dts->mday(), '==', 2, 'mday() on 1999-10-24 Gregorian' );
cmp_ok( $dts->month(), '==', 11, 'month() on 1999-10-24 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Blotmath', 'month_name() on 1999-10-24 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-10-24 Gregorian' );
Trewsday 2 Blotmath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63076406400, 'utc_rd_as_seconds() on 1999-10-24 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730051,
  0,
  0
]
, 'utc_rd_values() on 1999-10-24 Gregorian' );
cmp_ok( $dts->wday(), '==', 4, 'wday() on 1999-10-24 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  44
]
, 'week() on 1999-10-24 Gregorian' );
cmp_ok( $dts->week_number(), '==', 44, 'week_number() on 1999-10-24 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-10-24 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-10-24 Gregorian' );

$epoch = timegm( 0, 0, 0, 25, 10 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 10,
	day	=> 25,
    ),
);
cmp_ok( $dts->day(), '==', 3, 'day() on 1999-10-25 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Hevensday', 'day_name() on 1999-10-25 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Hevenesdei', 'day_name_trad() on 1999-10-25 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 3, 'day_of_month() on 1999-10-25 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 5, 'day_of_week() on 1999-10-25 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 307, 'day_of_year() on 1999-10-25 Gregorian' );
cmp_ok( $dts->dow(), '==', 5, 'dow() on 1999-10-25 Gregorian' );
cmp_ok( $dts->doy(), '==', 307, 'doy() on 1999-10-25 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-10-25 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-10-25 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-10-25 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-10-25 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-10-25 Gregorian' );
cmp_ok( $dts->mday(), '==', 3, 'mday() on 1999-10-25 Gregorian' );
cmp_ok( $dts->month(), '==', 11, 'month() on 1999-10-25 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Blotmath', 'month_name() on 1999-10-25 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-10-25 Gregorian' );
Hevensday 3 Blotmath 7463

Battle of Bywater and passing of Saruman, 1419.
End of the War of the Ring, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63076492800, 'utc_rd_as_seconds() on 1999-10-25 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730052,
  0,
  0
]
, 'utc_rd_values() on 1999-10-25 Gregorian' );
cmp_ok( $dts->wday(), '==', 5, 'wday() on 1999-10-25 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  44
]
, 'week() on 1999-10-25 Gregorian' );
cmp_ok( $dts->week_number(), '==', 44, 'week_number() on 1999-10-25 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-10-25 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-10-25 Gregorian' );

$epoch = timegm( 0, 0, 0, 26, 10 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 10,
	day	=> 26,
    ),
);
cmp_ok( $dts->day(), '==', 4, 'day() on 1999-10-26 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Mersday', 'day_name() on 1999-10-26 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Meresdei', 'day_name_trad() on 1999-10-26 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 4, 'day_of_month() on 1999-10-26 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 6, 'day_of_week() on 1999-10-26 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 308, 'day_of_year() on 1999-10-26 Gregorian' );
cmp_ok( $dts->dow(), '==', 6, 'dow() on 1999-10-26 Gregorian' );
cmp_ok( $dts->doy(), '==', 308, 'doy() on 1999-10-26 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-10-26 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-10-26 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-10-26 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-10-26 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-10-26 Gregorian' );
cmp_ok( $dts->mday(), '==', 4, 'mday() on 1999-10-26 Gregorian' );
cmp_ok( $dts->month(), '==', 11, 'month() on 1999-10-26 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Blotmath', 'month_name() on 1999-10-26 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-10-26 Gregorian' );
Mersday 4 Blotmath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63076579200, 'utc_rd_as_seconds() on 1999-10-26 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730053,
  0,
  0
]
, 'utc_rd_values() on 1999-10-26 Gregorian' );
cmp_ok( $dts->wday(), '==', 6, 'wday() on 1999-10-26 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  44
]
, 'week() on 1999-10-26 Gregorian' );
cmp_ok( $dts->week_number(), '==', 44, 'week_number() on 1999-10-26 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-10-26 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-10-26 Gregorian' );

$epoch = timegm( 0, 0, 0, 27, 10 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 10,
	day	=> 27,
    ),
);
cmp_ok( $dts->day(), '==', 5, 'day() on 1999-10-27 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Highday', 'day_name() on 1999-10-27 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Highdei', 'day_name_trad() on 1999-10-27 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 5, 'day_of_month() on 1999-10-27 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 7, 'day_of_week() on 1999-10-27 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 309, 'day_of_year() on 1999-10-27 Gregorian' );
cmp_ok( $dts->dow(), '==', 7, 'dow() on 1999-10-27 Gregorian' );
cmp_ok( $dts->doy(), '==', 309, 'doy() on 1999-10-27 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-10-27 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-10-27 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-10-27 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-10-27 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-10-27 Gregorian' );
cmp_ok( $dts->mday(), '==', 5, 'mday() on 1999-10-27 Gregorian' );
cmp_ok( $dts->month(), '==', 11, 'month() on 1999-10-27 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Blotmath', 'month_name() on 1999-10-27 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-10-27 Gregorian' );
Highday 5 Blotmath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63076665600, 'utc_rd_as_seconds() on 1999-10-27 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730054,
  0,
  0
]
, 'utc_rd_values() on 1999-10-27 Gregorian' );
cmp_ok( $dts->wday(), '==', 7, 'wday() on 1999-10-27 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  44
]
, 'week() on 1999-10-27 Gregorian' );
cmp_ok( $dts->week_number(), '==', 44, 'week_number() on 1999-10-27 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-10-27 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-10-27 Gregorian' );

$epoch = timegm( 0, 0, 0, 28, 10 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 10,
	day	=> 28,
    ),
);
cmp_ok( $dts->day(), '==', 6, 'day() on 1999-10-28 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sterday', 'day_name() on 1999-10-28 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sterrendei', 'day_name_trad() on 1999-10-28 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 6, 'day_of_month() on 1999-10-28 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 1, 'day_of_week() on 1999-10-28 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 310, 'day_of_year() on 1999-10-28 Gregorian' );
cmp_ok( $dts->dow(), '==', 1, 'dow() on 1999-10-28 Gregorian' );
cmp_ok( $dts->doy(), '==', 310, 'doy() on 1999-10-28 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-10-28 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-10-28 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-10-28 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-10-28 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-10-28 Gregorian' );
cmp_ok( $dts->mday(), '==', 6, 'mday() on 1999-10-28 Gregorian' );
cmp_ok( $dts->month(), '==', 11, 'month() on 1999-10-28 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Blotmath', 'month_name() on 1999-10-28 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-10-28 Gregorian' );
Sterday 6 Blotmath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63076752000, 'utc_rd_as_seconds() on 1999-10-28 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730055,
  0,
  0
]
, 'utc_rd_values() on 1999-10-28 Gregorian' );
cmp_ok( $dts->wday(), '==', 1, 'wday() on 1999-10-28 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  45
]
, 'week() on 1999-10-28 Gregorian' );
cmp_ok( $dts->week_number(), '==', 45, 'week_number() on 1999-10-28 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-10-28 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-10-28 Gregorian' );

$epoch = timegm( 0, 0, 0, 29, 10 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 10,
	day	=> 29,
    ),
);
cmp_ok( $dts->day(), '==', 7, 'day() on 1999-10-29 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sunday', 'day_name() on 1999-10-29 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sunnendei', 'day_name_trad() on 1999-10-29 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 7, 'day_of_month() on 1999-10-29 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 2, 'day_of_week() on 1999-10-29 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 311, 'day_of_year() on 1999-10-29 Gregorian' );
cmp_ok( $dts->dow(), '==', 2, 'dow() on 1999-10-29 Gregorian' );
cmp_ok( $dts->doy(), '==', 311, 'doy() on 1999-10-29 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-10-29 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-10-29 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-10-29 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-10-29 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-10-29 Gregorian' );
cmp_ok( $dts->mday(), '==', 7, 'mday() on 1999-10-29 Gregorian' );
cmp_ok( $dts->month(), '==', 11, 'month() on 1999-10-29 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Blotmath', 'month_name() on 1999-10-29 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-10-29 Gregorian' );
Sunday 7 Blotmath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63076838400, 'utc_rd_as_seconds() on 1999-10-29 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730056,
  0,
  0
]
, 'utc_rd_values() on 1999-10-29 Gregorian' );
cmp_ok( $dts->wday(), '==', 2, 'wday() on 1999-10-29 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  45
]
, 'week() on 1999-10-29 Gregorian' );
cmp_ok( $dts->week_number(), '==', 45, 'week_number() on 1999-10-29 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-10-29 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-10-29 Gregorian' );

$epoch = timegm( 0, 0, 0, 30, 10 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 10,
	day	=> 30,
    ),
);
cmp_ok( $dts->day(), '==', 8, 'day() on 1999-10-30 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Monday', 'day_name() on 1999-10-30 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Monendei', 'day_name_trad() on 1999-10-30 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 8, 'day_of_month() on 1999-10-30 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 3, 'day_of_week() on 1999-10-30 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 312, 'day_of_year() on 1999-10-30 Gregorian' );
cmp_ok( $dts->dow(), '==', 3, 'dow() on 1999-10-30 Gregorian' );
cmp_ok( $dts->doy(), '==', 312, 'doy() on 1999-10-30 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-10-30 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-10-30 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-10-30 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-10-30 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-10-30 Gregorian' );
cmp_ok( $dts->mday(), '==', 8, 'mday() on 1999-10-30 Gregorian' );
cmp_ok( $dts->month(), '==', 11, 'month() on 1999-10-30 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Blotmath', 'month_name() on 1999-10-30 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-10-30 Gregorian' );
Monday 8 Blotmath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63076924800, 'utc_rd_as_seconds() on 1999-10-30 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730057,
  0,
  0
]
, 'utc_rd_values() on 1999-10-30 Gregorian' );
cmp_ok( $dts->wday(), '==', 3, 'wday() on 1999-10-30 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  45
]
, 'week() on 1999-10-30 Gregorian' );
cmp_ok( $dts->week_number(), '==', 45, 'week_number() on 1999-10-30 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-10-30 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-10-30 Gregorian' );

$epoch = timegm( 0, 0, 0, 31, 10 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 10,
	day	=> 31,
    ),
);
cmp_ok( $dts->day(), '==', 9, 'day() on 1999-10-31 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Trewsday', 'day_name() on 1999-10-31 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Trewesdei', 'day_name_trad() on 1999-10-31 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 9, 'day_of_month() on 1999-10-31 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 4, 'day_of_week() on 1999-10-31 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 313, 'day_of_year() on 1999-10-31 Gregorian' );
cmp_ok( $dts->dow(), '==', 4, 'dow() on 1999-10-31 Gregorian' );
cmp_ok( $dts->doy(), '==', 313, 'doy() on 1999-10-31 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-10-31 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-10-31 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-10-31 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-10-31 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-10-31 Gregorian' );
cmp_ok( $dts->mday(), '==', 9, 'mday() on 1999-10-31 Gregorian' );
cmp_ok( $dts->month(), '==', 11, 'month() on 1999-10-31 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Blotmath', 'month_name() on 1999-10-31 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-10-31 Gregorian' );
Trewsday 9 Blotmath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63077011200, 'utc_rd_as_seconds() on 1999-10-31 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730058,
  0,
  0
]
, 'utc_rd_values() on 1999-10-31 Gregorian' );
cmp_ok( $dts->wday(), '==', 4, 'wday() on 1999-10-31 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  45
]
, 'week() on 1999-10-31 Gregorian' );
cmp_ok( $dts->week_number(), '==', 45, 'week_number() on 1999-10-31 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-10-31 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-10-31 Gregorian' );

$epoch = timegm( 0, 0, 0, 1, 11 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 11,
	day	=> 1,
    ),
);
cmp_ok( $dts->day(), '==', 10, 'day() on 1999-11-01 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Hevensday', 'day_name() on 1999-11-01 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Hevenesdei', 'day_name_trad() on 1999-11-01 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 10, 'day_of_month() on 1999-11-01 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 5, 'day_of_week() on 1999-11-01 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 314, 'day_of_year() on 1999-11-01 Gregorian' );
cmp_ok( $dts->dow(), '==', 5, 'dow() on 1999-11-01 Gregorian' );
cmp_ok( $dts->doy(), '==', 314, 'doy() on 1999-11-01 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-11-01 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-11-01 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-11-01 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-11-01 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-11-01 Gregorian' );
cmp_ok( $dts->mday(), '==', 10, 'mday() on 1999-11-01 Gregorian' );
cmp_ok( $dts->month(), '==', 11, 'month() on 1999-11-01 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Blotmath', 'month_name() on 1999-11-01 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-11-01 Gregorian' );
Hevensday 10 Blotmath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63077097600, 'utc_rd_as_seconds() on 1999-11-01 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730059,
  0,
  0
]
, 'utc_rd_values() on 1999-11-01 Gregorian' );
cmp_ok( $dts->wday(), '==', 5, 'wday() on 1999-11-01 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  45
]
, 'week() on 1999-11-01 Gregorian' );
cmp_ok( $dts->week_number(), '==', 45, 'week_number() on 1999-11-01 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-11-01 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-11-01 Gregorian' );

$epoch = timegm( 0, 0, 0, 2, 11 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 11,
	day	=> 2,
    ),
);
cmp_ok( $dts->day(), '==', 11, 'day() on 1999-11-02 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Mersday', 'day_name() on 1999-11-02 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Meresdei', 'day_name_trad() on 1999-11-02 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 11, 'day_of_month() on 1999-11-02 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 6, 'day_of_week() on 1999-11-02 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 315, 'day_of_year() on 1999-11-02 Gregorian' );
cmp_ok( $dts->dow(), '==', 6, 'dow() on 1999-11-02 Gregorian' );
cmp_ok( $dts->doy(), '==', 315, 'doy() on 1999-11-02 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-11-02 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-11-02 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-11-02 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-11-02 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-11-02 Gregorian' );
cmp_ok( $dts->mday(), '==', 11, 'mday() on 1999-11-02 Gregorian' );
cmp_ok( $dts->month(), '==', 11, 'month() on 1999-11-02 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Blotmath', 'month_name() on 1999-11-02 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-11-02 Gregorian' );
Mersday 11 Blotmath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63077184000, 'utc_rd_as_seconds() on 1999-11-02 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730060,
  0,
  0
]
, 'utc_rd_values() on 1999-11-02 Gregorian' );
cmp_ok( $dts->wday(), '==', 6, 'wday() on 1999-11-02 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  45
]
, 'week() on 1999-11-02 Gregorian' );
cmp_ok( $dts->week_number(), '==', 45, 'week_number() on 1999-11-02 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-11-02 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-11-02 Gregorian' );

$epoch = timegm( 0, 0, 0, 3, 11 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 11,
	day	=> 3,
    ),
);
cmp_ok( $dts->day(), '==', 12, 'day() on 1999-11-03 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Highday', 'day_name() on 1999-11-03 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Highdei', 'day_name_trad() on 1999-11-03 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 12, 'day_of_month() on 1999-11-03 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 7, 'day_of_week() on 1999-11-03 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 316, 'day_of_year() on 1999-11-03 Gregorian' );
cmp_ok( $dts->dow(), '==', 7, 'dow() on 1999-11-03 Gregorian' );
cmp_ok( $dts->doy(), '==', 316, 'doy() on 1999-11-03 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-11-03 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-11-03 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-11-03 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-11-03 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-11-03 Gregorian' );
cmp_ok( $dts->mday(), '==', 12, 'mday() on 1999-11-03 Gregorian' );
cmp_ok( $dts->month(), '==', 11, 'month() on 1999-11-03 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Blotmath', 'month_name() on 1999-11-03 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-11-03 Gregorian' );
Highday 12 Blotmath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63077270400, 'utc_rd_as_seconds() on 1999-11-03 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730061,
  0,
  0
]
, 'utc_rd_values() on 1999-11-03 Gregorian' );
cmp_ok( $dts->wday(), '==', 7, 'wday() on 1999-11-03 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  45
]
, 'week() on 1999-11-03 Gregorian' );
cmp_ok( $dts->week_number(), '==', 45, 'week_number() on 1999-11-03 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-11-03 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-11-03 Gregorian' );

$epoch = timegm( 0, 0, 0, 4, 11 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 11,
	day	=> 4,
    ),
);
cmp_ok( $dts->day(), '==', 13, 'day() on 1999-11-04 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sterday', 'day_name() on 1999-11-04 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sterrendei', 'day_name_trad() on 1999-11-04 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 13, 'day_of_month() on 1999-11-04 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 1, 'day_of_week() on 1999-11-04 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 317, 'day_of_year() on 1999-11-04 Gregorian' );
cmp_ok( $dts->dow(), '==', 1, 'dow() on 1999-11-04 Gregorian' );
cmp_ok( $dts->doy(), '==', 317, 'doy() on 1999-11-04 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-11-04 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-11-04 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-11-04 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-11-04 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-11-04 Gregorian' );
cmp_ok( $dts->mday(), '==', 13, 'mday() on 1999-11-04 Gregorian' );
cmp_ok( $dts->month(), '==', 11, 'month() on 1999-11-04 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Blotmath', 'month_name() on 1999-11-04 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-11-04 Gregorian' );
Sterday 13 Blotmath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63077356800, 'utc_rd_as_seconds() on 1999-11-04 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730062,
  0,
  0
]
, 'utc_rd_values() on 1999-11-04 Gregorian' );
cmp_ok( $dts->wday(), '==', 1, 'wday() on 1999-11-04 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  46
]
, 'week() on 1999-11-04 Gregorian' );
cmp_ok( $dts->week_number(), '==', 46, 'week_number() on 1999-11-04 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-11-04 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-11-04 Gregorian' );

$epoch = timegm( 0, 0, 0, 5, 11 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 11,
	day	=> 5,
    ),
);
cmp_ok( $dts->day(), '==', 14, 'day() on 1999-11-05 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sunday', 'day_name() on 1999-11-05 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sunnendei', 'day_name_trad() on 1999-11-05 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 14, 'day_of_month() on 1999-11-05 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 2, 'day_of_week() on 1999-11-05 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 318, 'day_of_year() on 1999-11-05 Gregorian' );
cmp_ok( $dts->dow(), '==', 2, 'dow() on 1999-11-05 Gregorian' );
cmp_ok( $dts->doy(), '==', 318, 'doy() on 1999-11-05 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-11-05 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-11-05 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-11-05 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-11-05 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-11-05 Gregorian' );
cmp_ok( $dts->mday(), '==', 14, 'mday() on 1999-11-05 Gregorian' );
cmp_ok( $dts->month(), '==', 11, 'month() on 1999-11-05 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Blotmath', 'month_name() on 1999-11-05 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-11-05 Gregorian' );
Sunday 14 Blotmath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63077443200, 'utc_rd_as_seconds() on 1999-11-05 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730063,
  0,
  0
]
, 'utc_rd_values() on 1999-11-05 Gregorian' );
cmp_ok( $dts->wday(), '==', 2, 'wday() on 1999-11-05 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  46
]
, 'week() on 1999-11-05 Gregorian' );
cmp_ok( $dts->week_number(), '==', 46, 'week_number() on 1999-11-05 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-11-05 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-11-05 Gregorian' );

$epoch = timegm( 0, 0, 0, 6, 11 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 11,
	day	=> 6,
    ),
);
cmp_ok( $dts->day(), '==', 15, 'day() on 1999-11-06 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Monday', 'day_name() on 1999-11-06 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Monendei', 'day_name_trad() on 1999-11-06 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 15, 'day_of_month() on 1999-11-06 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 3, 'day_of_week() on 1999-11-06 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 319, 'day_of_year() on 1999-11-06 Gregorian' );
cmp_ok( $dts->dow(), '==', 3, 'dow() on 1999-11-06 Gregorian' );
cmp_ok( $dts->doy(), '==', 319, 'doy() on 1999-11-06 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-11-06 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-11-06 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-11-06 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-11-06 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-11-06 Gregorian' );
cmp_ok( $dts->mday(), '==', 15, 'mday() on 1999-11-06 Gregorian' );
cmp_ok( $dts->month(), '==', 11, 'month() on 1999-11-06 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Blotmath', 'month_name() on 1999-11-06 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-11-06 Gregorian' );
Monday 15 Blotmath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63077529600, 'utc_rd_as_seconds() on 1999-11-06 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730064,
  0,
  0
]
, 'utc_rd_values() on 1999-11-06 Gregorian' );
cmp_ok( $dts->wday(), '==', 3, 'wday() on 1999-11-06 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  46
]
, 'week() on 1999-11-06 Gregorian' );
cmp_ok( $dts->week_number(), '==', 46, 'week_number() on 1999-11-06 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-11-06 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-11-06 Gregorian' );

$epoch = timegm( 0, 0, 0, 7, 11 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 11,
	day	=> 7,
    ),
);
cmp_ok( $dts->day(), '==', 16, 'day() on 1999-11-07 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Trewsday', 'day_name() on 1999-11-07 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Trewesdei', 'day_name_trad() on 1999-11-07 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 16, 'day_of_month() on 1999-11-07 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 4, 'day_of_week() on 1999-11-07 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 320, 'day_of_year() on 1999-11-07 Gregorian' );
cmp_ok( $dts->dow(), '==', 4, 'dow() on 1999-11-07 Gregorian' );
cmp_ok( $dts->doy(), '==', 320, 'doy() on 1999-11-07 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-11-07 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-11-07 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-11-07 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-11-07 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-11-07 Gregorian' );
cmp_ok( $dts->mday(), '==', 16, 'mday() on 1999-11-07 Gregorian' );
cmp_ok( $dts->month(), '==', 11, 'month() on 1999-11-07 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Blotmath', 'month_name() on 1999-11-07 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-11-07 Gregorian' );
Trewsday 16 Blotmath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63077616000, 'utc_rd_as_seconds() on 1999-11-07 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730065,
  0,
  0
]
, 'utc_rd_values() on 1999-11-07 Gregorian' );
cmp_ok( $dts->wday(), '==', 4, 'wday() on 1999-11-07 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  46
]
, 'week() on 1999-11-07 Gregorian' );
cmp_ok( $dts->week_number(), '==', 46, 'week_number() on 1999-11-07 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-11-07 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-11-07 Gregorian' );

$epoch = timegm( 0, 0, 0, 8, 11 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 11,
	day	=> 8,
    ),
);
cmp_ok( $dts->day(), '==', 17, 'day() on 1999-11-08 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Hevensday', 'day_name() on 1999-11-08 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Hevenesdei', 'day_name_trad() on 1999-11-08 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 17, 'day_of_month() on 1999-11-08 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 5, 'day_of_week() on 1999-11-08 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 321, 'day_of_year() on 1999-11-08 Gregorian' );
cmp_ok( $dts->dow(), '==', 5, 'dow() on 1999-11-08 Gregorian' );
cmp_ok( $dts->doy(), '==', 321, 'doy() on 1999-11-08 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-11-08 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-11-08 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-11-08 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-11-08 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-11-08 Gregorian' );
cmp_ok( $dts->mday(), '==', 17, 'mday() on 1999-11-08 Gregorian' );
cmp_ok( $dts->month(), '==', 11, 'month() on 1999-11-08 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Blotmath', 'month_name() on 1999-11-08 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-11-08 Gregorian' );
Hevensday 17 Blotmath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63077702400, 'utc_rd_as_seconds() on 1999-11-08 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730066,
  0,
  0
]
, 'utc_rd_values() on 1999-11-08 Gregorian' );
cmp_ok( $dts->wday(), '==', 5, 'wday() on 1999-11-08 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  46
]
, 'week() on 1999-11-08 Gregorian' );
cmp_ok( $dts->week_number(), '==', 46, 'week_number() on 1999-11-08 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-11-08 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-11-08 Gregorian' );

$epoch = timegm( 0, 0, 0, 9, 11 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 11,
	day	=> 9,
    ),
);
cmp_ok( $dts->day(), '==', 18, 'day() on 1999-11-09 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Mersday', 'day_name() on 1999-11-09 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Meresdei', 'day_name_trad() on 1999-11-09 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 18, 'day_of_month() on 1999-11-09 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 6, 'day_of_week() on 1999-11-09 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 322, 'day_of_year() on 1999-11-09 Gregorian' );
cmp_ok( $dts->dow(), '==', 6, 'dow() on 1999-11-09 Gregorian' );
cmp_ok( $dts->doy(), '==', 322, 'doy() on 1999-11-09 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-11-09 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-11-09 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-11-09 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-11-09 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-11-09 Gregorian' );
cmp_ok( $dts->mday(), '==', 18, 'mday() on 1999-11-09 Gregorian' );
cmp_ok( $dts->month(), '==', 11, 'month() on 1999-11-09 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Blotmath', 'month_name() on 1999-11-09 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-11-09 Gregorian' );
Mersday 18 Blotmath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63077788800, 'utc_rd_as_seconds() on 1999-11-09 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730067,
  0,
  0
]
, 'utc_rd_values() on 1999-11-09 Gregorian' );
cmp_ok( $dts->wday(), '==', 6, 'wday() on 1999-11-09 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  46
]
, 'week() on 1999-11-09 Gregorian' );
cmp_ok( $dts->week_number(), '==', 46, 'week_number() on 1999-11-09 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-11-09 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-11-09 Gregorian' );

$epoch = timegm( 0, 0, 0, 10, 11 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 11,
	day	=> 10,
    ),
);
cmp_ok( $dts->day(), '==', 19, 'day() on 1999-11-10 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Highday', 'day_name() on 1999-11-10 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Highdei', 'day_name_trad() on 1999-11-10 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 19, 'day_of_month() on 1999-11-10 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 7, 'day_of_week() on 1999-11-10 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 323, 'day_of_year() on 1999-11-10 Gregorian' );
cmp_ok( $dts->dow(), '==', 7, 'dow() on 1999-11-10 Gregorian' );
cmp_ok( $dts->doy(), '==', 323, 'doy() on 1999-11-10 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-11-10 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-11-10 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-11-10 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-11-10 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-11-10 Gregorian' );
cmp_ok( $dts->mday(), '==', 19, 'mday() on 1999-11-10 Gregorian' );
cmp_ok( $dts->month(), '==', 11, 'month() on 1999-11-10 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Blotmath', 'month_name() on 1999-11-10 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-11-10 Gregorian' );
Highday 19 Blotmath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63077875200, 'utc_rd_as_seconds() on 1999-11-10 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730068,
  0,
  0
]
, 'utc_rd_values() on 1999-11-10 Gregorian' );
cmp_ok( $dts->wday(), '==', 7, 'wday() on 1999-11-10 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  46
]
, 'week() on 1999-11-10 Gregorian' );
cmp_ok( $dts->week_number(), '==', 46, 'week_number() on 1999-11-10 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-11-10 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-11-10 Gregorian' );

$epoch = timegm( 0, 0, 0, 11, 11 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 11,
	day	=> 11,
    ),
);
cmp_ok( $dts->day(), '==', 20, 'day() on 1999-11-11 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sterday', 'day_name() on 1999-11-11 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sterrendei', 'day_name_trad() on 1999-11-11 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 20, 'day_of_month() on 1999-11-11 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 1, 'day_of_week() on 1999-11-11 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 324, 'day_of_year() on 1999-11-11 Gregorian' );
cmp_ok( $dts->dow(), '==', 1, 'dow() on 1999-11-11 Gregorian' );
cmp_ok( $dts->doy(), '==', 324, 'doy() on 1999-11-11 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-11-11 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-11-11 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-11-11 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-11-11 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-11-11 Gregorian' );
cmp_ok( $dts->mday(), '==', 20, 'mday() on 1999-11-11 Gregorian' );
cmp_ok( $dts->month(), '==', 11, 'month() on 1999-11-11 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Blotmath', 'month_name() on 1999-11-11 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-11-11 Gregorian' );
Sterday 20 Blotmath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63077961600, 'utc_rd_as_seconds() on 1999-11-11 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730069,
  0,
  0
]
, 'utc_rd_values() on 1999-11-11 Gregorian' );
cmp_ok( $dts->wday(), '==', 1, 'wday() on 1999-11-11 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  47
]
, 'week() on 1999-11-11 Gregorian' );
cmp_ok( $dts->week_number(), '==', 47, 'week_number() on 1999-11-11 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-11-11 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-11-11 Gregorian' );

$epoch = timegm( 0, 0, 0, 12, 11 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 11,
	day	=> 12,
    ),
);
cmp_ok( $dts->day(), '==', 21, 'day() on 1999-11-12 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sunday', 'day_name() on 1999-11-12 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sunnendei', 'day_name_trad() on 1999-11-12 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 21, 'day_of_month() on 1999-11-12 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 2, 'day_of_week() on 1999-11-12 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 325, 'day_of_year() on 1999-11-12 Gregorian' );
cmp_ok( $dts->dow(), '==', 2, 'dow() on 1999-11-12 Gregorian' );
cmp_ok( $dts->doy(), '==', 325, 'doy() on 1999-11-12 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-11-12 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-11-12 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-11-12 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-11-12 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-11-12 Gregorian' );
cmp_ok( $dts->mday(), '==', 21, 'mday() on 1999-11-12 Gregorian' );
cmp_ok( $dts->month(), '==', 11, 'month() on 1999-11-12 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Blotmath', 'month_name() on 1999-11-12 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-11-12 Gregorian' );
Sunday 21 Blotmath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63078048000, 'utc_rd_as_seconds() on 1999-11-12 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730070,
  0,
  0
]
, 'utc_rd_values() on 1999-11-12 Gregorian' );
cmp_ok( $dts->wday(), '==', 2, 'wday() on 1999-11-12 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  47
]
, 'week() on 1999-11-12 Gregorian' );
cmp_ok( $dts->week_number(), '==', 47, 'week_number() on 1999-11-12 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-11-12 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-11-12 Gregorian' );

$epoch = timegm( 0, 0, 0, 13, 11 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 11,
	day	=> 13,
    ),
);
cmp_ok( $dts->day(), '==', 22, 'day() on 1999-11-13 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Monday', 'day_name() on 1999-11-13 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Monendei', 'day_name_trad() on 1999-11-13 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 22, 'day_of_month() on 1999-11-13 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 3, 'day_of_week() on 1999-11-13 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 326, 'day_of_year() on 1999-11-13 Gregorian' );
cmp_ok( $dts->dow(), '==', 3, 'dow() on 1999-11-13 Gregorian' );
cmp_ok( $dts->doy(), '==', 326, 'doy() on 1999-11-13 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-11-13 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-11-13 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-11-13 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-11-13 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-11-13 Gregorian' );
cmp_ok( $dts->mday(), '==', 22, 'mday() on 1999-11-13 Gregorian' );
cmp_ok( $dts->month(), '==', 11, 'month() on 1999-11-13 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Blotmath', 'month_name() on 1999-11-13 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-11-13 Gregorian' );
Monday 22 Blotmath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63078134400, 'utc_rd_as_seconds() on 1999-11-13 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730071,
  0,
  0
]
, 'utc_rd_values() on 1999-11-13 Gregorian' );
cmp_ok( $dts->wday(), '==', 3, 'wday() on 1999-11-13 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  47
]
, 'week() on 1999-11-13 Gregorian' );
cmp_ok( $dts->week_number(), '==', 47, 'week_number() on 1999-11-13 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-11-13 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-11-13 Gregorian' );

$epoch = timegm( 0, 0, 0, 14, 11 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 11,
	day	=> 14,
    ),
);
cmp_ok( $dts->day(), '==', 23, 'day() on 1999-11-14 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Trewsday', 'day_name() on 1999-11-14 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Trewesdei', 'day_name_trad() on 1999-11-14 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 23, 'day_of_month() on 1999-11-14 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 4, 'day_of_week() on 1999-11-14 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 327, 'day_of_year() on 1999-11-14 Gregorian' );
cmp_ok( $dts->dow(), '==', 4, 'dow() on 1999-11-14 Gregorian' );
cmp_ok( $dts->doy(), '==', 327, 'doy() on 1999-11-14 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-11-14 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-11-14 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-11-14 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-11-14 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-11-14 Gregorian' );
cmp_ok( $dts->mday(), '==', 23, 'mday() on 1999-11-14 Gregorian' );
cmp_ok( $dts->month(), '==', 11, 'month() on 1999-11-14 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Blotmath', 'month_name() on 1999-11-14 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-11-14 Gregorian' );
Trewsday 23 Blotmath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63078220800, 'utc_rd_as_seconds() on 1999-11-14 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730072,
  0,
  0
]
, 'utc_rd_values() on 1999-11-14 Gregorian' );
cmp_ok( $dts->wday(), '==', 4, 'wday() on 1999-11-14 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  47
]
, 'week() on 1999-11-14 Gregorian' );
cmp_ok( $dts->week_number(), '==', 47, 'week_number() on 1999-11-14 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-11-14 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-11-14 Gregorian' );

$epoch = timegm( 0, 0, 0, 15, 11 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 11,
	day	=> 15,
    ),
);
cmp_ok( $dts->day(), '==', 24, 'day() on 1999-11-15 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Hevensday', 'day_name() on 1999-11-15 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Hevenesdei', 'day_name_trad() on 1999-11-15 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 24, 'day_of_month() on 1999-11-15 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 5, 'day_of_week() on 1999-11-15 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 328, 'day_of_year() on 1999-11-15 Gregorian' );
cmp_ok( $dts->dow(), '==', 5, 'dow() on 1999-11-15 Gregorian' );
cmp_ok( $dts->doy(), '==', 328, 'doy() on 1999-11-15 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-11-15 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-11-15 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-11-15 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-11-15 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-11-15 Gregorian' );
cmp_ok( $dts->mday(), '==', 24, 'mday() on 1999-11-15 Gregorian' );
cmp_ok( $dts->month(), '==', 11, 'month() on 1999-11-15 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Blotmath', 'month_name() on 1999-11-15 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-11-15 Gregorian' );
Hevensday 24 Blotmath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63078307200, 'utc_rd_as_seconds() on 1999-11-15 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730073,
  0,
  0
]
, 'utc_rd_values() on 1999-11-15 Gregorian' );
cmp_ok( $dts->wday(), '==', 5, 'wday() on 1999-11-15 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  47
]
, 'week() on 1999-11-15 Gregorian' );
cmp_ok( $dts->week_number(), '==', 47, 'week_number() on 1999-11-15 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-11-15 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-11-15 Gregorian' );

$epoch = timegm( 0, 0, 0, 16, 11 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 11,
	day	=> 16,
    ),
);
cmp_ok( $dts->day(), '==', 25, 'day() on 1999-11-16 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Mersday', 'day_name() on 1999-11-16 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Meresdei', 'day_name_trad() on 1999-11-16 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 25, 'day_of_month() on 1999-11-16 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 6, 'day_of_week() on 1999-11-16 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 329, 'day_of_year() on 1999-11-16 Gregorian' );
cmp_ok( $dts->dow(), '==', 6, 'dow() on 1999-11-16 Gregorian' );
cmp_ok( $dts->doy(), '==', 329, 'doy() on 1999-11-16 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-11-16 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-11-16 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-11-16 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-11-16 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-11-16 Gregorian' );
cmp_ok( $dts->mday(), '==', 25, 'mday() on 1999-11-16 Gregorian' );
cmp_ok( $dts->month(), '==', 11, 'month() on 1999-11-16 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Blotmath', 'month_name() on 1999-11-16 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-11-16 Gregorian' );
Mersday 25 Blotmath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63078393600, 'utc_rd_as_seconds() on 1999-11-16 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730074,
  0,
  0
]
, 'utc_rd_values() on 1999-11-16 Gregorian' );
cmp_ok( $dts->wday(), '==', 6, 'wday() on 1999-11-16 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  47
]
, 'week() on 1999-11-16 Gregorian' );
cmp_ok( $dts->week_number(), '==', 47, 'week_number() on 1999-11-16 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-11-16 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-11-16 Gregorian' );

$epoch = timegm( 0, 0, 0, 17, 11 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 11,
	day	=> 17,
    ),
);
cmp_ok( $dts->day(), '==', 26, 'day() on 1999-11-17 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Highday', 'day_name() on 1999-11-17 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Highdei', 'day_name_trad() on 1999-11-17 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 26, 'day_of_month() on 1999-11-17 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 7, 'day_of_week() on 1999-11-17 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 330, 'day_of_year() on 1999-11-17 Gregorian' );
cmp_ok( $dts->dow(), '==', 7, 'dow() on 1999-11-17 Gregorian' );
cmp_ok( $dts->doy(), '==', 330, 'doy() on 1999-11-17 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-11-17 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-11-17 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-11-17 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-11-17 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-11-17 Gregorian' );
cmp_ok( $dts->mday(), '==', 26, 'mday() on 1999-11-17 Gregorian' );
cmp_ok( $dts->month(), '==', 11, 'month() on 1999-11-17 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Blotmath', 'month_name() on 1999-11-17 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-11-17 Gregorian' );
Highday 26 Blotmath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63078480000, 'utc_rd_as_seconds() on 1999-11-17 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730075,
  0,
  0
]
, 'utc_rd_values() on 1999-11-17 Gregorian' );
cmp_ok( $dts->wday(), '==', 7, 'wday() on 1999-11-17 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  47
]
, 'week() on 1999-11-17 Gregorian' );
cmp_ok( $dts->week_number(), '==', 47, 'week_number() on 1999-11-17 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-11-17 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-11-17 Gregorian' );

$epoch = timegm( 0, 0, 0, 18, 11 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 11,
	day	=> 18,
    ),
);
cmp_ok( $dts->day(), '==', 27, 'day() on 1999-11-18 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sterday', 'day_name() on 1999-11-18 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sterrendei', 'day_name_trad() on 1999-11-18 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 27, 'day_of_month() on 1999-11-18 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 1, 'day_of_week() on 1999-11-18 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 331, 'day_of_year() on 1999-11-18 Gregorian' );
cmp_ok( $dts->dow(), '==', 1, 'dow() on 1999-11-18 Gregorian' );
cmp_ok( $dts->doy(), '==', 331, 'doy() on 1999-11-18 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-11-18 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-11-18 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-11-18 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-11-18 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-11-18 Gregorian' );
cmp_ok( $dts->mday(), '==', 27, 'mday() on 1999-11-18 Gregorian' );
cmp_ok( $dts->month(), '==', 11, 'month() on 1999-11-18 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Blotmath', 'month_name() on 1999-11-18 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-11-18 Gregorian' );
Sterday 27 Blotmath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63078566400, 'utc_rd_as_seconds() on 1999-11-18 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730076,
  0,
  0
]
, 'utc_rd_values() on 1999-11-18 Gregorian' );
cmp_ok( $dts->wday(), '==', 1, 'wday() on 1999-11-18 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  48
]
, 'week() on 1999-11-18 Gregorian' );
cmp_ok( $dts->week_number(), '==', 48, 'week_number() on 1999-11-18 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-11-18 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-11-18 Gregorian' );

$epoch = timegm( 0, 0, 0, 19, 11 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 11,
	day	=> 19,
    ),
);
cmp_ok( $dts->day(), '==', 28, 'day() on 1999-11-19 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sunday', 'day_name() on 1999-11-19 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sunnendei', 'day_name_trad() on 1999-11-19 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 28, 'day_of_month() on 1999-11-19 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 2, 'day_of_week() on 1999-11-19 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 332, 'day_of_year() on 1999-11-19 Gregorian' );
cmp_ok( $dts->dow(), '==', 2, 'dow() on 1999-11-19 Gregorian' );
cmp_ok( $dts->doy(), '==', 332, 'doy() on 1999-11-19 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-11-19 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-11-19 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-11-19 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-11-19 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-11-19 Gregorian' );
cmp_ok( $dts->mday(), '==', 28, 'mday() on 1999-11-19 Gregorian' );
cmp_ok( $dts->month(), '==', 11, 'month() on 1999-11-19 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Blotmath', 'month_name() on 1999-11-19 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-11-19 Gregorian' );
Sunday 28 Blotmath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63078652800, 'utc_rd_as_seconds() on 1999-11-19 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730077,
  0,
  0
]
, 'utc_rd_values() on 1999-11-19 Gregorian' );
cmp_ok( $dts->wday(), '==', 2, 'wday() on 1999-11-19 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  48
]
, 'week() on 1999-11-19 Gregorian' );
cmp_ok( $dts->week_number(), '==', 48, 'week_number() on 1999-11-19 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-11-19 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-11-19 Gregorian' );

$epoch = timegm( 0, 0, 0, 20, 11 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 11,
	day	=> 20,
    ),
);
cmp_ok( $dts->day(), '==', 29, 'day() on 1999-11-20 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Monday', 'day_name() on 1999-11-20 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Monendei', 'day_name_trad() on 1999-11-20 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 29, 'day_of_month() on 1999-11-20 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 3, 'day_of_week() on 1999-11-20 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 333, 'day_of_year() on 1999-11-20 Gregorian' );
cmp_ok( $dts->dow(), '==', 3, 'dow() on 1999-11-20 Gregorian' );
cmp_ok( $dts->doy(), '==', 333, 'doy() on 1999-11-20 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-11-20 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-11-20 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-11-20 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-11-20 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-11-20 Gregorian' );
cmp_ok( $dts->mday(), '==', 29, 'mday() on 1999-11-20 Gregorian' );
cmp_ok( $dts->month(), '==', 11, 'month() on 1999-11-20 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Blotmath', 'month_name() on 1999-11-20 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-11-20 Gregorian' );
Monday 29 Blotmath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63078739200, 'utc_rd_as_seconds() on 1999-11-20 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730078,
  0,
  0
]
, 'utc_rd_values() on 1999-11-20 Gregorian' );
cmp_ok( $dts->wday(), '==', 3, 'wday() on 1999-11-20 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  48
]
, 'week() on 1999-11-20 Gregorian' );
cmp_ok( $dts->week_number(), '==', 48, 'week_number() on 1999-11-20 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-11-20 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-11-20 Gregorian' );

$epoch = timegm( 0, 0, 0, 21, 11 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 11,
	day	=> 21,
    ),
);
cmp_ok( $dts->day(), '==', 30, 'day() on 1999-11-21 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Trewsday', 'day_name() on 1999-11-21 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Trewesdei', 'day_name_trad() on 1999-11-21 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 30, 'day_of_month() on 1999-11-21 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 4, 'day_of_week() on 1999-11-21 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 334, 'day_of_year() on 1999-11-21 Gregorian' );
cmp_ok( $dts->dow(), '==', 4, 'dow() on 1999-11-21 Gregorian' );
cmp_ok( $dts->doy(), '==', 334, 'doy() on 1999-11-21 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-11-21 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-11-21 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-11-21 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-11-21 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-11-21 Gregorian' );
cmp_ok( $dts->mday(), '==', 30, 'mday() on 1999-11-21 Gregorian' );
cmp_ok( $dts->month(), '==', 11, 'month() on 1999-11-21 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Blotmath', 'month_name() on 1999-11-21 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-11-21 Gregorian' );
Trewsday 30 Blotmath 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63078825600, 'utc_rd_as_seconds() on 1999-11-21 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730079,
  0,
  0
]
, 'utc_rd_values() on 1999-11-21 Gregorian' );
cmp_ok( $dts->wday(), '==', 4, 'wday() on 1999-11-21 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  48
]
, 'week() on 1999-11-21 Gregorian' );
cmp_ok( $dts->week_number(), '==', 48, 'week_number() on 1999-11-21 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-11-21 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-11-21 Gregorian' );

$epoch = timegm( 0, 0, 0, 22, 11 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 11,
	day	=> 22,
    ),
);
cmp_ok( $dts->day(), '==', 1, 'day() on 1999-11-22 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Hevensday', 'day_name() on 1999-11-22 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Hevenesdei', 'day_name_trad() on 1999-11-22 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 1, 'day_of_month() on 1999-11-22 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 5, 'day_of_week() on 1999-11-22 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 335, 'day_of_year() on 1999-11-22 Gregorian' );
cmp_ok( $dts->dow(), '==', 5, 'dow() on 1999-11-22 Gregorian' );
cmp_ok( $dts->doy(), '==', 335, 'doy() on 1999-11-22 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-11-22 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-11-22 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-11-22 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-11-22 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-11-22 Gregorian' );
cmp_ok( $dts->mday(), '==', 1, 'mday() on 1999-11-22 Gregorian' );
cmp_ok( $dts->month(), '==', 12, 'month() on 1999-11-22 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Foreyule', 'month_name() on 1999-11-22 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-11-22 Gregorian' );
Hevensday 1 Foreyule 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63078912000, 'utc_rd_as_seconds() on 1999-11-22 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730080,
  0,
  0
]
, 'utc_rd_values() on 1999-11-22 Gregorian' );
cmp_ok( $dts->wday(), '==', 5, 'wday() on 1999-11-22 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  48
]
, 'week() on 1999-11-22 Gregorian' );
cmp_ok( $dts->week_number(), '==', 48, 'week_number() on 1999-11-22 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-11-22 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-11-22 Gregorian' );

$epoch = timegm( 0, 0, 0, 23, 11 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 11,
	day	=> 23,
    ),
);
cmp_ok( $dts->day(), '==', 2, 'day() on 1999-11-23 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Mersday', 'day_name() on 1999-11-23 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Meresdei', 'day_name_trad() on 1999-11-23 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 2, 'day_of_month() on 1999-11-23 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 6, 'day_of_week() on 1999-11-23 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 336, 'day_of_year() on 1999-11-23 Gregorian' );
cmp_ok( $dts->dow(), '==', 6, 'dow() on 1999-11-23 Gregorian' );
cmp_ok( $dts->doy(), '==', 336, 'doy() on 1999-11-23 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-11-23 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-11-23 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-11-23 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-11-23 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-11-23 Gregorian' );
cmp_ok( $dts->mday(), '==', 2, 'mday() on 1999-11-23 Gregorian' );
cmp_ok( $dts->month(), '==', 12, 'month() on 1999-11-23 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Foreyule', 'month_name() on 1999-11-23 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-11-23 Gregorian' );
Mersday 2 Foreyule 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63078998400, 'utc_rd_as_seconds() on 1999-11-23 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730081,
  0,
  0
]
, 'utc_rd_values() on 1999-11-23 Gregorian' );
cmp_ok( $dts->wday(), '==', 6, 'wday() on 1999-11-23 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  48
]
, 'week() on 1999-11-23 Gregorian' );
cmp_ok( $dts->week_number(), '==', 48, 'week_number() on 1999-11-23 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-11-23 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-11-23 Gregorian' );

$epoch = timegm( 0, 0, 0, 24, 11 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 11,
	day	=> 24,
    ),
);
cmp_ok( $dts->day(), '==', 3, 'day() on 1999-11-24 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Highday', 'day_name() on 1999-11-24 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Highdei', 'day_name_trad() on 1999-11-24 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 3, 'day_of_month() on 1999-11-24 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 7, 'day_of_week() on 1999-11-24 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 337, 'day_of_year() on 1999-11-24 Gregorian' );
cmp_ok( $dts->dow(), '==', 7, 'dow() on 1999-11-24 Gregorian' );
cmp_ok( $dts->doy(), '==', 337, 'doy() on 1999-11-24 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-11-24 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-11-24 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-11-24 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-11-24 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-11-24 Gregorian' );
cmp_ok( $dts->mday(), '==', 3, 'mday() on 1999-11-24 Gregorian' );
cmp_ok( $dts->month(), '==', 12, 'month() on 1999-11-24 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Foreyule', 'month_name() on 1999-11-24 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-11-24 Gregorian' );
Highday 3 Foreyule 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63079084800, 'utc_rd_as_seconds() on 1999-11-24 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730082,
  0,
  0
]
, 'utc_rd_values() on 1999-11-24 Gregorian' );
cmp_ok( $dts->wday(), '==', 7, 'wday() on 1999-11-24 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  48
]
, 'week() on 1999-11-24 Gregorian' );
cmp_ok( $dts->week_number(), '==', 48, 'week_number() on 1999-11-24 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-11-24 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-11-24 Gregorian' );

$epoch = timegm( 0, 0, 0, 25, 11 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 11,
	day	=> 25,
    ),
);
cmp_ok( $dts->day(), '==', 4, 'day() on 1999-11-25 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sterday', 'day_name() on 1999-11-25 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sterrendei', 'day_name_trad() on 1999-11-25 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 4, 'day_of_month() on 1999-11-25 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 1, 'day_of_week() on 1999-11-25 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 338, 'day_of_year() on 1999-11-25 Gregorian' );
cmp_ok( $dts->dow(), '==', 1, 'dow() on 1999-11-25 Gregorian' );
cmp_ok( $dts->doy(), '==', 338, 'doy() on 1999-11-25 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-11-25 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-11-25 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-11-25 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-11-25 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-11-25 Gregorian' );
cmp_ok( $dts->mday(), '==', 4, 'mday() on 1999-11-25 Gregorian' );
cmp_ok( $dts->month(), '==', 12, 'month() on 1999-11-25 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Foreyule', 'month_name() on 1999-11-25 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-11-25 Gregorian' );
Sterday 4 Foreyule 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63079171200, 'utc_rd_as_seconds() on 1999-11-25 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730083,
  0,
  0
]
, 'utc_rd_values() on 1999-11-25 Gregorian' );
cmp_ok( $dts->wday(), '==', 1, 'wday() on 1999-11-25 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  49
]
, 'week() on 1999-11-25 Gregorian' );
cmp_ok( $dts->week_number(), '==', 49, 'week_number() on 1999-11-25 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-11-25 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-11-25 Gregorian' );

$epoch = timegm( 0, 0, 0, 26, 11 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 11,
	day	=> 26,
    ),
);
cmp_ok( $dts->day(), '==', 5, 'day() on 1999-11-26 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sunday', 'day_name() on 1999-11-26 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sunnendei', 'day_name_trad() on 1999-11-26 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 5, 'day_of_month() on 1999-11-26 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 2, 'day_of_week() on 1999-11-26 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 339, 'day_of_year() on 1999-11-26 Gregorian' );
cmp_ok( $dts->dow(), '==', 2, 'dow() on 1999-11-26 Gregorian' );
cmp_ok( $dts->doy(), '==', 339, 'doy() on 1999-11-26 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-11-26 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-11-26 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-11-26 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-11-26 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-11-26 Gregorian' );
cmp_ok( $dts->mday(), '==', 5, 'mday() on 1999-11-26 Gregorian' );
cmp_ok( $dts->month(), '==', 12, 'month() on 1999-11-26 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Foreyule', 'month_name() on 1999-11-26 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-11-26 Gregorian' );
Sunday 5 Foreyule 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63079257600, 'utc_rd_as_seconds() on 1999-11-26 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730084,
  0,
  0
]
, 'utc_rd_values() on 1999-11-26 Gregorian' );
cmp_ok( $dts->wday(), '==', 2, 'wday() on 1999-11-26 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  49
]
, 'week() on 1999-11-26 Gregorian' );
cmp_ok( $dts->week_number(), '==', 49, 'week_number() on 1999-11-26 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-11-26 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-11-26 Gregorian' );

$epoch = timegm( 0, 0, 0, 27, 11 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 11,
	day	=> 27,
    ),
);
cmp_ok( $dts->day(), '==', 6, 'day() on 1999-11-27 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Monday', 'day_name() on 1999-11-27 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Monendei', 'day_name_trad() on 1999-11-27 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 6, 'day_of_month() on 1999-11-27 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 3, 'day_of_week() on 1999-11-27 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 340, 'day_of_year() on 1999-11-27 Gregorian' );
cmp_ok( $dts->dow(), '==', 3, 'dow() on 1999-11-27 Gregorian' );
cmp_ok( $dts->doy(), '==', 340, 'doy() on 1999-11-27 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-11-27 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-11-27 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-11-27 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-11-27 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-11-27 Gregorian' );
cmp_ok( $dts->mday(), '==', 6, 'mday() on 1999-11-27 Gregorian' );
cmp_ok( $dts->month(), '==', 12, 'month() on 1999-11-27 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Foreyule', 'month_name() on 1999-11-27 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-11-27 Gregorian' );
Monday 6 Foreyule 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63079344000, 'utc_rd_as_seconds() on 1999-11-27 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730085,
  0,
  0
]
, 'utc_rd_values() on 1999-11-27 Gregorian' );
cmp_ok( $dts->wday(), '==', 3, 'wday() on 1999-11-27 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  49
]
, 'week() on 1999-11-27 Gregorian' );
cmp_ok( $dts->week_number(), '==', 49, 'week_number() on 1999-11-27 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-11-27 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-11-27 Gregorian' );

$epoch = timegm( 0, 0, 0, 28, 11 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 11,
	day	=> 28,
    ),
);
cmp_ok( $dts->day(), '==', 7, 'day() on 1999-11-28 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Trewsday', 'day_name() on 1999-11-28 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Trewesdei', 'day_name_trad() on 1999-11-28 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 7, 'day_of_month() on 1999-11-28 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 4, 'day_of_week() on 1999-11-28 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 341, 'day_of_year() on 1999-11-28 Gregorian' );
cmp_ok( $dts->dow(), '==', 4, 'dow() on 1999-11-28 Gregorian' );
cmp_ok( $dts->doy(), '==', 341, 'doy() on 1999-11-28 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-11-28 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-11-28 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-11-28 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-11-28 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-11-28 Gregorian' );
cmp_ok( $dts->mday(), '==', 7, 'mday() on 1999-11-28 Gregorian' );
cmp_ok( $dts->month(), '==', 12, 'month() on 1999-11-28 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Foreyule', 'month_name() on 1999-11-28 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-11-28 Gregorian' );
Trewsday 7 Foreyule 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63079430400, 'utc_rd_as_seconds() on 1999-11-28 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730086,
  0,
  0
]
, 'utc_rd_values() on 1999-11-28 Gregorian' );
cmp_ok( $dts->wday(), '==', 4, 'wday() on 1999-11-28 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  49
]
, 'week() on 1999-11-28 Gregorian' );
cmp_ok( $dts->week_number(), '==', 49, 'week_number() on 1999-11-28 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-11-28 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-11-28 Gregorian' );

$epoch = timegm( 0, 0, 0, 29, 11 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 11,
	day	=> 29,
    ),
);
cmp_ok( $dts->day(), '==', 8, 'day() on 1999-11-29 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Hevensday', 'day_name() on 1999-11-29 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Hevenesdei', 'day_name_trad() on 1999-11-29 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 8, 'day_of_month() on 1999-11-29 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 5, 'day_of_week() on 1999-11-29 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 342, 'day_of_year() on 1999-11-29 Gregorian' );
cmp_ok( $dts->dow(), '==', 5, 'dow() on 1999-11-29 Gregorian' );
cmp_ok( $dts->doy(), '==', 342, 'doy() on 1999-11-29 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-11-29 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-11-29 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-11-29 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-11-29 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-11-29 Gregorian' );
cmp_ok( $dts->mday(), '==', 8, 'mday() on 1999-11-29 Gregorian' );
cmp_ok( $dts->month(), '==', 12, 'month() on 1999-11-29 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Foreyule', 'month_name() on 1999-11-29 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-11-29 Gregorian' );
Hevensday 8 Foreyule 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63079516800, 'utc_rd_as_seconds() on 1999-11-29 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730087,
  0,
  0
]
, 'utc_rd_values() on 1999-11-29 Gregorian' );
cmp_ok( $dts->wday(), '==', 5, 'wday() on 1999-11-29 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  49
]
, 'week() on 1999-11-29 Gregorian' );
cmp_ok( $dts->week_number(), '==', 49, 'week_number() on 1999-11-29 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-11-29 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-11-29 Gregorian' );

$epoch = timegm( 0, 0, 0, 30, 11 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 11,
	day	=> 30,
    ),
);
cmp_ok( $dts->day(), '==', 9, 'day() on 1999-11-30 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Mersday', 'day_name() on 1999-11-30 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Meresdei', 'day_name_trad() on 1999-11-30 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 9, 'day_of_month() on 1999-11-30 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 6, 'day_of_week() on 1999-11-30 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 343, 'day_of_year() on 1999-11-30 Gregorian' );
cmp_ok( $dts->dow(), '==', 6, 'dow() on 1999-11-30 Gregorian' );
cmp_ok( $dts->doy(), '==', 343, 'doy() on 1999-11-30 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-11-30 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-11-30 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-11-30 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-11-30 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-11-30 Gregorian' );
cmp_ok( $dts->mday(), '==', 9, 'mday() on 1999-11-30 Gregorian' );
cmp_ok( $dts->month(), '==', 12, 'month() on 1999-11-30 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Foreyule', 'month_name() on 1999-11-30 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-11-30 Gregorian' );
Mersday 9 Foreyule 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63079603200, 'utc_rd_as_seconds() on 1999-11-30 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730088,
  0,
  0
]
, 'utc_rd_values() on 1999-11-30 Gregorian' );
cmp_ok( $dts->wday(), '==', 6, 'wday() on 1999-11-30 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  49
]
, 'week() on 1999-11-30 Gregorian' );
cmp_ok( $dts->week_number(), '==', 49, 'week_number() on 1999-11-30 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-11-30 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-11-30 Gregorian' );

$epoch = timegm( 0, 0, 0, 1, 12 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 12,
	day	=> 1,
    ),
);
cmp_ok( $dts->day(), '==', 10, 'day() on 1999-12-01 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Highday', 'day_name() on 1999-12-01 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Highdei', 'day_name_trad() on 1999-12-01 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 10, 'day_of_month() on 1999-12-01 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 7, 'day_of_week() on 1999-12-01 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 344, 'day_of_year() on 1999-12-01 Gregorian' );
cmp_ok( $dts->dow(), '==', 7, 'dow() on 1999-12-01 Gregorian' );
cmp_ok( $dts->doy(), '==', 344, 'doy() on 1999-12-01 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-12-01 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-12-01 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-12-01 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-12-01 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-12-01 Gregorian' );
cmp_ok( $dts->mday(), '==', 10, 'mday() on 1999-12-01 Gregorian' );
cmp_ok( $dts->month(), '==', 12, 'month() on 1999-12-01 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Foreyule', 'month_name() on 1999-12-01 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-12-01 Gregorian' );
Highday 10 Foreyule 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63079689600, 'utc_rd_as_seconds() on 1999-12-01 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730089,
  0,
  0
]
, 'utc_rd_values() on 1999-12-01 Gregorian' );
cmp_ok( $dts->wday(), '==', 7, 'wday() on 1999-12-01 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  49
]
, 'week() on 1999-12-01 Gregorian' );
cmp_ok( $dts->week_number(), '==', 49, 'week_number() on 1999-12-01 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-12-01 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-12-01 Gregorian' );

$epoch = timegm( 0, 0, 0, 2, 12 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 12,
	day	=> 2,
    ),
);
cmp_ok( $dts->day(), '==', 11, 'day() on 1999-12-02 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sterday', 'day_name() on 1999-12-02 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sterrendei', 'day_name_trad() on 1999-12-02 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 11, 'day_of_month() on 1999-12-02 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 1, 'day_of_week() on 1999-12-02 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 345, 'day_of_year() on 1999-12-02 Gregorian' );
cmp_ok( $dts->dow(), '==', 1, 'dow() on 1999-12-02 Gregorian' );
cmp_ok( $dts->doy(), '==', 345, 'doy() on 1999-12-02 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-12-02 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-12-02 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-12-02 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-12-02 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-12-02 Gregorian' );
cmp_ok( $dts->mday(), '==', 11, 'mday() on 1999-12-02 Gregorian' );
cmp_ok( $dts->month(), '==', 12, 'month() on 1999-12-02 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Foreyule', 'month_name() on 1999-12-02 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-12-02 Gregorian' );
Sterday 11 Foreyule 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63079776000, 'utc_rd_as_seconds() on 1999-12-02 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730090,
  0,
  0
]
, 'utc_rd_values() on 1999-12-02 Gregorian' );
cmp_ok( $dts->wday(), '==', 1, 'wday() on 1999-12-02 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  50
]
, 'week() on 1999-12-02 Gregorian' );
cmp_ok( $dts->week_number(), '==', 50, 'week_number() on 1999-12-02 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-12-02 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-12-02 Gregorian' );

$epoch = timegm( 0, 0, 0, 3, 12 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 12,
	day	=> 3,
    ),
);
cmp_ok( $dts->day(), '==', 12, 'day() on 1999-12-03 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sunday', 'day_name() on 1999-12-03 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sunnendei', 'day_name_trad() on 1999-12-03 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 12, 'day_of_month() on 1999-12-03 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 2, 'day_of_week() on 1999-12-03 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 346, 'day_of_year() on 1999-12-03 Gregorian' );
cmp_ok( $dts->dow(), '==', 2, 'dow() on 1999-12-03 Gregorian' );
cmp_ok( $dts->doy(), '==', 346, 'doy() on 1999-12-03 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-12-03 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-12-03 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-12-03 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-12-03 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-12-03 Gregorian' );
cmp_ok( $dts->mday(), '==', 12, 'mday() on 1999-12-03 Gregorian' );
cmp_ok( $dts->month(), '==', 12, 'month() on 1999-12-03 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Foreyule', 'month_name() on 1999-12-03 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-12-03 Gregorian' );
Sunday 12 Foreyule 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63079862400, 'utc_rd_as_seconds() on 1999-12-03 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730091,
  0,
  0
]
, 'utc_rd_values() on 1999-12-03 Gregorian' );
cmp_ok( $dts->wday(), '==', 2, 'wday() on 1999-12-03 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  50
]
, 'week() on 1999-12-03 Gregorian' );
cmp_ok( $dts->week_number(), '==', 50, 'week_number() on 1999-12-03 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-12-03 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-12-03 Gregorian' );

$epoch = timegm( 0, 0, 0, 4, 12 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 12,
	day	=> 4,
    ),
);
cmp_ok( $dts->day(), '==', 13, 'day() on 1999-12-04 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Monday', 'day_name() on 1999-12-04 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Monendei', 'day_name_trad() on 1999-12-04 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 13, 'day_of_month() on 1999-12-04 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 3, 'day_of_week() on 1999-12-04 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 347, 'day_of_year() on 1999-12-04 Gregorian' );
cmp_ok( $dts->dow(), '==', 3, 'dow() on 1999-12-04 Gregorian' );
cmp_ok( $dts->doy(), '==', 347, 'doy() on 1999-12-04 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-12-04 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-12-04 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-12-04 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-12-04 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-12-04 Gregorian' );
cmp_ok( $dts->mday(), '==', 13, 'mday() on 1999-12-04 Gregorian' );
cmp_ok( $dts->month(), '==', 12, 'month() on 1999-12-04 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Foreyule', 'month_name() on 1999-12-04 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-12-04 Gregorian' );
Monday 13 Foreyule 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63079948800, 'utc_rd_as_seconds() on 1999-12-04 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730092,
  0,
  0
]
, 'utc_rd_values() on 1999-12-04 Gregorian' );
cmp_ok( $dts->wday(), '==', 3, 'wday() on 1999-12-04 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  50
]
, 'week() on 1999-12-04 Gregorian' );
cmp_ok( $dts->week_number(), '==', 50, 'week_number() on 1999-12-04 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-12-04 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-12-04 Gregorian' );

$epoch = timegm( 0, 0, 0, 5, 12 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 12,
	day	=> 5,
    ),
);
cmp_ok( $dts->day(), '==', 14, 'day() on 1999-12-05 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Trewsday', 'day_name() on 1999-12-05 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Trewesdei', 'day_name_trad() on 1999-12-05 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 14, 'day_of_month() on 1999-12-05 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 4, 'day_of_week() on 1999-12-05 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 348, 'day_of_year() on 1999-12-05 Gregorian' );
cmp_ok( $dts->dow(), '==', 4, 'dow() on 1999-12-05 Gregorian' );
cmp_ok( $dts->doy(), '==', 348, 'doy() on 1999-12-05 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-12-05 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-12-05 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-12-05 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-12-05 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-12-05 Gregorian' );
cmp_ok( $dts->mday(), '==', 14, 'mday() on 1999-12-05 Gregorian' );
cmp_ok( $dts->month(), '==', 12, 'month() on 1999-12-05 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Foreyule', 'month_name() on 1999-12-05 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-12-05 Gregorian' );
Trewsday 14 Foreyule 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63080035200, 'utc_rd_as_seconds() on 1999-12-05 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730093,
  0,
  0
]
, 'utc_rd_values() on 1999-12-05 Gregorian' );
cmp_ok( $dts->wday(), '==', 4, 'wday() on 1999-12-05 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  50
]
, 'week() on 1999-12-05 Gregorian' );
cmp_ok( $dts->week_number(), '==', 50, 'week_number() on 1999-12-05 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-12-05 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-12-05 Gregorian' );

$epoch = timegm( 0, 0, 0, 6, 12 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 12,
	day	=> 6,
    ),
);
cmp_ok( $dts->day(), '==', 15, 'day() on 1999-12-06 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Hevensday', 'day_name() on 1999-12-06 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Hevenesdei', 'day_name_trad() on 1999-12-06 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 15, 'day_of_month() on 1999-12-06 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 5, 'day_of_week() on 1999-12-06 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 349, 'day_of_year() on 1999-12-06 Gregorian' );
cmp_ok( $dts->dow(), '==', 5, 'dow() on 1999-12-06 Gregorian' );
cmp_ok( $dts->doy(), '==', 349, 'doy() on 1999-12-06 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-12-06 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-12-06 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-12-06 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-12-06 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-12-06 Gregorian' );
cmp_ok( $dts->mday(), '==', 15, 'mday() on 1999-12-06 Gregorian' );
cmp_ok( $dts->month(), '==', 12, 'month() on 1999-12-06 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Foreyule', 'month_name() on 1999-12-06 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-12-06 Gregorian' );
Hevensday 15 Foreyule 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63080121600, 'utc_rd_as_seconds() on 1999-12-06 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730094,
  0,
  0
]
, 'utc_rd_values() on 1999-12-06 Gregorian' );
cmp_ok( $dts->wday(), '==', 5, 'wday() on 1999-12-06 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  50
]
, 'week() on 1999-12-06 Gregorian' );
cmp_ok( $dts->week_number(), '==', 50, 'week_number() on 1999-12-06 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-12-06 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-12-06 Gregorian' );

$epoch = timegm( 0, 0, 0, 7, 12 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 12,
	day	=> 7,
    ),
);
cmp_ok( $dts->day(), '==', 16, 'day() on 1999-12-07 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Mersday', 'day_name() on 1999-12-07 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Meresdei', 'day_name_trad() on 1999-12-07 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 16, 'day_of_month() on 1999-12-07 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 6, 'day_of_week() on 1999-12-07 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 350, 'day_of_year() on 1999-12-07 Gregorian' );
cmp_ok( $dts->dow(), '==', 6, 'dow() on 1999-12-07 Gregorian' );
cmp_ok( $dts->doy(), '==', 350, 'doy() on 1999-12-07 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-12-07 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-12-07 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-12-07 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-12-07 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-12-07 Gregorian' );
cmp_ok( $dts->mday(), '==', 16, 'mday() on 1999-12-07 Gregorian' );
cmp_ok( $dts->month(), '==', 12, 'month() on 1999-12-07 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Foreyule', 'month_name() on 1999-12-07 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-12-07 Gregorian' );
Mersday 16 Foreyule 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63080208000, 'utc_rd_as_seconds() on 1999-12-07 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730095,
  0,
  0
]
, 'utc_rd_values() on 1999-12-07 Gregorian' );
cmp_ok( $dts->wday(), '==', 6, 'wday() on 1999-12-07 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  50
]
, 'week() on 1999-12-07 Gregorian' );
cmp_ok( $dts->week_number(), '==', 50, 'week_number() on 1999-12-07 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-12-07 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-12-07 Gregorian' );

$epoch = timegm( 0, 0, 0, 8, 12 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 12,
	day	=> 8,
    ),
);
cmp_ok( $dts->day(), '==', 17, 'day() on 1999-12-08 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Highday', 'day_name() on 1999-12-08 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Highdei', 'day_name_trad() on 1999-12-08 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 17, 'day_of_month() on 1999-12-08 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 7, 'day_of_week() on 1999-12-08 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 351, 'day_of_year() on 1999-12-08 Gregorian' );
cmp_ok( $dts->dow(), '==', 7, 'dow() on 1999-12-08 Gregorian' );
cmp_ok( $dts->doy(), '==', 351, 'doy() on 1999-12-08 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-12-08 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-12-08 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-12-08 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-12-08 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-12-08 Gregorian' );
cmp_ok( $dts->mday(), '==', 17, 'mday() on 1999-12-08 Gregorian' );
cmp_ok( $dts->month(), '==', 12, 'month() on 1999-12-08 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Foreyule', 'month_name() on 1999-12-08 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-12-08 Gregorian' );
Highday 17 Foreyule 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63080294400, 'utc_rd_as_seconds() on 1999-12-08 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730096,
  0,
  0
]
, 'utc_rd_values() on 1999-12-08 Gregorian' );
cmp_ok( $dts->wday(), '==', 7, 'wday() on 1999-12-08 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  50
]
, 'week() on 1999-12-08 Gregorian' );
cmp_ok( $dts->week_number(), '==', 50, 'week_number() on 1999-12-08 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-12-08 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-12-08 Gregorian' );

$epoch = timegm( 0, 0, 0, 9, 12 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 12,
	day	=> 9,
    ),
);
cmp_ok( $dts->day(), '==', 18, 'day() on 1999-12-09 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sterday', 'day_name() on 1999-12-09 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sterrendei', 'day_name_trad() on 1999-12-09 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 18, 'day_of_month() on 1999-12-09 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 1, 'day_of_week() on 1999-12-09 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 352, 'day_of_year() on 1999-12-09 Gregorian' );
cmp_ok( $dts->dow(), '==', 1, 'dow() on 1999-12-09 Gregorian' );
cmp_ok( $dts->doy(), '==', 352, 'doy() on 1999-12-09 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-12-09 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-12-09 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-12-09 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-12-09 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-12-09 Gregorian' );
cmp_ok( $dts->mday(), '==', 18, 'mday() on 1999-12-09 Gregorian' );
cmp_ok( $dts->month(), '==', 12, 'month() on 1999-12-09 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Foreyule', 'month_name() on 1999-12-09 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-12-09 Gregorian' );
Sterday 18 Foreyule 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63080380800, 'utc_rd_as_seconds() on 1999-12-09 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730097,
  0,
  0
]
, 'utc_rd_values() on 1999-12-09 Gregorian' );
cmp_ok( $dts->wday(), '==', 1, 'wday() on 1999-12-09 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  51
]
, 'week() on 1999-12-09 Gregorian' );
cmp_ok( $dts->week_number(), '==', 51, 'week_number() on 1999-12-09 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-12-09 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-12-09 Gregorian' );

$epoch = timegm( 0, 0, 0, 10, 12 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 12,
	day	=> 10,
    ),
);
cmp_ok( $dts->day(), '==', 19, 'day() on 1999-12-10 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sunday', 'day_name() on 1999-12-10 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sunnendei', 'day_name_trad() on 1999-12-10 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 19, 'day_of_month() on 1999-12-10 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 2, 'day_of_week() on 1999-12-10 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 353, 'day_of_year() on 1999-12-10 Gregorian' );
cmp_ok( $dts->dow(), '==', 2, 'dow() on 1999-12-10 Gregorian' );
cmp_ok( $dts->doy(), '==', 353, 'doy() on 1999-12-10 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-12-10 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-12-10 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-12-10 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-12-10 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-12-10 Gregorian' );
cmp_ok( $dts->mday(), '==', 19, 'mday() on 1999-12-10 Gregorian' );
cmp_ok( $dts->month(), '==', 12, 'month() on 1999-12-10 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Foreyule', 'month_name() on 1999-12-10 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-12-10 Gregorian' );
Sunday 19 Foreyule 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63080467200, 'utc_rd_as_seconds() on 1999-12-10 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730098,
  0,
  0
]
, 'utc_rd_values() on 1999-12-10 Gregorian' );
cmp_ok( $dts->wday(), '==', 2, 'wday() on 1999-12-10 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  51
]
, 'week() on 1999-12-10 Gregorian' );
cmp_ok( $dts->week_number(), '==', 51, 'week_number() on 1999-12-10 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-12-10 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-12-10 Gregorian' );

$epoch = timegm( 0, 0, 0, 11, 12 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 12,
	day	=> 11,
    ),
);
cmp_ok( $dts->day(), '==', 20, 'day() on 1999-12-11 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Monday', 'day_name() on 1999-12-11 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Monendei', 'day_name_trad() on 1999-12-11 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 20, 'day_of_month() on 1999-12-11 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 3, 'day_of_week() on 1999-12-11 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 354, 'day_of_year() on 1999-12-11 Gregorian' );
cmp_ok( $dts->dow(), '==', 3, 'dow() on 1999-12-11 Gregorian' );
cmp_ok( $dts->doy(), '==', 354, 'doy() on 1999-12-11 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-12-11 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-12-11 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-12-11 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-12-11 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-12-11 Gregorian' );
cmp_ok( $dts->mday(), '==', 20, 'mday() on 1999-12-11 Gregorian' );
cmp_ok( $dts->month(), '==', 12, 'month() on 1999-12-11 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Foreyule', 'month_name() on 1999-12-11 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-12-11 Gregorian' );
Monday 20 Foreyule 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63080553600, 'utc_rd_as_seconds() on 1999-12-11 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730099,
  0,
  0
]
, 'utc_rd_values() on 1999-12-11 Gregorian' );
cmp_ok( $dts->wday(), '==', 3, 'wday() on 1999-12-11 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  51
]
, 'week() on 1999-12-11 Gregorian' );
cmp_ok( $dts->week_number(), '==', 51, 'week_number() on 1999-12-11 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-12-11 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-12-11 Gregorian' );

$epoch = timegm( 0, 0, 0, 12, 12 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 12,
	day	=> 12,
    ),
);
cmp_ok( $dts->day(), '==', 21, 'day() on 1999-12-12 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Trewsday', 'day_name() on 1999-12-12 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Trewesdei', 'day_name_trad() on 1999-12-12 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 21, 'day_of_month() on 1999-12-12 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 4, 'day_of_week() on 1999-12-12 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 355, 'day_of_year() on 1999-12-12 Gregorian' );
cmp_ok( $dts->dow(), '==', 4, 'dow() on 1999-12-12 Gregorian' );
cmp_ok( $dts->doy(), '==', 355, 'doy() on 1999-12-12 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-12-12 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-12-12 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-12-12 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-12-12 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-12-12 Gregorian' );
cmp_ok( $dts->mday(), '==', 21, 'mday() on 1999-12-12 Gregorian' );
cmp_ok( $dts->month(), '==', 12, 'month() on 1999-12-12 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Foreyule', 'month_name() on 1999-12-12 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-12-12 Gregorian' );
Trewsday 21 Foreyule 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63080640000, 'utc_rd_as_seconds() on 1999-12-12 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730100,
  0,
  0
]
, 'utc_rd_values() on 1999-12-12 Gregorian' );
cmp_ok( $dts->wday(), '==', 4, 'wday() on 1999-12-12 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  51
]
, 'week() on 1999-12-12 Gregorian' );
cmp_ok( $dts->week_number(), '==', 51, 'week_number() on 1999-12-12 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-12-12 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-12-12 Gregorian' );

$epoch = timegm( 0, 0, 0, 13, 12 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 12,
	day	=> 13,
    ),
);
cmp_ok( $dts->day(), '==', 22, 'day() on 1999-12-13 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Hevensday', 'day_name() on 1999-12-13 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Hevenesdei', 'day_name_trad() on 1999-12-13 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 22, 'day_of_month() on 1999-12-13 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 5, 'day_of_week() on 1999-12-13 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 356, 'day_of_year() on 1999-12-13 Gregorian' );
cmp_ok( $dts->dow(), '==', 5, 'dow() on 1999-12-13 Gregorian' );
cmp_ok( $dts->doy(), '==', 356, 'doy() on 1999-12-13 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-12-13 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-12-13 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-12-13 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-12-13 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-12-13 Gregorian' );
cmp_ok( $dts->mday(), '==', 22, 'mday() on 1999-12-13 Gregorian' );
cmp_ok( $dts->month(), '==', 12, 'month() on 1999-12-13 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Foreyule', 'month_name() on 1999-12-13 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-12-13 Gregorian' );
Hevensday 22 Foreyule 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63080726400, 'utc_rd_as_seconds() on 1999-12-13 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730101,
  0,
  0
]
, 'utc_rd_values() on 1999-12-13 Gregorian' );
cmp_ok( $dts->wday(), '==', 5, 'wday() on 1999-12-13 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  51
]
, 'week() on 1999-12-13 Gregorian' );
cmp_ok( $dts->week_number(), '==', 51, 'week_number() on 1999-12-13 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-12-13 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-12-13 Gregorian' );

$epoch = timegm( 0, 0, 0, 14, 12 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 12,
	day	=> 14,
    ),
);
cmp_ok( $dts->day(), '==', 23, 'day() on 1999-12-14 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Mersday', 'day_name() on 1999-12-14 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Meresdei', 'day_name_trad() on 1999-12-14 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 23, 'day_of_month() on 1999-12-14 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 6, 'day_of_week() on 1999-12-14 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 357, 'day_of_year() on 1999-12-14 Gregorian' );
cmp_ok( $dts->dow(), '==', 6, 'dow() on 1999-12-14 Gregorian' );
cmp_ok( $dts->doy(), '==', 357, 'doy() on 1999-12-14 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-12-14 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-12-14 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-12-14 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-12-14 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-12-14 Gregorian' );
cmp_ok( $dts->mday(), '==', 23, 'mday() on 1999-12-14 Gregorian' );
cmp_ok( $dts->month(), '==', 12, 'month() on 1999-12-14 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Foreyule', 'month_name() on 1999-12-14 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-12-14 Gregorian' );
Mersday 23 Foreyule 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63080812800, 'utc_rd_as_seconds() on 1999-12-14 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730102,
  0,
  0
]
, 'utc_rd_values() on 1999-12-14 Gregorian' );
cmp_ok( $dts->wday(), '==', 6, 'wday() on 1999-12-14 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  51
]
, 'week() on 1999-12-14 Gregorian' );
cmp_ok( $dts->week_number(), '==', 51, 'week_number() on 1999-12-14 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-12-14 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-12-14 Gregorian' );

$epoch = timegm( 0, 0, 0, 15, 12 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 12,
	day	=> 15,
    ),
);
cmp_ok( $dts->day(), '==', 24, 'day() on 1999-12-15 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Highday', 'day_name() on 1999-12-15 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Highdei', 'day_name_trad() on 1999-12-15 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 24, 'day_of_month() on 1999-12-15 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 7, 'day_of_week() on 1999-12-15 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 358, 'day_of_year() on 1999-12-15 Gregorian' );
cmp_ok( $dts->dow(), '==', 7, 'dow() on 1999-12-15 Gregorian' );
cmp_ok( $dts->doy(), '==', 358, 'doy() on 1999-12-15 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-12-15 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-12-15 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-12-15 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-12-15 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-12-15 Gregorian' );
cmp_ok( $dts->mday(), '==', 24, 'mday() on 1999-12-15 Gregorian' );
cmp_ok( $dts->month(), '==', 12, 'month() on 1999-12-15 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Foreyule', 'month_name() on 1999-12-15 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-12-15 Gregorian' );
Highday 24 Foreyule 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63080899200, 'utc_rd_as_seconds() on 1999-12-15 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730103,
  0,
  0
]
, 'utc_rd_values() on 1999-12-15 Gregorian' );
cmp_ok( $dts->wday(), '==', 7, 'wday() on 1999-12-15 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  51
]
, 'week() on 1999-12-15 Gregorian' );
cmp_ok( $dts->week_number(), '==', 51, 'week_number() on 1999-12-15 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-12-15 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-12-15 Gregorian' );

$epoch = timegm( 0, 0, 0, 16, 12 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 12,
	day	=> 16,
    ),
);
cmp_ok( $dts->day(), '==', 25, 'day() on 1999-12-16 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sterday', 'day_name() on 1999-12-16 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sterrendei', 'day_name_trad() on 1999-12-16 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 25, 'day_of_month() on 1999-12-16 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 1, 'day_of_week() on 1999-12-16 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 359, 'day_of_year() on 1999-12-16 Gregorian' );
cmp_ok( $dts->dow(), '==', 1, 'dow() on 1999-12-16 Gregorian' );
cmp_ok( $dts->doy(), '==', 359, 'doy() on 1999-12-16 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-12-16 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-12-16 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-12-16 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-12-16 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-12-16 Gregorian' );
cmp_ok( $dts->mday(), '==', 25, 'mday() on 1999-12-16 Gregorian' );
cmp_ok( $dts->month(), '==', 12, 'month() on 1999-12-16 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Foreyule', 'month_name() on 1999-12-16 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-12-16 Gregorian' );
Sterday 25 Foreyule 7463

The Company of the Ring leaves Rivendell at dusk, 1418.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63080985600, 'utc_rd_as_seconds() on 1999-12-16 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730104,
  0,
  0
]
, 'utc_rd_values() on 1999-12-16 Gregorian' );
cmp_ok( $dts->wday(), '==', 1, 'wday() on 1999-12-16 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  52
]
, 'week() on 1999-12-16 Gregorian' );
cmp_ok( $dts->week_number(), '==', 52, 'week_number() on 1999-12-16 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-12-16 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-12-16 Gregorian' );

$epoch = timegm( 0, 0, 0, 17, 12 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 12,
	day	=> 17,
    ),
);
cmp_ok( $dts->day(), '==', 26, 'day() on 1999-12-17 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sunday', 'day_name() on 1999-12-17 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sunnendei', 'day_name_trad() on 1999-12-17 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 26, 'day_of_month() on 1999-12-17 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 2, 'day_of_week() on 1999-12-17 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 360, 'day_of_year() on 1999-12-17 Gregorian' );
cmp_ok( $dts->dow(), '==', 2, 'dow() on 1999-12-17 Gregorian' );
cmp_ok( $dts->doy(), '==', 360, 'doy() on 1999-12-17 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-12-17 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-12-17 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-12-17 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-12-17 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-12-17 Gregorian' );
cmp_ok( $dts->mday(), '==', 26, 'mday() on 1999-12-17 Gregorian' );
cmp_ok( $dts->month(), '==', 12, 'month() on 1999-12-17 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Foreyule', 'month_name() on 1999-12-17 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-12-17 Gregorian' );
Sunday 26 Foreyule 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63081072000, 'utc_rd_as_seconds() on 1999-12-17 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730105,
  0,
  0
]
, 'utc_rd_values() on 1999-12-17 Gregorian' );
cmp_ok( $dts->wday(), '==', 2, 'wday() on 1999-12-17 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  52
]
, 'week() on 1999-12-17 Gregorian' );
cmp_ok( $dts->week_number(), '==', 52, 'week_number() on 1999-12-17 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-12-17 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-12-17 Gregorian' );

$epoch = timegm( 0, 0, 0, 18, 12 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 12,
	day	=> 18,
    ),
);
cmp_ok( $dts->day(), '==', 27, 'day() on 1999-12-18 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Monday', 'day_name() on 1999-12-18 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Monendei', 'day_name_trad() on 1999-12-18 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 27, 'day_of_month() on 1999-12-18 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 3, 'day_of_week() on 1999-12-18 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 361, 'day_of_year() on 1999-12-18 Gregorian' );
cmp_ok( $dts->dow(), '==', 3, 'dow() on 1999-12-18 Gregorian' );
cmp_ok( $dts->doy(), '==', 361, 'doy() on 1999-12-18 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-12-18 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-12-18 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-12-18 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-12-18 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-12-18 Gregorian' );
cmp_ok( $dts->mday(), '==', 27, 'mday() on 1999-12-18 Gregorian' );
cmp_ok( $dts->month(), '==', 12, 'month() on 1999-12-18 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Foreyule', 'month_name() on 1999-12-18 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-12-18 Gregorian' );
Monday 27 Foreyule 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63081158400, 'utc_rd_as_seconds() on 1999-12-18 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730106,
  0,
  0
]
, 'utc_rd_values() on 1999-12-18 Gregorian' );
cmp_ok( $dts->wday(), '==', 3, 'wday() on 1999-12-18 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  52
]
, 'week() on 1999-12-18 Gregorian' );
cmp_ok( $dts->week_number(), '==', 52, 'week_number() on 1999-12-18 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-12-18 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-12-18 Gregorian' );

$epoch = timegm( 0, 0, 0, 19, 12 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 12,
	day	=> 19,
    ),
);
cmp_ok( $dts->day(), '==', 28, 'day() on 1999-12-19 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Trewsday', 'day_name() on 1999-12-19 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Trewesdei', 'day_name_trad() on 1999-12-19 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 28, 'day_of_month() on 1999-12-19 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 4, 'day_of_week() on 1999-12-19 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 362, 'day_of_year() on 1999-12-19 Gregorian' );
cmp_ok( $dts->dow(), '==', 4, 'dow() on 1999-12-19 Gregorian' );
cmp_ok( $dts->doy(), '==', 362, 'doy() on 1999-12-19 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-12-19 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-12-19 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-12-19 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-12-19 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-12-19 Gregorian' );
cmp_ok( $dts->mday(), '==', 28, 'mday() on 1999-12-19 Gregorian' );
cmp_ok( $dts->month(), '==', 12, 'month() on 1999-12-19 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Foreyule', 'month_name() on 1999-12-19 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-12-19 Gregorian' );
Trewsday 28 Foreyule 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63081244800, 'utc_rd_as_seconds() on 1999-12-19 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730107,
  0,
  0
]
, 'utc_rd_values() on 1999-12-19 Gregorian' );
cmp_ok( $dts->wday(), '==', 4, 'wday() on 1999-12-19 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  52
]
, 'week() on 1999-12-19 Gregorian' );
cmp_ok( $dts->week_number(), '==', 52, 'week_number() on 1999-12-19 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-12-19 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-12-19 Gregorian' );

$epoch = timegm( 0, 0, 0, 20, 12 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 12,
	day	=> 20,
    ),
);
cmp_ok( $dts->day(), '==', 29, 'day() on 1999-12-20 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Hevensday', 'day_name() on 1999-12-20 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Hevenesdei', 'day_name_trad() on 1999-12-20 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 29, 'day_of_month() on 1999-12-20 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 5, 'day_of_week() on 1999-12-20 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 363, 'day_of_year() on 1999-12-20 Gregorian' );
cmp_ok( $dts->dow(), '==', 5, 'dow() on 1999-12-20 Gregorian' );
cmp_ok( $dts->doy(), '==', 363, 'doy() on 1999-12-20 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-12-20 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-12-20 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-12-20 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-12-20 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-12-20 Gregorian' );
cmp_ok( $dts->mday(), '==', 29, 'mday() on 1999-12-20 Gregorian' );
cmp_ok( $dts->month(), '==', 12, 'month() on 1999-12-20 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Foreyule', 'month_name() on 1999-12-20 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-12-20 Gregorian' );
Hevensday 29 Foreyule 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63081331200, 'utc_rd_as_seconds() on 1999-12-20 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730108,
  0,
  0
]
, 'utc_rd_values() on 1999-12-20 Gregorian' );
cmp_ok( $dts->wday(), '==', 5, 'wday() on 1999-12-20 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  52
]
, 'week() on 1999-12-20 Gregorian' );
cmp_ok( $dts->week_number(), '==', 52, 'week_number() on 1999-12-20 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-12-20 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-12-20 Gregorian' );

$epoch = timegm( 0, 0, 0, 21, 12 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 12,
	day	=> 21,
    ),
);
cmp_ok( $dts->day(), '==', 30, 'day() on 1999-12-21 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Mersday', 'day_name() on 1999-12-21 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Meresdei', 'day_name_trad() on 1999-12-21 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 30, 'day_of_month() on 1999-12-21 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 6, 'day_of_week() on 1999-12-21 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 364, 'day_of_year() on 1999-12-21 Gregorian' );
cmp_ok( $dts->dow(), '==', 6, 'dow() on 1999-12-21 Gregorian' );
cmp_ok( $dts->doy(), '==', 364, 'doy() on 1999-12-21 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-12-21 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-12-21 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-12-21 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-12-21 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-12-21 Gregorian' );
cmp_ok( $dts->mday(), '==', 30, 'mday() on 1999-12-21 Gregorian' );
cmp_ok( $dts->month(), '==', 12, 'month() on 1999-12-21 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Foreyule', 'month_name() on 1999-12-21 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-12-21 Gregorian' );
Mersday 30 Foreyule 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63081417600, 'utc_rd_as_seconds() on 1999-12-21 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730109,
  0,
  0
]
, 'utc_rd_values() on 1999-12-21 Gregorian' );
cmp_ok( $dts->wday(), '==', 6, 'wday() on 1999-12-21 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  52
]
, 'week() on 1999-12-21 Gregorian' );
cmp_ok( $dts->week_number(), '==', 52, 'week_number() on 1999-12-21 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-12-21 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-12-21 Gregorian' );

$epoch = timegm( 0, 0, 0, 22, 12 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 12,
	day	=> 22,
    ),
);
cmp_ok( $dts->day(), '==', 0, 'day() on 1999-12-22 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Highday', 'day_name() on 1999-12-22 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Highdei', 'day_name_trad() on 1999-12-22 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 0, 'day_of_month() on 1999-12-22 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 7, 'day_of_week() on 1999-12-22 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 365, 'day_of_year() on 1999-12-22 Gregorian' );
cmp_ok( $dts->dow(), '==', 7, 'dow() on 1999-12-22 Gregorian' );
cmp_ok( $dts->doy(), '==', 365, 'doy() on 1999-12-22 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-12-22 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-12-22 Gregorian' );
cmp_ok( $dts->holiday(), '==', 6, 'holiday() on 1999-12-22 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '1 Yule', 'holiday_name() on 1999-12-22 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 0, 'is_leap_year() on 1999-12-22 Gregorian' );
cmp_ok( $dts->mday(), '==', 0, 'mday() on 1999-12-22 Gregorian' );
cmp_ok( $dts->month(), '==', 0, 'month() on 1999-12-22 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', '', 'month_name() on 1999-12-22 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-12-22 Gregorian' );
Highday 1 Yule 7463
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63081504000, 'utc_rd_as_seconds() on 1999-12-22 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730110,
  0,
  0
]
, 'utc_rd_values() on 1999-12-22 Gregorian' );
cmp_ok( $dts->wday(), '==', 7, 'wday() on 1999-12-22 Gregorian' );
is_deeply( [ $dts->week() ], [
  7463,
  52
]
, 'week() on 1999-12-22 Gregorian' );
cmp_ok( $dts->week_number(), '==', 52, 'week_number() on 1999-12-22 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7463, 'week_year() on 1999-12-22 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-12-22 Gregorian' );

$epoch = timegm( 0, 0, 0, 23, 12 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 12,
	day	=> 23,
    ),
);
cmp_ok( $dts->day(), '==', 0, 'day() on 1999-12-23 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sterday', 'day_name() on 1999-12-23 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sterrendei', 'day_name_trad() on 1999-12-23 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 0, 'day_of_month() on 1999-12-23 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 1, 'day_of_week() on 1999-12-23 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 1, 'day_of_year() on 1999-12-23 Gregorian' );
cmp_ok( $dts->dow(), '==', 1, 'dow() on 1999-12-23 Gregorian' );
cmp_ok( $dts->doy(), '==', 1, 'doy() on 1999-12-23 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-12-23 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-12-23 Gregorian' );
cmp_ok( $dts->holiday(), '==', 1, 'holiday() on 1999-12-23 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '2 Yule', 'holiday_name() on 1999-12-23 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 1999-12-23 Gregorian' );
cmp_ok( $dts->mday(), '==', 0, 'mday() on 1999-12-23 Gregorian' );
cmp_ok( $dts->month(), '==', 0, 'month() on 1999-12-23 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', '', 'month_name() on 1999-12-23 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-12-23 Gregorian' );
Sterday 2 Yule 7464
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63081590400, 'utc_rd_as_seconds() on 1999-12-23 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730111,
  0,
  0
]
, 'utc_rd_values() on 1999-12-23 Gregorian' );
cmp_ok( $dts->wday(), '==', 1, 'wday() on 1999-12-23 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  1
]
, 'week() on 1999-12-23 Gregorian' );
cmp_ok( $dts->week_number(), '==', 1, 'week_number() on 1999-12-23 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 1999-12-23 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 1999-12-23 Gregorian' );

$epoch = timegm( 0, 0, 0, 24, 12 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 12,
	day	=> 24,
    ),
);
cmp_ok( $dts->day(), '==', 1, 'day() on 1999-12-24 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sunday', 'day_name() on 1999-12-24 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sunnendei', 'day_name_trad() on 1999-12-24 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 1, 'day_of_month() on 1999-12-24 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 2, 'day_of_week() on 1999-12-24 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 2, 'day_of_year() on 1999-12-24 Gregorian' );
cmp_ok( $dts->dow(), '==', 2, 'dow() on 1999-12-24 Gregorian' );
cmp_ok( $dts->doy(), '==', 2, 'doy() on 1999-12-24 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-12-24 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-12-24 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-12-24 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-12-24 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 1999-12-24 Gregorian' );
cmp_ok( $dts->mday(), '==', 1, 'mday() on 1999-12-24 Gregorian' );
cmp_ok( $dts->month(), '==', 1, 'month() on 1999-12-24 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afteryule', 'month_name() on 1999-12-24 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-12-24 Gregorian' );
Sunday 1 Afteryule 7464
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63081676800, 'utc_rd_as_seconds() on 1999-12-24 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730112,
  0,
  0
]
, 'utc_rd_values() on 1999-12-24 Gregorian' );
cmp_ok( $dts->wday(), '==', 2, 'wday() on 1999-12-24 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  1
]
, 'week() on 1999-12-24 Gregorian' );
cmp_ok( $dts->week_number(), '==', 1, 'week_number() on 1999-12-24 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 1999-12-24 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 1999-12-24 Gregorian' );

$epoch = timegm( 0, 0, 0, 25, 12 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 12,
	day	=> 25,
    ),
);
cmp_ok( $dts->day(), '==', 2, 'day() on 1999-12-25 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Monday', 'day_name() on 1999-12-25 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Monendei', 'day_name_trad() on 1999-12-25 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 2, 'day_of_month() on 1999-12-25 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 3, 'day_of_week() on 1999-12-25 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 3, 'day_of_year() on 1999-12-25 Gregorian' );
cmp_ok( $dts->dow(), '==', 3, 'dow() on 1999-12-25 Gregorian' );
cmp_ok( $dts->doy(), '==', 3, 'doy() on 1999-12-25 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-12-25 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-12-25 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-12-25 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-12-25 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 1999-12-25 Gregorian' );
cmp_ok( $dts->mday(), '==', 2, 'mday() on 1999-12-25 Gregorian' );
cmp_ok( $dts->month(), '==', 1, 'month() on 1999-12-25 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afteryule', 'month_name() on 1999-12-25 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-12-25 Gregorian' );
Monday 2 Afteryule 7464
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63081763200, 'utc_rd_as_seconds() on 1999-12-25 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730113,
  0,
  0
]
, 'utc_rd_values() on 1999-12-25 Gregorian' );
cmp_ok( $dts->wday(), '==', 3, 'wday() on 1999-12-25 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  1
]
, 'week() on 1999-12-25 Gregorian' );
cmp_ok( $dts->week_number(), '==', 1, 'week_number() on 1999-12-25 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 1999-12-25 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 1999-12-25 Gregorian' );

$epoch = timegm( 0, 0, 0, 26, 12 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 12,
	day	=> 26,
    ),
);
cmp_ok( $dts->day(), '==', 3, 'day() on 1999-12-26 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Trewsday', 'day_name() on 1999-12-26 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Trewesdei', 'day_name_trad() on 1999-12-26 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 3, 'day_of_month() on 1999-12-26 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 4, 'day_of_week() on 1999-12-26 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 4, 'day_of_year() on 1999-12-26 Gregorian' );
cmp_ok( $dts->dow(), '==', 4, 'dow() on 1999-12-26 Gregorian' );
cmp_ok( $dts->doy(), '==', 4, 'doy() on 1999-12-26 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-12-26 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-12-26 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-12-26 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-12-26 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 1999-12-26 Gregorian' );
cmp_ok( $dts->mday(), '==', 3, 'mday() on 1999-12-26 Gregorian' );
cmp_ok( $dts->month(), '==', 1, 'month() on 1999-12-26 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afteryule', 'month_name() on 1999-12-26 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-12-26 Gregorian' );
Trewsday 3 Afteryule 7464
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63081849600, 'utc_rd_as_seconds() on 1999-12-26 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730114,
  0,
  0
]
, 'utc_rd_values() on 1999-12-26 Gregorian' );
cmp_ok( $dts->wday(), '==', 4, 'wday() on 1999-12-26 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  1
]
, 'week() on 1999-12-26 Gregorian' );
cmp_ok( $dts->week_number(), '==', 1, 'week_number() on 1999-12-26 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 1999-12-26 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 1999-12-26 Gregorian' );

$epoch = timegm( 0, 0, 0, 27, 12 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 12,
	day	=> 27,
    ),
);
cmp_ok( $dts->day(), '==', 4, 'day() on 1999-12-27 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Hevensday', 'day_name() on 1999-12-27 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Hevenesdei', 'day_name_trad() on 1999-12-27 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 4, 'day_of_month() on 1999-12-27 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 5, 'day_of_week() on 1999-12-27 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 5, 'day_of_year() on 1999-12-27 Gregorian' );
cmp_ok( $dts->dow(), '==', 5, 'dow() on 1999-12-27 Gregorian' );
cmp_ok( $dts->doy(), '==', 5, 'doy() on 1999-12-27 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-12-27 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-12-27 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-12-27 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-12-27 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 1999-12-27 Gregorian' );
cmp_ok( $dts->mday(), '==', 4, 'mday() on 1999-12-27 Gregorian' );
cmp_ok( $dts->month(), '==', 1, 'month() on 1999-12-27 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afteryule', 'month_name() on 1999-12-27 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-12-27 Gregorian' );
Hevensday 4 Afteryule 7464
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63081936000, 'utc_rd_as_seconds() on 1999-12-27 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730115,
  0,
  0
]
, 'utc_rd_values() on 1999-12-27 Gregorian' );
cmp_ok( $dts->wday(), '==', 5, 'wday() on 1999-12-27 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  1
]
, 'week() on 1999-12-27 Gregorian' );
cmp_ok( $dts->week_number(), '==', 1, 'week_number() on 1999-12-27 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 1999-12-27 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 1999-12-27 Gregorian' );

$epoch = timegm( 0, 0, 0, 28, 12 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 12,
	day	=> 28,
    ),
);
cmp_ok( $dts->day(), '==', 5, 'day() on 1999-12-28 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Mersday', 'day_name() on 1999-12-28 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Meresdei', 'day_name_trad() on 1999-12-28 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 5, 'day_of_month() on 1999-12-28 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 6, 'day_of_week() on 1999-12-28 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 6, 'day_of_year() on 1999-12-28 Gregorian' );
cmp_ok( $dts->dow(), '==', 6, 'dow() on 1999-12-28 Gregorian' );
cmp_ok( $dts->doy(), '==', 6, 'doy() on 1999-12-28 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-12-28 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-12-28 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-12-28 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-12-28 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 1999-12-28 Gregorian' );
cmp_ok( $dts->mday(), '==', 5, 'mday() on 1999-12-28 Gregorian' );
cmp_ok( $dts->month(), '==', 1, 'month() on 1999-12-28 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afteryule', 'month_name() on 1999-12-28 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-12-28 Gregorian' );
Mersday 5 Afteryule 7464
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63082022400, 'utc_rd_as_seconds() on 1999-12-28 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730116,
  0,
  0
]
, 'utc_rd_values() on 1999-12-28 Gregorian' );
cmp_ok( $dts->wday(), '==', 6, 'wday() on 1999-12-28 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  1
]
, 'week() on 1999-12-28 Gregorian' );
cmp_ok( $dts->week_number(), '==', 1, 'week_number() on 1999-12-28 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 1999-12-28 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 1999-12-28 Gregorian' );

$epoch = timegm( 0, 0, 0, 29, 12 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 12,
	day	=> 29,
    ),
);
cmp_ok( $dts->day(), '==', 6, 'day() on 1999-12-29 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Highday', 'day_name() on 1999-12-29 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Highdei', 'day_name_trad() on 1999-12-29 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 6, 'day_of_month() on 1999-12-29 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 7, 'day_of_week() on 1999-12-29 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 7, 'day_of_year() on 1999-12-29 Gregorian' );
cmp_ok( $dts->dow(), '==', 7, 'dow() on 1999-12-29 Gregorian' );
cmp_ok( $dts->doy(), '==', 7, 'doy() on 1999-12-29 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-12-29 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-12-29 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-12-29 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-12-29 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 1999-12-29 Gregorian' );
cmp_ok( $dts->mday(), '==', 6, 'mday() on 1999-12-29 Gregorian' );
cmp_ok( $dts->month(), '==', 1, 'month() on 1999-12-29 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afteryule', 'month_name() on 1999-12-29 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-12-29 Gregorian' );
Highday 6 Afteryule 7464
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63082108800, 'utc_rd_as_seconds() on 1999-12-29 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730117,
  0,
  0
]
, 'utc_rd_values() on 1999-12-29 Gregorian' );
cmp_ok( $dts->wday(), '==', 7, 'wday() on 1999-12-29 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  1
]
, 'week() on 1999-12-29 Gregorian' );
cmp_ok( $dts->week_number(), '==', 1, 'week_number() on 1999-12-29 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 1999-12-29 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 1999-12-29 Gregorian' );

$epoch = timegm( 0, 0, 0, 30, 12 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 12,
	day	=> 30,
    ),
);
cmp_ok( $dts->day(), '==', 7, 'day() on 1999-12-30 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sterday', 'day_name() on 1999-12-30 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sterrendei', 'day_name_trad() on 1999-12-30 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 7, 'day_of_month() on 1999-12-30 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 1, 'day_of_week() on 1999-12-30 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 8, 'day_of_year() on 1999-12-30 Gregorian' );
cmp_ok( $dts->dow(), '==', 1, 'dow() on 1999-12-30 Gregorian' );
cmp_ok( $dts->doy(), '==', 8, 'doy() on 1999-12-30 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-12-30 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-12-30 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-12-30 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-12-30 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 1999-12-30 Gregorian' );
cmp_ok( $dts->mday(), '==', 7, 'mday() on 1999-12-30 Gregorian' );
cmp_ok( $dts->month(), '==', 1, 'month() on 1999-12-30 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afteryule', 'month_name() on 1999-12-30 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-12-30 Gregorian' );
Sterday 7 Afteryule 7464
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63082195200, 'utc_rd_as_seconds() on 1999-12-30 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730118,
  0,
  0
]
, 'utc_rd_values() on 1999-12-30 Gregorian' );
cmp_ok( $dts->wday(), '==', 1, 'wday() on 1999-12-30 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  2
]
, 'week() on 1999-12-30 Gregorian' );
cmp_ok( $dts->week_number(), '==', 2, 'week_number() on 1999-12-30 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 1999-12-30 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 1999-12-30 Gregorian' );

$epoch = timegm( 0, 0, 0, 31, 12 - 1, 1999 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 1999,
	month	=> 12,
	day	=> 31,
    ),
);
cmp_ok( $dts->day(), '==', 8, 'day() on 1999-12-31 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sunday', 'day_name() on 1999-12-31 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sunnendei', 'day_name_trad() on 1999-12-31 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 8, 'day_of_month() on 1999-12-31 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 2, 'day_of_week() on 1999-12-31 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 9, 'day_of_year() on 1999-12-31 Gregorian' );
cmp_ok( $dts->dow(), '==', 2, 'dow() on 1999-12-31 Gregorian' );
cmp_ok( $dts->doy(), '==', 9, 'doy() on 1999-12-31 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 1999-12-31 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 1999-12-31 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 1999-12-31 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 1999-12-31 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 1999-12-31 Gregorian' );
cmp_ok( $dts->mday(), '==', 8, 'mday() on 1999-12-31 Gregorian' );
cmp_ok( $dts->month(), '==', 1, 'month() on 1999-12-31 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afteryule', 'month_name() on 1999-12-31 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-12-31 Gregorian' );
Sunday 8 Afteryule 7464

The Company of the Ring reaches Hollin, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63082281600, 'utc_rd_as_seconds() on 1999-12-31 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730119,
  0,
  0
]
, 'utc_rd_values() on 1999-12-31 Gregorian' );
cmp_ok( $dts->wday(), '==', 2, 'wday() on 1999-12-31 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  2
]
, 'week() on 1999-12-31 Gregorian' );
cmp_ok( $dts->week_number(), '==', 2, 'week_number() on 1999-12-31 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 1999-12-31 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 1999-12-31 Gregorian' );

$epoch = timegm( 0, 0, 0, 1, 1 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 1,
	day	=> 1,
    ),
);
cmp_ok( $dts->day(), '==', 9, 'day() on 2000-01-01 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Monday', 'day_name() on 2000-01-01 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Monendei', 'day_name_trad() on 2000-01-01 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 9, 'day_of_month() on 2000-01-01 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 3, 'day_of_week() on 2000-01-01 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 10, 'day_of_year() on 2000-01-01 Gregorian' );
cmp_ok( $dts->dow(), '==', 3, 'dow() on 2000-01-01 Gregorian' );
cmp_ok( $dts->doy(), '==', 10, 'doy() on 2000-01-01 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-01-01 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-01-01 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-01-01 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-01-01 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-01-01 Gregorian' );
cmp_ok( $dts->mday(), '==', 9, 'mday() on 2000-01-01 Gregorian' );
cmp_ok( $dts->month(), '==', 1, 'month() on 2000-01-01 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afteryule', 'month_name() on 2000-01-01 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-01-01 Gregorian' );
Monday 9 Afteryule 7464
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63082368000, 'utc_rd_as_seconds() on 2000-01-01 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730120,
  0,
  0
]
, 'utc_rd_values() on 2000-01-01 Gregorian' );
cmp_ok( $dts->wday(), '==', 3, 'wday() on 2000-01-01 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  2
]
, 'week() on 2000-01-01 Gregorian' );
cmp_ok( $dts->week_number(), '==', 2, 'week_number() on 2000-01-01 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-01-01 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-01-01 Gregorian' );

$epoch = timegm( 0, 0, 0, 2, 1 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 1,
	day	=> 2,
    ),
);
cmp_ok( $dts->day(), '==', 10, 'day() on 2000-01-02 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Trewsday', 'day_name() on 2000-01-02 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Trewesdei', 'day_name_trad() on 2000-01-02 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 10, 'day_of_month() on 2000-01-02 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 4, 'day_of_week() on 2000-01-02 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 11, 'day_of_year() on 2000-01-02 Gregorian' );
cmp_ok( $dts->dow(), '==', 4, 'dow() on 2000-01-02 Gregorian' );
cmp_ok( $dts->doy(), '==', 11, 'doy() on 2000-01-02 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-01-02 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-01-02 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-01-02 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-01-02 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-01-02 Gregorian' );
cmp_ok( $dts->mday(), '==', 10, 'mday() on 2000-01-02 Gregorian' );
cmp_ok( $dts->month(), '==', 1, 'month() on 2000-01-02 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afteryule', 'month_name() on 2000-01-02 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-01-02 Gregorian' );
Trewsday 10 Afteryule 7464
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63082454400, 'utc_rd_as_seconds() on 2000-01-02 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730121,
  0,
  0
]
, 'utc_rd_values() on 2000-01-02 Gregorian' );
cmp_ok( $dts->wday(), '==', 4, 'wday() on 2000-01-02 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  2
]
, 'week() on 2000-01-02 Gregorian' );
cmp_ok( $dts->week_number(), '==', 2, 'week_number() on 2000-01-02 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-01-02 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-01-02 Gregorian' );

$epoch = timegm( 0, 0, 0, 3, 1 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 1,
	day	=> 3,
    ),
);
cmp_ok( $dts->day(), '==', 11, 'day() on 2000-01-03 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Hevensday', 'day_name() on 2000-01-03 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Hevenesdei', 'day_name_trad() on 2000-01-03 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 11, 'day_of_month() on 2000-01-03 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 5, 'day_of_week() on 2000-01-03 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 12, 'day_of_year() on 2000-01-03 Gregorian' );
cmp_ok( $dts->dow(), '==', 5, 'dow() on 2000-01-03 Gregorian' );
cmp_ok( $dts->doy(), '==', 12, 'doy() on 2000-01-03 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-01-03 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-01-03 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-01-03 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-01-03 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-01-03 Gregorian' );
cmp_ok( $dts->mday(), '==', 11, 'mday() on 2000-01-03 Gregorian' );
cmp_ok( $dts->month(), '==', 1, 'month() on 2000-01-03 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afteryule', 'month_name() on 2000-01-03 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-01-03 Gregorian' );
Hevensday 11 Afteryule 7464
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63082540800, 'utc_rd_as_seconds() on 2000-01-03 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730122,
  0,
  0
]
, 'utc_rd_values() on 2000-01-03 Gregorian' );
cmp_ok( $dts->wday(), '==', 5, 'wday() on 2000-01-03 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  2
]
, 'week() on 2000-01-03 Gregorian' );
cmp_ok( $dts->week_number(), '==', 2, 'week_number() on 2000-01-03 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-01-03 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-01-03 Gregorian' );

$epoch = timegm( 0, 0, 0, 4, 1 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 1,
	day	=> 4,
    ),
);
cmp_ok( $dts->day(), '==', 12, 'day() on 2000-01-04 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Mersday', 'day_name() on 2000-01-04 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Meresdei', 'day_name_trad() on 2000-01-04 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 12, 'day_of_month() on 2000-01-04 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 6, 'day_of_week() on 2000-01-04 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 13, 'day_of_year() on 2000-01-04 Gregorian' );
cmp_ok( $dts->dow(), '==', 6, 'dow() on 2000-01-04 Gregorian' );
cmp_ok( $dts->doy(), '==', 13, 'doy() on 2000-01-04 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-01-04 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-01-04 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-01-04 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-01-04 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-01-04 Gregorian' );
cmp_ok( $dts->mday(), '==', 12, 'mday() on 2000-01-04 Gregorian' );
cmp_ok( $dts->month(), '==', 1, 'month() on 2000-01-04 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afteryule', 'month_name() on 2000-01-04 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-01-04 Gregorian' );
Mersday 12 Afteryule 7464
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63082627200, 'utc_rd_as_seconds() on 2000-01-04 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730123,
  0,
  0
]
, 'utc_rd_values() on 2000-01-04 Gregorian' );
cmp_ok( $dts->wday(), '==', 6, 'wday() on 2000-01-04 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  2
]
, 'week() on 2000-01-04 Gregorian' );
cmp_ok( $dts->week_number(), '==', 2, 'week_number() on 2000-01-04 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-01-04 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-01-04 Gregorian' );

$epoch = timegm( 0, 0, 0, 5, 1 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 1,
	day	=> 5,
    ),
);
cmp_ok( $dts->day(), '==', 13, 'day() on 2000-01-05 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Highday', 'day_name() on 2000-01-05 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Highdei', 'day_name_trad() on 2000-01-05 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 13, 'day_of_month() on 2000-01-05 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 7, 'day_of_week() on 2000-01-05 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 14, 'day_of_year() on 2000-01-05 Gregorian' );
cmp_ok( $dts->dow(), '==', 7, 'dow() on 2000-01-05 Gregorian' );
cmp_ok( $dts->doy(), '==', 14, 'doy() on 2000-01-05 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-01-05 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-01-05 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-01-05 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-01-05 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-01-05 Gregorian' );
cmp_ok( $dts->mday(), '==', 13, 'mday() on 2000-01-05 Gregorian' );
cmp_ok( $dts->month(), '==', 1, 'month() on 2000-01-05 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afteryule', 'month_name() on 2000-01-05 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-01-05 Gregorian' );
Highday 13 Afteryule 7464

The Company of the Ring reaches the West-gate of Moria at nightfall, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63082713600, 'utc_rd_as_seconds() on 2000-01-05 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730124,
  0,
  0
]
, 'utc_rd_values() on 2000-01-05 Gregorian' );
cmp_ok( $dts->wday(), '==', 7, 'wday() on 2000-01-05 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  2
]
, 'week() on 2000-01-05 Gregorian' );
cmp_ok( $dts->week_number(), '==', 2, 'week_number() on 2000-01-05 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-01-05 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-01-05 Gregorian' );

$epoch = timegm( 0, 0, 0, 6, 1 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 1,
	day	=> 6,
    ),
);
cmp_ok( $dts->day(), '==', 14, 'day() on 2000-01-06 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sterday', 'day_name() on 2000-01-06 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sterrendei', 'day_name_trad() on 2000-01-06 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 14, 'day_of_month() on 2000-01-06 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 1, 'day_of_week() on 2000-01-06 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 15, 'day_of_year() on 2000-01-06 Gregorian' );
cmp_ok( $dts->dow(), '==', 1, 'dow() on 2000-01-06 Gregorian' );
cmp_ok( $dts->doy(), '==', 15, 'doy() on 2000-01-06 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-01-06 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-01-06 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-01-06 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-01-06 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-01-06 Gregorian' );
cmp_ok( $dts->mday(), '==', 14, 'mday() on 2000-01-06 Gregorian' );
cmp_ok( $dts->month(), '==', 1, 'month() on 2000-01-06 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afteryule', 'month_name() on 2000-01-06 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-01-06 Gregorian' );
Sterday 14 Afteryule 7464

The Company of the Ring spends the night in Moria hall 21, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63082800000, 'utc_rd_as_seconds() on 2000-01-06 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730125,
  0,
  0
]
, 'utc_rd_values() on 2000-01-06 Gregorian' );
cmp_ok( $dts->wday(), '==', 1, 'wday() on 2000-01-06 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  3
]
, 'week() on 2000-01-06 Gregorian' );
cmp_ok( $dts->week_number(), '==', 3, 'week_number() on 2000-01-06 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-01-06 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-01-06 Gregorian' );

$epoch = timegm( 0, 0, 0, 7, 1 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 1,
	day	=> 7,
    ),
);
cmp_ok( $dts->day(), '==', 15, 'day() on 2000-01-07 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sunday', 'day_name() on 2000-01-07 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sunnendei', 'day_name_trad() on 2000-01-07 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 15, 'day_of_month() on 2000-01-07 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 2, 'day_of_week() on 2000-01-07 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 16, 'day_of_year() on 2000-01-07 Gregorian' );
cmp_ok( $dts->dow(), '==', 2, 'dow() on 2000-01-07 Gregorian' );
cmp_ok( $dts->doy(), '==', 16, 'doy() on 2000-01-07 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-01-07 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-01-07 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-01-07 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-01-07 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-01-07 Gregorian' );
cmp_ok( $dts->mday(), '==', 15, 'mday() on 2000-01-07 Gregorian' );
cmp_ok( $dts->month(), '==', 1, 'month() on 2000-01-07 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afteryule', 'month_name() on 2000-01-07 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-01-07 Gregorian' );
Sunday 15 Afteryule 7464

The Bridge of Khazad-dum, and the fall of Gandalf, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63082886400, 'utc_rd_as_seconds() on 2000-01-07 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730126,
  0,
  0
]
, 'utc_rd_values() on 2000-01-07 Gregorian' );
cmp_ok( $dts->wday(), '==', 2, 'wday() on 2000-01-07 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  3
]
, 'week() on 2000-01-07 Gregorian' );
cmp_ok( $dts->week_number(), '==', 3, 'week_number() on 2000-01-07 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-01-07 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-01-07 Gregorian' );

$epoch = timegm( 0, 0, 0, 8, 1 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 1,
	day	=> 8,
    ),
);
cmp_ok( $dts->day(), '==', 16, 'day() on 2000-01-08 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Monday', 'day_name() on 2000-01-08 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Monendei', 'day_name_trad() on 2000-01-08 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 16, 'day_of_month() on 2000-01-08 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 3, 'day_of_week() on 2000-01-08 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 17, 'day_of_year() on 2000-01-08 Gregorian' );
cmp_ok( $dts->dow(), '==', 3, 'dow() on 2000-01-08 Gregorian' );
cmp_ok( $dts->doy(), '==', 17, 'doy() on 2000-01-08 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-01-08 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-01-08 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-01-08 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-01-08 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-01-08 Gregorian' );
cmp_ok( $dts->mday(), '==', 16, 'mday() on 2000-01-08 Gregorian' );
cmp_ok( $dts->month(), '==', 1, 'month() on 2000-01-08 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afteryule', 'month_name() on 2000-01-08 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-01-08 Gregorian' );
Monday 16 Afteryule 7464
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63082972800, 'utc_rd_as_seconds() on 2000-01-08 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730127,
  0,
  0
]
, 'utc_rd_values() on 2000-01-08 Gregorian' );
cmp_ok( $dts->wday(), '==', 3, 'wday() on 2000-01-08 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  3
]
, 'week() on 2000-01-08 Gregorian' );
cmp_ok( $dts->week_number(), '==', 3, 'week_number() on 2000-01-08 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-01-08 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-01-08 Gregorian' );

$epoch = timegm( 0, 0, 0, 9, 1 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 1,
	day	=> 9,
    ),
);
cmp_ok( $dts->day(), '==', 17, 'day() on 2000-01-09 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Trewsday', 'day_name() on 2000-01-09 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Trewesdei', 'day_name_trad() on 2000-01-09 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 17, 'day_of_month() on 2000-01-09 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 4, 'day_of_week() on 2000-01-09 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 18, 'day_of_year() on 2000-01-09 Gregorian' );
cmp_ok( $dts->dow(), '==', 4, 'dow() on 2000-01-09 Gregorian' );
cmp_ok( $dts->doy(), '==', 18, 'doy() on 2000-01-09 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-01-09 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-01-09 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-01-09 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-01-09 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-01-09 Gregorian' );
cmp_ok( $dts->mday(), '==', 17, 'mday() on 2000-01-09 Gregorian' );
cmp_ok( $dts->month(), '==', 1, 'month() on 2000-01-09 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afteryule', 'month_name() on 2000-01-09 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-01-09 Gregorian' );
Trewsday 17 Afteryule 7464

The Company of the Ring comes to Caras Galadhon at evening, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63083059200, 'utc_rd_as_seconds() on 2000-01-09 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730128,
  0,
  0
]
, 'utc_rd_values() on 2000-01-09 Gregorian' );
cmp_ok( $dts->wday(), '==', 4, 'wday() on 2000-01-09 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  3
]
, 'week() on 2000-01-09 Gregorian' );
cmp_ok( $dts->week_number(), '==', 3, 'week_number() on 2000-01-09 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-01-09 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-01-09 Gregorian' );

$epoch = timegm( 0, 0, 0, 10, 1 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 1,
	day	=> 10,
    ),
);
cmp_ok( $dts->day(), '==', 18, 'day() on 2000-01-10 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Hevensday', 'day_name() on 2000-01-10 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Hevenesdei', 'day_name_trad() on 2000-01-10 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 18, 'day_of_month() on 2000-01-10 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 5, 'day_of_week() on 2000-01-10 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 19, 'day_of_year() on 2000-01-10 Gregorian' );
cmp_ok( $dts->dow(), '==', 5, 'dow() on 2000-01-10 Gregorian' );
cmp_ok( $dts->doy(), '==', 19, 'doy() on 2000-01-10 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-01-10 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-01-10 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-01-10 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-01-10 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-01-10 Gregorian' );
cmp_ok( $dts->mday(), '==', 18, 'mday() on 2000-01-10 Gregorian' );
cmp_ok( $dts->month(), '==', 1, 'month() on 2000-01-10 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afteryule', 'month_name() on 2000-01-10 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-01-10 Gregorian' );
Hevensday 18 Afteryule 7464
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63083145600, 'utc_rd_as_seconds() on 2000-01-10 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730129,
  0,
  0
]
, 'utc_rd_values() on 2000-01-10 Gregorian' );
cmp_ok( $dts->wday(), '==', 5, 'wday() on 2000-01-10 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  3
]
, 'week() on 2000-01-10 Gregorian' );
cmp_ok( $dts->week_number(), '==', 3, 'week_number() on 2000-01-10 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-01-10 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-01-10 Gregorian' );

$epoch = timegm( 0, 0, 0, 11, 1 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 1,
	day	=> 11,
    ),
);
cmp_ok( $dts->day(), '==', 19, 'day() on 2000-01-11 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Mersday', 'day_name() on 2000-01-11 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Meresdei', 'day_name_trad() on 2000-01-11 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 19, 'day_of_month() on 2000-01-11 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 6, 'day_of_week() on 2000-01-11 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 20, 'day_of_year() on 2000-01-11 Gregorian' );
cmp_ok( $dts->dow(), '==', 6, 'dow() on 2000-01-11 Gregorian' );
cmp_ok( $dts->doy(), '==', 20, 'doy() on 2000-01-11 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-01-11 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-01-11 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-01-11 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-01-11 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-01-11 Gregorian' );
cmp_ok( $dts->mday(), '==', 19, 'mday() on 2000-01-11 Gregorian' );
cmp_ok( $dts->month(), '==', 1, 'month() on 2000-01-11 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afteryule', 'month_name() on 2000-01-11 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-01-11 Gregorian' );
Mersday 19 Afteryule 7464
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63083232000, 'utc_rd_as_seconds() on 2000-01-11 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730130,
  0,
  0
]
, 'utc_rd_values() on 2000-01-11 Gregorian' );
cmp_ok( $dts->wday(), '==', 6, 'wday() on 2000-01-11 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  3
]
, 'week() on 2000-01-11 Gregorian' );
cmp_ok( $dts->week_number(), '==', 3, 'week_number() on 2000-01-11 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-01-11 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-01-11 Gregorian' );

$epoch = timegm( 0, 0, 0, 12, 1 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 1,
	day	=> 12,
    ),
);
cmp_ok( $dts->day(), '==', 20, 'day() on 2000-01-12 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Highday', 'day_name() on 2000-01-12 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Highdei', 'day_name_trad() on 2000-01-12 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 20, 'day_of_month() on 2000-01-12 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 7, 'day_of_week() on 2000-01-12 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 21, 'day_of_year() on 2000-01-12 Gregorian' );
cmp_ok( $dts->dow(), '==', 7, 'dow() on 2000-01-12 Gregorian' );
cmp_ok( $dts->doy(), '==', 21, 'doy() on 2000-01-12 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-01-12 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-01-12 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-01-12 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-01-12 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-01-12 Gregorian' );
cmp_ok( $dts->mday(), '==', 20, 'mday() on 2000-01-12 Gregorian' );
cmp_ok( $dts->month(), '==', 1, 'month() on 2000-01-12 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afteryule', 'month_name() on 2000-01-12 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-01-12 Gregorian' );
Highday 20 Afteryule 7464
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63083318400, 'utc_rd_as_seconds() on 2000-01-12 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730131,
  0,
  0
]
, 'utc_rd_values() on 2000-01-12 Gregorian' );
cmp_ok( $dts->wday(), '==', 7, 'wday() on 2000-01-12 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  3
]
, 'week() on 2000-01-12 Gregorian' );
cmp_ok( $dts->week_number(), '==', 3, 'week_number() on 2000-01-12 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-01-12 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-01-12 Gregorian' );

$epoch = timegm( 0, 0, 0, 13, 1 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 1,
	day	=> 13,
    ),
);
cmp_ok( $dts->day(), '==', 21, 'day() on 2000-01-13 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sterday', 'day_name() on 2000-01-13 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sterrendei', 'day_name_trad() on 2000-01-13 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 21, 'day_of_month() on 2000-01-13 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 1, 'day_of_week() on 2000-01-13 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 22, 'day_of_year() on 2000-01-13 Gregorian' );
cmp_ok( $dts->dow(), '==', 1, 'dow() on 2000-01-13 Gregorian' );
cmp_ok( $dts->doy(), '==', 22, 'doy() on 2000-01-13 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-01-13 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-01-13 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-01-13 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-01-13 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-01-13 Gregorian' );
cmp_ok( $dts->mday(), '==', 21, 'mday() on 2000-01-13 Gregorian' );
cmp_ok( $dts->month(), '==', 1, 'month() on 2000-01-13 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afteryule', 'month_name() on 2000-01-13 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-01-13 Gregorian' );
Sterday 21 Afteryule 7464
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63083404800, 'utc_rd_as_seconds() on 2000-01-13 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730132,
  0,
  0
]
, 'utc_rd_values() on 2000-01-13 Gregorian' );
cmp_ok( $dts->wday(), '==', 1, 'wday() on 2000-01-13 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  4
]
, 'week() on 2000-01-13 Gregorian' );
cmp_ok( $dts->week_number(), '==', 4, 'week_number() on 2000-01-13 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-01-13 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-01-13 Gregorian' );

$epoch = timegm( 0, 0, 0, 14, 1 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 1,
	day	=> 14,
    ),
);
cmp_ok( $dts->day(), '==', 22, 'day() on 2000-01-14 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sunday', 'day_name() on 2000-01-14 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sunnendei', 'day_name_trad() on 2000-01-14 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 22, 'day_of_month() on 2000-01-14 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 2, 'day_of_week() on 2000-01-14 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 23, 'day_of_year() on 2000-01-14 Gregorian' );
cmp_ok( $dts->dow(), '==', 2, 'dow() on 2000-01-14 Gregorian' );
cmp_ok( $dts->doy(), '==', 23, 'doy() on 2000-01-14 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-01-14 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-01-14 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-01-14 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-01-14 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-01-14 Gregorian' );
cmp_ok( $dts->mday(), '==', 22, 'mday() on 2000-01-14 Gregorian' );
cmp_ok( $dts->month(), '==', 1, 'month() on 2000-01-14 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afteryule', 'month_name() on 2000-01-14 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-01-14 Gregorian' );
Sunday 22 Afteryule 7464
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63083491200, 'utc_rd_as_seconds() on 2000-01-14 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730133,
  0,
  0
]
, 'utc_rd_values() on 2000-01-14 Gregorian' );
cmp_ok( $dts->wday(), '==', 2, 'wday() on 2000-01-14 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  4
]
, 'week() on 2000-01-14 Gregorian' );
cmp_ok( $dts->week_number(), '==', 4, 'week_number() on 2000-01-14 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-01-14 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-01-14 Gregorian' );

$epoch = timegm( 0, 0, 0, 15, 1 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 1,
	day	=> 15,
    ),
);
cmp_ok( $dts->day(), '==', 23, 'day() on 2000-01-15 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Monday', 'day_name() on 2000-01-15 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Monendei', 'day_name_trad() on 2000-01-15 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 23, 'day_of_month() on 2000-01-15 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 3, 'day_of_week() on 2000-01-15 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 24, 'day_of_year() on 2000-01-15 Gregorian' );
cmp_ok( $dts->dow(), '==', 3, 'dow() on 2000-01-15 Gregorian' );
cmp_ok( $dts->doy(), '==', 24, 'doy() on 2000-01-15 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-01-15 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-01-15 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-01-15 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-01-15 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-01-15 Gregorian' );
cmp_ok( $dts->mday(), '==', 23, 'mday() on 2000-01-15 Gregorian' );
cmp_ok( $dts->month(), '==', 1, 'month() on 2000-01-15 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afteryule', 'month_name() on 2000-01-15 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-01-15 Gregorian' );
Monday 23 Afteryule 7464

Gandalf pursues the Balrog to the peak of Zirakzigil, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63083577600, 'utc_rd_as_seconds() on 2000-01-15 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730134,
  0,
  0
]
, 'utc_rd_values() on 2000-01-15 Gregorian' );
cmp_ok( $dts->wday(), '==', 3, 'wday() on 2000-01-15 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  4
]
, 'week() on 2000-01-15 Gregorian' );
cmp_ok( $dts->week_number(), '==', 4, 'week_number() on 2000-01-15 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-01-15 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-01-15 Gregorian' );

$epoch = timegm( 0, 0, 0, 16, 1 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 1,
	day	=> 16,
    ),
);
cmp_ok( $dts->day(), '==', 24, 'day() on 2000-01-16 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Trewsday', 'day_name() on 2000-01-16 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Trewesdei', 'day_name_trad() on 2000-01-16 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 24, 'day_of_month() on 2000-01-16 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 4, 'day_of_week() on 2000-01-16 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 25, 'day_of_year() on 2000-01-16 Gregorian' );
cmp_ok( $dts->dow(), '==', 4, 'dow() on 2000-01-16 Gregorian' );
cmp_ok( $dts->doy(), '==', 25, 'doy() on 2000-01-16 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-01-16 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-01-16 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-01-16 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-01-16 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-01-16 Gregorian' );
cmp_ok( $dts->mday(), '==', 24, 'mday() on 2000-01-16 Gregorian' );
cmp_ok( $dts->month(), '==', 1, 'month() on 2000-01-16 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afteryule', 'month_name() on 2000-01-16 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-01-16 Gregorian' );
Trewsday 24 Afteryule 7464
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63083664000, 'utc_rd_as_seconds() on 2000-01-16 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730135,
  0,
  0
]
, 'utc_rd_values() on 2000-01-16 Gregorian' );
cmp_ok( $dts->wday(), '==', 4, 'wday() on 2000-01-16 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  4
]
, 'week() on 2000-01-16 Gregorian' );
cmp_ok( $dts->week_number(), '==', 4, 'week_number() on 2000-01-16 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-01-16 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-01-16 Gregorian' );

$epoch = timegm( 0, 0, 0, 17, 1 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 1,
	day	=> 17,
    ),
);
cmp_ok( $dts->day(), '==', 25, 'day() on 2000-01-17 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Hevensday', 'day_name() on 2000-01-17 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Hevenesdei', 'day_name_trad() on 2000-01-17 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 25, 'day_of_month() on 2000-01-17 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 5, 'day_of_week() on 2000-01-17 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 26, 'day_of_year() on 2000-01-17 Gregorian' );
cmp_ok( $dts->dow(), '==', 5, 'dow() on 2000-01-17 Gregorian' );
cmp_ok( $dts->doy(), '==', 26, 'doy() on 2000-01-17 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-01-17 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-01-17 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-01-17 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-01-17 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-01-17 Gregorian' );
cmp_ok( $dts->mday(), '==', 25, 'mday() on 2000-01-17 Gregorian' );
cmp_ok( $dts->month(), '==', 1, 'month() on 2000-01-17 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afteryule', 'month_name() on 2000-01-17 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-01-17 Gregorian' );
Hevensday 25 Afteryule 7464

Gandalf casts down the Balrog, and passes away.
His body lies on the peak of Zirakzigil, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63083750400, 'utc_rd_as_seconds() on 2000-01-17 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730136,
  0,
  0
]
, 'utc_rd_values() on 2000-01-17 Gregorian' );
cmp_ok( $dts->wday(), '==', 5, 'wday() on 2000-01-17 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  4
]
, 'week() on 2000-01-17 Gregorian' );
cmp_ok( $dts->week_number(), '==', 4, 'week_number() on 2000-01-17 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-01-17 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-01-17 Gregorian' );

$epoch = timegm( 0, 0, 0, 18, 1 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 1,
	day	=> 18,
    ),
);
cmp_ok( $dts->day(), '==', 26, 'day() on 2000-01-18 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Mersday', 'day_name() on 2000-01-18 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Meresdei', 'day_name_trad() on 2000-01-18 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 26, 'day_of_month() on 2000-01-18 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 6, 'day_of_week() on 2000-01-18 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 27, 'day_of_year() on 2000-01-18 Gregorian' );
cmp_ok( $dts->dow(), '==', 6, 'dow() on 2000-01-18 Gregorian' );
cmp_ok( $dts->doy(), '==', 27, 'doy() on 2000-01-18 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-01-18 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-01-18 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-01-18 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-01-18 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-01-18 Gregorian' );
cmp_ok( $dts->mday(), '==', 26, 'mday() on 2000-01-18 Gregorian' );
cmp_ok( $dts->month(), '==', 1, 'month() on 2000-01-18 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afteryule', 'month_name() on 2000-01-18 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-01-18 Gregorian' );
Mersday 26 Afteryule 7464
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63083836800, 'utc_rd_as_seconds() on 2000-01-18 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730137,
  0,
  0
]
, 'utc_rd_values() on 2000-01-18 Gregorian' );
cmp_ok( $dts->wday(), '==', 6, 'wday() on 2000-01-18 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  4
]
, 'week() on 2000-01-18 Gregorian' );
cmp_ok( $dts->week_number(), '==', 4, 'week_number() on 2000-01-18 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-01-18 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-01-18 Gregorian' );

$epoch = timegm( 0, 0, 0, 19, 1 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 1,
	day	=> 19,
    ),
);
cmp_ok( $dts->day(), '==', 27, 'day() on 2000-01-19 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Highday', 'day_name() on 2000-01-19 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Highdei', 'day_name_trad() on 2000-01-19 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 27, 'day_of_month() on 2000-01-19 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 7, 'day_of_week() on 2000-01-19 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 28, 'day_of_year() on 2000-01-19 Gregorian' );
cmp_ok( $dts->dow(), '==', 7, 'dow() on 2000-01-19 Gregorian' );
cmp_ok( $dts->doy(), '==', 28, 'doy() on 2000-01-19 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-01-19 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-01-19 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-01-19 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-01-19 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-01-19 Gregorian' );
cmp_ok( $dts->mday(), '==', 27, 'mday() on 2000-01-19 Gregorian' );
cmp_ok( $dts->month(), '==', 1, 'month() on 2000-01-19 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afteryule', 'month_name() on 2000-01-19 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-01-19 Gregorian' );
Highday 27 Afteryule 7464
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63083923200, 'utc_rd_as_seconds() on 2000-01-19 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730138,
  0,
  0
]
, 'utc_rd_values() on 2000-01-19 Gregorian' );
cmp_ok( $dts->wday(), '==', 7, 'wday() on 2000-01-19 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  4
]
, 'week() on 2000-01-19 Gregorian' );
cmp_ok( $dts->week_number(), '==', 4, 'week_number() on 2000-01-19 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-01-19 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-01-19 Gregorian' );

$epoch = timegm( 0, 0, 0, 20, 1 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 1,
	day	=> 20,
    ),
);
cmp_ok( $dts->day(), '==', 28, 'day() on 2000-01-20 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sterday', 'day_name() on 2000-01-20 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sterrendei', 'day_name_trad() on 2000-01-20 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 28, 'day_of_month() on 2000-01-20 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 1, 'day_of_week() on 2000-01-20 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 29, 'day_of_year() on 2000-01-20 Gregorian' );
cmp_ok( $dts->dow(), '==', 1, 'dow() on 2000-01-20 Gregorian' );
cmp_ok( $dts->doy(), '==', 29, 'doy() on 2000-01-20 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-01-20 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-01-20 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-01-20 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-01-20 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-01-20 Gregorian' );
cmp_ok( $dts->mday(), '==', 28, 'mday() on 2000-01-20 Gregorian' );
cmp_ok( $dts->month(), '==', 1, 'month() on 2000-01-20 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afteryule', 'month_name() on 2000-01-20 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-01-20 Gregorian' );
Sterday 28 Afteryule 7464
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63084009600, 'utc_rd_as_seconds() on 2000-01-20 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730139,
  0,
  0
]
, 'utc_rd_values() on 2000-01-20 Gregorian' );
cmp_ok( $dts->wday(), '==', 1, 'wday() on 2000-01-20 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  5
]
, 'week() on 2000-01-20 Gregorian' );
cmp_ok( $dts->week_number(), '==', 5, 'week_number() on 2000-01-20 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-01-20 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-01-20 Gregorian' );

$epoch = timegm( 0, 0, 0, 21, 1 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 1,
	day	=> 21,
    ),
);
cmp_ok( $dts->day(), '==', 29, 'day() on 2000-01-21 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sunday', 'day_name() on 2000-01-21 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sunnendei', 'day_name_trad() on 2000-01-21 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 29, 'day_of_month() on 2000-01-21 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 2, 'day_of_week() on 2000-01-21 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 30, 'day_of_year() on 2000-01-21 Gregorian' );
cmp_ok( $dts->dow(), '==', 2, 'dow() on 2000-01-21 Gregorian' );
cmp_ok( $dts->doy(), '==', 30, 'doy() on 2000-01-21 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-01-21 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-01-21 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-01-21 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-01-21 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-01-21 Gregorian' );
cmp_ok( $dts->mday(), '==', 29, 'mday() on 2000-01-21 Gregorian' );
cmp_ok( $dts->month(), '==', 1, 'month() on 2000-01-21 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afteryule', 'month_name() on 2000-01-21 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-01-21 Gregorian' );
Sunday 29 Afteryule 7464
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63084096000, 'utc_rd_as_seconds() on 2000-01-21 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730140,
  0,
  0
]
, 'utc_rd_values() on 2000-01-21 Gregorian' );
cmp_ok( $dts->wday(), '==', 2, 'wday() on 2000-01-21 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  5
]
, 'week() on 2000-01-21 Gregorian' );
cmp_ok( $dts->week_number(), '==', 5, 'week_number() on 2000-01-21 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-01-21 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-01-21 Gregorian' );

$epoch = timegm( 0, 0, 0, 22, 1 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 1,
	day	=> 22,
    ),
);
cmp_ok( $dts->day(), '==', 30, 'day() on 2000-01-22 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Monday', 'day_name() on 2000-01-22 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Monendei', 'day_name_trad() on 2000-01-22 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 30, 'day_of_month() on 2000-01-22 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 3, 'day_of_week() on 2000-01-22 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 31, 'day_of_year() on 2000-01-22 Gregorian' );
cmp_ok( $dts->dow(), '==', 3, 'dow() on 2000-01-22 Gregorian' );
cmp_ok( $dts->doy(), '==', 31, 'doy() on 2000-01-22 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-01-22 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-01-22 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-01-22 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-01-22 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-01-22 Gregorian' );
cmp_ok( $dts->mday(), '==', 30, 'mday() on 2000-01-22 Gregorian' );
cmp_ok( $dts->month(), '==', 1, 'month() on 2000-01-22 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Afteryule', 'month_name() on 2000-01-22 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-01-22 Gregorian' );
Monday 30 Afteryule 7464
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63084182400, 'utc_rd_as_seconds() on 2000-01-22 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730141,
  0,
  0
]
, 'utc_rd_values() on 2000-01-22 Gregorian' );
cmp_ok( $dts->wday(), '==', 3, 'wday() on 2000-01-22 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  5
]
, 'week() on 2000-01-22 Gregorian' );
cmp_ok( $dts->week_number(), '==', 5, 'week_number() on 2000-01-22 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-01-22 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-01-22 Gregorian' );

$epoch = timegm( 0, 0, 0, 23, 1 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 1,
	day	=> 23,
    ),
);
cmp_ok( $dts->day(), '==', 1, 'day() on 2000-01-23 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Trewsday', 'day_name() on 2000-01-23 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Trewesdei', 'day_name_trad() on 2000-01-23 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 1, 'day_of_month() on 2000-01-23 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 4, 'day_of_week() on 2000-01-23 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 32, 'day_of_year() on 2000-01-23 Gregorian' );
cmp_ok( $dts->dow(), '==', 4, 'dow() on 2000-01-23 Gregorian' );
cmp_ok( $dts->doy(), '==', 32, 'doy() on 2000-01-23 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-01-23 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-01-23 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-01-23 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-01-23 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-01-23 Gregorian' );
cmp_ok( $dts->mday(), '==', 1, 'mday() on 2000-01-23 Gregorian' );
cmp_ok( $dts->month(), '==', 2, 'month() on 2000-01-23 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Solmath', 'month_name() on 2000-01-23 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-01-23 Gregorian' );
Trewsday 1 Solmath 7464
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63084268800, 'utc_rd_as_seconds() on 2000-01-23 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730142,
  0,
  0
]
, 'utc_rd_values() on 2000-01-23 Gregorian' );
cmp_ok( $dts->wday(), '==', 4, 'wday() on 2000-01-23 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  5
]
, 'week() on 2000-01-23 Gregorian' );
cmp_ok( $dts->week_number(), '==', 5, 'week_number() on 2000-01-23 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-01-23 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-01-23 Gregorian' );

$epoch = timegm( 0, 0, 0, 24, 1 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 1,
	day	=> 24,
    ),
);
cmp_ok( $dts->day(), '==', 2, 'day() on 2000-01-24 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Hevensday', 'day_name() on 2000-01-24 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Hevenesdei', 'day_name_trad() on 2000-01-24 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 2, 'day_of_month() on 2000-01-24 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 5, 'day_of_week() on 2000-01-24 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 33, 'day_of_year() on 2000-01-24 Gregorian' );
cmp_ok( $dts->dow(), '==', 5, 'dow() on 2000-01-24 Gregorian' );
cmp_ok( $dts->doy(), '==', 33, 'doy() on 2000-01-24 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-01-24 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-01-24 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-01-24 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-01-24 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-01-24 Gregorian' );
cmp_ok( $dts->mday(), '==', 2, 'mday() on 2000-01-24 Gregorian' );
cmp_ok( $dts->month(), '==', 2, 'month() on 2000-01-24 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Solmath', 'month_name() on 2000-01-24 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-01-24 Gregorian' );
Hevensday 2 Solmath 7464
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63084355200, 'utc_rd_as_seconds() on 2000-01-24 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730143,
  0,
  0
]
, 'utc_rd_values() on 2000-01-24 Gregorian' );
cmp_ok( $dts->wday(), '==', 5, 'wday() on 2000-01-24 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  5
]
, 'week() on 2000-01-24 Gregorian' );
cmp_ok( $dts->week_number(), '==', 5, 'week_number() on 2000-01-24 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-01-24 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-01-24 Gregorian' );

$epoch = timegm( 0, 0, 0, 25, 1 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 1,
	day	=> 25,
    ),
);
cmp_ok( $dts->day(), '==', 3, 'day() on 2000-01-25 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Mersday', 'day_name() on 2000-01-25 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Meresdei', 'day_name_trad() on 2000-01-25 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 3, 'day_of_month() on 2000-01-25 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 6, 'day_of_week() on 2000-01-25 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 34, 'day_of_year() on 2000-01-25 Gregorian' );
cmp_ok( $dts->dow(), '==', 6, 'dow() on 2000-01-25 Gregorian' );
cmp_ok( $dts->doy(), '==', 34, 'doy() on 2000-01-25 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-01-25 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-01-25 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-01-25 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-01-25 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-01-25 Gregorian' );
cmp_ok( $dts->mday(), '==', 3, 'mday() on 2000-01-25 Gregorian' );
cmp_ok( $dts->month(), '==', 2, 'month() on 2000-01-25 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Solmath', 'month_name() on 2000-01-25 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-01-25 Gregorian' );
Mersday 3 Solmath 7464
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63084441600, 'utc_rd_as_seconds() on 2000-01-25 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730144,
  0,
  0
]
, 'utc_rd_values() on 2000-01-25 Gregorian' );
cmp_ok( $dts->wday(), '==', 6, 'wday() on 2000-01-25 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  5
]
, 'week() on 2000-01-25 Gregorian' );
cmp_ok( $dts->week_number(), '==', 5, 'week_number() on 2000-01-25 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-01-25 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-01-25 Gregorian' );

$epoch = timegm( 0, 0, 0, 26, 1 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 1,
	day	=> 26,
    ),
);
cmp_ok( $dts->day(), '==', 4, 'day() on 2000-01-26 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Highday', 'day_name() on 2000-01-26 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Highdei', 'day_name_trad() on 2000-01-26 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 4, 'day_of_month() on 2000-01-26 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 7, 'day_of_week() on 2000-01-26 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 35, 'day_of_year() on 2000-01-26 Gregorian' );
cmp_ok( $dts->dow(), '==', 7, 'dow() on 2000-01-26 Gregorian' );
cmp_ok( $dts->doy(), '==', 35, 'doy() on 2000-01-26 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-01-26 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-01-26 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-01-26 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-01-26 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-01-26 Gregorian' );
cmp_ok( $dts->mday(), '==', 4, 'mday() on 2000-01-26 Gregorian' );
cmp_ok( $dts->month(), '==', 2, 'month() on 2000-01-26 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Solmath', 'month_name() on 2000-01-26 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-01-26 Gregorian' );
Highday 4 Solmath 7464
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63084528000, 'utc_rd_as_seconds() on 2000-01-26 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730145,
  0,
  0
]
, 'utc_rd_values() on 2000-01-26 Gregorian' );
cmp_ok( $dts->wday(), '==', 7, 'wday() on 2000-01-26 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  5
]
, 'week() on 2000-01-26 Gregorian' );
cmp_ok( $dts->week_number(), '==', 5, 'week_number() on 2000-01-26 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-01-26 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-01-26 Gregorian' );

$epoch = timegm( 0, 0, 0, 27, 1 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 1,
	day	=> 27,
    ),
);
cmp_ok( $dts->day(), '==', 5, 'day() on 2000-01-27 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sterday', 'day_name() on 2000-01-27 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sterrendei', 'day_name_trad() on 2000-01-27 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 5, 'day_of_month() on 2000-01-27 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 1, 'day_of_week() on 2000-01-27 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 36, 'day_of_year() on 2000-01-27 Gregorian' );
cmp_ok( $dts->dow(), '==', 1, 'dow() on 2000-01-27 Gregorian' );
cmp_ok( $dts->doy(), '==', 36, 'doy() on 2000-01-27 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-01-27 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-01-27 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-01-27 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-01-27 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-01-27 Gregorian' );
cmp_ok( $dts->mday(), '==', 5, 'mday() on 2000-01-27 Gregorian' );
cmp_ok( $dts->month(), '==', 2, 'month() on 2000-01-27 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Solmath', 'month_name() on 2000-01-27 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-01-27 Gregorian' );
Sterday 5 Solmath 7464
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63084614400, 'utc_rd_as_seconds() on 2000-01-27 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730146,
  0,
  0
]
, 'utc_rd_values() on 2000-01-27 Gregorian' );
cmp_ok( $dts->wday(), '==', 1, 'wday() on 2000-01-27 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  6
]
, 'week() on 2000-01-27 Gregorian' );
cmp_ok( $dts->week_number(), '==', 6, 'week_number() on 2000-01-27 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-01-27 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-01-27 Gregorian' );

$epoch = timegm( 0, 0, 0, 28, 1 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 1,
	day	=> 28,
    ),
);
cmp_ok( $dts->day(), '==', 6, 'day() on 2000-01-28 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sunday', 'day_name() on 2000-01-28 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sunnendei', 'day_name_trad() on 2000-01-28 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 6, 'day_of_month() on 2000-01-28 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 2, 'day_of_week() on 2000-01-28 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 37, 'day_of_year() on 2000-01-28 Gregorian' );
cmp_ok( $dts->dow(), '==', 2, 'dow() on 2000-01-28 Gregorian' );
cmp_ok( $dts->doy(), '==', 37, 'doy() on 2000-01-28 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-01-28 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-01-28 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-01-28 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-01-28 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-01-28 Gregorian' );
cmp_ok( $dts->mday(), '==', 6, 'mday() on 2000-01-28 Gregorian' );
cmp_ok( $dts->month(), '==', 2, 'month() on 2000-01-28 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Solmath', 'month_name() on 2000-01-28 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-01-28 Gregorian' );
Sunday 6 Solmath 7464
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63084700800, 'utc_rd_as_seconds() on 2000-01-28 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730147,
  0,
  0
]
, 'utc_rd_values() on 2000-01-28 Gregorian' );
cmp_ok( $dts->wday(), '==', 2, 'wday() on 2000-01-28 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  6
]
, 'week() on 2000-01-28 Gregorian' );
cmp_ok( $dts->week_number(), '==', 6, 'week_number() on 2000-01-28 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-01-28 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-01-28 Gregorian' );

$epoch = timegm( 0, 0, 0, 29, 1 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 1,
	day	=> 29,
    ),
);
cmp_ok( $dts->day(), '==', 7, 'day() on 2000-01-29 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Monday', 'day_name() on 2000-01-29 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Monendei', 'day_name_trad() on 2000-01-29 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 7, 'day_of_month() on 2000-01-29 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 3, 'day_of_week() on 2000-01-29 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 38, 'day_of_year() on 2000-01-29 Gregorian' );
cmp_ok( $dts->dow(), '==', 3, 'dow() on 2000-01-29 Gregorian' );
cmp_ok( $dts->doy(), '==', 38, 'doy() on 2000-01-29 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-01-29 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-01-29 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-01-29 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-01-29 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-01-29 Gregorian' );
cmp_ok( $dts->mday(), '==', 7, 'mday() on 2000-01-29 Gregorian' );
cmp_ok( $dts->month(), '==', 2, 'month() on 2000-01-29 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Solmath', 'month_name() on 2000-01-29 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-01-29 Gregorian' );
Monday 7 Solmath 7464
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63084787200, 'utc_rd_as_seconds() on 2000-01-29 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730148,
  0,
  0
]
, 'utc_rd_values() on 2000-01-29 Gregorian' );
cmp_ok( $dts->wday(), '==', 3, 'wday() on 2000-01-29 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  6
]
, 'week() on 2000-01-29 Gregorian' );
cmp_ok( $dts->week_number(), '==', 6, 'week_number() on 2000-01-29 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-01-29 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-01-29 Gregorian' );

$epoch = timegm( 0, 0, 0, 30, 1 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 1,
	day	=> 30,
    ),
);
cmp_ok( $dts->day(), '==', 8, 'day() on 2000-01-30 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Trewsday', 'day_name() on 2000-01-30 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Trewesdei', 'day_name_trad() on 2000-01-30 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 8, 'day_of_month() on 2000-01-30 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 4, 'day_of_week() on 2000-01-30 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 39, 'day_of_year() on 2000-01-30 Gregorian' );
cmp_ok( $dts->dow(), '==', 4, 'dow() on 2000-01-30 Gregorian' );
cmp_ok( $dts->doy(), '==', 39, 'doy() on 2000-01-30 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-01-30 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-01-30 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-01-30 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-01-30 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-01-30 Gregorian' );
cmp_ok( $dts->mday(), '==', 8, 'mday() on 2000-01-30 Gregorian' );
cmp_ok( $dts->month(), '==', 2, 'month() on 2000-01-30 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Solmath', 'month_name() on 2000-01-30 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-01-30 Gregorian' );
Trewsday 8 Solmath 7464
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63084873600, 'utc_rd_as_seconds() on 2000-01-30 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730149,
  0,
  0
]
, 'utc_rd_values() on 2000-01-30 Gregorian' );
cmp_ok( $dts->wday(), '==', 4, 'wday() on 2000-01-30 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  6
]
, 'week() on 2000-01-30 Gregorian' );
cmp_ok( $dts->week_number(), '==', 6, 'week_number() on 2000-01-30 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-01-30 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-01-30 Gregorian' );

$epoch = timegm( 0, 0, 0, 31, 1 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 1,
	day	=> 31,
    ),
);
cmp_ok( $dts->day(), '==', 9, 'day() on 2000-01-31 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Hevensday', 'day_name() on 2000-01-31 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Hevenesdei', 'day_name_trad() on 2000-01-31 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 9, 'day_of_month() on 2000-01-31 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 5, 'day_of_week() on 2000-01-31 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 40, 'day_of_year() on 2000-01-31 Gregorian' );
cmp_ok( $dts->dow(), '==', 5, 'dow() on 2000-01-31 Gregorian' );
cmp_ok( $dts->doy(), '==', 40, 'doy() on 2000-01-31 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-01-31 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-01-31 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-01-31 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-01-31 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-01-31 Gregorian' );
cmp_ok( $dts->mday(), '==', 9, 'mday() on 2000-01-31 Gregorian' );
cmp_ok( $dts->month(), '==', 2, 'month() on 2000-01-31 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Solmath', 'month_name() on 2000-01-31 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-01-31 Gregorian' );
Hevensday 9 Solmath 7464
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63084960000, 'utc_rd_as_seconds() on 2000-01-31 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730150,
  0,
  0
]
, 'utc_rd_values() on 2000-01-31 Gregorian' );
cmp_ok( $dts->wday(), '==', 5, 'wday() on 2000-01-31 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  6
]
, 'week() on 2000-01-31 Gregorian' );
cmp_ok( $dts->week_number(), '==', 6, 'week_number() on 2000-01-31 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-01-31 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-01-31 Gregorian' );

$epoch = timegm( 0, 0, 0, 1, 2 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 2,
	day	=> 1,
    ),
);
cmp_ok( $dts->day(), '==', 10, 'day() on 2000-02-01 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Mersday', 'day_name() on 2000-02-01 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Meresdei', 'day_name_trad() on 2000-02-01 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 10, 'day_of_month() on 2000-02-01 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 6, 'day_of_week() on 2000-02-01 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 41, 'day_of_year() on 2000-02-01 Gregorian' );
cmp_ok( $dts->dow(), '==', 6, 'dow() on 2000-02-01 Gregorian' );
cmp_ok( $dts->doy(), '==', 41, 'doy() on 2000-02-01 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-02-01 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-02-01 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-02-01 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-02-01 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-02-01 Gregorian' );
cmp_ok( $dts->mday(), '==', 10, 'mday() on 2000-02-01 Gregorian' );
cmp_ok( $dts->month(), '==', 2, 'month() on 2000-02-01 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Solmath', 'month_name() on 2000-02-01 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-02-01 Gregorian' );
Mersday 10 Solmath 7464
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63085046400, 'utc_rd_as_seconds() on 2000-02-01 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730151,
  0,
  0
]
, 'utc_rd_values() on 2000-02-01 Gregorian' );
cmp_ok( $dts->wday(), '==', 6, 'wday() on 2000-02-01 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  6
]
, 'week() on 2000-02-01 Gregorian' );
cmp_ok( $dts->week_number(), '==', 6, 'week_number() on 2000-02-01 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-02-01 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-02-01 Gregorian' );

$epoch = timegm( 0, 0, 0, 2, 2 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 2,
	day	=> 2,
    ),
);
cmp_ok( $dts->day(), '==', 11, 'day() on 2000-02-02 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Highday', 'day_name() on 2000-02-02 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Highdei', 'day_name_trad() on 2000-02-02 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 11, 'day_of_month() on 2000-02-02 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 7, 'day_of_week() on 2000-02-02 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 42, 'day_of_year() on 2000-02-02 Gregorian' );
cmp_ok( $dts->dow(), '==', 7, 'dow() on 2000-02-02 Gregorian' );
cmp_ok( $dts->doy(), '==', 42, 'doy() on 2000-02-02 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-02-02 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-02-02 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-02-02 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-02-02 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-02-02 Gregorian' );
cmp_ok( $dts->mday(), '==', 11, 'mday() on 2000-02-02 Gregorian' );
cmp_ok( $dts->month(), '==', 2, 'month() on 2000-02-02 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Solmath', 'month_name() on 2000-02-02 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-02-02 Gregorian' );
Highday 11 Solmath 7464
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63085132800, 'utc_rd_as_seconds() on 2000-02-02 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730152,
  0,
  0
]
, 'utc_rd_values() on 2000-02-02 Gregorian' );
cmp_ok( $dts->wday(), '==', 7, 'wday() on 2000-02-02 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  6
]
, 'week() on 2000-02-02 Gregorian' );
cmp_ok( $dts->week_number(), '==', 6, 'week_number() on 2000-02-02 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-02-02 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-02-02 Gregorian' );

$epoch = timegm( 0, 0, 0, 3, 2 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 2,
	day	=> 3,
    ),
);
cmp_ok( $dts->day(), '==', 12, 'day() on 2000-02-03 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sterday', 'day_name() on 2000-02-03 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sterrendei', 'day_name_trad() on 2000-02-03 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 12, 'day_of_month() on 2000-02-03 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 1, 'day_of_week() on 2000-02-03 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 43, 'day_of_year() on 2000-02-03 Gregorian' );
cmp_ok( $dts->dow(), '==', 1, 'dow() on 2000-02-03 Gregorian' );
cmp_ok( $dts->doy(), '==', 43, 'doy() on 2000-02-03 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-02-03 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-02-03 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-02-03 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-02-03 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-02-03 Gregorian' );
cmp_ok( $dts->mday(), '==', 12, 'mday() on 2000-02-03 Gregorian' );
cmp_ok( $dts->month(), '==', 2, 'month() on 2000-02-03 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Solmath', 'month_name() on 2000-02-03 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-02-03 Gregorian' );
Sterday 12 Solmath 7464
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63085219200, 'utc_rd_as_seconds() on 2000-02-03 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730153,
  0,
  0
]
, 'utc_rd_values() on 2000-02-03 Gregorian' );
cmp_ok( $dts->wday(), '==', 1, 'wday() on 2000-02-03 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  7
]
, 'week() on 2000-02-03 Gregorian' );
cmp_ok( $dts->week_number(), '==', 7, 'week_number() on 2000-02-03 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-02-03 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-02-03 Gregorian' );

$epoch = timegm( 0, 0, 0, 4, 2 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 2,
	day	=> 4,
    ),
);
cmp_ok( $dts->day(), '==', 13, 'day() on 2000-02-04 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sunday', 'day_name() on 2000-02-04 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sunnendei', 'day_name_trad() on 2000-02-04 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 13, 'day_of_month() on 2000-02-04 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 2, 'day_of_week() on 2000-02-04 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 44, 'day_of_year() on 2000-02-04 Gregorian' );
cmp_ok( $dts->dow(), '==', 2, 'dow() on 2000-02-04 Gregorian' );
cmp_ok( $dts->doy(), '==', 44, 'doy() on 2000-02-04 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-02-04 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-02-04 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-02-04 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-02-04 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-02-04 Gregorian' );
cmp_ok( $dts->mday(), '==', 13, 'mday() on 2000-02-04 Gregorian' );
cmp_ok( $dts->month(), '==', 2, 'month() on 2000-02-04 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Solmath', 'month_name() on 2000-02-04 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-02-04 Gregorian' );
Sunday 13 Solmath 7464
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63085305600, 'utc_rd_as_seconds() on 2000-02-04 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730154,
  0,
  0
]
, 'utc_rd_values() on 2000-02-04 Gregorian' );
cmp_ok( $dts->wday(), '==', 2, 'wday() on 2000-02-04 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  7
]
, 'week() on 2000-02-04 Gregorian' );
cmp_ok( $dts->week_number(), '==', 7, 'week_number() on 2000-02-04 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-02-04 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-02-04 Gregorian' );

$epoch = timegm( 0, 0, 0, 5, 2 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 2,
	day	=> 5,
    ),
);
cmp_ok( $dts->day(), '==', 14, 'day() on 2000-02-05 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Monday', 'day_name() on 2000-02-05 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Monendei', 'day_name_trad() on 2000-02-05 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 14, 'day_of_month() on 2000-02-05 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 3, 'day_of_week() on 2000-02-05 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 45, 'day_of_year() on 2000-02-05 Gregorian' );
cmp_ok( $dts->dow(), '==', 3, 'dow() on 2000-02-05 Gregorian' );
cmp_ok( $dts->doy(), '==', 45, 'doy() on 2000-02-05 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-02-05 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-02-05 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-02-05 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-02-05 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-02-05 Gregorian' );
cmp_ok( $dts->mday(), '==', 14, 'mday() on 2000-02-05 Gregorian' );
cmp_ok( $dts->month(), '==', 2, 'month() on 2000-02-05 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Solmath', 'month_name() on 2000-02-05 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-02-05 Gregorian' );
Monday 14 Solmath 7464

Frodo and Sam look in the Mirror of Galadriel, 1419.
Gandalf returns to life, and lies in a trance, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63085392000, 'utc_rd_as_seconds() on 2000-02-05 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730155,
  0,
  0
]
, 'utc_rd_values() on 2000-02-05 Gregorian' );
cmp_ok( $dts->wday(), '==', 3, 'wday() on 2000-02-05 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  7
]
, 'week() on 2000-02-05 Gregorian' );
cmp_ok( $dts->week_number(), '==', 7, 'week_number() on 2000-02-05 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-02-05 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-02-05 Gregorian' );

$epoch = timegm( 0, 0, 0, 6, 2 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 2,
	day	=> 6,
    ),
);
cmp_ok( $dts->day(), '==', 15, 'day() on 2000-02-06 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Trewsday', 'day_name() on 2000-02-06 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Trewesdei', 'day_name_trad() on 2000-02-06 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 15, 'day_of_month() on 2000-02-06 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 4, 'day_of_week() on 2000-02-06 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 46, 'day_of_year() on 2000-02-06 Gregorian' );
cmp_ok( $dts->dow(), '==', 4, 'dow() on 2000-02-06 Gregorian' );
cmp_ok( $dts->doy(), '==', 46, 'doy() on 2000-02-06 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-02-06 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-02-06 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-02-06 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-02-06 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-02-06 Gregorian' );
cmp_ok( $dts->mday(), '==', 15, 'mday() on 2000-02-06 Gregorian' );
cmp_ok( $dts->month(), '==', 2, 'month() on 2000-02-06 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Solmath', 'month_name() on 2000-02-06 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-02-06 Gregorian' );
Trewsday 15 Solmath 7464
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63085478400, 'utc_rd_as_seconds() on 2000-02-06 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730156,
  0,
  0
]
, 'utc_rd_values() on 2000-02-06 Gregorian' );
cmp_ok( $dts->wday(), '==', 4, 'wday() on 2000-02-06 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  7
]
, 'week() on 2000-02-06 Gregorian' );
cmp_ok( $dts->week_number(), '==', 7, 'week_number() on 2000-02-06 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-02-06 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-02-06 Gregorian' );

$epoch = timegm( 0, 0, 0, 7, 2 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 2,
	day	=> 7,
    ),
);
cmp_ok( $dts->day(), '==', 16, 'day() on 2000-02-07 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Hevensday', 'day_name() on 2000-02-07 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Hevenesdei', 'day_name_trad() on 2000-02-07 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 16, 'day_of_month() on 2000-02-07 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 5, 'day_of_week() on 2000-02-07 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 47, 'day_of_year() on 2000-02-07 Gregorian' );
cmp_ok( $dts->dow(), '==', 5, 'dow() on 2000-02-07 Gregorian' );
cmp_ok( $dts->doy(), '==', 47, 'doy() on 2000-02-07 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-02-07 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-02-07 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-02-07 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-02-07 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-02-07 Gregorian' );
cmp_ok( $dts->mday(), '==', 16, 'mday() on 2000-02-07 Gregorian' );
cmp_ok( $dts->month(), '==', 2, 'month() on 2000-02-07 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Solmath', 'month_name() on 2000-02-07 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-02-07 Gregorian' );
Hevensday 16 Solmath 7464

Company of the Ring says farewell to Lorien --
Gollum observes departure, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63085564800, 'utc_rd_as_seconds() on 2000-02-07 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730157,
  0,
  0
]
, 'utc_rd_values() on 2000-02-07 Gregorian' );
cmp_ok( $dts->wday(), '==', 5, 'wday() on 2000-02-07 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  7
]
, 'week() on 2000-02-07 Gregorian' );
cmp_ok( $dts->week_number(), '==', 7, 'week_number() on 2000-02-07 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-02-07 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-02-07 Gregorian' );

$epoch = timegm( 0, 0, 0, 8, 2 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 2,
	day	=> 8,
    ),
);
cmp_ok( $dts->day(), '==', 17, 'day() on 2000-02-08 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Mersday', 'day_name() on 2000-02-08 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Meresdei', 'day_name_trad() on 2000-02-08 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 17, 'day_of_month() on 2000-02-08 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 6, 'day_of_week() on 2000-02-08 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 48, 'day_of_year() on 2000-02-08 Gregorian' );
cmp_ok( $dts->dow(), '==', 6, 'dow() on 2000-02-08 Gregorian' );
cmp_ok( $dts->doy(), '==', 48, 'doy() on 2000-02-08 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-02-08 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-02-08 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-02-08 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-02-08 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-02-08 Gregorian' );
cmp_ok( $dts->mday(), '==', 17, 'mday() on 2000-02-08 Gregorian' );
cmp_ok( $dts->month(), '==', 2, 'month() on 2000-02-08 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Solmath', 'month_name() on 2000-02-08 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-02-08 Gregorian' );
Mersday 17 Solmath 7464

Gwaihir the eagle bears Gandalf to Lorien, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63085651200, 'utc_rd_as_seconds() on 2000-02-08 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730158,
  0,
  0
]
, 'utc_rd_values() on 2000-02-08 Gregorian' );
cmp_ok( $dts->wday(), '==', 6, 'wday() on 2000-02-08 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  7
]
, 'week() on 2000-02-08 Gregorian' );
cmp_ok( $dts->week_number(), '==', 7, 'week_number() on 2000-02-08 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-02-08 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-02-08 Gregorian' );

$epoch = timegm( 0, 0, 0, 9, 2 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 2,
	day	=> 9,
    ),
);
cmp_ok( $dts->day(), '==', 18, 'day() on 2000-02-09 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Highday', 'day_name() on 2000-02-09 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Highdei', 'day_name_trad() on 2000-02-09 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 18, 'day_of_month() on 2000-02-09 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 7, 'day_of_week() on 2000-02-09 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 49, 'day_of_year() on 2000-02-09 Gregorian' );
cmp_ok( $dts->dow(), '==', 7, 'dow() on 2000-02-09 Gregorian' );
cmp_ok( $dts->doy(), '==', 49, 'doy() on 2000-02-09 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-02-09 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-02-09 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-02-09 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-02-09 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-02-09 Gregorian' );
cmp_ok( $dts->mday(), '==', 18, 'mday() on 2000-02-09 Gregorian' );
cmp_ok( $dts->month(), '==', 2, 'month() on 2000-02-09 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Solmath', 'month_name() on 2000-02-09 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-02-09 Gregorian' );
Highday 18 Solmath 7464
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63085737600, 'utc_rd_as_seconds() on 2000-02-09 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730159,
  0,
  0
]
, 'utc_rd_values() on 2000-02-09 Gregorian' );
cmp_ok( $dts->wday(), '==', 7, 'wday() on 2000-02-09 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  7
]
, 'week() on 2000-02-09 Gregorian' );
cmp_ok( $dts->week_number(), '==', 7, 'week_number() on 2000-02-09 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-02-09 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-02-09 Gregorian' );

$epoch = timegm( 0, 0, 0, 10, 2 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 2,
	day	=> 10,
    ),
);
cmp_ok( $dts->day(), '==', 19, 'day() on 2000-02-10 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sterday', 'day_name() on 2000-02-10 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sterrendei', 'day_name_trad() on 2000-02-10 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 19, 'day_of_month() on 2000-02-10 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 1, 'day_of_week() on 2000-02-10 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 50, 'day_of_year() on 2000-02-10 Gregorian' );
cmp_ok( $dts->dow(), '==', 1, 'dow() on 2000-02-10 Gregorian' );
cmp_ok( $dts->doy(), '==', 50, 'doy() on 2000-02-10 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-02-10 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-02-10 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-02-10 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-02-10 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-02-10 Gregorian' );
cmp_ok( $dts->mday(), '==', 19, 'mday() on 2000-02-10 Gregorian' );
cmp_ok( $dts->month(), '==', 2, 'month() on 2000-02-10 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Solmath', 'month_name() on 2000-02-10 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-02-10 Gregorian' );
Sterday 19 Solmath 7464
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63085824000, 'utc_rd_as_seconds() on 2000-02-10 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730160,
  0,
  0
]
, 'utc_rd_values() on 2000-02-10 Gregorian' );
cmp_ok( $dts->wday(), '==', 1, 'wday() on 2000-02-10 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  8
]
, 'week() on 2000-02-10 Gregorian' );
cmp_ok( $dts->week_number(), '==', 8, 'week_number() on 2000-02-10 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-02-10 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-02-10 Gregorian' );

$epoch = timegm( 0, 0, 0, 11, 2 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 2,
	day	=> 11,
    ),
);
cmp_ok( $dts->day(), '==', 20, 'day() on 2000-02-11 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sunday', 'day_name() on 2000-02-11 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sunnendei', 'day_name_trad() on 2000-02-11 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 20, 'day_of_month() on 2000-02-11 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 2, 'day_of_week() on 2000-02-11 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 51, 'day_of_year() on 2000-02-11 Gregorian' );
cmp_ok( $dts->dow(), '==', 2, 'dow() on 2000-02-11 Gregorian' );
cmp_ok( $dts->doy(), '==', 51, 'doy() on 2000-02-11 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-02-11 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-02-11 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-02-11 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-02-11 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-02-11 Gregorian' );
cmp_ok( $dts->mday(), '==', 20, 'mday() on 2000-02-11 Gregorian' );
cmp_ok( $dts->month(), '==', 2, 'month() on 2000-02-11 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Solmath', 'month_name() on 2000-02-11 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-02-11 Gregorian' );
Sunday 20 Solmath 7464
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63085910400, 'utc_rd_as_seconds() on 2000-02-11 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730161,
  0,
  0
]
, 'utc_rd_values() on 2000-02-11 Gregorian' );
cmp_ok( $dts->wday(), '==', 2, 'wday() on 2000-02-11 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  8
]
, 'week() on 2000-02-11 Gregorian' );
cmp_ok( $dts->week_number(), '==', 8, 'week_number() on 2000-02-11 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-02-11 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-02-11 Gregorian' );

$epoch = timegm( 0, 0, 0, 12, 2 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 2,
	day	=> 12,
    ),
);
cmp_ok( $dts->day(), '==', 21, 'day() on 2000-02-12 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Monday', 'day_name() on 2000-02-12 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Monendei', 'day_name_trad() on 2000-02-12 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 21, 'day_of_month() on 2000-02-12 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 3, 'day_of_week() on 2000-02-12 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 52, 'day_of_year() on 2000-02-12 Gregorian' );
cmp_ok( $dts->dow(), '==', 3, 'dow() on 2000-02-12 Gregorian' );
cmp_ok( $dts->doy(), '==', 52, 'doy() on 2000-02-12 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-02-12 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-02-12 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-02-12 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-02-12 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-02-12 Gregorian' );
cmp_ok( $dts->mday(), '==', 21, 'mday() on 2000-02-12 Gregorian' );
cmp_ok( $dts->month(), '==', 2, 'month() on 2000-02-12 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Solmath', 'month_name() on 2000-02-12 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-02-12 Gregorian' );
Monday 21 Solmath 7464
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63085996800, 'utc_rd_as_seconds() on 2000-02-12 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730162,
  0,
  0
]
, 'utc_rd_values() on 2000-02-12 Gregorian' );
cmp_ok( $dts->wday(), '==', 3, 'wday() on 2000-02-12 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  8
]
, 'week() on 2000-02-12 Gregorian' );
cmp_ok( $dts->week_number(), '==', 8, 'week_number() on 2000-02-12 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-02-12 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-02-12 Gregorian' );

$epoch = timegm( 0, 0, 0, 13, 2 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 2,
	day	=> 13,
    ),
);
cmp_ok( $dts->day(), '==', 22, 'day() on 2000-02-13 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Trewsday', 'day_name() on 2000-02-13 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Trewesdei', 'day_name_trad() on 2000-02-13 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 22, 'day_of_month() on 2000-02-13 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 4, 'day_of_week() on 2000-02-13 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 53, 'day_of_year() on 2000-02-13 Gregorian' );
cmp_ok( $dts->dow(), '==', 4, 'dow() on 2000-02-13 Gregorian' );
cmp_ok( $dts->doy(), '==', 53, 'doy() on 2000-02-13 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-02-13 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-02-13 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-02-13 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-02-13 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-02-13 Gregorian' );
cmp_ok( $dts->mday(), '==', 22, 'mday() on 2000-02-13 Gregorian' );
cmp_ok( $dts->month(), '==', 2, 'month() on 2000-02-13 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Solmath', 'month_name() on 2000-02-13 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-02-13 Gregorian' );
Trewsday 22 Solmath 7464
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63086083200, 'utc_rd_as_seconds() on 2000-02-13 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730163,
  0,
  0
]
, 'utc_rd_values() on 2000-02-13 Gregorian' );
cmp_ok( $dts->wday(), '==', 4, 'wday() on 2000-02-13 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  8
]
, 'week() on 2000-02-13 Gregorian' );
cmp_ok( $dts->week_number(), '==', 8, 'week_number() on 2000-02-13 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-02-13 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-02-13 Gregorian' );

$epoch = timegm( 0, 0, 0, 14, 2 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 2,
	day	=> 14,
    ),
);
cmp_ok( $dts->day(), '==', 23, 'day() on 2000-02-14 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Hevensday', 'day_name() on 2000-02-14 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Hevenesdei', 'day_name_trad() on 2000-02-14 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 23, 'day_of_month() on 2000-02-14 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 5, 'day_of_week() on 2000-02-14 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 54, 'day_of_year() on 2000-02-14 Gregorian' );
cmp_ok( $dts->dow(), '==', 5, 'dow() on 2000-02-14 Gregorian' );
cmp_ok( $dts->doy(), '==', 54, 'doy() on 2000-02-14 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-02-14 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-02-14 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-02-14 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-02-14 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-02-14 Gregorian' );
cmp_ok( $dts->mday(), '==', 23, 'mday() on 2000-02-14 Gregorian' );
cmp_ok( $dts->month(), '==', 2, 'month() on 2000-02-14 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Solmath', 'month_name() on 2000-02-14 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-02-14 Gregorian' );
Hevensday 23 Solmath 7464
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63086169600, 'utc_rd_as_seconds() on 2000-02-14 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730164,
  0,
  0
]
, 'utc_rd_values() on 2000-02-14 Gregorian' );
cmp_ok( $dts->wday(), '==', 5, 'wday() on 2000-02-14 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  8
]
, 'week() on 2000-02-14 Gregorian' );
cmp_ok( $dts->week_number(), '==', 8, 'week_number() on 2000-02-14 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-02-14 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-02-14 Gregorian' );

$epoch = timegm( 0, 0, 0, 15, 2 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 2,
	day	=> 15,
    ),
);
cmp_ok( $dts->day(), '==', 24, 'day() on 2000-02-15 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Mersday', 'day_name() on 2000-02-15 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Meresdei', 'day_name_trad() on 2000-02-15 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 24, 'day_of_month() on 2000-02-15 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 6, 'day_of_week() on 2000-02-15 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 55, 'day_of_year() on 2000-02-15 Gregorian' );
cmp_ok( $dts->dow(), '==', 6, 'dow() on 2000-02-15 Gregorian' );
cmp_ok( $dts->doy(), '==', 55, 'doy() on 2000-02-15 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-02-15 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-02-15 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-02-15 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-02-15 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-02-15 Gregorian' );
cmp_ok( $dts->mday(), '==', 24, 'mday() on 2000-02-15 Gregorian' );
cmp_ok( $dts->month(), '==', 2, 'month() on 2000-02-15 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Solmath', 'month_name() on 2000-02-15 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-02-15 Gregorian' );
Mersday 24 Solmath 7464
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63086256000, 'utc_rd_as_seconds() on 2000-02-15 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730165,
  0,
  0
]
, 'utc_rd_values() on 2000-02-15 Gregorian' );
cmp_ok( $dts->wday(), '==', 6, 'wday() on 2000-02-15 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  8
]
, 'week() on 2000-02-15 Gregorian' );
cmp_ok( $dts->week_number(), '==', 8, 'week_number() on 2000-02-15 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-02-15 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-02-15 Gregorian' );

$epoch = timegm( 0, 0, 0, 16, 2 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 2,
	day	=> 16,
    ),
);
cmp_ok( $dts->day(), '==', 25, 'day() on 2000-02-16 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Highday', 'day_name() on 2000-02-16 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Highdei', 'day_name_trad() on 2000-02-16 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 25, 'day_of_month() on 2000-02-16 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 7, 'day_of_week() on 2000-02-16 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 56, 'day_of_year() on 2000-02-16 Gregorian' );
cmp_ok( $dts->dow(), '==', 7, 'dow() on 2000-02-16 Gregorian' );
cmp_ok( $dts->doy(), '==', 56, 'doy() on 2000-02-16 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-02-16 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-02-16 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-02-16 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-02-16 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-02-16 Gregorian' );
cmp_ok( $dts->mday(), '==', 25, 'mday() on 2000-02-16 Gregorian' );
cmp_ok( $dts->month(), '==', 2, 'month() on 2000-02-16 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Solmath', 'month_name() on 2000-02-16 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-02-16 Gregorian' );
Highday 25 Solmath 7464

The Company of the Ring pass the Argonath and camp at Parth Galen, 1419.
First battle of the Fords of Isen -- Theodred son of Theoden slain, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63086342400, 'utc_rd_as_seconds() on 2000-02-16 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730166,
  0,
  0
]
, 'utc_rd_values() on 2000-02-16 Gregorian' );
cmp_ok( $dts->wday(), '==', 7, 'wday() on 2000-02-16 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  8
]
, 'week() on 2000-02-16 Gregorian' );
cmp_ok( $dts->week_number(), '==', 8, 'week_number() on 2000-02-16 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-02-16 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-02-16 Gregorian' );

$epoch = timegm( 0, 0, 0, 17, 2 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 2,
	day	=> 17,
    ),
);
cmp_ok( $dts->day(), '==', 26, 'day() on 2000-02-17 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sterday', 'day_name() on 2000-02-17 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sterrendei', 'day_name_trad() on 2000-02-17 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 26, 'day_of_month() on 2000-02-17 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 1, 'day_of_week() on 2000-02-17 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 57, 'day_of_year() on 2000-02-17 Gregorian' );
cmp_ok( $dts->dow(), '==', 1, 'dow() on 2000-02-17 Gregorian' );
cmp_ok( $dts->doy(), '==', 57, 'doy() on 2000-02-17 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-02-17 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-02-17 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-02-17 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-02-17 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-02-17 Gregorian' );
cmp_ok( $dts->mday(), '==', 26, 'mday() on 2000-02-17 Gregorian' );
cmp_ok( $dts->month(), '==', 2, 'month() on 2000-02-17 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Solmath', 'month_name() on 2000-02-17 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-02-17 Gregorian' );
Sterday 26 Solmath 7464

Breaking of the Fellowship, 1419.
Death of Boromir; his horn is heard in Minas Tirith, 1419.
Meriadoc and Peregrin captured by Orcs -- Aragorn pursues, 1419.
Eomer hears of the descent of the Orc-band from Emyn Muil, 1419.
Frodo and Samwise enter the eastern Emyn Muil, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63086428800, 'utc_rd_as_seconds() on 2000-02-17 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730167,
  0,
  0
]
, 'utc_rd_values() on 2000-02-17 Gregorian' );
cmp_ok( $dts->wday(), '==', 1, 'wday() on 2000-02-17 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  9
]
, 'week() on 2000-02-17 Gregorian' );
cmp_ok( $dts->week_number(), '==', 9, 'week_number() on 2000-02-17 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-02-17 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-02-17 Gregorian' );

$epoch = timegm( 0, 0, 0, 18, 2 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 2,
	day	=> 18,
    ),
);
cmp_ok( $dts->day(), '==', 27, 'day() on 2000-02-18 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sunday', 'day_name() on 2000-02-18 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sunnendei', 'day_name_trad() on 2000-02-18 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 27, 'day_of_month() on 2000-02-18 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 2, 'day_of_week() on 2000-02-18 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 58, 'day_of_year() on 2000-02-18 Gregorian' );
cmp_ok( $dts->dow(), '==', 2, 'dow() on 2000-02-18 Gregorian' );
cmp_ok( $dts->doy(), '==', 58, 'doy() on 2000-02-18 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-02-18 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-02-18 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-02-18 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-02-18 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-02-18 Gregorian' );
cmp_ok( $dts->mday(), '==', 27, 'mday() on 2000-02-18 Gregorian' );
cmp_ok( $dts->month(), '==', 2, 'month() on 2000-02-18 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Solmath', 'month_name() on 2000-02-18 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-02-18 Gregorian' );
Sunday 27 Solmath 7464

Aragorn reaches the west-cliff at sunrise, 1419.
Eomer sets out from Eastfold against Theoden's orders to pursue the Orcs, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63086515200, 'utc_rd_as_seconds() on 2000-02-18 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730168,
  0,
  0
]
, 'utc_rd_values() on 2000-02-18 Gregorian' );
cmp_ok( $dts->wday(), '==', 2, 'wday() on 2000-02-18 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  9
]
, 'week() on 2000-02-18 Gregorian' );
cmp_ok( $dts->week_number(), '==', 9, 'week_number() on 2000-02-18 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-02-18 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-02-18 Gregorian' );

$epoch = timegm( 0, 0, 0, 19, 2 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 2,
	day	=> 19,
    ),
);
cmp_ok( $dts->day(), '==', 28, 'day() on 2000-02-19 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Monday', 'day_name() on 2000-02-19 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Monendei', 'day_name_trad() on 2000-02-19 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 28, 'day_of_month() on 2000-02-19 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 3, 'day_of_week() on 2000-02-19 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 59, 'day_of_year() on 2000-02-19 Gregorian' );
cmp_ok( $dts->dow(), '==', 3, 'dow() on 2000-02-19 Gregorian' );
cmp_ok( $dts->doy(), '==', 59, 'doy() on 2000-02-19 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-02-19 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-02-19 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-02-19 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-02-19 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-02-19 Gregorian' );
cmp_ok( $dts->mday(), '==', 28, 'mday() on 2000-02-19 Gregorian' );
cmp_ok( $dts->month(), '==', 2, 'month() on 2000-02-19 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Solmath', 'month_name() on 2000-02-19 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-02-19 Gregorian' );
Monday 28 Solmath 7464

Eomer overtakes the Orcs just outside of Fangorn Forest, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63086601600, 'utc_rd_as_seconds() on 2000-02-19 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730169,
  0,
  0
]
, 'utc_rd_values() on 2000-02-19 Gregorian' );
cmp_ok( $dts->wday(), '==', 3, 'wday() on 2000-02-19 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  9
]
, 'week() on 2000-02-19 Gregorian' );
cmp_ok( $dts->week_number(), '==', 9, 'week_number() on 2000-02-19 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-02-19 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-02-19 Gregorian' );

$epoch = timegm( 0, 0, 0, 20, 2 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 2,
	day	=> 20,
    ),
);
cmp_ok( $dts->day(), '==', 29, 'day() on 2000-02-20 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Trewsday', 'day_name() on 2000-02-20 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Trewesdei', 'day_name_trad() on 2000-02-20 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 29, 'day_of_month() on 2000-02-20 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 4, 'day_of_week() on 2000-02-20 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 60, 'day_of_year() on 2000-02-20 Gregorian' );
cmp_ok( $dts->dow(), '==', 4, 'dow() on 2000-02-20 Gregorian' );
cmp_ok( $dts->doy(), '==', 60, 'doy() on 2000-02-20 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-02-20 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-02-20 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-02-20 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-02-20 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-02-20 Gregorian' );
cmp_ok( $dts->mday(), '==', 29, 'mday() on 2000-02-20 Gregorian' );
cmp_ok( $dts->month(), '==', 2, 'month() on 2000-02-20 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Solmath', 'month_name() on 2000-02-20 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-02-20 Gregorian' );
Trewsday 29 Solmath 7464

Meriodoc and Pippin escape and meet Treebeard, 1419.
The Rohirrim attack at sunrise and destroy the Orcs, 1419.
Frodo descends from the Emyn Muil and meets Gollum, 1419.
Faramir sees the funeral boat of Boromir, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63086688000, 'utc_rd_as_seconds() on 2000-02-20 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730170,
  0,
  0
]
, 'utc_rd_values() on 2000-02-20 Gregorian' );
cmp_ok( $dts->wday(), '==', 4, 'wday() on 2000-02-20 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  9
]
, 'week() on 2000-02-20 Gregorian' );
cmp_ok( $dts->week_number(), '==', 9, 'week_number() on 2000-02-20 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-02-20 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-02-20 Gregorian' );

$epoch = timegm( 0, 0, 0, 21, 2 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 2,
	day	=> 21,
    ),
);
cmp_ok( $dts->day(), '==', 30, 'day() on 2000-02-21 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Hevensday', 'day_name() on 2000-02-21 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Hevenesdei', 'day_name_trad() on 2000-02-21 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 30, 'day_of_month() on 2000-02-21 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 5, 'day_of_week() on 2000-02-21 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 61, 'day_of_year() on 2000-02-21 Gregorian' );
cmp_ok( $dts->dow(), '==', 5, 'dow() on 2000-02-21 Gregorian' );
cmp_ok( $dts->doy(), '==', 61, 'doy() on 2000-02-21 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-02-21 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-02-21 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-02-21 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-02-21 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-02-21 Gregorian' );
cmp_ok( $dts->mday(), '==', 30, 'mday() on 2000-02-21 Gregorian' );
cmp_ok( $dts->month(), '==', 2, 'month() on 2000-02-21 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Solmath', 'month_name() on 2000-02-21 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-02-21 Gregorian' );
Hevensday 30 Solmath 7464

Entmoot begins, 1419.
Eomer, returning to Edoras, meets Aragorn, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63086774400, 'utc_rd_as_seconds() on 2000-02-21 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730171,
  0,
  0
]
, 'utc_rd_values() on 2000-02-21 Gregorian' );
cmp_ok( $dts->wday(), '==', 5, 'wday() on 2000-02-21 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  9
]
, 'week() on 2000-02-21 Gregorian' );
cmp_ok( $dts->week_number(), '==', 9, 'week_number() on 2000-02-21 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-02-21 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-02-21 Gregorian' );

$epoch = timegm( 0, 0, 0, 22, 2 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 2,
	day	=> 22,
    ),
);
cmp_ok( $dts->day(), '==', 1, 'day() on 2000-02-22 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Mersday', 'day_name() on 2000-02-22 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Meresdei', 'day_name_trad() on 2000-02-22 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 1, 'day_of_month() on 2000-02-22 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 6, 'day_of_week() on 2000-02-22 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 62, 'day_of_year() on 2000-02-22 Gregorian' );
cmp_ok( $dts->dow(), '==', 6, 'dow() on 2000-02-22 Gregorian' );
cmp_ok( $dts->doy(), '==', 62, 'doy() on 2000-02-22 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-02-22 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-02-22 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-02-22 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-02-22 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-02-22 Gregorian' );
cmp_ok( $dts->mday(), '==', 1, 'mday() on 2000-02-22 Gregorian' );
cmp_ok( $dts->month(), '==', 3, 'month() on 2000-02-22 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Rethe', 'month_name() on 2000-02-22 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-02-22 Gregorian' );
Mersday 1 Rethe 7464

Aragorn meets Gandalf the White, and they set out for Edoras, 1419.
Faramir leaves Minas Tirith on an errand to Ithilien, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63086860800, 'utc_rd_as_seconds() on 2000-02-22 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730172,
  0,
  0
]
, 'utc_rd_values() on 2000-02-22 Gregorian' );
cmp_ok( $dts->wday(), '==', 6, 'wday() on 2000-02-22 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  9
]
, 'week() on 2000-02-22 Gregorian' );
cmp_ok( $dts->week_number(), '==', 9, 'week_number() on 2000-02-22 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-02-22 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-02-22 Gregorian' );

$epoch = timegm( 0, 0, 0, 23, 2 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 2,
	day	=> 23,
    ),
);
cmp_ok( $dts->day(), '==', 2, 'day() on 2000-02-23 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Highday', 'day_name() on 2000-02-23 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Highdei', 'day_name_trad() on 2000-02-23 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 2, 'day_of_month() on 2000-02-23 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 7, 'day_of_week() on 2000-02-23 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 63, 'day_of_year() on 2000-02-23 Gregorian' );
cmp_ok( $dts->dow(), '==', 7, 'dow() on 2000-02-23 Gregorian' );
cmp_ok( $dts->doy(), '==', 63, 'doy() on 2000-02-23 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-02-23 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-02-23 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-02-23 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-02-23 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-02-23 Gregorian' );
cmp_ok( $dts->mday(), '==', 2, 'mday() on 2000-02-23 Gregorian' );
cmp_ok( $dts->month(), '==', 3, 'month() on 2000-02-23 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Rethe', 'month_name() on 2000-02-23 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-02-23 Gregorian' );
Highday 2 Rethe 7464

The Rohirrim ride west against Saruman, 1419.
Second battle at the Fords of Isen; Erkenbrand defeated, 1419.
Entmoot ends.  Ents march on Isengard and reach it at night, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63086947200, 'utc_rd_as_seconds() on 2000-02-23 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730173,
  0,
  0
]
, 'utc_rd_values() on 2000-02-23 Gregorian' );
cmp_ok( $dts->wday(), '==', 7, 'wday() on 2000-02-23 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  9
]
, 'week() on 2000-02-23 Gregorian' );
cmp_ok( $dts->week_number(), '==', 9, 'week_number() on 2000-02-23 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-02-23 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-02-23 Gregorian' );

$epoch = timegm( 0, 0, 0, 24, 2 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 2,
	day	=> 24,
    ),
);
cmp_ok( $dts->day(), '==', 3, 'day() on 2000-02-24 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sterday', 'day_name() on 2000-02-24 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sterrendei', 'day_name_trad() on 2000-02-24 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 3, 'day_of_month() on 2000-02-24 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 1, 'day_of_week() on 2000-02-24 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 64, 'day_of_year() on 2000-02-24 Gregorian' );
cmp_ok( $dts->dow(), '==', 1, 'dow() on 2000-02-24 Gregorian' );
cmp_ok( $dts->doy(), '==', 64, 'doy() on 2000-02-24 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-02-24 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-02-24 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-02-24 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-02-24 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-02-24 Gregorian' );
cmp_ok( $dts->mday(), '==', 3, 'mday() on 2000-02-24 Gregorian' );
cmp_ok( $dts->month(), '==', 3, 'month() on 2000-02-24 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Rethe', 'month_name() on 2000-02-24 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-02-24 Gregorian' );
Sterday 3 Rethe 7464

Theoden retreats to Helm's Deep; battle of the Hornburg begins, 1419.
Ents complete the destruction of Isengard.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63087033600, 'utc_rd_as_seconds() on 2000-02-24 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730174,
  0,
  0
]
, 'utc_rd_values() on 2000-02-24 Gregorian' );
cmp_ok( $dts->wday(), '==', 1, 'wday() on 2000-02-24 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  10
]
, 'week() on 2000-02-24 Gregorian' );
cmp_ok( $dts->week_number(), '==', 10, 'week_number() on 2000-02-24 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-02-24 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-02-24 Gregorian' );

$epoch = timegm( 0, 0, 0, 25, 2 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 2,
	day	=> 25,
    ),
);
cmp_ok( $dts->day(), '==', 4, 'day() on 2000-02-25 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sunday', 'day_name() on 2000-02-25 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sunnendei', 'day_name_trad() on 2000-02-25 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 4, 'day_of_month() on 2000-02-25 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 2, 'day_of_week() on 2000-02-25 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 65, 'day_of_year() on 2000-02-25 Gregorian' );
cmp_ok( $dts->dow(), '==', 2, 'dow() on 2000-02-25 Gregorian' );
cmp_ok( $dts->doy(), '==', 65, 'doy() on 2000-02-25 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-02-25 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-02-25 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-02-25 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-02-25 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-02-25 Gregorian' );
cmp_ok( $dts->mday(), '==', 4, 'mday() on 2000-02-25 Gregorian' );
cmp_ok( $dts->month(), '==', 3, 'month() on 2000-02-25 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Rethe', 'month_name() on 2000-02-25 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-02-25 Gregorian' );
Sunday 4 Rethe 7464

Theoden and Gandalf set out from Helm's Deep for Isengard, 1419.
Frodo reaches the slag mound on the edge of the of the Morannon, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63087120000, 'utc_rd_as_seconds() on 2000-02-25 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730175,
  0,
  0
]
, 'utc_rd_values() on 2000-02-25 Gregorian' );
cmp_ok( $dts->wday(), '==', 2, 'wday() on 2000-02-25 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  10
]
, 'week() on 2000-02-25 Gregorian' );
cmp_ok( $dts->week_number(), '==', 10, 'week_number() on 2000-02-25 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-02-25 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-02-25 Gregorian' );

$epoch = timegm( 0, 0, 0, 26, 2 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 2,
	day	=> 26,
    ),
);
cmp_ok( $dts->day(), '==', 5, 'day() on 2000-02-26 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Monday', 'day_name() on 2000-02-26 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Monendei', 'day_name_trad() on 2000-02-26 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 5, 'day_of_month() on 2000-02-26 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 3, 'day_of_week() on 2000-02-26 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 66, 'day_of_year() on 2000-02-26 Gregorian' );
cmp_ok( $dts->dow(), '==', 3, 'dow() on 2000-02-26 Gregorian' );
cmp_ok( $dts->doy(), '==', 66, 'doy() on 2000-02-26 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-02-26 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-02-26 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-02-26 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-02-26 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-02-26 Gregorian' );
cmp_ok( $dts->mday(), '==', 5, 'mday() on 2000-02-26 Gregorian' );
cmp_ok( $dts->month(), '==', 3, 'month() on 2000-02-26 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Rethe', 'month_name() on 2000-02-26 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-02-26 Gregorian' );
Monday 5 Rethe 7464

Theoden reaches Isengard at noon; parley with Saruman in Orthanc, 1419.
Gandalf sets out with Peregrin for Minas Tirith, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63087206400, 'utc_rd_as_seconds() on 2000-02-26 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730176,
  0,
  0
]
, 'utc_rd_values() on 2000-02-26 Gregorian' );
cmp_ok( $dts->wday(), '==', 3, 'wday() on 2000-02-26 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  10
]
, 'week() on 2000-02-26 Gregorian' );
cmp_ok( $dts->week_number(), '==', 10, 'week_number() on 2000-02-26 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-02-26 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-02-26 Gregorian' );

$epoch = timegm( 0, 0, 0, 27, 2 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 2,
	day	=> 27,
    ),
);
cmp_ok( $dts->day(), '==', 6, 'day() on 2000-02-27 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Trewsday', 'day_name() on 2000-02-27 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Trewesdei', 'day_name_trad() on 2000-02-27 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 6, 'day_of_month() on 2000-02-27 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 4, 'day_of_week() on 2000-02-27 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 67, 'day_of_year() on 2000-02-27 Gregorian' );
cmp_ok( $dts->dow(), '==', 4, 'dow() on 2000-02-27 Gregorian' );
cmp_ok( $dts->doy(), '==', 67, 'doy() on 2000-02-27 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-02-27 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-02-27 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-02-27 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-02-27 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-02-27 Gregorian' );
cmp_ok( $dts->mday(), '==', 6, 'mday() on 2000-02-27 Gregorian' );
cmp_ok( $dts->month(), '==', 3, 'month() on 2000-02-27 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Rethe', 'month_name() on 2000-02-27 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-02-27 Gregorian' );
Trewsday 6 Rethe 7464

Aragorn overtaken by the Dunedain in the early hours, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63087292800, 'utc_rd_as_seconds() on 2000-02-27 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730177,
  0,
  0
]
, 'utc_rd_values() on 2000-02-27 Gregorian' );
cmp_ok( $dts->wday(), '==', 4, 'wday() on 2000-02-27 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  10
]
, 'week() on 2000-02-27 Gregorian' );
cmp_ok( $dts->week_number(), '==', 10, 'week_number() on 2000-02-27 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-02-27 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-02-27 Gregorian' );

$epoch = timegm( 0, 0, 0, 28, 2 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 2,
	day	=> 28,
    ),
);
cmp_ok( $dts->day(), '==', 7, 'day() on 2000-02-28 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Hevensday', 'day_name() on 2000-02-28 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Hevenesdei', 'day_name_trad() on 2000-02-28 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 7, 'day_of_month() on 2000-02-28 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 5, 'day_of_week() on 2000-02-28 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 68, 'day_of_year() on 2000-02-28 Gregorian' );
cmp_ok( $dts->dow(), '==', 5, 'dow() on 2000-02-28 Gregorian' );
cmp_ok( $dts->doy(), '==', 68, 'doy() on 2000-02-28 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-02-28 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-02-28 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-02-28 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-02-28 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-02-28 Gregorian' );
cmp_ok( $dts->mday(), '==', 7, 'mday() on 2000-02-28 Gregorian' );
cmp_ok( $dts->month(), '==', 3, 'month() on 2000-02-28 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Rethe', 'month_name() on 2000-02-28 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-02-28 Gregorian' );
Hevensday 7 Rethe 7464

Frodo taken by Faramir to Henneth Annun, 1419.
Aragorn comes to Dunharrow at nightfall, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63087379200, 'utc_rd_as_seconds() on 2000-02-28 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730178,
  0,
  0
]
, 'utc_rd_values() on 2000-02-28 Gregorian' );
cmp_ok( $dts->wday(), '==', 5, 'wday() on 2000-02-28 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  10
]
, 'week() on 2000-02-28 Gregorian' );
cmp_ok( $dts->week_number(), '==', 10, 'week_number() on 2000-02-28 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-02-28 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-02-28 Gregorian' );

$epoch = timegm( 0, 0, 0, 29, 2 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 2,
	day	=> 29,
    ),
);
cmp_ok( $dts->day(), '==', 8, 'day() on 2000-02-29 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Mersday', 'day_name() on 2000-02-29 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Meresdei', 'day_name_trad() on 2000-02-29 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 8, 'day_of_month() on 2000-02-29 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 6, 'day_of_week() on 2000-02-29 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 69, 'day_of_year() on 2000-02-29 Gregorian' );
cmp_ok( $dts->dow(), '==', 6, 'dow() on 2000-02-29 Gregorian' );
cmp_ok( $dts->doy(), '==', 69, 'doy() on 2000-02-29 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-02-29 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-02-29 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-02-29 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-02-29 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-02-29 Gregorian' );
cmp_ok( $dts->mday(), '==', 8, 'mday() on 2000-02-29 Gregorian' );
cmp_ok( $dts->month(), '==', 3, 'month() on 2000-02-29 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Rethe', 'month_name() on 2000-02-29 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-02-29 Gregorian' );
Mersday 8 Rethe 7464

Aragorn takes the "Paths of the Dead", and reaches Erech at midnight, 1419.
Frodo leaves Henneth Annun, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63087465600, 'utc_rd_as_seconds() on 2000-02-29 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730179,
  0,
  0
]
, 'utc_rd_values() on 2000-02-29 Gregorian' );
cmp_ok( $dts->wday(), '==', 6, 'wday() on 2000-02-29 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  10
]
, 'week() on 2000-02-29 Gregorian' );
cmp_ok( $dts->week_number(), '==', 10, 'week_number() on 2000-02-29 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-02-29 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-02-29 Gregorian' );

$epoch = timegm( 0, 0, 0, 1, 3 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 3,
	day	=> 1,
    ),
);
cmp_ok( $dts->day(), '==', 9, 'day() on 2000-03-01 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Highday', 'day_name() on 2000-03-01 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Highdei', 'day_name_trad() on 2000-03-01 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 9, 'day_of_month() on 2000-03-01 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 7, 'day_of_week() on 2000-03-01 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 70, 'day_of_year() on 2000-03-01 Gregorian' );
cmp_ok( $dts->dow(), '==', 7, 'dow() on 2000-03-01 Gregorian' );
cmp_ok( $dts->doy(), '==', 70, 'doy() on 2000-03-01 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-03-01 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-03-01 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-03-01 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-03-01 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-03-01 Gregorian' );
cmp_ok( $dts->mday(), '==', 9, 'mday() on 2000-03-01 Gregorian' );
cmp_ok( $dts->month(), '==', 3, 'month() on 2000-03-01 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Rethe', 'month_name() on 2000-03-01 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-03-01 Gregorian' );
Highday 9 Rethe 7464

Gandalf reaches Minas Tirith, 1419.
Darkness begins to flow out of Mordor, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63087552000, 'utc_rd_as_seconds() on 2000-03-01 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730180,
  0,
  0
]
, 'utc_rd_values() on 2000-03-01 Gregorian' );
cmp_ok( $dts->wday(), '==', 7, 'wday() on 2000-03-01 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  10
]
, 'week() on 2000-03-01 Gregorian' );
cmp_ok( $dts->week_number(), '==', 10, 'week_number() on 2000-03-01 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-03-01 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-03-01 Gregorian' );

$epoch = timegm( 0, 0, 0, 2, 3 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 3,
	day	=> 2,
    ),
);
cmp_ok( $dts->day(), '==', 10, 'day() on 2000-03-02 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sterday', 'day_name() on 2000-03-02 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sterrendei', 'day_name_trad() on 2000-03-02 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 10, 'day_of_month() on 2000-03-02 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 1, 'day_of_week() on 2000-03-02 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 71, 'day_of_year() on 2000-03-02 Gregorian' );
cmp_ok( $dts->dow(), '==', 1, 'dow() on 2000-03-02 Gregorian' );
cmp_ok( $dts->doy(), '==', 71, 'doy() on 2000-03-02 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-03-02 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-03-02 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-03-02 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-03-02 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-03-02 Gregorian' );
cmp_ok( $dts->mday(), '==', 10, 'mday() on 2000-03-02 Gregorian' );
cmp_ok( $dts->month(), '==', 3, 'month() on 2000-03-02 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Rethe', 'month_name() on 2000-03-02 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-03-02 Gregorian' );
Sterday 10 Rethe 7464

The Dawnless Day, 1419.
The Rohirrim are mustered and ride from Harrowdale, 1419.
Faramir rescued by Gandalf at the gates of Minas Tirith, 1419.
An army from the Morannon takes Cair Andros and passes into Anorien, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63087638400, 'utc_rd_as_seconds() on 2000-03-02 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730181,
  0,
  0
]
, 'utc_rd_values() on 2000-03-02 Gregorian' );
cmp_ok( $dts->wday(), '==', 1, 'wday() on 2000-03-02 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  11
]
, 'week() on 2000-03-02 Gregorian' );
cmp_ok( $dts->week_number(), '==', 11, 'week_number() on 2000-03-02 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-03-02 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-03-02 Gregorian' );

$epoch = timegm( 0, 0, 0, 3, 3 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 3,
	day	=> 3,
    ),
);
cmp_ok( $dts->day(), '==', 11, 'day() on 2000-03-03 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sunday', 'day_name() on 2000-03-03 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sunnendei', 'day_name_trad() on 2000-03-03 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 11, 'day_of_month() on 2000-03-03 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 2, 'day_of_week() on 2000-03-03 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 72, 'day_of_year() on 2000-03-03 Gregorian' );
cmp_ok( $dts->dow(), '==', 2, 'dow() on 2000-03-03 Gregorian' );
cmp_ok( $dts->doy(), '==', 72, 'doy() on 2000-03-03 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-03-03 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-03-03 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-03-03 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-03-03 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-03-03 Gregorian' );
cmp_ok( $dts->mday(), '==', 11, 'mday() on 2000-03-03 Gregorian' );
cmp_ok( $dts->month(), '==', 3, 'month() on 2000-03-03 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Rethe', 'month_name() on 2000-03-03 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-03-03 Gregorian' );
Sunday 11 Rethe 7464

Gollum visits Shelob, 1419.
Denethor sends Faramir to Osgiliath, 1419.
Eastern Rohan is invaded and Lorien assaulted, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63087724800, 'utc_rd_as_seconds() on 2000-03-03 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730182,
  0,
  0
]
, 'utc_rd_values() on 2000-03-03 Gregorian' );
cmp_ok( $dts->wday(), '==', 2, 'wday() on 2000-03-03 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  11
]
, 'week() on 2000-03-03 Gregorian' );
cmp_ok( $dts->week_number(), '==', 11, 'week_number() on 2000-03-03 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-03-03 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-03-03 Gregorian' );

$epoch = timegm( 0, 0, 0, 4, 3 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 3,
	day	=> 4,
    ),
);
cmp_ok( $dts->day(), '==', 12, 'day() on 2000-03-04 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Monday', 'day_name() on 2000-03-04 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Monendei', 'day_name_trad() on 2000-03-04 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 12, 'day_of_month() on 2000-03-04 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 3, 'day_of_week() on 2000-03-04 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 73, 'day_of_year() on 2000-03-04 Gregorian' );
cmp_ok( $dts->dow(), '==', 3, 'dow() on 2000-03-04 Gregorian' );
cmp_ok( $dts->doy(), '==', 73, 'doy() on 2000-03-04 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-03-04 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-03-04 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-03-04 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-03-04 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-03-04 Gregorian' );
cmp_ok( $dts->mday(), '==', 12, 'mday() on 2000-03-04 Gregorian' );
cmp_ok( $dts->month(), '==', 3, 'month() on 2000-03-04 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Rethe', 'month_name() on 2000-03-04 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-03-04 Gregorian' );
Monday 12 Rethe 7464

Gollum leads Frodo into Shelob's lair, 1419.
Ents defeat the invaders of Rohan, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63087811200, 'utc_rd_as_seconds() on 2000-03-04 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730183,
  0,
  0
]
, 'utc_rd_values() on 2000-03-04 Gregorian' );
cmp_ok( $dts->wday(), '==', 3, 'wday() on 2000-03-04 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  11
]
, 'week() on 2000-03-04 Gregorian' );
cmp_ok( $dts->week_number(), '==', 11, 'week_number() on 2000-03-04 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-03-04 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-03-04 Gregorian' );

$epoch = timegm( 0, 0, 0, 5, 3 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 3,
	day	=> 5,
    ),
);
cmp_ok( $dts->day(), '==', 13, 'day() on 2000-03-05 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Trewsday', 'day_name() on 2000-03-05 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Trewesdei', 'day_name_trad() on 2000-03-05 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 13, 'day_of_month() on 2000-03-05 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 4, 'day_of_week() on 2000-03-05 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 74, 'day_of_year() on 2000-03-05 Gregorian' );
cmp_ok( $dts->dow(), '==', 4, 'dow() on 2000-03-05 Gregorian' );
cmp_ok( $dts->doy(), '==', 74, 'doy() on 2000-03-05 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-03-05 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-03-05 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-03-05 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-03-05 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-03-05 Gregorian' );
cmp_ok( $dts->mday(), '==', 13, 'mday() on 2000-03-05 Gregorian' );
cmp_ok( $dts->month(), '==', 3, 'month() on 2000-03-05 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Rethe', 'month_name() on 2000-03-05 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-03-05 Gregorian' );
Trewsday 13 Rethe 7464

Frodo captured by the Orcs of Cirith Ungol, 1419.
The Pelennor is overrun and Faramir is wounded, 1419.
Aragorn reaches Pelargir and captures the fleet of Umbar, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63087897600, 'utc_rd_as_seconds() on 2000-03-05 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730184,
  0,
  0
]
, 'utc_rd_values() on 2000-03-05 Gregorian' );
cmp_ok( $dts->wday(), '==', 4, 'wday() on 2000-03-05 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  11
]
, 'week() on 2000-03-05 Gregorian' );
cmp_ok( $dts->week_number(), '==', 11, 'week_number() on 2000-03-05 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-03-05 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-03-05 Gregorian' );

$epoch = timegm( 0, 0, 0, 6, 3 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 3,
	day	=> 6,
    ),
);
cmp_ok( $dts->day(), '==', 14, 'day() on 2000-03-06 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Hevensday', 'day_name() on 2000-03-06 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Hevenesdei', 'day_name_trad() on 2000-03-06 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 14, 'day_of_month() on 2000-03-06 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 5, 'day_of_week() on 2000-03-06 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 75, 'day_of_year() on 2000-03-06 Gregorian' );
cmp_ok( $dts->dow(), '==', 5, 'dow() on 2000-03-06 Gregorian' );
cmp_ok( $dts->doy(), '==', 75, 'doy() on 2000-03-06 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-03-06 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-03-06 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-03-06 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-03-06 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-03-06 Gregorian' );
cmp_ok( $dts->mday(), '==', 14, 'mday() on 2000-03-06 Gregorian' );
cmp_ok( $dts->month(), '==', 3, 'month() on 2000-03-06 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Rethe', 'month_name() on 2000-03-06 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-03-06 Gregorian' );
Hevensday 14 Rethe 7464

Samwise finds Frodo in the tower of Cirith Ungol, 1419.
Minas Tirith besieged, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63087984000, 'utc_rd_as_seconds() on 2000-03-06 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730185,
  0,
  0
]
, 'utc_rd_values() on 2000-03-06 Gregorian' );
cmp_ok( $dts->wday(), '==', 5, 'wday() on 2000-03-06 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  11
]
, 'week() on 2000-03-06 Gregorian' );
cmp_ok( $dts->week_number(), '==', 11, 'week_number() on 2000-03-06 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-03-06 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-03-06 Gregorian' );

$epoch = timegm( 0, 0, 0, 7, 3 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 3,
	day	=> 7,
    ),
);
cmp_ok( $dts->day(), '==', 15, 'day() on 2000-03-07 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Mersday', 'day_name() on 2000-03-07 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Meresdei', 'day_name_trad() on 2000-03-07 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 15, 'day_of_month() on 2000-03-07 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 6, 'day_of_week() on 2000-03-07 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 76, 'day_of_year() on 2000-03-07 Gregorian' );
cmp_ok( $dts->dow(), '==', 6, 'dow() on 2000-03-07 Gregorian' );
cmp_ok( $dts->doy(), '==', 76, 'doy() on 2000-03-07 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-03-07 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-03-07 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-03-07 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-03-07 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-03-07 Gregorian' );
cmp_ok( $dts->mday(), '==', 15, 'mday() on 2000-03-07 Gregorian' );
cmp_ok( $dts->month(), '==', 3, 'month() on 2000-03-07 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Rethe', 'month_name() on 2000-03-07 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-03-07 Gregorian' );
Mersday 15 Rethe 7464

Witch King breaks the gates of Minas Tirith, 1419.
Denethor, Steward of Gondor, burns himself on a pyre, 1419.
The battle of the Pelennor occurs as Theoden and Aragorn arrive, 1419.
Thranduil repels the forces of Dol Guldur in Mirkwood, 1419.
Lorien assaulted for second time, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63088070400, 'utc_rd_as_seconds() on 2000-03-07 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730186,
  0,
  0
]
, 'utc_rd_values() on 2000-03-07 Gregorian' );
cmp_ok( $dts->wday(), '==', 6, 'wday() on 2000-03-07 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  11
]
, 'week() on 2000-03-07 Gregorian' );
cmp_ok( $dts->week_number(), '==', 11, 'week_number() on 2000-03-07 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-03-07 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-03-07 Gregorian' );

$epoch = timegm( 0, 0, 0, 8, 3 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 3,
	day	=> 8,
    ),
);
cmp_ok( $dts->day(), '==', 16, 'day() on 2000-03-08 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Highday', 'day_name() on 2000-03-08 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Highdei', 'day_name_trad() on 2000-03-08 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 16, 'day_of_month() on 2000-03-08 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 7, 'day_of_week() on 2000-03-08 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 77, 'day_of_year() on 2000-03-08 Gregorian' );
cmp_ok( $dts->dow(), '==', 7, 'dow() on 2000-03-08 Gregorian' );
cmp_ok( $dts->doy(), '==', 77, 'doy() on 2000-03-08 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-03-08 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-03-08 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-03-08 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-03-08 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-03-08 Gregorian' );
cmp_ok( $dts->mday(), '==', 16, 'mday() on 2000-03-08 Gregorian' );
cmp_ok( $dts->month(), '==', 3, 'month() on 2000-03-08 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Rethe', 'month_name() on 2000-03-08 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-03-08 Gregorian' );
Highday 16 Rethe 7464
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63088156800, 'utc_rd_as_seconds() on 2000-03-08 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730187,
  0,
  0
]
, 'utc_rd_values() on 2000-03-08 Gregorian' );
cmp_ok( $dts->wday(), '==', 7, 'wday() on 2000-03-08 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  11
]
, 'week() on 2000-03-08 Gregorian' );
cmp_ok( $dts->week_number(), '==', 11, 'week_number() on 2000-03-08 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-03-08 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-03-08 Gregorian' );

$epoch = timegm( 0, 0, 0, 9, 3 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 3,
	day	=> 9,
    ),
);
cmp_ok( $dts->day(), '==', 17, 'day() on 2000-03-09 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sterday', 'day_name() on 2000-03-09 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sterrendei', 'day_name_trad() on 2000-03-09 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 17, 'day_of_month() on 2000-03-09 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 1, 'day_of_week() on 2000-03-09 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 78, 'day_of_year() on 2000-03-09 Gregorian' );
cmp_ok( $dts->dow(), '==', 1, 'dow() on 2000-03-09 Gregorian' );
cmp_ok( $dts->doy(), '==', 78, 'doy() on 2000-03-09 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-03-09 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-03-09 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-03-09 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-03-09 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-03-09 Gregorian' );
cmp_ok( $dts->mday(), '==', 17, 'mday() on 2000-03-09 Gregorian' );
cmp_ok( $dts->month(), '==', 3, 'month() on 2000-03-09 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Rethe', 'month_name() on 2000-03-09 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-03-09 Gregorian' );
Sterday 17 Rethe 7464

Battle of Dale, where King Brand and King Dain Ironfoot fall, 1419.
Shagrat brings Frodo's cloak, mail-shirt, and sword to Barad-dur, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63088243200, 'utc_rd_as_seconds() on 2000-03-09 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730188,
  0,
  0
]
, 'utc_rd_values() on 2000-03-09 Gregorian' );
cmp_ok( $dts->wday(), '==', 1, 'wday() on 2000-03-09 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  12
]
, 'week() on 2000-03-09 Gregorian' );
cmp_ok( $dts->week_number(), '==', 12, 'week_number() on 2000-03-09 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-03-09 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-03-09 Gregorian' );

$epoch = timegm( 0, 0, 0, 10, 3 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 3,
	day	=> 10,
    ),
);
cmp_ok( $dts->day(), '==', 18, 'day() on 2000-03-10 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sunday', 'day_name() on 2000-03-10 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sunnendei', 'day_name_trad() on 2000-03-10 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 18, 'day_of_month() on 2000-03-10 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 2, 'day_of_week() on 2000-03-10 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 79, 'day_of_year() on 2000-03-10 Gregorian' );
cmp_ok( $dts->dow(), '==', 2, 'dow() on 2000-03-10 Gregorian' );
cmp_ok( $dts->doy(), '==', 79, 'doy() on 2000-03-10 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-03-10 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-03-10 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-03-10 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-03-10 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-03-10 Gregorian' );
cmp_ok( $dts->mday(), '==', 18, 'mday() on 2000-03-10 Gregorian' );
cmp_ok( $dts->month(), '==', 3, 'month() on 2000-03-10 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Rethe', 'month_name() on 2000-03-10 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-03-10 Gregorian' );
Sunday 18 Rethe 7464

Host of the west leaves Minas Tirith, 1419.
Frodo and Sam overtaken by Orcs on the road from Durthang to Udun, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63088329600, 'utc_rd_as_seconds() on 2000-03-10 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730189,
  0,
  0
]
, 'utc_rd_values() on 2000-03-10 Gregorian' );
cmp_ok( $dts->wday(), '==', 2, 'wday() on 2000-03-10 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  12
]
, 'week() on 2000-03-10 Gregorian' );
cmp_ok( $dts->week_number(), '==', 12, 'week_number() on 2000-03-10 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-03-10 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-03-10 Gregorian' );

$epoch = timegm( 0, 0, 0, 11, 3 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 3,
	day	=> 11,
    ),
);
cmp_ok( $dts->day(), '==', 19, 'day() on 2000-03-11 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Monday', 'day_name() on 2000-03-11 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Monendei', 'day_name_trad() on 2000-03-11 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 19, 'day_of_month() on 2000-03-11 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 3, 'day_of_week() on 2000-03-11 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 80, 'day_of_year() on 2000-03-11 Gregorian' );
cmp_ok( $dts->dow(), '==', 3, 'dow() on 2000-03-11 Gregorian' );
cmp_ok( $dts->doy(), '==', 80, 'doy() on 2000-03-11 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-03-11 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-03-11 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-03-11 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-03-11 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-03-11 Gregorian' );
cmp_ok( $dts->mday(), '==', 19, 'mday() on 2000-03-11 Gregorian' );
cmp_ok( $dts->month(), '==', 3, 'month() on 2000-03-11 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Rethe', 'month_name() on 2000-03-11 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-03-11 Gregorian' );
Monday 19 Rethe 7464

Frodo and Sam escape the Orcs and start on the road toward Mount Doom, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63088416000, 'utc_rd_as_seconds() on 2000-03-11 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730190,
  0,
  0
]
, 'utc_rd_values() on 2000-03-11 Gregorian' );
cmp_ok( $dts->wday(), '==', 3, 'wday() on 2000-03-11 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  12
]
, 'week() on 2000-03-11 Gregorian' );
cmp_ok( $dts->week_number(), '==', 12, 'week_number() on 2000-03-11 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-03-11 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-03-11 Gregorian' );

$epoch = timegm( 0, 0, 0, 12, 3 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 3,
	day	=> 12,
    ),
);
cmp_ok( $dts->day(), '==', 20, 'day() on 2000-03-12 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Trewsday', 'day_name() on 2000-03-12 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Trewesdei', 'day_name_trad() on 2000-03-12 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 20, 'day_of_month() on 2000-03-12 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 4, 'day_of_week() on 2000-03-12 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 81, 'day_of_year() on 2000-03-12 Gregorian' );
cmp_ok( $dts->dow(), '==', 4, 'dow() on 2000-03-12 Gregorian' );
cmp_ok( $dts->doy(), '==', 81, 'doy() on 2000-03-12 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-03-12 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-03-12 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-03-12 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-03-12 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-03-12 Gregorian' );
cmp_ok( $dts->mday(), '==', 20, 'mday() on 2000-03-12 Gregorian' );
cmp_ok( $dts->month(), '==', 3, 'month() on 2000-03-12 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Rethe', 'month_name() on 2000-03-12 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-03-12 Gregorian' );
Trewsday 20 Rethe 7464
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63088502400, 'utc_rd_as_seconds() on 2000-03-12 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730191,
  0,
  0
]
, 'utc_rd_values() on 2000-03-12 Gregorian' );
cmp_ok( $dts->wday(), '==', 4, 'wday() on 2000-03-12 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  12
]
, 'week() on 2000-03-12 Gregorian' );
cmp_ok( $dts->week_number(), '==', 12, 'week_number() on 2000-03-12 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-03-12 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-03-12 Gregorian' );

$epoch = timegm( 0, 0, 0, 13, 3 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 3,
	day	=> 13,
    ),
);
cmp_ok( $dts->day(), '==', 21, 'day() on 2000-03-13 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Hevensday', 'day_name() on 2000-03-13 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Hevenesdei', 'day_name_trad() on 2000-03-13 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 21, 'day_of_month() on 2000-03-13 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 5, 'day_of_week() on 2000-03-13 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 82, 'day_of_year() on 2000-03-13 Gregorian' );
cmp_ok( $dts->dow(), '==', 5, 'dow() on 2000-03-13 Gregorian' );
cmp_ok( $dts->doy(), '==', 82, 'doy() on 2000-03-13 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-03-13 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-03-13 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-03-13 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-03-13 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-03-13 Gregorian' );
cmp_ok( $dts->mday(), '==', 21, 'mday() on 2000-03-13 Gregorian' );
cmp_ok( $dts->month(), '==', 3, 'month() on 2000-03-13 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Rethe', 'month_name() on 2000-03-13 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-03-13 Gregorian' );
Hevensday 21 Rethe 7464
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63088588800, 'utc_rd_as_seconds() on 2000-03-13 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730192,
  0,
  0
]
, 'utc_rd_values() on 2000-03-13 Gregorian' );
cmp_ok( $dts->wday(), '==', 5, 'wday() on 2000-03-13 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  12
]
, 'week() on 2000-03-13 Gregorian' );
cmp_ok( $dts->week_number(), '==', 12, 'week_number() on 2000-03-13 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-03-13 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-03-13 Gregorian' );

$epoch = timegm( 0, 0, 0, 14, 3 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 3,
	day	=> 14,
    ),
);
cmp_ok( $dts->day(), '==', 22, 'day() on 2000-03-14 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Mersday', 'day_name() on 2000-03-14 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Meresdei', 'day_name_trad() on 2000-03-14 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 22, 'day_of_month() on 2000-03-14 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 6, 'day_of_week() on 2000-03-14 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 83, 'day_of_year() on 2000-03-14 Gregorian' );
cmp_ok( $dts->dow(), '==', 6, 'dow() on 2000-03-14 Gregorian' );
cmp_ok( $dts->doy(), '==', 83, 'doy() on 2000-03-14 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-03-14 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-03-14 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-03-14 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-03-14 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-03-14 Gregorian' );
cmp_ok( $dts->mday(), '==', 22, 'mday() on 2000-03-14 Gregorian' );
cmp_ok( $dts->month(), '==', 3, 'month() on 2000-03-14 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Rethe', 'month_name() on 2000-03-14 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-03-14 Gregorian' );
Mersday 22 Rethe 7464

Lorien assaulted for the third time, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63088675200, 'utc_rd_as_seconds() on 2000-03-14 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730193,
  0,
  0
]
, 'utc_rd_values() on 2000-03-14 Gregorian' );
cmp_ok( $dts->wday(), '==', 6, 'wday() on 2000-03-14 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  12
]
, 'week() on 2000-03-14 Gregorian' );
cmp_ok( $dts->week_number(), '==', 12, 'week_number() on 2000-03-14 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-03-14 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-03-14 Gregorian' );

$epoch = timegm( 0, 0, 0, 15, 3 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 3,
	day	=> 15,
    ),
);
cmp_ok( $dts->day(), '==', 23, 'day() on 2000-03-15 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Highday', 'day_name() on 2000-03-15 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Highdei', 'day_name_trad() on 2000-03-15 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 23, 'day_of_month() on 2000-03-15 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 7, 'day_of_week() on 2000-03-15 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 84, 'day_of_year() on 2000-03-15 Gregorian' );
cmp_ok( $dts->dow(), '==', 7, 'dow() on 2000-03-15 Gregorian' );
cmp_ok( $dts->doy(), '==', 84, 'doy() on 2000-03-15 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-03-15 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-03-15 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-03-15 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-03-15 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-03-15 Gregorian' );
cmp_ok( $dts->mday(), '==', 23, 'mday() on 2000-03-15 Gregorian' );
cmp_ok( $dts->month(), '==', 3, 'month() on 2000-03-15 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Rethe', 'month_name() on 2000-03-15 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-03-15 Gregorian' );
Highday 23 Rethe 7464
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63088761600, 'utc_rd_as_seconds() on 2000-03-15 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730194,
  0,
  0
]
, 'utc_rd_values() on 2000-03-15 Gregorian' );
cmp_ok( $dts->wday(), '==', 7, 'wday() on 2000-03-15 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  12
]
, 'week() on 2000-03-15 Gregorian' );
cmp_ok( $dts->week_number(), '==', 12, 'week_number() on 2000-03-15 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-03-15 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-03-15 Gregorian' );

$epoch = timegm( 0, 0, 0, 16, 3 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 3,
	day	=> 16,
    ),
);
cmp_ok( $dts->day(), '==', 24, 'day() on 2000-03-16 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sterday', 'day_name() on 2000-03-16 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sterrendei', 'day_name_trad() on 2000-03-16 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 24, 'day_of_month() on 2000-03-16 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 1, 'day_of_week() on 2000-03-16 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 85, 'day_of_year() on 2000-03-16 Gregorian' );
cmp_ok( $dts->dow(), '==', 1, 'dow() on 2000-03-16 Gregorian' );
cmp_ok( $dts->doy(), '==', 85, 'doy() on 2000-03-16 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-03-16 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-03-16 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-03-16 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-03-16 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-03-16 Gregorian' );
cmp_ok( $dts->mday(), '==', 24, 'mday() on 2000-03-16 Gregorian' );
cmp_ok( $dts->month(), '==', 3, 'month() on 2000-03-16 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Rethe', 'month_name() on 2000-03-16 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-03-16 Gregorian' );
Sterday 24 Rethe 7464

Frodo and Sam reach the base of Mount Doom, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63088848000, 'utc_rd_as_seconds() on 2000-03-16 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730195,
  0,
  0
]
, 'utc_rd_values() on 2000-03-16 Gregorian' );
cmp_ok( $dts->wday(), '==', 1, 'wday() on 2000-03-16 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  13
]
, 'week() on 2000-03-16 Gregorian' );
cmp_ok( $dts->week_number(), '==', 13, 'week_number() on 2000-03-16 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-03-16 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-03-16 Gregorian' );

$epoch = timegm( 0, 0, 0, 17, 3 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 3,
	day	=> 17,
    ),
);
cmp_ok( $dts->day(), '==', 25, 'day() on 2000-03-17 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sunday', 'day_name() on 2000-03-17 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sunnendei', 'day_name_trad() on 2000-03-17 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 25, 'day_of_month() on 2000-03-17 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 2, 'day_of_week() on 2000-03-17 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 86, 'day_of_year() on 2000-03-17 Gregorian' );
cmp_ok( $dts->dow(), '==', 2, 'dow() on 2000-03-17 Gregorian' );
cmp_ok( $dts->doy(), '==', 86, 'doy() on 2000-03-17 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-03-17 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-03-17 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-03-17 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-03-17 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-03-17 Gregorian' );
cmp_ok( $dts->mday(), '==', 25, 'mday() on 2000-03-17 Gregorian' );
cmp_ok( $dts->month(), '==', 3, 'month() on 2000-03-17 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Rethe', 'month_name() on 2000-03-17 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-03-17 Gregorian' );
Sunday 25 Rethe 7464

Battle of the Host of the West on the slag hill of the Morannon, 1419.
Gollum siezes the Ring of Power and falls into the Cracks of Doom, 1419.
Downfall of Barad-dur and the passing of Sauron!, 1419.
Birth of Elanor the Fair, daughter of Samwise, 1421.
Fourth age begins in the reckoning of Gondor, 1421.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63088934400, 'utc_rd_as_seconds() on 2000-03-17 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730196,
  0,
  0
]
, 'utc_rd_values() on 2000-03-17 Gregorian' );
cmp_ok( $dts->wday(), '==', 2, 'wday() on 2000-03-17 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  13
]
, 'week() on 2000-03-17 Gregorian' );
cmp_ok( $dts->week_number(), '==', 13, 'week_number() on 2000-03-17 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-03-17 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-03-17 Gregorian' );

$epoch = timegm( 0, 0, 0, 18, 3 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 3,
	day	=> 18,
    ),
);
cmp_ok( $dts->day(), '==', 26, 'day() on 2000-03-18 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Monday', 'day_name() on 2000-03-18 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Monendei', 'day_name_trad() on 2000-03-18 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 26, 'day_of_month() on 2000-03-18 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 3, 'day_of_week() on 2000-03-18 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 87, 'day_of_year() on 2000-03-18 Gregorian' );
cmp_ok( $dts->dow(), '==', 3, 'dow() on 2000-03-18 Gregorian' );
cmp_ok( $dts->doy(), '==', 87, 'doy() on 2000-03-18 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-03-18 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-03-18 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-03-18 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-03-18 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-03-18 Gregorian' );
cmp_ok( $dts->mday(), '==', 26, 'mday() on 2000-03-18 Gregorian' );
cmp_ok( $dts->month(), '==', 3, 'month() on 2000-03-18 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Rethe', 'month_name() on 2000-03-18 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-03-18 Gregorian' );
Monday 26 Rethe 7464
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63089020800, 'utc_rd_as_seconds() on 2000-03-18 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730197,
  0,
  0
]
, 'utc_rd_values() on 2000-03-18 Gregorian' );
cmp_ok( $dts->wday(), '==', 3, 'wday() on 2000-03-18 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  13
]
, 'week() on 2000-03-18 Gregorian' );
cmp_ok( $dts->week_number(), '==', 13, 'week_number() on 2000-03-18 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-03-18 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-03-18 Gregorian' );

$epoch = timegm( 0, 0, 0, 19, 3 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 3,
	day	=> 19,
    ),
);
cmp_ok( $dts->day(), '==', 27, 'day() on 2000-03-19 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Trewsday', 'day_name() on 2000-03-19 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Trewesdei', 'day_name_trad() on 2000-03-19 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 27, 'day_of_month() on 2000-03-19 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 4, 'day_of_week() on 2000-03-19 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 88, 'day_of_year() on 2000-03-19 Gregorian' );
cmp_ok( $dts->dow(), '==', 4, 'dow() on 2000-03-19 Gregorian' );
cmp_ok( $dts->doy(), '==', 88, 'doy() on 2000-03-19 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-03-19 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-03-19 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-03-19 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-03-19 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-03-19 Gregorian' );
cmp_ok( $dts->mday(), '==', 27, 'mday() on 2000-03-19 Gregorian' );
cmp_ok( $dts->month(), '==', 3, 'month() on 2000-03-19 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Rethe', 'month_name() on 2000-03-19 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-03-19 Gregorian' );
Trewsday 27 Rethe 7464

Bard II and Thorin III Stonehelm drive the enemy from Dale, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63089107200, 'utc_rd_as_seconds() on 2000-03-19 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730198,
  0,
  0
]
, 'utc_rd_values() on 2000-03-19 Gregorian' );
cmp_ok( $dts->wday(), '==', 4, 'wday() on 2000-03-19 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  13
]
, 'week() on 2000-03-19 Gregorian' );
cmp_ok( $dts->week_number(), '==', 13, 'week_number() on 2000-03-19 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-03-19 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-03-19 Gregorian' );

$epoch = timegm( 0, 0, 0, 20, 3 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 3,
	day	=> 20,
    ),
);
cmp_ok( $dts->day(), '==', 28, 'day() on 2000-03-20 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Hevensday', 'day_name() on 2000-03-20 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Hevenesdei', 'day_name_trad() on 2000-03-20 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 28, 'day_of_month() on 2000-03-20 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 5, 'day_of_week() on 2000-03-20 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 89, 'day_of_year() on 2000-03-20 Gregorian' );
cmp_ok( $dts->dow(), '==', 5, 'dow() on 2000-03-20 Gregorian' );
cmp_ok( $dts->doy(), '==', 89, 'doy() on 2000-03-20 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-03-20 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-03-20 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-03-20 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-03-20 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-03-20 Gregorian' );
cmp_ok( $dts->mday(), '==', 28, 'mday() on 2000-03-20 Gregorian' );
cmp_ok( $dts->month(), '==', 3, 'month() on 2000-03-20 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Rethe', 'month_name() on 2000-03-20 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-03-20 Gregorian' );
Hevensday 28 Rethe 7464

Celeborn crosses the Anduin and begins destruction of Dol Guldur, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63089193600, 'utc_rd_as_seconds() on 2000-03-20 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730199,
  0,
  0
]
, 'utc_rd_values() on 2000-03-20 Gregorian' );
cmp_ok( $dts->wday(), '==', 5, 'wday() on 2000-03-20 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  13
]
, 'week() on 2000-03-20 Gregorian' );
cmp_ok( $dts->week_number(), '==', 13, 'week_number() on 2000-03-20 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-03-20 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-03-20 Gregorian' );

$epoch = timegm( 0, 0, 0, 21, 3 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 3,
	day	=> 21,
    ),
);
cmp_ok( $dts->day(), '==', 29, 'day() on 2000-03-21 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Mersday', 'day_name() on 2000-03-21 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Meresdei', 'day_name_trad() on 2000-03-21 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 29, 'day_of_month() on 2000-03-21 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 6, 'day_of_week() on 2000-03-21 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 90, 'day_of_year() on 2000-03-21 Gregorian' );
cmp_ok( $dts->dow(), '==', 6, 'dow() on 2000-03-21 Gregorian' );
cmp_ok( $dts->doy(), '==', 90, 'doy() on 2000-03-21 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-03-21 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-03-21 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-03-21 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-03-21 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-03-21 Gregorian' );
cmp_ok( $dts->mday(), '==', 29, 'mday() on 2000-03-21 Gregorian' );
cmp_ok( $dts->month(), '==', 3, 'month() on 2000-03-21 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Rethe', 'month_name() on 2000-03-21 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-03-21 Gregorian' );
Mersday 29 Rethe 7464
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63089280000, 'utc_rd_as_seconds() on 2000-03-21 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730200,
  0,
  0
]
, 'utc_rd_values() on 2000-03-21 Gregorian' );
cmp_ok( $dts->wday(), '==', 6, 'wday() on 2000-03-21 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  13
]
, 'week() on 2000-03-21 Gregorian' );
cmp_ok( $dts->week_number(), '==', 13, 'week_number() on 2000-03-21 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-03-21 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-03-21 Gregorian' );

$epoch = timegm( 0, 0, 0, 22, 3 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 3,
	day	=> 22,
    ),
);
cmp_ok( $dts->day(), '==', 30, 'day() on 2000-03-22 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Highday', 'day_name() on 2000-03-22 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Highdei', 'day_name_trad() on 2000-03-22 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 30, 'day_of_month() on 2000-03-22 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 7, 'day_of_week() on 2000-03-22 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 91, 'day_of_year() on 2000-03-22 Gregorian' );
cmp_ok( $dts->dow(), '==', 7, 'dow() on 2000-03-22 Gregorian' );
cmp_ok( $dts->doy(), '==', 91, 'doy() on 2000-03-22 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-03-22 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-03-22 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-03-22 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-03-22 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-03-22 Gregorian' );
cmp_ok( $dts->mday(), '==', 30, 'mday() on 2000-03-22 Gregorian' );
cmp_ok( $dts->month(), '==', 3, 'month() on 2000-03-22 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Rethe', 'month_name() on 2000-03-22 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-03-22 Gregorian' );
Highday 30 Rethe 7464
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63089366400, 'utc_rd_as_seconds() on 2000-03-22 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730201,
  0,
  0
]
, 'utc_rd_values() on 2000-03-22 Gregorian' );
cmp_ok( $dts->wday(), '==', 7, 'wday() on 2000-03-22 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  13
]
, 'week() on 2000-03-22 Gregorian' );
cmp_ok( $dts->week_number(), '==', 13, 'week_number() on 2000-03-22 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-03-22 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-03-22 Gregorian' );

$epoch = timegm( 0, 0, 0, 23, 3 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 3,
	day	=> 23,
    ),
);
cmp_ok( $dts->day(), '==', 1, 'day() on 2000-03-23 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sterday', 'day_name() on 2000-03-23 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sterrendei', 'day_name_trad() on 2000-03-23 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 1, 'day_of_month() on 2000-03-23 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 1, 'day_of_week() on 2000-03-23 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 92, 'day_of_year() on 2000-03-23 Gregorian' );
cmp_ok( $dts->dow(), '==', 1, 'dow() on 2000-03-23 Gregorian' );
cmp_ok( $dts->doy(), '==', 92, 'doy() on 2000-03-23 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-03-23 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-03-23 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-03-23 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-03-23 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-03-23 Gregorian' );
cmp_ok( $dts->mday(), '==', 1, 'mday() on 2000-03-23 Gregorian' );
cmp_ok( $dts->month(), '==', 4, 'month() on 2000-03-23 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Astron', 'month_name() on 2000-03-23 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-03-23 Gregorian' );
Sterday 1 Astron 7464
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63089452800, 'utc_rd_as_seconds() on 2000-03-23 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730202,
  0,
  0
]
, 'utc_rd_values() on 2000-03-23 Gregorian' );
cmp_ok( $dts->wday(), '==', 1, 'wday() on 2000-03-23 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  14
]
, 'week() on 2000-03-23 Gregorian' );
cmp_ok( $dts->week_number(), '==', 14, 'week_number() on 2000-03-23 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-03-23 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-03-23 Gregorian' );

$epoch = timegm( 0, 0, 0, 24, 3 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 3,
	day	=> 24,
    ),
);
cmp_ok( $dts->day(), '==', 2, 'day() on 2000-03-24 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sunday', 'day_name() on 2000-03-24 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sunnendei', 'day_name_trad() on 2000-03-24 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 2, 'day_of_month() on 2000-03-24 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 2, 'day_of_week() on 2000-03-24 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 93, 'day_of_year() on 2000-03-24 Gregorian' );
cmp_ok( $dts->dow(), '==', 2, 'dow() on 2000-03-24 Gregorian' );
cmp_ok( $dts->doy(), '==', 93, 'doy() on 2000-03-24 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-03-24 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-03-24 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-03-24 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-03-24 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-03-24 Gregorian' );
cmp_ok( $dts->mday(), '==', 2, 'mday() on 2000-03-24 Gregorian' );
cmp_ok( $dts->month(), '==', 4, 'month() on 2000-03-24 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Astron', 'month_name() on 2000-03-24 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-03-24 Gregorian' );
Sunday 2 Astron 7464
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63089539200, 'utc_rd_as_seconds() on 2000-03-24 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730203,
  0,
  0
]
, 'utc_rd_values() on 2000-03-24 Gregorian' );
cmp_ok( $dts->wday(), '==', 2, 'wday() on 2000-03-24 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  14
]
, 'week() on 2000-03-24 Gregorian' );
cmp_ok( $dts->week_number(), '==', 14, 'week_number() on 2000-03-24 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-03-24 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-03-24 Gregorian' );

$epoch = timegm( 0, 0, 0, 25, 3 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 3,
	day	=> 25,
    ),
);
cmp_ok( $dts->day(), '==', 3, 'day() on 2000-03-25 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Monday', 'day_name() on 2000-03-25 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Monendei', 'day_name_trad() on 2000-03-25 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 3, 'day_of_month() on 2000-03-25 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 3, 'day_of_week() on 2000-03-25 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 94, 'day_of_year() on 2000-03-25 Gregorian' );
cmp_ok( $dts->dow(), '==', 3, 'dow() on 2000-03-25 Gregorian' );
cmp_ok( $dts->doy(), '==', 94, 'doy() on 2000-03-25 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-03-25 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-03-25 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-03-25 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-03-25 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-03-25 Gregorian' );
cmp_ok( $dts->mday(), '==', 3, 'mday() on 2000-03-25 Gregorian' );
cmp_ok( $dts->month(), '==', 4, 'month() on 2000-03-25 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Astron', 'month_name() on 2000-03-25 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-03-25 Gregorian' );
Monday 3 Astron 7464
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63089625600, 'utc_rd_as_seconds() on 2000-03-25 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730204,
  0,
  0
]
, 'utc_rd_values() on 2000-03-25 Gregorian' );
cmp_ok( $dts->wday(), '==', 3, 'wday() on 2000-03-25 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  14
]
, 'week() on 2000-03-25 Gregorian' );
cmp_ok( $dts->week_number(), '==', 14, 'week_number() on 2000-03-25 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-03-25 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-03-25 Gregorian' );

$epoch = timegm( 0, 0, 0, 26, 3 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 3,
	day	=> 26,
    ),
);
cmp_ok( $dts->day(), '==', 4, 'day() on 2000-03-26 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Trewsday', 'day_name() on 2000-03-26 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Trewesdei', 'day_name_trad() on 2000-03-26 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 4, 'day_of_month() on 2000-03-26 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 4, 'day_of_week() on 2000-03-26 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 95, 'day_of_year() on 2000-03-26 Gregorian' );
cmp_ok( $dts->dow(), '==', 4, 'dow() on 2000-03-26 Gregorian' );
cmp_ok( $dts->doy(), '==', 95, 'doy() on 2000-03-26 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-03-26 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-03-26 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-03-26 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-03-26 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-03-26 Gregorian' );
cmp_ok( $dts->mday(), '==', 4, 'mday() on 2000-03-26 Gregorian' );
cmp_ok( $dts->month(), '==', 4, 'month() on 2000-03-26 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Astron', 'month_name() on 2000-03-26 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-03-26 Gregorian' );
Trewsday 4 Astron 7464
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63089712000, 'utc_rd_as_seconds() on 2000-03-26 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730205,
  0,
  0
]
, 'utc_rd_values() on 2000-03-26 Gregorian' );
cmp_ok( $dts->wday(), '==', 4, 'wday() on 2000-03-26 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  14
]
, 'week() on 2000-03-26 Gregorian' );
cmp_ok( $dts->week_number(), '==', 14, 'week_number() on 2000-03-26 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-03-26 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-03-26 Gregorian' );

$epoch = timegm( 0, 0, 0, 27, 3 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 3,
	day	=> 27,
    ),
);
cmp_ok( $dts->day(), '==', 5, 'day() on 2000-03-27 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Hevensday', 'day_name() on 2000-03-27 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Hevenesdei', 'day_name_trad() on 2000-03-27 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 5, 'day_of_month() on 2000-03-27 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 5, 'day_of_week() on 2000-03-27 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 96, 'day_of_year() on 2000-03-27 Gregorian' );
cmp_ok( $dts->dow(), '==', 5, 'dow() on 2000-03-27 Gregorian' );
cmp_ok( $dts->doy(), '==', 96, 'doy() on 2000-03-27 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-03-27 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-03-27 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-03-27 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-03-27 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-03-27 Gregorian' );
cmp_ok( $dts->mday(), '==', 5, 'mday() on 2000-03-27 Gregorian' );
cmp_ok( $dts->month(), '==', 4, 'month() on 2000-03-27 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Astron', 'month_name() on 2000-03-27 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-03-27 Gregorian' );
Hevensday 5 Astron 7464
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63089798400, 'utc_rd_as_seconds() on 2000-03-27 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730206,
  0,
  0
]
, 'utc_rd_values() on 2000-03-27 Gregorian' );
cmp_ok( $dts->wday(), '==', 5, 'wday() on 2000-03-27 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  14
]
, 'week() on 2000-03-27 Gregorian' );
cmp_ok( $dts->week_number(), '==', 14, 'week_number() on 2000-03-27 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-03-27 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-03-27 Gregorian' );

$epoch = timegm( 0, 0, 0, 28, 3 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 3,
	day	=> 28,
    ),
);
cmp_ok( $dts->day(), '==', 6, 'day() on 2000-03-28 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Mersday', 'day_name() on 2000-03-28 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Meresdei', 'day_name_trad() on 2000-03-28 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 6, 'day_of_month() on 2000-03-28 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 6, 'day_of_week() on 2000-03-28 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 97, 'day_of_year() on 2000-03-28 Gregorian' );
cmp_ok( $dts->dow(), '==', 6, 'dow() on 2000-03-28 Gregorian' );
cmp_ok( $dts->doy(), '==', 97, 'doy() on 2000-03-28 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-03-28 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-03-28 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-03-28 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-03-28 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-03-28 Gregorian' );
cmp_ok( $dts->mday(), '==', 6, 'mday() on 2000-03-28 Gregorian' );
cmp_ok( $dts->month(), '==', 4, 'month() on 2000-03-28 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Astron', 'month_name() on 2000-03-28 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-03-28 Gregorian' );
Mersday 6 Astron 7464

The mallorn tree flowers in the party field, 1420.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63089884800, 'utc_rd_as_seconds() on 2000-03-28 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730207,
  0,
  0
]
, 'utc_rd_values() on 2000-03-28 Gregorian' );
cmp_ok( $dts->wday(), '==', 6, 'wday() on 2000-03-28 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  14
]
, 'week() on 2000-03-28 Gregorian' );
cmp_ok( $dts->week_number(), '==', 14, 'week_number() on 2000-03-28 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-03-28 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-03-28 Gregorian' );

$epoch = timegm( 0, 0, 0, 29, 3 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 3,
	day	=> 29,
    ),
);
cmp_ok( $dts->day(), '==', 7, 'day() on 2000-03-29 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Highday', 'day_name() on 2000-03-29 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Highdei', 'day_name_trad() on 2000-03-29 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 7, 'day_of_month() on 2000-03-29 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 7, 'day_of_week() on 2000-03-29 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 98, 'day_of_year() on 2000-03-29 Gregorian' );
cmp_ok( $dts->dow(), '==', 7, 'dow() on 2000-03-29 Gregorian' );
cmp_ok( $dts->doy(), '==', 98, 'doy() on 2000-03-29 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-03-29 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-03-29 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-03-29 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-03-29 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-03-29 Gregorian' );
cmp_ok( $dts->mday(), '==', 7, 'mday() on 2000-03-29 Gregorian' );
cmp_ok( $dts->month(), '==', 4, 'month() on 2000-03-29 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Astron', 'month_name() on 2000-03-29 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-03-29 Gregorian' );
Highday 7 Astron 7464
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63089971200, 'utc_rd_as_seconds() on 2000-03-29 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730208,
  0,
  0
]
, 'utc_rd_values() on 2000-03-29 Gregorian' );
cmp_ok( $dts->wday(), '==', 7, 'wday() on 2000-03-29 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  14
]
, 'week() on 2000-03-29 Gregorian' );
cmp_ok( $dts->week_number(), '==', 14, 'week_number() on 2000-03-29 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-03-29 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-03-29 Gregorian' );

$epoch = timegm( 0, 0, 0, 30, 3 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 3,
	day	=> 30,
    ),
);
cmp_ok( $dts->day(), '==', 8, 'day() on 2000-03-30 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sterday', 'day_name() on 2000-03-30 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sterrendei', 'day_name_trad() on 2000-03-30 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 8, 'day_of_month() on 2000-03-30 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 1, 'day_of_week() on 2000-03-30 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 99, 'day_of_year() on 2000-03-30 Gregorian' );
cmp_ok( $dts->dow(), '==', 1, 'dow() on 2000-03-30 Gregorian' );
cmp_ok( $dts->doy(), '==', 99, 'doy() on 2000-03-30 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-03-30 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-03-30 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-03-30 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-03-30 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-03-30 Gregorian' );
cmp_ok( $dts->mday(), '==', 8, 'mday() on 2000-03-30 Gregorian' );
cmp_ok( $dts->month(), '==', 4, 'month() on 2000-03-30 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Astron', 'month_name() on 2000-03-30 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-03-30 Gregorian' );
Sterday 8 Astron 7464

Ring bearers are honored on the fields of Cormallen, 1419.
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63090057600, 'utc_rd_as_seconds() on 2000-03-30 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730209,
  0,
  0
]
, 'utc_rd_values() on 2000-03-30 Gregorian' );
cmp_ok( $dts->wday(), '==', 1, 'wday() on 2000-03-30 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  15
]
, 'week() on 2000-03-30 Gregorian' );
cmp_ok( $dts->week_number(), '==', 15, 'week_number() on 2000-03-30 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-03-30 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-03-30 Gregorian' );

$epoch = timegm( 0, 0, 0, 31, 3 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 3,
	day	=> 31,
    ),
);
cmp_ok( $dts->day(), '==', 9, 'day() on 2000-03-31 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sunday', 'day_name() on 2000-03-31 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sunnendei', 'day_name_trad() on 2000-03-31 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 9, 'day_of_month() on 2000-03-31 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 2, 'day_of_week() on 2000-03-31 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 100, 'day_of_year() on 2000-03-31 Gregorian' );
cmp_ok( $dts->dow(), '==', 2, 'dow() on 2000-03-31 Gregorian' );
cmp_ok( $dts->doy(), '==', 100, 'doy() on 2000-03-31 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-03-31 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-03-31 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-03-31 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-03-31 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-03-31 Gregorian' );
cmp_ok( $dts->mday(), '==', 9, 'mday() on 2000-03-31 Gregorian' );
cmp_ok( $dts->month(), '==', 4, 'month() on 2000-03-31 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Astron', 'month_name() on 2000-03-31 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-03-31 Gregorian' );
Sunday 9 Astron 7464
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63090144000, 'utc_rd_as_seconds() on 2000-03-31 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730210,
  0,
  0
]
, 'utc_rd_values() on 2000-03-31 Gregorian' );
cmp_ok( $dts->wday(), '==', 2, 'wday() on 2000-03-31 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  15
]
, 'week() on 2000-03-31 Gregorian' );
cmp_ok( $dts->week_number(), '==', 15, 'week_number() on 2000-03-31 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-03-31 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-03-31 Gregorian' );

$epoch = timegm( 0, 0, 0, 1, 4 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 4,
	day	=> 1,
    ),
);
cmp_ok( $dts->day(), '==', 10, 'day() on 2000-04-01 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Monday', 'day_name() on 2000-04-01 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Monendei', 'day_name_trad() on 2000-04-01 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 10, 'day_of_month() on 2000-04-01 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 3, 'day_of_week() on 2000-04-01 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 101, 'day_of_year() on 2000-04-01 Gregorian' );
cmp_ok( $dts->dow(), '==', 3, 'dow() on 2000-04-01 Gregorian' );
cmp_ok( $dts->doy(), '==', 101, 'doy() on 2000-04-01 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-04-01 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-04-01 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-04-01 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-04-01 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-04-01 Gregorian' );
cmp_ok( $dts->mday(), '==', 10, 'mday() on 2000-04-01 Gregorian' );
cmp_ok( $dts->month(), '==', 4, 'month() on 2000-04-01 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Astron', 'month_name() on 2000-04-01 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-04-01 Gregorian' );
Monday 10 Astron 7464
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63090230400, 'utc_rd_as_seconds() on 2000-04-01 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730211,
  0,
  0
]
, 'utc_rd_values() on 2000-04-01 Gregorian' );
cmp_ok( $dts->wday(), '==', 3, 'wday() on 2000-04-01 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  15
]
, 'week() on 2000-04-01 Gregorian' );
cmp_ok( $dts->week_number(), '==', 15, 'week_number() on 2000-04-01 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-04-01 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-04-01 Gregorian' );

$epoch = timegm( 0, 0, 0, 2, 4 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 4,
	day	=> 2,
    ),
);
cmp_ok( $dts->day(), '==', 11, 'day() on 2000-04-02 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Trewsday', 'day_name() on 2000-04-02 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Trewesdei', 'day_name_trad() on 2000-04-02 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 11, 'day_of_month() on 2000-04-02 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 4, 'day_of_week() on 2000-04-02 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 102, 'day_of_year() on 2000-04-02 Gregorian' );
cmp_ok( $dts->dow(), '==', 4, 'dow() on 2000-04-02 Gregorian' );
cmp_ok( $dts->doy(), '==', 102, 'doy() on 2000-04-02 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-04-02 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-04-02 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-04-02 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-04-02 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-04-02 Gregorian' );
cmp_ok( $dts->mday(), '==', 11, 'mday() on 2000-04-02 Gregorian' );
cmp_ok( $dts->month(), '==', 4, 'month() on 2000-04-02 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Astron', 'month_name() on 2000-04-02 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-04-02 Gregorian' );
Trewsday 11 Astron 7464
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63090316800, 'utc_rd_as_seconds() on 2000-04-02 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730212,
  0,
  0
]
, 'utc_rd_values() on 2000-04-02 Gregorian' );
cmp_ok( $dts->wday(), '==', 4, 'wday() on 2000-04-02 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  15
]
, 'week() on 2000-04-02 Gregorian' );
cmp_ok( $dts->week_number(), '==', 15, 'week_number() on 2000-04-02 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-04-02 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-04-02 Gregorian' );

$epoch = timegm( 0, 0, 0, 3, 4 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 4,
	day	=> 3,
    ),
);
cmp_ok( $dts->day(), '==', 12, 'day() on 2000-04-03 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Hevensday', 'day_name() on 2000-04-03 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Hevenesdei', 'day_name_trad() on 2000-04-03 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 12, 'day_of_month() on 2000-04-03 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 5, 'day_of_week() on 2000-04-03 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 103, 'day_of_year() on 2000-04-03 Gregorian' );
cmp_ok( $dts->dow(), '==', 5, 'dow() on 2000-04-03 Gregorian' );
cmp_ok( $dts->doy(), '==', 103, 'doy() on 2000-04-03 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-04-03 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-04-03 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-04-03 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-04-03 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-04-03 Gregorian' );
cmp_ok( $dts->mday(), '==', 12, 'mday() on 2000-04-03 Gregorian' );
cmp_ok( $dts->month(), '==', 4, 'month() on 2000-04-03 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Astron', 'month_name() on 2000-04-03 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-04-03 Gregorian' );
Hevensday 12 Astron 7464

Gandalf arrives in Hobbiton, 1418
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63090403200, 'utc_rd_as_seconds() on 2000-04-03 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730213,
  0,
  0
]
, 'utc_rd_values() on 2000-04-03 Gregorian' );
cmp_ok( $dts->wday(), '==', 5, 'wday() on 2000-04-03 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  15
]
, 'week() on 2000-04-03 Gregorian' );
cmp_ok( $dts->week_number(), '==', 15, 'week_number() on 2000-04-03 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-04-03 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-04-03 Gregorian' );

$epoch = timegm( 0, 0, 0, 4, 4 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 4,
	day	=> 4,
    ),
);
cmp_ok( $dts->day(), '==', 13, 'day() on 2000-04-04 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Mersday', 'day_name() on 2000-04-04 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Meresdei', 'day_name_trad() on 2000-04-04 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 13, 'day_of_month() on 2000-04-04 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 6, 'day_of_week() on 2000-04-04 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 104, 'day_of_year() on 2000-04-04 Gregorian' );
cmp_ok( $dts->dow(), '==', 6, 'dow() on 2000-04-04 Gregorian' );
cmp_ok( $dts->doy(), '==', 104, 'doy() on 2000-04-04 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-04-04 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-04-04 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-04-04 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-04-04 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-04-04 Gregorian' );
cmp_ok( $dts->mday(), '==', 13, 'mday() on 2000-04-04 Gregorian' );
cmp_ok( $dts->month(), '==', 4, 'month() on 2000-04-04 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Astron', 'month_name() on 2000-04-04 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-04-04 Gregorian' );
Mersday 13 Astron 7464
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63090489600, 'utc_rd_as_seconds() on 2000-04-04 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730214,
  0,
  0
]
, 'utc_rd_values() on 2000-04-04 Gregorian' );
cmp_ok( $dts->wday(), '==', 6, 'wday() on 2000-04-04 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  15
]
, 'week() on 2000-04-04 Gregorian' );
cmp_ok( $dts->week_number(), '==', 15, 'week_number() on 2000-04-04 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-04-04 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-04-04 Gregorian' );

$epoch = timegm( 0, 0, 0, 5, 4 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 4,
	day	=> 5,
    ),
);
cmp_ok( $dts->day(), '==', 14, 'day() on 2000-04-05 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Highday', 'day_name() on 2000-04-05 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Highdei', 'day_name_trad() on 2000-04-05 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 14, 'day_of_month() on 2000-04-05 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 7, 'day_of_week() on 2000-04-05 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 105, 'day_of_year() on 2000-04-05 Gregorian' );
cmp_ok( $dts->dow(), '==', 7, 'dow() on 2000-04-05 Gregorian' );
cmp_ok( $dts->doy(), '==', 105, 'doy() on 2000-04-05 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-04-05 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-04-05 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-04-05 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-04-05 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-04-05 Gregorian' );
cmp_ok( $dts->mday(), '==', 14, 'mday() on 2000-04-05 Gregorian' );
cmp_ok( $dts->month(), '==', 4, 'month() on 2000-04-05 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Astron', 'month_name() on 2000-04-05 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-04-05 Gregorian' );
Highday 14 Astron 7464
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63090576000, 'utc_rd_as_seconds() on 2000-04-05 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730215,
  0,
  0
]
, 'utc_rd_values() on 2000-04-05 Gregorian' );
cmp_ok( $dts->wday(), '==', 7, 'wday() on 2000-04-05 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  15
]
, 'week() on 2000-04-05 Gregorian' );
cmp_ok( $dts->week_number(), '==', 15, 'week_number() on 2000-04-05 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-04-05 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-04-05 Gregorian' );

$epoch = timegm( 0, 0, 0, 6, 4 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 4,
	day	=> 6,
    ),
);
cmp_ok( $dts->day(), '==', 15, 'day() on 2000-04-06 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sterday', 'day_name() on 2000-04-06 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sterrendei', 'day_name_trad() on 2000-04-06 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 15, 'day_of_month() on 2000-04-06 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 1, 'day_of_week() on 2000-04-06 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 106, 'day_of_year() on 2000-04-06 Gregorian' );
cmp_ok( $dts->dow(), '==', 1, 'dow() on 2000-04-06 Gregorian' );
cmp_ok( $dts->doy(), '==', 106, 'doy() on 2000-04-06 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-04-06 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-04-06 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-04-06 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-04-06 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-04-06 Gregorian' );
cmp_ok( $dts->mday(), '==', 15, 'mday() on 2000-04-06 Gregorian' );
cmp_ok( $dts->month(), '==', 4, 'month() on 2000-04-06 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Astron', 'month_name() on 2000-04-06 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-04-06 Gregorian' );
Sterday 15 Astron 7464
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63090662400, 'utc_rd_as_seconds() on 2000-04-06 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730216,
  0,
  0
]
, 'utc_rd_values() on 2000-04-06 Gregorian' );
cmp_ok( $dts->wday(), '==', 1, 'wday() on 2000-04-06 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  16
]
, 'week() on 2000-04-06 Gregorian' );
cmp_ok( $dts->week_number(), '==', 16, 'week_number() on 2000-04-06 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-04-06 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-04-06 Gregorian' );

$epoch = timegm( 0, 0, 0, 7, 4 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 4,
	day	=> 7,
    ),
);
cmp_ok( $dts->day(), '==', 16, 'day() on 2000-04-07 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Sunday', 'day_name() on 2000-04-07 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Sunnendei', 'day_name_trad() on 2000-04-07 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 16, 'day_of_month() on 2000-04-07 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 2, 'day_of_week() on 2000-04-07 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 107, 'day_of_year() on 2000-04-07 Gregorian' );
cmp_ok( $dts->dow(), '==', 2, 'dow() on 2000-04-07 Gregorian' );
cmp_ok( $dts->doy(), '==', 107, 'doy() on 2000-04-07 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-04-07 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-04-07 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-04-07 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-04-07 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-04-07 Gregorian' );
cmp_ok( $dts->mday(), '==', 16, 'mday() on 2000-04-07 Gregorian' );
cmp_ok( $dts->month(), '==', 4, 'month() on 2000-04-07 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Astron', 'month_name() on 2000-04-07 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-04-07 Gregorian' );
Sunday 16 Astron 7464
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63090748800, 'utc_rd_as_seconds() on 2000-04-07 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730217,
  0,
  0
]
, 'utc_rd_values() on 2000-04-07 Gregorian' );
cmp_ok( $dts->wday(), '==', 2, 'wday() on 2000-04-07 Gregorian' );
is_deeply( [ $dts->week() ], [
  7464,
  16
]
, 'week() on 2000-04-07 Gregorian' );
cmp_ok( $dts->week_number(), '==', 16, 'week_number() on 2000-04-07 Gregorian' );
cmp_ok( $dts->week_year(), '==', 7464, 'week_year() on 2000-04-07 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-04-07 Gregorian' );

$epoch = timegm( 0, 0, 0, 8, 4 - 1, 2000 );
$dts = DateTime::Fiction::JRRTolkien::Shire->from_object(
    object	=> DateTime->new(
	year	=> 2000,
	month	=> 4,
	day	=> 8,
    ),
);
cmp_ok( $dts->day(), '==', 17, 'day() on 2000-04-08 Gregorian' );
cmp_ok( $dts->day_name(), 'eq', 'Monday', 'day_name() on 2000-04-08 Gregorian' );
cmp_ok( $dts->day_name_trad(), 'eq', 'Monendei', 'day_name_trad() on 2000-04-08 Gregorian' );
cmp_ok( $dts->day_of_month(), '==', 17, 'day_of_month() on 2000-04-08 Gregorian' );
cmp_ok( $dts->day_of_week(), '==', 3, 'day_of_week() on 2000-04-08 Gregorian' );
cmp_ok( $dts->day_of_year(), '==', 108, 'day_of_year() on 2000-04-08 Gregorian' );
cmp_ok( $dts->dow(), '==', 3, 'dow() on 2000-04-08 Gregorian' );
cmp_ok( $dts->doy(), '==', 108, 'doy() on 2000-04-08 Gregorian' );
cmp_ok( $dts->epoch(), '==', $epoch, 'epoch() on 2000-04-08 Gregorian' );
cmp_ok( $dts->hires_epoch(), '==', $epoch, 'hires_epoch() on 2000-04-08 Gregorian' );
cmp_ok( $dts->holiday(), '==', 0, 'holiday() on 2000-04-08 Gregorian' );
cmp_ok( $dts->holiday_name(), 'eq', '', 'holiday_name() on 2000-04-08 Gregorian' );
cmp_ok( $dts->is_leap_year(), '==', 1, 'is_leap_year() on 2000-04-08 Gregorian' );
cmp_ok( $dts->mday(), '==', 17, 'mday() on 2000-04-08 Gregorian' );
cmp_ok( $dts->month(), '==', 4, 'month() on 2000-04-08 Gregorian' );
cmp_ok( $dts->month_name(), 'eq', 'Astron', 'month_name() on 2000-04-08 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-04-08 Gregorian' );
Monday 17 Astron 7464
EOT
cmp_ok( $dts->utc_rd_as_seconds(), '==', 63090835200, 'utc_rd_as_seconds() on 2000-04-08 Gregorian' );
is_deeply( [ $dts->utc_rd_values() ], [
  730218,
  0,
  0
]
, 'utc_rd_values() on 2000-04-08 Greg