package main;

use strict;
use warnings;

use Test2::V0;
use Test2::Plugin::BailOnFail;
use Test2::Tools::LoadModule;

load_module_ok 'Date::ManipX::Almanac::Lang';

load_module_ok 'Date::ManipX::Almanac::Lang::english';

SKIP: {
    $ENV{AUTHOR_TESTING}
	or skip 'Date::ManipX::Almanac::Lang::spanish is unpublished', 1;
    load_module_ok 'Date::ManipX::Almanac::Lang::spanish';
}

load_module_ok 'Date::ManipX::Almanac::Date';

{
    local $@ = undef;

    my $obj = eval { Date::ManipX::Almanac::Date->new() };
    isa_ok $obj, 'Date::ManipX::Almanac::Date';

    my $o2 = eval { $obj->new() };
    isa_ok $o2, 'Date::ManipX::Almanac::Date';

    my $o_config = eval { $obj->new_config() };
    isa_ok $o_config, 'Date::ManipX::Almanac::Date';

    my $o_date = eval { $obj->new_date() };
    isa_ok $o_date, 'Date::ManipX::Almanac::Date';
}

load_module_ok 'Date::ManipX::Almanac';

isa_ok 'Date::ManipX::Almanac', 'Date::Manip::DM6';

done_testing;

1;
