package Astro::Coord::ECI::VSOP87D::Venus;

use 5.008;

use strict;
use warnings;

use base qw{ Astro::Coord::ECI::VSOP87D::_Inferior };

our $VERSION = '0.005_02';

sub __model_definition {
    my ( undef, $key ) = @_;
    return {
      body => "Venus",
      default_model_cutoff => {
        Meeus => {
                   B0   => 9,
                   B1   => 4,
                   B2   => 4,
                   B3   => 4,
                   B4   => 1,
                   L0   => 24,
                   L1   => 12,
                   L2   => 8,
                   L3   => 3,
                   L4   => 3,
                   L5   => 1,
                   name => "Meeus",
                   R0   => 12,
                   R1   => 3,
                   R2   => 3,
                   R3   => 1,
                   R4   => 1,
                 },
        none  => {
                   B0   => 210,
                   B1   => 133,
                   B2   => 59,
                   B3   => 15,
                   B4   => 5,
                   B5   => 4,
                   L0   => 367,
                   L1   => 215,
                   L2   => 70,
                   L3   => 9,
                   L4   => 5,
                   L5   => 5,
                   name => "none",
                   R0   => 330,
                   R1   => 180,
                   R2   => 63,
                   R3   => 7,
                   R4   => 3,
                   R5   => 2,
                 },
      },
      diameter => 12104,
      model => [
        [
          {
            series => "L0",
            terms  => [
                        [3.17614666774, 0, 0],
                        [0.01353968419, 5.59313319619, 10213.285546211],
                        [0.00089891645, 5.30650048468, 20426.571092422],
                        [5.477201e-05, 4.41630652531, 7860.4193924392],
                        [3.455732e-05, 2.69964470778, 11790.6290886588],
                        [2.372061e-05, 2.99377539568, 3930.2096962196],
                        [1.317108e-05, 5.18668219093, 26.2983197998],
                        [1.664069e-05, 4.2501893503, 1577.3435424478],
                        [1.438322e-05, 4.15745043958, 9683.5945811164],
                        [1.200521e-05, 6.15357115319, 30639.856638633],
                        [7.6138e-06, 1.9501470212, 529.6909650946],
                        [7.07676e-06, 1.06466707214, 775.522611324],
                        [5.84836e-06, 3.99839884762, 191.4482661116],
                        [7.69314e-06, 0.81629615911, 9437.762934887],
                        [4.99915e-06, 4.12340210074, 15720.8387848784],
                        [3.26221e-06, 4.59056473097, 10404.7338123226],
                        [4.29498e-06, 3.58642859752, 19367.1891622328],
                        [3.26967e-06, 5.67736583705, 5507.5532386674],
                        [2.31937e-06, 3.16251057072, 9153.9036160218],
                        [1.79695e-06, 4.65337915578, 1109.3785520934],
                        [1.28263e-06, 4.22604493736, 20.7753954924],
                        [1.55464e-06, 5.57043888948, 19651.048481098],
                        [1.27907e-06, 0.96209822685, 5661.3320491522],
                        [1.05547e-06, 1.53721191253, 801.8209311238],
                        [8.5722e-07, 0.35589249966, 3154.6870848956],
                        [9.9121e-07, 0.83288185132, 213.299095438],
                        [9.8804e-07, 5.39389655503, 13367.9726311066],
                        [8.2094e-07, 3.21596990826, 18837.4981971382],
                        [8.8031e-07, 3.88868860307, 9999.986450773],
                        [7.1577e-07, 0.11145739345, 11015.1064773348],
                        [5.6122e-07, 4.24039855475, 7.1135470008],
                        [7.0239e-07, 0.67458813282, 23581.2581773176],
                        [5.0796e-07, 0.24531603049, 11322.6640983044],
                        [4.6111e-07, 5.31576465717, 18073.7049386502],
                        [4.4574e-07, 6.06282201966, 40853.142184844],
                        [4.2594e-07, 5.3287333721, 2352.8661537718],
                        [4.2635e-07, 1.7995542168, 7084.8967811152],
                        [4.1177e-07, 0.36240972161, 382.8965322232],
                        [3.5749e-07, 2.70448479296, 10206.1719992102],
                        [3.3893e-07, 2.02347322198, 6283.0758499914],
                        [2.9138e-07, 3.59230925768, 22003.9146348698],
                        [2.8479e-07, 2.22375414002, 1059.3819301892],
                        [2.985e-07, 4.02176977477, 10239.5838660108],
                        [3.3252e-07, 2.10025596509, 27511.4678735372],
                        [3.0172e-07, 4.9419191989, 13745.3462390224],
                        [2.9252e-07, 3.51392387787, 283.8593188652],
                        [2.4424e-07, 2.70177493852, 8624.2126509272],
                        [2.0274e-07, 3.79493637509, 14143.4952424306],
                        [2.4322e-07, 4.27814493315, 5.5229243074],
                        [2.626e-07, 0.54067587552, 17298.1823273262],
                        [2.0492e-07, 0.58547075036, 38.0276726358],
                        [1.8988e-07, 4.13811500642, 4551.9534970588],
                        [2.3739e-07, 4.82870797552, 6872.6731195112],
                        [1.5885e-07, 1.50067222283, 8635.9420037632],
                        [1.9069e-07, 6.12025580313, 29050.7837433492],
                        [1.8269e-07, 3.04740408477, 19999.972901546],
                        [1.3656e-07, 4.41336292334, 3532.0606928114],
                        [1.7094e-07, 3.5216152643, 31441.6775697568],
                        [1.0955e-07, 2.84562790076, 18307.8072320436],
                        [1.1048e-07, 2.58361219075, 9786.687355335],
                        [9.904e-08, 1.08737710389, 7064.1213856228],
                        [1.0576e-07, 0.85419784436, 10596.1820784342],
                        [9.231e-08, 5.52471655579, 12566.1516999828],
                        [1.1599e-07, 5.81007422699, 19896.8801273274],
                        [1.1807e-07, 1.91250672543, 21228.3920235458],
                        [1.0105e-07, 2.34270786693, 10742.9765113056],
                        [8.154e-08, 1.92331359797, 15.252471185],
                        [8.893e-08, 1.97291388515, 10186.9872264112],
                        [9.352e-08, 4.94508904764, 35371.8872659764],
                        [6.821e-08, 4.39733188968, 8662.240323563],
                        [6.688e-08, 1.55310437864, 14945.3161735544],
                        [6.413e-08, 2.17677652923, 10988.808157535],
                        [5.802e-08, 1.93462125906, 3340.6124266998],
                        [5.95e-08, 2.96578175391, 4732.0306273434],
                        [5.275e-08, 5.01877102496, 28286.9904848612],
                        [7.047e-08, 1.00111452053, 632.7837393132],
                        [5.048e-08, 4.27886209626, 29580.4747084438],
                        [6.305e-08, 0.3550633118, 103.0927742186],
                        [5.959e-08, 5.04792949464, 245.8316462294],
                        [4.651e-08, 0.85218058876, 6770.7106012456],
                        [5.58e-08, 0.48723384809, 522.5774180938],
                        [5.327e-08, 3.03115417024, 10021.8372800994],
                        [5.01e-08, 5.773751665, 28521.0927782546],
                        [4.608e-08, 1.93302108394, 4705.7323075436],
                        [5.526e-08, 3.36797048901, 25158.6017197654],
                        [3.863e-08, 4.89351531412, 25934.1243310894],
                        [5.303e-08, 0.08161426841, 39302.096962196],
                        [4.254e-08, 5.36046113295, 21535.9496445154],
                        [3.763e-08, 1.05304597315, 19.66976089979],
                        [4.407e-08, 4.02575374517, 74.7815985673],
                        [4.145e-08, 1.14356412295, 9676.4810341156],
                        [4.318e-08, 4.38289970585, 316.3918696566],
                        [3.642e-08, 6.11733529325, 3128.3887650958],
                        [3.238e-08, 5.39551036769, 419.4846438752],
                        [3.909e-08, 4.0526363533, 9690.7081281172],
                        [3.152e-08, 0.72553551731, 16496.3613962024],
                        [3.496e-08, 0.72414615705, 3723.508958923],
                        [3.755e-08, 3.80208713127, 19786.673806108],
                        [2.891e-08, 3.3378273777, 32217.2001810808],
                        [3.016e-08, 1.57249112496, 17277.4069318338],
                        [3.825e-08, 0.19612312903, 426.598190876],
                        [3.798e-08, 0.45524571743, 10316.3783204296],
                        [2.57e-08, 1.20813474107, 13936.794505134],
                        [2.796e-08, 3.65128969074, 206.1855484372],
                        [2.466e-08, 3.61988676373, 1551.045222648],
                        [3.108e-08, 1.50325806664, 43232.3066584156],
                        [2.976e-08, 4.79415001304, 29088.811415985],
                        [2.217e-08, 3.59623681714, 24356.7807886416],
                        [2.227e-08, 4.9605922194, 536.8045120954],
                        [2.397e-08, 3.45249688427, 19374.3027092336],
                        [2.462e-08, 0.53295178258, 19360.075615232],
                        [2.205e-08, 2.70399309963, 12592.4500197826],
                        [2.23e-08, 3.01413465913, 18875.525869774],
                        [1.858e-08, 4.06129152783, 2379.1644735716],
                        [1.807e-08, 3.15086214479, 9573.388259897],
                        [2.238e-08, 5.52216925076, 10138.5039476437],
                        [2.195e-08, 2.32046770554, 8094.5216858326],
                        [2.101e-08, 2.90421302975, 9967.4538999816],
                        [1.916e-08, 4.56513949099, 2218.7571041868],
                        [1.467e-08, 2.42640162465, 10234.0609417034],
                        [1.726e-08, 5.59790693845, 20452.8694122218],
                        [1.455e-08, 2.44757248737, 1589.0728952838],
                        [1.991e-08, 4.04623390359, 31749.2351907264],
                        [1.406e-08, 2.71736996917, 16983.9961474566],
                        [1.658e-08, 0.11252373292, 153.7788104848],
                        [1.851e-08, 2.92898027939, 47162.5163546352],
                        [1.492e-08, 1.07513892753, 9103.9069941176],
                        [1.247e-08, 2.48433565896, 17778.116266949],
                        [1.549e-08, 4.205536543, 3442.5749449654],
                        [1.243e-08, 3.95452438599, 170.6728706192],
                        [1.694e-08, 6.20694480406, 33019.0211122046],
                        [1.221e-08, 4.77931820602, 30110.1656735384],
                        [1.206e-08, 0.30531303095, 29864.334027309],
                        [1.238e-08, 5.05581820608, 20213.271996984],
                        [1.152e-08, 3.26229919481, 11.729352836],
                        [1.179e-08, 1.69491074791, 20400.2727726222],
                        [1.165e-08, 2.88995128147, 574.3447983348],
                        [1.306e-08, 0.14519588607, 9146.790069021],
                        [1.113e-08, 1.52598846804, 10426.584641649],
                        [1.104e-08, 2.58791423813, 18849.2275499742],
                        [1.045e-08, 0.5753921642, 15874.6175953632],
                        [1.36e-08, 2.41976595457, 38734.3783244656],
                        [9.81e-09, 4.37930727798, 110.2063212194],
                        [1.095e-08, 0.49492867814, 51066.427731055],
                        [1.146e-08, 4.54241454215, 10220.3990932118],
                        [9.81e-09, 1.65915064733, 10103.0792249916],
                        [1.27e-08, 4.69374306132, 9050.8108418032],
                        [1.065e-08, 4.41645258887, 22805.7355659936],
                        [8.54e-09, 2.34437926957, 6681.2248533996],
                        [1.104e-08, 0.49781459714, 1.4844727083],
                        [1.075e-08, 1.09857593161, 377.3736079158],
                        [1.114e-08, 4.35024775806, 51092.7260508548],
                        [8.29e-09, 5.41196274578, 27991.40181316],
                        [9e-09, 2.74195379617, 41962.5207369374],
                        [1.01e-08, 2.96092073452, 135.62532501],
                        [7.68e-09, 3.98260860494, 18844.611744139],
                        [1.018e-08, 1.36891050752, 36949.2308084242],
                        [7.26e-09, 1.67728773965, 21202.093703746],
                        [7.27e-09, 0.89048212541, 467.9649903544],
                        [8.69e-09, 2.93767679827, 10192.5101507186],
                        [6.96e-09, 5.35698039414, 10063.7223490764],
                        [9.2e-09, 4.17128923588, 18734.4054229196],
                        [6.91e-09, 1.50594097883, 27197.2816936676],
                        [8.35e-09, 0.48050621092, 20618.0193585336],
                        [7.11e-09, 0.19750098222, 18830.3846501374],
                        [8.11e-09, 0.16685071959, 12432.0426503978],
                        [7.56e-09, 3.79022623226, 9161.0171630226],
                        [6.22e-09, 5.33659507738, 9411.4646150872],
                        [8.62e-09, 5.72705356405, 10175.1525105732],
                        [8.53e-09, 0.10404188453, 2107.0345075424],
                        [7.42e-09, 3.96365892051, 813.5502839598],
                        [7.05e-09, 0.71229660616, 220.4126424388],
                        [5.84e-09, 1.719006927, 36.0278666774],
                        [6.12e-09, 0.36418385449, 949.1756089698],
                        [5.87e-09, 1.5864894929, 6.62855890001],
                        [5.81e-09, 5.49288908804, 6309.3741697912],
                        [5.81e-09, 4.80353237853, 24150.080051345],
                        [5.16e-09, 6.07328802561, 38.1330356378],
                        [6.27e-09, 5.47281424954, 9580.5018068978],
                        [6.01e-09, 1.40500080774, 1162.4747044078],
                        [6.2e-09, 4.00681042667, 9992.8729037722],
                        [6.11e-09, 3.62010998629, 7255.5696517344],
                        [6.97e-09, 2.22359630727, 348.924420448],
                        [6.93e-09, 5.77432072851, 55022.9357470744],
                        [4.94e-09, 0.29761886866, 7058.5984613154],
                        [5.63e-09, 0.24172140474, 37410.5672398786],
                        [4.87e-09, 5.86917216517, 10137.0194749354],
                        [4.93e-09, 2.04534833854, 735.8765135318],
                        [6.36e-09, 2.79707392326, 40879.4405046438],
                        [5.19e-09, 4.1394565763, 16522.6597160022],
                        [5.35e-09, 4.6056959782, 19573.37471067],
                        [5.55e-09, 5.88120421263, 26735.9452622132],
                        [4.4e-09, 5.61490649795, 23958.6317852334],
                        [5.41e-09, 0.62494922735, 10007.0999977738],
                        [4.27e-09, 4.02335620501, 14.2270940016],
                        [4.34e-09, 0.29028429049, 9264.1099372412],
                        [4.51e-09, 1.66320363626, 26087.9031415742],
                        [4.22e-09, 3.38413582674, 10787.6303445458],
                        [5.69e-09, 5.14001758731, 27490.6924780448],
                        [4.21e-09, 4.23407313457, 39793.7602546548],
                        [4.58e-09, 5.2878636882, 49.7570254718],
                        [4.18e-09, 5.6909779079, 14765.2390432698],
                        [4.75e-09, 0.97544690438, 1052.2683831884],
                        [3.87e-09, 4.41665162999, 21.8508293264],
                        [5.23e-09, 2.9051242687, 20235.1228263104],
                        [5.06e-09, 5.26999314618, 29999.959352319],
                        [4.38e-09, 2.49457071132, 20956.2620575166],
                        [5.3e-09, 0.71368442157, 33794.5437235286],
                        [3.82e-09, 1.9211936548, 3.9321532631],
                        [3.65e-09, 3.81715328784, 20419.4575454212],
                        [4.26e-09, 2.06384083608, 38204.687359371],
                        [4.96e-09, 0.44077356179, 9835.9119382952],
                        [4.1e-09, 4.93346326003, 19264.0963880142],
                        [3.8e-09, 3.79573358631, 8521.1198767086],
                        [3.34e-09, 5.51158557799, 10251.3132188468],
                        [4.12e-09, 2.56129670728, 77.673770428],
                        [4.18e-09, 2.37865963521, 32.5325507914],
                        [3.25e-09, 6.03020523465, 18947.7045183576],
                        [4e-09, 0.91999360201, 227.476132789],
                        [4.37e-09, 0.91420135162, 58953.145443294],
                        [3.6e-09, 0.82477639126, 22.7752014508],
                        [4.13e-09, 4.22381905655, 44809.6502008634],
                        [3.75e-09, 3.15657291896, 19992.8593545452],
                        [3.71e-09, 6.05370874275, 20007.0864485468],
                        [3.61e-09, 5.44371227904, 19470.2819364514],
                        [3.86e-09, 5.28120540405, 47623.8527860896],
                        [3.89e-09, 0.7321667224, 19050.7972925762],
                        [3.2e-09, 2.84811591194, 10199.0584522094],
                        [3.86e-09, 3.88754165531, 1975.492545856],
                        [2.76e-09, 4.33979180814, 20809.4676246452],
                        [2.76e-09, 0.50647429773, 9830.3890139878],
                        [3.09e-09, 3.79299100668, 18204.714457825],
                        [3.77e-09, 0.73768791281, 11506.7697697936],
                        [3.22e-09, 0.961384421, 30666.1549584328],
                        [3.63e-09, 1.3047240669, 9367.2027114598],
                        [3.66e-09, 2.79972786028, 11272.6674764002],
                        [2.71e-09, 4.66141338193, 846.0828347512],
                        [2.59e-09, 0.4203117575, 39264.0692895602],
                        [2.85e-09, 0.40546033634, 30.914125635],
                        [2.47e-09, 4.80676426942, 36147.4098773004],
                        [2.64e-09, 2.71608177583, 11.0457002639],
                        [2.33e-09, 2.76423842887, 187.9251477626],
                        [2.48e-09, 1.60765612338, 10497.1448650762],
                        [2.71e-09, 0.8234891963, 19793.7873531088],
                        [2.25e-09, 3.80080957016, 8631.326197928],
                        [2.63e-09, 1.92311689852, 37724.7534197482],
                        [2.14e-09, 5.01663795092, 639.897286314],
                        [2.89e-09, 0.12342601246, 20277.0078952874],
                        [2.1e-09, 0.12771800254, 29.8214381488],
                        [2.27e-09, 4.18036609801, 17468.8551979454],
                        [2.74e-09, 2.34929343, 62883.3551395136],
                        [2.6e-09, 5.65254501655, 48739.859897083],
                        [2.71e-09, 4.95325404028, 4214.0690150848],
                        [2.19e-09, 2.08775228014, 194.9713844606],
                        [1.91e-09, 2.49267248333, 568.8218740274],
                        [2.5e-09, 1.52909737354, 6037.244203762],
                        [2.31e-09, 5.23674429498, 491.6632924588],
                        [1.82e-09, 4.98046042571, 18418.013553263],
                        [1.88e-09, 2.82273639603, 1385.8952763362],
                        [2.04e-09, 4.09939796199, 14919.0178537546],
                        [1.76e-09, 3.8240098246, 9360.089164459],
                        [1.98e-09, 2.76491873243, 10217.2176994741],
                        [1.68e-09, 5.19268384202, 1066.49547719],
                        [1.99e-09, 1.95301487982, 7564.830720738],
                        [1.71e-09, 2.59623459612, 20405.7956969296],
                        [1.72e-09, 5.29332132623, 11764.330768859],
                        [1.65e-09, 2.88557908025, 10207.7626219036],
                        [1.64e-09, 3.25435371801, 3914.9572250346],
                        [2e-09, 3.8244321809, 18314.9207790444],
                        [1.69e-09, 1.78341902878, 31022.7531708562],
                        [1.79e-09, 0.90840065587, 7880.08915333899],
                        [1.63e-09, 2.79665037814, 41.5507909848],
                        [1.54e-09, 3.90796293476, 30213.258447757],
                        [1.53e-09, 0.07463240782, 28528.2063252554],
                        [1.94e-09, 5.95838706838, 8617.0991039264],
                        [1.71e-09, 4.58206324409, 20447.3464879144],
                        [1.5e-09, 2.11647586229, 17248.4253018544],
                        [1.49e-09, 2.1725998632, 9929.4262273458],
                        [1.91e-09, 0.82310353823, 52670.0695933026],
                        [1.48e-09, 2.94315921485, 41654.9631159678],
                        [1.49e-09, 4.49798039726, 30831.3049047446],
                        [1.84e-09, 2.46923348701, 34596.3646546524],
                        [1.46e-09, 2.694529303, 43071.8992890308],
                        [1.59e-09, 2.1113771357, 19317.1925403286],
                        [1.54e-09, 2.76536164654, 28513.9792312538],
                        [1.4e-09, 4.94595038686, 9256.9963902404],
                        [1.41e-09, 2.57248458154, 13553.8979729108],
                        [1.37e-09, 1.66482327575, 2636.725472637],
                        [1.4e-09, 5.2303960599, 22645.3281966088],
                        [1.32e-09, 5.35690599728, 19624.7501612982],
                        [1.4e-09, 2.90637712614, 48947.6638706766],
                        [1.29e-09, 3.95303623681, 32858.6137428198],
                        [1.56e-09, 6.01143316387, 29057.89729035],
                        [1.34e-09, 5.75241675118, 68050.4238785116],
                        [1.54e-09, 3.66827363753, 276.7457718644],
                        [1.76e-09, 3.77298381177, 66813.5648357332],
                        [1.26e-09, 5.00217740223, 27461.7108480654],
                        [1.35e-09, 1.3480701392, 53285.1848352418],
                        [1.5e-09, 0.25029475344, 290.972865866],
                        [1.52e-09, 3.13035670092, 29043.6701963484],
                        [1.69e-09, 5.0434810943, 73.297125859],
                        [1.66e-09, 5.39219948035, 41236.0387170672],
                        [1.63e-09, 5.59796070987, 7576.560073574],
                        [1.26e-09, 0.77391784606, 49.9966219042],
                        [1.63e-09, 0.44241846674, 20350.3050211464],
                        [1.36e-09, 3.09066368912, 418.9243989006],
                        [1.54e-09, 0.4708619096, 28418.000004036],
                        [1.2e-09, 0.88536981986, 29573.361161443],
                        [1.32e-09, 1.4800976904, 17085.9586657222],
                        [1.26e-09, 1.39497760964, 966.9708774356],
                        [1.43e-09, 3.84026797958, 14128.2427712456],
                        [1.47e-09, 2.11627427804, 34363.365597556],
                        [1.06e-09, 2.04696932293, 37674.9963942764],
                        [1.06e-09, 1.43873202489, 27682.1407441564],
                        [1.49e-09, 0.09286508794, 8144.2787113044],
                        [1.03e-09, 0.0199204147, 18300.6936850428],
                        [1.21e-09, 3.57602835443, 45.1412196366],
                        [1.25e-09, 0.11630302078, 149.5631971346],
                        [1.02e-09, 4.1794709773, 2333.196392872],
                        [9.9e-10, 1.51324741657, 10419.4710946482],
                        [1.33e-09, 3.02183293676, 76251.3277706202],
                        [1.36e-09, 4.17517197268, 3646.3503773544],
                        [1.23e-09, 0.44045588682, 515.463871093],
                        [1.13e-09, 5.69261397718, 10110.1927719924],
                        [9.8e-10, 6.23797900467, 202.2533951741],
                        [9.9e-10, 3.75627530197, 59728.668054618],
                        [1.01e-09, 4.62832557536, 65236.2212932854],
                        [1.11e-09, 1.25947267588, 10846.0692855242],
                        [1.1e-09, 5.87455577536, 38500.2760310722],
                        [1.28e-09, 6.0102456216, 90394.8230130508],
                        [9.1e-10, 1.77665981007, 1539.315869812],
                        [9.2e-10, 0.99804571578, 95.9792272178],
                        [1.2e-09, 3.93060866244, 38526.574350872],
                        [1.17e-09, 2.24143299549, 56600.2792895222],
                        [1.18e-09, 6.0912132594, 29786.660256881],
                        [9.8e-10, 4.60938156207, 11787.1059703098],
                        [9.7e-10, 3.92727733144, 11794.1522070078],
                        [9.3e-10, 5.23395435043, 14169.7935622304],
                        [9.6e-10, 5.27525709038, 8734.4189721466],
                        [9.4e-10, 0.18166654805, 67589.0874470572],
                        [1.1e-09, 4.96279287076, 48417.972905582],
                        [8.6e-10, 0.39533409505, 3956.5080160194],
                        [8.5e-10, 5.69642646462, 37703.9780242558],
                        [1.14e-09, 5.19676285428, 70743.7745319528],
                        [8.1e-10, 5.51324815184, 412.3710968744],
                        [8.9e-10, 2.13409771828, 44768.0994098786],
                        [8.4e-10, 6.02475904578, 10632.7701900862],
                        [8.5e-10, 4.60912614442, 45585.1728121874],
                        [7.8e-10, 4.47358603432, 114.43928868521],
                        [9.7e-10, 4.02223363535, 10218.8084705184],
                        [8.1e-10, 1.03870237004, 9793.8009023358],
                        [9.2e-10, 0.80301220092, 24383.0791084414],
                        [8.7e-10, 2.15124790938, 28313.288804661],
                        [7.5e-10, 5.17868679355, 63658.8777508376],
                        [7.8e-10, 5.81927313665, 567.7186377304],
                        [7.5e-10, 1.72618192481, 19580.4882576708],
                        [7.1e-10, 0.10259261764, 90695.7520751204],
                        [7.7e-10, 6.16012067704, 1573.8204240988],
                        [7.6e-10, 5.12884307551, 49515.382508407],
                        [6.9e-10, 0.29569499484, 10175.2578735752],
                        [6.1e-10, 4.80385549281, 19889.7665803266],
                        [6e-10, 4.56685040226, 30426.557543195],
                        [6.2e-10, 4.16222812699, 42430.4857272918],
                        [5e-10, 6.17899839001, 22779.4372461938],
                        [4.8e-10, 1.52546758016, 20639.87018786],
                        [4.6e-10, 4.41738494249, 34570.0663348526],
                        [3.7e-10, 4.69675087759, 44007.8292697396],
                      ],
          },
          {
            series => "L1",
            terms  => [
                        [10213.529430529, 0, 0],
                        [0.00095707712, 2.46424448979, 10213.285546211],
                        [0.00014444977, 0.51624564679, 20426.571092422],
                        [2.13374e-06, 1.79547929368, 30639.856638633],
                        [1.51669e-06, 6.10635282369, 1577.3435424478],
                        [1.73904e-06, 2.65535879443, 26.2983197998],
                        [8.2233e-07, 5.7023413373, 191.4482661116],
                        [6.9734e-07, 2.68136034979, 9437.762934887],
                        [5.2408e-07, 3.60013087656, 775.522611324],
                        [3.8318e-07, 1.03379038025, 529.6909650946],
                        [2.9633e-07, 1.25056322354, 5507.5532386674],
                        [2.5056e-07, 6.10664792855, 10404.7338123226],
                        [1.7772e-07, 6.19369798901, 1109.3785520934],
                        [1.651e-07, 2.6433045264, 7.1135470008],
                        [1.423e-07, 5.45138233941, 9153.9036160218],
                        [1.2607e-07, 1.24464400689, 40853.142184844],
                        [1.1627e-07, 4.97604495371, 213.299095438],
                        [1.2563e-07, 1.88122199199, 382.8965322232],
                        [8.869e-08, 0.95282732248, 13367.9726311066],
                        [7.374e-08, 4.3947676058, 10206.1719992102],
                        [6.552e-08, 2.28168808058, 2352.8661537718],
                        [6.255e-08, 4.08056644034, 3154.6870848956],
                        [6.697e-08, 5.05673427795, 801.8209311238],
                        [4.084e-08, 4.1210382603, 18837.4981971382],
                        [4.882e-08, 3.44515199115, 11015.1064773348],
                        [3.549e-08, 6.19934345402, 5.5229243074],
                        [3.448e-08, 1.77405651704, 11322.6640983044],
                        [4.29e-08, 0.0815480921, 6283.0758499914],
                        [3.694e-08, 2.48453945256, 5661.3320491522],
                        [3.555e-08, 1.4803694942, 1059.3819301892],
                        [3.023e-08, 2.24092938317, 18073.7049386502],
                        [3e-08, 0.39169917698, 15.252471185],
                        [2.563e-08, 0.35147506973, 22003.9146348698],
                        [2.774e-08, 1.45683830639, 10239.5838660108],
                        [2.951e-08, 5.34618097429, 7084.8967811152],
                        [2.344e-08, 2.36652432105, 17298.1823273262],
                        [2.405e-08, 2.36085282088, 10596.1820784342],
                        [1.72e-08, 4.72129626061, 10186.9872264112],
                        [2.209e-08, 2.07730338665, 8635.9420037632],
                        [2.122e-08, 4.47091605309, 8624.2126509272],
                        [1.527e-08, 0.67146857292, 14143.4952424306],
                        [1.473e-08, 2.59350470099, 7064.1213856228],
                        [1.311e-08, 0.90408820221, 12566.1516999828],
                        [1.474e-08, 5.92236241437, 9786.687355335],
                        [1.237e-08, 2.59740787132, 4551.9534970588],
                        [1.219e-08, 2.83617320088, 9676.4810341156],
                        [1.116e-08, 3.83715584719, 21228.3920235458],
                        [1.006e-08, 4.26200749078, 426.598190876],
                        [1.15e-08, 2.35531987378, 9690.7081281172],
                        [1.219e-08, 2.27324315182, 522.5774180938],
                        [1.15e-08, 0.81088598778, 10742.9765113056],
                        [1.101e-08, 3.74248783564, 18307.8072320436],
                        [1.031e-08, 2.03889374176, 38.0276726358],
                        [9.71e-09, 6.10590045414, 3532.0606928114],
                        [8.44e-09, 4.75124127613, 10988.808157535],
                        [9.08e-09, 1.06613723738, 10021.8372800994],
                        [8.24e-09, 0.23090829723, 28286.9904848612],
                        [8.21e-09, 2.60456032773, 19.66976089979],
                        [7.28e-09, 0.10716917942, 4705.7323075436],
                        [7.44e-09, 3.33129778857, 536.8045120954],
                        [8.16e-09, 1.27303930175, 19896.8801273274],
                        [9.29e-09, 1.08024621325, 11790.6290886588],
                        [7.97e-09, 2.23891816523, 3723.508958923],
                        [7.04e-09, 5.95307260017, 20.7753954924],
                        [6.65e-09, 0.21346689192, 7860.4193924392],
                        [7.33e-09, 2.22147883292, 19360.075615232],
                        [7.02e-09, 1.76206343944, 19374.3027092336],
                        [5.75e-09, 2.38792087791, 6770.7106012456],
                        [5.38e-09, 1.52023264138, 25934.1243310894],
                        [6.9e-09, 4.01873754171, 19651.048481098],
                        [5.32e-09, 4.4157613089, 574.3447983348],
                        [5.4e-09, 2.15936134728, 16496.3613962024],
                        [5.76e-09, 5.41170044566, 206.1855484372],
                        [4.82e-09, 0.40815793538, 3340.6124266998],
                        [5.01e-09, 3.08578363577, 245.8316462294],
                        [4.88e-09, 5.22311611589, 25158.6017197654],
                        [4.5e-09, 0.212798446, 11.729352836],
                        [4.32e-09, 1.32004964493, 103.0927742186],
                        [4.34e-09, 5.91094755233, 19786.673806108],
                        [5.64e-09, 0.38776462529, 19367.1891622328],
                        [4.21e-09, 2.71057839701, 13936.794505134],
                        [5.49e-09, 6.08792865644, 3930.2096962196],
                        [4.78e-09, 4.70234715828, 14945.3161735544],
                        [4.08e-09, 4.80890663927, 32217.2001810808],
                        [4.04e-09, 2.85003595942, 29864.334027309],
                        [4.07e-09, 2.94002049006, 10220.3990932118],
                        [3.59e-09, 0.72354778897, 419.4846438752],
                        [4.49e-09, 1.44520508753, 8662.240323563],
                        [3.53e-09, 2.22195492336, 51066.427731055],
                        [3.24e-09, 1.40308439067, 29580.4747084438],
                        [4.43e-09, 1.93864353398, 9146.790069021],
                        [3.14e-09, 0.96837035284, 20618.0193585336],
                        [3.24e-09, 5.10759068171, 24356.7807886416],
                        [3.24e-09, 1.80146948625, 18830.3846501374],
                        [3.7e-09, 6.16895004656, 2218.7571041868],
                        [2.78e-09, 2.20429108375, 18844.611744139],
                        [2.86e-09, 3.08459438435, 17277.4069318338],
                        [3.83e-09, 0.13890934755, 4732.0306273434],
                        [2.92e-09, 0.43528982259, 29088.811415985],
                        [2.73e-09, 5.84415407168, 9573.388259897],
                        [3.24e-09, 2.14144542781, 9999.986450773],
                        [2.64e-09, 5.20407029554, 220.4126424388],
                        [2.54e-09, 0.34411959301, 28521.0927782546],
                        [3e-09, 3.76014360906, 8094.5216858326],
                        [3.01e-09, 3.64457981649, 20400.2727726222],
                        [2.87e-09, 1.84003536598, 1589.0728952838],
                        [2.06e-09, 0.97167234723, 10234.0609417034],
                        [2.12e-09, 0.241736776, 36.0278666774],
                        [2.16e-09, 5.8861892303, 18875.525869774],
                        [1.98e-09, 1.89506914939, 20452.8694122218],
                        [2.58e-09, 6.27611355094, 1551.045222648],
                        [1.97e-09, 2.09222675324, 9683.5945811164],
                        [2.17e-09, 5.79472589364, 9103.9069941176],
                        [1.88e-09, 0.39123199129, 19573.37471067],
                        [1.95e-09, 6.23142464829, 30110.1656735384],
                        [1.87e-09, 5.49670351645, 170.6728706192],
                        [1.78e-09, 4.90042854659, 10787.6303445458],
                        [1.88e-09, 1.62614804098, 9161.0171630226],
                        [2.11e-09, 2.71884568392, 15720.8387848784],
                        [1.77e-09, 1.88170417337, 33019.0211122046],
                        [2.09e-09, 2.66033422116, 3442.5749449654],
                        [1.64e-09, 4.92240093026, 10426.584641649],
                        [1.86e-09, 5.13678812068, 7255.5696517344],
                        [1.77e-09, 5.70206821967, 9992.8729037722],
                        [2.14e-09, 2.70027196648, 3128.3887650958],
                        [2.08e-09, 3.38876526854, 17778.116266949],
                        [1.47e-09, 4.25008782855, 16983.9961474566],
                        [1.48e-09, 3.4640441813, 21202.093703746],
                        [1.89e-09, 1.43553862242, 2379.1644735716],
                        [1.39e-09, 2.99154379541, 110.2063212194],
                        [1.59e-09, 5.23851679605, 10007.0999977738],
                        [1.36e-09, 0.88942869764, 22805.7355659936],
                        [1.55e-09, 5.90500835975, 12592.4500197826],
                        [1.51e-09, 0.03422618975, 27991.40181316],
                        [1.53e-09, 4.01743770323, 33794.5437235286],
                        [1.21e-09, 0.51392111799, 21535.9496445154],
                        [1.09e-09, 2.25388616761, 26735.9452622132],
                        [1.09e-09, 0.78612823474, 6681.2248533996],
                        [1.22e-09, 4.84805105466, 19992.8593545452],
                        [1.12e-09, 3.31796669604, 36949.2308084242],
                        [1.06e-09, 3.34507236765, 10103.0792249916],
                        [1.14e-09, 4.36384000196, 20007.0864485468],
                        [9.8e-10, 5.07711736751, 135.62532501],
                        [1.2e-09, 5.41870615047, 37724.7534197482],
                        [1.03e-09, 2.62610244425, 20213.271996984],
                        [8.5e-10, 5.04808202087, 9830.3890139878],
                        [1.03e-09, 2.01549383816, 45585.1728121874],
                        [8.8e-10, 2.62613816931, 21.8508293264],
                        [8.4e-10, 3.50355880173, 639.897286314],
                        [9.9e-10, 0.61079620895, 41654.9631159678],
                        [8.8e-10, 3.63836700262, 49515.382508407],
                        [9.8e-10, 2.42401801881, 23581.2581773176],
                        [8.1e-10, 0.46468679835, 77.673770428],
                        [9.2e-10, 4.82530051729, 29043.6701963484],
                        [1.02e-09, 4.27051236894, 15874.6175953632],
                        [9e-10, 4.34075776744, 29057.89729035],
                        [8.1e-10, 0.01896422336, 24150.080051345],
                        [9.3e-10, 1.79250830018, 12432.0426503978],
                        [8.7e-10, 5.25157021446, 14128.2427712456],
                        [8.9e-10, 5.65756996753, 377.3736079158],
                        [9.7e-10, 5.67942873241, 227.476132789],
                        [7.6e-10, 2.93363913259, 38204.687359371],
                        [9.1e-10, 2.60544242067, 1052.2683831884],
                        [8.7e-10, 3.82284200928, 27511.4678735372],
                        [7.3e-10, 4.75280755154, 40879.4405046438],
                        [6.7e-10, 3.54815262526, 30666.1549584328],
                        [6.7e-10, 5.81350818057, 20809.4676246452],
                        [6.4e-10, 4.24772678145, 153.7788104848],
                        [6.4e-10, 2.99454749109, 27197.2816936676],
                        [7e-10, 4.03868009742, 56600.2792895222],
                        [7.1e-10, 4.3362880685, 39264.0692895602],
                        [6.9e-10, 1.73648747605, 37410.5672398786],
                        [6.5e-10, 1.08206062736, 68050.4238785116],
                        [6.2e-10, 4.7769845465, 3914.9572250346],
                        [6.1e-10, 4.96121014691, 34596.3646546524],
                        [6.3e-10, 5.04865067599, 53445.5922046266],
                        [5.8e-10, 3.74010494151, 1066.49547719],
                        [5.7e-10, 5.39355890141, 20419.4575454212],
                        [5.7e-10, 3.59399518494, 735.8765135318],
                        [6.5e-10, 2.10322000074, 74.7815985673],
                        [7.3e-10, 1.31083648835, 11272.6674764002],
                        [5.5e-10, 1.33161298098, 18300.6936850428],
                        [6.5e-10, 4.21150522641, 49.7570254718],
                        [6.1e-10, 5.66161679402, 17468.8551979454],
                        [5.3e-10, 4.30231233835, 18849.2275499742],
                        [5.5e-10, 2.63906959481, 52670.0695933026],
                        [5e-10, 5.69803054279, 39793.7602546548],
                        [4.9e-10, 0.77345264124, 35371.8872659764],
                        [4.8e-10, 6.00565977593, 283.8593188652],
                        [4.7e-10, 2.63299859494, 51868.2486621788],
                        [4.6e-10, 0.05105081843, 38526.574350872],
                        [5e-10, 4.37549274002, 28513.9792312538],
                        [4.6e-10, 2.93422086586, 27682.1407441564],
                        [5.1e-10, 5.45979584751, 60530.4889857418],
                        [4.5e-10, 5.59492908223, 467.9649903544],
                        [4.5e-10, 2.34680401001, 9411.4646150872],
                        [4.5e-10, 0.02999265111, 44809.6502008634],
                        [4.3e-10, 5.62725673544, 14.2270940016],
                        [4.7e-10, 3.73567275749, 64460.6986819614],
                        [4.6e-10, 0.12586526756, 57375.8019008462],
                        [4.4e-10, 2.03114426076, 18314.9207790444],
                        [3.9e-10, 0.99375127466, 94138.3270200858],
                        [5.3e-10, 0.41974404621, 30831.3049047446],
                        [5.5e-10, 1.38351566741, 38500.2760310722],
                        [4.1e-10, 4.47012768909, 40077.61957352],
                        [4.1e-10, 0.36665992484, 19999.972901546],
                        [4e-10, 3.06358586355, 813.5502839598],
                        [4e-10, 2.16802870803, 59728.668054618],
                        [3.7e-10, 1.08739100421, 17085.9586657222],
                        [3.9e-10, 1.31040309875, 48739.859897083],
                        [3.6e-10, 1.43280677914, 42456.7840470916],
                        [3.7e-10, 0.14190533464, 29050.7837433492],
                        [3.7e-10, 3.66792179278, 20956.2620575166],
                        [2.5e-10, 3.38876180652, 7058.5984613154],
                        [3.1e-10, 6.16829805337, 10192.5101507186],
                      ],
          },
          {
            series => "L2",
            terms  => [
                        [0.00054127076, 0, 0],
                        [3.89146e-05, 0.34514360047, 10213.285546211],
                        [1.33788e-05, 2.02011286082, 20426.571092422],
                        [2.3836e-07, 2.04592119012, 26.2983197998],
                        [1.9331e-07, 3.53527371458, 30639.856638633],
                        [9.984e-08, 3.97130221102, 775.522611324],
                        [7.046e-08, 1.51962593409, 1577.3435424478],
                        [6.014e-08, 0.99926757893, 191.4482661116],
                        [3.163e-08, 4.36095475762, 9437.762934887],
                        [2.125e-08, 2.65810625752, 40853.142184844],
                        [1.934e-08, 3.39287946981, 382.8965322232],
                        [1.46e-08, 6.04899046273, 529.6909650946],
                        [1.346e-08, 2.94633106219, 5507.5532386674],
                        [1.025e-08, 1.40598904981, 10404.7338123226],
                        [1.221e-08, 3.73339139385, 3154.6870848956],
                        [1.033e-08, 3.52858472904, 11015.1064773348],
                        [9.55e-09, 5.11133878923, 801.8209311238],
                        [7.42e-09, 1.49198584483, 1109.3785520934],
                        [5.25e-09, 3.32087042103, 213.299095438],
                        [5.78e-09, 0.92614279843, 10239.5838660108],
                        [6.02e-09, 5.19220099775, 7084.8967811152],
                        [4.31e-09, 2.67159914364, 13367.9726311066],
                        [3.89e-09, 4.14116341739, 8635.9420037632],
                        [3.55e-09, 1.12061570874, 9153.9036160218],
                        [3.01e-09, 3.90047984197, 10596.1820784342],
                        [2.12e-09, 5.32697688872, 18837.4981971382],
                        [2.6e-09, 0.22761369281, 2352.8661537718],
                        [2.43e-09, 4.70747902991, 6283.0758499914],
                        [1.96e-09, 4.10467294392, 11790.6290886588],
                        [1.94e-09, 6.0119775947, 7860.4193924392],
                        [1.4e-09, 4.97015671653, 14143.4952424306],
                        [1.34e-09, 4.10529011674, 17298.1823273262],
                        [1.19e-09, 3.39375528828, 11322.6640983044],
                        [1.26e-09, 0.0985451614, 18073.7049386502],
                        [1.22e-09, 5.92478855457, 574.3447983348],
                        [1.07e-09, 0.35660030184, 1059.3819301892],
                        [1.08e-09, 2.25352052666, 12566.1516999828],
                        [9.3e-10, 5.48716819776, 10021.8372800994],
                        [8.4e-10, 4.89744332968, 18307.8072320436],
                        [7.4e-10, 2.35354025573, 426.598190876],
                        [9.3e-10, 4.99316908815, 14945.3161735544],
                        [6.9e-10, 3.8640906586, 51066.427731055],
                        [8.2e-10, 5.36280178643, 10186.9872264112],
                        [7.7e-10, 3.75728548372, 3723.508958923],
                        [6.3e-10, 5.39882267787, 21228.3920235458],
                        [5.6e-10, 4.11564786973, 7064.1213856228],
                        [5.6e-10, 6.26920407723, 32217.2001810808],
                        [6e-10, 5.02186497542, 19367.1891622328],
                        [5.8e-10, 5.1326370967, 20400.2727726222],
                        [5.1e-10, 4.52870390511, 22003.9146348698],
                        [4.1e-10, 3.83822107919, 16496.3613962024],
                        [4.1e-10, 3.36020411807, 4705.7323075436],
                        [4.3e-10, 5.98371820588, 15720.8387848784],
                        [4.7e-10, 0.18498155367, 18875.525869774],
                        [3.8e-10, 0.52232581277, 1551.045222648],
                        [3.9e-10, 5.05391675878, 10742.9765113056],
                        [3.6e-10, 3.16242472203, 20452.8694122218],
                        [3.5e-10, 5.17462577483, 29088.811415985],
                        [3.5e-10, 3.47325394141, 24356.7807886416],
                        [3.1e-10, 4.74511706231, 28521.0927782546],
                        [2.9e-10, 0.19383091192, 19896.8801273274],
                        [3.3e-10, 1.80059867635, 20618.0193585336],
                        [2.4e-10, 0.14022912457, 21202.093703746],
                        [2.2e-10, 4.73565067573, 10988.808157535],
                        [1.8e-10, 0.74039763161, 25158.6017197654],
                        [1.9e-10, 1.53770232218, 28286.9904848612],
                        [1.4e-10, 1.49084059765, 30110.1656735384],
                        [1.3e-10, 4.72171283479, 29864.334027309],
                        [1.3e-10, 5.79700427846, 29580.4747084438],
                        [1.4e-10, 3.6920522501, 27511.4678735372],
                      ],
          },
          {
            series => "L3",
            terms  => [
                        [1.35742e-06, 4.80389020993, 10213.285546211],
                        [7.7846e-07, 3.66876371591, 20426.571092422],
                        [2.6023e-07, 0, 0],
                        [1.214e-08, 5.31970006917, 30639.856638633],
                        [2.54e-09, 4.15021671822, 40853.142184844],
                        [8e-11, 5.55523563261, 51066.427731055],
                        [8e-11, 1.40501229148, 1577.3435424478],
                        [6e-11, 1.27791479726, 10404.7338123226],
                        [6e-11, 5.76447068962, 10239.5838660108],
                      ],
          },
          {
            series => "L4",
            terms  => [
                        [1.14016e-06, 3.14159265359, 0],
                        [3.209e-08, 5.20514170164, 20426.571092422],
                        [1.714e-08, 2.51099591706, 10213.285546211],
                        [5e-10, 0.71356059861, 30639.856638633],
                        [2.3e-10, 5.68127607034, 40853.142184844],
                      ],
          },
          {
            series => "L5",
            terms  => [
                        [8.74e-09, 3.14159265359, 0],
                        [1.17e-09, 0.54643013, 20426.571092422],
                        [1.18e-09, 1.90548541922, 10213.285546211],
                        [2e-11, 1.07734277826, 40853.142184844],
                        [2e-11, 1.89460223529, 30639.856638633],
                      ],
          },
        ],
        [
          {
            series => "B0",
            terms  => [
                        [0.05923638472, 0.26702775813, 10213.285546211],
                        [0.00040107978, 1.14737178106, 20426.571092422],
                        [0.00032814918, 3.14159265359, 0],
                        [1.011392e-05, 1.08946123021, 30639.856638633],
                        [1.49458e-06, 6.25390296069, 18073.7049386502],
                        [1.37788e-06, 0.86020146523, 1577.3435424478],
                        [1.29973e-06, 3.67152483651, 9437.762934887],
                        [1.19507e-06, 3.70468812804, 2352.8661537718],
                        [1.07971e-06, 4.53903677647, 22003.9146348698],
                        [9.2029e-07, 1.53954562706, 9153.9036160218],
                        [5.2982e-07, 2.28138172277, 5507.5532386674],
                        [4.5617e-07, 0.72319641722, 10239.5838660108],
                        [3.8855e-07, 2.93437865147, 10186.9872264112],
                        [4.3491e-07, 6.14015776699, 11790.6290886588],
                        [4.17e-07, 5.99126845246, 19896.8801273274],
                        [3.9644e-07, 3.86842095901, 8635.9420037632],
                        [3.9175e-07, 3.94960351174, 529.6909650946],
                        [3.332e-07, 4.83194909595, 14143.4952424306],
                        [2.3711e-07, 2.90646621218, 10988.808157535],
                        [2.35e-07, 2.00770618322, 13367.9726311066],
                        [2.1809e-07, 2.69701424951, 19651.048481098],
                        [2.0653e-07, 0.98666685459, 775.522611324],
                        [1.6976e-07, 4.13711782135, 10021.8372800994],
                        [1.7835e-07, 5.96268643102, 25934.1243310894],
                        [1.4949e-07, 5.61075168206, 10404.7338123226],
                        [1.8579e-07, 1.80529277514, 40853.142184844],
                        [1.5407e-07, 3.29563855296, 11015.1064773348],
                        [1.2936e-07, 5.42651448496, 29580.4747084438],
                        [1.1962e-07, 3.57604253827, 10742.9765113056],
                        [1.1827e-07, 1.190709196, 8624.2126509272],
                        [1.1466e-07, 5.12780364967, 6283.0758499914],
                        [9.484e-08, 2.75167834335, 191.4482661116],
                        [1.3129e-07, 5.70735942511, 9683.5945811164],
                        [8.583e-08, 0.43182249199, 9786.687355335],
                        [9.763e-08, 0.14614896296, 20618.0193585336],
                        [8.148e-08, 1.30548515603, 15720.8387848784],
                        [6.05e-08, 6.26541665966, 11322.6640983044],
                        [5.955e-08, 4.92235372433, 1059.3819301892],
                        [6.983e-08, 3.44920932146, 17298.1823273262],
                        [6.228e-08, 1.13312070908, 29864.334027309],
                        [6.186e-08, 4.92498052443, 19367.1891622328],
                        [6.155e-08, 2.424139469, 4705.7323075436],
                        [5.204e-08, 3.42528906628, 9103.9069941176],
                        [6e-08, 3.57639095526, 3154.6870848956],
                        [4.796e-08, 3.86676184909, 7860.4193924392],
                        [5.289e-08, 4.99182712443, 7084.8967811152],
                        [4.07e-08, 5.5879814474, 12566.1516999828],
                        [3.942e-08, 5.68758787835, 10206.1719992102],
                        [3.797e-08, 3.89520601076, 10192.5101507186],
                        [3.798e-08, 6.06410995916, 10234.0609417034],
                        [3.579e-08, 0.73789669235, 4551.9534970588],
                        [3.641e-08, 2.61501257205, 15874.6175953632],
                        [3.266e-08, 0.97517223854, 23581.2581773176],
                        [2.813e-08, 0.29951755546, 9411.4646150872],
                        [3.048e-08, 2.5108514699, 33794.5437235286],
                        [2.559e-08, 4.58043833032, 801.8209311238],
                        [2.462e-08, 5.05790874754, 29050.7837433492],
                        [2.593e-08, 5.73113176751, 20213.271996984],
                        [2.625e-08, 4.24272906574, 213.299095438],
                        [2.246e-08, 0.82112963936, 28286.9904848612],
                        [2.229e-08, 2.22457598233, 10426.584641649],
                        [1.742e-08, 1.48394229233, 7058.5984613154],
                        [1.66e-08, 5.42775825275, 32217.2001810808],
                        [1.491e-08, 4.64883377941, 1109.3785520934],
                        [2.01e-08, 0.75702888128, 9999.986450773],
                        [1.562e-08, 3.93962080463, 37724.7534197482],
                        [1.538e-08, 2.1730957708, 21535.9496445154],
                        [1.546e-08, 4.70759186462, 14945.3161735544],
                        [1.2e-08, 1.48282382657, 9830.3890139878],
                        [1.224e-08, 5.55090394449, 5661.3320491522],
                        [1.111e-08, 1.20276209213, 9573.388259897],
                        [1.064e-08, 1.98891375536, 26.2983197998],
                        [1.041e-08, 5.38535116069, 7.1135470008],
                        [1.036e-08, 1.16719443387, 8662.240323563],
                        [1.143e-08, 3.20596958337, 3532.0606928114],
                        [1.201e-08, 0.81913312536, 8094.5216858326],
                        [1.005e-08, 2.38429892132, 27511.4678735372],
                        [1.047e-08, 4.56525030769, 20419.4575454212],
                        [9.68e-09, 6.18496721871, 25158.6017197654],
                        [1.044e-08, 1.98055689074, 10596.1820784342],
                        [9.62e-09, 0.48573513747, 23958.6317852334],
                        [8.46e-09, 0.01566400887, 3128.3887650958],
                        [7.92e-09, 5.39686899735, 24356.7807886416],
                        [8.58e-09, 5.34692750735, 41654.9631159678],
                        [7.57e-09, 6.25904553773, 20452.8694122218],
                        [8.01e-09, 4.62406152514, 9929.4262273458],
                        [8.02e-09, 5.3723489252, 10497.1448650762],
                        [7.5e-09, 3.85219782842, 21228.3920235458],
                        [7e-09, 1.98097957188, 3930.2096962196],
                        [7.19e-09, 6.11596800207, 10218.8084705184],
                        [6.72e-09, 6.23429601219, 14765.2390432698],
                        [6.39e-09, 5.37566437358, 1589.0728952838],
                        [6.05e-09, 2.4233039112, 10251.3132188468],
                        [7.26e-09, 6.16683781802, 18875.525869774],
                        [6.13e-09, 5.9973118069, 4732.0306273434],
                        [7.2e-09, 3.84286345199, 10207.7626219036],
                        [6.37e-09, 6.17053891156, 10220.3990932118],
                        [5.15e-09, 1.03001478293, 22779.4372461938],
                        [5.74e-09, 0.43813688572, 17085.9586657222],
                        [5.1e-09, 1.41065159851, 9161.0171630226],
                        [5.69e-09, 3.34601425125, 3340.6124266998],
                        [6.08e-09, 1.25236241968, 10175.2578735752],
                        [5.24e-09, 2.3979424867, 26087.9031415742],
                        [5.42e-09, 1.34665646732, 29088.811415985],
                        [5.27e-09, 4.01994270827, 18849.2275499742],
                        [5.69e-09, 1.65498800378, 39264.0692895602],
                        [5.18e-09, 4.96996115446, 30213.258447757],
                        [5.14e-09, 5.78413007838, 12592.4500197826],
                        [5.38e-09, 4.56198493922, 10063.7223490764],
                        [4.84e-09, 4.18538027381, 14919.0178537546],
                        [4.93e-09, 4.79939382739, 9146.790069021],
                        [4.27e-09, 3.76876868949, 11272.6674764002],
                        [4.95e-09, 0.49175293655, 45585.1728121874],
                        [4.94e-09, 3.74345863918, 31441.6775697568],
                        [5.24e-09, 0.97991794166, 30110.1656735384],
                        [4.83e-09, 1.87898057316, 51066.427731055],
                        [5.05e-09, 3.70047474212, 20400.2727726222],
                        [3.51e-09, 4.3402657449, 10137.0194749354],
                        [3.55e-09, 5.56672554631, 18837.4981971382],
                        [3.28e-09, 3.7842737891, 6681.2248533996],
                        [3.49e-09, 4.20550749672, 20956.2620575166],
                        [3.33e-09, 4.44969281739, 28521.0927782546],
                        [2.96e-09, 2.83205515646, 17277.4069318338],
                        [3.11e-09, 2.57334132897, 20809.4676246452],
                        [2.94e-09, 0.75089224483, 3149.1641605882],
                        [3.77e-09, 3.98143308775, 21202.093703746],
                        [2.72e-09, 5.56183082489, 16496.3613962024],
                        [3.14e-09, 0.02584607093, 13745.3462390224],
                        [2.63e-09, 0.55328410985, 36147.4098773004],
                        [2.86e-09, 5.16408902215, 426.598190876],
                        [2.79e-09, 4.29871615943, 19999.972901546],
                        [2.8e-09, 1.92925047377, 49515.382508407],
                        [2.65e-09, 4.81168402147, 20235.1228263104],
                        [2.73e-09, 5.12740051559, 35371.8872659764],
                        [3.06e-09, 5.28903794869, 382.8965322232],
                        [2.23e-09, 2.50591724074, 26709.6469424134],
                        [2.35e-09, 5.96522395118, 10198.033075026],
                        [2.34e-09, 3.52866583267, 10228.538017396],
                        [2.24e-09, 6.24561979789, 7064.1213856228],
                        [2.51e-09, 2.84739274245, 33019.0211122046],
                        [1.96e-09, 1.5061039379, 31749.2351907264],
                        [1.92e-09, 1.69321442572, 13341.6743113068],
                        [1.8e-09, 6.19353087076, 39793.7602546548],
                        [1.99e-09, 1.1643332188, 22805.7355659936],
                        [1.8e-09, 3.72646417141, 1551.045222648],
                        [1.73e-09, 3.35235705827, 53445.5922046266],
                        [1.95e-09, 1.51901264131, 43232.3066584156],
                        [1.74e-09, 2.84049662693, 9967.4538999816],
                        [1.63e-09, 4.29160537719, 36949.2308084242],
                        [1.69e-09, 0.37000676558, 10459.1171924404],
                        [1.37e-09, 5.61149803116, 10529.6774158676],
                        [1.39e-09, 0.87847805052, 16522.6597160022],
                        [1.39e-09, 4.12576475427, 36301.1886877852],
                        [1.27e-09, 5.14447758616, 5481.2549188676],
                        [1.31e-09, 3.11317801589, 9896.8936765544],
                        [1.31e-09, 0.89697384735, 3442.5749449654],
                        [1.21e-09, 1.32802112907, 38734.3783244656],
                        [1.22e-09, 1.59017183044, 10110.1927719924],
                        [1.23e-09, 2.33714216061, 10316.3783204296],
                        [1.33e-09, 2.90682399304, 9793.8009023358],
                        [1.11e-09, 2.5207763476, 13936.794505134],
                        [1.2e-09, 0.36076947165, 536.8045120954],
                        [1.15e-09, 2.53355582059, 26735.9452622132],
                        [1.08e-09, 2.65839634325, 10232.9553071108],
                        [1.08e-09, 0.55230439694, 10193.6157853112],
                        [1.38e-09, 1.0691923924, 65236.2212932854],
                        [1.01e-09, 3.17012502017, 19317.1925403286],
                        [1.27e-09, 5.63110477712, 10288.0671447783],
                        [1.27e-09, 3.86278127025, 10138.5039476437],
                        [1.37e-09, 2.9335065946, 47162.5163546352],
                        [9.5e-10, 5.03917884334, 52175.8062831484],
                        [9.4e-10, 0.71308489207, 38500.2760310722],
                        [9.2e-10, 5.46204624886, 11764.330768859],
                        [9.6e-10, 1.52914774412, 9690.7081281172],
                        [1.01e-09, 0.83318284426, 6489.776587288],
                        [1.15e-09, 3.76443612245, 522.5774180938],
                        [8.9e-10, 2.53312656681, 10735.8629643048],
                        [8.2e-10, 0.85628515615, 2379.1644735716],
                        [1.03e-09, 5.2268323762, 103.0927742186],
                        [9e-10, 2.12423586627, 28313.288804661],
                        [9e-10, 0.39668501735, 9580.5018068978],
                        [7.4e-10, 6.0268009555, 3723.508958923],
                        [8.1e-10, 5.25045057985, 10419.4710946482],
                        [8e-10, 4.23724598221, 10007.0999977738],
                        [9.1e-10, 2.48874147947, 10846.0692855242],
                        [8.5e-10, 3.82784790321, 51868.2486621788],
                        [8.1e-10, 2.26235214191, 3903.9113764198],
                        [9.7e-10, 0.772950916, 18307.8072320436],
                        [9.4e-10, 0.17063414792, 6872.6731195112],
                        [8e-10, 5.62254102739, 29999.959352319],
                        [6.8e-10, 2.7176293667, 16983.9961474566],
                        [6.6e-10, 0.76731351736, 20.7753954924],
                        [7.5e-10, 0.36155638007, 39302.096962196],
                        [7.5e-10, 2.27327165974, 8521.1198767086],
                        [5.8e-10, 2.14482855875, 8631.326197928],
                        [6.4e-10, 5.83569051301, 2118.7638603784],
                        [5.8e-10, 2.98524209824, 19889.7665803266],
                        [5.4e-10, 1.78260668333, 40077.61957352],
                        [5.5e-10, 4.70485939861, 639.897286314],
                        [6e-10, 5.8966189292, 41962.5207369374],
                        [6.6e-10, 2.24746237999, 74.7815985673],
                        [6.1e-10, 3.40726181591, 27490.6924780448],
                        [5.1e-10, 3.07811180039, 24150.080051345],
                        [5.7e-10, 2.30081371235, 20529.6638666406],
                        [5.2e-10, 2.37192464233, 29573.361161443],
                        [5.2e-10, 4.76610409132, 57375.8019008462],
                        [4.7e-10, 1.61630288856, 30831.3049047446],
                        [5.4e-10, 5.89684197257, 19903.9936743282],
                        [4e-10, 5.32101847424, 42430.4857272918],
                        [5.1e-10, 5.29186795569, 29587.5882554446],
                      ],
          },
          {
            series => "B1",
            terms  => [
                        [0.00513347602, 1.80364310797, 10213.285546211],
                        [4.3801e-05, 3.38615711591, 20426.571092422],
                        [1.96586e-06, 2.53001197486, 30639.856638633],
                        [1.99162e-06, 0, 0],
                        [1.4031e-07, 2.27087044687, 9437.762934887],
                        [1.2958e-07, 1.50735622957, 18073.7049386502],
                        [1.1941e-07, 5.60462450426, 1577.3435424478],
                        [1.0324e-07, 5.24224313355, 2352.8661537718],
                        [9.294e-08, 6.07545631303, 22003.9146348698],
                        [7.441e-08, 1.50257909439, 11790.6290886588],
                        [8.031e-08, 0.29371105198, 9153.9036160218],
                        [7.514e-08, 5.0808188599, 10186.9872264112],
                        [4.669e-08, 3.87801635015, 10239.5838660108],
                        [4.399e-08, 3.58872736593, 40853.142184844],
                        [3.975e-08, 1.28397121206, 10404.7338123226],
                        [4.657e-08, 0.75073886819, 5507.5532386674],
                        [3.783e-08, 4.33004753984, 19651.048481098],
                        [3.39e-08, 4.88976070903, 10988.808157535],
                        [3.555e-08, 1.25927550356, 19896.8801273274],
                        [3.479e-08, 5.5079700216, 529.6909650946],
                        [2.884e-08, 0.08549582037, 14143.4952424306],
                        [1.786e-08, 0.37134513186, 13367.9726311066],
                        [1.6e-08, 1.68378002982, 20618.0193585336],
                        [1.539e-08, 1.21683853657, 25934.1243310894],
                        [1.341e-08, 2.90077139758, 15720.8387848784],
                        [9.93e-09, 1.74681248965, 11322.6640983044],
                        [1.165e-08, 6.13437155401, 7860.4193924392],
                        [1.115e-08, 0.6674369038, 29580.4747084438],
                        [9.23e-09, 2.25384969096, 10021.8372800994],
                        [9.65e-09, 1.36425494833, 9683.5945811164],
                        [9.73e-09, 0.39071758442, 6283.0758499914],
                        [8.05e-09, 0.53331923557, 8624.2126509272],
                        [9.13e-09, 0.76046003719, 8635.9420037632],
                        [9.91e-09, 0.5531987933, 19367.1891622328],
                        [6.09e-09, 2.62364470139, 23581.2581773176],
                        [5.32e-09, 5.10925676528, 9786.687355335],
                        [4.76e-09, 6.17672999981, 11015.1064773348],
                        [4.72e-09, 1.696726292, 17298.1823273262],
                        [5.03e-09, 2.65840772485, 29864.334027309],
                        [4.56e-09, 5.01205315518, 10742.9765113056],
                        [4.78e-09, 3.94100005156, 775.522611324],
                        [4.77e-09, 3.71554345922, 10596.1820784342],
                        [3.47e-09, 2.3455106268, 9411.4646150872],
                        [4.58e-09, 2.31894399069, 9999.986450773],
                        [3.74e-09, 3.76878356974, 21228.3920235458],
                        [4.4e-09, 4.33400244581, 15874.6175953632],
                        [3.49e-09, 1.31468836511, 10234.0609417034],
                        [3.1e-09, 5.45422332781, 10192.5101507186],
                        [3.46e-09, 0.94242286364, 1059.3819301892],
                        [3.08e-09, 4.90145899142, 3930.2096962196],
                        [3.31e-09, 4.89498986674, 10206.1719992102],
                        [2.69e-09, 2.39650266204, 801.8209311238],
                        [2.69e-09, 0.00589873499, 9830.3890139878],
                        [2.61e-09, 3.48196147279, 7058.5984613154],
                        [2.9e-09, 0.10953964861, 29050.7837433492],
                        [2.83e-09, 6.12133736787, 20419.4575454212],
                        [2.32e-09, 3.0784585003, 12566.1516999828],
                        [2.65e-09, 4.02431894973, 33794.5437235286],
                        [2.2e-09, 2.37315851889, 4551.9534970588],
                        [2.47e-09, 3.07626728158, 28286.9904848612],
                        [2.02e-09, 3.56872121409, 21535.9496445154],
                        [2.25e-09, 5.7688889632, 213.299095438],
                        [2.17e-09, 0.88382111135, 20213.271996984],
                        [1.72e-09, 6.12653050186, 9161.0171630226],
                        [1.95e-09, 5.472408554, 37724.7534197482],
                        [1.53e-09, 4.07656151671, 27511.4678735372],
                        [1.74e-09, 1.33676849359, 32217.2001810808],
                        [1.57e-09, 5.98474214437, 26.2983197998],
                        [1.63e-09, 5.4551913476, 10426.584641649],
                        [1.29e-09, 2.08748660996, 3128.3887650958],
                        [1.31e-09, 1.51959002513, 10218.8084705184],
                        [1.39e-09, 4.42330401713, 10220.3990932118],
                        [1.26e-09, 2.62296638037, 22779.4372461938],
                        [1.46e-09, 4.69869606856, 25158.6017197654],
                        [1.72e-09, 6.13435208788, 18837.4981971382],
                        [1.57e-09, 5.44507403858, 4705.7323075436],
                        [1.17e-09, 6.18296175153, 20400.2727726222],
                        [1.64e-09, 3.30849473132, 51066.427731055],
                        [1.13e-09, 3.64412860654, 7.1135470008],
                        [1.09e-09, 5.21220660788, 8662.240323563],
                        [1.33e-09, 1.78047296245, 191.4482661116],
                        [1.17e-09, 0.14681677884, 9146.790069021],
                        [1.16e-09, 0.61940521198, 41654.9631159678],
                        [9.6e-10, 1.49631428731, 7084.8967811152],
                        [9.6e-10, 1.21744230443, 10198.033075026],
                        [8.2e-10, 1.45863866349, 10207.7626219036],
                        [8.5e-10, 6.04057728058, 21202.093703746],
                        [8.3e-10, 0.19985600927, 14919.0178537546],
                        [7.7e-10, 5.5013231061, 5661.3320491522],
                        [7.7e-10, 2.00173927326, 10228.538017396],
                        [9.3e-10, 1.85466268819, 45585.1728121874],
                        [6.6e-10, 3.25826124156, 1109.3785520934],
                        [8.9e-10, 0.64100435648, 3154.6870848956],
                        [6.1e-10, 3.80043027736, 11272.6674764002],
                        [7.7e-10, 1.8551635895, 3532.0606928114],
                        [6.2e-10, 0.81341290651, 382.8965322232],
                        [7.2e-10, 2.35312965005, 9103.9069941176],
                        [5.3e-10, 3.21969389511, 20452.8694122218],
                        [6.7e-10, 1.42090542131, 24356.7807886416],
                        [5.6e-10, 2.97733070198, 30110.1656735384],
                        [5.1e-10, 4.22406663447, 20809.4676246452],
                        [5.8e-10, 6.20761936031, 29088.811415985],
                        [6.1e-10, 3.27309494322, 49515.382508407],
                        [4.6e-10, 5.49443476235, 31441.6775697568],
                        [5e-10, 4.16651052942, 13341.6743113068],
                        [4.7e-10, 1.25473247769, 33019.0211122046],
                        [4.7e-10, 2.03402044389, 23958.6317852334],
                        [3.6e-10, 5.24409311105, 3149.1641605882],
                        [3.8e-10, 4.15337829669, 18849.2275499742],
                        [4.2e-10, 0.43005959574, 1589.0728952838],
                        [4.1e-10, 1.21289342964, 12592.4500197826],
                        [3.8e-10, 5.91928287144, 28521.0927782546],
                        [3.3e-10, 3.98241699279, 4732.0306273434],
                        [3.5e-10, 2.24417218267, 16496.3613962024],
                        [4e-10, 6.13293942728, 26087.9031415742],
                        [4.4e-10, 1.7812329486, 426.598190876],
                        [4.1e-10, 3.16744909855, 39264.0692895602],
                        [3.3e-10, 4.96183427323, 536.8045120954],
                        [3.4e-10, 0.12963030501, 30213.258447757],
                        [3.6e-10, 5.41167321573, 522.5774180938],
                        [2.7e-10, 4.44250239485, 17277.4069318338],
                        [3.4e-10, 5.94541303751, 9929.4262273458],
                        [3.3e-10, 0.40689057274, 10497.1448650762],
                        [2.3e-10, 2.59067946967, 10175.2578735752],
                        [2.2e-10, 0.69625017371, 19999.972901546],
                        [2.3e-10, 3.76162101633, 10251.3132188468],
                        [2.3e-10, 0.62711494266, 35371.8872659764],
                        [2.2e-10, 4.64142978776, 19889.7665803266],
                        [2e-10, 4.01315480107, 26709.6469424134],
                        [2e-10, 4.0334440068, 29573.361161443],
                        [2.3e-10, 0.90416640595, 8094.5216858326],
                        [2.2e-10, 1.92092469688, 17085.9586657222],
                        [1.9e-10, 5.04938942644, 6681.2248533996],
                      ],
          },
          {
            series => "B2",
            terms  => [
                        [0.00022377665, 3.38509143877, 10213.285546211],
                        [2.81739e-06, 0, 0],
                        [1.73164e-06, 5.25563766915, 20426.571092422],
                        [2.6945e-07, 3.87040891568, 30639.856638633],
                        [1.174e-08, 0.09768632072, 10186.9872264112],
                        [6.85e-09, 3.19139067811, 11790.6290886588],
                        [7.88e-09, 4.36515965295, 10239.5838660108],
                        [5.92e-09, 5.22270440328, 40853.142184844],
                        [5.15e-09, 6.12821215207, 10988.808157535],
                        [5.38e-09, 0.57550272342, 2352.8661537718],
                        [5.4e-09, 3.11657836329, 18073.7049386502],
                        [4.54e-09, 2.79306867629, 10404.7338123226],
                        [3.74e-09, 6.10468482446, 9437.762934887],
                        [4.31e-09, 4.00778431184, 1577.3435424478],
                        [3.6e-09, 6.0174784232, 19651.048481098],
                        [3.75e-09, 1.31319959789, 22003.9146348698],
                        [3.54e-09, 5.12509281266, 9153.9036160218],
                        [1.5e-09, 4.58623687118, 15720.8387848784],
                        [1.64e-09, 5.41790158607, 5507.5532386674],
                        [1.59e-09, 2.78191550878, 19896.8801273274],
                        [1.57e-09, 0.65774905071, 529.6909650946],
                        [1.55e-09, 2.54824315372, 9683.5945811164],
                        [1.09e-09, 2.01866665583, 14143.4952424306],
                        [1.06e-09, 2.28289033017, 6283.0758499914],
                        [1.15e-09, 3.23636374193, 20618.0193585336],
                        [1.28e-09, 5.32400510939, 13367.9726311066],
                        [8.7e-10, 3.28265082435, 11322.6640983044],
                        [9e-10, 5.23585072275, 10596.1820784342],
                        [5.5e-10, 4.82369879741, 7058.5984613154],
                        [4.4e-10, 0.58444963462, 10206.1719992102],
                        [4.4e-10, 2.34401612969, 19367.1891622328],
                        [3.8e-10, 4.55053233088, 9999.986450773],
                        [3.9e-10, 5.84340580032, 10220.3990932118],
                        [3.6e-10, 4.41006216127, 51066.427731055],
                        [3.9e-10, 3.14348236386, 9411.4646150872],
                        [3.3e-10, 4.5574866034, 10742.9765113056],
                        [3.7e-10, 2.79630938717, 25934.1243310894],
                        [3.4e-10, 0.55287110072, 11015.1064773348],
                        [3.4e-10, 2.25809144959, 29580.4747084438],
                        [3.8e-10, 1.88638747393, 801.8209311238],
                        [3.4e-10, 1.22706917271, 10021.8372800994],
                        [2.7e-10, 4.83867137637, 9830.3890139878],
                        [2.7e-10, 4.3114017935, 23581.2581773176],
                        [2.7e-10, 2.17187621336, 8635.9420037632],
                        [2e-10, 5.66581696952, 21228.3920235458],
                        [2.4e-10, 2.1720810785, 18849.2275499742],
                        [2e-10, 5.29318634138, 775.522611324],
                        [1.9e-10, 2.73486845601, 3128.3887650958],
                        [1.3e-10, 3.40362915274, 1059.3819301892],
                        [1.4e-10, 0.05074160195, 7860.4193924392],
                        [1.4e-10, 5.43035907265, 26.2983197998],
                        [1.2e-10, 3.24834347355, 9103.9069941176],
                        [1.3e-10, 5.04826725887, 7.1135470008],
                        [1.5e-10, 1.42027402522, 29050.7837433492],
                        [1e-10, 4.9813806749, 10426.584641649],
                        [1.1e-10, 0.85773045784, 17298.1823273262],
                        [1.1e-10, 4.23048200054, 29864.334027309],
                        [1e-10, 0.26447399758, 3930.2096962196],
                        [1.1e-10, 1.46728576671, 20419.4575454212],
                      ],
          },
          {
            series => "B3",
            terms  => [
                        [6.46671e-06, 4.99166565277, 10213.285546211],
                        [1.9952e-07, 3.14159265359, 0],
                        [5.54e-08, 0.77376923951, 20426.571092422],
                        [2.526e-08, 5.4449376302, 30639.856638633],
                        [7.9e-10, 1.51447613604, 10186.9872264112],
                        [5.6e-10, 0.63647808442, 40853.142184844],
                        [5.8e-10, 5.7073117655, 10239.5838660108],
                        [3.1e-10, 4.72523061067, 11790.6290886588],
                        [2.6e-10, 1.02068113372, 10988.808157535],
                        [2.5e-10, 5.60599130442, 9437.762934887],
                        [1.7e-10, 2.05293621864, 2352.8661537718],
                        [1.1e-10, 4.33056892256, 10404.7338123226],
                        [9e-11, 1.36283915068, 19651.048481098],
                        [7e-11, 4.69592781899, 18073.7049386502],
                        [6e-11, 2.97926526705, 22003.9146348698],
                      ],
          },
          {
            series => "B4",
            terms  => [
                        [1.4102e-07, 0.31537190181, 10213.285546211],
                        [1.9e-09, 2.35466404492, 20426.571092422],
                        [1.64e-09, 0.74476215141, 30639.856638633],
                        [2.14e-09, 3.14159265359, 0],
                        [4e-11, 2.34190883009, 40853.142184844],
                      ],
          },
          {
            series => "B5",
            terms  => [
                        [2.39e-09, 2.05201727566, 10213.285546211],
                        [3.9e-10, 0, 0],
                        [1.1e-10, 3.82500275251, 20426.571092422],
                        [9e-11, 2.32953116868, 30639.856638633],
                      ],
          },
        ],
        [
          {
            series => "R0",
            terms  => [
                        [0.72334820905, 0, 0],
                        [0.00489824185, 4.02151832268, 10213.285546211],
                        [1.658058e-05, 4.90206728012, 20426.571092422],
                        [1.632093e-05, 2.84548851892, 7860.4193924392],
                        [1.378048e-05, 1.128465906, 11790.6290886588],
                        [4.98399e-06, 2.58682187717, 9683.5945811164],
                        [3.73958e-06, 1.42314837063, 3930.2096962196],
                        [2.63616e-06, 5.5293818592, 9437.762934887],
                        [2.37455e-06, 2.55135903978, 15720.8387848784],
                        [2.21983e-06, 2.01346776772, 19367.1891622328],
                        [1.19467e-06, 3.01975365264, 10404.7338123226],
                        [1.25896e-06, 2.72769833559, 1577.3435424478],
                        [7.6178e-07, 1.59577224486, 9153.9036160218],
                        [8.5336e-07, 3.98607953754, 19651.048481098],
                        [7.4347e-07, 4.11957854039, 5507.5532386674],
                        [4.1904e-07, 1.64273363458, 18837.4981971382],
                        [4.2493e-07, 3.81864530735, 13367.9726311066],
                        [3.943e-07, 5.39019422358, 23581.2581773176],
                        [2.9042e-07, 5.67739528728, 5661.3320491522],
                        [2.7555e-07, 5.72392407794, 775.522611324],
                        [2.7283e-07, 4.82151812709, 11015.1064773348],
                        [3.1274e-07, 2.31806719544, 9999.986450773],
                        [1.97e-07, 4.96157560245, 11322.6640983044],
                        [1.9809e-07, 0.53189326492, 27511.4678735372],
                        [1.3567e-07, 3.75530870628, 18073.7049386502],
                        [1.2921e-07, 1.13381083556, 10206.1719992102],
                        [1.6215e-07, 0.5645383429, 529.6909650946],
                        [1.1821e-07, 5.09025877427, 3154.6870848956],
                        [1.1728e-07, 0.23432298744, 7084.8967811152],
                        [1.3079e-07, 5.24353197586, 17298.1823273262],
                        [1.318e-07, 3.37207825651, 13745.3462390224],
                        [9.097e-08, 3.07004895769, 1109.3785520934],
                        [1.0818e-07, 2.45024712908, 10239.5838660108],
                        [1.1438e-07, 4.56838894696, 29050.7837433492],
                        [8.377e-08, 5.78327612352, 30639.856638633],
                        [8.193e-08, 1.9502311186, 22003.9146348698],
                        [9.308e-08, 1.61615909286, 2352.8661537718],
                        [1.0652e-07, 1.9552839614, 31441.6775697568],
                        [1.0357e-07, 1.20234990061, 15874.6175953632],
                        [9.585e-08, 1.46639856228, 19999.972901546],
                        [6.506e-08, 2.17390732263, 14143.4952424306],
                        [7.562e-08, 1.13789564977, 8624.2126509272],
                        [6.434e-08, 0.84419623033, 6283.0758499914],
                        [5.898e-08, 0.0109373111, 8635.9420037632],
                        [5.632e-08, 3.94956548631, 12566.1516999828],
                        [5.523e-08, 1.27394296557, 18307.8072320436],
                        [4.488e-08, 2.47835729057, 191.4482661116],
                        [4.529e-08, 4.730277704, 19896.8801273274],
                        [6.193e-08, 3.25881250939, 6872.6731195112],
                        [6.07e-08, 0.35337419942, 21228.3920235458],
                        [4.315e-08, 2.59737099519, 4551.9534970588],
                        [6.005e-08, 3.37874723475, 35371.8872659764],
                        [3.852e-08, 1.01162850357, 9786.687355335],
                        [4.033e-08, 0.0005085558, 801.8209311238],
                        [3.92e-08, 5.56542869407, 10596.1820784342],
                        [2.709e-08, 5.80195530112, 7064.1213856228],
                        [3.216e-08, 0.39767254848, 10186.9872264112],
                        [3.089e-08, 6.26174762876, 14945.3161735544],
                        [2.982e-08, 4.21196716354, 28521.0927782546],
                        [3.284e-08, 0.70709821006, 10742.9765113056],
                        [3.484e-08, 4.79878191875, 39302.096962196],
                        [3.172e-08, 1.80518954174, 25158.6017197654],
                        [2.463e-08, 0.68708153678, 10988.808157535],
                        [2.374e-08, 3.77948685343, 21535.9496445154],
                        [2.198e-08, 2.82996372521, 8662.240323563],
                        [1.958e-08, 5.41763804167, 16496.3613962024],
                        [1.876e-08, 2.63426768393, 29580.4747084438],
                        [1.902e-08, 2.85782199133, 3532.0606928114],
                        [1.706e-08, 3.67573010379, 26.2983197998],
                        [1.817e-08, 0.41611036449, 4705.7323075436],
                        [1.858e-08, 1.50368318296, 10021.8372800994],
                        [2.087e-08, 6.22112874639, 43232.3066584156],
                        [1.95e-08, 2.21447019683, 19786.673806108],
                        [1.497e-08, 0.00134773824, 17277.4069318338],
                        [1.819e-08, 3.23144993268, 29088.811415985],
                        [1.423e-08, 5.85979618707, 9676.4810341156],
                        [1.223e-08, 5.55818994329, 6770.7106012456],
                        [1.14e-08, 5.92088900094, 13936.794505134],
                        [1.484e-08, 2.47665429253, 31749.2351907264],
                        [1.185e-08, 1.42087628351, 4732.0306273434],
                        [1.323e-08, 2.48821075422, 9690.7081281172],
                        [1.249e-08, 1.88323673734, 19374.3027092336],
                        [1.27e-08, 5.24647873116, 19360.075615232],
                        [1.402e-08, 5.17536780118, 10316.3783204296],
                        [1.042e-08, 3.05454698508, 25934.1243310894],
                        [1.174e-08, 1.42913732999, 18875.525869774],
                        [1.278e-08, 1.35747287297, 47162.5163546352],
                        [9.17e-09, 6.26337648765, 20618.0193585336],
                        [9.05e-09, 1.12740203561, 12592.4500197826],
                        [1.093e-08, 4.64451720605, 33019.0211122046],
                        [1.014e-08, 1.09259406433, 1059.3819301892],
                        [7.83e-09, 2.02118183873, 24356.7807886416],
                        [7.79e-09, 0.4158527401, 3340.6124266998],
                        [7e-09, 1.14936815714, 16983.9961474566],
                        [8.78e-09, 0.87852464964, 38734.3783244656],
                        [6.23e-09, 0.89976912165, 17778.116266949],
                        [6.08e-09, 1.58476225197, 9573.388259897],
                        [8e-09, 3.94213003073, 10138.5039476437],
                        [7.6e-09, 1.31851313748, 9967.4538999816],
                        [8.02e-09, 2.78173370208, 51092.7260508548],
                        [6.64e-09, 4.458646824, 3128.3887650958],
                        [6.74e-09, 5.11214939998, 382.8965322232],
                        [5.3e-09, 0.85392938403, 10234.0609417034],
                        [5.09e-09, 3.56809374595, 28286.9904848612],
                        [6e-09, 4.25927726907, 41962.5207369374],
                        [6.01e-09, 5.78144137895, 213.299095438],
                        [5.95e-09, 2.83045104588, 22805.7355659936],
                        [6.73e-09, 6.06079908421, 36949.2308084242],
                        [5.35e-09, 5.85422519711, 9103.9069941176],
                        [5.44e-09, 5.448060748, 3723.508958923],
                        [4.92e-09, 3.83802404893, 27991.40181316],
                        [6.35e-09, 0.76494024849, 8094.5216858326],
                        [4.34e-09, 6.22214487735, 27197.2816936676],
                        [4.59e-09, 3.55062885479, 20213.271996984],
                        [3.98e-09, 6.16269975784, 10426.584641649],
                        [3.78e-09, 2.41665947591, 18844.611744139],
                        [4.21e-09, 4.86552697954, 9146.790069021],
                        [5e-09, 4.20351458644, 55022.9357470744],
                        [4.04e-09, 4.95834410782, 37410.5672398786],
                        [4.02e-09, 2.97963246945, 10220.3990932118],
                        [4.64e-09, 2.59869499733, 18734.4054229196],
                        [3.52e-09, 0.08963076359, 10103.0792249916],
                        [3.48e-09, 4.90260339364, 18830.3846501374],
                        [3.38e-09, 3.22520096478, 24150.080051345],
                        [3.75e-09, 6.17532088136, 26087.9031415742],
                        [4.25e-09, 1.2005257828, 40879.4405046438],
                        [4.08e-09, 3.12833060705, 9050.8108418032],
                        [3.85e-09, 1.94284690176, 283.8593188652],
                        [3.37e-09, 4.87838699272, 12432.0426503978],
                        [3.26e-09, 4.27369741426, 26735.9452622132],
                        [3.09e-09, 0.50597475053, 38204.687359371],
                        [3.29e-09, 3.88430599153, 29864.334027309],
                        [3.13e-09, 1.36138752543, 10192.5101507186],
                        [3.47e-09, 3.58439807209, 27490.6924780448],
                        [2.51e-09, 3.78618457047, 10063.7223490764],
                        [2.44e-09, 3.83523342668, 9411.4646150872],
                        [2.81e-09, 4.50895206233, 32217.2001810808],
                        [2.37e-09, 0.87748812245, 6681.2248533996],
                        [3.15e-09, 5.62657778233, 58953.145443294],
                        [3.11e-09, 4.15626121491, 10175.1525105732],
                        [2.47e-09, 2.53637594113, 16522.6597160022],
                        [2.19e-09, 5.08729383251, 7058.5984613154],
                        [2.91e-09, 3.72567217056, 29999.959352319],
                        [2.67e-09, 2.97685503991, 19573.37471067],
                        [2.8e-09, 3.70200084294, 47623.8527860896],
                        [2.39e-09, 3.94545782067, 9580.5018068978],
                        [2.46e-09, 2.1824488393, 9161.0171630226],
                        [2.53e-09, 2.69506547016, 3442.5749449654],
                        [2.65e-09, 2.62811801237, 44809.6502008634],
                        [1.94e-09, 4.78926136175, 33794.5437235286],
                        [1.87e-09, 3.65620881095, 20452.8694122218],
                        [2.24e-09, 2.43601863127, 9992.8729037722],
                        [1.93e-09, 2.55112161845, 2379.1644735716],
                        [2.01e-09, 1.90356905733, 1551.045222648],
                        [1.76e-09, 4.29837616553, 10137.0194749354],
                        [1.84e-09, 6.16061560223, 36147.4098773004],
                        [1.75e-09, 2.7198479704, 20809.4676246452],
                        [1.86e-09, 2.55098927966, 14919.0178537546],
                        [1.61e-09, 4.13272567123, 23958.6317852334],
                        [2.21e-09, 4.83552377614, 20277.0078952874],
                        [1.6e-09, 1.81472642729, 10787.6303445458],
                        [1.99e-09, 5.7425979833, 30666.1549584328],
                        [1.6e-09, 4.46270605493, 18947.7045183576],
                        [1.87e-09, 2.98688597588, 2218.7571041868],
                        [1.89e-09, 5.34607810282, 10007.0999977738],
                        [1.98e-09, 0.77846666692, 62883.3551395136],
                        [1.44e-09, 5.00261963924, 9264.1099372412],
                        [1.71e-09, 2.05212624568, 7255.5696517344],
                        [1.88e-09, 4.08173534559, 48739.859897083],
                        [1.46e-09, 3.94191715702, 6309.3741697912],
                        [1.46e-09, 5.06313558118, 39264.0692895602],
                        [1.35e-09, 5.93689169614, 37724.7534197482],
                        [1.39e-09, 2.81266025896, 20.7753954924],
                        [1.77e-09, 5.16224804657, 9835.9119382952],
                        [1.19e-09, 1.37254262864, 40077.61957352],
                        [1.2e-09, 0.21443767468, 31022.7531708562],
                        [1.28e-09, 2.92458887798, 7.1135470008],
                        [1.5e-09, 5.73646272556, 632.7837393132],
                        [1.06e-09, 0.62224833817, 11272.6674764002],
                        [1.14e-09, 2.6330132652, 17468.8551979454],
                        [1.23e-09, 6.22518843711, 53285.1848352418],
                        [1.07e-09, 1.172589789, 43071.8992890308],
                        [1.03e-09, 1.09613781581, 41654.9631159678],
                        [1.09e-09, 2.01412667085, 20419.4575454212],
                        [1.02e-09, 4.23406964348, 10251.3132188468],
                        [1.16e-09, 1.27731728606, 10199.0584522094],
                        [1.03e-09, 5.25887538465, 9830.3890139878],
                        [1.12e-09, 2.24436894064, 18204.714457825],
                        [1.11e-09, 2.23547857955, 8521.1198767086],
                        [1.18e-09, 0.237542072, 10497.1448650762],
                        [1.23e-09, 0.88054816668, 34596.3646546524],
                        [1.02e-09, 4.3943864662, 18300.6936850428],
                        [1.31e-09, 6.01711652115, 9367.2027114598],
                        [1e-09, 5.00532389609, 10175.2578735752],
                        [1.07e-09, 0.41270197502, 40853.142184844],
                        [1.32e-09, 5.45008342761, 11506.7697697936],
                        [9.8e-10, 1.07722950958, 13553.8979729108],
                        [9.4e-10, 2.9172009759, 44007.8292697396],
                        [9.7e-10, 1.04004223634, 68050.4238785116],
                        [1.27e-09, 2.20215372683, 66813.5648357332],
                        [1.11e-09, 1.57823839032, 29043.6701963484],
                        [1.18e-09, 2.3326817689, 18314.9207790444],
                        [9e-10, 2.42353056125, 32858.6137428198],
                        [1.09e-09, 3.82796787296, 19470.2819364514],
                        [1.11e-09, 4.47666957576, 29057.89729035],
                        [1.01e-09, 3.4152849366, 19264.0963880142],
                        [9.2e-10, 3.66289799512, 22645.3281966088],
                        [9.4e-10, 6.07530805791, 10846.0692855242],
                        [1.14e-09, 4.02718653431, 7576.560073574],
                        [8.7e-10, 6.01842459303, 17085.9586657222],
                        [1.09e-09, 5.46886607309, 52670.0695933026],
                        [1.07e-09, 0.54805946713, 34363.365597556],
                        [1.08e-09, 5.44460610707, 19050.7972925762],
                        [7.6e-10, 6.15177368654, 27682.1407441564],
                        [1.07e-09, 4.80525404063, 8144.2787113044],
                        [7.3e-10, 1.60549217847, 20956.2620575166],
                        [9.7e-10, 5.1354205113, 22779.4372461938],
                        [6.8e-10, 2.31300447144, 8631.326197928],
                        [9.1e-10, 4.28652743953, 10110.1927719924],
                        [9.3e-10, 5.27290609264, 522.5774180938],
                        [7.1e-10, 3.6556596169, 11764.330768859],
                        [8.9e-10, 1.79712963206, 45585.1728121874],
                        [6.7e-10, 2.25900071584, 9360.089164459],
                        [8.5e-10, 0.67062144972, 56600.2792895222],
                        [8e-10, 1.58278081077, 19992.8593545452],
                        [6.5e-10, 6.23472325597, 10419.4710946482],
                        [6.4e-10, 0.53356325917, 17248.4253018544],
                        [8.5e-10, 4.52011215904, 29786.660256881],
                        [6.8e-10, 4.48235266554, 10632.7701900862],
                        [6.4e-10, 4.33495700921, 47938.0389659592],
                        [7.1e-10, 3.03858484137, 11787.1059703098],
                        [8.7e-10, 4.81823063172, 2107.0345075424],
                        [7e-10, 2.35648061034, 11794.1522070078],
                        [8e-10, 2.33248094128, 38526.574350872],
                        [7e-10, 3.704540611, 8734.4189721466],
                        [7.7e-10, 4.49569185467, 20007.0864485468],
                        [7.2e-10, 1.19410424468, 10217.2176994741],
                        [6.8e-10, 2.01841060183, 14128.2427712456],
                        [6.4e-10, 5.39293951654, 7880.08915333899],
                        [6.6e-10, 3.20467071127, 14765.2390432698],
                        [8e-10, 3.4162045777, 48417.972905582],
                        [8e-10, 3.39651161571, 245.8316462294],
                        [6.6e-10, 5.85414440204, 9793.8009023358],
                        [8.2e-10, 3.62592908644, 70743.7745319528],
                        [5.8e-10, 4.95174942212, 30110.1656735384],
                        [7.9e-10, 6.24161471033, 6037.244203762],
                        [6.9e-10, 5.50183658445, 19793.7873531088],
                        [5.6e-10, 1.24148350566, 10207.7626219036],
                        [7e-10, 2.45123308846, 10218.8084705184],
                        [6.4e-10, 5.53983104501, 10735.8629643048],
                        [5.4e-10, 3.6225971324, 27461.7108480654],
                        [7.3e-10, 1.75882480924, 1589.0728952838],
                        [7.5e-10, 3.38244819846, 4214.0690150848],
                        [5.4e-10, 0.64971567468, 9929.4262273458],
                        [5.4e-10, 3.4095963723, 18418.013553263],
                        [5.6e-10, 3.65815006538, 14169.7935622304],
                        [5.6e-10, 0.71243223808, 9896.8936765544],
                        [5.2e-10, 1.3334813194, 20400.2727726222],
                        [6.7e-10, 3.128065954, 5481.2549188676],
                        [5.8e-10, 0.54482893546, 28313.288804661],
                        [5.4e-10, 0.15603935681, 19580.4882576708],
                        [5.1e-10, 3.3751547351, 9256.9963902404],
                        [6.3e-10, 3.3884897095, 49515.382508407],
                        [6.9e-10, 4.90917651401, 63498.4703814528],
                        [5.7e-10, 5.0743774203, 18521.1063274816],
                        [5e-10, 1.59156823654, 18631.312648701],
                        [5.4e-10, 6.25816208666, 37674.9963942764],
                        [5.7e-10, 5.48065460919, 24383.0791084414],
                        [4.5e-10, 1.1046649066, 10408.2569306716],
                        [5.1e-10, 3.61196470313, 426.598190876],
                        [5.7e-10, 2.09567711267, 60530.4889857418],
                        [6e-10, 5.94659889997, 13897.6635962012],
                        [5.1e-10, 5.4723851772, 57837.1383323006],
                        [5.1e-10, 2.32438478428, 19779.5602591072],
                        [5.2e-10, 3.23766328818, 18940.5909713568],
                        [4.3e-10, 5.74921510909, 51868.2486621788],
                        [4.8e-10, 1.12206254877, 9779.5738083342],
                        [5.8e-10, 3.08646083897, 12074.488407524],
                        [4.6e-10, 4.07536026888, 7863.9425107882],
                        [4.5e-10, 4.75746520642, 7856.89627409019],
                        [5.4e-10, 4.43528236634, 8617.0991039264],
                        [5e-10, 3.70569982975, 42456.7840470916],
                        [4.4e-10, 1.29248911155, 69166.430989505],
                        [4.6e-10, 0.41229872114, 7564.830720738],
                        [4.4e-10, 6.17937388307, 13341.6743113068],
                        [5.3e-10, 4.71388531889, 53445.5922046266],
                        [4.1e-10, 3.48003037828, 37895.4262903674],
                        [4e-10, 1.2330554626, 10228.538017396],
                        [5.3e-10, 5.04979874661, 74673.9842281724],
                        [3.9e-10, 1.36646013032, 21202.093703746],
                        [3.9e-10, 2.15376025201, 8947.7180675846],
                        [4.1e-10, 6.1753298446, 65236.2212932854],
                        [5.2e-10, 1.29052331493, 90394.8230130508],
                        [3.9e-10, 0.70253732683, 18093.37469955],
                        [5.2e-10, 1.18164377451, 10211.8010735027],
                        [4.7e-10, 1.78672260794, 10401.2106939736],
                        [4e-10, 3.66961416802, 10198.033075026],
                        [5.1e-10, 2.71698589018, 94325.0327092704],
                        [3.6e-10, 1.2509171162, 10323.4918674304],
                        [4.9e-10, 1.2133595942, 9721.6222537522],
                        [4.2e-10, 6.05968230173, 105460.99111839],
                        [4.6e-10, 5.06978748275, 20350.3050211464],
                        [4e-10, 1.97645050921, 32243.4985008806],
                        [3.6e-10, 4.96702216961, 36301.1886877852],
                        [3.7e-10, 5.29642935562, 38.0276726358],
                        [3.9e-10, 0.52064327313, 26709.6469424134],
                        [3.5e-10, 2.34112124655, 58946.516884394],
                        [3.4e-10, 1.82989750626, 17675.0234927304],
                        [3.4e-10, 0.7649366411, 55798.4583583984],
                        [3.5e-10, 1.09353675147, 69159.802430605],
                        [3.1e-10, 5.59148330297, 10639.883737087],
                        [3.2e-10, 3.3296078187, 71519.2971432768],
                        [3.1e-10, 5.98191446392, 24341.5283174566],
                        [3.1e-10, 0.68615213145, 10202.2398459471],
                        [3e-10, 4.42039942947, 10459.1171924404],
                        [2.9e-10, 1.30367701539, 20103.0656757646],
                        [3.1e-10, 4.51793347997, 2957.7158944766],
                        [3.5e-10, 4.0563432129, 19903.9936743282],
                        [3e-10, 1.32113757427, 574.3447983348],
                        [2.9e-10, 3.36506645849, 10288.0671447783],
                        [2.9e-10, 1.40019042576, 9988.9407505091],
                        [3.2e-10, 0.21932095318, 24978.5245894808],
                        [3.4e-10, 5.22945947227, 8673.969676399],
                        [3.9e-10, 4.50883171158, 16004.6981037436],
                        [2.8e-10, 2.32945945641, 11392.4800852506],
                        [3.4e-10, 3.92498967835, 536.8045120954],
                        [3.2e-10, 5.46972716255, 64607.8489335462],
                        [2.8e-10, 2.38858990128, 20235.1228263104],
                        [3e-10, 3.34585843979, 39793.7602546548],
                        [2.6e-10, 5.36096904409, 1478.8665740644],
                      ],
          },
          {
            series => "R1",
            terms  => [
                        [0.00034551039, 0.89198710598, 10213.285546211],
                        [2.34203e-06, 1.77224942714, 20426.571092422],
                        [2.33998e-06, 3.14159265359, 0],
                        [2.3864e-07, 1.11274502648, 9437.762934887],
                        [1.0568e-07, 4.59168210921, 1577.3435424478],
                        [9.124e-08, 4.53540907003, 10404.7338123226],
                        [6.599e-08, 5.97703999838, 5507.5532386674],
                        [4.667e-08, 3.87683960551, 9153.9036160218],
                        [3.84e-08, 5.66196924375, 13367.9726311066],
                        [2.666e-08, 2.82413291285, 10206.1719992102],
                        [2.194e-08, 2.05314419626, 775.522611324],
                        [2.094e-08, 2.55137285015, 18837.4981971382],
                        [1.782e-08, 2.64808558644, 30639.856638633],
                        [1.845e-08, 1.87612936641, 11015.1064773348],
                        [1.303e-08, 0.20613045603, 11322.6640983044],
                        [1.169e-08, 0.79431893441, 17298.1823273262],
                        [1.001e-08, 6.16555101536, 10239.5838660108],
                        [9.15e-09, 4.59854496966, 1109.3785520934],
                        [8.84e-09, 0.66706834422, 18073.7049386502],
                        [8.49e-09, 5.5864157194, 12566.1516999828],
                        [1.071e-08, 4.94792017474, 6283.0758499914],
                        [8.87e-09, 2.47785193216, 3154.6870848956],
                        [9.04e-09, 0.81413053841, 10596.1820784342],
                        [8.18e-09, 0.90016838097, 5661.3320491522],
                        [8.45e-09, 5.48504338112, 529.6909650946],
                        [8.24e-09, 3.74837629121, 7084.8967811152],
                        [6.52e-09, 5.07444932607, 22003.9146348698],
                        [8.47e-09, 0.44119876869, 8635.9420037632],
                        [6.38e-09, 4.10125791268, 191.4482661116],
                        [6.15e-09, 3.14417599741, 10186.9872264112],
                        [5.27e-09, 5.86792949279, 2352.8661537718],
                        [5.2e-09, 5.33201358267, 14143.4952424306],
                        [5.76e-09, 2.25212731258, 21228.3920235458],
                        [6.62e-09, 2.86880467345, 8624.2126509272],
                        [5.54e-09, 2.17186191243, 18307.8072320436],
                        [5.15e-09, 4.34331395104, 9786.687355335],
                        [5.01e-09, 5.56479589366, 10742.9765113056],
                        [4.26e-09, 1.0216144312, 7064.1213856228],
                        [4.18e-09, 1.26803034691, 9676.4810341156],
                        [3.91e-09, 0.78974645621, 9690.7081281172],
                        [3.34e-09, 3.18175822557, 10988.808157535],
                        [3.75e-09, 0.66142254036, 19360.075615232],
                        [3.64e-09, 0.19369831864, 19374.3027092336],
                        [3.13e-09, 1.09734397626, 4551.9534970588],
                        [3.3e-09, 0.58817502306, 16496.3613962024],
                        [3.39e-09, 5.76768761396, 10021.8372800994],
                        [2.91e-09, 3.65846764668, 25158.6017197654],
                        [2.23e-09, 4.33581625553, 19786.673806108],
                        [2.66e-09, 3.57408827667, 801.8209311238],
                        [2.74e-09, 5.73346687248, 11790.6290886588],
                        [2.75e-09, 5.65814317085, 19896.8801273274],
                        [2.12e-09, 4.27038489878, 4705.7323075436],
                        [2.3e-09, 6.1340634559, 1059.3819301892],
                        [2.04e-09, 4.87348390351, 7860.4193924392],
                        [2.41e-09, 1.13551531894, 26.2983197998],
                        [2.06e-09, 0.31907973682, 382.8965322232],
                        [2.16e-09, 2.54741101724, 19651.048481098],
                        [2.12e-09, 3.15264941106, 14945.3161735544],
                        [1.63e-09, 1.13604744392, 13936.794505134],
                        [1.51e-09, 5.11341268743, 28521.0927782546],
                        [1.51e-09, 0.81278755582, 6770.7106012456],
                        [1.5e-09, 5.02227334847, 29088.811415985],
                        [1.46e-09, 1.37568138685, 10220.3990932118],
                        [1.27e-09, 4.49298610074, 3532.0606928114],
                        [1.21e-09, 6.26589208179, 29580.4747084438],
                        [1.47e-09, 6.16092774714, 8662.240323563],
                        [1.14e-09, 0.00114012635, 25934.1243310894],
                        [1.15e-09, 3.56897715344, 24356.7807886416],
                        [1.24e-09, 0.67547060274, 3723.508958923],
                        [1.45e-09, 0.36415036222, 9146.790069021],
                        [1.04e-09, 4.27865011376, 9573.388259897],
                        [1.36e-09, 5.09581116181, 19367.1891622328],
                        [1.02e-09, 1.53637788668, 17277.4069318338],
                        [1.17e-09, 0.57543238496, 9999.986450773],
                        [9.2e-10, 0.22936081655, 18830.3846501374],
                        [1.12e-09, 4.04771058036, 9103.9069941176],
                        [9.8e-10, 3.78447692407, 213.299095438],
                        [8.5e-10, 5.84471458481, 10234.0609417034],
                        [7.9e-10, 0.64440357793, 18844.611744139],
                        [8.4e-10, 0.56950139213, 9683.5945811164],
                        [1.07e-09, 1.77067111589, 17778.116266949],
                        [8.1e-10, 6.19048382717, 20618.0193585336],
                        [8.7e-10, 0.15771136594, 33019.0211122046],
                        [8.2e-10, 4.80683817059, 3930.2096962196],
                        [8.6e-10, 2.21505615071, 8094.5216858326],
                        [6.4e-10, 2.69215119482, 16983.9961474566],
                        [6.9e-10, 0.83385751986, 3128.3887650958],
                        [8.1e-10, 4.88025042367, 4732.0306273434],
                        [5.9e-10, 3.34348033725, 10787.6303445458],
                        [6.1e-10, 0.04044699966, 9161.0171630226],
                        [6.4e-10, 4.13127333938, 9992.8729037722],
                        [6e-10, 6.24603986632, 32217.2001810808],
                        [5.4e-10, 3.38449893196, 10426.584641649],
                        [5.4e-10, 5.15939119644, 28286.9904848612],
                        [6.3e-10, 4.32339245083, 12592.4500197826],
                        [6e-10, 4.4875384617, 18875.525869774],
                        [5.7e-10, 3.64912085313, 10007.0999977738],
                        [4.9e-10, 5.10267262491, 19573.37471067],
                        [4.7e-10, 5.79444960738, 68050.4238785116],
                        [5.2e-10, 3.56658420552, 7255.5696517344],
                        [5e-10, 1.61783309819, 36949.2308084242],
                        [5.3e-10, 2.64370544855, 15874.6175953632],
                        [4e-10, 3.93466530964, 20419.4575454212],
                        [5.1e-10, 0.79154899901, 23581.2581773176],
                        [3.8e-10, 1.77428239418, 10103.0792249916],
                        [4.9e-10, 1.12423644455, 3442.5749449654],
                        [4e-10, 5.22874487975, 21535.9496445154],
                        [3.8e-10, 1.12473430132, 7.1135470008],
                        [3.8e-10, 0.11510547453, 11272.6674764002],
                        [3.6e-10, 2.02476324983, 7058.5984613154],
                        [4.7e-10, 0.0558943239, 12432.0426503978],
                        [3.4e-10, 3.45481114998, 9830.3890139878],
                        [4.5e-10, 4.59817214088, 10192.5101507186],
                        [3.7e-10, 4.93959675364, 3340.6124266998],
                        [4.4e-10, 0.70533027806, 20213.271996984],
                        [3.4e-10, 2.16487642765, 64460.6986819614],
                        [3.1e-10, 1.57612397319, 36147.4098773004],
                        [2.8e-10, 2.56454760402, 94138.3270200858],
                        [3.3e-10, 1.08907268562, 29864.334027309],
                        [2.9e-10, 0.59718407064, 59728.668054618],
                        [3.1e-10, 3.04423979263, 40879.4405046438],
                        [3.5e-10, 0.32247158762, 1589.0728952838],
                        [3.1e-10, 3.27727318906, 19992.8593545452],
                        [2.7e-10, 5.83705748551, 17085.9586657222],
                        [3.2e-10, 2.6426078826, 41962.5207369374],
                        [2.8e-10, 4.90613317287, 29050.7837433492],
                        [2.5e-10, 4.55050389739, 14919.0178537546],
                        [2.8e-10, 3.58851614957, 40853.142184844],
                        [2.9e-10, 2.79705093386, 20007.0864485468],
                        [3.3e-10, 0.93862065616, 15720.8387848784],
                        [2.4e-10, 2.74970637101, 18947.7045183576],
                        [2.4e-10, 4.38966861409, 46386.9937433112],
                        [2.4e-10, 0.73361964525, 9411.4646150872],
                        [2.8e-10, 4.19559784013, 37674.9963942764],
                        [2.3e-10, 1.00023735538, 22779.4372461938],
                        [2.6e-10, 0.46990555736, 13745.3462390224],
                        [2.8e-10, 4.65181292126, 1551.045222648],
                        [2.5e-10, 4.18690270765, 44007.8292697396],
                        [2.2e-10, 0.98102807789, 426.598190876],
                        [3e-10, 1.24986033487, 27461.7108480654],
                        [2.7e-10, 3.94986823486, 17468.8551979454],
                        [2.1e-10, 6.09897508157, 18300.6936850428],
                        [2.5e-10, 4.75875623888, 27991.40181316],
                        [2.2e-10, 2.95281481673, 40077.61957352],
                        [2.8e-10, 6.12038264955, 38500.2760310722],
                        [2.2e-10, 4.11184201321, 19779.5602591072],
                        [2.7e-10, 3.7244644608, 19793.7873531088],
                        [2e-10, 4.27086627368, 31441.6775697568],
                        [2.2e-10, 4.99040169444, 31022.7531708562],
                        [2.3e-10, 1.33505132122, 65236.2212932854],
                        [2.1e-10, 4.46897353468, 53285.1848352418],
                        [2e-10, 4.15140915983, 2218.7571041868],
                        [2.5e-10, 2.18447182965, 27511.4678735372],
                        [1.9e-10, 1.43653410349, 27197.2816936676],
                        [2.7e-10, 1.22555218015, 42430.4857272918],
                        [1.9e-10, 3.65054338893, 49515.382508407],
                        [2.2e-10, 5.88380811711, 10218.8084705184],
                        [1.8e-10, 2.29853355765, 19264.0963880142],
                        [1.7e-10, 5.44429906531, 6681.2248533996],
                        [2e-10, 3.68116637773, 14128.2427712456],
                        [2.1e-10, 4.30316190532, 44809.6502008634],
                        [2e-10, 2.48583613985, 33794.5437235286],
                        [1.7e-10, 3.02735393984, 28528.2063252554],
                        [1.9e-10, 5.92656850674, 22805.7355659936],
                        [2.2e-10, 5.30827572791, 10207.7626219036],
                        [2e-10, 0.75829381378, 18314.9207790444],
                        [1.7e-10, 5.63315744126, 16522.6597160022],
                        [1.6e-10, 1.71021408448, 536.8045120954],
                        [1.5e-10, 5.27016880041, 53445.5922046266],
                        [1.7e-10, 5.61443395877, 47938.0389659592],
                        [1.5e-10, 5.81110284451, 43071.8992890308],
                        [1.5e-10, 4.96237667003, 19999.972901546],
                        [1.8e-10, 0.55618686515, 14765.2390432698],
                        [1.4e-10, 3.48144272414, 29786.660256881],
                        [1.5e-10, 5.84132627836, 10228.538017396],
                        [1.6e-10, 1.05720065324, 26735.9452622132],
                        [1.4e-10, 6.08462030302, 35371.8872659764],
                        [1.4e-10, 2.8453287189, 574.3447983348],
                        [1.5e-10, 5.3451771514, 10198.033075026],
                        [1.3e-10, 0.45004137509, 20452.8694122218],
                      ],
          },
          {
            series => "R2",
            terms  => [
                        [1.406587e-05, 5.0636639519, 10213.285546211],
                        [1.5529e-07, 5.47321687981, 20426.571092422],
                        [1.3059e-07, 0, 0],
                        [1.099e-08, 2.78883988292, 9437.762934887],
                        [4.88e-09, 6.27806914496, 1577.3435424478],
                        [3.61e-09, 6.11914188253, 10404.7338123226],
                        [3.1e-09, 1.38984998403, 5507.5532386674],
                        [3.89e-09, 1.95017779915, 11015.1064773348],
                        [3.72e-09, 2.33222828423, 775.522611324],
                        [2.07e-09, 5.63406721595, 10239.5838660108],
                        [1.68e-09, 1.10765197296, 13367.9726311066],
                        [1.75e-09, 6.1667465295, 30639.856638633],
                        [1.68e-09, 3.64495311632, 7084.8967811152],
                        [1.2e-09, 5.85815843789, 9153.9036160218],
                        [1.6e-09, 2.21564938463, 3154.6870848956],
                        [1.18e-09, 2.62358866565, 8635.9420037632],
                        [1.12e-09, 2.36235956804, 10596.1820784342],
                        [9.2e-10, 0.72664449269, 12566.1516999828],
                        [6.7e-10, 3.76089669118, 18837.4981971382],
                        [6.5e-10, 2.4798370999, 11790.6290886588],
                        [4.8e-10, 4.26620187144, 2352.8661537718],
                        [4.8e-10, 5.5089818955, 191.4482661116],
                        [4.8e-10, 2.54730918293, 17298.1823273262],
                        [4.6e-10, 3.40293459332, 14143.4952424306],
                        [4.1e-10, 1.83997113019, 11322.6640983044],
                        [3.7e-10, 6.17871126027, 1109.3785520934],
                        [3.9e-10, 4.77190210316, 18073.7049386502],
                        [3.5e-10, 3.10133256432, 4705.7323075436],
                        [4.6e-10, 3.30090415967, 6283.0758499914],
                        [3.4e-10, 3.91721765773, 10021.8372800994],
                        [3.4e-10, 3.24663787383, 22003.9146348698],
                        [4.2e-10, 3.39360926939, 14945.3161735544],
                        [4.4e-10, 4.42979374073, 7860.4193924392],
                        [3.4e-10, 2.16381407025, 16496.3613962024],
                        [3.1e-10, 0.45714618479, 26.2983197998],
                        [3.5e-10, 3.62868651241, 801.8209311238],
                        [3.2e-10, 1.84138997078, 382.8965322232],
                        [2.5e-10, 3.32908650295, 18307.8072320436],
                        [2.6e-10, 3.64313769818, 29088.811415985],
                        [2.9e-10, 3.8296717881, 10186.9872264112],
                        [2.2e-10, 3.17741520378, 28521.0927782546],
                        [2.1e-10, 2.52643834111, 529.6909650946],
                        [2.5e-10, 5.71401244457, 21202.093703746],
                        [2.1e-10, 3.77813434325, 21228.3920235458],
                        [1.9e-10, 5.24505118517, 19896.8801273274],
                        [1.8e-10, 4.62463651925, 19651.048481098],
                        [1.6e-10, 3.35893297896, 28286.9904848612],
                        [1.5e-10, 5.05571633205, 33019.0211122046],
                        [1.4e-10, 2.83786355803, 19786.673806108],
                        [1.4e-10, 1.79922718553, 9830.3890139878],
                        [1.4e-10, 3.14801263138, 19367.1891622328],
                        [1.4e-10, 3.57896195191, 10988.808157535],
                        [1.3e-10, 3.06303088617, 10742.9765113056],
                        [1.3e-10, 5.43981998532, 25158.6017197654],
                        [1.5e-10, 4.83166312889, 18875.525869774],
                        [1.2e-10, 2.54141086214, 7064.1213856228],
                        [1.2e-10, 4.45255110769, 15720.8387848784],
                        [1e-10, 1.87933121728, 24356.7807886416],
                        [1.1e-10, 2.58708635685, 9103.9069941176],
                        [1e-10, 2.179013099, 3723.508958923],
                        [8e-11, 3.63520673832, 1059.3819301892],
                        [8e-11, 4.67523115598, 25934.1243310894],
                        [9e-11, 5.97856553283, 9683.5945811164],
                      ],
          },
          {
            series => "R3",
            terms  => [
                        [4.9582e-07, 3.2226355452, 10213.285546211],
                        [8.31e-09, 3.21219077104, 20426.571092422],
                        [1.12e-09, 3.14159265359, 0],
                        [1.3e-10, 3.77448689585, 30639.856638633],
                        [9e-11, 4.19802043629, 10239.5838660108],
                        [6e-11, 0.20714935358, 10186.9872264112],
                        [5e-11, 0.68781956122, 8635.9420037632],
                      ],
          },
          {
            series => "R4",
            terms  => [
                        [5.73e-09, 0.9222969782, 10213.285546211],
                        [4e-10, 0.95468912157, 20426.571092422],
                        [6e-11, 3.14159265359, 0],
                      ],
          },
          {
            series => "R5",
            terms  => [
                        [4.5e-10, 0.30032866722, 10213.285546211],
                        [2e-11, 5.29627718483, 20426.571092422],
                      ],
          },
        ],
      ],
      name => "VSOP87D",
      order => 2,
      sidereal_period => 19414148.998,
      tropical_period => 19413685.543,
    }->{$key};
}

1;

__END__

=head1 NAME

Astro::Coord::ECI::VSOP87D::Venus - VSOP87D model of the position of Venus

=head1 SYNOPSIS

 use Astro::Coord::ECI::VSOP87D::Venus;
 use Astro::Coord::ECI::Utils qw{ deg2rad };
 use POSIX qw{ strftime };
 use Time::Local qw{ localtime };
 
 my $station = Astro::Coord::ECI->new(
     name => 'White House',
 )->geodetic(
     deg2rad( 38.899 ),  # radians
     deg2rad( -77.038 ), # radians
     16.68/1000,         # Kilometers
 );
 my $venus = Astro::Coord::ECI::VSOP87D::Venus->new(
     station => $station,
 );
 my $today = timelocal( 0, 0, 0, ( localtime )[ 3 .. 5 ] );
 foreach my $item ( $venus->almanac( $today, $today + 86400 ) ) {
     local $\ = "\n";
     print strftime( '%d-%b-%Y %H:%M:%S', localtime $item->[0] ),
         $item->[3];
 }

=head1 DESCRIPTION

This Perl class computes the position of Venus using the VSOP87D
model. It is a subclass of
L<Astro::Coord::ECI::VSOP87D::_Inferior|Astro::Coord::ECI::VSOP87D::_Inferior>.

=head1 METHODS

This class supports no additional public methods.

=head2 ATTRIBUTES

This class has no additional attributes.

=head1 SEE ALSO

L<Astro::Coord::ECI|Astro::Coord::ECI>

L<Astro::Coord::ECI::VSOP87D|Astro::Coord::ECI::VSOP87D>

=head1 SUPPORT

Support is by the author. Please file bug reports at
L<https://rt.cpan.org/Public/Dist/Display.html?Name=Astro-Coord-ECI-VSOP87D>,
L<https://github.com/trwyant/perl-Astro-Coord-ECI-VSOP87D/issues>, or in
electronic mail to the author.

=head1 AUTHOR

Thomas R. Wyant, III F<wyant at cpan dot org>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2018-2021 by Thomas R. Wyant, III

This program is free software; you can redistribute it and/or modify it
under the same terms as Perl 5.10.0. For more details, see the full text
of the licenses in the directory LICENSES.

This program is distributed in the hope that it will be useful, but
without any warranty; without even the implied warranty of
merchantability or fitness for a particular purpose.

=cut

# ex: set filetype=perl textwidth=72 :
