package Astro::Coord::ECI::VSOP87D::Mercury;

use 5.008;

use strict;
use warnings;

use base qw{ Astro::Coord::ECI::VSOP87D::_Inferior };

our $VERSION = '0.002_02';

sub __model_definition {
    my ( undef, $key ) = @_;
    return {
      body => "Mercury",
      default_model_cutoff => {
        Meeus => {
                   B0   => 14,
                   B1   => 11,
                   B2   => 9,
                   B3   => 7,
                   B4   => 2,
                   L0   => 38,
                   L1   => 16,
                   L2   => 10,
                   L3   => 8,
                   L4   => 6,
                   L5   => 1,
                   name => "Meeus",
                   R0   => 13,
                   R1   => 8,
                   R2   => 7,
                   R3   => 5,
                 },
        none  => {
                   B0   => 818,
                   B1   => 494,
                   B2   => 230,
                   B3   => 53,
                   B4   => 15,
                   B5   => 10,
                   L0   => 1380,
                   L1   => 839,
                   L2   => 395,
                   L3   => 153,
                   L4   => 28,
                   L5   => 13,
                   name => "none",
                   R0   => 1215,
                   R1   => 711,
                   R2   => 326,
                   R3   => 119,
                   R4   => 18,
                   R5   => 10,
                 },
      },
      diameter => 4879.4,
      model => [
        [
          {
            series => "L0",
            terms  => [
                        [4.40250710144, 0, 0],
                        [0.40989414976, 1.48302034194, 26087.9031415742],
                        [0.05046294199, 4.4778548954, 52175.8062831484],
                        [0.00855346843, 1.16520322351, 78263.7094247226],
                        [0.00165590362, 4.11969163181, 104351.612566297],
                        [0.00034561897, 0.77930765817, 130439.515707871],
                        [7.583476e-05, 3.7134840051, 156527.418849445],
                        [3.55974e-05, 1.51202669419, 1109.3785520934],
                        [1.726012e-05, 0.35832239908, 182615.321991019],
                        [1.803463e-05, 4.1033317841, 5661.3320491522],
                        [1.364682e-05, 4.59918318745, 27197.2816936676],
                        [1.589923e-05, 2.99510417815, 25028.521211385],
                        [1.017332e-05, 0.8803143904, 31749.2351907264],
                        [7.14182e-06, 1.54144865265, 24978.5245894808],
                        [6.43759e-06, 5.30266110787, 21535.9496445154],
                        [4.042e-06, 3.28228847025, 208703.225132594],
                        [3.52441e-06, 5.24156297101, 20426.571092422],
                        [3.43313e-06, 5.76531885335, 955.5997416086],
                        [3.39214e-06, 5.86327765, 25558.2121764796],
                        [4.51137e-06, 6.04989275289, 51116.4243529592],
                        [3.25335e-06, 1.3367433478, 53285.1848352418],
                        [2.59587e-06, 0.98732428184, 4551.9534970588],
                        [3.45212e-06, 2.79211901539, 15874.6175953632],
                        [2.72947e-06, 2.49451163975, 529.6909650946],
                        [2.3483e-06, 0.266721189, 11322.6640983044],
                        [2.38793e-06, 0.11343953378, 1059.3819301892],
                        [2.64336e-06, 3.91705094013, 57837.1383323006],
                        [2.16645e-06, 0.65987207348, 13521.7514415914],
                        [1.83359e-06, 2.62878670784, 27043.5028831828],
                        [1.75965e-06, 4.53636829858, 51066.427731055],
                        [1.81629e-06, 2.43413502466, 25661.3049506982],
                        [2.08995e-06, 2.09178234008, 47623.8527860896],
                        [1.72643e-06, 2.45200164173, 24498.8302462904],
                        [1.42316e-06, 3.36003948842, 37410.5672398786],
                        [1.37942e-06, 0.29098447849, 10213.285546211],
                        [1.18233e-06, 2.78149786369, 77204.3274945334],
                        [9.686e-07, 6.2039820274, 234791.128274168],
                        [1.25219e-06, 3.72079804425, 39609.6545831656],
                        [8.6819e-07, 2.64219349385, 51646.1153180538],
                        [8.6723e-07, 1.9595304265, 46514.4742339962],
                        [8.8329e-07, 5.41338795963, 26617.5941066688],
                        [1.06422e-06, 4.20572116254, 19804.8272915828],
                        [8.9987e-07, 5.85243631094, 41962.5207369374],
                        [8.4971e-07, 4.33100364958, 79373.087976816],
                        [6.9247e-07, 4.19446437496, 19.66976089979],
                        [6.3463e-07, 3.14700877722, 7238.6755916],
                        [6.8493e-07, 0.63424819267, 83925.0414738748],
                        [6.9729e-07, 3.57201709671, 25132.3033999656],
                        [5.9481e-07, 2.74692752, 16983.9961474566],
                        [6.483e-07, 0.0476292581, 33326.5787331742],
                        [5.5376e-07, 4.05312663019, 30639.856638633],
                        [5.4442e-07, 3.14331542453, 27147.2850717634],
                        [4.756e-07, 5.49722099211, 3.881335358],
                        [4.9567e-07, 3.98985863874, 6770.7106012456],
                        [5.6531e-07, 5.11920557675, 73711.7559276638],
                        [4.1764e-07, 5.64185159566, 53131.406024757],
                        [5.1458e-07, 5.47786463494, 50586.7333878646],
                        [4.4744e-07, 1.22366857463, 77154.3308726292],
                        [4.1882e-07, 5.19309298528, 6283.0758499914],
                        [3.8045e-07, 2.43117327523, 12566.1516999828],
                        [3.5627e-07, 0.81390126585, 32858.6137428198],
                        [4.8007e-07, 5.49260554912, 51749.2080922724],
                        [3.5392e-07, 3.36964859355, 36301.1886877852],
                        [3.3951e-07, 2.78618091049, 14765.2390432698],
                        [3.056e-07, 5.84045074182, 43071.8992890308],
                        [3.5964e-07, 1.4238083863, 2218.7571041868],
                        [3.4044e-07, 0.47470299167, 65697.5577247398],
                        [3.08e-07, 5.77017310191, 103292.230636108],
                        [2.8496e-07, 0.65048992658, 426.598190876],
                        [2.6215e-07, 5.24158618719, 22645.3281966088],
                        [2.6253e-07, 0.64807043102, 1589.0728952838],
                        [2.9538e-07, 0.69771244088, 213.299095438],
                        [2.7504e-07, 0.98010127839, 45892.730433157],
                        [2.2347e-07, 5.65335125838, 77734.018459628],
                        [2.2047e-07, 4.93398225193, 72602.3773755704],
                        [2.2275e-07, 2.17909842576, 52705.497248243],
                        [2.4252e-07, 4.39994170609, 7.1135470008],
                        [2.6751e-07, 1.06145361792, 3442.5749449654],
                        [2.3656e-07, 2.84168536986, 260879.031415742],
                        [2.2908e-07, 2.58462026514, 68050.4238785116],
                        [2.7086e-07, 0.08501738669, 63498.4703814528],
                        [2.2247e-07, 3.22418265191, 25448.0058552602],
                        [1.7803e-07, 3.61202297483, 110012.944615449],
                        [2.2407e-07, 1.02520094825, 105460.99111839],
                        [1.7576e-07, 4.71742326981, 25874.6040461362],
                        [1.8586e-07, 4.52709871258, 28306.660245761],
                        [1.4176e-07, 6.12394176563, 53235.1882133376],
                        [1.4186e-07, 5.14246797066, 26068.2333806744],
                        [1.7244e-07, 0.28394746813, 51220.2065415398],
                        [1.7176e-07, 3.26084092971, 153.7788104848],
                        [1.4938e-07, 1.83542009339, 99799.659069238],
                        [1.3387e-07, 0.76564655407, 56727.7597802072],
                        [1.3978e-07, 2.30193139916, 76674.6365294388],
                        [1.4428e-07, 0.96646356501, 26107.572902474],
                        [1.199e-07, 6.20492907598, 18849.2275499742],
                        [1.4381e-07, 1.90956715654, 23969.1392811958],
                        [1.1233e-07, 2.04817126136, 32370.9789915656],
                        [1.3392e-07, 4.51750784605, 26080.7895945734],
                        [1.1632e-07, 2.3849686026, 79219.3091663312],
                        [1.2412e-07, 2.22280944169, 77837.1112338466],
                        [9.95e-08, 2.0459444888, 48733.231338183],
                        [9.803e-08, 2.26706433546, 26091.7844769322],
                        [9.362e-08, 5.44291958209, 38654.054841557],
                        [9.747e-08, 3.83976857418, 26084.0218062162],
                        [9.264e-08, 4.02987000812, 467.9649903544],
                        [8.961e-08, 0.11062526114, 62389.0918293594],
                        [1.1543e-07, 4.17789167759, 103242.234014203],
                        [1.1146e-07, 3.78292300417, 26301.2022370122],
                        [9.677e-08, 2.98527809776, 59414.4818747484],
                        [8.977e-08, 3.47888073089, 91785.460866314],
                        [9.664e-08, 5.77941968495, 25938.3399444396],
                        [8.855e-08, 2.84672636028, 25035.6347583858],
                        [8.181e-08, 5.77857196635, 40853.142184844],
                        [8.033e-08, 2.45692824195, 129380.133777682],
                        [8.343e-08, 5.34499871294, 19317.1925403286],
                        [7.425e-08, 4.7116033039, 6.62855890001],
                        [9.001e-08, 6.23396256413, 25021.4076643842],
                        [8.126e-08, 1.12294634635, 26095.016688575],
                        [6.568e-08, 3.66248946629, 26514.5013324502],
                        [7.038e-08, 3.99035923761, 71980.6335747312],
                        [6.956e-08, 1.62821260299, 23869.1460373874],
                        [7.595e-08, 0.18334396433, 12432.0426503978],
                        [6.061e-08, 3.67044794062, 27676.976036858],
                        [5.896e-08, 5.57171141866, 94138.3270200858],
                        [5.716e-08, 5.18204203484, 78793.4003898172],
                        [5.855e-08, 2.14311779301, 20760.4270331914],
                        [5.681e-08, 1.60727624525, 98690.2805171446],
                        [5.788e-08, 2.3546749239, 103821.921601202],
                        [5.121e-08, 3.77832929907, 58946.516884394],
                        [5.873e-08, 5.76210244486, 286966.934557316],
                        [5.858e-08, 6.12538452806, 26011.6370702986],
                        [5.215e-08, 3.29186833997, 38519.945791972],
                        [6e-08, 0.00057044073, 51535.9089968344],
                        [4.647e-08, 0.29020584575, 136100.847757023],
                        [5.787e-08, 4.44783057272, 19406.6782881746],
                        [5.908e-08, 4.12195491631, 29530.4780865396],
                        [5.918e-08, 3.98930701135, 131548.894259964],
                        [5.728e-08, 3.02314979708, 89586.373523027],
                        [3.928e-08, 4.8143793369, 125887.562210812],
                        [3.929e-08, 2.48449041501, 69159.802430605],
                        [3.681e-08, 2.80180999964, 79323.0913549118],
                        [4.498e-08, 1.50325539137, 51962.5071877104],
                        [3.687e-08, 5.33717753698, 102762.539671013],
                        [3.497e-08, 1.85400531491, 52156.1365222486],
                        [3.867e-08, 1.25354714671, 54394.5633873352],
                        [4.459e-08, 4.88911997687, 50057.04242277],
                        [3.396e-08, 3.73870967348, 82815.6629217814],
                        [3.525e-08, 6.07665337319, 25934.1243310894],
                        [3.492e-08, 1.28206984744, 52168.6927361476],
                        [3.411e-08, 6.13976263434, 639.897286314],
                        [4.395e-08, 3.2547591476, 77308.109683114],
                        [2.99e-08, 5.27323635392, 46848.3301747656],
                        [3.218e-08, 5.20938751579, 103925.014375421],
                        [2.899e-08, 5.08451495112, 58458.8821331398],
                        [3.708e-08, 0.02713701028, 26241.681952059],
                        [2.991e-08, 2.92278339368, 44937.1306915484],
                        [3.177e-08, 0.05753403864, 22747.2907148744],
                        [3.163e-08, 5.38713552769, 105307.212307905],
                        [3.556e-08, 3.96231142071, 52195.4760440482],
                        [2.787e-08, 0.54704419913, 52389.1053785864],
                        [2.458e-08, 1.14904830408, 2333.196392872],
                        [2.492e-08, 5.24922078791, 25668.418497699],
                        [2.409e-08, 2.14208355028, 64741.9579831312],
                        [2.509e-08, 0.61934630416, 85034.4200259682],
                        [2.416e-08, 5.26204437192, 52179.6876185064],
                        [2.296e-08, 3.09900451546, 88476.9949709336],
                        [2.357e-08, 0.17742385045, 117873.364007888],
                        [3.012e-08, 0.83689268367, 129330.137155778],
                        [2.421e-08, 3.95913346049, 49.9966219042],
                        [2.197e-08, 2.56129546358, 3340.6124266998],
                        [2.402e-08, 0.55121112633, 52171.9249477904],
                        [2.106e-08, 5.41271503337, 155468.036919256],
                        [2.566e-08, 3.00606194044, 51109.3108059584],
                        [2.392e-08, 0.17898534184, 103.0927742186],
                        [2.737e-08, 1.08192567668, 632.7837393132],
                        [2.523e-08, 5.90356438675, 51123.53789996],
                        [2.098e-08, 2.4713206914, 66941.0453264182],
                        [2.003e-08, 3.75422326828, 16066.0658614748],
                        [2.188e-08, 1.18654376903, 2118.7638603784],
                        [2.593e-08, 2.55122032446, 25654.1914036974],
                        [2.559e-08, 1.18101453315, 45494.5814297488],
                        [1.918e-08, 0.79899605678, 26555.8681319286],
                        [1.819e-08, 0.69178943674, 98068.5367163054],
                        [2.471e-08, 2.55057179214, 52026.2430860138],
                        [1.704e-08, 0.3672357774, 52602.4044740244],
                        [2.129e-08, 2.66251948472, 18093.37469955],
                        [1.715e-08, 4.6217746471, 49957.0491789616],
                        [1.916e-08, 5.8372646205, 85502.3850163226],
                        [1.976e-08, 3.57365896777, 24395.7374720718],
                        [1.581e-08, 0.36987184257, 53764.8791784322],
                        [1.589e-08, 1.3353124195, 114.43928868521],
                        [2.042e-08, 2.05385564074, 45405.0956819028],
                        [1.539e-08, 2.25468618977, 120226.23016166],
                        [1.525e-08, 1.48231179113, 26094.5317004742],
                        [2.055e-08, 4.16315644175, 52182.9198301492],
                        [1.829e-08, 0.38846130335, 522.5774180938],
                        [2.105e-08, 4.04128506778, 25234.7067598222],
                        [1.48e-08, 1.87644604156, 104881.303531391],
                        [1.46e-08, 1.01790185557, 25455.119402261],
                        [1.453e-08, 0.3412522219, 1052.2683831884],
                        [1.449e-08, 3.39742463494, 24505.9437932912],
                        [1.48e-08, 4.55094492082, 124778.183658719],
                        [1.481e-08, 3.62242942443, 149.5631971346],
                        [1.516e-08, 5.3232780244, 129909.824742776],
                        [1.594e-08, 3.00887674765, 77623.8121384086],
                        [1.927e-08, 3.90378108197, 74.7815985673],
                        [1.373e-08, 4.32419381493, 80482.4665289094],
                        [1.419e-08, 3.90109225299, 7880.08915333899],
                        [1.525e-08, 4.62451312025, 26081.2745826742],
                        [1.567e-08, 0.65981123945, 157636.797401539],
                        [1.725e-08, 4.40112128069, 316.3918696566],
                        [1.263e-08, 4.96320745251, 74821.1344797572],
                        [1.472e-08, 5.56006656586, 95247.7055721792],
                        [1.315e-08, 1.83254115004, 76144.9455643442],
                        [1.439e-08, 0.8328616637, 55618.3812281138],
                        [1.355e-08, 3.15837061982, 1066.49547719],
                        [1.224e-08, 3.24032680768, 162188.750898597],
                        [1.39e-08, 5.13745290383, 419.4846438752],
                        [1.31e-08, 5.2825063668, 25619.9381512198],
                        [1.477e-08, 2.40227455027, 313054.83769889],
                        [1.252e-08, 5.65227031449, 26013.1215430069],
                        [1.143e-08, 0.38707356937, 42153.969003049],
                        [1.082e-08, 2.56550728704, 26190.9959157928],
                        [1.493e-08, 2.89973504649, 52099.5402118728],
                        [1.468e-08, 5.7150779125, 24491.7166992896],
                        [1.034e-08, 1.4954429444, 151975.465352386],
                        [1.314e-08, 5.91505351846, 115674.276664601],
                        [1.065e-08, 3.61081835123, 206.1855484372],
                        [1.053e-08, 5.1799602632, 23754.7067487022],
                        [9.64e-09, 2.05264296353, 128850.442812587],
                        [1.032e-08, 3.39114761061, 25551.0986294788],
                        [1.065e-08, 3.38225524038, 25863.5583458723],
                        [1.153e-08, 5.76498787983, 44181.2778411242],
                        [9.6e-09, 5.74774250678, 105410.994496486],
                        [1.137e-08, 6.20919445956, 103396.012824688],
                        [9.14e-09, 4.28855434634, 78256.5958777218],
                        [9.17e-09, 3.27543718918, 76.2660712756],
                        [8.92e-09, 4.82397571946, 78244.0396638228],
                        [9.76e-09, 4.86442946387, 25131.6139856036],
                        [1.086e-08, 0.73424633411, 33967.9922949132],
                        [1.162e-08, 4.52128441898, 78050.4103292846],
                        [8.68e-09, 2.78848256837, 52022.0274726636],
                        [9.43e-09, 4.0973685387, 26720.6868808874],
                        [9.73e-09, 4.54018615747, 24925.4284371664],
                        [8.45e-09, 5.05414707498, 25977.6968203548],
                        [8.41e-09, 1.89412486884, 130012.917516995],
                        [9.2e-09, 3.02504494542, 52329.5850936332],
                        [8.14e-09, 3.15330668609, 48835.1938564486],
                        [8.76e-09, 0.41318857467, 108903.566063356],
                        [8.18e-09, 1.61477924287, 40565.2543247742],
                        [1.074e-08, 1.37296024678, 23439.4483161012],
                        [8.12e-09, 2.82156935191, 25984.8103673556],
                        [7.75e-09, 2.86911510061, 26727.8004278882],
                        [7.55e-09, 5.44067645183, 24609.0365675098],
                        [9.21e-09, 4.7255790143, 14477.3511832],
                        [9.14e-09, 4.70826349904, 6681.2248533996],
                        [7.49e-09, 1.80279541026, 84546.785274714],
                        [9.07e-09, 0.64974692551, 78283.3791856224],
                        [8.54e-09, 5.05058435764, 307.5576209696],
                        [7.66e-09, 5.89942349817, 71025.0338331226],
                        [7.13e-09, 3.55192633098, 78477.0085201606],
                        [7.18e-09, 1.85061030321, 100909.037621331],
                        [8.58e-09, 5.43959629234, 536.8045120954],
                        [7.94e-09, 3.77076518156, 155418.040297352],
                        [8.48e-09, 2.08790526575, 131395.11544948],
                        [6.22e-09, 3.14583461131, 143961.267149462],
                        [6.23e-09, 4.58424507963, 9103.9069941176],
                        [6.23e-09, 5.10535773746, 90829.8611247054],
                        [7.06e-09, 4.19554833142, 71582.484571323],
                        [7.38e-09, 0.15942404038, 24712.1293417284],
                        [6.21e-09, 1.32834420218, 3328.13565628019],
                        [7.14e-09, 1.88052234658, 2199.087343287],
                        [6.78e-09, 6.01392909264, 77197.2139475326],
                        [6.5e-09, 5.51227348491, 29428.515568274],
                        [6.58e-09, 2.03299256393, 51756.3216392732],
                        [5.93e-09, 6.06807779961, 114564.898112508],
                        [6.66e-09, 0.70706334861, 26162.6847401415],
                        [5.97e-09, 5.15771478155, 333.8559407694],
                        [6.16e-09, 1.94902289932, 78267.5907600806],
                        [7.74e-09, 2.84206828086, 13655.8604911764],
                        [6.98e-09, 5.60747842278, 51742.0945452716],
                        [5.57e-09, 2.07529602574, 181555.94006083],
                        [5.47e-09, 3.17747066781, 90695.7520751204],
                        [5.41e-09, 4.20816350943, 28421.0995344462],
                        [6.39e-09, 5.55908134374, 78114.146227588],
                        [5.29e-09, 3.60209913515, 1911.1994832172],
                        [6.2e-09, 4.87816246784, 25771.5112719176],
                        [5.69e-09, 3.56250435364, 111122.323167542],
                        [5.1e-09, 4.2033182373, 28206.6670019526],
                        [5.39e-09, 5.42639519551, 93028.9484679924],
                        [6.59e-09, 3.45407389663, 26610.480559668],
                        [6.13e-09, 3.52133069078, 78259.8280893646],
                        [5.94e-09, 1.16299449628, 26404.2950112308],
                        [5.76e-09, 0.8161726673, 51322.6099013964],
                        [4.97e-09, 5.37540191935, 26037.90651967],
                        [6.63e-09, 2.63246066036, 77211.4410415342],
                        [4.87e-09, 1.96691664683, 26507.3877854494],
                        [4.74e-09, 3.65243004234, 124156.43985788],
                        [5.5e-09, 5.81040334783, 1731.1223529326],
                        [4.72e-09, 3.79351701945, 52643.7712735028],
                        [4.67e-09, 4.50175920356, 110.2063212194],
                        [5.93e-09, 3.04818872924, 12725.453434775],
                        [5.52e-09, 0.68733268561, 26137.8997634784],
                        [5.25e-09, 0.87988157932, 78270.8229717234],
                        [6e-09, 0.33902061394, 50483.640613646],
                        [4.43e-09, 3.33385484899, 78690.3076155986],
                        [4.41e-09, 1.31034191525, 76044.9523205358],
                        [5.88e-09, 2.37074288411, 121335.608713753],
                        [4.27e-09, 0.14810668871, 50593.8469348654],
                        [4.13e-09, 3.33346664325, 79852.7823200064],
                        [4.03e-09, 5.20705536949, 146314.133303234],
                        [5.24e-09, 5.02853960393, 71492.998823477],
                        [4.18e-09, 5.99113644745, 103711.715279983],
                        [3.88e-09, 4.44142037364, 29416.0387978544],
                        [3.9e-09, 4.02400157761, 51543.0225438352],
                        [4.42e-09, 2.37158178341, 111590.288157897],
                        [3.75e-09, 4.47565026408, 52182.4348420484],
                        [3.87e-09, 4.83640155029, 130969.206672966],
                        [3.9e-09, 1.20415517897, 150866.086800293],
                        [4.16e-09, 3.60399872842, 183724.700543113],
                        [4.07e-09, 0.529385305, 433.7117378768],
                        [4.39e-09, 2.45401498182, 50579.6198408638],
                        [4.12e-09, 0.50186886239, 27999.1026247914],
                        [3.91e-09, 0.68517124695, 134.109049585],
                        [3.98e-09, 1.99594942261, 155997.727884351],
                        [3.46e-09, 3.40308148193, 27140.1715247626],
                        [4.22e-09, 5.83293462268, 38813.3565763492],
                        [3.42e-09, 0.83679406818, 25764.3977249168],
                        [3.68e-09, 3.80659045949, 81706.284369688],
                        [3.55e-09, 1.99286044781, 1089.7087911936],
                        [4.62e-09, 3.33451630664, 25440.8923082594],
                        [3.3e-09, 0.37013669364, 26237.4663387088],
                        [3.3e-09, 6.19331560111, 188276.654040172],
                        [4.07e-09, 2.17141736652, 641.41356173899],
                        [3.21e-09, 5.0253200265, 102232.848705918],
                        [3.3e-09, 5.5308696608, 10021.8372800994],
                        [3.36e-09, 2.49163362426, 25344.9130810416],
                        [3.81e-09, 5.90928705861, 78187.443353447],
                        [3.16e-09, 2.42532836233, 52101.0246845811],
                        [3.31e-09, 4.38897286971, 26202.3424302594],
                        [4.01e-09, 1.99380933624, 49842.6098902764],
                        [4.22e-09, 0.4655666994, 1.4844727083],
                        [3.1e-09, 6.18819197073, 27154.3986187642],
                        [3.02e-09, 4.68575942793, 25565.3257234804],
                        [2.96e-09, 1.70818196194, 25973.463852889],
                        [3.75e-09, 5.31085497894, 339142.740840465],
                        [3.29e-09, 5.32609571265, 853.196381752],
                        [2.99e-09, 5.81101886868, 1692.1656695024],
                        [3.78e-09, 1.33745475273, 52169.1777242484],
                        [2.93e-09, 4.43993559835, 579.6875869988],
                        [2.76e-09, 4.45147472194, 178063.368493961],
                        [2.83e-09, 6.19860164015, 25881.717593137],
                        [3.15e-09, 1.95956643364, 51707.841292794],
                        [3.37e-09, 4.21457120705, 34282.1784747828],
                        [3.34e-09, 3.00354887525, 23866.0465069772],
                        [2.68e-09, 1.3443749352, 35191.8101356918],
                        [3.06e-09, 5.9444523141, 64607.8489335462],
                        [2.83e-09, 0.96234220412, 1639.069517188],
                        [2.87e-09, 1.28099267608, 51013.3315787406],
                        [2.69e-09, 0.55818949975, 3462.2447058652],
                        [2.74e-09, 5.61047457506, 52278.899057367],
                        [3.52e-09, 0.49071599781, 26294.0886900114],
                        [3.58e-09, 1.23360990528, 1223.81784077861],
                        [3.43e-09, 4.29256939583, 49527.3514576754],
                        [2.55e-09, 5.03019684368, 154938.345954161],
                        [2.97e-09, 2.87172991159, 129483.915966262],
                        [2.52e-09, 0.09044630682, 13541.4212024912],
                        [3.01e-09, 1.22789205624, 104138.313470859],
                        [2.74e-09, 3.67792692372, 68241.8721446232],
                        [3.21e-09, 2.49914111769, 141762.179806175],
                        [2.9e-09, 1.02241335068, 8194.2753332086],
                        [2.4e-09, 0.99284920524, 104344.499019296],
                        [2.78e-09, 0.53151576617, 949.1756089698],
                        [2.49e-09, 2.39787134441, 131498.89763806],
                        [2.74e-09, 2.09560778105, 26624.7076536696],
                        [2.4e-09, 3.14668052954, 23976.2528281966],
                        [2.39e-09, 0.8519855924, 52808.5900224616],
                        [2.66e-09, 0.18324709351, 2168.7604822826],
                        [2.26e-09, 4.85701184113, 156100.820658569],
                        [2.28e-09, 2.19799888298, 50696.939709084],
                        [2.31e-09, 1.49522976308, 104331.942805397],
                        [2.45e-09, 4.68642861263, 5327.4761083828],
                        [2.81e-09, 1.63579312063, 51219.5171271778],
                        [2.19e-09, 5.75893553103, 78109.9306142378],
                        [2.33e-09, 5.99853185125, 78417.4882352074],
                        [2.27e-09, 6.02396548637, 1581.959348283],
                        [2.18e-09, 5.42819370607, 18207.8139882352],
                        [2.2e-09, 3.72017611382, 7994.5284420242],
                        [2.71e-09, 0.20833686608, 51639.001771053],
                        [2.44e-09, 2.33639123341, 25138.7275326044],
                        [2.54e-09, 5.46143104532, 621.7438008392],
                        [2.09e-09, 0.01908528531, 26164.1692128498],
                        [2.08e-09, 6.18336687237, 74923.0969980228],
                        [2.74e-09, 0.1542389879, 51951.4614874465],
                        [2.12e-09, 1.95557421945, 735.8765135318],
                        [2.36e-09, 4.28368070837, 24079.3456024152],
                        [2.06e-09, 5.86972946528, 52072.7135089298],
                        [2.01e-09, 1.6122687707, 25241.820306823],
                        [2.35e-09, 3.60446251088, 104371.282327197],
                        [2.29e-09, 3.66187363672, 1596.1864422846],
                        [1.98e-09, 5.85298126352, 52815.7035694624],
                        [2.2e-09, 1.39541547612, 32769.1279949738],
                        [2.29e-09, 3.36265291664, 134991.46920493],
                        [1.92e-09, 1.03510456065, 25867.4904991354],
                        [1.99e-09, 4.7812628927, 110634.688416288],
                        [1.91e-09, 4.2411099766, 14.2270940016],
                        [2.1e-09, 5.44710702022, 147423.511855328],
                        [2.29e-09, 0.7626653182, 220.4126424388],
                        [1.85e-09, 0.24752751791, 104564.911661735],
                        [2.11e-09, 1.8182667082, 52065.599961929],
                        [1.82e-09, 2.31946183497, 9384.8410080752],
                        [2.07e-09, 0.77329376239, 917.9302859818],
                        [1.9e-09, 0.91354241432, 97670.3877128972],
                        [1.84e-09, 3.32299343484, 30.3268610044],
                        [2.09e-09, 0.41150840785, 181505.943438926],
                        [2.25e-09, 5.06158596891, 157483.018591054],
                        [1.84e-09, 2.71529935065, 103285.117089107],
                        [1.91e-09, 1.96528922573, 314.1861798696],
                        [1.82e-09, 4.30249539122, 1884.9011634174],
                        [1.92e-09, 4.820978767, 126996.940762906],
                        [1.88e-09, 0.98150502881, 26049.7701059364],
                        [1.84e-09, 0.6702869759, 106570.369670484],
                        [1.67e-09, 5.71084692524, 96357.0841242726],
                        [1.84e-09, 2.33710037381, 77829.9976868458],
                        [2.01e-09, 2.57648669602, 97112.9369746968],
                        [1.76e-09, 3.20466399658, 39629.3243440654],
                        [1.69e-09, 2.30516098722, 101.9625182656],
                        [1.63e-09, 6.11134623776, 170049.170291037],
                        [1.95e-09, 5.18276528052, 99024.136457914],
                        [1.65e-09, 6.00583599609, 224.3447957019],
                        [1.67e-09, 3.75645242744, 52250.5878817157],
                        [1.72e-09, 4.28474997892, 25780.3455206046],
                        [2.16e-09, 3.20425967752, 50800.0324833026],
                        [1.57e-09, 1.61810971101, 24815.222115947],
                        [1.63e-09, 1.77694235279, 116917.76426628],
                        [1.56e-09, 1.94644057334, 26421.7590823436],
                        [1.64e-09, 3.8148761948, 77410.5130429706],
                        [1.58e-09, 4.95279229085, 35472.7441496494],
                        [1.5e-09, 5.03580916221, 207643.843202404],
                        [2.08e-09, 2.59008696784, 27819.0254945068],
                        [1.8e-09, 5.62518388437, 103299.344183108],
                        [1.65e-09, 2.25945126594, 104202.049369162],
                        [1.48e-09, 3.94625893131, 24601.923020509],
                        [1.49e-09, 4.4976634152, 956.2891559706],
                        [1.57e-09, 1.62995234425, 51859.4144134918],
                        [1.66e-09, 0.21228205353, 52698.3837012422],
                        [1.51e-09, 2.75061488385, 140652.801254082],
                        [1.61e-09, 1.72952408524, 2648.454825473],
                        [1.69e-09, 2.61298183547, 26086.4186688659],
                        [1.7e-09, 0.78905798191, 72936.2333163398],
                        [1.77e-09, 5.06009562295, 77844.2247808474],
                        [1.42e-09, 2.61984020842, 24292.6446978532],
                        [1.5e-09, 4.93124201089, 28286.9904848612],
                        [1.75e-09, 5.79468120941, 39743.7636327506],
                        [1.63e-09, 3.37032055762, 76571.5437552202],
                        [1.5e-09, 1.79967850988, 3.9321532631],
                        [1.59e-09, 4.9036016347, 104355.493901655],
                        [1.49e-09, 4.20242344258, 52492.198152805],
                        [1.46e-09, 1.31203861446, 26198.1094627936],
                        [1.62e-09, 2.25640253895, 55516.4187098482],
                        [1.78e-09, 1.81205070225, 26395.4607625438],
                        [1.32e-09, 0.90685777764, 54294.5701435268],
                        [1.42e-09, 1.70641940798, 92741.0606079226],
                        [1.38e-09, 0.642980433, 86143.7985780616],
                        [1.25e-09, 0.32592941945, 150244.342999454],
                        [1.31e-09, 0.91963253985, 54509.0026760204],
                        [1.44e-09, 4.17124383409, 24822.3356629478],
                        [1.35e-09, 3.86821614788, 104358.726113298],
                        [1.59e-09, 4.72016316702, 4083.9885067044],
                        [1.22e-09, 2.0813340737, 52125.8096612442],
                        [1.41e-09, 2.08765477131, 119116.851609567],
                        [1.22e-09, 5.01211051965, 52595.2909270236],
                        [1.49e-09, 0.38744219837, 487.6347512542],
                        [1.21e-09, 3.30215904574, 1263.15736257819],
                        [1.38e-09, 1.04671626049, 1083.0802322936],
                        [1.57e-09, 5.17018916622, 23962.025734195],
                        [1.63e-09, 3.26593103179, 26089.3876142825],
                        [1.3e-09, 0.56779128434, 25936.8554717313],
                        [1.6e-09, 0.19385295261, 104347.731230939],
                        [1.16e-09, 2.69818513122, 129799.618421557],
                        [1.13e-09, 4.26323214388, 102132.85546211],
                        [1.15e-09, 1.35196569742, 75615.2545992496],
                        [1.35e-09, 1.70032124143, 97580.9019650512],
                        [1.21e-09, 0.20372434486, 38.1330356378],
                        [1.18e-09, 0.49434134122, 78731.674415077],
                        [1.19e-09, 5.5456272589, 76667.522982438],
                        [1.33e-09, 4.67446352847, 2014.9816717978],
                        [1.26e-09, 6.24694138116, 636.9962720242],
                        [1.2e-09, 3.20442216756, 76681.7500764396],
                        [1.25e-09, 3.65255045892, 29550.1478474394],
                        [1.18e-09, 5.26052652437, 26729.3167033132],
                        [1.13e-09, 6.26688921593, 104778.210757173],
                        [1.34e-09, 1.56524046563, 25939.8244171479],
                        [1.14e-09, 3.52566774494, 24356.7807886416],
                        [1.2e-09, 1.72596426067, 22759.767485294],
                        [1.45e-09, 3.6163842157, 52225.8029050526],
                        [1.07e-09, 5.72285490406, 24176.703658357],
                        [1.12e-09, 0.28882268029, 209812.603684687],
                        [1.21e-09, 0.11234419157, 51528.7954498336],
                        [1.2e-09, 4.17769370414, 25754.0472008048],
                        [1.05e-09, 1.88137155058, 172402.036444808],
                        [1.06e-09, 6.27133163237, 105940.685461581],
                        [1.04e-09, 3.850613951, 1478.8665740644],
                        [1.08e-09, 2.96292200098, 1375.7737998458],
                        [1.32e-09, 4.60210460022, 11610.5519583742],
                        [1.14e-09, 5.20612177122, 137678.191299471],
                        [1.07e-09, 0.00557717441, 13362.4497067992],
                        [1.01e-09, 0.73934409276, 77630.9256854094],
                        [9.7e-10, 1.19155686364, 78270.3379836226],
                        [1e-09, 0.25974575144, 160.40736938481],
                        [1.05e-09, 0.03739853961, 180.0771302846],
                        [1.14e-09, 5.13609864972, 1135.6768718932],
                        [1.01e-09, 4.1432325844, 176953.989941867],
                        [9.5e-10, 0.49488385937, 107794.187511262],
                        [9.5e-10, 1.54869651436, 25973.5040346608],
                        [1e-09, 1.51228088427, 157057.10981454],
                        [1.06e-09, 4.57237246234, 26073.6760475726],
                        [9.4e-10, 3.53697338405, 26521.614879451],
                        [9.1e-10, 3.13017596287, 64901.2597179234],
                        [8.8e-10, 5.20234335205, 1485.2907067032],
                        [1.16e-09, 5.96693811684, 24182.4383766338],
                        [9.9e-10, 2.1200254924, 66653.1574663484],
                        [1.05e-09, 4.04764282865, 27726.9726587622],
                        [9.4e-10, 2.62198655221, 104275.346495021],
                        [1.06e-09, 2.06629215696, 125112.039599488],
                        [8.8e-10, 3.8824070331, 51852.300866491],
                        [8.5e-10, 2.83285123847, 214364.557181746],
                        [8.3e-10, 5.44599307753, 78188.9278261553],
                        [8.3e-10, 3.35497157412, 52325.369480283],
                        [1.04e-09, 4.95116515346, 182085.631025925],
                        [1.1e-09, 6.04814955763, 49953.9496485514],
                        [9.3e-10, 1.00014028766, 9745.3205558566],
                        [8.1e-10, 4.03821735964, 132658.272812058],
                        [8.4e-10, 0.11234538521, 53228.0746663368],
                        [9.4e-10, 5.55962830464, 51432.8162226158],
                        [8e-10, 6.13595673095, 137210.226309117],
                        [8e-10, 2.72256616799, 25042.7483053866],
                        [8e-10, 4.2913724856, 77101.2347203148],
                        [8.5e-10, 0.97100574775, 25788.776747305],
                        [8.2e-10, 1.89501710792, 128320.751847493],
                        [7.7e-10, 1.16185579398, 204151.271635535],
                        [9.2e-10, 4.44154858356, 26091.8352948373],
                        [7.8e-10, 3.73813140716, 26222.0121911592],
                        [7.6e-10, 4.28770981047, 86457.9847579312],
                        [7.6e-10, 2.88868549481, 53242.3017603384],
                        [1.04e-09, 4.32540467122, 23888.8157982872],
                        [9.4e-10, 4.32453647728, 78257.0808658226],
                        [7.4e-10, 4.96325610801, 26823.779655106],
                        [7.7e-10, 1.07428657729, 50167.2487439894],
                        [7.5e-10, 2.56662960973, 19202.7532516434],
                        [9.9e-10, 6.00141798836, 19958.6061020676],
                        [8.7e-10, 3.55579419373, 52381.9918315856],
                        [7.8e-10, 1.00822618263, 25352.0266280424],
                        [8.8e-10, 3.52269656514, 60055.8954364874],
                        [7.8e-10, 5.82066892741, 155571.819107837],
                        [7.6e-10, 2.96046756402, 25024.5890581219],
                        [7.6e-10, 4.2442123571, 130226.216612433],
                        [7.6e-10, 2.22645638378, 36109.7404216736],
                        [7.2e-10, 2.23348468194, 173511.414996902],
                        [7.9e-10, 1.13204602827, 52290.2455718336],
                        [7.4e-10, 1.55328520138, 51653.2288650546],
                        [7.1e-10, 2.26106298981, 159.3017347922],
                        [7.3e-10, 2.05345178568, 26941.0995233262],
                        [9.5e-10, 1.93550514722, 365230.643982039],
                        [7e-10, 4.74315846161, 52061.3669944632],
                        [8.5e-10, 1.31607641314, 26667.590728573],
                        [7.6e-10, 5.58726680703, 13675.5302520762],
                        [9.2e-10, 3.24599684677, 28256.6636238568],
                        [6.7e-10, 1.15071488774, 55503.9419394286],
                        [6.8e-10, 2.92993581219, 23919.1426592916],
                        [6.7e-10, 1.77035470445, 181026.249095736],
                        [6.6e-10, 2.59648990707, 27780.0688110766],
                        [8.2e-10, 5.36282814327, 167850.08294775],
                        [6.4e-10, 3.99165913279, 130432.40216087],
                        [6.9e-10, 5.13777502156, 52712.6107952438],
                        [6.3e-10, 0.54837259436, 34082.4315835984],
                        [6.5e-10, 3.89976847376, 27005.833427556],
                        [7.3e-10, 6.19252091852, 50064.1559697708],
                        [6.6e-10, 1.91671959572, 102018.416173425],
                        [8.2e-10, 0.8782465164, 25446.4895798352],
                        [6.3e-10, 3.87624799927, 78896.4931640358],
                        [6.2e-10, 1.55377407031, 182188.723800143],
                        [6.2e-10, 4.71223563105, 103.7821885806],
                        [8.7e-10, 3.57434964589, 27037.078750544],
                        [7.7e-10, 3.43626093365, 54087.0057663656],
                        [7.8e-10, 4.92073893807, 77795.7444343682],
                        [7.1e-10, 2.76139796167, 11.0457002639],
                        [6.4e-10, 5.37974575072, 51226.6306741786],
                        [8.2e-10, 3.78003355754, 26308.315784013],
                        [6.2e-10, 2.70733081732, 104505.391376782],
                        [7.1e-10, 5.05097183202, 27177.6119327678],
                        [7e-10, 4.29342266024, 27311.7209823528],
                        [6.8e-10, 2.34136362165, 78366.8021989412],
                        [6e-10, 4.90888421377, 25508.2155545754],
                        [6.8e-10, 6.04917764171, 647.0108333148],
                        [5.8e-10, 2.46745404038, 104197.833755812],
                        [6.7e-10, 2.96573339768, 51969.6207347112],
                        [6.6e-10, 5.33871332672, 157586.800779634],
                        [5.8e-10, 2.17528608366, 323.5054166574],
                        [6.2e-10, 4.44991435917, 130419.845946971],
                        [6.3e-10, 0.27396211581, 130459.185468771],
                        [6.3e-10, 5.22327184571, 76784.8428506582],
                        [6.4e-10, 4.64108529425, 61279.713277266],
                        [6.2e-10, 1.84001159422, 183570.921732628],
                        [5.5e-10, 1.66692917947, 31415.379249957],
                        [5.8e-10, 4.06522187846, 32132.1317229496],
                        [5.7e-10, 2.0756938708, 17893.6278083656],
                        [5.5e-10, 2.49038254003, 22625.658435709],
                        [7.7e-10, 6.17301946895, 25032.4533646481],
                        [6.8e-10, 4.68765980625, 77307.420268752],
                        [5.4e-10, 4.63708190151, 51329.7234483972],
                        [5.5e-10, 0.21233757772, 2221.856634597],
                        [6.8e-10, 2.36358626958, 25953.7940919892],
                        [5.3e-10, 2.88564903323, 101011.000139597],
                        [6.2e-10, 1.19998944516, 26083.9709883111],
                        [5.4e-10, 3.90599349467, 123758.290854471],
                        [5.2e-10, 2.6059599715, 78160.616650504],
                        [7.2e-10, 0.83460657204, 22909.7573510066],
                        [6.6e-10, 3.17005690509, 78039.3646290207],
                        [5.2e-10, 2.13323028898, 44295.7171298094],
                        [6.1e-10, 1.63440457571, 61.7259747402],
                        [5.3e-10, 2.00748586733, 24448.8336243862],
                        [5.1e-10, 2.50978165702, 78903.6067110366],
                        [5.1e-10, 3.22110952745, 130652.814803309],
                        [6e-10, 6.23105854697, 76887.9356248768],
                        [6.6e-10, 3.23596712512, 77726.9049126272],
                        [5.9e-10, 1.53485505891, 6044.2285813754],
                        [5.9e-10, 1.10559326249, 26102.1302355758],
                        [6e-10, 1.08408977503, 27972.8043049916],
                        [4.9e-10, 2.24548271996, 425.908776514],
                        [5.5e-10, 3.33645161611, 207593.8465805],
                        [6.7e-10, 0.59579109206, 94329.7752861974],
                        [5.6e-10, 4.05652507832, 26010.1525975903],
                        [5.6e-10, 1.49670493057, 136722.591557862],
                        [4.9e-10, 4.72236375377, 5193.3670587978],
                        [4.9e-10, 2.99400480872, 52252.072354424],
                        [4.9e-10, 4.15104806247, 51955.3936407096],
                        [5e-10, 5.31916782876, 103917.90082842],
                        [5.1e-10, 4.32173710361, 58857.031136548],
                        [5e-10, 0.42233074233, 27684.0895838588],
                        [6.6e-10, 5.06498799279, 73.297125859],
                        [4.8e-10, 0.80745705976, 2703.6161546756],
                        [4.8e-10, 0.16882113823, 24918.3148901656],
                        [4.9e-10, 5.71984539931, 50380.5478394274],
                        [6.1e-10, 0.05575706789, 161079.372346504],
                        [4.7e-10, 5.70016549134, 129373.020230681],
                        [4.8e-10, 4.71754734372, 50903.1252575212],
                        [5e-10, 0.77120384679, 50689.8261620832],
                        [5e-10, 4.75557775921, 143005.667407854],
                        [4.6e-10, 1.03065291695, 51868.2486621788],
                        [4.6e-10, 4.07474771884, 52137.6732475106],
                        [4.5e-10, 2.75496032307, 196137.073432611],
                        [5.6e-10, 1.48667124221, 30171.8916482786],
                        [4.7e-10, 3.49884159195, 26575.5378928284],
                        [4.8e-10, 2.04489119557, 27573.1938482774],
                        [4.6e-10, 1.96812600979, 27223.5800134674],
                        [4.4e-10, 0.58466186909, 1243.4876016784],
                        [4.3e-10, 0.48582749664, 78338.4910232899],
                        [4.6e-10, 0.10663541022, 102659.446896794],
                        [4.9e-10, 1.92223535597, 50049.9288757692],
                        [4.7e-10, 5.34811633125, 846.0828347512],
                        [4.6e-10, 2.32911930278, 129387.247324683],
                        [5.6e-10, 1.46049477175, 28102.884813372],
                        [5e-10, 5.62967300375, 53906.928636081],
                        [4.6e-10, 5.09770472011, 151199.942741062],
                        [4.3e-10, 2.30154744958, 26709.6469424134],
                        [5.1e-10, 2.88082546361, 27669.8624898572],
                        [5.5e-10, 5.55849793732, 123200.840116271],
                        [4.4e-10, 0.48527820908, 80174.9089079398],
                        [4.8e-10, 2.59296696271, 6720.7139793414],
                        [4.4e-10, 0.24824938054, 742.9900605326],
                        [4.5e-10, 2.489494983, 65831.6667743248],
                        [4.5e-10, 4.86503115391, 52483.363904118],
                        [4.1e-10, 5.23419163545, 130289.952510736],
                        [4.1e-10, 0.91885509326, 50910.238804522],
                        [4.4e-10, 3.12424163301, 26126.036177212],
                        [4.2e-10, 5.66855218492, 166740.704395656],
                        [3.9e-10, 5.01739570944, 26402.0893214438],
                        [3.8e-10, 0.02313645928, 2111.6503133776],
                        [4.9e-10, 4.11697361923, 25227.5932128214],
                        [3.8e-10, 0.09191461136, 26118.2300025786],
                        [3.8e-10, 5.0314609238, 24203.0019781568],
                        [5.1e-10, 4.8630590664, 78153.5031035032],
                        [3.8e-10, 0.13003640396, 27351.0605041524],
                        [3.8e-10, 1.34984785206, 70269.1809826984],
                        [3.8e-10, 0.52032944033, 103498.416184545],
                        [4e-10, 5.66117959398, 52174.3218104401],
                        [3.8e-10, 0.92511339052, 112231.701719636],
                        [5.1e-10, 4.15223165568, 27170.9833738678],
                        [3.7e-10, 1.67308781547, 54374.8936264354],
                        [3.8e-10, 6.26592309401, 202.2533951741],
                        [3.6e-10, 3.23911910889, 176332.246141028],
                        [3.7e-10, 1.90730795656, 3308.4658953804],
                        [3.7e-10, 3.03203144287, 76041.8527901256],
                        [3.8e-10, 3.17519743409, 78786.2868428164],
                        [3.5e-10, 3.90697621183, 80382.473285101],
                        [3.8e-10, 2.00924199028, 1162.4747044078],
                        [3.6e-10, 1.80080871248, 19336.8623012284],
                        [3.5e-10, 4.66254825701, 77947.317555066],
                        [4.3e-10, 1.57972686428, 130443.397043229],
                        [3.5e-10, 0.74694549648, 25985.9406233086],
                        [4e-10, 2.11415671365, 3492.5715668696],
                        [3.8e-10, 4.65738726744, 22003.9146348698],
                        [3.7e-10, 0.7757183811, 16703.062133499],
                        [3.5e-10, 5.00128829727, 52509.6622239178],
                        [4.7e-10, 0.02275392308, 25014.2941173834],
                        [4.3e-10, 3.15273137814, 130435.634372513],
                        [3.4e-10, 3.05681901713, 2820.8311441262],
                        [3.7e-10, 4.68248751145, 123668.805106625],
                        [3.4e-10, 5.73615227262, 45290.6563932176],
                        [4e-10, 2.76893017076, 50270.341518208],
                        [3.8e-10, 6.01229835605, 26057.5762805698],
                        [3.4e-10, 6.25090722416, 21716.0267748],
                        [3.4e-10, 0.95587257158, 78580.1012943792],
                        [3.3e-10, 3.35217476663, 235900.506826261],
                        [3.2e-10, 2.35469869139, 2383.1930147762],
                        [3.7e-10, 3.80938441515, 8989.46770543239],
                        [4.3e-10, 2.27476214717, 25169.9728555924],
                        [3.2e-10, 4.14291864821, 2686.7220945412],
                        [3.7e-10, 0.0457118584, 52177.2907558567],
                        [3.2e-10, 1.53610678036, 233731.746343979],
                        [3.8e-10, 3.98892541543, 1300.826818205],
                        [4.2e-10, 5.10993958059, 145204.754751141],
                        [3.3e-10, 2.91530565997, 130866.113898747],
                        [4.3e-10, 1.77793563831, 103932.127922422],
                        [3.5e-10, 5.35726747093, 26189.8656598398],
                        [3.5e-10, 0.65119403092, 1535.9767429694],
                        [4.4e-10, 3.08976502022, 8014.198202924],
                        [3.1e-10, 0.90638189649, 128220.758603684],
                        [4.2e-10, 3.37905134636, 23549.6546373206],
                        [3.8e-10, 0.38543000653, 515.463871093],
                        [3.9e-10, 1.08681725797, 25773.7169617046],
                        [3.6e-10, 4.30448026071, 52286.0126043678],
                        [3.1e-10, 5.08183330827, 78213.7128028184],
                        [3.8e-10, 3.16432629306, 91805.1306272138],
                        [3.9e-10, 1.4749400211, 4022.2625319642],
                        [4.2e-10, 0.60192138814, 24388.623925071],
                        [3.7e-10, 3.2360628526, 28791.5192962498],
                        [4e-10, 0.26646931277, 78313.7060466268],
                        [3.6e-10, 4.38588497247, 81591.8450810028],
                        [3.5e-10, 0.17056359345, 6129.2970395066],
                        [3e-10, 2.50459470137, 102755.426124012],
                        [4e-10, 4.58870970073, 26076.8574413103],
                        [4e-10, 4.09419634913, 35833.2236974308],
                        [3e-10, 4.79837659477, 28736.3579670472],
                        [3.2e-10, 3.42931668217, 24402.8510190726],
                        [2.9e-10, 2.52212486456, 1353.7487450168],
                        [3e-10, 4.69352116507, 24072.9214697764],
                        [2.9e-10, 5.31070299201, 199599.318138476],
                        [3e-10, 3.20350587499, 23762.9537327586],
                        [3.6e-10, 2.44362166097, 23336.3555418826],
                        [2.8e-10, 2.77231585227, 26312.2479372761],
                        [2.8e-10, 0.26775880889, 50444.6839302158],
                        [2.9e-10, 3.50869792127, 15406.6526050088],
                        [3e-10, 2.95993198433, 132028.588603155],
                        [2.8e-10, 3.41609673663, 133882.090652836],
                        [3.3e-10, 2.39929042753, 61560.6472912236],
                        [3.2e-10, 1.34796958829, 37698.4550999484],
                        [2.8e-10, 1.75026246832, 78683.1940685978],
                        [3.3e-10, 4.51080770987, 3776.4308857348],
                        [3.2e-10, 5.0066530782, 29396.3690369546],
                        [3.7e-10, 5.23066729388, 81604.3218514224],
                        [2.8e-10, 0.99927277404, 1322.6776475314],
                        [2.9e-10, 2.0015977077, 25004.8229092806],
                        [3.5e-10, 4.69198477732, 22065.64060961],
                        [2.9e-10, 3.80697601044, 24513.057340292],
                        [3.2e-10, 4.69401466159, 27250.377845982],
                        [3.1e-10, 5.86715902954, 5815.11085963699],
                        [2.7e-10, 1.26702311366, 27044.1922975448],
                        [3e-10, 3.44351888035, 104819.577556651],
                        [2.8e-10, 5.36078058708, 412.3710968744],
                        [2.8e-10, 5.73893599832, 240452.46032332],
                        [3.4e-10, 5.19151430726, 2008.557539159],
                        [3e-10, 1.73241634839, 163766.094441045],
                        [2.7e-10, 5.30425762252, 24864.0853007956],
                        [3.2e-10, 1.12362303179, 625.6701923124],
                        [3e-10, 2.04171272941, 193937.986089324],
                        [3.2e-10, 4.78663079749, 75930.5130318506],
                        [3e-10, 4.4689122615, 25450.90686955],
                        [3.2e-10, 4.73906176949, 48847.6706268682],
                        [2.7e-10, 4.12514822062, 104358.241125197],
                        [2.6e-10, 0.67609297065, 35077.3708470066],
                        [3.3e-10, 2.69651735555, 25647.0778566966],
                        [2.6e-10, 4.94767789631, 209658.824874202],
                        [3.5e-10, 3.86705432105, 25466.159340735],
                        [2.6e-10, 4.79912409089, 198489.939586383],
                        [2.6e-10, 1.59971503257, 31281.270200372],
                        [2.6e-10, 1.20008223797, 153084.84390448],
                        [2.6e-10, 3.02443658098, 26724.8994135984],
                        [2.5e-10, 2.03567222767, 52817.2198448874],
                        [2.7e-10, 1.23585314301, 53.0961523144],
                        [2.6e-10, 5.53069670975, 25657.3727974351],
                        [2.8e-10, 0.93845909288, 158746.175953632],
                        [2.5e-10, 1.46977800361, 1272.6810256272],
                        [2.6e-10, 2.45961936761, 181659.722249411],
                        [3.4e-10, 2.39774146758, 39763.4333936504],
                        [2.9e-10, 6.23821353511, 102769.653218014],
                        [2.9e-10, 4.90111965589, 116783.655216695],
                        [2.5e-10, 3.02186465541, 39450.3528483734],
                        [2.7e-10, 3.77575599741, 103718.828826984],
                        [2.7e-10, 3.9212504685, 80596.9058175946],
                        [2.3e-10, 0.26970481255, 52609.5180210252],
                        [2.3e-10, 5.98846059571, 27463.67694142],
                        [2.5e-10, 1.22968381596, 49976.7189398614],
                        [2.3e-10, 5.57437029749, 155887.521563131],
                        [2.3e-10, 5.9950798502, 50007.0458008658],
                        [2.3e-10, 1.44496012077, 5687.630368952],
                        [2.4e-10, 0.46516912647, 130446.629254872],
                        [2.3e-10, 0.94331115897, 28774.6252361154],
                        [2.7e-10, 0.80529908381, 2698.4514473772],
                        [2.7e-10, 0.27124610516, 1265.5674786264],
                        [2.3e-10, 0.89381228793, 156314.119754007],
                        [2.3e-10, 2.96257779899, 12546.481939083],
                        [2.2e-10, 5.42940490576, 1485.9801210652],
                        [2.2e-10, 1.03839316349, 103189.137861889],
                        [2.3e-10, 1.35379542887, 52161.5791891468],
                        [2.6e-10, 6.01331218379, 122444.987265847],
                        [3e-10, 2.66518277698, 25600.26839032],
                        [2.3e-10, 4.07521268525, 230239.174777109],
                        [2.4e-10, 0.64355332403, 203041.893083441],
                        [2.2e-10, 1.39463873909, 952.0766232596],
                        [2.3e-10, 1.98852683178, 7392.4544020848],
                        [2.8e-10, 1.37381287166, 309.2783226558],
                        [2.2e-10, 2.15165551798, 104276.830967729],
                        [2.5e-10, 4.93854060665, 101703.157740824],
                        [2.3e-10, 3.12039946936, 77616.6985914078],
                        [2.8e-10, 0.40745832322, 55638.0509890136],
                        [2.4e-10, 0.4419926444, 24285.5311508524],
                        [2.3e-10, 1.33496997363, 163298.129450691],
                        [2.1e-10, 4.0146938126, 120417.678427772],
                        [2.4e-10, 0.63196904603, 77940.2040080652],
                        [2.2e-10, 5.70851933792, 2840.500905026],
                        [2.4e-10, 4.45840068641, 183145.012956114],
                        [2.3e-10, 3.62152465067, 5635.0337293524],
                        [2.1e-10, 3.04515069387, 9123.5767550174],
                        [2.1e-10, 1.96886020684, 177287.845882637],
                        [2.3e-10, 0.59040250365, 25672.3506509621],
                        [2.1e-10, 3.40810269373, 129586.319326119],
                        [2.1e-10, 3.09046433472, 26267.9802718588],
                        [2.4e-10, 1.94276984966, 183674.703921209],
                        [2.1e-10, 3.98455358233, 6191.0230142468],
                        [2.8e-10, 0.93414213433, 51841.950342379],
                        [2e-10, 4.59348701559, 52061.407176235],
                        [2.7e-10, 4.61439897742, 52027.7275587221],
                        [2e-10, 0.48128544481, 52309.9153327334],
                        [2e-10, 3.31281154655, 26248.310510959],
                        [2.3e-10, 1.67970146036, 23113.2931869632],
                        [2e-10, 2.44057473344, 50264.6067999312],
                        [2.5e-10, 5.43422956232, 2.9689454166],
                        [2.6e-10, 3.61410457829, 52024.7586133055],
                        [2e-10, 0.60321200025, 138319.60486121],
                        [2e-10, 2.62628682595, 164.43591058941],
                        [2e-10, 0.653247742, 156520.305302444],
                        [2.7e-10, 4.74395008878, 391318.547123613],
                        [2.1e-10, 4.45035214874, 25862.073873164],
                        [2.1e-10, 1.54947465846, 148.0787244263],
                        [2.7e-10, 5.13202499307, 12382.0460284936],
                        [2e-10, 0.68567124507, 42.8830749034],
                        [1.9e-10, 1.92072938625, 78800.513936818],
                        [2.7e-10, 2.48188330716, 25665.2371039613],
                        [2.7e-10, 1.27457874648, 7860.4193924392],
                        [2.2e-10, 2.29809961839, 25865.0428185806],
                        [1.9e-10, 4.09473921906, 76255.1518855636],
                        [2e-10, 4.67174071386, 207114.15223731],
                        [2.2e-10, 2.63315058351, 7768.3665566946],
                        [2e-10, 1.24271716091, 52179.7384364115],
                        [2e-10, 6.11431848045, 24824.745778996],
                        [2.3e-10, 4.18071159026, 2125.8774073792],
                        [2.1e-10, 0.74169140667, 1795.258443721],
                        [1.9e-10, 2.66558529381, 191.4482661116],
                        [2e-10, 3.22150044915, 156547.088610345],
                        [2.1e-10, 6.18753985884, 104127.267770595],
                        [2e-10, 5.52295053123, 130363.249636595],
                        [2.1e-10, 3.90684382108, 51534.3927214094],
                        [2e-10, 3.1001950954, 838.9692877504],
                        [2.5e-10, 5.79466888187, 26098.9488418381],
                        [2.1e-10, 6.23594952039, 103814.808054201],
                        [1.9e-10, 5.79715725254, 26279.3514076858],
                        [2.2e-10, 0.71256272418, 959.1228599576],
                        [2.1e-10, 1.39589766697, 103395.323410326],
                        [1.8e-10, 1.52837590084, 107.3053069296],
                        [1.9e-10, 0.6026210276, 27566.7697156386],
                        [2.5e-10, 0.78252166479, 53814.8758003364],
                        [2.5e-10, 2.29282750485, 77520.71936419],
                        [1.8e-10, 2.11606037402, 26.2983197998],
                        [2.4e-10, 1.60264230919, 208173.534167499],
                        [2.1e-10, 6.27983567062, 54344.566765431],
                        [1.8e-10, 2.13288203799, 77314.5338157528],
                        [1.9e-10, 5.02228884604, 26114.201461374],
                        [2e-10, 5.52520867267, 9591.5417453718],
                        [1.7e-10, 4.12183264175, 24602.612434871],
                        [2.2e-10, 0.51026067819, 95.9792272178],
                        [1.7e-10, 4.488898325, 208276.626941718],
                        [1.7e-10, 3.94937058994, 25459.0515555241],
                        [1.7e-10, 5.29323037427, 76137.8320173434],
                        [1.9e-10, 3.67294881327, 6885.14988993081],
                        [1.8e-10, 1.02433476262, 53399.624123927],
                        [2e-10, 2.79332004367, 25927.4957721894],
                        [1.8e-10, 5.83348216244, 293.4107843772],
                        [2.4e-10, 3.0007843166, 23446.561863102],
                        [2e-10, 1.11172116756, 156507.749088545],
                        [1.7e-10, 0.56645607004, 104984.39630561],
                        [2e-10, 4.48412602835, 52755.4938701472],
                        [1.9e-10, 5.18601674976, 2544.6726368924],
                        [2.3e-10, 4.19936868759, 24952.226269681],
                        [1.7e-10, 2.06473217893, 130005.803969994],
                        [1.9e-10, 0.55214472899, 52396.2189255872],
                        [1.9e-10, 1.79653943961, 89.485747846],
                        [2.2e-10, 3.72989530019, 48997.6604925808],
                        [2e-10, 5.93006048006, 11852.355063399],
                        [1.8e-10, 6.24870732707, 233681.749722074],
                        [2.1e-10, 3.0156672555, 25907.8260112896],
                        [1.6e-10, 1.73390726659, 52911.6827966802],
                        [1.7e-10, 3.23716624064, 117893.033768788],
                        [2.2e-10, 0.46092942812, 19367.1891622328],
                        [1.6e-10, 5.06429474773, 43981.5309499398],
                        [2.1e-10, 1.13950009268, 25650.2592504343],
                        [1.9e-10, 3.19311280972, 47803.9299163742],
                        [2.1e-10, 4.64218889935, 112545.887899505],
                        [1.7e-10, 2.96216633831, 102975.838766451],
                        [1.6e-10, 0.60226326404, 149846.193996046],
                        [1.6e-10, 5.86803075725, 127098.903281171],
                        [1.8e-10, 1.20391834667, 87367.6164188402],
                        [1.6e-10, 4.53670173929, 2667.0523336414],
                        [1.7e-10, 5.77652308057, 51130.6514469608],
                        [1.8e-10, 5.8770643204, 78057.5238762854],
                        [1.9e-10, 5.24206436649, 60370.081616357],
                        [1.6e-10, 1.31713012946, 78843.3970117214],
                        [1.9e-10, 5.33584429695, 104454.705340515],
                        [1.5e-10, 4.52789928708, 25984.1209529936],
                        [1.6e-10, 4.1216258545, 189386.032592265],
                        [1.7e-10, 3.51115348265, 45455.092303807],
                        [1.5e-10, 1.65943772958, 51596.1186961496],
                        [1.5e-10, 4.28577331083, 117.3198682202],
                        [1.6e-10, 0.28814169191, 78469.8949731598],
                        [1.5e-10, 0.64079475058, 53093.7365691302],
                        [2e-10, 5.58915267196, 1423.564731963],
                        [1.5e-10, 6.19871258212, 156740.717944883],
                        [1.5e-10, 2.05066243688, 16342.5825857176],
                        [1.8e-10, 0.93517825293, 104344.984007397],
                        [1.5e-10, 4.64013294295, 2974.609954611],
                        [1.5e-10, 2.61010767947, 7830.0925314348],
                        [1.5e-10, 2.60585262136, 151.0476698429],
                        [1.8e-10, 0.92309429794, 1577.3435424478],
                        [1.7e-10, 1.36952124854, 78115.6307002963],
                        [1.8e-10, 1.95659679786, 102872.745992232],
                        [1.7e-10, 5.37350443158, 25384.2699569568],
                        [1.5e-10, 2.1295253236, 128106.319314999],
                        [1.8e-10, 4.06290374391, 51439.9297696166],
                        [1.5e-10, 4.32808623679, 77741.1320066288],
                        [1.4e-10, 3.46389680879, 104426.394164864],
                        [2e-10, 5.15870331048, 154408.654989067],
                        [1.4e-10, 4.53089771582, 57503.2823915312],
                        [1.6e-10, 3.64720066701, 24072.2320554144],
                        [1.5e-10, 2.96793644807, 24719.2428887292],
                        [1.4e-10, 0.79165737765, 25928.601406782],
                        [1.4e-10, 4.36570321274, 78249.482330721],
                        [1.4e-10, 5.35774038541, 896.0794566554],
                        [1.4e-10, 5.57146329055, 104248.519792078],
                        [1.4e-10, 6.22061869408, 104874.189984391],
                        [1.5e-10, 0.66056760946, 77622.2958629836],
                        [1.7e-10, 4.3940408425, 162810.494699437],
                        [1.7e-10, 4.01700926317, 51876.6798888792],
                        [1.4e-10, 5.96074966457, 4371.8763667742],
                        [1.4e-10, 5.51412243126, 48713.5615772832],
                        [1.4e-10, 5.04161806976, 53029.0026649004],
                        [1.4e-10, 3.099795747, 128747.350038369],
                        [1.9e-10, 4.6170254761, 16028.396405848],
                        [1.7e-10, 2.09526572835, 52277.768801414],
                        [1.4e-10, 1.5151690827, 52164.7605828845],
                        [1.4e-10, 2.76589411039, 26734.913974889],
                        [1.7e-10, 5.31477308011, 103608.622505764],
                        [1.3e-10, 6.04881581356, 52812.8025551726],
                        [1.5e-10, 0.92065367569, 256327.077918683],
                        [1.6e-10, 2.76936523753, 46046.5092436418],
                        [1.9e-10, 4.91561037107, 277.0349937414],
                        [1.5e-10, 1.87874008695, 26161.2002674332],
                        [1.3e-10, 1.4859308936, 54824.2611086214],
                        [1.5e-10, 1.37228117638, 18043.3780776458],
                        [1.8e-10, 2.95472168569, 76152.059111345],
                        [1.7e-10, 1.57020520015, 104241.406245077],
                        [1.8e-10, 2.97721991956, 187167.275488078],
                        [1.3e-10, 3.49902133309, 78397.8184743076],
                        [1.8e-10, 2.18386661425, 149288.743257845],
                        [1.7e-10, 5.3885117007, 52041.6972335634],
                        [1.3e-10, 6.2695666077, 90989.1628594976],
                        [1.3e-10, 1.1367469174, 237009.885378355],
                        [1.4e-10, 2.18322393546, 225687.22128005],
                        [1.3e-10, 6.15204536524, 35211.4798965916],
                        [1.7e-10, 1.32178768936, 106262.812049514],
                        [1.4e-10, 1.73651187343, 2912.8839798708],
                        [1.3e-10, 0.84907711504, 102343.055027138],
                        [1.3e-10, 2.3997022038, 155460.923372255],
                        [1.7e-10, 4.15374414668, 26014.6060157152],
                        [1.3e-10, 0.72484082297, 153878.964023972],
                        [1.3e-10, 3.04907288197, 80432.4699070052],
                        [1.3e-10, 1.37316946035, 104035.22069664],
                        [1.5e-10, 3.12808384217, 173.44857138459],
                        [1.3e-10, 2.93774353095, 533.6231183577],
                        [1.3e-10, 2.24535401962, 246113.792372472],
                        [1.6e-10, 0.39665846969, 78112.6617548797],
                        [1.5e-10, 4.75053341616, 130020.031063996],
                        [1.6e-10, 0.76587038276, 557.4507382004],
                        [1.5e-10, 6.01045796437, 51112.4921996961],
                        [1.5e-10, 0.93774708323, 461.3364314544],
                        [1.2e-10, 4.03988032603, 77956.151803753],
                        [1.5e-10, 1.43833460468, 169093.570549428],
                        [1.4e-10, 2.1474910882, 78129.6003751376],
                        [1.2e-10, 4.57098987537, 6751.0408403458],
                        [1.7e-10, 0.640869336, 5131.6410840576],
                        [1.3e-10, 5.02936180992, 144916.866891071],
                        [1.6e-10, 3.65387335184, 104028.107149639],
                        [1.3e-10, 3.37789792164, 79212.8850336924],
                        [1.3e-10, 1.38408689559, 4885.8094378282],
                        [1.2e-10, 4.95862705668, 50536.7367659604],
                        [1.4e-10, 2.05563043425, 107692.224992997],
                        [1.2e-10, 3.9377239153, 104668.004435953],
                        [1.4e-10, 3.26407683636, 104401.609188201],
                        [1.4e-10, 2.94492731309, 51120.3565062223],
                        [1.3e-10, 5.3055485999, 155475.150466257],
                        [1.4e-10, 5.14050840336, 726.4820198702],
                        [1.2e-10, 2.41433841278, 24551.9263986048],
                        [1.3e-10, 3.02673254226, 182828.621086457],
                        [1.2e-10, 2.94598982599, 5039.588248313],
                        [1.3e-10, 3.57478000552, 78484.1220671614],
                        [1.3e-10, 2.94343799803, 79315.977807911],
                        [1.2e-10, 5.17024351037, 103402.436957327],
                        [1.2e-10, 3.19152649116, 28309.7597761712],
                        [1.2e-10, 6.16852058989, 78413.2726218572],
                        [1.3e-10, 4.35939831008, 133767.651364151],
                        [1.3e-10, 5.96217383792, 2538.2485042536],
                        [1.2e-10, 2.97455363125, 26290.1565367483],
                        [1.2e-10, 1.94777069809, 156377.855652311],
                        [1.2e-10, 1.81926611664, 70069.434091514],
                        [1.3e-10, 1.24212367708, 4437.51420837359],
                        [1.2e-10, 0.5377584257, 106470.376426675],
                        [1.2e-10, 4.0602950761, 79487.5272655012],
                        [1.2e-10, 1.39982040688, 77417.6265899714],
                        [1.2e-10, 5.70094378358, 79330.2049019126],
                        [1.2e-10, 2.36617272843, 79994.8317776552],
                        [1.2e-10, 4.77094162628, 78999.5859382544],
                        [1.2e-10, 5.23189289937, 26411.4085582316],
                        [1.4e-10, 2.99800402366, 1073.6090241908],
                        [1.2e-10, 6.15146193785, 103704.601732982],
                        [1.2e-10, 1.58617824624, 78571.2670456922],
                        [1.3e-10, 0.37894193721, 53124.9818921182],
                        [1.2e-10, 3.86549077079, 189853.997582619],
                        [1.3e-10, 4.70785515154, 234261.437309073],
                        [1.2e-10, 4.5409764894, 56259.7947898528],
                        [1.2e-10, 1.32257018476, 149756.7082482],
                        [1.1e-10, 5.69779744921, 222224.976574185],
                        [1.2e-10, 0.60900120711, 2751.5475996916],
                        [1.1e-10, 0.79876219873, 78225.5763890848],
                        [1.3e-10, 2.57664086838, 1116.4920990942],
                        [1.2e-10, 0.86411055123, 78043.2967822838],
                        [1.1e-10, 4.02869363295, 263097.788519929],
                        [1.1e-10, 3.97587600566, 76998.1419460962],
                        [1.1e-10, 5.29433199334, 52797.5500839876],
                        [1.3e-10, 5.69550284497, 51688.1715318942],
                        [1.5e-10, 3.91946731118, 27665.246684022],
                        [1.3e-10, 4.89334198524, 45424.7654428026],
                        [1.2e-10, 2.33066141026, 130336.422933652],
                        [1.2e-10, 2.97893637259, 25885.6497464001],
                        [1.2e-10, 0.33532325982, 41494.555746583],
                        [1.1e-10, 1.81390783997, 104301.615944393],
                        [1.1e-10, 3.67540306066, 79181.6397107044],
                        [1.3e-10, 1.92207364074, 2962.880601775],
                        [1.2e-10, 4.51335455691, 54190.7879549462],
                        [1.2e-10, 5.8914039722, 156954.017040321],
                        [1.2e-10, 5.80412470555, 72134.412385216],
                        [1.1e-10, 2.54446138738, 26183.882368792],
                        [1.1e-10, 0.57810940674, 142871.558358269],
                        [1.4e-10, 1.49797486148, 103883.647575942],
                        [1.1e-10, 0.25563634033, 52663.4410344026],
                        [1.1e-10, 4.34226157432, 63786.3582415226],
                        [1.1e-10, 5.79546155779, 76358.2446597822],
                        [1.1e-10, 5.43581617959, 4398.17468657401],
                        [1e-10, 3.45435285202, 26830.8932021068],
                        [1e-10, 1.05961891051, 216897.500465802],
                        [1e-10, 5.54078372768, 53867.9719526508],
                        [1.3e-10, 4.09291929409, 78378.1487134078],
                        [1.2e-10, 6.09214378282, 156523.537514087],
                        [1.2e-10, 2.30793560033, 192828.60753723],
                        [1.1e-10, 5.49984194986, 130593.294518356],
                        [1e-10, 5.02934387609, 63.7358983034],
                        [1e-10, 2.56161075764, 3178.1457905676],
                        [1e-10, 4.51229030686, 80912.1642501956],
                        [1e-10, 3.26964460988, 143980.936910362],
                        [1.4e-10, 0.09133406732, 138.5174968707],
                        [1.4e-10, 4.26704901561, 52171.8741298853],
                        [1e-10, 2.12874423735, 181563.053607831],
                        [1e-10, 2.68594312022, 53551.5800829942],
                        [1e-10, 5.01052160566, 53311.4831550416],
                        [1.3e-10, 2.21304135803, 287.8878600698],
                        [1e-10, 5.99285759925, 129063.741908025],
                        [1e-10, 0.23580667035, 159969.993794411],
                        [1.4e-10, 4.15846442712, 52190.03337715],
                        [1.4e-10, 2.17544501087, 2506.6449642566],
                        [1e-10, 2.39055885342, 78262.2249520143],
                        [1e-10, 5.33589950489, 128843.329265586],
                        [1e-10, 3.69795961564, 175934.09713762],
                        [1e-10, 5.50982370855, 181548.826513829],
                        [1.2e-10, 0.91293309387, 53258.886515442],
                        [1e-10, 0.21546965297, 155674.222467693],
                        [1e-10, 5.05408550952, 182465.758793885],
                        [1.1e-10, 1.47055363263, 76991.0283990954],
                        [1.4e-10, 1.74381856487, 36.6485629295],
                        [1.4e-10, 1.73080789777, 171292.657892715],
                        [1e-10, 1.79047706298, 235746.728015776],
                        [1.2e-10, 2.869185171, 2045.3085328022],
                        [1.3e-10, 5.94639118711, 168959.461499843],
                        [1e-10, 5.24213703651, 130285.736897386],
                        [1.4e-10, 6.10459624713, 454.9093665273],
                        [1e-10, 5.39397583397, 77.7505439839],
                        [1.1e-10, 1.99827759086, 1088.603156601],
                        [1e-10, 1.76064600598, 52489.992463018],
                        [1e-10, 5.11611480967, 113455.519560414],
                        [1.4e-10, 4.11983704037, 54060.7074465658],
                        [1.2e-10, 2.84049561669, 183041.920181895],
                        [1.2e-10, 3.1829708579, 228508.052424176],
                        [1e-10, 1.62042818189, 231348.553329202],
                        [1e-10, 2.3830820052, 181975.424704705],
                        [1e-10, 5.17901157458, 203375.749024211],
                        [1e-10, 1.70609651468, 78597.565365492],
                        [1e-10, 3.0188061819, 104501.175763431],
                        [1.1e-10, 1.42631059185, 58220.0348645238],
                        [1e-10, 3.45269160846, 99979.7361995226],
                        [1.1e-10, 4.42716378223, 235320.819239262],
                        [1e-10, 4.45423293249, 5469.8837830406],
                        [9e-11, 4.68983089958, 80462.7967680096],
                        [9e-11, 1.77635894319, 50290.905119731],
                        [1e-10, 1.41464391522, 48091.817776444],
                        [1.1e-10, 5.93477819724, 158116.491744729],
                        [1e-10, 2.55614008171, 105418.108043487],
                        [9e-11, 3.11835021508, 52206.1331441528],
                        [9e-11, 2.24380470375, 299.1263942692],
                        [9e-11, 3.22171579815, 51006.2180317398],
                        [9e-11, 3.24808968579, 78697.4211625994],
                        [1.1e-10, 0.73383746517, 17605.7399482958],
                        [1e-10, 2.45523846147, 233835.528532559],
                        [9e-11, 4.35363918141, 190809.597324228],
                        [9e-11, 2.77090630961, 76094.94894244],
                        [1.2e-10, 0.23038883503, 130907.480698225],
                        [9e-11, 5.05551915235, 70383.6202713836],
                        [9e-11, 5.11051597902, 156093.707111568],
                        [1.1e-10, 5.44617170556, 56777.7564021114],
                        [9e-11, 4.67339642631, 104771.097210172],
                        [9e-11, 4.56456351898, 259819.649485553],
                        [9e-11, 0.73352390338, 75085.563634155],
                        [1e-10, 2.64743106367, 153186.806422745],
                        [1e-10, 5.18315351919, 1382.1979324846],
                        [1.2e-10, 4.75714453262, 250665.745869531],
                        [1.1e-10, 5.79093643324, 292628.266606468],
                        [9e-11, 6.24971585432, 202420.149282602],
                        [1.2e-10, 5.83966176266, 11790.6290886588],
                        [1.1e-10, 2.84614041718, 184204.394886303],
                        [1e-10, 3.41187941424, 1905.4647649404],
                        [1e-10, 3.0024026508, 118828.963749497],
                        [9e-11, 3.90754065548, 154308.661745258],
                        [1e-10, 0.88848120961, 51315.4963543956],
                        [1.1e-10, 4.4943130123, 156531.300184803],
                        [9e-11, 0.37279337773, 182622.43553802],
                        [9e-11, 5.94479236467, 38634.3850806572],
                        [9e-11, 0.28434529807, 5019.9184874132],
                        [1.1e-10, 5.30507160437, 51257.8759971666],
                        [9e-11, 5.05598171209, 62197.6435632478],
                        [9e-11, 2.0074301127, 154194.222456573],
                        [1e-10, 2.29548861266, 1211.341070359],
                        [9e-11, 1.40840962373, 78149.2701360374],
                        [1.1e-10, 2.69818187519, 195047.364641417],
                        [9e-11, 3.7733811002, 52073.8437648828],
                        [1e-10, 4.16632261841, 1130.1539475858],
                        [9e-11, 4.71851534374, 257436.456470777],
                        [9e-11, 1.56697202296, 156107.93420557],
                        [1e-10, 3.84491070936, 42790.9652750732],
                        [1e-10, 0.84911221571, 61921.126839005],
                        [1.1e-10, 3.4350449899, 81725.9541305878],
                        [8e-11, 3.46841587447, 156534.532396446],
                        [9e-11, 3.07023951195, 78265.1938974309],
                        [1.1e-10, 5.3324059131, 49424.2586834568],
                        [9e-11, 3.80703237983, 184834.079095206],
                        [1e-10, 5.24984657637, 860.3099287528],
                        [8e-11, 2.32846981012, 156451.15277817],
                        [9e-11, 5.86810139691, 221135.267782991],
                        [9e-11, 0.07267483428, 54879.422437824],
                        [9e-11, 3.53847001127, 1169.5882514086],
                        [8e-11, 0.40730399, 5852.7803152638],
                        [1e-10, 5.08938165465, 53661.0969898516],
                        [9e-11, 0.09227292796, 285857.556005223],
                        [9e-11, 1.53921610006, 171004.770032645],
                        [1e-10, 6.0236999988, 105403.880949485],
                        [9e-11, 1.41005383919, 215473.935733839],
                        [8e-11, 2.95064025568, 182611.440655661],
                        [1.1e-10, 0.82592745776, 52098.0557391645],
                        [1.1e-10, 1.89268014069, 53265.515074342],
                        [9e-11, 0.91534494504, 130446.144266771],
                        [1.1e-10, 5.68651428373, 97466.462676366],
                        [8e-11, 6.09336539202, 65538.2559899476],
                        [1e-10, 4.71864870979, 1865.2314025176],
                        [1.1e-10, 0.33942008091, 2352.8661537718],
                        [1e-10, 0.58149039679, 51554.0624823092],
                        [9e-11, 4.63908561414, 130329.309386652],
                        [8e-11, 3.29340479484, 76532.58707179],
                        [8e-11, 0.39996086139, 31722.9368709266],
                        [9e-11, 2.07892055945, 84307.938006098],
                        [8e-11, 0.10251061291, 130489.512329775],
                        [9e-11, 4.86488540298, 197380.561034289],
                        [8e-11, 2.84319355109, 247223.170924566],
                        [9e-11, 5.40644601602, 205260.650187628],
                        [8e-11, 2.99554948925, 28199.5534549518],
                        [8e-11, 2.31903661034, 50951.9884423698],
                        [9e-11, 3.67243760379, 132558.279568249],
                        [1e-10, 3.84482406254, 199.0720014364],
                        [8e-11, 5.13311255182, 133780.128134571],
                        [8e-11, 4.50659262629, 31775.5335105262],
                        [1e-10, 3.05711078565, 12098.1867096284],
                        [9e-11, 5.43609233651, 65851.3365352246],
                        [8e-11, 3.1647127512, 53438.9636457266],
                        [8e-11, 5.49628419906, 208063.32784628],
                        [9e-11, 0.80806156177, 84944.9342781222],
                        [8e-11, 1.45936166924, 50160.8246113506],
                        [9e-11, 3.83369994945, 79902.7789419106],
                        [8e-11, 5.05169260225, 220025.889230898],
                        [1e-10, 0.99908522442, 78373.915745942],
                        [8e-11, 1.78435325528, 4743.4017631704],
                        [9e-11, 2.44642878457, 76468.4509810016],
                        [1e-10, 0.640410795, 106684.808959169],
                        [8e-11, 0.22706755866, 130514.297306438],
                        [8e-11, 4.45568539518, 175844.611389774],
                        [8e-11, 5.30875425569, 104991.509852611],
                        [8e-11, 4.26578657244, 78267.6415779857],
                        [1e-10, 3.66900856638, 22595.3315747046],
                        [8e-11, 5.3953090617, 1168.8988370466],
                        [7e-11, 2.97217552646, 130962.093125965],
                        [8e-11, 5.4165915664, 106082.734919229],
                        [7e-11, 6.14449914187, 154835.253179943],
                        [9e-11, 3.77109166248, 76777.7293036574],
                        [1e-10, 2.68699198523, 31903.0140012112],
                        [1e-10, 4.1132528617, 51861.6201032788],
                        [1e-10, 6.22285311837, 52213.9393187862],
                        [8e-11, 4.05691998652, 130432.887148971],
                        [8e-11, 5.44182392744, 24844.4155398958],
                        [8e-11, 5.31551782104, 26247.2048763664],
                        [7e-11, 3.34982243781, 53771.992725433],
                        [7e-11, 0.76435484795, 103829.035148203],
                        [9e-11, 0.48166296597, 4571.62325795859],
                        [1e-10, 2.5385762885, 23735.0369878024],
                        [9e-11, 3.0693298264, 51102.1972589576],
                        [9e-11, 0.81667861584, 180396.564886833],
                        [8e-11, 1.37381137878, 182619.203326377],
                        [1e-10, 4.53462580754, 195181.473691002],
                        [7e-11, 5.92229713446, 102129.7559317],
                        [9e-11, 1.70197819412, 114.3991069134],
                        [9e-11, 2.75554865259, 52145.479422144],
                        [7e-11, 5.030029299, 78905.1229864616],
                        [8e-11, 4.70162992466, 77684.0218377238],
                        [7e-11, 2.16016333042, 252884.502973718],
                        [7e-11, 4.7010481161, 197092.673174219],
                        [8e-11, 3.34882273958, 92.0528357446],
                        [7e-11, 4.64287583099, 104659.170187266],
                        [7e-11, 1.74834665027, 79116.9058064746],
                        [7e-11, 1.40803395997, 78149.3103178092],
                        [7e-11, 5.96603423152, 1685.0521225016],
                        [8e-11, 5.74025115791, 27441.651886591],
                        [7e-11, 3.32172728837, 186057.896935985],
                        [7e-11, 5.77399157694, 52822.8171164632],
                        [9e-11, 5.4096900728, 25970.583273354],
                        [7e-11, 5.0309737967, 51092.7260508548],
                        [8e-11, 4.85500497006, 79353.4182159162],
                        [9e-11, 2.91790460578, 128857.556359588],
                        [1e-10, 2.62831495455, 104145.42701786],
                        [8e-11, 3.65717048924, 50476.5270666452],
                        [1e-10, 4.97375703081, 128960.649133807],
                        [7e-11, 0.63731291763, 132350.715191088],
                        [7e-11, 3.70718359263, 61165.2739885808],
                        [7e-11, 1.524098908, 224577.842727957],
                        [7e-11, 5.83295581556, 78339.9754959982],
                        [7e-11, 1.2898265788, 127791.060882398],
                        [7e-11, 4.38077281912, 87648.5504327978],
                        [7e-11, 0.78772735446, 104044.054945327],
                        [7e-11, 5.55018242223, 148532.890407421],
                        [8e-11, 3.9435380026, 77929.8534839532],
                        [7e-11, 4.68484570125, 129971.550717517],
                        [7e-11, 5.46082675395, 76352.5099415054],
                        [7e-11, 0.89727780818, 28213.7805489534],
                        [6e-11, 2.25546242417, 79955.875094225],
                        [7e-11, 1.85784871452, 28096.4606807332],
                        [6e-11, 6.2231897778, 261988.409967835],
                        [6e-11, 3.92166942434, 182402.022895581],
                        [6e-11, 4.54553590954, 26235.9818660005],
                        [6e-11, 0.04385251847, 182634.991751919],
                        [6e-11, 3.27000773736, 104557.798114734],
                        [6e-11, 1.4831694091, 26191.6853301548],
                        [6e-11, 1.42098831764, 26026.177166834],
                        [6e-11, 4.63624566094, 57369.1733419462],
                        [6e-11, 2.24614788518, 131079.412994185],
                        [8e-11, 1.46359871781, 74935.5737684424],
                        [7e-11, 0.19039890992, 117077.066001072],
                        [6e-11, 2.30839350284, 27353.4706202006],
                        [8e-11, 4.05701479596, 60170.3347251726],
                        [6e-11, 2.25676540184, 118007.473057473],
                        [7e-11, 5.19369769843, 91919.569915899],
                        [6e-11, 2.17221286567, 27573.8832626394],
                        [6e-11, 3.04358438526, 83591.1855331054],
                        [6e-11, 5.50261387027, 26238.9508114171],
                        [6e-11, 5.55141392261, 207747.625390985],
                        [7e-11, 3.67760971466, 229129.796225016],
                        [6e-11, 5.14998820697, 130364.734109304],
                        [6e-11, 2.59291082745, 52186.8519834123],
                        [6e-11, 3.70620257597, 182608.208444019],
                        [7e-11, 5.89987227798, 53757.7656314314],
                        [7e-11, 1.17954845926, 209232.916097688],
                        [7e-11, 1.99199973963, 88285.546704822],
                        [6e-11, 5.29985761538, 175376.646399419],
                        [7e-11, 1.76338847974, 55484.2721785288],
                        [8e-11, 0.55724966367, 129806.731968558],
                        [5e-11, 4.19687137282, 111032.837419696],
                        [6e-11, 1.86021237763, 96471.5234129578],
                        [6e-11, 1.44535366888, 20043.6745601988],
                        [6e-11, 1.48244229587, 260349.340450647],
                        [6e-11, 1.00031747475, 51538.8100111242],
                        [5e-11, 0.08842088266, 79859.8958670072],
                        [6e-11, 2.17116807817, 156373.64003896],
                        [7e-11, 2.57540094308, 77218.554588535],
                        [6e-11, 4.66124811472, 65717.2274856396],
                        [5e-11, 5.69376389474, 52400.1510788503],
                        [6e-11, 2.47972848111, 266540.363464894],
                        [5e-11, 4.47086994598, 27360.5841672014],
                        [5e-11, 3.20880924837, 259769.652863649],
                        [5e-11, 3.98361684334, 54862.5283776896],
                        [7e-11, 2.86077141334, 179172.747046054],
                        [5e-11, 2.46087822928, 156681.19765993],
                        [7e-11, 5.00361119157, 209762.607062783],
                        [5e-11, 5.35670104895, 26513.8119180882],
                        [6e-11, 3.62607025643, 27883.1615852952],
                        [5e-11, 0.80991017339, 25661.9943650602],
                        [6e-11, 0.20069428083, 50490.7541606468],
                        [5e-11, 3.77056538505, 164407.508002784],
                        [5e-11, 2.71005052987, 104427.878637572],
                        [6e-11, 0.84754795471, 104466.051854982],
                        [5e-11, 2.69389382491, 180496.558130641],
                        [5e-11, 4.04820376371, 129277.041003463],
                        [6e-11, 0.5782905701, 50600.9604818662],
                        [6e-11, 4.21216601811, 182595.65223012],
                        [5e-11, 3.59670550074, 131072.299447184],
                        [5e-11, 0.08842684725, 27993.3679065146],
                        [6e-11, 0.00392034365, 73891.8330579484],
                        [6e-11, 4.68979746906, 26149.6291163144],
                        [5e-11, 4.61789756581, 20894.5360827764],
                        [5e-11, 3.5709323278, 53654.6728572128],
                        [5e-11, 0.36682731238, 146505.581569346],
                        [5e-11, 1.4054582464, 233202.055378884],
                        [6e-11, 2.35439456378, 139543.422701989],
                        [4e-11, 1.28935961583, 234364.530083292],
                        [4e-11, 1.10749672173, 51086.0974919548],
                        [5e-11, 3.64294402198, 27331.3907432526],
                        [4e-11, 0.00216060134, 213255.178629652],
                        [4e-11, 4.40507427126, 129483.2265519],
                        [4e-11, 2.18529936793, 23384.2869868986],
                        [5e-11, 0.93391333656, 52102.5091572894],
                        [4e-11, 2.33941435272, 23389.451694197],
                        [4e-11, 3.59370682931, 46564.4708559004],
                        [4e-11, 2.90835831307, 61299.3830381658],
                        [4e-11, 6.27884818175, 170068.840051936],
                        [4e-11, 4.90170477242, 104888.417078392],
                        [4e-11, 4.56426377076, 46131.577701773],
                        [5e-11, 2.12658067178, 130542.60848209],
                        [5e-11, 2.50519016528, 79845.6687730056],
                        [4e-11, 6.24881318031, 18073.7049386502],
                        [4e-11, 1.10868110225, 52072.0240945678],
                        [4e-11, 6.14515791357, 34102.1013444982],
                        [4e-11, 2.9409789397, 129902.711195776],
                        [4e-11, 2.91542426579, 130215.170912169],
                        [5e-11, 2.2014651331, 82865.6595436856],
                        [5e-11, 4.46570663623, 104237.173277612],
                        [4e-11, 5.1333479743, 26387.0295358434],
                        [4e-11, 5.34965278511, 24787.0763233692],
                        [4e-11, 4.17772291197, 53132.095439119],
                        [4e-11, 2.66996288682, 25572.4392704812],
                        [5e-11, 1.14175711692, 188898.397841011],
                      ],
          },
          {
            series => "L1",
            terms  => [
                        [26088.1470622275, 0, 0],
                        [0.01126007832, 6.21703970996, 26087.9031415742],
                        [0.00303471395, 3.05565472363, 52175.8062831484],
                        [0.00080538452, 6.10454743366, 78263.7094247226],
                        [0.00021245035, 2.83531934452, 104351.612566297],
                        [5.592094e-05, 5.82675673328, 130439.515707871],
                        [1.472233e-05, 2.51845458395, 156527.418849445],
                        [3.52244e-06, 3.05238094403, 1109.3785520934],
                        [3.88318e-06, 5.48039225891, 182615.321991019],
                        [9.354e-07, 6.11791163931, 27197.2816936676],
                        [9.0579e-07, 0.00045481669, 24978.5245894808],
                        [1.02743e-06, 2.14879173777, 208703.225132594],
                        [5.1941e-07, 5.62107554052, 5661.3320491522],
                        [4.437e-07, 4.57348500464, 25028.521211385],
                        [2.807e-07, 3.04195430989, 51066.427731055],
                        [2.2003e-07, 0.86475371243, 955.5997416086],
                        [2.7295e-07, 5.09210138837, 234791.128274168],
                        [2.0425e-07, 3.71509622702, 20426.571092422],
                        [2.0221e-07, 0.51934047295, 21535.9496445154],
                        [1.7496e-07, 5.7266360862, 4551.9534970588],
                        [1.668e-07, 1.35134428173, 529.6909650946],
                        [1.5306e-07, 1.79184360652, 11322.6640983044],
                        [1.5398e-07, 5.74263453989, 19.66976089979],
                        [1.3964e-07, 3.59426938083, 24498.8302462904],
                        [1.2822e-07, 2.69591798562, 53285.1848352418],
                        [1.2621e-07, 3.89530641889, 3.881335358],
                        [1.2566e-07, 4.70537436663, 1059.3819301892],
                        [7.974e-08, 4.17682324505, 26617.5941066688],
                        [7.929e-08, 0.50426804318, 46514.4742339962],
                        [8.024e-08, 3.92723313702, 27043.5028831828],
                        [7.665e-08, 2.48158305355, 57837.1383323006],
                        [8.639e-08, 6.06360282793, 77154.3308726292],
                        [6.838e-08, 2.77387065312, 7.1135470008],
                        [6.554e-08, 5.53478998989, 6770.7106012456],
                        [5.846e-08, 4.281396598, 16983.9961474566],
                        [7.285e-08, 1.74581868954, 260879.031415742],
                        [7.179e-08, 2.97766079692, 2218.7571041868],
                        [6.364e-08, 2.1380561938, 25132.3033999656],
                        [5.883e-08, 2.19545230409, 13521.7514415914],
                        [4.969e-08, 2.4775213418, 30639.856638633],
                        [4.578e-08, 1.55845855383, 27147.2850717634],
                        [4.857e-08, 4.84757952324, 37410.5672398786],
                        [5.022e-08, 3.94124675992, 25661.3049506982],
                        [4.381e-08, 4.94471456712, 213.299095438],
                        [4.211e-08, 5.53886788148, 83925.0414738748],
                        [4.299e-08, 5.09070560802, 10213.285546211],
                        [4.593e-08, 0.81920676333, 25558.2121764796],
                        [3.571e-08, 2.34341884629, 32858.6137428198],
                        [4.454e-08, 5.7915915618, 3442.5749449654],
                        [3.547e-08, 3.59413896239, 26068.2333806744],
                        [3.664e-08, 1.39952931281, 77204.3274945334],
                        [3.417e-08, 0.49855041138, 22645.3281966088],
                        [3.195e-08, 1.25743024246, 14765.2390432698],
                        [3.031e-08, 4.45207030477, 7238.6755916],
                        [3.284e-08, 5.22996707635, 25448.0058552602],
                        [2.974e-08, 0.14234349726, 50586.7333878646],
                        [2.855e-08, 0.67083991526, 26091.7844769322],
                        [2.773e-08, 3.54351198199, 72602.3773755704],
                        [3.132e-08, 6.21365344759, 26080.7895945734],
                        [2.732e-08, 5.64171761904, 1589.0728952838],
                        [2.652e-08, 0.88219699366, 52705.497248243],
                        [3.125e-08, 6.07160751766, 28306.660245761],
                        [2.799e-08, 2.51152391376, 26107.572902474],
                        [2.403e-08, 1.1551513036, 25035.6347583858],
                        [2.274e-08, 1.85167073193, 36301.1886877852],
                        [2.501e-08, 4.34723465048, 41962.5207369374],
                        [2.321e-08, 5.44262378304, 26084.0218062162],
                        [2.535e-08, 5.80101392346, 26095.016688575],
                        [2.872e-08, 1.63503968499, 25021.4076643842],
                        [2.066e-08, 1.0723184563, 43071.8992890308],
                        [2.616e-08, 2.78322243283, 103242.234014203],
                        [1.987e-08, 2.95923214706, 23969.1392811958],
                        [1.979e-08, 4.44092591248, 103292.230636108],
                        [1.974e-08, 0.83681704901, 12566.1516999828],
                        [1.7e-08, 2.28603732736, 110012.944615449],
                        [1.677e-08, 4.63366122462, 53235.1882133376],
                        [1.954e-08, 4.67733727976, 286966.934557316],
                        [1.653e-08, 1.25518276011, 33326.5787331742],
                        [1.785e-08, 1.80830270808, 26301.2022370122],
                        [1.784e-08, 5.17926273269, 426.598190876],
                        [2.143e-08, 5.16312278245, 51220.2065415398],
                        [1.597e-08, 5.53494401703, 56727.7597802072],
                        [1.59e-08, 0.07660134798, 23869.1460373874],
                        [1.574e-08, 3.7587058637, 73711.7559276638],
                        [1.362e-08, 1.13830507985, 68050.4238785116],
                        [1.358e-08, 1.45317020242, 51646.1153180538],
                        [1.586e-08, 4.65681044624, 79373.087976816],
                        [1.347e-08, 3.80254397382, 19317.1925403286],
                        [1.242e-08, 3.79389911401, 25874.6040461362],
                        [1.124e-08, 1.28920904043, 31749.2351907264],
                        [1.065e-08, 4.31416942177, 40853.142184844],
                        [1.014e-08, 3.58126441973, 48733.231338183],
                        [1.259e-08, 1.73130656223, 12432.0426503978],
                        [9.89e-09, 0.33276224293, 52156.1365222486],
                        [1.057e-08, 4.35251408825, 77734.018459628],
                        [1.033e-08, 3.72503880786, 6283.0758499914],
                        [8.94e-09, 0.29768279333, 105460.99111839],
                        [9.1e-09, 0.49823258962, 99799.659069238],
                        [9.99e-09, 5.29812267938, 65697.5577247398],
                        [1.138e-08, 2.56391312022, 29530.4780865396],
                        [8.76e-09, 4.91112286703, 62389.0918293594],
                        [9.12e-09, 0.27449857787, 98690.2805171446],
                        [8.79e-09, 4.78847722011, 18849.2275499742],
                        [8.69e-09, 3.87957425954, 78793.4003898172],
                        [8.31e-09, 2.35459129726, 27676.976036858],
                        [7.91e-09, 1.17444825871, 129380.133777682],
                        [7.82e-09, 3.92653768734, 38654.054841557],
                        [7.82e-09, 3.69412482234, 52179.6876185064],
                        [7.45e-09, 2.09648894863, 51535.9089968344],
                        [7.36e-09, 6.05470921559, 114.43928868521],
                        [7.33e-09, 3.2301997832, 47623.8527860896],
                        [6.98e-09, 2.99026308247, 52168.6927361476],
                        [7.8e-09, 5.77004504059, 129330.137155778],
                        [7.52e-09, 4.22525357653, 51123.53789996],
                        [7.52e-09, 4.70099207936, 51109.3108059584],
                        [6.51e-09, 5.87383050095, 2333.196392872],
                        [6.99e-09, 4.82823185979, 38519.945791972],
                        [6.56e-09, 3.65375726729, 25668.418497699],
                        [6.6e-09, 1.98037689941, 26514.5013324502],
                        [8.08e-09, 6.27898737551, 53131.406024757],
                        [7.53e-09, 5.64446551994, 45892.730433157],
                        [6.1e-09, 1.21194007471, 153.7788104848],
                        [6.04e-09, 5.29267380518, 136100.847757023],
                        [8.11e-09, 4.22885181263, 25654.1914036974],
                        [6.97e-09, 1.89331617498, 77308.109683114],
                        [5.81e-09, 2.61707271637, 76674.6365294388],
                        [5.49e-09, 4.18661776549, 94138.3270200858],
                        [5.67e-09, 6.08785859254, 25234.7067598222],
                        [5.49e-09, 2.08003708209, 91785.460866314],
                        [5.63e-09, 1.38660458, 79323.0913549118],
                        [5.27e-09, 5.83448542494, 50057.04242277],
                        [5.24e-09, 2.45745967369, 467.9649903544],
                        [5.7e-09, 3.1042551371, 15874.6175953632],
                        [6.99e-09, 2.57322536922, 52182.9198301492],
                        [5.01e-09, 0.39578180187, 32370.9789915656],
                        [5.42e-09, 2.77109053528, 54394.5633873352],
                        [5.25e-09, 1.31791713133, 313054.83769889],
                        [5.13e-09, 2.28640740711, 82815.6629217814],
                        [5.79e-09, 5.45103833735, 52195.4760440482],
                        [6.17e-09, 4.18395572588, 639.897286314],
                        [4.49e-09, 3.10044122691, 49957.0491789616],
                        [4.95e-09, 2.11807671869, 52171.9249477904],
                        [4.31e-09, 3.0671483672, 131548.894259964],
                        [4.27e-09, 5.353673111, 49.9966219042],
                        [4.7e-09, 1.46585019834, 1066.49547719],
                        [4.7e-09, 1.0748559576, 103821.921601202],
                        [4.15e-09, 2.50109134151, 71980.6335747312],
                        [3.95e-09, 5.24320159822, 58946.516884394],
                        [4.08e-09, 0.92030240581, 77837.1112338466],
                        [5.23e-09, 4.9239008231, 52389.1053785864],
                        [3.77e-09, 3.50882025297, 125887.562210812],
                        [5.08e-09, 1.03838633466, 24491.7166992896],
                        [4.18e-09, 0.36439379673, 51962.5071877104],
                        [4e-09, 3.51557589073, 20760.4270331914],
                        [3.59e-09, 0.03091967859, 2118.7638603784],
                        [3.56e-09, 2.03727281128, 1052.2683831884],
                        [4.23e-09, 4.2143754624, 18093.37469955],
                        [3.4e-09, 1.64349471632, 79219.3091663312],
                        [3.36e-09, 1.55276786593, 24505.9437932912],
                        [3.48e-09, 1.06528227311, 66941.0453264182],
                        [3.27e-09, 5.45093694594, 7880.08915333899],
                        [3.03e-09, 1.67537340603, 88476.9949709336],
                        [3.23e-09, 5.59204872298, 55618.3812281138],
                        [2.81e-09, 0.83478570176, 63498.4703814528],
                        [3.93e-09, 0.55222046684, 45405.0956819028],
                        [2.8e-09, 0.69995179262, 64741.9579831312],
                        [3.81e-09, 2.16540447546, 522.5774180938],
                        [2.79e-09, 4.17319236859, 155468.036919256],
                        [3.14e-09, 1.52755129973, 44937.1306915484],
                        [2.8e-09, 3.33549459014, 78244.0396638228],
                        [2.72e-09, 5.34763989826, 53764.8791784322],
                        [2.87e-09, 4.98400171694, 25551.0986294788],
                        [2.88e-09, 3.26773464056, 124778.183658719],
                        [2.75e-09, 0.59220058467, 104881.303531391],
                        [2.29e-09, 5.07700202235, 52602.4044740244],
                        [2.65e-09, 1.04033681288, 25938.3399444396],
                        [2.24e-09, 5.1072681918, 117873.364007888],
                        [2.42e-09, 0.44760602599, 23754.7067487022],
                        [2.14e-09, 3.50460190598, 58458.8821331398],
                        [2.3e-09, 2.45937674101, 155418.040297352],
                        [2.11e-09, 3.92377004339, 103925.014375421],
                        [2.82e-09, 3.81265243625, 536.8045120954],
                        [2.18e-09, 4.88963285925, 103396.012824688],
                        [2e-09, 5.41573374322, 16066.0658614748],
                        [2.18e-09, 0.41409439248, 78267.5907600806],
                        [2.01e-09, 2.38235635877, 23439.4483161012],
                        [2.03e-09, 2.69458032262, 59414.4818747484],
                        [1.96e-09, 0.92807787406, 120226.23016166],
                        [2.01e-09, 2.00560473829, 162188.750898597],
                        [1.83e-09, 3.83128433173, 69159.802430605],
                        [1.8e-09, 2.20428238305, 89586.373523027],
                        [2.15e-09, 5.3565209661, 206.1855484372],
                        [1.78e-09, 1.24568538055, 103.0927742186],
                        [1.96e-09, 0.44564203205, 51756.3216392732],
                        [1.83e-09, 2.88003872828, 3328.13565628019],
                        [2.16e-09, 4.48180965712, 26241.681952059],
                        [2.15e-09, 2.26752450953, 33967.9922949132],
                        [1.93e-09, 4.34407767816, 105307.212307905],
                        [2e-09, 1.01165813281, 51742.0945452716],
                        [1.7e-09, 5.57003076622, 98068.5367163054],
                        [2.24e-09, 0.97932137082, 77211.4410415342],
                        [1.68e-09, 5.96360976147, 157636.797401539],
                        [1.78e-09, 1.42319344949, 77197.2139475326],
                        [1.96e-09, 5.59654497318, 78270.8229717234],
                        [1.61e-09, 5.51918174079, 26555.8681319286],
                        [1.97e-09, 4.79975858562, 25455.119402261],
                        [1.81e-09, 4.3998767997, 105410.994496486],
                        [1.59e-09, 2.63928704121, 28421.0995344462],
                        [1.58e-09, 0.75224521142, 51116.4243529592],
                        [1.96e-09, 4.92493608061, 102762.539671013],
                        [1.62e-09, 2.82561928047, 26202.3424302594],
                        [1.94e-09, 1.02167898855, 44181.2778411242],
                        [1.79e-09, 5.11561177302, 25440.8923082594],
                        [1.52e-09, 5.21934955501, 77623.8121384086],
                        [1.5e-09, 5.98491689335, 78256.5958777218],
                        [1.84e-09, 0.26375114604, 419.4846438752],
                        [1.44e-09, 2.9065729497, 51322.6099013964],
                        [1.63e-09, 1.01728531879, 26727.8004278882],
                        [1.6e-09, 1.39225289207, 26011.6370702986],
                        [1.45e-09, 5.76503611587, 80482.4665289094],
                        [1.4e-09, 0.27227514908, 46848.3301747656],
                        [1.36e-09, 0.22641179921, 151975.465352386],
                        [1.42e-09, 4.24343923379, 339142.740840465],
                        [1.78e-09, 4.08547287819, 129909.824742776],
                        [1.42e-09, 3.31130337074, 78050.4103292846],
                        [1.31e-09, 0.70125733168, 3340.6124266998],
                        [1.54e-09, 1.72826405606, 78477.0085201606],
                        [1.59e-09, 5.29643521725, 108903.566063356],
                        [1.29e-09, 3.26743532785, 25973.463852889],
                        [1.28e-09, 6.10775258657, 76044.9523205358],
                        [1.44e-09, 4.06091644657, 50579.6198408638],
                        [1.64e-09, 6.17696810226, 19406.6782881746],
                        [1.39e-09, 5.11979950242, 433.7117378768],
                        [1.53e-09, 1.30046862259, 13655.8604911764],
                        [1.32e-09, 5.23445066335, 26610.480559668],
                        [1.15e-09, 4.6184579377, 50593.8469348654],
                        [1.21e-09, 2.52027376421, 76144.9455643442],
                        [1.14e-09, 4.51555533683, 27154.3986187642],
                        [1.06e-09, 5.18068866237, 85502.3850163226],
                        [1.1e-09, 3.45757703411, 25565.3257234804],
                        [1e-09, 0.11496600894, 74821.1344797572],
                        [1e-09, 3.95989644984, 26037.90651967],
                        [1e-09, 3.0153538215, 28206.6670019526],
                        [9.9e-10, 5.99257260255, 29416.0387978544],
                        [1.17e-09, 3.56597928882, 71492.998823477],
                        [1.31e-09, 5.96070215452, 1223.81784077861],
                        [9.5e-10, 1.840657503, 85034.4200259682],
                        [1.02e-09, 4.69459571654, 114564.898112508],
                        [9.7e-10, 0.87353840441, 181555.94006083],
                        [1.18e-09, 2.02298794976, 78283.3791856224],
                        [1.11e-09, 4.0731622796, 93028.9484679924],
                        [9e-10, 5.01726237192, 115674.276664601],
                        [9.4e-10, 2.31806507832, 81706.284369688],
                        [8.9e-10, 5.94413487088, 25131.6139856036],
                        [9.5e-10, 3.7229989459, 90829.8611247054],
                        [1.2e-09, 5.44384753792, 51749.2080922724],
                        [1.05e-09, 5.01803826552, 78259.8280893646],
                        [8.6e-10, 1.83551544255, 143961.267149462],
                        [1.08e-09, 4.53825443085, 71025.0338331226],
                        [8.3e-10, 0.64015893446, 130012.917516995],
                        [9.9e-10, 0.52218556269, 26624.7076536696],
                        [9.4e-10, 2.65386396812, 9103.9069941176],
                        [9.8e-10, 3.3148017225, 853.196381752],
                        [8e-10, 2.13424472361, 42153.969003049],
                        [8.6e-10, 2.05760695844, 79852.7823200064],
                        [8.4e-10, 0.97023030623, 131395.11544948],
                        [8.1e-10, 0.28916970825, 84546.785274714],
                        [8.1e-10, 5.18614814481, 220.4126424388],
                        [8.1e-10, 1.98383157756, 149.5631971346],
                        [8.2e-10, 0.05817684667, 104331.942805397],
                        [7.4e-10, 1.62836007935, 25984.8103673556],
                        [7.5e-10, 1.84245188133, 78690.3076155986],
                        [8.7e-10, 3.5863485536, 130969.206672966],
                        [7.4e-10, 5.06505616563, 27140.1715247626],
                        [7.5e-10, 5.47760610876, 134.109049585],
                        [8.9e-10, 6.25587801019, 150866.086800293],
                        [9.8e-10, 4.71698591369, 12725.453434775],
                        [6.9e-10, 5.05822197567, 1911.1994832172],
                        [8.1e-10, 2.05307563846, 1596.1864422846],
                        [7.5e-10, 2.05688075943, 26137.8997634784],
                        [6.9e-10, 3.67576176321, 24609.0365675098],
                        [8.1e-10, 1.38060133126, 52329.5850936332],
                        [6.9e-10, 1.60181551296, 129483.915966262],
                        [6.7e-10, 5.43668176629, 181505.943438926],
                        [6.6e-10, 1.56953438995, 19804.8272915828],
                        [6.6e-10, 3.92553131581, 146314.133303234],
                        [6.2e-10, 3.46967694133, 24925.4284371664],
                        [7.9e-10, 3.56674606057, 49842.6098902764],
                        [6.7e-10, 4.76959706409, 25881.717593137],
                        [6.1e-10, 2.61995550094, 183724.700543113],
                        [6.1e-10, 1.63344766876, 13541.4212024912],
                        [6.1e-10, 2.31153135385, 124156.43985788],
                        [5.8e-10, 3.88678278617, 18207.8139882352],
                        [8.2e-10, 1.36242531494, 128850.442812587],
                        [5.8e-10, 2.9899017915, 110.2063212194],
                        [6.4e-10, 4.98131448153, 188276.654040172],
                        [6.7e-10, 2.32849722473, 26294.0886900114],
                        [5.7e-10, 3.72454115593, 29428.515568274],
                        [6.6e-10, 1.69869503126, 51543.0225438352],
                        [5.5e-10, 2.30093263701, 52643.7712735028],
                        [6.9e-10, 1.78774826271, 51639.001771053],
                        [6.7e-10, 4.00863968986, 103299.344183108],
                        [7.4e-10, 6.14089486388, 14477.3511832],
                        [5.4e-10, 5.27646510692, 49527.3514576754],
                        [5.6e-10, 2.3349562066, 104358.726113298],
                        [6.2e-10, 3.41967311766, 104355.493901655],
                        [5e-10, 1.20854390978, 23976.2528281966],
                        [6.4e-10, 0.58512976749, 307.5576209696],
                        [6.2e-10, 3.6924578516, 641.41356173899],
                        [6.2e-10, 4.47317710621, 636.9962720242],
                        [4.9e-10, 4.09291926847, 52815.7035694624],
                        [6.1e-10, 0.78849475911, 155997.727884351],
                        [4.7e-10, 2.1465925461, 7994.5284420242],
                        [4.7e-10, 0.00507866085, 104138.313470859],
                        [4.5e-10, 2.28588893693, 25764.3977249168],
                        [5.1e-10, 2.98348805265, 40565.2543247742],
                        [4.7e-10, 4.03957254582, 77829.9976868458],
                        [4.7e-10, 3.21862563103, 178063.368493961],
                        [4.5e-10, 4.41401819607, 103285.117089107],
                        [5.4e-10, 3.47879330948, 77844.2247808474],
                        [5.4e-10, 2.83659707386, 6681.2248533996],
                        [5.6e-10, 1.11360360738, 131498.89763806],
                        [4.6e-10, 3.38384624666, 26507.3877854494],
                        [5.5e-10, 2.68637168389, 25934.1243310894],
                        [4.6e-10, 4.78696197215, 104564.911661735],
                        [5.9e-10, 1.2987910069, 38813.3565763492],
                        [4.3e-10, 3.86025201636, 10021.8372800994],
                        [4.4e-10, 1.90320971624, 51528.7954498336],
                        [5.5e-10, 0.4833507954, 23962.025734195],
                        [4.2e-10, 4.11693586607, 26190.9959157928],
                        [4.4e-10, 1.64247485835, 76.2660712756],
                        [4.2e-10, 6.21848377968, 26094.5317004742],
                        [4.1e-10, 2.73996884659, 25867.4904991354],
                        [4.3e-10, 0.38981425968, 1089.7087911936],
                        [4.3e-10, 4.89046790101, 24395.7374720718],
                        [4.1e-10, 0.44351702671, 25619.9381512198],
                        [4.1e-10, 1.47439583353, 76681.7500764396],
                        [3.9e-10, 1.71519867865, 111590.288157897],
                        [4.1e-10, 5.67594181048, 54509.0026760204],
                        [4.9e-10, 1.65739950579, 1581.959348283],
                        [4e-10, 1.85008425708, 27999.1026247914],
                        [3.8e-10, 3.99668572981, 9384.8410080752],
                        [3.7e-10, 2.83147987268, 102132.85546211],
                        [3.9e-10, 0.84546566819, 365230.643982039],
                        [3.7e-10, 4.65200082367, 90695.7520751204],
                        [3.7e-10, 0.94736176192, 76667.522982438],
                        [4e-10, 0.16806354899, 22759.767485294],
                        [4.9e-10, 2.02480943113, 134991.46920493],
                        [4.1e-10, 5.85592543833, 52290.2455718336],
                        [4e-10, 1.214911274, 64607.8489335462],
                        [4.1e-10, 3.07842612799, 26081.2745826742],
                        [3.5e-10, 3.89800430981, 157483.018591054],
                        [3.7e-10, 0.29068345666, 97580.9019650512],
                        [3.5e-10, 4.74965057267, 39629.3243440654],
                        [3.5e-10, 1.88777425098, 26521.614879451],
                        [3.3e-10, 3.60227423859, 156100.820658569],
                        [3.5e-10, 1.9611419157, 74.7815985673],
                        [4.5e-10, 3.72467663437, 39609.6545831656],
                        [3.8e-10, 4.29218444251, 39743.7636327506],
                        [3.2e-10, 5.95900501016, 77410.5130429706],
                        [3.2e-10, 0.64794221724, 2648.454825473],
                        [3.9e-10, 5.08510962281, 25863.5583458723],
                        [3.1e-10, 1.62486752727, 141762.179806175],
                        [3.1e-10, 1.25910229689, 53242.3017603384],
                        [3.1e-10, 2.65918037491, 104344.499019296],
                        [3.2e-10, 0.00169740803, 52061.3669944632],
                        [3.1e-10, 6.12210016938, 25977.6968203548],
                        [3e-10, 5.72239820341, 579.6875869988],
                        [3e-10, 0.7055331987, 52125.8096612442],
                        [3.9e-10, 1.60801806885, 333.8559407694],
                        [3e-10, 5.28578152795, 102232.848705918],
                        [2.9e-10, 0.53270948692, 50696.939709084],
                        [2.9e-10, 0.40281274949, 35472.7441496494],
                        [2.8e-10, 2.96171859812, 100909.037621331],
                        [3.4e-10, 1.41428136641, 140652.801254082],
                        [2.9e-10, 6.00401578551, 54294.5701435268],
                        [3.2e-10, 0.45221016093, 116917.76426628],
                        [2.8e-10, 5.0708896171, 26237.4663387088],
                        [2.8e-10, 5.33382835025, 107794.187511262],
                        [3e-10, 3.86080757411, 207643.843202404],
                        [2.8e-10, 4.81897403543, 170049.170291037],
                        [3.1e-10, 1.90989851759, 26308.315784013],
                        [3.5e-10, 1.26114015069, 97112.9369746968],
                        [2.8e-10, 2.01146788563, 52698.3837012422],
                        [3.3e-10, 4.31496976407, 154938.345954161],
                        [2.8e-10, 4.4678187573, 78417.4882352074],
                        [3.3e-10, 0.25034815279, 51653.2288650546],
                        [2.6e-10, 0.07835049738, 51013.3315787406],
                        [2.9e-10, 3.32582529322, 110634.688416288],
                        [2.7e-10, 6.01993388409, 25227.5932128214],
                        [3.6e-10, 0.79025288269, 119116.851609567],
                        [2.6e-10, 4.68624143375, 632.7837393132],
                        [2.7e-10, 1.14521834701, 121335.608713753],
                        [2.5e-10, 3.42095174931, 956.2891559706],
                        [2.8e-10, 2.73386270717, 27311.7209823528],
                        [2.4e-10, 0.82215620694, 314.1861798696],
                        [2.5e-10, 5.21681600178, 25241.820306823],
                        [2.5e-10, 3.57372833543, 52712.6107952438],
                        [2.7e-10, 5.05183520711, 105940.685461581],
                        [3.1e-10, 2.25462520789, 26720.6868808874],
                        [2.5e-10, 4.86890931082, 104778.210757173],
                        [2.3e-10, 3.01659387998, 52182.4348420484],
                        [2.6e-10, 2.13973174244, 103711.715279983],
                        [2.3e-10, 4.60383496965, 52072.7135089298],
                        [2.3e-10, 4.55605691468, 155571.819107837],
                        [2.2e-10, 3.69622699918, 735.8765135318],
                        [2.3e-10, 2.40544682432, 8194.2753332086],
                        [2.2e-10, 2.44094101414, 2703.6161546756],
                        [2.7e-10, 5.29221944987, 26162.6847401415],
                        [2.2e-10, 4.11517024183, 19202.7532516434],
                        [2.9e-10, 4.25385019536, 647.0108333148],
                        [2.1e-10, 2.11851790816, 207593.8465805],
                        [2.9e-10, 2.91003553544, 176953.989941867],
                        [2.6e-10, 5.68398596586, 95247.7055721792],
                        [2.1e-10, 5.29289519906, 150244.342999454],
                        [2.4e-10, 3.05210539174, 130419.845946971],
                        [2e-10, 2.54144132983, 51219.5171271778],
                        [2e-10, 6.1640195918, 35191.8101356918],
                        [2.2e-10, 3.22920342008, 1083.0802322936],
                        [2.8e-10, 0.30709453091, 157057.10981454],
                        [2.3e-10, 1.65280537431, 214364.557181746],
                        [2.7e-10, 3.72484040647, 621.7438008392],
                        [2.3e-10, 2.59065413623, 71582.484571323],
                        [2.2e-10, 0.94588004362, 52022.0274726636],
                        [2e-10, 3.8477679682, 5327.4761083828],
                        [2.4e-10, 4.82779429778, 104371.282327197],
                        [1.9e-10, 1.94368317235, 22747.2907148744],
                        [2.3e-10, 3.19739923216, 6044.2285813754],
                        [2e-10, 0.58967836529, 172402.036444808],
                        [1.9e-10, 2.73169091081, 55503.9419394286],
                        [1.8e-10, 1.63099638721, 48835.1938564486],
                        [2.2e-10, 1.62646807429, 104347.731230939],
                        [1.8e-10, 4.90435895585, 77630.9256854094],
                        [1.8e-10, 0.59687432455, 183570.921732628],
                        [2.4e-10, 5.58828197916, 34282.1784747828],
                        [1.8e-10, 5.54856348293, 209812.603684687],
                        [1.9e-10, 0.53136209334, 55516.4187098482],
                        [2e-10, 0.73777252741, 129387.247324683],
                        [2.1e-10, 4.62446809035, 13362.4497067992],
                        [2.1e-10, 1.94768946886, 487.6347512542],
                        [1.9e-10, 4.18946427203, 78114.146227588],
                        [2.3e-10, 2.43977160852, 24822.3356629478],
                        [1.7e-10, 2.24086275048, 26222.0121911592],
                        [1.8e-10, 5.08348808758, 27684.0895838588],
                        [1.7e-10, 4.31062701282, 50064.1559697708],
                        [1.7e-10, 0.6271358155, 44295.7171298094],
                        [2.2e-10, 0.09847423078, 26941.0995233262],
                        [1.9e-10, 2.09224104001, 86143.7985780616],
                        [1.6e-10, 0.43713509764, 101.9625182656],
                        [1.6e-10, 4.27219175799, 24176.703658357],
                        [1.8e-10, 5.24040005379, 68241.8721446232],
                        [2e-10, 5.09682447452, 60055.8954364874],
                        [1.6e-10, 4.08590900542, 147423.511855328],
                        [1.8e-10, 2.12913862198, 106570.369670484],
                        [1.6e-10, 1.0066838715, 25138.7275326044],
                        [1.6e-10, 5.76419504418, 14.2270940016],
                        [2.1e-10, 6.16511987091, 52169.1777242484],
                        [1.6e-10, 0.82798074394, 96357.0841242726],
                        [1.6e-10, 3.75399093257, 159.3017347922],
                        [1.7e-10, 4.95698248546, 52225.8029050526],
                        [1.7e-10, 6.11461465994, 26198.1094627936],
                        [1.7e-10, 6.19302565011, 204151.271635535],
                        [1.7e-10, 5.34573358099, 78731.674415077],
                        [1.6e-10, 1.90468795194, 128320.751847493],
                        [1.7e-10, 3.73180335896, 182085.631025925],
                        [1.7e-10, 5.86222137701, 32132.1317229496],
                        [1.9e-10, 1.56034038551, 51969.6207347112],
                        [1.8e-10, 2.5408624212, 25780.3455206046],
                        [1.5e-10, 4.29267057949, 1692.1656695024],
                        [1.6e-10, 1.75865740707, 53228.0746663368],
                        [2e-10, 2.35700883433, 75615.2545992496],
                        [1.5e-10, 5.29296109539, 130446.629254872],
                        [1.4e-10, 0.85174293693, 78903.6067110366],
                        [1.5e-10, 5.50776870695, 52808.5900224616],
                        [1.7e-10, 5.96622721781, 32769.1279949738],
                        [1.4e-10, 5.40589812318, 52381.9918315856],
                        [1.4e-10, 2.92783624754, 130226.216612433],
                        [1.4e-10, 4.73334676783, 26164.1692128498],
                        [1.8e-10, 4.09540263999, 157586.800779634],
                        [1.5e-10, 5.00568645183, 28791.5192962498],
                        [1.3e-10, 0.88297787282, 24292.6446978532],
                        [1.8e-10, 0.07544318179, 2199.087343287],
                        [1.4e-10, 0.39198838648, 1162.4747044078],
                        [1.2e-10, 4.87283902225, 64901.2597179234],
                        [1.3e-10, 4.28417448099, 23866.0465069772],
                        [1.3e-10, 3.77892895408, 391318.547123613],
                        [1.2e-10, 0.90287358387, 104202.049369162],
                        [1.2e-10, 1.68139724364, 72936.2333163398],
                        [1.5e-10, 3.7610819499, 111122.323167542],
                        [1.2e-10, 1.82629728829, 22909.7573510066],
                        [1.3e-10, 1.25451832397, 26724.8994135984],
                        [1.2e-10, 5.74844907374, 97670.3877128972],
                        [1.2e-10, 1.52451201886, 130652.814803309],
                        [1.1e-10, 5.30694474936, 24601.923020509],
                        [1.4e-10, 2.82065667408, 1639.069517188],
                        [1.5e-10, 4.79144654769, 77726.9049126272],
                        [1.3e-10, 5.37369194634, 8989.46770543239],
                        [1.3e-10, 3.84042504901, 25953.7940919892],
                        [1.5e-10, 0.08558342266, 130443.397043229],
                        [1.1e-10, 5.16135808879, 233681.749722074],
                        [1.2e-10, 0.99700192092, 65831.6667743248],
                        [1.2e-10, 4.51508367315, 78187.443353447],
                        [1.2e-10, 0.62022460619, 36109.7404216736],
                        [1.1e-10, 1.08182792, 129373.020230681],
                        [1.4e-10, 5.59428027773, 25446.4895798352],
                        [1.1e-10, 4.68045355937, 74923.0969980228],
                        [1.4e-10, 4.68060965317, 27669.8624898572],
                        [1.2e-10, 4.91061349082, 54087.0057663656],
                        [1e-10, 0.73914692842, 103917.90082842],
                        [1.3e-10, 4.96538793287, 161079.372346504],
                        [1.1e-10, 0.31330958005, 182188.723800143],
                        [1.3e-10, 3.74649756573, 145204.754751141],
                        [1e-10, 1.79124533717, 949.1756089698],
                        [1e-10, 4.24347093551, 78109.9306142378],
                        [1e-10, 1.22394899357, 104505.391376782],
                        [1.2e-10, 3.21001019103, 102018.416173425],
                        [1.1e-10, 4.48294709049, 102769.653218014],
                        [1e-10, 4.33936275875, 95.9792272178],
                        [1e-10, 3.73409843943, 199599.318138476],
                        [1.2e-10, 6.08780023115, 25450.90686955],
                        [1.2e-10, 0.52219299955, 125112.039599488],
                        [1.2e-10, 3.12928292612, 11610.5519583742],
                        [1.3e-10, 2.59745313501, 78378.1487134078],
                        [1e-10, 0.95664142687, 45290.6563932176],
                        [1.1e-10, 3.04942272888, 309.2783226558],
                        [1.2e-10, 3.42470973506, 143005.667407854],
                        [9e-11, 5.24571653547, 34082.4315835984],
                        [1.2e-10, 1.94632930172, 1135.6768718932],
                        [1e-10, 2.75654212398, 103.7821885806],
                        [1e-10, 6.06089846081, 78270.3379836226],
                        [9e-11, 1.42295924162, 12546.481939083],
                        [9e-11, 5.2388907902, 160.40736938481],
                        [1e-10, 1.77339719648, 25754.0472008048],
                        [1.1e-10, 3.45444324976, 27177.6119327678],
                        [1e-10, 2.40808781707, 3462.2447058652],
                        [1.2e-10, 0.211155779, 103932.127922422],
                        [1e-10, 0.44397528833, 26729.3167033132],
                        [9e-11, 4.39355955971, 224.3447957019],
                        [9e-11, 5.76319803259, 86457.9847579312],
                        [9e-11, 3.21350384534, 123668.805106625],
                        [9e-11, 5.50134612867, 25352.0266280424],
                        [9e-11, 3.61240341796, 76784.8428506582],
                        [9e-11, 3.71346537596, 78213.7128028184],
                        [1.1e-10, 0.04658635952, 136722.591557862],
                        [9e-11, 3.16339317765, 24079.3456024152],
                        [1e-10, 1.52307057829, 196137.073432611],
                        [9e-11, 5.78277172101, 137210.226309117],
                        [9e-11, 5.34709321166, 16703.062133499],
                        [1e-10, 1.10603431719, 76152.059111345],
                        [1e-10, 2.92130709301, 78257.0808658226],
                        [9e-11, 4.9259138928, 52609.5180210252],
                        [8e-11, 4.47915729665, 167850.08294775],
                        [1e-10, 3.52532046928, 50049.9288757692],
                        [9e-11, 5.74701495675, 128220.758603684],
                        [9e-11, 3.39636103723, 25771.5112719176],
                        [9e-11, 0.40885845708, 173511.414996902],
                        [9e-11, 0.0521477146, 209232.916097688],
                        [1.1e-10, 4.3947350056, 166740.704395656],
                        [8e-11, 0.83788793173, 52101.0246845811],
                        [9e-11, 0.39740145698, 208173.534167499],
                        [9e-11, 2.14648409917, 52250.5878817157],
                        [1.1e-10, 0.77019715443, 181026.249095736],
                        [8e-11, 0.46458507594, 11.0457002639],
                        [9e-11, 3.75726239516, 26395.4607625438],
                        [1.1e-10, 3.88183253605, 99024.136457914],
                        [9e-11, 5.91589628233, 26404.2950112308],
                        [8e-11, 3.62038830716, 28736.3579670472],
                        [9e-11, 5.53218561478, 50910.238804522],
                        [8e-11, 3.98222002302, 51226.6306741786],
                        [8e-11, 2.20332298794, 35077.3708470066],
                        [1e-10, 1.71606704784, 132028.588603155],
                        [9e-11, 4.19828805921, 123200.840116271],
                        [8e-11, 4.94949508683, 1263.15736257819],
                        [8e-11, 0.3825502474, 78800.513936818],
                        [8e-11, 3.55931433878, 25508.2155545754],
                        [8e-11, 2.06623542364, 133882.090652836],
                        [8e-11, 2.76004606287, 103498.416184545],
                        [9e-11, 6.07146960892, 52595.2909270236],
                        [1e-10, 4.64768763301, 240452.46032332],
                        [1e-10, 4.75089417351, 158116.491744729],
                        [9e-11, 3.16830318341, 156531.300184803],
                        [9e-11, 0.51442466727, 233731.746343979],
                        [8e-11, 1.84170519176, 52325.369480283],
                        [9e-11, 1.5802092941, 130866.113898747],
                        [8e-11, 1.31021834242, 78160.616650504],
                        [7e-11, 3.52394232228, 209658.824874202],
                        [7e-11, 5.30361639156, 51852.300866491],
                        [7e-11, 1.68129390597, 103704.601732982],
                        [7e-11, 4.93711462539, 77616.6985914078],
                        [7e-11, 4.26547182656, 130363.249636595],
                        [8e-11, 5.88262362064, 51955.3936407096],
                        [9e-11, 2.85041915486, 52286.0126043678],
                        [9e-11, 4.54751921819, 222224.976574185],
                        [7e-11, 2.95164397426, 58857.031136548],
                        [7e-11, 5.09932324366, 26421.7590823436],
                        [8e-11, 5.95900851407, 625.6701923124],
                        [8e-11, 2.87611784406, 182595.65223012],
                        [7e-11, 2.95245442922, 70269.1809826984],
                        [9e-11, 1.85768285044, 2168.7604822826],
                        [9e-11, 5.87894263333, 203041.893083441],
                        [7e-11, 5.76376514627, 53399.624123927],
                        [7e-11, 3.19368974135, 77947.317555066],
                        [7e-11, 0.58513513972, 17893.6278083656],
                        [7e-11, 1.25969543054, 104275.346495021],
                        [7e-11, 1.78997113742, 187167.275488078],
                        [7e-11, 3.04234073392, 77101.2347203148],
                        [7e-11, 5.13452237557, 77307.420268752],
                        [8e-11, 2.39389370291, 51534.3927214094],
                        [7e-11, 0.36315569295, 179172.747046054],
                        [9e-11, 4.65044386389, 156954.017040321],
                        [7e-11, 5.75015377153, 78580.1012943792],
                        [8e-11, 4.90310056069, 101703.157740824],
                        [7e-11, 2.81152781596, 92741.0606079226],
                        [7e-11, 4.53777069646, 78339.9754959982],
                        [8e-11, 3.72793390212, 77795.7444343682],
                        [7e-11, 4.99225219771, 102659.446896794],
                        [8e-11, 1.24101149187, 128857.556359588],
                        [6e-11, 1.24806705522, 181659.722249411],
                        [7e-11, 1.41908776548, 39450.3528483734],
                        [8e-11, 5.07207947299, 202420.149282602],
                        [6e-11, 3.88021248158, 104991.509852611],
                        [7e-11, 0.4481172726, 104301.615944393],
                        [7e-11, 6.19019459405, 37698.4550999484],
                        [8e-11, 3.27628873745, 183145.012956114],
                        [6e-11, 1.04156861985, 104197.833755812],
                        [7e-11, 6.04804574225, 103189.137861889],
                        [7e-11, 6.15588549143, 75930.5130318506],
                        [7e-11, 2.01982955946, 176332.246141028],
                        [7e-11, 4.68299502093, 838.9692877504],
                        [7e-11, 4.32694078051, 104248.519792078],
                        [6e-11, 0.30098706976, 54824.2611086214],
                        [7e-11, 2.39268679107, 80596.9058175946],
                        [6e-11, 0.45279066685, 225687.22128005],
                        [6e-11, 4.9361756676, 215473.935733839],
                        [6e-11, 4.22528261713, 79330.2049019126],
                        [7e-11, 5.53062936347, 917.9302859818],
                        [6e-11, 0.27837413876, 76137.8320173434],
                        [7e-11, 1.50054882304, 78313.7060466268],
                        [6e-11, 4.84865195534, 213255.178629652],
                        [7e-11, 0.37969316028, 102872.745992232],
                        [6e-11, 4.82915128356, 79859.8958670072],
                        [7e-11, 2.36435599398, 58220.0348645238],
                        [7e-11, 0.762437199, 183674.703921209],
                        [6e-11, 3.48561717935, 61560.6472912236],
                        [7e-11, 3.15542325331, 53029.0026649004],
                        [6e-11, 2.04066112896, 156534.532396446],
                        [6e-11, 4.08906102427, 91919.569915899],
                        [6e-11, 3.6498851175, 151199.942741062],
                        [6e-11, 4.09613031145, 53867.9719526508],
                        [6e-11, 3.49486002612, 66653.1574663484],
                        [7e-11, 2.89745929648, 230239.174777109],
                        [6e-11, 3.99809593088, 50380.5478394274],
                        [6e-11, 3.65663654813, 70383.6202713836],
                        [6e-11, 6.23319937932, 182619.203326377],
                        [6e-11, 0.15202166498, 51859.4144134918],
                        [6e-11, 0.36162525319, 26823.779655106],
                        [6e-11, 5.03417122369, 78786.2868428164],
                        [6e-11, 2.61401898803, 80382.473285101],
                        [6e-11, 5.0693978209, 51841.950342379],
                        [8e-11, 4.96432797037, 52396.2189255872],
                        [6e-11, 3.74091556543, 155475.150466257],
                        [6e-11, 4.29792825666, 52812.8025551726],
                        [7e-11, 6.02219529486, 156507.749088545],
                        [5e-11, 6.28085632767, 31415.379249957],
                        [6e-11, 2.7051772072, 52492.198152805],
                        [7e-11, 6.25185953525, 74935.5737684424],
                        [5e-11, 6.03800330793, 84944.9342781222],
                        [7e-11, 2.08385155566, 104819.577556651],
                        [5e-11, 2.79143401592, 51315.4963543956],
                        [7e-11, 0.15300257128, 2014.9816717978],
                        [6e-11, 5.45690475475, 1243.4876016784],
                        [5e-11, 1.7231082929, 103718.828826984],
                        [5e-11, 0.0534317532, 27044.1922975448],
                        [5e-11, 1.35980682609, 94329.7752861974],
                        [7e-11, 5.94496795198, 256327.077918683],
                        [6e-11, 1.88665916947, 80174.9089079398],
                        [5e-11, 2.15640465605, 235900.506826261],
                        [5e-11, 5.97271372078, 156314.119754007],
                        [6e-11, 2.6662090451, 229129.796225016],
                        [5e-11, 2.52891655111, 123758.290854471],
                        [6e-11, 1.20953605164, 130459.185468771],
                        [5e-11, 4.06443360712, 130285.736897386],
                        [7e-11, 1.34355308244, 1731.1223529326],
                        [5e-11, 2.36158299954, 78896.4931640358],
                        [5e-11, 0.96987247797, 149288.743257845],
                        [5e-11, 0.76610110351, 24864.0853007956],
                        [5e-11, 1.95647355963, 76571.5437552202],
                        [5e-11, 1.13701088228, 26312.2479372761],
                        [5e-11, 1.05826639118, 27780.0688110766],
                        [5e-11, 4.54130791881, 156740.717944883],
                        [6e-11, 3.58276567647, 198489.939586383],
                        [5e-11, 0.51603916276, 171292.657892715],
                        [6e-11, 3.03452226064, 77741.1320066288],
                        [5e-11, 1.46111595893, 101011.000139597],
                        [5e-11, 0.02805624095, 149756.7082482],
                        [5e-11, 5.10195955921, 112231.701719636],
                        [5e-11, 4.87459278742, 78413.2726218572],
                        [7e-11, 3.69898590349, 81604.3218514224],
                        [5e-11, 0.76195152302, 417406.450265187],
                        [5e-11, 0.55904094194, 2383.1930147762],
                        [5e-11, 3.95096384085, 78188.9278261553],
                        [5e-11, 1.76549372525, 53771.992725433],
                        [5e-11, 3.3535670841, 205260.650187628],
                        [6e-11, 5.57902902188, 87253.177130155],
                        [5e-11, 0.26610630357, 235746.728015776],
                        [5e-11, 2.90596877294, 154194.222456573],
                        [4e-11, 1.1697417665, 193937.986089324],
                        [4e-11, 3.93130462476, 130289.952510736],
                        [4e-11, 4.33627478046, 89.485747846],
                        [5e-11, 2.8002233534, 4437.51420837359],
                        [6e-11, 4.70286246928, 91805.1306272138],
                        [5e-11, 1.82284966431, 1884.9011634174],
                        [5e-11, 2.02580304988, 259769.652863649],
                        [4e-11, 4.65165864815, 195047.364641417],
                        [4e-11, 0.588581477, 323.5054166574],
                        [4e-11, 4.0062366874, 175376.646399419],
                        [4e-11, 0.64833718455, 156377.855652311],
                        [4e-11, 2.71436739189, 182402.022895581],
                        [5e-11, 4.68929437146, 79315.977807911],
                        [4e-11, 5.71176695959, 81591.8450810028],
                        [4e-11, 1.42876132655, 52252.072354424],
                        [5e-11, 2.55069425936, 154308.661745258],
                        [5e-11, 1.42813778372, 266540.363464894],
                        [4e-11, 2.00085806148, 189386.032592265],
                        [5e-11, 4.29231489707, 220025.889230898],
                        [4e-11, 6.20316213523, 79116.9058064746],
                        [4e-11, 0.85257120719, 118007.473057473],
                        [4e-11, 5.77579934605, 129799.618421557],
                        [4e-11, 4.47492094862, 137678.191299471],
                        [4e-11, 1.6456663118, 78697.4211625994],
                        [5e-11, 2.1751453684, 51329.7234483972],
                        [6e-11, 4.78710650697, 102755.426124012],
                        [4e-11, 1.46002058771, 935.92998070881],
                        [5e-11, 5.13889133658, 130907.480698225],
                        [4e-11, 1.8932118711, 2111.6503133776],
                        [4e-11, 0.10839681347, 38.1330356378],
                        [5e-11, 4.42201446083, 78057.5238762854],
                        [5e-11, 5.65870377214, 1300.826818205],
                        [5e-11, 5.90579064813, 1478.8665740644],
                        [4e-11, 5.24580055005, 52309.9153327334],
                        [4e-11, 2.74756161638, 144916.866891071],
                        [5e-11, 3.31232177694, 48847.6706268682],
                        [4e-11, 4.43048849829, 118828.963749497],
                        [4e-11, 0.51369916437, 181563.053607831],
                        [4e-11, 5.22571179686, 261988.409967835],
                        [4e-11, 0.80000960641, 1485.2907067032],
                        [4e-11, 3.25642623421, 195181.473691002],
                        [5e-11, 5.23264312237, 126996.940762906],
                        [4e-11, 3.86524951456, 209762.607062783],
                        [4e-11, 3.43760746038, 234261.437309073],
                        [4e-11, 0.67741502331, 131079.412994185],
                        [4e-11, 5.40862384292, 104984.39630561],
                        [4e-11, 0.30384598125, 285907.552627127],
                        [4e-11, 5.65734972357, 51868.2486621788],
                        [4e-11, 5.55015227967, 149846.193996046],
                        [4e-11, 1.51752118872, 103814.808054201],
                        [4e-11, 2.53135799952, 79487.5272655012],
                        [4e-11, 1.88512485652, 54879.422437824],
                        [4e-11, 5.12386500502, 182622.43553802],
                        [4e-11, 4.36228014188, 207747.625390985],
                        [4e-11, 3.24471199066, 130020.031063996],
                        [4e-11, 0.51045647492, 107692.224992997],
                        [4e-11, 4.26267840541, 132658.272812058],
                        [4e-11, 3.08522628552, 175844.611389774],
                        [4e-11, 3.38866894732, 104888.417078392],
                        [4e-11, 1.21404057369, 139543.422701989],
                        [5e-11, 3.75130732, 62197.6435632478],
                        [4e-11, 0.30056239753, 233202.055378884],
                        [4e-11, 4.20598588282, 218916.510678805],
                        [4e-11, 1.34568004641, 182828.621086457],
                        [4e-11, 0.68519128486, 104276.830967729],
                        [4e-11, 0.20412928769, 169093.570549428],
                        [3e-11, 0.98973904852, 105418.108043487],
                        [4e-11, 3.42019897755, 61279.713277266],
                        [3e-11, 5.22780381742, 78338.4910232899],
                        [3e-11, 2.67114319601, 24998.1943503806],
                        [4e-11, 1.65814724695, 50800.0324833026],
                        [4e-11, 3.24764679291, 28286.9904848612],
                        [4e-11, 6.01723954923, 104237.173277612],
                        [3e-11, 3.99050522839, 71378.5595347918],
                        [3e-11, 3.46632047879, 45494.5814297488],
                        [3e-11, 4.27304181959, 130593.294518356],
                        [3e-11, 4.05932083484, 52822.8171164632],
                        [3e-11, 5.89324219451, 50483.640613646],
                        [3e-11, 2.88091404327, 78149.2701360374],
                        [3e-11, 4.09573256493, 155460.923372255],
                        [3e-11, 0.40695406256, 52278.899057367],
                        [3e-11, 0.53381434741, 26709.6469424134],
                        [3e-11, 1.00008179165, 50264.6067999312],
                        [4e-11, 5.67939124426, 106470.376426675],
                        [3e-11, 0.77610404005, 142871.558358269],
                        [3e-11, 3.80375047171, 26402.0893214438],
                        [3e-11, 2.44134109777, 156520.305302444],
                        [3e-11, 0.98764974659, 128843.329265586],
                        [3e-11, 3.6290381593, 130435.634372513],
                        [3e-11, 2.12651302584, 78469.8949731598],
                        [3e-11, 4.29158350083, 154408.654989067],
                        [3e-11, 1.06499703474, 26734.913974889],
                        [3e-11, 1.86490629185, 51707.841292794],
                        [3e-11, 5.95559848753, 104344.984007397],
                        [4e-11, 3.60184879954, 207114.15223731],
                        [3e-11, 3.28684847821, 208276.626941718],
                        [3e-11, 2.80509981839, 104358.241125197],
                        [3e-11, 5.02808401414, 130432.40216087],
                        [3e-11, 6.1660165005, 20043.6745601988],
                        [3e-11, 5.29581547615, 57503.2823915312],
                        [3e-11, 1.3503644855, 23919.1426592916],
                        [2e-11, 3.75076268715, 130005.803969994],
                        [3e-11, 3.05479754348, 162810.494699437],
                        [3e-11, 2.06087055668, 52065.599961929],
                        [3e-11, 1.11245383788, 192828.60753723],
                        [2e-11, 1.90218644384, 24356.7807886416],
                        [2e-11, 4.74203919229, 76887.9356248768],
                        [2e-11, 0.63548334553, 23384.2869868986],
                        [2e-11, 2.51564214512, 26667.590728573],
                        [2e-11, 6.08909078783, 116783.655216695],
                        [2e-11, 3.56733241522, 26073.6760475726],
                        [3e-11, 5.60392923976, 104466.051854982],
                        [2e-11, 3.56126103854, 26189.8656598398],
                        [2e-11, 5.97797555746, 50167.2487439894],
                        [2e-11, 4.41481991835, 65538.2559899476],
                        [2e-11, 5.91297170155, 87367.6164188402],
                        [2e-11, 5.1750816963, 163298.129450691],
                        [3e-11, 1.10832319418, 25600.26839032],
                        [2e-11, 2.11477268878, 25773.7169617046],
                        [2e-11, 2.15515419441, 51951.4614874465],
                        [3e-11, 5.43138498093, 106684.808959169],
                        [2e-11, 0.11511311275, 27170.9833738678],
                        [2e-11, 5.22579437397, 6885.14988993081],
                        [2e-11, 2.93412437896, 63786.3582415226],
                        [3e-11, 6.19860078008, 25004.8229092806],
                        [2e-11, 0.23150025826, 24448.8336243862],
                        [2e-11, 0.54898566845, 153084.84390448],
                        [2e-11, 0.63373893542, 1265.5674786264],
                        [2e-11, 4.49873870855, 50007.0458008658],
                        [2e-11, 5.57750243319, 25928.601406782],
                        [2e-11, 5.66467419812, 25466.159340735],
                        [2e-11, 5.10682926241, 159969.993794411],
                        [2e-11, 3.49751807681, 259819.649485553],
                      ],
          },
          {
            series => "L2",
            terms  => [
                        [0.00053049845, 0, 0],
                        [0.00016903658, 4.69072300649, 26087.9031415742],
                        [7.396711e-05, 1.34735624669, 52175.8062831484],
                        [3.018297e-05, 4.45643539705, 78263.7094247226],
                        [1.107419e-05, 1.26226537554, 104351.612566297],
                        [3.78173e-06, 4.319980559, 130439.515707871],
                        [1.22998e-06, 1.06868541052, 156527.418849445],
                        [3.8663e-07, 4.08011610182, 182615.321991019],
                        [1.4898e-07, 4.6334308581, 1109.3785520934],
                        [1.1861e-07, 0.79187646439, 208703.225132594],
                        [5.243e-08, 4.71799772791, 24978.5245894808],
                        [3.575e-08, 3.77317513032, 234791.128274168],
                        [2.566e-08, 1.44059109766, 27197.2816936676],
                        [2.045e-08, 1.49570544876, 51066.427731055],
                        [1.064e-08, 0.46023695675, 260879.031415742],
                        [9.72e-09, 1.80344701358, 955.5997416086],
                        [6.28e-09, 6.18483168149, 529.6909650946],
                        [6.28e-09, 4.8493010532, 24498.8302462904],
                        [7.63e-09, 4.54299337366, 77154.3308726292],
                        [6.54e-09, 0.98170349539, 5661.3320491522],
                        [5.72e-09, 5.92841937309, 25028.521211385],
                        [5.52e-09, 2.1322864657, 20426.571092422],
                        [5.07e-09, 4.11466890786, 4551.9534970588],
                        [6.08e-09, 4.54152310086, 2218.7571041868],
                        [4.39e-09, 3.40705996719, 11322.6640983044],
                        [3.81e-09, 2.83442391504, 26617.5941066688],
                        [3.7e-09, 0.8236064656, 6770.7106012456],
                        [3.12e-09, 5.1878582963, 46514.4742339962],
                        [3.14e-09, 3.42002895816, 286966.934557316],
                        [3.07e-09, 3.20507351217, 1059.3819301892],
                        [3.32e-09, 0.97416155325, 25132.3033999656],
                        [3.27e-09, 2.22989850002, 21535.9496445154],
                        [3.03e-09, 4.68482058244, 27043.5028831828],
                        [2.47e-09, 5.87612469398, 16983.9961474566],
                        [3.11e-09, 4.22422008005, 3442.5749449654],
                        [2.37e-09, 4.37101224231, 114.43928868521],
                        [2.34e-09, 0.93917232374, 30639.856638633],
                        [2.73e-09, 1.29086264556, 103242.234014203],
                        [2.09e-09, 3.30158370895, 213.299095438],
                        [1.97e-09, 2.07792605062, 22645.3281966088],
                        [1.82e-09, 0.62534354989, 25448.0058552602],
                        [2.19e-09, 1.3418873834, 28306.660245761],
                        [1.68e-09, 6.20806483822, 27147.2850717634],
                        [1.56e-09, 3.91999448441, 32858.6137428198],
                        [1.6e-09, 5.7937744941, 52705.497248243],
                        [1.53e-09, 4.33936015634, 1589.0728952838],
                        [1.61e-09, 4.80105233203, 23869.1460373874],
                        [1.48e-09, 1.97575825359, 72602.3773755704],
                        [1.45e-09, 5.96024756685, 14765.2390432698],
                        [1.29e-09, 4.16213277137, 23969.1392811958],
                        [1.35e-09, 3.8677543707, 51220.2065415398],
                        [1.4e-09, 3.66642468738, 25558.2121764796],
                        [1.08e-09, 1.39723983534, 50586.7333878646],
                        [1.15e-09, 0.15124159675, 26301.2022370122],
                        [1.13e-09, 4.9813748525, 79373.087976816],
                        [1.15e-09, 3.05230359467, 53285.1848352418],
                        [9.9e-10, 3.99635236807, 56727.7597802072],
                        [9.9e-10, 3.84242768306, 83925.0414738748],
                        [9.3e-10, 2.04998627084, 26068.2333806744],
                        [9.2e-10, 0.08628005998, 313054.83769889],
                        [9.4e-10, 4.30968259383, 129330.137155778],
                        [8.5e-10, 3.01984486981, 53235.1882133376],
                        [1.05e-09, 5.32363189985, 7238.6755916],
                        [9.5e-10, 2.24093904831, 19317.1925403286],
                        [9.9e-10, 1.00218248773, 29530.4780865396],
                        [7.5e-10, 5.40269356209, 26091.7844769322],
                        [7.4e-10, 4.31017375756, 2333.196392872],
                        [8.6e-10, 0.78555390902, 57837.1383323006],
                        [8.1e-10, 0.9588922979, 26107.572902474],
                        [8.5e-10, 3.28561166885, 12432.0426503978],
                        [7e-10, 3.55533072657, 13521.7514415914],
                        [7.8e-10, 0.27707431029, 37410.5672398786],
                        [6.3e-10, 0.6582852544, 110012.944615449],
                        [6.4e-10, 2.68437002997, 43071.8992890308],
                        [6.7e-10, 3.8921657878, 26084.0218062162],
                        [6.4e-10, 2.75958867988, 40853.142184844],
                        [6.1e-10, 5.77836694481, 12566.1516999828],
                        [6.9e-10, 3.44813862795, 10213.285546211],
                        [6e-10, 0.79452201416, 53131.406024757],
                        [6.3e-10, 5.02106928248, 98690.2805171446],
                        [6.3e-10, 2.49160532665, 78793.4003898172],
                        [5.9e-10, 0.1554109817, 36301.1886877852],
                        [5.6e-10, 1.01839356017, 27676.976036858],
                        [5.3e-10, 1.55958841442, 49957.0491789616],
                        [5.2e-10, 5.14041028675, 52156.1365222486],
                        [5.2e-10, 1.15062443564, 26202.3424302594],
                        [5.2e-10, 0.5368757688, 77308.109683114],
                        [4.8e-10, 1.60851837486, 25234.7067598222],
                        [4.8e-10, 5.19507775798, 48733.231338183],
                        [5.3e-10, 5.49113976101, 25661.3049506982],
                        [4.6e-10, 5.18676728087, 77204.3274945334],
                        [4.4e-10, 4.971456138, 25973.463852889],
                        [5.4e-10, 0.32708522231, 25874.6040461362],
                        [4.2e-10, 2.21900478384, 52179.6876185064],
                        [4.5e-10, 2.52716095523, 103292.230636108],
                        [4.8e-10, 0.4894487653, 51646.1153180538],
                        [3.9e-10, 6.2527517396, 47623.8527860896],
                        [4.1e-10, 2.81015791586, 41962.5207369374],
                        [3.7e-10, 5.01445357044, 26080.7895945734],
                        [3.8e-10, 6.08585317961, 79323.0913549118],
                        [4.3e-10, 3.24574920597, 52389.1053785864],
                        [4.1e-10, 2.43000457106, 639.897286314],
                        [3.9e-10, 0.76157461206, 82815.6629217814],
                        [3.4e-10, 3.28090243752, 62389.0918293594],
                        [3.7e-10, 0.05738918168, 38519.945791972],
                        [3.5e-10, 5.78457148656, 68050.4238785116],
                        [4e-10, 3.14856042352, 426.598190876],
                        [4.2e-10, 4.09553132731, 52195.4760440482],
                        [3.2e-10, 2.45518077222, 38654.054841557],
                        [3.9e-10, 1.80165134294, 33326.5787331742],
                        [4.1e-10, 4.32141055637, 26095.016688575],
                        [3.2e-10, 3.72358129034, 136100.847757023],
                        [4e-10, 5.69015360764, 31749.2351907264],
                        [3.2e-10, 1.65828846012, 105460.99111839],
                        [3.2e-10, 1.0254998481, 155418.040297352],
                        [3e-10, 1.57915654792, 52168.6927361476],
                        [3.1e-10, 0.69335015231, 50057.04242277],
                        [3.3e-10, 4.04678616141, 55618.3812281138],
                        [2.9e-10, 3.72464718175, 51535.9089968344],
                        [2.9e-10, 5.7365444786, 129380.133777682],
                        [3.8e-10, 3.74472554242, 18849.2275499742],
                        [2.8e-10, 3.05059885517, 339142.740840465],
                        [3.5e-10, 0.74194291507, 52171.9249477904],
                        [2.8e-10, 0.73918545262, 7880.08915333899],
                        [3.6e-10, 1.26742819742, 51116.4243529592],
                        [3.5e-10, 5.2929814316, 45405.0956819028],
                        [3.2e-10, 5.79438282818, 18093.37469955],
                        [2.6e-10, 5.79318346346, 66941.0453264182],
                        [2.8e-10, 4.27104078603, 54394.5633873352],
                        [2.4e-10, 5.0630479161, 2118.7638603784],
                        [3e-10, 1.05420470769, 52182.9198301492],
                        [2.5e-10, 1.7599691024, 124778.183658719],
                        [2.2e-10, 4.43631488516, 3328.13565628019],
                        [2.2e-10, 5.09106835544, 99799.659069238],
                        [2.2e-10, 1.88199362566, 78244.0396638228],
                        [2.1e-10, 2.561232112, 94138.3270200858],
                        [2.5e-10, 5.46150069597, 104881.303531391],
                        [2.5e-10, 0.05236467599, 26514.5013324502],
                        [2.5e-10, 3.02983070039, 77734.018459628],
                        [2e-10, 3.48966334599, 103396.012824688],
                        [2.1e-10, 3.97495995227, 53764.8791784322],
                        [1.8e-10, 1.07895331282, 28421.0995344462],
                        [1.9e-10, 1.98308917333, 23754.7067487022],
                        [1.8e-10, 4.5863136596, 76044.9523205358],
                        [1.9e-10, 2.90042907299, 6283.0758499914],
                        [1.9e-10, 3.18954246101, 51109.3108059584],
                        [1.8e-10, 2.11231697626, 73711.7559276638],
                        [1.7e-10, 0.06118735536, 88476.9949709336],
                        [1.8e-10, 6.26984143774, 15874.6175953632],
                        [1.8e-10, 2.58820345674, 51123.53789996],
                        [1.7e-10, 5.82864656129, 32370.9789915656],
                        [1.8e-10, 5.22519288335, 78267.5907600806],
                        [1.5e-10, 5.43053381026, 64741.9579831312],
                        [1.5e-10, 2.53107093357, 155468.036919256],
                        [2e-10, 4.40959528115, 1223.81784077861],
                        [1.5e-10, 4.05461375332, 51962.5071877104],
                        [1.5e-10, 3.52769852262, 79219.3091663312],
                        [1.5e-10, 0.45988103836, 162188.750898597],
                        [1.5e-10, 0.87152359342, 78283.3791856224],
                        [1.4e-10, 1.87990160627, 125887.562210812],
                        [1.6e-10, 2.82759858554, 105410.994496486],
                        [1.3e-10, 4.67219046898, 78256.5958777218],
                        [1.6e-10, 0.04901690153, 78477.0085201606],
                        [1.4e-10, 4.21146699511, 52290.2455718336],
                        [1.4e-10, 4.08726245298, 78270.8229717234],
                        [1.5e-10, 3.80902990348, 33967.9922949132],
                        [1.6e-10, 0.28761005157, 44937.1306915484],
                        [1.4e-10, 5.8433060581, 103821.921601202],
                        [1.5e-10, 6.0373826452, 13655.8604911764],
                        [1.2e-10, 0.81685952408, 81706.284369688],
                        [1.5e-10, 3.79894620695, 108903.566063356],
                        [1.1e-10, 3.26651828162, 52602.4044740244],
                        [1.1e-10, 1.28755195884, 29416.0387978544],
                        [1.1e-10, 4.03185618461, 181505.943438926],
                        [1.1e-10, 5.5844804614, 120226.23016166],
                        [1.2e-10, 0.32316787548, 91785.460866314],
                        [1.3e-10, 2.02636565149, 71492.998823477],
                        [1.5e-10, 3.56357453844, 76674.6365294388],
                        [1.3e-10, 3.80590035776, 78259.8280893646],
                        [1e-10, 0.04109363791, 77197.2139475326],
                        [1e-10, 6.00753285175, 365230.643982039],
                        [1e-10, 1.74642821988, 52061.3669944632],
                        [1.3e-10, 2.79229719351, 636.9962720242],
                        [1.1e-10, 5.52780687723, 26727.8004278882],
                        [1.1e-10, 4.04728142335, 45892.730433157],
                        [8e-11, 4.9698513054, 151975.465352386],
                        [8e-11, 3.44547998787, 23439.4483161012],
                        [1.1e-10, 2.54429302352, 44181.2778411242],
                        [1e-10, 3.502742291, 65697.5577247398],
                        [9e-11, 2.45809063705, 93028.9484679924],
                        [9e-11, 4.9256893206, 104331.942805397],
                        [8e-11, 0.80535713418, 71980.6335747312],
                        [1e-10, 2.20026830808, 130969.206672966],
                        [7e-11, 2.30885367448, 18207.8139882352],
                        [1e-10, 5.72020107388, 77211.4410415342],
                        [7e-11, 0.15536656581, 129483.915966262],
                        [8e-11, 2.31255848253, 58458.8821331398],
                        [7e-11, 2.07713892797, 90829.8611247054],
                        [7e-11, 3.50101836609, 117873.364007888],
                        [7e-11, 3.20275960823, 64607.8489335462],
                        [7e-11, 4.73829767381, 51322.6099013964],
                        [7e-11, 5.655539467, 181555.94006083],
                        [9e-11, 2.56870006051, 129909.824742776],
                        [8e-11, 0.67171808844, 79852.7823200064],
                        [7e-11, 4.06204756163, 39609.6545831656],
                        [7e-11, 1.46575838897, 853.196381752],
                        [7e-11, 2.57400610109, 69159.802430605],
                        [6e-11, 3.86283147263, 59414.4818747484],
                        [6e-11, 1.3354568195, 102132.85546211],
                        [7e-11, 2.80506785787, 39743.7636327506],
                        [6e-11, 1.66711581835, 28206.6670019526],
                        [8e-11, 4.73806237855, 150866.086800293],
                        [6e-11, 0.81325444169, 207593.8465805],
                        [6e-11, 0.0692555554, 58946.516884394],
                        [6e-11, 3.09908354288, 114564.898112508],
                        [6e-11, 0.88473087003, 104358.726113298],
                        [6e-11, 3.51715962887, 188276.654040172],
                        [6e-11, 4.13083556162, 54509.0026760204],
                        [6e-11, 3.14680331401, 104564.911661735],
                        [7e-11, 5.89465282471, 131498.89763806],
                        [5e-11, 0.27174681491, 143961.267149462],
                        [5e-11, 5.25316838887, 3340.6124266998],
                        [7e-11, 1.99860349328, 104355.493901655],
                        [5e-11, 1.47362369989, 9103.9069941176],
                        [7e-11, 0.60725013988, 60055.8954364874],
                        [5e-11, 3.20081630256, 13541.4212024912],
                        [6e-11, 0.50137409605, 63498.4703814528],
                        [5e-11, 5.0773947536, 97580.9019650512],
                        [5e-11, 1.35632842517, 104344.499019296],
                        [5e-11, 2.16611734526, 103925.014375421],
                        [5e-11, 4.04581717475, 98068.5367163054],
                        [5e-11, 4.90166806916, 22759.767485294],
                        [5e-11, 3.87246722733, 89586.373523027],
                        [5e-11, 3.01510200596, 103285.117089107],
                        [6e-11, 1.4479147408, 78050.4103292846],
                        [5e-11, 2.4783121842, 26241.681952059],
                        [5e-11, 3.85799454501, 107794.187511262],
                        [5e-11, 0.57300969993, 134991.46920493],
                        [5e-11, 2.38724530268, 146314.133303234],
                        [4e-11, 6.11121027497, 90695.7520751204],
                        [4e-11, 1.8318123147, 74821.1344797572],
                        [4e-11, 5.23938469806, 130012.917516995],
                        [5e-11, 1.18020888905, 27311.7209823528],
                        [5e-11, 3.00001411726, 85034.4200259682],
                        [5e-11, 5.56662713374, 155997.727884351],
                        [5e-11, 2.35342507828, 145204.754751141],
                        [4e-11, 4.57119707855, 157636.797401539],
                        [4e-11, 5.78384635962, 51742.0945452716],
                        [4e-11, 2.41778026187, 157483.018591054],
                        [5e-11, 2.53226316949, 103299.344183108],
                        [4e-11, 3.7145852625, 26555.8681319286],
                        [4e-11, 3.8363997571, 150244.342999454],
                        [4e-11, 3.30201863644, 76144.9455643442],
                        [4e-11, 0.68904721853, 124156.43985788],
                        [4e-11, 1.73206522989, 178063.368493961],
                        [5e-11, 3.20991489892, 71025.0338331226],
                        [5e-11, 3.69408876581, 105940.685461581],
                        [4e-11, 2.75867944254, 391318.547123613],
                        [5e-11, 0.535860682, 80482.4665289094],
                        [4e-11, 5.07565982849, 51756.3216392732],
                        [4e-11, 0.12462379137, 78690.3076155986],
                        [4e-11, 5.25512859919, 157057.10981454],
                        [4e-11, 5.66367904256, 9384.8410080752],
                        [4e-11, 4.70366039546, 54294.5701435268],
                        [4e-11, 4.7476763595, 204151.271635535],
                        [3e-11, 3.2417738566, 155571.819107837],
                        [3e-11, 0.85377908455, 16066.0658614748],
                        [3e-11, 1.58566666033, 130226.216612433],
                        [4e-11, 5.58218314089, 119116.851609567],
                        [4e-11, 0.94898112028, 78378.1487134078],
                        [4e-11, 6.15781348253, 97112.9369746968],
                        [4e-11, 2.31787867435, 52815.7035694624],
                        [4e-11, 2.73401660736, 78417.4882352074],
                        [4e-11, 5.67762508473, 183674.703921209],
                        [4e-11, 0.21138526735, 214364.557181746],
                        [4e-11, 5.24311464709, 116917.76426628],
                        [3e-11, 3.86634858823, 104371.282327197],
                        [4e-11, 5.42881221134, 233731.746343979],
                        [3e-11, 1.97251042531, 183145.012956114],
                        [3e-11, 0.60740481915, 133882.090652836],
                        [3e-11, 6.23399386415, 181659.722249411],
                        [4e-11, 6.22336284288, 140652.801254082],
                        [3e-11, 5.94876130841, 25035.6347583858],
                        [3e-11, 3.83428144879, 233681.749722074],
                        [3e-11, 2.32902857669, 182085.631025925],
                        [3e-11, 2.8435468116, 123200.840116271],
                        [3e-11, 1.53933182823, 176953.989941867],
                        [4e-11, 2.45893471155, 207643.843202404],
                        [3e-11, 5.72001402121, 102762.539671013],
                        [4e-11, 1.40880562474, 80382.473285101],
                        [3e-11, 4.90489886883, 51749.2080922724],
                        [3e-11, 4.76799924569, 104138.313470859],
                        [4e-11, 6.26291139255, 25021.4076643842],
                        [3e-11, 0.40352872921, 132028.588603155],
                        [3e-11, 2.66696150741, 157586.800779634],
                        [3e-11, 5.23202292846, 84546.785274714],
                        [3e-11, 4.59428408981, 131548.894259964],
                        [3e-11, 2.53649995681, 50579.6198408638],
                        [3e-11, 2.55542640702, 77829.9976868458],
                        [4e-11, 1.67304824627, 130419.845946971],
                        [3e-11, 6.21862713072, 95247.7055721792],
                        [3e-11, 5.37878648081, 44295.7171298094],
                        [3e-11, 4.68342323732, 156507.749088545],
                        [3e-11, 3.36164307862, 104778.210757173],
                        [3e-11, 2.91632245418, 166740.704395656],
                        [2e-11, 0.72039482289, 7994.5284420242],
                        [2e-11, 5.43309839263, 78903.6067110366],
                        [2e-11, 1.12849064703, 183724.700543113],
                        [3e-11, 1.94668130835, 143005.667407854],
                        [3e-11, 0.5628939296, 104347.731230939],
                        [2e-11, 1.78482957305, 156531.300184803],
                        [3e-11, 5.0354242485, 130443.397043229],
                        [3e-11, 4.72735160431, 78149.2701360374],
                        [2e-11, 5.31651763274, 208173.534167499],
                        [3e-11, 5.36470448658, 131395.11544948],
                        [2e-11, 0.06581745526, 196137.073432611],
                        [2e-11, 2.93678015526, 167850.08294775],
                        [2e-11, 5.84781134233, 65831.6667743248],
                        [2e-11, 5.56634055777, 70269.1809826984],
                        [2e-11, 5.42145220392, 183570.921732628],
                        [2e-11, 6.06636386319, 53242.3017603384],
                        [2e-11, 4.37154457896, 128220.758603684],
                        [2e-11, 0.35903300236, 187167.275488078],
                        [2e-11, 2.78347515438, 79330.2049019126],
                        [2e-11, 4.51952536661, 203041.893083441],
                        [2e-11, 3.36865001265, 170049.170291037],
                        [2e-11, 3.08184453618, 50593.8469348654],
                        [2e-11, 4.32534428501, 55503.9419394286],
                        [2e-11, 1.81636961816, 110634.688416288],
                        [2e-11, 5.58793955981, 103917.90082842],
                        [2e-11, 5.79409172557, 417406.450265187],
                        [2e-11, 0.85923934181, 235900.506826261],
                        [2e-11, 4.60084058009, 26941.0995233262],
                        [2e-11, 5.1499567646, 182188.723800143],
                        [2e-11, 3.91756419842, 130446.629254872],
                        [2e-11, 2.88997273266, 27154.3986187642],
                        [3e-11, 5.85721944439, 52329.5850936332],
                        [2e-11, 6.10145799164, 77623.8121384086],
                        [2e-11, 1.98246165585, 77844.2247808474],
                        [2e-11, 0.1107175948, 130866.113898747],
                        [2e-11, 0.64849171165, 52643.7712735028],
                        [2e-11, 3.98410950717, 104466.051854982],
                        [2e-11, 1.83715639115, 123668.805106625],
                        [2e-11, 5.61305711026, 76667.522982438],
                        [2e-11, 5.83992902277, 19804.8272915828],
                        [2e-11, 0.54331921743, 130459.185468771],
                        [2e-11, 0.00997429525, 141762.179806175],
                        [2e-11, 5.59377744943, 35191.8101356918],
                        [2e-11, 0.39746661127, 26521.614879451],
                        [2e-11, 6.1619270402, 130652.814803309],
                        [2e-11, 0.85416063806, 25934.1243310894],
                        [2e-11, 2.18339110714, 156100.820658569],
                        [2e-11, 4.39281517355, 130432.40216087],
                        [2e-11, 5.50117730009, 172402.036444808],
                        [1e-11, 3.49234867738, 130435.634372513],
                        [1e-11, 4.8099549208, 77837.1112338466],
                        [2e-11, 6.26921260007, 87367.6164188402],
                        [2e-11, 2.79561490409, 115674.276664601],
                        [2e-11, 4.92122664455, 24864.0853007956],
                        [1e-11, 2.4157683233, 26037.90651967],
                        [1e-11, 6.04596837149, 129373.020230681],
                        [2e-11, 0.94020572434, 80596.9058175946],
                        [2e-11, 0.30073776192, 51639.001771053],
                        [1e-11, 0.18846827752, 34082.4315835984],
                        [1e-11, 3.62844435085, 161079.372346504],
                        [2e-11, 5.13133615893, 49842.6098902764],
                        [1e-11, 0.30832555285, 53228.0746663368],
                        [1e-11, 5.56519625382, 129387.247324683],
                        [1e-11, 5.63110777945, 46848.3301747656],
                        [1e-11, 1.38420566741, 26011.6370702986],
                        [1e-11, 5.86450783334, 26724.8994135984],
                        [1e-11, 6.14517818644, 76681.7500764396],
                        [1e-11, 3.19299019423, 25654.1914036974],
                        [1e-11, 0.34495954566, 128850.442812587],
                        [1e-11, 3.60230008239, 20760.4270331914],
                        [1e-11, 5.80015495751, 19406.6782881746],
                        [1e-11, 4.42116052212, 100909.037621331],
                        [1e-11, 0.48535289275, 52698.3837012422],
                        [1e-11, 6.22940855233, 111590.288157897],
                        [1e-11, 0.16055219324, 105307.212307905],
                        [1e-11, 2.19795772042, 29428.515568274],
                        [1e-11, 5.09783503526, 102232.848705918],
                        [1e-11, 0.61014627166, 25668.418497699],
                        [1e-11, 5.62459774786, 25565.3257234804],
                        [1e-11, 0.90991571866, 103711.715279983],
                        [1e-11, 0.28037611495, 25450.90686955],
                        [1e-11, 0.54824728173, 26137.8997634784],
                        [1e-11, 4.25324476801, 209812.603684687],
                        [1e-11, 0.08089899001, 51543.0225438352],
                        [1e-11, 0.33953378597, 51528.7954498336],
                        [1e-11, 4.15667461533, 25551.0986294788],
                        [1e-11, 1.59597814656, 72936.2333163398],
                        [1e-11, 5.5936222224, 25619.9381512198],
                        [1e-11, 3.26520760555, 240452.46032332],
                        [1e-11, 5.52286605071, 52125.8096612442],
                      ],
          },
          {
            series => "L3",
            terms  => [
                        [1.88077e-06, 0.03466830117, 52175.8062831484],
                        [1.42152e-06, 3.125054526, 26087.9031415742],
                        [9.6877e-07, 3.00378171915, 78263.7094247226],
                        [4.3669e-07, 6.01867965826, 104351.612566297],
                        [3.5395e-07, 0, 0],
                        [1.8045e-07, 2.77538373991, 130439.515707871],
                        [6.971e-08, 5.81808665742, 156527.418849445],
                        [2.556e-08, 2.57014364454, 182615.321991019],
                        [9e-09, 5.59308888939, 208703.225132594],
                        [3.07e-09, 2.32189002493, 234791.128274168],
                        [1.17e-09, 3.1656732416, 24978.5245894808],
                        [1.02e-09, 5.32134064237, 260879.031415742],
                        [7.7e-10, 6.24155593431, 51066.427731055],
                        [5.7e-10, 6.11222330831, 27197.2816936676],
                        [3.4e-10, 2.03244612467, 286966.934557316],
                        [3.8e-10, 2.99912912226, 77154.3308726292],
                        [3.1e-10, 3.11483471984, 53285.1848352418],
                        [1.7e-10, 6.02950226714, 103242.234014203],
                        [1.1e-10, 5.00109293882, 313054.83769889],
                        [9e-11, 0.59396483404, 20426.571092422],
                        [9e-11, 3.65190477342, 46514.4742339962],
                        [9e-11, 6.28305510644, 79373.087976816],
                        [8e-11, 2.74138109305, 129330.137155778],
                        [7e-11, 5.79018632644, 25132.3033999656],
                        [5e-11, 0.33554769835, 72602.3773755704],
                        [5e-11, 1.3111581035, 26617.5941066688],
                        [4e-11, 2.46414914425, 51220.2065415398],
                        [4e-11, 1.74528964721, 339142.740840465],
                        [4e-11, 4.31141963105, 52705.497248243],
                        [4e-11, 3.07093349506, 27043.5028831828],
                        [4e-11, 5.6801370125, 30639.856638633],
                        [3e-11, 5.80662640937, 155418.040297352],
                        [3e-11, 4.6451908806, 27147.2850717634],
                        [4e-11, 3.02893592955, 23869.1460373874],
                        [3e-11, 4.35199345075, 79323.0913549118],
                        [3e-11, 1.29040630287, 53235.1882133376],
                        [3e-11, 4.34017676059, 14765.2390432698],
                        [3e-11, 2.86652251194, 105460.99111839],
                        [3e-11, 6.23875368963, 28306.660245761],
                        [3e-11, 3.37815322354, 98690.2805171446],
                        [2e-11, 5.37466119262, 110012.944615449],
                        [2e-11, 0.16040583556, 50586.7333878646],
                        [2e-11, 0.35038889636, 19317.1925403286],
                        [2e-11, 6.2327164965, 49957.0491789616],
                        [2e-11, 2.52219274566, 181505.943438926],
                        [2e-11, 5.05358903232, 162188.750898597],
                        [2e-11, 0.15071040297, 124778.183658719],
                        [2e-11, 2.29024350361, 56727.7597802072],
                        [2e-11, 0.42411179784, 71492.998823477],
                        [2e-11, 6.11262694468, 57837.1383323006],
                        [2e-11, 2.17198531948, 108903.566063356],
                        [2e-11, 2.92723030315, 54394.5633873352],
                        [2e-11, 2.40411188609, 83925.0414738748],
                        [2e-11, 3.43613336205, 78267.5907600806],
                        [2e-11, 4.77873510695, 365230.643982039],
                        [2e-11, 3.54043808451, 64741.9579831312],
                        [2e-11, 1.60502923885, 77734.018459628],
                        [2e-11, 3.11800510932, 150866.086800293],
                        [2e-11, 1.0209874609, 78793.4003898172],
                        [2e-11, 4.39439085682, 88476.9949709336],
                        [2e-11, 1.49912329404, 43071.8992890308],
                        [2e-11, 1.96277160647, 25558.2121764796],
                        [2e-11, 4.76774165204, 77204.3274945334],
                        [2e-11, 0.61066658116, 155468.036919256],
                        [2e-11, 5.26875308161, 77308.109683114],
                        [2e-11, 0.5273609502, 94138.3270200858],
                        [2e-11, 2.05793854229, 103396.012824688],
                        [2e-11, 4.12698349577, 66941.0453264182],
                        [2e-11, 5.43336870762, 78283.3791856224],
                        [2e-11, 1.97520131105, 136100.847757023],
                        [2e-11, 5.54343111585, 81706.284369688],
                        [2e-11, 1.25444219651, 40853.142184844],
                        [2e-11, 1.07684180123, 103292.230636108],
                        [1e-11, 3.23979322492, 52156.1365222486],
                        [2e-11, 5.33834891475, 52182.9198301492],
                        [2e-11, 3.36867866204, 99799.659069238],
                        [2e-11, 5.4069790667, 82815.6629217814],
                        [1e-11, 5.80853057947, 4551.9534970588],
                        [1e-11, 4.9590938512, 129483.915966262],
                        [1e-11, 3.17481245588, 76674.6365294388],
                        [1e-11, 1.538031696, 52389.1053785864],
                        [1e-11, 2.48052961456, 53764.8791784322],
                        [1e-11, 1.20843095195, 105410.994496486],
                        [2e-11, 3.64576833526, 45405.0956819028],
                        [2e-11, 4.00710217385, 104881.303531391],
                        [1e-11, 3.0953209452, 76044.9523205358],
                        [1e-11, 5.52119023864, 58946.516884394],
                        [2e-11, 5.53036712466, 131548.894259964],
                        [1e-11, 0.38352295948, 52179.6876185064],
                        [1e-11, 0.08902944955, 51116.4243529592],
                        [1e-11, 1.4751416667, 62389.0918293594],
                        [1e-11, 4.20864838814, 131498.89763806],
                        [1e-11, 2.88161012078, 79219.3091663312],
                        [1e-11, 5.03155341199, 51646.1153180538],
                        [1e-11, 0.05873279909, 53131.406024757],
                        [1e-11, 0.606476206, 38654.054841557],
                        [1e-11, 1.58007357234, 391318.547123613],
                        [1e-11, 0.68687557696, 130969.206672966],
                        [1e-11, 3.90367213586, 129380.133777682],
                        [1e-11, 2.11138180302, 32858.6137428198],
                        [1e-11, 0.18542211423, 78244.0396638228],
                        [1e-11, 1.24063083423, 9103.9069941176],
                        [1e-11, 1.78547815249, 188276.654040172],
                        [1e-11, 0.94125502564, 93028.9484679924],
                        [1e-11, 2.41309932759, 55618.3812281138],
                        [1e-11, 2.29683748973, 52195.4760440482],
                        [1e-11, 3.39284109553, 25028.521211385],
                        [1e-11, 4.29717383023, 26301.2022370122],
                        [1e-11, 6.10639166059, 102132.85546211],
                        [1e-11, 4.58189329524, 37410.5672398786],
                        [1e-11, 6.16145880062, 125887.562210812],
                        [1e-11, 5.22010441376, 52171.9249477904],
                        [1e-11, 5.95645110567, 80482.4665289094],
                        [1e-11, 4.81981872221, 26107.572902474],
                        [1e-11, 4.27546069271, 36301.1886877852],
                        [1e-11, 2.43374991272, 51535.9089968344],
                        [1e-11, 4.03088051207, 1109.3785520934],
                        [1e-11, 5.60495524983, 207593.8465805],
                        [1e-11, 4.89918476796, 35191.8101356918],
                        [1e-11, 6.07747011982, 27676.976036858],
                        [1e-11, 5.48361013686, 29530.4780865396],
                        [1e-11, 0.15288602386, 25448.0058552602],
                        [1e-11, 2.18342825402, 63498.4703814528],
                        [1e-11, 3.67054321453, 21535.9496445154],
                        [1e-11, 1.49815422727, 26084.0218062162],
                        [1e-11, 1.75551273491, 26095.016688575],
                        [1e-11, 2.60061927559, 12566.1516999828],
                        [1e-11, 2.69537843932, 52290.2455718336],
                        [1e-11, 4.87760109673, 25874.6040461362],
                        [1e-11, 2.82170820105, 26091.7844769322],
                        [1e-11, 0.20736391933, 52061.3669944632],
                        [1e-11, 3.82330817663, 68050.4238785116],
                        [1e-11, 4.42501613287, 22645.3281966088],
                        [1e-11, 6.01128227925, 52168.6927361476],
                        [1e-11, 0.28595674172, 11322.6640983044],
                        [1e-11, 5.86280830053, 26202.3424302594],
                        [1e-11, 3.42109354799, 25973.463852889],
                        [1e-11, 0.300500653, 41962.5207369374],
                        [1e-11, 2.73414310032, 25035.6347583858],
                        [1e-11, 1.72346523407, 51962.5071877104],
                        [1e-11, 4.77297529316, 78477.0085201606],
                        [1e-11, 5.84491832575, 50057.04242277],
                        [1e-11, 3.2207229087, 25021.4076643842],
                        [1e-11, 4.74388045372, 26514.5013324502],
                        [1e-11, 4.31760630574, 69159.802430605],
                        [1e-11, 0.65529515413, 426.598190876],
                        [0, 1.96307435492, 1059.3819301892],
                        [1e-11, 5.58694327783, 79852.7823200064],
                        [0, 3.84680432548, 26080.7895945734],
                        [1e-11, 6.07111696987, 102762.539671013],
                        [0, 0.59142287644, 73711.7559276638],
                        [1e-11, 5.84438975852, 105307.212307905],
                        [1e-11, 2.82906439989, 24498.8302462904],
                      ],
          },
          {
            series => "L4",
            terms  => [
                        [1.14078e-06, 3.14159265359, 0],
                        [3.247e-08, 2.02848007619, 26087.9031415742],
                        [1.914e-08, 1.41731803758, 78263.7094247226],
                        [1.727e-08, 4.50137643801, 52175.8062831484],
                        [1.237e-08, 4.49970181057, 104351.612566297],
                        [6.45e-09, 1.26591776986, 130439.515707871],
                        [2.98e-09, 4.30600984981, 156527.418849445],
                        [1.28e-09, 1.05702505039, 182615.321991019],
                        [5.1e-10, 4.08566191934, 208703.225132594],
                        [2e-10, 0.82130394681, 234791.128274168],
                        [8e-11, 3.82199615635, 260879.031415742],
                        [3e-11, 0.54824060574, 286966.934557316],
                        [2e-11, 3.52134138964, 313054.83769889],
                        [1e-11, 1.6743511854, 24978.5245894808],
                        [2e-11, 4.60718203612, 51066.427731055],
                        [1e-11, 1.11396201203, 129330.137155778],
                        [1e-11, 4.35040700322, 103242.234014203],
                        [1e-11, 4.17434865844, 79373.087976816],
                        [1e-11, 1.20388630609, 77154.3308726292],
                        [1e-11, 4.8467708474, 27197.2816936676],
                        [1e-11, 0.29913093643, 339142.740840465],
                        [0, 4.11587125815, 155418.040297352],
                        [0, 0.73293870976, 46514.4742339962],
                        [0, 3.68822427283, 21535.9496445154],
                        [0, 3.83816920045, 20426.571092422],
                        [0, 4.73086078962, 1059.3819301892],
                        [0, 0.40939402954, 24498.8302462904],
                        [0, 3.30678220146, 365230.643982039],
                      ],
          },
          {
            series => "L5",
            terms  => [
                        [8.77e-09, 3.14159265359, 0],
                        [5.9e-10, 3.37513289692, 52175.8062831484],
                        [4.2e-10, 0.02433099382, 78263.7094247226],
                        [4.3e-10, 4.65071406046, 26087.9031415742],
                        [3.1e-10, 2.98112204944, 104351.612566297],
                        [1.9e-10, 6.00992467582, 130439.515707871],
                        [1e-10, 2.7569979192, 156527.418849445],
                        [5e-11, 5.79082359724, 182615.321991019],
                        [2e-11, 2.5143544823, 208703.225132594],
                        [1e-11, 5.49411470932, 234791.128274168],
                        [1e-11, 2.23688504668, 260879.031415742],
                        [1e-11, 5.18718589133, 286966.934557316],
                        [0, 2.11315496491, 313054.83769889],
                      ],
          },
        ],
        [
          {
            series => "B0",
            terms  => [
                        [0.11737528962, 1.98357498767, 26087.9031415742],
                        [0.02388076996, 5.03738959685, 52175.8062831484],
                        [0.01222839532, 3.14159265359, 0],
                        [0.0054325181, 1.79644363963, 78263.7094247226],
                        [0.0012977877, 4.83232503961, 104351.612566297],
                        [0.00031866927, 1.58088495667, 130439.515707871],
                        [7.963301e-05, 4.60972126348, 156527.418849445],
                        [2.014189e-05, 1.35324164694, 182615.321991019],
                        [5.13953e-06, 4.37835409309, 208703.225132594],
                        [2.07674e-06, 4.91772564073, 27197.2816936676],
                        [2.08584e-06, 2.02020294153, 24978.5245894808],
                        [1.32013e-06, 1.11908492283, 234791.128274168],
                        [1.00454e-06, 5.65684734206, 20426.571092422],
                        [1.21395e-06, 1.81271752059, 53285.1848352418],
                        [9.1566e-07, 2.28163128692, 25028.521211385],
                        [9.9214e-07, 0.09391887097, 51116.4243529592],
                        [9.4574e-07, 1.24184909234, 31749.2351907264],
                        [7.8785e-07, 4.4072588, 57837.1383323006],
                        [7.7747e-07, 0.52557061749, 1059.3819301892],
                        [8.4264e-07, 5.08510388314, 51066.427731055],
                        [4.9948e-07, 3.49752993688, 5661.3320491522],
                        [4.6454e-07, 3.23739270829, 77204.3274945334],
                        [4.4767e-07, 4.87849816734, 79373.087976816],
                        [4.0766e-07, 2.46558332165, 46514.4742339962],
                        [3.7378e-07, 4.45768797944, 4551.9534970588],
                        [3.4082e-07, 4.14209210575, 260879.031415742],
                        [3.5911e-07, 1.09057317869, 1109.3785520934],
                        [3.1953e-07, 1.18516389747, 83925.0414738748],
                        [3.0954e-07, 3.5032802721, 21535.9496445154],
                        [3.1808e-07, 2.41474588439, 47623.8527860896],
                        [2.8691e-07, 1.84828614269, 77154.3308726292],
                        [2.5765e-07, 2.77593370583, 27043.5028831828],
                        [2.5199e-07, 3.5906226646, 27147.2850717634],
                        [2.0244e-07, 3.06833797229, 51646.1153180538],
                        [1.8591e-07, 5.5842727444, 73711.7559276638],
                        [1.6971e-07, 0.02791276551, 103292.230636108],
                        [2.0099e-07, 4.06593040301, 25132.3033999656],
                        [1.7002e-07, 6.13739392193, 41962.5207369374],
                        [1.4984e-07, 1.64717994813, 105460.99111839],
                        [1.4186e-07, 0.33074185469, 10213.285546211],
                        [1.5577e-07, 6.07693643204, 53131.406024757],
                        [1.5795e-07, 3.79629547258, 529.6909650946],
                        [1.4011e-07, 5.52786452723, 72602.3773755704],
                        [1.2309e-07, 3.16626298867, 14765.2390432698],
                        [1.1261e-07, 0.11326534696, 13521.7514415914],
                        [1.2448e-07, 4.05109331029, 39609.6545831656],
                        [1.3044e-07, 3.48016433624, 37410.5672398786],
                        [1.1042e-07, 4.23192662377, 110012.944615449],
                        [1.1152e-07, 0.5565846182, 63498.4703814528],
                        [1.0717e-07, 1.53686240986, 25661.3049506982],
                        [1.0213e-07, 2.87881017166, 12566.1516999828],
                        [9.924e-08, 0.94824584866, 65697.5577247398],
                        [1.1047e-07, 5.79741510309, 51749.2080922724],
                        [1.046e-07, 5.82962163777, 50586.7333878646],
                        [9.774e-08, 1.6627176265, 24498.8302462904],
                        [9.412e-08, 1.82364886045, 15874.6175953632],
                        [1.2866e-07, 4.81650804018, 30639.856638633],
                        [9.123e-08, 4.8860439411, 103242.234014203],
                        [9.011e-08, 1.04262074744, 426.598190876],
                        [8.735e-08, 3.04132552652, 68050.4238785116],
                        [8.491e-08, 1.05130498445, 1589.0728952838],
                        [8.835e-08, 0.88128343813, 286966.934557316],
                        [8.823e-08, 5.81343662067, 11322.6640983044],
                        [8.196e-08, 0.84015129448, 51220.2065415398],
                        [7.64e-08, 3.43584035231, 36301.1886877852],
                        [9.175e-08, 6.16059719071, 77734.018459628],
                        [8.897e-08, 0.39691733779, 53235.1882133376],
                        [7.253e-08, 2.37179970828, 99799.659069238],
                        [7.104e-08, 5.73557153523, 26617.5941066688],
                        [8.322e-08, 5.271571288, 25558.2121764796],
                        [6.578e-08, 2.66741925057, 52705.497248243],
                        [5.825e-08, 6.25072627414, 33326.5787331742],
                        [5.625e-08, 3.0803000023, 129380.133777682],
                        [5.295e-08, 1.35863387771, 45892.730433157],
                        [5.116e-08, 2.67576280851, 76674.6365294388],
                        [5.035e-08, 2.66614676257, 77837.1112338466],
                        [4.762e-08, 4.68983196238, 131548.894259964],
                        [5.714e-08, 2.87339047644, 79219.3091663312],
                        [5.601e-08, 5.3719088515, 955.5997416086],
                        [4.965e-08, 3.47619946892, 59414.4818747484],
                        [5.468e-08, 1.43781223143, 56727.7597802072],
                        [4.08e-08, 4.01667499, 91785.460866314],
                        [3.971e-08, 5.44452771841, 6283.0758499914],
                        [4.063e-08, 5.64291749144, 26068.2333806744],
                        [3.877e-08, 3.60887633874, 89586.373523027],
                        [4.047e-08, 5.95235957644, 38654.054841557],
                        [4.064e-08, 1.46283079734, 26107.572902474],
                        [3.681e-08, 0.47365215122, 62389.0918293594],
                        [4.247e-08, 6.23163402945, 40853.142184844],
                        [3.694e-08, 2.75543227024, 7238.6755916],
                        [3.348e-08, 5.91868911857, 43071.8992890308],
                        [4.475e-08, 2.28937952702, 98690.2805171446],
                        [3.115e-08, 0.74943919509, 32858.6137428198],
                        [3.1e-08, 3.35203735852, 19804.8272915828],
                        [3.215e-08, 6.11374633777, 94138.3270200858],
                        [3.558e-08, 0.98820289555, 136100.847757023],
                        [2.908e-08, 4.06284172838, 26514.5013324502],
                        [2.799e-08, 1.63602212056, 129330.137155778],
                        [2.8e-08, 3.88358619611, 77308.109683114],
                        [2.68e-08, 4.48235268618, 71980.6335747312],
                        [2.767e-08, 4.12700796923, 27676.976036858],
                        [3.285e-08, 0.3939808152, 18849.2275499742],
                        [3.29e-08, 2.93487892542, 103821.921601202],
                        [3.048e-08, 0.67698362024, 9103.9069941176],
                        [2.484e-08, 5.4233220496, 125887.562210812],
                        [2.663e-08, 1.70280488847, 16983.9961474566],
                        [2.791e-08, 2.76839978418, 26091.7844769322],
                        [2.747e-08, 5.75135788288, 19317.1925403286],
                        [2.676e-08, 5.73635682216, 78793.4003898172],
                        [2.71e-08, 4.3127490272, 58946.516884394],
                        [2.877e-08, 3.45410696457, 79323.0913549118],
                        [2.787e-08, 4.34025817469, 26084.0218062162],
                        [2.097e-08, 2.09090732812, 23869.1460373874],
                        [2.297e-08, 3.9032125153, 313054.83769889],
                        [2.535e-08, 3.05170623483, 69159.802430605],
                        [2.211e-08, 4.651202109, 28306.660245761],
                        [1.912e-08, 5.78403850812, 102762.539671013],
                        [2.265e-08, 3.34478937379, 22645.3281966088],
                        [1.817e-08, 5.74251490625, 103925.014375421],
                        [1.961e-08, 5.94577427093, 105307.212307905],
                        [1.922e-08, 4.43763124338, 82815.6629217814],
                        [1.667e-08, 4.51887419928, 52195.4760440482],
                        [1.771e-08, 6.12278757535, 155468.036919256],
                        [1.515e-08, 1.7245811583, 54394.5633873352],
                        [1.585e-08, 0.23900687506, 85502.3850163226],
                        [1.477e-08, 4.73359545019, 29530.4780865396],
                        [1.469e-08, 1.44574704924, 157636.797401539],
                        [1.653e-08, 2.41345886386, 52156.1365222486],
                        [1.377e-08, 0.59981573116, 26080.7895945734],
                        [1.43e-08, 0.7841694399, 117873.364007888],
                        [1.68e-08, 3.42684715134, 6770.7106012456],
                        [1.604e-08, 4.52048871587, 3442.5749449654],
                        [1.345e-08, 0.31857167988, 51535.9089968344],
                        [1.357e-08, 3.17349203273, 25874.6040461362],
                        [1.25e-08, 2.33380858079, 25448.0058552602],
                        [1.196e-08, 2.09277609512, 48733.231338183],
                        [1.194e-08, 0.36376300747, 115674.276664601],
                        [1.443e-08, 2.73186009497, 64741.9579831312],
                        [1.375e-08, 5.32672767568, 124778.183658719],
                        [1.325e-08, 3.57805811914, 88476.9949709336],
                        [1.115e-08, 0.26092087309, 639.897286314],
                        [1.094e-08, 2.22755234371, 32370.9789915656],
                        [1.433e-08, 3.03965981318, 66941.0453264182],
                        [1.37e-08, 3.45924813827, 44937.1306915484],
                        [1.003e-08, 0.28769164324, 25934.1243310894],
                        [1.136e-08, 1.11057140999, 52171.9249477904],
                        [1e-08, 0.5245751492, 26241.681952059],
                        [1.033e-08, 2.55563840213, 45405.0956819028],
                        [1.096e-08, 5.01257889902, 7.1135470008],
                        [1.146e-08, 5.40631829059, 213.299095438],
                        [1.08e-08, 5.97835772937, 129909.824742776],
                        [9.88e-09, 1.25815251981, 98068.5367163054],
                        [1.062e-08, 2.88132742088, 120226.23016166],
                        [8.92e-09, 0.63710475446, 103396.012824688],
                        [1.041e-08, 0.89365572198, 52602.4044740244],
                        [9.78e-09, 0.93067667928, 53764.8791784322],
                        [1.136e-08, 5.82023159264, 52179.6876185064],
                        [8.38e-09, 4.66556603681, 155418.040297352],
                        [9.1e-09, 5.53568417425, 58458.8821331398],
                        [8.34e-09, 5.16159172473, 49957.0491789616],
                        [1.1e-08, 4.0215776119, 162188.750898597],
                        [8.05e-09, 1.03425281191, 23969.1392811958],
                        [8.35e-09, 5.28205659749, 50057.04242277],
                        [8.91e-09, 0.21542628779, 105410.994496486],
                        [7.43e-09, 0.86945390288, 52389.1053785864],
                        [7.83e-09, 3.32304812554, 26301.2022370122],
                        [7.11e-09, 1.57780048955, 2118.7638603784],
                        [8.01e-09, 2.18220012579, 151975.465352386],
                        [9.15e-09, 1.71247948367, 51962.5071877104],
                        [8.32e-09, 5.53506450006, 74821.1344797572],
                        [7.5e-09, 2.16183196338, 52168.6927361476],
                        [9.23e-09, 2.50170936928, 104881.303531391],
                        [7.27e-09, 6.05394635764, 95247.7055721792],
                        [6.4e-09, 2.71738158564, 131395.11544948],
                        [6.28e-09, 1.43868691098, 55618.3812281138],
                        [6.22e-09, 3.46102298068, 77623.8121384086],
                        [8.25e-09, 1.00561540075, 85034.4200259682],
                        [6.11e-09, 0.99677911598, 2218.7571041868],
                        [6.05e-09, 4.68164610499, 52182.9198301492],
                        [6.46e-09, 2.57803910757, 128850.442812587],
                        [6.21e-09, 1.16576338077, 108903.566063356],
                        [6.51e-09, 1.60040223342, 26095.016688575],
                        [5.99e-09, 2.51123620954, 130012.917516995],
                        [5.7e-09, 1.27714994259, 78283.3791856224],
                        [6.16e-09, 2.88990323867, 52026.2430860138],
                        [5.53e-09, 5.17654422678, 25938.3399444396],
                        [5.6e-09, 3.32834155275, 51109.3108059584],
                        [5.38e-09, 4.7459289211, 80482.4665289094],
                        [5.14e-09, 5.52495783925, 25021.4076643842],
                        [5.12e-09, 2.12021253064, 25035.6347583858],
                        [5.45e-09, 1.31029342517, 26555.8681319286],
                        [4.75e-09, 4.05390077061, 149.5631971346],
                        [4.64e-09, 3.26222495894, 111590.288157897],
                        [4.6e-09, 5.34048307893, 46848.3301747656],
                        [5.5e-09, 5.84636069235, 25619.9381512198],
                        [4.47e-09, 3.5768857164, 1066.49547719],
                        [5.5e-09, 6.22077946049, 51123.53789996],
                        [5.96e-09, 0.6449235299, 339142.740840465],
                        [4.84e-09, 3.16177806139, 38519.945791972],
                        [4.41e-09, 0.67395966884, 1052.2683831884],
                        [4.77e-09, 0.22606306742, 71025.0338331226],
                        [4.23e-09, 2.08215220948, 76144.9455643442],
                        [4.72e-09, 3.35508518254, 35191.8101356918],
                        [4.18e-09, 3.57908956341, 52329.5850936332],
                        [4.41e-09, 4.91196768491, 78050.4103292846],
                        [4.4e-09, 4.47866581814, 183724.700543113],
                        [4.35e-09, 1.98197259533, 26094.5317004742],
                        [5.64e-09, 5.45416215614, 78244.0396638228],
                        [5.4e-09, 2.87570725847, 181555.94006083],
                        [4.5e-09, 6.09063658976, 93028.9484679924],
                        [4.61e-09, 3.82361162048, 143961.267149462],
                        [4.08e-09, 3.34314470563, 52022.0274726636],
                        [4.12e-09, 2.07516355558, 150866.086800293],
                        [4.35e-09, 5.12507754577, 26081.2745826742],
                        [4.09e-09, 0.56822912556, 64607.8489335462],
                        [3.88e-09, 4.16039183226, 78259.8280893646],
                        [3.93e-09, 3.23715146834, 13655.8604911764],
                        [3.75e-09, 5.33297275541, 26011.6370702986],
                        [4.67e-09, 5.77388878977, 90829.8611247054],
                        [3.5e-09, 5.62301652558, 71492.998823477],
                        [3.52e-09, 3.27694758804, 26727.8004278882],
                        [3.5e-09, 3.39302729957, 141762.179806175],
                        [3.9e-09, 2.58800166779, 78267.5907600806],
                        [3.65e-09, 3.19925143022, 52099.5402118728],
                        [4.33e-09, 1.5518516339, 20760.4270331914],
                        [3.27e-09, 5.69228054184, 12432.0426503978],
                        [3.39e-09, 1.5808857282, 45494.5814297488],
                        [3.38e-09, 2.73161573173, 155997.727884351],
                        [3.15e-09, 4.00061444247, 78477.0085201606],
                        [4.35e-09, 0.36408526333, 114564.898112508],
                        [3.44e-09, 5.02616143626, 78256.5958777218],
                        [3.46e-09, 4.14121333484, 111122.323167542],
                        [2.86e-09, 5.40513646014, 6681.2248533996],
                        [2.83e-09, 3.65516534367, 76.2660712756],
                        [3.25e-09, 4.3041208046, 124156.43985788],
                        [3.64e-09, 2.32771554672, 84546.785274714],
                        [3.31e-09, 0.768825599, 188276.654040172],
                        [2.67e-09, 3.81778097058, 19406.6782881746],
                        [2.7e-09, 6.02010732963, 78114.146227588],
                        [2.73e-09, 3.6672618024, 129483.915966262],
                        [2.63e-09, 0.18743596408, 77197.2139475326],
                        [2.68e-09, 3.25051884036, 131498.89763806],
                        [2.84e-09, 1.93848296863, 76044.9523205358],
                        [2.95e-09, 5.53951004419, 130969.206672966],
                        [3.35e-09, 5.92048177497, 146314.133303234],
                        [2.46e-09, 1.45343047775, 78270.8229717234],
                        [2.59e-09, 3.0824170478, 77211.4410415342],
                        [2.53e-09, 2.86398164134, 121335.608713753],
                        [3.38e-09, 3.9582339601, 78690.3076155986],
                        [3.17e-09, 3.9813836922, 79852.7823200064],
                        [2.32e-09, 4.66776441683, 28206.6670019526],
                        [2.47e-09, 1.40414696612, 181505.943438926],
                        [2.28e-09, 0.25677390582, 103711.715279983],
                        [2.19e-09, 4.69799359762, 71582.484571323],
                        [2.21e-09, 4.46394113791, 81706.284369688],
                        [2.54e-09, 1.43735157085, 5327.4761083828],
                        [1.99e-09, 5.76674433704, 157483.018591054],
                        [2.53e-09, 2.47481215159, 72936.2333163398],
                        [1.91e-09, 4.17749403686, 134991.46920493],
                        [2.46e-09, 5.2155277312, 178063.368493961],
                        [1.82e-09, 4.31488794636, 104371.282327197],
                        [2.06e-09, 1.62004139707, 106570.369670484],
                        [2.34e-09, 2.1897992144, 100909.037621331],
                        [1.76e-09, 3.58325574282, 48835.1938564486],
                        [1.88e-09, 2.58568452037, 51707.841292794],
                        [1.77e-09, 1.8946109513, 52169.1777242484],
                        [1.68e-09, 3.01264496377, 23754.7067487022],
                        [2.22e-09, 4.35573235377, 52643.7712735028],
                        [1.69e-09, 5.25194313253, 102232.848705918],
                        [1.88e-09, 5.55333225508, 156100.820658569],
                        [1.63e-09, 1.72109994467, 104138.313470859],
                        [2.05e-09, 5.64507146979, 154938.345954161],
                        [1.61e-09, 0.06514575292, 78187.443353447],
                        [1.55e-09, 3.29540644622, 97112.9369746968],
                        [1.52e-09, 1.66425291176, 25654.1914036974],
                        [1.79e-09, 2.20248310353, 104331.942805397],
                        [1.57e-09, 5.91615237188, 51742.0945452716],
                        [1.76e-09, 5.03409571975, 52182.4348420484],
                        [1.45e-09, 0.34814763869, 78417.4882352074],
                        [1.51e-09, 0.8401618205, 26237.4663387088],
                        [1.43e-09, 0.36102957131, 27154.3986187642],
                        [1.42e-09, 5.87490895177, 26037.90651967],
                        [1.67e-09, 4.43520444137, 25668.418497699],
                        [1.37e-09, 2.8508932935, 119116.851609567],
                        [1.61e-09, 5.91020381915, 207643.843202404],
                        [1.3e-09, 6.26801612444, 137678.191299471],
                        [1.3e-09, 0.93376066695, 433.7117378768],
                        [1.4e-09, 1.22522976768, 26137.8997634784],
                        [1.44e-09, 4.56326656247, 419.4846438752],
                        [1.45e-09, 2.53141564902, 116917.76426628],
                        [1.45e-09, 3.74606280935, 27140.1715247626],
                        [1.55e-09, 3.65976494728, 365230.643982039],
                        [1.24e-09, 0.92716868075, 104347.731230939],
                        [1.4e-09, 0.1128733417, 78109.9306142378],
                        [1.26e-09, 1.13823138141, 51322.6099013964],
                        [1.46e-09, 3.25675289634, 3340.6124266998],
                        [1.22e-09, 5.10611624534, 176953.989941867],
                        [1.25e-09, 5.63666753628, 104355.493901655],
                        [1.55e-09, 2.3086138149, 51756.3216392732],
                        [1.36e-09, 3.41914767255, 140652.801254082],
                        [1.15e-09, 6.25299482333, 39743.7636327506],
                        [1.13e-09, 0.79353194356, 7994.5284420242],
                        [1.26e-09, 0.12477487369, 52815.7035694624],
                        [1.21e-09, 0.68099507149, 50483.640613646],
                        [1.18e-09, 0.87294905519, 137210.226309117],
                        [1.12e-09, 2.41390426449, 97580.9019650512],
                        [1.3e-09, 1.22267912068, 209812.603684687],
                        [1.1e-09, 3.15687226733, 25234.7067598222],
                        [1.09e-09, 2.85465805569, 24395.7374720718],
                        [1.08e-09, 5.7358716071, 853.196381752],
                        [1.41e-09, 4.76875897743, 28421.0995344462],
                        [1.43e-09, 0.57659923971, 170049.170291037],
                        [1.27e-09, 5.39590556187, 110634.688416288],
                        [1.1e-09, 0.79294568581, 104564.911661735],
                        [1.03e-09, 5.77115680934, 182085.631025925],
                        [1.08e-09, 0.78147749534, 42153.969003049],
                        [1.01e-09, 6.24176236571, 1692.1656695024],
                        [1.25e-09, 1.72822604057, 104344.499019296],
                        [1.12e-09, 1.53691309669, 18093.37469955],
                        [1e-09, 6.03656277681, 147423.511855328],
                        [1.02e-09, 2.16777222106, 32769.1279949738],
                        [1.27e-09, 5.69552946334, 44181.2778411242],
                        [9.6e-10, 2.81662615895, 104202.049369162],
                        [9.4e-10, 6.16378269144, 103299.344183108],
                        [9.5e-10, 3.08582674985, 70269.1809826984],
                        [9.6e-10, 3.26682732105, 103285.117089107],
                        [1.01e-09, 1.49832461293, 40565.2543247742],
                        [9.9e-10, 0.11817727117, 167850.08294775],
                        [9.9e-10, 3.80154992347, 214364.557181746],
                        [9.3e-10, 3.27120904242, 90695.7520751204],
                        [1.04e-09, 5.35405285854, 126996.940762906],
                        [1.05e-09, 0.73008875321, 104778.210757173],
                        [8.9e-10, 2.82753100547, 50579.6198408638],
                        [9.8e-10, 0.55393078868, 33967.9922949132],
                        [8.7e-10, 1.47928882834, 97670.3877128972],
                        [1.17e-09, 0.17401840597, 61279.713277266],
                        [8.9e-10, 0.41552735762, 26164.1692128498],
                        [9.1e-10, 2.28447351962, 157057.10981454],
                        [1.03e-09, 2.67784306575, 172402.036444808],
                        [8.4e-10, 4.31852113132, 60055.8954364874],
                        [8.5e-10, 4.50666554965, 104358.726113298],
                        [9.8e-10, 0.74967522191, 105940.685461581],
                        [8.2e-10, 2.80078395016, 52101.0246845811],
                        [8.6e-10, 0.38069361609, 74923.0969980228],
                        [7.7e-10, 4.91602955543, 24491.7166992896],
                        [1.04e-09, 6.08692240129, 10021.8372800994],
                        [9.4e-10, 2.2175482918, 25973.463852889],
                        [7.9e-10, 4.63574888508, 2333.196392872],
                        [7.6e-10, 0.0667660763, 157586.800779634],
                        [7.6e-10, 4.09119863738, 1596.1864422846],
                        [8.9e-10, 0.51926466594, 50593.8469348654],
                        [7.8e-10, 5.85412082904, 18207.8139882352],
                        [8.3e-10, 1.48347794862, 54294.5701435268],
                        [1.02e-09, 1.11648927836, 150244.342999454],
                        [8.1e-10, 0.43168464249, 155571.819107837],
                        [7.1e-10, 2.77560894834, 77829.9976868458],
                        [9.8e-10, 3.04617186486, 16066.0658614748],
                        [8.9e-10, 3.91487126164, 68241.8721446232],
                        [7.6e-10, 3.32839538947, 129799.618421557],
                        [9.1e-10, 4.99146967087, 102132.85546211],
                        [8.8e-10, 4.54401955709, 51543.0225438352],
                        [9.2e-10, 4.8882571486, 26202.3424302594],
                        [6.6e-10, 1.97272013972, 632.7837393132],
                        [6.6e-10, 1.34921841483, 52808.5900224616],
                        [7.1e-10, 1.2155124162, 107794.187511262],
                        [8.8e-10, 3.90671333341, 74.7815985673],
                        [7.6e-10, 1.1168426292, 78731.674415077],
                        [6e-10, 4.94665488683, 78257.0808658226],
                        [6.7e-10, 4.24719146625, 14477.3511832],
                        [6.9e-10, 5.46721744006, 77844.2247808474],
                        [5.9e-10, 2.80000354604, 25863.5583458723],
                        [6e-10, 4.23924716288, 52225.8029050526],
                        [5.9e-10, 5.90340687048, 103.0927742186],
                        [5.9e-10, 3.81127888964, 76571.5437552202],
                        [6e-10, 5.62072757879, 77795.7444343682],
                        [6.9e-10, 4.36673018646, 207593.8465805],
                        [6.6e-10, 0.49890308433, 51951.4614874465],
                        [5.8e-10, 1.63810168022, 51013.3315787406],
                        [5.8e-10, 4.28286858594, 77410.5130429706],
                        [6.6e-10, 0.61313044187, 51639.001771053],
                        [5.7e-10, 3.15657420172, 104275.346495021],
                        [5.8e-10, 4.41262101447, 26720.6868808874],
                        [7.5e-10, 0.13973480485, 1581.959348283],
                        [5.7e-10, 0.41985749035, 23439.4483161012],
                        [6.9e-10, 6.04001555481, 29428.515568274],
                        [5.5e-10, 0.87548003173, 161079.372346504],
                        [5.4e-10, 2.10504641371, 2648.454825473],
                        [7e-10, 1.90064683191, 204151.271635535],
                        [5.4e-10, 3.73359360369, 24925.4284371664],
                        [5.5e-10, 4.74493087072, 49527.3514576754],
                        [7.1e-10, 2.67007207774, 24505.9437932912],
                        [5.7e-10, 1.10422154948, 130459.185468771],
                        [6.8e-10, 5.29164108644, 26013.1215430069],
                        [5.4e-10, 0.06047544079, 52072.7135089298],
                        [5.3e-10, 0.0641936055, 536.8045120954],
                        [5.3e-10, 5.00852687358, 25977.6968203548],
                        [5.2e-10, 4.1740388604, 25131.6139856036],
                        [5.2e-10, 3.31036935415, 7880.08915333899],
                        [7e-10, 6.10702300469, 52278.899057367],
                        [5.9e-10, 1.97971323674, 51219.5171271778],
                        [5.2e-10, 0.17883872581, 224.3447957019],
                        [5.7e-10, 2.64616122722, 52125.8096612442],
                        [5.1e-10, 2.51127480556, 183570.921732628],
                        [5e-10, 4.67814206741, 130226.216612433],
                        [5e-10, 4.7732602477, 25780.3455206046],
                        [5.3e-10, 2.8157918125, 55516.4187098482],
                        [5.7e-10, 2.13355985608, 128320.751847493],
                        [4.9e-10, 2.32162107938, 26395.4607625438],
                        [4.9e-10, 4.96049794937, 956.2891559706],
                        [4.7e-10, 4.20636709156, 52250.5878817157],
                        [5.8e-10, 2.23088591593, 52065.599961929],
                        [4.8e-10, 5.31209962934, 1162.4747044078],
                        [6.2e-10, 6.11793881, 22747.2907148744],
                        [5.1e-10, 5.16823572193, 130419.845946971],
                        [5.8e-10, 1.50494628165, 54509.0026760204],
                        [6e-10, 0.43836944868, 116783.655216695],
                        [5.9e-10, 1.50474668065, 26507.3877854494],
                        [4.7e-10, 3.28426374672, 25565.3257234804],
                        [5.6e-10, 2.45288584577, 181026.249095736],
                        [5.1e-10, 3.46813929041, 53242.3017603384],
                        [4.5e-10, 0.64303440167, 52698.3837012422],
                        [4.9e-10, 0.43622928396, 27999.1026247914],
                        [4.6e-10, 0.93537805397, 26162.6847401415],
                        [4.3e-10, 5.95311422864, 76667.522982438],
                        [6e-10, 1.79764830651, 78270.3379836226],
                        [5.6e-10, 2.27809233545, 182188.723800143],
                        [4.3e-10, 3.95909386803, 26521.614879451],
                        [4.3e-10, 2.06740816154, 51859.4144134918],
                        [5.1e-10, 5.31772214752, 66653.1574663484],
                        [4.4e-10, 1.68470111077, 23888.8157982872],
                        [5.4e-10, 3.94217571152, 52325.369480283],
                        [4.3e-10, 5.1386495594, 11610.5519583742],
                        [4.2e-10, 4.61363107691, 52492.198152805],
                        [4.6e-10, 3.39633739377, 104505.391376782],
                        [4.6e-10, 4.83387098498, 110.2063212194],
                        [4.5e-10, 3.54092987543, 50800.0324833026],
                        [4.1e-10, 5.69167231584, 24712.1293417284],
                        [4e-10, 0.05181171325, 123200.840116271],
                        [5.3e-10, 0.61042891791, 53228.0746663368],
                        [3.9e-10, 3.11194295827, 25984.8103673556],
                        [4.6e-10, 2.5352841036, 50696.939709084],
                        [3.8e-10, 4.44293961717, 29416.0387978544],
                        [4.1e-10, 2.66264705448, 233731.746343979],
                        [3.7e-10, 3.37388547918, 1375.7737998458],
                        [3.8e-10, 5.61891042604, 143005.667407854],
                        [3.7e-10, 5.42828179354, 28286.9904848612],
                        [4.9e-10, 5.33653478407, 99024.136457914],
                        [4e-10, 5.63484527365, 522.5774180938],
                        [3.9e-10, 3.40419666656, 25551.0986294788],
                        [3.6e-10, 5.94925007197, 145204.754751141],
                        [3.8e-10, 2.07740095188, 153084.84390448],
                        [3.9e-10, 3.20021878147, 163766.094441045],
                        [3.7e-10, 5.22659089943, 52595.2909270236],
                        [4.2e-10, 4.90625897857, 25771.5112719176],
                        [4.1e-10, 2.99128318097, 26190.9959157928],
                        [4.4e-10, 1.11685231827, 26404.2950112308],
                        [4.5e-10, 4.61987657347, 132658.272812058],
                        [3.7e-10, 0.21788276252, 166740.704395656],
                        [3.4e-10, 1.94222980062, 203041.893083441],
                        [4.5e-10, 3.16157322891, 104197.833755812],
                        [4.6e-10, 4.46372826281, 316.3918696566],
                        [3.9e-10, 2.02681719442, 136722.591557862],
                        [3.4e-10, 1.34191646454, 467.9649903544],
                        [4.3e-10, 3.34582658464, 78903.6067110366],
                        [3.9e-10, 3.65232351757, 196137.073432611],
                        [3.7e-10, 0.3728911138, 391318.547123613],
                        [3.7e-10, 2.88378512797, 36109.7404216736],
                        [3.7e-10, 1.66197775716, 52290.2455718336],
                        [3.6e-10, 3.91856090884, 54087.0057663656],
                        [3.4e-10, 0.07777074766, 26294.0886900114],
                        [3.3e-10, 2.57658065167, 26941.0995233262],
                        [3.4e-10, 1.66706631543, 49842.6098902764],
                        [4.2e-10, 3.65143192554, 76681.7500764396],
                        [3.2e-10, 4.02685079656, 24356.7807886416],
                        [4.1e-10, 3.48117117726, 26610.480559668],
                        [4e-10, 1.30798263894, 77630.9256854094],
                        [3.3e-10, 3.31591322468, 65831.6667743248],
                        [4.2e-10, 4.68305225464, 24609.0365675098],
                        [3.4e-10, 2.43308912753, 26421.7590823436],
                        [3.1e-10, 0.55207634036, 13362.4497067992],
                        [3.1e-10, 3.97168176907, 130435.634372513],
                        [3.5e-10, 5.90195011358, 78188.9278261553],
                        [3.2e-10, 5.58275762493, 25881.717593137],
                        [3.2e-10, 3.03394602316, 27780.0688110766],
                        [3.8e-10, 4.616024782, 130432.40216087],
                        [3.1e-10, 5.37268049479, 75930.5130318506],
                        [3.4e-10, 4.68006477569, 25754.0472008048],
                        [3e-10, 2.7691739915, 173511.414996902],
                        [3.7e-10, 4.3753749777, 1478.8665740644],
                        [3e-10, 2.69970929614, 208173.534167499],
                        [2.9e-10, 2.28199342452, 130443.397043229],
                        [3.9e-10, 4.04390928499, 34282.1784747828],
                        [3.3e-10, 1.47153495142, 55503.9419394286],
                        [2.9e-10, 3.09374594552, 27819.0254945068],
                        [3e-10, 2.30968283835, 26624.7076536696],
                        [3.5e-10, 2.18534594257, 22759.767485294],
                        [2.7e-10, 0.63624513172, 240452.46032332],
                        [3.5e-10, 5.4058831234, 58857.031136548],
                        [2.8e-10, 5.46904052697, 123668.805106625],
                        [2.8e-10, 3.82629644574, 130866.113898747],
                        [2.7e-10, 3.91273567728, 163298.129450691],
                        [3.2e-10, 3.55783772742, 52252.072354424],
                        [3.6e-10, 5.26852179816, 52061.3669944632],
                        [2.7e-10, 0.81868301401, 25455.119402261],
                        [3e-10, 6.23608007707, 24176.703658357],
                        [2.5e-10, 1.48874402537, 60370.081616357],
                        [2.7e-10, 4.41957053501, 78896.4931640358],
                        [2.5e-10, 3.33404428554, 206.1855484372],
                        [2.5e-10, 2.22580879047, 12725.453434775],
                        [2.5e-10, 5.37774707105, 183145.012956114],
                        [2.6e-10, 3.83674753452, 132028.588603155],
                        [2.5e-10, 2.9360535584, 129387.247324683],
                        [2.5e-10, 5.8616145474, 130289.952510736],
                        [2.4e-10, 4.03572089813, 26089.3876142825],
                        [2.4e-10, 3.09138745629, 26086.4186688659],
                        [2.4e-10, 1.4045297785, 25446.4895798352],
                        [3.3e-10, 3.35253473958, 193937.986089324],
                        [2.4e-10, 4.8134227557, 27311.7209823528],
                        [2.4e-10, 2.36840229716, 25440.8923082594],
                        [2.4e-10, 2.60590286552, 125112.039599488],
                        [2.7e-10, 2.64006708171, 44295.7171298094],
                        [2.9e-10, 3.85906422319, 130652.814803309],
                        [3.3e-10, 4.2600726241, 235900.506826261],
                        [2.6e-10, 3.37356285012, 87367.6164188402],
                        [2.4e-10, 3.83432680564, 52381.9918315856],
                        [2.7e-10, 4.14811634858, 176332.246141028],
                        [2.3e-10, 0.19227535404, 647.0108333148],
                        [2.5e-10, 0.03897225418, 129373.020230681],
                        [2.3e-10, 5.73072631591, 26729.3167033132],
                        [2.6e-10, 2.78110886808, 64901.2597179234],
                        [2.8e-10, 6.14191568069, 38813.3565763492],
                        [2.5e-10, 5.64677901976, 198489.939586383],
                        [2.2e-10, 2.4748926331, 24864.0853007956],
                        [2.3e-10, 4.2668224139, 26222.0121911592],
                        [2.4e-10, 4.52962335246, 123758.290854471],
                        [2.3e-10, 2.88962909157, 25953.7940919892],
                        [2.8e-10, 4.67408679361, 80382.473285101],
                        [2.1e-10, 2.19925857864, 23866.0465069772],
                        [2.5e-10, 0.81737451667, 94329.7752861974],
                        [2.1e-10, 5.56863005528, 52712.6107952438],
                        [2.1e-10, 0.94657470314, 27684.0895838588],
                        [2.3e-10, 1.24923754668, 130446.629254872],
                        [2.2e-10, 1.55521175306, 24998.1943503806],
                        [2.4e-10, 3.25930776298, 27669.8624898572],
                        [2.1e-10, 3.16657819785, 183674.703921209],
                        [2e-10, 1.45970914613, 75615.2545992496],
                        [2.8e-10, 2.65124448902, 78366.8021989412],
                        [2.1e-10, 2.85719729554, 78160.616650504],
                        [2.2e-10, 0.14164137879, 51528.7954498336],
                        [2.2e-10, 1.54435105177, 158746.175953632],
                        [1.9e-10, 1.95606380894, 25344.9130810416],
                        [1.9e-10, 3.62491058376, 78039.3646290207],
                        [1.9e-10, 2.59809360557, 17893.6278083656],
                        [1.9e-10, 5.86487152937, 103917.90082842],
                        [1.9e-10, 5.07516493363, 230239.174777109],
                        [2.3e-10, 1.73809221823, 128220.758603684],
                        [1.8e-10, 3.70453311537, 77726.9049126272],
                        [2e-10, 5.58951443277, 27177.6119327678],
                        [1.9e-10, 2.26298959398, 103932.127922422],
                        [1.8e-10, 5.26103373994, 28736.3579670472],
                        [1.8e-10, 4.77075669731, 77101.2347203148],
                        [1.9e-10, 4.18613339997, 104819.577556651],
                        [1.9e-10, 3.72825596269, 31415.379249957],
                        [1.8e-10, 5.11985094325, 77307.420268752],
                        [1.9e-10, 1.61447515906, 51653.2288650546],
                        [2.2e-10, 3.45569006244, 101011.000139597],
                        [1.7e-10, 3.34823797519, 23919.1426592916],
                        [1.7e-10, 0.84289136609, 86143.7985780616],
                        [1.8e-10, 0.8199762803, 26073.6760475726],
                        [2e-10, 0.96632907921, 52609.5180210252],
                        [1.6e-10, 1.27839838984, 51868.2486621788],
                        [2e-10, 0.07187923898, 155887.521563131],
                        [1.8e-10, 5.44524309894, 25508.2155545754],
                        [1.6e-10, 0.6272245515, 102659.446896794],
                        [1.6e-10, 0.52102795891, 2221.856634597],
                        [1.7e-10, 3.93009669878, 51852.300866491],
                        [1.6e-10, 5.7418031822, 96357.0841242726],
                        [1.9e-10, 5.09029341511, 118828.963749497],
                        [1.7e-10, 2.59947793429, 24448.8336243862],
                        [1.6e-10, 5.52244950928, 2199.087343287],
                        [1.5e-10, 3.36667960581, 1911.1994832172],
                        [2.1e-10, 3.53223071778, 181659.722249411],
                        [1.9e-10, 1.29524947399, 233681.749722074],
                        [1.6e-10, 1.11236515889, 103498.416184545],
                        [2e-10, 3.19274792861, 51969.6207347112],
                        [1.7e-10, 3.27645001526, 26312.2479372761],
                        [1.6e-10, 5.54159968247, 207114.15223731],
                        [1.5e-10, 2.75565944373, 26709.6469424134],
                        [1.5e-10, 1.72732606714, 104344.984007397],
                        [1.6e-10, 5.31828785394, 78153.5031035032],
                        [1.6e-10, 1.13565154505, 742.9900605326],
                        [1.5e-10, 6.19247438386, 130363.249636595],
                        [1.5e-10, 1.16646378812, 92741.0606079226],
                        [1.5e-10, 4.39941321864, 25466.159340735],
                        [1.4e-10, 1.03341872997, 78313.7060466268],
                        [1.6e-10, 1.77081422797, 27044.1922975448],
                        [1.6e-10, 1.77854347809, 26667.590728573],
                        [1.4e-10, 2.39782698608, 103883.647575942],
                        [1.9e-10, 6.27226219255, 25764.3977249168],
                        [1.4e-10, 1.89621592736, 37698.4550999484],
                        [1.4e-10, 5.86393829627, 81604.3218514224],
                        [1.5e-10, 2.41952075336, 27250.377845982],
                        [1.7e-10, 5.6237861587, 51432.8162226158],
                        [1.4e-10, 0.57479381854, 8194.2753332086],
                        [1.4e-10, 2.0191587364, 156507.749088545],
                        [1.4e-10, 4.00033644851, 187167.275488078],
                        [1.6e-10, 3.05516572588, 22625.658435709],
                        [1.4e-10, 0.41333257896, 76887.9356248768],
                        [1.4e-10, 3.81333935444, 28256.6636238568],
                        [1.6e-10, 5.63829774136, 209658.824874202],
                        [1.7e-10, 2.79674558169, 323.5054166574],
                        [1.5e-10, 4.52292533775, 27726.9726587622],
                        [1.7e-10, 1.61686538851, 26198.1094627936],
                        [1.7e-10, 4.2862866237, 133882.090652836],
                        [1.3e-10, 1.02936352404, 25867.4904991354],
                        [1.4e-10, 5.57651447296, 2008.557539159],
                        [1.4e-10, 1.55161726953, 156314.119754007],
                        [1.7e-10, 6.07989986315, 49953.9496485514],
                        [1.5e-10, 4.87081069542, 104358.241125197],
                        [1.3e-10, 3.77228393975, 19.66976089979],
                        [1.5e-10, 5.4142973337, 208276.626941718],
                        [1.3e-10, 1.15273910706, 949.1756089698],
                        [1.7e-10, 4.64614224273, 112231.701719636],
                        [1.5e-10, 5.32485053265, 154408.654989067],
                        [1.3e-10, 4.02426203972, 417406.450265187],
                        [1.3e-10, 2.83441937048, 25169.9728555924],
                        [1.6e-10, 3.55004561005, 86457.9847579312],
                        [1.4e-10, 3.36717179008, 12546.481939083],
                        [1.3e-10, 0.99900287294, 78338.4910232899],
                        [1.2e-10, 3.72935261349, 78786.2868428164],
                        [1.3e-10, 4.55769261775, 80596.9058175946],
                        [1.3e-10, 3.68794178346, 79315.977807911],
                        [1.4e-10, 4.16918945992, 156547.088610345],
                        [1.2e-10, 3.12295185577, 149288.743257845],
                        [1.2e-10, 2.69822851627, 153.7788104848],
                        [1.2e-10, 4.38117483432, 27005.833427556],
                        [1.2e-10, 0.19322533903, 27463.67694142],
                        [1.4e-10, 4.1512708228, 29550.1478474394],
                        [1.2e-10, 2.80411772823, 102755.426124012],
                        [1.1e-10, 5.82734448081, 259819.649485553],
                        [1.1e-10, 2.40607503106, 169093.570549428],
                        [1.2e-10, 0.49737747696, 102769.653218014],
                        [1.4e-10, 5.69923121834, 76784.8428506582],
                        [1.2e-10, 5.56466695759, 26402.0893214438],
                        [1.2e-10, 1.48301102812, 78580.1012943792],
                        [1.1e-10, 5.15388067065, 77947.317555066],
                        [1.1e-10, 1.64586759073, 25773.7169617046],
                        [1.1e-10, 2.45779334771, 34082.4315835984],
                        [1.4e-10, 2.00354520885, 846.0828347512],
                        [1.3e-10, 0.71980668578, 78413.2726218572],
                        [1.1e-10, 5.17906120193, 162810.494699437],
                        [1.1e-10, 2.73596940194, 171292.657892715],
                        [1.1e-10, 5.59141622457, 24203.0019781568],
                        [1.1e-10, 0.45608202666, 2111.6503133776],
                        [1e-10, 3.29404880642, 192828.60753723],
                        [1e-10, 0.458570525, 222224.976574185],
                        [1.3e-10, 5.70684493376, 78213.7128028184],
                        [1.1e-10, 4.37474459591, 103718.828826984],
                        [1.1e-10, 0.63918585951, 26118.2300025786],
                        [1.3e-10, 5.83092856998, 26411.4085582316],
                        [1e-10, 5.45367935399, 52483.363904118],
                        [1e-10, 4.70344741563, 2125.8774073792],
                        [1.1e-10, 0.28816338163, 26057.5762805698],
                        [1e-10, 5.5776490348, 151199.942741062],
                        [1.1e-10, 0.03362968403, 104991.509852611],
                        [1e-10, 3.71565881071, 148532.890407421],
                        [1.3e-10, 0.25119201649, 79330.2049019126],
                        [1e-10, 6.23763004539, 128106.319314999],
                        [1.1e-10, 6.23138757669, 130285.736897386],
                        [1.3e-10, 3.60703035316, 39629.3243440654],
                        [1.1e-10, 2.08623018213, 78683.1940685978],
                        [1.1e-10, 2.89478268807, 122444.987265847],
                        [1.1e-10, 1.47224457688, 156520.305302444],
                        [1.2e-10, 0.18308102701, 130593.294518356],
                        [9e-11, 5.24611723729, 138319.60486121],
                        [9e-11, 5.64920582852, 1265.5674786264],
                        [9e-11, 6.25551575071, 53906.928636081],
                        [1.1e-10, 3.36985744471, 142871.558358269],
                        [9e-11, 5.47085206361, 156531.300184803],
                        [9e-11, 4.79150958411, 101703.157740824],
                        [9e-11, 2.73233240797, 38.1330356378],
                        [9e-11, 5.91954900221, 62197.6435632478],
                        [9e-11, 4.73154570336, 78378.1487134078],
                        [1.1e-10, 0.80389582741, 3328.13565628019],
                        [9e-11, 6.25489842872, 91919.569915899],
                        [9e-11, 5.87197255624, 199599.318138476],
                        [9e-11, 0.76033087382, 156523.537514087],
                        [8e-11, 0.63159267832, 80174.9089079398],
                        [9e-11, 5.02352759781, 229129.796225016],
                        [8e-11, 2.63272452796, 25138.7275326044],
                        [8e-11, 0.59154768044, 156954.017040321],
                        [8e-11, 3.95681232703, 120417.678427772],
                        [8e-11, 3.46882638388, 77616.6985914078],
                        [8e-11, 0.20349823136, 113455.519560414],
                        [8e-11, 0.21724719953, 13541.4212024912],
                        [8e-11, 1.77719128692, 26076.8574413103],
                        [9e-11, 6.2187869044, 189853.997582619],
                        [7e-11, 5.887681462, 51226.6306741786],
                        [7e-11, 0.61161547244, 158116.491744729],
                        [8e-11, 2.05860519043, 78149.2701360374],
                        [7e-11, 0.09500184933, 90989.1628594976],
                        [7e-11, 0.56541937862, 25985.9406233086],
                        [7e-11, 0.73212945216, 78469.8949731598],
                        [7e-11, 0.44088896603, 104127.267770595],
                        [8e-11, 5.86653927002, 104454.705340515],
                        [7e-11, 0.70585294359, 52177.2907558567],
                        [9e-11, 1.96929942879, 1272.6810256272],
                        [1e-10, 2.72173324175, 104276.830967729],
                        [7e-11, 5.1631579803, 26189.8656598398],
                        [7e-11, 5.1707974073, 179172.747046054],
                        [8e-11, 5.26981396126, 48847.6706268682],
                        [8e-11, 0.19880797043, 1.4844727083],
                        [7e-11, 6.26371276121, 52174.3218104401],
                        [8e-11, 0.98956493578, 16703.062133499],
                        [7e-11, 0.08448723866, 26098.9488418381],
                        [8e-11, 5.67030179581, 53029.0026649004],
                        [7e-11, 1.15333561308, 261988.409967835],
                        [7e-11, 0.70724943755, 65717.2274856396],
                        [7e-11, 0.52800551865, 103814.808054201],
                        [8e-11, 2.25202792521, 149756.7082482],
                        [7e-11, 1.45586274187, 51841.950342379],
                        [7e-11, 2.28027029168, 54374.8936264354],
                        [7e-11, 1.96795602434, 103395.323410326],
                        [7e-11, 0.91100826202, 27972.8043049916],
                        [7e-11, 6.04142381509, 155475.150466257],
                        [8e-11, 0.66187102958, 156740.717944883],
                        [7e-11, 0.94700216301, 202420.149282602],
                        [8e-11, 0.34397341638, 78339.9754959982],
                        [8e-11, 1.99164711035, 84944.9342781222],
                        [6e-11, 3.16647388859, 76041.8527901256],
                        [7e-11, 1.18920934641, 104984.39630561],
                        [7e-11, 6.12812258419, 53867.9719526508],
                        [7e-11, 2.68832841048, 156377.855652311],
                        [7e-11, 4.82261895829, 52286.0126043678],
                        [6e-11, 2.12110075547, 148.0787244263],
                        [6e-11, 3.05937939252, 151.0476698429],
                        [7e-11, 0.09315209734, 220025.889230898],
                        [8e-11, 5.56250511075, 52509.6622239178],
                        [6e-11, 2.57622376266, 224577.842727957],
                        [7e-11, 2.65171386195, 220.4126424388],
                        [6e-11, 2.00091220299, 102018.416173425],
                        [7e-11, 0.86158158633, 50444.6839302158],
                        [7e-11, 1.6199048214, 103189.137861889],
                        [6e-11, 2.68512587119, 77520.71936419],
                        [6e-11, 4.82671721903, 154308.661745258],
                        [6e-11, 2.40727316051, 78800.513936818],
                        [6e-11, 5.66286619587, 234261.437309073],
                        [7e-11, 1.38238075345, 106470.376426675],
                        [7e-11, 4.6219355895, 81591.8450810028],
                        [7e-11, 0.26927581545, 127098.903281171],
                        [6e-11, 0.92172283144, 57503.2823915312],
                        [6e-11, 5.39808870469, 130020.031063996],
                        [6e-11, 2.52761413373, 52817.2198448874],
                        [6e-11, 0.06817978613, 53757.7656314314],
                        [7e-11, 3.1354731214, 155460.923372255],
                        [5e-11, 2.17501494391, 209232.916097688],
                        [5e-11, 2.16759656006, 104241.406245077],
                        [6e-11, 2.68409858369, 130005.803969994],
                        [5e-11, 1.58914721681, 50167.2487439894],
                        [5e-11, 1.01687539089, 55638.0509890136],
                        [7e-11, 1.31888655444, 149846.193996046],
                        [5e-11, 2.48117306579, 9384.8410080752],
                        [5e-11, 3.70948655428, 266540.363464894],
                        [7e-11, 5.71513815276, 70383.6202713836],
                        [6e-11, 4.55015130253, 51955.3936407096],
                        [5e-11, 3.51602263966, 102975.838766451],
                        [5e-11, 3.69945557546, 39450.3528483734],
                        [5e-11, 3.98232048303, 53771.992725433],
                        [6e-11, 1.01394190869, 77940.2040080652],
                        [5e-11, 2.50588363651, 102872.745992232],
                        [7e-11, 3.0124494408, 50264.6067999312],
                        [6e-11, 0.45316437598, 50064.1559697708],
                        [7e-11, 6.03933985106, 1485.9801210652],
                        [5e-11, 1.35734487293, 53814.8758003364],
                        [5e-11, 4.43939776623, 51534.3927214094],
                        [5e-11, 2.29075654159, 61560.6472912236],
                        [5e-11, 0.07896316759, 78057.5238762854],
                        [5e-11, 0.95484155225, 130907.480698225],
                        [5e-11, 1.56485117164, 53399.624123927],
                        [5e-11, 4.55586232099, 52137.6732475106],
                        [6e-11, 4.34778590755, 156534.532396446],
                        [5e-11, 3.7269181897, 128747.350038369],
                        [4e-11, 0.56386565513, 189386.032592265],
                        [4e-11, 2.67910077904, 107692.224992997],
                        [6e-11, 6.10947724529, 104248.519792078],
                        [4e-11, 3.99859010561, 104401.609188201],
                        [4e-11, 0.51280078907, 54344.566765431],
                        [5e-11, 4.1991766574, 129586.319326119],
                        [4e-11, 5.91763059229, 52041.6972335634],
                        [5e-11, 3.1863383495, 181975.424704705],
                        [5e-11, 0.99354989216, 1795.258443721],
                        [4e-11, 6.20030341798, 209762.607062783],
                        [4e-11, 4.57601261459, 184834.079095206],
                        [6e-11, 4.81632935419, 77741.1320066288],
                        [4e-11, 2.32553366031, 53265.515074342],
                        [4e-11, 4.83867556795, 52755.4938701472],
                        [4e-11, 0.47379105299, 105403.880949485],
                        [4e-11, 2.62000942355, 50049.9288757692],
                        [5e-11, 1.01847704961, 52309.9153327334],
                        [4e-11, 5.12416312887, 52027.7275587221],
                        [4e-11, 0.26524339921, 50007.0458008658],
                        [5e-11, 0.30725353996, 207747.625390985],
                        [4e-11, 4.93794243881, 63786.3582415226],
                        [4e-11, 4.51168915835, 77956.151803753],
                        [5e-11, 1.16733741695, 27566.7697156386],
                        [4e-11, 3.77703754152, 104501.175763431],
                        [4e-11, 5.4485951193, 129971.550717517],
                        [5e-11, 5.22593130125, 51329.7234483972],
                        [4e-11, 1.64237114391, 130446.144266771],
                        [4e-11, 1.28513103275, 112545.887899505],
                        [4e-11, 3.50115780256, 76152.059111345],
                        [4e-11, 4.79032272131, 130432.887148971],
                        [4e-11, 5.62786746084, 43981.5309499398],
                        [4e-11, 4.1268797505, 52024.7586133055],
                        [4e-11, 5.13202982684, 735.8765135318],
                        [4e-11, 4.64327471216, 76255.1518855636],
                        [4e-11, 1.34781477964, 106684.808959169],
                        [4e-11, 2.34997151211, 177287.845882637],
                      ],
          },
          {
            series => "B1",
            terms  => [
                        [0.00429151362, 3.50169780393, 26087.9031415742],
                        [0.00146233668, 3.14159265359, 0],
                        [0.00022675295, 0.0151536688, 52175.8062831484],
                        [0.00010894981, 0.48540174006, 78263.7094247226],
                        [6.353462e-05, 3.42943919982, 104351.612566297],
                        [2.495743e-05, 0.16051210665, 130439.515707871],
                        [8.59585e-06, 3.18452433647, 156527.418849445],
                        [2.77503e-06, 6.21020774184, 182615.321991019],
                        [8.6233e-07, 2.95244391822, 208703.225132594],
                        [2.6133e-07, 5.97708962692, 234791.128274168],
                        [2.7696e-07, 0.29068938889, 27197.2816936676],
                        [1.2831e-07, 3.37744320558, 53285.1848352418],
                        [1.272e-07, 0.53792661684, 24978.5245894808],
                        [7.781e-08, 2.71768609268, 260879.031415742],
                        [7.527e-08, 3.58305121268, 51066.427731055],
                        [6.183e-08, 2.92383205004, 31749.2351907264],
                        [5.453e-08, 1.97318763801, 51116.4243529592],
                        [3.394e-08, 0.34761695275, 77154.3308726292],
                        [3.481e-08, 0.10739761667, 79373.087976816],
                        [2.932e-08, 5.95430013169, 57837.1383323006],
                        [2.742e-08, 0.98758439378, 25028.521211385],
                        [2.126e-08, 4.16352818018, 47623.8527860896],
                        [2.286e-08, 5.74036496396, 286966.934557316],
                        [2.38e-08, 4.0021366655, 21535.9496445154],
                        [1.651e-08, 4.43606584681, 27043.5028831828],
                        [1.523e-08, 1.97926797181, 5661.3320491522],
                        [1.518e-08, 5.01636479848, 77204.3274945334],
                        [1.398e-08, 0.66375029294, 20426.571092422],
                        [1.345e-08, 3.39193943388, 103242.234014203],
                        [1.297e-08, 5.34251327744, 37410.5672398786],
                        [1.076e-08, 0.95624460335, 50586.7333878646],
                        [1.05e-08, 3.00944151152, 26107.572902474],
                        [9.18e-09, 1.89988871166, 1059.3819301892],
                        [1.063e-08, 1.28486292967, 53131.406024757],
                        [9.05e-09, 3.34776562702, 25558.2121764796],
                        [9.29e-09, 4.81159652409, 51646.1153180538],
                        [7.82e-09, 6.08817839271, 529.6909650946],
                        [7.83e-09, 1.5096269941, 41962.5207369374],
                        [7.94e-09, 2.16868396183, 63498.4703814528],
                        [7.31e-09, 0.92148918837, 73711.7559276638],
                        [7.55e-09, 4.1091063739, 26068.2333806744],
                        [7.03e-09, 2.22466530621, 10213.285546211],
                        [9.22e-09, 2.30268247092, 1109.3785520934],
                        [7.39e-09, 3.05842748947, 105460.99111839],
                        [6.81e-09, 1.40695567526, 51749.2080922724],
                        [8.41e-09, 5.9320678781, 26084.0218062162],
                        [6.16e-09, 5.9536898243, 39609.6545831656],
                        [6.1e-09, 2.96796433797, 25132.3033999656],
                        [7.21e-09, 1.16472614778, 46514.4742339962],
                        [6.38e-09, 1.16941585214, 26091.7844769322],
                        [6.33e-09, 3.07427024064, 30639.856638633],
                        [6.65e-09, 2.47994200156, 313054.83769889],
                        [6.69e-09, 4.10310179631, 72602.3773755704],
                        [4.95e-09, 0.14776350456, 129330.137155778],
                        [4.74e-09, 2.61466823958, 32858.6137428198],
                        [4.7e-09, 5.04436148211, 13521.7514415914],
                        [4.94e-09, 0.0743055645, 28306.660245761],
                        [4.59e-09, 5.81611579004, 51220.2065415398],
                        [4.67e-09, 5.56622114735, 4551.9534970588],
                        [4.33e-09, 2.10197184422, 24498.8302462904],
                        [4.3e-09, 3.91046377635, 76674.6365294388],
                        [4.36e-09, 1.46213785727, 43071.8992890308],
                        [3.83e-09, 6.05537830853, 52195.4760440482],
                        [3.35e-09, 0.5599660533, 23869.1460373874],
                        [3.69e-09, 4.43217995206, 22645.3281966088],
                        [3.29e-09, 2.59508442112, 65697.5577247398],
                        [3.46e-09, 2.03170085305, 27147.2850717634],
                        [4.24e-09, 0.29775934661, 1589.0728952838],
                        [3.78e-09, 5.09810178577, 53235.1882133376],
                        [3.08e-09, 3.30225015955, 54394.5633873352],
                        [3.14e-09, 2.40932519602, 83925.0414738748],
                        [3.64e-09, 5.87784809361, 58946.516884394],
                        [3.52e-09, 0.879394819, 52156.1365222486],
                        [3.52e-09, 5.92675293084, 25661.3049506982],
                        [3.1e-09, 2.69873876637, 52171.9249477904],
                        [3.45e-09, 0.84406679212, 98690.2805171446],
                        [3.58e-09, 6.14890038263, 56727.7597802072],
                        [2.48e-09, 2.3439684006, 51535.9089968344],
                        [2.86e-09, 2.39648280163, 19804.8272915828],
                        [3.38e-09, 1.55189200325, 52705.497248243],
                        [2.39e-09, 3.35169081927, 52168.6927361476],
                        [2.34e-09, 2.51108507067, 77308.109683114],
                        [2.29e-09, 5.16737598091, 36301.1886877852],
                        [2.45e-09, 4.269960324, 19317.1925403286],
                        [2.1e-09, 3.16281965425, 29530.4780865396],
                        [2.12e-09, 5.33861521612, 15874.6175953632],
                        [2.91e-09, 4.22929240183, 52179.6876185064],
                        [2.63e-09, 4.64138649646, 69159.802430605],
                        [2.35e-09, 5.08060846802, 59414.4818747484],
                        [2.51e-09, 1.9004750479, 14765.2390432698],
                        [2.53e-09, 4.21581970504, 79219.3091663312],
                        [1.94e-09, 5.05904557922, 51109.3108059584],
                        [1.88e-09, 3.90664116889, 48733.231338183],
                        [2.07e-09, 2.89949362192, 7.1135470008],
                        [1.79e-09, 4.43018837604, 77837.1112338466],
                        [2.23e-09, 2.96569885227, 110012.944615449],
                        [1.76e-09, 5.15204624857, 89586.373523027],
                        [2.15e-09, 4.50903357312, 78793.4003898172],
                        [1.73e-09, 3.1849677146, 155418.040297352],
                        [2.05e-09, 1.89888752382, 79323.0913549118],
                        [1.75e-09, 2.91183047213, 82815.6629217814],
                        [1.65e-09, 0.4912369438, 25035.6347583858],
                        [1.83e-09, 1.42148796836, 77734.018459628],
                        [1.58e-09, 3.63030783882, 49957.0491789616],
                        [2.01e-09, 4.78711687782, 40853.142184844],
                        [1.57e-09, 3.02451795123, 52182.9198301492],
                        [1.92e-09, 5.5021820905, 339142.740840465],
                        [1.45e-09, 3.39803928124, 45892.730433157],
                        [1.4e-09, 2.64826898848, 16983.9961474566],
                        [1.9e-09, 3.05043439775, 27676.976036858],
                        [1.69e-09, 3.40273824751, 25874.6040461362],
                        [1.48e-09, 3.87588943419, 124778.183658719],
                        [1.34e-09, 0.9493002873, 25021.4076643842],
                        [1.74e-09, 5.88326736492, 136100.847757023],
                        [1.38e-09, 2.34393108627, 1052.2683831884],
                        [1.63e-09, 6.05484015332, 26080.7895945734],
                        [1.42e-09, 3.0720910315, 3442.5749449654],
                        [1.37e-09, 2.10984857727, 426.598190876],
                        [1.26e-09, 1.8943260926, 1066.49547719],
                        [1.22e-09, 1.04298624291, 45405.0956819028],
                        [1.35e-09, 4.66414339767, 25448.0058552602],
                        [1.15e-09, 2.8136585152, 78283.3791856224],
                        [1.14e-09, 4.47315411813, 68050.4238785116],
                        [1.34e-09, 5.35393682799, 213.299095438],
                        [1.25e-09, 1.61827845372, 129380.133777682],
                        [1.58e-09, 5.53788931475, 9103.9069941176],
                        [1.16e-09, 0.5007523578, 102762.539671013],
                        [1.36e-09, 0.245596581, 50057.04242277],
                        [1.24e-09, 2.20590858584, 33326.5787331742],
                        [1.06e-09, 6.15493608726, 11322.6640983044],
                        [1.23e-09, 4.432657352, 639.897286314],
                        [1.37e-09, 3.93191153638, 78244.0396638228],
                        [1.38e-09, 4.46503235172, 51123.53789996],
                        [1.19e-09, 3.64440622006, 26617.5941066688],
                        [9.9e-10, 6.18313188027, 55618.3812281138],
                        [1.01e-09, 5.52733987069, 103396.012824688],
                        [1.07e-09, 4.79994153405, 6770.7106012456],
                        [9.6e-10, 0.01853371395, 80482.4665289094],
                        [1.15e-09, 1.57423656512, 66941.0453264182],
                        [1.11e-09, 1.00588061631, 78267.5907600806],
                        [1.21e-09, 5.90839328752, 26095.016688575],
                        [9.5e-10, 5.74549458142, 78259.8280893646],
                        [1e-09, 1.90676485528, 103292.230636108],
                        [1.07e-09, 5.73194510449, 131548.894259964],
                        [9.8e-10, 5.49064814924, 77623.8121384086],
                        [1.12e-09, 0.87682090108, 74821.1344797572],
                        [9e-10, 5.82373560803, 955.5997416086],
                        [9.3e-10, 0.15279056716, 78256.5958777218],
                        [1e-09, 1.21759895953, 104881.303531391],
                        [8.7e-10, 4.20722631983, 12566.1516999828],
                        [8.8e-10, 5.00176994115, 38519.945791972],
                        [8.6e-10, 1.23375034376, 26301.2022370122],
                        [8.5e-10, 1.88852891739, 77197.2139475326],
                        [8.2e-10, 3.75652571856, 99799.659069238],
                        [8.9e-10, 4.95684147986, 105410.994496486],
                        [9.6e-10, 5.10490831351, 52389.1053785864],
                        [7.5e-10, 2.50722139185, 2218.7571041868],
                        [9.3e-10, 6.00229475799, 53764.8791784322],
                        [7.3e-10, 6.11603054445, 78270.8229717234],
                        [9.1e-10, 4.67762120545, 155468.036919256],
                        [8e-10, 1.9856425664, 7238.6755916],
                        [8.9e-10, 1.62820970873, 6283.0758499914],
                        [7.3e-10, 5.93728826025, 108903.566063356],
                        [8.7e-10, 2.61787684648, 162188.750898597],
                        [9.2e-10, 2.55298032665, 85034.4200259682],
                        [7.6e-10, 4.44230028342, 38654.054841557],
                        [7e-10, 2.07147354168, 25934.1243310894],
                        [7.8e-10, 1.79664677749, 23969.1392811958],
                        [6.8e-10, 2.15267768357, 64607.8489335462],
                        [6.9e-10, 1.37976390686, 77211.4410415342],
                        [8e-10, 0.75440631101, 2118.7638603784],
                        [6e-10, 5.95179539253, 18849.2275499742],
                        [5.8e-10, 0.98126270514, 51962.5071877104],
                        [5.7e-10, 0.63495768344, 150866.086800293],
                        [6.3e-10, 0.40577774917, 76044.9523205358],
                        [6.1e-10, 3.20728040856, 76144.9455643442],
                        [5.3e-10, 1.34424134476, 51742.0945452716],
                        [5.2e-10, 4.11944860444, 71492.998823477],
                        [5.4e-10, 2.23964604878, 44937.1306915484],
                        [6.4e-10, 1.19785741966, 64741.9579831312],
                        [5.8e-10, 6.22316473811, 181505.943438926],
                        [6e-10, 2.12727479557, 88476.9949709336],
                        [4.9e-10, 1.76854754615, 13655.8604911764],
                        [4.9e-10, 1.27506119902, 26727.8004278882],
                        [4.8e-10, 2.04581990152, 78477.0085201606],
                        [5e-10, 4.62948267835, 93028.9484679924],
                        [5.5e-10, 5.47526225139, 62389.0918293594],
                        [4.7e-10, 4.99113735496, 27154.3986187642],
                        [5.5e-10, 4.79762177368, 94138.3270200858],
                        [5.1e-10, 5.56459812422, 52602.4044740244],
                        [5.5e-10, 1.20462687751, 95247.7055721792],
                        [5e-10, 2.21530140501, 365230.643982039],
                        [4.9e-10, 0.68636780387, 104331.942805397],
                        [4.7e-10, 4.30403626352, 23754.7067487022],
                        [4.2e-10, 3.32657201754, 25654.1914036974],
                        [5.1e-10, 1.08082309375, 25619.9381512198],
                        [4.7e-10, 2.79966035046, 26514.5013324502],
                        [4e-10, 2.9193266898, 81706.284369688],
                        [4e-10, 4.65660434525, 129909.824742776],
                        [4.1e-10, 4.21875403274, 130969.206672966],
                        [5e-10, 1.46644208786, 120226.23016166],
                        [4.7e-10, 3.77053215629, 25973.463852889],
                        [4.7e-10, 2.82867670887, 25668.418497699],
                        [4.6e-10, 4.14427477722, 125887.562210812],
                        [3.9e-10, 4.06156914485, 104355.493901655],
                        [3.7e-10, 3.22245380356, 51322.6099013964],
                        [3.9e-10, 2.26439106521, 129483.915966262],
                        [4e-10, 0.54598734169, 105307.212307905],
                        [3.5e-10, 5.5389589782, 433.7117378768],
                        [3.8e-10, 6.0532946799, 419.4846438752],
                        [3.9e-10, 2.72082598885, 79852.7823200064],
                        [3.5e-10, 1.72937228501, 131498.89763806],
                        [3.4e-10, 0.83611265968, 12432.0426503978],
                        [3.2e-10, 4.45254278754, 50579.6198408638],
                        [4.2e-10, 1.4145702213, 181555.94006083],
                        [3.2e-10, 4.7334998692, 52026.2430860138],
                        [3.6e-10, 5.60766535694, 188276.654040172],
                        [3.3e-10, 3.98525990131, 78050.4103292846],
                        [3.2e-10, 5.86059322955, 104371.282327197],
                        [4e-10, 5.45287901295, 27140.1715247626],
                        [3.1e-10, 5.17982917253, 71025.0338331226],
                        [3.9e-10, 3.34206786809, 26202.3424302594],
                        [2.9e-10, 1.94010215318, 103821.921601202],
                        [3.6e-10, 0.65969730203, 51756.3216392732],
                        [3e-10, 0.82864967511, 46848.3301747656],
                        [3.8e-10, 0.80809536333, 151975.465352386],
                        [2.9e-10, 2.8922779253, 104358.726113298],
                        [2.9e-10, 4.49728060011, 103299.344183108],
                        [3.5e-10, 1.48121158024, 85502.3850163226],
                        [2.8e-10, 5.48224379273, 91785.460866314],
                        [3e-10, 3.11318420566, 106570.369670484],
                        [3.4e-10, 4.26548581082, 90829.8611247054],
                        [3.1e-10, 5.67743476614, 117873.364007888],
                        [2.8e-10, 4.97598935775, 103285.117089107],
                        [3.3e-10, 5.18111128318, 114564.898112508],
                        [2.7e-10, 0.88054842818, 157636.797401539],
                        [2.6e-10, 2.57652351573, 134991.46920493],
                        [2.9e-10, 2.64144900778, 26137.8997634784],
                        [2.8e-10, 3.23650761988, 128850.442812587],
                        [3e-10, 6.03255187776, 32370.9789915656],
                        [2.9e-10, 3.23415692694, 104344.499019296],
                        [3.2e-10, 3.21019810469, 28421.0995344462],
                        [2.4e-10, 2.52484264487, 1596.1864422846],
                        [2.4e-10, 0.27171495756, 24491.7166992896],
                        [2.6e-10, 1.20902208843, 44181.2778411242],
                        [2.7e-10, 5.71639245109, 111122.323167542],
                        [3.1e-10, 3.68314656803, 28206.6670019526],
                        [3e-10, 2.36500429653, 103711.715279983],
                        [2.2e-10, 4.4754796526, 77829.9976868458],
                        [2.2e-10, 5.93080138405, 98068.5367163054],
                        [2.1e-10, 4.45887879737, 52815.7035694624],
                        [2.2e-10, 1.51276188597, 35191.8101356918],
                        [2.5e-10, 3.67349275753, 853.196381752],
                        [2.1e-10, 5.21045664362, 104564.911661735],
                        [2.3e-10, 3.52400873624, 100909.037621331],
                        [2.1e-10, 0.91705070968, 97580.9019650512],
                        [2.1e-10, 3.93681460045, 25455.119402261],
                        [2e-10, 2.51210823023, 104347.731230939],
                        [2.7e-10, 2.35592427305, 78690.3076155986],
                        [2e-10, 5.09828683951, 52099.5402118728],
                        [1.9e-10, 3.37799607043, 45494.5814297488],
                        [2.1e-10, 1.47540794459, 115674.276664601],
                        [2e-10, 1.17802900406, 155997.727884351],
                        [2.5e-10, 4.46628547605, 146314.133303234],
                        [2.3e-10, 2.29934592297, 33967.9922949132],
                        [2e-10, 0.67974525638, 24505.9437932912],
                        [2e-10, 5.32443861216, 25234.7067598222],
                        [1.8e-10, 4.83011056299, 50593.8469348654],
                        [2e-10, 2.19515561332, 51639.001771053],
                        [2e-10, 4.54362105039, 26037.90651967],
                        [1.8e-10, 3.66945372389, 176953.989941867],
                        [2.2e-10, 2.36457126914, 143961.267149462],
                        [2e-10, 1.91605933726, 53242.3017603384],
                        [1.7e-10, 3.65797302958, 25938.3399444396],
                        [1.7e-10, 4.72356636284, 39743.7636327506],
                        [1.7e-10, 4.6338502937, 70269.1809826984],
                        [2.3e-10, 3.47296935942, 102132.85546211],
                        [1.8e-10, 3.89075237232, 77844.2247808474],
                        [1.6e-10, 1.39550514982, 119116.851609567],
                        [1.7e-10, 3.19413997784, 2333.196392872],
                        [1.8e-10, 0.10505670252, 52290.2455718336],
                        [1.5e-10, 5.66501892458, 7994.5284420242],
                        [1.7e-10, 5.59546671313, 60055.8954364874],
                        [1.5e-10, 3.35297565546, 58458.8821331398],
                        [1.9e-10, 1.88696722328, 1581.959348283],
                        [1.6e-10, 3.51339563149, 26094.5317004742],
                        [1.5e-10, 5.8779684464, 105940.685461581],
                        [1.4e-10, 4.90677373859, 632.7837393132],
                        [1.7e-10, 2.94915136654, 18093.37469955],
                        [1.6e-10, 3.30923893089, 26507.3877854494],
                        [1.7e-10, 2.79032831551, 124156.43985788],
                        [1.7e-10, 2.32026007183, 53228.0746663368],
                        [1.5e-10, 1.27735280723, 103925.014375421],
                        [1.4e-10, 0.47578456087, 104138.313470859],
                        [1.4e-10, 4.33486658309, 18207.8139882352],
                        [1.4e-10, 6.25912081869, 102232.848705918],
                        [1.6e-10, 5.19489448771, 52022.0274726636],
                        [1.5e-10, 3.36079341013, 26241.681952059],
                        [1.6e-10, 0.62153007569, 71980.6335747312],
                        [1.6e-10, 0.34240403974, 26081.2745826742],
                        [1.5e-10, 4.43868814661, 207643.843202404],
                        [1.7e-10, 3.44704905407, 183724.700543113],
                        [1.6e-10, 0.08608453345, 77410.5130429706],
                        [1.3e-10, 4.45469253351, 90695.7520751204],
                        [1.4e-10, 5.26281612633, 391318.547123613],
                        [1.3e-10, 2.28140033187, 26521.614879451],
                        [1.3e-10, 4.75564434373, 536.8045120954],
                        [1.3e-10, 3.72895039092, 130419.845946971],
                        [1.5e-10, 6.26388997196, 54509.0026760204],
                        [1.4e-10, 1.32802909705, 20760.4270331914],
                        [1.2e-10, 0.9618285308, 157057.10981454],
                        [1.7e-10, 3.00168933222, 207593.8465805],
                        [1.6e-10, 0.54167157981, 52061.3669944632],
                        [1.6e-10, 3.76004077423, 178063.368493961],
                        [1.2e-10, 0.50356687265, 5327.4761083828],
                        [1.4e-10, 0.65739903621, 84546.785274714],
                        [1.4e-10, 2.64166191335, 42153.969003049],
                        [1.1e-10, 1.8737562471, 97112.9369746968],
                        [1.2e-10, 5.28144640817, 26610.480559668],
                        [1.2e-10, 1.02715379165, 130012.917516995],
                        [1.1e-10, 4.76973198116, 157586.800779634],
                        [1.1e-10, 4.03645617358, 26011.6370702986],
                        [1.2e-10, 1.0377409492, 116917.76426628],
                        [1.1e-10, 2.34762914711, 214364.557181746],
                        [1.3e-10, 5.96105286469, 49527.3514576754],
                        [1.3e-10, 0.38784055589, 54294.5701435268],
                        [1.1e-10, 0.80279403389, 130443.397043229],
                        [1.2e-10, 1.91910219792, 140652.801254082],
                        [1.1e-10, 4.82050468552, 647.0108333148],
                        [1.2e-10, 3.95784286024, 72936.2333163398],
                        [1e-10, 2.38363926963, 52698.3837012422],
                        [1.2e-10, 5.21962000846, 25551.0986294788],
                        [1.1e-10, 1.24041943634, 51543.0225438352],
                        [1e-10, 1.23610986711, 76667.522982438],
                        [1.1e-10, 5.27116774881, 155571.819107837],
                        [1.1e-10, 5.98419309923, 107794.187511262],
                        [1e-10, 0.55390559777, 26941.0995233262],
                        [1e-10, 1.49161844344, 52329.5850936332],
                        [1.1e-10, 4.68946178137, 26190.9959157928],
                        [9e-11, 5.63092803389, 27684.0895838588],
                        [1.1e-10, 6.09445403088, 26555.8681319286],
                        [1e-10, 0.09698975387, 29416.0387978544],
                        [1e-10, 0.72339727974, 22759.767485294],
                        [9e-11, 1.96066446481, 51528.7954498336],
                        [9e-11, 4.28124553384, 121335.608713753],
                        [8e-11, 4.26127907796, 182085.631025925],
                        [9e-11, 3.34775259107, 22747.2907148744],
                        [8e-11, 1.25238578145, 129387.247324683],
                        [8e-11, 3.86388656969, 24864.0853007956],
                        [1e-10, 1.34737181255, 2648.454825473],
                        [8e-11, 5.72234642822, 161079.372346504],
                        [9e-11, 5.45351693096, 104778.210757173],
                        [1.1e-10, 2.85637796333, 52643.7712735028],
                        [8e-11, 3.27339488052, 27311.7209823528],
                        [1e-10, 1.31510855953, 52125.8096612442],
                        [9e-11, 1.17621493154, 172402.036444808],
                        [8e-11, 2.43297081646, 131395.11544948],
                        [9e-11, 0.46231104626, 26624.7076536696],
                        [7e-11, 4.93485551094, 48835.1938564486],
                        [7e-11, 5.92438953036, 130446.629254872],
                        [7e-11, 5.1510763867, 149.5631971346],
                        [8e-11, 0.00476652316, 209812.603684687],
                        [8e-11, 5.0655882241, 61279.713277266],
                        [9e-11, 0.56618846666, 522.5774180938],
                        [7e-11, 2.63009300708, 130459.185468771],
                        [8e-11, 2.0895971735, 25565.3257234804],
                        [9e-11, 5.37562306264, 170049.170291037],
                        [8e-11, 4.055541562, 156100.820658569],
                        [7e-11, 5.58541192959, 129799.618421557],
                        [7e-11, 1.76385898252, 129373.020230681],
                        [6e-11, 4.86066957244, 7880.08915333899],
                        [8e-11, 4.47849277972, 10021.8372800994],
                        [6e-11, 5.30561035943, 77726.9049126272],
                        [6e-11, 1.27631388714, 103917.90082842],
                        [6e-11, 4.61189217781, 157483.018591054],
                        [6e-11, 3.96170038596, 123668.805106625],
                        [6e-11, 1.33523648266, 78903.6067110366],
                        [6e-11, 0.5570238657, 204151.271635535],
                        [5e-11, 1.55562437906, 26294.0886900114],
                        [6e-11, 2.05839183005, 130652.814803309],
                        [5e-11, 5.58094407959, 130435.634372513],
                        [5e-11, 1.47580092631, 78114.146227588],
                        [6e-11, 4.10195998301, 51707.841292794],
                        [5e-11, 5.4235609608, 3340.6124266998],
                        [5e-11, 0.71252148739, 103932.127922422],
                        [5e-11, 3.31021043385, 111590.288157897],
                        [5e-11, 5.18242316734, 13362.4497067992],
                        [7e-11, 0.02670007799, 130432.40216087],
                        [6e-11, 5.6496176752, 52225.8029050526],
                        [6e-11, 0.24412111381, 128220.758603684],
                        [5e-11, 4.45623339313, 145204.754751141],
                        [6e-11, 5.59932602145, 154938.345954161],
                        [5e-11, 0.44843767302, 203041.893083441],
                        [6e-11, 0.61515143577, 126996.940762906],
                        [6e-11, 3.76267562514, 110634.688416288],
                        [5e-11, 3.87958020217, 25440.8923082594],
                        [6e-11, 6.1289854729, 132658.272812058],
                        [6e-11, 1.78589858446, 76681.7500764396],
                        [6e-11, 3.31942003464, 25881.717593137],
                        [5e-11, 4.83610476376, 78417.4882352074],
                        [5e-11, 1.62128192664, 65831.6667743248],
                        [6e-11, 5.79832326006, 150244.342999454],
                        [4e-11, 4.90210493212, 123200.840116271],
                        [4e-11, 0.04822157393, 71582.484571323],
                        [4e-11, 1.25993980368, 233731.746343979],
                        [4e-11, 4.09490053686, 143005.667407854],
                        [4e-11, 0.60263195052, 6681.2248533996],
                        [5e-11, 3.53504145685, 130226.216612433],
                        [4e-11, 2.52659732174, 132028.588603155],
                        [4e-11, 5.09490146272, 76.2660712756],
                        [4e-11, 1.41880070183, 31415.379249957],
                        [5e-11, 5.67226040777, 68241.8721446232],
                        [6e-11, 6.07125845396, 1478.8665740644],
                        [4e-11, 2.90387262796, 128320.751847493],
                        [4e-11, 3.16756186361, 78378.1487134078],
                        [4e-11, 0.3258927484, 52595.2909270236],
                        [5e-11, 1.7809608149, 116783.655216695],
                        [4e-11, 4.99518857973, 166740.704395656],
                        [5e-11, 4.90494970331, 79330.2049019126],
                        [4e-11, 5.2343783992, 206.1855484372],
                        [4e-11, 2.64302747396, 75615.2545992496],
                        [4e-11, 0.8140714413, 75930.5130318506],
                        [4e-11, 0.53239895977, 156507.749088545],
                        [4e-11, 4.27504704332, 956.2891559706],
                        [4e-11, 3.01307667234, 80596.9058175946],
                        [3e-11, 4.15170143655, 25867.4904991354],
                        [3e-11, 4.02158764895, 52712.6107952438],
                        [4e-11, 5.97032773544, 78731.674415077],
                        [4e-11, 5.13753166239, 137678.191299471],
                        [3e-11, 5.3837822517, 79315.977807911],
                        [3e-11, 4.90402266218, 77630.9256854094],
                        [4e-11, 3.35681065144, 80382.473285101],
                        [4e-11, 3.34724303278, 55503.9419394286],
                        [3e-11, 4.39477038963, 102755.426124012],
                        [4e-11, 2.19880101386, 137210.226309117],
                        [3e-11, 1.9219127492, 87367.6164188402],
                        [4e-11, 3.62687237484, 78149.2701360374],
                        [3e-11, 5.34278285975, 77616.6985914078],
                        [3e-11, 4.04927793779, 183145.012956114],
                        [3e-11, 2.33740424416, 86143.7985780616],
                        [3e-11, 0.29051326311, 66653.1574663484],
                        [4e-11, 3.19530187424, 103498.416184545],
                        [3e-11, 1.8367025094, 78187.443353447],
                        [4e-11, 6.08402133763, 233681.749722074],
                        [3e-11, 5.44799723236, 52609.5180210252],
                        [3e-11, 3.88568044923, 156531.300184803],
                        [3e-11, 1.56467339056, 183674.703921209],
                        [3e-11, 2.37223694472, 11610.5519583742],
                        [4e-11, 2.36349454401, 3328.13565628019],
                        [3e-11, 2.21015804942, 130866.113898747],
                        [3e-11, 1.00111385284, 12546.481939083],
                        [3e-11, 5.04736992413, 167850.08294775],
                        [4e-11, 2.74224804458, 133882.090652836],
                        [3e-11, 6.04124419781, 16066.0658614748],
                        [3e-11, 2.00390511344, 25984.8103673556],
                        [3e-11, 3.5845123152, 19406.6782881746],
                        [3e-11, 5.58865591583, 52381.9918315856],
                        [3e-11, 5.49839860031, 78786.2868428164],
                        [3e-11, 2.3525187781, 50483.640613646],
                        [3e-11, 2.23638545873, 417406.450265187],
                        [3e-11, 0.89820153238, 182188.723800143],
                        [3e-11, 2.18659555288, 196137.073432611],
                        [3e-11, 1.23213629886, 183570.921732628],
                        [3e-11, 0.65362427623, 1162.4747044078],
                        [3e-11, 2.37265737062, 141762.179806175],
                        [3e-11, 2.3716713866, 103.0927742186],
                        [3e-11, 3.43071585489, 51219.5171271778],
                        [2e-11, 5.43620933898, 240452.46032332],
                        [2e-11, 4.79210725186, 64901.2597179234],
                        [3e-11, 0.58543714627, 136722.591557862],
                        [2e-11, 3.65273296014, 53029.0026649004],
                        [3e-11, 1.40305085463, 52278.899057367],
                        [3e-11, 2.91888451759, 235900.506826261],
                        [2e-11, 5.24862580724, 32769.1279949738],
                        [3e-11, 0.92825301327, 29428.515568274],
                        [2e-11, 1.28026650043, 96357.0841242726],
                        [3e-11, 3.47745075021, 49842.6098902764],
                        [3e-11, 1.27522510736, 44295.7171298094],
                        [3e-11, 2.06356044829, 181659.722249411],
                        [2e-11, 1.82577636633, 181026.249095736],
                        [2e-11, 3.73653346143, 48847.6706268682],
                        [2e-11, 4.29258038531, 198489.939586383],
                        [3e-11, 1.30423082531, 26237.4663387088],
                        [2e-11, 5.6240507486, 112231.701719636],
                        [3e-11, 4.3496990758, 78213.7128028184],
                        [2e-11, 4.40950391344, 155475.150466257],
                        [2e-11, 5.10859116787, 27669.8624898572],
                        [2e-11, 2.40342983563, 53771.992725433],
                        [2e-11, 1.76898437388, 104505.391376782],
                        [2e-11, 1.13321786137, 208173.534167499],
                        [3e-11, 4.95012664609, 102769.653218014],
                        [2e-11, 2.37593594042, 51951.4614874465],
                        [3e-11, 0.6555617912, 1692.1656695024],
                        [2e-11, 1.65727778641, 163766.094441045],
                      ],
          },
          {
            series => "B2",
            terms  => [
                        [0.00011830934, 4.79065585784, 26087.9031415742],
                        [1.913516e-05, 0, 0],
                        [1.044801e-05, 1.21216540536, 52175.8062831484],
                        [2.66213e-06, 4.43418336532, 78263.7094247226],
                        [1.7028e-06, 1.62255638714, 104351.612566297],
                        [9.63e-07, 4.80023692017, 130439.515707871],
                        [4.4692e-07, 1.60758267772, 156527.418849445],
                        [1.8316e-07, 4.66904655377, 182615.321991019],
                        [6.927e-08, 1.4340488893, 208703.225132594],
                        [2.479e-08, 4.47495202955, 234791.128274168],
                        [1.739e-08, 1.830800396, 27197.2816936676],
                        [8.52e-09, 1.22749255198, 260879.031415742],
                        [6.41e-09, 4.87358642253, 53285.1848352418],
                        [3.01e-09, 1.9609892443, 51066.427731055],
                        [3.06e-09, 5.03912693671, 24978.5245894808],
                        [2.84e-09, 4.25874901943, 286966.934557316],
                        [2.35e-09, 3.14549432371, 51116.4243529592],
                        [2.32e-09, 4.22847849119, 31749.2351907264],
                        [1.86e-09, 5.05207772442, 77154.3308726292],
                        [1.43e-09, 5.71074961492, 21535.9496445154],
                        [1.14e-09, 5.6223246077, 27043.5028831828],
                        [1.23e-09, 1.51066137419, 79373.087976816],
                        [9.3e-10, 1.83776226489, 103242.234014203],
                        [8.1e-10, 0.85802178989, 57837.1383323006],
                        [7.9e-10, 5.50027152752, 47623.8527860896],
                        [9.3e-10, 1.01040170383, 313054.83769889],
                        [5.8e-10, 2.35944147105, 53131.406024757],
                        [7.4e-10, 2.28645155343, 50586.7333878646],
                        [4.9e-10, 1.7819375356, 28306.660245761],
                        [5.8e-10, 5.88387132512, 77204.3274945334],
                        [6e-10, 0.54679388547, 37410.5672398786],
                        [4.6e-10, 5.77182292982, 529.6909650946],
                        [5.2e-10, 3.58488737294, 25558.2121764796],
                        [6.1e-10, 1.64891174657, 20426.571092422],
                        [4.3e-10, 6.15538236294, 51646.1153180538],
                        [4.2e-10, 4.89875940528, 129330.137155778],
                        [3.6e-10, 5.61094806248, 22645.3281966088],
                        [3.3e-10, 4.34189175312, 32858.6137428198],
                        [3.7e-10, 4.50512068847, 26107.572902474],
                        [3.2e-10, 1.99466664427, 25132.3033999656],
                        [3e-10, 0.7660773863, 5661.3320491522],
                        [2.7e-10, 4.8718083816, 54394.5633873352],
                        [2.9e-10, 5.66168505554, 26068.2333806744],
                        [2.5e-10, 3.31115218239, 1059.3819301892],
                        [2.9e-10, 2.70280425915, 41962.5207369374],
                        [2.9e-10, 3.56940606994, 63498.4703814528],
                        [2.9e-10, 4.01947170286, 339142.740840465],
                        [2.8e-10, 0.80200569507, 39609.6545831656],
                        [2.3e-10, 5.30820497885, 23869.1460373874],
                        [2.4e-10, 4.8636944533, 46514.4742339962],
                        [2.7e-10, 3.32081057071, 10213.285546211],
                        [3e-10, 1.15631768661, 26084.0218062162],
                        [2.4e-10, 2.71284750937, 26091.7844769322],
                        [2.1e-10, 5.85119251529, 25874.6040461362],
                        [2.6e-10, 3.11971794265, 43071.8992890308],
                        [2.3e-10, 1.1425826685, 58946.516884394],
                        [2.1e-10, 4.78965226125, 51220.2065415398],
                        [2.5e-10, 5.17153436907, 76674.6365294388],
                        [2e-10, 6.05659966832, 25028.521211385],
                        [1.7e-10, 4.06375348164, 51535.9089968344],
                        [1.9e-10, 2.26589689692, 72602.3773755704],
                        [1.9e-10, 2.02802084878, 73711.7559276638],
                        [2e-10, 2.44092663198, 51749.2080922724],
                        [1.7e-10, 1.67702029587, 155418.040297352],
                        [1.8e-10, 2.11191340126, 26617.5941066688],
                        [1.9e-10, 0.32685450395, 4551.9534970588],
                        [1.6e-10, 4.0210564377, 105460.99111839],
                        [1.4e-10, 2.35860855509, 26080.7895945734],
                        [1.3e-10, 3.28426450224, 25661.3049506982],
                        [1.6e-10, 2.09223320909, 103292.230636108],
                        [1.3e-10, 2.08475100066, 49957.0491789616],
                        [1.4e-10, 5.66400816218, 48733.231338183],
                        [1.3e-10, 1.65023710844, 26095.016688575],
                        [1.5e-10, 5.43792291298, 25973.463852889],
                        [1.2e-10, 5.15541566845, 79219.3091663312],
                        [1.2e-10, 2.93766606728, 33326.5787331742],
                        [1.1e-10, 5.16599347976, 15874.6175953632],
                        [1.5e-10, 3.49521469034, 83925.0414738748],
                        [1.2e-10, 1.33980027148, 77308.109683114],
                        [1.2e-10, 2.74476655782, 19317.1925403286],
                        [1.4e-10, 5.48457159802, 98690.2805171446],
                        [1.2e-10, 6.17629016531, 36301.1886877852],
                        [1.2e-10, 5.16549673414, 1589.0728952838],
                        [1e-10, 3.19718718931, 24498.8302462904],
                        [1e-10, 3.10957426655, 16983.9961474566],
                        [1e-10, 2.67818215946, 77734.018459628],
                        [1.2e-10, 1.64438976704, 26202.3424302594],
                        [1.1e-10, 6.12421691815, 52705.497248243],
                        [1e-10, 5.42117419251, 14765.2390432698],
                        [1.1e-10, 1.59577581724, 50057.04242277],
                        [1.2e-10, 2.44342322463, 213.299095438],
                        [1.1e-10, 4.59333229552, 56727.7597802072],
                        [8e-11, 2.22267415318, 6283.0758499914],
                        [1e-10, 3.63881306668, 65697.5577247398],
                        [8e-11, 0.85708473896, 365230.643982039],
                        [1e-10, 3.56346926379, 53235.1882133376],
                        [9e-11, 3.03935867498, 78793.4003898172],
                        [8e-11, 2.05186284069, 30639.856638633],
                        [8e-11, 6.07959531374, 59414.4818747484],
                        [7e-11, 1.48753095657, 29530.4780865396],
                        [7e-11, 0.54370332724, 38519.945791972],
                        [8e-11, 5.99792913268, 7.1135470008],
                        [9e-11, 6.08426293157, 69159.802430605],
                        [7e-11, 1.3551301451, 82815.6629217814],
                        [8e-11, 3.00335450338, 40853.142184844],
                        [7e-11, 3.40544433462, 1066.49547719],
                        [7e-11, 5.80782632115, 45405.0956819028],
                        [7e-11, 3.82318715536, 1052.2683831884],
                        [6e-11, 4.57200111034, 55618.3812281138],
                        [6e-11, 4.85942618671, 52168.6927361476],
                        [8e-11, 0.34211699258, 79323.0913549118],
                        [6e-11, 0.6782367506, 110012.944615449],
                        [7e-11, 4.12285655199, 45892.730433157],
                        [7e-11, 5.41918774642, 1109.3785520934],
                        [7e-11, 3.14407932401, 51962.5071877104],
                        [6e-11, 5.13879522396, 76044.9523205358],
                        [7e-11, 2.06447590782, 124778.183658719],
                        [6e-11, 1.61443478349, 3442.5749449654],
                        [5e-11, 2.013597281, 27676.976036858],
                        [7e-11, 5.49596353318, 23754.7067487022],
                        [6e-11, 0.7144527205, 27147.2850717634],
                        [5e-11, 5.5815366372, 68050.4238785116],
                        [6e-11, 4.72387999717, 52290.2455718336],
                        [5e-11, 1.65565332809, 80482.4665289094],
                        [5e-11, 4.67655631038, 181505.943438926],
                        [5e-11, 5.35730277715, 12566.1516999828],
                        [5e-11, 2.24953488234, 52061.3669944632],
                        [4e-11, 1.93085125724, 52156.1365222486],
                        [6e-11, 5.23350745087, 129380.133777682],
                        [5e-11, 6.27908880897, 66941.0453264182],
                        [6e-11, 0.86124028508, 52195.4760440482],
                        [4e-11, 0.23100295125, 89586.373523027],
                        [5e-11, 4.23944686799, 103396.012824688],
                        [4e-11, 0.29398633221, 51109.3108059584],
                        [5e-11, 0.38451698643, 955.5997416086],
                        [5e-11, 5.7581296517, 104881.303531391],
                        [5e-11, 3.78671774559, 52171.9249477904],
                        [4e-11, 5.32828531774, 25448.0058552602],
                        [5e-11, 3.20016226905, 426.598190876],
                        [5e-11, 3.86489045633, 9103.9069941176],
                        [4e-11, 0.62543334322, 11322.6640983044],
                        [4e-11, 6.07508617692, 2118.7638603784],
                        [4e-11, 2.43638238426, 74821.1344797572],
                        [4e-11, 5.29735530203, 52179.6876185064],
                        [3e-11, 3.19112063073, 13521.7514415914],
                        [4e-11, 5.09850398144, 77837.1112338466],
                        [4e-11, 1.81128771043, 102762.539671013],
                        [4e-11, 2.92685125689, 639.897286314],
                        [4e-11, 4.37998582536, 52182.9198301492],
                        [4e-11, 0.905624683, 77623.8121384086],
                        [4e-11, 3.40653389629, 105410.994496486],
                        [4e-11, 5.56139758889, 26301.2022370122],
                        [3e-11, 3.84817111044, 2218.7571041868],
                        [4e-11, 3.40685398189, 52389.1053785864],
                        [3e-11, 3.64497587259, 64607.8489335462],
                        [3e-11, 4.90907522926, 99799.659069238],
                        [3e-11, 0.33551297325, 13655.8604911764],
                        [3e-11, 4.38738526963, 108903.566063356],
                        [3e-11, 2.7199654281, 38654.054841557],
                        [3e-11, 5.2163956913, 150866.086800293],
                        [3e-11, 5.79669813464, 131548.894259964],
                        [3e-11, 4.24481036893, 136100.847757023],
                        [3e-11, 4.74285528385, 53764.8791784322],
                        [3e-11, 5.12230469501, 32370.9789915656],
                        [3e-11, 4.9197929909, 18849.2275499742],
                        [3e-11, 1.21305125502, 105307.212307905],
                        [2e-11, 2.6174140723, 71492.998823477],
                        [2e-11, 5.29927753161, 64741.9579831312],
                        [2e-11, 2.59250638038, 155468.036919256],
                        [2e-11, 5.60083003625, 26514.5013324502],
                        [3e-11, 4.14284031224, 85034.4200259682],
                        [2e-11, 3.04958336441, 93028.9484679924],
                        [3e-11, 6.16142033746, 78477.0085201606],
                        [3e-11, 4.49779099, 76144.9455643442],
                        [2e-11, 2.74114399659, 130969.206672966],
                        [2e-11, 6.18606575651, 51123.53789996],
                        [3e-11, 1.68659744145, 28421.0995344462],
                        [2e-11, 1.39891525246, 81706.284369688],
                        [2e-11, 1.36487993355, 79852.7823200064],
                        [2e-11, 0.86961235954, 129483.915966262],
                        [2e-11, 0.16105302705, 25021.4076643842],
                        [2e-11, 0.20969999844, 19804.8272915828],
                        [2e-11, 0.99320491085, 162188.750898597],
                        [2e-11, 3.94039306142, 391318.547123613],
                        [2e-11, 1.80783236802, 23969.1392811958],
                        [2e-11, 5.1209935622, 51322.6099013964],
                        [2e-11, 2.80140642811, 62389.0918293594],
                        [2e-11, 2.60965333457, 52602.4044740244],
                        [2e-11, 2.72257468038, 7994.5284420242],
                        [2e-11, 5.84222491614, 103821.921601202],
                        [2e-11, 6.0451587872, 25035.6347583858],
                        [1e-11, 2.34997564292, 85502.3850163226],
                        [1e-11, 0.17409967102, 131498.89763806],
                        [1e-11, 3.11496551907, 25934.1243310894],
                        [2e-11, 5.12532278095, 78267.5907600806],
                        [1e-11, 5.49175475674, 104331.942805397],
                        [1e-11, 0.44808516059, 78050.4103292846],
                        [2e-11, 1.92656028088, 102132.85546211],
                        [2e-11, 1.93198050022, 853.196381752],
                        [1e-11, 2.42972717822, 94138.3270200858],
                        [2e-11, 5.13550087739, 6770.7106012456],
                        [1e-11, 4.6544150087, 78259.8280893646],
                        [1e-11, 3.9968745549, 188276.654040172],
                        [1e-11, 4.3906969233, 104371.282327197],
                        [1e-11, 1.64083661387, 78283.3791856224],
                        [1e-11, 1.50558734911, 78378.1487134078],
                        [2e-11, 6.27597485867, 91785.460866314],
                        [1e-11, 4.00786092689, 78244.0396638228],
                        [1e-11, 1.70741856509, 28206.6670019526],
                        [1e-11, 5.31900403501, 78149.2701360374],
                        [1e-11, 1.40205887414, 44937.1306915484],
                        [1e-11, 1.03752853909, 104347.731230939],
                        [1e-11, 0.66520680194, 419.4846438752],
                        [1e-11, 2.46437105095, 104355.493901655],
                        [1e-11, 0.81835364761, 35191.8101356918],
                        [1e-11, 0.3378067084, 88476.9949709336],
                        [1e-11, 6.0834623193, 70269.1809826984],
                        [1e-11, 1.86810476133, 125887.562210812],
                        [1e-11, 2.1046897466, 25619.9381512198],
                        [1e-11, 3.99494842792, 71025.0338331226],
                        [1e-11, 0.57714874874, 71980.6335747312],
                        [1e-11, 5.66312942513, 97580.9019650512],
                        [1e-11, 3.06688416266, 129909.824742776],
                        [1e-11, 5.66709359706, 433.7117378768],
                        [1e-11, 0.91634007063, 103925.014375421],
                        [1e-11, 6.02359186416, 181555.94006083],
                        [1e-11, 1.44980129997, 26727.8004278882],
                        [1e-11, 1.4544292039, 207593.8465805],
                        [1e-11, 1.12941846578, 60055.8954364874],
                        [1e-11, 1.16964771504, 134991.46920493],
                      ],
          },
          {
            series => "B3",
            terms  => [
                        [2.35423e-06, 0.35387524604, 26087.9031415742],
                        [1.60537e-06, 0, 0],
                        [1.8904e-07, 4.36275460261, 52175.8062831484],
                        [6.376e-08, 2.50715381439, 78263.7094247226],
                        [4.58e-08, 6.14257817571, 104351.612566297],
                        [3.061e-08, 3.12497552681, 130439.515707871],
                        [1.732e-08, 6.26642412058, 156527.418849445],
                        [8.57e-09, 3.07673166705, 182615.321991019],
                        [3.84e-09, 6.14815319932, 208703.225132594],
                        [1.59e-09, 2.9243737832, 234791.128274168],
                        [6.2e-10, 5.97292432097, 260879.031415742],
                        [5.4e-10, 3.31612529961, 27197.2816936676],
                        [2.3e-10, 2.74287679452, 286966.934557316],
                        [1.7e-10, 0.77798463435, 24978.5245894808],
                        [1.2e-10, 6.24116133415, 53285.1848352418],
                        [8e-11, 5.79551081392, 313054.83769889],
                        [6e-11, 5.81555175073, 31749.2351907264],
                        [4e-11, 4.67212195693, 51116.4243529592],
                        [4e-11, 3.36833718999, 77154.3308726292],
                        [3e-11, 0.26522113546, 103242.234014203],
                        [3e-11, 0.79794705473, 27043.5028831828],
                        [4e-11, 0.82832725003, 21535.9496445154],
                        [2e-11, 2.57068697582, 339142.740840465],
                        [2e-11, 1.8230939704, 1109.3785520934],
                        [2e-11, 0.74986942696, 47623.8527860896],
                        [2e-11, 3.61692083154, 50586.7333878646],
                        [2e-11, 4.70766241226, 51066.427731055],
                        [1e-11, 3.3368854909, 129330.137155778],
                        [1e-11, 2.64641192612, 57837.1383323006],
                        [1e-11, 4.93247555987, 25558.2121764796],
                        [2e-11, 5.00344393497, 20426.571092422],
                        [2e-11, 4.80841415889, 25028.521211385],
                        [2e-11, 5.85039338716, 1059.3819301892],
                        [1e-11, 1.85116662745, 37410.5672398786],
                        [2e-11, 3.97317842825, 25132.3033999656],
                        [1e-11, 2.144942913, 79373.087976816],
                        [1e-11, 2.53223701416, 46514.4742339962],
                        [1e-11, 5.8492163243, 5661.3320491522],
                        [1e-11, 3.81958470276, 53131.406024757],
                        [1e-11, 1.05410669937, 1589.0728952838],
                        [1e-11, 1.39436798574, 51646.1153180538],
                        [1e-11, 0.36358097174, 22645.3281966088],
                        [1e-11, 2.7660997227, 28306.660245761],
                        [1e-11, 3.67689055309, 4551.9534970588],
                        [1e-11, 5.39398540975, 32858.6137428198],
                        [1e-11, 3.7357912717, 24498.8302462904],
                        [1e-11, 0.60289607514, 26068.2333806744],
                        [1e-11, 5.78167324673, 26107.572902474],
                        [1e-11, 3.81913361795, 26091.7844769322],
                        [1e-11, 5.64455351094, 365230.643982039],
                        [1e-11, 4.87981157471, 10213.285546211],
                        [1e-11, 2.44816565966, 26084.0218062162],
                        [0, 3.45284067711, 105460.99111839],
                      ],
          },
          {
            series => "B4",
            terms  => [
                        [4.276e-08, 1.74579932115, 26087.9031415742],
                        [1.023e-08, 3.14159265359, 0],
                        [4.25e-09, 4.03419509143, 52175.8062831484],
                        [2.57e-09, 0.20643590425, 78263.7094247226],
                        [1.16e-09, 3.75237354024, 104351.612566297],
                        [7.3e-10, 1.18210375402, 130439.515707871],
                        [5.1e-10, 4.54581086194, 156527.418849445],
                        [3.1e-10, 1.44226942756, 182615.321991019],
                        [1.6e-10, 4.56372679459, 208703.225132594],
                        [8e-11, 1.34684622635, 234791.128274168],
                        [3e-11, 4.40269422669, 260879.031415742],
                        [1e-11, 4.69096566687, 27197.2816936676],
                        [1e-11, 1.16082903756, 286966.934557316],
                        [0, 1.44918128781, 24978.5245894808],
                        [0, 4.1804627869, 313054.83769889],
                      ],
          },
          {
            series => "B5",
            terms  => [
                        [1.06e-09, 3.94555784256, 26087.9031415742],
                        [7.5e-10, 3.14159265359, 0],
                        [2.2e-10, 1.30514874546, 52175.8062831484],
                        [7e-11, 4.99717136857, 78263.7094247226],
                        [4e-11, 2.05662545278, 104351.612566297],
                        [2e-11, 5.43162058632, 130439.515707871],
                        [1e-11, 2.68052517331, 156527.418849445],
                        [1e-11, 6.00841870284, 182615.321991019],
                        [0, 2.85941734701, 208703.225132594],
                        [0, 5.96962108614, 234791.128274168],
                      ],
          },
        ],
        [
          {
            series => "R0",
            terms  => [
                        [0.39528271652, 0, 0],
                        [0.07834131817, 6.19233722599, 26087.9031415742],
                        [0.00795525557, 2.95989690096, 52175.8062831484],
                        [0.00121281763, 6.01064153805, 78263.7094247226],
                        [0.00021921969, 2.77820093975, 104351.612566297],
                        [4.354065e-05, 5.82894543257, 130439.515707871],
                        [9.18228e-06, 2.59650562598, 156527.418849445],
                        [2.60033e-06, 3.02817753482, 27197.2816936676],
                        [2.89955e-06, 1.42441936951, 25028.521211385],
                        [2.01855e-06, 5.6472504035, 182615.321991019],
                        [2.01499e-06, 5.59227724202, 31749.2351907264],
                        [1.4198e-06, 6.25264202645, 24978.5245894808],
                        [1.00144e-06, 3.73435608689, 21535.9496445154],
                        [7.7561e-07, 3.66972526976, 20426.571092422],
                        [6.3277e-07, 4.29905918105, 25558.2121764796],
                        [6.2951e-07, 4.76588899933, 1059.3819301892],
                        [6.6754e-07, 2.52520309182, 5661.3320491522],
                        [7.55e-07, 4.47428642962, 51116.4243529592],
                        [4.8266e-07, 6.06824478778, 53285.1848352418],
                        [4.5748e-07, 2.41480951648, 208703.225132594],
                        [3.5224e-07, 1.05917802674, 27043.5028831828],
                        [4.0815e-07, 2.35882016415, 57837.1383323006],
                        [4.4234e-07, 1.21957314874, 15874.6175953632],
                        [3.3873e-07, 0.86381554651, 25661.3049506982],
                        [3.7203e-07, 0.5173382147, 47623.8527860896],
                        [3.0092e-07, 1.79500530627, 37410.5672398786],
                        [2.8417e-07, 3.02063625668, 51066.427731055],
                        [3.0903e-07, 0.88366335532, 24498.8302462904],
                        [2.6105e-07, 2.15021963174, 39609.6545831656],
                        [1.8699e-07, 4.96496008403, 11322.6640983044],
                        [2.127e-07, 5.36857139841, 13521.7514415914],
                        [1.9422e-07, 4.98378647655, 10213.285546211],
                        [1.6941e-07, 3.88765393402, 26617.5941066688],
                        [1.5109e-07, 0.44510589948, 46514.4742339962],
                        [1.7087e-07, 1.24077764194, 77204.3274945334],
                        [1.394e-07, 1.62573946865, 27147.2850717634],
                        [1.3382e-07, 1.07657890477, 51646.1153180538],
                        [1.5012e-07, 4.28173463507, 41962.5207369374],
                        [1.3977e-07, 4.77056848793, 33326.5787331742],
                        [1.2794e-07, 6.06437138766, 1109.3785520934],
                        [1.3938e-07, 1.99984876578, 25132.3033999656],
                        [1.6297e-07, 2.63293587817, 19804.8272915828],
                        [1.1933e-07, 2.36500939134, 4551.9534970588],
                        [1.0612e-07, 5.46555460932, 234791.128274168],
                        [1.2754e-07, 2.07613721222, 529.6909650946],
                        [1.2069e-07, 2.84997619452, 79373.087976816],
                        [9.069e-08, 1.21263611811, 14765.2390432698],
                        [9.491e-08, 0.83697007534, 12566.1516999828],
                        [9.379e-08, 5.41195286503, 83925.0414738748],
                        [7.499e-08, 2.44636811119, 30639.856638633],
                        [7.463e-08, 5.53233943198, 32858.6137428198],
                        [7.215e-08, 1.17101960691, 16983.9961474566],
                        [8.492e-08, 3.56622930635, 73711.7559276638],
                        [7.109e-08, 5.32625264624, 426.598190876],
                        [6.863e-08, 1.82313992707, 36301.1886877852],
                        [6.56e-08, 4.27818149213, 43071.8992890308],
                        [8.853e-08, 3.87737694074, 50586.7333878646],
                        [6.885e-08, 5.3110852663, 1589.0728952838],
                        [5.943e-08, 4.06893157254, 53131.406024757],
                        [7.653e-08, 3.91505031889, 51749.2080922724],
                        [6.46e-08, 6.07127449283, 77154.3308726292],
                        [5.415e-08, 5.20028107807, 65697.5577247398],
                        [5.186e-08, 3.56743214904, 6283.0758499914],
                        [4.09e-08, 3.6759365871, 22645.3281966088],
                        [4.075e-08, 4.29142111073, 103292.230636108],
                        [4.428e-08, 5.69109527379, 45892.730433157],
                        [3.426e-08, 0.64911736234, 52705.497248243],
                        [3.354e-08, 3.49345105494, 72602.3773755704],
                        [4.12e-08, 1.65386255382, 25448.0058552602],
                        [3.261e-08, 1.03195890028, 68050.4238785116],
                        [3.278e-08, 3.13863529552, 25874.6040461362],
                        [3.054e-08, 4.12578324522, 77734.018459628],
                        [3.614e-08, 2.95861599353, 28306.660245761],
                        [2.82e-08, 4.62628436074, 18849.2275499742],
                        [2.746e-08, 4.67880529205, 53235.1882133376],
                        [2.713e-08, 3.5687491398, 26068.2333806744],
                        [2.507e-08, 2.23312085627, 260879.031415742],
                        [3.044e-08, 5.90613310181, 105460.99111839],
                        [2.755e-08, 5.67587087632, 26107.572902474],
                        [2.267e-08, 2.17941340037, 110012.944615449],
                        [2.274e-08, 0.50173671332, 32370.9789915656],
                        [2.741e-08, 4.75427920262, 63498.4703814528],
                        [2.792e-08, 5.05148206806, 51220.2065415398],
                        [2.557e-08, 2.95114696617, 26080.7895945734],
                        [2.135e-08, 0.84621449019, 76674.6365294388],
                        [1.971e-08, 0.4740749431, 48733.231338183],
                        [1.965e-08, 1.37420902653, 7238.6755916],
                        [2.526e-08, 0.34535290139, 23969.1392811958],
                        [2.022e-08, 0.33828477567, 99799.659069238],
                        [1.872e-08, 3.93046425037, 38654.054841557],
                        [1.873e-08, 0.69327393635, 26091.7844769322],
                        [1.945e-08, 2.37383894182, 6770.7106012456],
                        [1.863e-08, 2.26591720786, 26084.0218062162],
                        [1.75e-08, 5.50651903992, 56727.7597802072],
                        [1.971e-08, 3.77455887616, 19317.1925403286],
                        [1.672e-08, 2.15275897581, 26514.5013324502],
                        [1.703e-08, 4.28965990785, 40853.142184844],
                        [1.657e-08, 4.98021773372, 9103.9069941176],
                        [2.084e-08, 2.19427123968, 26301.2022370122],
                        [1.818e-08, 4.20870869718, 25938.3399444396],
                        [1.78e-08, 0.91702846577, 79219.3091663312],
                        [1.525e-08, 2.15720744047, 27676.976036858],
                        [1.533e-08, 1.54503054415, 955.5997416086],
                        [1.614e-08, 1.27565104562, 25035.6347583858],
                        [1.743e-08, 0.68269002122, 77837.1112338466],
                        [1.389e-08, 4.85102048256, 62389.0918293594],
                        [1.436e-08, 0.05742216761, 23869.1460373874],
                        [1.563e-08, 5.84795233948, 26095.016688575],
                        [1.64e-08, 4.66281337712, 25021.4076643842],
                        [1.552e-08, 2.83910580545, 103242.234014203],
                        [1.249e-08, 1.97225274067, 91785.460866314],
                        [1.16e-08, 1.73113341823, 38519.945791972],
                        [1.005e-08, 1.0589831486, 129380.133777682],
                        [1.041e-08, 2.78036322434, 213.299095438],
                        [1.105e-08, 4.55512109515, 26011.6370702986],
                        [9.79e-09, 2.43870419667, 71980.6335747312],
                        [8.53e-09, 0.56334001923, 20760.4270331914],
                        [8.74e-09, 4.53679970936, 639.897286314],
                        [7.83e-09, 3.69782403005, 78793.4003898172],
                        [7.72e-09, 4.08714349549, 94138.3270200858],
                        [7.97e-09, 0.26237215917, 98690.2805171446],
                        [9.65e-09, 4.70784179954, 51535.9089968344],
                        [9.52e-09, 2.53604676495, 29530.4780865396],
                        [7.73e-09, 2.67893222158, 131548.894259964],
                        [7.34e-09, 0.8924366949, 103821.921601202],
                        [6.68e-09, 3.73113394924, 46848.3301747656],
                        [8.28e-09, 2.88184821542, 19406.6782881746],
                        [6.22e-09, 1.05579535631, 59414.4818747484],
                        [6.76e-09, 4.5035759936, 25934.1243310894],
                        [6.02e-09, 5.28399057704, 286966.934557316],
                        [6.19e-09, 1.44855037685, 79323.0913549118],
                        [6.91e-09, 6.19733262608, 51962.5071877104],
                        [5.63e-09, 5.22994296186, 136100.847757023],
                        [7.82e-09, 3.25257254691, 50057.04242277],
                        [5.51e-09, 0.33644229836, 52156.1365222486],
                        [7.05e-09, 4.7370537192, 26241.681952059],
                        [5.77e-09, 5.85654734429, 2118.7638603784],
                        [5.17e-09, 3.93195379429, 102762.539671013],
                        [6.35e-09, 4.87720838965, 12432.0426503978],
                        [6.35e-09, 1.81903685898, 77308.109683114],
                        [5.43e-09, 1.40877130839, 44937.1306915484],
                        [5.56e-09, 5.44324390449, 85034.4200259682],
                        [4.96e-09, 3.39004132624, 125887.562210812],
                        [5.46e-09, 4.78005317483, 22747.2907148744],
                        [5.2e-09, 6.00172746972, 52168.6927361476],
                        [4.63e-09, 3.67549187956, 25668.418497699],
                        [4.52e-09, 3.53009000682, 58458.8821331398],
                        [4.74e-09, 5.9433051204, 54394.5633873352],
                        [5.59e-09, 2.44355554028, 52195.4760440482],
                        [4.18e-09, 3.73369494476, 103925.014375421],
                        [3.97e-09, 0.6901460802, 64741.9579831312],
                        [5.11e-09, 5.88243734524, 45494.5814297488],
                        [4.12e-09, 2.26754404446, 82815.6629217814],
                        [4.25e-09, 5.24511927496, 52389.1053785864],
                        [4.82e-09, 0.98165400059, 25654.1914036974],
                        [3.8e-09, 3.74413132157, 52179.6876185064],
                        [3.59e-09, 5.50961077408, 26555.8681319286],
                        [3.75e-09, 1.97920050124, 149.5631971346],
                        [3.85e-09, 5.8899194879, 129330.137155778],
                        [3.48e-09, 4.91064019959, 1052.2683831884],
                        [4.17e-09, 4.32916053867, 51123.53789996],
                        [4.25e-09, 1.43228996047, 51109.3108059584],
                        [4.64e-09, 3.98651628073, 105307.212307905],
                        [3.29e-09, 5.20636278221, 52602.4044740244],
                        [3.54e-09, 1.04383146533, 66941.0453264182],
                        [3.24e-09, 1.62975761811, 88476.9949709336],
                        [3.78e-09, 5.31676765847, 52171.9249477904],
                        [4.4e-09, 1.46381183715, 89586.373523027],
                        [3.55e-09, 1.52732265492, 1066.49547719],
                        [3.02e-09, 5.21113786435, 53764.8791784322],
                        [3.01e-09, 5.02488829134, 117873.364007888],
                        [3.51e-09, 2.0043334173, 24395.7374720718],
                        [2.89e-09, 6.19161799918, 26094.5317004742],
                        [2.86e-09, 3.77170690304, 7.1135470008],
                        [2.84e-09, 3.10942616808, 49957.0491789616],
                        [3.85e-09, 2.47184729453, 25234.7067598222],
                        [3.82e-09, 0.97683830518, 52026.2430860138],
                        [2.71e-09, 5.74710334372, 25455.119402261],
                        [3.75e-09, 0.55187466535, 45405.0956819028],
                        [2.67e-09, 2.86410554301, 80482.4665289094],
                        [3.04e-09, 6.00190488272, 2218.7571041868],
                        [2.59e-09, 1.82921035765, 24505.9437932912],
                        [2.51e-09, 4.10979574073, 155468.036919256],
                        [2.89e-09, 3.05373259745, 26081.2745826742],
                        [2.42e-09, 5.05501089774, 42153.969003049],
                        [2.44e-09, 2.1562166805, 3442.5749449654],
                        [3.15e-09, 2.61613386386, 52182.9198301492],
                        [2.56e-09, 3.71117332461, 25619.9381512198],
                        [2.32e-09, 2.21576531181, 16066.0658614748],
                        [2.33e-09, 5.49033130906, 98068.5367163054],
                        [2.36e-09, 4.08612620637, 26013.1215430069],
                        [2.25e-09, 0.4444933881, 76144.9455643442],
                        [2.42e-09, 3.29851820234, 6681.2248533996],
                        [2.27e-09, 1.63236736805, 76.2660712756],
                        [2.68e-09, 1.09037236588, 18093.37469955],
                        [2.55e-09, 4.20635818545, 44181.2778411242],
                        [2.05e-09, 1.00234895959, 26190.9959157928],
                        [2.28e-09, 1.46077047931, 77623.8121384086],
                        [1.97e-09, 1.36693360783, 26727.8004278882],
                        [2.59e-09, 1.28296039354, 13655.8604911764],
                        [1.97e-09, 5.7330758343, 157636.797401539],
                        [1.96e-09, 0.06606260924, 40565.2543247742],
                        [1.87e-09, 0.86187283408, 120226.23016166],
                        [2.62e-09, 4.14850032709, 24491.7166992896],
                        [2.44e-09, 4.14399890076, 95247.7055721792],
                        [2.32e-09, 5.45165695316, 33967.9922949132],
                        [2.06e-09, 5.59196913034, 55618.3812281138],
                        [2.03e-09, 1.64252462466, 58946.516884394],
                        [1.87e-09, 0.46291089182, 104881.303531391],
                        [1.92e-09, 1.827611583, 25551.0986294788],
                        [2e-09, 1.81376901527, 25863.5583458723],
                        [1.91e-09, 5.57428963071, 5327.4761083828],
                        [1.95e-09, 3.31297083154, 124778.183658719],
                        [1.69e-09, 1.69270064342, 90695.7520751204],
                        [2.26e-09, 1.32354627258, 52099.5402118728],
                        [1.77e-09, 3.296208483, 25131.6139856036],
                        [1.78e-09, 2.5482379505, 26720.6868808874],
                        [1.67e-09, 3.61983109002, 23754.7067487022],
                        [1.59e-09, 3.48396967776, 25977.6968203548],
                        [1.5e-09, 5.20072476078, 69159.802430605],
                        [1.79e-09, 3.94252428767, 129909.824742776],
                        [1.66e-09, 0.40320638452, 100909.037621331],
                        [1.76e-09, 2.97410942402, 24925.4284371664],
                        [1.54e-09, 1.27206049137, 25984.8103673556],
                        [1.44e-09, 1.89319156163, 64607.8489335462],
                        [1.45e-09, 2.05409839424, 313054.83769889],
                        [1.52e-09, 4.87194153709, 103396.012824688],
                        [1.37e-09, 3.86782217557, 24609.0365675098],
                        [1.41e-09, 1.99770625298, 162188.750898597],
                        [1.85e-09, 6.10038742063, 23439.4483161012],
                        [1.35e-09, 1.27363012793, 52022.0274726636],
                        [1.27e-09, 0.70464976569, 128850.442812587],
                        [1.42e-09, 1.50696203402, 52329.5850936332],
                        [1.26e-09, 2.70555128398, 28206.6670019526],
                        [1.26e-09, 1.61963252183, 48835.1938564486],
                        [1.23e-09, 0.15629905349, 151975.465352386],
                        [1.37e-09, 1.77306412615, 35191.8101356918],
                        [1.47e-09, 4.50311642422, 105410.994496486],
                        [1.25e-09, 3.38994834526, 78244.0396638228],
                        [1.19e-09, 2.77644375904, 78256.5958777218],
                        [1.56e-09, 2.96616703196, 78050.4103292846],
                        [1.45e-09, 1.35569389554, 3340.6124266998],
                        [1.26e-09, 3.97006576134, 29428.515568274],
                        [1.28e-09, 5.41891989692, 26162.6847401415],
                        [1.32e-09, 4.86901248209, 24712.1293417284],
                        [1.1e-09, 3.8795470244, 85502.3850163226],
                        [1.27e-09, 5.49703075555, 78283.3791856224],
                        [1.26e-09, 0.94870979828, 121335.608713753],
                        [1.29e-09, 4.00691218396, 72936.2333163398],
                        [1.02e-09, 0.50487650429, 130012.917516995],
                        [1.04e-09, 0.29849788751, 84546.785274714],
                        [1.18e-09, 0.76511176346, 131395.11544948],
                        [1.2e-09, 4.45261989231, 71025.0338331226],
                        [1.17e-09, 3.31644134053, 25771.5112719176],
                        [1.1e-09, 2.632499343, 71582.484571323],
                        [9.7e-10, 2.66105435933, 155418.040297352],
                        [1.13e-09, 5.8873357539, 26404.2950112308],
                        [9.8e-10, 2.01417457095, 78477.0085201606],
                        [1.03e-09, 0.46416881502, 51756.3216392732],
                        [9.3e-10, 2.37389467504, 419.4846438752],
                        [1.25e-09, 1.87932536282, 26610.480559668],
                        [9.5e-10, 0.34221817875, 26507.3877854494],
                        [9.3e-10, 3.80346806552, 26037.90651967],
                        [9.1e-10, 2.63082094391, 28421.0995344462],
                        [1.01e-09, 5.20997240587, 433.7117378768],
                        [9.6e-10, 4.47724179825, 77197.2139475326],
                        [1.08e-09, 4.03679713919, 51742.0945452716],
                        [8.6e-10, 5.14039556935, 26237.4663387088],
                        [9.2e-10, 3.74335845403, 90829.8611247054],
                        [8.6e-10, 1.86276413658, 27140.1715247626],
                        [1.02e-09, 5.40465219833, 26137.8997634784],
                        [8.6e-10, 4.01653667598, 10021.8372800994],
                        [1e-09, 5.32142188276, 108903.566063356],
                        [7.9e-10, 4.68108496987, 27154.3986187642],
                        [9.2e-10, 5.52103093635, 51322.6099013964],
                        [9.3e-10, 4.20604773511, 38813.3565763492],
                        [7.8e-10, 2.88001982141, 29416.0387978544],
                        [9.5e-10, 4.44018421307, 115674.276664601],
                        [1.04e-09, 5.05004528676, 50483.640613646],
                        [7.5e-10, 1.7892706053, 143961.267149462],
                        [8.6e-10, 0.51423355089, 78267.5907600806],
                        [7.8e-10, 4.6683117379, 114564.898112508],
                        [7.8e-10, 4.20137623264, 1692.1656695024],
                        [8.6e-10, 4.03030391951, 78114.146227588],
                        [7.3e-10, 2.27328552013, 52643.7712735028],
                        [8.2e-10, 3.7351059211, 853.196381752],
                        [7.1e-10, 4.89150553141, 50593.8469348654],
                        [8.2e-10, 5.22677693918, 27999.1026247914],
                        [9.3e-10, 1.0956916144, 77211.4410415342],
                        [7.4e-10, 1.97833720876, 78690.3076155986],
                        [8.2e-10, 3.59482991001, 71492.998823477],
                        [8.3e-10, 4.10355702051, 93028.9484679924],
                        [8.3e-10, 3.12647584943, 14477.3511832],
                        [6.7e-10, 0.24182046727, 66653.1574663484],
                        [7.4e-10, 5.66833060422, 78270.8229717234],
                        [6.8e-10, 1.98236355905, 79852.7823200064],
                        [6.4e-10, 5.551158145, 25764.3977249168],
                        [6.4e-10, 6.15935356751, 76044.9523205358],
                        [8.7e-10, 1.77296830923, 25440.8923082594],
                        [7.3e-10, 2.06220281759, 111122.323167542],
                        [6.6e-10, 2.28151075383, 7880.08915333899],
                        [7.6e-10, 2.65553220848, 34282.1784747828],
                        [7.8e-10, 0.40338105541, 49842.6098902764],
                        [6.4e-10, 0.87558639332, 181555.94006083],
                        [8.6e-10, 2.0869774868, 78259.8280893646],
                        [7.4e-10, 0.865017517, 50579.6198408638],
                        [8.2e-10, 1.02659883956, 74821.1344797572],
                        [5.9e-10, 2.45952644668, 51543.0225438352],
                        [6.2e-10, 0.94273311929, 25344.9130810416],
                        [5.8e-10, 2.95861781205, 52182.4348420484],
                        [5.8e-10, 4.20402726578, 96357.0841242726],
                        [6.1e-10, 2.81500265978, 26202.3424302594],
                        [5.7e-10, 2.27689377996, 124156.43985788],
                        [5.7e-10, 4.37167017012, 1581.959348283],
                        [5.5e-10, 0.12465494356, 25973.463852889],
                        [5.4e-10, 4.79303212221, 26164.1692128498],
                        [5.4e-10, 3.05622204718, 25565.3257234804],
                        [5.5e-10, 4.51497762833, 103711.715279983],
                        [5.4e-10, 3.87143037686, 18207.8139882352],
                        [5.4e-10, 4.62784653733, 25881.717593137],
                        [5.3e-10, 4.3254827227, 70269.1809826984],
                        [5e-10, 2.5006687765, 183724.700543113],
                        [5.8e-10, 2.06211216656, 1596.1864422846],
                        [6.6e-10, 5.2029881429, 26294.0886900114],
                        [4.7e-10, 0.85039730966, 52101.0246845811],
                        [5.8e-10, 1.43409045174, 23866.0465069772],
                        [4.8e-10, 2.35364103056, 81706.284369688],
                        [5.2e-10, 0.19368783267, 92741.0606079226],
                        [5.3e-10, 0.58517949906, 26624.7076536696],
                        [6.1e-10, 2.61493039721, 49527.3514576754],
                        [4.7e-10, 3.88384847335, 146314.133303234],
                        [4.9e-10, 6.20308247475, 32769.1279949738],
                        [5.3e-10, 4.37486529196, 78187.443353447],
                        [4.8e-10, 5.97568482401, 51013.3315787406],
                        [4.8e-10, 3.84102043742, 102232.848705918],
                        [4.9e-10, 5.05464216653, 7994.5284420242],
                        [4.4e-10, 5.4289022484, 86143.7985780616],
                        [5.8e-10, 3.80571138237, 99024.136457914],
                        [4.4e-10, 4.02792920142, 147423.511855328],
                        [5.8e-10, 6.09746566424, 52169.1777242484],
                        [4.2e-10, 4.38843836266, 224.3447957019],
                        [4.3e-10, 1.57859396874, 23976.2528281966],
                        [4.9e-10, 0.46973350644, 51707.841292794],
                        [4e-10, 4.41764731583, 52815.7035694624],
                        [4.6e-10, 3.51985131014, 130969.206672966],
                        [4.5e-10, 4.35527612249, 39743.7636327506],
                        [4.5e-10, 0.78163192715, 25138.7275326044],
                        [4.9e-10, 0.90057831755, 632.7837393132],
                        [4.1e-10, 4.0422561567, 52278.899057367],
                        [3.9e-10, 2.9182959512, 956.2891559706],
                        [4.3e-10, 0.13178694356, 2648.454825473],
                        [3.8e-10, 0.62377784752, 50696.939709084],
                        [4.2e-10, 2.75028269027, 24079.3456024152],
                        [4e-10, 1.64358052897, 39629.3243440654],
                        [3.7e-10, 5.75760879379, 25867.4904991354],
                        [5.1e-10, 1.57829002915, 12725.453434775],
                        [3.7e-10, 1.62981695072, 129483.915966262],
                        [4.5e-10, 0.04645406242, 51219.5171271778],
                        [3.6e-10, 0.098343736, 25241.820306823],
                        [4.9e-10, 0.0768115705, 150866.086800293],
                        [3.4e-10, 4.56091607046, 536.8045120954],
                        [3.6e-10, 5.59483746723, 52808.5900224616],
                        [3.9e-10, 5.9950025247, 104138.313470859],
                        [4.6e-10, 0.70772608543, 155997.727884351],
                        [3.3e-10, 4.54716206885, 78417.4882352074],
                        [4.1e-10, 4.92673567168, 51639.001771053],
                        [3.2e-10, 4.31372208361, 78109.9306142378],
                        [3.6e-10, 5.69791953426, 26049.7701059364],
                        [3.4e-10, 3.32168809248, 35472.7441496494],
                        [4.2e-10, 4.86530735726, 51951.4614874465],
                        [3.3e-10, 3.73733919231, 154938.345954161],
                        [4.1e-10, 2.38147812869, 68241.8721446232],
                        [3.5e-10, 5.0957104722, 339142.740840465],
                        [3.1e-10, 4.31506703539, 52072.7135089298],
                        [3.2e-10, 3.21248509301, 178063.368493961],
                        [3.5e-10, 5.04278529087, 188276.654040172],
                        [4.1e-10, 3.22838990589, 1162.4747044078],
                        [3e-10, 2.3306109214, 1478.8665740644],
                        [3.2e-10, 2.71244280066, 25780.3455206046],
                        [3.2e-10, 3.8041146042, 157483.018591054],
                        [3e-10, 0.37624991562, 26421.7590823436],
                        [2.9e-10, 5.82513433576, 104344.499019296],
                        [3.1e-10, 6.02215690021, 26198.1094627936],
                        [4e-10, 1.02201252788, 27819.0254945068],
                        [3e-10, 2.2584999502, 104371.282327197],
                        [2.9e-10, 2.67851330746, 110.2063212194],
                        [3e-10, 1.34446903292, 1375.7737998458],
                        [2.8e-10, 4.62845152557, 74923.0969980228],
                        [3.7e-10, 3.03899000872, 11610.5519583742],
                        [3.2e-10, 0.26062549755, 52065.599961929],
                        [3.8e-10, 1.257046524, 131498.89763806],
                        [3.2e-10, 1.04832153595, 26086.4186688659],
                        [3.7e-10, 1.63595908508, 50800.0324833026],
                        [3e-10, 0.15550783905, 104331.942805397],
                        [2.6e-10, 0.03549300809, 24815.222115947],
                        [2.6e-10, 1.03871337432, 24292.6446978532],
                        [2.6e-10, 3.54557412535, 156100.820658569],
                        [2.7e-10, 0.60333270859, 111590.288157897],
                        [3.1e-10, 3.3554055611, 126996.940762906],
                        [2.6e-10, 5.73937805822, 54294.5701435268],
                        [2.6e-10, 2.79743885101, 86457.9847579312],
                        [2.6e-10, 5.70579806927, 97670.3877128972],
                        [2.5e-10, 2.34928986187, 24601.923020509],
                        [2.5e-10, 5.70613852018, 181505.943438926],
                        [3.4e-10, 0.23651097126, 26395.4607625438],
                        [2.5e-10, 2.19241735868, 52250.5878817157],
                        [2.5e-10, 1.82880416247, 74.7815985673],
                        [2.8e-10, 0.57661358158, 125112.039599488],
                        [2.4e-10, 2.0393825417, 26521.614879451],
                        [2.4e-10, 5.05213893429, 104564.911661735],
                        [2.3e-10, 6.23874249128, 75615.2545992496],
                        [2.6e-10, 3.34519516519, 110634.688416288],
                        [2.6e-10, 4.74840245512, 13362.4497067992],
                        [2.6e-10, 0.15419927428, 22759.767485294],
                        [2.7e-10, 2.39568978424, 522.5774180938],
                        [2.8e-10, 0.25542748453, 103.0927742186],
                        [2.5e-10, 3.32961707416, 28286.9904848612],
                        [2.6e-10, 2.07987634823, 29550.1478474394],
                        [3.2e-10, 1.70464933285, 26089.3876142825],
                        [2.3e-10, 4.16670746048, 24176.703658357],
                        [2.4e-10, 0.08582796512, 51859.4144134918],
                        [2.5e-10, 5.27240695394, 25936.8554717313],
                        [2.4e-10, 0.80363857551, 77829.9976868458],
                        [2.3e-10, 2.30360039127, 77410.5130429706],
                        [3e-10, 1.21286011206, 97112.9369746968],
                        [2.2e-10, 4.82094558003, 13541.4212024912],
                        [2.3e-10, 2.65250267545, 52492.198152805],
                        [2.6e-10, 6.26936948934, 25939.8244171479],
                        [2.4e-10, 4.92454390318, 52698.3837012422],
                        [2.2e-10, 1.2347092155, 103285.117089107],
                        [2.3e-10, 3.68813881444, 26729.3167033132],
                        [2.2e-10, 1.95831083558, 24356.7807886416],
                        [2.2e-10, 0.78346634338, 104202.049369162],
                        [2.1e-10, 2.5293143267, 467.9649903544],
                        [2.4e-10, 1.84656751628, 76571.5437552202],
                        [2.5e-10, 2.55626379808, 24822.3356629478],
                        [2.7e-10, 3.61440862477, 23962.025734195],
                        [2.3e-10, 1.18953680418, 141762.179806175],
                        [2e-10, 5.49778171394, 112231.701719636],
                        [2.3e-10, 2.6071960805, 25754.0472008048],
                        [2.6e-10, 0.75788900266, 55516.4187098482],
                        [2.6e-10, 2.09375500363, 134991.46920493],
                        [2e-10, 3.35091650179, 52595.2909270236],
                        [2.1e-10, 0.36570195077, 97580.9019650512],
                        [2.4e-10, 0.51085875774, 116917.76426628],
                        [2.1e-10, 5.71018496974, 60055.8954364874],
                        [1.9e-10, 0.56236491686, 52125.8096612442],
                        [1.9e-10, 2.85801633295, 60370.081616357],
                        [2.4e-10, 3.50657176712, 77844.2247808474],
                        [2e-10, 0.53533403977, 26941.0995233262],
                        [1.9e-10, 6.25214103463, 25973.5040346608],
                        [2.2e-10, 5.13145226592, 104347.731230939],
                        [2.1e-10, 4.13407823619, 103299.344183108],
                        [1.9e-10, 0.33492578967, 102018.416173425],
                        [1.9e-10, 5.67148210198, 54509.0026760204],
                        [1.8e-10, 1.90051892916, 52325.369480283],
                        [1.9e-10, 4.27364751897, 122444.987265847],
                        [1.8e-10, 2.45675888957, 104358.726113298],
                        [1.8e-10, 1.05990359493, 27780.0688110766],
                        [1.8e-10, 1.43297513339, 53242.3017603384],
                        [2.1e-10, 2.99876487527, 26073.6760475726],
                        [2.3e-10, 1.86389686355, 116783.655216695],
                        [1.8e-10, 4.87152831033, 170049.170291037],
                        [1.9e-10, 4.89400475242, 53228.0746663368],
                        [2.1e-10, 2.47295566818, 27726.9726587622],
                        [2e-10, 4.98762998978, 104778.210757173],
                        [2.1e-10, 1.46468188731, 140652.801254082],
                        [1.7e-10, 4.05153553008, 76667.522982438],
                        [2e-10, 4.80985268979, 51528.7954498336],
                        [2.2e-10, 0.86617331302, 119116.851609567],
                        [2.3e-10, 2.08281937549, 52225.8029050526],
                        [1.8e-10, 1.69333480892, 76681.7500764396],
                        [1.7e-10, 2.09406764538, 64901.2597179234],
                        [1.9e-10, 5.00011023502, 105940.685461581],
                        [1.9e-10, 0.74020534937, 36109.7404216736],
                        [1.7e-10, 2.93246868693, 102132.85546211],
                        [2.2e-10, 3.55902023067, 104355.493901655],
                        [2.1e-10, 3.54390310557, 106570.369670484],
                        [1.8e-10, 4.65006394461, 61279.713277266],
                        [1.9e-10, 4.43905256177, 647.0108333148],
                        [1.7e-10, 2.831244806, 132658.272812058],
                        [1.8e-10, 2.89808596608, 26091.8352948373],
                        [1.7e-10, 5.67044617806, 25788.776747305],
                        [1.7e-10, 5.37178978632, 78731.674415077],
                        [1.5e-10, 5.25910515843, 150244.342999454],
                        [1.9e-10, 1.72681089737, 153.7788104848],
                        [1.5e-10, 2.16472550978, 26222.0121911592],
                        [1.5e-10, 1.1302968538, 25042.7483053866],
                        [1.5e-10, 2.31335544105, 51852.300866491],
                        [1.9e-10, 4.38254962804, 24182.4383766338],
                        [1.5e-10, 5.16465400786, 27684.0895838588],
                        [1.7e-10, 3.97954718583, 207643.843202404],
                        [1.6e-10, 5.7405789846, 25352.0266280424],
                        [1.4e-10, 3.42441202713, 26823.779655106],
                        [1.4e-10, 5.30168284837, 742.9900605326],
                        [1.4e-10, 2.5043130681, 32132.1317229496],
                        [1.4e-10, 1.36632464908, 23919.1426592916],
                        [1.5e-10, 6.0749051443, 78270.3379836226],
                        [1.9e-10, 4.4055707896, 49953.9496485514],
                        [1.4e-10, 0.65475293554, 323.5054166574],
                        [1.4e-10, 0.47093305165, 17893.6278083656],
                        [1.4e-10, 1.33029112501, 129799.618421557],
                        [1.7e-10, 6.0291534594, 26667.590728573],
                        [1.4e-10, 1.17588054181, 104275.346495021],
                        [1.4e-10, 4.84032377923, 2221.856634597],
                        [1.4e-10, 5.53694881682, 77630.9256854094],
                        [1.3e-10, 5.5979123873, 209812.603684687],
                        [1.3e-10, 0.84042148682, 173511.414996902],
                        [1.5e-10, 3.96416547461, 51432.8162226158],
                        [1.5e-10, 3.17020350946, 176953.989941867],
                        [1.4e-10, 2.91048815444, 78257.0808658226],
                        [1.3e-10, 5.34915944924, 80174.9089079398],
                        [1.8e-10, 1.65795375577, 28256.6636238568],
                        [1.3e-10, 3.34629064183, 25508.2155545754],
                        [1.6e-10, 1.32228458025, 27669.8624898572],
                        [1.3e-10, 1.38990649917, 25024.5890581219],
                        [1.7e-10, 2.01249037695, 27037.078750544],
                        [1.5e-10, 1.99208068531, 52381.9918315856],
                        [1.3e-10, 2.32883800921, 27005.833427556],
                        [1.4e-10, 3.86914390591, 182085.631025925],
                        [1.2e-10, 3.97054224711, 78188.9278261553],
                        [1.6e-10, 5.59174105029, 25446.4895798352],
                        [1.4e-10, 0.70490117614, 172402.036444808],
                        [1.2e-10, 1.54422590258, 52252.072354424],
                        [1.4e-10, 3.47518139481, 27177.6119327678],
                        [1.2e-10, 5.46223056321, 107794.187511262],
                        [1.2e-10, 5.76552608362, 50167.2487439894],
                        [1.6e-10, 2.18648993322, 26308.315784013],
                        [1.4e-10, 2.72148386686, 27311.7209823528],
                        [1.3e-10, 0.55524977232, 75930.5130318506],
                        [1.2e-10, 2.66601602132, 137210.226309117],
                        [1.1e-10, 0.61596543052, 44295.7171298094],
                        [1.1e-10, 4.76091715459, 155571.819107837],
                        [1.4e-10, 5.93896401871, 52290.2455718336],
                        [1.1e-10, 0.92596625175, 22625.658435709],
                        [1.2e-10, 6.19273795549, 51653.2288650546],
                        [1.4e-10, 0.79969658546, 25953.7940919892],
                        [1.1e-10, 2.82093111356, 77101.2347203148],
                        [1.1e-10, 1.26994666311, 26312.2479372761],
                        [1.3e-10, 2.88923696437, 112545.887899505],
                        [1.1e-10, 6.05528757595, 27044.1922975448],
                        [1.2e-10, 3.29626000869, 52061.3669944632],
                        [1.1e-10, 3.58945976808, 52712.6107952438],
                        [1.4e-10, 2.790365075, 23888.8157982872],
                        [1.1e-10, 4.15810059578, 45290.6563932176],
                        [1.1e-10, 2.94979930726, 58857.031136548],
                        [1.2e-10, 2.20589728666, 31415.379249957],
                        [1.2e-10, 1.34841658603, 51969.6207347112],
                        [1.1e-10, 3.29585795787, 28736.3579670472],
                        [1.1e-10, 0.43538573957, 24448.8336243862],
                        [1e-10, 2.85999162474, 130226.216612433],
                        [1.3e-10, 4.41880429822, 19958.6061020676],
                        [1.2e-10, 5.96394058241, 26083.9709883111],
                        [1e-10, 5.442971467, 163298.129450691],
                        [1.2e-10, 1.57767582029, 91805.1306272138],
                        [1e-10, 3.83536418151, 51226.6306741786],
                        [1.3e-10, 0.34187342138, 157057.10981454],
                        [1e-10, 1.12787053523, 78903.6067110366],
                        [1e-10, 4.67818130014, 2111.6503133776],
                        [1.2e-10, 3.56391619799, 77795.7444343682],
                        [1.1e-10, 5.80720491261, 26102.1302355758],
                        [1.2e-10, 5.802523822, 27972.8043049916],
                        [1.1e-10, 2.47026109919, 26010.1525975903],
                        [1.3e-10, 4.60245036657, 25032.4533646481],
                        [1e-10, 1.14221106164, 9384.8410080752],
                        [1.3e-10, 5.56953201474, 22909.7573510066],
                        [1e-10, 4.35806585483, 157586.800779634],
                        [1e-10, 1.11553298844, 65831.6667743248],
                        [1.1e-10, 4.67108617661, 50064.1559697708],
                        [1.1e-10, 2.80726281395, 81591.8450810028],
                        [9e-11, 0.4735375306, 128106.319314999],
                        [9e-11, 1.42459829123, 104505.391376782],
                        [9e-11, 2.37565722096, 78896.4931640358],
                        [9e-11, 4.84820485208, 24918.3148901656],
                        [1.1e-10, 6.2383400887, 30171.8916482786],
                        [1.1e-10, 1.65565660037, 78039.3646290207],
                        [9e-11, 3.65734666897, 151199.942741062],
                        [9e-11, 5.40966654859, 130459.185468771],
                        [1e-10, 0.87714716556, 78366.8021989412],
                        [9e-11, 3.04701773654, 51329.7234483972],
                        [9e-11, 1.96005885441, 26575.5378928284],
                        [1e-10, 1.18004009296, 50270.341518208],
                        [9e-11, 5.48583841069, 138319.60486121],
                        [1e-10, 3.21154218694, 77307.420268752],
                        [9e-11, 5.55407965409, 8194.2753332086],
                        [8e-11, 1.35584545211, 12546.481939083],
                        [9e-11, 0.42023516699, 27223.5800134674],
                        [1e-10, 1.7670450966, 77726.9049126272],
                        [9e-11, 1.60501838348, 77616.6985914078],
                        [9e-11, 5.46388323313, 16703.062133499],
                        [9e-11, 1.60520912676, 117893.033768788],
                        [9e-11, 6.2352873989, 846.0828347512],
                        [9e-11, 5.66619352199, 50910.238804522],
                        [9e-11, 1.18753574623, 104197.833755812],
                        [9e-11, 0.69327774851, 26709.6469424134],
                        [1e-10, 5.48870132496, 94329.7752861974],
                        [8e-11, 1.17006056902, 78160.616650504],
                        [9e-11, 0.4996506522, 27573.1938482774],
                        [1.1e-10, 6.20705720585, 28102.884813372],
                        [1.1e-10, 0.75657533913, 128320.751847493],
                        [8e-11, 3.8643079482, 103917.90082842],
                        [9e-11, 3.64580324894, 76784.8428506582],
                        [8e-11, 4.52722085618, 27463.67694142],
                        [9e-11, 1.73726961641, 28791.5192962498],
                        [1.1e-10, 1.86762532326, 214364.557181746],
                        [8e-11, 3.17547134507, 50903.1252575212],
                        [8e-11, 6.2314049198, 148.0787244263],
                        [8e-11, 0.97646930359, 19202.7532516434],
                        [8e-11, 0.87651427964, 151.0476698429],
                        [9e-11, 1.55645109653, 26126.036177212],
                        [8e-11, 3.12232090039, 22003.9146348698],
                        [8e-11, 3.45204671122, 24203.0019781568],
                        [8e-11, 2.50177739941, 51955.3936407096],
                        [8e-11, 4.20326276911, 50380.5478394274],
                        [8e-11, 2.66681931912, 130432.40216087],
                        [1e-10, 2.61302801987, 27170.9833738678],
                        [8e-11, 6.1579179294, 37698.4550999484],
                        [8e-11, 5.36718741692, 35077.3708470066],
                        [8e-11, 0.39542025081, 183570.921732628],
                        [8e-11, 4.37576068847, 123200.840116271],
                        [8e-11, 3.44870239791, 26402.0893214438],
                        [7e-11, 5.88380837195, 51868.2486621788],
                        [7e-11, 4.80640660702, 26118.2300025786],
                        [8e-11, 5.82773614091, 3328.13565628019],
                        [9e-11, 2.53209611805, 25227.5932128214],
                        [1e-10, 2.5279323615, 35833.2236974308],
                        [8e-11, 4.11204744654, 53906.928636081],
                        [8e-11, 1.58745297967, 101011.000139597],
                        [9e-11, 2.57384727244, 2125.8774073792],
                        [7e-11, 2.46084982092, 52137.6732475106],
                        [8e-11, 5.5657753539, 50689.8261620832],
                        [7e-11, 5.98112141065, 52179.7384364115],
                        [1e-10, 5.16567712694, 55638.0509890136],
                        [8e-11, 4.67643518278, 76887.9356248768],
                        [7e-11, 4.36322743599, 155887.521563131],
                        [9e-11, 0.68598593831, 38.1330356378],
                        [8e-11, 0.46194680162, 181026.249095736],
                        [8e-11, 0.42442705032, 182188.723800143],
                        [9e-11, 3.57254516611, 1265.5674786264],
                        [9e-11, 1.65553917926, 65717.2274856396],
                        [1e-10, 3.53066047636, 2008.557539159],
                        [7e-11, 3.8937339755, 1485.9801210652],
                        [1e-10, 0.8255026956, 39763.4333936504],
                        [7e-11, 4.33817871844, 129373.020230681],
                        [7e-11, 3.41340083585, 52483.363904118],
                        [8e-11, 1.2399232388, 76041.8527901256],
                        [7e-11, 0.04567921269, 206.1855484372],
                        [7e-11, 2.56169701158, 207593.8465805],
                        [9e-11, 1.97148507623, 365230.643982039],
                        [7e-11, 3.14813276839, 52061.407176235],
                        [7e-11, 4.86954611488, 27351.0605041524],
                        [8e-11, 6.27520424489, 204151.271635535],
                        [7e-11, 5.46143749214, 25985.9406233086],
                        [8e-11, 4.44335543148, 26057.5762805698],
                        [7e-11, 1.00677483843, 129387.247324683],
                        [8e-11, 0.22314041177, 50049.9288757692],
                        [7e-11, 3.98224449185, 13675.5302520762],
                        [7e-11, 4.34489404354, 167850.08294775],
                        [9e-11, 0.71471851401, 233731.746343979],
                        [7e-11, 1.69935809006, 54087.0057663656],
                        [7e-11, 6.21044393135, 203041.893083441],
                        [7e-11, 2.53524305485, 80382.473285101],
                        [7e-11, 0.03218225075, 31281.270200372],
                        [7e-11, 5.26037977949, 78338.4910232899],
                        [7e-11, 3.52744190481, 52509.6622239178],
                        [7e-11, 5.24771876203, 1795.258443721],
                        [7e-11, 5.20875856726, 161079.372346504],
                        [7e-11, 3.19471628666, 24072.9214697764],
                        [6e-11, 1.5809679318, 143980.936910362],
                        [9e-11, 0.70414754528, 25169.9728555924],
                        [6e-11, 0.15264531683, 52911.6827966802],
                        [7e-11, 4.2857845572, 51130.6514469608],
                        [7e-11, 3.42650023556, 29396.3690369546],
                        [7e-11, 4.12959254769, 52174.3218104401],
                        [8e-11, 3.79812131071, 137678.191299471],
                        [7e-11, 5.70602822567, 9745.3205558566],
                        [8e-11, 0.14316432919, 136722.591557862],
                        [7e-11, 3.78832454636, 26189.8656598398],
                        [7e-11, 5.44664616173, 27566.7697156386],
                        [6e-11, 0.53269408847, 208173.534167499],
                        [7e-11, 3.95192199993, 145204.754751141],
                        [6e-11, 1.8061026575, 26830.8932021068],
                        [8e-11, 5.80105964058, 25773.7169617046],
                        [6e-11, 1.20705629404, 26734.913974889],
                        [8e-11, 3.87508349031, 52041.6972335634],
                        [7e-11, 1.874291269, 1905.4647649404],
                        [7e-11, 5.68938243001, 158746.175953632],
                        [8e-11, 3.39884199213, 78153.5031035032],
                        [7e-11, 1.20867598891, 61560.6472912236],
                        [8e-11, 3.30580293572, 130419.845946971],
                        [7e-11, 0.39338960799, 2199.087343287],
                        [6e-11, 3.17982806365, 77947.317555066],
                        [8e-11, 0.8858517965, 220.4126424388],
                        [8e-11, 1.46508855917, 87367.6164188402],
                        [6e-11, 0.60809363482, 118828.963749497],
                        [8e-11, 5.53182088929, 53814.8758003364],
                        [7e-11, 1.65646088833, 196137.073432611],
                        [6e-11, 5.74552748087, 55503.9419394286],
                        [6e-11, 1.43996863707, 2333.196392872],
                        [6e-11, 1.91186990644, 130652.814803309],
                        [6e-11, 5.06448767269, 50444.6839302158],
                        [6e-11, 1.09838300878, 183674.703921209],
                        [7e-11, 0.35338852938, 103932.127922422],
                        [6e-11, 0.2892480859, 54374.8936264354],
                        [6e-11, 2.72829193454, 76255.1518855636],
                        [6e-11, 3.9229048448, 130289.952510736],
                        [7e-11, 1.2740249479, 46046.5092436418],
                        [7e-11, 2.96149281662, 52755.4938701472],
                        [8e-11, 2.23784693584, 25466.159340735],
                        [6e-11, 1.78075029765, 78786.2868428164],
                        [8e-11, 4.71972114899, 25014.2941173834],
                        [6e-11, 5.5279847086, 103498.416184545],
                        [8e-11, 5.43345902063, 949.1756089698],
                        [6e-11, 5.55571041746, 130446.629254872],
                        [7e-11, 5.36488899884, 77940.2040080652],
                        [6e-11, 0.5208093082, 25004.8229092806],
                        [6e-11, 3.48878406062, 123668.805106625],
                        [8e-11, 3.02023688443, 26076.8574413103],
                        [8e-11, 5.31586228888, 24388.623925071],
                        [6e-11, 5.06257578673, 78469.8949731598],
                        [6e-11, 4.7950404512, 52177.2907558567],
                        [6e-11, 4.57296057068, 35211.4798965916],
                        [6e-11, 5.37176342301, 53093.7365691302],
                        [6e-11, 4.26973755729, 130363.249636595],
                        [6e-11, 5.75364706874, 78580.1012943792],
                        [6e-11, 1.99314462977, 130435.634372513],
                        [6e-11, 1.55918658153, 39450.3528483734],
                        [8e-11, 4.77256284659, 142871.558358269],
                        [6e-11, 6.09530056324, 103395.323410326],
                        [6e-11, 1.29134609458, 102975.838766451],
                        [6e-11, 1.83917095242, 24402.8510190726],
                        [5e-11, 3.63216834248, 43981.5309499398],
                        [5e-11, 5.64850202903, 28774.6252361154],
                        [7e-11, 4.22124824964, 26098.9488418381],
                        [5e-11, 5.85936922514, 156314.119754007],
                        [5e-11, 4.97283396704, 102659.446896794],
                        [5e-11, 1.46473339833, 181659.722249411],
                        [6e-11, 0.71584342921, 104276.830967729],
                        [7e-11, 2.49362242764, 51439.9297696166],
                        [6e-11, 0.0294487624, 20043.6745601988],
                        [6e-11, 2.1948080146, 12412.372889498],
                        [7e-11, 3.28347851449, 183145.012956114],
                        [5e-11, 3.46807375357, 50536.7367659604],
                        [6e-11, 6.20804958899, 114.3991069134],
                        [6e-11, 2.26035174588, 103718.828826984],
                        [7e-11, 3.65318062648, 143005.667407854],
                        [5e-11, 0.12859263642, 51596.1186961496],
                        [7e-11, 0.75531928973, 77520.71936419],
                        [5e-11, 1.5297413665, 26724.8994135984],
                        [7e-11, 3.81960920375, 62197.6435632478],
                        [5e-11, 5.08212104486, 52609.5180210252],
                        [5e-11, 4.49337901115, 50007.0458008658],
                        [5e-11, 5.0321086104, 1045.1548361876],
                        [5e-11, 6.27674019656, 1272.6810256272],
                        [6e-11, 3.84313039676, 81604.3218514224],
                        [6e-11, 3.27974922227, 144916.866891071],
                        [5e-11, 0.50987626702, 299.1263942692],
                        [6e-11, 5.10596879808, 78313.7060466268],
                        [5e-11, 4.14575201906, 53867.9719526508],
                        [7e-11, 4.53402175332, 166740.704395656],
                        [5e-11, 5.57648480152, 106262.812049514],
                        [7e-11, 3.08562485832, 52027.7275587221],
                        [6e-11, 2.81224506925, 25450.90686955],
                        [5e-11, 1.51400872659, 28199.5534549518],
                        [6e-11, 1.58495517428, 47803.9299163742],
                        [6e-11, 2.79561551205, 52286.0126043678],
                        [7e-11, 1.80630878142, 23549.6546373206],
                        [7e-11, 3.72396318065, 198489.939586383],
                        [5e-11, 5.74129147264, 103189.137861889],
                        [6e-11, 2.94825789213, 56259.7947898528],
                        [5e-11, 4.96546514085, 78413.2726218572],
                        [5e-11, 1.7851884573, 129586.319326119],
                        [5e-11, 0.31701812829, 78800.513936818],
                        [5e-11, 0.55478931159, 52817.2198448874],
                        [6e-11, 1.18448496437, 25600.26839032],
                        [5e-11, 0.42862127579, 179172.747046054],
                        [6e-11, 3.74336258475, 26247.2048763664],
                        [5e-11, 2.46583763315, 123758.290854471],
                        [6e-11, 5.09461941443, 53124.9818921182],
                        [6e-11, 0.42320281908, 130443.397043229],
                        [6e-11, 2.57896380153, 26014.6060157152],
                        [5e-11, 2.23635663946, 24513.057340292],
                        [5e-11, 5.98752668018, 104344.984007397],
                        [6e-11, 0.32131472009, 102872.745992232],
                        [5e-11, 1.95885559875, 53771.992725433],
                        [7e-11, 2.16257501519, 52024.7586133055],
                        [6e-11, 1.37111815532, 51120.3565062223],
                        [5e-11, 0.15128494504, 78683.1940685978],
                        [5e-11, 4.00810087423, 48713.5615772832],
                        [6e-11, 1.4588311578, 76152.059111345],
                        [5e-11, 1.72421399237, 28309.7597761712],
                        [5e-11, 0.71424864998, 102755.426124012],
                        [6e-11, 0.0328360798, 78149.2701360374],
                        [6e-11, 2.69429372458, 78378.1487134078],
                        [6e-11, 1.12570261398, 25647.0778566966],
                        [5e-11, 3.60259399819, 11.0457002639],
                        [6e-11, 4.8317124728, 240452.46032332],
                        [5e-11, 3.71949948652, 26411.4085582316],
                        [5e-11, 4.55172986205, 79330.2049019126],
                        [5e-11, 0.84232799985, 24551.9263986048],
                        [5e-11, 3.74067330742, 52797.5500839876],
                        [5e-11, 2.92277012561, 54190.7879549462],
                        [5e-11, 3.96038779086, 25657.3727974351],
                        [5e-11, 4.54502031861, 102769.653218014],
                        [6e-11, 2.35342867622, 27665.246684022],
                        [5e-11, 3.72877345305, 78213.7128028184],
                        [5e-11, 6.19447408823, 26191.6853301548],
                        [4e-11, 0.53733592588, 77314.5338157528],
                        [4e-11, 1.3991722537, 26290.1565367483],
                        [5e-11, 4.85332036328, 54344.566765431],
                        [6e-11, 0.92030946706, 23336.3555418826],
                        [6e-11, 0.37487337241, 53265.515074342],
                        [4e-11, 2.01983013209, 156547.088610345],
                        [5e-11, 6.13113074115, 26026.177166834],
                        [4e-11, 4.94928690334, 52663.4410344026],
                        [5e-11, 0.40443457223, 28096.4606807332],
                        [4e-11, 4.40405080911, 130593.294518356],
                        [4e-11, 4.17440698686, 91919.569915899],
                        [5e-11, 3.7177743666, 70383.6202713836],
                        [5e-11, 1.52885825328, 51102.1972589576],
                        [4e-11, 1.71609047005, 23762.9537327586],
                        [4e-11, 0.55287089413, 26933.9859763254],
                        [5e-11, 6.02225706023, 128220.758603684],
                        [5e-11, 1.78226900229, 187167.275488078],
                        [5e-11, 3.32000517354, 45424.7654428026],
                        [5e-11, 4.64166221826, 24824.745778996],
                        [5e-11, 3.45997061965, 48847.6706268682],
                        [6e-11, 2.6227258092, 52171.8741298853],
                        [4e-11, 3.62789650971, 53029.0026649004],
                        [6e-11, 2.53652345505, 52190.03337715],
                        [4e-11, 0.08235213515, 58220.0348645238],
                        [6e-11, 2.56621666334, 51876.6798888792],
                        [5e-11, 5.04323059321, 41494.555746583],
                        [4e-11, 3.42433134364, 53311.4831550416],
                        [5e-11, 5.60899913389, 1911.1994832172],
                        [4e-11, 1.13990612191, 26183.882368792],
                        [4e-11, 4.24142693734, 189853.997582619],
                        [4e-11, 0.215216512, 19336.8623012284],
                        [5e-11, 0.3030674552, 103883.647575942],
                        [4e-11, 6.09719517639, 77417.6265899714],
                        [4e-11, 3.38148734662, 316.3918696566],
                        [4e-11, 1.40344660688, 25885.6497464001],
                        [6e-11, 2.54556610763, 54060.7074465658],
                        [5e-11, 4.62289027765, 78339.9754959982],
                        [4e-11, 6.06868163269, 84944.9342781222],
                        [5e-11, 0.6497001886, 3178.1457905676],
                        [4e-11, 5.4810925636, 78225.5763890848],
                        [4e-11, 3.76404568854, 153084.84390448],
                        [4e-11, 0.18748530762, 52489.992463018],
                        [5e-11, 1.7404411428, 79315.977807911],
                        [4e-11, 6.06406108213, 52161.5791891468],
                        [5e-11, 0.28595106407, 26161.2002674332],
                        [4e-11, 2.11074347112, 189386.032592265],
                        [4e-11, 0.5971553074, 16342.5825857176],
                        [4e-11, 3.91091220587, 101703.157740824],
                        [4e-11, 1.1613029014, 50264.6067999312],
                        [4e-11, 5.51188515445, 78043.2967822838],
                        [5e-11, 4.393503226, 53757.7656314314],
                        [4e-11, 5.15437140585, 24285.5311508524],
                        [5e-11, 2.15280343086, 48997.6604925808],
                        [4e-11, 5.35316514819, 104984.39630561],
                        [5e-11, 5.7539064007, 51841.950342379],
                        [4e-11, 1.52206374281, 26267.9802718588],
                        [4e-11, 4.66563868021, 104127.267770595],
                        [4e-11, 2.36671017385, 19.66976089979],
                        [4e-11, 5.1095428608, 31722.9368709266],
                        [4e-11, 1.54518951672, 52206.1331441528],
                        [4e-11, 4.16791904155, 130285.736897386],
                        [4e-11, 2.93299901703, 31775.5335105262],
                        [5e-11, 4.47247592301, 51112.4921996961],
                        [4e-11, 2.41568769208, 51534.3927214094],
                        [4e-11, 1.74441095464, 26248.310510959],
                        [4e-11, 5.23856038893, 52396.2189255872],
                        [4e-11, 4.12254586219, 27441.651886591],
                        [5e-11, 5.17529407091, 19367.1891622328],
                        [4e-11, 4.21064422396, 26279.3514076858],
                        [5e-11, 4.41570881449, 78057.5238762854],
                        [4e-11, 5.30327887066, 25672.3506509621],
                        [5e-11, 1.10382058499, 31903.0140012112],
                        [5e-11, 2.71619626622, 24952.226269681],
                        [4e-11, 2.28793023586, 235900.506826261],
                        [4e-11, 1.58884724433, 128747.350038369],
                        [4e-11, 5.78862899204, 22779.4372461938],
                        [4e-11, 4.22021430561, 1731.1223529326],
                        [4e-11, 4.68318371027, 103814.808054201],
                        [4e-11, 3.29575966354, 76137.8320173434],
                        [4e-11, 5.47487283809, 132350.715191088],
                        [4e-11, 2.99265295426, 77741.1320066288],
                        [4e-11, 3.4788961061, 53661.0969898516],
                        [4e-11, 4.76216346874, 156740.717944883],
                        [4e-11, 1.47799681769, 120417.678427772],
                        [4e-11, 2.78305398087, 133767.651364151],
                        [4e-11, 2.87953962922, 25862.073873164],
                        [4e-11, 1.9297299024, 15406.6526050088],
                        [5e-11, 1.8139493043, 130866.113898747],
                        [4e-11, 2.62752187758, 24602.612434871],
                        [4e-11, 3.12567603415, 20894.5360827764],
                        [4e-11, 1.00432915295, 149288.743257845],
                        [4e-11, 3.47489986602, 26114.201461374],
                        [4e-11, 4.27251739299, 104991.509852611],
                        [4e-11, 2.20022040184, 52073.8437648828],
                        [4e-11, 3.77568584773, 14.2270940016],
                        [4e-11, 1.65179392234, 51006.2180317398],
                        [4e-11, 0.72729563393, 25865.0428185806],
                        [4e-11, 5.61140287619, 53258.886515442],
                        [4e-11, 1.55115346866, 53438.9636457266],
                        [5e-11, 0.91157457367, 25665.2371039613],
                        [5e-11, 6.11073147567, 156507.749088545],
                        [3e-11, 3.12711312875, 80462.7967680096],
                        [4e-11, 2.2106835847, 76777.7293036574],
                        [4e-11, 0.82472101949, 30689.8532605372],
                        [4e-11, 3.85651603357, 26513.8119180882],
                        [3e-11, 3.76311835707, 77.7505439839],
                        [4e-11, 0.76897521016, 23384.2869868986],
                        [3e-11, 4.58555781046, 57503.2823915312],
                        [4e-11, 3.82967402925, 104454.705340515],
                        [3e-11, 2.4744892731, 77956.151803753],
                        [4e-11, 4.93160467297, 391318.547123613],
                        [4e-11, 1.56118199279, 1055.4497769261],
                        [4e-11, 0.77257538538, 79994.8317776552],
                        [5e-11, 3.1167545854, 26149.6291163144],
                        [3e-11, 4.05641745083, 104248.519792078],
                        [4e-11, 2.97133561512, 30110.1656735384],
                        [4e-11, 5.6042082933, 156520.305302444],
                        [4e-11, 5.59378669038, 51315.4963543956],
                        [3e-11, 5.33733887891, 52309.9153327334],
                        [3e-11, 5.47155908699, 149846.193996046],
                        [3e-11, 0.19039417498, 50290.905119731],
                        [3e-11, 0.55626990901, 130005.803969994],
                        [4e-11, 1.22491945176, 25927.4957721894],
                        [4e-11, 1.83119228357, 132028.588603155],
                        [4e-11, 3.7891019345, 25970.583273354],
                        [4e-11, 4.12310730501, 33856.2696982688],
                        [4e-11, 3.29497466474, 208276.626941718],
                        [3e-11, 1.23800163682, 193937.986089324],
                        [4e-11, 3.81093761011, 49424.2586834568],
                        [4e-11, 6.17742034131, 76991.0283990954],
                        [3e-11, 2.37855052298, 25459.0515555241],
                        [3e-11, 0.06662548789, 54824.2611086214],
                        [3e-11, 0.00882668027, 78571.2670456922],
                        [4e-11, 3.50355655289, 33480.357543659],
                        [4e-11, 1.42998120813, 23446.561863102],
                        [4e-11, 4.57967744099, 52213.9393187862],
                        [4e-11, 4.30793307856, 2538.2485042536],
                        [4e-11, 2.64175466237, 80596.9058175946],
                        [4e-11, 2.23067570586, 104819.577556651],
                        [4e-11, 2.1086768693, 27331.3907432526],
                        [3e-11, 3.74321552731, 28471.0961563504],
                        [3e-11, 5.35951703976, 233681.749722074],
                        [4e-11, 1.44726666359, 25907.8260112896],
                        [3e-11, 0.77055249403, 23389.451694197],
                        [4e-11, 5.53731910534, 52098.0557391645],
                        [4e-11, 2.7106584473, 107679.748222577],
                        [3e-11, 4.85884222947, 1063.3140834523],
                        [3e-11, 6.10322230645, 48091.817776444],
                        [3e-11, 0.57378510632, 154194.222456573],
                        [3e-11, 4.65504051632, 25896.4548754626],
                        [3e-11, 2.07685199898, 3.9321532631],
                        [4e-11, 4.67601599622, 18073.7049386502],
                        [3e-11, 4.62237776277, 21716.0267748],
                        [3e-11, 2.40811934972, 76998.1419460962],
                        [4e-11, 1.45941637429, 1073.6090241908],
                        [3e-11, 4.0696522735, 32808.6171209156],
                        [3e-11, 3.54974279869, 23401.181047033],
                        [3e-11, 5.94935193305, 6751.0408403458],
                        [3e-11, 4.32590129932, 52400.1510788503],
                        [3e-11, 1.93788940079, 45455.092303807],
                        [3e-11, 6.08303870194, 53399.624123927],
                        [3e-11, 4.45999574391, 127098.903281171],
                        [3e-11, 5.4517602882, 26061.6048217744],
                        [3e-11, 2.26429696537, 27047.0260015318],
                        [4e-11, 1.93735592711, 26603.3670126672],
                        [3e-11, 2.94612910423, 27039.9797648338],
                        [4e-11, 3.64314833794, 860.3099287528],
                        [4e-11, 2.04162116492, 27623.8798845436],
                        [4e-11, 1.02413610685, 25991.9239143564],
                        [4e-11, 3.72190941745, 51257.8759971666],
                        [3e-11, 0.83533616968, 78262.2249520143],
                        [4e-11, 5.84174581609, 25650.2592504343],
                        [3e-11, 3.8669808813, 56777.7564021114],
                        [4e-11, 0.94091162922, 23735.0369878024],
                        [3e-11, 2.87479269049, 159855.554505725],
                        [4e-11, 2.92372103776, 104358.241125197],
                        [3e-11, 5.50683793531, 25928.601406782],
                        [3e-11, 1.5028298198, 4371.8763667742],
                        [3e-11, 2.10941795435, 60170.3347251726],
                        [3e-11, 1.71064218785, 170068.840051936],
                        [3e-11, 1.97431548371, 104426.394164864],
                        [3e-11, 2.96711706073, 25984.1209529936],
                        [3e-11, 1.86795145608, 126067.639341097],
                        [3e-11, 4.74630310296, 54879.422437824],
                        [4e-11, 3.71365034796, 29580.4747084438],
                        [3e-11, 4.20767161544, 128843.329265586],
                        [3e-11, 0.91166163253, 76468.4509810016],
                        [3e-11, 6.20945940475, 50160.8246113506],
                        [3e-11, 6.10137777265, 52164.7605828845],
                        [3e-11, 0.31852065143, 28632.5757784666],
                        [3e-11, 2.88816579373, 27360.5841672014],
                        [3e-11, 5.29083364884, 2751.5475996916],
                        [3e-11, 0.87901414893, 1699.2792165032],
                        [3e-11, 0.1294237828, 203375.749024211],
                        [3e-11, 1.88640533644, 27353.4706202006],
                        [3e-11, 3.77660990144, 24787.0763233692],
                        [3e-11, 5.26339958526, 289185.691661503],
                        [3e-11, 1.34477523795, 1169.5882514086],
                        [3e-11, 0.07928565452, 104241.406245077],
                        [3e-11, 4.47916732925, 38634.3850806572],
                        [4e-11, 1.37420794262, 128857.556359588],
                        [3e-11, 2.08343776186, 50476.5270666452],
                        [3e-11, 4.23656246406, 76358.2446597822],
                        [3e-11, 5.54498269246, 61921.126839005],
                        [3e-11, 3.80268685478, 25384.2699569568],
                        [3e-11, 5.22182880098, 3462.2447058652],
                        [3e-11, 0.61479556097, 171292.657892715],
                        [3e-11, 3.12135348664, 162810.494699437],
                        [3e-11, 4.22351187737, 67608.757207957],
                        [3e-11, 5.30037747699, 51554.0624823092],
                        [3e-11, 4.58024970278, 34102.1013444982],
                        [3e-11, 2.07639441349, 24072.2320554144],
                        [3e-11, 4.65503825059, 104874.189984391],
                        [3e-11, 4.53866780815, 28908.7342857004],
                        [3e-11, 1.0019131214, 155460.923372255],
                        [3e-11, 2.05553254051, 176332.246141028],
                        [3e-11, 3.9487029151, 155475.150466257],
                        [3e-11, 1.43273740893, 24719.2428887292],
                        [3e-11, 0.23823986548, 24510.5595991264],
                        [3e-11, 5.21326346293, 1639.069517188],
                        [3e-11, 2.53461972944, 51861.6201032788],
                        [3e-11, 4.13978656372, 33917.995673009],
                        [3e-11, 4.34295741397, 16964.3263865568],
                        [3e-11, 0.28015371448, 169093.570549428],
                        [3e-11, 2.49492450438, 636.9962720242],
                        [3e-11, 4.20183911478, 149642.268959514],
                        [3e-11, 0.73100534966, 35679.444886946],
                        [3e-11, 1.1897797117, 143164.969142646],
                        [3e-11, 1.17691552034, 52145.479422144],
                        [3e-11, 4.94963823249, 49637.5577788948],
                        [3e-11, 3.00732745961, 24705.0157947276],
                        [3e-11, 5.76323456196, 49976.7189398614],
                        [3e-11, 4.83245208446, 156523.537514087],
                        [2e-11, 3.69719041336, 24616.1501145106],
                        [3e-11, 0.18439316147, 78597.565365492],
                        [3e-11, 4.98373933018, 102129.7559317],
                        [3e-11, 0.02228487734, 1.4844727083],
                        [3e-11, 4.06250318984, 97466.462676366],
                        [3e-11, 2.65726234287, 13705.8571130806],
                        [2e-11, 0.1288386868, 149756.7082482],
                        [3e-11, 2.82299563379, 53132.095439119],
                        [3e-11, 5.9906150951, 29864.334027309],
                        [3e-11, 3.9301871107, 17098.4354361418],
                        [2e-11, 4.22698039366, 10681.2505365654],
                        [2e-11, 1.31889013785, 25572.4392704812],
                        [2e-11, 3.49816744164, 51092.7260508548],
                        [3e-11, 1.5236169166, 78265.1938974309],
                        [3e-11, 0.52188463522, 52277.768801414],
                        [3e-11, 3.80600862869, 25124.5004386028],
                        [3e-11, 6.14366757538, 48153.5437511842],
                        [2e-11, 0.58190501461, 27573.8832626394],
                        [3e-11, 5.63901497713, 106470.376426675],
                        [2e-11, 3.36639066096, 42430.4857272918],
                        [3e-11, 3.08628517069, 4083.9885067044],
                        [2e-11, 6.13024035669, 104035.22069664],
                        [3e-11, 1.81280963372, 104401.609188201],
                        [3e-11, 3.34404708133, 130020.031063996],
                        [2e-11, 1.22333771717, 76094.94894244],
                        [2e-11, 0.6354233409, 1485.2907067032],
                        [3e-11, 5.24568241255, 6885.14988993081],
                        [3e-11, 2.46305012048, 133882.090652836],
                        [2e-11, 0.84094631125, 163766.094441045],
                        [3e-11, 2.12660879166, 42790.9652750732],
                        [2e-11, 2.98805690719, 26235.9818660005],
                        [3e-11, 3.26197855217, 156531.300184803],
                        [2e-11, 4.50734435605, 25248.9338538238],
                        [2e-11, 4.32859791317, 1685.0521225016],
                        [2e-11, 5.62335584014, 28213.7805489534],
                        [2e-11, 3.87492323552, 199599.318138476],
                        [2e-11, 2.60597304148, 26713.5733338866],
                        [3e-11, 4.15733644316, 51688.1715318942],
                        [3e-11, 4.33101389874, 220025.889230898],
                        [2e-11, 4.46567523081, 31127.4913898872],
                        [2e-11, 3.66265576771, 26397.18146423],
                        [2e-11, 4.68312774052, 49850.8568743328],
                        [2e-11, 4.51215350981, 52812.8025551726],
                        [3e-11, 3.56621882535, 154408.654989067],
                        [2e-11, 3.95708432187, 1574.8458012822],
                        [2e-11, 2.41940194318, 104668.004435953],
                        [3e-11, 0.24921211552, 25778.6248189184],
                        [2e-11, 3.18370791629, 207114.15223731],
                        [2e-11, 4.17768592199, 51734.9809982708],
                        [2e-11, 1.74283332135, 76532.58707179],
                        [2e-11, 1.36339547692, 6044.2285813754],
                        [2e-11, 2.82219230315, 63786.3582415226],
                        [2e-11, 5.27165023098, 75085.563634155],
                        [2e-11, 5.7673572032, 25661.9943650602],
                        [2e-11, 5.2466618317, 24734.1543965574],
                        [2e-11, 5.31625926462, 24998.1943503806],
                        [2e-11, 0.17868115875, 177287.845882637],
                        [3e-11, 5.47127542511, 27388.7299597792],
                        [2e-11, 2.48055036253, 25543.985082478],
                        [2e-11, 0.16253031708, 23113.2931869632],
                        [3e-11, 1.68453793975, 2703.6161546756],
                        [2e-11, 1.17069889009, 53551.5800829942],
                        [3e-11, 3.06893058902, 230239.174777109],
                        [3e-11, 5.00145362139, 180496.558130641],
                        [2e-11, 1.90098213386, 20272.7922819372],
                        [3e-11, 5.06877735444, 440.8252848776],
                        [2e-11, 1.33626564472, 196156.743193511],
                        [2e-11, 4.50940380454, 65538.2559899476],
                        [2e-11, 4.55891488212, 2324.9494088156],
                        [2e-11, 0.21025125051, 18227.483749135],
                        [2e-11, 0.58359043648, 156377.855652311],
                        [2e-11, 4.57189351312, 26926.8724293246],
                        [2e-11, 3.79747475767, 65851.3365352246],
                        [2e-11, 0.301390155, 50951.9884423698],
                        [2e-11, 3.94570007959, 225687.22128005],
                        [2e-11, 0.99415397716, 2064.978293702],
                        [2e-11, 3.49827019018, 78905.1229864616],
                        [2e-11, 4.16512398869, 24864.0853007956],
                        [2e-11, 0.47605198546, 107692.224992997],
                        [2e-11, 0.02213914405, 197092.673174219],
                        [2e-11, 0.35795159068, 104301.615944393],
                        [2e-11, 2.54426644231, 249268.479457368],
                        [2e-11, 0.35872697789, 25462.2329492618],
                        [2e-11, 0.03956368481, 24189.5519236346],
                        [2e-11, 2.0068296723, 28786.3545889514],
                        [2e-11, 1.64612572499, 40738.7028961588],
                        [2e-11, 1.77509184801, 22595.3315747046],
                        [2e-11, 1.93881159123, 78697.4211625994],
                        [2e-11, 1.06567957268, 21562.2479643152],
                        [3e-11, 4.58782698256, 156954.017040321],
                        [2e-11, 0.84740706727, 24494.8980930273],
                        [2e-11, 5.98697403459, 283524.359612351],
                        [2e-11, 4.02135788869, 26238.9508114171],
                        [2e-11, 3.98649649262, 24808.1085689462],
                        [2e-11, 3.06252327958, 57369.1733419462],
                        [2e-11, 6.10258403438, 78115.6307002963],
                        [2e-11, 0.19431714321, 55484.2721785288],
                        [2e-11, 4.26819419359, 90989.1628594976],
                        [2e-11, 2.9494161028, 22065.64060961],
                        [2e-11, 4.53722544295, 52355.883413433],
                        [2e-11, 1.97399498955, 430.5303441391],
                        [2e-11, 1.99872081555, 24932.5419841672],
                        [2e-11, 0.37032643194, 26500.2742384486],
                        [2e-11, 3.83480132336, 307.5576209696],
                        [2e-11, 5.81356382744, 51538.8100111242],
                        [2e-11, 6.20773606719, 49.9966219042],
                        [2e-11, 2.40589345998, 77929.8534839532],
                        [2e-11, 4.51719783127, 21067.984654161],
                        [2e-11, 2.06311358499, 23233.262767664],
                        [2e-11, 0.29430089395, 24765.2254940428],
                        [2e-11, 2.21513587213, 25675.5320446998],
                        [2e-11, 2.29291278322, 27410.5807891056],
                        [2e-11, 2.39356701559, 242985.403607376],
                        [2e-11, 4.28957020884, 71378.5595347918],
                        [2e-11, 5.41199778568, 23704.710126798],
                        [2e-11, 0.54252133289, 3.881335358],
                        [2e-11, 5.88236623932, 52072.0240945678],
                        [2e-11, 5.78749542412, 78373.915745942],
                        [2e-11, 5.69226787602, 51040.1294112552],
                        [2e-11, 4.42185841709, 93696.6603495312],
                        [2e-11, 5.15491529148, 78112.6617548797],
                        [2e-11, 2.30493903824, 27883.1615852952],
                        [2e-11, 5.53948896377, 87253.177130155],
                        [2e-11, 4.75957265478, 52336.2136525332],
                        [2e-11, 6.08199781417, 18043.3780776458],
                        [2e-11, 0.73324052336, 25757.284177916],
                        [2e-11, 0.91928644358, 52186.8519834123],
                        [2e-11, 3.22142261212, 104771.097210172],
                        [2e-11, 2.016713014, 46564.4708559004],
                        [2e-11, 4.39545799671, 41520.8540663828],
                        [2e-11, 2.52858429504, 26140.9992938886],
                        [2e-11, 2.07561943546, 53654.6728572128],
                        [2e-11, 0.08977124652, 25135.8265183146],
                        [2e-11, 1.67350036401, 66826.606037733],
                        [2e-11, 4.57268426145, 158116.491744729],
                        [2e-11, 2.84194927894, 78249.482330721],
                        [2e-11, 3.07002924674, 23432.3347691004],
                        [2e-11, 4.11559657607, 123554.36581794],
                        [2e-11, 0.05687800902, 26034.8069892598],
                        [2e-11, 4.28354458896, 24484.6031522888],
                        [2e-11, 3.24222429199, 21509.6513247156],
                        [2e-11, 2.52315832958, 210614.424615811],
                        [2e-11, 4.44247371827, 148532.890407421],
                        [2e-11, 0.11737800376, 146505.581569346],
                        [2e-11, 2.4137136239, 54862.5283776896],
                        [2e-11, 4.66022680664, 247223.170924566],
                        [2e-11, 3.79260774499, 3308.4658953804],
                        [2e-11, 5.83454304626, 2974.609954611],
                        [2e-11, 5.3787850016, 77622.2958629836],
                        [2e-11, 1.63153524958, 99979.7361995226],
                        [2e-11, 5.18613735503, 50600.9604818662],
                        [2e-11, 2.55420547959, 76064.6220814356],
                        [2e-11, 4.05996888958, 24502.7623995535],
                        [2e-11, 2.47809526116, 179966.867165546],
                        [2e-11, 1.25528265056, 50912.6489205702],
                        [2e-11, 0.75306774592, 235746.728015776],
                        [2e-11, 2.97464643769, 31219.5442256318],
                        [1e-11, 0.17722772219, 158438.618332662],
                        [2e-11, 4.94589808424, 168959.461499843],
                        [2e-11, 0.63110575282, 415.5524906121],
                        [1e-11, 0.77799418557, 299398.977207714],
                        [2e-11, 5.97867896248, 164721.694182654],
                        [2e-11, 5.62955025847, 21819.8089633806],
                        [1e-11, 4.93638931294, 27993.3679065146],
                        [2e-11, 6.22578827437, 74935.5737684424],
                        [2e-11, 1.03965665113, 1802.3719907218],
                        [1e-11, 5.61994219678, 50690.5155764452],
                        [2e-11, 5.02281046549, 422.6660376129],
                        [1e-11, 3.57619837497, 209658.824874202],
                        [2e-11, 0.1124953909, 38469.9491700678],
                        [2e-11, 0.62470424533, 51745.2759390093],
                        [1e-11, 0.71806518278, 28928.4040466002],
                        [2e-11, 3.91669753023, 76352.5099415054],
                        [2e-11, 3.05277164813, 225.8292684102],
                        [1e-11, 4.33602746737, 4601.950118963],
                      ],
          },
          {
            series => "R1",
            terms  => [
                        [0.00217347739, 4.65617158663, 26087.9031415742],
                        [0.00044141826, 1.42385543975, 52175.8062831484],
                        [0.00010094479, 4.47466326316, 78263.7094247226],
                        [2.432804e-05, 1.24226083435, 104351.612566297],
                        [1.624367e-05, 0, 0],
                        [6.03996e-06, 4.29303116561, 130439.515707871],
                        [1.52851e-06, 1.0606077981, 156527.418849445],
                        [3.9202e-07, 4.11136751416, 182615.321991019],
                        [1.776e-07, 4.54424653085, 27197.2816936676],
                        [1.7999e-07, 4.7119372581, 24978.5245894808],
                        [1.0154e-07, 0.87893548494, 208703.225132594],
                        [8.086e-08, 3.0054085489, 25028.521211385],
                        [4.444e-08, 2.13639058123, 20426.571092422],
                        [4.393e-08, 1.48074475165, 51066.427731055],
                        [3.51e-08, 3.21171223697, 1059.3819301892],
                        [3.133e-08, 5.23846336855, 21535.9496445154],
                        [2.65e-08, 3.92968881423, 234791.128274168],
                        [2.498e-08, 2.02623950395, 24498.8302462904],
                        [2.011e-08, 1.23911360588, 53285.1848352418],
                        [1.963e-08, 4.04524902962, 5661.3320491522],
                        [1.546e-08, 2.61849590442, 26617.5941066688],
                        [1.542e-08, 2.35659537465, 27043.5028831828],
                        [1.417e-08, 1.37876323533, 1109.3785520934],
                        [1.295e-08, 5.19094850935, 46514.4742339962],
                        [1.241e-08, 0.21246226135, 11322.6640983044],
                        [1.09e-08, 6.23733263925, 27147.2850717634],
                        [1.271e-08, 0.56437938715, 25132.3033999656],
                        [1.12e-08, 0.86374628388, 57837.1383323006],
                        [1.005e-08, 3.28272284427, 37410.5672398786],
                        [1.177e-08, 4.53194022227, 77154.3308726292],
                        [8.41e-09, 5.96261035419, 14765.2390432698],
                        [9.35e-09, 2.37277497611, 25661.3049506982],
                        [7.42e-09, 0.77751594919, 32858.6137428198],
                        [7.36e-09, 4.0688529657, 1589.0728952838],
                        [7.12e-09, 2.70884051645, 16983.9961474566],
                        [8.63e-09, 5.55308682281, 25558.2121764796],
                        [7.07e-09, 0.92992556568, 30639.856638633],
                        [6.96e-09, 0.69734796212, 260879.031415742],
                        [6.78e-09, 2.0219388593, 26068.2333806744],
                        [6.08e-09, 0.85708468483, 4551.9534970588],
                        [5.46e-09, 5.38138962861, 26091.7844769322],
                        [6.08e-09, 3.65993973133, 25448.0058552602],
                        [5.97e-09, 4.64867954048, 26080.7895945734],
                        [5.72e-09, 3.50125649521, 10213.285546211],
                        [5.15e-09, 4.83662922562, 50586.7333878646],
                        [5.32e-09, 5.21855381213, 22645.3281966088],
                        [5.72e-09, 0.62751016416, 13521.7514415914],
                        [5.16e-09, 3.89421000089, 83925.0414738748],
                        [5.07e-09, 5.55466020276, 12566.1516999828],
                        [6.06e-09, 4.50215566301, 28306.660245761],
                        [5.33e-09, 0.93587795381, 26107.572902474],
                        [4.35e-09, 5.79043985706, 43071.8992890308],
                        [4.36e-09, 5.86659160961, 25035.6347583858],
                        [4.29e-09, 0.26260280461, 36301.1886877852],
                        [4.72e-09, 6.00507778421, 77204.3274945334],
                        [4.43e-09, 3.86758570847, 26084.0218062162],
                        [4.87e-09, 4.23950195756, 26095.016688575],
                        [4.06e-09, 5.60324652352, 52705.497248243],
                        [5.23e-09, 0.06439941262, 25021.4076643842],
                        [3.79e-09, 1.95647626585, 72602.3773755704],
                        [3.9e-09, 3.81996185881, 426.598190876],
                        [4.18e-09, 2.7752141866, 41962.5207369374],
                        [4.53e-09, 0.7280313725, 529.6909650946],
                        [3.58e-09, 6.00165335616, 33326.5787331742],
                        [3.47e-09, 1.39524259509, 23969.1392811958],
                        [3.4e-09, 0.24111380317, 26301.2022370122],
                        [3.25e-09, 4.78747749132, 23869.1460373874],
                        [2.9e-09, 3.04044859601, 53235.1882133376],
                        [3.26e-09, 1.30033833957, 103242.234014203],
                        [3.16e-09, 2.22791434675, 19317.1925403286],
                        [2.64e-09, 3.93160763696, 6770.7106012456],
                        [3.32e-09, 3.59235758173, 51220.2065415398],
                        [2.23e-09, 2.76528831516, 103292.230636108],
                        [2.15e-09, 3.97996009773, 56727.7597802072],
                        [2.35e-09, 2.2405050326, 25874.6040461362],
                        [2.15e-09, 6.16660008496, 51646.1153180538],
                        [2.08e-09, 2.74551899929, 40853.142184844],
                        [2.04e-09, 3.44654782597, 9103.9069941176],
                        [1.97e-09, 0.80026289238, 27676.976036858],
                        [2.05e-09, 3.20844012088, 18849.2275499742],
                        [1.96e-09, 1.99924288764, 48733.231338183],
                        [2.18e-09, 2.11865566044, 73711.7559276638],
                        [1.89e-09, 0.65681038131, 110012.944615449],
                        [2.07e-09, 5.89082708705, 31749.2351907264],
                        [1.84e-09, 3.74837387583, 286966.934557316],
                        [1.74e-09, 5.81264188702, 68050.4238785116],
                        [1.63e-09, 4.00380715262, 79373.087976816],
                        [1.52e-09, 5.07389967152, 52156.1365222486],
                        [1.51e-09, 2.83369443311, 955.5997416086],
                        [1.51e-09, 0.4095365021, 26514.5013324502],
                        [1.47e-09, 2.32191248197, 38654.054841557],
                        [1.54e-09, 3.26437373895, 38519.945791972],
                        [1.85e-09, 0.98966099528, 29530.4780865396],
                        [1.5e-09, 3.69230644689, 65697.5577247398],
                        [1.32e-09, 2.71837382155, 77734.018459628],
                        [1.4e-09, 2.05736044462, 6283.0758499914],
                        [1.22e-09, 3.31361750281, 62389.0918293594],
                        [1.23e-09, 2.07840148125, 25668.418497699],
                        [1.18e-09, 0.51913709271, 51535.9089968344],
                        [1.21e-09, 2.15433834534, 52179.6876185064],
                        [1.51e-09, 2.66028539824, 25654.1914036974],
                        [1.13e-09, 2.33243126122, 78793.4003898172],
                        [1.24e-09, 3.13058661995, 51109.3108059584],
                        [1.5e-09, 2.60376479044, 639.897286314],
                        [1.23e-09, 2.65137961558, 51123.53789996],
                        [1.06e-09, 1.31393069594, 47623.8527860896],
                        [1.12e-09, 5.00798069297, 98690.2805171446],
                        [1.07e-09, 5.12738291017, 99799.659069238],
                        [1.23e-09, 6.13795219131, 1066.49547719],
                        [1.06e-09, 1.42997322881, 52168.6927361476],
                        [1.04e-09, 4.51477063494, 25234.7067598222],
                        [1.2e-09, 4.0656730086, 45892.730433157],
                        [9.2e-10, 4.72811907093, 2118.7638603784],
                        [1.12e-09, 4.78983902693, 53131.406024757],
                        [9.6e-10, 5.03438502363, 32370.9789915656],
                        [9.1e-10, 4.22099920434, 50057.04242277],
                        [9.1e-10, 4.35481864546, 129330.137155778],
                        [1.06e-09, 0.14583281261, 12432.0426503978],
                        [8.4e-10, 0.32848825294, 1052.2683831884],
                        [8.4e-10, 5.81442139422, 129380.133777682],
                        [9.3e-10, 0.34539006564, 77308.109683114],
                        [7.8e-10, 1.17633266287, 76674.6365294388],
                        [1.07e-09, 1.01316358023, 52182.9198301492],
                        [8.2e-10, 6.11445014523, 79323.0913549118],
                        [8.5e-10, 2.50332044483, 7238.6755916],
                        [7.2e-10, 1.561708325, 49957.0491789616],
                        [7.6e-10, 1.62577226881, 15874.6175953632],
                        [9.1e-10, 5.75408440781, 24491.7166992896],
                        [9.2e-10, 3.97747935513, 52195.4760440482],
                        [6.8e-10, 0.44378826429, 91785.460866314],
                        [7.8e-10, 0.63585741399, 52171.9249477904],
                        [6.4e-10, 2.57311321703, 94138.3270200858],
                        [6.5e-10, 2.12942233842, 7.1135470008],
                        [6.2e-10, 3.70751240431, 136100.847757023],
                        [6.8e-10, 1.18946361248, 54394.5633873352],
                        [7.9e-10, 3.35596277474, 52389.1053785864],
                        [6.4e-10, 5.09677055426, 51962.5071877104],
                        [6e-10, 6.25938912295, 24505.9437932912],
                        [6.1e-10, 0.73867692725, 82815.6629217814],
                        [6.3e-10, 1.29883580487, 2218.7571041868],
                        [7e-10, 5.28692696943, 45405.0956819028],
                        [5.7e-10, 1.92365363632, 20760.4270331914],
                        [5.4e-10, 0.89448628916, 71980.6335747312],
                        [5.1e-10, 4.71710385051, 105460.99111839],
                        [5.4e-10, 6.22009952451, 44937.1306915484],
                        [5.2e-10, 3.43365769233, 25551.0986294788],
                        [5.2e-10, 5.77930503293, 66941.0453264182],
                        [4.8e-10, 0.51937745535, 313054.83769889],
                        [5.2e-10, 5.71476972233, 103821.921601202],
                        [4.7e-10, 3.82203240163, 53764.8791784322],
                        [5e-10, 5.76150579489, 25938.3399444396],
                        [4.7e-10, 5.52705163618, 77837.1112338466],
                        [4.3e-10, 5.84994474092, 63498.4703814528],
                        [5.2e-10, 2.63638299982, 18093.37469955],
                        [4.2e-10, 5.39178421925, 64741.9579831312],
                        [4.1e-10, 1.87113963554, 125887.562210812],
                        [4.5e-10, 4.04603530632, 55618.3812281138],
                        [3.9e-10, 3.50934954924, 52602.4044740244],
                        [4.8e-10, 0.72400634326, 33967.9922949132],
                        [5.1e-10, 6.02427997984, 13655.8604911764],
                        [3.8e-10, 0.09359107033, 88476.9949709336],
                        [3.8e-10, 1.84297739511, 78244.0396638228],
                        [4.1e-10, 5.74927951755, 26727.8004278882],
                        [4.5e-10, 5.73633413733, 44181.2778411242],
                        [3.5e-10, 0.81793649503, 23439.4483161012],
                        [3.8e-10, 5.17914668407, 23754.7067487022],
                        [3.6e-10, 4.81782090538, 51116.4243529592],
                        [4.1e-10, 2.91943000674, 26241.681952059],
                        [3.2e-10, 1.91760062435, 58458.8821331398],
                        [3.3e-10, 1.27507180487, 131548.894259964],
                        [3.2e-10, 5.01820692941, 46848.3301747656],
                        [3e-10, 3.95444605179, 26555.8681319286],
                        [3.1e-10, 1.17911028239, 59414.4818747484],
                        [3e-10, 0.55604674983, 3442.5749449654],
                        [3.4e-10, 3.55745328485, 433.7117378768],
                        [3.3e-10, 5.36229697065, 104881.303531391],
                        [3e-10, 1.24209931344, 26202.3424302594],
                        [3.3e-10, 3.55673853222, 25440.8923082594],
                        [2.9e-10, 2.9884790115, 27154.3986187642],
                        [3.5e-10, 3.23888704617, 25455.119402261],
                        [3.3e-10, 1.77322555881, 124778.183658719],
                        [2.8e-10, 4.35951220773, 80482.4665289094],
                        [3e-10, 5.14555074991, 51756.3216392732],
                        [2.9e-10, 0.03524298861, 79219.3091663312],
                        [2.7e-10, 2.59555966553, 155468.036919256],
                        [2.7e-10, 1.05480537311, 28421.0995344462],
                        [3e-10, 5.7208773684, 51742.0945452716],
                        [2.9e-10, 5.20529460359, 78267.5907600806],
                        [2.6e-10, 1.11551342052, 155418.040297352],
                        [3e-10, 6.10884155937, 26011.6370702986],
                        [2.7e-10, 3.38666053174, 103396.012824688],
                        [2.5e-10, 3.48592449926, 117873.364007888],
                        [2.5e-10, 1.69043243445, 25973.463852889],
                        [2.6e-10, 6.195779404, 77197.2139475326],
                        [2.4e-10, 1.47972864008, 28206.6670019526],
                        [2.3e-10, 3.86767325148, 16066.0658614748],
                        [2.7e-10, 4.06858086478, 78270.8229717234],
                        [2.2e-10, 4.03528313026, 419.4846438752],
                        [2.3e-10, 3.3842610754, 58946.516884394],
                        [2.2e-10, 1.33669336918, 51322.6099013964],
                        [2.3e-10, 2.23954141042, 103925.014375421],
                        [2.4e-10, 3.65673385174, 26610.480559668],
                        [2.1e-10, 4.49565014938, 78256.5958777218],
                        [2.1e-10, 3.69266624882, 77623.8121384086],
                        [2.8e-10, 5.71652736884, 77211.4410415342],
                        [2.1e-10, 3.97119771059, 98068.5367163054],
                        [2.1e-10, 5.61140929496, 120226.23016166],
                        [2.5e-10, 1.73460075205, 853.196381752],
                        [2.4e-10, 2.89897553229, 105410.994496486],
                        [2e-10, 6.15988447425, 213.299095438],
                        [2.1e-10, 0.4212676491, 149.5631971346],
                        [2e-10, 4.41588880947, 29416.0387978544],
                        [2.4e-10, 2.43220296378, 50579.6198408638],
                        [2e-10, 0.47739908961, 162188.750898597],
                        [2.1e-10, 0.18110422167, 35191.8101356918],
                        [1.9e-10, 2.3875625116, 26037.90651967],
                        [2e-10, 0.61997291259, 85034.4200259682],
                        [1.8e-10, 4.60331561584, 76044.9523205358],
                        [1.8e-10, 3.06180224259, 50593.8469348654],
                        [2.2e-10, 0.45787269756, 1596.1864422846],
                        [1.9e-10, 1.76795970776, 78050.4103292846],
                        [1.9e-10, 3.58333941723, 27140.1715247626],
                        [2.1e-10, 0.15585183693, 78477.0085201606],
                        [1.8e-10, 1.81330190957, 25565.3257234804],
                        [2.1e-10, 3.45385724015, 102762.539671013],
                        [2.2e-10, 4.62891777236, 19406.6782881746],
                        [1.9e-10, 5.28998871939, 26624.7076536696],
                        [1.6e-10, 4.3790892436, 25131.6139856036],
                        [1.9e-10, 2.69598918032, 105307.212307905],
                        [1.8e-10, 4.13274028026, 5327.4761083828],
                        [1.8e-10, 1.10819559505, 76144.9455643442],
                        [1.8e-10, 2.04678515653, 71492.998823477],
                        [1.5e-10, 0.52406345582, 42153.969003049],
                        [1.8e-10, 0.71897799959, 78283.3791856224],
                        [2e-10, 3.8710563228, 51749.2080922724],
                        [1.4e-10, 0.06732488, 25984.8103673556],
                        [1.9e-10, 2.51337817026, 129909.824742776],
                        [1.8e-10, 3.79705759661, 108903.566063356],
                        [1.4e-10, 2.30467577173, 18207.8139882352],
                        [1.4e-10, 4.91192145857, 151975.465352386],
                        [1.4e-10, 4.25365079026, 157636.797401539],
                        [1.4e-10, 3.82494343251, 7880.08915333899],
                        [1.4e-10, 0.47442483304, 26137.8997634784],
                        [1.5e-10, 1.41820144369, 40565.2543247742],
                        [1.6e-10, 1.92985195149, 49842.6098902764],
                        [1.6e-10, 2.97241905198, 71025.0338331226],
                        [1.3e-10, 0.07086712207, 76.2660712756],
                        [1.3e-10, 2.19019855275, 90829.8611247054],
                        [1.4e-10, 1.68395491426, 6681.2248533996],
                        [1.2e-10, 2.16242752229, 29428.515568274],
                        [1.3e-10, 0.55373605944, 79852.7823200064],
                        [1.2e-10, 2.10236188465, 24609.0365675098],
                        [1.2e-10, 3.4937235482, 64607.8489335462],
                        [1.3e-10, 3.16312334997, 25881.717593137],
                        [1.2e-10, 0.32301447482, 78690.3076155986],
                        [1.6e-10, 3.67591976897, 78259.8280893646],
                        [1.2e-10, 0.81060544329, 81706.284369688],
                        [1.5e-10, 2.57802360273, 93028.9484679924],
                        [1.3e-10, 3.55704873434, 339142.740840465],
                        [1.2e-10, 3.14169564714, 114564.898112508],
                        [1.1e-10, 4.96251639039, 84546.785274714],
                        [1.1e-10, 2.93160493628, 536.8045120954],
                        [1.1e-10, 0.04474275203, 19804.8272915828],
                        [1.1e-10, 2.39391294657, 10021.8372800994],
                        [1.1e-10, 3.22530161123, 90695.7520751204],
                        [1.2e-10, 0.71785378975, 26294.0886900114],
                        [1.1e-10, 3.51130712506, 7994.5284420242],
                        [1.1e-10, 1.78813511249, 69159.802430605],
                        [1e-10, 1.89377082198, 24925.4284371664],
                        [1.2e-10, 6.06775243662, 52329.5850936332],
                        [1.2e-10, 0.11656433296, 51543.0225438352],
                        [1.2e-10, 0.01462307671, 1581.959348283],
                        [1e-10, 3.60476399042, 49527.3514576754],
                        [9e-11, 5.35498571113, 2648.454825473],
                        [1e-10, 2.54352513591, 52815.7035694624],
                        [9e-11, 5.25498849885, 130012.917516995],
                        [1e-10, 5.63770719377, 181555.94006083],
                        [1.1e-10, 1.65385601347, 26507.3877854494],
                        [1.1e-10, 4.93008131424, 104331.942805397],
                        [1e-10, 0.35445064092, 26521.614879451],
                        [1e-10, 2.79303258728, 39743.7636327506],
                        [9e-11, 0.71144667758, 25764.3977249168],
                        [8e-11, 4.22951187793, 181505.943438926],
                        [8e-11, 0.1751430319, 129483.915966262],
                        [1e-10, 1.16786157884, 25934.1243310894],
                        [1e-10, 2.50335300453, 103299.344183108],
                        [9e-11, 3.18692590406, 39629.3243440654],
                        [1e-10, 3.98242351264, 522.5774180938],
                        [1.1e-10, 0.23158217376, 51639.001771053],
                        [9e-11, 0.30008658313, 27999.1026247914],
                        [1.1e-10, 4.84801040284, 150866.086800293],
                        [1.1e-10, 5.94731028211, 38813.3565763492],
                        [8e-11, 4.66199260294, 26094.5317004742],
                        [8e-11, 0.71995165086, 52643.7712735028],
                        [8e-11, 3.3182527779, 24395.7374720718],
                        [8e-11, 2.52932369592, 26190.9959157928],
                        [8e-11, 5.11541081184, 25619.9381512198],
                        [8e-11, 1.18625312267, 25867.4904991354],
                        [8e-11, 0.31593558687, 51528.7954498336],
                        [1e-10, 2.12019897039, 130969.206672966],
                        [8e-11, 0.24131547257, 143961.267149462],
                        [7e-11, 5.90865595918, 23976.2528281966],
                        [8e-11, 4.88221803127, 22759.767485294],
                        [7e-11, 3.17202081415, 632.7837393132],
                        [8e-11, 2.40875907837, 146314.133303234],
                        [7e-11, 6.03640433343, 53242.3017603384],
                        [7e-11, 0.86406939215, 104358.726113298],
                        [7e-11, 3.45761762182, 26237.4663387088],
                        [9e-11, 3.3062859753, 12725.453434775],
                        [7e-11, 0.74174993099, 124156.43985788],
                        [8e-11, 5.6260015428, 131395.11544948],
                        [7e-11, 2.52679818243, 77829.9976868458],
                        [8e-11, 1.93255904016, 77844.2247808474],
                        [7e-11, 3.6943967793, 85502.3850163226],
                        [7e-11, 5.14299105203, 35472.7441496494],
                        [8e-11, 1.52116219771, 26081.2745826742],
                        [8e-11, 3.50246944455, 25863.5583458723],
                        [8e-11, 5.17598738878, 23962.025734195],
                        [9e-11, 2.01720755803, 104355.493901655],
                        [7e-11, 0.57777174711, 86143.7985780616],
                        [7e-11, 2.0353430072, 100909.037621331],
                        [6e-11, 3.30402834266, 104564.911661735],
                        [6e-11, 5.26635186541, 50696.939709084],
                        [6e-11, 3.60993601694, 27684.0895838588],
                        [8e-11, 5.97157930225, 131498.89763806],
                        [6e-11, 4.4320413642, 54294.5701435268],
                        [6e-11, 4.1618373488, 54509.0026760204],
                        [7e-11, 4.35729742194, 52290.2455718336],
                        [7e-11, 4.88364528875, 26941.0995233262],
                        [7e-11, 3.84735933689, 34282.1784747828],
                        [6e-11, 0.71889591582, 89586.373523027],
                        [6e-11, 4.7741020149, 104138.313470859],
                        [6e-11, 5.81016662275, 70269.1809826984],
                        [7e-11, 3.59164938122, 188276.654040172],
                        [6e-11, 1.42397911026, 102132.85546211],
                        [6e-11, 5.15043168056, 97580.9019650512],
                        [8e-11, 2.67404385604, 647.0108333148],
                        [5e-11, 4.58227258685, 25977.6968203548],
                        [7e-11, 6.18437842544, 128850.442812587],
                        [5e-11, 0.05338946228, 13541.4212024912],
                        [6e-11, 5.55589010148, 155997.727884351],
                        [5e-11, 5.54731935938, 96357.0841242726],
                        [6e-11, 0.36201698821, 26308.315784013],
                        [5e-11, 3.05584811656, 103285.117089107],
                        [5e-11, 4.80319811501, 51013.3315787406],
                        [6e-11, 3.04691542636, 13362.4497067992],
                        [5e-11, 5.59905054438, 76667.522982438],
                        [5e-11, 3.15313951574, 26164.1692128498],
                        [6e-11, 1.15194666645, 27311.7209823528],
                        [5e-11, 6.16463589751, 76681.7500764396],
                        [5e-11, 2.77667883666, 224.3447957019],
                        [5e-11, 4.27775147717, 14477.3511832],
                        [5e-11, 5.50743820134, 52125.8096612442],
                        [6e-11, 0.68838699976, 26720.6868808874],
                        [5e-11, 4.44878671847, 25227.5932128214],
                        [5e-11, 4.88707969684, 52061.3669944632],
                        [5e-11, 3.66186576821, 25241.820306823],
                        [5e-11, 1.76383923429, 178063.368493961],
                        [5e-11, 3.09083817171, 115674.276664601],
                        [5e-11, 1.73277038612, 956.2891559706],
                        [6e-11, 0.59128664983, 134991.46920493],
                        [5e-11, 1.3943570322, 104344.499019296],
                        [5e-11, 5.66016557162, 45290.6563932176],
                        [5e-11, 2.69362119172, 50064.1559697708],
                        [5e-11, 4.11526724305, 209812.603684687],
                        [6e-11, 3.7263359886, 26162.6847401415],
                        [4e-11, 1.01205356829, 183724.700543113],
                        [5e-11, 2.02484630372, 52712.6107952438],
                        [5e-11, 4.47460304849, 77410.5130429706],
                        [5e-11, 0.42971081835, 52698.3837012422],
                        [5e-11, 1.56442459236, 11610.5519583742],
                        [4e-11, 0.62582613574, 22747.2907148744],
                        [4e-11, 1.51592730997, 66653.1574663484],
                        [5e-11, 6.10277243405, 97112.9369746968],
                        [4e-11, 1.00562353481, 51219.5171271778],
                        [4e-11, 0.31906550066, 48835.1938564486],
                        [5e-11, 4.98644771495, 51653.2288650546],
                        [5e-11, 4.3442901056, 32132.1317229496],
                        [4e-11, 2.9212557902, 78417.4882352074],
                        [4e-11, 5.99601868842, 121335.608713753],
                        [5e-11, 3.13172791066, 61279.713277266],
                        [5e-11, 2.13824746365, 39609.6545831656],
                        [5e-11, 5.68604378667, 119116.851609567],
                        [4e-11, 2.73202591375, 1692.1656695024],
                        [4e-11, 5.78251523942, 26734.913974889],
                        [5e-11, 0.77777359038, 103711.715279983],
                        [5e-11, 0.91021434517, 71582.484571323],
                        [4e-11, 3.03035393128, 52072.7135089298],
                        [4e-11, 0.45156085724, 31415.379249957],
                        [4e-11, 3.93028686443, 104371.282327197],
                        [4e-11, 4.54919541216, 26198.1094627936],
                        [4e-11, 2.66986199617, 24176.703658357],
                        [4e-11, 3.50110688244, 74821.1344797572],
                        [4e-11, 5.75284691398, 25138.7275326044],
                        [4e-11, 5.44367911308, 72936.2333163398],
                        [4e-11, 1.60493978664, 176953.989941867],
                        [4e-11, 1.93554854399, 50049.9288757692],
                        [3e-11, 3.90053130991, 107794.187511262],
                        [3e-11, 5.45429683058, 44295.7171298094],
                        [4e-11, 0.60054840458, 104347.731230939],
                        [4e-11, 0.88305624488, 60055.8954364874],
                        [4e-11, 6.20681068925, 140652.801254082],
                        [3e-11, 1.44572212087, 130226.216612433],
                        [4e-11, 4.3775024277, 32769.1279949738],
                        [4e-11, 1.75525459469, 110634.688416288],
                        [3e-11, 0.6698019741, 26222.0121911592],
                        [4e-11, 2.20364417845, 182085.631025925],
                        [3e-11, 5.6061526381, 129387.247324683],
                        [3e-11, 0.96551693568, 207593.8465805],
                        [4e-11, 4.51472339809, 52169.1777242484],
                        [4e-11, 0.86790293541, 24822.3356629478],
                        [3e-11, 2.05745330337, 156100.820658569],
                        [4e-11, 0.27139822027, 214364.557181746],
                        [3e-11, 3.63958954831, 102232.848705918],
                        [3e-11, 3.33824382272, 170049.170291037],
                        [3e-11, 6.15959485239, 12546.481939083],
                        [3e-11, 0.54712514364, 1911.1994832172],
                        [3e-11, 5.53215106225, 323.5054166574],
                        [3e-11, 5.78740917576, 27780.0688110766],
                        [4e-11, 3.60062257669, 105940.685461581],
                        [3e-11, 5.23668974633, 17893.6278083656],
                        [3e-11, 3.21536557308, 155571.819107837],
                        [4e-11, 3.78439308193, 68241.8721446232],
                        [4e-11, 0.35026324282, 53228.0746663368],
                        [3e-11, 1.39462627029, 110.2063212194],
                        [3e-11, 2.9858544254, 102769.653218014],
                        [3e-11, 5.54914760118, 52101.0246845811],
                        [4e-11, 5.31358771393, 116917.76426628],
                        [4e-11, 5.02170245911, 130443.397043229],
                        [3e-11, 3.39708771017, 104778.210757173],
                        [3e-11, 1.35333080979, 52182.4348420484],
                        [3e-11, 3.53872943291, 28791.5192962498],
                        [3e-11, 0.32151031474, 75615.2545992496],
                        [3e-11, 2.81736551277, 78187.443353447],
                        [3e-11, 3.41370464721, 77616.6985914078],
                        [3e-11, 2.72102083462, 157586.800779634],
                        [4e-11, 0.3799045894, 365230.643982039],
                        [3e-11, 5.29398694468, 183570.921732628],
                        [3e-11, 0.53039476474, 35077.3708470066],
                        [3e-11, 0.96990585284, 25780.3455206046],
                        [4e-11, 5.03799187214, 103932.127922422],
                        [3e-11, 0.57063116288, 52250.5878817157],
                        [3e-11, 4.90694398172, 27044.1922975448],
                        [3e-11, 5.64342324025, 78903.6067110366],
                        [3e-11, 3.90829945174, 130446.629254872],
                        [4e-11, 5.39121442451, 52022.0274726636],
                        [3e-11, 5.38325956945, 172402.036444808],
                        [3e-11, 3.62725946038, 161079.372346504],
                        [3e-11, 0.02159890719, 130652.814803309],
                        [3e-11, 5.26052772975, 55516.4187098482],
                        [3e-11, 1.45533607551, 77101.2347203148],
                        [3e-11, 2.45621582046, 207643.843202404],
                        [3e-11, 3.04264756378, 74923.0969980228],
                        [3e-11, 3.27797530359, 27669.8624898572],
                        [4e-11, 6.20795181771, 3340.6124266998],
                        [3e-11, 2.86818821459, 79330.2049019126],
                        [3e-11, 5.42245453158, 36109.7404216736],
                        [3e-11, 1.11238018002, 2125.8774073792],
                        [3e-11, 4.70325749301, 52595.2909270236],
                        [3e-11, 4.14290639481, 25446.4895798352],
                        [3e-11, 4.11874155864, 1478.8665740644],
                        [3e-11, 4.41727880469, 128220.758603684],
                        [3e-11, 5.8430133045, 65831.6667743248],
                        [3e-11, 0.63458746349, 112231.701719636],
                        [3e-11, 5.2035846966, 157057.10981454],
                        [3e-11, 4.22446997246, 53399.624123927],
                        [3e-11, 6.08145059717, 26724.8994135984],
                        [3e-11, 3.32246989691, 111122.323167542],
                        [3e-11, 1.11208497752, 78378.1487134078],
                        [3e-11, 1.18205388535, 80382.473285101],
                        [3e-11, 3.98183946807, 25352.0266280424],
                        [3e-11, 5.1753723875, 225687.22128005],
                        [2e-11, 3.19970010923, 64901.2597179234],
                        [3e-11, 5.90368046078, 104505.391376782],
                        [3e-11, 2.15712281571, 28736.3579670472],
                        [2e-11, 0.27988699718, 52325.369480283],
                        [2e-11, 1.09392137734, 24998.1943503806],
                        [3e-11, 1.72654636472, 130419.845946971],
                        [3e-11, 6.24477199702, 51969.6207347112],
                        [3e-11, 3.27154613105, 77630.9256854094],
                        [2e-11, 1.80684819652, 123668.805106625],
                        [2e-11, 3.75304905922, 150244.342999454],
                        [3e-11, 2.04107819596, 76784.8428506582],
                        [3e-11, 4.07589828594, 97670.3877128972],
                        [2e-11, 3.43439078149, 52609.5180210252],
                        [2e-11, 0.51530246334, 133882.090652836],
                        [3e-11, 4.75031746198, 204151.271635535],
                        [2e-11, 5.57618391474, 24292.6446978532],
                        [2e-11, 2.22207407093, 78213.7128028184],
                        [2e-11, 6.08590562625, 39450.3528483734],
                        [3e-11, 4.42541702442, 51955.3936407096],
                        [3e-11, 5.48323931966, 220.4126424388],
                        [3e-11, 5.24728665819, 26709.6469424134],
                        [3e-11, 4.52126286883, 20043.6745601988],
                        [2e-11, 1.69429787369, 53029.0026649004],
                        [3e-11, 0.98781948776, 80596.9058175946],
                        [2e-11, 2.7229153699, 23866.0465069772],
                        [2e-11, 2.23117481869, 26402.0893214438],
                        [3e-11, 2.32561622864, 145204.754751141],
                        [3e-11, 3.55406019317, 52225.8029050526],
                        [3e-11, 0.82939608505, 87253.177130155],
                        [3e-11, 3.59850686303, 52396.2189255872],
                        [2e-11, 0.25549281668, 22909.7573510066],
                        [2e-11, 4.18932113589, 81591.8450810028],
                        [2e-11, 5.58984236569, 104202.049369162],
                        [2e-11, 1.5932542826, 206.1855484372],
                        [2e-11, 2.33240745085, 157483.018591054],
                        [2e-11, 3.78499822852, 78731.674415077],
                        [3e-11, 1.73139148586, 77741.1320066288],
                        [2e-11, 1.98761216006, 102018.416173425],
                        [2e-11, 3.82447809654, 1162.4747044078],
                        [2e-11, 3.73613869026, 24601.923020509],
                        [2e-11, 4.87002033008, 51859.4144134918],
                        [2e-11, 0.10623356446, 111590.288157897],
                        [2e-11, 4.43911582586, 78270.3379836226],
                        [2e-11, 2.47821765975, 78114.146227588],
                        [2e-11, 5.8334620174, 181026.249095736],
                        [2e-11, 2.27341561267, 25953.7940919892],
                        [2e-11, 2.73852323809, 123200.840116271],
                        [2e-11, 2.35063735347, 78109.9306142378],
                        [2e-11, 0.45168929332, 2111.6503133776],
                        [2e-11, 4.46926491505, 25450.90686955],
                        [2e-11, 3.97278244291, 52808.5900224616],
                        [2e-11, 0.58667782465, 128320.751847493],
                        [2e-11, 3.05065649587, 102755.426124012],
                        [2e-11, 1.1348605474, 52492.198152805],
                        [2e-11, 4.64642529286, 60370.081616357],
                        [2e-11, 3.68035435205, 52309.9153327334],
                        [2e-11, 5.93910800197, 78160.616650504],
                        [2e-11, 1.26706232, 58857.031136548],
                        [2e-11, 5.09637370849, 26823.779655106],
                        [2e-11, 3.88808196008, 16703.062133499],
                        [2e-11, 0.00715741623, 130866.113898747],
                        [2e-11, 3.63338095338, 51852.300866491],
                        [2e-11, 5.67927933196, 103917.90082842],
                        [2e-11, 1.35964203538, 3328.13565628019],
                        [2e-11, 6.1353166559, 129373.020230681],
                        [2e-11, 3.74140255139, 52381.9918315856],
                        [2e-11, 0.37783717379, 53771.992725433],
                        [2e-11, 0.70779949763, 26667.590728573],
                        [2e-11, 2.05372686428, 70383.6202713836],
                        [2e-11, 6.06999395703, 23919.1426592916],
                        [2e-11, 1.22493486348, 103498.416184545],
                        [2e-11, 4.0005881348, 129799.618421557],
                        [2e-11, 1.62085169147, 78149.2701360374],
                        [2e-11, 1.81898501228, 25771.5112719176],
                        [2e-11, 6.2245179639, 52252.072354424],
                        [2e-11, 0.20849484282, 25754.0472008048],
                        [2e-11, 2.38916713246, 51226.6306741786],
                        [2e-11, 4.34697979051, 26404.2950112308],
                        [2e-11, 2.87638496001, 167850.08294775],
                        [2e-11, 4.0163819369, 51868.2486621788],
                        [2e-11, 3.38565068956, 77726.9049126272],
                        [2e-11, 5.73512271075, 189853.997582619],
                        [2e-11, 3.93444553575, 50910.238804522],
                        [2e-11, 3.62039658007, 6885.14988993081],
                        [2e-11, 1.7649293935, 92741.0606079226],
                        [2e-11, 2.5819014903, 154938.345954161],
                        [2e-11, 5.37279792857, 52278.899057367],
                        [2e-11, 3.37039086197, 2221.856634597],
                        [2e-11, 6.07737780217, 94329.7752861974],
                        [2e-11, 5.16106622649, 26729.3167033132],
                        [2e-11, 1.58212922198, 26013.1215430069],
                        [2e-11, 5.77714525422, 25600.26839032],
                        [2e-11, 1.88481234244, 27177.6119327678],
                        [2e-11, 5.68695965343, 50264.6067999312],
                        [2e-11, 6.0760153167, 141762.179806175],
                        [2e-11, 4.33545610317, 8194.2753332086],
                        [2e-11, 1.10189365852, 1223.81784077861],
                        [2e-11, 1.68048369897, 27250.377845982],
                        [2e-11, 5.32044002117, 151199.942741062],
                        [2e-11, 1.33411828477, 78257.0808658226],
                        [2e-11, 5.40842531044, 95247.7055721792],
                        [2e-11, 4.55349965747, 37698.4550999484],
                        [2e-11, 2.71889214634, 173511.414996902],
                        [2e-11, 1.95076646341, 143005.667407854],
                        [2e-11, 2.00346690661, 26073.6760475726],
                        [2e-11, 1.78781584986, 48847.6706268682],
                        [2e-11, 5.89586766332, 26312.2479372761],
                        [2e-11, 1.99160321093, 26189.8656598398],
                        [2e-11, 0.40598906242, 25773.7169617046],
                        [2e-11, 3.36946627953, 26575.5378928284],
                        [2e-11, 4.77845331095, 136722.591557862],
                        [2e-11, 1.11920130054, 51315.4963543956],
                        [2e-11, 4.99966961564, 78800.513936818],
                        [2e-11, 2.50164995664, 19202.7532516434],
                        [2e-11, 5.31192385841, 23384.2869868986],
                        [2e-11, 2.93563622378, 137678.191299471],
                        [2e-11, 5.00974264854, 182188.723800143],
                        [2e-11, 2.8206637022, 118828.963749497],
                        [2e-11, 1.23355180586, 52286.0126043678],
                        [2e-11, 0.27866926, 24356.7807886416],
                        [2e-11, 2.19163720361, 26395.4607625438],
                        [2e-11, 2.41579406356, 147423.511855328],
                        [2e-11, 1.80661945912, 860.3099287528],
                        [1e-11, 3.75687703582, 34082.4315835984],
                        [1e-11, 5.85918351804, 163766.094441045],
                        [1e-11, 4.84627694564, 27170.9833738678],
                        [2e-11, 3.12958128871, 195047.364641417],
                        [2e-11, 0.59313712363, 74.7815985673],
                        [2e-11, 4.60111717878, 25004.8229092806],
                        [1e-11, 1.14751201091, 55503.9419394286],
                        [2e-11, 4.55507467591, 132658.272812058],
                        [1e-11, 1.61844283111, 24079.3456024152],
                        [2e-11, 1.99970840056, 17098.4354361418],
                        [2e-11, 4.95650007002, 24448.8336243862],
                        [1e-11, 6.20512620421, 2333.196392872],
                        [2e-11, 1.27464400058, 144916.866891071],
                        [2e-11, 6.17677089224, 87367.6164188402],
                        [1e-11, 1.29983905478, 154194.222456573],
                        [2e-11, 4.47232796046, 130432.40216087],
                        [1e-11, 4.48574397522, 101703.157740824],
                        [2e-11, 2.19277171383, 103.0927742186],
                        [1e-11, 1.80796273878, 25508.2155545754],
                        [1e-11, 5.486640137, 22625.658435709],
                        [1e-11, 0.74294839995, 78896.4931640358],
                        [1e-11, 3.51165251141, 26421.7590823436],
                        [1e-11, 5.5566899571, 220025.889230898],
                        [2e-11, 4.08809950869, 25466.159340735],
                        [2e-11, 2.89128653047, 166740.704395656],
                        [1e-11, 3.92791860433, 189386.032592265],
                        [1e-11, 0.3312846752, 76571.5437552202],
                        [2e-11, 1.98187462633, 81604.3218514224],
                        [1e-11, 3.57210475329, 78786.2868428164],
                        [2e-11, 1.13879447241, 61165.2739885808],
                        [1e-11, 5.62721081889, 122444.987265847],
                        [1e-11, 0.51173156424, 113341.080271729],
                        [1e-11, 0.63238768568, 130459.185468771],
                        [1e-11, 0.62172861766, 138319.60486121],
                        [2e-11, 0.35135879351, 132028.588603155],
                        [1e-11, 1.68473271541, 28286.9904848612],
                        [2e-11, 2.61859360479, 61560.6472912236],
                        [1e-11, 3.42727473387, 130435.634372513],
                        [2e-11, 3.42836265136, 65717.2274856396],
                        [1e-11, 2.98248327032, 846.0828347512],
                        [1e-11, 5.35146960556, 1265.5674786264],
                        [1e-11, 4.8837970192, 205260.650187628],
                        [1e-11, 1.38681194099, 467.9649903544],
                        [1e-11, 5.78967137689, 76152.059111345],
                        [1e-11, 1.6462517202, 75930.5130318506],
                        [1e-11, 0.08732855602, 103718.828826984],
                        [1e-11, 0.74831854153, 51534.3927214094],
                        [1e-11, 1.98744571247, 26411.4085582316],
                        [2e-11, 0.58716824437, 52065.599961929],
                        [1e-11, 5.83388253183, 104275.346495021],
                        [1e-11, 2.07307900948, 78188.9278261553],
                        [1e-11, 4.54379329814, 203041.893083441],
                        [1e-11, 3.67961974137, 116783.655216695],
                        [1e-11, 2.7641982766, 52812.8025551726],
                        [1e-11, 5.76246998806, 1375.7737998458],
                        [1e-11, 3.49542841313, 79315.977807911],
                        [1e-11, 3.09408892186, 9384.8410080752],
                        [2e-11, 2.99230815235, 91805.1306272138],
                        [1e-11, 2.3181898578, 58220.0348645238],
                        [1e-11, 2.52061585089, 91919.569915899],
                        [1e-11, 0.20823485438, 54879.422437824],
                        [1e-11, 4.44457464944, 6044.2285813754],
                        [1e-11, 0.49331056411, 104819.577556651],
                        [1e-11, 5.98062907857, 106570.369670484],
                        [1e-11, 3.43578051874, 51841.950342379],
                        [1e-11, 1.50478057782, 137210.226309117],
                        [1e-11, 0.85871789181, 25985.9406233086],
                        [1e-11, 0.00464768227, 196137.073432611],
                        [1e-11, 4.31601888279, 50483.640613646],
                        [1e-11, 3.82192552665, 25928.601406782],
                        [1e-11, 2.13422641639, 62197.6435632478],
                        [1e-11, 0.26342054765, 1795.258443721],
                        [1e-11, 3.33069384141, 19.66976089979],
                        [1e-11, 5.0467220846, 26247.2048763664],
                        [1e-11, 3.6909155011, 77307.420268752],
                        [1e-11, 0.68629642431, 26102.1302355758],
                        [1e-11, 5.6196302566, 104197.833755812],
                        [1e-11, 0.41026701894, 636.9962720242],
                        [1e-11, 2.73690252229, 170068.840051936],
                        [1e-11, 2.97981003623, 78057.5238762854],
                        [1e-11, 2.84174115238, 168959.461499843],
                        [1e-11, 6.19695864555, 241561.838875413],
                        [1e-11, 2.31427972623, 179172.747046054],
                        [1e-11, 0.82072277702, 51329.7234483972],
                        [1e-11, 5.23954201903, 99024.136457914],
                        [1e-11, 1.86269361791, 45494.5814297488],
                        [1e-11, 3.54450921353, 78338.4910232899],
                        [1e-11, 4.60745432488, 156507.749088545],
                        [1e-11, 1.62346464256, 128106.319314999],
                        [1e-11, 0.72186155433, 27005.833427556],
                        [1e-11, 2.30344666604, 50380.5478394274],
                        [1e-11, 1.18658609813, 8989.46770543239],
                        [1e-11, 6.25857682168, 50800.0324833026],
                        [1e-11, 0.99962008973, 163298.129450691],
                        [1e-11, 2.86790873835, 38634.3850806572],
                        [1e-11, 3.61827980669, 106262.812049514],
                        [1e-11, 0.61515728295, 78469.8949731598],
                        [1e-11, 4.60636743786, 126996.940762906],
                        [1e-11, 4.48187053152, 231348.553329202],
                        [1e-11, 5.1982979368, 142871.558358269],
                        [1e-11, 5.68864830775, 3178.1457905676],
                        [1e-11, 4.89753750946, 53265.515074342],
                        [1e-11, 3.68051221186, 2703.6161546756],
                        [1e-11, 0.0173753133, 103814.808054201],
                        [1e-11, 1.79348974875, 183145.012956114],
                        [1e-11, 6.16564988887, 199599.318138476],
                        [1e-11, 0.63301837081, 51439.9297696166],
                        [1e-11, 2.2942790431, 1485.9801210652],
                        [1e-11, 1.44184009822, 112545.887899505],
                        [1e-11, 0.55411127132, 42790.9652750732],
                        [1e-11, 5.07507945312, 54824.2611086214],
                        [1e-11, 5.10858625008, 107679.748222577],
                        [1e-11, 5.50068575093, 27819.0254945068],
                        [1e-11, 5.60579347269, 153084.84390448],
                        [1e-11, 4.92352598929, 51596.1186961496],
                        [1e-11, 6.10538330268, 181659.722249411],
                      ],
          },
          {
            series => "R2",
            terms  => [
                        [3.117867e-05, 3.08231840296, 26087.9031415742],
                        [1.245396e-05, 6.15183317423, 52175.8062831484],
                        [4.24822e-06, 2.9258335296, 78263.7094247226],
                        [1.3613e-06, 5.97983925842, 104351.612566297],
                        [4.2175e-07, 2.74936980629, 130439.515707871],
                        [2.1759e-07, 3.14159265359, 0],
                        [1.2793e-07, 5.80143162209, 156527.418849445],
                        [3.825e-08, 2.56993599584, 182615.321991019],
                        [1.042e-08, 3.14648120079, 24978.5245894808],
                        [1.131e-08, 5.6214219697, 208703.225132594],
                        [4.83e-09, 6.1430765452, 27197.2816936676],
                        [3.32e-09, 2.3899257567, 234791.128274168],
                        [3.2e-09, 6.20674766565, 51066.427731055],
                        [1.2e-09, 0.56745598887, 20426.571092422],
                        [1.13e-09, 3.28048907943, 24498.8302462904],
                        [1.05e-09, 4.36663468239, 25028.521211385],
                        [9.7e-10, 5.44128884026, 260879.031415742],
                        [9.5e-10, 1.70276410782, 1059.3819301892],
                        [1.03e-09, 2.98038190305, 77154.3308726292],
                        [7.4e-10, 1.286303818, 26617.5941066688],
                        [5.7e-10, 2.9675336298, 1109.3785520934],
                        [6.6e-10, 5.68201233964, 25132.3033999656],
                        [5.3e-10, 3.63699398162, 46514.4742339962],
                        [5.9e-10, 3.10922979724, 27043.5028831828],
                        [5.3e-10, 0.66673109494, 21535.9496445154],
                        [4.3e-10, 4.69270605698, 27147.2850717634],
                        [4.2e-10, 2.77372510028, 1589.0728952838],
                        [3.6e-10, 4.39741248058, 14765.2390432698],
                        [3.5e-10, 1.80468389323, 11322.6640983044],
                        [4.3e-10, 6.0742625499, 28306.660245761],
                        [3.3e-10, 5.34572581657, 25448.0058552602],
                        [3.1e-10, 5.6648907507, 30639.856638633],
                        [3.1e-10, 2.36104565226, 32858.6137428198],
                        [3.1e-10, 4.27403143366, 16983.9961474566],
                        [3.3e-10, 3.22976052744, 23869.1460373874],
                        [3.1e-10, 0.5004107612, 22645.3281966088],
                        [2.8e-10, 2.21390393577, 286966.934557316],
                        [3.3e-10, 6.03682885493, 103242.234014203],
                        [2.5e-10, 4.23934105457, 52705.497248243],
                        [2.3e-10, 2.59711556958, 23969.1392811958],
                        [2.7e-10, 2.10665521901, 25558.2121764796],
                        [2.1e-10, 0.4089238358, 72602.3773755704],
                        [2.5e-10, 5.69513499802, 5661.3320491522],
                        [2.2e-10, 4.86064608327, 26301.2022370122],
                        [2.4e-10, 0.66522740624, 19317.1925403286],
                        [2e-10, 5.61847810688, 4551.9534970588],
                        [2.1e-10, 2.30083904827, 51220.2065415398],
                        [1.8e-10, 0.4883903725, 26068.2333806744],
                        [1.6e-10, 6.07779022342, 50586.7333878646],
                        [1.6e-10, 1.47218845921, 53235.1882133376],
                        [1.7e-10, 2.94277588966, 53285.1848352418],
                        [1.5e-10, 2.39097980793, 83925.0414738748],
                        [1.5e-10, 3.85502950028, 26091.7844769322],
                        [1.4e-10, 4.13753968603, 12566.1516999828],
                        [1.5e-10, 5.51545801304, 6770.7106012456],
                        [1.4e-10, 5.67708505049, 57837.1383323006],
                        [1.4e-10, 5.73775080815, 27676.976036858],
                        [1.6e-10, 5.69298300679, 26107.572902474],
                        [1.4e-10, 5.00837046884, 37410.5672398786],
                        [1.5e-10, 5.72321978212, 29530.4780865396],
                        [1.2e-10, 1.18827026407, 40853.142184844],
                        [1.3e-10, 2.34101240702, 26084.0218062162],
                        [1.2e-10, 2.43920574243, 56727.7597802072],
                        [1.2e-10, 1.12086684687, 43071.8992890308],
                        [1.2e-10, 1.86975778356, 9103.9069941176],
                        [1.2e-10, 4.9023641695, 36301.1886877852],
                        [1e-10, 2.33297570685, 426.598190876],
                        [1.1e-10, 2.80390774003, 129330.137155778],
                        [1e-10, 5.86382886189, 26202.3424302594],
                        [9e-11, 0.03545904481, 25234.7067598222],
                        [1.1e-10, 0.92571990717, 639.897286314],
                        [1e-10, 3.94827815051, 25661.3049506982],
                        [9e-11, 0.00145195768, 49957.0491789616],
                        [8e-11, 5.42702003399, 110012.944615449],
                        [8e-11, 3.39306818321, 25973.463852889],
                        [9e-11, 4.83499870418, 38519.945791972],
                        [8e-11, 5.65148718768, 53131.406024757],
                        [9e-11, 5.73812314204, 51116.4243529592],
                        [8e-11, 1.98050481337, 13521.7514415914],
                        [9e-11, 0.95963913886, 78793.4003898172],
                        [8e-11, 5.24647237181, 313054.83769889],
                        [8e-11, 3.52212788936, 52156.1365222486],
                        [7e-11, 3.57060093012, 48733.231338183],
                        [8e-11, 3.47359025801, 98690.2805171446],
                        [8e-11, 5.32679971128, 51646.1153180538],
                        [1e-10, 5.07319693095, 25874.6040461362],
                        [8e-11, 4.34411026261, 31749.2351907264],
                        [7e-11, 3.44556423722, 26080.7895945734],
                        [7e-11, 5.28088749622, 77308.109683114],
                        [7e-11, 3.46667099767, 2118.7638603784],
                        [7e-11, 1.96360039314, 10213.285546211],
                        [7e-11, 1.18631489114, 103292.230636108],
                        [7e-11, 4.28693259279, 955.5997416086],
                        [7e-11, 0.88520158736, 38654.054841557],
                        [9e-11, 2.1210015003, 18849.2275499742],
                        [8e-11, 2.75301666365, 26095.016688575],
                        [7e-11, 4.98530328971, 529.6909650946],
                        [7e-11, 0.20928215626, 33326.5787331742],
                        [6e-11, 4.54286088482, 79323.0913549118],
                        [6e-11, 0.60060875587, 52179.6876185064],
                        [6e-11, 1.21940434381, 41962.5207369374],
                        [6e-11, 1.74585091288, 62389.0918293594],
                        [6e-11, 2.13481309441, 51535.9089968344],
                        [6e-11, 4.92478078408, 26514.5013324502],
                        [7e-11, 4.18249532118, 77204.3274945334],
                        [7e-11, 1.68449319925, 52389.1053785864],
                        [5e-11, 4.28220819106, 68050.4238785116],
                        [7e-11, 1.69076988754, 12432.0426503978],
                        [6e-11, 3.73803069606, 45405.0956819028],
                        [5e-11, 2.6132037412, 79373.087976816],
                        [5e-11, 2.82458540907, 54394.5633873352],
                        [4e-11, 6.27439443684, 52168.6927361476],
                        [5e-11, 4.50767453332, 13655.8604911764],
                        [6e-11, 2.41451327257, 52195.4760440482],
                        [5e-11, 5.35396003655, 52171.9249477904],
                        [5e-11, 5.48187638039, 82815.6629217814],
                        [4e-11, 2.46695073802, 55618.3812281138],
                        [4e-11, 2.40470389725, 53764.8791784322],
                        [4e-11, 4.24591997877, 66941.0453264182],
                        [4e-11, 3.26730161531, 7238.6755916],
                        [4e-11, 4.24517841791, 129380.133777682],
                        [4e-11, 5.46706523938, 50057.04242277],
                        [4e-11, 2.17208918484, 136100.847757023],
                        [4e-11, 5.86573287261, 155418.040297352],
                        [4e-11, 4.15256069197, 32370.9789915656],
                        [4e-11, 2.92358717546, 2218.7571041868],
                        [4e-11, 2.22141015932, 33967.9922949132],
                        [5e-11, 5.74788858603, 52182.9198301492],
                        [4e-11, 0.97295961632, 44181.2778411242],
                        [3e-11, 5.78273085505, 28421.0995344462],
                        [3e-11, 3.65975480266, 99799.659069238],
                        [4e-11, 3.98623592167, 26727.8004278882],
                        [3e-11, 2.65056124435, 76674.6365294388],
                        [3e-11, 4.91152657563, 47623.8527860896],
                        [4e-11, 1.60135504353, 77734.018459628],
                        [3e-11, 0.26868606771, 78244.0396638228],
                        [3e-11, 4.58298191655, 1066.49547719],
                        [3e-11, 4.04696774318, 18093.37469955],
                        [3e-11, 1.04981780528, 94138.3270200858],
                        [3e-11, 0.82425633309, 73711.7559276638],
                        [3e-11, 5.12180734718, 1052.2683831884],
                        [3e-11, 1.58544193974, 51109.3108059584],
                        [3e-11, 0.22337858409, 124778.183658719],
                        [3e-11, 3.08207297479, 76044.9523205358],
                        [3e-11, 6.26000429251, 853.196381752],
                        [3e-11, 3.89747679105, 64741.9579831312],
                        [3e-11, 1.86869273254, 52602.4044740244],
                        [4e-11, 0.01480665337, 7.1135470008],
                        [3e-11, 1.95420622178, 103396.012824688],
                        [3e-11, 6.00022344367, 29416.0387978544],
                        [3e-11, 1.0582738966, 51123.53789996],
                        [3e-11, 3.9333618709, 104881.303531391],
                        [2e-11, 4.80666683935, 88476.9949709336],
                        [2e-11, 2.56919394798, 51962.5071877104],
                        [2e-11, 5.19328838214, 91785.460866314],
                        [3e-11, 4.94448744333, 44937.1306915484],
                        [2e-11, 0.39272598961, 23754.7067487022],
                        [3e-11, 3.64926786888, 78267.5907600806],
                        [2e-11, 1.93776267237, 117873.364007888],
                        [2e-11, 0.16310879863, 28206.6670019526],
                        [2e-11, 2.74232958068, 52290.2455718336],
                        [2e-11, 1.94114905421, 7994.5284420242],
                        [2e-11, 0.39437121176, 125887.562210812],
                        [2e-11, 1.03418813348, 155468.036919256],
                        [2e-11, 2.06866763231, 339142.740840465],
                        [2e-11, 1.29912216629, 105410.994496486],
                        [2e-11, 0.5412418909, 74821.1344797572],
                        [2e-11, 2.12346357366, 65697.5577247398],
                        [2e-11, 2.54143985834, 78270.8229717234],
                        [2e-11, 4.87063627681, 35191.8101356918],
                        [2e-11, 0.51631216786, 71492.998823477],
                        [2e-11, 0.7397688755, 18207.8139882352],
                        [2e-11, 5.50150244414, 78283.3791856224],
                        [2e-11, 4.78661791721, 78477.0085201606],
                        [2e-11, 4.40683761496, 103821.921601202],
                        [2e-11, 3.07092516027, 78256.5958777218],
                        [2e-11, 5.01301614244, 3442.5749449654],
                        [2e-11, 2.58799752737, 181505.943438926],
                        [2e-11, 4.95243490606, 129483.915966262],
                        [2e-11, 4.12821833516, 77211.4410415342],
                        [2e-11, 4.05475453577, 120226.23016166],
                        [2e-11, 3.34041291655, 151975.465352386],
                        [2e-11, 3.27812728356, 51322.6099013964],
                        [2e-11, 4.06092192484, 77837.1112338466],
                        [2e-11, 5.22546741404, 162188.750898597],
                        [2e-11, 5.57497617017, 71980.6335747312],
                        [2e-11, 1.86655156569, 23439.4483161012],
                        [2e-11, 4.79020891265, 15874.6175953632],
                        [2e-11, 2.43202419279, 45892.730433157],
                        [1e-11, 4.91443985635, 78690.3076155986],
                        [2e-11, 2.55186486587, 39609.6545831656],
                        [2e-11, 2.04705904795, 433.7117378768],
                        [1e-11, 6.06582167254, 102132.85546211],
                        [2e-11, 0.36512406083, 6283.0758499914],
                        [2e-11, 5.96418661485, 78050.4103292846],
                        [1e-11, 0.66730245858, 58458.8821331398],
                        [1e-11, 2.46652537811, 98068.5367163054],
                        [2e-11, 3.24884087108, 150866.086800293],
                        [2e-11, 0.33626385981, 52061.3669944632],
                        [1e-11, 1.58214319162, 114564.898112508],
                        [1e-11, 1.86505965946, 27140.1715247626],
                        [1e-11, 4.7095478466, 77197.2139475326],
                        [1e-11, 3.30080224324, 104331.942805397],
                        [2e-11, 2.15014442693, 78259.8280893646],
                        [1e-11, 4.16909637294, 51742.0945452716],
                        [2e-11, 0.61993180902, 130969.206672966],
                        [1e-11, 5.64166202504, 81706.284369688],
                        [1e-11, 1.28449131177, 27154.3986187642],
                        [1e-11, 0.20716724934, 131548.894259964],
                        [1e-11, 5.01586042695, 105460.99111839],
                        [1e-11, 2.2014213773, 104371.282327197],
                        [1e-11, 0.7154790308, 103925.014375421],
                        [1e-11, 1.69298852699, 71025.0338331226],
                        [2e-11, 1.01857337375, 93028.9484679924],
                        [2e-11, 0.99564225222, 129909.824742776],
                        [1e-11, 3.04953117213, 26941.0995233262],
                        [1e-11, 1.54774252742, 104564.911661735],
                        [1e-11, 1.29736654025, 26241.681952059],
                        [2e-11, 0.39879309478, 104355.493901655],
                        [1e-11, 1.73442408485, 64607.8489335462],
                        [1e-11, 3.52887677711, 97580.9019650512],
                        [1e-11, 3.55488474055, 84546.785274714],
                        [1e-11, 2.68991734615, 59414.4818747484],
                        [1e-11, 2.23301107736, 107794.187511262],
                        [1e-11, 6.04185199127, 104344.499019296],
                        [1e-11, 2.33178230942, 108903.566063356],
                        [1e-11, 5.23291332097, 134991.46920493],
                        [1e-11, 5.42420842294, 79852.7823200064],
                        [1e-11, 5.56485897392, 104358.726113298],
                        [1e-11, 2.03042058117, 76144.9455643442],
                        [1e-11, 4.42403586918, 25021.4076643842],
                        [1e-11, 4.07362401058, 181555.94006083],
                        [1e-11, 4.39544806298, 131498.89763806],
                        [1e-11, 3.37653548744, 22759.767485294],
                        [1e-11, 3.34598726101, 24864.0853007956],
                        [1e-11, 0.81949463309, 52815.7035694624],
                        [1e-11, 4.13026377404, 2648.454825473],
                        [1e-11, 1.4070114617, 103285.117089107],
                        [1e-11, 2.72338212355, 419.4846438752],
                        [1e-11, 2.8623972993, 63498.4703814528],
                        [1e-11, 4.60118276053, 19804.8272915828],
                        [1e-11, 3.76488909896, 51749.2080922724],
                        [1e-11, 5.71167880995, 78378.1487134078],
                        [1e-11, 3.11068504003, 54294.5701435268],
                        [1e-11, 5.17191010522, 1596.1864422846],
                        [1e-11, 0.84666659977, 26037.90651967],
                        [1e-11, 1.27214241387, 39743.7636327506],
                        [1e-11, 3.62572271343, 51756.3216392732],
                        [1e-11, 0.99401491673, 50579.6198408638],
                        [1e-11, 2.65940437112, 79219.3091663312],
                        [1e-11, 2.78122688424, 157636.797401539],
                        [1e-11, 5.02865728622, 365230.643982039],
                        [1e-11, 4.26629771518, 26724.8994135984],
                        [1e-11, 0.69459147389, 90829.8611247054],
                        [1e-11, 3.74834736873, 44295.7171298094],
                        [1e-11, 2.67181600104, 5327.4761083828],
                        [1e-11, 5.10769130141, 58946.516884394],
                        [1e-11, 0.55503171074, 69159.802430605],
                        [1e-11, 4.68391610322, 90695.7520751204],
                        [1e-11, 5.17372763616, 149.5631971346],
                        [1e-11, 5.26044215633, 25934.1243310894],
                        [1e-11, 5.13679156205, 104347.731230939],
                        [1e-11, 0.91197645609, 103299.344183108],
                        [1e-11, 5.89466975855, 27311.7209823528],
                        [1e-11, 0.91206378451, 77829.9976868458],
                        [1e-11, 0.82686052448, 146314.133303234],
                        [1e-11, 5.01041490382, 25450.90686955],
                        [1e-11, 0.74891931364, 10021.8372800994],
                        [1e-11, 3.75910629606, 25619.9381512198],
                        [1e-11, 1.57855828108, 61279.713277266],
                        [1e-11, 5.22196769252, 77623.8121384086],
                        [1e-11, 5.4428033736, 52643.7712735028],
                        [1e-11, 3.3876046343, 49842.6098902764],
                        [1e-11, 4.04176416141, 25565.3257234804],
                        [1e-11, 1.99169557218, 105940.685461581],
                        [1e-11, 2.40126368211, 26555.8681319286],
                        [1e-11, 3.28153684541, 78149.2701360374],
                        [1e-11, 1.50606534242, 50593.8469348654],
                        [1e-11, 4.99390846744, 143961.267149462],
                        [1e-11, 4.36279289081, 70269.1809826984],
                        [1e-11, 0.5633044687, 29428.515568274],
                        [1e-11, 1.96827343473, 188276.654040172],
                        [1e-11, 6.1402409335, 3328.13565628019],
                        [1e-11, 4.38278455115, 52329.5850936332],
                        [1e-11, 5.32677211586, 26137.8997634784],
                        [1e-11, 5.49001686286, 7880.08915333899],
                        [1e-11, 2.08096369099, 26610.480559668],
                        [1e-11, 2.81808749734, 54509.0026760204],
                        [1e-11, 3.85620334673, 26624.7076536696],
                        [1e-11, 1.15157832957, 536.8045120954],
                        [1e-11, 3.62974919098, 130012.917516995],
                        [1e-11, 0.3597788856, 105307.212307905],
                        [1e-11, 2.75970257539, 55503.9419394286],
                        [1e-11, 3.95087871071, 119116.851609567],
                        [1e-11, 2.02746284465, 85034.4200259682],
                        [1e-11, 0.01631363612, 25668.418497699],
                        [1e-11, 4.69497491223, 1581.959348283],
                        [1e-11, 4.43589881789, 53242.3017603384],
                        [1e-11, 0.02851648548, 213.299095438],
                        [1e-11, 2.42155941603, 25551.0986294788],
                        [1e-11, 4.51335885923, 12546.481939083],
                        [1e-11, 3.0701219029, 104138.313470859],
                        [1e-11, 4.25105785914, 65831.6667743248],
                        [1e-11, 0.26591217377, 89586.373523027],
                        [1e-11, 3.25491459524, 46848.3301747656],
                        [1e-11, 5.00501348827, 51639.001771053],
                        [0, 5.50334834007, 124156.43985788],
                        [0, 4.83101429854, 76.2660712756],
                        [0, 4.34030366776, 80482.4665289094],
                        [1e-11, 3.55161443787, 116917.76426628],
                        [0, 4.96302997387, 26521.614879451],
                        [1e-11, 0.12176395772, 6681.2248533996],
                        [1e-11, 0.06932929209, 48847.6706268682],
                        [1e-11, 0.08695556653, 26507.3877854494],
                        [0, 1.50601747714, 632.7837393132],
                        [0, 3.68453733674, 25035.6347583858],
                        [0, 2.10077795936, 86143.7985780616],
                        [0, 2.61352703953, 53399.624123927],
                        [0, 0.84481589887, 25881.717593137],
                        [0, 3.95854005744, 95247.7055721792],
                        [1e-11, 4.47600641528, 97112.9369746968],
                        [1e-11, 0.40812953108, 77844.2247808474],
                        [0, 4.89912517892, 25984.8103673556],
                        [0, 5.16843610094, 52698.3837012422],
                        [0, 3.99449121788, 131395.11544948],
                        [0, 5.65446547429, 80596.9058175946],
                      ],
          },
          {
            series => "R3",
            terms  => [
                        [3.2676e-07, 1.67971635359, 26087.9031415742],
                        [2.4166e-07, 4.63403168997, 52175.8062831484],
                        [1.2133e-07, 1.38983781545, 78263.7094247226],
                        [5.14e-08, 4.4391538693, 104351.612566297],
                        [1.981e-08, 1.20733880274, 130439.515707871],
                        [1.46e-08, 3.14159265359, 0],
                        [7.19e-09, 4.25913631362, 156527.418849445],
                        [2.5e-09, 1.02794425848, 182615.321991019],
                        [8.4e-10, 4.08008618813, 208703.225132594],
                        [2.8e-10, 0.85051616237, 234791.128274168],
                        [2.3e-10, 1.60029451014, 24978.5245894808],
                        [1.1e-10, 4.58074493182, 27197.2816936676],
                        [1.2e-10, 4.6587866039, 51066.427731055],
                        [9e-11, 3.90622332667, 260879.031415742],
                        [5e-11, 1.43247327249, 77154.3308726292],
                        [4e-11, 1.37106678794, 53285.1848352418],
                        [3e-11, 0.67217979275, 286966.934557316],
                        [2e-11, 5.31135121818, 20426.571092422],
                        [2e-11, 1.54812921017, 1109.3785520934],
                        [2e-11, 4.48222146022, 103242.234014203],
                        [2e-11, 0.20057520755, 1059.3819301892],
                        [2e-11, 4.21865197056, 25132.3033999656],
                        [1e-11, 2.11997334018, 46514.4742339962],
                        [1e-11, 3.24267833975, 27147.2850717634],
                        [1e-11, 1.33238537892, 1589.0728952838],
                        [1e-11, 5.14405498793, 72602.3773755704],
                        [1e-11, 6.14595652541, 26617.5941066688],
                        [1e-11, 3.90494988936, 4551.9534970588],
                        [1e-11, 2.85134614467, 14765.2390432698],
                        [1e-11, 3.74339959279, 313054.83769889],
                        [1e-11, 2.82234410581, 52705.497248243],
                        [1e-11, 1.70132625273, 23869.1460373874],
                        [1e-11, 1.4410244446, 27043.5028831828],
                        [1e-11, 1.2535842334, 129330.137155778],
                        [1e-11, 0.32054002273, 9103.9069941176],
                        [1e-11, 0.90273607509, 51220.2065415398],
                        [1e-11, 4.28935605425, 27676.976036858],
                        [1e-11, 4.41206223998, 79373.087976816],
                        [1e-11, 3.23518929162, 26301.2022370122],
                        [1e-11, 2.25667255668, 21535.9496445154],
                        [1e-11, 4.70414203873, 50586.7333878646],
                        [1e-11, 1.88608259832, 98690.2805171446],
                        [1e-11, 5.90420893056, 40853.142184844],
                        [1e-11, 4.46892853356, 53131.406024757],
                        [1e-11, 3.83684899837, 77308.109683114],
                        [1e-11, 1.31974603498, 54394.5633873352],
                        [1e-11, 0.74728939443, 32858.6137428198],
                        [1e-11, 6.27673970277, 53235.1882133376],
                        [1e-11, 4.1481457861, 29530.4780865396],
                        [1e-11, 0.87302135775, 83925.0414738748],
                        [1e-11, 5.20339566427, 26068.2333806744],
                        [1e-11, 2.88631079597, 79323.0913549118],
                        [1e-11, 5.39853672849, 19317.1925403286],
                        [1e-11, 5.73721596586, 78793.4003898172],
                        [0, 1.85241611022, 25973.463852889],
                        [0, 4.31134434847, 26202.3424302594],
                        [0, 4.7430520578, 49957.0491789616],
                        [1e-11, 3.87802524387, 82815.6629217814],
                        [0, 4.28937691652, 155418.040297352],
                        [1e-11, 3.35625397389, 37410.5672398786],
                        [0, 2.00313301846, 22645.3281966088],
                        [0, 2.49236829957, 25028.521211385],
                        [0, 0.01947787727, 25558.2121764796],
                        [1e-11, 4.13825019881, 3442.5749449654],
                        [0, 2.81832388305, 25874.6040461362],
                        [0, 2.53416253042, 12566.1516999828],
                        [1e-11, 4.46169102731, 28306.660245761],
                        [1e-11, 2.16986592809, 45405.0956819028],
                        [0, 2.27621739263, 26091.7844769322],
                        [0, 1.95034764539, 52156.1365222486],
                        [0, 4.03054078678, 30639.856638633],
                        [0, 5.76722418743, 43071.8992890308],
                        [0, 4.12739704581, 26107.572902474],
                        [0, 1.37713138665, 31749.2351907264],
                        [1e-11, 3.54716896556, 51646.1153180538],
                        [0, 3.3916159585, 36301.1886877852],
                        [0, 4.34410863436, 57837.1383323006],
                        [0, 5.6208296069, 639.897286314],
                        [0, 3.16268062826, 529.6909650946],
                        [0, 0.77186843357, 26084.0218062162],
                        [0, 3.78612072314, 110012.944615449],
                        [0, 5.50453358586, 51116.4243529592],
                        [0, 0.0470913142, 52389.1053785864],
                        [0, 3.93991894858, 6770.7106012456],
                        [0, 1.41961180167, 76674.6365294388],
                        [0, 2.61258742182, 66941.0453264182],
                        [0, 0.70544164813, 426.598190876],
                        [0, 0.91883551986, 55618.3812281138],
                        [0, 5.30612883135, 52179.6876185064],
                        [0, 2.00604152518, 2118.7638603784],
                        [0, 1.08640210817, 56727.7597802072],
                        [0, 3.92743267498, 58946.516884394],
                        [0, 5.52202827702, 38654.054841557],
                        [0, 1.57363600114, 24498.8302462904],
                        [0, 3.49522546958, 5661.3320491522],
                        [0, 0.63375195581, 51535.9089968344],
                        [0, 1.34305878069, 105460.99111839],
                        [0, 0.44820055565, 339142.740840465],
                        [0, 1.39951362362, 2218.7571041868],
                        [0, 0.63311095079, 18849.2275499742],
                        [0, 0.82120127326, 52195.4760440482],
                        [0, 2.78211363987, 47623.8527860896],
                        [0, 0.94752126944, 53764.8791784322],
                        [0, 3.75988526858, 52171.9249477904],
                        [0, 0.4435143591, 136100.847757023],
                        [0, 1.44824925227, 76044.9523205358],
                        [0, 4.83985082201, 78244.0396638228],
                        [0, 0.04522486479, 62389.0918293594],
                        [0, 6.28144869714, 213.299095438],
                        [0, 5.17875557687, 955.5997416086],
                        [0, 4.62674052433, 52168.6927361476],
                        [0, 2.19907823066, 77204.3274945334],
                        [0, 3.40216597806, 26514.5013324502],
                        [0, 2.89630853457, 13655.8604911764],
                        [0, 3.92639394174, 50057.04242277],
                        [0, 0.27991454535, 11322.6640983044],
                        [0, 5.63968341805, 103292.230636108],
                        [0, 1.86829495425, 48733.231338183],
                        [0, 5.77443179008, 105410.994496486],
                      ],
          },
          {
            series => "R4",
            terms  => [
                        [3.94e-09, 0.3673540384, 26087.9031415742],
                        [3.87e-09, 3.18568771507, 52175.8062831484],
                        [2.7e-09, 6.16983616444, 78263.7094247226],
                        [1.49e-09, 2.91591904641, 104351.612566297],
                        [7.1e-10, 5.95867889641, 130439.515707871],
                        [3.1e-10, 2.72386700044, 156527.418849445],
                        [1.7e-10, 0, 0],
                        [1.2e-10, 5.77775334056, 182615.321991019],
                        [5e-11, 2.54506442647, 208703.225132594],
                        [2e-11, 5.59978443851, 234791.128274168],
                        [1e-11, 2.33785160871, 260879.031415742],
                        [0, 5.37943916893, 286966.934557316],
                        [0, 3.09643524101, 51066.427731055],
                        [0, 0.0934285875, 24978.5245894808],
                        [0, 6.02837115675, 53285.1848352418],
                        [0, 6.13600004668, 77154.3308726292],
                        [0, 2.93310416266, 27197.2816936676],
                        [0, 2.89897922039, 103242.234014203],
                      ],
          },
          {
            series => "R5",
            terms  => [
                        [6e-11, 3.98900269603, 26087.9031415742],
                        [6e-11, 1.55248278782, 52175.8062831484],
                        [5e-11, 4.65461721116, 78263.7094247226],
                        [4e-11, 1.40238366492, 104351.612566297],
                        [2e-11, 4.44231488663, 130439.515707871],
                        [1e-11, 3.14159265359, 0],
                        [1e-11, 1.21278177664, 156527.418849445],
                        [1e-11, 4.2614902634, 182615.321991019],
                        [0, 0.99831133595, 208703.225132594],
                        [0, 4.0026706421, 234791.128274168],
                      ],
          },
        ],
      ],
      name => "VSOP87D",
      order => 1,
      sidereal_period => 7600543.7,
      tropical_period => 7600472.666,
    }->{$key};
}

1;

__END__

=head1 NAME

Astro::Coord::ECI::VSOP87D::Mercury - VSOP87D model of the position of Mercury

=head1 SYNOPSIS

 use Astro::Coord::ECI::VSOP87D::Mercury;
 use Astro::Coord::ECI::Utils qw{ deg2rad };
 use POSIX qw{ strftime };
 use Time::Local qw{ localtime };
 
 my $station = Astro::Coord::ECI->new(
     name => 'White House',
 )->geodetic(
     deg2rad( 38.899 ),  # radians
     deg2rad( -77.038 ), # radians
     16.68/1000,         # Kilometers
 );
 my $venus = Astro::Coord::ECI::VSOP87D::Mercury->new(
     station => $station,
 );
 my $today = timelocal( 0, 0, 0, ( localtime )[ 3 .. 5 ] );
 foreach my $item ( $venus->almanac( $today, $today + 86400 ) ) {
     local $\ = "\n";
     print strftime( '%d-%b-%Y %H:%M:%S', localtime $item->[0] ),
         $item->[3];
 }

=head1 DESCRIPTION

This Perl class computes the position of Mercury using the VSOP87D
model. It is a subclass of
L<Astro::Coord::ECI::VSOP87D::_Inferior|Astro::Coord::ECI::VSOP87D::_Inferior>.

=head1 METHODS

This class supports no additional public methods.

=head2 ATTRIBUTES

This class has no additional attributes.

=head1 SEE ALSO

L<Astro::Coord::ECI|Astro::Coord::ECI>

L<Astro::Coord::ECI::VSOP87D|Astro::Coord::ECI::VSOP87D>

=head1 SUPPORT

Support is by the author. Please file bug reports at
L<http://rt.cpan.org>, or in electronic mail to the author.

=head1 AUTHOR

Thomas R. Wyant, III F<wyant at cpan dot org>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2018-2020 by Thomas R. Wyant, III

This program is free software; you can redistribute it and/or modify it
under the same terms as Perl 5.10.0. For more details, see the full text
of the licenses in the directory LICENSES.

This program is distributed in the hope that it will be useful, but
without any warranty; without even the implied warranty of
merchantability or fitness for a particular purpose.

=cut

# ex: set filetype=perl textwidth=72 :
