#!perl
use warnings; use strict;
use Test::More tests => 26;
use Test::Fatal;

use version;
use Try::Tiny;

use lib '.';
use t::Elive::StandardV3;

use Elive::StandardV3::Session;
use Elive::Util;

our $t = Test::More->builder;
our $class = 'Elive::StandardV3::Session';

our $connection;

SKIP: {

    my $skippable = 26;

    my %result = t::Elive::StandardV3->test_connection();
    my $auth = $result{auth};

   skip ($result{reason} || 'skipping live tests', $skippable)
	unless $auth && @$auth;

    try {require Elive::StandardV3::Connection} catch {die $_};

    my $connection_class = $result{class};
    $connection = $connection_class->connect(@$auth);
    Elive::StandardV3->connection($connection);

    my $session_start = Elive::Util::next_quarter_hour();
    my $session_end = Elive::Util::next_quarter_hour( $session_start );

    my %session_data = (
	sessionName => 'test session, generated by t/soap-session.t',
	creatorId => $connection->user,
	startTime =>  $session_start . '000',
	endTime => $session_end . '000',
	openChair => 0,
	mustBeSupervised => 0,
	permissionsOn => 1,
	chairList => [qw(alice bob)],
	groupingList => [qw(mechanics sewing)],
    );

    my $session = $class->insert(\%session_data);

    isa_ok($session, $class, 'session');
    ok(my $session_id = $session->sessionId, 'Insert returned session id');

    note "session-id: $session_id";

    foreach (keys %session_data) {
	#
	# returned record doesn't contain password
	is(uc Elive::Util::string($session->$_), uc Elive::Util::string($session_data{$_}), "session $_ as expected");
    }

    my %update_data = (
	chairNotes => 'test moderator notes. Here are some entities: & > <',
	nonChairNotes => 'test user notes; some more entities: &gt;',
	raiseHandOnEnter => 1,
	maxTalkers => 3,
	recordingModeType => 2,
	);

    $session->update(\%update_data);

    is( exception {$session->set_api_callback_url('http://perlmonks.org')} => undef,
	'$session->setapI_callback_url(...) - lives');

    $session = undef;

    my $sessions;

    ok ($sessions = Elive::StandardV3::Session->list(filter => {sessionId => $session_id}),
	'List of session');
  
    is(scalar @$sessions, 1, 'list returns unique session');

    is( try {$sessions->[0]->sessionId}, $session_id, 'listed sessionId as expected');
    $sessions = undef;

    ok ($session = Elive::StandardV3::Session->retrieve($session_id),
	'Refetch of session');

    foreach (keys %update_data) {
	#
	# returned record doesn't contain password
	is( uc $session->$_, uc $update_data{$_}, "session update $_ as expected");
    }

    my $session_url;
    is( exception {$session_url = $session->session_url(userId => 'bob', displayName => 'Robert')} => undef, 'Can generate session Url for charList user');
    note "session url: $session_url";

    my $attendances;

    is( exception {$attendances = $session->attendance('')} => undef, 'session attendance sans date - lives');

    my $today = $session_start - 7200;
    is( exception {$attendances = $session->attendance($today . '000')} => undef, 'session attendance with date - lives');

    is( exception {$session->delete} => undef, 'session deletion - lives');

    my $deleted_session;
    my $del_error = exception {$deleted_session = Elive::StandardV3::Session->retrieve($session_id)};

    ok($del_error || !$deleted_session, "can't retrieve deleted session");
}

Elive::StandardV3->disconnect;

