use strict;
use ExtUtils::MakeMaker;
use ExtUtils::PkgConfig;

my %cfg;
my $cfg_success = eval {
%cfg = ExtUtils::PkgConfig->find (
    "rpm >= 4.10");
  1;
};
if (!$cfg_success) {
  warn $@;
  exit 0;
}

# where to find the rpm utility

my $rpm_path = $ENV{RPM_PATH}; # this overrides

unless (defined $rpm_path) {
    for (qw(/bin/rpm /usr/bin/rpm)) {
	if (-x) {
	    $rpm_path = $_;
	    last;
	}
    }
}

defined $rpm_path or die "Can't find rpm on this system\n";

sub hexversion {
	my ($major, $minor, $micro) = (@_[0] =~ /(\d+)\.(\d+)\.?(\d+)?/);
	return int($major<<16) + int($minor<<8) + int($micro<<0);
}

my $version = `LC_ALL=C $rpm_path --version`;
# fix compiling with RCs:
$version =~ s/(-.*)|(\.DEVEL)//;
chomp $version;
$version =~ s/(RPM version )|(rpm \(RPM\) )//;
my $hversion = hexversion($version);
$hversion ge hexversion("4.13") or die "Unable to build URPM with too old (or undetected) rpm version $version\n";

my @rpmflags;
if ($hversion ge hexversion("4.13.0") && $hversion lt hexversion("5.0")) {
    # rpm.org version 4.13.0
    push @rpmflags, "-DRPM4140";
}

my $ccflags = join(' ', '-Wall -Wextra -fno-strict-aliasing', @rpmflags);

print "Found RPM version $version (compiling with flags: $ccflags)\n";

WriteMakefile(
    NAME	=> 'URPM',
    ABSTRACT_FROM => 'URPM.pm',
    AUTHOR	=> 'Thierry Vignaud',
    LICENSE     => 'perl_5',
    PREREQ_PM	=> {
	'ExtUtils::PkgConfig' => '1.00', # for finding rpm-devel
	'MDV::Packdrakeng' => '1.00', # for URPM::Build
	'Test::Pod' => '1.00',
    },
    META_MERGE => {
	'meta-spec' => { version => 2 },
        resources => {
            repository  => {
		type => 'git',
		url => 'git://git.mageia.org/software/rpm/perl-URPM/',
		web =>  'http://gitweb.mageia.org/software/rpm/perl-URPM/',
	    },
        },
	release_status => 'testing'
    },
    MIN_PERL_VERSION => '5.008001',
    CCFLAGS	=> $ccflags,
    VERSION_FROM	=> 'URPM.pm',
    LIBS	=> [ $cfg{libs}, "-lrpmbuild" ],
    INC		=> '-I/usr/include/rpm',
    dist	=> { COMPRESS => "xz -f", SUFFIX => ".xz" },
    realclean	=> { FILES => "t/RPMS/noarch/*" },
);
