use v5.20;
use strict;
use warnings;

package DevTo {
  use Zydeco;
  class Privacy {

    # Predeclaration of the accessor ref
    # https://metacpan.org/pod/MooX::Press#Attribute-Specifications
    my $hidden_attr;

    has wonder ( isa => Str );
    has hidden (
      isa => Str,
      is => private,
      accessor => \$hidden_attr );

    method $innaccessible_method {
      say "No problem acessing " . $self->wonder .
      ' through a private method';
    }

    method $innaccessible_method_attr {
      $self->$hidden_attr('a hidden place');
      say "No problem accessing a private attribute in " .
      $self->$hidden_attr;
    };

    multi method no_problem {
      $self->$innaccessible_method;
    }

    multi method no_problem( Bool *with_attr ) {
      $self->$innaccessible_method_attr;
    }
  }

  my $access = DevTo
    ->new_privacy( wonder => "a public attribute" );

  $access->no_problem;
  # ==> "No problem acessing a public attribute through a private method"
  $access->no_problem({ with_attr => true });
  # ==> "No problem accessing a private attribute in a hidden place"

  # This would fail
  # $access->$innaccessible_method;

  # Such things are not possible
  # $access->hidden_attr;
  # $access->$hidden_attr;

}
