use Test::More tests => 4;
use lib 'lib';
use Art::World;
use Faker;
use DDP;
# Should be transformed to an Art::World::Util and the dependency moved to general ones in cpanfile
use DateTimeX::Auto 'dt';

my $f = Faker->new;

my $place = Art::World->new_place( location => $f->address_city_name, name => 'A Famous Place' );
my $chat = $f->lorem_sentence;

my $opening_event = Art::World->new_opening(
  place     => $place,
  # Should be transformed to an Art::World::Util and the dependency moved to general ones in cpanfile
  datetime => dt( '2020-02-16T08:18:43' ),
  name => 'Come See Our Stuff',
  smalltalk => $chat,
  treat     => [ 'Red wine', 'White wine', 'Peanuts', 'Candies' ],
  # missing participant
 );

can_ok $opening_event, 'serve';

diag $opening_event->smalltalk;
diag $opening_event->datetime;
diag $opening_event->place->location;
diag join ', ',  $opening_event->serve;

isa_ok $opening_event, 'Art::World::Art';
ok $opening_event->does( 'Art::World::Event' );
ok $opening_event->does( 'Art::World::Event' );

# TODO Must test the Invitation role

done_testing();
