use 5.20.0;
use strict;
use warnings;

package Art::World::Util {

  use Zydeco;

  class Math {
    method pick ( Int $min, Int $max ) {
      return $min + int ( rand ( $max - $min ));
    }
  }

  class Person {
    use Faker;
    method fake_name {
      my $f = Faker->new;
      return $f->person_first_name . ' ' . $f->person_last_name;
    }
  }
}

1;

__END__

=encoding UTF-8

=head1 NAME

Art::World::Util - Generating all kind of data for the Art::World

=head1 SYNOPSIS

  use Art::World::Util;

  say Art::World::Util->new_person->fake_name;
  #==> Firtname Lastname

  say Art::World::Util->new_math->pick( 10, 1000 ));
  #==> 666

=head1 DESCRIPTION

C<Art::World::Util> provide useful generation tools for automated C<Agents>
creation.

=head2 Methods

=head3 fake_name

Generate a complete person name using L<Faker>.

=head3 pick

Pick an integer between a range that can be passed as a parameter. Mostly a way
to not have to memorize C<$min + int ( rand ( $max - $min ))>.

=head1 AUTHOR

Sébastien Feugère <sebastien@feugere.net>

=head1 COPYRIGHT AND LICENSE

Copyright 2006-2021 Sebastien Feugère

This library is free software; you can redistribute it and/or modify it under the Artistic License 2.0.
