use Test::More tests => 5;
use v5.24.1;
use Art::World;
use Faker;
use DDP;

use constant {
  INITIAL_ARTIST_REPUTATION => 1,
  INITIAL_CURATOR_REPUTATION => 100,
  INITIAL_MANAGER_REPUTATION => 200,
};

my $f = Faker->new;

my $manager = Art::World->new_director(
  id => 111, reputation => INITIAL_MANAGER_REPUTATION, name => $f->person_first_name . ' ' . $f->person_last_name );
my $artist_1 = Art::World->new_artist(
  id => 2, reputation => INITIAL_ARTIST_REPUTATION, name => $f->person_first_name . ' ' . $f->person_last_name );
my $curator_1 = Art::World->new_curator(
  id => 3, reputation => INITIAL_CURATOR_REPUTATION, name => $f->person_first_name . ' ' . $f->person_last_name );

my $peoples = [ $manager, $artist_1, $curator_1 ];

$manager->networking( $peoples );

is $manager->reputation, 220, "Check that the manager reputation wasn't increased with the super-manager-bump after networking";
is $artist_1->reputation, 126, "Artist acquired a serious reputation thanks to the influence of the institution manager";
is $curator_1->reputation, 720, "Curator acquired a serious reputation thanks to the influence of the institution manager";

my $artist_2 = Art::World->new_artist(
  id => 4, reputation => INITIAL_ARTIST_REPUTATION, name => $f->person_first_name . ' ' . $f->person_last_name );

my $bumped_reputation = $artist_2->bump_fame( $artist_1->reputation );
is $bumped_reputation, 127, "The artist got it's reputation bumped by another artist";
my $networked_reputation = $manager->influence( $artist_2->reputation );
is $networked_reputation, 635, "The manager can influence() an artist reputation";

# $manager->insert('agent', { name => 'Felis Lechat',  reputation => 666 });


done_testing;
