package Locale::LanguageCodes;

# This file was automatically generated.  Any changes to this file will
# be lost the next time 'get_codes' is run.
#    Generated on: Wed Feb 10 06:59:04 EST 2010

=pod

=head1 NAME

Locale::LanguageCodes - language codes for the Locale::Language module

=head1 SYNOPSIS

This module contains data used by the Locale::Language module. It is
not intended to be used directly, and contains no calleable routines.

=head1 AUTHOR

See Locale::Codes for full author history.

Currently maintained by Sullivan Beck (sbeck@cpan.org).

=head1 COPYRIGHT

   Copyright (c) 1997-2001 Canon Research Centre Europe (CRE).
   Copyright (c) 2001-2010 Neil Bowers
   Copyright (c) 2010-2010 Sullivan Beck

This module is free software; you can redistribute it and/or
modify it under the same terms as Perl itself.

=cut

use strict;
use warnings;
require 5.002;

use vars qw($VERSION);
$VERSION='3.00';

use vars qw(
   %Language
   %LanguageAlias
   %Code2LanguageID
   %LanguageID2Code
);

%Language = (
   q(0001) => [
      q(Afar),
      ],
   q(0002) => [
      q(Abkhazian),
      ],
   q(0003) => [
      q(Achinese),
      ],
   q(0004) => [
      q(Acoli),
      ],
   q(0005) => [
      q(Adangme),
      ],
   q(0006) => [
      q(Adyghe),
      q(Adygei),
      ],
   q(0007) => [
      q(Afro-Asiatic languages),
      ],
   q(0008) => [
      q(Afrihili),
      ],
   q(0009) => [
      q(Afrikaans),
      ],
   q(0010) => [
      q(Ainu),
      ],
   q(0011) => [
      q(Akan),
      ],
   q(0012) => [
      q(Akkadian),
      ],
   q(0013) => [
      q(Albanian),
      ],
   q(0014) => [
      q(Aleut),
      ],
   q(0015) => [
      q(Algonquian languages),
      ],
   q(0016) => [
      q(Southern Altai),
      ],
   q(0017) => [
      q(Amharic),
      ],
   q(0018) => [
      q(English, Old (ca.450-1100)),
      ],
   q(0019) => [
      q(Angika),
      ],
   q(0020) => [
      q(Apache languages),
      ],
   q(0021) => [
      q(Arabic),
      ],
   q(0022) => [
      q(Official Aramaic (700-300 BCE)),
      q(Imperial Aramaic (700-300 BCE)),
      ],
   q(0023) => [
      q(Aragonese),
      ],
   q(0024) => [
      q(Armenian),
      ],
   q(0025) => [
      q(Mapudungun),
      q(Mapuche),
      ],
   q(0026) => [
      q(Arapaho),
      ],
   q(0027) => [
      q(Artificial languages),
      ],
   q(0028) => [
      q(Arawak),
      ],
   q(0029) => [
      q(Assamese),
      ],
   q(0030) => [
      q(Asturian),
      q(Bable),
      q(Leonese),
      q(Asturleonese),
      ],
   q(0031) => [
      q(Athapascan languages),
      ],
   q(0032) => [
      q(Australian languages),
      ],
   q(0033) => [
      q(Avaric),
      ],
   q(0034) => [
      q(Avestan),
      ],
   q(0035) => [
      q(Awadhi),
      ],
   q(0036) => [
      q(Aymara),
      ],
   q(0037) => [
      q(Azerbaijani),
      ],
   q(0038) => [
      q(Banda languages),
      ],
   q(0039) => [
      q(Bamileke languages),
      ],
   q(0040) => [
      q(Bashkir),
      ],
   q(0041) => [
      q(Baluchi),
      ],
   q(0042) => [
      q(Bambara),
      ],
   q(0043) => [
      q(Balinese),
      ],
   q(0044) => [
      q(Basque),
      ],
   q(0045) => [
      q(Basa),
      ],
   q(0046) => [
      q(Baltic languages),
      ],
   q(0047) => [
      q(Beja),
      q(Bedawiyet),
      ],
   q(0048) => [
      q(Belarusian),
      ],
   q(0049) => [
      q(Bemba),
      ],
   q(0050) => [
      q(Bengali),
      ],
   q(0051) => [
      q(Berber languages),
      ],
   q(0052) => [
      q(Bhojpuri),
      ],
   q(0053) => [
      q(Bihari languages),
      ],
   q(0054) => [
      q(Bikol),
      ],
   q(0055) => [
      q(Bini),
      q(Edo),
      ],
   q(0056) => [
      q(Bislama),
      ],
   q(0057) => [
      q(Siksika),
      ],
   q(0058) => [
      q(Bantu (Other)),
      ],
   q(0059) => [
      q(Bosnian),
      ],
   q(0060) => [
      q(Braj),
      ],
   q(0061) => [
      q(Breton),
      ],
   q(0062) => [
      q(Batak languages),
      ],
   q(0063) => [
      q(Buriat),
      ],
   q(0064) => [
      q(Buginese),
      ],
   q(0065) => [
      q(Bulgarian),
      ],
   q(0066) => [
      q(Burmese),
      ],
   q(0067) => [
      q(Blin),
      q(Bilin),
      ],
   q(0068) => [
      q(Caddo),
      ],
   q(0069) => [
      q(Central American Indian languages),
      ],
   q(0070) => [
      q(Galibi Carib),
      ],
   q(0071) => [
      q(Catalan),
      q(Valencian),
      ],
   q(0072) => [
      q(Caucasian languages),
      ],
   q(0073) => [
      q(Cebuano),
      ],
   q(0074) => [
      q(Celtic languages),
      ],
   q(0075) => [
      q(Chamorro),
      ],
   q(0076) => [
      q(Chibcha),
      ],
   q(0077) => [
      q(Chechen),
      ],
   q(0078) => [
      q(Chagatai),
      ],
   q(0079) => [
      q(Chinese),
      ],
   q(0080) => [
      q(Chuukese),
      ],
   q(0081) => [
      q(Mari),
      ],
   q(0082) => [
      q(Chinook jargon),
      ],
   q(0083) => [
      q(Choctaw),
      ],
   q(0084) => [
      q(Chipewyan),
      q(Dene Suline),
      ],
   q(0085) => [
      q(Cherokee),
      ],
   q(0086) => [
      q(Church Slavic),
      q(Old Slavonic),
      q(Church Slavonic),
      q(Old Bulgarian),
      q(Old Church Slavonic),
      ],
   q(0087) => [
      q(Chuvash),
      ],
   q(0088) => [
      q(Cheyenne),
      ],
   q(0089) => [
      q(Chamic languages),
      ],
   q(0090) => [
      q(Coptic),
      ],
   q(0091) => [
      q(Cornish),
      ],
   q(0092) => [
      q(Corsican),
      ],
   q(0093) => [
      q(Creoles and pidgins, English based),
      ],
   q(0094) => [
      q(Creoles and pidgins, French-based ),
      ],
   q(0095) => [
      q(Creoles and pidgins, Portuguese-based ),
      ],
   q(0096) => [
      q(Cree),
      ],
   q(0097) => [
      q(Crimean Tatar),
      q(Crimean Turkish),
      ],
   q(0098) => [
      q(Creoles and pidgins ),
      ],
   q(0099) => [
      q(Kashubian),
      ],
   q(0100) => [
      q(Cushitic languages),
      ],
   q(0101) => [
      q(Czech),
      ],
   q(0102) => [
      q(Dakota),
      ],
   q(0103) => [
      q(Danish),
      ],
   q(0104) => [
      q(Dargwa),
      ],
   q(0105) => [
      q(Land Dayak languages),
      ],
   q(0106) => [
      q(Delaware),
      ],
   q(0107) => [
      q(Slave (Athapascan)),
      ],
   q(0108) => [
      q(Dogrib),
      ],
   q(0109) => [
      q(Dinka),
      ],
   q(0110) => [
      q(Divehi),
      q(Dhivehi),
      q(Maldivian),
      ],
   q(0111) => [
      q(Dogri),
      ],
   q(0112) => [
      q(Dravidian languages),
      ],
   q(0113) => [
      q(Lower Sorbian),
      ],
   q(0114) => [
      q(Duala),
      ],
   q(0115) => [
      q(Dutch, Middle (ca.1050-1350)),
      ],
   q(0116) => [
      q(Dutch),
      q(Flemish),
      ],
   q(0117) => [
      q(Dyula),
      ],
   q(0118) => [
      q(Dzongkha),
      ],
   q(0119) => [
      q(Efik),
      ],
   q(0120) => [
      q(Egyptian (Ancient)),
      ],
   q(0121) => [
      q(Ekajuk),
      ],
   q(0122) => [
      q(Elamite),
      ],
   q(0123) => [
      q(English),
      ],
   q(0124) => [
      q(English, Middle (1100-1500)),
      ],
   q(0125) => [
      q(Esperanto),
      ],
   q(0126) => [
      q(Estonian),
      ],
   q(0127) => [
      q(Ewe),
      ],
   q(0128) => [
      q(Ewondo),
      ],
   q(0129) => [
      q(Fang),
      ],
   q(0130) => [
      q(Faroese),
      ],
   q(0131) => [
      q(Fanti),
      ],
   q(0132) => [
      q(Fijian),
      ],
   q(0133) => [
      q(Filipino),
      q(Pilipino),
      ],
   q(0134) => [
      q(Finnish),
      ],
   q(0135) => [
      q(Finno-Ugrian languages),
      ],
   q(0136) => [
      q(Fon),
      ],
   q(0137) => [
      q(French),
      ],
   q(0138) => [
      q(French, Middle (ca.1400-1600)),
      ],
   q(0139) => [
      q(French, Old (842-ca.1400)),
      ],
   q(0140) => [
      q(Northern Frisian),
      ],
   q(0141) => [
      q(Eastern Frisian),
      ],
   q(0142) => [
      q(Western Frisian),
      ],
   q(0143) => [
      q(Fulah),
      ],
   q(0144) => [
      q(Friulian),
      ],
   q(0145) => [
      q(Ga),
      ],
   q(0146) => [
      q(Gayo),
      ],
   q(0147) => [
      q(Gbaya),
      ],
   q(0148) => [
      q(Germanic languages),
      ],
   q(0149) => [
      q(Georgian),
      ],
   q(0150) => [
      q(German),
      ],
   q(0151) => [
      q(Geez),
      ],
   q(0152) => [
      q(Gilbertese),
      ],
   q(0153) => [
      q(Gaelic),
      q(Scottish Gaelic),
      ],
   q(0154) => [
      q(Irish),
      ],
   q(0155) => [
      q(Galician),
      ],
   q(0156) => [
      q(Manx),
      ],
   q(0157) => [
      q(German, Middle High (ca.1050-1500)),
      ],
   q(0158) => [
      q(German, Old High (ca.750-1050)),
      ],
   q(0159) => [
      q(Gondi),
      ],
   q(0160) => [
      q(Gorontalo),
      ],
   q(0161) => [
      q(Gothic),
      ],
   q(0162) => [
      q(Grebo),
      ],
   q(0163) => [
      q(Greek, Ancient (to 1453)),
      ],
   q(0164) => [
      q(Greek, Modern (1453-)),
      q(Greek),
      ],
   q(0165) => [
      q(Guarani),
      ],
   q(0166) => [
      q(Swiss German),
      q(Alemannic),
      q(Alsatian),
      ],
   q(0167) => [
      q(Gujarati),
      ],
   q(0168) => [
      q(Gwich'in),
      ],
   q(0169) => [
      q(Haida),
      ],
   q(0170) => [
      q(Haitian),
      q(Haitian Creole),
      ],
   q(0171) => [
      q(Hausa),
      ],
   q(0172) => [
      q(Hawaiian),
      ],
   q(0173) => [
      q(Hebrew),
      ],
   q(0174) => [
      q(Herero),
      ],
   q(0175) => [
      q(Hiligaynon),
      ],
   q(0176) => [
      q(Himachali languages),
      q(Western Pahari languages),
      ],
   q(0177) => [
      q(Hindi),
      ],
   q(0178) => [
      q(Hittite),
      ],
   q(0179) => [
      q(Hmong),
      ],
   q(0180) => [
      q(Hiri Motu),
      ],
   q(0181) => [
      q(Croatian),
      ],
   q(0182) => [
      q(Upper Sorbian),
      ],
   q(0183) => [
      q(Hungarian),
      ],
   q(0184) => [
      q(Hupa),
      ],
   q(0185) => [
      q(Iban),
      ],
   q(0186) => [
      q(Igbo),
      ],
   q(0187) => [
      q(Icelandic),
      ],
   q(0188) => [
      q(Ido),
      ],
   q(0189) => [
      q(Sichuan Yi),
      q(Nuosu),
      ],
   q(0190) => [
      q(Ijo languages),
      ],
   q(0191) => [
      q(Inuktitut),
      ],
   q(0192) => [
      q(Interlingue),
      q(Occidental),
      ],
   q(0193) => [
      q(Iloko),
      ],
   q(0194) => [
      q(Interlingua (International Auxiliary Language Association)),
      ],
   q(0195) => [
      q(Indic languages),
      ],
   q(0196) => [
      q(Indonesian),
      ],
   q(0197) => [
      q(Indo-European languages),
      ],
   q(0198) => [
      q(Ingush),
      ],
   q(0199) => [
      q(Inupiaq),
      ],
   q(0200) => [
      q(Iranian languages),
      ],
   q(0201) => [
      q(Iroquoian languages),
      ],
   q(0202) => [
      q(Italian),
      ],
   q(0203) => [
      q(Javanese),
      ],
   q(0204) => [
      q(Lojban),
      ],
   q(0205) => [
      q(Japanese),
      ],
   q(0206) => [
      q(Judeo-Persian),
      ],
   q(0207) => [
      q(Judeo-Arabic),
      ],
   q(0208) => [
      q(Kara-Kalpak),
      ],
   q(0209) => [
      q(Kabyle),
      ],
   q(0210) => [
      q(Kachin),
      q(Jingpho),
      ],
   q(0211) => [
      q(Kalaallisut),
      q(Greenlandic),
      ],
   q(0212) => [
      q(Kamba),
      ],
   q(0213) => [
      q(Kannada),
      ],
   q(0214) => [
      q(Karen languages),
      ],
   q(0215) => [
      q(Kashmiri),
      ],
   q(0216) => [
      q(Kanuri),
      ],
   q(0217) => [
      q(Kawi),
      ],
   q(0218) => [
      q(Kazakh),
      ],
   q(0219) => [
      q(Kabardian),
      ],
   q(0220) => [
      q(Khasi),
      ],
   q(0221) => [
      q(Khoisan languages),
      ],
   q(0222) => [
      q(Central Khmer),
      ],
   q(0223) => [
      q(Khotanese),
      q(Sakan),
      ],
   q(0224) => [
      q(Kikuyu),
      q(Gikuyu),
      ],
   q(0225) => [
      q(Kinyarwanda),
      ],
   q(0226) => [
      q(Kirghiz),
      q(Kyrgyz),
      ],
   q(0227) => [
      q(Kimbundu),
      ],
   q(0228) => [
      q(Konkani),
      ],
   q(0229) => [
      q(Komi),
      ],
   q(0230) => [
      q(Kongo),
      ],
   q(0231) => [
      q(Korean),
      ],
   q(0232) => [
      q(Kosraean),
      ],
   q(0233) => [
      q(Kpelle),
      ],
   q(0234) => [
      q(Karachay-Balkar),
      ],
   q(0235) => [
      q(Karelian),
      ],
   q(0236) => [
      q(Kru languages),
      ],
   q(0237) => [
      q(Kurukh),
      ],
   q(0238) => [
      q(Kuanyama),
      q(Kwanyama),
      ],
   q(0239) => [
      q(Kumyk),
      ],
   q(0240) => [
      q(Kurdish),
      ],
   q(0241) => [
      q(Kutenai),
      ],
   q(0242) => [
      q(Ladino),
      ],
   q(0243) => [
      q(Lahnda),
      ],
   q(0244) => [
      q(Lamba),
      ],
   q(0245) => [
      q(Lao),
      ],
   q(0246) => [
      q(Latin),
      ],
   q(0247) => [
      q(Latvian),
      ],
   q(0248) => [
      q(Lezghian),
      ],
   q(0249) => [
      q(Limburgan),
      q(Limburger),
      q(Limburgish),
      ],
   q(0250) => [
      q(Lingala),
      ],
   q(0251) => [
      q(Lithuanian),
      ],
   q(0252) => [
      q(Mongo),
      ],
   q(0253) => [
      q(Lozi),
      ],
   q(0254) => [
      q(Luxembourgish),
      q(Letzeburgesch),
      ],
   q(0255) => [
      q(Luba-Lulua),
      ],
   q(0256) => [
      q(Luba-Katanga),
      ],
   q(0257) => [
      q(Ganda),
      ],
   q(0258) => [
      q(Luiseno),
      ],
   q(0259) => [
      q(Lunda),
      ],
   q(0260) => [
      q(Luo (Kenya and Tanzania)),
      ],
   q(0261) => [
      q(Lushai),
      ],
   q(0262) => [
      q(Macedonian),
      ],
   q(0263) => [
      q(Madurese),
      ],
   q(0264) => [
      q(Magahi),
      ],
   q(0265) => [
      q(Marshallese),
      ],
   q(0266) => [
      q(Maithili),
      ],
   q(0267) => [
      q(Makasar),
      ],
   q(0268) => [
      q(Malayalam),
      ],
   q(0269) => [
      q(Mandingo),
      ],
   q(0270) => [
      q(Maori),
      ],
   q(0271) => [
      q(Austronesian languages),
      ],
   q(0272) => [
      q(Marathi),
      ],
   q(0273) => [
      q(Masai),
      ],
   q(0274) => [
      q(Malay),
      ],
   q(0275) => [
      q(Moksha),
      ],
   q(0276) => [
      q(Mandar),
      ],
   q(0277) => [
      q(Mende),
      ],
   q(0278) => [
      q(Irish, Middle (900-1200)),
      ],
   q(0279) => [
      q(Mi'kmaq),
      q(Micmac),
      ],
   q(0280) => [
      q(Minangkabau),
      ],
   q(0281) => [
      q(Uncoded languages),
      ],
   q(0282) => [
      q(Mon-Khmer languages),
      ],
   q(0283) => [
      q(Malagasy),
      ],
   q(0284) => [
      q(Maltese),
      ],
   q(0285) => [
      q(Manchu),
      ],
   q(0286) => [
      q(Manipuri),
      ],
   q(0287) => [
      q(Manobo languages),
      ],
   q(0288) => [
      q(Mohawk),
      ],
   q(0289) => [
      q(Mongolian),
      ],
   q(0290) => [
      q(Mossi),
      ],
   q(0291) => [
      q(Multiple languages),
      ],
   q(0292) => [
      q(Munda languages),
      ],
   q(0293) => [
      q(Creek),
      ],
   q(0294) => [
      q(Mirandese),
      ],
   q(0295) => [
      q(Marwari),
      ],
   q(0296) => [
      q(Mayan languages),
      ],
   q(0297) => [
      q(Erzya),
      ],
   q(0298) => [
      q(Nahuatl languages),
      ],
   q(0299) => [
      q(North American Indian languages),
      ],
   q(0300) => [
      q(Neapolitan),
      ],
   q(0301) => [
      q(Nauru),
      ],
   q(0302) => [
      q(Navajo),
      q(Navaho),
      ],
   q(0303) => [
      q(Ndebele, South),
      q(South Ndebele),
      ],
   q(0304) => [
      q(Ndebele, North),
      q(North Ndebele),
      ],
   q(0305) => [
      q(Ndonga),
      ],
   q(0306) => [
      q(Low German),
      q(Low Saxon),
      q(German, Low),
      q(Saxon, Low),
      ],
   q(0307) => [
      q(Nepali),
      ],
   q(0308) => [
      q(Nepal Bhasa),
      q(Newari),
      ],
   q(0309) => [
      q(Nias),
      ],
   q(0310) => [
      q(Niger-Kordofanian languages),
      ],
   q(0311) => [
      q(Niuean),
      ],
   q(0312) => [
      q(Norwegian Nynorsk),
      q(Nynorsk, Norwegian),
      ],
   q(0313) => [
      q(Bokmal, Norwegian),
      q(Norwegian Bokmal),
      ],
   q(0314) => [
      q(Nogai),
      ],
   q(0315) => [
      q(Norse, Old),
      ],
   q(0316) => [
      q(Norwegian),
      ],
   q(0317) => [
      q(N'Ko),
      ],
   q(0318) => [
      q(Pedi),
      q(Sepedi),
      q(Northern Sotho),
      ],
   q(0319) => [
      q(Nubian languages),
      ],
   q(0320) => [
      q(Classical Newari),
      q(Old Newari),
      q(Classical Nepal Bhasa),
      ],
   q(0321) => [
      q(Chichewa),
      q(Chewa),
      q(Nyanja),
      ],
   q(0322) => [
      q(Nyamwezi),
      ],
   q(0323) => [
      q(Nyankole),
      ],
   q(0324) => [
      q(Nyoro),
      ],
   q(0325) => [
      q(Nzima),
      ],
   q(0326) => [
      q(Occitan (post 1500)),
      q(Provencal),
      ],
   q(0327) => [
      q(Ojibwa),
      ],
   q(0328) => [
      q(Oriya),
      ],
   q(0329) => [
      q(Oromo),
      ],
   q(0330) => [
      q(Osage),
      ],
   q(0331) => [
      q(Ossetian),
      q(Ossetic),
      ],
   q(0332) => [
      q(Turkish, Ottoman (1500-1928)),
      ],
   q(0333) => [
      q(Otomian languages),
      ],
   q(0334) => [
      q(Papuan languages),
      ],
   q(0335) => [
      q(Pangasinan),
      ],
   q(0336) => [
      q(Pahlavi),
      ],
   q(0337) => [
      q(Pampanga),
      q(Kapampangan),
      ],
   q(0338) => [
      q(Panjabi),
      q(Punjabi),
      ],
   q(0339) => [
      q(Papiamento),
      ],
   q(0340) => [
      q(Palauan),
      ],
   q(0341) => [
      q(Persian, Old (ca.600-400 B.C.)),
      ],
   q(0342) => [
      q(Persian),
      ],
   q(0343) => [
      q(Philippine languages),
      ],
   q(0344) => [
      q(Phoenician),
      ],
   q(0345) => [
      q(Pali),
      ],
   q(0346) => [
      q(Polish),
      ],
   q(0347) => [
      q(Pohnpeian),
      ],
   q(0348) => [
      q(Portuguese),
      ],
   q(0349) => [
      q(Prakrit languages),
      ],
   q(0350) => [
      q(Provencal, Old (to 1500)),
      ],
   q(0351) => [
      q(Pushto),
      q(Pashto),
      ],
   q(0352) => [
      q(Reserved for local use),
      ],
   q(0353) => [
      q(Quechua),
      ],
   q(0354) => [
      q(Rajasthani),
      ],
   q(0355) => [
      q(Rapanui),
      ],
   q(0356) => [
      q(Rarotongan),
      q(Cook Islands Maori),
      ],
   q(0357) => [
      q(Romance languages),
      ],
   q(0358) => [
      q(Romansh),
      ],
   q(0359) => [
      q(Romany),
      ],
   q(0360) => [
      q(Romanian),
      q(Moldavian),
      q(Moldovan),
      ],
   q(0361) => [
      q(Rundi),
      ],
   q(0362) => [
      q(Aromanian),
      q(Arumanian),
      q(Macedo-Romanian),
      ],
   q(0363) => [
      q(Russian),
      ],
   q(0364) => [
      q(Sandawe),
      ],
   q(0365) => [
      q(Sango),
      ],
   q(0366) => [
      q(Yakut),
      ],
   q(0367) => [
      q(South American Indian (Other)),
      ],
   q(0368) => [
      q(Salishan languages),
      ],
   q(0369) => [
      q(Samaritan Aramaic),
      ],
   q(0370) => [
      q(Sanskrit),
      ],
   q(0371) => [
      q(Sasak),
      ],
   q(0372) => [
      q(Santali),
      ],
   q(0373) => [
      q(Sicilian),
      ],
   q(0374) => [
      q(Scots),
      ],
   q(0375) => [
      q(Selkup),
      ],
   q(0376) => [
      q(Semitic languages),
      ],
   q(0377) => [
      q(Irish, Old (to 900)),
      ],
   q(0378) => [
      q(Sign Languages),
      ],
   q(0379) => [
      q(Shan),
      ],
   q(0380) => [
      q(Sidamo),
      ],
   q(0381) => [
      q(Sinhala),
      q(Sinhalese),
      ],
   q(0382) => [
      q(Siouan languages),
      ],
   q(0383) => [
      q(Sino-Tibetan languages),
      ],
   q(0384) => [
      q(Slavic languages),
      ],
   q(0385) => [
      q(Slovak),
      ],
   q(0386) => [
      q(Slovenian),
      ],
   q(0387) => [
      q(Southern Sami),
      ],
   q(0388) => [
      q(Northern Sami),
      ],
   q(0389) => [
      q(Sami languages),
      ],
   q(0390) => [
      q(Lule Sami),
      ],
   q(0391) => [
      q(Inari Sami),
      ],
   q(0392) => [
      q(Samoan),
      ],
   q(0393) => [
      q(Skolt Sami),
      ],
   q(0394) => [
      q(Shona),
      ],
   q(0395) => [
      q(Sindhi),
      ],
   q(0396) => [
      q(Soninke),
      ],
   q(0397) => [
      q(Sogdian),
      ],
   q(0398) => [
      q(Somali),
      ],
   q(0399) => [
      q(Songhai languages),
      ],
   q(0400) => [
      q(Sotho, Southern),
      ],
   q(0401) => [
      q(Spanish),
      q(Castilian),
      ],
   q(0402) => [
      q(Sardinian),
      ],
   q(0403) => [
      q(Sranan Tongo),
      ],
   q(0404) => [
      q(Serbian),
      ],
   q(0405) => [
      q(Serer),
      ],
   q(0406) => [
      q(Nilo-Saharan languages),
      ],
   q(0407) => [
      q(Swati),
      ],
   q(0408) => [
      q(Sukuma),
      ],
   q(0409) => [
      q(Sundanese),
      ],
   q(0410) => [
      q(Susu),
      ],
   q(0411) => [
      q(Sumerian),
      ],
   q(0412) => [
      q(Swahili),
      ],
   q(0413) => [
      q(Swedish),
      ],
   q(0414) => [
      q(Classical Syriac),
      ],
   q(0415) => [
      q(Syriac),
      ],
   q(0416) => [
      q(Tahitian),
      ],
   q(0417) => [
      q(Tai languages),
      ],
   q(0418) => [
      q(Tamil),
      ],
   q(0419) => [
      q(Tatar),
      ],
   q(0420) => [
      q(Telugu),
      ],
   q(0421) => [
      q(Timne),
      ],
   q(0422) => [
      q(Tereno),
      ],
   q(0423) => [
      q(Tetum),
      ],
   q(0424) => [
      q(Tajik),
      ],
   q(0425) => [
      q(Tagalog),
      ],
   q(0426) => [
      q(Thai),
      ],
   q(0427) => [
      q(Tibetan),
      ],
   q(0428) => [
      q(Tigre),
      ],
   q(0429) => [
      q(Tigrinya),
      ],
   q(0430) => [
      q(Tiv),
      ],
   q(0431) => [
      q(Tokelau),
      ],
   q(0432) => [
      q(Klingon),
      q(tlhIngan-Hol),
      ],
   q(0433) => [
      q(Tlingit),
      ],
   q(0434) => [
      q(Tamashek),
      ],
   q(0435) => [
      q(Tonga (Nyasa)),
      ],
   q(0436) => [
      q(Tonga (Tonga Islands)),
      q(Tonga),
      ],
   q(0437) => [
      q(Tok Pisin),
      ],
   q(0438) => [
      q(Tsimshian),
      ],
   q(0439) => [
      q(Tswana),
      ],
   q(0440) => [
      q(Tsonga),
      ],
   q(0441) => [
      q(Turkmen),
      ],
   q(0442) => [
      q(Tumbuka),
      ],
   q(0443) => [
      q(Tupi languages),
      ],
   q(0444) => [
      q(Turkish),
      ],
   q(0445) => [
      q(Altaic languages),
      ],
   q(0446) => [
      q(Tuvalu),
      ],
   q(0447) => [
      q(Twi),
      ],
   q(0448) => [
      q(Tuvinian),
      ],
   q(0449) => [
      q(Udmurt),
      ],
   q(0450) => [
      q(Ugaritic),
      ],
   q(0451) => [
      q(Uighur),
      q(Uyghur),
      ],
   q(0452) => [
      q(Ukrainian),
      ],
   q(0453) => [
      q(Umbundu),
      ],
   q(0454) => [
      q(Undetermined),
      ],
   q(0455) => [
      q(Urdu),
      ],
   q(0456) => [
      q(Uzbek),
      ],
   q(0457) => [
      q(Vai),
      ],
   q(0458) => [
      q(Venda),
      ],
   q(0459) => [
      q(Vietnamese),
      ],
   q(0460) => [
      q(Volapuk),
      ],
   q(0461) => [
      q(Votic),
      ],
   q(0462) => [
      q(Wakashan languages),
      ],
   q(0463) => [
      q(Walamo),
      ],
   q(0464) => [
      q(Waray),
      ],
   q(0465) => [
      q(Washo),
      ],
   q(0466) => [
      q(Welsh),
      ],
   q(0467) => [
      q(Sorbian languages),
      ],
   q(0468) => [
      q(Walloon),
      ],
   q(0469) => [
      q(Wolof),
      ],
   q(0470) => [
      q(Kalmyk),
      q(Oirat),
      ],
   q(0471) => [
      q(Xhosa),
      ],
   q(0472) => [
      q(Yao),
      ],
   q(0473) => [
      q(Yapese),
      ],
   q(0474) => [
      q(Yiddish),
      ],
   q(0475) => [
      q(Yoruba),
      ],
   q(0476) => [
      q(Yupik languages),
      ],
   q(0477) => [
      q(Zapotec),
      ],
   q(0478) => [
      q(Blissymbols),
      q(Blissymbolics),
      q(Bliss),
      ],
   q(0479) => [
      q(Zenaga),
      ],
   q(0480) => [
      q(Zhuang),
      q(Chuang),
      ],
   q(0481) => [
      q(Zande languages),
      ],
   q(0482) => [
      q(Zulu),
      ],
   q(0483) => [
      q(Zuni),
      ],
   q(0484) => [
      q(No linguistic content),
      q(Not applicable),
      ],
   q(0485) => [
      q(Zaza),
      q(Dimili),
      q(Dimli),
      q(Kirdki),
      q(Kirmanjki),
      q(Zazaki),
      ],
);

%LanguageAlias = (
   q(abkhazian) => q(0002),
   q(achinese) => q(0003),
   q(acoli) => q(0004),
   q(adangme) => q(0005),
   q(adygei) => q(0006),
   q(adyghe) => q(0006),
   q(afar) => q(0001),
   q(afrihili) => q(0008),
   q(afrikaans) => q(0009),
   q(afro-asiatic languages) => q(0007),
   q(ainu) => q(0010),
   q(akan) => q(0011),
   q(akkadian) => q(0012),
   q(albanian) => q(0013),
   q(alemannic) => q(0166),
   q(aleut) => q(0014),
   q(algonquian languages) => q(0015),
   q(alsatian) => q(0166),
   q(altaic languages) => q(0445),
   q(amharic) => q(0017),
   q(angika) => q(0019),
   q(apache languages) => q(0020),
   q(arabic) => q(0021),
   q(aragonese) => q(0023),
   q(arapaho) => q(0026),
   q(arawak) => q(0028),
   q(armenian) => q(0024),
   q(aromanian) => q(0362),
   q(artificial languages) => q(0027),
   q(arumanian) => q(0362),
   q(assamese) => q(0029),
   q(asturian) => q(0030),
   q(asturleonese) => q(0030),
   q(athapascan languages) => q(0031),
   q(australian languages) => q(0032),
   q(austronesian languages) => q(0271),
   q(avaric) => q(0033),
   q(avestan) => q(0034),
   q(awadhi) => q(0035),
   q(aymara) => q(0036),
   q(azerbaijani) => q(0037),
   q(bable) => q(0030),
   q(balinese) => q(0043),
   q(baltic languages) => q(0046),
   q(baluchi) => q(0041),
   q(bambara) => q(0042),
   q(bamileke languages) => q(0039),
   q(banda languages) => q(0038),
   q(bantu (other)) => q(0058),
   q(basa) => q(0045),
   q(bashkir) => q(0040),
   q(basque) => q(0044),
   q(batak languages) => q(0062),
   q(bedawiyet) => q(0047),
   q(beja) => q(0047),
   q(belarusian) => q(0048),
   q(bemba) => q(0049),
   q(bengali) => q(0050),
   q(berber languages) => q(0051),
   q(bhojpuri) => q(0052),
   q(bihari languages) => q(0053),
   q(bikol) => q(0054),
   q(bilin) => q(0067),
   q(bini) => q(0055),
   q(bislama) => q(0056),
   q(blin) => q(0067),
   q(bliss) => q(0478),
   q(blissymbolics) => q(0478),
   q(blissymbols) => q(0478),
   q(bokmal, norwegian) => q(0313),
   q(bosnian) => q(0059),
   q(braj) => q(0060),
   q(breton) => q(0061),
   q(buginese) => q(0064),
   q(bulgarian) => q(0065),
   q(buriat) => q(0063),
   q(burmese) => q(0066),
   q(caddo) => q(0068),
   q(castilian) => q(0401),
   q(catalan) => q(0071),
   q(caucasian languages) => q(0072),
   q(cebuano) => q(0073),
   q(celtic languages) => q(0074),
   q(central american indian languages) => q(0069),
   q(central khmer) => q(0222),
   q(chagatai) => q(0078),
   q(chamic languages) => q(0089),
   q(chamorro) => q(0075),
   q(chechen) => q(0077),
   q(cherokee) => q(0085),
   q(chewa) => q(0321),
   q(cheyenne) => q(0088),
   q(chibcha) => q(0076),
   q(chichewa) => q(0321),
   q(chinese) => q(0079),
   q(chinook jargon) => q(0082),
   q(chipewyan) => q(0084),
   q(choctaw) => q(0083),
   q(chuang) => q(0480),
   q(church slavic) => q(0086),
   q(church slavonic) => q(0086),
   q(chuukese) => q(0080),
   q(chuvash) => q(0087),
   q(classical nepal bhasa) => q(0320),
   q(classical newari) => q(0320),
   q(classical syriac) => q(0414),
   q(cook islands maori) => q(0356),
   q(coptic) => q(0090),
   q(cornish) => q(0091),
   q(corsican) => q(0092),
   q(cree) => q(0096),
   q(creek) => q(0293),
   q(creoles and pidgins ) => q(0098),
   q(creoles and pidgins, english based) => q(0093),
   q(creoles and pidgins, french-based ) => q(0094),
   q(creoles and pidgins, portuguese-based ) => q(0095),
   q(crimean tatar) => q(0097),
   q(crimean turkish) => q(0097),
   q(croatian) => q(0181),
   q(cushitic languages) => q(0100),
   q(czech) => q(0101),
   q(dakota) => q(0102),
   q(danish) => q(0103),
   q(dargwa) => q(0104),
   q(delaware) => q(0106),
   q(dene suline) => q(0084),
   q(dhivehi) => q(0110),
   q(dimili) => q(0485),
   q(dimli) => q(0485),
   q(dinka) => q(0109),
   q(divehi) => q(0110),
   q(dogri) => q(0111),
   q(dogrib) => q(0108),
   q(dravidian languages) => q(0112),
   q(duala) => q(0114),
   q(dutch) => q(0116),
   q(dutch, middle (ca.1050-1350)) => q(0115),
   q(dyula) => q(0117),
   q(dzongkha) => q(0118),
   q(eastern frisian) => q(0141),
   q(edo) => q(0055),
   q(efik) => q(0119),
   q(egyptian (ancient)) => q(0120),
   q(ekajuk) => q(0121),
   q(elamite) => q(0122),
   q(english) => q(0123),
   q(english, middle (1100-1500)) => q(0124),
   q(english, old (ca.450-1100)) => q(0018),
   q(erzya) => q(0297),
   q(esperanto) => q(0125),
   q(estonian) => q(0126),
   q(ewe) => q(0127),
   q(ewondo) => q(0128),
   q(fang) => q(0129),
   q(fanti) => q(0131),
   q(faroese) => q(0130),
   q(fijian) => q(0132),
   q(filipino) => q(0133),
   q(finnish) => q(0134),
   q(finno-ugrian languages) => q(0135),
   q(flemish) => q(0116),
   q(fon) => q(0136),
   q(french) => q(0137),
   q(french, middle (ca.1400-1600)) => q(0138),
   q(french, old (842-ca.1400)) => q(0139),
   q(friulian) => q(0144),
   q(fulah) => q(0143),
   q(ga) => q(0145),
   q(gaelic) => q(0153),
   q(galibi carib) => q(0070),
   q(galician) => q(0155),
   q(ganda) => q(0257),
   q(gayo) => q(0146),
   q(gbaya) => q(0147),
   q(geez) => q(0151),
   q(georgian) => q(0149),
   q(german) => q(0150),
   q(german, low) => q(0306),
   q(german, middle high (ca.1050-1500)) => q(0157),
   q(german, old high (ca.750-1050)) => q(0158),
   q(germanic languages) => q(0148),
   q(gikuyu) => q(0224),
   q(gilbertese) => q(0152),
   q(gondi) => q(0159),
   q(gorontalo) => q(0160),
   q(gothic) => q(0161),
   q(grebo) => q(0162),
   q(greek) => q(0164),
   q(greek, ancient (to 1453)) => q(0163),
   q(greek, modern (1453-)) => q(0164),
   q(greenlandic) => q(0211),
   q(guarani) => q(0165),
   q(gujarati) => q(0167),
   q(gwich'in) => q(0168),
   q(haida) => q(0169),
   q(haitian) => q(0170),
   q(haitian creole) => q(0170),
   q(hausa) => q(0171),
   q(hawaiian) => q(0172),
   q(hebrew) => q(0173),
   q(herero) => q(0174),
   q(hiligaynon) => q(0175),
   q(himachali languages) => q(0176),
   q(hindi) => q(0177),
   q(hiri motu) => q(0180),
   q(hittite) => q(0178),
   q(hmong) => q(0179),
   q(hungarian) => q(0183),
   q(hupa) => q(0184),
   q(iban) => q(0185),
   q(icelandic) => q(0187),
   q(ido) => q(0188),
   q(igbo) => q(0186),
   q(ijo languages) => q(0190),
   q(iloko) => q(0193),
   q(imperial aramaic (700-300 bce)) => q(0022),
   q(inari sami) => q(0391),
   q(indic languages) => q(0195),
   q(indo-european languages) => q(0197),
   q(indonesian) => q(0196),
   q(ingush) => q(0198),
   q(interlingua (international auxiliary language association)) => q(0194),
   q(interlingue) => q(0192),
   q(inuktitut) => q(0191),
   q(inupiaq) => q(0199),
   q(iranian languages) => q(0200),
   q(irish) => q(0154),
   q(irish, middle (900-1200)) => q(0278),
   q(irish, old (to 900)) => q(0377),
   q(iroquoian languages) => q(0201),
   q(italian) => q(0202),
   q(japanese) => q(0205),
   q(javanese) => q(0203),
   q(jingpho) => q(0210),
   q(judeo-arabic) => q(0207),
   q(judeo-persian) => q(0206),
   q(kabardian) => q(0219),
   q(kabyle) => q(0209),
   q(kachin) => q(0210),
   q(kalaallisut) => q(0211),
   q(kalmyk) => q(0470),
   q(kamba) => q(0212),
   q(kannada) => q(0213),
   q(kanuri) => q(0216),
   q(kapampangan) => q(0337),
   q(kara-kalpak) => q(0208),
   q(karachay-balkar) => q(0234),
   q(karelian) => q(0235),
   q(karen languages) => q(0214),
   q(kashmiri) => q(0215),
   q(kashubian) => q(0099),
   q(kawi) => q(0217),
   q(kazakh) => q(0218),
   q(khasi) => q(0220),
   q(khoisan languages) => q(0221),
   q(khotanese) => q(0223),
   q(kikuyu) => q(0224),
   q(kimbundu) => q(0227),
   q(kinyarwanda) => q(0225),
   q(kirdki) => q(0485),
   q(kirghiz) => q(0226),
   q(kirmanjki) => q(0485),
   q(klingon) => q(0432),
   q(komi) => q(0229),
   q(kongo) => q(0230),
   q(konkani) => q(0228),
   q(korean) => q(0231),
   q(kosraean) => q(0232),
   q(kpelle) => q(0233),
   q(kru languages) => q(0236),
   q(kuanyama) => q(0238),
   q(kumyk) => q(0239),
   q(kurdish) => q(0240),
   q(kurukh) => q(0237),
   q(kutenai) => q(0241),
   q(kwanyama) => q(0238),
   q(kyrgyz) => q(0226),
   q(ladino) => q(0242),
   q(lahnda) => q(0243),
   q(lamba) => q(0244),
   q(land dayak languages) => q(0105),
   q(lao) => q(0245),
   q(latin) => q(0246),
   q(latvian) => q(0247),
   q(leonese) => q(0030),
   q(letzeburgesch) => q(0254),
   q(lezghian) => q(0248),
   q(limburgan) => q(0249),
   q(limburger) => q(0249),
   q(limburgish) => q(0249),
   q(lingala) => q(0250),
   q(lithuanian) => q(0251),
   q(lojban) => q(0204),
   q(low german) => q(0306),
   q(low saxon) => q(0306),
   q(lower sorbian) => q(0113),
   q(lozi) => q(0253),
   q(luba-katanga) => q(0256),
   q(luba-lulua) => q(0255),
   q(luiseno) => q(0258),
   q(lule sami) => q(0390),
   q(lunda) => q(0259),
   q(luo (kenya and tanzania)) => q(0260),
   q(lushai) => q(0261),
   q(luxembourgish) => q(0254),
   q(macedo-romanian) => q(0362),
   q(macedonian) => q(0262),
   q(madurese) => q(0263),
   q(magahi) => q(0264),
   q(maithili) => q(0266),
   q(makasar) => q(0267),
   q(malagasy) => q(0283),
   q(malay) => q(0274),
   q(malayalam) => q(0268),
   q(maldivian) => q(0110),
   q(maltese) => q(0284),
   q(manchu) => q(0285),
   q(mandar) => q(0276),
   q(mandingo) => q(0269),
   q(manipuri) => q(0286),
   q(manobo languages) => q(0287),
   q(manx) => q(0156),
   q(maori) => q(0270),
   q(mapuche) => q(0025),
   q(mapudungun) => q(0025),
   q(marathi) => q(0272),
   q(mari) => q(0081),
   q(marshallese) => q(0265),
   q(marwari) => q(0295),
   q(masai) => q(0273),
   q(mayan languages) => q(0296),
   q(mende) => q(0277),
   q(mi'kmaq) => q(0279),
   q(micmac) => q(0279),
   q(minangkabau) => q(0280),
   q(mirandese) => q(0294),
   q(mohawk) => q(0288),
   q(moksha) => q(0275),
   q(moldavian) => q(0360),
   q(moldovan) => q(0360),
   q(mon-khmer languages) => q(0282),
   q(mongo) => q(0252),
   q(mongolian) => q(0289),
   q(mossi) => q(0290),
   q(multiple languages) => q(0291),
   q(munda languages) => q(0292),
   q(n'ko) => q(0317),
   q(nahuatl languages) => q(0298),
   q(nauru) => q(0301),
   q(navaho) => q(0302),
   q(navajo) => q(0302),
   q(ndebele, north) => q(0304),
   q(ndebele, south) => q(0303),
   q(ndonga) => q(0305),
   q(neapolitan) => q(0300),
   q(nepal bhasa) => q(0308),
   q(nepali) => q(0307),
   q(newari) => q(0308),
   q(nias) => q(0309),
   q(niger-kordofanian languages) => q(0310),
   q(nilo-saharan languages) => q(0406),
   q(niuean) => q(0311),
   q(no linguistic content) => q(0484),
   q(nogai) => q(0314),
   q(norse, old) => q(0315),
   q(north american indian languages) => q(0299),
   q(north ndebele) => q(0304),
   q(northern frisian) => q(0140),
   q(northern sami) => q(0388),
   q(northern sotho) => q(0318),
   q(norwegian) => q(0316),
   q(norwegian bokmal) => q(0313),
   q(norwegian nynorsk) => q(0312),
   q(not applicable) => q(0484),
   q(nubian languages) => q(0319),
   q(nuosu) => q(0189),
   q(nyamwezi) => q(0322),
   q(nyanja) => q(0321),
   q(nyankole) => q(0323),
   q(nynorsk, norwegian) => q(0312),
   q(nyoro) => q(0324),
   q(nzima) => q(0325),
   q(occidental) => q(0192),
   q(occitan (post 1500)) => q(0326),
   q(official aramaic (700-300 bce)) => q(0022),
   q(oirat) => q(0470),
   q(ojibwa) => q(0327),
   q(old bulgarian) => q(0086),
   q(old church slavonic) => q(0086),
   q(old newari) => q(0320),
   q(old slavonic) => q(0086),
   q(oriya) => q(0328),
   q(oromo) => q(0329),
   q(osage) => q(0330),
   q(ossetian) => q(0331),
   q(ossetic) => q(0331),
   q(otomian languages) => q(0333),
   q(pahlavi) => q(0336),
   q(palauan) => q(0340),
   q(pali) => q(0345),
   q(pampanga) => q(0337),
   q(pangasinan) => q(0335),
   q(panjabi) => q(0338),
   q(papiamento) => q(0339),
   q(papuan languages) => q(0334),
   q(pashto) => q(0351),
   q(pedi) => q(0318),
   q(persian) => q(0342),
   q(persian, old (ca.600-400 b.c.)) => q(0341),
   q(philippine languages) => q(0343),
   q(phoenician) => q(0344),
   q(pilipino) => q(0133),
   q(pohnpeian) => q(0347),
   q(polish) => q(0346),
   q(portuguese) => q(0348),
   q(prakrit languages) => q(0349),
   q(provencal) => q(0326),
   q(provencal, old (to 1500)) => q(0350),
   q(punjabi) => q(0338),
   q(pushto) => q(0351),
   q(quechua) => q(0353),
   q(rajasthani) => q(0354),
   q(rapanui) => q(0355),
   q(rarotongan) => q(0356),
   q(reserved for local use) => q(0352),
   q(romance languages) => q(0357),
   q(romanian) => q(0360),
   q(romansh) => q(0358),
   q(romany) => q(0359),
   q(rundi) => q(0361),
   q(russian) => q(0363),
   q(sakan) => q(0223),
   q(salishan languages) => q(0368),
   q(samaritan aramaic) => q(0369),
   q(sami languages) => q(0389),
   q(samoan) => q(0392),
   q(sandawe) => q(0364),
   q(sango) => q(0365),
   q(sanskrit) => q(0370),
   q(santali) => q(0372),
   q(sardinian) => q(0402),
   q(sasak) => q(0371),
   q(saxon, low) => q(0306),
   q(scots) => q(0374),
   q(scottish gaelic) => q(0153),
   q(selkup) => q(0375),
   q(semitic languages) => q(0376),
   q(sepedi) => q(0318),
   q(serbian) => q(0404),
   q(serer) => q(0405),
   q(shan) => q(0379),
   q(shona) => q(0394),
   q(sichuan yi) => q(0189),
   q(sicilian) => q(0373),
   q(sidamo) => q(0380),
   q(sign languages) => q(0378),
   q(siksika) => q(0057),
   q(sindhi) => q(0395),
   q(sinhala) => q(0381),
   q(sinhalese) => q(0381),
   q(sino-tibetan languages) => q(0383),
   q(siouan languages) => q(0382),
   q(skolt sami) => q(0393),
   q(slave (athapascan)) => q(0107),
   q(slavic languages) => q(0384),
   q(slovak) => q(0385),
   q(slovenian) => q(0386),
   q(sogdian) => q(0397),
   q(somali) => q(0398),
   q(songhai languages) => q(0399),
   q(soninke) => q(0396),
   q(sorbian languages) => q(0467),
   q(sotho, southern) => q(0400),
   q(south american indian (other)) => q(0367),
   q(south ndebele) => q(0303),
   q(southern altai) => q(0016),
   q(southern sami) => q(0387),
   q(spanish) => q(0401),
   q(sranan tongo) => q(0403),
   q(sukuma) => q(0408),
   q(sumerian) => q(0411),
   q(sundanese) => q(0409),
   q(susu) => q(0410),
   q(swahili) => q(0412),
   q(swati) => q(0407),
   q(swedish) => q(0413),
   q(swiss german) => q(0166),
   q(syriac) => q(0415),
   q(tagalog) => q(0425),
   q(tahitian) => q(0416),
   q(tai languages) => q(0417),
   q(tajik) => q(0424),
   q(tamashek) => q(0434),
   q(tamil) => q(0418),
   q(tatar) => q(0419),
   q(telugu) => q(0420),
   q(tereno) => q(0422),
   q(tetum) => q(0423),
   q(thai) => q(0426),
   q(tibetan) => q(0427),
   q(tigre) => q(0428),
   q(tigrinya) => q(0429),
   q(timne) => q(0421),
   q(tiv) => q(0430),
   q(tlhingan-hol) => q(0432),
   q(tlingit) => q(0433),
   q(tok pisin) => q(0437),
   q(tokelau) => q(0431),
   q(tonga) => q(0436),
   q(tonga (nyasa)) => q(0435),
   q(tonga (tonga islands)) => q(0436),
   q(tsimshian) => q(0438),
   q(tsonga) => q(0440),
   q(tswana) => q(0439),
   q(tumbuka) => q(0442),
   q(tupi languages) => q(0443),
   q(turkish) => q(0444),
   q(turkish, ottoman (1500-1928)) => q(0332),
   q(turkmen) => q(0441),
   q(tuvalu) => q(0446),
   q(tuvinian) => q(0448),
   q(twi) => q(0447),
   q(udmurt) => q(0449),
   q(ugaritic) => q(0450),
   q(uighur) => q(0451),
   q(ukrainian) => q(0452),
   q(umbundu) => q(0453),
   q(uncoded languages) => q(0281),
   q(undetermined) => q(0454),
   q(upper sorbian) => q(0182),
   q(urdu) => q(0455),
   q(uyghur) => q(0451),
   q(uzbek) => q(0456),
   q(vai) => q(0457),
   q(valencian) => q(0071),
   q(venda) => q(0458),
   q(vietnamese) => q(0459),
   q(volapuk) => q(0460),
   q(votic) => q(0461),
   q(wakashan languages) => q(0462),
   q(walamo) => q(0463),
   q(walloon) => q(0468),
   q(waray) => q(0464),
   q(washo) => q(0465),
   q(welsh) => q(0466),
   q(western frisian) => q(0142),
   q(western pahari languages) => q(0176),
   q(wolof) => q(0469),
   q(xhosa) => q(0471),
   q(yakut) => q(0366),
   q(yao) => q(0472),
   q(yapese) => q(0473),
   q(yiddish) => q(0474),
   q(yoruba) => q(0475),
   q(yupik languages) => q(0476),
   q(zande languages) => q(0481),
   q(zapotec) => q(0477),
   q(zaza) => q(0485),
   q(zazaki) => q(0485),
   q(zenaga) => q(0479),
   q(zhuang) => q(0480),
   q(zulu) => q(0482),
   q(zuni) => q(0483),
);

%Code2LanguageID = (
   q(alpha2) => {
      q(aa) => [
         q(0001),
         q(0),
         ],
      q(ab) => [
         q(0002),
         q(0),
         ],
      q(ae) => [
         q(0034),
         q(0),
         ],
      q(af) => [
         q(0009),
         q(0),
         ],
      q(ak) => [
         q(0011),
         q(0),
         ],
      q(am) => [
         q(0017),
         q(0),
         ],
      q(an) => [
         q(0023),
         q(0),
         ],
      q(ar) => [
         q(0021),
         q(0),
         ],
      q(as) => [
         q(0029),
         q(0),
         ],
      q(av) => [
         q(0033),
         q(0),
         ],
      q(ay) => [
         q(0036),
         q(0),
         ],
      q(az) => [
         q(0037),
         q(0),
         ],
      q(ba) => [
         q(0040),
         q(0),
         ],
      q(be) => [
         q(0048),
         q(0),
         ],
      q(bg) => [
         q(0065),
         q(0),
         ],
      q(bh) => [
         q(0053),
         q(0),
         ],
      q(bi) => [
         q(0056),
         q(0),
         ],
      q(bm) => [
         q(0042),
         q(0),
         ],
      q(bn) => [
         q(0050),
         q(0),
         ],
      q(bo) => [
         q(0427),
         q(0),
         ],
      q(br) => [
         q(0061),
         q(0),
         ],
      q(bs) => [
         q(0059),
         q(0),
         ],
      q(ca) => [
         q(0071),
         q(0),
         ],
      q(ce) => [
         q(0077),
         q(0),
         ],
      q(ch) => [
         q(0075),
         q(0),
         ],
      q(co) => [
         q(0092),
         q(0),
         ],
      q(cr) => [
         q(0096),
         q(0),
         ],
      q(cs) => [
         q(0101),
         q(0),
         ],
      q(cu) => [
         q(0086),
         q(0),
         ],
      q(cv) => [
         q(0087),
         q(0),
         ],
      q(cy) => [
         q(0466),
         q(0),
         ],
      q(da) => [
         q(0103),
         q(0),
         ],
      q(de) => [
         q(0150),
         q(0),
         ],
      q(dv) => [
         q(0110),
         q(0),
         ],
      q(dz) => [
         q(0118),
         q(0),
         ],
      q(ee) => [
         q(0127),
         q(0),
         ],
      q(el) => [
         q(0164),
         q(0),
         ],
      q(en) => [
         q(0123),
         q(0),
         ],
      q(eo) => [
         q(0125),
         q(0),
         ],
      q(es) => [
         q(0401),
         q(0),
         ],
      q(et) => [
         q(0126),
         q(0),
         ],
      q(eu) => [
         q(0044),
         q(0),
         ],
      q(fa) => [
         q(0342),
         q(0),
         ],
      q(ff) => [
         q(0143),
         q(0),
         ],
      q(fi) => [
         q(0134),
         q(0),
         ],
      q(fj) => [
         q(0132),
         q(0),
         ],
      q(fo) => [
         q(0130),
         q(0),
         ],
      q(fr) => [
         q(0137),
         q(0),
         ],
      q(fy) => [
         q(0142),
         q(0),
         ],
      q(ga) => [
         q(0154),
         q(0),
         ],
      q(gd) => [
         q(0153),
         q(0),
         ],
      q(gl) => [
         q(0155),
         q(0),
         ],
      q(gn) => [
         q(0165),
         q(0),
         ],
      q(gu) => [
         q(0167),
         q(0),
         ],
      q(gv) => [
         q(0156),
         q(0),
         ],
      q(ha) => [
         q(0171),
         q(0),
         ],
      q(he) => [
         q(0173),
         q(0),
         ],
      q(hi) => [
         q(0177),
         q(0),
         ],
      q(ho) => [
         q(0180),
         q(0),
         ],
      q(hr) => [
         q(0181),
         q(0),
         ],
      q(ht) => [
         q(0170),
         q(0),
         ],
      q(hu) => [
         q(0183),
         q(0),
         ],
      q(hy) => [
         q(0024),
         q(0),
         ],
      q(hz) => [
         q(0174),
         q(0),
         ],
      q(ia) => [
         q(0194),
         q(0),
         ],
      q(id) => [
         q(0196),
         q(0),
         ],
      q(ie) => [
         q(0192),
         q(0),
         ],
      q(ig) => [
         q(0186),
         q(0),
         ],
      q(ii) => [
         q(0189),
         q(0),
         ],
      q(ik) => [
         q(0199),
         q(0),
         ],
      q(io) => [
         q(0188),
         q(0),
         ],
      q(is) => [
         q(0187),
         q(0),
         ],
      q(it) => [
         q(0202),
         q(0),
         ],
      q(iu) => [
         q(0191),
         q(0),
         ],
      q(ja) => [
         q(0205),
         q(0),
         ],
      q(jv) => [
         q(0203),
         q(0),
         ],
      q(ka) => [
         q(0149),
         q(0),
         ],
      q(kg) => [
         q(0230),
         q(0),
         ],
      q(ki) => [
         q(0224),
         q(0),
         ],
      q(kj) => [
         q(0238),
         q(0),
         ],
      q(kk) => [
         q(0218),
         q(0),
         ],
      q(kl) => [
         q(0211),
         q(0),
         ],
      q(km) => [
         q(0222),
         q(0),
         ],
      q(kn) => [
         q(0213),
         q(0),
         ],
      q(ko) => [
         q(0231),
         q(0),
         ],
      q(kr) => [
         q(0216),
         q(0),
         ],
      q(ks) => [
         q(0215),
         q(0),
         ],
      q(ku) => [
         q(0240),
         q(0),
         ],
      q(kv) => [
         q(0229),
         q(0),
         ],
      q(kw) => [
         q(0091),
         q(0),
         ],
      q(ky) => [
         q(0226),
         q(0),
         ],
      q(la) => [
         q(0246),
         q(0),
         ],
      q(lb) => [
         q(0254),
         q(0),
         ],
      q(lg) => [
         q(0257),
         q(0),
         ],
      q(li) => [
         q(0249),
         q(0),
         ],
      q(ln) => [
         q(0250),
         q(0),
         ],
      q(lo) => [
         q(0245),
         q(0),
         ],
      q(lt) => [
         q(0251),
         q(0),
         ],
      q(lu) => [
         q(0256),
         q(0),
         ],
      q(lv) => [
         q(0247),
         q(0),
         ],
      q(mg) => [
         q(0283),
         q(0),
         ],
      q(mh) => [
         q(0265),
         q(0),
         ],
      q(mi) => [
         q(0270),
         q(0),
         ],
      q(mk) => [
         q(0262),
         q(0),
         ],
      q(ml) => [
         q(0268),
         q(0),
         ],
      q(mn) => [
         q(0289),
         q(0),
         ],
      q(mr) => [
         q(0272),
         q(0),
         ],
      q(ms) => [
         q(0274),
         q(0),
         ],
      q(mt) => [
         q(0284),
         q(0),
         ],
      q(my) => [
         q(0066),
         q(0),
         ],
      q(na) => [
         q(0301),
         q(0),
         ],
      q(nb) => [
         q(0313),
         q(0),
         ],
      q(nd) => [
         q(0304),
         q(0),
         ],
      q(ne) => [
         q(0307),
         q(0),
         ],
      q(ng) => [
         q(0305),
         q(0),
         ],
      q(nl) => [
         q(0116),
         q(0),
         ],
      q(nn) => [
         q(0312),
         q(0),
         ],
      q(no) => [
         q(0316),
         q(0),
         ],
      q(nr) => [
         q(0303),
         q(0),
         ],
      q(nv) => [
         q(0302),
         q(0),
         ],
      q(ny) => [
         q(0321),
         q(0),
         ],
      q(oc) => [
         q(0326),
         q(0),
         ],
      q(oj) => [
         q(0327),
         q(0),
         ],
      q(om) => [
         q(0329),
         q(0),
         ],
      q(or) => [
         q(0328),
         q(0),
         ],
      q(os) => [
         q(0331),
         q(0),
         ],
      q(pa) => [
         q(0338),
         q(0),
         ],
      q(pi) => [
         q(0345),
         q(0),
         ],
      q(pl) => [
         q(0346),
         q(0),
         ],
      q(ps) => [
         q(0351),
         q(0),
         ],
      q(pt) => [
         q(0348),
         q(0),
         ],
      q(qu) => [
         q(0353),
         q(0),
         ],
      q(rm) => [
         q(0358),
         q(0),
         ],
      q(rn) => [
         q(0361),
         q(0),
         ],
      q(ro) => [
         q(0360),
         q(0),
         ],
      q(ru) => [
         q(0363),
         q(0),
         ],
      q(rw) => [
         q(0225),
         q(0),
         ],
      q(sa) => [
         q(0370),
         q(0),
         ],
      q(sc) => [
         q(0402),
         q(0),
         ],
      q(sd) => [
         q(0395),
         q(0),
         ],
      q(se) => [
         q(0388),
         q(0),
         ],
      q(sg) => [
         q(0365),
         q(0),
         ],
      q(si) => [
         q(0381),
         q(0),
         ],
      q(sk) => [
         q(0385),
         q(0),
         ],
      q(sl) => [
         q(0386),
         q(0),
         ],
      q(sm) => [
         q(0392),
         q(0),
         ],
      q(sn) => [
         q(0394),
         q(0),
         ],
      q(so) => [
         q(0398),
         q(0),
         ],
      q(sq) => [
         q(0013),
         q(0),
         ],
      q(sr) => [
         q(0404),
         q(0),
         ],
      q(ss) => [
         q(0407),
         q(0),
         ],
      q(st) => [
         q(0400),
         q(0),
         ],
      q(su) => [
         q(0409),
         q(0),
         ],
      q(sv) => [
         q(0413),
         q(0),
         ],
      q(sw) => [
         q(0412),
         q(0),
         ],
      q(ta) => [
         q(0418),
         q(0),
         ],
      q(te) => [
         q(0420),
         q(0),
         ],
      q(tg) => [
         q(0424),
         q(0),
         ],
      q(th) => [
         q(0426),
         q(0),
         ],
      q(ti) => [
         q(0429),
         q(0),
         ],
      q(tk) => [
         q(0441),
         q(0),
         ],
      q(tl) => [
         q(0425),
         q(0),
         ],
      q(tn) => [
         q(0439),
         q(0),
         ],
      q(to) => [
         q(0436),
         q(0),
         ],
      q(tr) => [
         q(0444),
         q(0),
         ],
      q(ts) => [
         q(0440),
         q(0),
         ],
      q(tt) => [
         q(0419),
         q(0),
         ],
      q(tw) => [
         q(0447),
         q(0),
         ],
      q(ty) => [
         q(0416),
         q(0),
         ],
      q(ug) => [
         q(0451),
         q(0),
         ],
      q(uk) => [
         q(0452),
         q(0),
         ],
      q(ur) => [
         q(0455),
         q(0),
         ],
      q(uz) => [
         q(0456),
         q(0),
         ],
      q(ve) => [
         q(0458),
         q(0),
         ],
      q(vi) => [
         q(0459),
         q(0),
         ],
      q(vo) => [
         q(0460),
         q(0),
         ],
      q(wa) => [
         q(0468),
         q(0),
         ],
      q(wo) => [
         q(0469),
         q(0),
         ],
      q(xh) => [
         q(0471),
         q(0),
         ],
      q(yi) => [
         q(0474),
         q(0),
         ],
      q(yo) => [
         q(0475),
         q(0),
         ],
      q(za) => [
         q(0480),
         q(0),
         ],
      q(zh) => [
         q(0079),
         q(0),
         ],
      q(zu) => [
         q(0482),
         q(0),
         ],
      },
   q(alpha3) => {
      q(aar) => [
         q(0001),
         q(0),
         ],
      q(abk) => [
         q(0002),
         q(0),
         ],
      q(ace) => [
         q(0003),
         q(0),
         ],
      q(ach) => [
         q(0004),
         q(0),
         ],
      q(ada) => [
         q(0005),
         q(0),
         ],
      q(ady) => [
         q(0006),
         q(0),
         ],
      q(afa) => [
         q(0007),
         q(0),
         ],
      q(afh) => [
         q(0008),
         q(0),
         ],
      q(afr) => [
         q(0009),
         q(0),
         ],
      q(ain) => [
         q(0010),
         q(0),
         ],
      q(aka) => [
         q(0011),
         q(0),
         ],
      q(akk) => [
         q(0012),
         q(0),
         ],
      q(alb) => [
         q(0013),
         q(0),
         ],
      q(ale) => [
         q(0014),
         q(0),
         ],
      q(alg) => [
         q(0015),
         q(0),
         ],
      q(alt) => [
         q(0016),
         q(0),
         ],
      q(amh) => [
         q(0017),
         q(0),
         ],
      q(ang) => [
         q(0018),
         q(0),
         ],
      q(anp) => [
         q(0019),
         q(0),
         ],
      q(apa) => [
         q(0020),
         q(0),
         ],
      q(ara) => [
         q(0021),
         q(0),
         ],
      q(arc) => [
         q(0022),
         q(0),
         ],
      q(arg) => [
         q(0023),
         q(0),
         ],
      q(arm) => [
         q(0024),
         q(0),
         ],
      q(arn) => [
         q(0025),
         q(0),
         ],
      q(arp) => [
         q(0026),
         q(0),
         ],
      q(art) => [
         q(0027),
         q(0),
         ],
      q(arw) => [
         q(0028),
         q(0),
         ],
      q(asm) => [
         q(0029),
         q(0),
         ],
      q(ast) => [
         q(0030),
         q(0),
         ],
      q(ath) => [
         q(0031),
         q(0),
         ],
      q(aus) => [
         q(0032),
         q(0),
         ],
      q(ava) => [
         q(0033),
         q(0),
         ],
      q(ave) => [
         q(0034),
         q(0),
         ],
      q(awa) => [
         q(0035),
         q(0),
         ],
      q(aym) => [
         q(0036),
         q(0),
         ],
      q(aze) => [
         q(0037),
         q(0),
         ],
      q(bad) => [
         q(0038),
         q(0),
         ],
      q(bai) => [
         q(0039),
         q(0),
         ],
      q(bak) => [
         q(0040),
         q(0),
         ],
      q(bal) => [
         q(0041),
         q(0),
         ],
      q(bam) => [
         q(0042),
         q(0),
         ],
      q(ban) => [
         q(0043),
         q(0),
         ],
      q(baq) => [
         q(0044),
         q(0),
         ],
      q(bas) => [
         q(0045),
         q(0),
         ],
      q(bat) => [
         q(0046),
         q(0),
         ],
      q(bej) => [
         q(0047),
         q(0),
         ],
      q(bel) => [
         q(0048),
         q(0),
         ],
      q(bem) => [
         q(0049),
         q(0),
         ],
      q(ben) => [
         q(0050),
         q(0),
         ],
      q(ber) => [
         q(0051),
         q(0),
         ],
      q(bho) => [
         q(0052),
         q(0),
         ],
      q(bih) => [
         q(0053),
         q(0),
         ],
      q(bik) => [
         q(0054),
         q(0),
         ],
      q(bin) => [
         q(0055),
         q(0),
         ],
      q(bis) => [
         q(0056),
         q(0),
         ],
      q(bla) => [
         q(0057),
         q(0),
         ],
      q(bnt) => [
         q(0058),
         q(0),
         ],
      q(bos) => [
         q(0059),
         q(0),
         ],
      q(bra) => [
         q(0060),
         q(0),
         ],
      q(bre) => [
         q(0061),
         q(0),
         ],
      q(btk) => [
         q(0062),
         q(0),
         ],
      q(bua) => [
         q(0063),
         q(0),
         ],
      q(bug) => [
         q(0064),
         q(0),
         ],
      q(bul) => [
         q(0065),
         q(0),
         ],
      q(bur) => [
         q(0066),
         q(0),
         ],
      q(byn) => [
         q(0067),
         q(0),
         ],
      q(cad) => [
         q(0068),
         q(0),
         ],
      q(cai) => [
         q(0069),
         q(0),
         ],
      q(car) => [
         q(0070),
         q(0),
         ],
      q(cat) => [
         q(0071),
         q(0),
         ],
      q(cau) => [
         q(0072),
         q(0),
         ],
      q(ceb) => [
         q(0073),
         q(0),
         ],
      q(cel) => [
         q(0074),
         q(0),
         ],
      q(cha) => [
         q(0075),
         q(0),
         ],
      q(chb) => [
         q(0076),
         q(0),
         ],
      q(che) => [
         q(0077),
         q(0),
         ],
      q(chg) => [
         q(0078),
         q(0),
         ],
      q(chi) => [
         q(0079),
         q(0),
         ],
      q(chk) => [
         q(0080),
         q(0),
         ],
      q(chm) => [
         q(0081),
         q(0),
         ],
      q(chn) => [
         q(0082),
         q(0),
         ],
      q(cho) => [
         q(0083),
         q(0),
         ],
      q(chp) => [
         q(0084),
         q(0),
         ],
      q(chr) => [
         q(0085),
         q(0),
         ],
      q(chu) => [
         q(0086),
         q(0),
         ],
      q(chv) => [
         q(0087),
         q(0),
         ],
      q(chy) => [
         q(0088),
         q(0),
         ],
      q(cmc) => [
         q(0089),
         q(0),
         ],
      q(cop) => [
         q(0090),
         q(0),
         ],
      q(cor) => [
         q(0091),
         q(0),
         ],
      q(cos) => [
         q(0092),
         q(0),
         ],
      q(cpe) => [
         q(0093),
         q(0),
         ],
      q(cpf) => [
         q(0094),
         q(0),
         ],
      q(cpp) => [
         q(0095),
         q(0),
         ],
      q(cre) => [
         q(0096),
         q(0),
         ],
      q(crh) => [
         q(0097),
         q(0),
         ],
      q(crp) => [
         q(0098),
         q(0),
         ],
      q(csb) => [
         q(0099),
         q(0),
         ],
      q(cus) => [
         q(0100),
         q(0),
         ],
      q(cze) => [
         q(0101),
         q(0),
         ],
      q(dak) => [
         q(0102),
         q(0),
         ],
      q(dan) => [
         q(0103),
         q(0),
         ],
      q(dar) => [
         q(0104),
         q(0),
         ],
      q(day) => [
         q(0105),
         q(0),
         ],
      q(del) => [
         q(0106),
         q(0),
         ],
      q(den) => [
         q(0107),
         q(0),
         ],
      q(dgr) => [
         q(0108),
         q(0),
         ],
      q(din) => [
         q(0109),
         q(0),
         ],
      q(div) => [
         q(0110),
         q(0),
         ],
      q(doi) => [
         q(0111),
         q(0),
         ],
      q(dra) => [
         q(0112),
         q(0),
         ],
      q(dsb) => [
         q(0113),
         q(0),
         ],
      q(dua) => [
         q(0114),
         q(0),
         ],
      q(dum) => [
         q(0115),
         q(0),
         ],
      q(dut) => [
         q(0116),
         q(0),
         ],
      q(dyu) => [
         q(0117),
         q(0),
         ],
      q(dzo) => [
         q(0118),
         q(0),
         ],
      q(efi) => [
         q(0119),
         q(0),
         ],
      q(egy) => [
         q(0120),
         q(0),
         ],
      q(eka) => [
         q(0121),
         q(0),
         ],
      q(elx) => [
         q(0122),
         q(0),
         ],
      q(eng) => [
         q(0123),
         q(0),
         ],
      q(enm) => [
         q(0124),
         q(0),
         ],
      q(epo) => [
         q(0125),
         q(0),
         ],
      q(est) => [
         q(0126),
         q(0),
         ],
      q(ewe) => [
         q(0127),
         q(0),
         ],
      q(ewo) => [
         q(0128),
         q(0),
         ],
      q(fan) => [
         q(0129),
         q(0),
         ],
      q(fao) => [
         q(0130),
         q(0),
         ],
      q(fat) => [
         q(0131),
         q(0),
         ],
      q(fij) => [
         q(0132),
         q(0),
         ],
      q(fil) => [
         q(0133),
         q(0),
         ],
      q(fin) => [
         q(0134),
         q(0),
         ],
      q(fiu) => [
         q(0135),
         q(0),
         ],
      q(fon) => [
         q(0136),
         q(0),
         ],
      q(fre) => [
         q(0137),
         q(0),
         ],
      q(frm) => [
         q(0138),
         q(0),
         ],
      q(fro) => [
         q(0139),
         q(0),
         ],
      q(frr) => [
         q(0140),
         q(0),
         ],
      q(frs) => [
         q(0141),
         q(0),
         ],
      q(fry) => [
         q(0142),
         q(0),
         ],
      q(ful) => [
         q(0143),
         q(0),
         ],
      q(fur) => [
         q(0144),
         q(0),
         ],
      q(gaa) => [
         q(0145),
         q(0),
         ],
      q(gay) => [
         q(0146),
         q(0),
         ],
      q(gba) => [
         q(0147),
         q(0),
         ],
      q(gem) => [
         q(0148),
         q(0),
         ],
      q(geo) => [
         q(0149),
         q(0),
         ],
      q(ger) => [
         q(0150),
         q(0),
         ],
      q(gez) => [
         q(0151),
         q(0),
         ],
      q(gil) => [
         q(0152),
         q(0),
         ],
      q(gla) => [
         q(0153),
         q(0),
         ],
      q(gle) => [
         q(0154),
         q(0),
         ],
      q(glg) => [
         q(0155),
         q(0),
         ],
      q(glv) => [
         q(0156),
         q(0),
         ],
      q(gmh) => [
         q(0157),
         q(0),
         ],
      q(goh) => [
         q(0158),
         q(0),
         ],
      q(gon) => [
         q(0159),
         q(0),
         ],
      q(gor) => [
         q(0160),
         q(0),
         ],
      q(got) => [
         q(0161),
         q(0),
         ],
      q(grb) => [
         q(0162),
         q(0),
         ],
      q(grc) => [
         q(0163),
         q(0),
         ],
      q(gre) => [
         q(0164),
         q(0),
         ],
      q(grn) => [
         q(0165),
         q(0),
         ],
      q(gsw) => [
         q(0166),
         q(0),
         ],
      q(guj) => [
         q(0167),
         q(0),
         ],
      q(gwi) => [
         q(0168),
         q(0),
         ],
      q(hai) => [
         q(0169),
         q(0),
         ],
      q(hat) => [
         q(0170),
         q(0),
         ],
      q(hau) => [
         q(0171),
         q(0),
         ],
      q(haw) => [
         q(0172),
         q(0),
         ],
      q(heb) => [
         q(0173),
         q(0),
         ],
      q(her) => [
         q(0174),
         q(0),
         ],
      q(hil) => [
         q(0175),
         q(0),
         ],
      q(him) => [
         q(0176),
         q(0),
         ],
      q(hin) => [
         q(0177),
         q(0),
         ],
      q(hit) => [
         q(0178),
         q(0),
         ],
      q(hmn) => [
         q(0179),
         q(0),
         ],
      q(hmo) => [
         q(0180),
         q(0),
         ],
      q(hrv) => [
         q(0181),
         q(0),
         ],
      q(hsb) => [
         q(0182),
         q(0),
         ],
      q(hun) => [
         q(0183),
         q(0),
         ],
      q(hup) => [
         q(0184),
         q(0),
         ],
      q(iba) => [
         q(0185),
         q(0),
         ],
      q(ibo) => [
         q(0186),
         q(0),
         ],
      q(ice) => [
         q(0187),
         q(0),
         ],
      q(ido) => [
         q(0188),
         q(0),
         ],
      q(iii) => [
         q(0189),
         q(0),
         ],
      q(ijo) => [
         q(0190),
         q(0),
         ],
      q(iku) => [
         q(0191),
         q(0),
         ],
      q(ile) => [
         q(0192),
         q(0),
         ],
      q(ilo) => [
         q(0193),
         q(0),
         ],
      q(ina) => [
         q(0194),
         q(0),
         ],
      q(inc) => [
         q(0195),
         q(0),
         ],
      q(ind) => [
         q(0196),
         q(0),
         ],
      q(ine) => [
         q(0197),
         q(0),
         ],
      q(inh) => [
         q(0198),
         q(0),
         ],
      q(ipk) => [
         q(0199),
         q(0),
         ],
      q(ira) => [
         q(0200),
         q(0),
         ],
      q(iro) => [
         q(0201),
         q(0),
         ],
      q(ita) => [
         q(0202),
         q(0),
         ],
      q(jav) => [
         q(0203),
         q(0),
         ],
      q(jbo) => [
         q(0204),
         q(0),
         ],
      q(jpn) => [
         q(0205),
         q(0),
         ],
      q(jpr) => [
         q(0206),
         q(0),
         ],
      q(jrb) => [
         q(0207),
         q(0),
         ],
      q(kaa) => [
         q(0208),
         q(0),
         ],
      q(kab) => [
         q(0209),
         q(0),
         ],
      q(kac) => [
         q(0210),
         q(0),
         ],
      q(kal) => [
         q(0211),
         q(0),
         ],
      q(kam) => [
         q(0212),
         q(0),
         ],
      q(kan) => [
         q(0213),
         q(0),
         ],
      q(kar) => [
         q(0214),
         q(0),
         ],
      q(kas) => [
         q(0215),
         q(0),
         ],
      q(kau) => [
         q(0216),
         q(0),
         ],
      q(kaw) => [
         q(0217),
         q(0),
         ],
      q(kaz) => [
         q(0218),
         q(0),
         ],
      q(kbd) => [
         q(0219),
         q(0),
         ],
      q(kha) => [
         q(0220),
         q(0),
         ],
      q(khi) => [
         q(0221),
         q(0),
         ],
      q(khm) => [
         q(0222),
         q(0),
         ],
      q(kho) => [
         q(0223),
         q(0),
         ],
      q(kik) => [
         q(0224),
         q(0),
         ],
      q(kin) => [
         q(0225),
         q(0),
         ],
      q(kir) => [
         q(0226),
         q(0),
         ],
      q(kmb) => [
         q(0227),
         q(0),
         ],
      q(kok) => [
         q(0228),
         q(0),
         ],
      q(kom) => [
         q(0229),
         q(0),
         ],
      q(kon) => [
         q(0230),
         q(0),
         ],
      q(kor) => [
         q(0231),
         q(0),
         ],
      q(kos) => [
         q(0232),
         q(0),
         ],
      q(kpe) => [
         q(0233),
         q(0),
         ],
      q(krc) => [
         q(0234),
         q(0),
         ],
      q(krl) => [
         q(0235),
         q(0),
         ],
      q(kro) => [
         q(0236),
         q(0),
         ],
      q(kru) => [
         q(0237),
         q(0),
         ],
      q(kua) => [
         q(0238),
         q(0),
         ],
      q(kum) => [
         q(0239),
         q(0),
         ],
      q(kur) => [
         q(0240),
         q(0),
         ],
      q(kut) => [
         q(0241),
         q(0),
         ],
      q(lad) => [
         q(0242),
         q(0),
         ],
      q(lah) => [
         q(0243),
         q(0),
         ],
      q(lam) => [
         q(0244),
         q(0),
         ],
      q(lao) => [
         q(0245),
         q(0),
         ],
      q(lat) => [
         q(0246),
         q(0),
         ],
      q(lav) => [
         q(0247),
         q(0),
         ],
      q(lez) => [
         q(0248),
         q(0),
         ],
      q(lim) => [
         q(0249),
         q(0),
         ],
      q(lin) => [
         q(0250),
         q(0),
         ],
      q(lit) => [
         q(0251),
         q(0),
         ],
      q(lol) => [
         q(0252),
         q(0),
         ],
      q(loz) => [
         q(0253),
         q(0),
         ],
      q(ltz) => [
         q(0254),
         q(0),
         ],
      q(lua) => [
         q(0255),
         q(0),
         ],
      q(lub) => [
         q(0256),
         q(0),
         ],
      q(lug) => [
         q(0257),
         q(0),
         ],
      q(lui) => [
         q(0258),
         q(0),
         ],
      q(lun) => [
         q(0259),
         q(0),
         ],
      q(luo) => [
         q(0260),
         q(0),
         ],
      q(lus) => [
         q(0261),
         q(0),
         ],
      q(mac) => [
         q(0262),
         q(0),
         ],
      q(mad) => [
         q(0263),
         q(0),
         ],
      q(mag) => [
         q(0264),
         q(0),
         ],
      q(mah) => [
         q(0265),
         q(0),
         ],
      q(mai) => [
         q(0266),
         q(0),
         ],
      q(mak) => [
         q(0267),
         q(0),
         ],
      q(mal) => [
         q(0268),
         q(0),
         ],
      q(man) => [
         q(0269),
         q(0),
         ],
      q(mao) => [
         q(0270),
         q(0),
         ],
      q(map) => [
         q(0271),
         q(0),
         ],
      q(mar) => [
         q(0272),
         q(0),
         ],
      q(mas) => [
         q(0273),
         q(0),
         ],
      q(may) => [
         q(0274),
         q(0),
         ],
      q(mdf) => [
         q(0275),
         q(0),
         ],
      q(mdr) => [
         q(0276),
         q(0),
         ],
      q(men) => [
         q(0277),
         q(0),
         ],
      q(mga) => [
         q(0278),
         q(0),
         ],
      q(mic) => [
         q(0279),
         q(0),
         ],
      q(min) => [
         q(0280),
         q(0),
         ],
      q(mis) => [
         q(0281),
         q(0),
         ],
      q(mkh) => [
         q(0282),
         q(0),
         ],
      q(mlg) => [
         q(0283),
         q(0),
         ],
      q(mlt) => [
         q(0284),
         q(0),
         ],
      q(mnc) => [
         q(0285),
         q(0),
         ],
      q(mni) => [
         q(0286),
         q(0),
         ],
      q(mno) => [
         q(0287),
         q(0),
         ],
      q(moh) => [
         q(0288),
         q(0),
         ],
      q(mon) => [
         q(0289),
         q(0),
         ],
      q(mos) => [
         q(0290),
         q(0),
         ],
      q(mul) => [
         q(0291),
         q(0),
         ],
      q(mun) => [
         q(0292),
         q(0),
         ],
      q(mus) => [
         q(0293),
         q(0),
         ],
      q(mwl) => [
         q(0294),
         q(0),
         ],
      q(mwr) => [
         q(0295),
         q(0),
         ],
      q(myn) => [
         q(0296),
         q(0),
         ],
      q(myv) => [
         q(0297),
         q(0),
         ],
      q(nah) => [
         q(0298),
         q(0),
         ],
      q(nai) => [
         q(0299),
         q(0),
         ],
      q(nap) => [
         q(0300),
         q(0),
         ],
      q(nau) => [
         q(0301),
         q(0),
         ],
      q(nav) => [
         q(0302),
         q(0),
         ],
      q(nbl) => [
         q(0303),
         q(0),
         ],
      q(nde) => [
         q(0304),
         q(0),
         ],
      q(ndo) => [
         q(0305),
         q(0),
         ],
      q(nds) => [
         q(0306),
         q(0),
         ],
      q(nep) => [
         q(0307),
         q(0),
         ],
      q(new) => [
         q(0308),
         q(0),
         ],
      q(nia) => [
         q(0309),
         q(0),
         ],
      q(nic) => [
         q(0310),
         q(0),
         ],
      q(niu) => [
         q(0311),
         q(0),
         ],
      q(nno) => [
         q(0312),
         q(0),
         ],
      q(nob) => [
         q(0313),
         q(0),
         ],
      q(nog) => [
         q(0314),
         q(0),
         ],
      q(non) => [
         q(0315),
         q(0),
         ],
      q(nor) => [
         q(0316),
         q(0),
         ],
      q(nqo) => [
         q(0317),
         q(0),
         ],
      q(nso) => [
         q(0318),
         q(0),
         ],
      q(nub) => [
         q(0319),
         q(0),
         ],
      q(nwc) => [
         q(0320),
         q(0),
         ],
      q(nya) => [
         q(0321),
         q(0),
         ],
      q(nym) => [
         q(0322),
         q(0),
         ],
      q(nyn) => [
         q(0323),
         q(0),
         ],
      q(nyo) => [
         q(0324),
         q(0),
         ],
      q(nzi) => [
         q(0325),
         q(0),
         ],
      q(oci) => [
         q(0326),
         q(0),
         ],
      q(oji) => [
         q(0327),
         q(0),
         ],
      q(ori) => [
         q(0328),
         q(0),
         ],
      q(orm) => [
         q(0329),
         q(0),
         ],
      q(osa) => [
         q(0330),
         q(0),
         ],
      q(oss) => [
         q(0331),
         q(0),
         ],
      q(ota) => [
         q(0332),
         q(0),
         ],
      q(oto) => [
         q(0333),
         q(0),
         ],
      q(paa) => [
         q(0334),
         q(0),
         ],
      q(pag) => [
         q(0335),
         q(0),
         ],
      q(pal) => [
         q(0336),
         q(0),
         ],
      q(pam) => [
         q(0337),
         q(0),
         ],
      q(pan) => [
         q(0338),
         q(0),
         ],
      q(pap) => [
         q(0339),
         q(0),
         ],
      q(pau) => [
         q(0340),
         q(0),
         ],
      q(peo) => [
         q(0341),
         q(0),
         ],
      q(per) => [
         q(0342),
         q(0),
         ],
      q(phi) => [
         q(0343),
         q(0),
         ],
      q(phn) => [
         q(0344),
         q(0),
         ],
      q(pli) => [
         q(0345),
         q(0),
         ],
      q(pol) => [
         q(0346),
         q(0),
         ],
      q(pon) => [
         q(0347),
         q(0),
         ],
      q(por) => [
         q(0348),
         q(0),
         ],
      q(pra) => [
         q(0349),
         q(0),
         ],
      q(pro) => [
         q(0350),
         q(0),
         ],
      q(pus) => [
         q(0351),
         q(0),
         ],
      q(qtz) => [
         q(0352),
         q(0),
         ],
      q(que) => [
         q(0353),
         q(0),
         ],
      q(raj) => [
         q(0354),
         q(0),
         ],
      q(rap) => [
         q(0355),
         q(0),
         ],
      q(rar) => [
         q(0356),
         q(0),
         ],
      q(roa) => [
         q(0357),
         q(0),
         ],
      q(roh) => [
         q(0358),
         q(0),
         ],
      q(rom) => [
         q(0359),
         q(0),
         ],
      q(rum) => [
         q(0360),
         q(0),
         ],
      q(run) => [
         q(0361),
         q(0),
         ],
      q(rup) => [
         q(0362),
         q(0),
         ],
      q(rus) => [
         q(0363),
         q(0),
         ],
      q(sad) => [
         q(0364),
         q(0),
         ],
      q(sag) => [
         q(0365),
         q(0),
         ],
      q(sah) => [
         q(0366),
         q(0),
         ],
      q(sai) => [
         q(0367),
         q(0),
         ],
      q(sal) => [
         q(0368),
         q(0),
         ],
      q(sam) => [
         q(0369),
         q(0),
         ],
      q(san) => [
         q(0370),
         q(0),
         ],
      q(sas) => [
         q(0371),
         q(0),
         ],
      q(sat) => [
         q(0372),
         q(0),
         ],
      q(scn) => [
         q(0373),
         q(0),
         ],
      q(sco) => [
         q(0374),
         q(0),
         ],
      q(sel) => [
         q(0375),
         q(0),
         ],
      q(sem) => [
         q(0376),
         q(0),
         ],
      q(sga) => [
         q(0377),
         q(0),
         ],
      q(sgn) => [
         q(0378),
         q(0),
         ],
      q(shn) => [
         q(0379),
         q(0),
         ],
      q(sid) => [
         q(0380),
         q(0),
         ],
      q(sin) => [
         q(0381),
         q(0),
         ],
      q(sio) => [
         q(0382),
         q(0),
         ],
      q(sit) => [
         q(0383),
         q(0),
         ],
      q(sla) => [
         q(0384),
         q(0),
         ],
      q(slo) => [
         q(0385),
         q(0),
         ],
      q(slv) => [
         q(0386),
         q(0),
         ],
      q(sma) => [
         q(0387),
         q(0),
         ],
      q(sme) => [
         q(0388),
         q(0),
         ],
      q(smi) => [
         q(0389),
         q(0),
         ],
      q(smj) => [
         q(0390),
         q(0),
         ],
      q(smn) => [
         q(0391),
         q(0),
         ],
      q(smo) => [
         q(0392),
         q(0),
         ],
      q(sms) => [
         q(0393),
         q(0),
         ],
      q(sna) => [
         q(0394),
         q(0),
         ],
      q(snd) => [
         q(0395),
         q(0),
         ],
      q(snk) => [
         q(0396),
         q(0),
         ],
      q(sog) => [
         q(0397),
         q(0),
         ],
      q(som) => [
         q(0398),
         q(0),
         ],
      q(son) => [
         q(0399),
         q(0),
         ],
      q(sot) => [
         q(0400),
         q(0),
         ],
      q(spa) => [
         q(0401),
         q(0),
         ],
      q(srd) => [
         q(0402),
         q(0),
         ],
      q(srn) => [
         q(0403),
         q(0),
         ],
      q(srp) => [
         q(0404),
         q(0),
         ],
      q(srr) => [
         q(0405),
         q(0),
         ],
      q(ssa) => [
         q(0406),
         q(0),
         ],
      q(ssw) => [
         q(0407),
         q(0),
         ],
      q(suk) => [
         q(0408),
         q(0),
         ],
      q(sun) => [
         q(0409),
         q(0),
         ],
      q(sus) => [
         q(0410),
         q(0),
         ],
      q(sux) => [
         q(0411),
         q(0),
         ],
      q(swa) => [
         q(0412),
         q(0),
         ],
      q(swe) => [
         q(0413),
         q(0),
         ],
      q(syc) => [
         q(0414),
         q(0),
         ],
      q(syr) => [
         q(0415),
         q(0),
         ],
      q(tah) => [
         q(0416),
         q(0),
         ],
      q(tai) => [
         q(0417),
         q(0),
         ],
      q(tam) => [
         q(0418),
         q(0),
         ],
      q(tat) => [
         q(0419),
         q(0),
         ],
      q(tel) => [
         q(0420),
         q(0),
         ],
      q(tem) => [
         q(0421),
         q(0),
         ],
      q(ter) => [
         q(0422),
         q(0),
         ],
      q(tet) => [
         q(0423),
         q(0),
         ],
      q(tgk) => [
         q(0424),
         q(0),
         ],
      q(tgl) => [
         q(0425),
         q(0),
         ],
      q(tha) => [
         q(0426),
         q(0),
         ],
      q(tib) => [
         q(0427),
         q(0),
         ],
      q(tig) => [
         q(0428),
         q(0),
         ],
      q(tir) => [
         q(0429),
         q(0),
         ],
      q(tiv) => [
         q(0430),
         q(0),
         ],
      q(tkl) => [
         q(0431),
         q(0),
         ],
      q(tlh) => [
         q(0432),
         q(0),
         ],
      q(tli) => [
         q(0433),
         q(0),
         ],
      q(tmh) => [
         q(0434),
         q(0),
         ],
      q(tog) => [
         q(0435),
         q(0),
         ],
      q(ton) => [
         q(0436),
         q(0),
         ],
      q(tpi) => [
         q(0437),
         q(0),
         ],
      q(tsi) => [
         q(0438),
         q(0),
         ],
      q(tsn) => [
         q(0439),
         q(0),
         ],
      q(tso) => [
         q(0440),
         q(0),
         ],
      q(tuk) => [
         q(0441),
         q(0),
         ],
      q(tum) => [
         q(0442),
         q(0),
         ],
      q(tup) => [
         q(0443),
         q(0),
         ],
      q(tur) => [
         q(0444),
         q(0),
         ],
      q(tut) => [
         q(0445),
         q(0),
         ],
      q(tvl) => [
         q(0446),
         q(0),
         ],
      q(twi) => [
         q(0447),
         q(0),
         ],
      q(tyv) => [
         q(0448),
         q(0),
         ],
      q(udm) => [
         q(0449),
         q(0),
         ],
      q(uga) => [
         q(0450),
         q(0),
         ],
      q(uig) => [
         q(0451),
         q(0),
         ],
      q(ukr) => [
         q(0452),
         q(0),
         ],
      q(umb) => [
         q(0453),
         q(0),
         ],
      q(und) => [
         q(0454),
         q(0),
         ],
      q(urd) => [
         q(0455),
         q(0),
         ],
      q(uzb) => [
         q(0456),
         q(0),
         ],
      q(vai) => [
         q(0457),
         q(0),
         ],
      q(ven) => [
         q(0458),
         q(0),
         ],
      q(vie) => [
         q(0459),
         q(0),
         ],
      q(vol) => [
         q(0460),
         q(0),
         ],
      q(vot) => [
         q(0461),
         q(0),
         ],
      q(wak) => [
         q(0462),
         q(0),
         ],
      q(wal) => [
         q(0463),
         q(0),
         ],
      q(war) => [
         q(0464),
         q(0),
         ],
      q(was) => [
         q(0465),
         q(0),
         ],
      q(wel) => [
         q(0466),
         q(0),
         ],
      q(wen) => [
         q(0467),
         q(0),
         ],
      q(wln) => [
         q(0468),
         q(0),
         ],
      q(wol) => [
         q(0469),
         q(0),
         ],
      q(xal) => [
         q(0470),
         q(0),
         ],
      q(xho) => [
         q(0471),
         q(0),
         ],
      q(yao) => [
         q(0472),
         q(0),
         ],
      q(yap) => [
         q(0473),
         q(0),
         ],
      q(yid) => [
         q(0474),
         q(0),
         ],
      q(yor) => [
         q(0475),
         q(0),
         ],
      q(ypk) => [
         q(0476),
         q(0),
         ],
      q(zap) => [
         q(0477),
         q(0),
         ],
      q(zbl) => [
         q(0478),
         q(0),
         ],
      q(zen) => [
         q(0479),
         q(0),
         ],
      q(zha) => [
         q(0480),
         q(0),
         ],
      q(znd) => [
         q(0481),
         q(0),
         ],
      q(zul) => [
         q(0482),
         q(0),
         ],
      q(zun) => [
         q(0483),
         q(0),
         ],
      q(zxx) => [
         q(0484),
         q(0),
         ],
      q(zza) => [
         q(0485),
         q(0),
         ],
      },
   q(term) => {
      q(bod) => [
         q(0427),
         q(0),
         ],
      q(ces) => [
         q(0101),
         q(0),
         ],
      q(cym) => [
         q(0466),
         q(0),
         ],
      q(deu) => [
         q(0150),
         q(0),
         ],
      q(ell) => [
         q(0164),
         q(0),
         ],
      q(eus) => [
         q(0044),
         q(0),
         ],
      q(fas) => [
         q(0342),
         q(0),
         ],
      q(fra) => [
         q(0137),
         q(0),
         ],
      q(hye) => [
         q(0024),
         q(0),
         ],
      q(isl) => [
         q(0187),
         q(0),
         ],
      q(kat) => [
         q(0149),
         q(0),
         ],
      q(mkd) => [
         q(0262),
         q(0),
         ],
      q(mri) => [
         q(0270),
         q(0),
         ],
      q(msa) => [
         q(0274),
         q(0),
         ],
      q(mya) => [
         q(0066),
         q(0),
         ],
      q(nld) => [
         q(0116),
         q(0),
         ],
      q(ron) => [
         q(0360),
         q(0),
         ],
      q(slk) => [
         q(0385),
         q(0),
         ],
      q(sqi) => [
         q(0013),
         q(0),
         ],
      q(zho) => [
         q(0079),
         q(0),
         ],
      },
);

%LanguageID2Code = (
   q(alpha2) => {
      q(0001) => q(aa),
      q(0002) => q(ab),
      q(0009) => q(af),
      q(0011) => q(ak),
      q(0013) => q(sq),
      q(0017) => q(am),
      q(0021) => q(ar),
      q(0023) => q(an),
      q(0024) => q(hy),
      q(0029) => q(as),
      q(0033) => q(av),
      q(0034) => q(ae),
      q(0036) => q(ay),
      q(0037) => q(az),
      q(0040) => q(ba),
      q(0042) => q(bm),
      q(0044) => q(eu),
      q(0048) => q(be),
      q(0050) => q(bn),
      q(0053) => q(bh),
      q(0056) => q(bi),
      q(0059) => q(bs),
      q(0061) => q(br),
      q(0065) => q(bg),
      q(0066) => q(my),
      q(0071) => q(ca),
      q(0075) => q(ch),
      q(0077) => q(ce),
      q(0079) => q(zh),
      q(0086) => q(cu),
      q(0087) => q(cv),
      q(0091) => q(kw),
      q(0092) => q(co),
      q(0096) => q(cr),
      q(0101) => q(cs),
      q(0103) => q(da),
      q(0110) => q(dv),
      q(0116) => q(nl),
      q(0118) => q(dz),
      q(0123) => q(en),
      q(0125) => q(eo),
      q(0126) => q(et),
      q(0127) => q(ee),
      q(0130) => q(fo),
      q(0132) => q(fj),
      q(0134) => q(fi),
      q(0137) => q(fr),
      q(0142) => q(fy),
      q(0143) => q(ff),
      q(0149) => q(ka),
      q(0150) => q(de),
      q(0153) => q(gd),
      q(0154) => q(ga),
      q(0155) => q(gl),
      q(0156) => q(gv),
      q(0164) => q(el),
      q(0165) => q(gn),
      q(0167) => q(gu),
      q(0170) => q(ht),
      q(0171) => q(ha),
      q(0173) => q(he),
      q(0174) => q(hz),
      q(0177) => q(hi),
      q(0180) => q(ho),
      q(0181) => q(hr),
      q(0183) => q(hu),
      q(0186) => q(ig),
      q(0187) => q(is),
      q(0188) => q(io),
      q(0189) => q(ii),
      q(0191) => q(iu),
      q(0192) => q(ie),
      q(0194) => q(ia),
      q(0196) => q(id),
      q(0199) => q(ik),
      q(0202) => q(it),
      q(0203) => q(jv),
      q(0205) => q(ja),
      q(0211) => q(kl),
      q(0213) => q(kn),
      q(0215) => q(ks),
      q(0216) => q(kr),
      q(0218) => q(kk),
      q(0222) => q(km),
      q(0224) => q(ki),
      q(0225) => q(rw),
      q(0226) => q(ky),
      q(0229) => q(kv),
      q(0230) => q(kg),
      q(0231) => q(ko),
      q(0238) => q(kj),
      q(0240) => q(ku),
      q(0245) => q(lo),
      q(0246) => q(la),
      q(0247) => q(lv),
      q(0249) => q(li),
      q(0250) => q(ln),
      q(0251) => q(lt),
      q(0254) => q(lb),
      q(0256) => q(lu),
      q(0257) => q(lg),
      q(0262) => q(mk),
      q(0265) => q(mh),
      q(0268) => q(ml),
      q(0270) => q(mi),
      q(0272) => q(mr),
      q(0274) => q(ms),
      q(0283) => q(mg),
      q(0284) => q(mt),
      q(0289) => q(mn),
      q(0301) => q(na),
      q(0302) => q(nv),
      q(0303) => q(nr),
      q(0304) => q(nd),
      q(0305) => q(ng),
      q(0307) => q(ne),
      q(0312) => q(nn),
      q(0313) => q(nb),
      q(0316) => q(no),
      q(0321) => q(ny),
      q(0326) => q(oc),
      q(0327) => q(oj),
      q(0328) => q(or),
      q(0329) => q(om),
      q(0331) => q(os),
      q(0338) => q(pa),
      q(0342) => q(fa),
      q(0345) => q(pi),
      q(0346) => q(pl),
      q(0348) => q(pt),
      q(0351) => q(ps),
      q(0353) => q(qu),
      q(0358) => q(rm),
      q(0360) => q(ro),
      q(0361) => q(rn),
      q(0363) => q(ru),
      q(0365) => q(sg),
      q(0370) => q(sa),
      q(0381) => q(si),
      q(0385) => q(sk),
      q(0386) => q(sl),
      q(0388) => q(se),
      q(0392) => q(sm),
      q(0394) => q(sn),
      q(0395) => q(sd),
      q(0398) => q(so),
      q(0400) => q(st),
      q(0401) => q(es),
      q(0402) => q(sc),
      q(0404) => q(sr),
      q(0407) => q(ss),
      q(0409) => q(su),
      q(0412) => q(sw),
      q(0413) => q(sv),
      q(0416) => q(ty),
      q(0418) => q(ta),
      q(0419) => q(tt),
      q(0420) => q(te),
      q(0424) => q(tg),
      q(0425) => q(tl),
      q(0426) => q(th),
      q(0427) => q(bo),
      q(0429) => q(ti),
      q(0436) => q(to),
      q(0439) => q(tn),
      q(0440) => q(ts),
      q(0441) => q(tk),
      q(0444) => q(tr),
      q(0447) => q(tw),
      q(0451) => q(ug),
      q(0452) => q(uk),
      q(0455) => q(ur),
      q(0456) => q(uz),
      q(0458) => q(ve),
      q(0459) => q(vi),
      q(0460) => q(vo),
      q(0466) => q(cy),
      q(0468) => q(wa),
      q(0469) => q(wo),
      q(0471) => q(xh),
      q(0474) => q(yi),
      q(0475) => q(yo),
      q(0480) => q(za),
      q(0482) => q(zu),
      },
   q(alpha3) => {
      q(0001) => q(aar),
      q(0002) => q(abk),
      q(0003) => q(ace),
      q(0004) => q(ach),
      q(0005) => q(ada),
      q(0006) => q(ady),
      q(0007) => q(afa),
      q(0008) => q(afh),
      q(0009) => q(afr),
      q(0010) => q(ain),
      q(0011) => q(aka),
      q(0012) => q(akk),
      q(0013) => q(alb),
      q(0014) => q(ale),
      q(0015) => q(alg),
      q(0016) => q(alt),
      q(0017) => q(amh),
      q(0018) => q(ang),
      q(0019) => q(anp),
      q(0020) => q(apa),
      q(0021) => q(ara),
      q(0022) => q(arc),
      q(0023) => q(arg),
      q(0024) => q(arm),
      q(0025) => q(arn),
      q(0026) => q(arp),
      q(0027) => q(art),
      q(0028) => q(arw),
      q(0029) => q(asm),
      q(0030) => q(ast),
      q(0031) => q(ath),
      q(0032) => q(aus),
      q(0033) => q(ava),
      q(0034) => q(ave),
      q(0035) => q(awa),
      q(0036) => q(aym),
      q(0037) => q(aze),
      q(0038) => q(bad),
      q(0039) => q(bai),
      q(0040) => q(bak),
      q(0041) => q(bal),
      q(0042) => q(bam),
      q(0043) => q(ban),
      q(0044) => q(baq),
      q(0045) => q(bas),
      q(0046) => q(bat),
      q(0047) => q(bej),
      q(0048) => q(bel),
      q(0049) => q(bem),
      q(0050) => q(ben),
      q(0051) => q(ber),
      q(0052) => q(bho),
      q(0053) => q(bih),
      q(0054) => q(bik),
      q(0055) => q(bin),
      q(0056) => q(bis),
      q(0057) => q(bla),
      q(0058) => q(bnt),
      q(0059) => q(bos),
      q(0060) => q(bra),
      q(0061) => q(bre),
      q(0062) => q(btk),
      q(0063) => q(bua),
      q(0064) => q(bug),
      q(0065) => q(bul),
      q(0066) => q(bur),
      q(0067) => q(byn),
      q(0068) => q(cad),
      q(0069) => q(cai),
      q(0070) => q(car),
      q(0071) => q(cat),
      q(0072) => q(cau),
      q(0073) => q(ceb),
      q(0074) => q(cel),
      q(0075) => q(cha),
      q(0076) => q(chb),
      q(0077) => q(che),
      q(0078) => q(chg),
      q(0079) => q(chi),
      q(0080) => q(chk),
      q(0081) => q(chm),
      q(0082) => q(chn),
      q(0083) => q(cho),
      q(0084) => q(chp),
      q(0085) => q(chr),
      q(0086) => q(chu),
      q(0087) => q(chv),
      q(0088) => q(chy),
      q(0089) => q(cmc),
      q(0090) => q(cop),
      q(0091) => q(cor),
      q(0092) => q(cos),
      q(0093) => q(cpe),
      q(0094) => q(cpf),
      q(0095) => q(cpp),
      q(0096) => q(cre),
      q(0097) => q(crh),
      q(0098) => q(crp),
      q(0099) => q(csb),
      q(0100) => q(cus),
      q(0101) => q(cze),
      q(0102) => q(dak),
      q(0103) => q(dan),
      q(0104) => q(dar),
      q(0105) => q(day),
      q(0106) => q(del),
      q(0107) => q(den),
      q(0108) => q(dgr),
      q(0109) => q(din),
      q(0110) => q(div),
      q(0111) => q(doi),
      q(0112) => q(dra),
      q(0113) => q(dsb),
      q(0114) => q(dua),
      q(0115) => q(dum),
      q(0116) => q(dut),
      q(0117) => q(dyu),
      q(0118) => q(dzo),
      q(0119) => q(efi),
      q(0120) => q(egy),
      q(0121) => q(eka),
      q(0122) => q(elx),
      q(0123) => q(eng),
      q(0124) => q(enm),
      q(0125) => q(epo),
      q(0126) => q(est),
      q(0127) => q(ewe),
      q(0128) => q(ewo),
      q(0129) => q(fan),
      q(0130) => q(fao),
      q(0131) => q(fat),
      q(0132) => q(fij),
      q(0133) => q(fil),
      q(0134) => q(fin),
      q(0135) => q(fiu),
      q(0136) => q(fon),
      q(0137) => q(fre),
      q(0138) => q(frm),
      q(0139) => q(fro),
      q(0140) => q(frr),
      q(0141) => q(frs),
      q(0142) => q(fry),
      q(0143) => q(ful),
      q(0144) => q(fur),
      q(0145) => q(gaa),
      q(0146) => q(gay),
      q(0147) => q(gba),
      q(0148) => q(gem),
      q(0149) => q(geo),
      q(0150) => q(ger),
      q(0151) => q(gez),
      q(0152) => q(gil),
      q(0153) => q(gla),
      q(0154) => q(gle),
      q(0155) => q(glg),
      q(0156) => q(glv),
      q(0157) => q(gmh),
      q(0158) => q(goh),
      q(0159) => q(gon),
      q(0160) => q(gor),
      q(0161) => q(got),
      q(0162) => q(grb),
      q(0163) => q(grc),
      q(0164) => q(gre),
      q(0165) => q(grn),
      q(0166) => q(gsw),
      q(0167) => q(guj),
      q(0168) => q(gwi),
      q(0169) => q(hai),
      q(0170) => q(hat),
      q(0171) => q(hau),
      q(0172) => q(haw),
      q(0173) => q(heb),
      q(0174) => q(her),
      q(0175) => q(hil),
      q(0176) => q(him),
      q(0177) => q(hin),
      q(0178) => q(hit),
      q(0179) => q(hmn),
      q(0180) => q(hmo),
      q(0181) => q(hrv),
      q(0182) => q(hsb),
      q(0183) => q(hun),
      q(0184) => q(hup),
      q(0185) => q(iba),
      q(0186) => q(ibo),
      q(0187) => q(ice),
      q(0188) => q(ido),
      q(0189) => q(iii),
      q(0190) => q(ijo),
      q(0191) => q(iku),
      q(0192) => q(ile),
      q(0193) => q(ilo),
      q(0194) => q(ina),
      q(0195) => q(inc),
      q(0196) => q(ind),
      q(0197) => q(ine),
      q(0198) => q(inh),
      q(0199) => q(ipk),
      q(0200) => q(ira),
      q(0201) => q(iro),
      q(0202) => q(ita),
      q(0203) => q(jav),
      q(0204) => q(jbo),
      q(0205) => q(jpn),
      q(0206) => q(jpr),
      q(0207) => q(jrb),
      q(0208) => q(kaa),
      q(0209) => q(kab),
      q(0210) => q(kac),
      q(0211) => q(kal),
      q(0212) => q(kam),
      q(0213) => q(kan),
      q(0214) => q(kar),
      q(0215) => q(kas),
      q(0216) => q(kau),
      q(0217) => q(kaw),
      q(0218) => q(kaz),
      q(0219) => q(kbd),
      q(0220) => q(kha),
      q(0221) => q(khi),
      q(0222) => q(khm),
      q(0223) => q(kho),
      q(0224) => q(kik),
      q(0225) => q(kin),
      q(0226) => q(kir),
      q(0227) => q(kmb),
      q(0228) => q(kok),
      q(0229) => q(kom),
      q(0230) => q(kon),
      q(0231) => q(kor),
      q(0232) => q(kos),
      q(0233) => q(kpe),
      q(0234) => q(krc),
      q(0235) => q(krl),
      q(0236) => q(kro),
      q(0237) => q(kru),
      q(0238) => q(kua),
      q(0239) => q(kum),
      q(0240) => q(kur),
      q(0241) => q(kut),
      q(0242) => q(lad),
      q(0243) => q(lah),
      q(0244) => q(lam),
      q(0245) => q(lao),
      q(0246) => q(lat),
      q(0247) => q(lav),
      q(0248) => q(lez),
      q(0249) => q(lim),
      q(0250) => q(lin),
      q(0251) => q(lit),
      q(0252) => q(lol),
      q(0253) => q(loz),
      q(0254) => q(ltz),
      q(0255) => q(lua),
      q(0256) => q(lub),
      q(0257) => q(lug),
      q(0258) => q(lui),
      q(0259) => q(lun),
      q(0260) => q(luo),
      q(0261) => q(lus),
      q(0262) => q(mac),
      q(0263) => q(mad),
      q(0264) => q(mag),
      q(0265) => q(mah),
      q(0266) => q(mai),
      q(0267) => q(mak),
      q(0268) => q(mal),
      q(0269) => q(man),
      q(0270) => q(mao),
      q(0271) => q(map),
      q(0272) => q(mar),
      q(0273) => q(mas),
      q(0274) => q(may),
      q(0275) => q(mdf),
      q(0276) => q(mdr),
      q(0277) => q(men),
      q(0278) => q(mga),
      q(0279) => q(mic),
      q(0280) => q(min),
      q(0281) => q(mis),
      q(0282) => q(mkh),
      q(0283) => q(mlg),
      q(0284) => q(mlt),
      q(0285) => q(mnc),
      q(0286) => q(mni),
      q(0287) => q(mno),
      q(0288) => q(moh),
      q(0289) => q(mon),
      q(0290) => q(mos),
      q(0291) => q(mul),
      q(0292) => q(mun),
      q(0293) => q(mus),
      q(0294) => q(mwl),
      q(0295) => q(mwr),
      q(0296) => q(myn),
      q(0297) => q(myv),
      q(0298) => q(nah),
      q(0299) => q(nai),
      q(0300) => q(nap),
      q(0301) => q(nau),
      q(0302) => q(nav),
      q(0303) => q(nbl),
      q(0304) => q(nde),
      q(0305) => q(ndo),
      q(0306) => q(nds),
      q(0307) => q(nep),
      q(0308) => q(new),
      q(0309) => q(nia),
      q(0310) => q(nic),
      q(0311) => q(niu),
      q(0312) => q(nno),
      q(0313) => q(nob),
      q(0314) => q(nog),
      q(0315) => q(non),
      q(0316) => q(nor),
      q(0317) => q(nqo),
      q(0318) => q(nso),
      q(0319) => q(nub),
      q(0320) => q(nwc),
      q(0321) => q(nya),
      q(0322) => q(nym),
      q(0323) => q(nyn),
      q(0324) => q(nyo),
      q(0325) => q(nzi),
      q(0326) => q(oci),
      q(0327) => q(oji),
      q(0328) => q(ori),
      q(0329) => q(orm),
      q(0330) => q(osa),
      q(0331) => q(oss),
      q(0332) => q(ota),
      q(0333) => q(oto),
      q(0334) => q(paa),
      q(0335) => q(pag),
      q(0336) => q(pal),
      q(0337) => q(pam),
      q(0338) => q(pan),
      q(0339) => q(pap),
      q(0340) => q(pau),
      q(0341) => q(peo),
      q(0342) => q(per),
      q(0343) => q(phi),
      q(0344) => q(phn),
      q(0345) => q(pli),
      q(0346) => q(pol),
      q(0347) => q(pon),
      q(0348) => q(por),
      q(0349) => q(pra),
      q(0350) => q(pro),
      q(0351) => q(pus),
      q(0352) => q(qtz),
      q(0353) => q(que),
      q(0354) => q(raj),
      q(0355) => q(rap),
      q(0356) => q(rar),
      q(0357) => q(roa),
      q(0358) => q(roh),
      q(0359) => q(rom),
      q(0360) => q(rum),
      q(0361) => q(run),
      q(0362) => q(rup),
      q(0363) => q(rus),
      q(0364) => q(sad),
      q(0365) => q(sag),
      q(0366) => q(sah),
      q(0367) => q(sai),
      q(0368) => q(sal),
      q(0369) => q(sam),
      q(0370) => q(san),
      q(0371) => q(sas),
      q(0372) => q(sat),
      q(0373) => q(scn),
      q(0374) => q(sco),
      q(0375) => q(sel),
      q(0376) => q(sem),
      q(0377) => q(sga),
      q(0378) => q(sgn),
      q(0379) => q(shn),
      q(0380) => q(sid),
      q(0381) => q(sin),
      q(0382) => q(sio),
      q(0383) => q(sit),
      q(0384) => q(sla),
      q(0385) => q(slo),
      q(0386) => q(slv),
      q(0387) => q(sma),
      q(0388) => q(sme),
      q(0389) => q(smi),
      q(0390) => q(smj),
      q(0391) => q(smn),
      q(0392) => q(smo),
      q(0393) => q(sms),
      q(0394) => q(sna),
      q(0395) => q(snd),
      q(0396) => q(snk),
      q(0397) => q(sog),
      q(0398) => q(som),
      q(0399) => q(son),
      q(0400) => q(sot),
      q(0401) => q(spa),
      q(0402) => q(srd),
      q(0403) => q(srn),
      q(0404) => q(srp),
      q(0405) => q(srr),
      q(0406) => q(ssa),
      q(0407) => q(ssw),
      q(0408) => q(suk),
      q(0409) => q(sun),
      q(0410) => q(sus),
      q(0411) => q(sux),
      q(0412) => q(swa),
      q(0413) => q(swe),
      q(0414) => q(syc),
      q(0415) => q(syr),
      q(0416) => q(tah),
      q(0417) => q(tai),
      q(0418) => q(tam),
      q(0419) => q(tat),
      q(0420) => q(tel),
      q(0421) => q(tem),
      q(0422) => q(ter),
      q(0423) => q(tet),
      q(0424) => q(tgk),
      q(0425) => q(tgl),
      q(0426) => q(tha),
      q(0427) => q(tib),
      q(0428) => q(tig),
      q(0429) => q(tir),
      q(0430) => q(tiv),
      q(0431) => q(tkl),
      q(0432) => q(tlh),
      q(0433) => q(tli),
      q(0434) => q(tmh),
      q(0435) => q(tog),
      q(0436) => q(ton),
      q(0437) => q(tpi),
      q(0438) => q(tsi),
      q(0439) => q(tsn),
      q(0440) => q(tso),
      q(0441) => q(tuk),
      q(0442) => q(tum),
      q(0443) => q(tup),
      q(0444) => q(tur),
      q(0445) => q(tut),
      q(0446) => q(tvl),
      q(0447) => q(twi),
      q(0448) => q(tyv),
      q(0449) => q(udm),
      q(0450) => q(uga),
      q(0451) => q(uig),
      q(0452) => q(ukr),
      q(0453) => q(umb),
      q(0454) => q(und),
      q(0455) => q(urd),
      q(0456) => q(uzb),
      q(0457) => q(vai),
      q(0458) => q(ven),
      q(0459) => q(vie),
      q(0460) => q(vol),
      q(0461) => q(vot),
      q(0462) => q(wak),
      q(0463) => q(wal),
      q(0464) => q(war),
      q(0465) => q(was),
      q(0466) => q(wel),
      q(0467) => q(wen),
      q(0468) => q(wln),
      q(0469) => q(wol),
      q(0470) => q(xal),
      q(0471) => q(xho),
      q(0472) => q(yao),
      q(0473) => q(yap),
      q(0474) => q(yid),
      q(0475) => q(yor),
      q(0476) => q(ypk),
      q(0477) => q(zap),
      q(0478) => q(zbl),
      q(0479) => q(zen),
      q(0480) => q(zha),
      q(0481) => q(znd),
      q(0482) => q(zul),
      q(0483) => q(zun),
      q(0484) => q(zxx),
      q(0485) => q(zza),
      },
   q(term) => {
      q(0013) => q(sqi),
      q(0024) => q(hye),
      q(0044) => q(eus),
      q(0066) => q(mya),
      q(0079) => q(zho),
      q(0101) => q(ces),
      q(0116) => q(nld),
      q(0137) => q(fra),
      q(0149) => q(kat),
      q(0150) => q(deu),
      q(0164) => q(ell),
      q(0187) => q(isl),
      q(0262) => q(mkd),
      q(0270) => q(mri),
      q(0274) => q(msa),
      q(0342) => q(fas),
      q(0360) => q(ron),
      q(0385) => q(slk),
      q(0427) => q(bod),
      q(0466) => q(cym),
      },
);



1;
