#!/usr/bin/perl -w

use Test::Inter;
$t = new Test::Inter 'all_periods';
$testdir = '';
$testdir = $t->testdir();

use Date::Manip;
if (DateManipVersion() >= 6.00) {
   $t->feature("DM6",1);
}

$t->skip_all('Date::Manip 6.xx required','DM6');


sub test {
  (@test)=@_;
  @per = $obj->all_periods(@test);
  @ret = ();
  foreach my $per (@per) {
     push(@ret,@$per);
  }
  return @ret;
}

$obj = new Date::Manip::TZ;
$obj->config("forcedate","now,America/New_York");

$tests="
America/New_York 0001 =>
   [ 1 1 2 0 0 0 ]
   [ 1 1 1 19 3 58 ]
   -04:56:02
   [ -4 -56 -2 ]
   LMT
   0
   [ 1883 11 18 16 59 59 ]
   [ 1883 11 18 12 3 57 ]
   0001010200:00:00
   0001010119:03:58
   1883111816:59:59
   1883111812:03:57

America/New_York 1 =>
   [ 1 1 2 0 0 0 ]
   [ 1 1 1 19 3 58 ]
   -04:56:02
   [ -4 -56 -2 ]
   LMT
   0
   [ 1883 11 18 16 59 59 ]
   [ 1883 11 18 12 3 57 ]
   0001010200:00:00
   0001010119:03:58
   1883111816:59:59
   1883111812:03:57

America/New_York 1800 =>
   [ 1 1 2 0 0 0 ]
   [ 1 1 1 19 3 58 ]
   -04:56:02
   [ -4 -56 -2 ]
   LMT
   0
   [ 1883 11 18 16 59 59 ]
   [ 1883 11 18 12 3 57 ]
   0001010200:00:00
   0001010119:03:58
   1883111816:59:59
   1883111812:03:57

America/New_York 1883 =>
   [ 1 1 2 0 0 0 ]
   [ 1 1 1 19 3 58 ]
   -04:56:02
   [ -4 -56 -2 ]
   LMT
   0
   [ 1883 11 18 16 59 59 ]
   [ 1883 11 18 12 3 57 ]
   0001010200:00:00
   0001010119:03:58
   1883111816:59:59
   1883111812:03:57
   [ 1883 11 18 17 0 0 ]
   [ 1883 11 18 12 0 0 ]
   -05:00:00
   [ -5 0 0 ]
   EST
   0
   [ 1918 3 31 6 59 59 ]
   [ 1918 3 31 1 59 59 ]
   1883111817:00:00
   1883111812:00:00
   1918033106:59:59
   1918033101:59:59

America/New_York 1926 =>
   [ 1925 9 27 6 0 0 ]
   [ 1925 9 27 1 0 0 ]
   -05:00:00
   [ -5 0 0 ]
   EST
   0
   [ 1926 4 25 6 59 59 ]
   [ 1926 4 25 1 59 59 ]
   1925092706:00:00
   1925092701:00:00
   1926042506:59:59
   1926042501:59:59
   [ 1926 4 25 7 0 0 ]
   [ 1926 4 25 3 0 0 ]
   -04:00:00
   [ -4 0 0 ]
   EDT
   1
   [ 1926 9 26 5 59 59 ]
   [ 1926 9 26 1 59 59 ]
   1926042507:00:00
   1926042503:00:00
   1926092605:59:59
   1926092601:59:59
   [ 1926 9 26 6 0 0 ]
   [ 1926 9 26 1 0 0 ]
   -05:00:00
   [ -5 0 0 ]
   EST
   0
   [ 1927 4 24 6 59 59 ]
   [ 1927 4 24 1 59 59 ]
   1926092606:00:00
   1926092601:00:00
   1927042406:59:59
   1927042401:59:59

America/New_York 2037 =>
   [ 2036 11 2 6 0 0 ]
   [ 2036 11 2 1 0 0 ]
   -05:00:00
   [ -5 0 0 ]
   EST
   0
   [ 2037 3 8 6 59 59 ]
   [ 2037 3 8 1 59 59 ]
   2036110206:00:00
   2036110201:00:00
   2037030806:59:59
   2037030801:59:59
   [ 2037 3 8 7 0 0 ]
   [ 2037 3 8 3 0 0 ]
   -04:00:00
   [ -4 0 0 ]
   EDT
   1
   [ 2037 11 1 5 59 59 ]
   [ 2037 11 1 1 59 59 ]
   2037030807:00:00
   2037030803:00:00
   2037110105:59:59
   2037110101:59:59
   [ 2037 11 1 6 0 0 ]
   [ 2037 11 1 1 0 0 ]
   -05:00:00
   [ -5 0 0 ]
   EST
   0
   [ 2038 3 14 6 59 59 ]
   [ 2038 3 14 1 59 59 ]
   2037110106:00:00
   2037110101:00:00
   2038031406:59:59
   2038031401:59:59

America/New_York 2100 =>
   [ 2099 11 1 6 0 0 ]
   [ 2099 11 1 1 0 0 ]
   -05:00:00
   [ -5 0 0 ]
   EST
   0
   [ 2100 3 14 6 59 59 ]
   [ 2100 3 14 1 59 59 ]
   2099110106:00:00
   2099110101:00:00
   2100031406:59:59
   2100031401:59:59
   [ 2100 3 14 7 0 0 ]
   [ 2100 3 14 3 0 0 ]
   -04:00:00
   [ -4 0 0 ]
   EDT
   1
   [ 2100 11 7 5 59 59 ]
   [ 2100 11 7 1 59 59 ]
   2100031407:00:00
   2100031403:00:00
   2100110705:59:59
   2100110701:59:59
   [ 2100 11 7 6 0 0 ]
   [ 2100 11 7 1 0 0 ]
   -05:00:00
   [ -5 0 0 ]
   EST
   0
   [ 2101 3 13 6 59 59 ]
   [ 2101 3 13 1 59 59 ]
   2100110706:00:00
   2100110701:00:00
   2101031306:59:59
   2101031301:59:59

";

$t->tests(func  => \&test,
          tests => $tests);
$t->done_testing();

#Local Variables:
#mode: cperl
#indent-tabs-mode: nil
#cperl-indent-level: 3
#cperl-continued-statement-offset: 2
#cperl-continued-brace-offset: 0
#cperl-brace-offset: 0
#cperl-brace-imaginary-offset: 0
#cperl-label-offset: 0
#End:
