#############################################################################
#
# RPM-specific routines for CPAN::MetaMuncher
#
# Author:  Chris Weyl (cpan:RSRCHBOY), <cweyl@alumni.drew.edu>
# Company: No company, personal work
#
# Copyright (c) 2009-2010 Chris Weyl <cweyl@alumni.drew.edu>
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
#############################################################################

package CPAN::MetaMuncher::TraitFor::RPMInfo;

use Moose::Role;
use namespace::autoclean;
use Carp;

our $VERSION = '0.007_02';

# debugging
#use Smart::Comments '###', '####';

#############################################################################
# RPM requires/needs

has _rpm_build_requires => (
    traits => ['Hash'], is => 'ro', isa => 'HashRef[Str]', lazy_build => 1,

    handles => {
        #'' => '_rpm_build_requires',
        num_rpm_build_requires      => 'count',
        no_rpm_build_requires       => 'is_empty',
        has_any_rpm_build_requires  => 'count',
        has_rpm_build_requires      => 'count',
        has_rpm_br_on               => 'exists',
        rpm_build_requires          => 'keys',
        rpm_build_require_version   => 'get',
        rpm_build_requires_kv_pairs => 'kv',

        # huh?! make sure we're not actually trying to use this somewhere and
        # remove
        full_rpm_build_requires => 'elements',
    },
);

sub _build__rpm_build_requires {
    shift->_rpm_requires_from_meta_keys(
        qw(requires configure_requires build_requires)
    );
}

before has_any_rpm_build_requires => sub {

    carp 'has_any_rpm_build_requires is depreciated; '
       . 'use has_rpm_build_requires instead!';
};

has _rpm_requires => (
    traits => ['Hash'], is => 'ro', isa => 'HashRef[Str]', lazy_build => 1,

    handles => {
        #'' => '_rpm_build_requires',
        num_rpm_requires      => 'count',
        no_rpm_requires       => 'is_empty',
        has_any_rpm_requires  => 'count',
        has_rpm_requires      => 'count',
        has_rpm_require_on    => 'exists',
        rpm_requires          => 'keys',
        rpm_require_version   => 'get',
        rpm_requires_kv_pairs => 'kv',

        # huh?! make sure we're not actually trying to use this somewhere and
        # remove
        full_rpm_requires => 'elements',
    },
);

sub _build__rpm_requires { shift->_rpm_requires_from_meta_keys('requires') }

sub _rpm_requires_from_meta_keys {
    my $self = shift @_;
    my @keys = @_;

    my %req = ();
    BR_LOOP:
    for my $key (@keys) {

        next BR_LOOP unless $self->has_meta_key($key);
        my %more = %{ $self->meta_value_for($key) };
        $req{"perl($_)"} = $more{$_} foreach keys %more;
        #%req = (%req, %more);
    }

    # until we figure out what to do with this...
    do{ delete $req{"perl($_)"} if exists $req{"perl($_)"} }
        foreach qw{ perl strict warnings overload attributes };

    ### %req
    return \%req;
}

1;

__END__

=head1 NAME

CPAN::MetaMuncher - Generate RPM-specific dependency information

=head1 SYNOPSIS

    use CPAN::MetaMuncher;

    # ...
    my $mm = CPAN::MetaMuncher->with_traits('RPMInfo')->new(module => "Some::Name");


=head1 DESCRIPTION

B<WARNING: This is VERY early code.>

This trait adds methods and attributes to L<CPAN::MetaMuncher> that
generate RPM-specific metadata information.  If you're writing something that
wants to examine CPAN/Perl dependencies against an RPM-managed system or needs
to express dependencies in a way RPM will understand it, then this trait is
for you.

=head1 BUILD REQUIRES

In brief, build requires are generated by looking at the requires,
configure_requires, and build_requires values.

=head2 num_rpm_build_requires

=head2 no_rpm_build_requires

=head2 has_rpm_build_requires

=head2 has_any_rpm_build_requires

Depreciated legacy alias for has_rpm_build_requires.  Don't use this :)

=head2 has_rpm_br_on

=head2 rpm_build_requires

=head2 rpm_build_require_version

=head2 rpm_build_requires_kv_pairs

=head1 REQUIRES

In brief, requires are generated by looking at the requires values.

=head2 num_rpm_requires

=head2 no_rpm_requires

=head2 has_any_rpm_requires

=head2 has_rpm_requires

=head2 has_rpm_require_on

=head2 rpm_requires

=head2 rpm_require_version

=head2 rpm_requires_kv_pairs

=head1 SEE ALSO

L<CPAN::MetaMuncher>

=head1 AUTHOR

Chris Weyl <cweyl@alumni.drew.edu>

=head1 LICENSE AND COPYRIGHT

Copyright (c) 2009-2010 Chris Weyl <cweyl@alumni.drew.edu>

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the

    Free Software Foundation, Inc.
    59 Temple Place, Suite 330
    Boston, MA  02111-1307  USA

=cut



