#!perl -T
use 5.006;
use strict;
use warnings;
use Test::More;
use Test::Exception;
use Test::MockModule;

BEGIN {
    use_ok( 'Firewall::PaloAlto::Panorama' ) || print "Bail out!\n";
}

#As we're only testing parameter validation, we mock the module so that we don't need to connect
#to an actual Panorama device
my $pa_mocked = new Test::MockModule('Firewall::PaloAlto::Panorama');
$pa_mocked->mock('connect', sub { return 1; });
$pa_mocked->mock('_create_requester', sub { return sub { return 1; } });

my $pa;

ok( $pa = Firewall::PaloAlto::Panorama->new(host => 'panorama.local', username => 'admin', password => 'admin', ssl => 0 ) );
ok( $pa->connect(), 'connect() returns 1');

#We define an array of hashes, each hash being containing:
#a) One of the functions
#b) An array of 'set' parameters that should succeeed and an array of 'set' parameters that should fail
#c) An array for 'get' and 'delete' parameters that should succeeed and fail.
my $tests = [ 
                {   function => $pa->can('template'),
                    actions =>  {   set =>  {   lives =>    [ 
                                                            { name => 'a', description => 'b' },
                                                            { name => 'a' }
                                                            ],
                                                dies =>     [ 
                                                            { description => 'description' },
                                                            {},
                                                            ] 
                                            },
                                    get =>  {   lives =>    [   { name => 'a' } ],
                                                dies =>     [   
                                                            { name => 'a', desription => 'b' },
                                                            { incorrect => 'a'},
                                                            {},
                                                            ],
                                            },
                                    delete => { lives =>    [ { name => 'a' } ],
                                                dies =>     [   
                                                            { name => 'a', desription => 'b' },
                                                            { incorrect => 'a'},
                                                            {},
                                                            ],
                                              },
                                }
                },
                {   function => $pa->can('template_stack'),
                    actions =>  {   set =>  {   lives =>    [
                                                            { name => 't', templates => ['t', 't'] },
                                                            { name => 't', templates => ['t1', 't1'], description => 'd' },
                                                            ],
                                                dies =>     [
                                                            { name => 't', templates => 't1' },
                                                            { name => 't' },
                                                            {},
                                                            ]
                                            },
                                    get =>  {   lives =>    [   
                                                            { name => 't' }
                                                            ],
                                                dies =>     [   
                                                            { name => 't', templates => 't1' },
                                                            { incorrect => 't'},
                                                            {},
                                                            ],
                                            },
                                    delete => { lives =>    [
                                                            { name => 't' }
                                                            ],
                                                dies =>     [
                                                            { name => 't', templates => 't1' },
                                                            { incorrect => 'a'},
                                                            {},
                                                            ],
                                              },
                                }
                },
                {   function => $pa->can('devicegroup'),
                    actions =>  {   set =>  {   lives =>    [ 
                                                            { name => 'd', }, 
                                                            { name => 'd', description => 'desc' }, 
                                                            ],
                                                dies =>     [ 
                                                            { description => 'desc' },
                                                            { incorrect => 'desc' },
                                                            {},
                                                            ]
                                            },
                                    get =>  {   lives =>    [
                                                            { name => 'd' }
                                                            ],
                                                dies =>     [  
                                                            { name => 'd', description => 'desc' },
                                                            { description => 'd'},
                                                            { incorrect => 'd'},
                                                            {},
                                                            ],
                                            },
                                    delete => { lives =>    [ 
                                                            { name => 'd' }
                                                            ],
                                                dies =>     [
                                                            { name => 'd', description => 'desc' },
                                                            { description => 'desc' },
                                                            { incorrect => 'a'},
                                                            {},
                                                            ],
                                              },
                                }
                },
                {   function => $pa->can('vsys'),
                    actions =>  {   set =>  {   lives =>    [
                                                            { template=> 't', name => 'vsys', max_sessions => 1, max_rules => 1 },
                                                            ],
                                                dies =>     [
                                                            { name => 'vsys_name', max_sessions => 1, max_rules => 1 },
                                                            { template => 'template', max_sessions => 1, max_rules => 1 },
                                                            { template => 'template', name => 'vsys_name', max_rules => 1 },
                                                            { template => 'template', name => 'vsys_name', max_sessions => 1 },
                                                            ]
                                            },
                                    get =>  {   lives =>    [
                                                            { template => 't', name => 'vsys' }
                                                            ],
                                                dies =>     [
                                                            { template => 't', max_sessions => 1 },
                                                            { template => 't', max_rules => 1 },
                                                            { incorrect => 't'},
                                                            {},
                                                            ],
                                            },
                                    delete => { lives =>    [
                                                            { template => 't', name => 'vsys' }
                                                            ],
                                                dies =>     [
                                                            { template => 't', max_sessions => 1 },
                                                            { template => 't', max_rules => 1 },
                                                            { incorrect => 't'},
                                                            {},
                                                            ],
                                              },
                                }
                },

            ];


#Run through the test array and perform the tests for each function:
foreach my $test_func ( @{ $tests } ) {
    #Test to make sure an invalid action throws an exception
    dies_ok { $test_func->{function}->($pa, 'incorrect_action') };

    #Iterate through each action ('set', 'get' and 'delete'
    while (my ($action, $action_tests) = each %{ $test_func->{actions} }) {

        #Iterate through the test arguments for the ones that should live
        foreach my $test_args ( @{ $action_tests->{lives} }) {
            lives_ok { $test_func->{function}->($pa, $action, %{ $test_args }) };
        }

        #Iterate through the test arguments for the ones that should die
        foreach my $test_args ( @{ $action_tests->{dies} }) {
            dies_ok{ $test_func->{function}->($pa, $action, %{ $test_args }) };
        }
    }
}



done_testing();
