# This Makefile.PL for UV was generated by
# Dist::Zilla::Plugin::MakeMaker::Awesome 0.48.
# Don't edit it but the dist.ini and plugins used to construct it.

use strict;
use warnings;

use ExtUtils::MakeMaker;

use Alien::Base::Wrapper ();

my %xsbuild;

if( defined eval { require ExtUtils::PkgConfig; ExtUtils::PkgConfig->find( "libuv" ) } ) {
    my @cflags = split m/ /, ExtUtils::PkgConfig->cflags("libuv") // "";
    my @libs   = split m/ /, ExtUtils::PkgConfig->libs("libuv");

    %xsbuild = (
        INC  => join( " ", grep { m/^-I/ } @cflags ),
        LIBS    => [          grep {  m/-l/i } @libs ],
        LDFLAGS => join( " ", grep { !m/-l/  } @libs ),
    );
}
else {
    %xsbuild = Alien::Base::Wrapper->new('Alien::libuv')->mm_args2;
}

# Our cpanfile contains the proper configure requires already
delete $xsbuild{CONFIGURE_REQUIRES};

# We keep our XS file in the right place in lib/
$xsbuild{XSMULTI} = 1;

# Append our hax/ directory
$xsbuild{INC} .= " -Ihax";

my %WriteMakefileArgs = (
  "ABSTRACT" => "Perl interface to libuv",
  "AUTHOR" => "Chase Whitener <capoeirab\@cpan.org>, Daisuke Murase <typester\@cpan.org>",
  "BUILD_REQUIRES" => {
    "Alien::Base::Wrapper" => 0,
    "Alien::libuv" => "1.000",
    "Config" => 0,
    "ExtUtils::MakeMaker" => "7.12",
  },
  "CONFIGURE_REQUIRES" => {
    "Alien::Base::Wrapper" => 0,
    "Alien::libuv" => "1.000",
    "ExtUtils::MakeMaker" => "7.12"
  },
  "DISTNAME" => "UV",
  "LICENSE" => "perl",
  "NAME" => "UV",
  "PREREQ_PM" => {
    "Alien::libuv" => "1.000",
    "Carp" => 0,
    "Exporter" => "5.57",
    "Scalar::Util" => 0,
    "XSLoader" => "0.14",
    "parent" => 0,
    "strict" => 0,
    "warnings" => 0
  },
  "TEST_REQUIRES" => {
    "Alien::libuv" => "1.000",
    "Errno" => 0,
    "ExtUtils::MakeMaker" => "7.12",
    "File::Spec" => 0,
    "FindBin" => 0,
    "IO::Handle" => 0,
    "IO::Socket::INET" => 0,
    "POSIX" => 0,
    "Socket" => 0,
    "Test::More" => "0.88",
    "Try::Tiny" => 0
  },
  "VERSION" => "1.900",
  "test" => {
    "TESTS" => "t/*.t"
  }
);

%WriteMakefileArgs = (
    %WriteMakefileArgs,
    %xsbuild,
);

my %FallbackPrereqs = (
  "Alien::Base::Wrapper" => 0,
  "Alien::libuv" => "1.000",
  "Carp" => 0,
  "Config" => 0,
  "Errno" => 0,
  "Exporter" => "5.57",
  "ExtUtils::MakeMaker" => "7.12",
  "File::Spec" => 0,
  "FindBin" => 0,
  "IO::Handle" => 0,
  "IO::Socket::INET" => 0,
  "POSIX" => 0,
  "Scalar::Util" => 0,
  "Socket" => 0,
  "Test::More" => "0.88",
  "Try::Tiny" => 0,
  "XSLoader" => "0.14",
  "parent" => 0,
  "strict" => 0,
  "warnings" => 0
);

unless ( eval { ExtUtils::MakeMaker->VERSION('6.63_03') } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);
