package Bencher::Scenario::IPCRun::run_overhead;

our $DATE = '2016-10-13'; # DATE
our $VERSION = '0.001'; # VERSION

use strict;
use warnings;

our $scenario = {
    summary => "Benchmark overhead of run() vs core's system()",
    modules => {
    },
    participants => [
        {
            fcall_template => 'IPC::Run::run(["true"]) or die',
        },
        {
            name => 'system',
            code_template => 'system("true"); $? and die',
        },
    ],
};

1;
# ABSTRACT: Benchmark overhead of run() vs core's system()

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::IPCRun::run_overhead - Benchmark overhead of run() vs core's system()

=head1 VERSION

This document describes version 0.001 of Bencher::Scenario::IPCRun::run_overhead (from Perl distribution Bencher-Scenarios-IPCRun), released on 2016-10-13.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m IPCRun::run_overhead

To run module startup overhead benchmark:

 % bencher --module-startup -m IPCRun::run_overhead

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<IPC::Run> 0.94

=head1 BENCHMARK PARTICIPANTS

=over

=item * IPC::Run::run (perl_code)

Function call template:

 IPC::Run::run(["true"]) or die



=item * system (perl_code)

Code template:

 system("true"); $? and die



=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.24.0 >>, CPU: I<< Intel(R) Core(TM) M-5Y71 CPU @ 1.20GHz (2 cores) >>, OS: I<< GNU/Linux LinuxMint version 17.3 >>, OS kernel: I<< Linux version 3.19.0-32-generic >>.

Benchmark with default options (C<< bencher -m IPCRun::run_overhead >>):

 #table1#
 +---------------+-----------+-----------+------------+---------+---------+
 | participant   | rate (/s) | time (ms) | vs_slowest |  errors | samples |
 +---------------+-----------+-----------+------------+---------+---------+
 | IPC::Run::run |       203 |      4.93 |        1   | 4.6e-06 |      21 |
 | system        |       230 |      4.3  |        1.2 | 9.5e-06 |      20 |
 +---------------+-----------+-----------+------------+---------+---------+


Benchmark module startup overhead (C<< bencher -m IPCRun::run_overhead --module-startup >>):

 #table2#
 +---------------------+-----------+------------------------+------------+---------+---------+
 | participant         | time (ms) | mod_overhead_time (ms) | vs_slowest |  errors | samples |
 +---------------------+-----------+------------------------+------------+---------+---------+
 | IPC::Run            |      34.7 |                   29.3 |        1   | 1.9e-05 |      21 |
 | perl -e1 (baseline) |       5.4 |                    0   |        6.5 | 1.2e-05 |      20 |
 +---------------------+-----------+------------------------+------------+---------+---------+

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-IPCRun>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-IPCRun>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-IPCRun>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
