package Bencher::Scenario::Accessors::GeneratorStartup;

our $DATE = '2016-04-14'; # DATE
our $VERSION = '0.05'; # VERSION

use Bencher::ScenarioUtil::Accessors;

my $classes = \%Bencher::ScenarioUtil::Accessors::classes;

our $scenario = {
    summary => 'Benchmark startup of various accessor generators',
    module_startup => 1,
    modules => {
    },
    participants => [
        map {
            my $spec = $classes->{$_};
            +{ (module=>$spec->{generator}) x !!$spec->{generator} };
        } keys %$classes,
    ],
};

1;
# ABSTRACT: Benchmark startup of various accessor generators

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::Accessors::GeneratorStartup - Benchmark startup of various accessor generators

=head1 VERSION

This document describes version 0.05 of Bencher::Scenario::Accessors::GeneratorStartup (from Perl distribution Bencher-Scenarios-Accessors), released on 2016-04-14.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m Accessors::GeneratorStartup

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Class::Accessor> 0.34

L<Class::Accessor::Array> 0.02

L<Class::InsideOut> 1.13

L<Class::XSAccessor> 1.19

L<Class::XSAccessor::Array> 1.19

L<Mo> 0.39

L<Moo> 2.000002

L<Moose> 2.1405

L<Mouse> 2.4.2

=head1 BENCHMARK PARTICIPANTS

=over

=item * Class::XSAccessor::Array (perl_code)

L<Class::XSAccessor::Array>



=item * Class::Accessor::Array (perl_code)

L<Class::Accessor::Array>



=item * Class::Accessor (perl_code)

L<Class::Accessor>



=item * Moo (perl_code)

L<Moo>



=item *  (perl_code)



=item * Class::XSAccessor (perl_code)

L<Class::XSAccessor>



=item * Mouse (perl_code)

L<Mouse>



=item *  (perl_code)



=item * Moose (perl_code)

L<Moose>



=item *  (perl_code)



=item * Mo (perl_code)

L<Mo>



=item * Class::InsideOut (perl_code)

L<Class::InsideOut>



=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.0 >>, CPU: I<< Intel(R) Core(TM) i7-4770 CPU @ 3.40GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m Accessors::GeneratorStartup >>):

 +--------------------------+-----------+------------------------+------------+---------+---------+
 | participant              | time (ms) | mod_overhead_time (ms) | vs_slowest | errors  | samples |
 +--------------------------+-----------+------------------------+------------+---------+---------+
 | Moose                    | 1.1e+02   | 107.4                  | 1          | 0.00013 | 20      |
 | Mouse                    | 18        | 15.4                   | 6.3        | 8.5e-05 | 20      |
 | Moo                      | 14        | 11.4                   | 7.8        | 3.3e-05 | 20      |
 | Class::InsideOut         | 11        | 8.4                    | 10         | 3.1e-05 | 23      |
 | Class::XSAccessor::Array | 7.7       | 5.1                    | 14         | 2.7e-05 | 20      |
 | Class::Accessor          | 7.4       | 4.8                    | 15         | 1.8e-05 | 20      |
 | Class::XSAccessor        | 7.3       | 4.7                    | 15         | 9.8e-06 | 22      |
 | Mo                       | 4.2       | 1.6                    | 26         | 3e-05   | 20      |
 | Class::Accessor::Array   | 4         | 1.4                    | 28         | 2e-05   | 20      |
 | perl -e1 (baseline)      | 2.6       | 0                      | 43         | 7.4e-06 | 20      |
 +--------------------------+-----------+------------------------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-Accessors>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-Accessors>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-Accessors>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
