package Acme::CPANAuthors::CPAN::TopDepended::ByOthers;

our $DATE = '2016-10-14'; # DATE
our $VERSION = '0.002'; # VERSION

use strict;
use warnings;

use Acme::CPANAuthors::Register (
    "EXODIST"   => "Chad Granum",                           #  18178
    "BINGOS"    => "Chris Williams",                        #  15964
    "RJBS"      => "Ricardo SIGNES",                        #  11147
    "ETHER"     => "Karen Etheridge",                       #   8807
    "LEONT"     => "Leon Timmermans",                       #   5574
    "DAGOLDEN"  => "David Golden",                          #   3798
    "GBARR"     => "Graham Barr",                           #   3622
    "PEVANS"    => "Paul Evans",                            #   3169
    "NEILB"     => "Neil Bowers",                           #   2929
    "GAAS"      => "Gisle Aas",                             #   2276
    "TODDR"     => "Todd Rinaldo",                          #   2224
    "SMUELLER"  => "Steffen Mueller",                       #   2087
    "DROLSKY"   => "Dave Rolsky",                           #   2045
    "CORION"    => "Max Maischein",                         #   1451
    "BARBIE"    => "Barbie",                                #   1296
    "REHSACK"   => "Jens Rehsack",                          #   1235
    "TOKUHIROM" => "Tokuhiro Matsuno''<xmp>",               #   1171
    "ISHIGAKI"  => "Kenichi Ishigaki",                      #   1168
    "ADAMK"     => "Adam Kennedy",                          #   1087
    "MIYAGAWA"  => "Tatsuhiko Miyagawa",                    #   1056
    "DANKOGAI"  => "Dan Kogai",                             #    924
    "MLEHMANN"  => "Marc A. Lehmann",                       #    906
    "HAARG"     => "Graham Knop",                           #    904
    "JV"        => "Johan Vromans",                         #    890
    "RIBASUSHI" => "Peter Rabbitson",                       #    878
    "TIMB"      => "Tim Bunce",                             #    841
    "SHLOMIF"   => "Shlomi Fish",                           #    838
    "TINITA"    => "Tina Muller",                           #    816
    "JHI"       => "Jarkko Hietaniemi",                     #    808
    "BOBTFISH"  => "Tomas Doran",                           #    774
    "RICHE"     => "Richard Elberger",                      #    754
    "TOBYINK"   => "Toby Inkster",                          #    677
    "KASEI"     => "Marty Pauley",                          #    662
    "PLICEASE"  => "Graham Ollis",                          #    657
    "CHORNY"    => "Alexandr Ciornii",                      #    643
    "OVID"      => "Curtis 'Ovid' Poe",                     #    619
    "KWILLIAMS" => "Ken Williams",                          #    612
    "SRI"       => "Sebastian Riedel",                      #    594
    "URI"       => "Uri Guttman",                           #    591
    "MAREKR"    => "Marek Rouchal",                         #    573
    "JJNAPIORK" => "John Napiorkowski",                     #    572
    "SYOHEX"    => "Syohei Yoshida",                        #    543
    "MSCHILLI"  => "Michael Schilli",                       #    540
    "FREW"      => "Arthur Axel 'fREW' Schmidt",            #    523
    "ABW"       => "Andy Wardley",                          #    522
    "AMS"       => "Abhijit Menon-Sen",                     #    507
    "INGY"      => "Ingy dot Net",                          #    502
    "ZEFRAM"    => "Andrew Main (Zefram)",                  #    491
    "SARTAK"    => "Shawn M Moore",                         #    472
    "GRANTM"    => "Grant McLean",                          #    461


);

1;
# ABSTRACT: Authors with the largest number of other authors' distributions depending on one of his/her modules

__END__

=pod

=encoding UTF-8

=head1 NAME

Acme::CPANAuthors::CPAN::TopDepended::ByOthers - Authors with the largest number of other authors' distributions depending on one of his/her modules

=head1 VERSION

This document describes version 0.002 of Acme::CPANAuthors::CPAN::TopDepended::ByOthers (from Perl distribution Acme-CPANAuthors-CPAN-TopDepended-ByOthers), released on 2016-10-14.

=head1 SYNOPSIS

   use Acme::CPANAuthors;
   use Acme::CPANAuthors::TopDepended::ByOthers;

   my $authors = Acme::CPANAuthors->new('CPAN::TopDepended::ByOthers');

   my $number   = $authors->count;
   my @ids      = $authors->id;
   my @distros  = $authors->distributions('RJBS');
   my $url      = $authors->avatar_url('RJBS');
   my $kwalitee = $authors->kwalitee('RJBS');

=head1 DESCRIPTION

This module, like L<Acme::CPANAuthors::CPAN::TopDepended>, lists 50 CPAN authors
with the largest number of distributions directly depending to one of his/her
modules. The difference is, only distributions by other authors are counted.
This in some cases might be a better indication of how "depended upon" an author
is, as some authors might have modules that are mostly depended by his/her own
distributions.

This list is produced by querying a local mini CPAN mirror using this command:

 % lcpan authors-by-rdep-count --exclude-same-author | head -n 50

Statistics of the CPAN mirror:

 +---------------------+----------------------+
 | key                 | value                |
 +---------------------+----------------------+
 | cpan                | /home/s1/cpan        |
 | index_name          | index.db             |
 | last_index_time     | 2016-10-14T11:06:26Z |
 | raw_last_index_time | 1476443186           |
 +---------------------+----------------------+

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Acme-CPANAuthors-CPAN-TopDepended-ByOthers>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Acme-CPANAuthors-CPAN-TopDepended-ByOthers>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Acme-CPANAuthors-CPAN-TopDepended-ByOthers>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

L<Acme::CPANAuthors>

L<Acme::CPANAuthors::CPAN::TopDepended>

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
