'\"
'\" Copyright (c) 1994 The Regents of the University of California.
'\" Copyright (c) 1994-1996 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" SCCS: @(#) focusNext.n 1.10 96/03/26 18:22:23
'\" 
.so man.macros
.TH focusNext n 4.0 Tk "Tk User Interaction"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
focusNext, focusPrev, focusFollowsMouse \- Utility methods for managing the input focus.
.SH SYNOPSIS
\fI$widget\fR->\fBfocusNext\fR 
.br
\fI$widget\fR->\fBfocusPrev\fR
.br
\fI$widget\fR->\fBfocusFollowsMouse\fR
.BE

.SH DESCRIPTION
.PP
\fBfocusNext\fR is a utility method used for keyboard traversal.
It returns the ``next'' window after \fI$widget\fR in focus order.
The focus order is determined by
the stacking order of windows and the structure of the window hierarchy.
Among siblings, the focus order is the same as the stacking order, with the
lowest window being first.
If a window has children, the window is visited first, followed by
its children (recursively), followed by its next sibling.
Top-level windows other than \fI$widget\fR are skipped, so that
\fBfocusNext\fR never returns a window in a different top-level
from \fI$widget\fR.
.PP
After computing the next window, \fBfocusNext\fR examines the
window's \fB\-takefocus\fR option to see whether it should be skipped.
If so, \fBfocusNext\fR continues on to the next window in the focus
order, until it eventually finds a window that will accept the focus
or returns back to \fI$widget\fR.
.PP
\fBfocusPrev\fR is similar to \fBfocusNext\fR except that it
returns the window just before \fI$widget\fR in the focus order.
.PP
\fBfocusFollowsMouse\fR changes the focus model for the application
to an implicit one where the window under the mouse gets the focus.
After this procedure is called, whenever the mouse enters a window
Tk will automatically give it the input focus.
The \fBfocus\fR command may be used to move the focus to a window
other than the one under the mouse, but as soon as the mouse moves
into a new window the focus will jump to that window.
Note: at present there is no built-in support for returning the
application to an explicit focus model;  to do this you'll have
to write a script that deletes the bindings created by
\fBfocusFollowsMouse\fR.

.SH KEYWORDS
focus, keyboard traversal, top-level
