package X11::GLX::Pixmap;
use strict;
use warnings;
use parent 'X11::Xlib::Pixmap';


sub x_pixmap { my $self= shift; if (@_) { $_->{x_pixmap}= shift; } $_->{x_pixmap} }

sub DESTROY {
    my $self= shift;
    if ($self->autofree && $self->xid) {
        X11::GLX::glXDestroyGLXPixmap($self->display, $self->xid);
        delete $self->{xid}; # make sure parent constructor doesn't run
    }
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

X11::GLX::Pixmap

=head1 VERSION

version 0.00_01

=head1 DESCRIPTION

Object representing a GLX Pixmap, which is built on top of an X pixmap.

=head1 ATTRIBUTES

Extends L<X11::Xlib::Pixmap> with:

=head2 x_pixmap

The X11 pixmap which this GLX pixmap is extending.

The GLX pixmap holds this reference to make sure the X pixmap is not destroyed
until after the GLX pixmap.

=head1 AUTHOR

Michael Conrad <mike@nrdvana.net>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Michael Conrad.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
