package CPU::x86_64::InstructionWriter::Unknown;
$CPU::x86_64::InstructionWriter::Unknown::VERSION = '0.000_001'; # TRIAL
$CPU::x86_64::InstructionWriter::Unknown::VERSION = '0.000001';
use Moo 2;
use Carp;
use Scalar::Util 'refaddr';

# ABSTRACT: Placeholder for a constant that will be assembled

has name => ( is => 'rw' );

sub bits {
	my $self= shift;
	return $self->{bits} unless @_;
	my $val= shift;
	!defined $self->{bits} || $self->{bits} == $val
		or croak "Can't change bits from $self->{bits} to $val for unknown($self->{name})";
	$self->{bits}= $val;
}

has value => ( is => 'rw' );

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

CPU::x86_64::InstructionWriter::Unknown - Placeholder for a constant that will be assembled

=head1 VERSION

version 0.000_001

=head1 AUTHOR

Michael Conrad <mike@nrdvana.net>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by Michael Conrad.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
