#!perl -T
use 5.006;
use strict;
use warnings;
use Test::More tests => 5;

BEGIN {
    use_ok('Acme::CPANAuthors::NameGen')     || print "Bail out!\n";
    require_ok('Acme::CPANAuthors::NameGen') || print "Bail out!\n";
}

is( Acme::CPANAuthors::NameGen::gen( 2, 1423 ), 'affectionate_MZIESCHA', 'Standard gen.' );
is( Acme::CPANAuthors::NameGen::gen_lc( 2, 1423 ), 'affectionate_mziescha', 'Lowercase gen.' );
is( Acme::CPANAuthors::NameGen::gen_uc( 2, 1423 ), 'AFFECTIONATE_MZIESCHA', 'Uppercase gen.' );

diag("Testing Acme::CPANAuthors::NameGen $Acme::CPANAuthors::NameGen::VERSION, Perl $], $^X");
