# -*- Mode: CPerl -*-

$TEST_DIR = './t';
#use lib qw(../blib/lib ../blib/arch); $TEST_DIR = '.'; # for debugging

use DDC::XS;

# load common subs
do "$TEST_DIR/common.plt"
  or die("could not load $TEST_DIR/common.plt");

plan(test => 21);

##-- 1..4: CQAnd: perl only
my $qa = DDC::XS::CQTokExact->new('','a');
my $qb = DDC::XS::CQTokExact->new('','b');
my $qc = DDC::XS::CQTokExact->new('','b');
my $qand = DDC::XS::CQAnd->new($qa,$qb);
isok("CQAnd:args", $qa && $qb && $qc);
isok("CQAnd:obj", $qand);
isok("CQAnd:str", $qand->toString eq q(@'a' && @'b'));
$qand->setDtr2($qc);
isok("CQAnd:setDtr2:str", $qand->toString eq q(@'a' && @'c'));

##-- 5..7: CQOr: parsed
my $qor = DDC::XS->parse('a || b');
isok("CQOr:parse", $qor);
isok("CQOr:dtr1:str", $qor->getDtr1->toString eq 'a');
isok("CQOr:dtr2:str", $qor->getDtr1->toString eq 'b');

##-- 8..11: CQSeq
my $qseq = DDC::XS->parse('"@foo #2 @bar #=1 @{baz,bonk}"');
my $items = $qseq->getItems;
my $ops   = $qseq->getDistOps;
isok("CQSeq:parse", $qseq);
isok("CQSeq:items", $items && UNIVERSAL::isa($items,'ARRAY') && @$items == 3);
isok("CQSeq:ops",   $ops   && UNIVERSAL::isa($ops,'ARRAY') && join(' ',@$ops) eq '< =');
$_ = '=' foreach (@$ops);
$qseq->setDistOps($ops);
isok("CQSeq:ops:set", !(grep {$_ ne '='} @{$qseq->getDistOps//[]}));

##-- 12..14: CQSet
my $qset = DDC::XS->parse('@{blip,blop}');
my $vals = $qset->getValues;
isok("CQSet:parse", $qset);
isok("CQSet:vals", join(' ', sort @{$vals//[]}) eq 'blip blop');
$vals = [qw(a b c)];
$qset->setValues($vals);
isok("CQSet:vals:set", join(' ', sort @{$qset->getValues//[]}) eq 'a b c');

##-- 15..16: CQRegex
my $qre = DDC::XS->parse('/flip\.flop/');
isok("CQRegex:parse", $qre);
isok("CQRegex:value", $qre->getValue eq "flip\\.flop");

##-- 17..18: expanders
my $qx = DDC::XS->parse('foo |bar|baz');
isok("expanders:parse", $qx);
isok("expanders:chain", @{$qx->getExpanders//[]} eq 'bar baz');

##-- 19..21 : WITH aliases
my $qwith = DDC::XS->parse('foo &= bar');
isok("with:&=", $qx && $qx->isa('DDC::XS::CQWith'));

my $qwithor = DDC::XS->parse('foo |= bar');
isok("withor:|=", $qx && $qx->isa('DDC::XS::CQWithor'));

my $qwithout = DDC::XS->parse('foo != bar');
isok("without:!=", $qx && $qx->isa('DDC::XS::CQWithout'));


print "\n";

