# -*- Mode: CPerl -*-

$TEST_DIR = './t';
#use lib qw(../blib/lib ../blib/arch); $TEST_DIR = '.'; # for debugging

use DDC::XS;

# load common subs
do "$TEST_DIR/common.plt"
  or die("could not load $TEST_DIR/common.plt");

plan(test => 11);

##-- 1..2: parse
my ($q,$qo);
isok("qopts:parse", ($q = DDC::XS->parse('foo #cntxt 5 #sep #in file #has[author,kant] #asc_date :c1,c2')));
isok("qopts:options", ($qo=$q->getOptions));

##-- 3..7: basic options
isok("qopts:cntxt", $qo->getContextSentencesCount == 5);
isok("qopts:bibl",  $qo->getEnableBibliography);
isok("qopts:!debugrank", !$qo->getDebugRank);
isok("qopts:separate", $qo->getSeparateHits);
isok("qopts:within", join(' ',@{$qo->getWithin//[]}) eq 'file');

##-- 8..10: filters
my ($filters);
isok("qopts:filters", ($filters=$qo->getFilters) && @{$filters//[]}==2);
isok("qopts:filters[0]", $filters->[0]->toString =~ /^\#HAS(?:_FIELD)?\['author','kant'\]$/i);
isok("qopts:filters[1]", $filters->[1]->toString =~ /^\#(?:ASC|LESS)(?:_BY)?_DATE$/i);

##-- 11: corpora
my $corpora = $qo->getSubcorpora;
isok("qopts:corpora", join(' ',@{$corpora//[]}) eq 'c1 c2');

print "\n";

