# -*- Mode: CPerl -*-

$TEST_DIR = './t';
#use lib qw(../blib/lib ../blib/arch); $TEST_DIR = '.'; # for debugging

use DDC::XS;

# load common subs
do "$TEST_DIR/common.plt"
  or die("could not load $TEST_DIR/common.plt");

plan(test => 9);

##-- 1: constructor
my $compiler = DDC::XS::CQueryCompiler->new;
isok("CQCompiler->new", $compiler);

##-- 2: ParseQuery (bad)
my ($q);
eval {
  $q = $compiler->ParseQuery('Haus #');
};
isok("compiler->ParseQuery('Haus #') -> error", !defined($q) && defined($@) && $@ =~ /syntax error/);

##-- 3: ParseQuery (good)
isok("compiler->ParseQuery('Haus')", ($q=$compiler->ParseQuery('Haus')));

##-- 4: QueryToString
isok("QueryToString", $compiler->QueryToString =~ /Haus/);

##-- 5: QueryToJson
isok("QueryToJson", $compiler->QueryToJson =~ /Haus/);

##-- 6: TO_JSON
use JSON;
my %jopts = (allow_blessed=>1,convert_blessed=>1,canonical=>1);
my $json = JSON::to_json($compiler, \%jopts);
isok("to_json", defined($json));

##-- 7: toHash
my ($hash);
isok("toHash", defined($hash=$compiler->toHash));

##-- 8..9: fromHash
my $c2 = ref($compiler)->newFromHash($hash);
isok("newFromHash", defined($c2));
isok("to_json(fromHash(toHash(src)))==to_json(src)", JSON::to_json($c2,\%jopts) eq $json);


print "\n";

