# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl iban_gen.t'

use Test::More tests => 2905;

BEGIN { use_ok('Business::KontoCheck') };

$ok_cnt=1;
$nok_cnt=0;
$retval=lut_init("blz.lut",9);
$ret_txt=$kto_retval{$retval};
if($retval gt 0){$ok_cnt++;}else{$nok_cnt++;}
ok($retval gt 0,"lut_init(): $retval => $ret_txt (ok: $ok_cnt, nok: $nok_cnt)");

if($retval gt 0){
   while(<DATA>){
      chomp;
      ($blz,$kto,$bic,$iban,$ret)=split(/;/);
      ($retval,$iban_p,$papier_p,$bic_p,$regel,$pz_methode)=Business::KontoCheck::iban_gen($blz,$kto);
      $iban="" if not defined($iban);
      $bic="" if not defined($bic);
      $iban_p="" if not defined($iban_p);
      $papier_p="" if not defined($papier_p);
      $bic_p="" if not defined($bic_p);
      $regel/=100;
#      $ret_txt=$kto_retval{$retval};
      if($ret==$retval && $iban_p eq $iban && $bic_p eq $bic){$ok_cnt++;}else{$nok_cnt++;}
      $r1=($ret==$retval)?1:0;
      $r2=($iban_p eq $iban)?1:0;
      $r3=($bic_p eq $bic)?1:0;
      ok($ret==$retval && $iban_p eq $iban && $bic_p eq $bic,"iban_gen($blz,$kto): $r1 $r2 $r3 [ $retval / $ret @ $iban_p / $iban @ $bic_p / $bic] (Regel $regel, PZ $pz_methode) (ok: $ok_cnt, nok: $nok_cnt)");
   }
}

__DATA__
10220500;9270995831;BOFSDEB1XXX;DE22102205009270995831;1
12030000;6479276617;BYLADEM1001;DE82120300006479276617;1
20050550;4617998804;HASPDEHHXXX;DE39200505504617998804;1
20120000;4470563307;BEGODEHHXXX;DE26201200004470563307;1
20130400;2446544617;GREBDEH1XXX;DE50201304002446544617;1
10130800;6477977746;BIWBDE33XXX;DE88101308006477977746;1
25010600;7188985198;DEHYDE2HXXX;DE14250106007188985198;1
30330800;5423443689;BIWBDE33303;DE04303308005423443689;1
40153768;3040842579;WELADED1EMS;DE05401537683040842579;1
45050001;2511087744;WELADE3HXXX;DE44450500012511087744;1
45050001;1201091826;WELADE3HXXX;DE47450500011201091826;1
45050001;1039152217;WELADE3HXXX;DE12450500011039152217;1
45050001;3487628726;WELADE3HXXX;DE72450500013487628726;1
45050001;8069296834;WELADE3HXXX;DE19450500018069296834;1
47850065;2854228177;WELADED1GTL;DE41478500652854228177;1
55350010;6426520119;MALADE51WOR;DE68553500106426520119;1
66350036;2278440969;BRUSDE66XXX;DE81663500362278440969;1
66450050;2083324803;SOLADES1OFG;DE72664500502083324803;1
66451346;2938047005;SOLADES1GEB;DE84664513462938047005;1
30030500;7920830405;CUABDED1XXX;DE64300305007920830405;1
52050353;3962815369;HELADEF1KAS;DE90520503533962815369;1
30030500;6034489141;CUABDED1XXX;DE81300305006034489141;1
30030500;2729807993;CUABDED1XXX;DE80300305002729807993;1
52050353;7082895618;HELADEF1KAS;DE32520503537082895618;1
10060198;1452662759;GENODED1PAX;;-124
10090000;1930086688;BEVODEBBXXX;DE51100900001930086688;1
10130600;8167085785;ISBKDEFXXXX;DE40101306008167085785;1
13091084;8233693791;GENODEF1HWI;DE56130610788233693791;1
15091674;1861587360;GENODEF1DM1;DE50150916741861587360;1
70220800;5524323628;VVAGDEM1XXX;DE96702208005524323628;1
70220800;2978893044;VVAGDEM1XXX;DE12702208002978893044;1
70220800;1756576009;VVAGDEM1XXX;DE85702208001756576009;1
70220800;9002857551;VVAGDEM1XXX;DE45702208009002857551;1
70220800;7584265863;VVAGDEM1XXX;DE05702208007584265863;1
30022000;8304626222;NRWBDEDMXXX;DE15300220008304626222;1
30025500;1780861165;PORTDEDDXXX;DE41300255001780861165;1
30050000;5652571992;WELADEDDXXX;DE20300500005652571992;1
40022000;3520650189;NRWBDEDMMST;DE32400220003520650189;1
40050000;9862925188;WELADEDDXXX;DE79300500009862925188;19
44050000;1170;WELADEDDXXX;DE20300500000000001170;19
30022000;7928;NRWBDEDMXXX;DE02300220000000007928;1
30022000;4297;NRWBDEDMXXX;DE69300220000000004297;1
30025500;6088;PORTDEDDXXX;DE07300255000000006088;1
30050000;5605;WELADEDDXXX;DE70300500000000005605;1
40022000;79863;NRWBDEDMMST;DE29400220000000079863;1
40050000;38783;WELADEDDXXX;DE59300500000000038783;19
44050000;12685;WELADEDDXXX;DE97300500000000012685;19
30022000;28898;NRWBDEDMXXX;DE98300220000000028898;1
10000000;7000514688;MARKDEF1100;;-124
10010424;8497298337;AARBDE5W100;DE85100104248497298337;1
10011001;2202312674;NTSBDEB1XXX;DE20100110012202312674;1
10019610;7571218516;DXIADEBBXXX;DE92100196107571218516;1
10020500;8306563786;BFSWDE33BER;DE13100205008306563786;1
12030900;2410019960;MEFIDEMM100;DE60120309002410019960;1
20030133;5915420354;VGAGDEHHXXX;DE22200301335915420354;1
20030700;7252827640;MEFIDEMM200;DE36200307007252827640;1
20190003;8168398165;GENODEF1HH2;DE25201900038168398165;1
20190206;2278104632;GENODEF1HH1;DE63201902062278104632;1
51420200;4402777216;MIBEDEFFXXX;DE23514202004402777216;1
74350000;6889401174;BYLADEM1LAH;DE91743500006889401174;1
76230000;4265037801;QUBADE71XXX;DE09762300004265037801;1
51420200;5760691163;MIBEDEFFXXX;DE13514202005760691163;1
51420200;2854347129;MIBEDEFFXXX;DE11514202002854347129;1
10040000;952568478;COBADEFFXXX;DE89100400000952568478;1
10040005;560040887;COBADEFFXXX;DE98100400050560040887;1
10040048;493771048;COBADEFFXXX;DE36100400480493771048;1
10040085;220138277;COBADEFFXXX;DE56100400850220138277;1
10045050;82345684;COBADEFFXXX;DE35100450500082345684;1
12040000;38604217;COBADEFFXXX;DE55120400000038604217;1
13010111;80591800;ESSEDE5F130;DE24130101110080591800;1
13040000;36825723;COBADEFFXXX;DE03130400000036825723;1
14040000;50449629;COBADEFFXXX;DE50140400000050449629;1
10030700;1676656592;DLGHDEB1XXX;DE46100307001676656592;1
20120700;5868408288;HSTBDEHHXXX;DE82201207005868408288;1
55020700;2691340344;SUFGDE51XXX;DE22550207002691340344;1
62020000;3881193255;HOEBDE61XXX;DE72620200003881193255;1
70011300;4798120293;AUZDDEM1XXX;DE81700113004798120293;1
10110600;4857158320;QUBKDEBBXXX;DE92101106004857158320;1
51420300;6457544819;BAERDEF1XXX;DE84514203006457544819;1
70011200;3604541589;VONTDEM1XXX;DE25700112003604541589;1
70012300;5209858317;VBANDEMMXXX;DE43700123005209858317;1
10110600;2454859304;QUBKDEBBXXX;DE34101106002454859304;1
29020100;5368190222;BANVDEHBXXX;DE07290201005368190222;1
30120500;1503592191;BANVDEHB300;DE59301205001503592191;1
30524400;5157902911;KREDDEDDXXX;DE14305244005157902911;1
50020300;4840243746;BANVDEHB500;DE54500203004840243746;1
10220600;6643292718;SYBKDE22BER;DE29102206006643292718;1
20030600;2432523462;SYBKDE22HAM;DE90200306002432523462;1
20210200;3820789027;MELIDEHHXXX;DE42202102003820789027;1
21020600;7563600296;SYBKDE22KIE;DE77210206007563600296;1
21510600;4166815183;SYBKDE22XXX;DE04215106004166815183;1
13050000;5895917803;NOLADE21ROS;DE64130500005895917803;1
14051000;8824323678;NOLADE21WIS;DE42140510008824323678;1
14051362;1625944396;NOLADE21PCH;DE68140513621625944396;1
14052000;3454915359;NOLADE21LWL;DE57140520003454915359;1
15050100;4742728209;NOLADE21WRN;DE14150501004742728209;1
59051090;1296295061;SALADE51VKS;DE27590510901296295061;1
26851620;1317947071;NOLADE21SZG;DE65268516201317947071;1
26851620;3685054450;NOLADE21SZG;DE55268516203685054450;1
26851620;7950323975;NOLADE21SZG;DE67268516207950323975;1
26851620;8138093987;NOLADE21SZG;DE06268516208138093987;1
26851620;7929145669;NOLADE21SZG;DE08268516207929145669;1
72020700;1069829834;AUGBDE77XXX;DE13720207001069829834;1
72020700;7552440860;AUGBDE77XXX;;-124
72020700;3031624819;AUGBDE77XXX;DE80720207003031624819;1
72020700;6623093357;AUGBDE77XXX;DE97720207006623093357;1
72020700;9904220342;AUGBDE77XXX;DE41720207009904220342;1
72020700;1762001987;AUGBDE77XXX;DE54720207001762001987;1
72020700;7091508009;AUGBDE77XXX;DE16720207007091508009;1
72020700;4774507835;AUGBDE77XXX;DE90720207004774507835;1
72020700;5091705500;AUGBDE77XXX;DE36720207005091705500;1
72020700;7120400506;AUGBDE77XXX;DE71720207007120400506;1
72020700;5629314835;AUGBDE77XXX;DE83720207005629314835;1
72020700;3937011957;AUGBDE77XXX;DE26720207003937011957;1
72020700;1309412906;AUGBDE77XXX;DE53720207001309412906;1
72020700;9245111636;AUGBDE77XXX;;-124
72020700;1192817771;AUGBDE77XXX;DE46720207001192817771;1
72020700;9352023149;AUGBDE77XXX;DE71720207009352023149;1
72020700;2504122394;AUGBDE77XXX;DE71720207002504122394;1
72020700;3377520668;AUGBDE77XXX;;-124
72020700;7829620674;AUGBDE77XXX;;-124
72020700;5159628840;AUGBDE77XXX;DE65720207005159628840;1
72020700;9111131849;AUGBDE77XXX;DE25720207009111131849;1
72020700;9576231357;AUGBDE77XXX;DE45720207009576231357;1
72020700;4971035040;AUGBDE77XXX;DE11720207004971035040;1
72020700;2048233850;AUGBDE77XXX;DE92720207002048233850;1
72020700;5743338815;AUGBDE77XXX;DE24720207005743338815;1
72020700;6835044717;AUGBDE77XXX;DE67720207006835044717;1
72020700;1958542853;AUGBDE77XXX;DE19720207001958542853;1
72020700;9608141613;AUGBDE77XXX;;-124
72020700;9458441122;AUGBDE77XXX;DE09720207009458441122;1
72020700;2210045930;AUGBDE77XXX;DE07720207002210045930;1
72020700;5611555173;AUGBDE77XXX;DE90720207005611555173;1
72020700;1778056933;AUGBDE77XXX;DE06720207001778056933;1
72020700;4758951818;AUGBDE77XXX;DE27720207004758951818;1
72020700;6331653593;AUGBDE77XXX;DE52720207006331653593;1
72020700;2697750417;AUGBDE77XXX;DE70720207002697750417;1
72020700;7159862353;AUGBDE77XXX;DE27720207007159862353;1
72020700;9451064654;AUGBDE77XXX;;-124
72020700;6484166749;AUGBDE77XXX;DE92720207006484166749;1
72020700;9551766884;AUGBDE77XXX;DE13720207009551766884;1
72020700;5732964824;AUGBDE77XXX;DE96720207005732964824;1
72020700;8431175113;AUGBDE77XXX;DE21720207008431175113;1
72020700;6509576346;AUGBDE77XXX;DE51720207006509576346;1
72020700;1464078121;AUGBDE77XXX;DE22720207001464078121;1
72020700;7454074002;AUGBDE77XXX;DE12720207007454074002;1
72020700;4403576251;AUGBDE77XXX;DE52720207004403576251;1
72020700;5366089508;AUGBDE77XXX;DE30720207005366089508;1
72020700;4575784920;AUGBDE77XXX;DE73720207004575784920;1
72020700;9442383704;AUGBDE77XXX;DE65720207009442383704;1
72020700;3298086836;AUGBDE77XXX;DE04720207003298086836;1
72020700;6583393555;AUGBDE77XXX;DE34720207006583393555;1
72020700;4515196263;AUGBDE77XXX;DE64720207004515196263;1
72020700;1630199022;AUGBDE77XXX;DE78720207001630199022;1
72020700;7644892585;AUGBDE77XXX;DE18720207007644892585;1
10010010;1057101686;PBNKDEFFXXX;DE44100100101057101686;1
20010020;1675090333;PBNKDEFFXXX;DE04200100201675090333;1
25010030;1433081096;PBNKDEFFXXX;DE22250100301433081096;1
36010043;1292871724;PBNKDEFFXXX;DE05360100431292871724;1
37010050;2376038693;PBNKDEFFXXX;DE16370100502376038693;1
37011000;2059681255;PBNKDEFFXXX;DE86370110002059681255;1
44010046;2420303235;PBNKDEFFXXX;DE81440100462420303235;1
50010060;2696525787;PBNKDEFFXXX;DE59500100602696525787;1
54510067;2610138501;PBNKDEFFXXX;DE06545100672610138501;1
59010066;7768093704;PBNKDEFFXXX;DE53590100667768093704;1
60010070;7391762934;PBNKDEFFXXX;DE53600100707391762934;1
66010075;7776388511;PBNKDEFFXXX;DE18660100757776388511;1
70010080;7623298028;PBNKDEFFXXX;DE79700100807623298028;1
76010085;7410822638;PBNKDEFFXXX;DE39760100857410822638;1
86010090;8563658080;PBNKDEFFXXX;DE10860100908563658080;1
10010010;8777452886;PBNKDEFFXXX;DE36100100108777452886;1
10010010;8408044405;PBNKDEFFXXX;DE46100100108408044405;1
20010020;8986721980;PBNKDEFFXXX;DE21200100208986721980;1
25010030;8874739853;PBNKDEFFXXX;DE30250100308874739853;1
36010043;3631397605;PBNKDEFFXXX;DE63360100433631397605;1
37010050;3551944024;PBNKDEFFXXX;DE14370100503551944024;1
37011000;3511675616;PBNKDEFFXXX;DE05370110003511675616;1
44010046;3371195788;PBNKDEFFXXX;DE54440100463371195788;1
50010060;3091299198;PBNKDEFFXXX;DE16500100603091299198;1
54510067;4191001403;PBNKDEFFXXX;DE40545100674191001403;1
59010066;4951256887;PBNKDEFFXXX;DE52590100664951256887;1
60010070;4501421509;PBNKDEFFXXX;DE06600100704501421509;1
66010075;4661603326;PBNKDEFFXXX;DE96660100754661603326;1
70010080;4111833090;PBNKDEFFXXX;DE33700100804111833090;1
76010085;5451333665;PBNKDEFFXXX;DE08760100855451333665;1
86010090;5401347937;PBNKDEFFXXX;DE45860100905401347937;1
10010010;5841800521;PBNKDEFFXXX;DE38100100105841800521;1
10010010;5031861259;PBNKDEFFXXX;DE45100100105031861259;1
20010020;5771118736;PBNKDEFFXXX;DE69200100205771118736;1
25010030;6811590960;PBNKDEFFXXX;DE15250100306811590960;1
36010043;6861917829;PBNKDEFFXXX;DE08360100436861917829;1
37010050;6241086618;PBNKDEFFXXX;DE92370100506241086618;1
37011000;6181287012;PBNKDEFFXXX;DE86370110006181287012;1
44010046;6731298824;PBNKDEFFXXX;DE46440100466731298824;1
50010060;3322185956;PBNKDEFFXXX;DE06500100603322185956;1
54510067;3092773969;PBNKDEFFXXX;DE74545100673092773969;1
59010066;3102016316;PBNKDEFFXXX;DE67590100663102016316;1
60010070;3342929883;PBNKDEFFXXX;DE31600100703342929883;1
66010075;3842329441;PBNKDEFFXXX;DE18660100753842329441;1
70010080;4242142574;PBNKDEFFXXX;DE29700100804242142574;1
76010085;4212232023;PBNKDEFFXXX;DE82760100854212232023;1
86010090;4052854924;PBNKDEFFXXX;DE71860100904052854924;1
10010010;4142567017;PBNKDEFFXXX;DE12100100104142567017;1
10010010;4742636155;PBNKDEFFXXX;DE24100100104742636155;1
20010020;5152735426;PBNKDEFFXXX;DE78200100205152735426;1
25010030;5312951134;PBNKDEFFXXX;DE21250100305312951134;1
36010043;5822664656;PBNKDEFFXXX;DE47360100435822664656;1
37010050;5762418336;PBNKDEFFXXX;DE95370100505762418336;1
37011000;5892573671;PBNKDEFFXXX;DE17370110005892573671;1
44010046;6672101725;PBNKDEFFXXX;DE48440100466672101725;1
50010060;6632529450;PBNKDEFFXXX;DE14500100606632529450;1
54510067;6532711483;PBNKDEFFXXX;DE56545100676532711483;1
59010066;6312383634;PBNKDEFFXXX;DE87590100666312383634;1
60010070;3673190857;PBNKDEFFXXX;DE94600100703673190857;1
66010075;3793275283;PBNKDEFFXXX;DE34660100753793275283;1
70010080;3533362927;PBNKDEFFXXX;DE38700100803533362927;1
76010085;3743892072;PBNKDEFFXXX;DE60760100853743892072;1
86010090;3353478509;PBNKDEFFXXX;DE34860100903353478509;1
10010010;4733231641;PBNKDEFFXXX;DE55100100104733231641;1
10010010;4393533747;PBNKDEFFXXX;DE45100100104393533747;1
20010020;4923394979;PBNKDEFFXXX;DE43200100204923394979;1
25010030;4023808248;PBNKDEFFXXX;DE04250100304023808248;1
36010043;4513794078;PBNKDEFFXXX;DE53360100434513794078;1
37010050;5093755104;PBNKDEFFXXX;DE27370100505093755104;1
37011000;5993220233;PBNKDEFFXXX;DE74370110005993220233;1
44010046;5983749045;PBNKDEFFXXX;DE77440100465983749045;1
50010060;5893915761;PBNKDEFFXXX;DE20500100605893915761;1
54510067;5663070797;PBNKDEFFXXX;DE77545100675663070797;1
59010066;6723616399;PBNKDEFFXXX;DE76590100666723616399;1
60010070;6213419717;PBNKDEFFXXX;DE38600100706213419717;1
66010075;6623392363;PBNKDEFFXXX;DE30660100756623392363;1
70010080;6583533634;PBNKDEFFXXX;DE82700100806583533634;1
76010085;6933855833;PBNKDEFFXXX;DE42760100856933855833;1
86010090;3615447147;PBNKDEFFXXX;DE90860100903615447147;1
10010010;3715242321;PBNKDEFFXXX;DE51100100103715242321;1
10010010;3095638956;PBNKDEFFXXX;DE54100100103095638956;1
20010020;3345466305;PBNKDEFFXXX;DE21200100203345466305;1
25010030;3985571166;PBNKDEFFXXX;DE51250100303985571166;1
36010043;4315541339;PBNKDEFFXXX;DE62360100434315541339;1
37010050;4395284866;PBNKDEFFXXX;DE06370100504395284866;1
37011000;4175438763;PBNKDEFFXXX;DE91370110004175438763;1
44010046;4595329583;PBNKDEFFXXX;DE70440100464595329583;1
50010060;4655940912;PBNKDEFFXXX;DE54500100604655940912;1
54510067;5145721521;PBNKDEFFXXX;DE43545100675145721521;1
59010066;5745361443;PBNKDEFFXXX;DE04590100665745361443;1
60010070;5515501750;PBNKDEFFXXX;DE25600100705515501750;1
66010075;5705537182;PBNKDEFFXXX;DE06660100755705537182;1
70010080;5005620122;PBNKDEFFXXX;DE26700100805005620122;1
76010085;6245730354;PBNKDEFFXXX;DE21760100856245730354;1
86010090;6985974020;PBNKDEFFXXX;DE43860100906985974020;1
10010010;6135780438;PBNKDEFFXXX;DE93100100106135780438;1
10010010;6165482093;PBNKDEFFXXX;DE95100100106165482093;1
20010020;6155318436;PBNKDEFFXXX;DE17200100206155318436;1
25010030;3966684469;PBNKDEFFXXX;DE36250100303966684469;1
36010043;3046715556;PBNKDEFFXXX;DE36360100433046715556;1
37010050;3926019709;PBNKDEFFXXX;DE39370100503926019709;1
37011000;3056596209;PBNKDEFFXXX;DE55370110003056596209;1
44010046;4566972741;PBNKDEFFXXX;DE30440100464566972741;1
50010060;4786260866;PBNKDEFFXXX;DE18500100604786260866;1
54510067;4906159473;PBNKDEFFXXX;DE96545100674906159473;1
59010066;4946441244;PBNKDEFFXXX;DE24590100664946441244;1
60010070;4546237974;PBNKDEFFXXX;DE90600100704546237974;1
66010075;5136961784;PBNKDEFFXXX;DE17660100755136961784;1
70010080;5056221720;PBNKDEFFXXX;DE37700100805056221720;1
76010085;5166147002;PBNKDEFFXXX;DE71760100855166147002;1
86010090;5926363920;PBNKDEFFXXX;DE94860100905926363920;1
10010010;5376315690;PBNKDEFFXXX;DE04100100105376315690;1
10010010;6826121481;PBNKDEFFXXX;DE77100100106826121481;1
20010020;6966015515;PBNKDEFFXXX;DE34200100206966015515;1
25010030;6136423308;PBNKDEFFXXX;DE11250100306136423308;1
36010043;6636381496;PBNKDEFFXXX;DE61360100436636381496;1
37010050;6026250100;PBNKDEFFXXX;DE46370100506026250100;1
37011000;3727006141;PBNKDEFFXXX;DE41370110003727006141;1
44010046;3757281061;PBNKDEFFXXX;DE78440100463757281061;1
50010060;3547917272;PBNKDEFFXXX;DE87500100603547917272;1
54510067;3657042039;PBNKDEFFXXX;DE60545100673657042039;1
59010066;3667768506;PBNKDEFFXXX;DE95590100663667768506;1
60010070;4277329722;PBNKDEFFXXX;DE47600100704277329722;1
66010075;4257859385;PBNKDEFFXXX;DE08660100754257859385;1
70010080;4907985074;PBNKDEFFXXX;DE20700100804907985074;1
76010085;4977860991;PBNKDEFFXXX;DE92760100854977860991;1
86010090;4397211492;PBNKDEFFXXX;DE51860100904397211492;1
10010010;5887763052;PBNKDEFFXXX;DE19100100105887763052;1
10010010;5497822367;PBNKDEFFXXX;DE84100100105497822367;1
20010020;5527112103;PBNKDEFFXXX;DE76200100205527112103;1
25010030;5977522555;PBNKDEFFXXX;DE60250100305977522555;1
36010043;5827823992;PBNKDEFFXXX;DE63360100435827823992;1
37010050;6527625789;PBNKDEFFXXX;DE97370100506527625789;1
37011000;6627444753;PBNKDEFFXXX;DE68370110006627444753;1
44010046;6717835328;PBNKDEFFXXX;DE51440100466717835328;1
50010060;6387256580;PBNKDEFFXXX;DE91500100606387256580;1
54510067;6497488448;PBNKDEFFXXX;DE51545100676497488448;1
59010066;3048757261;PBNKDEFFXXX;DE10590100663048757261;1
60010070;3398315804;PBNKDEFFXXX;DE64600100703398315804;1
66010075;3358590389;PBNKDEFFXXX;DE64660100753358590389;1
70010080;3928590420;PBNKDEFFXXX;DE96700100803928590420;1
76010085;3498852532;PBNKDEFFXXX;DE86760100853498852532;1
86010090;4988063491;PBNKDEFFXXX;DE04860100904988063491;1
10010010;4148845741;PBNKDEFFXXX;DE06100100104148845741;1
10010010;4798162185;PBNKDEFFXXX;DE17100100104798162185;1
20010020;4658561102;PBNKDEFFXXX;DE60200100204658561102;1
25010030;4598068986;PBNKDEFFXXX;DE59250100304598068986;1
36010043;5858620333;PBNKDEFFXXX;DE25360100435858620333;1
37010050;5898806538;PBNKDEFFXXX;DE63370100505898806538;1
37011000;5288571803;PBNKDEFFXXX;DE46370110005288571803;1
44010046;5058481601;PBNKDEFFXXX;DE75440100465058481601;1
50010060;5118117657;PBNKDEFFXXX;DE34500100605118117657;1
54510067;6738907362;PBNKDEFFXXX;DE36545100676738907362;1
59010066;6918088573;PBNKDEFFXXX;DE88590100666918088573;1
60010070;6348964047;PBNKDEFFXXX;DE26600100706348964047;1
66010075;6328860027;PBNKDEFFXXX;DE83660100756328860027;1
70010080;6678968008;PBNKDEFFXXX;DE63700100806678968008;1
76010085;3579584706;PBNKDEFFXXX;DE62760100853579584706;1
86010090;3119768191;PBNKDEFFXXX;DE81860100903119768191;1
10010010;3269409709;PBNKDEFFXXX;DE86100100103269409709;1
10010010;3699883255;PBNKDEFFXXX;DE45100100103699883255;1
20010020;3819721659;PBNKDEFFXXX;DE94200100203819721659;1
25010030;4319568468;PBNKDEFFXXX;DE34250100304319568468;1
36010043;4609969074;PBNKDEFFXXX;DE81360100434609969074;1
37010050;4819140755;PBNKDEFFXXX;DE85370100504819140755;1
37011000;4469773318;PBNKDEFFXXX;DE81370110004469773318;1
44010046;4659064169;PBNKDEFFXXX;DE83440100464659064169;1
50010060;5689355765;PBNKDEFFXXX;DE52500100605689355765;1
54510067;5939984477;PBNKDEFFXXX;DE22545100675939984477;1
59010066;5749133578;PBNKDEFFXXX;DE31590100665749133578;1
60010070;5719351713;PBNKDEFFXXX;DE95600100705719351713;1
66010075;5189580574;PBNKDEFFXXX;DE83660100755189580574;1
70010080;6889347189;PBNKDEFFXXX;DE17700100806889347189;1
76010085;6809546273;PBNKDEFFXXX;DE52760100856809546273;1
86010090;6249935225;PBNKDEFFXXX;DE42860100906249935225;1
10010010;6009304042;PBNKDEFFXXX;DE95100100106009304042;1
10010010;6339759097;PBNKDEFFXXX;DE08100100106339759097;1
20010020;9701430695;PBNKDEFFXXX;DE96200100209701430695;1
25010030;9251350353;PBNKDEFFXXX;DE49250100309251350353;1
36010043;9091129989;PBNKDEFFXXX;DE26360100439091129989;1
37010050;9651415975;PBNKDEFFXXX;DE51370100509651415975;1
37011000;9981180398;PBNKDEFFXXX;DE18370110009981180398;1
44010046;9532653660;PBNKDEFFXXX;DE85440100469532653660;1
50010060;9022537844;PBNKDEFFXXX;DE69500100609022537844;1
54510067;9252384279;PBNKDEFFXXX;DE89545100679252384279;1
59010066;9862072237;PBNKDEFFXXX;DE50590100669862072237;1
60010070;9152819697;PBNKDEFFXXX;DE78600100709152819697;1
66010075;9383480780;PBNKDEFFXXX;DE69660100759383480780;1
70010080;9473598360;PBNKDEFFXXX;DE62700100809473598360;1
76010085;9253022900;PBNKDEFFXXX;DE86760100859253022900;1
86010090;9673166594;PBNKDEFFXXX;DE31860100909673166594;1
10010010;9703645705;PBNKDEFFXXX;DE76100100109703645705;1
10010010;9284970685;PBNKDEFFXXX;DE40100100109284970685;1
20010020;9764563711;PBNKDEFFXXX;DE43200100209764563711;1
25010030;9494104762;PBNKDEFFXXX;DE61250100309494104762;1
36010043;9474095180;PBNKDEFFXXX;DE92360100439474095180;1
37010050;9294447028;PBNKDEFFXXX;DE90370100509294447028;1
37011000;9085991578;PBNKDEFFXXX;DE65370110009085991578;1
44010046;9445432148;PBNKDEFFXXX;DE68440100469445432148;1
50010060;9565934124;PBNKDEFFXXX;DE07500100609565934124;1
54510067;9615601695;PBNKDEFFXXX;DE92545100679615601695;1
59010066;9435636583;PBNKDEFFXXX;DE60590100669435636583;1
60010070;9626309597;PBNKDEFFXXX;DE07600100709626309597;1
66010075;9636601703;PBNKDEFFXXX;DE31660100759636601703;1
70010080;9146323381;PBNKDEFFXXX;DE72700100809146323381;1
76010085;9726594559;PBNKDEFFXXX;DE48760100859726594559;1
86010090;9236644557;PBNKDEFFXXX;DE32860100909236644557;1
10010010;9087705591;PBNKDEFFXXX;DE98100100109087705591;1
10010010;9447394163;PBNKDEFFXXX;DE57100100109447394163;1
20010020;9757174939;PBNKDEFFXXX;DE91200100209757174939;1
25010030;9187818416;PBNKDEFFXXX;DE89250100309187818416;1
36010043;9907410512;PBNKDEFFXXX;DE90360100439907410512;1
37010050;9378799869;PBNKDEFFXXX;DE15370100509378799869;1
37011000;9418304683;PBNKDEFFXXX;DE58370110009418304683;1
44010046;9068068724;PBNKDEFFXXX;DE28440100469068068724;1
50010060;9008043598;PBNKDEFFXXX;DE54500100609008043598;1
54510067;9228366991;PBNKDEFFXXX;DE40545100679228366991;1
59010066;9329966198;PBNKDEFFXXX;DE73590100669329966198;1
60010070;9459438123;PBNKDEFFXXX;DE85600100709459438123;1
66010075;9709547256;PBNKDEFFXXX;DE04660100759709547256;1
70010080;9259948462;PBNKDEFFXXX;DE85700100809259948462;1
76010085;9619391979;PBNKDEFFXXX;DE87760100859619391979;1
42050001;100648592;WELADED1GEK;DE66420500010100648592;1
42050001;836849728;WELADED1GEK;DE96420500010836849728;1
42050001;284600636;WELADED1GEK;DE40420500010284600636;1
42050001;711724334;WELADED1GEK;DE88420500010711724334;1
25055500;20014849;NOLADE21LBS;DE16250555000020014849;1
72012300;17913204;BTVADE61XXX;DE38720123000017913204;1
25055500;40994980;NOLADE21LBS;DE86250555000040994980;1
25055500;79729000;NOLADE21LBS;DE44250555000079729000;1
72012300;88053362;BTVADE61XXX;DE25720123000088053362;1
25055500;6992424711;NOLADE21LBS;DE05250555006992424711;1
25055500;1335774919;NOLADE21LBS;DE44250555001335774919;1
72012300;8501632648;BTVADE61XXX;DE10720123008501632648;1
25055500;7007089818;NOLADE21LBS;DE93250555007007089818;1
25055500;2768587093;NOLADE21LBS;DE25250555002768587093;1
25050000;615693652;NOLADE2HXXX;DE74250500000615693652;1
59050000;909542656;SALADE55XXX;DE26590500000909542656;1
25050000;928097997;NOLADE2HXXX;DE29250500000928097997;1
25050000;333680783;NOLADE2HXXX;DE21250500000333680783;1
59050000;255295545;SALADE55XXX;DE83590500000255295545;1
25050000;8073998831;NOLADE2HXXX;DE68250500008073998831;1
25050000;8478679329;NOLADE2HXXX;DE47250500008478679329;1
59050000;8908550535;SALADE55XXX;DE92590500008908550535;1
25050000;1309910437;NOLADE2HXXX;DE79250500001309910437;1
25050000;7525819967;NOLADE2HXXX;DE06250500007525819967;1
16062008;9824419194;GENODEF1LUK;DE47160620089824419194;1
20069780;2190066392;GENODEF1AST;DE44200697802190066392;1
20069782;4104693566;GENODEF1APE;DE36200697824104693566;1
20069786;3880540500;GENODEF1DRO;DE27200697863880540500;1
20069800;1484803141;GENODEF1HAA;DE12200698001484803141;1
20069812;56714050;GENODEF1FRB;DE06200698120056714050;1
20069815;25025232;GENODEF1815;DE94200698150025025232;1
20069965;52725484;GENODEF1WIM;DE65200699650052725484;1
20069989;71398838;GENODEF1WUL;DE60200699890071398838;1
29050000;2963104181;BRLADE22XXX;DE95290500002963104181;1
29050000;8109469793;BRLADE22XXX;DE11290500008109469793;1
29050000;7761420814;BRLADE22XXX;DE80290500007761420814;1
29050000;6309646497;BRLADE22XXX;DE29290500006309646497;1
29050000;3585927267;BRLADE22XXX;DE92290500003585927267;1
52420600;9116932229;ABGRDEFFXXX;DE45524206009116932229;1
70120600;5710131203;AGBMDEMMXXX;DE07701206005710131203;1
52420600;3473514732;ABGRDEFFXXX;DE71524206003473514732;1
52420600;2298102383;ABGRDEFFXXX;DE93524206002298102383;1
70120600;7112791930;AGBMDEMMXXX;DE67701206007112791930;1
50324000;5501040875;FTSBDEFAXXX;DE54503240005501040875;1
50324040;6621716559;FTSBDEFAMYO;DE66503240406621716559;1
50324000;4770330014;FTSBDEFAXXX;DE36503240004770330014;1
50324000;3426506130;FTSBDEFAXXX;DE17503240003426506130;1
50324040;6783736903;FTSBDEFAMYO;DE40503240406783736903;1
13061008;3139146474;GENODEF1WOG;DE06130610083139146474;1
13061078;6562867885;GENODEF1HWI;DE74130610786562867885;1
13061088;1620984884;GENODEF1HWI;DE44130610781620984884;1
13061128;3492494256;GENODEF1GUE;DE77140613083492494256;1
20069125;2493313319;GENODEF1KLK;DE65200691252493313319;1
20069144;3250223115;GENODEF1SST;DE63200691443250223115;1
20069232;4927716804;GENODEF1STV;DE37200692324927716804;1
20069641;4770748820;GENODEF1OWS;DE21200696414770748820;1
20069861;5597796689;GENODEF1RRZ;DE92200698615597796689;1
36060488;3908104750;GENODEM1GBE;DE98360604883908104750;1
40060265;5805910167;GENODEM1DKM;DE43400602655805910167;1
40060300;5479382779;GENODEM1WLM;DE81400603005479382779;1
40061238;4510801589;GENODEM1GRV;DE77400612384510801589;1
40069226;7309220900;GENODEM1CND;DE35400692267309220900;1
40069266;65230808;GENODEM1MAS;DE89400692660065230808;1
40069283;90356818;GENODEM1SLN;DE21400692830090356818;1
40069348;41129999;GENODEM1MDB;DE11400693480041129999;1
40069362;87672393;GENODEM1SAE;DE78400693620087672393;1
38621500;1196996929;GENODED1STB;DE93386215001196996929;1
56061151;2606829928;GENODED1KSL;DE53560611512606829928;1
56061472;8946203693;GENODED1KHK;DE16560614728946203693;1
56090000;5389255624;GENODE51KRE;DE25560900005389255624;1
56261735;8966433026;GENODED1FIN;DE72562617358966433026;1
35060386;1188620328;GENODED1VRR;DE12350603861188620328;1
56062227;6660313552;GENODED1RBO;DE61560622276660313552;1
35060386;1886318070;GENODED1VRR;DE97350603861886318070;1
35060386;7967143951;GENODED1VRR;DE56350603867967143951;1
25020600;4369921966;CCBADE31XXX;DE41310108334369921966;19
25020600;9729525767;CCBADE31XXX;DE71310108339729525767;19
25020600;6609774787;CCBADE31XXX;DE13310108336609774787;19
25020600;3749334632;CCBADE31XXX;DE71310108333749334632;19
25020600;3149633983;CCBADE31XXX;DE49310108333149633983;19
25020600;5505966795;CCBADE31XXX;DE66310108335505966795;19
25020600;8396390877;CCBADE31XXX;DE53310108338396390877;19
25020600;4183184441;CCBADE31XXX;DE74310108334183184441;19
25020600;4621422114;CCBADE31XXX;DE57310108334621422114;19
25020600;3824648046;CCBADE31XXX;DE12310108333824648046;19
66661454;6709865570;GENODE61NFO;DE22666614546709865570;1
66661454;8979956633;GENODE61NFO;DE67666614548979956633;1
66661454;8117223808;GENODE61NFO;DE23666614548117223808;1
66661454;6874701619;GENODE61NFO;DE02666614546874701619;1
66661454;4835354512;GENODE61NFO;DE45666614544835354512;1
66690000;7757700367;VBPFDE66XXX;DE45666900007757700367;1
66690000;8197127672;VBPFDE66XXX;DE59666900008197127672;1
66690000;4872045848;VBPFDE66XXX;DE27666900004872045848;1
66690000;7880290805;VBPFDE66XXX;DE83666900007880290805;1
66690000;1973775497;VBPFDE66XXX;DE42666900001973775497;1
30060010;8935938269;GENODEDDXXX;DE71300600109382698935;24
40060000;2490346183;GENODEMSXXX;DE80400600002490346183;1
57060000;2869270094;GENODEDD570;DE48570600002869270094;1
30060010;8292826419;GENODEDDXXX;DE34300600108292826419;1
30060010;3071561220;GENODEDDXXX;DE84300600103071561220;1
29020000;456017013;NEELDE22XXX;DE74290200000456017013;1
29020000;500104806;NEELDE22XXX;DE83290200000500104806;1
29020000;709979856;NEELDE22XXX;DE49290200000709979856;1
29020000;634212563;NEELDE22XXX;DE55290200000634212563;1
29020000;213251956;NEELDE22XXX;DE50290200000213251956;1
29020000;5986195004;NEELDE22XXX;DE35290200005986195004;1
29020000;8403185504;NEELDE22XXX;DE79290200008403185504;1
29020000;1111194594;NEELDE22XXX;DE36290200001111194594;1
29020000;1877135391;NEELDE22XXX;DE69290200001877135391;1
29020000;1921168467;NEELDE22XXX;DE30290200001921168467;1
29020000;9085442698;NEELDE22XXX;DE18290200009085442698;1
29020000;5315976505;NEELDE22XXX;DE03290200005315976505;1
29020000;7838287287;NEELDE22XXX;DE68290200007838287287;1
29020000;5028939584;NEELDE22XXX;DE92290200005028939584;1
29020000;7943983952;NEELDE22XXX;DE50290200007943983952;1
50310400;8932765435;BARCDEFFXXX;DE13503104008932765435;1
50310400;6037843715;BARCDEFFXXX;DE12503104006037843715;1
50310400;7454256329;BARCDEFFXXX;DE88503104007454256329;1
27290087;7147800810;GENODEF1HMV;DE08272900877147800810;1
27290087;8324676507;GENODEF1HMV;DE18272900878324676507;1
27290087;2410768482;GENODEF1HMV;DE34272900872410768482;1
27290087;8602177517;GENODEF1HMV;DE98272900878602177517;1
27290087;1114446180;GENODEF1HMV;DE31272900871114446180;1
20190109;7026277442;GENODEF1HH4;DE46201901097026277442;1
21092023;9896479704;GENODEF1EFO;DE24210920239896479704;1
21290016;6448454129;GENODEF1NMS;DE15212900166448454129;1
22190030;8451121924;GENODEF1ELM;DE42221900308451121924;1
22191405;4211291555;GENODEF1PIN;DE25221914054211291555;1
76050101;3714683533;SSKNDE77XXX;DE26760501013714683533;1
76050101;5854199931;SSKNDE77XXX;DE04760501015854199931;1
76050101;8702281430;SSKNDE77XXX;DE69760501018702281430;1
76050101;5213283509;SSKNDE77XXX;DE46760501015213283509;1
76050101;2341351621;SSKNDE77XXX;DE85760501012341351621;1
76050101;4661910542;SSKNDE77XXX;DE05760501014661910542;1
76050101;2657898405;SSKNDE77XXX;DE37760501012657898405;1
76050101;4902931149;SSKNDE77XXX;DE83760501014902931149;1
76050101;5206038637;SSKNDE77XXX;DE32760501015206038637;1
76050101;6972714181;SSKNDE77XXX;DE97760501016972714181;1
20090700;7435169165;EDEKDEHHXXX;DE37200907007435169165;1
20090745;7548630812;EDEKDEHHXXX;DE67200907457548630812;1
26991066;1616331330;GENODEF1WOB;DE91269910661616331330;1
51220910;7830890343;MSFFDEFXCND;DE49512209107830890343;1
20090700;8216444;EDEKDEHHXXX;DE58200907000008216444;1
20090700;3301214;EDEKDEHHXXX;DE39200907000003301214;1
20090745;6158633;EDEKDEHHXXX;DE57200907450006158633;1
26991066;9338241;GENODEF1WOB;DE59269910660009338241;1
51220910;7021461;MSFFDEFXCND;DE71512209100007021461;1
33060592;2979835218;GENODED1SPW;DE03330605922979835218;1
36060591;4479956934;GENODED1SPE;DE96360605914479956934;1
37060590;9538704600;GENODED1SPK;DE91370605909538704600;1
33060592;5053590402;GENODED1SPW;DE60330605925053590402;1
33060592;4146961363;GENODED1SPW;DE93330605924146961363;1
36060591;5110779083;GENODED1SPE;DE63360605915110779083;1
37060590;1962344530;GENODED1SPK;DE74370605901962344530;1
33060592;7462757150;GENODED1SPW;DE46330605927462757150;1
33060592;8950626929;GENODED1SPW;DE53330605928950626929;1
36060591;6610169447;GENODED1SPE;DE92360605916610169447;1
37060590;3550249343;GENODED1SPK;DE54370605903550249343;1
33060592;5053776980;GENODED1SPW;DE52330605925053776980;1
33060592;6417811165;GENODED1SPW;DE03330605926417811165;1
36060591;4770525880;GENODED1SPE;DE09360605914770525880;1
37060590;1049187576;GENODED1SPK;DE59370605901049187576;1
33060592;3905101829;GENODED1SPW;DE89330605923905101829;1
33060592;4646982052;GENODED1SPW;DE42330605924646982052;1
36060591;1961653856;GENODED1SPE;DE82360605911961653856;1
37060590;8085961595;GENODED1SPK;DE21370605908085961595;1
33060592;3006446501;GENODED1SPW;DE67330605923006446501;1
33060592;9907147892;GENODED1SPW;DE43330605929907147892;1
36060591;4756398541;GENODED1SPE;DE18360605914756398541;1
37060590;3802388434;GENODED1SPK;DE59370605903802388434;1
33060592;9696556838;GENODED1SPW;DE85330605929696556838;1
33060592;9392542999;GENODED1SPW;DE65330605929392542999;1
36060591;8397985791;GENODED1SPE;DE04360605918397985791;1
37060590;1895890920;GENODED1SPK;DE35370605901895890920;1
33060592;4198760785;GENODED1SPW;DE14330605924198760785;1
33060592;3294869118;GENODED1SPW;DE56330605923294869118;1
36060591;3192754923;GENODED1SPE;DE25360605913192754923;1
37060590;5497162738;GENODED1SPK;DE48370605905497162738;1
33060592;2393907076;GENODED1SPW;DE37330605922393907076;1
33060592;9494098544;GENODED1SPW;DE36330605929494098544;1
13051172;92976542;TESTDEX9876;DE73130511720092976542;1
13051172;85425275;TESTDEX9876;DE79130511720085425275;1
13051172;33329791;TESTDEX9876;DE62130511720033329791;1
13051172;51721674;TESTDEX9876;DE51130511720051721674;1
13051172;19038371;TESTDEX9876;DE74130511720019038371;1
16052072;586608279;TESTDEX9876;DE27160520720586608279;1
16052072;491393812;TESTDEX9876;DE24160520720491393812;1
16052072;728177927;TESTDEX9876;DE76160520720728177927;1
16052072;398191400;TESTDEX9876;DE65160520720398191400;1
76035000;9046263343;UMWEDE7NXXX;DE10760350009046263343;1
76035000;7620953098;UMWEDE7NXXX;DE48760350007620953098;1
30030100;3036340508;PULSDEDDXXX;DE91300301003036340508;1
30030880;8557783637;TUBDDEDDXXX;DE31300308808557783637;1
51051000;1488533289;PULSDE5WXXX;DE98510510001488533289;1
30030100;7529769223;PULSDEDDXXX;DE89300301007529769223;1
30030100;7409716517;PULSDEDDXXX;DE50300301007409716517;1
30020900;9064027897;CMCIDEDDXXX;DE55300209009064027897;1
30020900;5420087838;CMCIDEDDXXX;DE30300209005420087838;1
30020900;5081748193;CMCIDEDDXXX;DE87300209005081748193;1
30020900;5161179457;CMCIDEDDXXX;DE60300209005161179457;1
30020900;8822444290;CMCIDEDDXXX;DE10300209008822444290;1
30020900;7777774469;CMCIDEDDXXX;DE26300209007777774469;1
30020900;7777775436;CMCIDEDDXXX;DE10300209007777775436;1
30020900;7777779940;CMCIDEDDXXX;DE40300209007777779940;1
30020900;7777779578;CMCIDEDDXXX;DE17300209007777779578;1
30020900;7777770886;CMCIDEDDXXX;DE58300209007777770886;1
30020900;8888886026;CMCIDEDDXXX;DE62300209008888886026;1
30020900;8888884735;CMCIDEDDXXX;DE96300209008888884735;1
30020900;8888888818;CMCIDEDDXXX;DE47300209008888888818;1
30020900;8888880840;CMCIDEDDXXX;DE16300209008888880840;1
30020900;8888884800;CMCIDEDDXXX;DE87300209008888884800;1
30020900;4001537958;CMCIDEDDXXX;DE60300209004001537958;1
30020900;4041825485;CMCIDEDDXXX;DE69300209004041825485;1
30020900;4032173157;CMCIDEDDXXX;DE18300209004032173157;1
30020900;4094325324;CMCIDEDDXXX;DE45300209004094325324;1
30020900;4086775019;CMCIDEDDXXX;DE73300209004086775019;1
30020900;5056113906;CMCIDEDDXXX;DE87300209005056113906;1
30020900;5070939255;CMCIDEDDXXX;DE35300209005070939255;1
30020900;5088264776;CMCIDEDDXXX;DE64300209005088264776;1
30020900;5092394551;CMCIDEDDXXX;DE64300209005092394551;1
30020900;5094573596;CMCIDEDDXXX;DE35300209005094573596;1
30020900;9121346385;CMCIDEDDXXX;DE86300209009121346385;1
30020900;9126813518;CMCIDEDDXXX;DE58300209009126813518;1
30020900;9184975801;CMCIDEDDXXX;DE14300209009184975801;1
30020900;9132101454;CMCIDEDDXXX;DE86300209009132101454;1
30020900;9161213490;CMCIDEDDXXX;DE64300209009161213490;1
30020900;9980592834;CMCIDEDDXXX;DE87300209009980592834;1
30020900;9924281328;CMCIDEDDXXX;DE60300209009924281328;1
30020900;9946321285;CMCIDEDDXXX;DE22300209009946321285;1
30020900;9968515313;CMCIDEDDXXX;DE09300209009968515313;1
30020900;9914250092;CMCIDEDDXXX;DE32300209009914250092;1
30020900;185125434;CMCIDEDDXXX;DE87300209000185125434;1
30020900;185125434;CMCIDEDDXXX;DE87300209000185125434;1
30020900;185125434;CMCIDEDDXXX;DE87300209000185125434;1
30020900;185125434;CMCIDEDDXXX;DE87300209000185125434;1
30020900;185125434;CMCIDEDDXXX;DE87300209000185125434;1
55050000;26570474;SOLADEST550;DE29550500000026570474;1
55050000;68067173;SOLADEST550;DE72550500000068067173;1
55050000;91331155;SOLADEST550;DE35550500000091331155;1
55050000;39427647;SOLADEST550;DE55550500000039427647;1
55050000;50296709;SOLADEST550;DE54550500000050296709;1
55050000;238056709;SOLADEST550;DE75550500000238056709;1
55050000;582505038;SOLADEST550;DE82550500000582505038;1
55050000;612827824;SOLADEST550;DE71550500000612827824;1
55050000;953916772;SOLADEST550;DE23550500000953916772;1
55050000;155739964;SOLADEST550;DE17550500000155739964;1
55050000;2929302491;SOLADEST550;DE11550500002929302491;1
55050000;3825422540;SOLADEST550;DE54550500003825422540;1
55050000;1500699457;SOLADEST550;DE02550500001500699457;1
55050000;5198276478;SOLADEST550;DE25550500005198276478;1
55050000;8188537891;SOLADEST550;DE56550500008188537891;1
10020200;4713161138;BHFBDEFF500;DE89500202004713161138;19
20120200;4687678355;BHFBDEFF500;DE68500202004687678355;19
25020200;5375193235;BHFBDEFF500;DE45500202005375193235;19
30020500;2536428654;BHFBDEFF500;DE84500202002536428654;19
50020200;8671666051;BHFBDEFF500;DE89500202008671666051;1
25621327;9080054176;OLBODEH2XXX;DE35280200509080054176;19
26520017;8213208573;OLBODEH2XXX;DE76280200508213208573;19
26521703;7886234996;OLBODEH2XXX;DE47280200507886234996;19
26522319;7748652018;OLBODEH2XXX;DE32280200507748652018;19
26620010;2375619018;OLBODEH2XXX;DE47280200502375619018;19
26621413;7280895289;OLBODEH2XXX;DE93280200507280895289;19
26720028;5230217086;OLBODEH2XXX;DE79280200505230217086;19
28020050;3088299781;OLBODEH2XXX;DE72280200503088299781;1
28021002;6359158986;OLBODEH2XXX;DE02280200506359158986;19
10070000;7250414;DEUTDEBBXXX;DE05100700000007250414;1
10070024;5667456;DEUTDEDBBER;DE28100700240566745600;25
10070100;4364646;DEUTDEBB101;DE14100701000004364646;1
10070124;1261707;DEUTDEDB101;DE46100701240001261707;1
10070848;2909950;DEUTDEDB110;DE25100708480290995000;25
10077777;401277919;NORSDE51XXX;DE06100777770401277919;1
12070000;547636118;DEUTDEBB160;DE27120700000547636118;1
12070024;539176828;DEUTDEDB160;DE65120700240539176828;1
13070000;908583829;DEUTDEBRXXX;DE59130700000908583829;1
13070024;489442425;DEUTDEDBROS;DE12130700240489442425;1
57090000;6203220163;GENODE51KOB;DE97570900006203220163;1
57090000;4248134347;GENODE51KOB;DE64570900004248134347;1
57090000;6484157026;GENODE51KOB;DE36570900006484157026;1
57090000;4811249241;GENODE51KOB;DE63570900004811249241;1
57090000;5931082140;GENODE51KOB;DE95570900005931082140;1
60020030;2785864670;SOLADEST601;DE31600200302785864670;1
66020020;4887849065;SOLADEST663;DE31660200204887849065;1
60020030;2548335511;SOLADEST601;DE16600200302548335511;1
60020030;4931283830;SOLADEST601;DE24600200304931283830;1
66020020;2539391951;SOLADEST663;DE53660200202539391951;1
60020030;8419677291;SOLADEST601;DE23600200308419677291;1
60020030;8474557597;SOLADEST601;DE75600200308474557597;1
66020020;3538307495;SOLADEST663;DE94660200203538307495;1
60020030;7092555397;SOLADEST601;DE50600200307092555397;1
60020030;7213438394;SOLADEST601;DE96600200307213438394;1
50120500;439495217;CRESDE55XXX;DE65501205000439495217;1
50120500;309126552;CRESDE55XXX;DE75501205000309126552;1
50120500;790063636;CRESDE55XXX;DE52501205000790063636;1
50120500;134076019;CRESDE55XXX;DE84501205000134076019;1
50120500;336749959;CRESDE55XXX;DE19501205000336749959;1
50120500;179661248;CRESDE55XXX;DE85501205000179661248;1
50120500;164420658;CRESDE55XXX;DE93501205000164420658;1
50120500;176782215;CRESDE55XXX;DE19501205000176782215;1
50120500;151666509;CRESDE55XXX;DE88501205000151666509;1
50120500;188314483;CRESDE55XXX;DE44501205000188314483;1
50120500;293905337;CRESDE55XXX;DE79501205000293905337;1
50120500;219147173;CRESDE55XXX;DE29501205000219147173;1
50120500;235709767;CRESDE55XXX;DE70501205000235709767;1
50120500;240509571;CRESDE55XXX;DE78501205000240509571;1
50120500;250303540;CRESDE55XXX;DE47501205000250303540;1
50120500;374407519;CRESDE55XXX;DE93501205000374407519;1
50120500;385584623;CRESDE55XXX;DE29501205000385584623;1
50120500;332635074;CRESDE55XXX;DE54501205000332635074;1
50120500;399339661;CRESDE55XXX;DE37501205000399339661;1
50120500;351509711;CRESDE55XXX;DE60501205000351509711;1
50120500;499289404;CRESDE55XXX;DE87501205000499289404;1
50120500;442946278;CRESDE55XXX;DE06501205000442946278;1
50120500;432534557;CRESDE55XXX;DE94501205000432534557;1
50120500;477105036;CRESDE55XXX;DE16501205000477105036;1
50120500;444920902;CRESDE55XXX;DE44501205000444920902;1
50120500;555268362;CRESDE55XXX;DE08501205000555268362;1
50120500;503401429;CRESDE55XXX;DE60501205000503401429;1
50120500;583680824;CRESDE55XXX;DE62501205000583680824;1
50120500;574896461;CRESDE55XXX;DE59501205000574896461;1
50120500;596900000;CRESDE55XXX;DE18501205000596900000;1
50120500;623375791;CRESDE55XXX;DE11501205000623375791;1
50120500;689591604;CRESDE55XXX;DE42501205000689591604;1
50120500;653349455;CRESDE55XXX;DE28501205000653349455;1
50120500;693818498;CRESDE55XXX;DE30501205000693818498;1
50120500;606994601;CRESDE55XXX;DE77501205000606994601;1
50120500;733948956;CRESDE55XXX;DE62501205000733948956;1
50120500;718267754;CRESDE55XXX;DE29501205000718267754;1
50120500;717580894;CRESDE55XXX;DE13501205000717580894;1
50120500;733316488;CRESDE55XXX;DE42501205000733316488;1
50120500;714633181;CRESDE55XXX;DE55501205000714633181;1
50120500;872063885;CRESDE55XXX;DE93501205000872063885;1
50120500;823312877;CRESDE55XXX;DE16501205000823312877;1
50120500;816354758;CRESDE55XXX;DE17501205000816354758;1
50120500;850750394;CRESDE55XXX;DE16501205000850750394;1
50120500;907810146;CRESDE55XXX;DE76501205000907810146;1
50120500;916816290;CRESDE55XXX;DE93501205000916816290;1
50120500;985531905;CRESDE55XXX;DE10501205000985531905;1
50120500;969780349;CRESDE55XXX;DE81501205000969780349;1
50120500;914669792;CRESDE55XXX;DE76501205000914669792;1
70013000;7945782690;EBSGDEMXXXX;DE51700130007945782690;1
70013010;8481576094;EFSGDEM1XXX;;-124
70013000;3915770684;EBSGDEMXXXX;DE70700130003915770684;1
70013000;9854415821;EBSGDEMXXXX;DE66700130009854415821;1
20030000;410838204;HYVEDEMM300;DE10200300000410838204;1
20030000;464950139;HYVEDEMM300;DE10200300000464950139;1
20030000;456818969;HYVEDEMM300;DE45200300000456818969;1
20030000;491362842;HYVEDEMM300;DE59200300000491362842;1
20030000;497716048;HYVEDEMM300;DE43200300000497716048;1
20030000;1989774258;HYVEDEMM300;DE57200300001989774258;1
20030000;9319854324;HYVEDEMM300;DE80200300009319854324;1
20030000;3049978784;HYVEDEMM300;DE27200300003049978784;1
20030000;7919876707;HYVEDEMM300;DE15200300007919876707;1
20030000;2919889379;HYVEDEMM300;DE21200300002919889379;1
20030000;465286;HYVEDEMM300;DE35200300000000465286;1
20030000;391961;HYVEDEMM300;DE40200300000000391961;1
20030000;590158;HYVEDEMM300;DE17200300000000590158;1
20030000;781880;HYVEDEMM300;DE25200300000000781880;1
20030000;287912;HYVEDEMM300;DE49200300000000287912;1
20030000;2211928;HYVEDEMM300;DE64200300000002211928;1
20030000;3452182;HYVEDEMM300;DE31200300000003452182;1
20030000;4084471;HYVEDEMM300;DE34200300000004084471;1
20030000;5642236;HYVEDEMM300;DE64200300000005642236;1
20030000;5861729;HYVEDEMM300;DE65200300000005861729;1
20030000;65904245;HYVEDEMM300;DE38200300000065904245;1
20030000;56949795;HYVEDEMM300;DE16200300000056949795;1
20030000;38033064;HYVEDEMM300;DE96200300000038033064;1
20030000;98068190;HYVEDEMM300;DE70200300000098068190;1
20030000;88342217;HYVEDEMM300;DE31200300000088342217;1
20030000;902547785;HYVEDEMM300;DE75200300000902547785;1
20030000;725321830;HYVEDEMM300;DE68200300000725321830;1
20030000;398533968;HYVEDEMM300;DE52200300000398533968;1
20030000;958736357;HYVEDEMM300;DE77200300000958736357;1
20030000;779131853;HYVEDEMM300;DE06200300000779131853;1
20030000;407999;HYVEDEMM300;DE22200300000000407999;1
20030000;748681;HYVEDEMM300;DE21200300000000748681;1
20030000;425538;HYVEDEMM300;DE23200300000000425538;1
20030000;780759;HYVEDEMM300;DE28200300000000780759;1
20030000;915348;HYVEDEMM300;DE36200300000000915348;1
20030000;6198598;HYVEDEMM300;DE98200300000006198598;1
20030000;1601302;HYVEDEMM300;DE70200300000001601302;1
20030000;5506014;HYVEDEMM300;DE12200300000005506014;1
20030000;2551739;HYVEDEMM300;DE09200300000002551739;1
20030000;3868620;HYVEDEMM300;DE57200300000003868620;1
20030000;60894238;HYVEDEMM300;DE41200300000060894238;1
20030000;61990101;HYVEDEMM300;DE38200300000061990101;1
20030000;73462762;HYVEDEMM300;DE28200300000073462762;1
20030000;16776534;HYVEDEMM300;DE07200300000016776534;1
20030000;66925347;HYVEDEMM300;DE12200300000066925347;1
20030000;187120419;HYVEDEMM300;DE85200300000187120419;1
20030000;974296591;HYVEDEMM300;DE62200300000974296591;1
20030000;781634074;HYVEDEMM300;DE54200300000781634074;1
20030000;950886615;HYVEDEMM300;DE51200300000950886615;1
20030000;279203818;HYVEDEMM300;DE29200300000279203818;1
20030000;453649596;HYVEDEMM300;DE07200300000453649596;1
20030000;443759015;HYVEDEMM300;DE38200300000443759015;1
20030000;466043691;HYVEDEMM300;DE33200300000466043691;1
20030000;458761219;HYVEDEMM300;DE17200300000458761219;1
20030000;483539318;HYVEDEMM300;DE53200300000483539318;1
65110200;8927265736;IBBFDE81XXX;DE20651102008927265736;1
65110200;2983671834;IBBFDE81XXX;DE52651102002983671834;1
65110200;9714061591;IBBFDE81XXX;DE39651102009714061591;1
65110200;5518805233;IBBFDE81XXX;DE15651102005518805233;1
65110200;5156140220;IBBFDE81XXX;DE45651102005156140220;1
50090500;2930594612;GENODEF1S12;DE25500905002930594612;1
50090500;6213729645;GENODEF1S12;DE47500905006213729645;1
50090500;3335981470;GENODEF1S12;DE36500905003335981470;1
50090500;8779462364;GENODEF1S12;DE59500905008779462364;1
50090500;4751527904;GENODEF1S12;DE78500905004751527904;1
50090500;9816618227;GENODEF1S12;DE51500905009816618227;1
50090500;4678517534;GENODEF1S12;DE90500905004678517534;1
50090500;1732118891;GENODEF1S12;DE94500905001732118891;1
50090500;6155801949;GENODEF1S12;DE51500905006155801949;1
50090500;1542459303;GENODEF1S12;DE05500905001542459303;1
50090500;9460103580;GENODEF1S12;DE28500905009460103580;1
50090500;9940716746;GENODEF1S12;DE77500905009940716746;1
50090500;3800334367;GENODEF1S12;DE13500905003800334367;1
50090500;3356094169;GENODEF1S12;DE23500905003356094169;1
50090500;7904879593;GENODEF1S12;DE71500905007904879593;1
50090500;3650520332;GENODEF1S12;DE97500905003650520332;1
50090500;1439072585;GENODEF1S12;DE29500905001439072585;1
50090500;2295645136;GENODEF1S12;DE19500905002295645136;1
50090500;7144073073;GENODEF1S12;DE72500905007144073073;1
50090500;2914039972;GENODEF1S12;DE81500905002914039972;1
50090500;5898383221;GENODEF1S12;DE15500905005898383221;1
50090500;4191024102;GENODEF1S12;DE98500905004191024102;1
50090500;3192862870;GENODEF1S12;DE44500905003192862870;1
50090500;3399775085;GENODEF1S12;DE73500905003399775085;1
50090500;7599254948;GENODEF1S12;DE20500905007599254948;1
21050170;2188134;NOLADE21KIE;DE30210501700002188134;1
21050170;5811872;NOLADE21KIE;DE94210501700005811872;1
21050170;4937595;NOLADE21KIE;DE41210501700004937595;1
21050170;2563617;NOLADE21KIE;DE41210501700002563617;1
21050170;15761240;NOLADE21KIE;DE25210501700015761240;1
21050170;40161440;NOLADE21KIE;DE98210501700040161440;1
21050170;70256656;NOLADE21KIE;DE12210501700070256656;1
21050170;90038944;NOLADE21KIE;DE06210501700090038944;1
21050170;37342532;NOLADE21KIE;DE49210501700037342532;1
21050170;859068157;NOLADE21KIE;DE21210501700859068157;1
21050170;967190083;NOLADE21KIE;DE37210501700967190083;1
21050170;332892983;NOLADE21KIE;DE12210501700332892983;1
21050170;198232126;NOLADE21KIE;DE08210501700198232126;1
21050170;374052439;NOLADE21KIE;DE32210501700374052439;1
21050170;6179000499;NOLADE21KIE;DE57210501706179000499;1
21050170;7138256743;NOLADE21KIE;DE59210501707138256743;1
21050170;5780245725;NOLADE21KIE;DE46210501705780245725;1
21050170;8250329771;NOLADE21KIE;DE03210501708250329771;1
21050170;4311268876;NOLADE21KIE;DE58210501704311268876;1
21050170;572875;NOLADE21KIE;DE47210501700000572875;1
21050170;103655;NOLADE21KIE;DE11210501700000103655;1
21050170;904656;NOLADE21KIE;DE07210501700000904656;1
21050170;755645;NOLADE21KIE;DE35210501700000755645;1
21050170;148007;NOLADE21KIE;DE69210501700000148007;1
21050170;810817;NOLADE21KIE;DE20210501700000810817;1
21050170;460480;NOLADE21KIE;DE67210501700000460480;1
21050170;741202;NOLADE21KIE;DE56210501700000741202;1
21050170;667993;NOLADE21KIE;DE33210501700000667993;1
10080000;4772799;DRESDEFF100;DE69100800000004772799;1
10080005;1060149;DRESDEFFI26;DE54100800050001060149;1
10080006;3140995;DRESDEFFXXX;DE35100800060003140995;1
10080055;1354732;DRESDEFF112;DE26100800550001354732;1
10080057;9922327;DRESDEFF114;DE49100800570009922327;1
10080088;11684143;DRESDEFFXXX;DE29100800880011684143;1
10080900;65006757;DRESDEFF199;DE19100809000065006757;1
12080000;10539982;DRESDEFF120;DE81120800000010539982;1
13080000;28759360;DRESDEFF130;DE31130800000028759360;1
14080000;789193356;DRESDEFF140;DE29140800000789193356;1
14080011;759892004;DRESDEFFI27;DE68140800110759892004;1
15080000;371051805;DRESDEFF150;DE29150800000371051805;1
16080000;865863800;DRESDEFF160;DE17160800000865863800;1
17080000;837381498;DRESDEFF170;DE35170800000837381498;1
18080000;9664290179;DRESDEFF180;DE77180800009664290179;1
20080000;7899336147;DRESDEFF200;DE83200800007899336147;1
20080055;7881345046;DRESDEFF207;DE91200800557881345046;1
20080057;8724915908;DRESDEFF208;DE38200800578724915908;1
21080050;74184;DRESDEFF210;DE50210800500007418400;25
21280002;58233;DRESDEFF212;DE05212800020005823300;25
21480003;77495;DRESDEFF214;DE58214800030007749500;25
21580000;12348;DRESDEFF215;DE09215800000001234800;25
22180000;97068;DRESDEFF221;DE36221800000009706800;25
22181400;739169;DRESDEFF206;DE09221814000073916900;25
22280000;317470;DRESDEFF201;DE79222800000031747000;25
23080040;601652;DRESDEFF230;DE41230800400060165200;25
24080000;735929;DRESDEFF240;DE50240800000073592900;25
24180000;672282;DRESDEFF242;DE50241800000067228200;25
24180001;6388802;DRESDEFF241;DE98241800010638880200;25
25080020;1586580;DRESDEFF250;DE04250800200158658000;25
25480021;8370515;DRESDEFF254;DE86254800210837051500;25
25780022;3498803;DRESDEFF257;DE53257800220003498803;1
25980027;1771140;DRESDEFF259;DE18259800270001771140;1
26080024;87398128;DRESDEFF260;DE36260800248739812800;25
26280020;89038851;DRESDEFF261;DE72262800200089038851;1
26281420;83990576;DRESDEFF262;DE82262814200083990576;1
26580070;68821367;DRESDEFF265;DE33265800706882136700;25
26880063;71520660;DRESDEFF268;DE43268800637152066000;25
26981062;84169517;DRESDEFF269;DE76269810628416951700;25
27080060;87271232;DRESDEFF270;DE78270800608727123200;25
28280012;88025770;DRESDEFF282;DE05282800128802577000;25
29080010;49895565;DRESDEFF290;DE75290800104989556500;25
36050105;69408432;SPESDE3EXXX;DE38360501050069408432;1
36050105;29961729;SPESDE3EXXX;DE49360501050029961729;1
36050105;23404330;SPESDE3EXXX;DE87360501050023404330;1
36050105;72021304;SPESDE3EXXX;DE12360501050072021304;1
36050105;69122073;SPESDE3EXXX;DE55360501050069122073;1
36050105;5701926239;SPESDE3EXXX;DE44360501055701926239;1
36050105;3114138773;SPESDE3EXXX;DE51360501053114138773;1
36050105;8609293348;SPESDE3EXXX;DE02360501058609293348;1
36050105;9500299665;SPESDE3EXXX;DE39360501059500299665;1
36050105;9944646752;SPESDE3EXXX;DE67360501059944646752;1
20090500;1000489069;AUGBDE71NET;DE76200905001000489069;1
25090500;8407334095;GENODEF1S09;DE53250905008407334095;1
70090500;5605633931;GENODEF1S04;DE75700905005605633931;1
76090500;1105562872;GENODEF1S06;DE12760905001105562872;1
20090500;6713839770;AUGBDE71NET;DE13200905006713839770;1
20090500;9818610223;AUGBDE71NET;DE14200905009818610223;1
25090500;5910417971;GENODEF1S09;DE71250905005910417971;1
70090500;2115745586;GENODEF1S04;DE50700905002115745586;1
76090500;1511480138;GENODEF1S06;DE87760905001511480138;1
20090500;9828866708;AUGBDE71NET;DE25200905009828866708;1
20090500;5024218744;AUGBDE71NET;DE64200905005024218744;1
25090500;5121280325;GENODEF1S09;DE26250905005121280325;1
70090500;8124960092;GENODEF1S04;DE23700905008124960092;1
76090500;4926434762;GENODEF1S06;DE02760905004926434762;1
20090500;6832748746;AUGBDE71NET;DE36200905006832748746;1
20090500;7336129978;AUGBDE71NET;DE94200905007336129978;1
25090500;6932310678;GENODEF1S09;DE96250905006932310678;1
70090500;9234001354;GENODEF1S04;DE28700905009234001354;1
76090500;2330500305;GENODEF1S06;DE23760905002330500305;1
20090500;5643818853;AUGBDE71NET;DE91200905005643818853;1
20090500;6740183717;AUGBDE71NET;DE88200905006740183717;1
25090500;8742204479;GENODEF1S09;DE53250905008742204479;1
70090500;7640402729;GENODEF1S04;DE97700905007640402729;1
76090500;1051144294;GENODEF1S06;DE35760905001051144294;1
20090500;9552440890;AUGBDE71NET;DE18200905009552440890;1
20090500;5055349230;AUGBDE71NET;DE81200905005055349230;1
25090500;7357034857;GENODEF1S09;DE81250905007357034857;1
70090500;6450641480;GENODEF1S04;DE91700905006450641480;1
76090500;8968623384;GENODEF1S06;DE47760905008968623384;1
20090500;8360314269;AUGBDE71NET;DE62200905008360314269;1
20090500;2862296284;AUGBDE71NET;DE77200905002862296284;1
25090500;3167129530;GENODEF1S09;DE34250905003167129530;1
70090500;2568032726;GENODEF1S04;DE93700905002568032726;1
76090500;8479330712;GENODEF1S06;DE92760905008479330712;1
20090500;5371446886;AUGBDE71NET;DE34200905005371446886;1
20090500;2974967186;AUGBDE71NET;DE14200905002974967186;1
25090500;6472928868;GENODEF1S09;DE58250905006472928868;1
70090500;1175445264;GENODEF1S04;DE81700905001175445264;1
76090500;2584526678;GENODEF1S06;DE36760905002584526678;1
20090500;6583435199;AUGBDE71NET;DE67200905006583435199;1
20090500;5188251835;AUGBDE71NET;DE22200905005188251835;1
25090500;2787248784;GENODEF1S09;DE79250905002787248784;1
70090500;5485220718;GENODEF1S04;DE66700905005485220718;1
76090500;5693784201;GENODEF1S06;DE13760905005693784201;1
20090500;8799087677;AUGBDE71NET;DE34200905008799087677;1
20090500;3499657430;AUGBDE71NET;DE26200905003499657430;1
25090500;2096877596;GENODEF1S09;DE83250905002096877596;1
70090500;2493856318;GENODEF1S04;DE35700905002493856318;1
72090500;8884753432;GENODEF1S03;DE86720905008884753432;1
75090500;2081237329;GENODEF1S05;DE34750905002081237329;1
72090500;8243223085;GENODEF1S03;DE64720905008243223085;1
72090500;7058203297;GENODEF1S03;DE47720905007058203297;1
75090500;3770989622;GENODEF1S05;DE57750905003770989622;1
72090500;3316845316;GENODEF1S03;DE03720905003316845316;1
72090500;8311795551;GENODEF1S03;DE39720905008311795551;1
75090500;6404137916;GENODEF1S05;DE64750905006404137916;1
72090500;7435204762;GENODEF1S03;DE36720905007435204762;1
72090500;6514038952;GENODEF1S03;DE40720905006514038952;1
75090500;3877011700;GENODEF1S05;DE51750905003877011700;1
72090500;8964206046;GENODEF1S03;DE80720905008964206046;1
72090500;3829552811;GENODEF1S03;DE50720905003829552811;1
75090500;4331767197;GENODEF1S05;DE51750905004331767197;1
72090500;2298287370;GENODEF1S03;DE32720905002298287370;1
72090500;4091551099;GENODEF1S03;DE97720905004091551099;1
75090500;5395349090;GENODEF1S05;DE36750905005395349090;1
72090500;6599583070;GENODEF1S03;DE07720905006599583070;1
40060560;9693541495;GENODEF1S08;DE78400605609693541495;1
40060560;5030463248;GENODEF1S08;DE49400605605030463248;1
40060560;8675339928;GENODEF1S08;DE80400605608675339928;1
40060560;1971769022;GENODEF1S08;DE93400605601971769022;1
40060560;4377209797;GENODEF1S08;DE31400605604377209797;1
40060560;2346848778;GENODEF1S08;DE52400605602346848778;1
40060560;9281283126;GENODEF1S08;DE31400605609281283126;1
40060560;4412289868;GENODEF1S08;DE46400605604412289868;1
40060560;3142664324;GENODEF1S08;DE09400605603142664324;1
40060560;9948309818;GENODEF1S08;DE75400605609948309818;1
40060560;6849467474;GENODEF1S08;DE55400605606849467474;1
40060560;5920227215;GENODEF1S08;DE63400605605920227215;1
40060560;6452511614;GENODEF1S08;DE79400605606452511614;1
40060560;3705922396;GENODEF1S08;DE40400605603705922396;1
40060560;3966353701;GENODEF1S08;DE41400605603966353701;1
40060560;9599596776;GENODEF1S08;DE74400605609599596776;1
40060560;6999895676;GENODEF1S08;DE97400605606999895676;1
40060560;7499423987;GENODEF1S08;DE14400605607499423987;1
40060560;2399741407;GENODEF1S08;DE96400605602399741407;1
40060560;1199210533;GENODEF1S08;DE58400605601199210533;1
60090800;8266193585;GENODEF1S02;DE47600908008266193585;1
60090800;8335982156;GENODEF1S02;DE75600908008335982156;1
60090800;7122195448;GENODEF1S02;DE59600908007122195448;1
60090800;5657025330;GENODEF1S02;DE19600908005657025330;1
60090800;5624310887;GENODEF1S02;DE26600908005624310887;1
60090800;907588;GENODEF1S02;DE20600908000000907588;1
60090800;617296;GENODEF1S02;DE13600908000000617296;1
60090800;228796;GENODEF1S02;DE30600908000000228796;1
60090800;652768;GENODEF1S02;DE47600908000000652768;1
60090800;350362;GENODEF1S02;DE34600908000000350362;1
60090800;822566;GENODEF1S02;DE12600908000000822566;1
60090800;912921;GENODEF1S02;DE74600908000000912921;1
60090800;268836;GENODEF1S02;DE15600908000000268836;1
60090800;552804;GENODEF1S02;DE50600908000000552804;1
60090800;2187264;GENODEF1S02;DE71600908000002187264;1
60090800;7411391;GENODEF1S02;DE28600908000007411391;1
60090800;3600823;GENODEF1S02;DE83600908000003600823;1
60090800;4485912;GENODEF1S02;DE85600908000004485912;1
60090800;95808965;GENODEF1S02;DE97600908000095808965;1
60090800;91699100;GENODEF1S02;DE04600908000091699100;1
60090800;95367144;GENODEF1S02;DE10600908000095367144;1
60090800;94689210;GENODEF1S02;DE37600908000094689210;1
60090800;98741438;GENODEF1S02;DE61600908000098741438;1
60090800;91587069;GENODEF1S02;DE90600908000091587069;1
60090800;95067892;GENODEF1S02;DE05600908000095067892;1
60090800;91379768;GENODEF1S02;DE26600908000091379768;1
60090800;92689388;GENODEF1S02;DE84600908000092689388;1
60090800;98946587;GENODEF1S02;DE29600908000098946587;1
10030600;3447831609;GENODEF1OGK;DE42100306003447831609;1
70090100;4105209722;GENODEF1M04;DE42700901004105209722;1
70091500;2881942530;GENODEF1DCA;DE03700915002881942530;1
70091600;2833290077;GENODEF1DSS;DE47700916002833290077;1
70091900;7412753090;GENODEF1EDV;DE50700919007412753090;1
70093200;5494387184;GENODEF1STH;DE36700932005494387184;1
70093400;6590302915;GENODEF1ISV;DE88700934006590302915;1
70130800;6791125707;GENODEF1M06;DE08701308006791125707;1
70160300;9298318055;GENODEF1M02;DE95701603009298318055;1
55090500;8207000928;GENODEF1S01;DE11550905008207000928;1
55090500;8704340655;GENODEF1S01;DE72550905008704340655;1
55090500;4701358391;GENODEF1S01;DE31550905004701358391;1
55090500;7506535291;GENODEF1S01;DE23550905007506535291;1
55090500;7606970117;GENODEF1S01;DE63550905007606970117;1
55090500;1201893404;GENODEF1S01;DE29550905001201893404;1
55090500;5808151840;GENODEF1S01;DE27550905005808151840;1
55090500;3804624063;GENODEF1S01;DE73550905003804624063;1
55090500;7604832383;GENODEF1S01;DE98550905007604832383;1
55090500;9309552607;GENODEF1S01;DE91550905009309552607;1
55090500;4006840845;GENODEF1S01;DE24550905004006840845;1
55090500;2901758664;GENODEF1S01;DE93550905002901758664;1
55090500;9807060083;GENODEF1S01;DE53550905009807060083;1
55090500;2908405984;GENODEF1S01;DE98550905002908405984;1
55090500;7609751416;GENODEF1S01;DE62550905007609751416;1
55090500;2203264702;GENODEF1S01;DE32550905002203264702;1
55090500;1407349356;GENODEF1S01;DE15550905001407349356;1
55090500;2806695323;GENODEF1S01;DE90550905002806695323;1
55090500;4803167535;GENODEF1S01;DE59550905004803167535;1
55090500;5500767170;GENODEF1S01;DE60550905005500767170;1
55090500;1008497611;GENODEF1S01;DE94550905001008497611;1
55090500;1506779647;GENODEF1S01;DE39550905001506779647;1
55090500;5103131748;GENODEF1S01;DE29550905005103131748;1
55090500;5705281030;GENODEF1S01;DE26550905005705281030;1
55090500;1308178253;GENODEF1S01;DE77550905001308178253;1
55090500;6911591371;GENODEF1S01;DE04550905006911591371;1
55090500;1413423824;GENODEF1S01;DE83550905001413423824;1
55090500;5516285708;GENODEF1S01;DE55550905005516285708;1
55090500;5714407091;GENODEF1S01;DE47550905005714407091;1
55090500;9512368200;GENODEF1S01;DE08550905009512368200;1
55090500;8717016900;GENODEF1S01;DE40550905008717016900;1
55090500;5912615404;GENODEF1S01;DE38550905005912615404;1
55090500;4218207780;GENODEF1S01;DE91550905004218207780;1
55090500;8014161039;GENODEF1S01;DE60550905008014161039;1
55090500;7117844977;GENODEF1S01;DE48550905007117844977;1
55090500;8310398541;GENODEF1S01;DE23550905008310398541;1
55090500;8211068813;GENODEF1S01;DE22550905008211068813;1
55090500;5414055325;GENODEF1S01;DE36550905005414055325;1
55090500;9511385134;GENODEF1S01;DE98550905009511385134;1
55090500;5213141052;GENODEF1S01;DE80550905005213141052;1
55090500;6817711871;GENODEF1S01;DE25550905006817711871;1
55090500;4019175692;GENODEF1S01;DE22550905004019175692;1
55090500;7211723665;GENODEF1S01;DE29550905007211723665;1
55090500;3611749594;GENODEF1S01;DE60550905003611749594;1
55090500;2511188417;GENODEF1S01;DE52550905002511188417;1
55090500;9010515405;GENODEF1S01;DE25550905009010515405;1
55090500;3111712522;GENODEF1S01;DE35550905003111712522;1
55090500;3919572794;GENODEF1S01;DE22550905003919572794;1
55090500;2718675069;GENODEF1S01;DE97550905002718675069;1
55090500;4819225757;GENODEF1S01;DE23550905004819225757;1
55090500;7128147132;GENODEF1S01;DE33550905007128147132;1
55090500;2527254903;GENODEF1S01;DE85550905002527254903;1
55090500;7323193985;GENODEF1S01;DE26550905007323193985;1
55090500;4723373347;GENODEF1S01;DE94550905004723373347;1
55090500;7320020451;GENODEF1S01;DE09550905007320020451;1
55090500;6829166103;GENODEF1S01;DE85550905006829166103;1
55090500;6020121584;GENODEF1S01;DE75550905006020121584;1
55090500;3124885908;GENODEF1S01;DE56550905003124885908;1
55090500;1624923010;GENODEF1S01;DE40550905001624923010;1
55090500;3423974951;GENODEF1S01;DE28550905003423974951;1
55090500;3728115991;GENODEF1S01;DE03550905003728115991;1
55090500;7228223593;GENODEF1S01;DE81550905007228223593;1
55090500;4724615176;GENODEF1S01;DE22550905004724615176;1
55090500;9529599875;GENODEF1S01;DE45550905009529599875;1
55090500;2221804022;GENODEF1S01;DE05550905002221804022;1
55090500;7125635091;GENODEF1S01;DE24550905007125635091;1
55090500;7720174930;GENODEF1S01;DE58550905007720174930;1
55090500;7824692204;GENODEF1S01;DE49550905007824692204;1
55090500;2024738723;GENODEF1S01;DE59550905002024738723;1
55090500;9724836778;GENODEF1S01;DE85550905009724836778;1
55090500;4120935306;GENODEF1S01;DE21550905004120935306;1
55090500;2929211780;GENODEF1S01;DE94550905002929211780;1
55090500;8121783466;GENODEF1S01;DE57550905008121783466;1
55090500;3422522236;GENODEF1S01;DE25550905003422522236;1
55090500;7534926897;GENODEF1S01;DE07550905007534926897;1
55090500;7734458389;GENODEF1S01;DE41550905007734458389;1
55090500;7232758695;GENODEF1S01;DE83550905007232758695;1
55090500;1931381881;GENODEF1S01;DE68550905001931381881;1
55090500;8637355475;GENODEF1S01;DE12550905008637355475;1
55090500;3734447501;GENODEF1S01;DE93550905003734447501;1
55090500;7938402540;GENODEF1S01;DE84550905007938402540;1
55090500;4132104841;GENODEF1S01;DE38550905004132104841;1
55090500;1736190730;GENODEF1S01;DE19550905001736190730;1
55090500;1336426504;GENODEF1S01;DE55550905001336426504;1
55090500;4035145394;GENODEF1S01;DE43550905004035145394;1
55090500;4131344250;GENODEF1S01;DE28550905004131344250;1
55090500;6334895111;GENODEF1S01;DE27550905006334895111;1
55090500;3237533993;GENODEF1S01;DE05550905003237533993;1
55090500;5437240525;GENODEF1S01;DE97550905005437240525;1
55090500;2435548924;GENODEF1S01;DE39550905002435548924;1
55090500;3135075024;GENODEF1S01;DE86550905003135075024;1
55090500;6933269125;GENODEF1S01;DE04550905006933269125;1
55090500;1231931698;GENODEF1S01;DE66550905001231931698;1
55090500;2532312768;GENODEF1S01;DE53550905002532312768;1
55090500;5036029547;GENODEF1S01;DE52550905005036029547;1
55090500;7032102294;GENODEF1S01;DE49550905007032102294;1
55090500;9036207862;GENODEF1S01;DE59550905009036207862;1
55090500;2438861296;GENODEF1S01;DE92550905002438861296;1
55090500;5731161670;GENODEF1S01;DE76550905005731161670;1
55090500;9842143917;GENODEF1S01;DE26550905009842143917;1
55090500;6848745390;GENODEF1S01;DE24550905006848745390;1
55090500;9048147205;GENODEF1S01;DE32550905009048147205;1
55090500;5648904626;GENODEF1S01;DE37550905005648904626;1
55090500;6942500051;GENODEF1S01;DE03550905006942500051;1
55090500;3949290726;GENODEF1S01;DE52550905003949290726;1
55090500;8148743356;GENODEF1S01;DE30550905008148743356;1
55090500;2646613800;GENODEF1S01;DE36550905002646613800;1
55090500;6448083020;GENODEF1S01;DE45550905006448083020;1
55090500;1948103969;GENODEF1S01;DE86550905001948103969;1
55090500;5045943922;GENODEF1S01;DE14550905005045943922;1
55090500;9443602705;GENODEF1S01;DE06550905009443602705;1
55090500;2541136124;GENODEF1S01;DE83550905002541136124;1
55090500;4441425315;GENODEF1S01;DE98550905004441425315;1
55090500;4941051424;GENODEF1S01;DE03550905004941051424;1
55090500;8743688114;GENODEF1S01;DE24550905008743688114;1
55090500;3841919564;GENODEF1S01;DE80550905003841919564;1
55090500;1249724775;GENODEF1S01;DE51550905001249724775;1
55090500;9949280992;GENODEF1S01;DE21550905009949280992;1
55090500;5445292356;GENODEF1S01;DE67550905005445292356;1
55090500;2144786056;GENODEF1S01;DE57550905002144786056;1
55090500;9346315243;GENODEF1S01;DE25550905009346315243;1
55090500;1647725335;GENODEF1S01;DE48550905001647725335;1
55090500;5044947260;GENODEF1S01;DE51550905005044947260;1
55090500;8449596843;GENODEF1S01;DE12550905008449596843;1
55090500;2653840930;GENODEF1S01;DE98550905002653840930;1
55090500;3656217095;GENODEF1S01;DE77550905003656217095;1
55090500;3852408384;GENODEF1S01;DE36550905003852408384;1
55090500;8654583493;GENODEF1S01;DE42550905008654583493;1
55090500;8050927198;GENODEF1S01;DE30550905008050927198;1
55090500;7958808229;GENODEF1S01;DE79550905007958808229;1
55090500;5657848310;GENODEF1S01;DE32550905005657848310;1
55090500;1650684147;GENODEF1S01;DE63550905001650684147;1
55090500;5451803944;GENODEF1S01;DE79550905005451803944;1
55090500;5756292346;GENODEF1S01;DE16550905005756292346;1
55090500;7852105950;GENODEF1S01;DE17550905007852105950;1
55090500;5351140064;GENODEF1S01;DE68550905005351140064;1
55090500;6452215686;GENODEF1S01;DE73550905006452215686;1
55090500;9552390062;GENODEF1S01;DE16550905009552390062;1
55090500;4350789910;GENODEF1S01;DE69550905004350789910;1
55090500;2252653121;GENODEF1S01;DE43550905002252653121;1
55090500;9555974036;GENODEF1S01;DE15550905009555974036;1
55090500;9253329932;GENODEF1S01;DE49550905009253329932;1
55090500;4855418968;GENODEF1S01;DE29550905004855418968;1
55090500;6353172768;GENODEF1S01;DE03550905006353172768;1
55090500;6956184416;GENODEF1S01;DE95550905006956184416;1
55090500;6359105545;GENODEF1S01;DE48550905006359105545;1
55090500;6755636699;GENODEF1S01;DE37550905006755636699;1
55090500;5564386493;GENODEF1S01;DE26550905005564386493;1
55090500;1560487996;GENODEF1S01;DE75550905001560487996;1
55090500;2368125872;GENODEF1S01;DE66550905002368125872;1
55090500;1060838632;GENODEF1S01;DE77550905001060838632;1
55090500;7363060918;GENODEF1S01;DE89550905007363060918;1
55090500;3867099597;GENODEF1S01;DE64550905003867099597;1
55090500;5361099546;GENODEF1S01;DE73550905005361099546;1
55090500;3865983950;GENODEF1S01;DE56550905003865983950;1
55090500;5063312118;GENODEF1S01;DE81550905005063312118;1
55090500;3663139045;GENODEF1S01;DE43550905003663139045;1
55090500;9561982332;GENODEF1S01;DE84550905009561982332;1
55090500;8869243512;GENODEF1S01;DE48550905008869243512;1
55090500;5261936133;GENODEF1S01;DE85550905005261936133;1
55090500;5366445382;GENODEF1S01;DE53550905005366445382;1
55090500;8662561292;GENODEF1S01;DE94550905008662561292;1
55090500;4369756843;GENODEF1S01;DE13550905004369756843;1
55090500;1464311747;GENODEF1S01;DE25550905001464311747;1
55090500;2064890128;GENODEF1S01;DE32550905002064890128;1
55090500;8169101624;GENODEF1S01;DE89550905008169101624;1
55090500;4867582206;GENODEF1S01;DE71550905004867582206;1
55090500;9761524381;GENODEF1S01;DE65550905009761524381;1
55090500;5163636798;GENODEF1S01;DE43550905005163636798;1
55090500;7169499279;GENODEF1S01;DE88550905007169499279;1
55090500;4667094342;GENODEF1S01;DE02550905004667094342;1
55090500;3573071693;GENODEF1S01;DE29550905003573071693;1
55090500;5073125106;GENODEF1S01;DE55550905005073125106;1
55090500;2072541360;GENODEF1S01;DE93550905002072541360;1
55090500;1476548091;GENODEF1S01;DE58550905001476548091;1
55090500;7670388777;GENODEF1S01;DE92550905007670388777;1
55090500;5370583014;GENODEF1S01;DE53550905005370583014;1
55090500;7977827169;GENODEF1S01;DE06550905007977827169;1
55090500;8877632643;GENODEF1S01;DE54550905008877632643;1
55090500;6670789585;GENODEF1S01;DE29550905006670789585;1
55090500;5773210668;GENODEF1S01;DE50550905005773210668;1
55090500;7571843991;GENODEF1S01;DE90550905007571843991;1
55090500;3077638956;GENODEF1S01;DE02550905003077638956;1
55090500;7372201590;GENODEF1S01;DE15550905007372201590;1
55090500;3471874784;GENODEF1S01;DE08550905003471874784;1
55090500;3176432273;GENODEF1S01;DE30550905003176432273;1
55090500;1872984420;GENODEF1S01;DE07550905001872984420;1
55090500;8476213737;GENODEF1S01;DE93550905008476213737;1
55090500;7678708778;GENODEF1S01;DE37550905007678708778;1
55090500;3371092942;GENODEF1S01;DE73550905003371092942;1
55090500;7373967240;GENODEF1S01;DE55550905007373967240;1
55090500;2971270059;GENODEF1S01;DE32550905002971270059;1
55090500;9578006842;GENODEF1S01;DE24550905009578006842;1
55090500;7174277196;GENODEF1S01;DE24550905007174277196;1
55090500;2171913261;GENODEF1S01;DE09550905002171913261;1
55090500;5875524480;GENODEF1S01;DE20550905005875524480;1
55090500;7581721364;GENODEF1S01;DE06550905007581721364;1
55090500;7383680355;GENODEF1S01;DE97550905007383680355;1
55090500;4086927050;GENODEF1S01;DE78550905004086927050;1
55090500;8487158238;GENODEF1S01;DE45550905008487158238;1
55090500;2488408858;GENODEF1S01;DE51550905002488408858;1
55090500;1383922811;GENODEF1S01;DE03550905001383922811;1
55090500;2086657638;GENODEF1S01;DE68550905002086657638;1
55090500;4788517526;GENODEF1S01;DE16550905004788517526;1
55090500;2287739693;GENODEF1S01;DE04550905002287739693;1
55090500;1681138738;GENODEF1S01;DE53550905001681138738;1
55090500;7581802216;GENODEF1S01;DE84550905007581802216;1
55090500;5086933893;GENODEF1S01;DE57550905005086933893;1
55090500;1982368983;GENODEF1S01;DE56550905001982368983;1
55090500;2684576331;GENODEF1S01;DE29550905002684576331;1
55090500;5282289645;GENODEF1S01;DE31550905005282289645;1
55090500;3481684104;GENODEF1S01;DE78550905003481684104;1
55090500;7584930855;GENODEF1S01;DE57550905007584930855;1
55090500;4489784675;GENODEF1S01;DE22550905004489784675;1
55090500;1283939758;GENODEF1S01;DE36550905001283939758;1
55090500;4580585203;GENODEF1S01;DE44550905004580585203;1
55090500;9485568066;GENODEF1S01;DE19550905009485568066;1
55090500;9588320052;GENODEF1S01;DE90550905009588320052;1
55090500;8385522591;GENODEF1S01;DE19550905008385522591;1
55090500;6884025040;GENODEF1S01;DE47550905006884025040;1
55090500;8690586867;GENODEF1S01;DE70550905008690586867;1
55090500;2992680739;GENODEF1S01;DE50550905002992680739;1
55090500;6592530168;GENODEF1S01;DE35550905006592530168;1
55090500;6798050354;GENODEF1S01;DE63550905006798050354;1
55090500;8692274323;GENODEF1S01;DE46550905008692274323;1
10090900;9949020508;GENODEF1P01;DE97100909009949020508;1
20090900;7342128005;GENODEF1P08;DE38200909007342128005;1
21090900;1614053798;GENODEF1P11;DE26210909001614053798;1
25090900;5723582573;GENODEF1P09;DE39250909005723582573;1
27090900;3251845657;GENODEF1P02;DE53270909003251845657;1
29090900;3176686475;GENODEF1P03;DE08290909003176686475;1
30060992;7922010316;GENODEF1P05;DE09300609927922010316;1
37060993;1549170413;GENODEF1P13;DE60370609931549170413;1
40090900;1731663740;GENODEF1P15;DE38400909001731663740;1
44090920;2124610413;GENODEF1P04;DE58440909202124610413;1
50090900;2824236432;GENODEF1P06;DE79500909002824236432;1
57090900;4957246509;GENODEF1P12;DE57570909004957246509;1
58590900;6549759599;GENODEF1P21;DE21585909006549759599;1
59090900;1950007056;GENODEF1P19;DE91590909001950007056;1
67230000;4127722202;MLPBDE61XXX;DE17672300004127722202;1
67230001;7092887441;MLPBDE61001;DE80672300017092887441;1
67230000;6162221870;MLPBDE61XXX;DE85672300006162221870;1
67230000;9241893096;MLPBDE61XXX;DE64672300009241893096;1
67230001;3985931428;MLPBDE61001;DE55672300013985931428;1
10120100;3248534356;WELADED1WBB;DE34101201003248534356;1
50110801;1909013836;CHASDEFXVR1;DE92501108011909013836;1
10120100;4729178569;WELADED1WBB;DE43101201004729178569;1
10120100;2811942376;WELADED1WBB;DE03101201002811942376;1
50110801;9973628216;CHASDEFXVR1;DE25501108019973628216;1
70020270;1981896;HYVEDEMMXXX;DE46700202700001981896;1
70020270;1010993;HYVEDEMMXXX;DE80700202700001010993;1
70020270;1982324;HYVEDEMMXXX;DE33700202700001982324;1
70020270;1071833;HYVEDEMMXXX;DE95700202700001071833;1
70020270;1336898;HYVEDEMMXXX;DE97700202700001336898;1
70020270;9040633;HYVEDEMMXXX;DE38700202700009040633;1
70020270;9695756;HYVEDEMMXXX;DE55700202700009695756;1
70020270;9261916;HYVEDEMMXXX;DE15700202700009261916;1
70020270;9417528;HYVEDEMMXXX;DE46700202700009417528;1
70020270;9593134;HYVEDEMMXXX;DE44700202700009593134;1
70020270;12762081;HYVEDEMMXXX;DE41700202700012762081;1
70020270;10560294;HYVEDEMMXXX;DE94700202700010560294;1
70020270;19023610;HYVEDEMMXXX;DE58700202700019023610;1
70020270;14445063;HYVEDEMMXXX;DE50700202700014445063;1
70020270;16012597;HYVEDEMMXXX;DE60700202700016012597;1
70020270;20253769;HYVEDEMMXXX;DE20700202700020253769;1
70020270;20994074;HYVEDEMMXXX;DE90700202700020994074;1
70020270;20603062;HYVEDEMMXXX;DE31700202700020603062;1
70020270;20321811;HYVEDEMMXXX;DE66700202700020321811;1
70020270;20217998;HYVEDEMMXXX;DE08700202700020217998;1
70020270;21205132;HYVEDEMMXXX;DE80700202700021205132;1
70020270;21395720;HYVEDEMMXXX;DE54700202700021395720;1
70020270;21896492;HYVEDEMMXXX;DE40700202700021896492;1
70020270;21697756;HYVEDEMMXXX;DE66700202700021697756;1
70020270;21414805;HYVEDEMMXXX;DE23700202700021414805;1
70020270;22451690;HYVEDEMMXXX;DE74700202700022451690;1
70020270;22911950;HYVEDEMMXXX;DE15700202700022911950;1
70020270;22197464;HYVEDEMMXXX;DE68700202700022197464;1
70020270;22334305;HYVEDEMMXXX;DE91700202700022334305;1
70020270;22205572;HYVEDEMMXXX;DE81700202700022205572;1
70020270;23863454;HYVEDEMMXXX;DE51700202700023863454;1
70020270;23041781;HYVEDEMMXXX;DE61700202700023041781;1
70020270;23481840;HYVEDEMMXXX;DE95700202700023481840;1
70020270;23139792;HYVEDEMMXXX;DE21700202700023139792;1
70020270;23769426;HYVEDEMMXXX;DE26700202700023769426;1
70020270;24553632;HYVEDEMMXXX;DE12700202700024553632;1
70020270;24584005;HYVEDEMMXXX;DE76700202700024584005;1
70020270;24090086;HYVEDEMMXXX;DE38700202700024090086;1
70020270;24942954;HYVEDEMMXXX;DE14700202700024942954;1
70020270;24967905;HYVEDEMMXXX;DE02700202700024967905;1
70020270;25661275;HYVEDEMMXXX;DE12700202700025661275;1
70020270;25654575;HYVEDEMMXXX;DE07700202700025654575;1
70020270;25939795;HYVEDEMMXXX;DE91700202700025939795;1
70020270;25211396;HYVEDEMMXXX;DE17700202700025211396;1
70020270;396437940;HYVEDEMMXXX;DE29700202700396437940;1
70020270;396742573;HYVEDEMMXXX;DE53700202700396742573;1
70020270;396356565;HYVEDEMMXXX;DE07700202700396356565;1
70020270;396390021;HYVEDEMMXXX;DE56700202700396390021;1
70020270;396918492;HYVEDEMMXXX;DE39700202700396918492;1
70020270;397879074;HYVEDEMMXXX;DE88700202700397879074;1
70020270;397077250;HYVEDEMMXXX;DE03700202700397077250;1
70020270;397936503;HYVEDEMMXXX;DE50700202700397936503;1
70020270;397688024;HYVEDEMMXXX;DE75700202700397688024;1
70020270;398213792;HYVEDEMMXXX;DE95700202700398213792;1
70020270;398957592;HYVEDEMMXXX;DE84700202700398957592;1
70020270;398849885;HYVEDEMMXXX;DE16700202700398849885;1
70020270;398822726;HYVEDEMMXXX;DE86700202700398822726;1
70020270;398533573;HYVEDEMMXXX;DE75700202700398533573;1
70020270;399008512;HYVEDEMMXXX;DE25700202700399008512;1
70020270;399702586;HYVEDEMMXXX;DE39700202700399702586;1
70020270;399679726;HYVEDEMMXXX;DE48700202700399679726;1
70020270;399345025;HYVEDEMMXXX;DE67700202700399345025;1
70020270;399762773;HYVEDEMMXXX;DE31700202700399762773;1
70020270;449111764;HYVEDEMMXXX;DE23700202700449111764;1
70020270;462719890;HYVEDEMMXXX;DE34700202700462719890;1
70020270;443183760;HYVEDEMMXXX;DE20700202700443183760;1
70020270;406548747;HYVEDEMMXXX;DE93700202700406548747;1
70020270;414361746;HYVEDEMMXXX;DE64700202700414361746;1
70020270;756836327;HYVEDEMMXXX;DE49700202700756836327;1
70020270;729565316;HYVEDEMMXXX;DE46700202700729565316;1
70020270;727908402;HYVEDEMMXXX;DE33700202700727908402;1
70020270;750029611;HYVEDEMMXXX;DE40700202700750029611;1
70020270;744271249;HYVEDEMMXXX;DE43700202700744271249;1
70020270;912085916;HYVEDEMMXXX;DE37700202700912085916;1
70020270;915249092;HYVEDEMMXXX;DE69700202700915249092;1
70020270;916374502;HYVEDEMMXXX;DE25700202700916374502;1
70020270;913484712;HYVEDEMMXXX;DE77700202700913484712;1
70020270;913695528;HYVEDEMMXXX;DE05700202700913695528;1
70020270;921123066;HYVEDEMMXXX;DE02700202700921123066;1
70020270;926525880;HYVEDEMMXXX;DE93700202700926525880;1
70020270;924453819;HYVEDEMMXXX;DE20700202700924453819;1
70020270;928447190;HYVEDEMMXXX;DE32700202700928447190;1
70020270;928578495;HYVEDEMMXXX;DE50700202700928578495;1
70020270;939971101;HYVEDEMMXXX;DE74700202700939971101;1
70020270;938248245;HYVEDEMMXXX;DE60700202700938248245;1
70020270;937900824;HYVEDEMMXXX;DE42700202700937900824;1
70020270;934377381;HYVEDEMMXXX;DE59700202700934377381;1
70020270;933359511;HYVEDEMMXXX;DE24700202700933359511;1
70020270;941182727;HYVEDEMMXXX;DE04700202700941182727;1
70020270;945706022;HYVEDEMMXXX;DE53700202700945706022;1
70020270;945656231;HYVEDEMMXXX;DE87700202700945656231;1
70020270;941506860;HYVEDEMMXXX;DE44700202700941506860;1
70020270;941982396;HYVEDEMMXXX;DE74700202700941982396;1
70020270;959832313;HYVEDEMMXXX;DE16700202700959832313;1
70020270;954920111;HYVEDEMMXXX;DE12700202700954920111;1
70020270;959816664;HYVEDEMMXXX;DE07700202700959816664;1
70020270;954167897;HYVEDEMMXXX;DE27700202700954167897;1
70020270;955101420;HYVEDEMMXXX;DE65700202700955101420;1
70020270;964703549;HYVEDEMMXXX;DE11700202700964703549;1
70020270;963476559;HYVEDEMMXXX;DE40700202700963476559;1
70020270;963269811;HYVEDEMMXXX;DE80700202700963269811;1
70020270;960621009;HYVEDEMMXXX;DE22700202700960621009;1
70020270;967849374;HYVEDEMMXXX;DE10700202700967849374;1
70020270;975288522;HYVEDEMMXXX;DE41700202700975288522;1
70020270;972962350;HYVEDEMMXXX;DE58700202700972962350;1
70020270;971157209;HYVEDEMMXXX;DE51700202700971157209;1
70020270;975284630;HYVEDEMMXXX;DE74700202700975284630;1
70020270;970571596;HYVEDEMMXXX;DE20700202700970571596;1
70020270;982603484;HYVEDEMMXXX;DE95700202700982603484;1
70020270;988440451;HYVEDEMMXXX;DE20700202700988440451;1
70020270;986407419;HYVEDEMMXXX;DE69700202700986407419;1
70020270;983009290;HYVEDEMMXXX;DE65700202700983009290;1
70020270;5774659937;HYVEDEMMXXX;;-3
70020270;6819530171;HYVEDEMM489;DE81670201906819530171;19
70020270;9657031850;HYVEDEMMXXX;;-3
70020270;7666745048;HYVEDEMMXXX;;-3
70020270;6162655564;HYVEDEMM427;DE68734200716162655564;19
50050201;8025822880;HELADEF1822;DE56500502018025822880;1
50050201;5439435744;HELADEF1822;DE07500502015439435744;1
50050201;3783976957;HELADEF1822;DE74500502013783976957;1
50050201;4059299475;HELADEF1822;DE93500502014059299475;1
50050201;7833716461;HELADEF1822;DE32500502017833716461;1
50050201;7835985651;HELADEF1822;DE12500502017835985651;1
50050201;8347981170;HELADEF1822;DE48500502018347981170;1
50050201;3650246832;HELADEF1822;DE96500502013650246832;1
50050201;1717337214;HELADEF1822;DE49500502011717337214;1
50050201;1318945;HELADEF1822;DE22500502010001318945;1
50050201;1369132;HELADEF1822;DE63500502010001369132;1
50050201;1395753;HELADEF1822;DE66500502010001395753;1
50050201;1379572;HELADEF1822;DE65500502010001379572;1
50050201;1351469;HELADEF1822;DE15500502010001351469;1
50050201;1495987;HELADEF1822;DE48500502010001495987;1
50050201;1411198;HELADEF1822;DE54500502010001411198;1
50050201;1471463;HELADEF1822;DE74500502010001471463;1
50050201;1482530;HELADEF1822;DE25500502010001482530;1
50050201;1473873;HELADEF1822;DE91500502010001473873;1
50050201;1588919;HELADEF1822;DE80500502010001588919;1
50050201;1516033;HELADEF1822;DE66500502010001516033;1
50050201;1577338;HELADEF1822;DE39500502010001577338;1
50050201;1544211;HELADEF1822;DE31500502010001544211;1
50050201;1532813;HELADEF1822;DE93500502010001532813;1
50050201;1613083;HELADEF1822;DE74500502010001613083;1
50050201;1624405;HELADEF1822;DE27500502010001624405;1
50050201;1611053;HELADEF1822;DE79500502010001611053;1
50050201;1653215;HELADEF1822;DE97500502010001653215;1
50050201;1675613;HELADEF1822;DE49500502010001675613;1
50050201;1751019;HELADEF1822;DE20500502010001751019;1
50050201;1740071;HELADEF1822;DE57500502010001740071;1
50050201;1714325;HELADEF1822;DE97500502010001714325;1
50050201;1766447;HELADEF1822;DE79500502010001766447;1
50050201;1708702;HELADEF1822;DE16500502010001708702;1
50050201;1898669;HELADEF1822;DE73500502010001898669;1
50050201;1834792;HELADEF1822;DE92500502010001834792;1
50050201;1859317;HELADEF1822;DE39500502010001859317;1
50050201;1850415;HELADEF1822;DE27500502010001850415;1
50050201;1882027;HELADEF1822;DE06500502010001882027;1
50050201;1906779;HELADEF1822;DE32500502010001906779;1
50050201;1982820;HELADEF1822;DE27500502010001982820;1
50050201;1948570;HELADEF1822;DE76500502010001948570;1
50050201;1956465;HELADEF1822;DE20500502010001956465;1
50050201;1908052;HELADEF1822;DE96500502010001908052;1
50050201;2267332;HELADEF1822;DE21500502010002267332;1
50050201;2676315;HELADEF1822;DE57500502010002676315;1
50050201;2932821;HELADEF1822;DE98500502010002932821;1
50050201;2309569;HELADEF1822;DE51500502010002309569;1
50050201;2477999;HELADEF1822;DE92500502010002477999;1
50050201;3568850;HELADEF1822;DE98500502010003568850;1
50050201;3210582;HELADEF1822;DE09500502010003210582;1
50050201;3398735;HELADEF1822;DE59500502010003398735;1
50050201;3064324;HELADEF1822;DE08500502010003064324;1
50050201;3893508;HELADEF1822;DE28500502010003893508;1
50050201;4192858;HELADEF1822;DE06500502010004192858;1
50050201;4116794;HELADEF1822;DE50500502010004116794;1
50050201;4267819;HELADEF1822;DE61500502010004267819;1
50050201;4995564;HELADEF1822;DE42500502010004995564;1
50050201;4111840;HELADEF1822;DE45500502010004111840;1
50050201;5299188;HELADEF1822;DE52500502010005299188;1
50050201;5313099;HELADEF1822;DE39500502010005313099;1
50050201;5665087;HELADEF1822;DE35500502010005665087;1
50050201;5559434;HELADEF1822;DE90500502010005559434;1
50050201;5530845;HELADEF1822;DE67500502010005530845;1
50050201;6964990;HELADEF1822;DE67500502010006964990;1
50050201;6146363;HELADEF1822;DE91500502010006146363;1
50050201;6772640;HELADEF1822;DE40500502010006772640;1
50050201;6261095;HELADEF1822;DE22500502010006261095;1
50050201;6047927;HELADEF1822;DE63500502010006047927;1
50050201;7974440;HELADEF1822;DE74500502010007974440;1
50050201;7776517;HELADEF1822;DE71500502010007776517;1
50050201;7911385;HELADEF1822;DE15500502010007911385;1
50050201;7850363;HELADEF1822;DE64500502010007850363;1
50050201;7029154;HELADEF1822;DE59500502010007029154;1
50050201;8452290;HELADEF1822;DE94500502010008452290;1
50050201;8171107;HELADEF1822;DE39500502010008171107;1
50050201;8478088;HELADEF1822;DE08500502010008478088;1
50050201;8304651;HELADEF1822;DE35500502010008304651;1
50050201;8097474;HELADEF1822;DE18500502010008097474;1
50050201;9323453;HELADEF1822;DE29500502010009323453;1
50050201;9068220;HELADEF1822;DE52500502010009068220;1
50050201;9237256;HELADEF1822;DE27500502010009237256;1
50050201;9796318;HELADEF1822;DE08500502010009796318;1
50050201;9137876;HELADEF1822;DE73500502010009137876;1
50050201;10646723;HELADEF1822;DE40500502010010646723;1
50050201;10475856;HELADEF1822;DE32500502010010475856;1
50050201;10684459;HELADEF1822;DE56500502010010684459;1
50050201;10123519;HELADEF1822;DE50500502010010123519;1
50050201;10611016;HELADEF1822;DE46500502010010611016;1
50050201;20437680;HELADEF1822;DE47500502010020437680;1
50050201;20565494;HELADEF1822;DE38500502010020565494;1
50050201;20214684;HELADEF1822;DE52500502010020214684;1
50050201;20447836;HELADEF1822;DE54500502010020447836;1
50050201;20172819;HELADEF1822;DE66500502010020172819;1
50050201;30073719;HELADEF1822;DE06500502010030073719;1
50050201;30154895;HELADEF1822;DE66500502010030154895;1
50050201;30181045;HELADEF1822;DE79500502010030181045;1
50050201;30583898;HELADEF1822;DE46500502010030583898;1
50050201;30878422;HELADEF1822;DE55500502010030878422;1
50050201;40274492;HELADEF1822;DE62500502010040274492;1
50050201;40998039;HELADEF1822;DE93500502010040998039;1
50050201;40932772;HELADEF1822;DE06500502010040932772;1
50050201;40892865;HELADEF1822;DE19500502010040892865;1
50050201;40234959;HELADEF1822;DE65500502010040234959;1
50050201;50353838;HELADEF1822;DE47500502010050353838;1
50050201;50134791;HELADEF1822;DE32500502010050134791;1
50050201;50573323;HELADEF1822;DE70500502010050573323;1
50050201;50145203;HELADEF1822;DE14500502010050145203;1
50050201;50859289;HELADEF1822;DE91500502010050859289;1
50050201;60231388;HELADEF1822;DE34500502010060231388;1
50050201;60022278;HELADEF1822;DE22500502010060022278;1
50050201;60686735;HELADEF1822;DE27500502010060686735;1
50050201;60190097;HELADEF1822;DE70500502010060190097;1
50050201;60132406;HELADEF1822;DE04500502010060132406;1
50050201;70938194;HELADEF1822;DE37500502010070938194;1
50050201;70317994;HELADEF1822;DE36500502010070317994;1
50050201;70203967;HELADEF1822;DE82500502010070203967;1
50050201;70411739;HELADEF1822;DE39500502010070411739;1
50050201;70737679;HELADEF1822;DE81500502010070737679;1
50050201;80049832;HELADEF1822;DE24500502010080049832;1
50050201;80901673;HELADEF1822;DE84500502010080901673;1
50050201;80858502;HELADEF1822;DE52500502010080858502;1
50050201;80585297;HELADEF1822;DE28500502010080585297;1
50050201;80076453;HELADEF1822;DE27500502010080076453;1
50050201;90404211;HELADEF1822;DE50500502010090404211;1
50050201;90452312;HELADEF1822;DE56500502010090452312;1
50050201;90562827;HELADEF1822;DE65500502010090562827;1
50050201;90762200;HELADEF1822;DE09500502010090762200;1
50050201;91877380;HELADEF1822;DE16500502010091877380;1
50050201;91439938;HELADEF1822;DE36500502010091439938;1
50050201;91849270;HELADEF1822;DE58500502010091849270;1
50050201;91021169;HELADEF1822;DE91500502010091021169;1
50050201;91181660;HELADEF1822;DE18500502010091181660;1
50050201;92835747;HELADEF1822;DE21500502010092835747;1
50050201;92759163;HELADEF1822;DE40500502010092759163;1
50050201;92702179;HELADEF1822;DE91500502010092702179;1
50050201;92320041;HELADEF1822;DE24500502010092320041;1
50050201;92305956;HELADEF1822;DE79500502010092305956;1
50050201;93843825;HELADEF1822;DE18500502010093843825;1
50050201;93833392;HELADEF1822;DE21500502010093833392;1
50050201;93567763;HELADEF1822;DE18500502010093567763;1
50050201;93008583;HELADEF1822;DE22500502010093008583;1
50050201;93686431;HELADEF1822;DE86500502010093686431;1
50050201;94004539;HELADEF1822;DE35500502010094004539;1
50050201;94001538;HELADEF1822;DE67500502010094001538;1
50050201;94098424;HELADEF1822;DE41500502010094098424;1
50050201;94409164;HELADEF1822;DE76500502010094409164;1
50050201;94289479;HELADEF1822;DE16500502010094289479;1
50050201;95818845;HELADEF1822;DE34500502010095818845;1
50050201;95229094;HELADEF1822;DE82500502010095229094;1
50050201;95163165;HELADEF1822;DE21500502010095163165;1
50050201;95889786;HELADEF1822;DE86500502010095889786;1
50050201;95542391;HELADEF1822;DE45500502010095542391;1
50050201;96263635;HELADEF1822;DE80500502010096263635;1
50050201;96977772;HELADEF1822;DE41500502010096977772;1
50050201;96539128;HELADEF1822;DE20500502010096539128;1
50050201;96117055;HELADEF1822;DE43500502010096117055;1
50050201;96230034;HELADEF1822;DE66500502010096230034;1
50050201;97125276;HELADEF1822;DE59500502010097125276;1
50050201;97236078;HELADEF1822;DE79500502010097236078;1
50050201;97189433;HELADEF1822;DE46500502010097189433;1
50050201;97494019;HELADEF1822;DE78500502010097494019;1
50050201;97681144;HELADEF1822;DE45500502010097681144;1
50050201;98795544;HELADEF1822;DE63500502010098795544;1
50050201;98090731;HELADEF1822;DE69500502010098090731;1
50050201;98659019;HELADEF1822;DE44500502010098659019;1
50050201;98838726;HELADEF1822;DE89500502010098838726;1
50050201;98234363;HELADEF1822;DE65500502010098234363;1
50050201;99954591;HELADEF1822;DE31500502010099954591;1
50050201;99438208;HELADEF1822;DE77500502010099438208;1
50050201;99511886;HELADEF1822;DE47500502010099511886;1
50050201;99549662;HELADEF1822;DE50500502010099549662;1
50050201;99695049;HELADEF1822;DE94500502010099695049;1
50050201;99149504;HELADEF1822;DE68500502010099149504;1
50050201;99179137;HELADEF1822;DE33500502010099179137;1
50050201;99194329;HELADEF1822;DE62500502010099194329;1
50050201;99128789;HELADEF1822;DE71500502010099128789;1
50050201;99137550;HELADEF1822;DE10500502010099137550;1
50050201;99298495;HELADEF1822;DE95500502010099298495;1
50050201;99258286;HELADEF1822;DE17500502010099258286;1
50050201;99268810;HELADEF1822;DE79500502010099268810;1
50050201;99293728;HELADEF1822;DE85500502010099293728;1
50050201;99236594;HELADEF1822;DE15500502010099236594;1
50050201;99336334;HELADEF1822;DE46500502010099336334;1
50050201;99391632;HELADEF1822;DE24500502010099391632;1
50050201;99389841;HELADEF1822;DE75500502010099389841;1
50050201;99367962;HELADEF1822;DE78500502010099367962;1
50050201;99316980;HELADEF1822;DE65500502010099316980;1
74290100;7386307323;CBSRDE71XXX;DE80742901007386307323;1
74290100;9263782884;CBSRDE71XXX;DE63742901009263782884;1
74290100;5448922638;CBSRDE71XXX;DE53742901005448922638;1
74290100;5824664479;CBSRDE71XXX;DE41742901005824664479;1
74290100;6849089861;CBSRDE71XXX;DE28742901006849089861;1
74290100;8622808692;CBSRDE71XXX;DE38742901008622808692;1
74290100;2178763828;CBSRDE71XXX;DE93742901002178763828;1
74290100;1964615468;CBSRDE71XXX;DE34742901001964615468;1
74290100;9064154819;CBSRDE71XXX;DE43742901009064154819;1
10020890;3081323398;HYVEDEMMXXX;DE10700202703081323398;19
16020086;4968206325;HYVEDEMM470;;-3
17020086;5008492370;HYVEDEMM471;;-3
18020086;1401368856;HYVEDEMM455;DE49790200761401368856;19
20730023;2056889470;HYVEDEMME23;DE34207300232056889470;1
30220190;396812711;HYVEDEMM414;DE96302201900396812711;1
33020190;396344126;HYVEDEMM809;DE14330201900396344126;1
36020186;396445411;HYVEDEMM360;DE19360201860396445411;1
37020090;396130180;HYVEDEMM429;DE98370200900396130180;1
38020090;396490945;HYVEDEMM402;DE61380200900396490945;1
44020090;397820205;HYVEDEMM808;DE85440200900397820205;1
48020086;397310813;HYVEDEMM344;DE90480200860397310813;1
50320191;397010302;HYVEDEMM430;DE11503201910397010302;1
50520190;397798326;HYVEDEMM467;DE79505201900397798326;1
50820292;397875499;HYVEDEMM487;DE87508202920397875499;1
51020186;398528030;HYVEDEMM478;DE25510201860398528030;1
54020090;398598879;HYVEDEMM482;DE96540200900398598879;1
54220091;398802332;HYVEDEMM485;DE05542200910398802332;1
54520194;398523444;HYVEDEMM483;DE25545201940398523444;1
54620093;398526911;HYVEDEMM620;DE24546200930398526911;1
55020486;399472785;HYVEDEMM486;DE42550204860399472785;1
56020086;399878131;HYVEDEMM515;DE56560200860399878131;1
57020086;399613831;HYVEDEMM401;DE35570200860399613831;1
58520086;399989233;HYVEDEMM437;DE13585200860399989233;1
59020090;490701036;HYVEDEMM432;DE80590200900490701036;1
59320087;469984851;HYVEDEMM838;DE91593200870469984851;1
60020290;491578665;HYVEDEMM473;DE24600202900491578665;1
60320291;451463699;HYVEDEMM858;DE48603202910451463699;1
60420186;410041901;HYVEDEMM860;DE88604201860410041901;1
21051275;7589087936;NOLADE21BOR;DE35210512757589087936;1
21452030;2494461318;NOLADE21HWS;DE87214520302494461318;1
21852310;4333625954;NOLADE21WEB;DE36218523104333625954;1
22150000;8208280720;NOLADE21ELH;DE90221500008208280720;1
22250020;7942709820;NOLADE21WHO;DE51222500207942709820;1
23051030;6927614527;NOLADE21SHO;DE78230510306927614527;1
23052750;8663132955;NOLADE21RZB;DE38230527508663132955;1
51050015;1345083266;NASSDE55XXX;DE43510500151345083266;1
21051275;8316803033;NOLADE21BOR;DE97210512758316803033;1
21051275;5386923002;NOLADE21BOR;DE85210512755386923002;1
25050180;5834186982;SPKHDE2HXXX;DE35250501805834186982;1
25050299;6133744646;SPKHDE2HXXX;DE17250501806133744646;19
60030000;6557519813;MEBEDE6SDCB;DE52600300006557519813;1
25050180;9403799217;SPKHDE2HXXX;DE72250501809403799217;1
25050180;8888641076;SPKHDE2HXXX;DE81250501808888641076;1
25050299;9346832266;SPKHDE2HXXX;DE89250501809346832266;19
60030000;4705807693;MEBEDE6SDCB;DE61600300004705807693;1
25050180;8768666080;SPKHDE2HXXX;DE79250501808768666080;1
25050180;2355440840;SPKHDE2HXXX;DE15250501802355440840;1
25050299;7458565110;SPKHDE2HXXX;DE12250501807458565110;19
10090603;6107067321;DAAEDEDDXXX;DE20300606016107067321;19
12090640;2002195275;DAAEDEDDXXX;DE12300606012002195275;19
20090602;9205029503;DAAEDEDDXXX;DE93300606019205029503;19
21090619;7406648533;DAAEDEDDXXX;DE93300606017406648533;19
23092620;3303796043;DAAEDEDDXXX;DE41300606013303796043;19
25090608;7714817729;DAAEDEDDXXX;DE39300606017714817729;19
26560625;2711842994;DAAEDEDDXXX;DE72300606012711842994;19
27090618;8917889364;DAAEDEDDXXX;DE64300606018917889364;19
28090633;3313646777;DAAEDEDDXXX;DE52300606013313646777;19
29090605;4314181468;DAAEDEDDXXX;DE54300606014314181468;19
30060601;3723485820;DAAEDEDDXXX;DE64300606013723485820;1
33060616;9820553620;DAAEDEDDXXX;DE69300606019820553620;19
35060632;5422366800;DAAEDEDDXXX;DE16300606015422366800;19
36060610;6328596263;DAAEDEDDXXX;DE98300606016328596263;19
37060615;8527418752;DAAEDEDDXXX;DE76300606018527418752;19
39060630;4338303649;DAAEDEDDXXX;DE04300606014338303649;19
40060614;7736682723;DAAEDEDDXXX;DE05300606017736682723;19
44060604;2938787654;DAAEDEDDXXX;DE63300606012938787654;19
50090607;7031075144;DAAEDEDDXXX;DE37300606017031075144;19
50890634;3634719174;DAAEDEDDXXX;DE32300606013634719174;19
51090636;4647164289;DAAEDEDDXXX;DE67300606014647164289;19
52090611;9349033580;DAAEDEDDXXX;DE87300606019349033580;19
53390635;2347744587;DAAEDEDDXXX;DE98300606012347744587;19
54690623;4448380112;DAAEDEDDXXX;DE80300606014448380112;19
55060831;1641855948;DAAEDEDDXXX;DE52300606011641855948;19
57060612;2855263735;DAAEDEDDXXX;DE54300606012855263735;19
59090626;4354879406;DAAEDEDDXXX;DE52300606014354879406;19
60090609;4951095315;DAAEDEDDXXX;DE91300606014951095315;19
66090621;2452735962;DAAEDEDDXXX;DE64300606012452735962;19
67090617;6854898850;DAAEDEDDXXX;DE61300606016854898850;19
68090622;3565180015;DAAEDEDDXXX;DE08300606013565180015;19
70090606;1063556620;DAAEDEDDXXX;DE56300606011063556620;19
75090629;5864909461;DAAEDEDDXXX;DE35300606015864909461;19
76090613;8662256339;DAAEDEDDXXX;DE91300606018662256339;19
77390628;9261326767;DAAEDEDDXXX;DE49300606019261326767;19
79090624;2272454726;DAAEDEDDXXX;DE61300606012272454726;19
10090603;2071027492;DAAEDEDDXXX;DE04300606012071027492;19
10090603;1777484631;DAAEDEDDXXX;DE69300606011777484631;19
12090640;1172584107;DAAEDEDDXXX;DE36300606011172584107;19
20090602;7172686759;DAAEDEDDXXX;DE34300606017172686759;19
21090619;5382055910;DAAEDEDDXXX;DE17300606015382055910;19
23092620;3386347835;DAAEDEDDXXX;DE55300606013386347835;19
25090608;8282811928;DAAEDEDDXXX;DE32300606018282811928;19
26560625;8486920209;DAAEDEDDXXX;DE10300606018486920209;19
27090618;8685257565;DAAEDEDDXXX;DE80300606018685257565;19
28090633;9120649864;DAAEDEDDXXX;DE94300606019120649864;19
29090605;7040717711;DAAEDEDDXXX;DE86300606017040717711;19
30060601;8590904660;DAAEDEDDXXX;DE55300606018590904660;1
33060616;3610774782;DAAEDEDDXXX;DE18300606013610774782;19
35060632;3461380257;DAAEDEDDXXX;DE22300606013461380257;19
36060610;4861415549;DAAEDEDDXXX;DE03300606014861415549;19
37060615;5381370553;DAAEDEDDXXX;DE63300606015381370553;19
39060630;5671983377;DAAEDEDDXXX;DE28300606015671983377;19
40060614;5201075110;DAAEDEDDXXX;DE14300606015201075110;19
44060604;4602158930;DAAEDEDDXXX;DE55300606014602158930;19
50090607;1692660024;DAAEDEDDXXX;DE77300606011692660024;19
50890634;1112005395;DAAEDEDDXXX;DE08300606011112005395;19
51090636;6862812630;DAAEDEDDXXX;DE86300606016862812630;19
52090611;7963739449;DAAEDEDDXXX;DE32300606017963739449;19
53390635;8473403319;DAAEDEDDXXX;DE39300606018473403319;19
54690623;9493148165;DAAEDEDDXXX;DE85300606019493148165;19
55060831;3083034755;DAAEDEDDXXX;DE71300606013083034755;19
57060612;3683055701;DAAEDEDDXXX;DE12300606013683055701;19
59090626;3924132270;DAAEDEDDXXX;DE85300606013924132270;19
60090609;6134521595;DAAEDEDDXXX;DE86300606016134521595;19
66090621;9824987802;DAAEDEDDXXX;DE84300606019824987802;19
67090617;2914899148;DAAEDEDDXXX;DE59300606012914899148;19
68090622;2944484207;DAAEDEDDXXX;DE18300606012944484207;19
70090606;5815002362;DAAEDEDDXXX;DE09300606015815002362;19
75090629;1605519497;DAAEDEDDXXX;DE39300606011605519497;19
76090613;7475803799;DAAEDEDDXXX;DE02300606017475803799;19
77390628;4125605598;DAAEDEDDXXX;DE17300606014125605598;19
79090624;1635618720;DAAEDEDDXXX;DE16300606011635618720;19
10090603;1426243533;DAAEDEDDXXX;DE38300606011426243533;19
10090603;6016246478;DAAEDEDDXXX;DE65300606016016246478;19
12090640;5996310761;DAAEDEDDXXX;DE75300606015996310761;19
20090602;4316772897;DAAEDEDDXXX;DE93300606014316772897;19
21090619;6946498957;DAAEDEDDXXX;DE61300606016946498957;19
23092620;4147231512;DAAEDEDDXXX;DE84300606014147231512;19
25090608;9767195990;DAAEDEDDXXX;DE51300606019767195990;19
26560625;3737145659;DAAEDEDDXXX;DE42300606013737145659;19
27090618;2007607423;DAAEDEDDXXX;DE91300606012007607423;19
28090633;5067009763;DAAEDEDDXXX;DE57300606015067009763;19
29090605;8048894337;DAAEDEDDXXX;DE35300606018048894337;19
30060601;3828457859;DAAEDEDDXXX;DE48300606013828457859;1
33060616;7388342628;DAAEDEDDXXX;DE05300606017388342628;19
35060632;1228522391;DAAEDEDDXXX;DE18300606011228522391;19
36060610;5848240221;DAAEDEDDXXX;DE88300606015848240221;19
37060615;2914158286;DAAEDEDDXXX;DE90300606012914158286;19
39060630;6019337780;DAAEDEDDXXX;DE16300606016019337780;19
40060614;8612346682;DAAEDEDDXXX;DE67300606018612346682;19
44060604;4011526076;DAAEDEDDXXX;DE90300606014011526076;19
50090607;1415654994;DAAEDEDDXXX;DE66300606011415654994;19
50890634;2827911425;DAAEDEDDXXX;DE14300606012827911425;19
51090636;7228035360;DAAEDEDDXXX;DE71300606017228035360;19
52090611;1526501515;DAAEDEDDXXX;DE41300606011526501515;19
53390635;5928917623;DAAEDEDDXXX;DE46300606015928917623;19
54690623;7127195761;DAAEDEDDXXX;DE09300606017127195761;19
55060831;7930521624;DAAEDEDDXXX;DE04300606017930521624;19
57060612;1238748670;DAAEDEDDXXX;DE15300606011238748670;19
59090626;3232439501;DAAEDEDDXXX;DE65300606013232439501;19
60090609;5830296935;DAAEDEDDXXX;DE79300606015830296935;19
66090621;3937715614;DAAEDEDDXXX;DE07300606013937715614;19
67090617;1146412141;DAAEDEDDXXX;DE58300606011146412141;19
68090622;4541602590;DAAEDEDDXXX;DE02300606014541602590;19
70090606;1646879286;DAAEDEDDXXX;DE79300606011646879286;19
75090629;9746457321;DAAEDEDDXXX;DE71300606019746457321;19
76090613;4843537886;DAAEDEDDXXX;DE72300606014843537886;19
77390628;8058479572;DAAEDEDDXXX;DE25300606018058479572;19
79090624;5950657315;DAAEDEDDXXX;DE97300606015950657315;19
10090603;4552345810;DAAEDEDDXXX;DE19300606014552345810;19
10090603;4851036904;DAAEDEDDXXX;DE21300606014851036904;19
12090640;7859466560;DAAEDEDDXXX;DE71300606017859466560;19
20090602;5964829615;DAAEDEDDXXX;DE96300606015964829615;19
21090619;5567962335;DAAEDEDDXXX;DE92300606015567962335;19
23092620;2960639581;DAAEDEDDXXX;DE49300606012960639581;19
25090608;1568804262;DAAEDEDDXXX;DE96300606011568804262;19
26560625;8767245766;DAAEDEDDXXX;DE79300606018767245766;19
27090618;2871224341;DAAEDEDDXXX;DE63300606012871224341;19
28090633;1278223740;DAAEDEDDXXX;DE07300606011278223740;19
29090605;4475468864;DAAEDEDDXXX;DE72300606014475468864;19
30060601;4179863392;DAAEDEDDXXX;DE24300606014179863392;1
33060616;2179012836;DAAEDEDDXXX;DE85300606012179012836;19
35060632;8989215005;DAAEDEDDXXX;DE70300606018989215005;19
36060610;3483497055;DAAEDEDDXXX;DE10300606013483497055;19
37060615;6987392270;DAAEDEDDXXX;DE85300606016987392270;19
39060630;5388761241;DAAEDEDDXXX;DE81300606015388761241;19
40060614;3987319275;DAAEDEDDXXX;DE45300606013987319275;19
44060604;7321229075;DAAEDEDDXXX;DE12300606017321229075;19
50090607;8261502670;DAAEDEDDXXX;DE27300606018261502670;19
50890634;1481540954;DAAEDEDDXXX;DE73300606011481540954;19
51090636;6281837031;DAAEDEDDXXX;DE33300606016281837031;19
52090611;8091864685;DAAEDEDDXXX;DE82300606018091864685;19
53390635;5202073192;DAAEDEDDXXX;DE49300606015202073192;19
54690623;9522696201;DAAEDEDDXXX;DE80300606019522696201;19
55060831;7332298996;DAAEDEDDXXX;DE88300606017332298996;19
57060612;1312606371;DAAEDEDDXXX;DE98300606011312606371;19
59090626;4382843302;DAAEDEDDXXX;DE65300606014382843302;19
60090609;3613150414;DAAEDEDDXXX;DE77300606013613150414;19
66090621;5793222462;DAAEDEDDXXX;DE47300606015793222462;19
67090617;5453518212;DAAEDEDDXXX;DE56300606015453518212;19
68090622;5173160970;DAAEDEDDXXX;DE39300606015173160970;19
70090606;2934127373;DAAEDEDDXXX;DE26300606012934127373;19
75090629;7474485240;DAAEDEDDXXX;DE58300606017474485240;19
76090613;4994982796;DAAEDEDDXXX;DE95300606014994982796;19
77390628;6234765022;DAAEDEDDXXX;DE30300606016234765022;19
79090624;2574667051;DAAEDEDDXXX;DE18300606012574667051;19
10090603;7725127624;DAAEDEDDXXX;DE79300606017725127624;19
10090603;6575455836;DAAEDEDDXXX;DE60300606016575455836;19
12090640;8015242845;DAAEDEDDXXX;DE49300606018015242845;19
20090602;7105565840;DAAEDEDDXXX;DE73300606017105565840;19
21090619;3845026995;DAAEDEDDXXX;DE92300606013845026995;19
23092620;5286469426;DAAEDEDDXXX;DE26300606015286469426;19
25090608;7396134791;DAAEDEDDXXX;DE45300606017396134791;19
26560625;7966523871;DAAEDEDDXXX;DE03300606017966523871;19
27090618;6916526993;DAAEDEDDXXX;DE25300606016916526993;19
28090633;6826375751;DAAEDEDDXXX;DE91300606016826375751;19
29090605;4377850782;DAAEDEDDXXX;DE18300606014377850782;19
30060601;3667237732;DAAEDEDDXXX;DE92300606013667237732;1
33060616;6897774543;DAAEDEDDXXX;DE37300606016897774543;19
35060632;8747356316;DAAEDEDDXXX;DE46300606018747356316;19
36060610;2797058150;DAAEDEDDXXX;DE14300606012797058150;19
37060615;5588740295;DAAEDEDDXXX;DE07300606015588740295;19
39060630;2448413392;DAAEDEDDXXX;DE24300606012448413392;19
40060614;6668952484;DAAEDEDDXXX;DE44300606016668952484;19
44060604;2038337934;DAAEDEDDXXX;DE35300606012038337934;19
50090607;8278052524;DAAEDEDDXXX;DE86300606018278052524;19
50890634;6899993956;DAAEDEDDXXX;DE61300606016899993956;19
51090636;1699976563;DAAEDEDDXXX;DE38300606011699976563;19
52090611;3099961701;DAAEDEDDXXX;DE57300606013099961701;19
53390635;1399275883;DAAEDEDDXXX;DE65300606011399275883;19
54690623;4099369241;DAAEDEDDXXX;DE65300606014099369241;19
55060831;870048;DAAEDEDDXXX;DE65300606010000870048;19
57060612;589845;DAAEDEDDXXX;DE31300606010000589845;19
59090626;753963;DAAEDEDDXXX;DE96300606010000753963;19
60090609;256846;DAAEDEDDXXX;DE74300606010000256846;19
66090621;554014;DAAEDEDDXXX;DE87300606010000554014;19
67090617;6273649694;DAAEDEDDXXX;DE79300606016273649694;19
68090622;5748483298;DAAEDEDDXXX;DE82300606015748483298;19
70090606;9029771917;DAAEDEDDXXX;DE35300606019029771917;19
75090629;6159274857;DAAEDEDDXXX;DE63300606016159274857;19
76090613;9692156195;DAAEDEDDXXX;DE14300606019692156195;19
77390628;3845569706;DAAEDEDDXXX;DE06300606013845569706;19
79090624;8895863946;DAAEDEDDXXX;DE11300606018895863946;19
10090603;8559926982;DAAEDEDDXXX;DE20300606018559926982;19
76450000;4261496998;BYLADEM1SRS;DE85764500004261496998;1
76450000;5910575470;BYLADEM1SRS;DE15764500005910575470;1
76450000;8328308385;BYLADEM1SRS;DE98764500008328308385;1
76450000;1101436721;BYLADEM1SRS;DE85764500001101436721;1
76450000;6556497417;BYLADEM1SRS;DE25764500006556497417;1
76450000;437805158;BYLADEM1SRS;DE50764500000437805158;1
76450000;818681519;BYLADEM1SRS;DE10764500000818681519;1
76450000;704384469;BYLADEM1SRS;DE86764500000704384469;1
76450000;331141981;BYLADEM1SRS;DE79764500000331141981;1
76450000;667001859;BYLADEM1SRS;DE63764500000667001859;1
76450000;1181380553;BYLADEM1SRS;DE03764500001181380553;1
76450000;1296261697;BYLADEM1SRS;DE37764500001296261697;1
76450000;1862472947;BYLADEM1SRS;DE08764500001862472947;1
76450000;1774562383;BYLADEM1SRS;DE86764500001774562383;1
76450000;1379726654;BYLADEM1SRS;DE56764500001379726654;1
76450000;2224396791;BYLADEM1SRS;DE53764500002224396791;1
76450000;2181746141;BYLADEM1SRS;DE93764500002181746141;1
76450000;2005157813;BYLADEM1SRS;DE08764500002005157813;1
76450000;2056679078;BYLADEM1SRS;DE40764500002056679078;1
76450000;2651582565;BYLADEM1SRS;DE15764500002651582565;1
76450000;3536721729;BYLADEM1SRS;DE58764500003536721729;1
76450000;3093701635;BYLADEM1SRS;DE12764500003093701635;1
76450000;3460287799;BYLADEM1SRS;DE40764500003460287799;1
76450000;3879051992;BYLADEM1SRS;DE42764500003879051992;1
76450000;3044424143;BYLADEM1SRS;DE41764500003044424143;1
76450000;4967214100;BYLADEM1SRS;DE74764500004967214100;1
76450000;4724437600;BYLADEM1SRS;DE66764500004724437600;1
76450000;4665689938;BYLADEM1SRS;DE66764500004665689938;1
76450000;4066251145;BYLADEM1SRS;DE68764500004066251145;1
76450000;5685347286;BYLADEM1SRS;DE26764500005685347286;1
76450000;5908794120;BYLADEM1SRS;DE82764500005908794120;1
76450000;5333858551;BYLADEM1SRS;DE81764500005333858551;1
76450000;5443212672;BYLADEM1SRS;DE86764500005443212672;1
76450000;5508811958;BYLADEM1SRS;DE79764500005508811958;1
76450000;6910511115;BYLADEM1SRS;DE91764500006910511115;1
76450000;6419909465;BYLADEM1SRS;DE10764500006419909465;1
76450000;6848120774;BYLADEM1SRS;DE50764500006848120774;1
76450000;6242203316;BYLADEM1SRS;DE27764500006242203316;1
76450000;6839523004;BYLADEM1SRS;DE22764500006839523004;1
76450000;7046989931;BYLADEM1SRS;DE15764500007046989931;1
76450000;7562233853;BYLADEM1SRS;DE85764500007562233853;1
76450000;7880577513;BYLADEM1SRS;DE02764500007880577513;1
76450000;7012938366;BYLADEM1SRS;DE80764500007012938366;1
76450000;7175975252;BYLADEM1SRS;DE55764500007175975252;1
76450000;8240346812;BYLADEM1SRS;DE19764500008240346812;1
76450000;8653528792;BYLADEM1SRS;DE08764500008653528792;1
76450000;8307716993;BYLADEM1SRS;DE57764500008307716993;1
76450000;8319611172;BYLADEM1SRS;DE71764500008319611172;1
53250000;5820580867;HELADEF1HER;DE26532500005820580867;1
53250000;5800824517;HELADEF1HER;DE46532500005800824517;1
53250000;2834934248;HELADEF1HER;DE64532500002834934248;1
53250000;7814551151;HELADEF1HER;DE87532500007814551151;1
53250000;3868869417;HELADEF1HER;DE40532500003868869417;1
53250000;7071624494;HELADEF1HER;DE80532500007071624494;1
53250000;3092662123;HELADEF1HER;DE78532500003092662123;1
53250000;4071510570;HELADEF1HER;DE02532500004071510570;1
53250000;1066638240;HELADEF1HER;DE95532500001066638240;1
53250000;8198803166;HELADEF1HER;DE44532500008198803166;1
53250000;5111517731;HELADEF1HER;DE65532500005111517731;1
53250000;6141762603;HELADEF1HER;DE48532500006141762603;1
53250000;2113723856;HELADEF1HER;DE03532500002113723856;1
53250000;3168922405;HELADEF1HER;DE97532500003168922405;1
53250000;5222635069;HELADEF1HER;DE35532500005222635069;1
53250000;9220885226;HELADEF1HER;DE20532500009220885226;1
53250000;3262704684;HELADEF1HER;DE29532500003262704684;1
53250000;3226679614;HELADEF1HER;DE10532500003226679614;1
53250000;2271208660;HELADEF1HER;DE64532500002271208660;1
53250000;1371161213;HELADEF1HER;DE46532500001371161213;1
53250000;4396264941;HELADEF1HER;DE44532500004396264941;1
53250000;6303569833;HELADEF1HER;DE60532500006303569833;1
53250000;4390998086;HELADEF1HER;DE25532500004390998086;1
53250000;4365280437;HELADEF1HER;DE11532500004365280437;1
53250000;7447773711;HELADEF1HER;DE37532500007447773711;1
53250000;5444151596;HELADEF1HER;DE86532500005444151596;1
53250000;5409937944;HELADEF1HER;DE54532500005409937944;1
53250000;1424775013;HELADEF1HER;DE59532500001424775013;1
53250000;9484799220;HELADEF1HER;DE91532500009484799220;1
53250000;8576363369;HELADEF1HER;DE32532500008576363369;1
53250000;4536132826;HELADEF1HER;DE55532500004536132826;1
53250000;5583534012;HELADEF1HER;DE53532500005583534012;1
53250000;5552127357;HELADEF1HER;DE15532500005552127357;1
53250000;2619363466;HELADEF1HER;DE92532500002619363466;1
53250000;4669498949;HELADEF1HER;DE47532500004669498949;1
53250000;2640787640;HELADEF1HER;DE07532500002640787640;1
53250000;9699401822;HELADEF1HER;DE05532500009699401822;1
53250000;5767314443;HELADEF1HER;DE82532500005767314443;1
53250000;6708201222;HELADEF1HER;DE89532500006708201222;1
53250000;7785991334;HELADEF1HER;DE66532500007785991334;1
53250000;1732200885;HELADEF1HER;DE65532500001732200885;1
53250000;1963526792;HELADEF1HER;DE21532500001963526792;1
53250000;4985695347;HELADEF1HER;DE11532500004985695347;1
53250000;9932439788;HELADEF1HER;DE09532500009932439788;1
53250000;1971056577;HELADEF1HER;DE66532500001971056577;1
21352240;1864844095;NOLADE21HOL;DE74213522401864844095;1
21352240;4052175173;NOLADE21HOL;DE69213522404052175173;1
21352240;9958237050;NOLADE21HOL;DE86213522409958237050;1
21352240;8026505415;NOLADE21HOL;DE22213522408026505415;1
21352240;2927914834;NOLADE21HOL;DE57213522402927914834;1
21352240;4696804321;NOLADE21HOL;DE08213522404696804321;1
21352240;4561504006;NOLADE21HOL;DE49213522404561504006;1
21352240;2076169795;NOLADE21HOL;DE23213522402076169795;1
21352240;5953909359;NOLADE21HOL;DE74213522405953909359;1
21352240;1182940859;NOLADE21HOL;DE97213522401182940859;1
12096597;7809501312;GENODEF1S10;DE15120965977809501312;1
12096597;3304092678;GENODEF1S10;DE78120965973304092678;1
12096597;9007566239;GENODEF1S10;DE16120965979007566239;1
12096597;1000614440;GENODEF1S10;DE69120965971000614440;1
12096597;9709425608;GENODEF1S10;DE02120965979709425608;1
12096597;4317268564;GENODEF1S10;DE66120965974317268564;1
12096597;3218111111;GENODEF1S10;DE29120965973218111111;1
12096597;7918867151;GENODEF1S10;DE48120965977918867151;1
12096597;2315947820;GENODEF1S10;DE37120965972315947820;1
12096597;4011698680;GENODEF1S10;DE39120965974011698680;1
12096597;5224431537;GENODEF1S10;DE52120965975224431537;1
12096597;8025718490;GENODEF1S10;DE20120965978025718490;1
12096597;1523262499;GENODEF1S10;DE08120965971523262499;1
12096597;5720922749;GENODEF1S10;DE73120965975720922749;1
12096597;7123560961;GENODEF1S10;DE42120965977123560961;1
12096597;7431028650;GENODEF1S10;DE69120965977431028650;1
12096597;4538076014;GENODEF1S10;DE15120965974538076014;1
12096597;3136883206;GENODEF1S10;DE51120965973136883206;1
12096597;1031959840;GENODEF1S10;DE45120965971031959840;1
12096597;9435637490;GENODEF1S10;DE77120965979435637490;1
12096597;1841835408;GENODEF1S10;DE63120965971841835408;1
12096597;9745940923;GENODEF1S10;DE26120965979745940923;1
12096597;7946204236;GENODEF1S10;DE77120965977946204236;1
12096597;9947200714;GENODEF1S10;DE68120965979947200714;1
12096597;8442355949;GENODEF1S10;DE71120965978442355949;1
12096597;6252549352;GENODEF1S10;DE75120965976252549352;1
12096597;1958450668;GENODEF1S10;DE89120965971958450668;1
12096597;5257390149;GENODEF1S10;DE87120965975257390149;1
12096597;9057978952;GENODEF1S10;DE50120965979057978952;1
12096597;4265415241;GENODEF1S10;DE84120965974265415241;1
12096597;8865399033;GENODEF1S10;DE23120965978865399033;1
12096597;1069767851;GENODEF1S10;DE11120965971069767851;1
12096597;2967081553;GENODEF1S10;DE16120965972967081553;1
12096597;4166581145;GENODEF1S10;DE42120965974166581145;1
12096597;5570511480;GENODEF1S10;DE98120965975570511480;1
12096597;7776315232;GENODEF1S10;DE61120965977776315232;1
12096597;4472165902;GENODEF1S10;DE78120965974472165902;1
12096597;4773078167;GENODEF1S10;DE71120965974773078167;1
12096597;5877427115;GENODEF1S10;DE78120965975877427115;1
12096597;8483469018;GENODEF1S10;DE76120965978483469018;1
12096597;9280917281;GENODEF1S10;DE70120965979280917281;1
12096597;5787820186;GENODEF1S10;DE66120965975787820186;1
12096597;4282724219;GENODEF1S10;DE89120965974282724219;1
12096597;8887646364;GENODEF1S10;DE18120965978887646364;1
12096597;6901779016;GENODEF1S10;DE14120965976901779016;1
12096597;2501225986;GENODEF1S10;DE36120965972501225986;1
12096597;2205363411;GENODEF1S10;DE61120965972205363411;1
12096597;3806647895;GENODEF1S10;DE10120965973806647895;1
12096597;8904373619;GENODEF1S10;DE13120965978904373619;1
12096597;5716449201;GENODEF1S10;DE14120965975716449201;1
12096597;2012723310;GENODEF1S10;DE04120965972012723310;1
12096597;6813418910;GENODEF1S10;DE19120965976813418910;1
12096597;5711879428;GENODEF1S10;DE79120965975711879428;1
12096597;6717223167;GENODEF1S10;DE82120965976717223167;1
12096597;4420563981;GENODEF1S10;DE11120965974420563981;1
12096597;9023754371;GENODEF1S10;DE27120965979023754371;1
12096597;3523255833;GENODEF1S10;DE62120965973523255833;1
12096597;6624120796;GENODEF1S10;DE78120965976624120796;1
12096597;1725173968;GENODEF1S10;DE59120965971725173968;1
12096597;1039015751;GENODEF1S10;DE97120965971039015751;1
12096597;2838542078;GENODEF1S10;DE28120965972838542078;1
12096597;4132256188;GENODEF1S10;DE88120965974132256188;1
12096597;9136963185;GENODEF1S10;DE53120965979136963185;1
12096597;2332109981;GENODEF1S10;DE52120965972332109981;1
12096597;8145655667;GENODEF1S10;DE16120965978145655667;1
12096597;8043049541;GENODEF1S10;DE22120965978043049541;1
12096597;2041639681;GENODEF1S10;DE26120965972041639681;1
12096597;2245331657;GENODEF1S10;DE73120965972245331657;1
12096597;2246196026;GENODEF1S10;DE19120965972246196026;1
12096597;7155857339;GENODEF1S10;DE94120965977155857339;1
12096597;1551714849;GENODEF1S10;DE77120965971551714849;1
12096597;6752176626;GENODEF1S10;DE50120965976752176626;1
12096597;6950137372;GENODEF1S10;DE80120965976950137372;1
12096597;7655738737;GENODEF1S10;DE16120965977655738737;1
12096597;8562823722;GENODEF1S10;DE02120965978562823722;1
12096597;3963982899;GENODEF1S10;DE62120965973963982899;1
12096597;3768428625;GENODEF1S10;DE59120965973768428625;1
12096597;5967371578;GENODEF1S10;DE16120965975967371578;1
12096597;9473801206;GENODEF1S10;DE75120965979473801206;1
12096597;8671890425;GENODEF1S10;DE02120965978671890425;1
12096597;9773454766;GENODEF1S10;DE86120965979773454766;1
12096597;5779376302;GENODEF1S10;DE14120965975779376302;1
12096597;2572654010;GENODEF1S10;DE07120965972572654010;1
12096597;1587244312;GENODEF1S10;DE44120965971587244312;1
12096597;9588297780;GENODEF1S10;DE37120965979588297780;1
12096597;6287061658;GENODEF1S10;DE59120965976287061658;1
12096597;2184713822;GENODEF1S10;DE36120965972184713822;1
12096597;4686132765;GENODEF1S10;DE19120965974686132765;1
12096597;3491373883;GENODEF1S10;DE83120965973491373883;1
12096597;5691590108;GENODEF1S10;DE48120965975691590108;1
12096597;4198164066;GENODEF1S10;DE09120965974198164066;1
12096597;1995530134;GENODEF1S10;DE43120965971995530134;1
12096597;1598458400;GENODEF1S10;DE27120965971598458400;1
12096597;8394891004;GENODEF1S10;DE62120965978394891004;1
12096597;8399317420;GENODEF1S10;DE45120965978399317420;1
12096597;9696233264;GENODEF1S10;DE75120965979696233264;1
12096597;6493717027;GENODEF1S10;DE12120965976493717027;1
60651070;3414166317;PZHSDE66XXX;DE87666500853414166317;19
60651070;3765800306;PZHSDE66XXX;DE78666500853765800306;19
60651070;6272035111;PZHSDE66XXX;DE93666500856272035111;19
60651070;2728558469;PZHSDE66XXX;DE77666500852728558469;19
60651070;7838270810;PZHSDE66XXX;DE78666500857838270810;19
60651070;2101175793;PZHSDE66XXX;DE05666500852101175793;19
25950001;7152532720;NOLADE21HIS;DE30259500017152532720;1
25950130;6170473781;NOLADE21HIK;DE72259501306170473781;1
25950001;9516523687;NOLADE21HIS;DE09259500019516523687;1
25950001;2294883934;NOLADE21HIS;DE81259500012294883934;1
25950130;5528929383;NOLADE21HIK;DE60259501305528929383;1
25950001;6504376540;NOLADE21HIS;DE11259500016504376540;1
25950001;6241195060;NOLADE21HIS;DE71259500016241195060;1
25950130;7092282705;NOLADE21HIK;DE57259501307092282705;1
25950001;9123476402;NOLADE21HIS;DE46259500019123476402;1
25950001;9041282730;NOLADE21HIS;DE43259500019041282730;1
54051660;462556131;MALADE51LAS;DE16540516600462556131;1
56250030;145787303;BILADE55XXX;DE98562500300145787303;1
54051660;883126230;MALADE51LAS;DE31540516600883126230;1
54051660;465142052;MALADE51LAS;DE70540516600465142052;1
56250030;635471817;BILADE55XXX;DE12562500300635471817;1
54051660;1209807081;MALADE51LAS;DE05540516601209807081;1
54051660;1188979326;MALADE51LAS;DE38540516601188979326;1
56250030;1445267559;BILADE55XXX;DE89562500301445267559;1
54051660;1572090305;MALADE51LAS;DE88540516601572090305;1
54051660;1810811306;MALADE51LAS;DE22540516601810811306;1
56250030;2297462675;BILADE55XXX;DE10562500302297462675;1
54051660;2196457684;MALADE51LAS;DE12540516602196457684;1
54051660;2203996395;MALADE51LAS;DE03540516602203996395;1
56250030;2624573326;BILADE55XXX;DE76562500302624573326;1
54051660;3445524817;MALADE51LAS;DE78540516603445524817;1
54051660;3970419966;MALADE51LAS;DE50540516603970419966;1
56250030;3979570551;BILADE55XXX;DE73562500303979570551;1
54051660;3204656790;MALADE51LAS;DE27540516603204656790;1
54051660;3841288911;MALADE51LAS;DE23540516603841288911;1
56250030;4070982751;BILADE55XXX;DE74562500304070982751;1
54051660;4367653179;MALADE51LAS;DE89540516604367653179;1
54051660;4370529114;MALADE51LAS;DE90540516604370529114;1
56250030;4380855928;BILADE55XXX;DE21562500304380855928;1
54051660;4206626099;MALADE51LAS;DE62540516604206626099;1
54051660;5936744732;MALADE51LAS;DE32540516605936744732;1
56250030;5269778668;BILADE55XXX;DE32562500305269778668;1
54051660;5638114862;MALADE51LAS;DE56540516605638114862;1
54051660;5126028355;MALADE51LAS;DE74540516605126028355;1
56250030;5038984432;BILADE55XXX;DE86562500305038984432;1
54051660;6395598345;MALADE51LAS;DE61540516606395598345;1
54051660;6764056459;MALADE51LAS;DE65540516606764056459;1
56250030;6863956989;BILADE55XXX;DE91562500306863956989;1
54051660;6294464912;MALADE51LAS;DE81540516606294464912;1
54051660;6775196818;MALADE51LAS;DE97540516606775196818;1
56250030;7032542140;BILADE55XXX;DE25562500307032542140;1
54051660;7706646042;MALADE51LAS;DE36540516607706646042;1
54051660;7119173945;MALADE51LAS;DE38540516607119173945;1
56250030;7396742626;BILADE55XXX;DE24562500307396742626;1
54051660;8403133062;MALADE51LAS;DE33540516608403133062;1
54051660;8966234596;MALADE51LAS;DE09540516608966234596;1
56250030;8523141615;BILADE55XXX;DE04562500308523141615;1
54051660;8881977105;MALADE51LAS;DE14540516608881977105;1
54051660;8493939816;MALADE51LAS;DE54540516608493939816;1
56250030;9449375105;BILADE55XXX;DE64562500309449375105;1
54051660;9873046206;MALADE51LAS;DE02540516609873046206;1
54051660;9316061085;MALADE51LAS;DE54540516609316061085;1
56250030;9010587617;BILADE55XXX;DE12562500309010587617;1
66090800;332590425;GENODE61BBB;DE98660908000332590425;1
66090800;801619357;GENODE61BBB;DE02660908000801619357;1
66090800;283060616;GENODE61BBB;DE85660908000283060616;1
66090800;817081898;GENODE61BBB;DE74660908000817081898;1
66090800;496334237;GENODE61BBB;DE52660908000496334237;1
66090800;1018927847;GENODE61BBB;DE79660908001018927847;1
66090800;1503543277;GENODE61BBB;DE07660908001503543277;1
66090800;1228340919;GENODE61BBB;DE27660908001228340919;1
66090800;1320908169;GENODE61BBB;DE51660908001320908169;1
66090800;1220209066;GENODE61BBB;DE73660908001220209066;1
66090800;2693290670;GENODE61BBB;DE93660908002693290670;1
66090800;2014002040;GENODE61BBB;DE26660908002014002040;1
66090800;2443445780;GENODE61BBB;DE85660908002443445780;1
66090800;2858245630;GENODE61BBB;DE79660908002858245630;1
66090800;2358993610;GENODE61BBB;DE90660908002358993610;1
66090800;3871886673;GENODE61BBB;DE97660908003871886673;1
66090800;3557788665;GENODE61BBB;DE42660908003557788665;1
66090800;3357603355;GENODE61BBB;DE64660908003357603355;1
66090800;3371789236;GENODE61BBB;DE36660908003371789236;1
66090800;3340138711;GENODE61BBB;DE31660908003340138711;1
66090800;4347230745;GENODE61BBB;DE52660908004347230745;1
66090800;4394884876;GENODE61BBB;DE59660908004394884876;1
66090800;4286060587;GENODE61BBB;DE53660908004286060587;1
66090800;4168373345;GENODE61BBB;DE02660908004168373345;1
66090800;5819572589;GENODE61BBB;DE31660908005819572589;1
66090800;5988555605;GENODE61BBB;DE69660908005988555605;1
66090800;5131201220;GENODE61BBB;DE69660908005131201220;1
66090800;5475283906;GENODE61BBB;DE68660908005475283906;1
66090800;5494357604;GENODE61BBB;DE03660908005494357604;1
66090800;6214284941;GENODE61BBB;DE66660908006214284941;1
66090800;6192489040;GENODE61BBB;DE93660908006192489040;1
66090800;6744827929;GENODE61BBB;DE48660908006744827929;1
66090800;6610328960;GENODE61BBB;DE82660908006610328960;1
66090800;6547767390;GENODE61BBB;DE10660908006547767390;1
66090800;7833818101;GENODE61BBB;DE76660908007833818101;1
66090800;7994172329;GENODE61BBB;DE74660908007994172329;1
66090800;7865376190;GENODE61BBB;DE43660908007865376190;1
66090800;7410923885;GENODE61BBB;DE77660908007410923885;1
66090800;7225488672;GENODE61BBB;DE89660908007225488672;1
66090800;8858511276;GENODE61BBB;DE32660908008858511276;1
66090800;8600240990;GENODE61BBB;DE55660908008600240990;1
66090800;8465254671;GENODE61BBB;DE04660908008465254671;1
66090800;8249818189;GENODE61BBB;DE83660908008249818189;1
66090800;8205479398;GENODE61BBB;DE18660908008205479398;1
66090800;9107384941;GENODE61BBB;DE38660908009107384941;1
66090800;9480819290;GENODE61BBB;DE83660908009480819290;1
66090800;9574498470;GENODE61BBB;DE79660908009574498470;1
66090800;9226192155;GENODE61BBB;DE13660908009226192155;1
37050299;5196304068;COKSDE33XXX;DE12370502995196304068;1
37050299;6812143900;COKSDE33XXX;DE95370502996812143900;1
37050299;1259325124;COKSDE33XXX;DE54370502991259325124;1
37050299;9284665518;COKSDE33XXX;DE11370502999284665518;1
37050299;9871240304;COKSDE33XXX;DE07370502999871240304;1
37050299;996226007;COKSDE33XXX;DE38370502990996226007;1
37050299;884588401;COKSDE33XXX;DE55370502990884588401;1
37050299;686091372;COKSDE33XXX;DE88370502990686091372;1
37050299;883904872;COKSDE33XXX;DE21370502990883904872;1
37050299;635536436;COKSDE33XXX;DE39370502990635536436;1
37050299;1723878144;COKSDE33XXX;DE95370502991723878144;1
37050299;1895669016;COKSDE33XXX;DE20370502991895669016;1
37050299;1432885703;COKSDE33XXX;DE90370502991432885703;1
37050299;1203032238;COKSDE33XXX;DE38370502991203032238;1
37050299;1380516912;COKSDE33XXX;DE87370502991380516912;1
37050299;2926973542;COKSDE33XXX;DE77370502992926973542;1
37050299;2185906233;COKSDE33XXX;DE24370502992185906233;1
37050299;2453072502;COKSDE33XXX;DE54370502992453072502;1
37050299;2193025570;COKSDE33XXX;DE12370502992193025570;1
37050299;2477637181;COKSDE33XXX;DE48370502992477637181;1
37050299;3258935778;COKSDE33XXX;DE28370502993258935778;1
37050299;3861230617;COKSDE33XXX;DE38370502993861230617;1
37050299;3460491719;COKSDE33XXX;DE21370502993460491719;1
37050299;3771125105;COKSDE33XXX;DE10370502993771125105;1
37050299;3710795547;COKSDE33XXX;DE65370502993710795547;1
37050299;4536963814;COKSDE33XXX;DE67370502994536963814;1
37050299;4297352793;COKSDE33XXX;DE87370502994297352793;1
37050299;4762422352;COKSDE33XXX;DE41370502994762422352;1
37050299;4438228894;COKSDE33XXX;DE55370502994438228894;1
37050299;5680737987;COKSDE33XXX;DE06370502995680737987;1
37050299;5351370654;COKSDE33XXX;DE95370502995351370654;1
37050299;5042283308;COKSDE33XXX;DE06370502995042283308;1
37050299;5281302462;COKSDE33XXX;DE33370502995281302462;1
37050299;5335479928;COKSDE33XXX;DE73370502995335479928;1
37050299;6627353029;COKSDE33XXX;DE17370502996627353029;1
37050299;6230469659;COKSDE33XXX;DE77370502996230469659;1
37050299;6123494731;COKSDE33XXX;DE14370502996123494731;1
37050299;6271812114;COKSDE33XXX;DE13370502996271812114;1
37050299;7038116815;COKSDE33XXX;DE59370502997038116815;1
37050299;7847865669;COKSDE33XXX;DE68370502997847865669;1
37050299;7941728144;COKSDE33XXX;DE39370502997941728144;1
37050299;7915006386;COKSDE33XXX;DE50370502997915006386;1
37050299;7569759439;COKSDE33XXX;DE17370502997569759439;1
80053762;1178380331;NOLADE21HAL;DE84800537621178380331;1
80053762;1364652575;NOLADE21HAL;DE71800537621364652575;1
80053762;1680986500;NOLADE21HAL;DE63800537621680986500;1
80053762;1235792451;NOLADE21HAL;DE65800537621235792451;1
80053762;1453596760;NOLADE21HAL;DE96800537621453596760;1
80053762;2994784060;NOLADE21HAL;DE59800537622994784060;1
80053762;2405994634;NOLADE21HAL;DE81800537622405994634;1
80053762;2970087220;NOLADE21HAL;DE73800537622970087220;1
80053762;2895358012;NOLADE21HAL;DE31800537622895358012;1
80053762;2765212646;NOLADE21HAL;DE03800537622765212646;1
80053762;3913719295;NOLADE21HAL;DE26800537623913719295;1
80053762;3921327465;NOLADE21HAL;DE22800537623921327465;1
80053762;3541109660;NOLADE21HAL;DE23800537623541109660;1
80053762;3774212154;NOLADE21HAL;DE85800537623774212154;1
80053762;3833352867;NOLADE21HAL;DE90800537623833352867;1
80053762;4299205001;NOLADE21HAL;DE29800537624299205001;1
80053762;4835979600;NOLADE21HAL;DE95800537624835979600;1
80053762;4434514321;NOLADE21HAL;DE32800537624434514321;1
80053762;4936026145;NOLADE21HAL;DE59800537624936026145;1
80053762;4153542143;NOLADE21HAL;DE88800537624153542143;1
80053762;5660401351;NOLADE21HAL;DE61800537625660401351;1
80053762;5482658041;NOLADE21HAL;DE57800537625482658041;1
80053762;5757785332;NOLADE21HAL;DE31800537625757785332;1
80053762;5482738053;NOLADE21HAL;DE20800537625482738053;1
80053762;5721208157;NOLADE21HAL;DE81800537625721208157;1
80053762;6798802395;NOLADE21HAL;DE22800537626798802395;1
80053762;6482799491;NOLADE21HAL;DE43800537626482799491;1
80053762;6123317910;NOLADE21HAL;DE79800537626123317910;1
80053762;6823999380;NOLADE21HAL;DE45800537626823999380;1
80053762;6055122373;NOLADE21HAL;DE67800537626055122373;1
80053762;7208130900;NOLADE21HAL;DE84800537627208130900;1
80053762;7438776314;NOLADE21HAL;DE96800537627438776314;1
80053762;7144018536;NOLADE21HAL;DE42800537627144018536;1
80053762;7910152781;NOLADE21HAL;DE41800537627910152781;1
80053762;7413449581;NOLADE21HAL;DE17800537627413449581;1
80053762;8383530006;NOLADE21HAL;DE81800537628383530006;1
80053762;8307638527;NOLADE21HAL;DE13800537628307638527;1
80053762;8736627268;NOLADE21HAL;DE92800537628736627268;1
80053762;8011718534;NOLADE21HAL;DE70800537628011718534;1
80053762;8945776304;NOLADE21HAL;DE94800537628945776304;1
80053762;9000814100;NOLADE21HAL;DE08800537629000814100;1
80053762;9974858949;NOLADE21HAL;DE27800537629974858949;1
80053762;9835979844;NOLADE21HAL;DE72800537629835979844;1
80053762;9769890437;NOLADE21HAL;DE24800537629769890437;1
80053762;9873219061;NOLADE21HAL;DE48800537629873219061;1
80053762;269122117;NOLADE21HAL;DE41800537620269122117;1
80053762;269186409;NOLADE21HAL;DE69800537620269186409;1
80053762;269178503;NOLADE21HAL;DE34800537620269178503;1
80053762;269108050;NOLADE21HAL;DE95800537620269108050;1
80053762;269129413;NOLADE21HAL;DE56800537620269129413;1
80053762;269232478;NOLADE21HAL;DE37800537620269232478;1
80053762;269283790;NOLADE21HAL;DE64800537620269283790;1
80053762;269256938;NOLADE21HAL;DE90800537620269256938;1
80053762;269225358;NOLADE21HAL;DE23800537620269225358;1
80053762;269263918;NOLADE21HAL;DE04800537620269263918;1
80053762;269306137;NOLADE21HAL;DE35800537620269306137;1
80053762;269374973;NOLADE21HAL;DE80800537620269374973;1
80053762;269353755;NOLADE21HAL;DE84800537620269353755;1
80053762;269334084;NOLADE21HAL;DE29800537620269334084;1
80053762;269373780;NOLADE21HAL;DE87800537620269373780;1
80053762;269483764;NOLADE21HAL;DE77800537620269483764;1
80053762;269400702;NOLADE21HAL;DE14800537620269400702;1
80053762;269496300;NOLADE21HAL;DE38800537620269496300;1
80053762;269420100;NOLADE21HAL;DE68800537620269420100;1
80053762;269407570;NOLADE21HAL;DE42800537620269407570;1
80053762;269564110;NOLADE21HAL;DE43800537620269564110;1
80053762;269571698;NOLADE21HAL;DE31800537620269571698;1
80053762;269539301;NOLADE21HAL;DE04800537620269539301;1
80053762;269511784;NOLADE21HAL;DE40800537620269511784;1
80053762;269519815;NOLADE21HAL;DE95800537620269519815;1
80053762;269697160;NOLADE21HAL;DE88800537620269697160;1
80053762;269690964;NOLADE21HAL;DE55800537620269690964;1
80053762;269612785;NOLADE21HAL;DE71800537620269612785;1
80053762;269699279;NOLADE21HAL;DE08800537620269699279;1
80053762;269604766;NOLADE21HAL;DE80800537620269604766;1
80053762;269719806;NOLADE21HAL;DE37800537620269719806;1
80053762;269703268;NOLADE21HAL;DE72800537620269703268;1
80053762;269758305;NOLADE21HAL;DE16800537620269758305;1
80053762;269713956;NOLADE21HAL;DE71800537620269713956;1
80053762;269768556;NOLADE21HAL;DE77800537620269768556;1
80053762;269861289;NOLADE21HAL;DE50800537620269861289;1
80053762;269872973;NOLADE21HAL;DE26800537620269872973;1
80053762;269815309;NOLADE21HAL;DE07800537620269815309;1
80053762;269812318;NOLADE21HAL;DE60800537620269812318;1
80053762;269856897;NOLADE21HAL;DE03800537620269856897;1
80053762;269948651;NOLADE21HAL;DE25800537620269948651;1
80053762;269948473;NOLADE21HAL;DE78800537620269948473;1
80053762;269986332;NOLADE21HAL;DE71800537620269986332;1
80053762;269951857;NOLADE21HAL;DE84800537620269951857;1
80053762;269947540;NOLADE21HAL;DE49800537620269947540;1
80053762;146117858;NOLADE21HAL;DE31800537620146117858;1
80053762;900944431;NOLADE21HAL;DE62800537620900944431;1
80053762;179874137;NOLADE21HAL;DE64800537620179874137;1
80053762;407934895;NOLADE21HAL;DE11800537620407934895;1
80053772;878848776;TESTDEX9876;DE20800537720878848776;1
80053772;938176792;TESTDEX9876;DE36800537720938176792;1
80053772;373645242;TESTDEX9876;DE30800537720373645242;1
80053772;399082405;TESTDEX9876;DE85800537720399082405;1
80053782;444070771;TESTDEX9876;DE60800537820444070771;1
80053782;289876974;TESTDEX9876;DE48800537820289876974;1
80053782;581695723;TESTDEX9876;DE28800537820581695723;1
80053782;384078674;TESTDEX9876;DE72800537820384078674;1
50010700;1654338;DEGUDEFFXXX;DE46500107000001654338;1
50010700;1075058;DEGUDEFFXXX;DE35500107000001075058;1
50010700;1202467;DEGUDEFFXXX;DE97500107000001202467;1
50010700;1729191;DEGUDEFFXXX;DE10500107000001729191;1
50010700;1408223;DEGUDEFFXXX;DE69500107000001408223;1
50010700;2981639;DEGUDEFFXXX;DE54500107000002981639;1
50010700;2240215;DEGUDEFFXXX;DE30500107000002240215;1
50010700;2876689;DEGUDEFFXXX;DE43500107000002876689;1
50010700;2544258;DEGUDEFFXXX;DE76500107000002544258;1
50010700;2094643;DEGUDEFFXXX;DE34500107000002094643;1
50010700;3325933;DEGUDEFFXXX;DE14500107000003325933;1
50010700;3424188;DEGUDEFFXXX;DE79500107000003424188;1
50010700;3498743;DEGUDEFFXXX;DE38500107000003498743;1
50010700;3364970;DEGUDEFFXXX;DE17500107000003364970;1
50010700;3063570;DEGUDEFFXXX;DE02500107000003063570;1
50010700;4133007;DEGUDEFFXXX;DE66500107000004133007;1
50010700;4204723;DEGUDEFFXXX;DE48500107000004204723;1
50010700;4372026;DEGUDEFFXXX;DE60500107000004372026;1
50010700;4751300;DEGUDEFFXXX;DE49500107000004751300;1
50010700;4037512;DEGUDEFFXXX;DE74500107000004037512;1
50010700;5582626;DEGUDEFFXXX;DE47500107000005582626;1
50010700;5462485;DEGUDEFFXXX;DE77500107000005462485;1
50010700;5569371;DEGUDEFFXXX;DE02500107000005569371;1
50010700;5075195;DEGUDEFFXXX;DE16500107000005075195;1
50010700;5145520;DEGUDEFFXXX;DE16500107000005145520;1
50010700;785426992;DEGUDEFFXXX;DE22500107000785426992;1
50010700;791774755;DEGUDEFFXXX;DE12500107000791774755;1
50010700;716597120;DEGUDEFFXXX;DE56500107000716597120;1
50010700;781763343;DEGUDEFFXXX;DE79500107000781763343;1
50010700;743911298;DEGUDEFFXXX;DE05500107000743911298;1
50010700;816521261;DEGUDEFFXXX;DE41500107000816521261;1
50010700;820570765;DEGUDEFFXXX;DE87500107000820570765;1
50010700;876280638;DEGUDEFFXXX;DE03500107000876280638;1
50010700;862881601;DEGUDEFFXXX;DE86500107000862881601;1
50010700;833798462;DEGUDEFFXXX;DE60500107000833798462;1
10050000;5876861539;BELADEBEXXX;DE33100500005876861539;1
10050020;4256276640;SKPADEB1XXX;DE53100500204256276640;1
10050000;5213811177;BELADEBEXXX;DE37100500005213811177;1
10050000;3112381113;BELADEBEXXX;DE88100500003112381113;1
10050020;1540322936;SKPADEB1XXX;DE03100500201540322936;1
10050000;7419199745;BELADEBEXXX;DE66100500007419199745;1
10050000;6689341182;BELADEBEXXX;DE88100500006689341182;1
10050020;3735932490;SKPADEB1XXX;DE89100500203735932490;1
10050000;7785984842;BELADEBEXXX;DE84100500007785984842;1
10050000;5479867794;BELADEBEXXX;DE87100500005479867794;1
10050020;5746479503;SKPADEB1XXX;DE47100500205746479503;1
10050000;5739029019;BELADEBEXXX;DE32100500005739029019;1
10050000;5994307435;BELADEBEXXX;DE63100500005994307435;1
10050020;5133786065;SKPADEB1XXX;DE75100500205133786065;1
10050000;5179214114;BELADEBEXXX;DE68100500005179214114;1
10050000;5141743116;BELADEBEXXX;DE30100500005141743116;1
10050020;5100791135;SKPADEB1XXX;DE53100500205100791135;1
10050000;5147773700;BELADEBEXXX;DE14100500005147773700;1
10050000;5249767010;BELADEBEXXX;DE71100500005249767010;1
10050020;5258704440;SKPADEB1XXX;DE68100500205258704440;1
10050000;5254451980;BELADEBEXXX;DE89100500005254451980;1
10050000;5270360261;BELADEBEXXX;DE68100500005270360261;1
10050020;5243732852;SKPADEB1XXX;DE91100500205243732852;1
10050000;5345472322;BELADEBEXXX;DE78100500005345472322;1
10050000;5368379491;BELADEBEXXX;DE49100500005368379491;1
10050020;5369169574;SKPADEB1XXX;DE69100500205369169574;1
10050000;5340379002;BELADEBEXXX;DE05100500005340379002;1
10050000;5383140418;BELADEBEXXX;DE84100500005383140418;1
10050020;5438484025;SKPADEB1XXX;DE53100500205438484025;1
10050000;5480546253;BELADEBEXXX;DE47100500005480546253;1
10050000;5403868338;BELADEBEXXX;DE63100500005403868338;1
10050020;5493210734;SKPADEB1XXX;DE86100500205493210734;1
10050000;5468380389;BELADEBEXXX;DE97100500005468380389;1
10050000;5527420611;BELADEBEXXX;DE75100500005527420611;1
10050020;5514890538;SKPADEB1XXX;DE26100500205514890538;1
10050000;5597229969;BELADEBEXXX;DE96100500005597229969;1
10050000;5559846120;BELADEBEXXX;DE61100500005559846120;1
10050020;5566774488;SKPADEB1XXX;DE04100500205566774488;1
10050000;5611140767;BELADEBEXXX;DE19100500005611140767;1
10050000;5674245032;BELADEBEXXX;DE49100500005674245032;1
10050020;5649413595;SKPADEB1XXX;DE98100500205649413595;1
10050000;5602652320;BELADEBEXXX;DE77100500005602652320;1
10050000;5677014133;BELADEBEXXX;DE79100500005677014133;1
10050020;5728377089;SKPADEB1XXX;DE73100500205728377089;1
10050000;5799761264;BELADEBEXXX;DE61100500005799761264;1
10050000;5793273262;BELADEBEXXX;DE32100500005793273262;1
10050020;5797495441;SKPADEB1XXX;DE82100500205797495441;1
10050000;5756497721;BELADEBEXXX;DE12100500005756497721;1
10050000;5849291133;BELADEBEXXX;DE06100500005849291133;1
10050020;5888157173;SKPADEB1XXX;DE98100500205888157173;1
10050000;5891563173;BELADEBEXXX;DE91100500005891563173;1
10050000;5825086403;BELADEBEXXX;DE13100500005825086403;1
10050020;5889923865;SKPADEB1XXX;DE37100500205889923865;1
10050000;5930990770;BELADEBEXXX;DE96100500005930990770;1
10050000;5954093193;BELADEBEXXX;DE62100500005954093193;1
10050020;5918419947;SKPADEB1XXX;DE26100500205918419947;1
10050000;5960239289;BELADEBEXXX;DE63100500005960239289;1
10050000;5983174201;BELADEBEXXX;DE07100500005983174201;1
10050020;9012844705;SKPADEB1XXX;DE79100500209012844705;1
10050000;9017513104;BELADEBEXXX;DE32100500009017513104;1
10050000;9011648284;BELADEBEXXX;DE97100500009011648284;1
10050020;9015387940;SKPADEB1XXX;DE04100500209015387940;1
10050000;9022111155;BELADEBEXXX;DE45100500009022111155;1
10050000;9028453373;BELADEBEXXX;DE79100500009028453373;1
10050020;9028046264;SKPADEB1XXX;DE03100500209028046264;1
10050000;9029503656;BELADEBEXXX;DE97100500009029503656;1
10050000;9023302448;BELADEBEXXX;DE43100500009023302448;1
10050020;9034697994;SKPADEB1XXX;DE54100500209034697994;1
10050000;9035751701;BELADEBEXXX;DE44100500009035751701;1
10050000;9035024023;BELADEBEXXX;DE97100500009035024023;1
10050020;9033148096;SKPADEB1XXX;DE45100500209033148096;1
10050000;9036575961;BELADEBEXXX;DE25100500009036575961;1
10050000;9047178208;BELADEBEXXX;DE33100500009047178208;1
10050020;9047954425;SKPADEB1XXX;DE15100500209047954425;1
10050000;9046979124;BELADEBEXXX;DE46100500009046979124;1
10050000;9048054947;BELADEBEXXX;DE57100500009048054947;1
10050020;9041255920;SKPADEB1XXX;DE46100500209041255920;1
10050000;9058925681;BELADEBEXXX;DE17100500009058925681;1
10050000;9057738399;BELADEBEXXX;DE71100500009057738399;1
10050020;9054430663;SKPADEB1XXX;DE94100500209054430663;1
10050000;9056262256;BELADEBEXXX;DE87100500009056262256;1
10050000;9054862684;BELADEBEXXX;DE47100500009054862684;1
10050020;9061409574;SKPADEB1XXX;DE48100500209061409574;1
10050000;9066895912;BELADEBEXXX;DE26100500009066895912;1
10050000;9061492446;BELADEBEXXX;DE79100500009061492446;1
10050020;9069437215;SKPADEB1XXX;DE47100500209069437215;1
10050000;9065320332;BELADEBEXXX;DE75100500009065320332;1
10050000;9070647550;BELADEBEXXX;DE87100500009070647550;1
10050020;9079760820;SKPADEB1XXX;DE69100500209079760820;1
10050000;9077049449;BELADEBEXXX;DE98100500009077049449;1
10050000;9075958805;BELADEBEXXX;DE32100500009075958805;1
10050020;9071415915;SKPADEB1XXX;DE31100500209071415915;1
10050000;9089751424;BELADEBEXXX;DE70100500009089751424;1
10050000;9086566189;BELADEBEXXX;DE51100500009086566189;1
10050020;9086136176;SKPADEB1XXX;DE08100500209086136176;1
10050000;9084950023;BELADEBEXXX;DE16100500009084950023;1
10050000;9087748195;BELADEBEXXX;DE53100500009087748195;1
10050020;9099999284;SKPADEB1XXX;DE80100500209099999284;1
10050000;9097651718;BELADEBEXXX;DE79100500009097651718;1
10050000;9092550959;BELADEBEXXX;DE69100500009092550959;1
10050020;9090488408;SKPADEB1XXX;DE06100500209090488408;1
10050000;9094653068;BELADEBEXXX;DE57100500009094653068;1
10050000;9103485365;BELADEBEXXX;DE16100500009103485365;1
10050020;9108106145;SKPADEB1XXX;DE86100500209108106145;1
10050000;9100914344;BELADEBEXXX;DE18100500009100914344;1
10050000;9104484365;BELADEBEXXX;DE97100500009104484365;1
13051172;22553456;TESTDEX9876;DE04130511720022553456;1
13051172;80038368;TESTDEX9876;DE15130511720080038368;1
13051172;50328862;TESTDEX9876;DE45130511720050328862;1
13051172;35011574;TESTDEX9876;DE46130511720035011574;1
13051172;39332780;TESTDEX9876;DE54130511720039332780;1
13051042;4097798370;NOLADE21RUE;DE66130510424097798370;1
14051462;1225190300;NOLADE21SNS;DE95140514621225190300;1
15051732;8457907094;NOLADE21MST;DE32150517328457907094;1
17052302;9962629621;WELADED1UMX;DE45170523029962629621;1
80053572;9855534180;NOLADE21DES;DE66800535729855534180;1
50010517;166447645;INGDDEFFXXX;DE48500105170166447645;1
50010517;716895148;INGDDEFFXXX;DE29500105170716895148;1
50010517;831679034;INGDDEFFXXX;DE45500105170831679034;1
50010517;937072022;INGDDEFFXXX;DE90500105170937072022;1
50010517;177524999;INGDDEFFXXX;DE29500105170177524999;1
50010517;1118908665;INGDDEFFXXX;DE60500105171118908665;1
50010517;1141229837;INGDDEFFXXX;DE86500105171141229837;1
50010517;1291669369;INGDDEFFXXX;DE59500105171291669369;1
50010517;1565955504;INGDDEFFXXX;DE53500105171565955504;1
50010517;1082290088;INGDDEFFXXX;DE39500105171082290088;1
50010517;2255363795;INGDDEFFXXX;DE37500105172255363795;1
50010517;2564857418;INGDDEFFXXX;DE86500105172564857418;1
50010517;2095133827;INGDDEFFXXX;DE55500105172095133827;1
50010517;2219311009;INGDDEFFXXX;DE92500105172219311009;1
50010517;2893673864;INGDDEFFXXX;DE63500105172893673864;1
50010517;3789825061;INGDDEFFXXX;DE03500105173789825061;1
50010517;3022619315;INGDDEFFXXX;DE87500105173022619315;1
50010517;3937882393;INGDDEFFXXX;DE34500105173937882393;1
50010517;3171552536;INGDDEFFXXX;DE06500105173171552536;1
50010517;3327248446;INGDDEFFXXX;DE25500105173327248446;1
50010517;4789935831;INGDDEFFXXX;DE66500105174789935831;1
50010517;4684711898;INGDDEFFXXX;DE65500105174684711898;1
50010517;4868745439;INGDDEFFXXX;DE65500105174868745439;1
50010517;4436204534;INGDDEFFXXX;DE52500105174436204534;1
50010517;4698016681;INGDDEFFXXX;DE45500105174698016681;1
50010517;6000304811;INGDDEFFXXX;DE19500105176000304811;1
50010517;6297059122;INGDDEFFXXX;DE74500105176297059122;1
50010517;6847251067;INGDDEFFXXX;DE26500105176847251067;1
50010517;6663205598;INGDDEFFXXX;DE42500105176663205598;1
50010517;6396971851;INGDDEFFXXX;DE14500105176396971851;1
50010517;7012834070;INGDDEFFXXX;DE03500105177012834070;1
50010517;7785834704;INGDDEFFXXX;DE10500105177785834704;1
50010517;7041303167;INGDDEFFXXX;DE20500105177041303167;1
50010517;7050813779;INGDDEFFXXX;DE44500105177050813779;1
50010517;7394842285;INGDDEFFXXX;DE46500105177394842285;1
50010517;8425335053;INGDDEFFXXX;DE31500105178425335053;1
50010517;8350397959;INGDDEFFXXX;DE06500105178350397959;1
50010517;8416641102;INGDDEFFXXX;DE06500105178416641102;1
50010517;8656014049;INGDDEFFXXX;DE85500105178656014049;1
50010517;8831342493;INGDDEFFXXX;DE11500105178831342493;1
50010517;9878137262;INGDDEFFXXX;DE56500105179878137262;1
50010517;9506541451;INGDDEFFXXX;DE11500105179506541451;1
50010517;9441740044;INGDDEFFXXX;DE15500105179441740044;1
50010517;9172184759;INGDDEFFXXX;DE66500105179172184759;1
50010517;9384979585;INGDDEFFXXX;DE17500105179384979585;1
50010517;5134249221;INGDDEFFXXX;DE09500105175134249221;1
50010517;5270882341;INGDDEFFXXX;DE69500105175270882341;1
50010517;5516491651;INGDDEFFXXX;DE65500105175516491651;1
50010517;5214577161;INGDDEFFXXX;DE57500105175214577161;1
50010517;5029518870;INGDDEFFXXX;DE27500105175029518870;1
21450000;4522529261;NOLADE21RDB;DE09214500004522529261;1
21450000;9119668743;NOLADE21RDB;DE60214500009119668743;1
21450000;2861386972;NOLADE21RDB;DE48214500002861386972;1
21450000;7927679791;NOLADE21RDB;DE81214500007927679791;1
21450000;1854802611;NOLADE21RDB;DE23214500001854802611;1
21450000;7136258147;NOLADE21RDB;DE38214500007136258147;1
21450000;6062758146;NOLADE21RDB;DE02214500006062758146;1
21450000;2574960817;NOLADE21RDB;DE37214500002574960817;1
21450000;2348975133;NOLADE21RDB;DE98214500002348975133;1
21450000;2697154132;NOLADE21RDB;DE16214500002697154132;1
20030400;551096001;MCRDDEHHXXX;DE33200304000551096001;1
20030400;173265885;MCRDDEHHXXX;DE86200304000173265885;1
20030400;360425367;MCRDDEHHXXX;DE58200304000360425367;1
20030400;827079112;MCRDDEHHXXX;DE13200304000827079112;1
20030400;376041380;MCRDDEHHXXX;DE32200304000376041380;1
20030400;1564891297;MCRDDEHHXXX;DE12200304001564891297;1
20030400;1383976840;MCRDDEHHXXX;DE47200304001383976840;1
20030400;1651171900;MCRDDEHHXXX;DE78200304001651171900;1
20030400;1697789988;MCRDDEHHXXX;DE95200304001697789988;1
20030400;1145950182;MCRDDEHHXXX;DE42200304001145950182;1
20030400;2399170162;MCRDDEHHXXX;DE98200304002399170162;1
20030400;2770234629;MCRDDEHHXXX;DE34200304002770234629;1
20030400;2833380575;MCRDDEHHXXX;DE71200304002833380575;1
20030400;2883501302;MCRDDEHHXXX;DE52200304002883501302;1
20030400;2186224354;MCRDDEHHXXX;DE42200304002186224354;1
20030400;3991117163;MCRDDEHHXXX;DE67200304003991117163;1
20030400;3210174037;MCRDDEHHXXX;DE35200304003210174037;1
20030400;3440591968;MCRDDEHHXXX;DE48200304003440591968;1
20030400;3438907838;MCRDDEHHXXX;DE92200304003438907838;1
20030400;3471770788;MCRDDEHHXXX;DE85200304003471770788;1
20030400;4107026223;MCRDDEHHXXX;DE09200304004107026223;1
20030400;4277703411;MCRDDEHHXXX;DE81200304004277703411;1
20030400;4746871500;MCRDDEHHXXX;DE41200304004746871500;1
20030400;4603128697;MCRDDEHHXXX;DE71200304004603128697;1
20030400;4734160064;MCRDDEHHXXX;DE18200304004734160064;1
20030400;5990683152;MCRDDEHHXXX;DE92200304005990683152;1
20030400;5422896869;MCRDDEHHXXX;DE48200304005422896869;1
20030400;5126893329;MCRDDEHHXXX;DE42200304005126893329;1
20030400;5100349942;MCRDDEHHXXX;DE86200304005100349942;1
20030400;6609764318;MCRDDEHHXXX;DE27200304006609764318;1
20030400;6584370693;MCRDDEHHXXX;DE86200304006584370693;1
20030400;6851805108;MCRDDEHHXXX;DE60200304006851805108;1
20030400;6739764709;MCRDDEHHXXX;DE42200304006739764709;1
20030400;6500426280;MCRDDEHHXXX;DE50200304006500426280;1
20030400;7198335767;MCRDDEHHXXX;DE06200304007198335767;1
20030400;7380931027;MCRDDEHHXXX;DE31200304007380931027;1
20030400;7582433285;MCRDDEHHXXX;DE91200304007582433285;1
20030400;7023070605;MCRDDEHHXXX;DE24200304007023070605;1
20030400;7260409268;MCRDDEHHXXX;DE06200304007260409268;1
20030400;8606366824;MCRDDEHHXXX;DE54200304008606366824;1
20030400;8342808865;MCRDDEHHXXX;DE29200304008342808865;1
20030400;8552515812;MCRDDEHHXXX;DE49200304008552515812;1
20030400;8041047369;MCRDDEHHXXX;DE25200304008041047369;1
20030400;8154613957;MCRDDEHHXXX;DE92200304008154613957;1
20030400;9877686670;MCRDDEHHXXX;DE10200304009877686670;1
20030400;9816475599;MCRDDEHHXXX;DE26200304009816475599;1
20030400;9286645400;MCRDDEHHXXX;DE26200304009286645400;1
20030400;9086686441;MCRDDEHHXXX;DE56200304009086686441;1
20030400;9514429937;MCRDDEHHXXX;DE95200304009514429937;1
20050000;161125;HSHNDEHHXXX;DE38210500000161125000;20
21050000;137489;HSHNDEHHXXX;DE17210500000137489000;18
23050000;108043;HSHNDEHHXXX;DE44210500000108043000;20
20050000;104117;HSHNDEHHXXX;DE56210500000104117000;20
20050000;101378;HSHNDEHHXXX;DE62210500000101378000;20
21050000;214023;HSHNDEHHXXX;DE80210500000214023000;18
23050000;288399;HSHNDEHHXXX;DE86210500000288399000;20
20050000;221283;HSHNDEHHXXX;DE08210500000221283000;20
20050000;276303;HSHNDEHHXXX;DE70210500000276303000;20
21050000;241430;HSHNDEHHXXX;DE24210500000241430000;18
23050000;372037;HSHNDEHHXXX;DE46210500000372037000;20
20050000;366807;HSHNDEHHXXX;DE65210500000366807000;20
20050000;324038;HSHNDEHHXXX;DE84210500000324038000;20
21050000;334318;HSHNDEHHXXX;DE55210500000334318000;18
23050000;341487;HSHNDEHHXXX;DE70210500000341487000;20
20050000;466193;HSHNDEHHXXX;DE33210500000466193000;20
20050000;485862;HSHNDEHHXXX;DE05210500000485862000;20
21050000;496679;HSHNDEHHXXX;DE51210500000496679000;18
23050000;443739;HSHNDEHHXXX;DE79210500000443739000;20
20050000;491746;HSHNDEHHXXX;DE60210500000491746000;20
20050000;545103;HSHNDEHHXXX;DE16210500000545103000;20
21050000;551580;HSHNDEHHXXX;DE85210500000551580000;18
23050000;557033;HSHNDEHHXXX;DE50210500000557033000;20
20050000;549295;HSHNDEHHXXX;DE78210500000549295000;20
20050000;518472;HSHNDEHHXXX;DE72210500000518472000;20
21050000;673129;HSHNDEHHXXX;DE07210500000673129000;18
23050000;699868;HSHNDEHHXXX;DE62210500000699868000;20
20050000;668327;HSHNDEHHXXX;DE24210500000668327000;20
20050000;634246;HSHNDEHHXXX;DE16210500000634246000;20
21050000;648048;HSHNDEHHXXX;DE34210500000648048000;18
23050000;743948;HSHNDEHHXXX;DE89210500000743948000;20
20050000;753525;HSHNDEHHXXX;DE03210500000753525000;20
20050000;790550;HSHNDEHHXXX;DE19210500000790550000;20
21050000;721225;HSHNDEHHXXX;DE66210500000721225000;18
23050000;797993;HSHNDEHHXXX;DE30210500000797993000;20
20050000;850149;HSHNDEHHXXX;DE80210500000850149000;20
20050000;866715;HSHNDEHHXXX;DE18210500000866715000;20
21050000;851220;HSHNDEHHXXX;DE41210500000851220000;18
23050000;887919;HSHNDEHHXXX;DE83210500000887919000;20
20050000;812446;HSHNDEHHXXX;DE30210500000812446000;20
20050000;110262956;HSHNDEHHXXX;DE54210500000110262956;19
21050000;125633237;HSHNDEHHXXX;DE89210500000125633237;1
23050000;164210561;HSHNDEHHXXX;DE87210500000164210561;19
20050000;117879331;HSHNDEHHXXX;DE63210500000117879331;19
20050000;113845780;HSHNDEHHXXX;DE63210500000113845780;19
21050000;250365954;HSHNDEHHXXX;DE82210500000250365954;1
23050000;256107274;HSHNDEHHXXX;DE45210500000256107274;19
20050000;275073482;HSHNDEHHXXX;DE67210500000275073482;19
20050000;231134335;HSHNDEHHXXX;DE88210500000231134335;19
21050000;286237913;HSHNDEHHXXX;DE55210500000286237913;1
23050000;389775551;HSHNDEHHXXX;DE64210500000389775551;19
20050000;308783134;HSHNDEHHXXX;DE66210500000308783134;19
20050000;394486418;HSHNDEHHXXX;DE39210500000394486418;19
21050000;375568543;HSHNDEHHXXX;DE64210500000375568543;1
23050000;348805735;HSHNDEHHXXX;DE06210500000348805735;19
20050000;454074644;HSHNDEHHXXX;DE95210500000454074644;19
20050000;404848948;HSHNDEHHXXX;DE81210500000404848948;19
21050000;426031824;HSHNDEHHXXX;DE37210500000426031824;1
23050000;407478069;HSHNDEHHXXX;DE63210500000407478069;19
20050000;484329518;HSHNDEHHXXX;DE20210500000484329518;19
20050000;525477815;HSHNDEHHXXX;DE51210500000525477815;19
21050000;560433794;HSHNDEHHXXX;DE73210500000560433794;1
23050000;544932056;HSHNDEHHXXX;DE50210500000544932056;19
20050000;597310393;HSHNDEHHXXX;DE40210500000597310393;19
20050000;599662583;HSHNDEHHXXX;DE11210500000599662583;19
21050000;656645697;HSHNDEHHXXX;DE93210500000656645697;1
23050000;614651448;HSHNDEHHXXX;DE79210500000614651448;19
20050000;685073680;HSHNDEHHXXX;DE23210500000685073680;19
20050000;668251717;HSHNDEHHXXX;DE30210500000668251717;19
21050000;683953935;HSHNDEHHXXX;DE81210500000683953935;1
23050000;741785287;HSHNDEHHXXX;DE19210500000741785287;19
20050000;782144651;HSHNDEHHXXX;DE41210500000782144651;19
20050000;707661546;HSHNDEHHXXX;DE09210500000707661546;19
21050000;712646910;HSHNDEHHXXX;DE44210500000712646910;1
23050000;722850169;HSHNDEHHXXX;DE05210500000722850169;19
20050000;887752299;HSHNDEHHXXX;DE16210500000887752299;19
20050000;817544184;HSHNDEHHXXX;DE16210500000817544184;19
21050000;839175333;HSHNDEHHXXX;DE67210500000839175333;1
23050000;879882068;HSHNDEHHXXX;DE02210500000879882068;19
20050000;891010070;HSHNDEHHXXX;DE90210500000891010070;19
20050000;1576745456;HSHNDEHHXXX;DE74210500001576745456;19
21050000;1988649546;HSHNDEHHXXX;DE96210500001988649546;1
23050000;1947432803;HSHNDEHHXXX;DE63210500001947432803;19
20050000;1341333701;HSHNDEHHXXX;DE11210500001341333701;19
20050000;1512954303;HSHNDEHHXXX;DE08210500001512954303;19
21050000;4024021423;HSHNDEHHXXX;DE84210500004024021423;1
23050000;4204630905;HSHNDEHHXXX;DE44210500004204630905;19
20050000;4455375734;HSHNDEHHXXX;DE05210500004455375734;19
20050000;4685131503;HSHNDEHHXXX;DE31210500004685131503;19
21050000;4250783870;HSHNDEHHXXX;DE83210500004250783870;1
23050000;5202490917;HSHNDEHHXXX;DE73210500005202490917;19
20050000;5805612035;HSHNDEHHXXX;DE65210500005805612035;19
20050000;5962035206;HSHNDEHHXXX;DE38210500005962035206;19
21050000;5886611192;HSHNDEHHXXX;DE55210500005886611192;1
23050000;5730125063;HSHNDEHHXXX;DE23210500005730125063;19
20050000;6415367886;HSHNDEHHXXX;DE23210500006415367886;19
20050000;6952410345;HSHNDEHHXXX;DE92210500006952410345;19
21050000;6069496794;HSHNDEHHXXX;DE95210500006069496794;1
23050000;6513498083;HSHNDEHHXXX;DE31210500006513498083;19
20050000;6648050673;HSHNDEHHXXX;DE52210500006648050673;19
20050000;9905609019;HSHNDEHHXXX;DE75210500009905609019;19
21050000;9884298738;HSHNDEHHXXX;DE46210500009884298738;1
23050000;9469854648;HSHNDEHHXXX;DE54210500009469854648;19
20050000;9519779968;HSHNDEHHXXX;DE97210500009519779968;19
20050000;9490205906;HSHNDEHHXXX;DE39210500009490205906;19
21050000;3696157613;HSHNDEHHXXX;DE37210500003696157613;1
23050000;3669209045;HSHNDEHHXXX;DE17210500003669209045;19
20050000;3085788465;HSHNDEHHXXX;DE34210500003085788465;19
20050000;3084298698;HSHNDEHHXXX;DE74210500003084298698;19
21050000;3504048913;HSHNDEHHXXX;DE05210500003504048913;1
23050000;33574446;HSHNDEHHXXX;DE82210500000033574446;19
20050000;37818359;HSHNDEHHXXX;DE46210500000037818359;19
20050000;30969890;HSHNDEHHXXX;DE34210500000030969890;19
21050000;38490765;HSHNDEHHXXX;DE89210500000038490765;1
23050000;37802207;HSHNDEHHXXX;DE38210500000037802207;19
20050000;43758237;HSHNDEHHXXX;DE36210500000043758237;19
20050000;41677090;HSHNDEHHXXX;DE69210500000041677090;19
21050000;42866390;HSHNDEHHXXX;DE43210500000042866390;1
23050000;48620356;HSHNDEHHXXX;DE04210500000048620356;19
20050000;45395037;HSHNDEHHXXX;DE24210500000045395037;19
20050000;54710374;HSHNDEHHXXX;DE38210500000054710374;19
21050000;56918835;HSHNDEHHXXX;DE13210500000056918835;1
23050000;50896540;HSHNDEHHXXX;DE05210500000050896540;19
20050000;55844519;HSHNDEHHXXX;DE53210500000055844519;19
20050000;53645834;HSHNDEHHXXX;DE63210500000053645834;19
21050000;7008366434;HSHNDEHHXXX;DE71210500007008366434;1
23050000;7014282358;HSHNDEHHXXX;DE23210500007014282358;19
20050000;7062493932;HSHNDEHHXXX;DE74210500007062493932;19
20050000;7019216793;HSHNDEHHXXX;DE69210500007019216793;19
21050000;7013687094;HSHNDEHHXXX;DE27210500007013687094;1
23050000;8597644539;HSHNDEHHXXX;DE96210500008597644539;19
20050000;8556542741;HSHNDEHHXXX;DE63210500008556542741;19
20050000;8508011530;HSHNDEHHXXX;DE24210500008508011530;19
21050000;8522818455;HSHNDEHHXXX;DE04210500008522818455;1
23050000;8515391063;HSHNDEHHXXX;DE42210500008515391063;19
76026000;5347000;NORSDE71XXX;DE59760260000534700000;25
76026000;2433161;NORSDE71XXX;DE59760260000002433161;1
76026000;4229161;NORSDE71XXX;DE08760260000004229161;1
76026000;7133232;NORSDE71XXX;DE41760260000007133232;1
76026000;524049464;NORSDE71XXX;DE77760260000524049464;1
76026000;620662776;NORSDE71XXX;DE58760260000620662776;1
76026000;524470262;NORSDE71XXX;DE44760260000524470262;1
76026000;693058038;NORSDE71XXX;DE10760260000693058038;1
76026000;969751761;NORSDE71XXX;DE66760260000969751761;1
76026000;3450460523;NORSDE71XXX;;-124
76026000;2753704437;NORSDE71XXX;;-124
76026000;6826635337;NORSDE71XXX;;-124
76026000;4355531789;NORSDE71XXX;;-124
76026000;7846636360;NORSDE71XXX;;-124
21750000;9709231881;NOLADE21NOS;DE66217500009709231881;1
21750000;4160666378;NOLADE21NOS;DE51217500004160666378;1
21750000;7679054812;NOLADE21NOS;DE31217500007679054812;1
21750000;1368381685;NOLADE21NOS;DE14217500001368381685;1
21750000;7874040566;NOLADE21NOS;DE18217500007874040566;1
21750000;3854191054;NOLADE21NOS;DE91217500003854191054;1
21750000;8176725452;NOLADE21NOS;DE14217500008176725452;1
21750000;9737359732;NOLADE21NOS;DE83217500009737359732;1
21750000;2698378177;NOLADE21NOS;DE03217500002698378177;1
21750000;1131315135;NOLADE21NOS;DE52217500001131315135;1
21750000;9230795798;NOLADE21NOS;DE97217500009230795798;1
21750000;4826342985;NOLADE21NOS;DE81217500004826342985;1
21750000;2638944033;NOLADE21NOS;DE63217500002638944033;1
21750000;2798978556;NOLADE21NOS;DE66217500002798978556;1
59252046;6919516713;SALADE51NKS;DE75592520466919516713;1
59252046;6896513956;SALADE51NKS;DE04592520466896513956;1
59252046;1545414870;SALADE51NKS;DE90592520461545414870;1
59252046;8162266269;SALADE51NKS;DE26592520468162266269;1
59252046;3928234214;SALADE51NKS;DE26592520463928234214;1
59252046;1597476455;SALADE51NKS;DE88592520461597476455;1
59252046;3083450532;SALADE51NKS;DE59592520463083450532;1
59252046;2161671103;SALADE51NKS;DE79592520462161671103;1
59252046;8312761225;SALADE51NKS;DE67592520468312761225;1
59252046;1049783638;SALADE51NKS;DE81592520461049783638;1
86055592;3349019250;WELADE8LXXX;DE62860555923349019250;1
86055592;9809441298;WELADE8LXXX;DE45860555929809441298;1
86055592;5052896044;WELADE8LXXX;DE72860555925052896044;1
86055592;7565365798;WELADE8LXXX;DE61860555927565365798;1
86055592;4712499597;WELADE8LXXX;DE22860555924712499597;1
86055592;5707416958;WELADE8LXXX;DE92860555925707416958;1
86055592;5786293659;WELADE8LXXX;DE55860555925786293659;1
86055592;5760234274;WELADE8LXXX;DE79860555925760234274;1
86055592;5708809523;WELADE8LXXX;DE74860555925708809523;1
86055592;5739836699;WELADE8LXXX;DE32860555925739836699;1
70120500;1569169;FMBKDEMMXXX;DE69701205000001569169;1
70120500;1165644;FMBKDEMMXXX;DE10701205000001165644;1
70120500;1562478;FMBKDEMMXXX;DE15701205000001562478;1
70120500;1411373;FMBKDEMMXXX;DE30701205000001411373;1
70120500;1689723;FMBKDEMMXXX;DE43701205000001689723;1
70120500;9228811;FMBKDEMMXXX;DE40701205000009228811;1
70120500;9302949;FMBKDEMMXXX;DE06701205000009302949;1
70120500;9307469;FMBKDEMMXXX;DE89701205000009307469;1
70120500;9683629;FMBKDEMMXXX;DE57701205000009683629;1
70120500;9159369;FMBKDEMMXXX;DE61701205000009159369;1
70120500;10669848;FMBKDEMMXXX;DE02701205000010669848;1
70120500;18260801;FMBKDEMMXXX;DE33701205000018260801;1
70120500;16622682;FMBKDEMMXXX;DE59701205000016622682;1
70120500;13191157;FMBKDEMMXXX;DE35701205000013191157;1
70120500;13991502;FMBKDEMMXXX;DE89701205000013991502;1
70120500;20090732;FMBKDEMMXXX;DE10701205000020090732;1
70120500;20595435;FMBKDEMMXXX;DE74701205000020595435;1
70120500;20391289;FMBKDEMMXXX;DE88701205000020391289;1
70120500;20302429;FMBKDEMMXXX;DE13701205000020302429;1
70120500;20742565;FMBKDEMMXXX;DE05701205000020742565;1
70120500;21543804;FMBKDEMMXXX;DE74701205000021543804;1
70120500;21857299;FMBKDEMMXXX;DE26701205000021857299;1
70120500;21348740;FMBKDEMMXXX;DE90701205000021348740;1
70120500;21179616;FMBKDEMMXXX;DE66701205000021179616;1
70120500;21668654;FMBKDEMMXXX;DE68701205000021668654;1
70120500;22170904;FMBKDEMMXXX;DE15701205000022170904;1
70120500;22152439;FMBKDEMMXXX;DE87701205000022152439;1
70120500;22069971;FMBKDEMMXXX;DE88701205000022069971;1
70120500;22711182;FMBKDEMMXXX;DE48701205000022711182;1
70120500;22075111;FMBKDEMMXXX;DE18701205000022075111;1
70120500;23420339;FMBKDEMMXXX;DE27701205000023420339;1
70120500;23155247;FMBKDEMMXXX;DE75701205000023155247;1
70120500;23534331;FMBKDEMMXXX;DE53701205000023534331;1
70120500;23777916;FMBKDEMMXXX;DE52701205000023777916;1
70120500;23328532;FMBKDEMMXXX;DE78701205000023328532;1
70120500;24086411;FMBKDEMMXXX;DE77701205000024086411;1
70120500;24853266;FMBKDEMMXXX;DE30701205000024853266;1
70120500;24314565;FMBKDEMMXXX;DE98701205000024314565;1
70120500;24343820;FMBKDEMMXXX;DE84701205000024343820;1
70120500;24995384;FMBKDEMMXXX;DE67701205000024995384;1
70120500;25407195;FMBKDEMMXXX;DE86701205000025407195;1
70120500;25422736;FMBKDEMMXXX;DE04701205000025422736;1
70120500;25661580;FMBKDEMMXXX;DE67701205000025661580;1
70120500;25625230;FMBKDEMMXXX;DE71701205000025625230;1
70120500;25558140;FMBKDEMMXXX;DE26701205000025558140;1
70120500;396622966;FMBKDEMMXXX;DE66701205000396622966;1
70120500;396856963;FMBKDEMMXXX;DE48701205000396856963;1
70120500;396999832;FMBKDEMMXXX;DE81701205000396999832;1
70120500;396246243;FMBKDEMMXXX;DE70701205000396246243;1
70120500;396433996;FMBKDEMMXXX;DE56701205000396433996;1
70120500;397144170;FMBKDEMMXXX;DE27701205000397144170;1
70120500;397477867;FMBKDEMMXXX;DE53701205000397477867;1
70120500;397167804;FMBKDEMMXXX;DE72701205000397167804;1
70120500;397762499;FMBKDEMMXXX;DE08701205000397762499;1
70120500;397632916;FMBKDEMMXXX;DE56701205000397632916;1
70120500;398755827;FMBKDEMMXXX;DE70701205000398755827;1
70120500;398835265;FMBKDEMMXXX;DE11701205000398835265;1
70120500;398601050;FMBKDEMMXXX;DE95701205000398601050;1
70120500;398863539;FMBKDEMMXXX;DE03701205000398863539;1
70120500;399833256;FMBKDEMMXXX;DE78701205000399833256;1
70120500;399937142;FMBKDEMMXXX;DE08701205000399937142;1
70120500;399059875;FMBKDEMMXXX;DE78701205000399059875;1
70120500;399863795;FMBKDEMMXXX;DE25701205000399863795;1
70120500;399292583;FMBKDEMMXXX;DE40701205000399292583;1
70120500;435357345;FMBKDEMMXXX;DE31701205000435357345;1
70120500;409536600;FMBKDEMMXXX;DE97701205000409536600;1
70120500;436848877;FMBKDEMMXXX;DE60701205000436848877;1
70120500;461222991;FMBKDEMMXXX;DE41701205000461222991;1
70120500;466404811;FMBKDEMMXXX;DE15701205000466404811;1
70120500;711598384;FMBKDEMMXXX;DE70701205000711598384;1
70120500;713818877;FMBKDEMMXXX;DE34701205000713818877;1
70120500;744397316;FMBKDEMMXXX;DE09701205000744397316;1
70120500;737605068;FMBKDEMMXXX;DE80701205000737605068;1
70120500;4140781563;FMBKDEMMXXX;DE22701205004140781563;1
70120500;9131253351;FMBKDEMMXXX;DE61701205009131253351;1
70120500;1012400426;FMBKDEMMXXX;DE27701205001012400426;1
70120500;2650990288;FMBKDEMMXXX;DE54701205002650990288;1
70120500;4758067666;FMBKDEMMXXX;DE26701205004758067666;1
70120500;5813220182;FMBKDEMMXXX;DE53701205005813220182;1
70120500;7432727571;FMBKDEMMXXX;DE02701205007432727571;1
70120500;7251723206;FMBKDEMMXXX;DE31701205007251723206;1
70120500;6341337167;FMBKDEMMXXX;DE53701205006341337167;1
70120500;434868028;FMBKDEMMXXX;DE93701205000434868028;1
70120500;469457190;FMBKDEMMXXX;DE86701205000469457190;1
70120500;434266621;FMBKDEMMXXX;DE88701205000434266621;1
70120500;449473626;FMBKDEMMXXX;DE22701205000449473626;1
70120500;447095851;FMBKDEMMXXX;DE12701205000447095851;1
70120500;8559011552;FMBKDEMMXXX;DE34701205008559011552;1
70120500;3659867870;FMBKDEMMXXX;DE55701205003659867870;1
70120500;5319667445;FMBKDEMMXXX;DE29701205005319667445;1
70120500;2359291972;FMBKDEMMXXX;DE17701205002359291972;1
70120500;3309891888;FMBKDEMMXXX;DE54701205003309891888;1
70120500;937813;FMBKDEMMXXX;DE95701205000000937813;1
70120500;446534;FMBKDEMMXXX;DE72701205000000446534;1
70120500;315242;FMBKDEMMXXX;DE91701205000000315242;1
70120500;229369;FMBKDEMMXXX;DE71701205000000229369;1
70120500;454819;FMBKDEMMXXX;DE59701205000000454819;1
70120500;4127860;FMBKDEMMXXX;DE73701205000004127860;1
70120500;2781195;FMBKDEMMXXX;DE63701205000002781195;1
70120500;4354563;FMBKDEMMXXX;DE83701205000004354563;1
70120500;8114256;FMBKDEMMXXX;DE36701205000008114256;1
70120500;6909218;FMBKDEMMXXX;DE31701205000006909218;1
70120500;68178830;FMBKDEMMXXX;DE23701205000068178830;1
70120500;27071332;FMBKDEMMXXX;DE48701205000027071332;1
70120500;25594010;FMBKDEMMXXX;DE81701205000025594010;1
70120500;45927316;FMBKDEMMXXX;DE61701205000045927316;1
70120500;50674432;FMBKDEMMXXX;DE43701205000050674432;1
70120500;124403492;FMBKDEMMXXX;DE57701205000124403492;1
70120500;418014642;FMBKDEMMXXX;DE62701205000418014642;1
70120500;572911094;FMBKDEMMXXX;DE37701205000572911094;1
70120500;342675915;FMBKDEMMXXX;DE13701205000342675915;1
70120500;863951;FMBKDEMMXXX;DE49701205000000863951;1
70120500;875096;FMBKDEMMXXX;DE28701205000000875096;1
70120500;459842;FMBKDEMMXXX;DE44701205000000459842;1
70120500;350934;FMBKDEMMXXX;DE05701205000000350934;1
70120500;563700;FMBKDEMMXXX;DE51701205000000563700;1
70120500;1208652;FMBKDEMMXXX;DE78701205000001208652;1
70120500;5340141;FMBKDEMMXXX;DE69701205000005340141;1
70120500;9170589;FMBKDEMMXXX;DE52701205000009170589;1
70120500;8309112;FMBKDEMMXXX;DE10701205000008309112;1
70120500;59417402;FMBKDEMMXXX;DE23701205000059417402;1
70120500;64970657;FMBKDEMMXXX;DE82701205000064970657;1
70120500;21551069;FMBKDEMMXXX;DE53701205000021551069;1
70120500;51272914;FMBKDEMMXXX;DE65701205000051272914;1
70120500;15689679;FMBKDEMMXXX;DE46701205000015689679;1
70120500;216804524;FMBKDEMMXXX;DE68701205000216804524;1
70120500;702912512;FMBKDEMMXXX;DE65701205000702912512;1
70120500;178934017;FMBKDEMMXXX;DE82701205000178934017;1
70120500;820908204;FMBKDEMMXXX;DE95701205000820908204;1
70120500;817883829;FMBKDEMMXXX;DE31701205000817883829;1
70120500;403461744;FMBKDEMMXXX;DE29701205000403461744;1
70120500;450307516;FMBKDEMMXXX;DE50701205000450307516;1
70120500;433815054;FMBKDEMMXXX;DE79701205000433815054;1
70120500;428773574;FMBKDEMMXXX;DE36701205000428773574;1
70120500;435979595;FMBKDEMMXXX;DE69701205000435979595;1
20690500;3199493756;GENODEF1S11;DE48206905003199493756;1
20690500;9999688786;GENODEF1S11;DE62206905009999688786;1
20690500;1699300796;GENODEF1S11;DE20206905001699300796;1
20690500;7999754304;GENODEF1S11;DE58206905007999754304;1
20690500;6599651203;GENODEF1S11;DE45206905006599651203;1
20690500;9157870655;GENODEF1S11;DE32206905009157870655;1
20690500;4013420299;GENODEF1S11;DE68206905004013420299;1
20690500;5780726753;GENODEF1S11;DE24206905005780726753;1
20690500;8467165951;GENODEF1S11;DE70206905008467165951;1
20690500;7931649140;GENODEF1S11;DE10206905007931649140;1
20690500;9193151093;GENODEF1S11;DE22206905009193151093;1
20690500;2750538731;GENODEF1S11;DE12206905002750538731;1
20690500;1676017064;GENODEF1S11;DE98206905001676017064;1
20690500;9645766362;GENODEF1S11;DE77206905009645766362;1
20690500;8173309932;GENODEF1S11;DE08206905008173309932;1
20690500;8315803178;GENODEF1S11;DE59206905008315803178;1
20690500;2734965090;GENODEF1S11;DE12206905002734965090;1
20690500;8745618280;GENODEF1S11;DE40206905008745618280;1
20690500;9544525777;GENODEF1S11;DE79206905009544525777;1
22151730;2671061900;NOLADE21WED;DE91221517302671061900;1
22151730;2257490975;NOLADE21WED;DE09221517302257490975;1
22151730;5235721950;NOLADE21WED;DE03221517305235721950;1
22151730;5442076473;NOLADE21WED;DE18221517305442076473;1
22151730;1771201134;NOLADE21WED;DE97221517301771201134;1
22151730;9362082403;NOLADE21WED;DE92221517309362082403;1
22151730;7869946567;NOLADE21WED;DE04221517307869946567;1
22151730;1849431825;NOLADE21WED;DE81221517301849431825;1
22151730;3773732996;NOLADE21WED;DE95221517303773732996;1
22151730;9788834477;NOLADE21WED;DE17221517309788834477;1
22151730;8871052614;NOLADE21WED;DE80221517308871052614;1
22151730;2631891783;NOLADE21WED;DE19221517302631891783;1
22151730;8963436792;NOLADE21WED;DE25221517308963436792;1
22151730;5630397827;NOLADE21WED;DE22221517305630397827;1
22151730;5757328507;NOLADE21WED;DE02221517305757328507;1
57020500;6171606350;OYAKDE5KXXX;DE80570205006171606350;1
57020500;7338594529;OYAKDE5KXXX;DE64570205007338594529;1
57020500;7882094985;OYAKDE5KXXX;DE56570205007882094985;1
57020500;5509685007;OYAKDE5KXXX;DE82570205005509685007;1
57020500;8284237469;OYAKDE5KXXX;DE84570205008284237469;1
27020000;9234435411;VOWADE2BXXX;DE23270200009234435411;1
27020001;7143427644;AUDFDE21XXX;DE37270200017143427644;1
27020003;1996640981;SKODDE21XXX;DE71270200031996640981;1
27020004;8452940680;ECBKDE21XXX;DE86270200048452940680;1
27020800;16227940;SEATDE21XXX;DE10270208000016227940;1
27020000;78510920;VOWADE2BXXX;DE83270200000078510920;1
27020000;51156727;VOWADE2BXXX;DE56270200000051156727;1
27020001;52582433;AUDFDE21XXX;DE91270200010052582433;1
27020003;33492187;SKODDE21XXX;DE46270200030033492187;1
50120383;6705857941;DELBDE33XXX;DE14501203836705857941;1
50120383;8707046093;DELBDE33XXX;DE48501203838707046093;1
50120383;5825982965;DELBDE33XXX;DE25501203835825982965;1
50120383;4581710138;DELBDE33XXX;DE03501203834581710138;1
50120383;7561827077;DELBDE33XXX;DE89501203837561827077;1
50120383;1717089876;DELBDE33XXX;DE55501203831717089876;1
20120400;4397218186;DRBKDEH1XXX;DE81201204004397218186;1
20120400;8301732521;DRBKDEH1XXX;DE05201204008301732521;1
20120400;4660747523;DRBKDEH1XXX;DE04201204004660747523;1
20120400;7002619599;DRBKDEH1XXX;DE52201204007002619599;1
20120400;9968066963;DRBKDEH1XXX;DE18201204009968066963;1
50131000;766196436;ICBVDEFFXXX;DE60501310000766196436;1
50131000;431434427;ICBVDEFFXXX;DE37501310000431434427;1
50131000;354064493;ICBVDEFFXXX;DE38501310000354064493;1
50131000;123074981;ICBVDEFFXXX;DE12501310000123074981;1
50131000;698389690;ICBVDEFFXXX;DE31501310000698389690;1
