# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl iban_gen.t'

use Test::More tests => 347;

BEGIN { use_ok('Business::KontoCheck') };

$ok_cnt=1;
$nok_cnt=0;
$retval=lut_init("blz.lut",9);
$ret_txt=$kto_retval{$retval};
if($retval gt 0){$ok_cnt++;}else{$nok_cnt++;}
ok($retval gt 0,"lut_init(): $retval => $ret_txt (ok: $ok_cnt, nok: $nok_cnt)");

if($retval gt 0){
   while(<DATA>){
      chomp;
      ($ret,$bic,$cnt)=split(/;/);
      $retval=Business::KontoCheck::bic_check($bic,$cnt1);
      if($ret==$retval && $cnt1==$cnt){$ok_cnt++;}else{$nok_cnt++;}
      ok($ret==$retval && $cnt1==$cnt,"bic_check($bic,\$cnt): [$ret / $retval],  [$cnt / $cnt1] (ok: $ok_cnt, nok: $nok_cnt)");
   }
}

__DATA__
1;AARBDE5W100;1
1;AARBDE5W108;1
1;AARBDE5W;13
1;AARBDE5W200;1
1;ABKBDEB1;1
1;ABKBDEB1XXX;1
1;AUGBDE77;1
1;AUGBDE77XXX;1
1;BARCDEHA;1
1;BARCDEHAXXX;1
1;BBKRDE6B;1
1;BBKRDE6BXXX;1
1;BEGODEHH;1
1;BEGODEHHXXX;1
1;BELADEBE;1
1;BELADEBEXXX;1
1;BEVODEBB;1
1;BEVODEBBXXX;1
1;BFSWDE33;16
1;BFSWDE33BER;3
1;BFSWDE33XXX;1
1;BHFBDEFF500;1
1;BHFBDEFF;9
1;BHYPDEB2;1
1;BHYPDEB2XXX;1
1;BIWBDE33;3
1;BIWBDE33XXX;1
1;BKCHDEFF;2
1;BKCHDEFFHMB;1
1;BOTKDEDX;1
1;BOTKDEDXXXX;1
1;BRLADE21CUX;1
1;BRLADE21DHZ;1
1;BRLADE21ROB;1
1;BYLADEM1001;1
1;BYLADEM1;76
1;BYLADEM1DGF;1
1;BYLADEM1MIB;1
1;BYLADEM1MLM;1
1;BYLADEM1WOR;1
1;CHDBDEHH;2
1;CHDBDEHHXXX;2
1;CKVHDE21;1
1;CKVHDE21XXX;1
1;CMCIDEDD;1
1;CMCIDEDDXXX;1
1;COBADEF1;1
1;COBADEF1BRS;1
0;COBADEFFINT;0
1;COBADEHD001;1
1;COBADEHD044;1
1;COBADEHD055;1
1;COBADEHD;4
1;COBADEHDXXX;1
1;COKSDE33;1
1;COKSDE33XXX;1
1;COLSDE33;2
1;COLSDE33XXX;1
1;DAAEDEDD;1
1;DAAEDEDDXXX;1
1;DABADEHH;1
1;DABADEHHXXX;1
1;DEGUDEFF;1
1;DEGUDEFFXXX;1
1;DEHYDE2H;1
1;DEHYDE2HXXX;1
1;DELBDE33;1
1;DELBDE33XXX;1
1;DEUTDE2H240;1
1;DEUTDE2H251;1
1;DEUTDE2H254;1
1;DEUTDE2H256;1
1;DEUTDE2H257;1
1;DEUTDE2H258;1
1;DEUTDE2H264;1
1;DEUTDE2H265;1
1;DEUTDE2H;36
1;DEUTDE2HXXX;1
1;DEUTDE5M;23
1;DEUTDE5M585;1
1;DEUTDEBB101;1
1;DEUTDEBB160;1
1;DEUTDEBB;63
1;DEUTDEBBXXX;1
1;DEUTDEBR;9
1;DEUTDEBRXXX;1
1;DEUTDEDB101;1
1;DEUTDEDB110;1
1;DEUTDEDB160;1
1;DEUTDEDB210;1
1;DEUTDEDB212;1
1;DEUTDEDB215;1
1;DEUTDEDB217;1
1;DEUTDEDB237;1
1;DEUTDEDB240;1
1;DEUTDEDB254;1
1;DEUTDEDB257;1
1;DEUTDEDB264;1
1;DEUTDEDB450;1
1;DEUTDEDB545;1
1;DEUTDEDB;703
1;DEUTDEDBBER;1
1;DEUTDEDBHAM;1
1;DEUTDEDBHAN;1
1;DEUTDEDBKOE;1
1;DEUTDEDBMAN;1
1;DEUTDEDBMUC;1
1;DEUTDEDBPAL;1
1;DEUTDEDBROS;1
1;DEUTDEDBXXX;1
1;DEUTDEFF;44
1;DEUTDEFFVAC;1
1;DEUTDEFFXXX;1
1;DEUTDEHH210;1
1;DEUTDEHH212;1
1;DEUTDEHH215;1
1;DEUTDEHH217;1
1;DEUTDEHH;22
1;DEUTDEHH222;1
1;DEUTDEHHXXX;1
1;DEUTDEMM;56
1;DEUTDEMMXXX;1
1;DEUTDESM;32
1;DEUTDESM672;1
1;DEUTDESMXXX;1
1;DGHYDEH1;1
1;DGHYDEH1XXX;1
1;DGZFDEFF;2
1;DGZFDEFFBER;1
1;DLGHDEB1;2
1;DLGHDEB1XXX;2
1;DNBADEHX;1
1;DNBADEHXXXX;1
1;DRBKDEH1;1
1;DRBKDEH1XXX;1
1;DRESDEFF100;1
1;DRESDEFF112;1
1;DRESDEFF114;1
1;DRESDEFF120;1
1;DRESDEFF130;1
1;DRESDEFF140;1
1;DRESDEFF150;1
1;DRESDEFF160;1
1;DRESDEFF170;1
1;DRESDEFF180;1
1;DRESDEFF199;1
1;DRESDEFF200;1
1;DRESDEFF201;1
1;DRESDEFF206;1
1;DRESDEFF207;1
1;DRESDEFF208;1
1;DRESDEFF210;1
1;DRESDEFF212;1
1;DRESDEFF214;1
1;DRESDEFF215;1
1;DRESDEFF221;1
1;DRESDEFF230;1
1;DRESDEFF240;1
1;DRESDEFF241;1
1;DRESDEFF242;1
1;DRESDEFF250;1
1;DRESDEFF254;1
1;DRESDEFF257;1
1;DRESDEFF259;1
1;DRESDEFF260;1
1;DRESDEFF262;1
1;DRESDEFF265;1
1;DRESDEFF268;1
1;DRESDEFF269;1
1;DRESDEFF282;1
1;DRESDEFF290;1
1;DRESDEFF292;1
1;DRESDEFF;297
1;DRESDEFF300;1
1;DRESDEFF309;1
1;DRESDEFF310;1
1;DRESDEFF316;1
1;DRESDEFF320;1
1;DRESDEFF332;1
1;DRESDEFF340;1
1;DRESDEFF342;1
1;DRESDEFF360;1
1;DRESDEFF362;1
1;DRESDEFF365;1
1;DRESDEFF370;1
1;DRESDEFF390;1
1;DRESDEFF400;1
1;DRESDEFF413;1
1;DRESDEFF420;1
1;DRESDEFF426;1
1;DRESDEFF430;1
1;DRESDEFF440;1
1;DRESDEFF445;1
1;DRESDEFF446;1
1;DRESDEFF447;1
1;DRESDEFF450;1
1;DRESDEFF460;1
1;DRESDEFF478;1
1;DRESDEFF491;1
1;DRESDEFF506;1
1;DRESDEFF508;1
1;DRESDEFF510;1
1;DRESDEFF513;1
1;DRESDEFF516;1
1;DRESDEFF520;1
1;DRESDEFF522;1
1;DRESDEFF524;1
1;DRESDEFF530;1
1;DRESDEFF540;1
1;DRESDEFF542;1
1;DRESDEFF545;1
1;DRESDEFF546;1
1;DRESDEFF550;1
1;DRESDEFF570;1
1;DRESDEFF585;1
1;DRESDEFF590;1
1;DRESDEFF600;1
1;DRESDEFF601;1
1;DRESDEFF604;1
1;DRESDEFF608;1
1;DRESDEFF609;1
1;DRESDEFF610;1
1;DRESDEFF612;1
1;DRESDEFF614;1
1;DRESDEFF620;1
1;DRESDEFF622;1
1;DRESDEFF630;1
1;DRESDEFF640;1
1;DRESDEFF643;1
1;DRESDEFF650;1
1;DRESDEFF651;1
1;DRESDEFF653;1
1;DRESDEFF662;1
1;DRESDEFF666;1
1;DRESDEFF670;1
1;DRESDEFF672;1
1;DRESDEFF680;1
1;DRESDEFF692;1
1;DRESDEFF700;1
1;DRESDEFF703;1
1;DRESDEFF711;1
1;DRESDEFF714;1
1;DRESDEFF721;1
1;DRESDEFF724;1
1;DRESDEFF731;1
1;DRESDEFF733;1
1;DRESDEFF734;1
1;DRESDEFF741;1
1;DRESDEFF743;1
1;DRESDEFF750;1
1;DRESDEFF760;1
1;DRESDEFF790;1
1;DRESDEFF793;1
1;DRESDEFF795;1
1;DRESDEFF800;1
1;DRESDEFF810;1
1;DRESDEFF827;1
1;DRESDEFF830;1
1;DRESDEFF843;1
1;DRESDEFF850;1
1;DRESDEFF857;1
1;DRESDEFF860;1
1;DRESDEFF862;1
1;DRESDEFF867;1
1;DRESDEFF870;1
1;DRESDEFFAGI;1
1;DRESDEFFAVB;1
1;DRESDEFFI01;1
1;DRESDEFFI06;1
1;DRESDEFFI14;1
1;DRESDEFFI26;1
1;DRESDEFFI27;1
1;DRESDEFFI53;1
1;DRESDEFFI56;1
1;DRESDEFFI63;1
1;DRESDEFFI64;1
1;DRESDEFFI71;1
1;DRESDEFFI72;1
1;DRESDEFFI73;1
1;DRESDEFFI74;1
1;DRESDEFFI75;1
1;DRESDEFFI99;1
1;DRESDEFFJ33;1
1;DRESDEFFJ34;1
1;DRESDEFFJ35;1
1;DRESDEFFJ36;1
1;DRESDEFFJ37;1
1;DRESDEFFXXX;10
1;DXIADEBB;1
1;DXIADEBBXXX;1
1;EDEKDEHH;2
1;EDEKDEHHXXX;2
1;ESSEDE5F100;1
1;ESSEDE5F130;1
1;ESSEDE5F200;1
1;ESSEDE5F210;1
1;ESSEDE5F230;1
1;ESSEDE5F250;1
1;ESSEDEFF;2
1;ESSEDEFFHAM;1
1;FFVBDEFF;1
1;FFVBDEFFXXX;1
1;FRSPDE66;1
1;FRSPDE66XXX;1
1;GENODE51LIM;1
1;GENODE61BBB;1
1;GENODE61LBS;1
1;GENODE61MA2;1
1;GENODE61MA3;1
1;GENODE61SPE;1
1;GENODE61SUW;1
1;GENODE61WIE;1
1;GENODE61WNM;1
1;GENODE61WO1;1
1;GENODED1AAC;1
1;GENODED1AEZ;1
1;GENODED1BBE;1
1;GENODED1BMU;1
1;GENODED1BRS;1
1;GENODED1CGN;1
1;GENODED1DKD;1
1;GENODED1HTK;1
1;GENODED1KDB;1
1;GENODED1PAX;1
1;GENODEF1815;1
1;GENODEF1ANK;1
1;GENODEF1AOE;1
1;GENODEF1APE;1
1;GENODEF1AST;1
1;GENODEF1BAR;1
1;GENODEF1BBR;1
1;GENODEF1BCH;1
1;GENODEF1BCK;1
1;GENODEF1BDS;1
1;GENODEF1BKW;1
1;GENODEF1BNT;1
1;GENODEF1BOO;1
1;GENODEF1BRB;1
1;GENODEF1BSB;1
1;GENODEF1CLZ;1
1;GENODEF1COP;1
1;GENODEF1DAB;1
1;GENODEF1DAN;1
1;GENODEF1DES;1
1;GENODEF1DM1;1
