#!/usr/bin/perl
use strict;
use warnings;

use Test::More tests => 5;
BEGIN { use_ok('Audio::Opusfile') };

my $fail = 0;
foreach my $constname (qw(
	OPUS_CHANNEL_COUNT_MAX OP_ABSOLUTE_GAIN OP_DEC_FORMAT_FLOAT
	OP_DEC_FORMAT_SHORT OP_DEC_USE_DEFAULT OP_EBADHEADER OP_EBADLINK
	OP_EBADPACKET OP_EBADTIMESTAMP OP_EFAULT OP_EIMPL OP_EINVAL OP_ENOSEEK
	OP_ENOTAUDIO OP_ENOTFORMAT OP_EOF OP_EREAD OP_EVERSION OP_FALSE
	OP_GET_SERVER_INFO_REQUEST OP_HEADER_GAIN OP_HOLE
	OP_HTTP_PROXY_HOST_REQUEST OP_HTTP_PROXY_PASS_REQUEST
	OP_HTTP_PROXY_PORT_REQUEST OP_HTTP_PROXY_USER_REQUEST OP_PIC_FORMAT_GIF
	OP_PIC_FORMAT_JPEG OP_PIC_FORMAT_PNG OP_PIC_FORMAT_UNKNOWN
	OP_PIC_FORMAT_URL OP_SSL_SKIP_CERTIFICATE_CHECK_REQUEST OP_TRACK_GAIN)) {
  next if (eval "my \$a = $constname; 1");
  if ($@ =~ /^Your vendor has not defined Audio::Opusfile macro $constname/) {
    print "# pass: $@";
  } else {
    print "# fail: $@";
    $fail = 1;
  }

}

ok( $fail == 0 , 'Constants' );

my $of = Audio::Opusfile->new_from_file('empty.opus');
my $tags = $of->tags;
is $tags->query_count('TITLE'), 1, 'query_count';
is $tags->query('TITLE'), 'Cellule', 'query';
is_deeply [$tags->query_all('TITLE')], ['Cellule'], 'query_all';
