#!/usr/bin/perl -wT
use v5.14;
use warnings;

use Test::More tests => 3;

use File::Temp qw/tempfile/;

my $file;

BEGIN {
  $file = (tempfile UNLINK => 1)[1];
  @ARGV = (-cache => $file, sort <empty*>);
}
BEGIN { use_ok('App::MusicExpo'); }

close STDOUT;
my $out;
open STDOUT, '>', \$out;

App::MusicExpo->run;

is $out, <<'OUT', 'output is correct';
<!DOCTYPE html>
<title>Music</title>
<meta charset="utf-8">
<link rel="stylesheet" href="musicexpo.css">
<script async defer type="application/javascript" src="player.js"></script>

<div id="player"></div>

<table border>
<thead>
<tr><th>Title<th>Artist<th>Album<th>Genre<th>Track<th>Year<th>Type
<tbody>
<tr><td class="title"><a href="#silence-cellule" data-hash="#silence-cellule">Cellule</a><td class="artist">Silence<td class="album">L&#39;autre endroit<td class="genre">Electro<td class="track">01/09<td class="year">2005<td class="formats"><a href="/music/empty.flac">FLAC</a> <a href="/music/empty.ogg">Vorbis</a> 
<tr><td class="title"><a href="#silence-cellule" data-hash="#silence-cellule">Cellule</a><td class="artist">Silence<td class="album">L&#39;autre endroit<td class="genre">Electro<td class="track">01/09<td class="year">2005<td class="formats"><a href="/music/empty3.mp3">MP3</a> 
<tr><td class="title"><a href="#silence-cellule" data-hash="#silence-cellule">Cellule</a><td class="artist">Silence<td class="album">L&#39;autre endroit<td class="genre">Electro<td class="track">1/9<td class="year">2005<td class="formats"><a href="/music/empty4.aac">AAC</a> 
</table>
OUT

ok -e $file, 'cache exists';
