package SVG::Rasterize::Specification::Shape;
use strict;
use warnings;

use Params::Validate qw(:types);

use SVG::Rasterize::Regexes qw(:attributes);

# $Id: Shape.pm 6484 2011-04-21 09:25:12Z powergnom $

=head1 NAME

C<SVG::Rasterize::Specification::Shape> - specification for class Shape

=head1 VERSION

Version 0.003005

=cut

our $VERSION = '0.003005';

our %CHILDREN = ('circle'   => {'animate'          => 1,
                                'animateColor'     => 1,
                                'animateMotion'    => 1,
                                'animateTransform' => 1,
                                'desc'             => 1,
                                'metadata'         => 1,
                                'set'              => 1,
                                'title'            => 1},
                 'ellipse'  => {'animate'          => 1,
                                'animateColor'     => 1,
                                'animateMotion'    => 1,
                                'animateTransform' => 1,
                                'desc'             => 1,
                                'metadata'         => 1,
                                'set'              => 1,
                                'title'            => 1},
                 'line'     => {'animate'          => 1,
                                'animateColor'     => 1,
                                'animateMotion'    => 1,
                                'animateTransform' => 1,
                                'desc'             => 1,
                                'metadata'         => 1,
                                'set'              => 1,
                                'title'            => 1},
                 'path'     => {'animate'          => 1,
                                'animateColor'     => 1,
                                'animateMotion'    => 1,
                                'animateTransform' => 1,
                                'desc'             => 1,
                                'metadata'         => 1,
                                'set'              => 1,
                                'title'            => 1},
                 'polygon'  => {'animate'          => 1,
                                'animateColor'     => 1,
                                'animateMotion'    => 1,
                                'animateTransform' => 1,
                                'desc'             => 1,
                                'metadata'         => 1,
                                'set'              => 1,
                                'title'            => 1},
                 'polyline' => {'animate'          => 1,
                                'animateColor'     => 1,
                                'animateMotion'    => 1,
                                'animateTransform' => 1,
                                'desc'             => 1,
                                'metadata'         => 1,
                                'set'              => 1,
                                'title'            => 1},
                 'rect'     => {'animate'          => 1,
                                'animateColor'     => 1,
                                'animateMotion'    => 1,
                                'animateTransform' => 1,
                                'desc'             => 1,
                                'metadata'         => 1,
                                'set'              => 1,
                                'title'            => 1});

our %ATTR_VAL = ('circle'   => {'class'                     => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'clip-path'                 => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'clip-rule'                 => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:nonzero|evenodd|inherit)$/},
                                'color'                     => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => $RE_PAINT{p_COLOR}},
                                'color-interpolation'       => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:auto|sRGB|linearRGB|inherit)$/},
                                'color-rendering'           => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:auto|optimizeSpeed|optimizeQuality|inherit)$/},
                                'cursor'                    => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'cx'                        => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => $RE_LENGTH{p_A_LENGTH}},
                                'cy'                        => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => $RE_LENGTH{p_A_LENGTH}},
                                'display'                   => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:inline|block|list\-item|run\-in|compact|marker|table|inline\-table|table\-row\-group|table\-header\-group|table\-footer\-group|table\-row|table\-column\-group|table\-column|table\-cell|table\-caption|none|inherit)$/},
                                'externalResourcesRequired' => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:false|true)$/},
                                'fill'                      => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => $RE_PAINT{p_PAINT}},
                                'fill-opacity'              => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                                'fill-rule'                 => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:nonzero|evenodd|inherit)$/},
                                'filter'                    => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'id'                        => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => $RE_XML{p_NAME}},
                                'image-rendering'           => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:auto|optimizeSpeed|optimizeQuality|inherit)$/},
                                'mask'                      => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'onactivate'                => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'onclick'                   => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'onfocusin'                 => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'onfocusout'                => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'onload'                    => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'onmousedown'               => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'onmousemove'               => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'onmouseout'                => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'onmouseover'               => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'onmouseup'                 => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'opacity'                   => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                                'pointer-events'            => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:visiblePainted|visibleFill|visibleStroke|visible|painted|fill|stroke|all|none|inherit)$/},
                                'r'                         => {'optional' => 0,
                                                                'type'     => SCALAR,
                                                                'regex'    => $RE_LENGTH{p_A_LENGTH}},
                                'requiredExtensions'        => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'requiredFeatures'          => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'shape-rendering'           => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:auto|optimizeSpeed|crispEdges|geometricPrecision|inherit)$/},
                                'stroke'                    => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => $RE_PAINT{p_PAINT}},
                                'stroke-dasharray'          => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/$RE_DASHARRAY{p_DASHARRAY}|^inherit$|^none$/},
                                'stroke-dashoffset'         => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/$RE_LENGTH{p_A_LENGTH}|^inherit$/},
                                'stroke-linecap'            => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:butt|round|square|inherit)$/},
                                'stroke-linejoin'           => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:miter|round|bevel|inherit)$/},
                                'stroke-miterlimit'         => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/$RE_NUMBER{p_A_NNNUMBER}|^inherit$/},
                                'stroke-opacity'            => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                                'stroke-width'              => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/$RE_LENGTH{p_A_LENGTH}|^inherit$/},
                                'style'                     => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'systemLanguage'            => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'text-rendering'            => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:auto|optimizeSpeed|optimizeLegibility|geometricPrecision|inherit)$/},
                                'transform'                 => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => $RE_TRANSFORM{p_TRANSFORM_LIST}},
                                'visibility'                => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:visible|hidden|inherit)$/},
                                'xml:base'                  => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'xml:lang'                  => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => $RE_XML{p_NMTOKEN}},
                                'xml:space'                 => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:default|preserve)$/}},
                 'ellipse'  => {'class'                     => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'clip-path'                 => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'clip-rule'                 => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:nonzero|evenodd|inherit)$/},
                                'color'                     => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => $RE_PAINT{p_COLOR}},
                                'color-interpolation'       => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:auto|sRGB|linearRGB|inherit)$/},
                                'color-rendering'           => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:auto|optimizeSpeed|optimizeQuality|inherit)$/},
                                'cursor'                    => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'cx'                        => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => $RE_LENGTH{p_A_LENGTH}},
                                'cy'                        => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => $RE_LENGTH{p_A_LENGTH}},
                                'display'                   => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:inline|block|list\-item|run\-in|compact|marker|table|inline\-table|table\-row\-group|table\-header\-group|table\-footer\-group|table\-row|table\-column\-group|table\-column|table\-cell|table\-caption|none|inherit)$/},
                                'externalResourcesRequired' => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:false|true)$/},
                                'fill'                      => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => $RE_PAINT{p_PAINT}},
                                'fill-opacity'              => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                                'fill-rule'                 => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:nonzero|evenodd|inherit)$/},
                                'filter'                    => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'id'                        => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => $RE_XML{p_NAME}},
                                'image-rendering'           => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:auto|optimizeSpeed|optimizeQuality|inherit)$/},
                                'mask'                      => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'onactivate'                => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'onclick'                   => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'onfocusin'                 => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'onfocusout'                => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'onload'                    => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'onmousedown'               => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'onmousemove'               => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'onmouseout'                => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'onmouseover'               => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'onmouseup'                 => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'opacity'                   => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                                'pointer-events'            => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:visiblePainted|visibleFill|visibleStroke|visible|painted|fill|stroke|all|none|inherit)$/},
                                'requiredExtensions'        => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'requiredFeatures'          => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'rx'                        => {'optional' => 0,
                                                                'type'     => SCALAR,
                                                                'regex'    => $RE_LENGTH{p_A_LENGTH}},
                                'ry'                        => {'optional' => 0,
                                                                'type'     => SCALAR,
                                                                'regex'    => $RE_LENGTH{p_A_LENGTH}},
                                'shape-rendering'           => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:auto|optimizeSpeed|crispEdges|geometricPrecision|inherit)$/},
                                'stroke'                    => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => $RE_PAINT{p_PAINT}},
                                'stroke-dasharray'          => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/$RE_DASHARRAY{p_DASHARRAY}|^inherit$|^none$/},
                                'stroke-dashoffset'         => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/$RE_LENGTH{p_A_LENGTH}|^inherit$/},
                                'stroke-linecap'            => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:butt|round|square|inherit)$/},
                                'stroke-linejoin'           => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:miter|round|bevel|inherit)$/},
                                'stroke-miterlimit'         => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/$RE_NUMBER{p_A_NNNUMBER}|^inherit$/},
                                'stroke-opacity'            => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                                'stroke-width'              => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/$RE_LENGTH{p_A_LENGTH}|^inherit$/},
                                'style'                     => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'systemLanguage'            => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'text-rendering'            => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:auto|optimizeSpeed|optimizeLegibility|geometricPrecision|inherit)$/},
                                'transform'                 => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => $RE_TRANSFORM{p_TRANSFORM_LIST}},
                                'visibility'                => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:visible|hidden|inherit)$/},
                                'xml:base'                  => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'xml:lang'                  => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => $RE_XML{p_NMTOKEN}},
                                'xml:space'                 => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:default|preserve)$/}},
                 'line'     => {'class'                     => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'clip-path'                 => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'clip-rule'                 => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:nonzero|evenodd|inherit)$/},
                                'color'                     => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => $RE_PAINT{p_COLOR}},
                                'color-interpolation'       => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:auto|sRGB|linearRGB|inherit)$/},
                                'color-rendering'           => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:auto|optimizeSpeed|optimizeQuality|inherit)$/},
                                'cursor'                    => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'display'                   => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:inline|block|list\-item|run\-in|compact|marker|table|inline\-table|table\-row\-group|table\-header\-group|table\-footer\-group|table\-row|table\-column\-group|table\-column|table\-cell|table\-caption|none|inherit)$/},
                                'externalResourcesRequired' => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:false|true)$/},
                                'fill'                      => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => $RE_PAINT{p_PAINT}},
                                'fill-opacity'              => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                                'fill-rule'                 => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:nonzero|evenodd|inherit)$/},
                                'filter'                    => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'id'                        => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => $RE_XML{p_NAME}},
                                'image-rendering'           => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:auto|optimizeSpeed|optimizeQuality|inherit)$/},
                                'marker-end'                => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'marker-mid'                => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'marker-start'              => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'mask'                      => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'onactivate'                => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'onclick'                   => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'onfocusin'                 => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'onfocusout'                => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'onload'                    => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'onmousedown'               => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'onmousemove'               => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'onmouseout'                => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'onmouseover'               => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'onmouseup'                 => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'opacity'                   => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                                'pointer-events'            => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:visiblePainted|visibleFill|visibleStroke|visible|painted|fill|stroke|all|none|inherit)$/},
                                'requiredExtensions'        => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'requiredFeatures'          => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'shape-rendering'           => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:auto|optimizeSpeed|crispEdges|geometricPrecision|inherit)$/},
                                'stroke'                    => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => $RE_PAINT{p_PAINT}},
                                'stroke-dasharray'          => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/$RE_DASHARRAY{p_DASHARRAY}|^inherit$|^none$/},
                                'stroke-dashoffset'         => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/$RE_LENGTH{p_A_LENGTH}|^inherit$/},
                                'stroke-linecap'            => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:butt|round|square|inherit)$/},
                                'stroke-linejoin'           => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:miter|round|bevel|inherit)$/},
                                'stroke-miterlimit'         => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/$RE_NUMBER{p_A_NNNUMBER}|^inherit$/},
                                'stroke-opacity'            => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                                'stroke-width'              => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/$RE_LENGTH{p_A_LENGTH}|^inherit$/},
                                'style'                     => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'systemLanguage'            => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'text-rendering'            => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:auto|optimizeSpeed|optimizeLegibility|geometricPrecision|inherit)$/},
                                'transform'                 => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => $RE_TRANSFORM{p_TRANSFORM_LIST}},
                                'visibility'                => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:visible|hidden|inherit)$/},
                                'x1'                        => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => $RE_LENGTH{p_A_LENGTH}},
                                'x2'                        => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => $RE_LENGTH{p_A_LENGTH}},
                                'xml:base'                  => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'xml:lang'                  => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => $RE_XML{p_NMTOKEN}},
                                'xml:space'                 => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:default|preserve)$/},
                                'y1'                        => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => $RE_LENGTH{p_A_LENGTH}},
                                'y2'                        => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => $RE_LENGTH{p_A_LENGTH}}},
                 'path'     => {'class'                     => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'clip-path'                 => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'clip-rule'                 => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:nonzero|evenodd|inherit)$/},
                                'color'                     => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => $RE_PAINT{p_COLOR}},
                                'color-interpolation'       => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:auto|sRGB|linearRGB|inherit)$/},
                                'color-rendering'           => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:auto|optimizeSpeed|optimizeQuality|inherit)$/},
                                'cursor'                    => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'd'                         => {'optional' => 0,
                                                                'type'     => SCALAR,
                                                                'regex'    => $RE_PATH{s_PATH_LIST}},
                                'display'                   => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:inline|block|list\-item|run\-in|compact|marker|table|inline\-table|table\-row\-group|table\-header\-group|table\-footer\-group|table\-row|table\-column\-group|table\-column|table\-cell|table\-caption|none|inherit)$/},
                                'externalResourcesRequired' => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:false|true)$/},
                                'fill'                      => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => $RE_PAINT{p_PAINT}},
                                'fill-opacity'              => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                                'fill-rule'                 => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:nonzero|evenodd|inherit)$/},
                                'filter'                    => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'id'                        => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => $RE_XML{p_NAME}},
                                'image-rendering'           => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:auto|optimizeSpeed|optimizeQuality|inherit)$/},
                                'marker-end'                => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'marker-mid'                => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'marker-start'              => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'mask'                      => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'onactivate'                => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'onclick'                   => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'onfocusin'                 => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'onfocusout'                => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'onload'                    => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'onmousedown'               => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'onmousemove'               => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'onmouseout'                => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'onmouseover'               => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'onmouseup'                 => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'opacity'                   => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                                'pathLength'                => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => $RE_NUMBER{p_A_NUMBER}},
                                'pointer-events'            => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:visiblePainted|visibleFill|visibleStroke|visible|painted|fill|stroke|all|none|inherit)$/},
                                'requiredExtensions'        => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'requiredFeatures'          => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'shape-rendering'           => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:auto|optimizeSpeed|crispEdges|geometricPrecision|inherit)$/},
                                'stroke'                    => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => $RE_PAINT{p_PAINT}},
                                'stroke-dasharray'          => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/$RE_DASHARRAY{p_DASHARRAY}|^inherit$|^none$/},
                                'stroke-dashoffset'         => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/$RE_LENGTH{p_A_LENGTH}|^inherit$/},
                                'stroke-linecap'            => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:butt|round|square|inherit)$/},
                                'stroke-linejoin'           => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:miter|round|bevel|inherit)$/},
                                'stroke-miterlimit'         => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/$RE_NUMBER{p_A_NNNUMBER}|^inherit$/},
                                'stroke-opacity'            => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                                'stroke-width'              => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/$RE_LENGTH{p_A_LENGTH}|^inherit$/},
                                'style'                     => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'systemLanguage'            => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'text-rendering'            => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:auto|optimizeSpeed|optimizeLegibility|geometricPrecision|inherit)$/},
                                'transform'                 => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => $RE_TRANSFORM{p_TRANSFORM_LIST}},
                                'visibility'                => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:visible|hidden|inherit)$/},
                                'xml:base'                  => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'xml:lang'                  => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => $RE_XML{p_NMTOKEN}},
                                'xml:space'                 => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:default|preserve)$/}},
                 'polygon'  => {'class'                     => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'clip-path'                 => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'clip-rule'                 => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:nonzero|evenodd|inherit)$/},
                                'color'                     => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => $RE_PAINT{p_COLOR}},
                                'color-interpolation'       => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:auto|sRGB|linearRGB|inherit)$/},
                                'color-rendering'           => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:auto|optimizeSpeed|optimizeQuality|inherit)$/},
                                'cursor'                    => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'display'                   => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:inline|block|list\-item|run\-in|compact|marker|table|inline\-table|table\-row\-group|table\-header\-group|table\-footer\-group|table\-row|table\-column\-group|table\-column|table\-cell|table\-caption|none|inherit)$/},
                                'externalResourcesRequired' => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:false|true)$/},
                                'fill'                      => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => $RE_PAINT{p_PAINT}},
                                'fill-opacity'              => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                                'fill-rule'                 => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:nonzero|evenodd|inherit)$/},
                                'filter'                    => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'id'                        => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => $RE_XML{p_NAME}},
                                'image-rendering'           => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:auto|optimizeSpeed|optimizeQuality|inherit)$/},
                                'marker-end'                => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'marker-mid'                => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'marker-start'              => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'mask'                      => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'onactivate'                => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'onclick'                   => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'onfocusin'                 => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'onfocusout'                => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'onload'                    => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'onmousedown'               => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'onmousemove'               => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'onmouseout'                => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'onmouseover'               => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'onmouseup'                 => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'opacity'                   => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                                'pointer-events'            => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:visiblePainted|visibleFill|visibleStroke|visible|painted|fill|stroke|all|none|inherit)$/},
                                'points'                    => {'optional' => 0,
                                                                'type'     => SCALAR,
                                                                'regex'    => $RE_POLY{s_POINTS_LIST}},
                                'requiredExtensions'        => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'requiredFeatures'          => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'shape-rendering'           => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:auto|optimizeSpeed|crispEdges|geometricPrecision|inherit)$/},
                                'stroke'                    => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => $RE_PAINT{p_PAINT}},
                                'stroke-dasharray'          => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/$RE_DASHARRAY{p_DASHARRAY}|^inherit$|^none$/},
                                'stroke-dashoffset'         => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/$RE_LENGTH{p_A_LENGTH}|^inherit$/},
                                'stroke-linecap'            => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:butt|round|square|inherit)$/},
                                'stroke-linejoin'           => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:miter|round|bevel|inherit)$/},
                                'stroke-miterlimit'         => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/$RE_NUMBER{p_A_NNNUMBER}|^inherit$/},
                                'stroke-opacity'            => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                                'stroke-width'              => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/$RE_LENGTH{p_A_LENGTH}|^inherit$/},
                                'style'                     => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'systemLanguage'            => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'text-rendering'            => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:auto|optimizeSpeed|optimizeLegibility|geometricPrecision|inherit)$/},
                                'transform'                 => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => $RE_TRANSFORM{p_TRANSFORM_LIST}},
                                'visibility'                => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:visible|hidden|inherit)$/},
                                'xml:base'                  => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'xml:lang'                  => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => $RE_XML{p_NMTOKEN}},
                                'xml:space'                 => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:default|preserve)$/}},
                 'polyline' => {'class'                     => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'clip-path'                 => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'clip-rule'                 => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:nonzero|evenodd|inherit)$/},
                                'color'                     => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => $RE_PAINT{p_COLOR}},
                                'color-interpolation'       => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:auto|sRGB|linearRGB|inherit)$/},
                                'color-rendering'           => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:auto|optimizeSpeed|optimizeQuality|inherit)$/},
                                'cursor'                    => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'display'                   => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:inline|block|list\-item|run\-in|compact|marker|table|inline\-table|table\-row\-group|table\-header\-group|table\-footer\-group|table\-row|table\-column\-group|table\-column|table\-cell|table\-caption|none|inherit)$/},
                                'externalResourcesRequired' => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:false|true)$/},
                                'fill'                      => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => $RE_PAINT{p_PAINT}},
                                'fill-opacity'              => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                                'fill-rule'                 => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:nonzero|evenodd|inherit)$/},
                                'filter'                    => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'id'                        => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => $RE_XML{p_NAME}},
                                'image-rendering'           => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:auto|optimizeSpeed|optimizeQuality|inherit)$/},
                                'marker-end'                => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'marker-mid'                => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'marker-start'              => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'mask'                      => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'onactivate'                => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'onclick'                   => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'onfocusin'                 => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'onfocusout'                => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'onload'                    => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'onmousedown'               => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'onmousemove'               => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'onmouseout'                => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'onmouseover'               => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'onmouseup'                 => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'opacity'                   => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                                'pointer-events'            => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:visiblePainted|visibleFill|visibleStroke|visible|painted|fill|stroke|all|none|inherit)$/},
                                'points'                    => {'optional' => 0,
                                                                'type'     => SCALAR,
                                                                'regex'    => $RE_POLY{s_POINTS_LIST}},
                                'requiredExtensions'        => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'requiredFeatures'          => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'shape-rendering'           => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:auto|optimizeSpeed|crispEdges|geometricPrecision|inherit)$/},
                                'stroke'                    => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => $RE_PAINT{p_PAINT}},
                                'stroke-dasharray'          => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/$RE_DASHARRAY{p_DASHARRAY}|^inherit$|^none$/},
                                'stroke-dashoffset'         => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/$RE_LENGTH{p_A_LENGTH}|^inherit$/},
                                'stroke-linecap'            => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:butt|round|square|inherit)$/},
                                'stroke-linejoin'           => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:miter|round|bevel|inherit)$/},
                                'stroke-miterlimit'         => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/$RE_NUMBER{p_A_NNNUMBER}|^inherit$/},
                                'stroke-opacity'            => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                                'stroke-width'              => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/$RE_LENGTH{p_A_LENGTH}|^inherit$/},
                                'style'                     => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'systemLanguage'            => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'text-rendering'            => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:auto|optimizeSpeed|optimizeLegibility|geometricPrecision|inherit)$/},
                                'transform'                 => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => $RE_TRANSFORM{p_TRANSFORM_LIST}},
                                'visibility'                => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:visible|hidden|inherit)$/},
                                'xml:base'                  => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'xml:lang'                  => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => $RE_XML{p_NMTOKEN}},
                                'xml:space'                 => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:default|preserve)$/}},
                 'rect'     => {'class'                     => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'clip-path'                 => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'clip-rule'                 => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:nonzero|evenodd|inherit)$/},
                                'color'                     => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => $RE_PAINT{p_COLOR}},
                                'color-interpolation'       => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:auto|sRGB|linearRGB|inherit)$/},
                                'color-rendering'           => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:auto|optimizeSpeed|optimizeQuality|inherit)$/},
                                'cursor'                    => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'display'                   => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:inline|block|list\-item|run\-in|compact|marker|table|inline\-table|table\-row\-group|table\-header\-group|table\-footer\-group|table\-row|table\-column\-group|table\-column|table\-cell|table\-caption|none|inherit)$/},
                                'externalResourcesRequired' => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:false|true)$/},
                                'fill'                      => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => $RE_PAINT{p_PAINT}},
                                'fill-opacity'              => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                                'fill-rule'                 => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:nonzero|evenodd|inherit)$/},
                                'filter'                    => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'height'                    => {'optional' => 0,
                                                                'type'     => SCALAR,
                                                                'regex'    => $RE_LENGTH{p_A_LENGTH}},
                                'id'                        => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => $RE_XML{p_NAME}},
                                'image-rendering'           => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:auto|optimizeSpeed|optimizeQuality|inherit)$/},
                                'mask'                      => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'onactivate'                => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'onclick'                   => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'onfocusin'                 => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'onfocusout'                => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'onload'                    => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'onmousedown'               => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'onmousemove'               => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'onmouseout'                => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'onmouseover'               => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'onmouseup'                 => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'opacity'                   => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                                'pointer-events'            => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:visiblePainted|visibleFill|visibleStroke|visible|painted|fill|stroke|all|none|inherit)$/},
                                'requiredExtensions'        => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'requiredFeatures'          => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'rx'                        => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => $RE_LENGTH{p_A_LENGTH}},
                                'ry'                        => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => $RE_LENGTH{p_A_LENGTH}},
                                'shape-rendering'           => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:auto|optimizeSpeed|crispEdges|geometricPrecision|inherit)$/},
                                'stroke'                    => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => $RE_PAINT{p_PAINT}},
                                'stroke-dasharray'          => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/$RE_DASHARRAY{p_DASHARRAY}|^inherit$|^none$/},
                                'stroke-dashoffset'         => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/$RE_LENGTH{p_A_LENGTH}|^inherit$/},
                                'stroke-linecap'            => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:butt|round|square|inherit)$/},
                                'stroke-linejoin'           => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:miter|round|bevel|inherit)$/},
                                'stroke-miterlimit'         => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/$RE_NUMBER{p_A_NNNUMBER}|^inherit$/},
                                'stroke-opacity'            => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                                'stroke-width'              => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/$RE_LENGTH{p_A_LENGTH}|^inherit$/},
                                'style'                     => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'systemLanguage'            => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'text-rendering'            => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:auto|optimizeSpeed|optimizeLegibility|geometricPrecision|inherit)$/},
                                'transform'                 => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => $RE_TRANSFORM{p_TRANSFORM_LIST}},
                                'visibility'                => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:visible|hidden|inherit)$/},
                                'width'                     => {'optional' => 0,
                                                                'type'     => SCALAR,
                                                                'regex'    => $RE_LENGTH{p_A_LENGTH}},
                                'x'                         => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => $RE_LENGTH{p_A_LENGTH}},
                                'xml:base'                  => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/.?/},
                                'xml:lang'                  => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => $RE_XML{p_NMTOKEN}},
                                'xml:space'                 => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => qr/^(?:default|preserve)$/},
                                'y'                         => {'optional' => 1,
                                                                'type'     => SCALAR,
                                                                'regex'    => $RE_LENGTH{p_A_LENGTH}}});

our %ATTR_HINTS = ('circle'   => {'color'        => {'color'  => 1},
                                  'cx'           => {'length' => 1},
                                  'cy'           => {'length' => 1},
                                  'fill'         => {'color'  => 1},
                                  'r'            => {'length' => 1},
                                  'stroke'       => {'color'  => 1},
                                  'stroke-width' => {'length' => 1}},
                   'ellipse'  => {'color'        => {'color'  => 1},
                                  'cx'           => {'length' => 1},
                                  'cy'           => {'length' => 1},
                                  'fill'         => {'color'  => 1},
                                  'rx'           => {'length' => 1},
                                  'ry'           => {'length' => 1},
                                  'stroke'       => {'color'  => 1},
                                  'stroke-width' => {'length' => 1}},
                   'line'     => {'color'        => {'color'  => 1},
                                  'fill'         => {'color'  => 1},
                                  'stroke'       => {'color'  => 1},
                                  'stroke-width' => {'length' => 1},
                                  'x1'           => {'length' => 1},
                                  'x2'           => {'length' => 1},
                                  'y1'           => {'length' => 1},
                                  'y2'           => {'length' => 1}},
                   'path'     => {'color'        => {'color'  => 1},
                                  'fill'         => {'color'  => 1},
                                  'stroke'       => {'color'  => 1},
                                  'stroke-width' => {'length' => 1}},
                   'polygon'  => {'color'        => {'color'  => 1},
                                  'fill'         => {'color'  => 1},
                                  'stroke'       => {'color'  => 1},
                                  'stroke-width' => {'length' => 1}},
                   'polyline' => {'color'        => {'color'  => 1},
                                  'fill'         => {'color'  => 1},
                                  'stroke'       => {'color'  => 1},
                                  'stroke-width' => {'length' => 1}},
                   'rect'     => {'color'        => {'color'  => 1},
                                  'fill'         => {'color'  => 1},
                                  'height'       => {'length' => 1},
                                  'rx'           => {'length' => 1},
                                  'ry'           => {'length' => 1},
                                  'stroke'       => {'color'  => 1},
                                  'stroke-width' => {'length' => 1},
                                  'width'        => {'length' => 1},
                                  'x'            => {'length' => 1},
                                  'y'            => {'length' => 1}});

1;


__END__

=pod

=head1 DESCRIPTION

This file was automatically generated using the SVG DTD available
under
L<http://www.w3.org/Graphics/SVG/1.1/DTD/svg11-flat-20030114.dtd>.

See L<SVG::Rasterize::Specification|SVG::Rasterize::Specification>
for more details.


=head1 AUTHOR

Lutz Gehlen, C<< <perl at lutzgehlen.de> >>


=head1 LICENSE AND COPYRIGHT

Copyright 2010-2011 Lutz Gehlen.

This program is free software; you can redistribute it and/or modify
it under the terms of either: the GNU General Public License as
published by the Free Software Foundation; or the Artistic License.

See http://dev.perl.org/licenses/ for more information.

=cut
