use strict;

package Lingua::Postcodes;
$Lingua::Postcodes::VERSION = '0.001'; # TRIAL
use warnings;
use utf8;

# ABSTRACT: Returns the names of postcodes/zipcodes

use base 'Exporter';
our @EXPORT = 'name';

our %POSTCODES = (
    AL => { EN => 'Post Code',   AL => 'Kodi Postar' },
    FR => { EN => 'Postal Code', FR => 'Code Postal' },
    GB => { EN => 'Postcode',    FR => '?' },
    IE => { EN => 'Eircode',     FR => '?' },
    IN => { EN => 'PIN Code',    FR => '?' },
    RO => { EN => 'Postal Code', RO => 'Cod poștal' },
    US => { EN => 'Zip code',    FR => '?' },
);

sub name {
    my $country_code = shift;
    if ( @_ == 0 ) {
        return undef unless exists $POSTCODES{$country_code};

        return $POSTCODES{$country_code}{'EN'};
    }
    else {
        my $language = shift;
        return undef unless exists $POSTCODES{$country_code}{$language};

        return $POSTCODES{$country_code}{$language};
    }
}
1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Lingua::Postcodes - Returns the names of postcodes/zipcodes

=head1 VERSION

version 0.001

=head1 NAME 

Lingua::Postcodes - Provide names for postcodes/zipcodes

=head1 VERSION

version 0.001

=head1 AUTHOR

Lance Wicks <lancew@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by Lance Wicks.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
