use 5.010001;
use strict;
use warnings;
use autodie;
use Test::More;

unless ( $ENV{RELEASE_TESTING} ) {
    plan( skip_all => "Author tests not required for installation" );
}
else {
    plan tests => 2;
    
}


my $file = 'lib/Term/Choose.pm';

my $test_env = 0;
open my $fh1, '<', $file;
while ( my $line = readline $fh1 ) {
    if ( $line =~ /\A\s*use\s+warnings\s+FATAL/s ) {
        $test_env++;
    }
	if ( $line =~ /(?:\A\s*|\s+)use\s+Log::Log4perl/ ) {
		$test_env++;
	}
}
close $fh1;
is( $test_env, 0, "OK - test environment in $file disabled." );




my $c = 0;
my $pad_before_pad_one_row = 0;
open my $fh2, '<', $file;
while ( my $line = readline $fh2 ) {
    if ( $line =~ /\Asub _set_layout/ .. $line =~ /\A\}/ ) {
        $c++ if $line =~ /\A\s*\$\Qconfig->{pad}\E/;
        if ( $line =~ /\A\s*\$\Qconfig->{pad_one_row}\E/ ) {
            $pad_before_pad_one_row = 1 if $c;
            last;
        }
    }      
}
close $fh2;
is( $pad_before_pad_one_row, 1, "OK - option \"pad\" is set before option \"pad_one_row\"." );