use warnings;
use strict;
use 5.10.1;
use utf8;
package Term::Choose::GC;

our $VERSION = '1.013';

say "";
say "package Term::Choose::GC is now Term::Choose.";
say "";
say "Please use Term::Choose:";
say "";
say "    use Term::Choose qw(choose);";
say "";
die;
1;


=pod

=encoding utf8

=head1 NAME

Term::Choose::GC - Works as L<Term::Choose>.

=head1 VERSION

Version 1.013

=cut

=head1 L<Term::Choose::GC> is now called L<Term::Choose>.

L<Term::Choose::GC> is now called L<Term::Choose>.

Please use L<Term::Choose> instead of L<Term::Choose::GC>.

    use Term::Choose qw(choose);

=head1 AUTHOR

Matthäus Kiem <cuer2s@gmail.com>

=head1 CREDITS

Based on and inspired by the I<choose> function from L<Term::Clui> module.

Thanks to the L<http://www.perl-community.de> and the people form L<http://stackoverflow.com> for the help.

=head1 LICENSE AND COPYRIGHT

Copyright 2012 Matthäus Kiem.

This library is free software; you can redistribute it and/or modify it under the same terms as Perl itself.

=cut

# End of Term::Choose


















