package # hide from PAUSE
App::YTDL::Info;

use warnings;
use strict;
use 5.010000;

use Exporter qw( import );
our @EXPORT_OK = qw( get_download_infos );

use File::Path            qw( make_path );
use File::Spec::Functions qw( catfile catdir );

use Term::ANSIScreen   qw( :cursor :screen );
use Term::Choose       qw( choose );
use Term::Choose::Util qw( term_size );

use if $^O eq 'MSWin32', 'Win32::Console::ANSI';

use App::YTDL::Info_Print     qw( linefolded_print_info );
use App::YTDL::Helper         qw( get_filename encode_stdout_lax encode_fs sanitize_for_path );
use App::YTDL::History        qw( add_channel_to_history write_channel_history_to_file );
use App::YTDL::Select_Quality qw( fmt_quality set_preferred_qualities );
use App::YTDL::Options        qw( set_options );



sub get_download_infos {
    my ( $opt, $info ) = @_;
    my ( $cols, $rows ) = term_size();
    print "\n\n\n", '=' x $cols, "\n\n", "\n" x $rows;
    print locate( 1, 1 ), cldown;
    say 'Dir  : ', $opt->{video_dir};
    say 'Agent: ', $opt->{useragent} // '';
    print "\n";

    EXTRACTOR: for my $ex ( sort keys %$info ) {
        my @video_ids = sort {
               $info->{$ex}{$a}{playlist_id} cmp $info->{$ex}{$b}{playlist_id}
            || $info->{$ex}{$a}{uploader_id} cmp $info->{$ex}{$b}{uploader_id}
            || $info->{$ex}{$a}{upload_date} cmp $info->{$ex}{$b}{upload_date}
            || $info->{$ex}{$a}{title}       cmp $info->{$ex}{$b}{title}
        } keys %{$info->{$ex}};
        my $fmt_list;
        my $count = 0;
        $opt->{up} = 0;

        VIDEO: while ( @video_ids ) {
            my $video_id = shift @video_ids;
            $count++;
            my $key_len = 13;
            my $print_array = linefolded_print_info( $opt, $info, $ex, $video_id, $key_len );

            MENU: while ( 1 ) {
                print "\n";
                $opt->{up}++;
                binmode STDOUT, ':pop';
                print for map { encode_stdout_lax( $_ ) } @$print_array;
                binmode STDOUT, ':encoding(console_out)';
                $opt->{up} += @$print_array;
                print "\n";
                $opt->{up}++;
                $fmt_list = fmt_quality( $opt, $info, $fmt_list, $ex, $video_id );
                if ( ! defined $fmt_list ) {
                    my ( $delete, $append, $pref_qualities, $options, $quit ) = ( 'Delete', 'Append', 'Preferred qualities', 'Options', 'Quit' );
                    # Choose
                    my $choice = choose(
                        [ undef, $quit, $delete, $append, $pref_qualities, $options ],
                        { prompt => 'Your choice: ', default => 1, undef => 'Back' }
                    );
                    if ( ! defined $choice ) {
                        print up( $opt->{up} ), cldown;
                        $opt->{up} = 0;
                        next MENU;
                    }
                    elsif ( $choice eq $quit ) {
                        my $confirm = choose(
                            [ undef, '  Confirm QUIT' ],
                            { prompt => 'Your choice: ', default => 1, layout => 3, undef => '  MENU' }
                        );
                        if ( ! defined $confirm ) {
                            print up( $opt->{up} ), cldown;
                            $opt->{up} = 0;
                            next MENU;
                        }
                        else {
                            print locate( 1, 1 ), cldown;
                            say "Quit";
                            exit;
                        }
                    }
                    elsif ( $choice eq $delete ) {
                        delete  $info->{$ex}{$video_id};
                        if ( ! @video_ids ) {
                            print up( 2 ), cldown;
                            print "\n";
                        }
                        print up( $opt->{up} ), cldown;
                        $opt->{up} = 0;
                        $count--;
                        next VIDEO;
                    }
                    elsif ( $choice eq $append ) {
                        push @video_ids, $video_id;
                        print up( $opt->{up} ), cldown;
                        $opt->{up} = 0;
                        $count--;
                        next VIDEO;
                    }
                    elsif ( $choice eq $pref_qualities ) {
                        set_preferred_qualities( $opt, $info, $ex, $video_id );
                        print up( $opt->{up} ), cldown;
                        $opt->{up} = 0;
                        next MENU;
                    }
                    elsif ( $choice eq $options ) {
                        set_options( $opt );
                        unshift @video_ids, $video_id;
                        print up( $opt->{up} ), cldown;
                        $opt->{up} = 0;
                        next VIDEO;
                    }
                }
                else {
                    last MENU;
                }
            }
            print up( $opt->{up} ), cldown;
            $opt->{up} = 0;
            my $video_dir = $opt->{video_dir};
            if ( $opt->{extractor_dir} ) {
                my $extractor_dir = sanitize_for_path( $ex );
                $video_dir = catdir $video_dir, $extractor_dir;
                make_path encode_fs( $video_dir );
            }
            if ( $opt->{channel_dir} == 2 || $opt->{channel_dir} == 1 && $info->{$ex}{$video_id}{from_list} ) {
                if ( length $info->{$ex}{$video_id}{uploader} ) {
                    my $channel_name = sanitize_for_path( $info->{$ex}{$video_id}{uploader} );
                    $video_dir = catdir $video_dir, $channel_name;
                    make_path encode_fs( $video_dir );
                }
            }
            $info->{$ex}{$video_id}{video_dir} = $video_dir;
            printf "%*.*s : %s\n", $key_len, $key_len, 'video', $count;
            my $joined_fmts = join ' + ', @$fmt_list;
            $print_array->[0] =~ s/\n\z//;
            $print_array->[0] .= " ($joined_fmts)\n";
            binmode STDOUT, ':pop';
            print for map { encode_stdout_lax( $_ ) } @$print_array;
            binmode STDOUT, ':encoding(console_out)';
            print "\n";
            for my $fmt ( @$fmt_list ) {
                $info->{$ex}{$video_id}{video_url}{$fmt} = $info->{$ex}{$video_id}{fmt_to_info}{$fmt}{url};
                my $title = $info->{$ex}{$video_id}{title};
                my $ext   = $info->{$ex}{$video_id}{fmt_to_info}{$fmt}{ext};
                $info->{$ex}{$video_id}{file_name}{$fmt} = catfile( $video_dir, get_filename( $opt, $title, $ext, $fmt ) );

                $info->{$ex}{$video_id}{count} = $count;
                $opt->{total_nr_videos}++;

            }
            if ( $opt->{max_channels} ) {
                add_channel_to_history( $opt, $info, $ex, $video_id );
            }
        }
    }
    print "\n";
    if ( $opt->{max_channels} ) {
        write_channel_history_to_file( $opt );
    }
    if ( ! $opt->{total_nr_videos} ) {
        print locate( 1, 1 ), cldown;
        say "No videos";
        exit;
    }
    return $opt, $info;
}



1;


__END__
