use ExtUtils::MakeMaker;
use Data::Dumper;
use strict;

# Let's ask some questions

my $virtuals = {};
print "What is the name of the Virtual User?\n";
my $virtual  = getLine();

while ($virtual) {
	my %attributes;
	print "What is the connect string?\n";
	my $connect  = getLine();
	print "What is the username?\n";
	my $username  = getLine();
	print "What is the password?\n";
	my $password  = getLine();
	print "What attributes would you like to add?\n";
	print "(Enter nothing to skip or finish)\n";
	my $attr  = getLine();
	while($attr) {
		print "What is the value of the attribute?\n";
		my $value  = getLine();
		$attributes{$attr} = $value;
		print "What attributes would you like to add?\n";
		print "(Enter nothing to skip or finish)\n";
		$attr  = getLine();
	}
	$virtuals->{$virtual} = {
			connect => $connect,
			username => $username,
			password => $password,
			attributes => \%attributes
			};
	$virtual = undef;
	print "What is the name of the Virtual User?\n";
	print "(Enter nothing if you are finished adding users.)\n";
	$virtual  = getLine();
}

#Now, lets build up our data structure
my $data = Data::Dumper->new([$virtuals]);
$data->Purity(1);
$data->Indent(3);
$data->Varname('virtual');
my $dumped = $data->Dump();
makeFile();
makeTest();

#Now, lets grab the version
open (FILEHANDLE, "VERSION");
my $version = <FILEHANDLE>;
close (FILEHANDLE);
# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.
WriteMakefile(
    'NAME'	=> 'DBIx::Password',
    'VERSION' => $version, # finds $VERSION
);

sub getLine {
	my $data = <STDIN>;
	chomp($data);
	return $data;
}

sub makeFile {
	open(FILEHANDLE, "Password.pm-orig"); 
	my @file = <FILEHANDLE>;
	close (FILEHANDLE);
	open(FILEHANDLE, ">Password.pm"); 
	for (@file) {
		chomp($_);
		if(/#PASSWORD_INSERT/) {
			print FILEHANDLE ("my $dumped\n");
		} else {
			print FILEHANDLE ("$_\n");
		}
	}
	close (FILEHANDLE);
}

sub makeTest {
	open(FILEHANDLE, "test.pl-orig"); 
	my @file = <FILEHANDLE>;
	close (FILEHANDLE);
	open(FILEHANDLE, ">test.pl"); 
	for (@file) {
		chomp($_);
		if(/#PASSWORD_INSERT/) {
			print FILEHANDLE ("my $dumped\n");
		} else {
			print FILEHANDLE ("$_\n");
		}
	}
	close (FILEHANDLE);
}
