use strict;

mkdir('uc', 0777);

my @c = (
    (map {chr($_)} (0x20..0x7E, 0xA1..0xDF)),
);

my $script = "uc\\uc.pl";
open(SCRIPT,">$script") || die "Can't open file: $script\n";

#----------------------------------------------------------------------------
# uc
#----------------------------------------------------------------------------

for my $c (@c) {

    if ($c eq "\\c[") {
        next;
    }

    if ($c =~ /^['\\]$/) {
        print SCRIPT "\$_ = '\\", $c, "'; print uc;\n";
    }
    else {
        print SCRIPT "\$_ = '", $c, "'; print uc;\n";
    }
}

for my $c1 (0x81..0x9F, 0xE0..0xFC) {
    for my $c2 (0x40..0x7E, 0x80..0xFC) {
        print SCRIPT "\$_ = '", chr($c1), chr($c2), "'; print uc;\n";
    }
}

#----------------------------------------------------------------------------
# uc $_
#----------------------------------------------------------------------------

for my $c (@c) {

    if ($c eq "\\c[") {
        next;
    }

    if ($c =~ /^['\\]$/) {
        print SCRIPT "\$_ = '\\", $c, "'; print uc \$_;\n";
    }
    else {
        print SCRIPT "\$_ = '", $c, "'; print uc \$_;\n";
    }
}

for my $c1 (0x81..0x9F, 0xE0..0xFC) {
    for my $c2 (0x40..0x7E, 0x80..0xFC) {
        print SCRIPT "\$_ = '", chr($c1), chr($c2), "'; print uc \$_;\n";
    }
}

#----------------------------------------------------------------------------
# uc($_)
#----------------------------------------------------------------------------

for my $c (@c) {

    if ($c eq "\\c[") {
        next;
    }

    if ($c =~ /^['\\]$/) {
        print SCRIPT "\$_ = '\\", $c, "'; print uc(\$_);\n";
    }
    else {
        print SCRIPT "\$_ = '", $c, "'; print uc(\$_);\n";
    }
}

for my $c1 (0x81..0x9F, 0xE0..0xFC) {
    for my $c2 (0x40..0x7E, 0x80..0xFC) {
        print SCRIPT "\$_ = '", chr($c1), chr($c2), "'; print uc(\$_);\n";
    }
}

#----------------------------------------------------------------------------
# uc $_, 'a', 'b', 'c'
#----------------------------------------------------------------------------

for my $c (@c) {

    if ($c eq "\\c[") {
        next;
    }

    if ($c =~ /^['\\]$/) {
        print SCRIPT "\$_ = '\\", $c, "'; print uc \$_, 'a', 'b', 'c';\n";
    }
    else {
        print SCRIPT "\$_ = '", $c, "'; print uc \$_, 'a', 'b', 'c';\n";
    }
}

for my $c1 (0x81..0x9F, 0xE0..0xFC) {
    for my $c2 (0x40..0x7E, 0x80..0xFC) {
        print SCRIPT "\$_ = '", chr($c1), chr($c2), "'; print uc \$_, 'a', 'b', 'c';\n";
    }
}

#----------------------------------------------------------------------------
# uc '*'
#----------------------------------------------------------------------------

for my $c (@c) {

    if ($c eq "\\c[") {
        next;
    }

    if ($c =~ /^['\\]$/) {
        print SCRIPT "print uc '\\", $c, "';\n";
    }
    else {
        print SCRIPT "print uc '", $c, "';\n";
    }
}

for my $c1 (0x81..0x9F, 0xE0..0xFC) {
    for my $c2 (0x40..0x7E, 0x80..0xFC) {
        print SCRIPT "print uc '", chr($c1), chr($c2), "';\n";
    }
}

#----------------------------------------------------------------------------
# uc('*')
#----------------------------------------------------------------------------

for my $c (@c) {

    if ($c eq "\\c[") {
        next;
    }

    if ($c =~ /^['\\]$/) {
        print SCRIPT "print uc('\\", $c, "');\n";
    }
    else {
        print SCRIPT "print uc('", $c, "');\n";
    }
}

for my $c1 (0x81..0x9F, 0xE0..0xFC) {
    for my $c2 (0x40..0x7E, 0x80..0xFC) {
        print SCRIPT "print uc('", chr($c1), chr($c2), "');\n";
    }
}

#----------------------------------------------------------------------------
# uc '*', 'a', 'b', 'c'
#----------------------------------------------------------------------------

for my $c (@c) {

    if ($c eq "\\c[") {
        next;
    }

    if ($c =~ /^['\\]$/) {
        print SCRIPT "print uc '\\", $c, "', 'a', 'b', 'c';\n";
    }
    else {
        print SCRIPT "print uc '", $c, "', 'a', 'b', 'c';\n";
    }
}

for my $c1 (0x81..0x9F, 0xE0..0xFC) {
    for my $c2 (0x40..0x7E, 0x80..0xFC) {
        print SCRIPT "print uc '", chr($c1), chr($c2), "', 'a', 'b', 'c';\n";
    }
}

close(SCRIPT);

#----------------------------------------------------------------------------
