1;
__END__

=pod

=encoding Shift_JIS

=head1 \tgEFA

Sjis-JA - Source code filter to escape ShiftJIS (Japanese document)

=head1 Tv

   g: A

    XNvg ShiftJIS_script.pl ̒ɈȉLq...
      use Sjis;
      use Sjis version;          --- Sjis.pm ̃o[W`FbNsꍇ
      use Sjis qw(ord reverse);  --- ord, reverse ̊g@\gꍇ
      use Sjis version qw(ord reverse);

       no Sjis; ͗pł܂B

    R}hvvgňȉ̂悤Ɏs
      perl     ShiftJIS_script.pl  wild*  *card  and  '*quote*'  on MSWin32
      perl55   ShiftJIS_script.pl  wild*  *card  and  '*quote*'  on MSWin32
      perl56   ShiftJIS_script.pl  wild*  *card  and  '*quote*'  on MSWin32
      perl58   ShiftJIS_script.pl  wild*  *card  and  '*quote*'  on MSWin32
      perl510  ShiftJIS_script.pl  wild*  *card  and  '*quote*'  on MSWin32
      perl512  ShiftJIS_script.pl  wild*  *card  and  '*quote*'  on MSWin32
      perl514  ShiftJIS_script.pl  wild*  *card  and  '*quote*'  on MSWin32
      perl64   ShiftJIS_script.pl  wild*  *card  and  '*quote*'  on MSWin32

      ? * găChJ[h̎w肪ł܂
      ' ` ' găNH[g邱Ƃł܂

      g֐
        Sjis::ord(...);
        Sjis::reverse(...);
        Sjis::length(...);
        Sjis::substr(...);
        Sjis::index(...);
        Sjis::rindex(...);

      Perl5.6 G~[V(perl5.005̏ꍇ)
        use warnings;
        use warnings::register;
        binmode(...);
        open(...);

      ȉ̓_~[֐Ƃ
        utf8::upgrade(...);
        utf8::downgrade(...);
        utf8::encode(...);
        utf8::decode(...);
        utf8::is_utf8(...);
        utf8::valid(...);
        bytes::chr(...);
        bytes::index(...);
        bytes::length(...);
        bytes::ord(...);
        bytes::rindex(...);
        bytes::substr(...);

   g: B

    R}hvvgňȉ̂悤Ɏs

      C:\>perl  Sjis.pm  ShiftJIS_script.pl  >  Escaped_script.pl.e
      C:\>perl  Escaped_script.pl.e

      ShiftJIS_script.pl  --- ShiftJIS ŏꂽXNvg
      Escaped_script.pl.e --- GXP[vꂽXNvg

=head1 v

܂ł̗j͂߂܂傤BShiftJIS ̃T|[g jperl 4.019+1.3 n
܂܂Bɂ chop() Ȃǂ̊֐␳K\𕡎Gȓ{̕ɑ΂
Kpł悤ɂȂ܂B

Perl5.8 ȍ~ Encode W[ɂă}`KT|[gꂽ߁A
jperl ͕svɂȂƌĂ܂B

łA͖{̂Ƃł傤H

{ɂāAėp^Rs[^̓óAp[\iRs[^̓R[
hѓóAɂ͌gѓdbɎ܂ŁAShiftJIS {ƂR[h
LgĂ܂B̃\tgEFA͂ ShiftJIS 𒼐ڈ܂B̂
UTF8 tO͂܂B
̃\tgEFA Shift_JIS, Windows-31J, CP932, MacJapanese, SJIS(R90),
Shift_JISX0213, Shift_JIS-2004 Ȃǂ ShiftJIS ̈Ƃł܂B
̕ł͂𑍏̂ ShiftJIS Ƃŕ\Ă܂(u_vȂ)B

Gȉ@͖蕡Gɂ܂B
ȂGR[h̖肩GXP[v܂񂩁H

=head1 ЂƂ̖

JPerl ͂ƂĂDꂽ\tgEFAłBƁAł JPerl ͓{Ήł
Perl ̂ƂŁAJava  JVM Ƃ͊֌W܂BȂ킯ŁÃ\tgEFA
͏Փˉ̂߂ Sjis ƂOɂ܂B̌Agbvx̖O
 Char::Sjis ƂOŃfBXgr[V쐬悤ɂ܂A
] Sjis.pm, Esjis.pm ͈g悤ɂĂ܂B

ƂŁA JPerl ̓o[W 5.005_04 ȍ~AeiXĂ܂B

ώcOȂƂɁAJPerl̊Jsn  The Perl Confernce Japan
1998 ɂ

  "킽Ȃׂ͔ꂽ玟̐l낵"

ƂbZ[WcAPerl 痣ĂĂ܂܂B

XCh15 "jperl ̍"

ftp://ftp.oreilly.co.jp/pcjp98/watanabe/jperlconf.ppt

ƒNpŏĂ邾낤B
ȂǂƊ҂Ȃ10NԁA҂ԂɐE͈ႤւƐił̂łB

̃\tgEFA ShiftJIS ŏꂽ Perl XNvgGXP[v邽߂
\[XR[htB^łBGXP[vɂĕR[hω邱Ƃ͂
܂B

̃\tgEFA͈ȉ̓܂B

=over 2

=item * ShiftJIS ̂܂܂̒l

=item * ߋ̃f[^AXNvgAmEnEƌ݊ۂĂ

=item * UNIXOSADOSOS̏ꍇ́ASjis.pm  Esjis.pm ŋ@\

=item * UTF8 tOȂł(perlunitut  perluniadvice ̑Ή͕sv)

=item * (JPerlێ炷邽߂) C vO~OsȂł

=item * (CPU, OS, perl̃o[W, 32rbg/64rbgł̈Ⴂɂ) oCit@CɈˑȂ

=back

AJPerl ̖ɂĂЂƂ̖܂傤B

=head1 {IȎdg

ŋ߁Aȉ̃[Ĕ܂B

[Tokyo.pm] jus Benkyoukai

http://mail.pm.org/pipermail/tokyo-pm/1999-September/001854.html

("SJIS.pm" Ƃt@CŕۑĂ̂Ƃ܂)

  package SJIS;
  use Filter::Util::Call;
  sub multibyte_filter {
      my $status;
      if (($status = filter_read()) > 0 ) {
          s/([\x81-\x9f\xe0-\xef])([\x40-\x7e\x80-\xfc])/
              sprintf("\\x%02x\\x%02x",ord($1),ord($2))
          /eg;
      }
      $status;
  }
  sub import {
      filter_add(\&multibyte_filter);
  }
  1;

{Iɂ́Ã\tgEFA͏L̂悤ȂƂs܂B
AFilter::Util::Call 𗘗pĂȂ_APerl ̍\͂ĕKvɉ
GXP[v_قȂ܂B

=head1 CXg[@(makegꍇ)

   perl Makefile.PL
   make test
   make install

   VXe strict.pm Ȃꍇ͕t strict.pm_  strict.pm Ƀl[
   ĎgpĂB

=head1 CXg[@(makegȂꍇ)

   perl pMakefile.pl         --- pMakefile.pl  pmake.bat 𐶐܂
   pmake.bat
   pmake.bat test

   pmake.bat install          --- ݎgp perl ɃCXg[܂
   perl55   pmake.bat install --- perl5.005 ɃCXg[܂
   perl56   pmake.bat install --- perl5.006 ɃCXg[܂
   perl58   pmake.bat install --- perl5.008 ɃCXg[܂
   perl510  pmake.bat install --- perl5.010 ɃCXg[܂
   perl512  pmake.bat install --- perl5.012 ɃCXg[܂
   perl514  pmake.bat install --- perl5.014 ɃCXg[܂
   perl64   pmake.bat install --- perl64    ɃCXg[܂

   VXe strict.pm Ȃꍇ͕t strict.pm_  strict.pm Ƀl[
   ĎgpĂB

   pmake.bat dist             --- CPAN zzppbP[W܂
   pmake.bat ptar.bat         --- ptar.bat 쐬܂

=head1 \tgEFÄꗗ

   Char/Sjis.pm          --- ShiftJIS \[XR[htB^
   Char/Esjis.pm         --- Sjis.pm ̃^C[`
   Sjis.pm               --- Char/Sjis.pm ̕ʖ(@\͓ł)
   Esjis.pm              --- Char/Esjis.pm ̕ʖ(@\͓ł)
   perl55.bat            --- ϐ PATH ̐ݒȂ perl5.5  TĎs
   perl56.bat            --- ϐ PATH ̐ݒȂ perl5.6  TĎs
   perl58.bat            --- ϐ PATH ̐ݒȂ perl5.8  TĎs
   perl510.bat           --- ϐ PATH ̐ݒȂ perl5.10 TĎs
   perl512.bat           --- ϐ PATH ̐ݒȂ perl5.12 TĎs
   perl514.bat           --- ϐ PATH ̐ݒȂ perl5.14 TĎs
   perl64.bat            --- ϐ PATH ̐ݒȂ perl64   TĎs
   strict.pm_            --- _~[ strict.pm
   warnings.pm_          --- warnings.pm ̊ȈՔ
   warnings/register.pm_ --- warnings/register.pm ̊ȈՔ

=head1 GXP[vɂʌ݊̊m

̃\tgEFA͉ߋ̂̂󂵂͂AɁuGXP[vvɂċ@\ǉ
Ă܂B獡܂ŉ\łƂs\ɂȂ邱Ƃ͂܂B
̃Av[`́AނċȂɗLłB

=head1 XNvg̃GXP[v

쐬XNvg 'use Sjis;' ƏKv܂B

  ---------------------------------
  ȑO        Ȍ
  ---------------------------------
  (Ȃ)      use Sjis;
  ---------------------------------

=head1 }`oCg̃GXP[v

̃\tgEFAɂāA}`oCg̑2oCg @  [  \  ]  ^  `  {  |  }
̒O chr(0x5c) }܂BΏۂ͈ȉ̉ӏłB

=over 2

=item * VONH[g̕ ('', q{}, <<'END' and qw{})

=item * _uNH[g̕ ("", qq{}, <<END, <<"END", ``, qx{} and <<`END`)

=item * VONH[g̐K\ (m'', s''', split(''), split(m'') and qr'')

=item * _uNH[g̐K\ (//, m//, ??, s///, split(//), split(m//) and qr//)

=item * tr/// ̒̕ (tr/// and y///)

=back

  : J^Jíu\vR[h "\x83\x5C"
  
                    _v
  -----------------------------------------
  source script   "`/"    [83 5c]
  -----------------------------------------
 
   use Sjis; s
                          _v
  -----------------------------------------
  escaped script  "`\/"   [83 [5c] 5c]
  -----------------------------------------
                    ^--- Sjis \tgEFAŃGXP[v
 
  Ql              _v
  -----------------------------------------
  your eye's      "`/\"   [83 5c] [5c]
  -----------------------------------------
  perl eye's      "`\/"   [83] \[5c]
  -----------------------------------------
 
                          _v
  -----------------------------------------
  in the perl     "`/"    [83] [5c]
  -----------------------------------------

=head1 NX̃GXP[v

ߋperlƂ̌݊ۂ߂ɕNX͈ȉ̂悤ɍĒ`Ă܂B

  ---------------------------------------------------------------------------
  escape        class
  ---------------------------------------------------------------------------
   .            (?:[\x81-\x9F\xE0-\xFC][\x00-\xFF]|[^\x0A])
                (?:[\x81-\x9F\xE0-\xFC][\x00-\xFF]|[\x00-\xFF]) (/s Cq)
  \d            [0-9]
  \s            [\x09\x0A\x0C\x0D\x20]
  \w            [0-9A-Z_a-z]
  \D            (?:[\x81-\x9F\xE0-\xFC][\x00-\xFF]|[^0-9])
  \S            (?:[\x81-\x9F\xE0-\xFC][\x00-\xFF]|[^\x09\x0A\x0C\x0D\x20])
  \W            (?:[\x81-\x9F\xE0-\xFC][\x00-\xFF]|[^0-9A-Z_a-z])
  \h            [\x09\x20]
  \v            [\x0C\x0A\x0D]
  \H            (?:[\x81-\x9F\xE0-\xFC][\x00-\xFF]|[^\x09\x20])
  \V            (?:[\x81-\x9F\xE0-\xFC][\x00-\xFF]|[^\x0C\x0A\x0D])
  ---------------------------------------------------------------------------

l \b  \B ߋperlƂ̌݊ۂ߂ɍĒ`Ă܂B

  ---------------------------------------------------------------------------
  escape        class
  ---------------------------------------------------------------------------
  \b            (?:\A(?=[0-9A-Z_a-z])|(?<=[\x00-\x2F\x40\x5B-\x5E\x60\x7B-\xFF])(?=[0-9A-Z_a-z])|(?<=[0-9A-Z_a-z])(?=[\x00-\x2F\x40\x5B-\x5E\x60\x7B-\xFF]|\z))
  \B            (?:(?<=[0-9A-Z_a-z])(?=[0-9A-Z_a-z])|(?<=[\x00-\x2F\x40\x5B-\x5E\x60\x7B-\xFF])(?=[\x00-\x2F\x40\x5B-\x5E\x60\x7B-\xFF]))
  ---------------------------------------------------------------------------

=head1 g݊֐̃GXP[v

̃\tgEFAɂĊ֐̐擪 'Esjis::' GXP[v܂B
Esjis::* ֐ Esjis.pm 񋟂܂B

  ---------------------------------
  O      
  ---------------------------------
  length      length
  substr      substr
  pos         pos
  split       Esjis::split
  tr///       Esjis::tr
  tr///b      tr///
  tr///B      tr///
  y///        Esjis::tr
  y///b       tr///
  y///B       tr///
  chop        Esjis::chop
  index       Esjis::index
  rindex      Esjis::rindex
  lc          Esjis::lc
  lcfirst     Esjis::lcfirst
  uc          Esjis::uc
  ucfirst     Esjis::ucfirst
  chr         Esjis::chr
  glob        Esjis::glob
  lstat       Esjis::lstat
  opendir     Esjis::opendir
  stat        Esjis::stat
  unlink      Esjis::unlink
  chdir       Esjis::chdir
  do          Esjis::do
  require     Esjis::require
  ---------------------------------

  ------------------------------------------------------------------------------------------------------------------------
  O                   
  ------------------------------------------------------------------------------------------------------------------------
  use Perl::Module;        BEGIN { Esjis::require 'Perl/Module.pm'; Perl::Module->import() if Perl::Module->can('import'); }
  use Perl::Module @list;  BEGIN { Esjis::require 'Perl/Module.pm'; Perl::Module->import(@list) if Perl::Module->can('import'); }
  use Perl::Module ();     BEGIN { Esjis::require 'Perl/Module.pm'; }
  no Perl::Module;         BEGIN { Esjis::require 'Perl/Module.pm'; Perl::Module->unimport() if Perl::Module->can('unimport'); }
  no Perl::Module @list;   BEGIN { Esjis::require 'Perl/Module.pm'; Perl::Module->unimport(@list) if Perl::Module->can('unimport'); }
  no Perl::Module ();      BEGIN { Esjis::require 'Perl/Module.pm'; }
  ------------------------------------------------------------------------------------------------------------------------

=head1 bytes::* ֐̃AGXP[v

̃\tgEFAɂ bytes::* ֐̐擪 'bytes::' 菜܂B

  ------------------------------------
  O           
  ------------------------------------
  bytes::chr       chr
  bytes::index     index
  bytes::length    length
  bytes::ord       ord
  bytes::rindex    rindex
  bytes::substr    substr
  ------------------------------------

=head1 t@CeXgZq̃GXP[v

̃\tgEFAɂĉZq '-'  'Esjis::' ɏ܂B

  ---------------------------------
  O      
  ---------------------------------
  -r          Esjis::r
  -w          Esjis::w
  -x          Esjis::x
  -o          Esjis::o
  -R          Esjis::R
  -W          Esjis::W
  -X          Esjis::X
  -O          Esjis::O
  -e          Esjis::e
  -z          Esjis::z
  -f          Esjis::f
  -d          Esjis::d
  -l          Esjis::l
  -p          Esjis::p
  -S          Esjis::S
  -b          Esjis::b
  -c          Esjis::c
  -t          -t
  -u          Esjis::u
  -g          Esjis::g
  -k          Esjis::k
  -T          Esjis::T
  -B          Esjis::B
  -s          Esjis::s
  -M          Esjis::M
  -A          Esjis::A
  -C          Esjis::C
  ---------------------------------

perl5.00503 gpĂꍇłt@CeXgZq́uςݏd˂vƂ
ł܂B

  if ( -w -r $file ) {
      print "The file is both readable and writable!\n";
  }

=head1 ֐̃GXP[v

ẘ֐gꍇ͈ȉ̂悤ɋLqKv܂Bꂼ
̋@\ɂẮuẘ֐vQƂĂB

  ---------------------------------
  oCgw  w
  ---------------------------------
  ord         Sjis::ord
  reverse     Sjis::reverse
  length      Sjis::length
  substr      Sjis::substr
  index       Sjis::index
  rindex      Sjis::rindex
  ---------------------------------

=head1 ẘ֐

=over 2

=item * Sjis::ord

    "use Sjis qw(ord);" ɂ ord  Sjis::ord ɏ悤ɂȂ܂B

    $ord = Sjis::ord($string);

    Sjis::ord($string)  $string ̐擪̕ ShiftJIS R[hlԂ܂B
    $string ȗꂽꍇ $_ ΏۂƂȂ܂B̊֐͏ɕȂ
    lԂ܂B

    ̓ JPerl Ɣ݊Ȃ̂ŖIɃC|[gꍇ̂݋@\悤
    ȂĂ܂B

=item * Sjis::reverse

    "use Sjis qw(reverse);" ɂ reverse  Sjis::reverse ɏ悤
    ɂȂ܂B

    @reverse = Sjis::reverse(@list);
    $reverse = Sjis::reverse(@list);

    Sjis::reverse(@list) ̓XgReLXgł @list ̗vftɕׂ
    XglԂ܂B
    𗘗pāA~̐𔭐邱Ƃł܂B

    for (Sjis::reverse(1 .. 10)) { ... }

    @list ƂănbVnꍇÃnbV̓tbgȃXgɕϊ
    B̂Ƃ𗘗p΁Areverse gănbVtɂ(lL[
    Ђ悤ɂ)Ƃł܂(AׂĂ̒lj[Nł邱ƂO
    ł)B

    %barfoo = Sjis::reverse(%foobar);

    XJ[ReLXgł @list ׂ̂Ă̗vfAŁAShiftJIS 
    Pʂŋtɂ̂Ԃ܂B

    ̓ JPerl Ɣ݊Ȃ̂ŖIɃC|[gꍇ̂݋@\悤
    ȂĂ܂B

=item * Sjis::length

    $length = Sjis::length($string);
    $length = Sjis::length();

    Sjis::length($string) ̓XJ[l $string ̒ ShiftJIS ̕ŕ
    ܂B$string ȗꍇ $_ ̕Ԃ܂B

    ł͂ȂoCgPʂł̒𒲂ׂɂ́A܂܂Œʂ

    $bytes = length($string);

    ̂悤ɂ܂B

=item * Sjis::substr

    $substr = Sjis::substr($string,$offset,$length,$replacement);
    $substr = Sjis::substr($string,$offset,$length);
    $substr = Sjis::substr($string,$offset);

    Sjis::substr ́AShiftJIS  $string Ŏw肳ꂽ񂩂畔
    oĕԂ܂B́A̐擪琔 $offset ڂn܂A
    $length łB$offset Ȃ΁A̖ -$offset ߂
    Ƃ납畔񂪊Jn܂B$length ȗƁA̖܂łׂĂ
    Ԃ܂B$length Ȃ΁A̖ -$length c悤ɁA
    ߂܂BłȂ΁A$length ́AȂ҂悤ɁAo
    ̒\Ă܂B

    Sjis::substr Ӓl(̑ΏۂƂȂ)ƂĎgƂ͂ł܂B̑
    ɁA4 $replacement ɒup̕w肵܂B̏ꍇA
    Sjis::substr  $string ̈ꕔ𕶎 $replacement ŒuƂƂɁA
    (splice ̂悤)uꂽlƂĕԂ܂B̗́A$var ̍Ō
     "Curly" ŒuƂƂɁAuꂽ $oldstr ɃZbg
    :

    $oldstr = Sjis::substr($var, -1, 1, "Curly");

    $var ̐擪ɕ "Larry" tɂ́Â悤ɂ܂:

    Sjis::substr($var, 0, 0, "Larry");

    $var ̍ŏ1 "Moe" Œuɂ́Â悤ɂ܂:

    Sjis::substr($var, 0, 1, "Moe");

    $var ̍Ō1 "Curly" Œuɂ͎̂悤ɂ܂:

    Sjis::substr($var, -1, 1, "Curly");

=item * Sjis::index

    $index = Sjis::index($string,$substring,$start);
    $index = Sjis::index($string,$substring);

    Sjis::index ́AShiftJIS  $string ̒Ɋ܂܂A1 ShiftJIS 
     $substr T܂B$string ̒ŁA$substr ŏɏoʒu𕶎P
    ŐĕԂ܂B$start w肳ĂꍇA$string ̐擪 $start 
    XLbvʒuA$substr Tn߂܂Bʒu 0 x[XɂƂ
    ܂B$substr Ȃ΁ASjis::index ֐̓x[X 1 
    l -1 Ԃ܂BSjis::index gāAŜ𒲂ׂɂ́Â悤ɂ
    ܂B

    $pos = -1;
    while (($pos = Sjis::index($string, $lookfor, $pos)) > -1) {
        print "Found at $pos\n";
        $pos++;
    }

=item * Sjis::rindex

    $rindex = Sjis::rindex($string,$substring,$position);
    $rindex = Sjis::rindex($string,$substring);

    Sjis::rindex  Sjis::index ƎĂ܂AShiftJIS  $string ̒ŁA
     $substr Ōɏoʒu𕶎PʂŐĕԂ܂(܂
    reverse Sjis::index ł)B$substr Ȃ΁A-1 Ԃ܂B$position
    ɂāAlƂĕԂƂAłËʒuw肷邱Ƃł܂B
    Sjis::rindex gāAŜ𖖔擪ɌĒׂɂ́Â悤
    ɂ܂B

    $pos = Sjis::length($string);
    while (($pos = Sjis::rindex($string, $lookfor, $pos)) >= 0) {
        print "Found at $pos\n";
        $pos--;
    }

=back

=head1 g݂̕WW[̃GXP[v

Esjis.pm ̐擪 "BEGIN { unshift @INC, '/Perl/site/lib/Sjis' }" sA
W[̌Aŏ '/Perl/site/lib/Sjis' QƂ悤ɂȂ܂BSjis
\tgEFAŎg悤ɉWW[Ɋi[āAƂ̕W
W[I[o[Ch܂B

=head1 WW[̓ẽGXP[v

WW[̃t@C /Perl/site/lib/Sjis ɃRs[ 'use utf8;' 
'use Sjis;' ɏ܂BKvɉĂ̑̏sĂB

=head1 perl5.005 ɂ Perl5.6 G~[V

  perl5.005 ɂ warnings vO}G~[g܂B
   warnings.pm_  warnings.pm ɁAwarnings/register.pm_ 
  warnings/register.pm Ƀt@CύXĎgpł܂B

=head1 vO}уW[

  -----------------------------------------------------------
  O                    
  -----------------------------------------------------------
  use strict;               use strict; no strict qw(refs);
  require utf8;             # require utf8;
  require bytes;            # require bytes;
  require I18N::Japanese;   # require I18N::Japanese;
  require I18N::Collate;    # require I18N::Collate;
  require I18N::JExt;       # require I18N::JExt;
  require File::DosGlob;    # require File::DosGlob;
  require Wild;             # require Wild;
  require Wildcard;         # require Wildcard;
  require Japanese;         # require Japanese;
  use utf8;                 # use utf8;
  use bytes;                # use bytes;
  use I18N::Japanese;       # use I18N::Japanese;
  use I18N::Collate;        # use I18N::Collate;
  use I18N::JExt;           # use I18N::JExt;
  use File::DosGlob;        # use File::DosGlob;
  use Wild;                 # use Wild;
  use Wildcard;             # use Wildcard;
  use Japanese;             # use Japanese;
  no utf8;                  # no utf8;
  no bytes;                 # no bytes;
  no I18N::Japanese;        # no I18N::Japanese;
  no I18N::Collate;         # no I18N::Collate;
  no I18N::JExt;            # no I18N::JExt;
  no File::DosGlob;         # no File::DosGlob;
  no Wild;                  # no Wild;
  no Wildcard;              # no Wildcard;
  no Japanese;              # no Japanese;
  -----------------------------------------------------------

  utf8 vO}Abytes vO}̓RgAEg܂Bt@CŒ񋟂
  ֐̑Ƃ Esjis.pm _~[֐񋟂܂B

=over 2

=item * _~[̊֐ utf8::upgrade

  $num_octets = utf8::upgrade($string);

  $string ̃INebgԂ܂B

=item * _~[̊֐ utf8::downgrade

  $success = utf8::downgrade($string[, FAIL_OK]);

  ̊֐͏ɐ^̒lԂ܂B

=item * _~[̊֐ utf8::encode

  utf8::encode($string);

  ̊֐͉Ԃ܂B

=item * _~[̊֐ utf8::decode

  $success = utf8::decode($string);

  ̊֐͏ɐ^̒lԂ܂B

=item * _~[̊֐ utf8::is_utf8

  $flag = utf8::is_utf8(STRING);

  ̊֐͏ɋU̒lԂ܂B

=item * _~[̊֐ utf8::valid

  $flag = utf8::valid(STRING);

  ̊֐͏ɐ^̒lԂ܂B

=item * _~[̊֐ bytes::chr

  oCgẘ֐ chr ƂĎĂ܂B

=item * _~[̊֐ bytes::index

  oCgẘ֐ index ƂĎĂ܂B

=item * _~[̊֐ bytes::length

  oCgẘ֐ length ƂĎĂ܂B

=item * _~[̊֐ bytes::ord

  oCgẘ֐ ord ƂĎĂ܂B

=item * _~[̊֐ bytes::rindex

  oCgẘ֐ rindex ƂĎĂ܂B

=item * _~[̊֐ bytes::substr

  oCgẘ֐ substr ƂĎĂ܂B

=back

=head1 ϐ

 ̃\tgEFA͔r flock ֐gp܂Bt@Cǎ\ɂȂ܂
 邢͏݉\ɂȂ܂ŃvO̎s̓ubN܂B
 ϐ SJIS_NONBLOCK `邱ƂŃubNȂ悤ɂ邱Ƃł
 B

 :

   SET SJIS_NONBLOCK=1

 (l '1' ͈ӖȂ̂ŉł\܂)

=head1 MacJPerl ̋@\

 } Web ̏Qlɂ MacOS ɑΉĂ݂܂B@Ȃ߂ɃeXg
 łĂ܂B񍐁AoO񍐓ƂƂĂ肪łB
 
 sɂ͈ȉ̃\tgEFAKvłB
 1. MacPerl W[
 2. Mac::Files W[
 3. ToolServer
 4. MPW(Macintosh Programmer's Workshop)

=head1 oOƐ

oO񍐁Apb`}܂B

=over 2

=item * format

    IWi Perl Ƌ@\ł(ShiftJIS ɑΉĂ܂)B

=item * chdir

    perl5.005 łΏ chdir() 𐳏Ɏsł܂B

    DOS̃VXe($^O ̒l MSWin32, NetWare, symbian, dos ̂ꂩ
    ꍇ)́Aȉ̐܂B

    perl5.006 ܂ perl5.00800 ̏ꍇŕR[h(0x5C)ŏIfBNg
    w肵Ďsɂ jacode.pl CuKvłB

    perl5.008001ȍ~, perl5.010, perl5.012, perl5.014 ɂĕR[h(0x5C)
    IfBNgw肵ĎsƂAWin32 W[
    Win32::GetShortPathName() ɂĒZO擾łꍇ chdir() 
    ܂BAchdir() ̃JgfBNg
    Win32::GetShortPathName() ɂĎ擾ZOɂȂ܂B

    QlN
    Bug #81839
    chdir does not work with chr(0x5C) at end of path
    http://bugs.activestate.com/show_bug.cgi?id=81839

=item * ǂ݌

    ǂ݌(Ⴆ (?<=[A-Z]))O̓oCg̑oCgɌă}b`
    邱Ƃɂ͑ΏĂ܂B
    Ⴆ΁A'ACE' =~ /(?<=[A-Z])([ACE])/ sƃ}b` $1  'C'
    ɂȂ܂A͐܂B

=item * ӒlƂĂ Sjis::substr

    Sjis::substr  CORE::substr Ƃ͈قȂAӒlƂĈƂł܂B
    ̈ꕔύXꍇ́ASjis::substr 4Ԗڂ̈ƂĒu
    w肵܂B
    
    Sjis::substr($string, 13, 4, "JPerl");

=item * ϐ $`  $& ͋@\܂

    ȂȂ΁A
 
      'AAABBBCCC' =~ /BBB/;
 
    ƂXNvgXP[vƐK\̐擪Ƀ}`oCgAJ[O
    ̂߂̋LqǉA
 
      'AAABBBCCC' =~ /\G(?:[\x81-\x9F\xE0-\xFC][\x00-\xFF]|[^\x81-\x9F\xE0-\xFC])*?(?:BBB)@Esjis::m_matched/;
 
    ̕ $& Ɋ܂܂Ă܂łB
    L̎sʂ͈ȉ̂悤ɂȂ܂B 
      $'  ''       ('AAA' )
      $&  'AAABBB' ('BBB' )
      $`  'CCC'
 
    @
    XNvg̋Lq
 
      'AAABBBCCC' =~ /(BBB)/;
 
    ̂悤ɂāAK\Ŝ ( ... ) ň͂ŃLv`܂B
    GXP[ṽXNvg
 
      'AAABBBCCC' =~ /\G(?:[\x81-\x9F\xE0-\xFC][\x00-\xFF]|[^\x81-\x9F\xE0-\xFC])*?(?:(BBB))@Esjis::m_matched/;
 
    ̂悤ɂȂ̂ŁAsA
 
      $1  'BBB'
 
    ɂȂA$& ̑Ɏgp邱Ƃł܂B

=item * K\Kp镶̒̏

    L̂ƂAGXP[v̐K\ɂ̓}`oCgAJ[Ô
    ߂̋Lqǉ܂A̒Ɋ܂܂ \G ̐󂯂܂B
    perl5.006, perl5.008, perl5.010, perl5.012, perl5.014 ŎsꍇAΏ
    32,767oCg𒴂ʒuł̃}b`ׂƂŃ}b`܂B
    ȂA̍ۂɃG[xo͂܂B

    QlN
    Bug #89792
    \G can't treat over 32,767 octets
    http://bugs.activestate.com/show_bug.cgi?id=89792

=back

=head1 

̃vWFNg t  ina@cpan.org ɂĎn܂܂B

=head1 쌠

̃\tgEFA̓t[\tgEFAłBȂ Perl ƓCZX
̌ōĔzzyѕύXsƂo܂Bڂ perlartistic QƂ
B

̃\tgEFA͗Lpł邱ƂĔЕz܂A*S̖ۏ* 
łBƉ\̕ۏ؂̖ړIւ̓ḰAOɎꂽ̂
ߑS݂܂B

=head1 VtgJISR[hƂ({񏈗)

VtgJIŚA}CN\tgЂɂJꂽA{̃Rs[^ōł悭
p镄łBVtgJIŚuMS(Microsoft)vA܂́uSJIS
(ShiftJIS̗)vƂĂ΂Ă܂B

ē{̃Rs[^[U͔pЉgȂ߁A]Ƃ̌݊
ێړIŃVtgJISJ܂B

VtgJISɂẮA16i 0x81`0x9F ܂ 0xE0`0xEF ͈̔͂INebg
ɂ12INebg[hJn܂BẴINebǵAn܂
2INebg̑1INebgƂď܂B(2)INebǵA16i
0x40`0x7E ܂ 0x80`0xFC ͈̔͂lłȂ΂Ȃ܂B1INebg
͈͂͊gASCIIZbgA܂ŏʃrbgIɂȂ8rbgZbg͈̔
ɊSɎ܂Ă邱ƂɒڂĂB܂VtgJIŚApЉASCII/JIS
[}T|[gĂ܂B

ꕔ̃VtgJISdl(Ƀ[Jdl)ł́A[U`̃R[ḧAꍇɂ
͔pЉ󔒕̃R[hʒu`Ă܂B{iIȏ]ނ̂
΁Â悤ȃR[ḧR[hʒu͕ssłBƂ̂Â悤ȕ́A
ʂ̓{ꕄ(܂JISEUC)̃R[hʒuɕϊłȂ悤ɕĂ
܂łB

=head1 EBLyfBAɂuShift_JISv̒`

Shift_JIS (2009.09.17 14:00:00 JST). In Wikipedia: The Free Encyclopedia.
Retrieved from
http://ja.wikipedia.org/wiki/Shift_JIS

oT: t[SȎTwEBLyfBA(Wikipedia)x

Shift_JIS(IANAւ̓o^Bǂݕ́wVtgWXx)́Aݑ̃p\R
{\߂ɎgĂ镶R[hłBƎ̃R[hgĂ
A݂͕WĂJIS X 0208̕1ŋK肵ĂB

Microsoft̊ex_Shift_JIS̈ɂẮwMicrosoftR[hy[
W932xQƁBMac OS鈟ɂẮwMacJapanesexQƁB

Shift_JIS̒a
1980NAp\Rp16rbgCPU̕y܂āA\\ȃn[hEF
Ap\RXƔꂽB̂߁Ap\Rp̕
͍ĂB

Shift_JISuVtgJISR[hvƌĂŕW(R[h)̖ʂ݂̂
lc_邪Ał͕̖ʂɏœ_𓖂ĂB

̕ɂ́AsĂ悭pĂJIS C 6220(݂JIS X 0201)
8rbg(ȉupEpJiv)ƁAJIS C 6226(݂JIS X 0208A
ȉuv)̗WA\悤ƂBt@C̑傫AԂ
Zk}邽߃GXP[vV[PXȂō݉\ɂ邱ƂlĂB

JIS C 6220JIS C 62262͂ƂɁAISO 2022ŕW؂ւėp
݌vBISO 2022ɂƂÂł́ApApJiA
ꂼA8rbgԂ̒GL/GRƂ̈1(2)g
Ƃŕ\łBpƊ2GXP[vV[PXȂō݂
ȂApGLAGRɊ蓖Ă@BEUC-JṔA悻̂悤
ɎĂB

Ap\Rł͂łɁAJIS X 02018rbgA܂AGLɉpAGR
PoCgJ^Ji(pJ^Ji)蓖Ă邱ƂyĂBpƂPoC
gJ^Ji2𓮂Ƃ́ǍɂȂ邽ߔKvB
̂߁AISO 2022̘g̗̈Ɋ݂邱Ƃ͍̂łB

1982NA̕ʒu𕡎GɈړ(Vtg)AԂ̌Ԃɉ
ShiftJISaB邽߂ɂ́A1oCgڂƂāAISO 2022
ɂGR(A1(16)-FE(16))̈31cĂgp̈ɂ킦AISO 2022
ɂĔgpCR(80(16)-9F(16))̈gp邱ƂƂBAGL
(21(16)-7E(16))̈ɂẮAJIS X 0201̋Lɓ镔͋ɗ͔B
2oCgڂɂISO 2022Ƃ͈قȂApEpJiɎgpς݂̗̈
܂ށAGLACRAGRɂë̂قڑSĂgKvB

}CN\tg({@l)̌Ð식ɂƁAShift_JIS̐ɂ́AAX
L[A}CN\tg()AOHd@A}CN\tgEFAEA\VGCcA
fW^T[`()ւAɃAXL[̎RǑSƂȂč쐬
̂ƂBɑ΂ِƂāAsẅF́A}CN\t
gEFAEA\VGCcƎOHd@݂̂̋JƎ咣ĂBR{l̔
ɂ͎̓PƂ锭ĂB

Shift_JIS̕W
Shift_JIŚAWƂ̗̕܂ތ̖
邽߂̋ZpłB䂦AJIS X 0208̕W𗘗pĂ͂̂́A
ISO 2022̕̕j͈̔͂̊OɂB

ȂA݂ł́AJIS X 0208:1997̕1ɂāuVtg\vƂ
OŁAdl`ĂB́Aft@NgX^_[hƂȂĂZp
ɂĂ͏oƂAƂWĂ܂ƂӐ}{HƕW
 (JISC) ɂĂ̂ƂłB

JIS X 0208̊gKiłJIS X 0213ł́A2000N̏łŕ1Ƃ
Shift_JISX0213߂ꂽB2004N10ǉɔāAShift_JIS-2004
Ɩ̂ύXꂽB

IANAuShift_JISvƂOœo^ĂB

_ƌ_

_
1. SpƁAJIS X 0201Œ`锼pJi𓯈̃R[ȟn
   \łB
2. {ɂẮAMS-DOSœ{pR[hƂč̗pĈȗAp\
   RɂĈ|IȕyxȂ̕ɔׂăf[^
   \ (AWɂĂ͎x_JIS X 0208ŋK肳
   Ȃ@ˑ̊g{Ă邱ƂAgɊւĂ
   f[^\Ⴂ)B

_
1. pJî߂̗̈mۂ֌WAR[hV[NGX_ԍ́uv
   ̋؂ł͂ȂӏŕfĂB̂߁AR[hԍZŋ߂ۂ
   ώGȏKvłB
2. 2oCgڂ80(16)(ASCIĨR[ḧ)B̂߁A̋؂
   ɎԂBt@CAd̐擪當R[h肷ꍇ͂悢A
   납當R[h̔悤ƎvƁAň̏ꍇA擪܂łǂȂ
   ȂƂ邽߁AvO̍ɍHvKvɂȂB܂A̗
   Ɋ܂܂ꕔ̈̂̕߁A}`oCgEUC-JPAUTF-8ȂǂAv
   O~ÖB
3. JIS⏕\łȂB⏕̕Shift_JIS̃R[ho^
   ܂ȂB

2oCgڂ5CɂȂ肤邱Ƃɂ

Shift_JISł́Au\vu\vȂǈꕔ̎2oCgڂɁA5C(16)(Shift_JISł
LAASCIIȂǂł̓obNXbV)gpĂB̃vO~O
 (CAPerlABourne ShellȂǑ) ł́A5C(16)GXP[vƂ
BāA\[XR[h╶f[^̏ɂShift_JISz肵
ȂvO~Oł͖肪NB̖́A悤2oCgڂ
͈͂5C(16)܂Big5A܂ł͂邪GBKȂǂ̕R[hłB

܂A5C(16)ȊOɂĂގ̖肪邱ƂBƂ΁AUnix
MS-DOSȂǂ̃VF7C(16) (Shift_JISASCIIł̓o[eBJo[) ܂
(|A|A|A|A|A|A|Acc)t@CɎgp悤ƂƁA
pCvLƔFAɃt@C쐬ȂAǂݍ݂sǂ
Ȃ肷邱ƂB

݂łAVOoCgR[hΉ̃\tgEFAShift_JISŎgp
ƁAsȂǂ̓t@C̏Ȃǂɂ΂΂̖肪܂ƂB
sA2oCgڂ5C(16)̂ƂAߕƌĂсA̒ɂ
u\vu\vu\vu\vȂǈʂɎgppx̍[1]B

̖`Iȕ@ƂāA\[XR[hŜEUCR[hUTF-8Ȃ
ɕϊĂRpCs肷@B邢́u\\v
悤2oCgڂ̒OɃGXP[v5C(16)LqAߕ𕶎Ƃ
FȂǂ̕@(Perl Sjis\tgEFAȂ)Bŋ߂ł́A
̃vO~OꂪShift_JISɑΉ悤ɂȂ߁AShift_JIS܂
\[XR[hf[^Ă̖͋NȂȂÃ\tgEFA
Y𗘗pł͈ˑRA肪܂ƂB



pɂɌƂāAu\ȂvƂ񂪂̌f\tg
uȂvƉB

   \         
  8d5c 82ed 82c8 82a2
  obNXbVɂ5cƁA
  8d   82ed 82c8 82a2
             

uvƂ̂ƂŃfR[hē͐̕ɖ߂B܂l
Ɂu|\Evu|EvɉB 

   |    \   E
  8c7c 945c 8a45
  obNXbVɂ5cƁA
  8c7c 94   8a45
   |       E

  \ 2oCgڂ5C(16)ꗗ  (16i) ǂ݁EӖ 

  \   815C _bV
  \   835C Љ́uv
  \   845C L̃EB
  \/? 875C Windowsł̓[}9
            MacłGB(MKoCg)
  \   895C 킳B
  \   8A5C C
  \   8B5C ނB\
  \   8C5C BlB
  \   8D5C ܂B\
  \   8E5C JCRB{\
  \   8F5C 10B
  \   905C AB\
  \   915C AЁBu]v̈ẂB\
  \   925C B\y
  \   935C ͂B\t
  \   945C ̂B\
  \   955C 킷AЂ傤B\
  \   965C ΂AڂB\
  \   975C 炩߁AB\
  \   985C 낭B\
  \   995C ƁABuevّ̈̎
  \   9A5C B\
  \   9B5C B\a(ua̔񏑊)
  \   9C5C B퐶́uv̋
  \   9D5C B\
  \   9E5C Ȃ̕ʑ
  \   9F5C AA傤B
  \   E05C 炤AB
  \   E15C ӂAقB
  \   E25C ƂAւB
  \   E35C AB
  \   E45C łAB\
  \   E55C BaC\X
  \   E65C G̋
  \   E75C ̂̌Î
  \   E85C ΁B\()B
  \   E95C ܂B\
  \   EA5C oB̖B
  x   ED5C B
  x   EE5C 傭B
  \   FA5C 킽AB
  \   FB5C B

R[hԂɂ镶
Shift_JIS2oCgR[h̋Ԃ́A1oCg81(16)-9F(16)ȂтE0(16)-FC(16)A
2oCg40(16)-7E(16)Ȃт80(16)-FC(16)łBāA60~188=11280
A1oCgR[h158 (Xy[X܂݁ADEL͐)ł邽߁A
v11438ƂȂB

ȂAShift_JIS-2004ł́A2oCg11233A1oCg158̂߁A
v11391gpĂB

Shift_JISɂuVtgvƂ
ISO-2022-JP͎wV[PXŊƃAt@xbg؂ւ镄łB
܂AEUC-JP͕⏕ƔpJ^JiVOVtgňꎞIɐ؂ւĎg
łB̕ł́AeW̖ʂVtgR[hɂ
؂ւ(Vtg)ĂB

ȂAShift_JIŚwVtgxƂ͂̈Ӗł̃Vtgł͂ȂB܂Arbg
VtǵwVtgxłȂB́wVtgxƂ́A256~256̕ʂ̒ŕ
G"炷"ƂӖ́wVtgxłB

Shift_JISƋ_ԍ
Shift_JIS̑Ώۂɂ镶ZbǵAJIS X 0208łB̕
Wɂ́A_ԍƂTO݂B́A94~94̕\̍sƗ̔ԍ
̑głB

Shift_JISł́A8140(16)-FCFC(16)Ƃ悤ɁAJIS X 0208Ƃ͂܂
R[ȟnł邪AJIS X 0208vZɂό`̂ł邽߁A_ԍ
pĕ̃R[h|CgwƂBeɂẮAJIS X 0208
1`94ƓłBA@ˑł́AVtgJIS̕ԂtA
94̉ɂ120܂łgĂ邩̂悤ɈƂB95ȏ
́AISO/IEC 2022ɑJIS X 0208̍\ł݂͑Ȃ̂ŁA{͂B
x_Ǝ̔ȊTOłBȂAJIS X 0213̋Kïꕔł
Shift_JISX0213\ɂẮA1oCgF0(16)ȍ~2ʂ̕Ɋ蓖
ĂASƂ悤ȑ݂Ȃԍ͓oꂵȂB

ux-sjisvƁuMS_Kanjiv
ux-sjisvƁuMS_Kanjiv͂ƂɁAHTMLhLǵucharsetv̎w
uShift_JISv̕ʖƂĎgƂoB

ux-sjisvIANAɁuShift_JISvƂOo^OɁANetscape Navigator 2.0
ɂĎgĂGR[fBO̎wqłBꕔHTML\tg
ł̎wqgݍŎgĂB̂ߔF\ȃuEU邪A
uShift_JISvɏ邱Ƃ𐄏ĂB


=head1 ̃\tgEFAł "ShiftJIS"

̃\tgEFAł "ShiftJIS" ͏ĹuR[hԂɂ镶v
11438ׂĂ邱ƂڎwĂ܂B̂߂ɃASY2g
Ă܂B

* ASY 1

    INebg̕т當oƂA1INebgR[h2INebgR[h
    ̋ʂ͑1INebgR[ĥ݂ōs܂B2INebg͍l܂B

    1INebgR[h:
      0x00-0x80, 0xA0-0xDF, 0xFD-0xFF

    2INebgR[h:
      1INebg  0x81-0x9F, 0xE0-0xEF, 0xF0-0xFC
      2INebg  0x00-0xFF (ׂ)

    s1INebgR[h:
      0x81-0x9F, 0xE0-0xFC
      * ̍ŏIINebg2INebgR[h̑1INebgƓꍇ

ȉɃR[h\fڂ܂B

        1INebgR[h\

   0 1 2 3 4 5 6 7 8 9 A B C D E F 
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 0|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*| 0x00-0x80
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 1|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 2|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 3|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 4|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 5|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 6|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 7|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 8|*| | | | | | | | | | | | | | | |
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 9| | | | | | | | | | | | | | | | |
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 A|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*| 0xA0-0xDF
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 B|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 C|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 D|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 E| | | | | | | | | | | | | | | | |
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 F| | | | | | | | | | | | | |*|*|*| 0xFD-0xFF
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+

                                 2INebgR[h\
            1INebg                                    2INebg


   0 1 2 3 4 5 6 7 8 9 A B C D E F                 0 1 2 3 4 5 6 7 8 9 A B C D E F 
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 0| | | | | | | | | | | | | | | | |              0|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*| 0x00-0xFF
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 1| | | | | | | | | | | | | | | | |              1|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 2| | | | | | | | | | | | | | | | |              2|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 3| | | | | | | | | | | | | | | | |              3|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 4| | | | | | | | | | | | | | | | |              4|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 5| | | | | | | | | | | | | | | | |              5|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 6| | | | | | | | | | | | | | | | |              6|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 7| | | | | | | | | | | | | | | | |              7|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 8| |*|*|*|*|*|*|*|*|*|*|*|*|*|*|*| 0x81-0x9F    8|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 9|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|              9|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 A| | | | | | | | | | | | | | | | |              A|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 B| | | | | | | | | | | | | | | | |              B|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 C| | | | | | | | | | | | | | | | |              C|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 D| | | | | | | | | | | | | | | | |              D|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 E|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*| 0xE0-0xFC    E|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 F|*|*|*|*|*|*|*|*|*|*|*|*|*| | | |              F|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+


̍ŏIINebg2INebgR[h̑1INebgƓꍇ

słĂꂽAIɍ폜邱Ƃ͂܂B
Ⴆ΁AEsjis::chop ͂̃INebgԂ܂B

    *s* 1INebgR[h

   0 1 2 3 4 5 6 7 8 9 A B C D E F 
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 0| | | | | | | | | | | | | | | | |
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 1| | | | | | | | | | | | | | | | |
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 2| | | | | | | | | | | | | | | | |
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 3| | | | | | | | | | | | | | | | |
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 4| | | | | | | | | | | | | | | | |
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 5| | | | | | | | | | | | | | | | |
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 6| | | | | | | | | | | | | | | | |
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 7| | | | | | | | | | | | | | | | |
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 8| |M|M|M|M|M|M|M|M|M|M|M|M|M|M|M| 0x81-0x9F
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 9|M|M|M|M|M|M|M|M|M|M|M|M|M|M|M|M|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 A| | | | | | | | | | | | | | | | |
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 B| | | | | | | | | | | | | | | | |
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 C| | | | | | | | | | | | | | | | |
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 D| | | | | | | | | | | | | | | | |
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 E|M|M|M|M|M|M|M|M|M|M|M|M|M|M|M|M|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 F|M|M|M|M|M|M|M|M|M|M|M|M|M| | | |  0xE0-0xFC
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+


=head1 x_ SJIS R[hꗗ

http://home.m05.itscom.net/numa/cde/sjis-euc/sjis.html

 DEC PC                         0x00-0x7F, 0xA1-0xDF, (0x81-0x9F, 0xE0-0xFC)(0x40-0x7E, 0x80-0xFC)
 DEC WS                         0x00-0x7F, 0xA1-0xDF, (0x81-0x9F, 0xE0-0xFC)(0x40-0x7E, 0x80-0xFC)
 Fujitsu TrueType font (PC)     0x00-0x7F, 0xA1-0xDF, (0x81-0x9F, 0xE0-0xFC)(0x40-0x7E, 0x80-0xFC)
 Fujitsu FontCity font (PC)     0x00-0x7F, 0xA1-0xDF, (0x81-0x9F, 0xE0-0xFC)(0x40-0x7E, 0x80-0xFC)
 Hitachi PC                     0x00-0x7F, 0xA1-0xDF, (0x81-0x9F, 0xE0-0xFC)(0x40-0x7E, 0x80-0xFC)
 Hitachi WS                     0x00-0x7F, 0xA1-0xDF, (0x81-0x9F, 0xE0-0xFC)(0x40-0x7E, 0x80-0xFC)
 IBM                            0x00-0x7F, 0xA1-0xDF, (0x81-0x9F, 0xE0-0xFC)(0x40-0x7E, 0x80-0xFC)
 NEC Windows (PC)               0x00-0x7F, 0xA1-0xDF, (0x81-0x9F, 0xE0-0xFC)(0x40-0x7E, 0x80-0xFC)
 NEC DOS (PC)                   0x00-0x7F, 0xA1-0xDF, (0x81-0x9F, 0xE0-0xFC)(0x40-0x7E, 0x80-0xFC)
 SONY NEWS-OS                   0x00-0x7F, 0xA1-0xDF, (0x81-0x9F, 0xE0-0xFC)(0x40-0x7E, 0x80-0xFC)
 Sun Wabi                       0x00-0x7F, 0xA1-0xDF, (0x81-0x9F, 0xE0-0xFC)(0x40-0x7E, 0x80-0xFC)
 Unisys PC                      0x00-0x7F, 0xA1-0xDF, (0x81-0x9F, 0xE0-0xFC)(0x40-0x7E, 0x80-0xFC)
 HP Japan Japanese HP-15        0x00-0x7F, 0xA1-0xDF, (0x81-0x9F, 0xE0-0xFC)(0x40-0x7E, 0x80-0xFC)
 AT&T Japan                     0x00-0x7F, 0xA1-0xDF, (0x81-0x9F, 0xE0-0xFC)(0x40-0x7E, 0x80-0xFC)
 Mitsubishi Electric FONTRUNNER 0x00-0x7F, 0xA1-0xDF, (0x81-0x9F, 0xE0-0xFC)(0x40-0x7E, 0x80-0xFC)
 Concurrent Japan               0x00-0x7F, 0xA1-0xDF, (0x81-0x9F, 0xE0-0xFC)(0x40-0x7E, 0x80-0xFC)
 Informix ASCII INFORMIX V6 ALS 0x00-0x7F, 0xA1-0xDF, (0x81-0x9F, 0xE0-0xFC)(0x40-0x7E, 0x80-0xFC), (0xFD)(0xA1-0xFE)(0xA1-0xFE)
 Oracle Oracle7 (Release 7.1.3) 0x00-0x7F, 0xA1-0xDF, (0x81-0x9F, 0xE0-0xFC)(0x00-0xFF)
 Sybase SQL Server, Open Server 0x00-0x7F, 0xA1-0xDF, (0x81-0x9F, 0xE0-0xFC)(0x40-0x7E, 0x80-0xFC)
 
 {񏈗(ISBN 4-89052-708-7)
 
 Hewlett-Packard HP-15          0x00-0x7F, 0xA1-0xDF, (0x80-0xA0, 0xE0-0xFE)(0x21-0x7E, 0x80-0xFF)


* ASY 2

    ASY 1 ɂւ炸Atr/// ɂ蕶͈̔͂w肳ꂽꍇ͈ȉ̕
    ݂̂LƂȂ܂B

    1INebgR[h:
      0x00-0x80, 0xA0-0xDF, 0xFD-0xFF

    2INebgR[h:
      1INebg  0x81-0x9F, 0xE0-0xEF, 0xF0-0xFC
      2INebg  0x40-0x7E, 0x80-0xFC

Ⴆ΁A[\x81\x00-\x82\xFF] Əꂽꍇ [\x81\x82][\x40-\x7E\x80-\xFC] 
Ӗ܂B

ȉɃR[h\fڂ܂B

        1INebgR[h\

   0 1 2 3 4 5 6 7 8 9 A B C D E F 
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 0|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*| 0x00-0x80
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 1|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 2|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 3|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 4|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 5|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 6|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 7|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 8|*| | | | | | | | | | | | | | | |
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 9| | | | | | | | | | | | | | | | |
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 A|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*| 0xA0-0xDF
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 B|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 C|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 D|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 E| | | | | | | | | | | | | | | | |
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 F| | | | | | | | | | | | | |*|*|*| 0xFD-0xFF
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+


                                 2INebgR[h\
            1INebg                                    2INebg

   0 1 2 3 4 5 6 7 8 9 A B C D E F                 0 1 2 3 4 5 6 7 8 9 A B C D E F 
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 0| | | | | | | | | | | | | | | | |              0| | | | | | | | | | | | | | | | |
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 1| | | | | | | | | | | | | | | | |              1| | | | | | | | | | | | | | | | |
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 2| | | | | | | | | | | | | | | | |              2| | | | | | | | | | | | | | | | |
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 3| | | | | | | | | | | | | | | | |              3| | | | | | | | | | | | | | | | |
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 4| | | | | | | | | | | | | | | | |              4|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*| 0x40-0x7E
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 5| | | | | | | | | | | | | | | | |              5|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 6| | | | | | | | | | | | | | | | |              6|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 7| | | | | | | | | | | | | | | | |              7|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*| |
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 8| |*|*|*|*|*|*|*|*|*|*|*|*|*|*|*| 0x81-0x9F    8|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*| 0x80-0xFC
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 9|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|              9|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 A| | | | | | | | | | | | | | | | |              A|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 B| | | | | | | | | | | | | | | | |              B|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 C| | | | | | | | | | | | | | | | |              C|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 D| | | | | | | | | | | | | | | | |              D|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 E|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*| 0xE0-0xFC    E|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 F|*|*|*|*|*|*|*|*|*|*|*|*|*| | | |              F|*|*|*|*|*|*|*|*|*|*|*|*|*| | | |
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+


=head1 ڕWƂĂ

vO~O Perl 3 VOLUME 1 (ISBN 4-87311-096-3)
15 Unicode Q

Unicode T|[g perl ɓȑÓAeq Zq́A2̃XJ[ϐɂ
ĕ\ꂽoCgׂĂ܂Bperl5.8 ȍ~Aeq ́A2̃oCgׂ
Ɠ UTF8 tOl܂B

  perl5.8 ȍ~̏񏈗f
 
    +----------------------+---------------------+
    |     Text strings     |                     |
    +----------+-----------|    Binary strings   |
    |   UTF8   |  Latin-1  |                     |
    +----------+-----------+---------------------+
    | UTF8     |            Not UTF8             |
    | Flagged  |            Flagged              |
    +--------------------------------------------+
    http://perl-users.jp/articles/advent-calendar/2010/casual/4
 
    ̐}oȂƃvO܂B
 
    (ǂ Latin-1 ʈ̂ł傤H)

ʓIɂ̕ύX́Aߋ̃XNvgƐVXNvg̊Ԃɑ傫ȍa܂B
͂◼҂̃XNvg̓R[h݂ɍėp邱Ƃł܂B܂V@
vO}ɕS邽߁AXNvgׂĒû͂܂܂
Ǝv܂B

V@ŖƂȂĂ邱Ƃ UTF8 tO͎ۂ̕̕ƈvȂ
łBōXNvg͂̃fobȎO UTF8 tOɂăfobOȂ
΂Ȃ܂B

Ő̂̕@ɖ߂ƂɂāAǂ̂悤ɉ̂ Programming Perl, 3rd ed.
(M vO~OPerl 3) 402y[Wxp܂傤B

  Sjis\tgEFApɂ񏈗f
 
    +-----------------------------------+
    |           Octet Strings           | oCif[^
    +-----------------------------------+
    |         Character Strings         | eLXgf[^
    +-----------------------------------+
    |      ASCII Compatible Encoding    | ShiftJIS Ȃ
    +-----------------------------------+
              (UTF8tOȂ)
 
    ̐}ɈӖ͂Ȃ߁AoKv܂B

zIɂ́Aȉ5̃S[悤ƍlĂ܂B

=over 2

=item * S[1

    ̃oCgw̃XNvǵAȑOẴoCgw̃f[^ɑ΂
    āAȑOƓlɓ삷ׂłB

     ShiftJIS oCgwł ASCII  JIS X 0201 Ƒg킹ėp
    ł悤݌vꂽƂɂāAłɒBĂ܂B

=item * S[2

    ̃oCgw̃XNvǵAɁA(邱ƂK؂ł)
    Vw̃f[^ɑ΂Ă삷悤ɂȂׂłB

    g݊֐ length, substr, index, rindex, pos Ȃǂ̒̕ʒu
    ͍̂܂łǂ1INebg 1 Ɛ܂B̕ɂĉ͉
    ܂B2INebgR[h1 length  2 ɂȂ܂B

    AXNvg̐K\́A}`oCĝ߂̃AJ[O
    LqKv܂AȂɑẴ\tgEFAs܂B

    S[1ƃS[2̓e}܂B

                                   GOAL#1  GOAL#2
                            (a)     (b)     (c)     (d)     (e)
          +--------------+-------+-------+-------+-------+-------+
          | data         |  Old  |  Old  |  New  |  Old  |  New  |
          +--------------+-------+-------+-------+-------+-------+
          | script       |  Old  |      Old      |      New      |
          +--------------+-------+---------------+---------------+
          | interpreter  |  Old  |              New              |
          +--------------+-------+-------------------------------+
          Old --- ̃oCgw
          New --- Vw

    f[^AXNvgAC^v^̐VEɊւāA (a)  (e) ܂ł
    g܂B̕ꂽɑ݂Ȃ Encode W[
    ̃\tgEFAAё݂Ă JPerl Ă݂܂傤B

                            (a)     (b)     (c)     (d)     (e)
                                          JPerl           Encode,Sjis
          +--------------+-------+-------+-------+-------+-------+
          | data         |  Old  |  Old  |  New  |  Old  |  New  |
          +--------------+-------+-------+-------+-------+-------+
          | script       |  Old  |      Old      |      New      |
          +--------------+-------+---------------+---------------+
          | interpreter  |  Old  |              New              |
          +--------------+-------+-------------------------------+
          Old --- ̃oCgw
          New --- Vw

    JPerl ƂĂDĂ闝R (c) ̈ʒuɂ邩łBȂ킿{ꏈ
    s߂ɃXNvgɓʂȋLqsKv܂B

    ΏƓIȂ̂ Encode W[₱̃\tgEFAɂ "use Sjis;" Lq
    ꍇłB̏ꍇ͐VȃXNvg̏Kv܂B

=item * S[3

    XNvǵAVw[hłAȑÕoCgw[hƓXs[
    hœ삷ׂłB

    ͖BāAȉ̎ԂKv́B

    (1) XNvgGXP[vāAoCgw Perl ň悤ɏ邽߂
     ԁBAꂽXNvg͕ۑł邽߁A񂩂͂̎ԂȂ
     Ƃ\łB

    (2) GXP[vꂽXNvg}`oCgAJ[OsȂA
     K\s鎞ԁB

    łɑ݂ ASCII f[^11INebgɃpbNĂ܂B
    f[^ƌ݊ۂȂ當𑝂₻ƂƁAISO-2022 ̂悤ɃGXP[
    vV[PXKvłAShiftJIS  UTF-8 ̂悤 "GXP[vrbg"
    KvɂȂ肵܂B̃GXP[v邽߁AȑOƓXs[
    hœ삷ׂłƂ͖̂ȖڕWƎv܂B

=item * S[4

    Perl ́AoCgw Perl ƕw Perl Ɏ}ꂹɁA1̌
    葱ׂłB

    JPerl  Perl 𕪊򂳂Ȃ悤ɂ邽߂ɁAC^v^𕪊򂳂܂B
    ł Perl RA`[̓C^v^̕]łȂ̂ł傤BʓIPerl
    ꂪ򂵁AR~jeB͏k]VȂ܂B

    oCgw perl ͂łɃoCif[^Ƃł邽߁Aw
    perl ʗĂō쐬Kv͂܂B̃\tgEFA͒PȂ Perl ̃Av
    P[VvOłAtB^vOƂč쐬Ă܂B
    {Iɂ perl słȂΓ삷ł傤B

    ɖ Perl XNvgŉ悤ƂȂAPerl R~jeB̃T|[g
    𓾂ł傤B

=item * S[5

    JPerl [U Perl  JPerl ێł悤ɂȂB

    JPerl Ȃ̂΂ɂ܂悤 ...

=back

Programming Perl, 3rd ed. ꂽɂ́AUTF8 tO͐܂Ă炸APerl 
ȒPȎdȒPɂł悤ɐ݌vĂ܂B̃\tgEFÂ͓悤
vO~O񋟂܂B

=head1 Ql

 vO~OPerl 
 By Larry Wall, Tom Christiansen, Randal L. Schwartz, ߓ Ð 
 1997N12 s
 759y[W
 ISBN 4-900900-48-6
 http://www.oreilly.co.jp/out/pperl/index.htm

 vO~OPerl 3 VOLUME 1
 By Larry Wall, Tom Christiansen, Jon Orwant, ߓ Ð 
 2002N09 s
 756y[W
 ISBN 4-87311-096-3
 http://www.oreilly.co.jp/books/4873110963/

 vO~OPerl 3 VOLUME 2
 By Larry Wall, Tom Christiansen, Jon Orwant, ߓ Ð 
 2002N09 s
 680y[W
 ISBN 4-87311-097-1
 http://www.oreilly.co.jp/books/4873110971/

 PerlNbNubN 2 VOLUME 1
 By Tom Christiansen, Nathan Torkington, Shibuya Perl Mongers Ė, ЃhLgVXe 
 2004N09 s
 752y[W
 ISBN 4-87311-202-8
 http://www.oreilly.co.jp/books/4873112028/

 PerlNbNubN 2 VOLUME 2
 By Tom Christiansen, Nathan Torkington, Shibuya Perl Mongers Ė, ЃhLgVXe 
 2004N09 s
 464y[W
 ISBN 4-87311-203-6
 http://www.oreilly.co.jp/books/4873112036/

 PerlNCbNt@X
 By Stephen Spainhour, Ellen Siever, Nathan Patwardhan, ߓ Ð,  \ Ė
 2000N03 s
 784y[W
 ISBN 4-900900-72-9
 http://www.oreilly.co.jp/books/4900900729/

 ߂ĂPerl Win32VXe
 Randal L. Schwartz, Erik Olson, Tom Christiansen , Ln OY Ė, Ό q_ 
 1998N11 s
 348y[W
 ISBN 4-900900-79-6
 http://www.oreilly.co.jp/books/4900900796/

 ߂ĂPerl 5
 Randal L. Schwartz, Tom Phoenix, brian d foy 
 2009N1024 
 424y[W
 ISBN978-4-87311-427-9
 http://www.oreilly.co.jp/books/9784873114279/

 Perl\[XLbg - UNIX
 Futato, Irving, Jepson, Patwardhan, Siever , CG[[x R{ _ 
 ISBN4-900900-65-6

 {񏈗
 Understanding Japanese Information Processing
 By Ken Lunde, t ,   
 1995N8 s
 496y[W
 ISBN 4-89052-708-7

 CJKV؉z񏈗
 Chinese, Japanese, Korean & Vietnamese Computing
 By Ken Lunde,  , t  
 2002N12 s
 1172y[W
 ISBN 4-87311-108-0
 http://www.oreilly.co.jp/books/4873111080/

 ڐ K\ 2
 By Jeffrey E. F. Friedl, ca  
 2003N05 s
 464y[W
 ISBN 4-87311-130-7
 http://www.oreilly.co.jp/books/4873111307/

 ڐ K\ 3
 By Jeffrey E. F. Friedl, ЃOe[^ O 
 2008N04 s
 528y[W
 ISBN 978-4-87311-359-3
 http://www.oreilly.co.jp/books/9784873113593/

 K\NbNubN
 Jan Goyvaerts, Steven Levithan ,  O 
 2010N04 s
 552y[W
 ISBN978-4-87311-450-7
 http://www.oreilly.co.jp/books/9784873114507/

 PerlvO~O
 Larry Wall, Randal L.Schwartz, ߓ Ð 
 1993N2s
 ISBN 4-89052-384-7
 http://www.context.co.jp/~cond/books/old-books.html

 JIST
 Ŗ ki Ғ
 1456 
 ISBN 4-542-20129-5
 http://www.webstore.jsa.or.jp/lib/lib.asp?fn=/manual/mnl01_12.htm

 UNIX MAGAZINE
 1993N8
 172y[W
 T1008901080816 G08901-8
 http://ascii.asciimw.jp/books/magazines/unix.shtml

 MacPerl
 Vicki Brown, Chris Nandor , ()RXEvlbg 
 1999N03 s
 399y[W
 ISBN 4-7561-3068-2

 Macintoshf[^pp
 Γc L 
 230y[W
 1995N2 s
 ISBN 4-89563-408-6

 MPWvO~Ou
 Handmade Intelligence 
 1992N8 s
 346y[W
 ISBN 4-7561-0963-2

 J E, ۉK\CuȂ
 http://lc.linux.or.jp/lc2001/papers/dfa-i18n-paper.pdf
 http://lc.linux.or.jp/lc2002/papers/hasegawa0918h.pdf
 http://lc.linux.or.jp/lc2002/papers/hasegawa0918p.pdf
 http://www.j-tokkyo.com/2003/G06F/JP2003-242179.shtml

 Oc א, }`oCgZbgpK\RpC\@yуvO 
 http://patent.astamuse.com/ja/published/JP/No/2007102744

 YAMAGAKI Norio, }`oCgƍpLI[g}gVXe
 http://www.wipo.int/pctdb/ja/wo.jsp?WO=2009116646&IA=JP2009055515

 ֘A\tgEFA
 http://search.cpan.org/dist/jacode/
 http://search.cpan.org/dist/Char/

 BackPAN
 http://backpan.perl.org/authors/id/I/IN/INA/

=head1 ӎ

̃\tgEFÁAȉ̕X̍쐬\tgEFAѕ̂ɂ쐬
܂BSĂ̕Ɋӂ܂B

 R Ǒ, VtgJIS̃fUC̘b
 ttp://furukawablog.spaces.live.com/Blog/cns!1pmWgsL289nm7Shn7cS0jHzA!2225.entry (N؂)
 ttp://shino.tumblr.com/post/116166805/1981-us-jis
 (擪 'h' tăANZXĂ)
 http://www.wdic.org/w/WDIC/%E3%82%B7%E3%83%95%E3%83%88JIS

 Larry Wall, Perl
 http://www.perl.org/

 ̑ a, jcode.pl
 ftp://ftp.iij.ad.jp/pub/IIJ/dist/utashiro/perl/

 Jeffrey E. F. Friedl, Mastering Regular Expressions
 http://www.oreilly.com/catalog/regex/index.html

 A ms, Shift-JISeLXg𐳂
 http://homepage1.nifty.com/nomenclator/perl/shiftjis.htm

 ܂ 䂫Ђ낳, Ruby on Perl(s)
 http://www.rubyist.net/~matz/slides/yapc2006/

  av, jperl[U[̂߂
 http://homepage1.nifty.com/kazuf/jperl.html

 Bruce., Unicode in Perl
 http://www.rakunet.org/tsnet/TSabc/18/546.html

 a G, WindowsPerl 5.8/5.10gȂ
 http://www.aritia.org/hizumi/perl/perlwin.html

 ˖{ q, Perl/Windowsł̃t@CpX
 http://digit.que.ne.jp/work/wiki.cgi?Perl%E3%83%A1%E3%83%A2%2FWindows%E3%81%A7%E3%81%AE%E3%83%95%E3%82%A1%E3%82%A4%E3%83%AB%E3%83%91%E3%82%B9

 chaichanPaPa, VtgJIS̃t@CɃ}b`Ă݂
 http://d.hatena.ne.jp/chaichanPaPa/20080802/1217660826

  Iv, Jperl
 http://homepage2.nifty.com/kipp/perl/jperl/

 n , Jperl
 http://www.cpan.org/src/5.0/jperl/
 http://search.cpan.org/~watanabe/
 ftp://ftp.oreilly.co.jp/pcjp98/watanabe/jperlconf.ppt

 Chuck Houpt,  qq, MacJPerl
 http://habilis.net/macjperl/index.j.html

 Ί_ ꂳ, Pod-PerldocJp, _Perl̐Eւ悤
 http://search.cpan.org/dist/Pod-PerldocJp/
 http://gihyo.jp/dev/serial/01/modern-perl/0031
 http://gihyo.jp/dev/serial/01/modern-perl/0032
 http://gihyo.jp/dev/serial/01/modern-perl/0033

  e, Encode W[
 http://search.cpan.org/dist/Encode/
 http://www.dan.co.jp/~dankogai/yapcasia2006/slide.html

 Juerd, Perl Unicode Advice
 http://juerd.nl/site.plp/perluniadvice

 daily dayflower, 2008-06-25 perluniadvice
 http://d.hatena.ne.jp/dayflower/20080625/1214374293

 Jesse Vincent, Compatibility is a virtue
 http://www.nntp.perl.org/group/perl.perl5.porters/2010/05/msg159825.html

 Tokyo-pm ۑ
 http://mail.pm.org/pipermail/tokyo-pm/
 http://mail.pm.org/pipermail/tokyo-pm/1999-September/001844.html
 http://mail.pm.org/pipermail/tokyo-pm/1999-September/001854.html

 ruby-list
 http://blade.nagaokaut.ac.jp/ruby/ruby-list/index.shtml
 http://blade.nagaokaut.ac.jp/cgi-bin/scat.rb/ruby/ruby-list/2440
 http://blade.nagaokaut.ac.jp/cgi-bin/scat.rb/ruby/ruby-list/2446
 http://blade.nagaokaut.ac.jp/cgi-bin/scat.rb/ruby/ruby-list/2569
 http://blade.nagaokaut.ac.jp/cgi-bin/scat.rb/ruby/ruby-list/9427
 http://blade.nagaokaut.ac.jp/cgi-bin/scat.rb/ruby/ruby-list/9431
 http://blade.nagaokaut.ac.jp/cgi-bin/scat.rb/ruby/ruby-list/10500
 http://blade.nagaokaut.ac.jp/cgi-bin/scat.rb/ruby/ruby-list/10501
 http://blade.nagaokaut.ac.jp/cgi-bin/scat.rb/ruby/ruby-list/10502
 http://blade.nagaokaut.ac.jp/cgi-bin/scat.rb/ruby/ruby-list/12385
 http://blade.nagaokaut.ac.jp/cgi-bin/scat.rb/ruby/ruby-list/12392
 http://blade.nagaokaut.ac.jp/cgi-bin/scat.rb/ruby/ruby-list/12393
 http://blade.nagaokaut.ac.jp/cgi-bin/scat.rb/ruby/ruby-list/19156

=cut

