use strict;
use warnings;
use Test::More;
use Test::Exception;
use Data::Dumper;

my $pkg;

BEGIN {
    $pkg = 'Catmandu::Importer::MediaHaven';
    use_ok $pkg;
}
require_ok $pkg;

my $url  = $ENV{MEDIAHAVEN_URL} || "";
my $user = $ENV{MEDIAHAVEN_USER} || "";
my $pwd  = $ENV{MEDIAHAVEN_PWD} || "";

SKIP: {
    skip "No Mediahaven server environment settings found (MEDIAHAVEN_URL,"
	 . "MEDIAHAVEN_USER,MEDIAHAVEN_PWD).",
	100 if (! $url || ! $user || ! $pwd);

    my $importer = Catmandu->importer('MediaHaven', url => $url , username => $user , password => $pwd);

    ok $importer , 'got an importer';

    my $item = $importer->first;

    if ($item) {
        ok $item , 'got an item';
    }
}

done_testing;
