# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl 1.t'

# this code is written in Unicode/UTF-8 character-set
# including Japanese letters.

use strict;
use warnings;

use Test::More tests => 7;

use Encode;

BEGIN { use_ok('Lingua::JA::Fold') };

my $text = decode('utf8', 'かんじ	漢字');
my $obj = Lingua::JA::Fold->new($text);
isa_ok($obj, 'Lingua::JA::Fold');
########################################################################
# replace a [TAB] with 4 of [SPACE]s.
$obj->tab2space(4);
my $got = $obj->output;
$got = encode('utf8', $got);
my $expected = 'かんじ    漢字';
is ($got, $expected,
	'[TAB] -> [SPACE] convert');
########################################################################
# convert half pitch 'Kana' letters to full pitch ones.
$text = decode('utf8', 'ｱｲｳｴｵ');
my $obj2 = Lingua::JA::Fold->new($text);
$obj2->kana_half2full;
$got = $obj2->output;
$got = encode('utf8', $got);
$expected = 'アイウエオ';
is ($got, $expected,
	'from half-pitch to full-pitch \'Kana\' convert');
########################################################################
# fold the text under 2 full pitch letters par a line.
$text = decode('utf8', 'abcdeかんじ漢字');
my $obj3 = Lingua::JA::Fold->new($text);
$obj3->fold(2);
$got = $obj3->output;
$got = encode('utf8', $got);
$expected = 'abcd
eか
んじ
漢字';
is ($got, $expected,
	'folding: a short text');
########################################################################
# long text trial
$text = decode('utf8', 'apougaobuaEmailアドレスも必須です（こちらから返事をする際に必要となりますので、アドレスの記入ミスをなさらぬようご注意下さい）。改行は、原則として段落を変えたい時のみ使用するgaoubaようにしてください。
aaaa手a動で行を折り返して長さを揃える必要はありません。 作成中に誤って消してしまった場合はショックが大きいものです。特に長文の場合などは、一旦、テキストエディタやワープロ等で原稿を作成してから、それをメールの書き込み欄にコピー＆ペーストして送信するやり方にすれば安aaa全です。
 Emailアドレスも必須です（こちらから返事をoubabaする際に必要となりますので、アドレスの記入ミスをなさらぬようご注意下さい）。改行は、原則として段落を変えたい時のみ使用するようにしてください。aaaa手a動で行を折り返して長さを揃える必要はありません。作成中に誤って消してしまった場合はショックが大きいもagaのです。
特にagabb長文の場合などは、一旦、テキストエディタやワープロ等で原稿を作成してから、それをメールの書き込み欄にコピー＆ペーストして送信するやり方にすれば安全です。Emailアドレスも必須です（こちらから返事をする際に必要となりますので、アドレスの記入ミスをなさらぬようご注意下さい）。 改行は、原則として段落を変えたい時のみ使用するようにしてください。aaaa手a動で行を折り返して長さを揃える必要はありません。 
作成中に誤って消してしまった場合はショックが大きいものです。特に長文の場合などは、一旦、テキストエディタやワープロ等で原稿を作成してから、それをメールの書き込み欄にコピー＆ペーストして送信するやり方にすれば安全です。');
my $obj4 = Lingua::JA::Fold->new($text);
$obj4->fold(20);
$got = $obj4->output;
$got = encode('utf8', $got);
$expected = 'apougaobuaEmailアドレスも必須です（こち
らから返事をする際に必要となりますので、
アドレスの記入ミスをなさらぬようご注意下
さい）。改行は、原則として段落を変えたい
時のみ使用するgaoubaようにしてください。
aaaa手a動で行を折り返して長さを揃える必
要はありません。 作成中に誤って消してし
まった場合はショックが大きいものです。特
に長文の場合などは、一旦、テキストエディ
タやワープロ等で原稿を作成してから、それ
をメールの書き込み欄にコピー＆ペーストし
て送信するやり方にすれば安aaa全です。
 Emailアドレスも必須です（こちらから返事
をoubabaする際に必要となりますので、アド
レスの記入ミスをなさらぬようご注意下さい
）。改行は、原則として段落を変えたい時の
み使用するようにしてください。aaaa手a動
で行を折り返して長さを揃える必要はありま
せん。作成中に誤って消してしまった場合は
ショックが大きいもagaのです。
特にagabb長文の場合などは、一旦、テキス
トエディタやワープロ等で原稿を作成してか
ら、それをメールの書き込み欄にコピー＆ペ
ーストして送信するやり方にすれば安全です
。Emailアドレスも必須です（こちらから返
事をする際に必要となりますので、アドレス
の記入ミスをなさらぬようご注意下さい）。
 改行は、原則として段落を変えたい時のみ
使用するようにしてください。aaaa手a動で
行を折り返して長さを揃える必要はありませ
ん。 
作成中に誤って消してしまった場合はショッ
クが大きいものです。特に長文の場合などは
、一旦、テキストエディタやワープロ等で原
稿を作成してから、それをメールの書き込み
欄にコピー＆ペーストして送信するやり方に
すれば安全です。';
is ($got, $expected,
	'folding: long text');
########################################################################
# special long text trial
my $obj5 = Lingua::JA::Fold->new($text);
$obj5->fold_mixed(20);
$got = $obj5->output;
$got = encode('utf8', $got);
$expected = 'apougaobuaEmailアドレスも
必須です（こちらから返事をする際に必要と
なりますので、アドレスの記入ミスをなさら
ぬようご注意下さい）。改行は、原則として
段落を変えたい時のみ使用するgaouba
ようにしてください。
aaaa手a動で行を折り返して長さを揃え
る必要はありません。 作成中に誤って消し
てしまった場合はショックが大きいものです
。特に長文の場合などは、一旦、テキストエ
ディタやワープロ等で原稿を作成してから、
それをメールの書き込み欄にコピー＆ペース
トして送信するやり方にすれば安aaa全で
す。
 Emailアドレスも必須です（こちらか
ら返事をoubabaする際に必要となりま
すので、アドレスの記入ミスをなさらぬよう
ご注意下さい）。改行は、原則として段落を
変えたい時のみ使用するようにしてください
。aaaa手a動で行を折り返して長さを揃
える必要はありません。作成中に誤って消し
てしまった場合はショックが大きいもaga
のです。
特にagabb長文の場合などは、一旦、テ
キストエディタやワープロ等で原稿を作成し
てから、それをメールの書き込み欄にコピー
＆ペーストして送信するやり方にすれば安全
です。Emailアドレスも必須です（こち
らから返事をする際に必要となりますので、
アドレスの記入ミスをなさらぬようご注意下
さい）。 改行は、原則として段落を変えた
い時のみ使用するようにしてください。aa
aa手a動で行を折り返して長さを揃える必
要はありません。 
作成中に誤って消してしまった場合はショッ
クが大きいものです。特に長文の場合などは
、一旦、テキストエディタやワープロ等で原
稿を作成してから、それをメールの書き込み
欄にコピー＆ペーストして送信するやり方に
すれば安全です。';
is ($got, $expected,
	'folding: ignore difference whether full or half');
