# Test to see if a Geo::ReadGRIB object can return the 
# expected parameter data.
#
# In this case there are two 180 degree places for each lat,
# one on each edge of the flat grid, and 
# this test makes sure they are the same value
# 
# For this to work there needs to be a specific sample GRIB file
# and the module has to be able to find wgrib.exe 

BEGIN{ unshift @INC, '.'}


use Test::More tests => 603;
use strict;
use warnings;


###########################################################################
# Test for offset but on 64bit uselongdouble
############################################################################

use Geo::ReadGRIB;

## Find path to test file
my $TEST_FILE;
foreach my $inc (@INC) {
   if (-e "$inc/Geo/Sample-GRIB/2009100900_P000.grib") {
      $TEST_FILE = "$inc/Geo/Sample-GRIB/2009100900_P000.grib";
      last;
   }  
}

ok(-e "$TEST_FILE") or
   diag("Path to sample GRIB file not found");

my $w = Geo::ReadGRIB->new("$TEST_FILE");

my @wegot1 = qw/600 1200 1802 2402 3004 3605 4205 4807 5407 6009 6610 7210 7812 8412 9014 9615 10215 10817 11417 12019 12620 13220 13822 14422 15024 15625 16225 16827 17427 18029 18630 19230 19832 20433 21034 21635 22235 22837 23438 24039 24640 25240 25842 26443 27044 27645 28245 28847 29448 30049 30650 31250 31852 32453 33054 33655 34256 34856 35458 36059 36660 37261 37861 38463 39064 39665 40266 40867 41468 42069 42670 43271 43872 44473 45074 45675 46276 46877 47478 48079 48680 49281 49882 50483 51084 51685 52286 52887 53488 54089 54690 55291 55892 56493 57094 57695 58296 58897 59498 60099 60700 61301 61902 62503 63104 63705 64306 64907 65508 66109 66710 67311 67912 68513 69113 69715 70316 70917 71518 72118 72720 73321 73922 74523 75123 75725 76326 76927 77528 78129 78730 79331 79932 80533 81134 81735 82336 82937 83538 84139 84740 85341 85942 86543 87144 87745 88346 88947 89548 90149 90750 91351 91952 92553 93154 93755 94356 94957 95558 96159 96760 97361 97962 98563 99164 99765 100366 100967 101568 102169 102770 103371 103972 104573 105174 105775 106376 106977 107578 108179 108780 109381 109982 110583 111184 111785 112386 112987 113588 114189 114790 115391 115992 116593 117194 117795 118396 118997 119598 120199 120800 121401 122002 122603 123204 123805 124406 125007 125608 126209 126810 127411 128012 128613 129214 129815 130416 131017 131618 132219 132820 133421 134022 134622 135224 135825 136426 137027 137627 138229 138830 139431 140032 140632 141234 141835 142436 143037 143637 144239 144840 145441 146042 146642 147244 147845 148446 149047 149647 150249 150850 151451 152052 152652 153254 153855 154456 155057 155658 156259 156860 157461 158062 158663 159264 159865 160466 161067 161668 162269 162870 163471 164072 164673 165274 165875 166476 167077 167678 168279 168880 169481 170082 170683 171284 171885 172486 173087 173688 174289 174890 175491 176092 176693 177294 177895 178496 179097 179698 180299 180900/;

my @wegot2 = qw/0 600 1202 1802 2404 3005 3605 4207 4807 5409 6010 6610 7212 7812 8414 9015 9615 10217 10817 11419 12020 12620 13222 13822 14424 15025 15625 16227 16827 17429 18030 18630 19232 19833 20434 21035 21635 22237 22838 23439 24040 24640 25242 25843 26444 27045 27645 28247 28848 29449 30050 30650 31252 31853 32454 33055 33656 34256 34858 35459 36060 36661 37261 37863 38464 39065 39666 40267 40868 41469 42070 42671 43272 43873 44474 45075 45676 46277 46878 47479 48080 48681 49282 49883 50484 51085 51686 52287 52888 53489 54090 54691 55292 55893 56494 57095 57696 58297 58898 59499 60100 60701 61302 61903 62504 63105 63706 64307 64908 65508 66110 66711 67312 67913 68513 69115 69716 70317 70918 71518 72120 72721 73322 73923 74523 75125 75726 76327 76928 77529 78130 78731 79332 79933 80534 81135 81736 82337 82938 83539 84140 84741 85342 85943 86544 87145 87746 88347 88948 89549 90150 90751 91352 91953 92554 93155 93756 94357 94958 95559 96160 96761 97362 97963 98564 99165 99766 100367 100968 101569 102170 102771 103372 103973 104574 105175 105776 106377 106978 107579 108180 108781 109382 109983 110584 111185 111786 112387 112988 113589 114190 114791 115392 115993 116594 117195 117796 118397 118998 119599 120200 120801 121402 122003 122604 123205 123806 124407 125008 125609 126210 126811 127412 128013 128614 129215 129816 130417 131017 131619 132220 132821 133422 134022 134624 135225 135826 136427 137027 137629 138230 138831 139432 140032 140634 141235 141836 142437 143037 143639 144240 144841 145442 146042 146644 147245 147846 148447 149047 149649 150250 150851 151452 152052 152654 153255 153856 154457 155058 155659 156260 156861 157462 158063 158664 159265 159866 160467 161068 161669 162270 162871 163472 164073 164674 165275 165876 166477 167078 167679 168280 168881 169482 170083 170684 171285 171886 172487 173088 173689 174290 174891 175492 176093 176694 177295 177896 178497 179098 179699 180300/;

my $la1 = -90;
my $lo1 = 180;
my $lo2 = -180;
for ( my $j = 0; $j <= 300; $j++ ) {
    
    my $la = $la1 + (.6 * $j);
    my $offset = $w->lalo2offset( $la, $lo1 );
    ok( $offset == $wegot1[$j] ) or
        diag( "lalo2offset( $la, $lo1) gives $offset, should be $wegot1[$j] ");

    $offset = $w->lalo2offset( $la, $lo2 );
    ok( $offset == $wegot2[$j] ) or
        diag( "lalo2offset( $la, $lo2) gives $offset, should be $wegot2[$j] ");          
}




