package Games::EternalLands::Constants;

require Exporter;
@ISA = qw(Exporter);

@EXPORT_OK = qw(%WearableItems %WearableItemsByID %TextChannels %TextChannelsByID
                %SkinColors %SkinColorsByID %Helmets %HelmetsByID %Heads %HeadsByID
                %Capes %CapesByID %ClientCommands %ClientCommandsByID %NoArmorFlags
                %NoArmorFlagsByID %ServerCommands %ServerCommandsByID %ELStats %ELStatsByID
                %Frames %FramesByID %ActorTypes %ActorTypesByID %Weapons %WeaponsByID
                %PantsColors %PantsColorsByID %Windows %WindowsByID %ActorCommands
                %ActorCommandsByID %BootsColors %BootsColorsByID %ForeignChars
                %ForeignCharsByID %Sound %SoundByID %CommonCommandsByID %Colors
                %ColorsByID %ShirtColors %ShirtColorsByID %HairColors %HairColorsByID
                %Shields %ShieldsByID
                $DEBUG_PACKETS $DEBUG_TYPES);

use vars qw(%WearableItems %WearableItemsByID %TextChannels %TextChannelsByID
            %SkinColors %SkinColorsByID %Helmets %HelmetsByID %Heads %HeadsByID
            %Capes %CapesByID %ClientCommands %ClientCommandsByID %NoArmorFlags
            %NoArmorFlagsByID %ServerCommands %ServerCommandsByID %ELStats %ELStatsByID
            %Frames %FramesByID %ActorTypes %ActorTypesByID %Weapons %WeaponsByID
            %PantsColors %PantsColorsByID %Windows %WindowsByID %ActorCommands
            %ActorCommandsByID %BootsColors %BootsColorsByID %ForeignChars
            %ForeignCharsByID %Sound %SoundByID %CommonCommandsByID %Colors
            %ColorsByID %ShirtColors %ShirtColorsByID %HairColors %HairColorsByID
            %Shields %ShieldsByID
            $DEBUG_PACKETS $DEBUG_TYPES);

%WearableItems = (
    'KIND_OF_WEAPON' => chr(0),
    'KIND_OF_SHIELD' => chr(1),
    'KIND_OF_CAPE' => chr(2),
    'KIND_OF_HELMET' => chr(3),
    'KIND_OF_LEG_ARMOR' => chr(4),
    'KIND_OF_BODY_ARMOR' => chr(5),
    'KIND_OF_BOOT_ARMOR' => chr(6),
);

%WearableItemsByID = (
   chr(0) => 'KIND_OF_WEAPON',
   chr(1) => 'KIND_OF_SHIELD',
   chr(2) => 'KIND_OF_CAPE',
   chr(3) => 'KIND_OF_HELMET',
   chr(4) => 'KIND_OF_LEG_ARMOR',
   chr(5) => 'KIND_OF_BODY_ARMOR',
   chr(6) => 'KIND_OF_BOOT_ARMOR',
);

%TextChannels = (
    'CHAT_LOCAL' => chr(0),
    'CHAT_PERSONAL' => chr(1),
    'CHAT_GM' => chr(2),
    'CHAT_SERVER' => chr(3),
    'CHAT_MOD' => chr(4),
    'CHAT_CHANNEL1' => chr(5),
    'CHAT_CHANNEL2' => chr(6),
    'CHAT_CHANNEL3' => chr(7),
    'CHAT_MODPM' => chr(8),
);

%TextChannelsByID = (
   chr(0) => 'CHAT_LOCAL',
   chr(1) => 'CHAT_PERSONAL',
   chr(2) => 'CHAT_GM',
   chr(3) => 'CHAT_SERVER',
   chr(4) => 'CHAT_MOD',
   chr(5) => 'CHAT_CHANNEL1',
   chr(6) => 'CHAT_CHANNEL2',
   chr(7) => 'CHAT_CHANNEL3',
   chr(8) => 'CHAT_MODPM',
);

%SkinColors = (
    'SKIN_BROWN' => chr(0),
    'SKIN_NORMAL' => chr(1),
    'SKIN_PALE' => chr(2),
    'SKIN_TAN' => chr(3),
    'SKIN_DARK_BLUE' => chr(4),
);

%SkinColorsByID = (
   chr(0) => 'SKIN_BROWN',
   chr(1) => 'SKIN_NORMAL',
   chr(2) => 'SKIN_PALE',
   chr(3) => 'SKIN_TAN',
   chr(4) => 'SKIN_DARK_BLUE',
);

%Helmets = (
    'HELMET_IRON' => chr(0),
    'HELMET_FUR' => chr(1),
    'HELMET_LEATHER' => chr(2),
    'HELMET_RACOON' => chr(3),
    'HELMET_SKUNK' => chr(4),
    'HELMET_CROWN_OF_MANA' => chr(5),
    'HELMET_CROWN_OF_LIFE' => chr(6),
    'HELMET_STEEL' => chr(7),
    'HELMET_TITANIUM' => chr(8),
    'HELMET_HYDROGENIUM' => chr(9),
    'HELMET_NONE' => chr(20),
);

%HelmetsByID = (
   chr(0) => 'HELMET_IRON',
   chr(1) => 'HELMET_FUR',
   chr(2) => 'HELMET_LEATHER',
   chr(3) => 'HELMET_RACOON',
   chr(4) => 'HELMET_SKUNK',
   chr(5) => 'HELMET_CROWN_OF_MANA',
   chr(6) => 'HELMET_CROWN_OF_LIFE',
   chr(7) => 'HELMET_STEEL',
   chr(8) => 'HELMET_TITANIUM',
   chr(9) => 'HELMET_HYDROGENIUM',
   chr(20) => 'HELMET_NONE',
);

%Heads = (
    'HEAD_1' => chr(0),
    'HEAD_2' => chr(1),
    'HEAD_3' => chr(2),
    'HEAD_4' => chr(3),
    'HEAD_5' => chr(4),
);

%HeadsByID = (
   chr(0) => 'HEAD_1',
   chr(1) => 'HEAD_2',
   chr(2) => 'HEAD_3',
   chr(3) => 'HEAD_4',
   chr(4) => 'HEAD_5',
);

%Capes = (
    'CAPE_BLACK' => chr(0),
    'CAPE_BLUE' => chr(1),
    'CAPE_BLUEGRAY' => chr(2),
    'CAPE_BROWN' => chr(3),
    'CAPE_BROWNGRAY' => chr(4),
    'CAPE_GRAY' => chr(5),
    'CAPE_GREEN' => chr(6),
    'CAPE_GREENGRAY' => chr(7),
    'CAPE_PURPLE' => chr(8),
    'CAPE_WHITE' => chr(9),
    'CAPE_FUR' => chr(10),
    'CAPE_GOLD' => chr(11),
    'CAPE_RED' => chr(12),
    'CAPE_ORANGE' => chr(13),
    'CAPE_MOD' => chr(14),
    'CAPE_DERIN' => chr(15),
    'CAPE_RAVENOD' => chr(16),
    'CAPE_PLACID' => chr(17),
    'CAPE_LORD_VERMOR' => chr(18),
    'CAPE_AISLINN' => chr(19),
    'CAPE_SOLDUS' => chr(20),
    'CAPE_LOTHARION' => chr(21),
    'CAPE_LEARNER' => chr(22),
    'CAPE_NONE' => chr(30),
);

%CapesByID = (
   chr(0) => 'CAPE_BLACK',
   chr(1) => 'CAPE_BLUE',
   chr(2) => 'CAPE_BLUEGRAY',
   chr(3) => 'CAPE_BROWN',
   chr(4) => 'CAPE_BROWNGRAY',
   chr(5) => 'CAPE_GRAY',
   chr(6) => 'CAPE_GREEN',
   chr(7) => 'CAPE_GREENGRAY',
   chr(8) => 'CAPE_PURPLE',
   chr(9) => 'CAPE_WHITE',
   chr(10) => 'CAPE_FUR',
   chr(11) => 'CAPE_GOLD',
   chr(12) => 'CAPE_RED',
   chr(13) => 'CAPE_ORANGE',
   chr(14) => 'CAPE_MOD',
   chr(15) => 'CAPE_DERIN',
   chr(16) => 'CAPE_RAVENOD',
   chr(17) => 'CAPE_PLACID',
   chr(18) => 'CAPE_LORD_VERMOR',
   chr(19) => 'CAPE_AISLINN',
   chr(20) => 'CAPE_SOLDUS',
   chr(21) => 'CAPE_LOTHARION',
   chr(22) => 'CAPE_LEARNER',
   chr(30) => 'CAPE_NONE',
);

%ClientCommands = (
    'RAW_TEXT' => chr(0),
    'ADD_NEW_ACTOR' => chr(1),
    'ADD_ACTOR_COMMAND' => chr(2),
    'YOU_ARE' => chr(3),
    'SYNC_CLOCK' => chr(4),
    'NEW_MINUTE' => chr(5),
    'REMOVE_ACTOR' => chr(6),
    'CHANGE_MAP' => chr(7),
    'COMBAT_MODE' => chr(8),
    'KILL_ALL_ACTORS' => chr(9),
    'GET_TELEPORTERS_LIST' => chr(10),
    'PONG' => chr(11),
    'TELEPORT_IN' => chr(12),
    'TELEPORT_OUT' => chr(13),
    'PLAY_SOUND' => chr(14),
    'START_RAIN' => chr(15),
    'STOP_RAIN' => chr(16),
    'THUNDER' => chr(17),
    'HERE_YOUR_STATS' => chr(18),
    'HERE_YOUR_INVENTORY' => chr(19),
    'INVENTORY_ITEM_TEXT' => chr(20),
    'GET_NEW_INVENTORY_ITEM' => chr(21),
    'REMOVE_ITEM_FROM_INVENTORY' => chr(22),
    'HERE_YOUR_GROUND_ITEMS' => chr(23),
    'GET_NEW_GROUND_ITEM' => chr(24),
    'REMOVE_ITEM_FROM_GROUND' => chr(25),
    'CLOSE_BAG' => chr(26),
    'GET_NEW_BAG' => chr(27),
    'GET_BAGS_LIST' => chr(28),
    'DESTROY_BAG' => chr(29),
    'NPC_TEXT' => chr(30),
    'NPC_OPTIONS_LIST' => chr(31),
    'CLOSE_NPC_MENU' => chr(32),
    'SEND_NPC_INFO' => chr(33),
    'GET_TRADE_INFO' => chr(34),
    'GET_TRADE_OBJECT' => chr(35),
    'GET_TRADE_ACCEPT' => chr(36),
    'GET_TRADE_REJECT' => chr(37),
    'GET_TRADE_EXIT' => chr(38),
    'REMOVE_TRADE_OBJECT' => chr(39),
    'GET_YOUR_TRADEOBJECTS' => chr(40),
    'GET_TRADE_PARTNER_NAME' => chr(41),
    'GET_YOUR_SIGILS' => chr(42),
    'SPELL_ITEM_TEXT' => chr(43),
    'GET_ACTIVE_SPELL' => chr(44),
    'GET_ACTIVE_SPELL_LIST' => chr(45),
    'REMOVE_ACTIVE_SPELL' => chr(46),
    'GET_ACTOR_DAMAGE' => chr(47),
    'GET_ACTOR_HEAL' => chr(48),
    'SEND_PARTIAL_STAT' => chr(49),
    'SPAWN_BAG_PARTICLES' => chr(50),
    'ADD_NEW_ENHANCED_ACTOR' => chr(51),
    'ACTOR_WEAR_ITEM' => chr(52),
    'ACTOR_UNWEAR_ITEM' => chr(53),
    'PLAY_MUSIC' => chr(54),
    'GET_KNOWLEDGE_LIST' => chr(55),
    'GET_NEW_KNOWLEDGE' => chr(56),
    'GET_KNOWLEDGE_TEXT' => chr(57),
    'BUDDY_EVENT' => chr(59),
    'PING_REQUEST' => chr(60),
    'FIRE_PARTICLES' => chr(61),
    'REMOVE_FIRE_AT' => chr(62),
    'DISPLAY_CLIENT_WINDOW' => chr(63),
    'OPEN_BOOK' => chr(64),
    'READ_BOOK' => chr(65),
    'CLOSE_BOOK' => chr(66),
    'STORAGE_LIST' => chr(67),
    'STORAGE_ITEMS' => chr(68),
    'STORAGE_TEXT' => chr(69),
    'SPELL_CAST' => chr(70),
    'GET_ACTIVE_CHANNELS' => chr(71),
    'MAP_FLAGS' => chr(72),
    'GET_ACTOR_HEALTH' => chr(73),
    'GET_3D_OBJ_LIST' => chr(74),
    'GET_3D_OBJ' => chr(75),
    'REMOVE_3D_OBJ' => chr(76),
    'GET_ITEMS_COOLDOWN' => chr(77),
    'SEND_BUFFS' => chr(78),
    'MAP_SET_OBJECTS' => chr(220),
    'MAP_STATE_OBJECTS' => chr(221),
    'UPGRADE_NEW_VERSION' => chr(240),
    'UPGRADE_TOO_OLD' => chr(241),
    'REDEFINE_YOUR_COLORS' => chr(248),
    'YOU_DONT_EXIST' => chr(249),
    'LOG_IN_OK' => chr(250),
    'LOG_IN_NOT_OK' => chr(251),
    'CREATE_CHAR_OK' => chr(252),
    'CREATE_CHAR_NOT_OK' => chr(253),
    'BYE' => chr(255),
);

%ClientCommandsByID = (
   chr(0) => 'RAW_TEXT',
   chr(1) => 'ADD_NEW_ACTOR',
   chr(2) => 'ADD_ACTOR_COMMAND',
   chr(3) => 'YOU_ARE',
   chr(4) => 'SYNC_CLOCK',
   chr(5) => 'NEW_MINUTE',
   chr(6) => 'REMOVE_ACTOR',
   chr(7) => 'CHANGE_MAP',
   chr(8) => 'COMBAT_MODE',
   chr(9) => 'KILL_ALL_ACTORS',
   chr(10) => 'GET_TELEPORTERS_LIST',
   chr(11) => 'PONG',
   chr(12) => 'TELEPORT_IN',
   chr(13) => 'TELEPORT_OUT',
   chr(14) => 'PLAY_SOUND',
   chr(15) => 'START_RAIN',
   chr(16) => 'STOP_RAIN',
   chr(17) => 'THUNDER',
   chr(18) => 'HERE_YOUR_STATS',
   chr(19) => 'HERE_YOUR_INVENTORY',
   chr(20) => 'INVENTORY_ITEM_TEXT',
   chr(21) => 'GET_NEW_INVENTORY_ITEM',
   chr(22) => 'REMOVE_ITEM_FROM_INVENTORY',
   chr(23) => 'HERE_YOUR_GROUND_ITEMS',
   chr(24) => 'GET_NEW_GROUND_ITEM',
   chr(25) => 'REMOVE_ITEM_FROM_GROUND',
   chr(26) => 'CLOSE_BAG',
   chr(27) => 'GET_NEW_BAG',
   chr(28) => 'GET_BAGS_LIST',
   chr(29) => 'DESTROY_BAG',
   chr(30) => 'NPC_TEXT',
   chr(31) => 'NPC_OPTIONS_LIST',
   chr(32) => 'CLOSE_NPC_MENU',
   chr(33) => 'SEND_NPC_INFO',
   chr(34) => 'GET_TRADE_INFO',
   chr(35) => 'GET_TRADE_OBJECT',
   chr(36) => 'GET_TRADE_ACCEPT',
   chr(37) => 'GET_TRADE_REJECT',
   chr(38) => 'GET_TRADE_EXIT',
   chr(39) => 'REMOVE_TRADE_OBJECT',
   chr(40) => 'GET_YOUR_TRADEOBJECTS',
   chr(41) => 'GET_TRADE_PARTNER_NAME',
   chr(42) => 'GET_YOUR_SIGILS',
   chr(43) => 'SPELL_ITEM_TEXT',
   chr(44) => 'GET_ACTIVE_SPELL',
   chr(45) => 'GET_ACTIVE_SPELL_LIST',
   chr(46) => 'REMOVE_ACTIVE_SPELL',
   chr(47) => 'GET_ACTOR_DAMAGE',
   chr(48) => 'GET_ACTOR_HEAL',
   chr(49) => 'SEND_PARTIAL_STAT',
   chr(50) => 'SPAWN_BAG_PARTICLES',
   chr(51) => 'ADD_NEW_ENHANCED_ACTOR',
   chr(52) => 'ACTOR_WEAR_ITEM',
   chr(53) => 'ACTOR_UNWEAR_ITEM',
   chr(54) => 'PLAY_MUSIC',
   chr(55) => 'GET_KNOWLEDGE_LIST',
   chr(56) => 'GET_NEW_KNOWLEDGE',
   chr(57) => 'GET_KNOWLEDGE_TEXT',
   chr(59) => 'BUDDY_EVENT',
   chr(60) => 'PING_REQUEST',
   chr(61) => 'FIRE_PARTICLES',
   chr(62) => 'REMOVE_FIRE_AT',
   chr(63) => 'DISPLAY_CLIENT_WINDOW',
   chr(64) => 'OPEN_BOOK',
   chr(65) => 'READ_BOOK',
   chr(66) => 'CLOSE_BOOK',
   chr(67) => 'STORAGE_LIST',
   chr(68) => 'STORAGE_ITEMS',
   chr(69) => 'STORAGE_TEXT',
   chr(70) => 'SPELL_CAST',
   chr(71) => 'GET_ACTIVE_CHANNELS',
   chr(72) => 'MAP_FLAGS',
   chr(73) => 'GET_ACTOR_HEALTH',
   chr(74) => 'GET_3D_OBJ_LIST',
   chr(75) => 'GET_3D_OBJ',
   chr(76) => 'REMOVE_3D_OBJ',
   chr(77) => 'GET_ITEMS_COOLDOWN',
   chr(78) => 'SEND_BUFFS',
   chr(220) => 'MAP_SET_OBJECTS',
   chr(221) => 'MAP_STATE_OBJECTS',
   chr(240) => 'UPGRADE_NEW_VERSION',
   chr(241) => 'UPGRADE_TOO_OLD',
   chr(248) => 'REDEFINE_YOUR_COLORS',
   chr(249) => 'YOU_DONT_EXIST',
   chr(250) => 'LOG_IN_OK',
   chr(251) => 'LOG_IN_NOT_OK',
   chr(252) => 'CREATE_CHAR_OK',
   chr(253) => 'CREATE_CHAR_NOT_OK',
   chr(255) => 'BYE',
);

%NoArmorFlags = (
    'NO_BODY_ARMOR' => chr(0),
    'NO_PANTS_ARMOR' => chr(0),
    'NO_BOOTS_ARMOR' => chr(0),
);

%NoArmorFlagsByID = (
   chr(0) => 'NO_BODY_ARMOR',
   chr(0) => 'NO_PANTS_ARMOR',
   chr(0) => 'NO_BOOTS_ARMOR',
);

%ServerCommands = (
    'RAW_TEXT' => chr(0),
    'MOVE_TO' => chr(1),
    'SEND_PM' => chr(2),
    'GET_PLAYER_INFO' => chr(5),
    'RUN_TO' => chr(6),
    'SIT_DOWN' => chr(7),
    'SEND_ME_MY_ACTORS' => chr(8),
    'SEND_OPENING_SCREEN' => chr(9),
    'SEND_VERSION' => chr(10),
    'TURN_LEFT' => chr(11),
    'TURN_RIGHT' => chr(12),
    'PING' => chr(13),
    'HEART_BEAT' => chr(14),
    'LOCATE_ME' => chr(15),
    'USE_MAP_OBJECT' => chr(16),
    'SEND_MY_STATS' => chr(17),
    'SEND_MY_INVENTORY' => chr(18),
    'LOOK_AT_INVENTORY_ITEM' => chr(19),
    'MOVE_INVENTORY_ITEM' => chr(20),
    'HARVEST' => chr(21),
    'DROP_ITEM' => chr(22),
    'PICK_UP_ITEM' => chr(23),
    'LOOK_AT_GROUND_ITEM' => chr(24),
    'INSPECT_BAG' => chr(25),
    'S_CLOSE_BAG' => chr(26),
    'LOOK_AT_MAP_OBJECT' => chr(27),
    'TOUCH_PLAYER' => chr(28),
    'RESPOND_TO_NPC' => chr(29),
    'MANUFACTURE_THIS' => chr(30),
    'USE_INVENTORY_ITEM' => chr(31),
    'TRADE_WITH' => chr(32),
    'ACCEPT_TRADE' => chr(33),
    'REJECT_TRADE' => chr(34),
    'EXIT_TRADE' => chr(35),
    'PUT_OBJECT_ON_TRADE' => chr(36),
    'REMOVE_OBJECT_FROM_TRADE' => chr(37),
    'LOOK_AT_TRADE_ITEM' => chr(38),
    'CAST_SPELL' => chr(39),
    'ATTACK_SOMEONE' => chr(40),
    'GET_KNOWLEDGE_INFO' => chr(41),
    'ITEM_ON_ITEM' => chr(42),
    'SEND_BOOK' => chr(43),
    'GET_STORAGE_CATEGORY' => chr(44),
    'DEPOSITE_ITEM' => chr(45),
    'WITHDRAW_ITEM' => chr(46),
    'LOOK_AT_STORAGE_ITEM' => chr(47),
    'SPELL_NAME' => chr(48),
    'PING_RESPONSE' => chr(60),
    'SET_ACTIVE_CHANNEL' => chr(61),
    'LOG_IN' => chr(140),
    'CREATE_CHAR' => chr(141),
    'GET_DATE' => chr(230),
    'GET_TIME' => chr(231),
    'SERVER_STATS' => chr(232),
    'ORIGINAL_IP' => chr(233),
    'BYE' => chr(255),
);

%ServerCommandsByID = (
   chr(0) => 'RAW_TEXT',
   chr(1) => 'MOVE_TO',
   chr(2) => 'SEND_PM',
   chr(5) => 'GET_PLAYER_INFO',
   chr(6) => 'RUN_TO',
   chr(7) => 'SIT_DOWN',
   chr(8) => 'SEND_ME_MY_ACTORS',
   chr(9) => 'SEND_OPENING_SCREEN',
   chr(10) => 'SEND_VERSION',
   chr(11) => 'TURN_LEFT',
   chr(12) => 'TURN_RIGHT',
   chr(13) => 'PING',
   chr(14) => 'HEART_BEAT',
   chr(15) => 'LOCATE_ME',
   chr(16) => 'USE_MAP_OBJECT',
   chr(17) => 'SEND_MY_STATS',
   chr(18) => 'SEND_MY_INVENTORY',
   chr(19) => 'LOOK_AT_INVENTORY_ITEM',
   chr(20) => 'MOVE_INVENTORY_ITEM',
   chr(21) => 'HARVEST',
   chr(22) => 'DROP_ITEM',
   chr(23) => 'PICK_UP_ITEM',
   chr(24) => 'LOOK_AT_GROUND_ITEM',
   chr(25) => 'INSPECT_BAG',
   chr(26) => 'S_CLOSE_BAG',
   chr(27) => 'LOOK_AT_MAP_OBJECT',
   chr(28) => 'TOUCH_PLAYER',
   chr(29) => 'RESPOND_TO_NPC',
   chr(30) => 'MANUFACTURE_THIS',
   chr(31) => 'USE_INVENTORY_ITEM',
   chr(32) => 'TRADE_WITH',
   chr(33) => 'ACCEPT_TRADE',
   chr(34) => 'REJECT_TRADE',
   chr(35) => 'EXIT_TRADE',
   chr(36) => 'PUT_OBJECT_ON_TRADE',
   chr(37) => 'REMOVE_OBJECT_FROM_TRADE',
   chr(38) => 'LOOK_AT_TRADE_ITEM',
   chr(39) => 'CAST_SPELL',
   chr(40) => 'ATTACK_SOMEONE',
   chr(41) => 'GET_KNOWLEDGE_INFO',
   chr(42) => 'ITEM_ON_ITEM',
   chr(43) => 'SEND_BOOK',
   chr(44) => 'GET_STORAGE_CATEGORY',
   chr(45) => 'DEPOSITE_ITEM',
   chr(46) => 'WITHDRAW_ITEM',
   chr(47) => 'LOOK_AT_STORAGE_ITEM',
   chr(48) => 'SPELL_NAME',
   chr(60) => 'PING_RESPONSE',
   chr(61) => 'SET_ACTIVE_CHANNEL',
   chr(140) => 'LOG_IN',
   chr(141) => 'CREATE_CHAR',
   chr(230) => 'GET_DATE',
   chr(231) => 'GET_TIME',
   chr(232) => 'SERVER_STATS',
   chr(233) => 'ORIGINAL_IP',
   chr(255) => 'BYE',
);

%ELStats = (
    'PHY_CUR' => chr(0),
    'PHY_BASE' => chr(1),
    'COO_CUR' => chr(2),
    'COO_BASE' => chr(3),
    'REAS_CUR' => chr(4),
    'REAS_BASE' => chr(5),
    'WILL_CUR' => chr(6),
    'WILL_BASE' => chr(7),
    'INST_CUR' => chr(8),
    'INST_BASE' => chr(9),
    'VIT_CUR' => chr(10),
    'VIT_BASE' => chr(11),
    'HUMAN_CUR' => chr(12),
    'HUMAN_BASE' => chr(13),
    'ANIMAL_CUR' => chr(14),
    'ANIMAL_BASE' => chr(15),
    'VEGETAL_CUR' => chr(16),
    'VEGETAL_BASE' => chr(17),
    'INORG_CUR' => chr(18),
    'INORG_BASE' => chr(19),
    'ARTIF_CUR' => chr(20),
    'ARTIF_BASE' => chr(21),
    'MAGIC_CUR' => chr(22),
    'MAGIC_BASE' => chr(23),
    'MAN_S_CUR' => chr(24),
    'MAN_S_BASE' => chr(25),
    'HARV_S_CUR' => chr(26),
    'HARV_S_BASE' => chr(27),
    'ALCH_S_CUR' => chr(28),
    'ALCH_S_BASE' => chr(29),
    'OVRL_S_CUR' => chr(30),
    'OVRL_S_BASE' => chr(31),
    'DEF_S_CUR' => chr(32),
    'DEF_S_BASE' => chr(33),
    'ATT_S_CUR' => chr(34),
    'ATT_S_BASE' => chr(35),
    'MAG_S_CUR' => chr(36),
    'MAG_S_BASE' => chr(37),
    'POT_S_CUR' => chr(38),
    'POT_S_BASE' => chr(39),
    'CARRY_WGHT_CUR' => chr(40),
    'CARRY_WGHT_BASE' => chr(41),
    'MAT_POINT_CUR' => chr(42),
    'MAT_POINT_BASE' => chr(43),
    'ETH_POINT_CUR' => chr(44),
    'ETH_POINT_BASE' => chr(45),
    'FOOD_LEV' => chr(46),
    'RESEARCHING' => chr(47),
    'MAG_RES' => chr(48),
    'MAN_EXP' => chr(49),
    'MAN_EXP_NEXT' => chr(50),
    'HARV_EXP' => chr(51),
    'HARV_EXP_NEXT' => chr(52),
    'ALCH_EXP' => chr(53),
    'ALCH_EXP_NEXT' => chr(54),
    'OVRL_EXP' => chr(55),
    'OVRL_EXP_NEXT' => chr(56),
    'DEF_EXP' => chr(57),
    'DEF_EXP_NEXT' => chr(58),
    'ATT_EXP' => chr(59),
    'ATT_EXP_NEXT' => chr(60),
    'MAG_EXP' => chr(61),
    'MAG_EXP_NEXT' => chr(62),
    'POT_EXP' => chr(63),
    'POT_EXP_NEXT' => chr(64),
    'RESEARCH_COMPLETED' => chr(65),
    'RESEARCH_TOTAL' => chr(66),
    'SUM_EXP' => chr(67),
    'SUM_EXP_NEXT' => chr(68),
    'SUM_S_CUR' => chr(69),
    'SUM_S_BASE' => chr(70),
    'CRA_EXP' => chr(71),
    'CRA_EXP_NEXT' => chr(72),
    'CRA_S_CUR' => chr(73),
    'CRA_S_BASE' => chr(74),
);

%ELStatsByID = (
   chr(0) => 'PHY_CUR',
   chr(1) => 'PHY_BASE',
   chr(2) => 'COO_CUR',
   chr(3) => 'COO_BASE',
   chr(4) => 'REAS_CUR',
   chr(5) => 'REAS_BASE',
   chr(6) => 'WILL_CUR',
   chr(7) => 'WILL_BASE',
   chr(8) => 'INST_CUR',
   chr(9) => 'INST_BASE',
   chr(10) => 'VIT_CUR',
   chr(11) => 'VIT_BASE',
   chr(12) => 'HUMAN_CUR',
   chr(13) => 'HUMAN_BASE',
   chr(14) => 'ANIMAL_CUR',
   chr(15) => 'ANIMAL_BASE',
   chr(16) => 'VEGETAL_CUR',
   chr(17) => 'VEGETAL_BASE',
   chr(18) => 'INORG_CUR',
   chr(19) => 'INORG_BASE',
   chr(20) => 'ARTIF_CUR',
   chr(21) => 'ARTIF_BASE',
   chr(22) => 'MAGIC_CUR',
   chr(23) => 'MAGIC_BASE',
   chr(24) => 'MAN_S_CUR',
   chr(25) => 'MAN_S_BASE',
   chr(26) => 'HARV_S_CUR',
   chr(27) => 'HARV_S_BASE',
   chr(28) => 'ALCH_S_CUR',
   chr(29) => 'ALCH_S_BASE',
   chr(30) => 'OVRL_S_CUR',
   chr(31) => 'OVRL_S_BASE',
   chr(32) => 'DEF_S_CUR',
   chr(33) => 'DEF_S_BASE',
   chr(34) => 'ATT_S_CUR',
   chr(35) => 'ATT_S_BASE',
   chr(36) => 'MAG_S_CUR',
   chr(37) => 'MAG_S_BASE',
   chr(38) => 'POT_S_CUR',
   chr(39) => 'POT_S_BASE',
   chr(40) => 'CARRY_WGHT_CUR',
   chr(41) => 'CARRY_WGHT_BASE',
   chr(42) => 'MAT_POINT_CUR',
   chr(43) => 'MAT_POINT_BASE',
   chr(44) => 'ETH_POINT_CUR',
   chr(45) => 'ETH_POINT_BASE',
   chr(46) => 'FOOD_LEV',
   chr(47) => 'RESEARCHING',
   chr(48) => 'MAG_RES',
   chr(49) => 'MAN_EXP',
   chr(50) => 'MAN_EXP_NEXT',
   chr(51) => 'HARV_EXP',
   chr(52) => 'HARV_EXP_NEXT',
   chr(53) => 'ALCH_EXP',
   chr(54) => 'ALCH_EXP_NEXT',
   chr(55) => 'OVRL_EXP',
   chr(56) => 'OVRL_EXP_NEXT',
   chr(57) => 'DEF_EXP',
   chr(58) => 'DEF_EXP_NEXT',
   chr(59) => 'ATT_EXP',
   chr(60) => 'ATT_EXP_NEXT',
   chr(61) => 'MAG_EXP',
   chr(62) => 'MAG_EXP_NEXT',
   chr(63) => 'POT_EXP',
   chr(64) => 'POT_EXP_NEXT',
   chr(65) => 'RESEARCH_COMPLETED',
   chr(66) => 'RESEARCH_TOTAL',
   chr(67) => 'SUM_EXP',
   chr(68) => 'SUM_EXP_NEXT',
   chr(69) => 'SUM_S_CUR',
   chr(70) => 'SUM_S_BASE',
   chr(71) => 'CRA_EXP',
   chr(72) => 'CRA_EXP_NEXT',
   chr(73) => 'CRA_S_CUR',
   chr(74) => 'CRA_S_BASE',
);

%Frames = (
    'frame_walk' => chr(0),
    'frame_run' => chr(1),
    'frame_die1' => chr(2),
    'frame_die2' => chr(3),
    'frame_pain1' => chr(4),
    'frame_pick' => chr(5),
    'frame_drop' => chr(6),
    'frame_idle' => chr(7),
    'frame_harvest' => chr(8),
    'frame_cast' => chr(9),
    'frame_ranged' => chr(10),
    'frame_pain2' => chr(11),
    'frame_sit' => chr(12),
    'frame_stand' => chr(13),
    'frame_sit_idle' => chr(14),
    'frame_combat_idle' => chr(15),
    'frame_in_combat' => chr(16),
    'frame_out_combat' => chr(17),
    'frame_attack_up_1' => chr(18),
    'frame_attack_up_2' => chr(19),
    'frame_attack_up_3' => chr(20),
    'frame_attack_up_4' => chr(21),
    'frame_attack_down_1' => chr(22),
    'frame_attack_down_2' => chr(23),
);

%FramesByID = (
   chr(0) => 'frame_walk',
   chr(1) => 'frame_run',
   chr(2) => 'frame_die1',
   chr(3) => 'frame_die2',
   chr(4) => 'frame_pain1',
   chr(5) => 'frame_pick',
   chr(6) => 'frame_drop',
   chr(7) => 'frame_idle',
   chr(8) => 'frame_harvest',
   chr(9) => 'frame_cast',
   chr(10) => 'frame_ranged',
   chr(11) => 'frame_pain2',
   chr(12) => 'frame_sit',
   chr(13) => 'frame_stand',
   chr(14) => 'frame_sit_idle',
   chr(15) => 'frame_combat_idle',
   chr(16) => 'frame_in_combat',
   chr(17) => 'frame_out_combat',
   chr(18) => 'frame_attack_up_1',
   chr(19) => 'frame_attack_up_2',
   chr(20) => 'frame_attack_up_3',
   chr(21) => 'frame_attack_up_4',
   chr(22) => 'frame_attack_down_1',
   chr(23) => 'frame_attack_down_2',
);

%ActorTypes = (
    'human_female' => chr(0),
    'human_male' => chr(1),
    'elf_female' => chr(2),
    'elf_male' => chr(3),
    'dwarf_female' => chr(4),
    'dwarf_male' => chr(5),
    'wraith' => chr(6),
    'cyclops' => chr(7),
    'beaver' => chr(8),
    'rat' => chr(9),
    'goblin_male_2' => chr(10),
    'goblin_female_1' => chr(11),
    'town_folk4' => chr(12),
    'town_folk5' => chr(13),
    'shop_girl3' => chr(14),
    'deer' => chr(15),
    'bear' => chr(16),
    'wolf' => chr(17),
    'white_rabbit' => chr(18),
    'brown_rabbit' => chr(19),
    'boar' => chr(20),
    'bear2' => chr(21),
    'snake1' => chr(22),
    'snake2' => chr(23),
    'snake3' => chr(24),
    'fox' => chr(25),
    'puma' => chr(26),
    'ogre_male_1' => chr(27),
    'goblin_male_1' => chr(28),
    'orc_male_1' => chr(29),
    'orc_female_1' => chr(30),
    'skeleton' => chr(31),
    'gargoyle1' => chr(32),
    'gargoyle2' => chr(33),
    'gargoyle3' => chr(34),
    'troll' => chr(35),
    'chimeran_wolf_mountain' => chr(36),
    'gnome_female' => chr(37),
    'gnome_male' => chr(38),
    'orchan_female' => chr(39),
    'orchan_male' => chr(40),
    'draegoni_female' => chr(41),
    'draegoni_male' => chr(42),
    'skunk_1' => chr(43),
    'racoon_1' => chr(44),
    'unicorn_1' => chr(45),
    'chimeran_wolf_desert' => chr(46),
    'chimeran_wolf_forest' => chr(47),
    'bear_3' => chr(48),
    'bear_4' => chr(49),
    'panther' => chr(50),
    'feran' => chr(51),
    'leopard_1' => chr(52),
    'leopard_2' => chr(53),
    'chimeran_wolf_arctic' => chr(54),
    'tiger_1' => chr(55),
    'tiger_2' => chr(56),
    'armed_female_orc' => chr(57),
    'armed_male_orc' => chr(58),
    'armed_skeleton' => chr(59),
    'phantom_warrior' => chr(60),
    'imp' => chr(61),
    'brownie' => chr(62),
    'leprechaun' => chr(63),
    'spider_s_1' => chr(64),
    'spider_s_2' => chr(65),
    'spider_s_3' => chr(66),
    'spider_l_1' => chr(67),
    'spider_l_2' => chr(68),
    'spider_l_3' => chr(69),
    'wood_sprite' => chr(70),
    'spider_l_4' => chr(71),
    'spider_s_4' => chr(72),
    'giant_1' => chr(73),
    'hobgoblin' => chr(74),
    'yeti' => chr(75),
    'snake4' => chr(76),
);

%ActorTypesByID = (
   chr(0) => 'human_female',
   chr(1) => 'human_male',
   chr(2) => 'elf_female',
   chr(3) => 'elf_male',
   chr(4) => 'dwarf_female',
   chr(5) => 'dwarf_male',
   chr(6) => 'wraith',
   chr(7) => 'cyclops',
   chr(8) => 'beaver',
   chr(9) => 'rat',
   chr(10) => 'goblin_male_2',
   chr(11) => 'goblin_female_1',
   chr(12) => 'town_folk4',
   chr(13) => 'town_folk5',
   chr(14) => 'shop_girl3',
   chr(15) => 'deer',
   chr(16) => 'bear',
   chr(17) => 'wolf',
   chr(18) => 'white_rabbit',
   chr(19) => 'brown_rabbit',
   chr(20) => 'boar',
   chr(21) => 'bear2',
   chr(22) => 'snake1',
   chr(23) => 'snake2',
   chr(24) => 'snake3',
   chr(25) => 'fox',
   chr(26) => 'puma',
   chr(27) => 'ogre_male_1',
   chr(28) => 'goblin_male_1',
   chr(29) => 'orc_male_1',
   chr(30) => 'orc_female_1',
   chr(31) => 'skeleton',
   chr(32) => 'gargoyle1',
   chr(33) => 'gargoyle2',
   chr(34) => 'gargoyle3',
   chr(35) => 'troll',
   chr(36) => 'chimeran_wolf_mountain',
   chr(37) => 'gnome_female',
   chr(38) => 'gnome_male',
   chr(39) => 'orchan_female',
   chr(40) => 'orchan_male',
   chr(41) => 'draegoni_female',
   chr(42) => 'draegoni_male',
   chr(43) => 'skunk_1',
   chr(44) => 'racoon_1',
   chr(45) => 'unicorn_1',
   chr(46) => 'chimeran_wolf_desert',
   chr(47) => 'chimeran_wolf_forest',
   chr(48) => 'bear_3',
   chr(49) => 'bear_4',
   chr(50) => 'panther',
   chr(51) => 'feran',
   chr(52) => 'leopard_1',
   chr(53) => 'leopard_2',
   chr(54) => 'chimeran_wolf_arctic',
   chr(55) => 'tiger_1',
   chr(56) => 'tiger_2',
   chr(57) => 'armed_female_orc',
   chr(58) => 'armed_male_orc',
   chr(59) => 'armed_skeleton',
   chr(60) => 'phantom_warrior',
   chr(61) => 'imp',
   chr(62) => 'brownie',
   chr(63) => 'leprechaun',
   chr(64) => 'spider_s_1',
   chr(65) => 'spider_s_2',
   chr(66) => 'spider_s_3',
   chr(67) => 'spider_l_1',
   chr(68) => 'spider_l_2',
   chr(69) => 'spider_l_3',
   chr(70) => 'wood_sprite',
   chr(71) => 'spider_l_4',
   chr(72) => 'spider_s_4',
   chr(73) => 'giant_1',
   chr(74) => 'hobgoblin',
   chr(75) => 'yeti',
   chr(76) => 'snake4',
);

%Weapons = (
    'WEAPON_NONE' => chr(0),
    'SWORD_1' => chr(1),
    'SWORD_2' => chr(2),
    'SWORD_3' => chr(3),
    'SWORD_4' => chr(4),
    'SWORD_5' => chr(5),
    'SWORD_6' => chr(6),
    'SWORD_7' => chr(7),
    'STAFF_1' => chr(8),
    'STAFF_2' => chr(9),
    'STAFF_3' => chr(10),
    'STAFF_4' => chr(11),
    'HAMMER_1' => chr(12),
    'HAMMER_2' => chr(13),
    'PICKAX' => chr(14),
    'SWORD_1_FIRE' => chr(15),
    'SWORD_2_FIRE' => chr(16),
    'SWORD_2_COLD' => chr(17),
    'SWORD_3_FIRE' => chr(18),
    'SWORD_3_COLD' => chr(19),
    'SWORD_3_MAGIC' => chr(20),
    'SWORD_4_FIRE' => chr(21),
    'SWORD_4_COLD' => chr(22),
    'SWORD_4_MAGIC' => chr(23),
    'SWORD_4_THERMAL' => chr(24),
    'SWORD_5_FIRE' => chr(25),
    'SWORD_5_COLD' => chr(26),
    'SWORD_5_MAGIC' => chr(27),
    'SWORD_5_THERMAL' => chr(28),
    'SWORD_6_FIRE' => chr(29),
    'SWORD_6_COLD' => chr(30),
    'SWORD_6_MAGIC' => chr(31),
    'SWORD_6_THERMAL' => chr(32),
    'SWORD_7_FIRE' => chr(33),
    'SWORD_7_COLD' => chr(34),
    'SWORD_7_MAGIC' => chr(35),
    'SWORD_7_THERMAL' => chr(36),
    'PICKAX_MAGIC' => chr(37),
    'BATTLEAXE_IRON' => chr(38),
    'BATTLEAXE_STEEL' => chr(39),
    'BATTLEAXE_TITANIUM' => chr(40),
    'BATTLEAXE_IRON_FIRE' => chr(41),
    'BATTLEAXE_STEEL_COLD' => chr(42),
    'BATTLEAXE_STEEL_FIRE' => chr(43),
    'BATTLEAXE_TITANIUM_COLD' => chr(44),
    'BATTLEAXE_TITANIUM_FIRE' => chr(45),
    'BATTLEAXE_TITANIUM_MAGIC' => chr(46),
    'GLOVE_FUR' => chr(47),
    'GLOVE_LEATHER' => chr(48),
    'BONE_1' => chr(49),
    'STICK_1' => chr(50),
    'SWORD_EMERALD_CLAYMORE' => chr(51),
    'SWORD_CUTLASS' => chr(52),
    'SWORD_SUNBREAKER' => chr(53),
    'SWORD_ORC_SLAYER' => chr(54),
    'SWORD_EAGLE_WING' => chr(55),
    'SWORD_RAPIER' => chr(56),
    'SWORD_JAGGED_SABER' => chr(57),
);

%WeaponsByID = (
   chr(0) => 'WEAPON_NONE',
   chr(1) => 'SWORD_1',
   chr(2) => 'SWORD_2',
   chr(3) => 'SWORD_3',
   chr(4) => 'SWORD_4',
   chr(5) => 'SWORD_5',
   chr(6) => 'SWORD_6',
   chr(7) => 'SWORD_7',
   chr(8) => 'STAFF_1',
   chr(9) => 'STAFF_2',
   chr(10) => 'STAFF_3',
   chr(11) => 'STAFF_4',
   chr(12) => 'HAMMER_1',
   chr(13) => 'HAMMER_2',
   chr(14) => 'PICKAX',
   chr(15) => 'SWORD_1_FIRE',
   chr(16) => 'SWORD_2_FIRE',
   chr(17) => 'SWORD_2_COLD',
   chr(18) => 'SWORD_3_FIRE',
   chr(19) => 'SWORD_3_COLD',
   chr(20) => 'SWORD_3_MAGIC',
   chr(21) => 'SWORD_4_FIRE',
   chr(22) => 'SWORD_4_COLD',
   chr(23) => 'SWORD_4_MAGIC',
   chr(24) => 'SWORD_4_THERMAL',
   chr(25) => 'SWORD_5_FIRE',
   chr(26) => 'SWORD_5_COLD',
   chr(27) => 'SWORD_5_MAGIC',
   chr(28) => 'SWORD_5_THERMAL',
   chr(29) => 'SWORD_6_FIRE',
   chr(30) => 'SWORD_6_COLD',
   chr(31) => 'SWORD_6_MAGIC',
   chr(32) => 'SWORD_6_THERMAL',
   chr(33) => 'SWORD_7_FIRE',
   chr(34) => 'SWORD_7_COLD',
   chr(35) => 'SWORD_7_MAGIC',
   chr(36) => 'SWORD_7_THERMAL',
   chr(37) => 'PICKAX_MAGIC',
   chr(38) => 'BATTLEAXE_IRON',
   chr(39) => 'BATTLEAXE_STEEL',
   chr(40) => 'BATTLEAXE_TITANIUM',
   chr(41) => 'BATTLEAXE_IRON_FIRE',
   chr(42) => 'BATTLEAXE_STEEL_COLD',
   chr(43) => 'BATTLEAXE_STEEL_FIRE',
   chr(44) => 'BATTLEAXE_TITANIUM_COLD',
   chr(45) => 'BATTLEAXE_TITANIUM_FIRE',
   chr(46) => 'BATTLEAXE_TITANIUM_MAGIC',
   chr(47) => 'GLOVE_FUR',
   chr(48) => 'GLOVE_LEATHER',
   chr(49) => 'BONE_1',
   chr(50) => 'STICK_1',
   chr(51) => 'SWORD_EMERALD_CLAYMORE',
   chr(52) => 'SWORD_CUTLASS',
   chr(53) => 'SWORD_SUNBREAKER',
   chr(54) => 'SWORD_ORC_SLAYER',
   chr(55) => 'SWORD_EAGLE_WING',
   chr(56) => 'SWORD_RAPIER',
   chr(57) => 'SWORD_JAGGED_SABER',
);

%PantsColors = (
    'PANTS_BLACK' => chr(0),
    'PANTS_BLUE' => chr(1),
    'PANTS_BROWN' => chr(2),
    'PANTS_DARKBROWN' => chr(3),
    'PANTS_GREY' => chr(4),
    'PANTS_GREEN' => chr(5),
    'PANTS_LIGHTBROWN' => chr(6),
    'PANTS_RED' => chr(7),
    'PANTS_WHITE' => chr(8),
    'PANTS_LEATHER' => chr(9),
    'PANTS_IRON_CUISSES' => chr(10),
    'PANTS_FUR' => chr(11),
    'PANTS_STEEL_CUISSES' => chr(12),
    'PANTS_TITANIUM_CUISSES' => chr(13),
    'PANTS_HYDROGENIUM_CUISSES' => chr(14),
);

%PantsColorsByID = (
   chr(0) => 'PANTS_BLACK',
   chr(1) => 'PANTS_BLUE',
   chr(2) => 'PANTS_BROWN',
   chr(3) => 'PANTS_DARKBROWN',
   chr(4) => 'PANTS_GREY',
   chr(5) => 'PANTS_GREEN',
   chr(6) => 'PANTS_LIGHTBROWN',
   chr(7) => 'PANTS_RED',
   chr(8) => 'PANTS_WHITE',
   chr(9) => 'PANTS_LEATHER',
   chr(10) => 'PANTS_IRON_CUISSES',
   chr(11) => 'PANTS_FUR',
   chr(12) => 'PANTS_STEEL_CUISSES',
   chr(13) => 'PANTS_TITANIUM_CUISSES',
   chr(14) => 'PANTS_HYDROGENIUM_CUISSES',
);

%Windows = (
    'RULE_WIN' => chr(1),
    'RULE_INTERFACE' => chr(2),
    'NEW_CHAR_INTERFACE' => chr(3),
);

%WindowsByID = (
   chr(1) => 'RULE_WIN',
   chr(2) => 'RULE_INTERFACE',
   chr(3) => 'NEW_CHAR_INTERFACE',
);

%ActorCommands = (
    'nothing' => chr(0),
    'kill_me' => chr(1),
    'die1' => chr(3),
    'die2' => chr(4),
    'pain1' => chr(5),
    'pick' => chr(6),
    'drop' => chr(7),
    'idle' => chr(8),
    'harvest' => chr(9),
    'cast' => chr(10),
    'ranged' => chr(11),
    'meele' => chr(12),
    'sit_down' => chr(13),
    'stand_up' => chr(14),
    'turn_left' => chr(15),
    'turn_right' => chr(16),
    'pain2' => chr(17),
    'enter_combat' => chr(18),
    'leave_combat' => chr(19),
    'move_n' => chr(20),
    'move_ne' => chr(21),
    'move_e' => chr(22),
    'move_se' => chr(23),
    'move_s' => chr(24),
    'move_sw' => chr(25),
    'move_w' => chr(26),
    'move_nw' => chr(27),
    'run_n' => chr(30),
    'run_ne' => chr(31),
    'run_e' => chr(32),
    'run_se' => chr(33),
    'run_s' => chr(34),
    'run_sw' => chr(35),
    'run_w' => chr(36),
    'run_nw' => chr(37),
    'turn_n' => chr(38),
    'turn_ne' => chr(39),
    'turn_e' => chr(40),
    'turn_se' => chr(41),
    'turn_s' => chr(42),
    'turn_sw' => chr(43),
    'turn_w' => chr(44),
    'turn_nw' => chr(45),
    'attack_up_1' => chr(46),
    'attack_up_2' => chr(47),
    'attack_up_3' => chr(48),
    'attack_up_4' => chr(49),
    'attack_down_1' => chr(50),
    'attack_down_2' => chr(51),
);

%ActorCommandsByID = (
   chr(0) => 'nothing',
   chr(1) => 'kill_me',
   chr(3) => 'die1',
   chr(4) => 'die2',
   chr(5) => 'pain1',
   chr(6) => 'pick',
   chr(7) => 'drop',
   chr(8) => 'idle',
   chr(9) => 'harvest',
   chr(10) => 'cast',
   chr(11) => 'ranged',
   chr(12) => 'meele',
   chr(13) => 'sit_down',
   chr(14) => 'stand_up',
   chr(15) => 'turn_left',
   chr(16) => 'turn_right',
   chr(17) => 'pain2',
   chr(18) => 'enter_combat',
   chr(19) => 'leave_combat',
   chr(20) => 'move_n',
   chr(21) => 'move_ne',
   chr(22) => 'move_e',
   chr(23) => 'move_se',
   chr(24) => 'move_s',
   chr(25) => 'move_sw',
   chr(26) => 'move_w',
   chr(27) => 'move_nw',
   chr(30) => 'run_n',
   chr(31) => 'run_ne',
   chr(32) => 'run_e',
   chr(33) => 'run_se',
   chr(34) => 'run_s',
   chr(35) => 'run_sw',
   chr(36) => 'run_w',
   chr(37) => 'run_nw',
   chr(38) => 'turn_n',
   chr(39) => 'turn_ne',
   chr(40) => 'turn_e',
   chr(41) => 'turn_se',
   chr(42) => 'turn_s',
   chr(43) => 'turn_sw',
   chr(44) => 'turn_w',
   chr(45) => 'turn_nw',
   chr(46) => 'attack_up_1',
   chr(47) => 'attack_up_2',
   chr(48) => 'attack_up_3',
   chr(49) => 'attack_up_4',
   chr(50) => 'attack_down_1',
   chr(51) => 'attack_down_2',
);

%BootsColors = (
    'BOOTS_BLACK' => chr(0),
    'BOOTS_BROWN' => chr(1),
    'BOOTS_DARKBROWN' => chr(2),
    'BOOTS_DULLBROWN' => chr(3),
    'BOOTS_LIGHTBROWN' => chr(4),
    'BOOTS_ORANGE' => chr(5),
    'BOOTS_LEATHER' => chr(6),
    'BOOTS_FUR' => chr(7),
    'BOOTS_IRON_GREAVE' => chr(8),
    'BOOTS_STEEL_GREAVE' => chr(9),
    'BOOTS_TITANIUM_GREAVE' => chr(10),
    'BOOTS_HYDROGENIUM_GREAVE' => chr(11),
);

%BootsColorsByID = (
   chr(0) => 'BOOTS_BLACK',
   chr(1) => 'BOOTS_BROWN',
   chr(2) => 'BOOTS_DARKBROWN',
   chr(3) => 'BOOTS_DULLBROWN',
   chr(4) => 'BOOTS_LIGHTBROWN',
   chr(5) => 'BOOTS_ORANGE',
   chr(6) => 'BOOTS_LEATHER',
   chr(7) => 'BOOTS_FUR',
   chr(8) => 'BOOTS_IRON_GREAVE',
   chr(9) => 'BOOTS_STEEL_GREAVE',
   chr(10) => 'BOOTS_TITANIUM_GREAVE',
   chr(11) => 'BOOTS_HYDROGENIUM_GREAVE',
);

%ForeignChars = (
    'SPECIALCHAR_LBOUND' => chr(180),
    'EACUTE' => chr(181),
    'ACIRC' => chr(182),
    'AGRAVE' => chr(183),
    'CCEDIL' => chr(184),
    'ECIRC' => chr(185),
    'EUML' => chr(186),
    'EGRAVE' => chr(187),
    'IUML' => chr(188),
    'OCIRC' => chr(189),
    'uGRAVE' => chr(190),
    'aUMLAUT' => chr(191),
    'oUMLAUT' => chr(192),
    'uUMLAUT' => chr(193),
    'AUMLAUT' => chr(194),
    'OUMLAUT' => chr(195),
    'UUMLAUT' => chr(196),
    'DOUBLES' => chr(197),
    'aELIG' => chr(198),
    'oSLASH' => chr(199),
    'aRING' => chr(200),
    'AELIG' => chr(201),
    'OSLASH' => chr(202),
    'ARING' => chr(203),
    'EnyE' => chr(204),
    'ENYE' => chr(205),
    'aACCENT' => chr(206),
    'AACCENT' => chr(207),
    'EACCENT' => chr(208),
    'iACCENT' => chr(209),
    'IACCENT' => chr(210),
    'oACCENT' => chr(211),
    'OACCENT' => chr(212),
    'uACCENT' => chr(213),
    'SPECIALCHAR_UBOUND' => chr(214),
    'UACCENT' => chr(214),
);

%ForeignCharsByID = (
   chr(180) => 'SPECIALCHAR_LBOUND',
   chr(181) => 'EACUTE',
   chr(182) => 'ACIRC',
   chr(183) => 'AGRAVE',
   chr(184) => 'CCEDIL',
   chr(185) => 'ECIRC',
   chr(186) => 'EUML',
   chr(187) => 'EGRAVE',
   chr(188) => 'IUML',
   chr(189) => 'OCIRC',
   chr(190) => 'uGRAVE',
   chr(191) => 'aUMLAUT',
   chr(192) => 'oUMLAUT',
   chr(193) => 'uUMLAUT',
   chr(194) => 'AUMLAUT',
   chr(195) => 'OUMLAUT',
   chr(196) => 'UUMLAUT',
   chr(197) => 'DOUBLES',
   chr(198) => 'aELIG',
   chr(199) => 'oSLASH',
   chr(200) => 'aRING',
   chr(201) => 'AELIG',
   chr(202) => 'OSLASH',
   chr(203) => 'ARING',
   chr(204) => 'EnyE',
   chr(205) => 'ENYE',
   chr(206) => 'aACCENT',
   chr(207) => 'AACCENT',
   chr(208) => 'EACCENT',
   chr(209) => 'iACCENT',
   chr(210) => 'IACCENT',
   chr(211) => 'oACCENT',
   chr(212) => 'OACCENT',
   chr(213) => 'uACCENT',
   chr(214) => 'SPECIALCHAR_UBOUND',
   chr(214) => 'UACCENT',
);

%Sound = (
    'snd_rain' => chr(0),
    'snd_tele_in' => chr(1),
    'snd_tele_out' => chr(2),
    'snd_teleprtr' => chr(3),
    'snd_thndr_1' => chr(4),
    'snd_thndr_2' => chr(5),
    'snd_thndr_3' => chr(6),
    'snd_thndr_4' => chr(7),
    'snd_thndr_5' => chr(8),
    'snd_fire' => chr(9),
);

%SoundByID = (
   chr(0) => 'snd_rain',
   chr(1) => 'snd_tele_in',
   chr(2) => 'snd_tele_out',
   chr(3) => 'snd_teleprtr',
   chr(4) => 'snd_thndr_1',
   chr(5) => 'snd_thndr_2',
   chr(6) => 'snd_thndr_3',
   chr(7) => 'snd_thndr_4',
   chr(8) => 'snd_thndr_5',
   chr(9) => 'snd_fire',
);


%CommonCommandsByID = (
   chr(0) => 'RAW_TEXT',
   chr(255) => 'BYE',
);

%Colors = (
    'c_lbound' => chr(0),
    'c_red1' => chr(0),
    'c_orange1' => chr(1),
    'c_yellow1' => chr(2),
    'c_green1' => chr(3),
    'c_blue1' => chr(4),
    'c_purple1' => chr(5),
    'c_grey1' => chr(6),
    'c_red2' => chr(7),
    'c_orange2' => chr(8),
    'c_yellow2' => chr(9),
    'c_green2' => chr(10),
    'c_blue2' => chr(11),
    'c_purple2' => chr(12),
    'c_grey2' => chr(13),
    'c_red3' => chr(14),
    'c_orange3' => chr(15),
    'c_yellow3' => chr(16),
    'c_green3' => chr(17),
    'c_blue3' => chr(18),
    'c_purple3' => chr(19),
    'c_grey3' => chr(20),
    'c_red4' => chr(21),
    'c_orange4' => chr(22),
    'c_yellow4' => chr(23),
    'c_green4' => chr(24),
    'c_blue4' => chr(25),
    'c_purple4' => chr(26),
    'c_ubound' => chr(27),
    'c_grey4' => chr(27),
);

%ColorsByID = (
   chr(0) => 'c_lbound',
   chr(0) => 'c_red1',
   chr(1) => 'c_orange1',
   chr(2) => 'c_yellow1',
   chr(3) => 'c_green1',
   chr(4) => 'c_blue1',
   chr(5) => 'c_purple1',
   chr(6) => 'c_grey1',
   chr(7) => 'c_red2',
   chr(8) => 'c_orange2',
   chr(9) => 'c_yellow2',
   chr(10) => 'c_green2',
   chr(11) => 'c_blue2',
   chr(12) => 'c_purple2',
   chr(13) => 'c_grey2',
   chr(14) => 'c_red3',
   chr(15) => 'c_orange3',
   chr(16) => 'c_yellow3',
   chr(17) => 'c_green3',
   chr(18) => 'c_blue3',
   chr(19) => 'c_purple3',
   chr(20) => 'c_grey3',
   chr(21) => 'c_red4',
   chr(22) => 'c_orange4',
   chr(23) => 'c_yellow4',
   chr(24) => 'c_green4',
   chr(25) => 'c_blue4',
   chr(26) => 'c_purple4',
   chr(27) => 'c_ubound',
   chr(27) => 'c_grey4',
);

%ShirtColors = (
    'SHIRT_BLACK' => chr(0),
    'SHIRT_BLUE' => chr(1),
    'SHIRT_BROWN' => chr(2),
    'SHIRT_GREY' => chr(3),
    'SHIRT_GREEN' => chr(4),
    'SHIRT_LIGHTBROWN' => chr(5),
    'SHIRT_ORANGE' => chr(6),
    'SHIRT_PINK' => chr(7),
    'SHIRT_PURPLE' => chr(8),
    'SHIRT_RED' => chr(9),
    'SHIRT_WHITE' => chr(10),
    'SHIRT_YELLOW' => chr(11),
    'SHIRT_LEATHER_ARMOR' => chr(12),
    'SHIRT_CHAIN_ARMOR' => chr(13),
    'SHIRT_STEEL_CHAIN_ARMOR' => chr(14),
    'SHIRT_TITANIUM_CHAIN_ARMOR' => chr(15),
    'SHIRT_IRON_PLATE_ARMOR' => chr(16),
    'SHIRT_ARMOR_6' => chr(17),
    'SHIRT_FUR' => chr(18),
    'SHIRT_STEEL_PLATE_ARMOR' => chr(19),
    'SHIRT_TITANIUM_PLATE_ARMOR' => chr(20),
);

%ShirtColorsByID = (
   chr(0) => 'SHIRT_BLACK',
   chr(1) => 'SHIRT_BLUE',
   chr(2) => 'SHIRT_BROWN',
   chr(3) => 'SHIRT_GREY',
   chr(4) => 'SHIRT_GREEN',
   chr(5) => 'SHIRT_LIGHTBROWN',
   chr(6) => 'SHIRT_ORANGE',
   chr(7) => 'SHIRT_PINK',
   chr(8) => 'SHIRT_PURPLE',
   chr(9) => 'SHIRT_RED',
   chr(10) => 'SHIRT_WHITE',
   chr(11) => 'SHIRT_YELLOW',
   chr(12) => 'SHIRT_LEATHER_ARMOR',
   chr(13) => 'SHIRT_CHAIN_ARMOR',
   chr(14) => 'SHIRT_STEEL_CHAIN_ARMOR',
   chr(15) => 'SHIRT_TITANIUM_CHAIN_ARMOR',
   chr(16) => 'SHIRT_IRON_PLATE_ARMOR',
   chr(17) => 'SHIRT_ARMOR_6',
   chr(18) => 'SHIRT_FUR',
   chr(19) => 'SHIRT_STEEL_PLATE_ARMOR',
   chr(20) => 'SHIRT_TITANIUM_PLATE_ARMOR',
);

%HairColors = (
    'HAIR_BLACK' => chr(0),
    'HAIR_BLOND' => chr(1),
    'HAIR_BROWN' => chr(2),
    'HAIR_GRAY' => chr(3),
    'HAIR_RED' => chr(4),
    'HAIR_WHITE' => chr(5),
    'HAIR_BLUE' => chr(6),
    'HAIR_GREEN' => chr(7),
    'HAIR_PURPLE' => chr(8),
);

%HairColorsByID = (
   chr(0) => 'HAIR_BLACK',
   chr(1) => 'HAIR_BLOND',
   chr(2) => 'HAIR_BROWN',
   chr(3) => 'HAIR_GRAY',
   chr(4) => 'HAIR_RED',
   chr(5) => 'HAIR_WHITE',
   chr(6) => 'HAIR_BLUE',
   chr(7) => 'HAIR_GREEN',
   chr(8) => 'HAIR_PURPLE',
);

%Shields = (
    'SHIELD_WOOD' => chr(0),
    'SHIELD_WOOD_ENHANCED' => chr(1),
    'SHIELD_IRON' => chr(2),
    'SHIELD_STEEL' => chr(3),
    'SHIELD_TITANIUM' => chr(4),
    'SHIELD_HYDROGENIUM' => chr(5),
    'SHIELD_NONE' => chr(11),
);

%ShieldsByID = (
   chr(0) => 'SHIELD_WOOD',
   chr(1) => 'SHIELD_WOOD_ENHANCED',
   chr(2) => 'SHIELD_IRON',
   chr(3) => 'SHIELD_STEEL',
   chr(4) => 'SHIELD_TITANIUM',
   chr(5) => 'SHIELD_HYDROGENIUM',
   chr(11) => 'SHIELD_NONE',
);

$DEBUG_PACKETS   = 1;
$DEBUG_TYPES     = 2;
