package POD2::ES;

use 5.005;
use strict;
use vars qw($VERSION);
$VERSION = '5.12.3.01_1';

use base qw(Exporter);
our @EXPORT = qw(print_pod print_pods search_perlfunc_re new pod_dirs);

use utf8;

my $pods = {
    perlintro	=> '5.12.3',
    # perl	=> '5.12.3',
    # perlbook	=> '5.12.3',
    # perlcheat => '5.12.3',
    # perldata	=> '5.12.3',
    # perlfunc	=> '5.12.3',
    # perlstyle => '5.12.3',
    # perlsyn	=> '5.12.3',
};

sub new {
    return __PACKAGE__;
}

sub pod_dirs {
    ( my $mod = __PACKAGE__ . '.pm' ) =~ s|::|/|g;
    ( my $dir = $INC{$mod} ) =~ s/\.pm\z//;
    return $dir;
}

sub print_pods {
    print_pod(sort keys %$pods);
}

sub print_pod {
    my @args = @_ ? @_ : @ARGV;

    while (@args) {
	(my $pod = lc(shift @args)) =~ s/\.pod$//;
	if ( exists $pods->{$pod} ) {
	    print "\t'$pod' traducido correspondiente a Perl
$pods->{$pod}\n";
	}
	else {
	    print "\t'$pod' todava no existe\n";
	}
    }
}

sub search_perlfunc_re {
    return 'Listado alfabtico de funciones de Perl';
}

1;
__END__

=head1 NOMBRE

POD2::ES - Documentacin de Perl en espaol / Spanish translation of Perl
core documentation

=head1 SINOPSIS

  %> perldoc POD2::ES::<nombre_de_pod>	

  use POD2::ES;
  print_pods();
  print_pod('pod_foo', 'pod_baz', ...); 

  %> perl -MPOD2::ES -e print_pods
  %> perl -MPOD2::ES -e print_pod <nombre_de_pod1> <nombre_de_pod2> ...

=head1 DESCRIPCIN

pod2es es el proyecto de traduccin al espaol de la documentacin bsica
de Perl. Por su dimensin, es un proyecto a largo plazo. :-) 

Consulte L<http://github.com/zipf/perldoc-es> para obtener ms informacin
sobre el proyecto. 

Cuando haya instalado el paquete, puede utilizar el siguiente comando para
consultar la documentacin: 

  %> perldoc POD2::ES::<nombre_de_pod>

=head1 EXTENSIN DE perldoc

Por desgracia, los tiles modificadores C<-f> y C<-q> de C<perldoc> no
funcionan con la documentacin traducida.

Por esta razn, hemos creado una revisin de F<Pod/Perldoc.pm> 3.14 que
permite utilizar la siguiente sintaxis: 

  %> perldoc -L ES <nombre_pod>
  %> perldoc -L ES -f <funcin>
  %> perldoc -L ES -q <expresin regular P+F>

La revisin agrega el modificador C<-L>, que permite definir el cdigo de
idioma para la traduccin deseada. Si el paquete C<POD2::E<lt>idiomaE<gt>>
no existe, no se aplicar el modificador.

Los ms perezosos pueden agregar un alias del sistema:

  perldoc-es="perldoc -L ES "

para no tener que escribir el modificador C<-L> cada vez:

  %> perldoc-es -f map 
 
Puede aplicar la revisin con la lnea siguiente: 

  %> patch -p0 `/ruta_de_perl -MPod::Perldoc -e 'print
$INC{"Pod/Perldoc.pm"}'` < /ruta/Perldoc.pm-3.14-patch

La revisin se incluye con esta distribucin y se encuentra en
F<./patches/Perldoc.pm-3.14-patch>.

Tenga en cuenta que la revisin es para la versin 3.14 de
L<Pod::Perldoc|Pod::Perldoc>
(incluida en Perl 5.8.7 y en Perl 5.8.8). Si tiene una distribucin de Perl
anterior
(salvo la E<gt>= 5.8.1) y est impaciente por aplicar la revisin,
actualice el mdulo L<Pod::Perldoc|Pod::Perldoc> a la versin 3.14. ;-) 

Consulte la API C<search_perlfunc_re> para obtener ms informacin.

I<Nota: Perl 5.10 ya contiene esta funcionalidad, por lo que no es
necesario aplicar la revisin.>

=head1 API

El paquete exporta las siguientes funciones:

=over 4

=item * C<new>

Se ha agregado por compatibilidad con la funcin C<perldoc> de Perl 5.10.1.
L<Pod::Perldoc> la utiliza para devolver el nombre del paquete de
traduccin.

=item * C<pod_dirs>

Se ha agregado por compatibilidad con la funcin C<perldoc> de Perl 5.10.1.
L<Pod::Perldoc> la utiliza para determinar dnde debe buscar los pods
traducidos.

=item * C<print_pods>

Imprime en pantalla todos los pods traducidos y la versin original de Perl
correspondiente.

=item * C<print_pod>

Imprime en pantalla la versin original de Perl correspondiente a todos los
pods pasados como argumentos.

=item * C<search_perlfunc_re>

Como el mtodo C<search_perlfunc> de F<Pod/Perldoc.pm> utiliza la cadena
"Lista alfabtica de funciones de Perl" incluida en el cdigo (como una
expresin regular) para omitir la introduccin, a fin de que el archivo de
revisin funcione con otros idiomas con la opcin C<-L>, hemos utilizado un
mecanismo sencillo, similar a un complemento. 

El paquete de idioma C<POD2::E<lt>idiomaE<gt>> debe exportar
C<search_perlfunc_re> para devolver una traduccin de la cadena mencionada
en el prrafo anterior. Esta cadena se usar para omitir la introduccin de
F<perlfunc.pod>. Si 
C<POD2::E<lt>idiomaE<gt>-E<gt>search_perlfunc_re> genera un error (o no
existe), se restablece el comportamiento predeterminado. Este mecanismo
permite agregar traducciones de C<POD2::*> adicionales sin necesidad de
aplicar cada vez la revisin de F<Pod/Perldoc.pm>.

=back

=head1 Ms informacin sobre el proyecto

Visite L<http://github.com/zipf/perldoc-es> para obtener ms informacin.

=head1 AUTORES

Joaqun Ferrero C<< explorer at joaquinferrero.com >>
y Enrique Nell C<< blas.gordon at gmail.com >>.


=head1 VEA TAMBIN

L<POD2::PT_BR>, L<POD2::IT>, L<POD2::FR>, L<POD2::LT>, L<perl>.


=head1 ERRORES

Puede notificar errores (bugs) o solicitar funcionalidad a travs de la
direccin C<bug-pod2-esd at rt.cpan.org> o de la interfaz web en
L<http://rt.cpan.org/NoAuth/ReportBug.html?Queue=POD2-ES>.  Se le
comunicarn automticamente los cambios relacionados con los errores
notificados o la funcionalidad solicitada.


=head1 ASISTENCIA

Para ver la documentacin de este mdulo, utilice el comando perldoc.

    perldoc POD2::ES


Tambin puede buscar informacin en:

=over 4

=item * RT: sistema de seguimiento de solicitudes de CPAN

L<http://rt.cpan.org/NoAuth/Bugs.html?Dist=POD2-ES>

=item * AnnoCPAN: documentacin de CPAN anotada

L<http://annocpan.org/dist/POD2-ES>

=item * Valoraciones de CPAN

L<http://cpanratings.perl.org/d/POD2-ES>

=item * Bsqueda de mdulos de CPAN

L<http://search.cpan.org/dist/POD2-ES/>

=back


=head1 AGRADECIMIENTOS


=head1 LICENCIA Y COPYRIGHT

Copyright 2011 Equipo de Perl en Espaol.

Este programa es software libre; puede redistribuirlo o modificarlo bajo
los trminos de la licencia GNU General Public License publicada por la
Free Software Foundation, o los de la licencia Artistic.

	Consulte http://dev.perl.org/licenses/ para obtener ms
informacin.


=cut


=head1 TRADUCTORES

Joaqun Ferrero C<< explorer at joaquinferrero.com >>
Enrique Nell C<< blas.gordon at gmail.com >>
