package Firewall::Config::Element::Role;

use Moose::Role;
use Carp;

#------------------------------------------------------------------------------
# Firewall::Config::Element::Role 通用属性
#------------------------------------------------------------------------------
# 防火墙ID
has fwId => (
  is       => 'ro',
  isa      => 'Int',
  required => 0,
);

# 在同一个设备中描述一个对象的唯一性特征
has sign => (
  is      => 'ro',
  isa     => 'Str',
  lazy    => 1,
  builder => '_buildSign',
);

# 设备的配置内容
has config => (
  is       => 'ro',
  isa      => 'Str',
  required => 0,
);

#------------------------------------------------------------------------------
# 应用该模块需要具体实现 _buildSign
#------------------------------------------------------------------------------
requires '_buildSign';

#------------------------------------------------------------------------------
# 生成sign的辅助函数，用来统一记录连接符，这样修改的时候会很简单
#------------------------------------------------------------------------------
sub createSign {
  my $self = shift;

  #confess "ERROR: 用于生成 sign 的参数成员不能是 undefined" if grep { not defined } @_;
  return ( join( '<|>', @_ ) );
}

1;
