#!perl

use strict;
use warnings;

use Test::More tests => 41;
use CPAN::WWW::Testers;

use lib 't';
use CWT_Testing;

ok( my $obj = CWT_Testing::getObj(), "got object" );

# test the attributes generated by Class::Accessor::Chained::Fast

# predefined attributes
foreach my $k ( qw/
	directory
	database
	osnames
	exceptions
	tt
    logclean
/ ){
  my $label = "[$k]";
  SKIP: {
    ok( $obj->can($k), "$label can" )
	or skip "'$k' attribute missing", 3;
    isnt( $obj->$k(), undef, "$label has default" );
    is( $obj->$k(123), $obj, "$label set" ); # chained, so returns object, not value.
    is( $obj->$k, 123, "$label get" );
  };
}

# undefined attributes
foreach my $k ( qw/
	authors
	perls
    logfile
    mode
/ ){
  my $label = "[$k]";
  SKIP: {
    ok( $obj->can($k), "$label can" )
	or skip "'$k' attribute missing", 3;
    is( $obj->$k(), undef, "$label has no default" );
    is( $obj->$k(123), $obj, "$label set" ); # chained, so returns object, not value.
    is( $obj->$k, 123, "$label get" );
  };
}

# TODO -- test these:
#	$MAX_ID;

