#!/usr/bin/perl -w
# $File: //member/autrijus/PAR/myldr/Makefile.PL $ $Author: autrijus $
# $Revision: #24 $ $Change: 7151 $ $DateTime: 2003/07/27 08:31:51 $
#
# Copyright 2002, 2003 by Autrijus Tang.
# Copyright (c) 2002 Mattia Barbon.
# This package is free software; you can redistribute it and/or
# modify it under the same terms as Perl itself.

use strict;
use Config;
use File::Spec;
use ExtUtils::Embed;

xsinit(undef);

my $debug = 0;

my $perl = $^X;
my $exe = $Config{_exe};
my $o = $Config{obj_ext};
my $gccversion = $Config{gccversion};
my $pccflags = ccopts;
my $pldflags = ldopts;
my $ld = $Config{ld} || (($^O eq 'MSWin32') ? 'link.exe' : $Config{cc});
my $cc = $Config{cc};
my $dynperl = $Config{libperl} =~ /\b$Config{dlext}$/i;
my $f2c = File::Spec->catfile(".", "file2c.pl");
my $par_pl = File::Spec->catfile('..', 'script', "par.pl");
my $par_exe = File::Spec->catfile('.', "par$exe");
my $static_exe = File::Spec->catfile('.', "static$exe");
my $parl_exe = File::Spec->catfile('..', 'script', "parl$exe");
my $parldyn_exe = File::Spec->catfile('..', 'script', "parldyn$exe");
my $lib_path = join(' ', map qq(-I"$_"), map { $^O eq 'MSWin32' ? Win32::GetShortPathName($_) : $_ } @INC);

my $par = ($dynperl ? $static_exe : $par_exe);
my $all = ($dynperl ? "$parl_exe $parldyn_exe" : $parl_exe);

$perl = Win32::GetShortPathName($perl)
    if $perl =~ / / and defined &Win32::GetShortPathName;

print "Writing Makefile for the par$exe program\n";

open OUT, "> Makefile" or die "open 'Makefile': $!";

my( $out, $ccdebug, $lddebug, $warn, $rm, $mv );

if( $cc =~ m/^cl\b/ ) {
    $out = '-out:';
    $ccdebug = $debug ? '-Zi ' : '';
    $lddebug = $debug ? '-debug ' : '-release ';
    $warn = $debug ? '-W3' : '';
} elsif ($cc =~ m/^gcc\b/ or ($cc =~ m/^cc\b/ and $gccversion)) {
    $out = '--output ';
    $ccdebug = $debug ? '-g ' : '';
    $lddebug = ($debug or $^O eq 'darwin') ? '' : '-s ';
    $warn = $debug ? '-Wall -Wno-comments ' : '';
} else {
    $out = '-o ';
    $ccdebug = '';
    $lddebug = '';
    $warn = '';
}

$rm = $^O eq 'MSWin32' ? '$(PERL) -MExtUtils::Command -e rm_f' : 'rm';
$mv = $^O eq 'MSWin32' ? '$(PERL) -MExtUtils::Command -e mv' : 'mv';

my  $cflags = "$ccdebug$warn$pccflags";
my $ldflags = "$lddebug$pldflags";

if (-e $par_exe and not -s $par_exe) {
    print OUT "all ::\n\t$^X -e1\n";
}
else {
    print OUT << "EOT";
# AUTOGENERATED, DO NOT EDIT, RERUN Makefile.PL

RM=$rm
MV=$mv
PERL=$perl
LD=$ld
CC=$cc
CFLAGS=$cflags
LDFLAGS=$ldflags
NOOP=\$(PERL) -e1

OBJECTS=main$o my_par_pl$o

.c$o:
	\$(CC) -c \$(CFLAGS) \$<

all: $all

clean:
	-\$(RM) my_*.c
	-\$(RM) *$o
	-\$(RM) *.opt *.pdb perlxsi.c
	\$(MV) Makefile Makefile.old

realclean: clean
	-\$(RM) $par_exe
	-\$(RM) $parl_exe
	-\$(RM) Makefile Makefile.old

distclean: clean
	-\$(RM) $par_exe
	-\$(RM) $parl_exe
	-\$(RM) Makefile Makefile.old

$par_exe: \$(OBJECTS) my_par_pl$o
	\$(LD) \$(OBJECTS) \$(LDFLAGS) $out\$@

my_par_pl.c:
	\$(PERL) $f2c $par_pl \$@ load_me_2

$parl_exe: $par
	$par $lib_path -I../myldr/.. -I../blib/lib -B -O\$@

disttest:
	-\$(NOOP)

test:
	-\$(NOOP)

.DEFAULT:
	-\$(NOOP)

.SUFFIXES: $o

EOT

    print OUT << "EOT" if $dynperl;

$parldyn_exe: $par_exe
	$par_exe -I../myldr/.. -I../blib/lib $lib_path -B -O\$@

$static_exe: static$o my_perl$o my_par$o
	\$(LD) static$o my_perl$o my_par$o $out\$@

my_perl.c:
	\$(PERL) $f2c $Config{archlibexp}/CORE/$Config{libperl} \$@ load_me_0

my_par.c: $par_exe
	\$(PERL) $f2c $par_exe \$@ load_me_1

EOT
}

# local variables:
# mode: cperl
# end:
