#!/usr/bin/perl
# $File: //member/autrijus/Lingua-ZH-Toke/t/1-basic.t $ $Author: autrijus $
# $Revision: #1 $ $Change: 3663 $ $DateTime: 2003/01/19 19:46:28 $

use strict;
use Test;

BEGIN { plan tests => 20 }

require Lingua::ZH::Toke;
ok($Lingua::ZH::Toke::VERSION) if $Lingua::ZH::Toke::VERSION or 1;

# Create Lingua::ZH::Toke::Sentence object (->Sentence also works)
my $token = Lingua::ZH::Toke->new( 'Hob/OB/qoN' );

my $tmp = $token;

# Easy tokenization via array deferencing
ok($tmp = $tmp->[0], 'Hob',    'Tokenization - Fragment');
ok($tmp = $tmp->[2], 'ob',	    'Tokenization - Phrase');
ok($tmp = $tmp->[0], 'o',	    'Tokenization - Character');
ok($tmp = $tmp->[0], '',	    'Tokenization - Pronounciation');
ok($tmp = $tmp->[2], '',	    'Tokenization - Phonetic');

# Magic histogram via hash deferencing
ok($token->{'Hob'},    1,	    'Histogram - Fragment');
ok($token->{'N'},    1,	    'Histogram - Phrase');
ok($token->{'oN'},    undef,  'Histogram - No Phrase');
ok($token->{''},	    2,	    'Histogram - Character');
ok($token->{''},	    2,	    'Histogram - Pronounciation');
ok($token->{''},	    3,	    'Histogram - Phonetic');

my @phrases = qw( H ob O  B qo N);

# Iteration
while ($tmp = <$token>) {	# iterate each fragment
    while (<$tmp>) {		# iterate each phrase
	ok($_, shift(@phrases), 'Iteration');
    }
}

1;
