#!/bin/bash

name=`pwd|perl -e '$d=<>;$d=~s{.*/}{}g;$d=~s/2$//g;print $d'`

echo "Generating HTMLs for $name..."
rm -rf html_out
src2html.pl -e 'html_out/*' -e 'eg/*' -c -x -l -n -i '*.t' -e 'lemplate' -e 'src/js/*' -e 'tests/lib/*' -e 'tests/js/*' -e 'lib/Lemplate/Grammar.pm' -i '*.yp' -i '*.skel' -e "ebooks.sh" -i 'src/parser/yc' -t 3 . $name

echo "Generating .pdf file for $name..."
rm -rf *.pdf
ebook-convert html_out/index.html $name.pdf \
	--override-profile-size \
	--paper-size a4 \
	--pdf-default-font-size 12 \
	--pdf-mono-font-size 12 \
	--margin-left 10 --margin-right 10 \
	--margin-top 10 --margin-bottom 10 \
	--page-breaks-before='/'
exit

echo "Generating .epub file for $name..."
rm -rf *.epub
ebook-convert html_out/src/index.html $name.epub \
	--no-default-epub-cover \
	--publisher agentzh \
	--output-profile ipad3 \
	--title $name \
	--language en --authors 'The Lighttpd Team'

echo "Generating .mobi file for $name..."
rm -rf *.mobi
ebook-convert html_out/src/index.html $name.mobi \
	--output-profile kindle_dx --no-inline-toc \
	--publisher agentzh \
	--title $name \
	--language en --authors 'The Lighttpd Team'

#cp -uv *.mobi ~/mobi/

